PAMD(8)                    DACS Web Services Manual                    PAMD(8)



[1mNAME[0m
       pamd - PAM transaction server

[1mSYNOPSIS[0m
       [1mpamd [22m[[34m[1mdacsoptions[0m[1m[22m[1]] [[1m-daemon[22m] [[1m-fork[22m] [[1m-h [4m[22mhostname[24m] [[1m-http[22m] [[1m-inetd[22m]
            [[1m-nofork[22m]
            [[1m-p [4m[22mportnum[24m] [[1m-policy [4m[22mname[24m] [[1m-secure[22m] [[1m-unsecure[22m]

[1mDESCRIPTION[0m
       This program is part of the [1mDACS [22msuite.

       The [1mpamd [22mserver is required by the [34m[1mlocal_pam_authenticate[0m[1m[22m[2]
       authentication module. It acts as a proxy for [1mlocal_pam_authenticate[22m,
       calling PAM functions on its behalf. The [1mpamd [22mserver may be started
       from [34m[1minetd(8)[0m[1m[22m[3] or from the command line, but it must be running for
       [1mDACS [22mto perform PAM-based authentication.

       Each [1mpamd [22mprocess is involved in an arbitrarily long "conversation" or
       "transaction" with one or more executions of [1mlocal_pam_authenticate[22m.
       For instance, [1mpamd's [22minitial response to [1mlocal_pam_authenticate [22mmight
       be that it requires an account name; upon receiving the account name
       from [1mlocal_pam_authenticate[22m, [1mpamd's [22mresponse might be that it requires
       the password for the account; and upon receiving the password, [1mpamd[0m
       would indicate success or failure, depending on whether an acceptable
       username/password pair was received. The eventual outcome of a
       transaction is that authentication succeeds, fails, or could not be
       completed because an error occurs.

       [1mpamd [22mmust be run on the host where [34m[1mpam(3)[0m[1m[22m[4] processing is being
       performed, which is not necessarily the same host where
       [1mlocal_pam_authenticate [22mis executed.

           [1mSecurity[0m
           +o   [1mpamd [22mwill usually be run as root so that it can access the
               files it needs to perform authentication.

           +o   [1mpamd [22mis not a [1mDACS [22mweb service and is not protected by [1mDACS[22m.

           +o   The protocol between [1mpamd [22mand its client may include sensitive
               material, such as passwords. If both programs are run on the
               same host, this is probably not an issue. If there is any
               possibility of eavesdropping etc. by an attacker, however,
               communication should be secured through an SSL wrapper.

           +o   [1mpamd [22mshould probably not be run on a world-accessible server,
               since it would offer a way for attackers to try to guess
               passwords.

       The operating system's PAM policy file is consulted - see
       [34m[1mpam.conf(5)[0m[1m[22m[5]. The default PAM service name is "dacs" (see
       [34m[1mpam_start(3)[0m[1m[22m[6]), which may be used by PAM to locate the appropriate
       policy file. A different policy name can be specified using the [1m-policy[0m
       flag.

       The prompts that passed from PAM to [1mpamd [22mto [1mlocal_pam_authenticate [22mto
       [1mdacs_authenticate [22m(or [1mdacsauth[22m) are simply displayed to the user. The
       user must understand what the prompts mean (e.g., that "Login:" means
       to provide a Unix account name).

       [1mpamd [22mcan be used by non-[1mDACS [22mapplications. The protocol, though simple,
       is not yet documented other than within the source code. A program
       called [1mpamd-client [22mis available for testing and debugging [1mpamd[22m; it is
       built when PAM support is required, but is neither installed nor
       documented (see the source code for basic instructions).

[1mOPTIONS[0m
       In addition to the standard [34m[4mdacsoptions[0m[4m[24m[1], [1mpamd [22mrecognizes these
       command line flags:

       [1m-daemon[0m
           Wait for a connection, then service the request. Mutually exclusive
           with [1m-inetd[22m.

       [1m-fork[0m
           Create a new process to service each request. It implies the
           [1m-daemon [22mflag.

       [1m-h [4m[22mhostname[0m
           If [1mpamd [22mis running on a host with multiple IP addresses, this
           specifies the hostname (or IP address) to listen to for incoming
           requests. If not provided, the [34m[1mPAMD_HOST[0m[1m[22m[7] directive will be
           consulted; if unavailable, [34m[1mgethostname(3)[0m[1m[22m[8] will be used.

       [1m-http[0m
           This flag is reserved for future use.

       [1m-inetd[0m
           The server assumes it has been started by [34m[1minetd(8)[0m[1m[22m[3] and therefore
           does not wait for a connection. It exits after servicing the
           request. This is the default behaviour and preferred way to
           configure [1mpamd[22m. This mode of operation assumes that an entry has
           been added to [34m[1minetd.conf(5)[0m[1m[22m[9] that looks much like this:

               dacs-pamd stream tcp nowait root /usr/local/dacs/sbin/pamd pamd -uj EXAMPLE -inetd


       [1m-nofork[0m
           This flag, which implies the [1m-daemon[22m, causes the [1mpamd [22mserver to
           exit after servicing one request (which is useful when debugging).
           This is the default behaviour of [1m-daemon [22mmode.

       [1m-p [4m[22mportnum[0m
           This specifies the port number to listen to, overriding any
           [34m[1mPAMD_PORT[0m[1m[22m[10] directive in effect. It can also be a service name.
           Any otherwise unassigned port number on the system from 49152
           through 65535 (i.e., one in the dynamic and/or private range) ought
           to be acceptable.

           If neither this flag nor a PAMD_PORT directive is provided, the
           program will try to find the port associated with the dacs-pamd
           service name in [34m[1mservices(5)[0m[1m[22m[11]. For example:

               dacs-pamd       17000/tcp  # DACS pamd


       [1m-policy [4m[22mname[0m
           Use [4mname[24m as the PAM policy name instead of the default.

       [1m-secure[0m
           The client must supply valid [1mDACS [22madministrative credentials
           encapsulated within a [1mDACS [22mcookie. This is the default.

       [1m-unsecure[0m
           Administrative credentials are not required, but if they are
           provided they must be valid. This should probably be used only when
           testing or if client identification is not an issue or has been
           addressed in some other way.

           [1mNote[0m
           When the [1m-secure [22mflag is in effect, [1mpamd [22mmust be associated with a
           jurisdiction. Therefore, the [1mDACS [22mconfiguration files are read and
           the jurisdiction must be specified on the command line (e.g., using
           the [1m-uj [22mflag).

[1mEXAMPLE[0m
       For testing purposes, or to better understand how [1mpamd [22mworks, you can
       run it manually and interact with it using [34m[1mtelnet(1)[0m[1m[22m[12], for example,
       which takes the place of [1mlocal_pam_authenticate[22m. You must have PAM
       authentication configured on the host where you run [1mpamd [22mand you will
       probably need to run it as root. This is best done using two windows;
       start [1mpamd [22min the first window and then [1mtelnet [22mto it from the second
       window.

       An interaction to perform username/password authentication will look
       something like the following (substitute your jurisdiction's name for
       myjur, your jurisdiction's domain name or IP address for
       myjur.example.com, and use a username and password pair that is
       recognized on your system). The first [1mtelnet [22mconnection receives a
       prompt for a username (labeled "Login:" and assigned the variable name
       [4mAUTH_PROMPT_VAR1[24m) from [1mpamd[22m, a transaction identifier ([4mTRANSID[24m)
       "10.0.0.124:56372:66664:53983facb39881b2" for this session, and port
       number to use for subsequent operations belonging to this transaction
       (62475). The second [1mtelnet [22mconnection provides the [4mTRANSID[24m and username
       (AUTH_PROMPT_VAR1="auggie"), and receives a prompt for a password
       ("Password:", assigned the variable name [4mAUTH_PROMPT_VAR2[24m). The third
       [1mtelnet [22mconnection provides the [4mTRANSID[24m and the password
       (AUTH_PROMPT_VAR2="doggy"), and receives the result of authentication
       ("Success").

           # ./pamd -uj myjur -ll debug -daemon -unsecure -nofork
           pamd[info]: Site config file is "/usr/local/dacs/federations/site.conf"
           pamd[info]: Config file is "/usr/local/dacs/federations/dacs.conf"
           pamd[info]: This is jurisdiction DSS::myjur
           pamd[info]: Secure mode is off
           pamd[debug]: Waiting for initial input block...
           pamd[debug]: No username
           pamd[debug]: Calling pam_authenticate
           pamd[debug]: pamd_conv: reply to port 62475
           pamd[debug]: TRANSID is "10.0.0.124:56372:66664:53983facb39881b2"
           pamd[debug]:   type="text"
           pamd[debug]:   label="Login:"
           pamd[debug]:   varname="AUTH_PROMPT_VAR1"
           pamd[debug]: pamd_conv: waiting 60 seconds for reply
           pamd[debug]: pamd_conv: received connection
           pamd[debug]: Reading reply...
           pamd[debug]: pamd_conv: reply to port 62475
           pamd[debug]: TRANSID is "10.0.0.124:62475:66695:fc855a7d68e8b1eb"
           pamd[debug]:   type="password"
           pamd[debug]:   label="Password:"
           pamd[debug]:   varname="AUTH_PROMPT_VAR2"
           pamd[debug]: pamd_conv: waiting 60 seconds for reply
           pamd[debug]: pamd_conv: received connection
           pamd[debug]: Reading reply...
           pamd[debug]: Success
           pamd[debug]: result="ok"
           pamd[debug]: username="auggie"



           % telnet myjur.example.com 17000
           Trying 10.0.0.124...
           Connected to bsd6.dss.bc.ca.
           Escape character is '^]'.

           Connection closed by foreign host.
           % telnet myjur.example.com 62475
           Trying 10.0.0.124...
           Connected to bsd6.dss.bc.ca.
           Escape character is '^]'.
           TRANSID="10.0.0.124:62475:66695:fc855a7d68e8b1eb"
           AUTH_PROMPT_VAR1="auggie"

           Connection closed by foreign host.
           % telnet myjur.example.com 62475
           Trying 10.0.0.124...
           Connected to bsd6.dss.bc.ca.
           Escape character is '^]'.
           TRANSID="10.0.0.124:62475:66695:fc855a7d68e8b1eb"
           AUTH_PROMPT_VAR2="doggy"

           result="ok"
           username="auggie"
           Connection closed by foreign host.


[1mDIAGNOSTICS[0m
       The program exits 0 if everything was fine, 1 if an error occurred.

[1mBUGS[0m
       The [1m-daemon [22mflag should cause the process to detach and put itself in
       the background unless overridden by another flag; at present it must be
       started in the background "manually".

       The [1m-http [22mflag, which would allow a [1mpamd [22msession to be started with a
       web service request, is not implemented.

[1mSEE ALSO[0m
       [34m[1mdacs_authenticate(8)[0m[1m[22m[13], [34m[1mdacsauth(1)[0m[1m[22m[14], [34m[1mpam(3)[0m[1m[22m[15], [34m[1mX/Open Single[0m
       [1m[34mSign-On Service (XSSO) preliminary specification[0m[1m[22m[16]

[1mAUTHOR[0m
       Distributed Systems Software ([34m[1mwww.dss.ca[0m[1m[22m[17])

[1mCOPYING[0m
       Copyright (C) 2003-2012 Distributed Systems Software. See the
       [34m[1mLICENSE[0m[1m[22m[18] file that accompanies the distribution for licensing
       information.

[1mNOTES[0m
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. local_pam_authenticate
           http://dacs.dss.ca/man/dacs_authenticate.8.html#local_pam_authenticate

        3. inetd(8)
           http://www.freebsd.org/cgi/man.cgi?query=inetd&apropos=0&sektion=8&manpath=FreeBSD+9.0-RELEASE&format=html

        4. pam(3)
           http://www.freebsd.org/cgi/man.cgi?query=pam&apropos=0&sektion=0&manpath=FreeBSD+9.0-RELEASE&format=html

        5. pam.conf(5)
           http://www.freebsd.org/cgi/man.cgi?query=pam.conf&apropos=0&sektion=5&manpath=FreeBSD+9.0-RELEASE&format=html

        6. pam_start(3)
           http://www.freebsd.org/cgi/man.cgi?query=pam_start&apropos=0&sektion=3&manpath=FreeBSD+9.0-RELEASE&format=html

        7. PAMD_HOST
           http://dacs.dss.ca/man/dacs.conf.5.html#PAMD_HOST

        8. gethostname(3)
           http://www.freebsd.org/cgi/man.cgi?query=gethostname&apropos=0&sektion=3&manpath=FreeBSD+9.0-RELEASE&format=html

        9. inetd.conf(5)
           http://www.freebsd.org/cgi/man.cgi?query=inetd.conf&apropos=0&sektion=5&manpath=FreeBSD+9.0-RELEASE&format=html

       10. PAMD_PORT
           http://dacs.dss.ca/man/dacs.conf.5.html#PAMD_PORT

       11. services(5)
           http://www.freebsd.org/cgi/man.cgi?query=services&apropos=0&sektion=5&manpath=FreeBSD+9.0-RELEASE&format=html

       12. telnet(1)
           http://www.freebsd.org/cgi/man.cgi?query=telnet&apropos=0&sektion=1&manpath=FreeBSD+9.0-RELEASE&format=html

       13. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html

       14. dacsauth(1)
           http://dacs.dss.ca/man/dacsauth.1.html

       15. pam(3)
           http://www.freebsd.org/cgi/man.cgi?query=pam&apropos=0&sektion=3&manpath=FreeBSD+9.0-RELEASE&format=html

       16. X/Open Single Sign-On Service (XSSO) preliminary specification
           http://www.opengroup.org/pubs/catalog/p702.htm

       17. www.dss.ca
           http://www.dss.ca

       18. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27b                      03/19/2012                           PAMD(8)
