DACS.SERVICES(8)           DACS Web Services Manual           DACS.SERVICES(8)



[1mNAME[0m
       dacs.services - [1mDACS [22mweb services

[1mSYNOPSIS[0m
       [4mdacswebservice[24m [[34m[1mdacsoptions[0m[1m[22m[1]]

[1mDESCRIPTION[0m
       These web services are part of the [1mDACS [22msuite.

       The following is a list of [1mDACS [22mweb services with a brief description
       of each. General aspects of [1mDACS [22mand its web services are discussed in
       [34m[1mdacs(1)[0m[1m[22m[2]. Individual web services are discussed in more detail
       elsewhere. By default, these CGI programs are installed in the dacs
       subdirectory of the [1mApache [22mcgi-bin directory.

       By convention, [1mDACS [22mweb service names use underscores as word
       separators. Some web services have command counterparts; their names
       omit the underscores.

       +o

               [1mdacs_admin[0m
               A low-level administration tool for [1mDACS[22m.
               [[34m[1mdacs_admin(8)[0m[1m[22m[3]]


       +o

               [1mdacs_auth_agent[0m
               Authenticate by delegating responsibility to a trusted identity.
               [[34m[1mdacs_auth_agent(8)[0m[1m[22m[4]]


       +o

               [1mdacs_auth_transfer[0m
               Transfer credentials between federations.
               [[34m[1mdacs_auth_transfer(8)[0m[1m[22m[5]]


       +o

               [1mdacs_authenticate[0m
               The [1mDACS [22mauthentication service.
               [[34m[1mdacs_authenticate(8)[0m[1m[22m[6]]


       +o

               [1mdacs_conf[0m
               Process and display [1mDACS [22mconfiguration files.
               [[34m[1mdacs_conf(8)[0m[1m[22m[7]]


       +o

               [1mdacs_current_credentials[0m
               Display elements of each set of credentials sent with the request.
               [[34m[1mdacs_current_credentials(8)[0m[1m[22m[8]]


       +o

               [1mdacs_group[0m
               A [1mDACS [22mgroup administration tool.
               [[34m[1mdacs.groups(5)[0m[1m[22m[9]]


       +o

               [1mdacs_list_jurisdictions[0m
               Display information about all jurisdictions in a federation.
               [[34m[1mdacs_list_jurisdictions(8)[0m[1m[22m[10]]


       +o

               [1mdacs_notices[0m
               Notice presentation and acknowledgement handler.
               [[34m[1mdacs_notices(8)[0m[1m[22m[11]]


       +o

               [1mdacs_passwd[0m
               Administration tool for passwords used by [1mlocal_passwd_authenticate[22m.
               [[34m[1mdacs_passwd(8)[0m[1m[22m[12]]


       +o

               [1mdacs_signout[0m
               Typically called from a browser, this web services causes one or more
               cookies (each representing a [1mDACS [22midentity) to be deleted.
               Cookies are automatically deleted when a browser terminates, but it
               is sometimes useful to explicitly logoff.
               [[34m[1mdacs_signout(8)[0m[1m[22m[13]]


       +o

               [1mdacs_version[0m
               Display version information.
               [[34m[1mdacsversion(8)[0m[1m[22m[14]]


       +o

               [1mdacs_vfs[0m
               Manage items in the [1mDACS [22mvirtual filestore.
               [[34m[1mdacs_vfs(8)[0m[1m[22m[15]]


       +o

               [1mlocal_*_authenticate[0m
               Authentication modules used by [34m[1mdacs_authenticate(8)[0m[1m[22m[6].
               Each one implements a particular authentication method and optionally
               returns role information.


       +o

               [1mlocal_*_roles[0m
               Roles modules used by [34m[1mdacs_authenticate(8)[0m[1m[22m[6].


   [1mStandard CGI Arguments for DACS Web Services[0m
       The following set of CGI arguments are recognized by most [1mDACS [22mweb
       services. When the document for a [1mDACS [22mweb service says that it accepts
       "the standard CGI arguments", it is referring to the following
       arguments; not all of these arguments are necessarily meaningful to all
       web services, however.

       In general, duplicate CGI argument names are not allowed; i.e., you
       cannot pass an argument named [4mDACS_JURISDICTION[24m more than once when
       calling a [1mDACS [22mweb service, even if each occurrence of the argument has
       the same value.

       [4mDACS_JURISDICTION[0m
           This argument is required by most web services. It specifies the
           name of the jurisdiction to which the request is being sent. Web
           services will verify that the jurisdiction that receives the
           request is the same as the intended recipient.

       [4mDACS_VERSION[0m
           If this argument is present, it specifies the major [1mDACS [22mversion
           number (e.g., 1.4) expected by the client. The service request will
           fail if the [1mDACS [22msoftware does not support this version number. If
           not provided, no compatibility checks are performed.

       FILE
           Reserved for future use for file uploading. Requests content type
           application/x-dacs-credentials.

       [4mFORMAT[0m
           This optional argument requests a particular output format. The
           default value varies, but it is usually HTML. Not all formats are
           supported by every web service; refer to the manual page for
           details. The following values are recognized:

           HTML
               Requests content type text/html;

           JSON
               Requests content type application/json ([4mJavaScript[24m [4mObject[0m
               [4mNotation[24m, see [34m[1mwww.json.org[0m[1m[22m[16] and [34m[1mRFC 4627[0m[1m[22m[17]);

           PHP
               Used by the [34m[1mdacs_list_jurisdictions(8)[0m[1m[22m[10] web service when its
               output is to processed by PHP;

           PLAIN
               Requests content type text/plain;

           TEXT
               Like PLAIN except that no content type is specified;

           XML
               Requests content type text/xml. If the DTD_BASE_URL directive
               is configured, a DOCTYPE element with the keyword SYSTEM
               followed by a value derived from DTD_BASE_URL is emitted; e.g.,



                   <!DOCTYPE foo SYSTEM "http://fedroot.com/dacs/dtd-xsd/foo.dtd">

               If DTD_BASE_URL is not configured, an internal DTD is emitted.
               A default xmlns attribute is emitted in both cases;

           XMLDTD
               Requests content type text/xml This emits an internal DTD and
               default xmlns attribute;

           XMLSCHEMA
               Requests content type text/xml. If the XSD_BASE_URL directive
               is configured, xmlns:xsi and xsi:schemaLocation attributes are
               emitted, the former having a compile-time value (e.g.,
               "http://www.w3.org/2001/XMLSchema-instance") and the latter
               being a pair, the first having the same value as the value of
               the xmlns attribute and the second having a value derived from
               XSD_BASE_URL; e.g.,



                   <foo xmlns="http://fedroot.com/dacs/v1.4"
                       xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                       xsi:schemaLocation="http://fedroot.com/dacs/v1.4
                       http://amd.dss.bc.ca/dacs/dtd-xsd/foo.xsd">


               The default xmlns attribute is also emitted. If XSD_BASE_URL is
               not configured, only the default xmlns attribute is emitted;
               and

           XMLSIMPLE
               Requests content type text/xml Neither a DTD (no DOCTYPE) nor a
               default xmlns attribute is emitted.

           Also see the [34m[4m-format[0m[4m[24m[18] command line flag (one of the
           [34m[4mdacsoptions[0m[4m[24m[1]).

[1mDIAGNOSTICS[0m
       Programs usually exit 0 if everything was fine, 1 if an error occurred.

[1mAUTHOR[0m
       Distributed Systems Software ([34m[1mwww.dss.ca[0m[1m[22m[19])

[1mCOPYING[0m
       Copyright (C) 2003-2012 Distributed Systems Software. See the
       [34m[1mLICENSE[0m[1m[22m[20] file that accompanies the distribution for licensing
       information.

[1mNOTES[0m
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. dacs(1)
           http://dacs.dss.ca/man/dacs.1.html

        3. dacs_admin(8)
           http://dacs.dss.ca/man/dacs_admin.8.html

        4. dacs_auth_agent(8)
           http://dacs.dss.ca/man/dacs_auth_agent.8.html

        5. dacs_auth_transfer(8)
           http://dacs.dss.ca/man/dacs_auth_transfer.8.html

        6. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html

        7. dacs_conf(8)
           http://dacs.dss.ca/man/dacs_conf.8.html

        8. dacs_current_credentials(8)
           http://dacs.dss.ca/man/dacs_current_credentials.8.html

        9. dacs.groups(5)
           http://dacs.dss.ca/man/dacs.groups.5.html

       10. dacs_list_jurisdictions(8)
           http://dacs.dss.ca/man/dacs_list_jurisdictions.8.html

       11. dacs_notices(8)
           http://dacs.dss.ca/man/dacs_notices.8.html

       12. dacs_passwd(8)
           http://dacs.dss.ca/man/dacs_passwd.8.html

       13. dacs_signout(8)
           http://dacs.dss.ca/man/dacs_signout.8.html

       14. dacsversion(8)
           http://dacs.dss.ca/man/dacs_version.8.html

       15. dacs_vfs(8)
           http://dacs.dss.ca/man/dacs_vfs.8.html

       16. www.json.org
           http://www.json.org

       17. RFC 4627
           http://www.rfc-editor.org/rfc/rfc4627.txt

       18. [4m-format[0m
           http://dacs.dss.ca/man/dacs.1.html#format-arg

       19. www.dss.ca
           http://www.dss.ca

       20. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27b                      03/19/2012                  DACS.SERVICES(8)
