<?php
/**
 * Will contain a fortune module
 *
 * daCode http://www.dacode.org/
 * src/phplib/fortunes.php3
 * $Id: fortunes.php3,v 1.13.2.3 2002/10/22 21:39:35 ruffy Exp $
 *
 * Will contain a fortune module
 *
 *@author yog <yogi@nicolas.as> for the code
 *
 * Depends: Config
 */

Class Fortunes {
	/**
	 * Config instance
	 *@var object Config
	 */
	var $config;


	/**
	 * Class constructor
	 */
	Function Fortunes() {
	}

	/**
	 * Gets a random fortune
	 *@return string the raw fortune
	 *@access public
	 */
	Function get_random() {
		global $config;

		// Exit if file doesn't exist
		if (empty($config->fortunefile) || !file_exists($config->fortunefile)) {
			return;
		}

		// Get size for random number
		$size = filesize($config->fortunefile);
		if ($size == false) {
			return;
		}
		// Open file read only
		$file = fopen($config->fortunefile, "rb");
		if ($file == false) {
			return;
		}
		// Generate random in $rand between 0 to size of file
		mt_srand((double)microtime()*1000000);
		$rand = mt_rand(0,$size);
		// Go forward in the file
		fseek($file,$rand);
		$pointeur = $rand + 1;
		$comp = fgetc($file);
		while ($comp && ($comp != "%")) {
			$pointeur++;
			$comp = fgetc($file);
			if ($pointeur == $size - 1) {
				$pointeur = -1;
				rewind($file);
				break;
			}
		}

		//  Skip % and newline
		$pos1 = $pointeur + 2;
		$pointeur++;
		$comp = fgetc($file);
		while ($comp && ($comp != "%")) {
			$pointeur++;
			$comp = fgetc($file);
			//   Just in case trailing % is missing
			if ($pointeur == $size - 1) {
				break;
			}
		}
		$pos2 = $pointeur;
		$length = $pos2 - $pos1;
		fseek($file,$pos1 - 1);
		if ($length < 0) {
			return;
		}

		$out=fread($file,$length);
		fclose($file);

		$out=htmlentities($out);
		$out=nl2br($out);

		return $out;
	}

}

?>
