/*
 * The Cryptonit security software suite is developped by IDEALX
 * Cryptonit Team (http://IDEALX.org/ and http://cryptonit.org).
 *
 * Copyright 2003-2006 IDEALX
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301, USA. 
 *
 * In addition, as two special exceptions:
 *
 * 1) IDEALX S.A.S gives permission to:
 *  * link the code of portions of his program with the OpenSSL library under
 *    certain conditions described in each source file
 *  * distribute linked combinations including the two, with respect to the
 *    OpenSSL license and with the GPL
 *
 * You must obey the GNU General Public License in all respects for all of the
 * code used other than OpenSSL. If you modify file(s) with this exception,
 * you may extend this exception to your version of the file(s), but you are
 * not obligated to do so. If you do not wish to do so, delete this exception
 * statement from your version, in all files (this very one along with all
 * source files).

 * 2) IDEALX S.A.S acknowledges that portions of his sourcecode uses (by the
 * way of headers inclusion) some work published by 'RSA Security Inc.'. Those
 * portions are "derived from the RSA Security Inc. PKCS #11Cryptographic
 * Token Interface (Cryptoki)" as described in each individual source file.
 */

#ifndef _MAIN_WINDOW_HH_
#define _MAIN_WINDOW_HH_

#include <wx/wx.h>
#include <wx/toolbar.h>
#include <wx/bmpbuttn.h>
#include <wx/splitter.h>
#include <wx/checkbox.h>
#include <wx/filedlg.h>

#include "SelectedFilesList.hh"
#include "../User.hh"
#include "../KeyStore.hh"
#include "../SoftKeyStore.hh"
#include "../P11KeyStore.hh"

void verifCallback(std::string filename, std::string m, void* statusDlg, bool ok);

class MainWindow : public wxFrame{

public :
  
  MainWindow(wxWindow *parent, wxWindowID id,
	     const wxString &title,
	     Cryptonit::User* usr,
	     const wxPoint& pos = wxDefaultPosition,
	     const wxSize& size = wxDefaultSize,
	     long style = wxDEFAULT_FRAME_STYLE
	     );

    ~MainWindow();
    
    void createToolBar();
    void createStatusBar();
    void createDropList();
    void createActionPanel();
 
    void onFile(wxCommandEvent& WXUNUSED(event));
    void onEncrypt(wxCommandEvent& WXUNUSED(event));
    void onDecrypt(wxCommandEvent& WXUNUSED(event));
    void onSign(wxCommandEvent& WXUNUSED(event));
  void onSelf(wxCommandEvent& WXUNUSED(event));
  void onEmpty(wxCommandEvent& WXUNUSED(event));
    void onUsers(wxCommandEvent& WXUNUSED(event));
    void onVerify(wxCommandEvent& WXUNUSED(event));

    void addressBook(wxCommandEvent& WXUNUSED(event));
    void config(wxCommandEvent& WXUNUSED(event));
    void exit(wxCommandEvent& WXUNUSED(event));
    void exit2(wxCloseEvent& WXUNUSED(event));
    void about(wxCommandEvent& WXUNUSED(event));
    int decryptFiles(bool remove, bool leave, wxString path);
    int encryptFiles(bool remove, bool leave, wxString path, 
		     std::vector<wxString>& certificates_files);
    //    int signFiles(bool detached=FALSE, bool encrypted=FALSE);
    int signFiles(bool detached, bool encrypted, bool leave, bool remove , const wxString &path,std::vector<wxString>& certificates_files);
    int verifyFiles(const bool leave, const bool remove,const wxString &path, const bool extract);

    void enableButtons(const bool enable=true );
    
    /* init available keystores */
    void initKeyStores();
    
    void enableAddressBookBtn(bool enable);

private:  
    wxWindow *p;
#ifdef __WXMSW__
    wxToolBarBase*mainToolBar;
#else
    wxToolBar *mainToolBar;
#endif  
  SelectedFilesList *dropList;
    wxBoxSizer *mainSizer;
    wxBoxSizer *sizer;

#ifdef __WXMAC__
   wxMenuBar  *menuBar;
   wxMenu *helpMenu;
#endif




        
    Cryptonit::User *user;

    std::vector<Cryptonit::KeyStore *> keyStores;
    Cryptonit::SoftKeyStore *softKeyStore; //openssl keystore, used in propertieframe
    Cryptonit::P11KeyStore *pks ;

  DECLARE_EVENT_TABLE();  
};
// wx widget ID enum
  enum
    { 
      MW_TOOLBAR_ID=1000,
      MW_FILE_BTN_ID,
      MW_DIR_BTN_ID,
      MW_CONFIG_BTN_ID,
      MW_DROP_LIST_ID,

      MW_ADDRESSBOOK_BTN_ID,
      MW_ENCRYPT_BTN_ID,
      MW_DECRYPT_BTN_ID,
      MW_SIGN_BTN_ID,
      MW_VERIFY_BTN_ID,
      MW_SELF_BTN_ID,
      MW_EMPTY_BTN_ID,
      MW_EXIT_BTN_ID,
      MW_ABOUT_BTN_ID,

/*      MW_USER_MENU_PKCS12,
      MW_USER_MENU_PKCS10,
      MW_USER_MENU_ADD_CERT,*/

      MW_HELP_MENU_ABOUT,
      MW_HELP_MENU_HELP
    };

#endif

