/*
 * The Cryptonit security software suite is developped by IDEALX
 * Cryptonit Team (http://IDEALX.org/ and http://cryptonit.org).
 *
 * Copyright ? 2004 IDEALX
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301, USA. 
 *
 * In addition, as two special exceptions:
 *
 * 1) IDEALX S.A.S gives permission to:
 *  * link the code of portions of his program with the OpenSSL library under
 *    certain conditions described in each source file
 *  * distribute linked combinations including the two, with respect to the
 *    OpenSSL license and with the GPL
 *
 * You must obey the GNU General Public License in all respects for all of the
 * code used other than OpenSSL. If you modify file(s) with this exception,
 * you may extend this exception to your version of the file(s), but you are
 * not obligated to do so. If you do not wish to do so, delete this exception
 * statement from your version, in all files (this very one along with all
 * source files).

 * 2) IDEALX S.A.S acknowledges that portions of his sourcecode uses (by the
 * way of headers inclusion) some work published by 'RSA Security Inc.'. Those
 * portions are "derived from the RSA Security Inc. PKCS #11Cryptographic
 * Token Interface (Cryptoki)" as described in each individual source file.
 */
#ifndef _P11_DEVICES_HH_
#define _P11_DEVICES_HH_

#include <vector>

#include "P11Device.hh"

namespace Cryptonit
{
    class P11Devices
    {
    private:

	/** Detected PKCS#11 devices */
	std::vector<P11Device> devices;

    public:

	P11Devices();
	~P11Devices();

	/** Try to autodetect *known* PKCS#11 devices.
	 *  Only USB devices are supported at this time.
	 *  If called multiple times, only new devices are
	 *  added into the list.
	 *  Return the total of detected devices, or 0< in
	 *  case of subsystem detection error.
	 *
	 *  FIXME: If an error occured, the device list consistency
	 *         is not guaranted.
	 */
	int autodetect();

	/** Return a driver list of detected PKCS#11 devices.
	 *  For MS Windows the root is not prepend you must add
	 *  "C:\Windows\", you can use wxGetOSDirectory().
	 *  You must call autodetect() before.
	 */
	std::vector<std::string> getDetectedDriverList();

	/** Return a vector with product of each detected devices
	 */
	std::vector<std::string> getDevicesProductName();

    };
}

#endif
