/*
 * The Cryptonit security software suite is developped by IDEALX
 * Cryptonit Team (http://IDEALX.org/ and http://cryptonit.org).
 *
 * Copyright 2003-2006 IDEALX
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301, USA. 
 *
 * In addition, as two special exceptions:
 *
 * 1) IDEALX S.A.S gives permission to:
 *  * link the code of portions of his program with the OpenSSL library under
 *    certain conditions described in each source file
 *  * distribute linked combinations including the two, with respect to the
 *    OpenSSL license and with the GPL
 *
 * You must obey the GNU General Public License in all respects for all of the
 * code used other than OpenSSL. If you modify file(s) with this exception,
 * you may extend this exception to your version of the file(s), but you are
 * not obligated to do so. If you do not wish to do so, delete this exception
 * statement from your version, in all files (this very one along with all
 * source files).

 * 2) IDEALX S.A.S acknowledges that portions of his sourcecode uses (by the
 * way of headers inclusion) some work published by 'RSA Security Inc.'. Those
 * portions are "derived from the RSA Security Inc. PKCS #11Cryptographic
 * Token Interface (Cryptoki)" as described in each individual source file.
 */

#ifndef _CertificateStore_hh_
#define _CertificateStore_hh_


#include "Certificate.hh"


#define CERTIFICATE_STORE_DEFAULT_PATH "Certificates"
#define CERTIFICATE_DEFAULT_EXTENSION "der"


namespace Cryptonit
{

    /**
     * CertificateStore
     * This class is an agregate of Certificate class.
     */
    class CertificateStore
    {
    private :

	/** The current path pointing to all certificate files */
	std::string certificatePath;

	/** A vector with all certificates in the current store */
	std::vector<Certificate> certificates;

    public:
	
	/** Create an empty Certificate Store
	 */
	CertificateStore();


	/** Create a new Certificate Store with all certificates
	 *  conatined into the given path.
	 *
	 *  @param path
	 */
	CertificateStore( const std::string path );


	/** Copy constructor.
	 *
	 *  @param src the source certificate store
	 */
	CertificateStore( const CertificateStore &src );


	/** Destructor.
	 */
	~CertificateStore();


	/** Add a certificate into the certificate store.
	 *
	 *  @param certificate
	 *  @param write flag telling if the certificate will be immediatly
	 *         writed on disk.
	 *
	 *  @return true if the operation succeed.
	 */
	bool add( Certificate &certificate, const bool write = true );

	
	/** Remove a certificate from the store. If it is on disk, it will
	 *  be deleted.
	 *
	 *  @param index the certificate's index into the certificate vector
	 *         (getCertificates).
	 *
	 *  @return true if the operation succeed.
	 */
	bool remove( const size_t index );


	/** Return a Certificate vector with all certificates contained into
	 *  the current store.
	 *
	 *  @return a copy of all certificates from the store.
	 */
	const std::vector<Certificate> getCertificates() const;


	/** Return the total number of certificates stored in the current store.
	 *
	 *  @return the number of certificates
	 */
	size_t getNbCertificates() const;


	/** Return the current certificate store path.
	 *
	 *  @return a copy of the current certificate store's path.
	 */
	std::string getCertificatePath() const;

    };
}

#endif
