#include "backend"
#include "profiler/profiler"
#include "ipstore/ipstore"

bool Backend::available() const {
    PROFILE("Backend::available");

    /*
    debugmsg("Back end " << description() << ": "
	     << livestr() << ", " << upstr() << ", "
	     << connections() << " connections, "
	     << IPStore::anticipated(balancerindex()) << " anticipated, "
	     << maxconn() << " max\n");
    */
    if (!maxconn())
	return (islive && isup);
    return (islive &&
	    isup &&
	    (connections() + IPStore::anticipated(balancerindex()) <
	     maxconn()));
}
