#include "checkupthread"

void Checkupthread::execute() {

    Threadlist::desc("Checkup thread");
    
    while (1) {
	if (config.checkupsec()) {
	    msg("Running checkup thread\n");
	    for (unsigned i = 0; i < balancer.nbackends(); i++) {
		Backend target(balancer.backend(i).backenddef());
		try {
		    target.check();
		    if (target.live()) {
			balancer.backend(i).live(true);
			msg("Checkup call: backend " << target.description()
			    << " is alive\n");
		    } else {
			balancer.backend(i).live(false);
			balancer.backend(i).markconnecterror();
			msg("Checkup call: backend " << target.description()
			    << " is unavailable\n");
			if (config.onfail().length()) {
			    ostringstream o;
			    o << config.onfail() << " 0.0.0.0 "
			      << target.description() << ' '
			      << balancer.backend(i).connections();
			    sysrun(o.str());
			}
		    }
		} catch (Error &e) {
		    debugmsg("Error in checkup thread: " << e.what() <<
			     '\n');
		} catch (...) {
		    debugmsg("Error in checkup thread\n");
		}
	    }
	    sleep(config.checkupsec());
	} else
	    sleep(30);
    }
}
	
