/*
 *  Copyright (C) 2002,2003,2004  Mattia Dongili<dongili@supereva.it>
 *                                George Staikos <staikos@0wned.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include "string_list.h"


int string_list_free_sublist(struct string_list *list, struct string_node *start) {
  int ret = 0;
  struct string_node *prev = 0L;
  
  /* return if !start */
  if (!start)
    return 0;
  
  /* terminate the list just before the subtree to remove */
  if (start->prev) {  /* unless the starting node is the first */
    list->last = start->prev;
    list->last->next = 0L;
  }

  /* free subtree */
  while(start) {
    prev = start;
    start = start->next;
    free(prev);
    ret++;
  }
  return ret;
}

struct string_list *string_list_new(void) {
  struct string_list *ret = 0L;
  ret = (struct string_list *) malloc(sizeof(struct string_list));
  memset(ret, 0, sizeof(struct string_list));
  return ret;
}

struct string_node *string_node_new(void) {
  struct string_node *ret = 0L;
  ret = (struct string_node *) malloc(sizeof(struct string_node));
  memset(ret, 0, sizeof(struct string_node));
  return ret;
}

void string_list_append(struct string_list *list, struct string_node *node) {
  if (!list->first) {
    list->first = list->last = node;
  } else {
    list->last->next = node;
    node->prev = list->last;
    list->last = node;
  }
}
