/*****************************************************************
 *
 *   show_help.c
 *
 *     Copyright (c) 2000  Kam Tik <kamtik@hongkong.com>
 *
 *	http://debian.kamtik.net
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 ******************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "cpanel.h"

extern gboolean if_gb;

void show_help(gchar *path, gchar *help_title, gint width, gint high)
{
	GtkWidget *win;
	GtkWidget *vbox, *hbox;
	GtkWidget *help_content;
	GtkWidget *vscrollbar;
	GtkWidget *separator;
	GtkWidget *button;
	FILE *f;
	long file_size;
	gchar *help_source;
	gchar *real_path;

	if(if_gb)
	real_path = g_strconcat(PREFIX, "/share/cpanel/help/gb/",path,NULL);
	else
	real_path = g_strconcat(PREFIX, "/share/cpanel/help/big5/",path,NULL);

	f = fopen(real_path, "r");
	if(!f)
	{
		simple_message_dialog(_("Cannot open help file"),_("Oops...."));
		return;
	}
	if(fseek(f,0,SEEK_END)!=0)
	{
		simple_message_dialog(_("Can't determine file size"),_("Huh?"));
		fclose(f);
		return;
	}

	file_size = ftell(f);
	if(file_size == -1)
	{
		simple_message_dialog(_("Can't determine file size"),_("Huh?"));
		fclose(f);
		return;
	}

	help_source = (gchar *)malloc(file_size);
	if(!help_source)
	{
		simple_message_dialog(_("Memory not enough"),
				_("Let's go to buy more ;)"));
		fclose(f);
		return;
	}
	if(fseek(f,0,SEEK_SET)!=0)
	{
		simple_message_dialog(_("Can't determine file size"),_("Huh?"));
		g_free(help_source);
		fclose(f);
		return;
	}
	
	fread(help_source,1,file_size,f);
	fclose(f);

	/* Making window */
	win = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_title(GTK_WINDOW(win),help_title);
	gtk_container_set_border_width(GTK_CONTAINER(win),5);
	gtk_widget_set_usize(win,width,high);

	vbox = gtk_vbox_new(FALSE,0);
	hbox = gtk_hbox_new(FALSE,0);

	help_content = gtk_text_new(NULL,NULL);
	gtk_text_set_editable(GTK_TEXT(help_content),FALSE);
	gtk_box_pack_start(GTK_BOX(hbox),help_content,TRUE,TRUE,0);

	vscrollbar = gtk_vscrollbar_new(GTK_TEXT(help_content)->vadj);
	gtk_box_pack_start(GTK_BOX(hbox),vscrollbar,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,TRUE,TRUE,0);

	separator = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(vbox),separator,FALSE,FALSE,5);

	button = gtk_button_new_with_label(_("Close"));
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(close_win),win);
	gtk_box_pack_start(GTK_BOX(vbox),button,FALSE,TRUE,0);

	gtk_container_add(GTK_CONTAINER(win),vbox);
	gtk_grab_add(win);
	gtk_widget_show_all(win);
	gtk_text_insert(GTK_TEXT(help_content),NULL,NULL,NULL,help_source,-1);

	g_free(help_source);
}
