/*****************************************************************
 *
 *   cpanel.h
 *
 *     Copyright (c) 2000  Kam Tik <kamtik@hongkong.com>
 *
 *	http://debian.kamtik.net
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 ******************************************************************/

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* for gettext */
#include <libintl.h>
#define _(String) gettext (String)

#define RC_FILE_NAME ".cpanelrc"
#define GTK_LOCALE_FILE_NAME ".gtkrc.zh_TW.big5"
#define GTK_LOCALE_FILE_NAME_GB ".gtkrc.zh_CN"
#define SET_LOCALE_FILE_NAME ".xsession"
#define STR_BUFFER_SIZE 1024
#define VERSION_MAJOR 0
#define VERSION_MINOR 3
#define VERSION_MICRO 1

#define MAIN_WIN_TITLE _("Debian Chinese Panel")
#define MINI_WIN_TITLE _("Debian Chinese Panel")
#define MAIN_WIN_BORDER 8
#define MINI_WIN_BORDER 2

/***********************
 * Function prototype
 * *********************/
/* cpanel */
GtkWidget *pack_icon_label_button(gchar *path, gchar *text, GtkWidget *box, GtkWidget *win);
GtkWidget *pack_icon_button_end(gchar *path, GtkWidget *box, GtkWidget *win);
GtkWidget *pack_icon_button(gchar *path, GtkWidget *box, GtkWidget *win);
GtkWidget *pack_button(gchar *label, GtkWidget *box);
GtkWidget *pack_button_end(gchar *label, GtkWidget *box);

/* about */
void display_about_page(GtkWidget *button, gpointer data);

/* install_list */
void install_list(GtkWidget *pre_button, gpointer data);

/* rcfile */
void loadconfig(void);
void saveconfig(void);

/* sys_chk */
void sys_check(void);
void sys_info_page(GtkWidget *widget, gpointer data);

/* show_help */
void show_help(gchar *path, gchar *help_title, gint width, gint high);

/* fonts */
void getFonts(GtkWidget *entry);

/* pixmap */
GtkWidget *xpm_box(GtkWidget *window, gchar *xpm_filename);

/* apt */
void apt_process(GtkWidget *pre_button, gpointer program);

/* common */
void close_win(GtkWidget *button, gpointer *win);
void save_opt(GtkWidget *button, gpointer *data);
GtkWidget *make_opt(gchar *text, GtkWidget *entry[], gint n, gchar *value);
GtkWidget *make_fonts_opt(gchar *text, GtkWidget *entry[], gint n, gchar *value, GtkWidget *win);
GtkWidget *make_button(GtkWidget *ok,GtkWidget *cancel,
	GtkWidget *def,GtkWidget *help,GtkWidget *win,GtkWidget *button);
void simple_message_dialog(gchar *message,gchar *button_label);
GtkWidget *make_opt_win(gchar *title, GtkWidget *button);
GtkWidget *make_check_opt(gchar *text, gboolean checked);

/* search_file */
gboolean isfile(gchar *s);
void search_file(void);
void search_program(void);

/* menu */
GtkWidget *cpanel_create_menu_bar(void);

/* crxvt */
void crxvt(GtkWidget *button, gpointer *data);
void crxvt_opt(GtkWidget *button, gpointer *data);
void crxvt_help(GtkWidget *button, gpointer *data);

/* crxvt-gb */
void crxvt_gb(GtkWidget *button, gpointer *data);
void crxvt_gb_opt(GtkWidget *button, gpointer *data);
void crxvt_gb_help(GtkWidget *button, gpointer *data);

/* xcin */
void xcin(GtkWidget *button, gpointer *data);
void xcin_opt(GtkWidget *button, gpointer *data);
void xcin_help(GtkWidget *button, gpointer *data);

/* xcin2.3 */
void xcin23(GtkWidget *button, gpointer *data);
void xcin23_opt(GtkWidget *button, gpointer *data);
void xcin23_help(GtkWidget *button, gpointer *data);

/* xcingb */
void xcingb(GtkWidget *button, gpointer *data);
void xcingb_help(GtkWidget *button, gpointer *data);

/* gtk_fonts */
void gtk_fonts_opt(GtkWidget *button, gpointer *data);
void gtk_fonts_help(GtkWidget *button, gpointer *data);
void save_gtk_fonts(gchar *fontName, gboolean gb);

/* set_locale */
void set_locale_opt(GtkWidget *button, gpointer *data);
void set_locale_help(GtkWidget *button, gpointer *data);

/* xacv */
void xacv(GtkWidget *button, gpointer *data);
void xacv_opt(GtkWidget *button, gpointer *data);
void xacv_help(GtkWidget *button, gpointer *data);

/* pydict */
void pydict(GtkWidget *button, gpointer data);
void pydict_help(GtkWidget *button, gpointer data);

/* init */
void init_process(void);
