#include "cpanel.h"

void font_button_clicked(GtkWidget *button, gpointer *entry)
{
	getFonts(GTK_WIDGET(entry));
}

void activate(GtkWidget *widget,gpointer *button)
{
	gtk_widget_set_sensitive(GTK_WIDGET(button),TRUE);
}

void close_win(GtkWidget *button, gpointer *win)
{
	gtk_widget_destroy(GTK_WIDGET(win));
}

void release_grab(GtkWidget *win, gpointer *data)
{
	gtk_grab_remove(GTK_WIDGET(data));
}

void save_opt(GtkWidget *button, gpointer *data)
{
	saveconfig();
}

GtkWidget *make_opt(gchar *text, GtkWidget *entry[], gint n, gchar *value)
{
	GtkWidget *label;
	GtkWidget *hbox;
	
	hbox = gtk_hbox_new(FALSE,0);
	label = gtk_label_new(text);
	entry[n] = gtk_entry_new();
	gtk_entry_append_text(GTK_ENTRY(entry[n]),value);
	gtk_box_pack_start(GTK_BOX(hbox),label,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),entry[n],FALSE,FALSE,0);

	return hbox;
}

GtkWidget *make_check_opt(gchar *text, gboolean checked)
{
	GtkWidget *check_button;
	
	check_button = gtk_check_button_new_with_label(text);
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(check_button),checked);

	return check_button;
}


GtkWidget *make_fonts_opt(gchar *text,GtkWidget *entry[], gint n, gchar *value, GtkWidget *win)
{
	GtkWidget *label;
	GtkWidget *hbox;
	GtkWidget *font_button;

	hbox = gtk_hbox_new(FALSE,0);
	label = gtk_label_new(text);
	entry[n] = gtk_entry_new();
	font_button = gtk_button_new_with_label(_("Select"));
	gtk_entry_append_text(GTK_ENTRY(entry[n]),value);
	gtk_signal_connect(GTK_OBJECT(font_button),"clicked",
			GTK_SIGNAL_FUNC(font_button_clicked),entry[n]);
	gtk_signal_connect(GTK_OBJECT(font_button),"clicked",
			GTK_SIGNAL_FUNC(release_grab),win);
	gtk_box_pack_start(GTK_BOX(hbox),label,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),entry[n],FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),font_button,FALSE,FALSE,0);

	return hbox;
}

GtkWidget *make_button(GtkWidget *ok,GtkWidget *cancel,
		GtkWidget *def,GtkWidget *help,GtkWidget *win,GtkWidget *button)
{
	GtkWidget *hbox;

	hbox = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),ok,FALSE,FALSE,0);
	gtk_signal_connect(GTK_OBJECT(ok),"clicked",
			GTK_SIGNAL_FUNC(close_win),win);
	gtk_box_pack_start(GTK_BOX(hbox),cancel,FALSE,FALSE,0);
	gtk_signal_connect(GTK_OBJECT(cancel),"clicked",
			GTK_SIGNAL_FUNC(close_win),win);
	gtk_box_pack_start(GTK_BOX(hbox),def,FALSE,FALSE,0);
	gtk_box_pack_end(GTK_BOX(hbox),help,FALSE,FALSE,0);

	/*
	gtk_signal_connect(GTK_OBJECT(win),"destroy",
			GTK_SIGNAL_FUNC(activate),button);
	*/

	return hbox;
}

void simple_message_dialog(gchar *message,gchar *button_label)
{
	GtkWidget *win;
	GtkWidget *label;
	GtkWidget *separator;
	GtkWidget *button;
	GtkWidget *vbox;

	win = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_title(GTK_WINDOW(win),_("Message"));
	gtk_container_set_border_width(GTK_CONTAINER(win),10);

	vbox = gtk_vbox_new(FALSE,0);

	label = gtk_label_new(message);
	separator = gtk_hseparator_new();
	button = gtk_button_new_with_label(button_label);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
			GTK_SIGNAL_FUNC(close_win),win);
	gtk_box_pack_start(GTK_BOX(vbox),label,FALSE,FALSE,1);
	gtk_box_pack_start(GTK_BOX(vbox),separator,FALSE,FALSE,5);
	gtk_box_pack_start(GTK_BOX(vbox),button,FALSE,FALSE,5);

	gtk_container_add(GTK_CONTAINER(win),vbox);
	gtk_grab_add(win);
	gtk_widget_show_all(win);
}

GtkWidget *make_opt_win(gchar *title, GtkWidget *button)
{
	GtkWidget *win;
	
	win = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_title(GTK_WINDOW(win),title);
	gtk_container_set_border_width(GTK_CONTAINER(win),5);
	gtk_grab_add(win);
	gtk_signal_connect(GTK_OBJECT(win),"destroy",
			GTK_SIGNAL_FUNC(release_grab),win);
	return win;
}
