
/*
** Copyright 2000 Double Precision, Inc.
** See COPYING for distribution information.
**
** $Id: xtest.c,v 1.1 2000/12/24 03:26:43 mrsam Exp $
*/

#include "unicode.h"

/*
** This map is for testing purposes.  Funny stuff.
*/

extern const struct unicode_info unicode_ISO8859_1;

static unicode_char *c2u(const char *cp, int *ip)
{
	unicode_char *uc= (*unicode_ISO8859_1.c2u)(cp, ip);
	int i;

	for (i=0; uc && uc[i]; i++)
		if (uc[i] >= 0x40 && uc[i] <= 0x7d)
			uc[i] ^= 1;
	return (uc);
}

static char *u2c(const unicode_char *cp, int *ip)
{
	char *uc= (*unicode_ISO8859_1.u2c)(cp, ip);

	int i;

	for (i=0; uc && uc[i]; i++)
		if (uc[i] >= 0x40 && uc[i] <= 0x7d)
			uc[i] ^= 1;
	return (uc);
}

static char *toupper_func(const char *cp, int *ip)
{
	return ( (*unicode_ISO8859_1.toupper_func)(cp, ip));
}

static char *tolower_func(const char *cp, int *ip)
{
	return ( (*unicode_ISO8859_1.tolower_func)(cp, ip));
}

static char *totitle_func(const char *cp, int *ip)
{
	return ( (*unicode_ISO8859_1.totitle_func)(cp, ip));
}

const struct unicode_info unicode_XTEST = {
	"X-TEST",
	c2u,
	u2c,
	toupper_func,
	tolower_func,
	totitle_func};
