/*
** Copyright 1998 - 2001 Double Precision, Inc.
** See COPYING for distribution information.
*/

#include	"courier.h"
#include	"rw.h"
#include	"comcargs.h"
#include	"rfc822.h"
#include	"afx.h"
#include	"afxtempl.h"
#include	<string.h>
#include	<signal.h>
#include	<stdlib.h>
#include	<stdio.h>

#if	HAVE_LOCALE_H
#include	<locale.h>
#endif

#if	HAVE_SYS_STAT_H
#include	<sys/stat.h>
#endif
#if	HAVE_UNISTD_H
#include	<unistd.h>
#endif
#include	<iostream>
#include	<fstream>

using namespace std;

static const char rcsid[]="$Id: aliasexp.C,v 1.8 2001/08/05 20:00:33 mrsam Exp $";

// MAXDUMP is the maximum # of addresses printed per list by the -dump
// flag.  Larger lists are printed in parts.  This allows the output
// of -dump to be refed into makealiases without using up a lot of memory.
//

static const char *srcfilename=0;
static const char *tmpdir=0;
static const char *xpfix="";

static struct courier_args arginfo[]={
	{"src", &srcfilename},
	{"xaliastmpdir", &tmpdir},
	{"xaliaspfix", &xpfix},
	{0}
	} ;

static char *normalize(struct rw_transport *module, struct rfc822token *t,
	int &islocal)
{
struct	rw_info_rewrite	rwir;
struct	rw_info rwi;
char	*address, *p;
char	*hostdomain;

	islocal=0;
	rw_info_init(&rwi, t, rw_err_func);

	rwi.mode=RW_ENVRECIPIENT;
	rwi.udata=(void *)&rwir;
	rwir.buf=0;
	rwir.errmsg=0;

	rw_rewrite_module(module, &rwi, rw_rewrite_chksyn_print);
	address=((struct rw_info_rewrite *)rwi.udata)->buf;
	if (!address)
	{
	char	*p=rfc822_gettok(rwi.ptr);

		if (!p)	clog_msg_errno();
		clog_msg_start_err();
		clog_msg_str(p);
		free(p);
		clog_msg_str(": ");
		while ((p=strchr(((struct rw_info_rewrite *)rwi.udata)->errmsg,
			'\n')) != 0)
			*p=p[1] ? '/':'\0';
		clog_msg_str(((struct rw_info_rewrite *)rwi.udata)->errmsg);
		clog_msg_send();
		exit(1);
	}

	hostdomain=0;
	if ((p=strrchr(address, '@')) == 0
		|| (config_islocal(p+1, &hostdomain) && hostdomain == 0))
	{
		locallower(address);
		islocal=1;
	}
	if (hostdomain)	free(hostdomain);

	domainlower(address);
	return (address);
}

/*
** Ok, we have an alias defined as /pathname, or | prog.  Emulate it by
** substituting a dummy address for it.
*/

static void sendmailext(const char *aliasname, const char *cmd)
{
size_t	l=strlen(aliasname);
const char *p;
char	*s, *t;

static int first_time=1;

	if (tmpdir == 0)	return;

	for (p=aliasname; *p; p++)
		if (strchr("/.-+\"\\", *p))	l += 2;

	s=(char *)courier_malloc(l+1);
	t=s;
	for (p=aliasname; *p; p++)
		if (strchr("/.-+\"\\", *p))
		{
			sprintf(t, "+%02x", (int)(unsigned char)*p);
			t += 3;
		}
		else	*t++ = *p;
	*t=0;

	t=(char *)courier_malloc(strlen(s)+strlen(tmpdir)+sizeof("/"));
	strcpy(t, tmpdir);

	if (first_time)
	{
		first_time=0;
		mkdir(t, 0755);
	}
	strcat(strcat(t, "/"), s);

	printf("<\"%s%s\"@%s>\n", xpfix, s, config_defaultdomain());

ofstream	o(t, ios::out | ios::app);

	if (o.fail())
	{
		perror(t);
		exit(1);
	}

	o << cmd << endl << flush;

	if (o.fail() || (o.close(), o.fail()))
	{
		perror(t);
		exit(1);
	}
	free(t);
	free(s);
}

static void doline(const char *alias,
	const char *line, struct rw_transport *module)
{
struct rfc822t *tp=rfc822t_alloc_new( line, NULL, NULL);
int	i;

	if (!tp)	clog_msg_errno();

struct rfc822a *ta=rfc822a_alloc(tp);

	if (!ta)	clog_msg_errno();

	for (i=0; i<ta->naddrs; i++)
	{
	int	islocal=0;

		if (!ta->addrs[i].tokens)	continue;

	char	*p;

		if (*alias != '@')
		{
			p=normalize(module, ta->addrs[i].tokens, islocal);
		}
		else
		{
		/*
		** When the name of the alias starts with an @, it's a virtual
		** domain definition, so don't convert the addresses to
		** canonical format!!
		*/
			p=rfc822_gettok(ta->addrs[i].tokens);

			if (!p)	clog_msg_errno();
		}

		cout << '<' << p << '>' << endl;
		free(p);
	}
	rfc822a_free(ta);
	rfc822t_free(tp);
}

static int doexpaliases(CString line, struct rw_transport *module)
{
int	i;
CString	name;

	line.TrimLeft();
	line.TrimRight();
	if (line.GetLength() == 0)	return (0);

	if ((i=line.Find(':')) < 0)	return (-1);
	name=line.Left(i);
	line=line.Mid(i+1);

struct rfc822t	*nametok=rw_rewrite_tokenize(name);
int dummy;
char	*norm_addr=normalize(module, nametok->tokens, dummy);

	rfc822t_free(nametok);
	cout << '<' << norm_addr << '>' << endl;

	line.TrimLeft();

const char *linep=line;

	if (*linep == '/' || *linep == '|')
	{
		sendmailext(norm_addr, line);
		free(norm_addr);
		cout << endl;
		return (0);
	}

	if (strncmp(line, ":include:", 9))
	{
		doline(norm_addr, line, module);
		free(norm_addr);
		cout << endl;
		return (0);
	}

	line=line.Mid(9);
	if ( *(const char *)line != '/')
	{
		clog_msg_start_err();
		clog_msg_str("Absolute pathname is required:");
		clog_msg_send();
		return (-1);
	}

ifstream	ifs;

	ifs.open(line);
	if (!ifs.is_open())
		clog_msg_errno();

	while ((line << ifs) == 0)
	{
	int	i=line.Find('#');

		if (i >= 0)
		{
			line.GetBuffer();
			line.ReleaseBuffer(i);
		}
		doline(norm_addr, line, module);
	}
	cout << endl;
	free(norm_addr);
	return (0);
}

static int expaliases(CString line, struct rw_transport *module,
		unsigned linenum, CString &filename)
{
	if (doexpaliases(line, module))
	{
		clog_msg_start_err();
		if (filename.GetLength() > 0)
		{
			clog_msg_str( (const char *)filename );
			clog_msg_str(": ");
		}
		clog_msg_str("syntax error, line ");
		clog_msg_uint(linenum);
		clog_msg_send();
		return (-1);
	}
	return (0);
}

static int aliasexp(istream &is, struct rw_transport *module)
{
CString	line, next_line;
int	i;
unsigned linenum=0, start_line;
int	rc=0;
CString	filename;

	line="";
	start_line=1;

	while ((next_line << is) == 0)
	{
		++linenum;

		if (strncmp(next_line, "##MaKeAlIaSeS##", 15) == 0)
		{
			linenum=0;
			filename=next_line.Mid(15);
		}

		if ((i=next_line.Find('#')) >= 0)
		{
			next_line.GetBuffer();
			next_line.ReleaseBuffer(i);
		}
		next_line.TrimRight();

	const	char *p=next_line;

		if (!p || *p == ' ' || *p == '\t')
		{
			line += next_line;
			continue;
		}

		if (expaliases(line, module, linenum, filename))
			rc=1;
		line=next_line;
		start_line=linenum;
	}

	if (expaliases(line, module, linenum, filename))
		rc=1;

	if (rc == 0)	cout << "." << endl;
	return (rc);
}

int cppmain(int argc, char **argv)
{
int	argn;
const	char *module="local";
ifstream	ifs;
istream		*i;

#if HAVE_SETLOCALE
	setlocale(LC_ALL, "C");
#endif

	argn=cargs(argc, argv, arginfo);

	if (argn < argc)
		module=argv[argn++];

	if (rw_init(0))	exit (1);
	clog_open_stderr("aliasexp");
	if (!srcfilename || strcmp(srcfilename, "-") == 0)
		i= &cin;
	else
	{
		ifs.open(srcfilename);
		if (ifs.fail())
		{
			clog_msg_start_err();
			clog_msg_str("Unable to open ");
			clog_msg_str(srcfilename);
			clog_msg_send();
			exit(1);
		}
		i= &ifs;
	}

struct rw_transport *modulep=rw_search_transport(module);

	if (!modulep)
	{
		clog_msg_start_err();
		clog_msg_str(module);
		clog_msg_str(" - not a valid module.");
		clog_msg_send();
		exit(1);
	}

int rc=aliasexp(*i, modulep);

	return(rc);
}
