/**
 * Handle Temporary Allow List by maintaining the config preference
 * CM_PREFERENCE_TYPE_COOKIE_TEMP
 * @type s1tony.CM.tempAllow
 */
s1tony.CM.tempAllow = 
{
    init: function()
    {
		// Do nothing for now    	
	},
	
	/**
	 * Check if the host is already contained in this list
	 * @param {} aList
	 * @param {} elt
	 * @return Integer
	 */
    _requestHostIndexOf: function(aList, elt /*, checkDomain, from*/)
	{
		var len = aList.length >>> 0;
		var checkDomain = false || Boolean(arguments[2]);
	
		var from = Number(arguments[3]) || 0;
		from = (from < 0)
			? Math.ceil(from)
			: Math.floor(from);
		if (from < 0)
			from += len;

		if (!checkDomain)
		{
			for (; from < len; from++)
			{
	  			if (from in aList &&
	      			aList[from].split(';')[0] === elt)
	    		return from;    		
			}
		}
		else
		{
			for (; from < len; from++)
			{		
			    if (from in aList &&
	      			s1tony.CM.cookieInfo.getSecondLevelHost(aList[from].split(';')[0]) === elt)
	    		return from;
			}
		}
		
		return -1;		
	},
	
	add: function(aURI)
	{
		// Check if URI already has a non-default cookie access
		// Use CM_TOP_LEVEL because the level is already inherently defined
		// by aURI in this case 
        var accessLevel = s1tony.CM.cookieInfo.checkPermissionArray(aURI, CM_PERMISSION_TYPE_COOKIE);
        var accessValue = s1tony.CM.cookieInfo.getPermissionValue(accessLevel[CM_TOP_LEVEL]);

        s1tony.CM.nsPreferences.setAppendToStringPref(CM_PREFERENCE_TYPE_COOKIE_TEMP, aURI.asciiHost + ';' + accessValue);		
	},
	
	remove: function(aURI)
	{
		s1tony.CM.nsPreferences.setRemoveFromStringPref(CM_PREFERENCE_TYPE_COOKIE_TEMP, aURI.asciiHost);
	},

	// Check to see if aURI is a temporary permission
	isTempPermission: function(aURI)
	{
		var retValue = false;
    	var tempList = s1tony.CM.nsPreferences.getStringPrefArray(CM_PREFERENCE_TYPE_COOKIE_TEMP);
    	
    	// Each array item should contain a URI and a cookie preference,
    	// separated by a semicolon
        for (var i = 0; i < tempList.length; i++)
        {
        	var tempItem = tempList[i].split(';');
        	
        	if (tempItem[0] === aURI.asciiHost)
        	{
				retValue = true;
				break;
        	}
        }
        
        return retValue;
	},

	/**
	 * Reset permission for aHost from temp allow
	 * back to original permission
	 * @param {string} aHost
	 * @return {Integer} Original Permission Setting
	 */
	resetTempCookie: function(aHost)
	{
		var retValue = null;
    	var tempList = s1tony.CM.nsPreferences.getStringPrefArray(CM_PREFERENCE_TYPE_COOKIE_TEMP);
    	
    	// Retrieve index position for aURI
    	var hostIndex = this._requestHostIndexOf(tempList, aHost);
    	//alert("Got to resetTempCookie:  hostIndex:  " + hostIndex + " " + tempList[hostIndex]);
    	
    	// Reset cookie permissions back to previous setting and
    	// remove from preference string
    	if (hostIndex > -1)
    	{
    		this._resetTempCookieValues(tempList[hostIndex], hostIndex);
    		s1tony.CM.nsPreferences.setRemoveFromStringPref(CM_PREFERENCE_TYPE_COOKIE_TEMP, aHost);
    		retValue = tempList[hostIndex].split(';')[1];
    	}
    	
    	return retValue;
	},
	
	/**
	 * Reset temp cookie list
	 */
    resetTempCookies: function()
    {  	
     	var tempList = s1tony.CM.nsPreferences.getStringPrefArray(CM_PREFERENCE_TYPE_COOKIE_TEMP);
    	tempList.forEach(this._resetTempCookieValues, this);
        
        s1tony.CM.nsPreferences.clearUserPref(CM_PREFERENCE_TYPE_COOKIE_TEMP);   
    },

    // Delete temp cookies from host and reset temp cookie permissions
    _resetTempCookieValues: function(aItem, aIndex)
    {
        var hostURI = null;
     	var item = aItem.split(';');
     	var host = item[0];
     	var prefSetting = item[1];
        	   	
    	// Set aUseBaseDomain to true
        s1tony.CM.cookieInfo.deleteHostCookies(host, true);
        
        //alert("resetTempCookieValues:  Host: " + host + " Previous Setting: " + prefSetting);
 
        hostURI = s1tony.CM.utils.createURIFromHostName(host);

        // Reset cookie permissions back to previous setting 
        s1tony.CM.cookieInfo.choice.setAccess(hostURI, prefSetting);
	}
}
