/* trivial.c */

#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

#include "trivial.h"

/* there's also printe in trivial.h */

/*
 * this is for errors we can't be reasonably
 * be blamed for
 */
int _printsys(char *fmt, ...)
{
	va_list ap;
	fprintf(stderr, "SYSTEM ERROR: %s : ", strerror(errno));
	fflush(stderr);
	va_start(ap, fmt);
	vfprintf(stderr, fmt, ap);
	va_end(ap);
	exit(1);
}

/* print warning */
int printw(char *fmt, ...)
{
	va_list ap;
	fprintf(stdout, "WARNING: ");
	fflush(stderr);
	va_start(ap, fmt);
	vfprintf(stdout, fmt, ap);
	va_end(ap);
	return 0;
}

/* desired output, what we worked for */
int printout(char *fmt, ...)
{
	va_list ap;
	va_start(ap, fmt);
	if(opt_outfile){
		FILE *fp;
		if(!(fp=fopen(opt_outfile, "a"))){
				fprintf(stderr, "cannot open output file %s "
						"for writing\n", opt_outfile);
				exit(1);
		}
		vfprintf(fp, fmt, ap);
		fclose(fp);
		return 0;
	}
	vfprintf(stdout, fmt, ap);
	fflush(stdout);
	va_end(ap);
	return 0;
}

/*
 * dirty progress bar implementation
 */

int print_prog_bar(int perc)
{
	char line[80];
	int i, pos;

	if(perc>100 || perc<0){
		printe("invalid percentage specified (%d)\n", perc);
		return 1;
	}
	pos=70*perc/100;
	line[0]='|';
	for(i=1; i<pos; i++){
		line[i]='-';
	}
	for(; i<70; i++){
		line[i]=' ';
	}
	line[i++]='|';
	for(; i<80; i++){
		line[i]='\0';
	}
	sprintf(line+71, "%5d%%", perc);
	printf("%s\r", line);
	fflush(stdout);
	return 0;
}
