/*

    linux/usb.h compatibility header

    Copyright (C) 2003 Bernd Porr, Bernd.Porr@cn.stir.ac.uk

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef __COMPAT_LINUX_USB_H_
#define __COMPAT_LINUX_USB_H_

#include <linux/version.h>

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,0)
#define USB_ALLOC_URB(x) usb_alloc_urb(x)
#define USB_SUBMIT_URB(x) usb_submit_urb(x)
#define URB_ISO_ASAP USB_ISO_ASAP
#define PROBE_ERR_RETURN(x) NULL
#else
#define USB_ALLOC_URB(x) usb_alloc_urb(x,GFP_KERNEL)
#define USB_SUBMIT_URB(x) usb_submit_urb(x,GFP_ATOMIC)
#define PROBE_ERR_RETURN(x) x
#endif


#include_next <linux/usb.h>

#endif

