import py
from py.__.rest.latex import process_configfile, process_rest_file
from shared_helpers import is_on_path

def setup_module(mod):
    if not is_on_path("gs") or not is_on_path("dot") or not is_on_path("latex"):
        py.test.skip("ghostscript, graphviz and latex needed")

data = py.magic.autopath().dirpath().join("data")

def test_process_rest_file():
    part2 = data.join("part1.txt")
    pdf = part2.new(ext="pdf")
    process_rest_file(part2)
    assert pdf.check()
    pdf.remove()

def test_process_configfile():
    config = data.join("example.rst2pdfconfig")
    pdf = config.new(ext="pdf")
    tex = data.join('example.tex')
    process_configfile(config, debug=True)
    assert pdf.check()
    assert tex.check()
    texcontent = tex.read()
    assert "Generated by" in texcontent
    assert "Docutils" in texcontent
    process_configfile(config, debug=False)
    assert pdf.check()
    assert not tex.check()
    pdf.remove()

def test_process_all():
    # fallback test: only checks that no exception is raised
    def rec(p):
        return p.check(dotfile=0)
    for x in data.visit("*.txt", rec=rec):
        yield process_rest_file, x
    for x in data.visit("*.rst2pdfconfig", rec=rec):
        yield process_configfile, x
