//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
// copyright            : (C) 2014 The CodeLite Team
// file name            : qmakesettingstab.h
//
// -------------------------------------------------------------------------
// A
//              _____           _      _     _ _
//             /  __ \         | |    | |   (_) |
//             | /  \/ ___   __| | ___| |    _| |_ ___
//             | |    / _ \ / _  |/ _ \ |   | | __/ _ )
//             | \__/\ (_) | (_| |  __/ |___| | ||  __/
//              \____/\___/ \__,_|\___\_____/_|\__\___|
//
//                                                  F i l e
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

#ifndef __qmakesettingstab__
#define __qmakesettingstab__

/**
@file
Subclass of QmakeSettingsTabBase, which is generated by wxFormBuilder.
*/
class QmakeConf;

#include "qmakesettingsbasedlg.h"

/** Implementing QmakeSettingsTabBase */
class QmakeSettingsTab : public QmakeSettingsTabBase
{
    wxString       m_name;
    wxArrayString  GetSpecList(const wxString &qmakePath);

public:
    /** Constructor */
    QmakeSettingsTab(wxWindow* parent, const wxString &name, QmakeConf* conf);

    void Load(QmakeConf *conf);
    void Save(QmakeConf *conf);
    void OnFileSelected(wxFileDirPickerEvent &event);

    void SetTabName(const wxString& name) {
        this->m_name = name;
    }
    const wxString& GetTabName() const {
        return m_name;
    }
};

#endif // __qmakesettingstab__
