/*
*
* put.c - COBEX - Send files to a device.
*
* Copyright (c) 2003,2004,2005,2006 Fredrik Srensson
*
* History:
* v0.5 - fsn - 04-02-22 - First version
* v0.6 - fsn - 05-07-19 - Using general signal handling and general path handling
* v0.7 - fsn - 06-07-29 - Code cleanup
*
* Source:
*
*/

#include <stdio.h>
#include <ezV24/ezV24.h>
#include <signal.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include "cobex_core.h"
#include "cobex_tools.h"
#include "cobex_serial.h"

v24_port_t *UsedPort=NULL;

// Send the Buffer

int sendBuffer (char *inBuffer, int inBuffLgt, obex_packet *inPacket) {

	int sent=0;
	while (sent < inBuffLgt) {
		obex_opcode_put ( inPacket );
		sent+=obex_hi_body ( inPacket, inBuffer, inBuffLgt, sent );
		cobex_packlgt ( inPacket );

		if (cobex_packet_send(inPacket, UsedPort) != COBEX_OK) {
			cobex_closePort(UsedPort);
			return COBEX_ERR;
		}
		if ( cobex_packet_recieve(inPacket, UsedPort) != COBEX_OK) {
			cobex_closePort(UsedPort);
			return COBEX_ERR;
		}
	}
	return COBEX_OK;
}

// Send a file

int sendFile (char *fileName, char *nameOnDevice, obex_packet *inPacket ) {
	FILE *fh;
	char *path;
	char *name;
	char fileBuffer[4001];
	int total=0;
	int buffLgt;
	int rc;
	struct stat buf;

	// Open file...

	if (stat(fileName,&buf) != 0) { return COBEX_ERR; }

	fh=fopen(fileName, "r");
	if (fh==NULL) { return COBEX_ERR; }

	//Set Path
	
	path=calloc( strlen(nameOnDevice)+1, sizeof(char) );
	name=calloc( strlen(nameOnDevice)+1, sizeof(char) );
	
	ctools_buildPath (nameOnDevice, path, name);
	rc=ctools_recursePath( inPacket, path, UsedPort, OBEX_SETPATH_DONTCREATE );

	// Send put start

	obex_opcode_put ( inPacket );
	obex_hi_length ( inPacket, buf.st_size );
	obex_hi_name ( inPacket, name, strlen(name)+1 );
	//obex_hi_name ( inPacket, nameOnDevice, strlen(nameOnDevice)+1 );
	cobex_packlgt ( inPacket );

	free(name);
	free(path);

	// dump_packet_headers (inPacket);


	if ( cobex_packet_send(inPacket, UsedPort) != COBEX_OK) {
		fclose (fh);
		return COBEX_ERR;
	}
	if ( cobex_packet_recieve(inPacket, UsedPort) != COBEX_OK) {
		fclose (fh);
		return COBEX_ERR;
	}
	// dump_packet_headers (inPacket);

	if ( inPacket->buffer[0] != (OBEX_RESPONSE_CONTINUE | OBEX_FINAL_BIT) ) {
		fclose (fh);
		return COBEX_ERR;
	}

	// Send file

	while ((buffLgt=fread (fileBuffer,1,4000,fh)) > 0 ) {
		rc=sendBuffer ( fileBuffer, buffLgt, inPacket);
		if (rc != 0) { fclose(fh); return rc; }
		if (cobex_response_code(inPacket) != (OBEX_RESPONSE_CONTINUE | OBEX_FINAL_BIT)) {
			fclose(fh);
			return COBEX_ERR;
		}
		total+=buffLgt;
		printf("Sent %d bytes.\r",total);
		fflush(stdout);
	}

	printf ("\n");

	fclose (fh);

	// Send end_of_body

	obex_opcode_put ( inPacket );
	obex_hi_endofbody ( inPacket );
	cobex_packlgt ( inPacket );
	cobex_set_final_bit( inPacket );

	if (cobex_packet_send(inPacket, UsedPort) != COBEX_OK) {
		return COBEX_ERR;
	}
	if ( cobex_packet_recieve(inPacket, UsedPort) != COBEX_OK) {
		return COBEX_ERR;
	}
	if (inPacket->buffer[0] != (OBEX_RESPONSE_OK | OBEX_FINAL_BIT) ) {
		return COBEX_ERR;
	}

	return COBEX_OK;
}

void help () {
	printf ("cobex_put v0.5\n\n");
	printf ("Usage: obex_put <device> <infile> <name_on_device>\n\n");
	printf ("All arguments are compulsory and order is important. Returncodes are used to\n");
	printf ("indicate errors. Use the perl frontend if you want more userfriendlyness.\n\n");
}

// Main routine

int main (int argc, char *argv[]) {
	int rc;
	int endStatus;
	static char fsBrowser[]={ 0xf9, 0xec, 0x7b, 0xc4, 0x95, 0x3c, 0x11, 0xd2, 0x98, 0x4e, 0x52, 0x54, 0x00, 0xdc, 0x9e, 0x09, 0x00};


	char outBuffer[513];
	obex_packet outPacket;

	outPacket.max=512;
	//outPacket.buffer=outBuffer;
	outPacket.buffer=(u_char *)outBuffer;

	if (argc != 4) {
		help() ;
		return COBEX_ERR;
	}

	// Set up the port

	rc = ctools_commonInit( &UsedPort, &outPacket, argv[1], fsBrowser );
	if (rc != COBEX_OK) { exit (COBEX_ERR); }	

	// Do the specific things

	endStatus=sendFile(argv[2],argv[3],&outPacket);
	if (cobex_response_code(&outPacket) != (OBEX_RESPONSE_OK|OBEX_FINAL_BIT)) {
		fprintf (stderr, "ERR: %s \n",
			cobex_respstring(cobex_response_code(&outPacket)) ) ;
		rc=COBEX_ERR;
	}

	// Bye, y'all!

	ctools_disconnect( &outPacket, UsedPort );
	cobex_closePort(UsedPort);

	return rc;

}
