/****************************************************************************
 *    lib/options.cpp - This file is part of coala							*
 *																			*
 *    Copyright (C) 2009  Torsten Grote										*
 *																			*
 *    This program is free software; you can redistribute it and/or modify	*
 *    it under the terms of the GNU General Public License as published by	*
 *    the Free Software Foundation; either version 3 of the License, or		*
 *    (at your option) any later version.									*
 *																			*
 *    This program is distributed in the hope that it will be useful,		*
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of		*
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the			*
 *    GNU General Public License for more details.							*
 *																			*
 *    You should have received a copy of the GNU General Public License		*
 *    along with this program; if not, see http://www.gnu.org/licenses		*
 ****************************************************************************/

#include "options.h"

namespace Coala {

CompilerOptions::CompilerOptions() {
	language_ = "c";
	fakeClassicalNegation_ = false;
	debug_ = 0;
	directEncoding_ = false;
	incremental_ = false;
	reverseIncremental_ = false;
	whereCheck_ = true;
}

CompilerOptions::~CompilerOptions() {
}


bool CompilerOptions::checkOptions() {
	if(language_ == "c_taid") {
		if(!directEncoding_ || incremental_ || reverseIncremental_) return false;
		else return true;
	}
	else if(language_ == "c" || language_ == "m") {
		if(!directEncoding_ && language_ == "m") return false;
		else if(directEncoding_ && reverseIncremental_) return false;
		else return true;
	}
	else return true;
}


void CompilerOptions::setLanguage(string language) {
	language_ = language;
}

string CompilerOptions::getLanguage() {
	return language_;
}


void CompilerOptions::setInputStream(istream& inputStream) {
	inputStream_ = &inputStream;
}

istream* CompilerOptions::getInputStream() {
	return inputStream_;
}


void CompilerOptions::setOutputStream(ostream& outputStream) {
	outputStream_ = &outputStream;
}

ostream* CompilerOptions::getOutputStream() {
	return outputStream_;
}


void CompilerOptions::setFakeClassicalNegation(bool fakeClassicalNegation) {
	fakeClassicalNegation_ = fakeClassicalNegation;
}

bool CompilerOptions::getFakeClassicalNegation() {
	return fakeClassicalNegation_;
}


void CompilerOptions::setDebug(int debug) {
	debug_ = debug;
}

int CompilerOptions::getDebug() {
	return debug_;
}


void CompilerOptions::setDirectEncoding(bool directEncoding) {
	directEncoding_ = directEncoding;
}

bool CompilerOptions::getDirectEncoding() {
	return directEncoding_;
}


void CompilerOptions::setIncremental(bool incremental) {
	incremental_ = incremental;
}

bool CompilerOptions::getIncremental() {
	return incremental_;
}


void CompilerOptions::setReverseIncremental(bool reverseIncremental) {
	reverseIncremental_ = reverseIncremental;
}

bool CompilerOptions::getReverseIncremental() {
	return reverseIncremental_;
}


void CompilerOptions::setWhereCheck(bool whereCheck) {
	whereCheck_ = whereCheck;
}

bool CompilerOptions::getWhereCheck() {
	return whereCheck_;
}


};
