/*
	$Id: treeview_item_generic.cpp,v 1.4 2002/01/08 10:26:20 sphair Exp $
	
	ClanGUI, copyrights by various people. Have a look in the CREDITS file.
	
	This sourcecode is distributed using the Library GNU Public Licence,
	version 2 or (at your option) any later version. Please read LICENSE
	for details.
*/

#include "precomp.h"
#include "treeview_item_generic.h"
#include "API/GUI/treeview_item.h"
#include "API/GUI/component.h"
#include "API/GUI/component_options.h"
#include "API/GUI/stylemanager.h"

/////////////////////////////////////////////////////////////////////////////
// Construction:

CL_TreeView_Item_Generic::CL_TreeView_Item_Generic(CL_TreeView_Item *self, const std::string &_text)
: item(self)
{
	opened = false;

	slot_key_down = item->sig_key_down().connect(
		this, &CL_TreeView_Item_Generic::on_key_down);
	slot_set_options = item->sig_set_options().connect(
		this, &CL_TreeView_Item_Generic::on_set_options);

	text = _text;
}

/////////////////////////////////////////////////////////////////////////////
// Attributes:

bool CL_TreeView_Item_Generic::has_subtree() const
{
	return item->get_children().size() > 0;
}
	
/////////////////////////////////////////////////////////////////////////////
// Operations:

void CL_TreeView_Item_Generic::set_text(const std::string &text)
{
	this->text = text;
}

/////////////////////////////////////////////////////////////////////////////
// Callbacks:

void CL_TreeView_Item_Generic::on_key_down(CL_Component *comp, CL_InputDevice *device, const CL_Key &key)
{
	item->sig_clicked()();
	
	opened = !opened;
}

void CL_TreeView_Item_Generic::on_set_options(const CL_ComponentOptions &options)
{
	if(options.exists("text"))
		text = options.get_value("text");
}
