/*
	$Id: menubar_generic.cpp,v 1.8 2001/12/16 19:18:08 mbn Exp $
	
	ClanGUI, copyrights by various people. Have a look in the CREDITS file.
	
	This sourcecode is distributed using the Library GNU Public Licence,
	version 2 or (at your option) any later version. Please read LICENSE
	for details.
*/

#include "precomp.h"
#include "menubar_generic.h"
#include "API/GUI/component_options.h"
#include "API/GUI/gui_manager.h"

CL_ComponentOptions CL_MenuBar_Generic::create_options(
	const CL_Rect &pos)
{
	CL_ComponentOptions options;

	options.add_option("x", pos.x1);
	options.add_option("y", pos.y1);
	options.add_option("width", pos.get_width());
	options.add_option("height", pos.get_height());

	return options;
}

CL_MenuBar_Generic::CL_MenuBar_Generic(CL_MenuBar *self, const CL_ComponentOptions &options, CL_StyleManager *style)
:
	menubar(self)
{
	slot_child_add = menubar->sig_child_before_add().connect(
		this, &CL_MenuBar_Generic::on_child_add);
}

CL_MenuBar_Generic::~CL_MenuBar_Generic()
{
}

void CL_MenuBar_Generic::on_child_add(CL_Component *child)
{
	CL_Rect children_rect = menubar->get_children_rect();

	// Move first child left abit
	if(children_rect.x2 == 0)
		children_rect.x2 = 2;

	// Move and resize child to fit into menubar
	CL_Rect rect(children_rect.x2 + 1, 2, children_rect.x2 + child->get_width(), menubar->get_height() - 2);
	child->set_position(rect);

	// Hook into clicking on the child
	if(child->is_enabled())
	{
		CL_Slot *slot = new CL_Slot(child->sig_mouse_up().connect(
			this, &CL_MenuBar_Generic::on_child_click, child));
		slots_child_click.push_back(slot);
	}
}

void CL_MenuBar_Generic::on_child_click(const CL_Key &key, CL_Component *component)
{
	const std::list<CL_Component *> children = component->get_children();
	if(children.size())
	{
		CL_Component *submenu = *(children.begin());
		component->remove_child(submenu);
		menubar->get_gui_manager()->add_child(submenu);

		CL_Rect pos = menubar->get_screen_rect();
		submenu->set_position(pos.x1, pos.y1 + menubar->get_height());
		submenu->set_focus();
		submenu->show();
	}
}

