/*
	$Id: combobox_generic.h,v 1.9 2001/12/27 23:14:03 sphair Exp $
	
	ClanGUI, copyrights by various people. Have a look in the CREDITS file.
	
	This sourcecode is distributed using the Library GNU Public Licence,
	version 2 or (at your option) any later version. Please read LICENSE
	for details.
*/

#ifndef header_combobox_generic
#define header_combobox_generic

#include "API/GUI/combobox.h"

class CL_Button;

class CL_ComboBox_Generic
{
public:
	CL_ComboBox_Generic(CL_ComboBox *self);
	~CL_ComboBox_Generic();

public:
	int get_count() const;

	std::list<std::string> &get_items();
	std::string get_current_text() const;
	std::string get_text(int index) const;
	int get_current_item() const;
	bool is_selected(int index) const;

public:
	int insert_item(const std::string &text, int index);
	void remove_item(int index);
	void change_item(const std::string &text, int index);

	void set_current_item(int index);
	void clear_selection();

	void sort(bool ascending);

	void clear();

public:
	CL_Signal_v1<int> sig_activated;
	CL_Signal_v1<int> sig_highlighted;

protected:
	void on_set_options(const CL_ComponentOptions &options);
	void set_select_button(CL_Button *select_button);
	void select_clicked();

	CL_Slot slot_clicked, slot_pressed;
	CL_Slot slot_set_options;

	bool activated;
	bool skip_next_activation;

	int highlighted_item;

	CL_ComboBox *combobox;
	CL_Button *select_button;

	std::list<std::string> items;
};  

#endif

