#include <iostream.h>
#include <ClanLib/core.h>
#include <ClanLib/gui.h>
#include <ClanLib/application.h>
#include <ClanLib/display.h>

class FileDialogTest : public CL_ClanApplication
{
public:
	char *get_title() { return "FileDialogTest"; }

	int main(int argc, char** argv)
	{
		// Create a console window for text-output if not available
		CL_ConsoleWindow console("Console");
		console.redirect_stdio();

		try
		{
			CL_SetupCore::init();
			CL_SetupGUI::init();
			CL_SetupDisplay::init();
			CL_Display::set_videomode(640,480,16, false, false, false);

			resources = new CL_ResourceManager("resources.scr", false);
			style = new CL_StyleManager_Default(resources);
			gui = new CL_GUIManager(style);
			manager = CL_ComponentManager::create("filedialog.gui", false, style,gui);
			

			CL_FileDialog *dialog = (CL_FileDialog *)manager->get_component("mydialog");

			//CL_Slot s1 = dialog->sig_ok.connect(this, &FileDialogTest::on_ok);
			//CL_Slot s2 = dialog->sig_cancel.connect(this, &FileDialogTest::on_cancel);

			//dialog->set_path("/home/");

			while (!CL_Keyboard::get_keycode(CL_KEY_ESCAPE))
			{
				CL_Display::clear_display(0.60f, 0.60f, 0.60f);
				
				gui->show();

				CL_System::keep_alive();
				CL_Display::flip_display();
			}
			
			delete gui;
			delete manager;
			delete style;
			delete resources;

			CL_SetupDisplay::deinit();
			CL_SetupGUI::deinit();
			CL_SetupCore::deinit();
		}
		catch (CL_Error e)
		{
			std::cout << e.message.c_str() << std::endl;
		}
		catch (...)
		{
			std::cout << "Ugga" << std::endl;
		}

		// Display console close message and wait for a key
		console.display_close_message();

		return 0;
	}

	void on_ok(CL_String s)
	{
		std::cout << "File selected: " << s << std::endl;
	}

	void on_cancel()
	{
		std::cout << "Dialog cancelled" << std::endl;
	}

private:
	CL_ResourceManager *resources;
	CL_StyleManager *style;
	CL_ComponentManager *manager;
	CL_GUIManager *gui;
} app;
