
;;;
;;; *** Old *** version of the Foreign function interface.
;;;
;;; This version attempted to automatically process function calls
;;; with arguments that are composite types (structs, arrays).
;;;
;;; The basic idea is to automatically "wrap" each argument with a function
;;; that extracts a pointer to the composite type before calling the
;;; C function.
;;;
;;; This approach was abandoned because: 1) it was too complicated; 2)
;;; I don't want to do too much for the user automatically.
;;;
;;;
;;; Richard Mann
;;; 31 October 1996
;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;
;; Low-level accessors for GCL data
;;

;;; This only works for pointer to array type
(defCfun "static object void_ptr(s) object s;" 0
 " return((void*)(s)->ust.ust_self);")
(defentry void-ptr (object) (object void_ptr))

;;; Later may want to handle case of: char array, single char, string, fixnum
;;; This may avoid need to tell FFI what datatype is needed
;;; (Instead the user says this by calling the function with either
;;; a character array, a character, a string, or a number).
(defCfun "static object char_ptr(s) object s;" 0
 " return(s->st.st_self);")
(defentry char-ptr (object) (object char_ptr))

(defCfun "static object unsigned_char_ptr(s) object s;" 0
 " return(s->ust.ust_self);")
(defentry unsigned-char-ptr (object) (object unsigned_char_ptr))

;;; All types of INT are FIXNUM now.
;;; Note: if a single number is used, point to it.  If array type,
;;; point to first element of array.  (We hope it is a "typed" array.)
(defCfun "static object short_ptr(s) object s;" 0
 " if (type_of(s) == t_fixnum) return(&fix(s)); return(s->fixa.fixa_self);")
(defentry short-ptr (object) (object short_ptr))

(defCfun "static object unsigned_short_ptr(s) object s;" 0
 " if (type_of(s) == t_fixnum) return(&fix(s)); return(s->fixa.fixa_self);")
(defentry unsigned-short-ptr (object) (object unsigned_short_ptr))

(defCfun "static object int_ptr(s) object s;" 0
 " if (type_of(s) == t_fixnum) return(&fix(s)); return(s->fixa.fixa_self);")
(defentry int-ptr (object) (object int_ptr))

(defCfun "static object unsigned_int_ptr(s) object s;" 0
 " if (type_of(s) == t_fixnum) return(&fix(s)); return(s->fixa.fixa_self);")
(defentry unsigned-int-ptr (object) (object unsigned_int_ptr))

(defCfun "static object float_ptr(s) object s;" 0
 " if (type_of(s) == t_shortfloat) return(&sf(s)); return(s->sfa.sfa_self);")
(defentry float-ptr (object) (object float_ptr))

(defCfun "static object double_ptr(s) object s;" 0
 " if (type_of(s) == t_doublefloat) return(&lf(s)); return(s->lfa.lfa_self);")
(defentry double-ptr (object) (object double_ptr))

;;; Pointers to functions and structs not used now.
(defCfun "static object struct_ptr(s) object s;" 0
 " return(s->str.str_self);")
(defentry struct-ptr (object) (object struct_ptr))

(defCfun "static object function_ptr(s) object s;" 0
 " return((int(*)())s->cf.cf_self);")
(defentry function-ptr (object) (object function_ptr))

;;; The following is now inserted into the bindings files
;(eval-when (compile load eval)
(eval-when ()
 
 ;;
 ;; List of foreign symbols used to build export list
 ;;

 (defvar foreign-functions '())
 (defvar foreign-defines '())

 ;;
 ;; Map foreign types to types used by GCL
 ;;

 (defparameter *parameter-types-default* 'int)
 (defparameter *parameter-types*
   '((pointer int nil)
     (string string nil)
     (void void nil)
     (int int nil)
     (long int nil)
     (unsigned-int int nil)
     (unsigned-long int nil)
     (short int nil)
     (unsigned-short int nil)
     (char char nil)
     (unsigned-char char nil)
     (float float nil)
     (double double nil)
     ((pointer void) object void-ptr)
     ((pointer char) object char-ptr)
     ((pointer unsigned-char) object unsigned-char-ptr)
     ((pointer short) object short-ptr)
     ((pointer unsigned-short) object unsigned-short-ptr)
     ((pointer int) object int-ptr)
     ((pointer unsigned-int) object unsigned-int-ptr)
     ((pointer long) object int-ptr)
     ((pointer unsigned-long) object unsigned-int-ptr)
     ((pointer float) object float-ptr)
     ((pointer double) object double-ptr)
     ;;((pointer struct) object struct-ptr)
     ((pointer struct) int nil)         ; for now, access structs by pointers
     ((pointer function) object function-ptr)))

 ;;
 ;; Types used for Extern definitions
 ;;

 (defparameter *extern-types-default* "void*")
 (defparameter *extern-types*
   '((pointer "void*")
     (string "char*")
     (void "void")
     (int "int")
     (long "long")
     (unsigned-int "unsigned int")
     (unsigned-long "unsigned long")
     (short "short")
     (unsigned-short "unsigned short")
     (char "char")
     (unsigned-char "unsigned char")
     (float "float")
     (double "double")
     ((pointer void) "void*")
     ((pointer char) "char*")
     ((pointer unsigned-char) "unsigned char*")
     ((pointer short) "short*")
     ((pointer unsigned-short) "unsigned short*")
     ((pointer int) "int*")
     ((pointer unsigned-int) "unsigned int*")
     ((pointer long) "long*")
     ((pointer unsigned-long) "unsigned long*")
     ((pointer float) "float*")
     ((pointer double) "double*")
     ((pointer struct) "void*")	; use generic pointers for now
     ((pointer function) "void*")))


 ;;
 ;; Macro to do translation.
 ;;
 ;; "Simple" calls are are translated to GCL "defentry" form.
 ;; When the types involve "composite" datatypes, an auxillary function
 ;; (ending in "*") is created.  (See the code.)
 ;;
 ;; Note! In addition to the LISP "defentry" form, you need to put
 ;; a C "extern" definition before each function so that the types are
 ;; properly converted to C.
 ;;

 (defmacro foreign-function (lisp-name parameters return-parameter c-name)
  (setq foreign-functions (push lisp-name foreign-functions))
  (let* ((parameter-types
	  (mapcar #'(lambda (x)
		     (let ((result
			    (second (assoc x *parameter-types*
					   :test #'equal))))
		      ;; if we cannot find type, choose default
		      (if result result *parameter-types-default*)))
		  parameters))
	 ;; return type must be a primitive type (or a pointer)
	 (return-parameter-type
	  (let ((result
		 (second (assoc return-parameter *parameter-types*
				:test #'equal))))
	   (if (or (not result) (eq result 'object))
	       *parameter-types-default*
	       result)))
	 (extern-types
	  (mapcar #'(lambda (x)
		     (let ((result
			    (second (assoc x *extern-types*
					   :test #'equal))))
		      (if result result *extern-types-default*)))
		  parameters))
	 (return-extern-type
	  (let ((result (second (assoc return-parameter *extern-types*
				       :test #'equal))))
	   (if result result *extern-types-default*)))
	 ;; extern <ret-type> <c-name>(<type1>, <type2>, ... ,<typen>);
	 (extern-declaration
	  (concatenate
	   'string "extern " return-extern-type " " c-name "("
	   ;; Concatenate strings with commas between terms.  Messy!
	   (let ((l extern-types)
		 (s ""))
	    (loop (when (null l) (return s))
		  (setf s (concatenate 'string s (first l)))
		  (setf l (rest l))
		  (unless (null l) (setf s (concatenate 'string s ", ")))))
	   ;; Add final bracket
	   ");")))
   ;;
   (if (not (or (member 'object parameter-types)
		(eq 'object return-parameter-type)))
       ;;
       ;; If there are no "compound" parameters, just do a DEFENTRY
       `(progn
	 (clines ,extern-declaration)
	 (defentry ,lisp-name ,parameter-types (,return-parameter-type
						,c-name)))
       ;;
       ;; Otherwise, put a wrapper to get pointers to compound elements
       ;; (Not sure why we Intern here?)
       (let ((new-name (intern (concatenate 'string
					    (symbol-name lisp-name) "*")))
	     (arguments (mapcar #'(lambda (x) (gensym)) parameters))
	     (converters
	      (mapcar #'(lambda (x)
			 (third (assoc x *parameter-types* :test #'equal)))
		      parameters))
	     (return-converter
	      (third (assoc return-parameter-type *parameter-types*
			    :test #'equal))))
	;;
	;; For now, don't define macros if they return compound types.
	(unless return-converter
	 `(progn
	   (clines ,extern-declaration)
	   (defentry ,new-name ,parameter-types (,return-parameter-type
						 ,c-name))
	   (defmacro ,lisp-name ,arguments
	    (,new-name
	     ,@(mapcar #'(lambda (argument converter)
			  (if (null converter)
			      argument
			      `(,converter ,argument)))
		       arguments converters)))))))))
 
 
 ;;
 ;; Simple treatment of CPP "define" macro for now; may expand later.
 ;;

 (defmacro foreign-define (a b)
  (setq foreign-defines (push a foreign-defines))
  `(defconstant ,a ,b))

 ;;
 ;; When done all definitions, this call will build list of external symbols
 ;;

 (defmacro export-all-foreign-symbols ()
  `(progn
    (EXPORT ',(reverse foreign-defines))
    (EXPORT ',(reverse foreign-functions))))
 
 ) ;; eval-when

