(in-package :gl)

(eval-when (:compile-toplevel)
  (when *output-c*
    (with-open-file (file "glut-callbacks-c.c"
			  :direction :output :if-exists :supersede)
      (format file "
/* CMUCL GLUT callback glue: generated from glut-callbacks.lisp */
typedef unsigned int lispobj; /* safe assumtion? */
#define make_fixnum(n) ((lispobj)((n)<<2))
extern lispobj funcall0(lispobj function);
extern lispobj funcall1(lispobj function, lispobj arg0);
extern lispobj funcall2(lispobj function, lispobj arg0, lispobj arg1);
extern lispobj funcall3(lispobj function, lispobj arg0, lispobj arg1,
                        lispobj arg2);
/* funcall4 is not predefined, use call_into_lisp: */
extern lispobj call_into_lisp(lispobj fun, lispobj *args, int nargs);
lispobj funcall4(lispobj function, lispobj arg0, lispobj arg1,
                 lispobj arg2, lispobj arg3)
{
  static lispobj args[4];
  args[0] = arg0;
  args[1] = arg1;
  args[2] = arg2;
  args[3] = arg3;
  return call_into_lisp(function, args, 4);
}

#include <GL/glut.h>
/* GLUT/lisp callback code follows */"))))


(glut-callback glutdisplayfunc () "glutDisplayFunc")
(glut-callback glutreshapefunc (int int) "glutReshapeFunc")
(glut-callback glutkeyboardfunc (unsigned-char int int) "glutKeyboardFunc")
(glut-callback glutmousefunc (int int int int) "glutMouseFunc")
(glut-callback glutmotionfunc (int int) "glutMotionFunc")
(glut-callback glutpassivemotionfunc (int int) "glutPassiveMotionFunc")
(glut-callback glutentryfunc (int) "glutEntryFunc")
(glut-callback glutvisibilityfunc (int) "glutVisibilityFunc")
(glut-callback glutidlefunc () "glutIdleFunc")
;;(glut-callback gluttimerfunc (unsigned-int (function int) int) "glutTimerFunc")
(glut-callback glutmenustatefunc (int) "glutMenuStateFunc")
(glut-callback glutspecialfunc (int int int) "glutSpecialFunc")
(glut-callback glutspaceballmotionfunc (int int int) "glutSpaceballMotionFunc")
(glut-callback glutspaceballrotatefunc (int int int) "glutSpaceballRotateFunc")
(glut-callback glutspaceballbuttonfunc (int int) "glutSpaceballButtonFunc")
(glut-callback glutbuttonboxfunc (int int) "glutButtonBoxFunc")
(glut-callback glutdialsfunc (int int) "glutDialsFunc")
(glut-callback gluttabletmotionfunc (int int) "glutTabletMotionFunc")
(glut-callback gluttabletbuttonfunc (int int int int) "glutTabletButtonFunc")
(glut-callback glutmenustatusfunc (int int int) "glutMenuStatusFunc")
(glut-callback glutoverlaydisplayfunc () "glutOverlayDisplayFunc")
(glut-callback glutwindowstatusfunc (int) "glutWindowStatusFunc")