/*
 #
 #  File        : loop_macros.h
 #                ( C++ header file - CImg plug-in )
 #
 #  Description : CImg plug-in adding useful loop macros in CImg, in order to
 #                deal with NxN neighborhoods (where N=10..32)
 #                and NxNxN neighborhoods (where N=4..8)
 #                This file has been automatically generated using the loop
 #                macro generator available in 'examples/generate_loop_macros.cpp'
 #                This file is a part of the CImg Library project.
 #                ( http://cimg.sourceforge.net )
 #
 #  Copyright   : David Tschumperle
 #                ( http://www.greyc.ensicaen.fr/~dtschump/ )
 #
 #  License     : CeCILL v2.0
 #                ( http://www.cecill.info/licences/Licence_CeCILL_V2-en.html )
 #
 #  This software is governed by the CeCILL  license under French law and
 #  abiding by the rules of distribution of free software.  You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  "http://www.cecill.info".
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  In this respect, the user's attention is drawn to the risks associated
 #  with loading,  using,  modifying and/or developing or reproducing the
 #  software by the user in light of its specific status of free software,
 #  that may mean  that it is complicated to manipulate,  and  that  also
 #  therefore means  that it is reserved for developers  and  experienced
 #  professionals having in-depth computer knowledge. Users are therefore
 #  encouraged to load and test the software's suitability as regards their
 #  requirements in conditions enabling the security of their systems and/or
 #  data to be ensured and,  more generally, to use and operate it in the
 #  same conditions as regards security.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL license and that you accept its terms.
 #
*/

#ifndef cimg_plugin_loop_macros
#define cimg_plugin_loop_macros

// Define 10x10 loop macros
//-------------------------
#define cimg_for10(bound,i) for (int i = 0, \
 _p4##i = 0, _p3##i = 0, _p2##i = 0, _p1##i = 0, \
 _n1##i = 1>=(int)(bound)?(int)(bound)-1:1, \
 _n2##i = 2>=(int)(bound)?(int)(bound)-1:2, \
 _n3##i = 3>=(int)(bound)?(int)(bound)-1:3, \
 _n4##i = 4>=(int)(bound)?(int)(bound)-1:4, \
 _n5##i = 5>=(int)(bound)?(int)(bound)-1:5; \
 _n5##i<(int)(bound) || _n4##i==--_n5##i || _n3##i==--_n4##i || _n2##i==--_n3##i || _n1##i==--_n2##i || \
 i==(_n5##i = _n4##i = _n3##i = _n2##i = --_n1##i); \
 _p4##i = _p3##i, _p3##i = _p2##i, _p2##i = _p1##i, _p1##i = i++, \
 ++_n1##i, ++_n2##i, ++_n3##i, ++_n4##i, ++_n5##i)

#define cimg_for10X(img,x) cimg_for10((img)._width,x)
#define cimg_for10Y(img,y) cimg_for10((img)._height,y)
#define cimg_for10Z(img,z) cimg_for10((img)._depth,z)
#define cimg_for10C(img,c) cimg_for10((img)._spectrum,c)
#define cimg_for10XY(img,x,y) cimg_for10Y(img,y) cimg_for10X(img,x)
#define cimg_for10XZ(img,x,z) cimg_for10Z(img,z) cimg_for10X(img,x)
#define cimg_for10XC(img,x,c) cimg_for10C(img,c) cimg_for10X(img,x)
#define cimg_for10YZ(img,y,z) cimg_for10Z(img,z) cimg_for10Y(img,y)
#define cimg_for10YC(img,y,c) cimg_for10C(img,c) cimg_for10Y(img,y)
#define cimg_for10ZC(img,z,c) cimg_for10C(img,c) cimg_for10Z(img,z)
#define cimg_for10XYZ(img,x,y,z) cimg_for10Z(img,z) cimg_for10XY(img,x,y)
#define cimg_for10XZC(img,x,z,c) cimg_for10C(img,c) cimg_for10XZ(img,x,z)
#define cimg_for10YZC(img,y,z,c) cimg_for10C(img,c) cimg_for10YZ(img,y,z)
#define cimg_for10XYZC(img,x,y,z,c) cimg_for10C(img,c) cimg_for10XYZ(img,x,y,z)

#define cimg_for_in10(bound,i0,i1,i) for (int i = (int)(i0)<0?0:(int)(i0), \
 _p4##i = i-4<0?0:i-4, \
 _p3##i = i-3<0?0:i-3, \
 _p2##i = i-2<0?0:i-2, \
 _p1##i = i-1<0?0:i-1, \
 _n1##i = i+1>=(int)(bound)?(int)(bound)-1:i+1, \
 _n2##i = i+2>=(int)(bound)?(int)(bound)-1:i+2, \
 _n3##i = i+3>=(int)(bound)?(int)(bound)-1:i+3, \
 _n4##i = i+4>=(int)(bound)?(int)(bound)-1:i+4, \
 _n5##i = i+5>=(int)(bound)?(int)(bound)-1:i+5; \
 i<=(int)(i1) && (_n5##i<(int)(bound) || _n4##i==--_n5##i || _n3##i==--_n4##i || _n2##i==--_n3##i || _n1##i==--_n2##i || \
 i==(_n5##i = _n4##i = _n3##i = _n2##i = --_n1##i)); \
 _p4##i = _p3##i, _p3##i = _p2##i, _p2##i = _p1##i, _p1##i = i++, \
 ++_n1##i, ++_n2##i, ++_n3##i, ++_n4##i, ++_n5##i)

#define cimg_for_in10X(img,x0,x1,x) cimg_for_in10((img)._width,x0,x1,x)
#define cimg_for_in10Y(img,y0,y1,y) cimg_for_in10((img)._height,y0,y1,y)
#define cimg_for_in10Z(img,z0,z1,z) cimg_for_in10((img)._depth,z0,z1,z)
#define cimg_for_in10C(img,c0,c1,c) cimg_for_in10((img)._spectrum,c0,c1,c)
#define cimg_for_in10XY(img,x0,y0,x1,y1,x,y) cimg_for_in10Y(img,y0,y1,y) cimg_for_in10X(img,x0,x1,x)
#define cimg_for_in10XZ(img,x0,z0,x1,z1,x,z) cimg_for_in10Z(img,z0,z1,z) cimg_for_in10X(img,x0,x1,x)
#define cimg_for_in10XC(img,x0,c0,x1,c1,x,c) cimg_for_in10C(img,c0,c1,c) cimg_for_in10X(img,x0,x1,x)
#define cimg_for_in10YZ(img,y0,z0,y1,z1,y,z) cimg_for_in10Z(img,z0,z1,z) cimg_for_in10Y(img,y0,y1,y)
#define cimg_for_in10YC(img,y0,c0,y1,c1,y,c) cimg_for_in10C(img,c0,c1,c) cimg_for_in10Y(img,y0,y1,y)
#define cimg_for_in10ZC(img,z0,c0,z1,c1,z,c) cimg_for_in10C(img,c0,c1,c) cimg_for_in10Z(img,z0,z1,z)
#define cimg_for_in10XYZ(img,x0,y0,z0,x1,y1,z1,x,y,z) cimg_for_in10Z(img,z0,z1,z) cimg_for_in10XY(img,x0,y0,x1,y1,x,y)
#define cimg_for_in10XZC(img,x0,z0,c0,x1,y1,c1,x,z,c) cimg_for_in10C(img,c0,c1,c) cimg_for_in10XZ(img,x0,y0,x1,y1,x,z)
#define cimg_for_in10YZC(img,y0,z0,c0,y1,z1,c1,y,z,c) cimg_for_in10C(img,c0,c1,c) cimg_for_in10YZ(img,y0,z0,y1,z1,y,z)
#define cimg_for_in10XYZC(img,x0,y0,z0,c0,x1,y1,z1,c1,x,y,z,c) cimg_for_in10C(img,c0,c1,c) cimg_for_in10XYZ(img,x0,y0,z0,x1,y1,z1,x,y,z)

#define cimg_for10x10(img,x,y,z,c,I,T) \
 cimg_for10((img)._height,y) for (int x = 0, \
 _p4##x = 0, _p3##x = 0, _p2##x = 0, _p1##x = 0, \
 _n1##x = 1>=((img)._width)?(img).width()-1:1, \
 _n2##x = 2>=((img)._width)?(img).width()-1:2, \
 _n3##x = 3>=((img)._width)?(img).width()-1:3, \
 _n4##x = 4>=((img)._width)?(img).width()-1:4, \
 _n5##x = (int)( \
 (I[0] = I[1] = I[2] = I[3] = I[4] = (T)(img)(0,_p4##y,z,c)), \
 (I[10] = I[11] = I[12] = I[13] = I[14] = (T)(img)(0,_p3##y,z,c)), \
 (I[20] = I[21] = I[22] = I[23] = I[24] = (T)(img)(0,_p2##y,z,c)), \
 (I[30] = I[31] = I[32] = I[33] = I[34] = (T)(img)(0,_p1##y,z,c)), \
 (I[40] = I[41] = I[42] = I[43] = I[44] = (T)(img)(0,y,z,c)), \
 (I[50] = I[51] = I[52] = I[53] = I[54] = (T)(img)(0,_n1##y,z,c)), \
 (I[60] = I[61] = I[62] = I[63] = I[64] = (T)(img)(0,_n2##y,z,c)), \
 (I[70] = I[71] = I[72] = I[73] = I[74] = (T)(img)(0,_n3##y,z,c)), \
 (I[80] = I[81] = I[82] = I[83] = I[84] = (T)(img)(0,_n4##y,z,c)), \
 (I[90] = I[91] = I[92] = I[93] = I[94] = (T)(img)(0,_n5##y,z,c)), \
 (I[5] = (T)(img)(_n1##x,_p4##y,z,c)), \
 (I[15] = (T)(img)(_n1##x,_p3##y,z,c)), \
 (I[25] = (T)(img)(_n1##x,_p2##y,z,c)), \
 (I[35] = (T)(img)(_n1##x,_p1##y,z,c)), \
 (I[45] = (T)(img)(_n1##x,y,z,c)), \
 (I[55] = (T)(img)(_n1##x,_n1##y,z,c)), \
 (I[65] = (T)(img)(_n1##x,_n2##y,z,c)), \
 (I[75] = (T)(img)(_n1##x,_n3##y,z,c)), \
 (I[85] = (T)(img)(_n1##x,_n4##y,z,c)), \
 (I[95] = (T)(img)(_n1##x,_n5##y,z,c)), \
 (I[6] = (T)(img)(_n2##x,_p4##y,z,c)), \
 (I[16] = (T)(img)(_n2##x,_p3##y,z,c)), \
 (I[26] = (T)(img)(_n2##x,_p2##y,z,c)), \
 (I[36] = (T)(img)(_n2##x,_p1##y,z,c)), \
 (I[46] = (T)(img)(_n2##x,y,z,c)), \
 (I[56] = (T)(img)(_n2##x,_n1##y,z,c)), \
 (I[66] = (T)(img)(_n2##x,_n2##y,z,c)), \
 (I[76] = (T)(img)(_n2##x,_n3##y,z,c)), \
 (I[86] = (T)(img)(_n2##x,_n4##y,z,c)), \
 (I[96] = (T)(img)(_n2##x,_n5##y,z,c)), \
 (I[7] = (T)(img)(_n3##x,_p4##y,z,c)), \
 (I[17] = (T)(img)(_n3##x,_p3##y,z,c)), \
 (I[27] = (T)(img)(_n3##x,_p2##y,z,c)), \
 (I[37] = (T)(img)(_n3##x,_p1##y,z,c)), \
 (I[47] = (T)(img)(_n3##x,y,z,c)), \
 (I[57] = (T)(img)(_n3##x,_n1##y,z,c)), \
 (I[67] = (T)(img)(_n3##x,_n2##y,z,c)), \
 (I[77] = (T)(img)(_n3##x,_n3##y,z,c)), \
 (I[87] = (T)(img)(_n3##x,_n4##y,z,c)), \
 (I[97] = (T)(img)(_n3##x,_n5##y,z,c)), \
 (I[8] = (T)(img)(_n4##x,_p4##y,z,c)), \
 (I[18] = (T)(img)(_n4##x,_p3##y,z,c)), \
 (I[28] = (T)(img)(_n4##x,_p2##y,z,c)), \
 (I[38] = (T)(img)(_n4##x,_p1##y,z,c)), \
 (I[48] = (T)(img)(_n4##x,y,z,c)), \
 (I[58] = (T)(img)(_n4##x,_n1##y,z,c)), \
 (I[68] = (T)(img)(_n4##x,_n2##y,z,c)), \
 (I[78] = (T)(img)(_n4##x,_n3##y,z,c)), \
 (I[88] = (T)(img)(_n4##x,_n4##y,z,c)), \
 (I[98] = (T)(img)(_n4##x,_n5##y,z,c)), \
 5>=((img)._width)?(img).width()-1:5); \
 (_n5##x<(img).width() && ( \
 (I[9] = (T)(img)(_n5##x,_p4##y,z,c)), \
 (I[19] = (T)(img)(_n5##x,_p3##y,z,c)), \
 (I[29] = (T)(img)(_n5##x,_p2##y,z,c)), \
 (I[39] = (T)(img)(_n5##x,_p1##y,z,c)), \
 (I[49] = (T)(img)(_n5##x,y,z,c)), \
 (I[59] = (T)(img)(_n5##x,_n1##y,z,c)), \
 (I[69] = (T)(img)(_n5##x,_n2##y,z,c)), \
 (I[79] = (T)(img)(_n5##x,_n3##y,z,c)), \
 (I[89] = (T)(img)(_n5##x,_n4##y,z,c)), \
 (I[99] = (T)(img)(_n5##x,_n5##y,z,c)),1)) || \
 _n4##x==--_n5##x || _n3##x==--_n4##x || _n2##x==--_n3##x || _n1##x==--_n2##x || x==(_n5##x = _n4##x = _n3##x = _n2##x = --_n1##x); \
 I[0] = I[1], I[1] = I[2], I[2] = I[3], I[3] = I[4], I[4] = I[5], I[5] = I[6], I[6] = I[7], I[7] = I[8], I[8] = I[9], \
 I[10] = I[11], I[11] = I[12], I[12] = I[13], I[13] = I[14], I[14] = I[15], I[15] = I[16], I[16] = I[17], I[17] = I[18], I[18] = I[19], \
 I[20] = I[21], I[21] = I[22], I[22] = I[23], I[23] = I[24], I[24] = I[25], I[25] = I[26], I[26] = I[27], I[27] = I[28], I[28] = I[29], \
 I[30] = I[31], I[31] = I[32], I[32] = I[33], I[33] = I[34], I[34] = I[35], I[35] = I[36], I[36] = I[37], I[37] = I[38], I[38] = I[39], \
 I[40] = I[41], I[41] = I[42], I[42] = I[43], I[43] = I[44], I[44] = I[45], I[45] = I[46], I[46] = I[47], I[47] = I[48], I[48] = I[49], \
 I[50] = I[51], I[51] = I[52], I[52] = I[53], I[53] = I[54], I[54] = I[55], I[55] = I[56], I[56] = I[57], I[57] = I[58], I[58] = I[59], \
 I[60] = I[61], I[61] = I[62], I[62] = I[63], I[63] = I[64], I[64] = I[65], I[65] = I[66], I[66] = I[67], I[67] = I[68], I[68] = I[69], \
 I[70] = I[71], I[71] = I[72], I[72] = I[73], I[73] = I[74], I[74] = I[75], I[75] = I[76], I[76] = I[77], I[77] = I[78], I[78] = I[79], \
 I[80] = I[81], I[81] = I[82], I[82] = I[83], I[83] = I[84], I[84] = I[85], I[85] = I[86], I[86] = I[87], I[87] = I[88], I[88] = I[89], \
 I[90] = I[91], I[91] = I[92], I[92] = I[93], I[93] = I[94], I[94] = I[95], I[95] = I[96], I[96] = I[97], I[97] = I[98], I[98] = I[99], \
 _p4##x = _p3##x, _p3##x = _p2##x, _p2##x = _p1##x, _p1##x = x++, ++_n1##x, ++_n2##x, ++_n3##x, ++_n4##x, ++_n5##x)

#define cimg_for_in10x10(img,x0,y0,x1,y1,x,y,z,c,I,T) \
 cimg_for_in10((img)._height,y0,y1,y) for (int x = (int)(x0)<0?0:(int)(x0), \
 _p4##x = x-4<0?0:x-4, \
 _p3##x = x-3<0?0:x-3, \
 _p2##x = x-2<0?0:x-2, \
 _p1##x = x-1<0?0:x-1, \
 _n1##x = x+1>=(img).width()?(img).width()-1:x+1, \
 _n2##x = x+2>=(img).width()?(img).width()-1:x+2, \
 _n3##x = x+3>=(img).width()?(img).width()-1:x+3, \
 _n4##x = x+4>=(img).width()?(img).width()-1:x+4, \
 _n5##x = (int)( \
 (I[0] = (T)(img)(_p4##x,_p4##y,z,c)), \
 (I[10] = (T)(img)(_p4##x,_p3##y,z,c)), \
 (I[20] = (T)(img)(_p4##x,_p2##y,z,c)), \
 (I[30] = (T)(img)(_p4##x,_p1##y,z,c)), \
 (I[40] = (T)(img)(_p4##x,y,z,c)), \
 (I[50] = (T)(img)(_p4##x,_n1##y,z,c)), \
 (I[60] = (T)(img)(_p4##x,_n2##y,z,c)), \
 (I[70] = (T)(img)(_p4##x,_n3##y,z,c)), \
 (I[80] = (T)(img)(_p4##x,_n4##y,z,c)), \
 (I[90] = (T)(img)(_p4##x,_n5##y,z,c)), \
 (I[1] = (T)(img)(_p3##x,_p4##y,z,c)), \
 (I[11] = (T)(img)(_p3##x,_p3##y,z,c)), \
 (I[21] = (T)(img)(_p3##x,_p2##y,z,c)), \
 (I[31] = (T)(img)(_p3##x,_p1##y,z,c)), \
 (I[41] = (T)(img)(_p3##x,y,z,c)), \
 (I[51] = (T)(img)(_p3##x,_n1##y,z,c)), \
 (I[61] = (T)(img)(_p3##x,_n2##y,z,c)), \
 (I[71] = (T)(img)(_p3##x,_n3##y,z,c)), \
 (I[81] = (T)(img)(_p3##x,_n4##y,z,c)), \
 (I[91] = (T)(img)(_p3##x,_n5##y,z,c)), \
 (I[2] = (T)(img)(_p2##x,_p4##y,z,c)), \
 (I[12] = (T)(img)(_p2##x,_p3##y,z,c)), \
 (I[22] = (T)(img)(_p2##x,_p2##y,z,c)), \
 (I[32] = (T)(img)(_p2##x,_p1##y,z,c)), \
 (I[42] = (T)(img)(_p2##x,y,z,c)), \
 (I[52] = (T)(img)(_p2##x,_n1##y,z,c)), \
 (I[62] = (T)(img)(_p2##x,_n2##y,z,c)), \
 (I[72] = (T)(img)(_p2##x,_n3##y,z,c)), \
 (I[82] = (T)(img)(_p2##x,_n4##y,z,c)), \
 (I[92] = (T)(img)(_p2##x,_n5##y,z,c)), \
 (I[3] = (T)(img)(_p1##x,_p4##y,z,c)), \
 (I[13] = (T)(img)(_p1##x,_p3##y,z,c)), \
 (I[23] = (T)(img)(_p1##x,_p2##y,z,c)), \
 (I[33] = (T)(img)(_p1##x,_p1##y,z,c)), \
 (I[43] = (T)(img)(_p1##x,y,z,c)), \
 (I[53] = (T)(img)(_p1##x,_n1##y,z,c)), \
 (I[63] = (T)(img)(_p1##x,_n2##y,z,c)), \
 (I[73] = (T)(img)(_p1##x,_n3##y,z,c)), \
 (I[83] = (T)(img)(_p1##x,_n4##y,z,c)), \
 (I[93] = (T)(img)(_p1##x,_n5##y,z,c)), \
 (I[4] = (T)(img)(x,_p4##y,z,c)), \
 (I[14] = (T)(img)(x,_p3##y,z,c)), \
 (I[24] = (T)(img)(x,_p2##y,z,c)), \
 (I[34] = (T)(img)(x,_p1##y,z,c)), \
 (I[44] = (T)(img)(x,y,z,c)), \
 (I[54] = (T)(img)(x,_n1##y,z,c)), \
 (I[64] = (T)(img)(x,_n2##y,z,c)), \
 (I[74] = (T)(img)(x,_n3##y,z,c)), \
 (I[84] = (T)(img)(x,_n4##y,z,c)), \
 (I[94] = (T)(img)(x,_n5##y,z,c)), \
 (I[5] = (T)(img)(_n1##x,_p4##y,z,c)), \
 (I[15] = (T)(img)(_n1##x,_p3##y,z,c)), \
 (I[25] = (T)(img)(_n1##x,_p2##y,z,c)), \
 (I[35] = (T)(img)(_n1##x,_p1##y,z,c)), \
 (I[45] = (T)(img)(_n1##x,y,z,c)), \
 (I[55] = (T)(img)(_n1##x,_n1##y,z,c)), \
 (I[65] = (T)(img)(_n1##x,_n2##y,z,c)), \
 (I[75] = (T)(img)(_n1##x,_n3##y,z,c)), \
 (I[85] = (T)(img)(_n1##x,_n4##y,z,c)), \
 (I[95] = (T)(img)(_n1##x,_n5##y,z,c)), \
 (I[6] = (T)(img)(_n2##x,_p4##y,z,c)), \
 (I[16] = (T)(img)(_n2##x,_p3##y,z,c)), \
 (I[26] = (T)(img)(_n2##x,_p2##y,z,c)), \
 (I[36] = (T)(img)(_n2##x,_p1##y,z,c)), \
 (I[46] = (T)(img)(_n2##x,y,z,c)), \
 (I[56] = (T)(img)(_n2##x,_n1##y,z,c)), \
 (I[66] = (T)(img)(_n2##x,_n2##y,z,c)), \
 (I[76] = (T)(img)(_n2##x,_n3##y,z,c)), \
 (I[86] = (T)(img)(_n2##x,_n4##y,z,c)), \
 (I[96] = (T)(img)(_n2##x,_n5##y,z,c)), \
 (I[7] = (T)(img)(_n3##x,_p4##y,z,c)), \
 (I[17] = (T)(img)(_n3##x,_p3##y,z,c)), \
 (I[27] = (T)(img)(_n3##x,_p2##y,z,c)), \
 (I[37] = (T)(img)(_n3##x,_p1##y,z,c)), \
 (I[47] = (T)(img)(_n3##x,y,z,c)), \
 (I[57] = (T)(img)(_n3##x,_n1##y,z,c)), \
 (I[67] = (T)(img)(_n3##x,_n2##y,z,c)), \
 (I[77] = (T)(img)(_n3##x,_n3##y,z,c)), \
 (I[87] = (T)(img)(_n3##x,_n4##y,z,c)), \
 (I[97] = (T)(img)(_n3##x,_n5##y,z,c)), \
 (I[8] = (T)(img)(_n4##x,_p4##y,z,c)), \
 (I[18] = (T)(img)(_n4##x,_p3##y,z,c)), \
 (I[28] = (T)(img)(_n4##x,_p2##y,z,c)), \
 (I[38] = (T)(img)(_n4##x,_p1##y,z,c)), \
 (I[48] = (T)(img)(_n4##x,y,z,c)), \
 (I[58] = (T)(img)(_n4##x,_n1##y,z,c)), \
 (I[68] = (T)(img)(_n4##x,_n2##y,z,c)), \
 (I[78] = (T)(img)(_n4##x,_n3##y,z,c)), \
 (I[88] = (T)(img)(_n4##x,_n4##y,z,c)), \
 (I[98] = (T)(img)(_n4##x,_n5##y,z,c)), \
 x+5>=(img).width()?(img).width()-1:x+5); \
 x<=(int)(x1) && ((_n5##x<(img).width() && ( \
 (I[9] = (T)(img)(_n5##x,_p4##y,z,c)), \
 (I[19] = (T)(img)(_n5##x,_p3##y,z,c)), \
 (I[29] = (T)(img)(_n5##x,_p2##y,z,c)), \
 (I[39] = (T)(img)(_n5##x,_p1##y,z,c)), \
 (I[49] = (T)(img)(_n5##x,y,z,c)), \
 (I[59] = (T)(img)(_n5##x,_n1##y,z,c)), \
 (I[69] = (T)(img)(_n5##x,_n2##y,z,c)), \
 (I[79] = (T)(img)(_n5##x,_n3##y,z,c)), \
 (I[89] = (T)(img)(_n5##x,_n4##y,z,c)), \
 (I[99] = (T)(img)(_n5##x,_n5##y,z,c)),1)) || \
 _n4##x==--_n5##x || _n3##x==--_n4##x || _n2##x==--_n3##x || _n1##x==--_n2##x || x==(_n5##x = _n4##x = _n3##x = _n2##x = --_n1##x)); \
 I[0] = I[1], I[1] = I[2], I[2] = I[3], I[3] = I[4], I[4] = I[5], I[5] = I[6], I[6] = I[7], I[7] = I[8], I[8] = I[9], \
 I[10] = I[11], I[11] = I[12], I[12] = I[13], I[13] = I[14], I[14] = I[15], I[15] = I[16], I[16] = I[17], I[17] = I[18], I[18] = I[19], \
 I[20] = I[21], I[21] = I[22], I[22] = I[23], I[23] = I[24], I[24] = I[25], I[25] = I[26], I[26] = I[27], I[27] = I[28], I[28] = I[29], \
 I[30] = I[31], I[31] = I[32], I[32] = I[33], I[33] = I[34], I[34] = I[35], I[35] = I[36], I[36] = I[37], I[37] = I[38], I[38] = I[39], \
 I[40] = I[41], I[41] = I[42], I[42] = I[43], I[43] = I[44], I[44] = I[45], I[45] = I[46], I[46] = I[47], I[47] = I[48], I[48] = I[49], \
 I[50] = I[51], I[51] = I[52], I[52] = I[53], I[53] = I[54], I[54] = I[55], I[55] = I[56], I[56] = I[57], I[57] = I[58], I[58] = I[59], \
 I[60] = I[61], I[61] = I[62], I[62] = I[63], I[63] = I[64], I[64] = I[65], I[65] = I[66], I[66] = I[67], I[67] = I[68], I[68] = I[69], \
 I[70] = I[71], I[71] = I[72], I[72] = I[73], I[73] = I[74], I[74] = I[75], I[75] = I[76], I[76] = I[77], I[77] = I[78], I[78] = I[79], \
 I[80] = I[81], I[81] = I[82], I[82] = I[83], I[83] = I[84], I[84] = I[85], I[85] = I[86], I[86] = I[87], I[87] = I[88], I[88] = I[89], \
 I[90] = I[91], I[91] = I[92], I[92] = I[93], I[93] = I[94], I[94] = I[95], I[95] = I[96], I[96] = I[97], I[97] = I[98], I[98] = I[99], \
 _p4##x = _p3##x, _p3##x = _p2##x, _p2##x = _p1##x, _p1##x = x++, ++_n1##x, ++_n2##x, ++_n3##x, ++_n4##x, ++_n5##x)

#define cimg_get10x10(img,x,y,z,c,I,T) \
 I[0] = (T)(img)(_p4##x,_p4##y,z,c), I[1] = (T)(img)(_p3##x,_p4##y,z,c), I[2] = (T)(img)(_p2##x,_p4##y,z,c), I[3] = (T)(img)(_p1##x,_p4##y,z,c), I[4] = (T)(img)(x,_p4##y,z,c), I[5] = (T)(img)(_n1##x,_p4##y,z,c), I[6] = (T)(img)(_n2##x,_p4##y,z,c), I[7] = (T)(img)(_n3##x,_p4##y,z,c), I[8] = (T)(img)(_n4##x,_p4##y,z,c), I[9] = (T)(img)(_n5##x,_p4##y,z,c), \
 I[10] = (T)(img)(_p4##x,_p3##y,z,c), I[11] = (T)(img)(_p3##x,_p3##y,z,c), I[12] = (T)(img)(_p2##x,_p3##y,z,c), I[13] = (T)(img)(_p1##x,_p3##y,z,c), I[14] = (T)(img)(x,_p3##y,z,c), I[15] = (T)(img)(_n1##x,_p3##y,z,c), I[16] = (T)(img)(_n2##x,_p3##y,z,c), I[17] = (T)(img)(_n3##x,_p3##y,z,c), I[18] = (T)(img)(_n4##x,_p3##y,z,c), I[19] = (T)(img)(_n5##x,_p3##y,z,c), \
 I[20] = (T)(img)(_p4##x,_p2##y,z,c), I[21] = (T)(img)(_p3##x,_p2##y,z,c), I[22] = (T)(img)(_p2##x,_p2##y,z,c), I[23] = (T)(img)(_p1##x,_p2##y,z,c), I[24] = (T)(img)(x,_p2##y,z,c), I[25] = (T)(img)(_n1##x,_p2##y,z,c), I[26] = (T)(img)(_n2##x,_p2##y,z,c), I[27] = (T)(img)(_n3##x,_p2##y,z,c), I[28] = (T)(img)(_n4##x,_p2##y,z,c), I[29] = (T)(img)(_n5##x,_p2##y,z,c), \
 I[30] = (T)(img)(_p4##x,_p1##y,z,c), I[31] = (T)(img)(_p3##x,_p1##y,z,c), I[32] = (T)(img)(_p2##x,_p1##y,z,c), I[33] = (T)(img)(_p1##x,_p1##y,z,c), I[34] = (T)(img)(x,_p1##y,z,c), I[35] = (T)(img)(_n1##x,_p1##y,z,c), I[36] = (T)(img)(_n2##x,_p1##y,z,c), I[37] = (T)(img)(_n3##x,_p1##y,z,c), I[38] = (T)(img)(_n4##x,_p1##y,z,c), I[39] = (T)(img)(_n5##x,_p1##y,z,c), \
 I[40] = (T)(img)(_p4##x,y,z,c), I[41] = (T)(img)(_p3##x,y,z,c), I[42] = (T)(img)(_p2##x,y,z,c), I[43] = (T)(img)(_p1##x,y,z,c), I[44] = (T)(img)(x,y,z,c), I[45] = (T)(img)(_n1##x,y,z,c), I[46] = (T)(img)(_n2##x,y,z,c), I[47] = (T)(img)(_n3##x,y,z,c), I[48] = (T)(img)(_n4##x,y,z,c), I[49] = (T)(img)(_n5##x,y,z,c), \
 I[50] = (T)(img)(_p4##x,_n1##y,z,c), I[51] = (T)(img)(_p3##x,_n1##y,z,c), I[52] = (T)(img)(_p2##x,_n1##y,z,c), I[53] = (T)(img)(_p1##x,_n1##y,z,c), I[54] = (T)(img)(x,_n1##y,z,c), I[55] = (T)(img)(_n1##x,_n1##y,z,c), I[56] = (T)(img)(_n2##x,_n1##y,z,c), I[57] = (T)(img)(_n3##x,_n1##y,z,c), I[58] = (T)(img)(_n4##x,_n1##y,z,c), I[59] = (T)(img)(_n5##x,_n1##y,z,c), \
 I[60] = (T)(img)(_p4##x,_n2##y,z,c), I[61] = (T)(img)(_p3##x,_n2##y,z,c), I[62] = (T)(img)(_p2##x,_n2##y,z,c), I[63] = (T)(img)(_p1##x,_n2##y,z,c), I[64] = (T)(img)(x,_n2##y,z,c), I[65] = (T)(img)(_n1##x,_n2##y,z,c), I[66] = (T)(img)(_n2##x,_n2##y,z,c), I[67] = (T)(img)(_n3##x,_n2##y,z,c), I[68] = (T)(img)(_n4##x,_n2##y,z,c), I[69] = (T)(img)(_n5##x,_n2##y,z,c), \
 I[70] = (T)(img)(_p4##x,_n3##y,z,c), I[71] = (T)(img)(_p3##x,_n3##y,z,c), I[72] = (T)(img)(_p2##x,_n3##y,z,c), I[73] = (T)(img)(_p1##x,_n3##y,z,c), I[74] = (T)(img)(x,_n3##y,z,c), I[75] = (T)(img)(_n1##x,_n3##y,z,c), I[76] = (T)(img)(_n2##x,_n3##y,z,c), I[77] = (T)(img)(_n3##x,_n3##y,z,c), I[78] = (T)(img)(_n4##x,_n3##y,z,c), I[79] = (T)(img)(_n5##x,_n3##y,z,c), \
 I[80] = (T)(img)(_p4##x,_n4##y,z,c), I[81] = (T)(img)(_p3##x,_n4##y,z,c), I[82] = (T)(img)(_p2##x,_n4##y,z,c), I[83] = (T)(img)(_p1##x,_n4##y,z,c), I[84] = (T)(img)(x,_n4##y,z,c), I[85] = (T)(img)(_n1##x,_n4##y,z,c), I[86] = (T)(img)(_n2##x,_n4##y,z,c), I[87] = (T)(img)(_n3##x,_n4##y,z,c), I[88] = (T)(img)(_n4##x,_n4##y,z,c), I[89] = (T)(img)(_n5##x,_n4##y,z,c), \
 I[90] = (T)(img)(_p4##x,_n5##y,z,c), I[91] = (T)(img)(_p3##x,_n5##y,z,c), I[92] = (T)(img)(_p2##x,_n5##y,z,c), I[93] = (T)(img)(_p1##x,_n5##y,z,c), I[94] = (T)(img)(x,_n5##y,z,c), I[95] = (T)(img)(_n1##x,_n5##y,z,c), I[96] = (T)(img)(_n2##x,_n5##y,z,c), I[97] = (T)(img)(_n3##x,_n5##y,z,c), I[98] = (T)(img)(_n4##x,_n5##y,z,c), I[99] = (T)(img)(_n5##x,_n5##y,z,c);

// Define 11x11 loop macros
//-------------------------
#define cimg_for11(bound,i) for (int i = 0, \
 _p5##i = 0, _p4##i = 0, _p3##i = 0, _p2##i = 0, _p1##i = 0, \
 _n1##i = 1>=(int)(bound)?(int)(bound)-1:1, \
 _n2##i = 2>=(int)(bound)?(int)(bound)-1:2, \
 _n3##i = 3>=(int)(bound)?(int)(bound)-1:3, \
 _n4##i = 4>=(int)(bound)?(int)(bound)-1:4, \
 _n5##i = 5>=(int)(bound)?(int)(bound)-1:5; \
 _n5##i<(int)(bound) || _n4##i==--_n5##i || _n3##i==--_n4##i || _n2##i==--_n3##i || _n1##i==--_n2##i || \
 i==(_n5##i = _n4##i = _n3##i = _n2##i = --_n1##i); \
 _p5##i = _p4##i, _p4##i = _p3##i, _p3##i = _p2##i, _p2##i = _p1##i, _p1##i = i++, \
 ++_n1##i, ++_n2##i, ++_n3##i, ++_n4##i, ++_n5##i)

#define cimg_for11X(img,x) cimg_for11((img)._width,x)
#define cimg_for11Y(img,y) cimg_for11((img)._height,y)
#define cimg_for11Z(img,z) cimg_for11((img)._depth,z)
#define cimg_for11C(img,c) cimg_for11((img)._spectrum,c)
#define cimg_for11XY(img,x,y) cimg_for11Y(img,y) cimg_for11X(img,x)
#define cimg_for11XZ(img,x,z) cimg_for11Z(img,z) cimg_for11X(img,x)
#define cimg_for11XC(img,x,c) cimg_for11C(img,c) cimg_for11X(img,x)
#define cimg_for11YZ(img,y,z) cimg_for11Z(img,z) cimg_for11Y(img,y)
#define cimg_for11YC(img,y,c) cimg_for11C(img,c) cimg_for11Y(img,y)
#define cimg_for11ZC(img,z,c) cimg_for11C(img,c) cimg_for11Z(img,z)
#define cimg_for11XYZ(img,x,y,z) cimg_for11Z(img,z) cimg_for11XY(img,x,y)
#define cimg_for11XZC(img,x,z,c) cimg_for11C(img,c) cimg_for11XZ(img,x,z)
#define cimg_for11YZC(img,y,z,c) cimg_for11C(img,c) cimg_for11YZ(img,y,z)
#define cimg_for11XYZC(img,x,y,z,c) cimg_for11C(img,c) cimg_for11XYZ(img,x,y,z)

#define cimg_for_in11(bound,i0,i1,i) for (int i = (int)(i0)<0?0:(int)(i0), \
 _p5##i = i-5<0?0:i-5, \
 _p4##i = i-4<0?0:i-4, \
 _p3##i = i-3<0?0:i-3, \
 _p2##i = i-2<0?0:i-2, \
 _p1##i = i-1<0?0:i-1, \
 _n1##i = i+1>=(int)(bound)?(int)(bound)-1:i+1, \
 _n2##i = i+2>=(int)(bound)?(int)(bound)-1:i+2, \
 _n3##i = i+3>=(int)(bound)?(int)(bound)-1:i+3, \
 _n4##i = i+4>=(int)(bound)?(int)(bound)-1:i+4, \
 _n5##i = i+5>=(int)(bound)?(int)(bound)-1:i+5; \
 i<=(int)(i1) && (_n5##i<(int)(bound) || _n4##i==--_n5##i || _n3##i==--_n4##i || _n2##i==--_n3##i || _n1##i==--_n2##i || \
 i==(_n5##i = _n4##i = _n3##i = _n2##i = --_n1##i)); \
 _p5##i = _p4##i, _p4##i = _p3##i, _p3##i = _p2##i, _p2##i = _p1##i, _p1##i = i++, \
 ++_n1##i, ++_n2##i, ++_n3##i, ++_n4##i, ++_n5##i)

#define cimg_for_in11X(img,x0,x1,x) cimg_for_in11((img)._width,x0,x1,x)
#define cimg_for_in11Y(img,y0,y1,y) cimg_for_in11((img)._height,y0,y1,y)
#define cimg_for_in11Z(img,z0,z1,z) cimg_for_in11((img)._depth,z0,z1,z)
#define cimg_for_in11C(img,c0,c1,c) cimg_for_in11((img)._spectrum,c0,c1,c)
#define cimg_for_in11XY(img,x0,y0,x1,y1,x,y) cimg_for_in11Y(img,y0,y1,y) cimg_for_in11X(img,x0,x1,x)
#define cimg_for_in11XZ(img,x0,z0,x1,z1,x,z) cimg_for_in11Z(img,z0,z1,z) cimg_for_in11X(img,x0,x1,x)
#define cimg_for_in11XC(img,x0,c0,x1,c1,x,c) cimg_for_in11C(img,c0,c1,c) cimg_for_in11X(img,x0,x1,x)
#define cimg_for_in11YZ(img,y0,z0,y1,z1,y,z) cimg_for_in11Z(img,z0,z1,z) cimg_for_in11Y(img,y0,y1,y)
#define cimg_for_in11YC(img,y0,c0,y1,c1,y,c) cimg_for_in11C(img,c0,c1,c) cimg_for_in11Y(img,y0,y1,y)
#define cimg_for_in11ZC(img,z0,c0,z1,c1,z,c) cimg_for_in11C(img,c0,c1,c) cimg_for_in11Z(img,z0,z1,z)
#define cimg_for_in11XYZ(img,x0,y0,z0,x1,y1,z1,x,y,z) cimg_for_in11Z(img,z0,z1,z) cimg_for_in11XY(img,x0,y0,x1,y1,x,y)
#define cimg_for_in11XZC(img,x0,z0,c0,x1,y1,c1,x,z,c) cimg_for_in11C(img,c0,c1,c) cimg_for_in11XZ(img,x0,y0,x1,y1,x,z)
#define cimg_for_in11YZC(img,y0,z0,c0,y1,z1,c1,y,z,c) cimg_for_in11C(img,c0,c1,c) cimg_for_in11YZ(img,y0,z0,y1,z1,y,z)
#define cimg_for_in11XYZC(img,x0,y0,z0,c0,x1,y1,z1,c1,x,y,z,c) cimg_for_in11C(img,c0,c1,c) cimg_for_in11XYZ(img,x0,y0,z0,x1,y1,z1,x,y,z)

#define cimg_for11x11(img,x,y,z,c,I,T) \
 cimg_for11((img)._height,y) for (int x = 0, \
 _p5##x = 0, _p4##x = 0, _p3##x = 0, _p2##x = 0, _p1##x = 0, \
 _n1##x = 1>=((img)._width)?(img).width()-1:1, \
 _n2##x = 2>=((img)._width)?(img).width()-1:2, \
 _n3##x = 3>=((img)._width)?(img).width()-1:3, \
 _n4##x = 4>=((img)._width)?(img).width()-1:4, \
 _n5##x = (int)( \
 (I[0] = I[1] = I[2] = I[3] = I[4] = I[5] = (T)(img)(0,_p5##y,z,c)), \
 (I[11] = I[12] = I[13] = I[14] = I[15] = I[16] = (T)(img)(0,_p4##y,z,c)), \
 (I[22] = I[23] = I[24] = I[25] = I[26] = I[27] = (T)(img)(0,_p3##y,z,c)), \
 (I[33] = I[34] = I[35] = I[36] = I[37] = I[38] = (T)(img)(0,_p2##y,z,c)), \
 (I[44] = I[45] = I[46] = I[47] = I[48] = I[49] = (T)(img)(0,_p1##y,z,c)), \
 (I[55] = I[56] = I[57] = I[58] = I[59] = I[60] = (T)(img)(0,y,z,c)), \
 (I[66] = I[67] = I[68] = I[69] = I[70] = I[71] = (T)(img)(0,_n1##y,z,c)), \
 (I[77] = I[78] = I[79] = I[80] = I[81] = I[82] = (T)(img)(0,_n2##y,z,c)), \
 (I[88] = I[89] = I[90] = I[91] = I[92] = I[93] = (T)(img)(0,_n3##y,z,c)), \
 (I[99] = I[100] = I[101] = I[102] = I[103] = I[104] = (T)(img)(0,_n4##y,z,c)), \
 (I[110] = I[111] = I[112] = I[113] = I[114] = I[115] = (T)(img)(0,_n5##y,z,c)), \
 (I[6] = (T)(img)(_n1##x,_p5##y,z,c)), \
 (I[17] = (T)(img)(_n1##x,_p4##y,z,c)), \
 (I[28] = (T)(img)(_n1##x,_p3##y,z,c)), \
 (I[39] = (T)(img)(_n1##x,_p2##y,z,c)), \
 (I[50] = (T)(img)(_n1##x,_p1##y,z,c)), \
 (I[61] = (T)(img)(_n1##x,y,z,c)), \
 (I[72] = (T)(img)(_n1##x,_n1##y,z,c)), \
 (I[83] = (T)(img)(_n1##x,_n2##y,z,c)), \
 (I[94] = (T)(img)(_n1##x,_n3##y,z,c)), \
 (I[105] = (T)(img)(_n1##x,_n4##y,z,c)), \
 (I[116] = (T)(img)(_n1##x,_n5##y,z,c)), \
 (I[7] = (T)(img)(_n2##x,_p5##y,z,c)), \
 (I[18] = (T)(img)(_n2##x,_p4##y,z,c)), \
 (I[29] = (T)(img)(_n2##x,_p3##y,z,c)), \
 (I[40] = (T)(img)(_n2##x,_p2##y,z,c)), \
 (I[51] = (T)(img)(_n2##x,_p1##y,z,c)), \
 (I[62] = (T)(img)(_n2##x,y,z,c)), \
 (I[73] = (T)(img)(_n2##x,_n1##y,z,c)), \
 (I[84] = (T)(img)(_n2##x,_n2##y,z,c)), \
 (I[95] = (T)(img)(_n2##x,_n3##y,z,c)), \
 (I[106] = (T)(img)(_n2##x,_n4##y,z,c)), \
 (I[117] = (T)(img)(_n2##x,_n5##y,z,c)), \
 (I[8] = (T)(img)(_n3##x,_p5##y,z,c)), \
 (I[19] = (T)(img)(_n3##x,_p4##y,z,c)), \
 (I[30] = (T)(img)(_n3##x,_p3##y,z,c)), \
 (I[41] = (T)(img)(_n3##x,_p2##y,z,c)), \
 (I[52] = (T)(img)(_n3##x,_p1##y,z,c)), \
 (I[63] = (T)(img)(_n3##x,y,z,c)), \
 (I[74] = (T)(img)(_n3##x,_n1##y,z,c)), \
 (I[85] = (T)(img)(_n3##x,_n2##y,z,c)), \
 (I[96] = (T)(img)(_n3##x,_n3##y,z,c)), \
 (I[107] = (T)(img)(_n3##x,_n4##y,z,c)), \
 (I[118] = (T)(img)(_n3##x,_n5##y,z,c)), \
 (I[9] = (T)(img)(_n4##x,_p5##y,z,c)), \
 (I[20] = (T)(img)(_n4##x,_p4##y,z,c)), \
 (I[31] = (T)(img)(_n4##x,_p3##y,z,c)), \
 (I[42] = (T)(img)(_n4##x,_p2##y,z,c)), \
 (I[53] = (T)(img)(_n4##x,_p1##y,z,c)), \
 (I[64] = (T)(img)(_n4##x,y,z,c)), \
 (I[75] = (T)(img)(_n4##x,_n1##y,z,c)), \
 (I[86] = (T)(img)(_n4##x,_n2##y,z,c)), \
 (I[97] = (T)(img)(_n4##x,_n3##y,z,c)), \
 (I[108] = (T)(img)(_n4##x,_n4##y,z,c)), \
 (I[119] = (T)(img)(_n4##x,_n5##y,z,c)), \
 5>=((img)._width)?(img).width()-1:5); \
 (_n5##x<(img).width() && ( \
 (I[10] = (T)(img)(_n5##x,_p5##y,z,c)), \
 (I[21] = (T)(img)(_n5##x,_p4##y,z,c)), \
 (I[32] = (T)(img)(_n5##x,_p3##y,z,c)), \
 (I[43] = (T)(img)(_n5##x,_p2##y,z,c)), \
 (I[54] = (T)(img)(_n5##x,_p1##y,z,c)), \
 (I[65] = (T)(img)(_n5##x,y,z,c)), \
 (I[76] = (T)(img)(_n5##x,_n1##y,z,c)), \
 (I[87] = (T)(img)(_n5##x,_n2##y,z,c)), \
 (I[98] = (T)(img)(_n5##x,_n3##y,z,c)), \
 (I[109] = (T)(img)(_n5##x,_n4##y,z,c)), \
 (I[120] = (T)(img)(_n5##x,_n5##y,z,c)),1)) || \
 _n4##x==--_n5##x || _n3##x==--_n4##x || _n2##x==--_n3##x || _n1##x==--_n2##x || x==(_n5##x = _n4##x = _n3##x = _n2##x = --_n1##x); \
 I[0] = I[1], I[1] = I[2], I[2] = I[3], I[3] = I[4], I[4] = I[5], I[5] = I[6], I[6] = I[7], I[7] = I[8], I[8] = I[9], I[9] = I[10], \
 I[11] = I[12], I[12] = I[13], I[13] = I[14], I[14] = I[15], I[15] = I[16], I[16] = I[17], I[17] = I[18], I[18] = I[19], I[19] = I[20], I[20] = I[21], \
 I[22] = I[23], I[23] = I[24], I[24] = I[25], I[25] = I[26], I[26] = I[27], I[27] = I[28], I[28] = I[29], I[29] = I[30], I[30] = I[31], I[31] = I[32], \
 I[33] = I[34], I[34] = I[35], I[35] = I[36], I[36] = I[37], I[37] = I[38], I[38] = I[39], I[39] = I[40], I[40] = I[41], I[41] = I[42], I[42] = I[43], \
 I[44] = I[45], I[45] = I[46], I[46] = I[47], I[47] = I[48], I[48] = I[49], I[49] = I[50], I[50] = I[51], I[51] = I[52], I[52] = I[53], I[53] = I[54], \
 I[55] = I[56], I[56] = I[57], I[57] = I[58], I[58] = I[59], I[59] = I[60], I[60] = I[61], I[61] = I[62], I[62] = I[63], I[63] = I[64], I[64] = I[65], \
 I[66] = I[67], I[67] = I[68], I[68] = I[69], I[69] = I[70], I[70] = I[71], I[71] = I[72], I[72] = I[73], I[73] = I[74], I[74] = I[75], I[75] = I[76], \
 I[77] = I[78], I[78] = I[79], I[79] = I[80], I[80] = I[81], I[81] = I[82], I[82] = I[83], I[83] = I[84], I[84] = I[85], I[85] = I[86], I[86] = I[87], \
 I[88] = I[89], I[89] = I[90], I[90] = I[91], I[91] = I[92], I[92] = I[93], I[93] = I[94], I[94] = I[95], I[95] = I[96], I[96] = I[97], I[97] = I[98], \
 I[99] = I[100], I[100] = I[101], I[101] = I[102], I[102] = I[103], I[103] = I[104], I[104] = I[105], I[105] = I[106], I[106] = I[107], I[107] = I[108], I[108] = I[109], \
 I[110] = I[111], I[111] = I[112], I[112] = I[113], I[113] = I[114], I[114] = I[115], I[115] = I[116], I[116] = I[117], I[117] = I[118], I[118] = I[119], I[119] = I[120], \
 _p5##x = _p4##x, _p4##x = _p3##x, _p3##x = _p2##x, _p2##x = _p1##x, _p1##x = x++, ++_n1##x, ++_n2##x, ++_n3##x, ++_n4##x, ++_n5##x)

#define cimg_for_in11x11(img,x0,y0,x1,y1,x,y,z,c,I,T) \
 cimg_for_in11((img)._height,y0,y1,y) for (int x = (int)(x0)<0?0:(int)(x0), \
 _p5##x = x-5<0?0:x-5, \
 _p4##x = x-4<0?0:x-4, \
 _p3##x = x-3<0?0:x-3, \
 _p2##x = x-2<0?0:x-2, \
 _p1##x = x-1<0?0:x-1, \
 _n1##x = x+1>=(img).width()?(img).width()-1:x+1, \
 _n2##x = x+2>=(img).width()?(img).width()-1:x+2, \
 _n3##x = x+3>=(img).width()?(img).width()-1:x+3, \
 _n4##x = x+4>=(img).width()?(img).width()-1:x+4, \
 _n5##x = (int)( \
 (I[0] = (T)(img)(_p5##x,_p5##y,z,c)), \
 (I[11] = (T)(img)(_p5##x,_p4##y,z,c)), \
 (I[22] = (T)(img)(_p5##x,_p3##y,z,c)), \
 (I[33] = (T)(img)(_p5##x,_p2##y,z,c)), \
 (I[44] = (T)(img)(_p5##x,_p1##y,z,c)), \
 (I[55] = (T)(img)(_p5##x,y,z,c)), \
 (I[66] = (T)(img)(_p5##x,_n1##y,z,c)), \
 (I[77] = (T)(img)(_p5##x,_n2##y,z,c)), \
 (I[88] = (T)(img)(_p5##x,_n3##y,z,c)), \
 (I[99] = (T)(img)(_p5##x,_n4##y,z,c)), \
 (I[110] = (T)(img)(_p5##x,_n5##y,z,c)), \
 (I[1] = (T)(img)(_p4##x,_p5##y,z,c)), \
 (I[12] = (T)(img)(_p4##x,_p4##y,z,c)), \
 (I[23] = (T)(img)(_p4##x,_p3##y,z,c)), \
 (I[34] = (T)(img)(_p4##x,_p2##y,z,c)), \
 (I[45] = (T)(img)(_p4##x,_p1##y,z,c)), \
 (I[56] = (T)(img)(_p4##x,y,z,c)), \
 (I[67] = (T)(img)(_p4##x,_n1##y,z,c)), \
 (I[78] = (T)(img)(_p4##x,_n2##y,z,c)), \
 (I[89] = (T)(img)(_p4##x,_n3##y,z,c)), \
 (I[100] = (T)(img)(_p4##x,_n4##y,z,c)), \
 (I[111] = (T)(img)(_p4##x,_n5##y,z,c)), \
 (I[2] = (T)(img)(_p3##x,_p5##y,z,c)), \
 (I[13] = (T)(img)(_p3##x,_p4##y,z,c)), \
 (I[24] = (T)(img)(_p3##x,_p3##y,z,c)), \
 (I[35] = (T)(img)(_p3##x,_p2##y,z,c)), \
 (I[46] = (T)(img)(_p3##x,_p1##y,z,c)), \
 (I[57] = (T)(img)(_p3##x,y,z,c)), \
 (I[68] = (T)(img)(_p3##x,_n1##y,z,c)), \
 (I[79] = (T)(img)(_p3##x,_n2##y,z,c)), \
 (I[90] = (T)(img)(_p3##x,_n3##y,z,c)), \
 (I[101] = (T)(img)(_p3##x,_n4##y,z,c)), \
 (I[112] = (T)(img)(_p3##x,_n5##y,z,c)), \
 (I[3] = (T)(img)(_p2##x,_p5##y,z,c)), \
 (I[14] = (T)(img)(_p2##x,_p4##y,z,c)), \
 (I[25] = (T)(img)(_p2##x,_p3##y,z,c)), \
 (I[36] = (T)(img)(_p2##x,_p2##y,z,c)), \
 (I[47] = (T)(img)(_p2##x,_p1##y,z,c)), \
 (I[58] = (T)(img)(_p2##x,y,z,c)), \
 (I[69] = (T)(img)(_p2##x,_n1##y,z,c)), \
 (I[80] = (T)(img)(_p2##x,_n2##y,z,c)), \
 (I[91] = (T)(img)(_p2##x,_n3##y,z,c)), \
 (I[102] = (T)(img)(_p2##x,_n4##y,z,c)), \
 (I[113] = (T)(img)(_p2##x,_n5##y,z,c)), \
 (I[4] = (T)(img)(_p1##x,_p5##y,z,c)), \
 (I[15] = (T)(img)(_p1##x,_p4##y,z,c)), \
 (I[26] = (T)(img)(_p1##x,_p3##y,z,c)), \
 (I[37] = (T)(img)(_p1##x,_p2##y,z,c)), \
 (I[48] = (T)(img)(_p1##x,_p1##y,z,c)), \
 (I[59] = (T)(img)(_p1##x,y,z,c)), \
 (I[70] = (T)(img)(_p1##x,_n1##y,z,c)), \
 (I[81] = (T)(img)(_p1##x,_n2##y,z,c)), \
 (I[92] = (T)(img)(_p1##x,_n3##y,z,c)), \
 (I[103] = (T)(img)(_p1##x,_n4##y,z,c)), \
 (I[114] = (T)(img)(_p1##x,_n5##y,z,c)), \
 (I[5] = (T)(img)(x,_p5##y,z,c)), \
 (I[16] = (T)(img)(x,_p4##y,z,c)), \
 (I[27] = (T)(img)(x,_p3##y,z,c)), \
 (I[38] = (T)(img)(x,_p2##y,z,c)), \
 (I[49] = (T)(img)(x,_p1##y,z,c)), \
 (I[60] = (T)(img)(x,y,z,c)), \
 (I[71] = (T)(img)(x,_n1##y,z,c)), \
 (I[82] = (T)(img)(x,_n2##y,z,c)), \
 (I[93] = (T)(img)(x,_n3##y,z,c)), \
 (I[104] = (T)(img)(x,_n4##y,z,c)), \
 (I[115] = (T)(img)(x,_n5##y,z,c)), \
 (I[6] = (T)(img)(_n1##x,_p5##y,z,c)), \
 (I[17] = (T)(img)(_n1##x,_p4##y,z,c)), \
 (I[28] = (T)(img)(_n1##x,_p3##y,z,c)), \
 (I[39] = (T)(img)(_n1##x,_p2##y,z,c)), \
 (I[50] = (T)(img)(_n1##x,_p1##y,z,c)), \
 (I[61] = (T)(img)(_n1##x,y,z,c)), \
 (I[72] = (T)(img)(_n1##x,_n1##y,z,c)), \
 (I[83] = (T)(img)(_n1##x,_n2##y,z,c)), \
 (I[94] = (T)(img)(_n1##x,_n3##y,z,c)), \
 (I[105] = (T)(img)(_n1##x,_n4##y,z,c)), \
 (I[116] = (T)(img)(_n1##x,_n5##y,z,c)), \
 (I[7] = (T)(img)(_n2##x,_p5##y,z,c)), \
 (I[18] = (T)(img)(_n2##x,_p4##y,z,c)), \
 (I[29] = (T)(img)(_n2##x,_p3##y,z,c)), \
 (I[40] = (T)(img)(_n2##x,_p2##y,z,c)), \
 (I[51] = (T)(img)(_n2##x,_p1##y,z,c)), \
 (I[62] = (T)(img)(_n2##x,y,z,c)), \
 (I[73] = (T)(img)(_n2##x,_n1##y,z,c)), \
 (I[84] = (T)(img)(_n2##x,_n2##y,z,c)), \
 (I[95] = (T)(img)(_n2##x,_n3##y,z,c)), \
 (I[106] = (T)(img)(_n2##x,_n4##y,z,c)), \
 (I[117] = (T)(img)(_n2##x,_n5##y,z,c)), \
 (I[8] = (T)(img)(_n3##x,_p5##y,z,c)), \
 (I[19] = (T)(img)(_n3##x,_p4##y,z,c)), \
 (I[30] = (T)(img)(_n3##x,_p3##y,z,c)), \
 (I[41] = (T)(img)(_n3##x,_p2##y,z,c)), \
 (I[52] = (T)(img)(_n3##x,_p1##y,z,c)), \
 (I[63] = (T)(img)(_n3##x,y,z,c)), \
 (I[74] = (T)(img)(_n3##x,_n1##y,z,c)), \
 (I[85] = (T)(img)(_n3##x,_n2##y,z,c)), \
 (I[96] = (T)(img)(_n3##x,_n3##y,z,c)), \
 (I[107] = (T)(img)(_n3##x,_n4##y,z,c)), \
 (I[118] = (T)(img)(_n3##x,_n5##y,z,c)), \
 (I[9] = (T)(img)(_n4##x,_p5##y,z,c)), \
 (I[20] = (T)(img)(_n4##x,_p4##y,z,c)), \
 (I[31] = (T)(img)(_n4##x,_p3##y,z,c)), \
 (I[42] = (T)(img)(_n4##x,_p2##y,z,c)), \
 (I[53] = (T)(img)(_n4##x,_p1##y,z,c)), \
 (I[64] = (T)(img)(_n4##x,y,z,c)), \
 (I[75] = (T)(img)(_n4##x,_n1##y,z,c)), \
 (I[86] = (T)(img)(_n4##x,_n2##y,z,c)), \
 (I[97] = (T)(img)(_n4##x,_n3##y,z,c)), \
 (I[108] = (T)(img)(_n4##x,_n4##y,z,c)), \
 (I[119] = (T)(img)(_n4##x,_n5##y,z,c)), \
 x+5>=(img).width()?(img).width()-1:x+5); \
 x<=(int)(x1) && ((_n5##x<(img).width() && ( \
 (I[10] = (T)(img)(_n5##x,_p5##y,z,c)), \
 (I[21] = (T)(img)(_n5##x,_p4##y,z,c)), \
 (I[32] = (T)(img)(_n5##x,_p3##y,z,c)), \
 (I[43] = (T)(img)(_n5##x,_p2##y,z,c)), \
 (I[54] = (T)(img)(_n5##x,_p1##y,z,c)), \
 (I[65] = (T)(img)(_n5##x,y,z,c)), \
 (I[76] = (T)(img)(_n5##x,_n1##y,z,c)), \
 (I[87] = (T)(img)(_n5##x,_n2##y,z,c)), \
 (I[98] = (T)(img)(_n5##x,_n3##y,z,c)), \
 (I[109] = (T)(img)(_n5##x,_n4##y,z,c)), \
 (I[120] = (T)(img)(_n5##x,_n5##y,z,c)),1)) || \
 _n4##x==--_n5##x || _n3##x==--_n4##x || _n2##x==--_n3##x || _n1##x==--_n2##x || x==(_n5##x = _n4##x = _n3##x = _n2##x = --_n1##x)); \
 I[0] = I[1], I[1] = I[2], I[2] = I[3], I[3] = I[4], I[4] = I[5], I[5] = I[6], I[6] = I[7], I[7] = I[8], I[8] = I[9], I[9] = I[10], \
 I[11] = I[12], I[12] = I[13], I[13] = I[14], I[14] = I[15], I[15] = I[16], I[16] = I[17], I[17] = I[18], I[18] = I[19], I[19] = I[20], I[20] = I[21], \
 I[22] = I[23], I[23] = I[24], I[24] = I[25], I[25] = I[26], I[26] = I[27], I[27] = I[28], I[28] = I[29], I[29] = I[30], I[30] = I[31], I[31] = I[32], \
 I[33] = I[34], I[34] = I[35], I[35] = I[36], I[36] = I[37], I[37] = I[38], I[38] = I[39], I[39] = I[40], I[40] = I[41], I[41] = I[42], I[42] = I[43], \
 I[44] = I[45], I[45] = I[46], I[46] = I[47], I[47] = I[48], I[48] = I[49], I[49] = I[50], I[50] = I[51], I[51] = I[52], I[52] = I[53], I[53] = I[54], \
 I[55] = I[56], I[56] = I[57], I[57] = I[58], I[58] = I[59], I[59] = I[60], I[60] = I[61], I[61] = I[62], I[62] = I[63], I[63] = I[64], I[64] = I[65], \
 I[66] = I[67], I[67] = I[68], I[68] = I[69], I[69] = I[70], I[70] = I[71], I[71] = I[72], I[72] = I[73], I[73] = I[74], I[74] = I[75], I[75] = I[76], \
 I[77] = I[78], I[78] = I[79], I[79] = I[80], I[80] = I[81], I[81] = I[82], I[82] = I[83], I[83] = I[84], I[84] = I[85], I[85] = I[86], I[86] = I[87], \
 I[88] = I[89], I[89] = I[90], I[90] = I[91], I[91] = I[92], I[92] = I[93], I[93] = I[94], I[94] = I[95], I[95] = I[96], I[96] = I[97], I[97] = I[98], \
 I[99] = I[100], I[100] = I[101], I[101] = I[102], I[102] = I[103], I[103] = I[104], I[104] = I[105], I[105] = I[106], I[106] = I[107], I[107] = I[108], I[108] = I[109], \
 I[110] = I[111], I[111] = I[112], I[112] = I[113], I[113] = I[114], I[114] = I[115], I[115] = I[116], I[116] = I[117], I[117] = I[118], I[118] = I[119], I[119] = I[120], \
 _p5##x = _p4##x, _p4##x = _p3##x, _p3##x = _p2##x, _p2##x = _p1##x, _p1##x = x++, ++_n1##x, ++_n2##x, ++_n3##x, ++_n4##x, ++_n5##x)

#define cimg_get11x11(img,x,y,z,c,I,T) \
 I[0] = (T)(img)(_p5##x,_p5##y,z,c), I[1] = (T)(img)(_p4##x,_p5##y,z,c), I[2] = (T)(img)(_p3##x,_p5##y,z,c), I[3] = (T)(img)(_p2##x,_p5##y,z,c), I[4] = (T)(img)(_p1##x,_p5##y,z,c), I[5] = (T)(img)(x,_p5##y,z,c), I[6] = (T)(img)(_n1##x,_p5##y,z,c), I[7] = (T)(img)(_n2##x,_p5##y,z,c), I[8] = (T)(img)(_n3##x,_p5##y,z,c), I[9] = (T)(img)(_n4##x,_p5##y,z,c), I[10] = (T)(img)(_n5##x,_p5##y,z,c), \
 I[11] = (T)(img)(_p5##x,_p4##y,z,c), I[12] = (T)(img)(_p4##x,_p4##y,z,c), I[13] = (T)(img)(_p3##x,_p4##y,z,c), I[14] = (T)(img)(_p2##x,_p4##y,z,c), I[15] = (T)(img)(_p1##x,_p4##y,z,c), I[16] = (T)(img)(x,_p4##y,z,c), I[17] = (T)(img)(_n1##x,_p4##y,z,c), I[18] = (T)(img)(_n2##x,_p4##y,z,c), I[19] = (T)(img)(_n3##x,_p4##y,z,c), I[20] = (T)(img)(_n4##x,_p4##y,z,c), I[21] = (T)(img)(_n5##x,_p4##y,z,c), \
 I[22] = (T)(img)(_p5##x,_p3##y,z,c), I[23] = (T)(img)(_p4##x,_p3##y,z,c), I[24] = (T)(img)(_p3##x,_p3##y,z,c), I[25] = (T)(img)(_p2##x,_p3##y,z,c), I[26] = (T)(img)(_p1##x,_p3##y,z,c), I[27] = (T)(img)(x,_p3##y,z,c), I[28] = (T)(img)(_n1##x,_p3##y,z,c), I[29] = (T)(img)(_n2##x,_p3##y,z,c), I[30] = (T)(img)(_n3##x,_p3##y,z,c), I[31] = (T)(img)(_n4##x,_p3##y,z,c), I[32] = (T)(img)(_n5##x,_p3##y,z,c), \
 I[33] = (T)(img)(_p5##x,_p2##y,z,c), I[34] = (T)(img)(_p4##x,_p2##y,z,c), I[35] = (T)(img)(_p3##x,_p2##y,z,c), I[36] = (T)(img)(_p2##x,_p2##y,z,c), I[37] = (T)(img)(_p1##x,_p2##y,z,c), I[38] = (T)(img)(x,_p2##y,z,c), I[39] = (T)(img)(_n1##x,_p2##y,z,c), I[40] = (T)(img)(_n2##x,_p2##y,z,c), I[41] = (T)(img)(_n3##x,_p2##y,z,c), I[42] = (T)(img)(_n4##x,_p2##y,z,c), I[43] = (T)(img)(_n5##x,_p2##y,z,c), \
 I[44] = (T)(img)(_p5##x,_p1##y,z,c), I[45] = (T)(img)(_p4##x,_p1##y,z,c), I[46] = (T)(img)(_p3##x,_p1##y,z,c), I[47] = (T)(img)(_p2##x,_p1##y,z,c), I[48] = (T)(img)(_p1##x,_p1##y,z,c), I[49] = (T)(img)(x,_p1##y,z,c), I[50] = (T)(img)(_n1##x,_p1##y,z,c), I[51] = (T)(img)(_n2##x,_p1##y,z,c), I[52] = (T)(img)(_n3##x,_p1##y,z,c), I[53] = (T)(img)(_n4##x,_p1##y,z,c), I[54] = (T)(img)(_n5##x,_p1##y,z,c), \
 I[55] = (T)(img)(_p5##x,y,z,c), I[56] = (T)(img)(_p4##x,y,z,c), I[57] = (T)(img)(_p3##x,y,z,c), I[58] = (T)(img)(_p2##x,y,z,c), I[59] = (T)(img)(_p1##x,y,z,c), I[60] = (T)(img)(x,y,z,c), I[61] = (T)(img)(_n1##x,y,z,c), I[62] = (T)(img)(_n2##x,y,z,c), I[63] = (T)(img)(_n3##x,y,z,c), I[64] = (T)(img)(_n4##x,y,z,c), I[65] = (T)(img)(_n5##x,y,z,c), \
 I[66] = (T)(img)(_p5##x,_n1##y,z,c), I[67] = (T)(img)(_p4##x,_n1##y,z,c), I[68] = (T)(img)(_p3##x,_n1##y,z,c), I[69] = (T)(img)(_p2##x,_n1##y,z,c), I[70] = (T)(img)(_p1##x,_n1##y,z,c), I[71] = (T)(img)(x,_n1##y,z,c), I[72] = (T)(img)(_n1##x,_n1##y,z,c), I[73] = (T)(img)(_n2##x,_n1##y,z,c), I[74] = (T)(img)(_n3##x,_n1##y,z,c), I[75] = (T)(img)(_n4##x,_n1##y,z,c), I[76] = (T)(img)(_n5##x,_n1##y,z,c), \
 I[77] = (T)(img)(_p5##x,_n2##y,z,c), I[78] = (T)(img)(_p4##x,_n2##y,z,c), I[79] = (T)(img)(_p3##x,_n2##y,z,c), I[80] = (T)(img)(_p2##x,_n2##y,z,c), I[81] = (T)(img)(_p1##x,_n2##y,z,c), I[82] = (T)(img)(x,_n2##y,z,c), I[83] = (T)(img)(_n1##x,_n2##y,z,c), I[84] = (T)(img)(_n2##x,_n2##y,z,c), I[85] = (T)(img)(_n3##x,_n2##y,z,c), I[86] = (T)(img)(_n4##x,_n2##y,z,c), I[87] = (T)(img)(_n5##x,_n2##y,z,c), \
 I[88] = (T)(img)(_p5##x,_n3##y,z,c), I[89] = (T)(img)(_p4##x,_n3##y,z,c), I[90] = (T)(img)(_p3##x,_n3##y,z,c), I[91] = (T)(img)(_p2##x,_n3##y,z,c), I[92] = (T)(img)(_p1##x,_n3##y,z,c), I[93] = (T)(img)(x,_n3##y,z,c), I[94] = (T)(img)(_n1##x,_n3##y,z,c), I[95] = (T)(img)(_n2##x,_n3##y,z,c), I[96] = (T)(img)(_n3##x,_n3##y,z,c), I[97] = (T)(img)(_n4##x,_n3##y,z,c), I[98] = (T)(img)(_n5##x,_n3##y,z,c), \
 I[99] = (T)(img)(_p5##x,_n4##y,z,c), I[100] = (T)(img)(_p4##x,_n4##y,z,c), I[101] = (T)(img)(_p3##x,_n4##y,z,c), I[102] = (T)(img)(_p2##x,_n4##y,z,c), I[103] = (T)(img)(_p1##x,_n4##y,z,c), I[104] = (T)(img)(x,_n4##y,z,c), I[105] = (T)(img)(_n1##x,_n4##y,z,c), I[106] = (T)(img)(_n2##x,_n4##y,z,c), I[107] = (T)(img)(_n3##x,_n4##y,z,c), I[108] = (T)(img)(_n4##x,_n4##y,z,c), I[109] = (T)(img)(_n5##x,_n4##y,z,c), \
 I[110] = (T)(img)(_p5##x,_n5##y,z,c), I[111] = (T)(img)(_p4##x,_n5##y,z,c), I[112] = (T)(img)(_p3##x,_n5##y,z,c), I[113] = (T)(img)(_p2##x,_n5##y,z,c), I[114] = (T)(img)(_p1##x,_n5##y,z,c), I[115] = (T)(img)(x,_n5##y,z,c), I[116] = (T)(img)(_n1##x,_n5##y,z,c), I[117] = (T)(img)(_n2##x,_n5##y,z,c), I[118] = (T)(img)(_n3##x,_n5##y,z,c), I[119] = (T)(img)(_n4##x,_n5##y,z,c), I[120] = (T)(img)(_n5##x,_n5##y,z,c);

// Define 12x12 loop macros
//-------------------------
#define cimg_for12(bound,i) for (int i = 0, \
 _p5##i = 0, _p4##i = 0, _p3##i = 0, _p2##i = 0, _p1##i = 0, \
 _n1##i = 1>=(int)(bound)?(int)(bound)-1:1, \
 _n2##i = 2>=(int)(bound)?(int)(bound)-1:2, \
 _n3##i = 3>=(int)(bound)?(int)(bound)-1:3, \
 _n4##i = 4>=(int)(bound)?(int)(bound)-1:4, \
 _n5##i = 5>=(int)(bound)?(int)(bound)-1:5, \
 _n6##i = 6>=(int)(bound)?(int)(bound)-1:6; \
 _n6##i<(int)(bound) || _n5##i==--_n6##i || _n4##i==--_n5##i || _n3##i==--_n4##i || _n2##i==--_n3##i || _n1##i==--_n2##i || \
 i==(_n6##i = _n5##i = _n4##i = _n3##i = _n2##i = --_n1##i); \
 _p5##i = _p4##i, _p4##i = _p3##i, _p3##i = _p2##i, _p2##i = _p1##i, _p1##i = i++, \
 ++_n1##i, ++_n2##i, ++_n3##i, ++_n4##i, ++_n5##i, ++_n6##i)

#define cimg_for12X(img,x) cimg_for12((img)._width,x)
#define cimg_for12Y(img,y) cimg_for12((img)._height,y)
#define cimg_for12Z(img,z) cimg_for12((img)._depth,z)
#define cimg_for12C(img,c) cimg_for12((img)._spectrum,c)
#define cimg_for12XY(img,x,y) cimg_for12Y(img,y) cimg_for12X(img,x)
#define cimg_for12XZ(img,x,z) cimg_for12Z(img,z) cimg_for12X(img,x)
#define cimg_for12XC(img,x,c) cimg_for12C(img,c) cimg_for12X(img,x)
#define cimg_for12YZ(img,y,z) cimg_for12Z(img,z) cimg_for12Y(img,y)
#define cimg_for12YC(img,y,c) cimg_for12C(img,c) cimg_for12Y(img,y)
#define cimg_for12ZC(img,z,c) cimg_for12C(img,c) cimg_for12Z(img,z)
#define cimg_for12XYZ(img,x,y,z) cimg_for12Z(img,z) cimg_for12XY(img,x,y)
#define cimg_for12XZC(img,x,z,c) cimg_for12C(img,c) cimg_for12XZ(img,x,z)
#define cimg_for12YZC(img,y,z,c) cimg_for12C(img,c) cimg_for12YZ(img,y,z)
#define cimg_for12XYZC(img,x,y,z,c) cimg_for12C(img,c) cimg_for12XYZ(img,x,y,z)

#define cimg_for_in12(bound,i0,i1,i) for (int i = (int)(i0)<0?0:(int)(i0), \
 _p5##i = i-5<0?0:i-5, \
 _p4##i = i-4<0?0:i-4, \
 _p3##i = i-3<0?0:i-3, \
 _p2##i = i-2<0?0:i-2, \
 _p1##i = i-1<0?0:i-1, \
 _n1##i = i+1>=(int)(bound)?(int)(bound)-1:i+1, \
 _n2##i = i+2>=(int)(bound)?(int)(bound)-1:i+2, \
 _n3##i = i+3>=(int)(bound)?(int)(bound)-1:i+3, \
 _n4##i = i+4>=(int)(bound)?(int)(bound)-1:i+4, \
 _n5##i = i+5>=(int)(bound)?(int)(bound)-1:i+5, \
 _n6##i = i+6>=(int)(bound)?(int)(bound)-1:i+6; \
 i<=(int)(i1) && (_n6##i<(int)(bound) || _n5##i==--_n6##i || _n4##i==--_n5##i || _n3##i==--_n4##i || _n2##i==--_n3##i || _n1##i==--_n2##i || \
 i==(_n6##i = _n5##i = _n4##i = _n3##i = _n2##i = --_n1##i)); \
 _p5##i = _p4##i, _p4##i = _p3##i, _p3##i = _p2##i, _p2##i = _p1##i, _p1##i = i++, \
 ++_n1##i, ++_n2##i, ++_n3##i, ++_n4##i, ++_n5##i, ++_n6##i)

#define cimg_for_in12X(img,x0,x1,x) cimg_for_in12((img)._width,x0,x1,x)
#define cimg_for_in12Y(img,y0,y1,y) cimg_for_in12((img)._height,y0,y1,y)
#define cimg_for_in12Z(img,z0,z1,z) cimg_for_in12((img)._depth,z0,z1,z)
#define cimg_for_in12C(img,c0,c1,c) cimg_for_in12((img)._spectrum,c0,c1,c)
#define cimg_for_in12XY(img,x0,y0,x1,y1,x,y) cimg_for_in12Y(img,y0,y1,y) cimg_for_in12X(img,x0,x1,x)
#define cimg_for_in12XZ(img,x0,z0,x1,z1,x,z) cimg_for_in12Z(img,z0,z1,z) cimg_for_in12X(img,x0,x1,x)
#define cimg_for_in12XC(img,x0,c0,x1,c1,x,c) cimg_for_in12C(img,c0,c1,c) cimg_for_in12X(img,x0,x1,x)
#define cimg_for_in12YZ(img,y0,z0,y1,z1,y,z) cimg_for_in12Z(img,z0,z1,z) cimg_for_in12Y(img,y0,y1,y)
#define cimg_for_in12YC(img,y0,c0,y1,c1,y,c) cimg_for_in12C(img,c0,c1,c) cimg_for_in12Y(img,y0,y1,y)
#define cimg_for_in12ZC(img,z0,c0,z1,c1,z,c) cimg_for_in12C(img,c0,c1,c) cimg_for_in12Z(img,z0,z1,z)
#define cimg_for_in12XYZ(img,x0,y0,z0,x1,y1,z1,x,y,z) cimg_for_in12Z(img,z0,z1,z) cimg_for_in12XY(img,x0,y0,x1,y1,x,y)
#define cimg_for_in12XZC(img,x0,z0,c0,x1,y1,c1,x,z,c) cimg_for_in12C(img,c0,c1,c) cimg_for_in12XZ(img,x0,y0,x1,y1,x,z)
#define cimg_for_in12YZC(img,y0,z0,c0,y1,z1,c1,y,z,c) cimg_for_in12C(img,c0,c1,c) cimg_for_in12YZ(img,y0,z0,y1,z1,y,z)
#define cimg_for_in12XYZC(img,x0,y0,z0,c0,x1,y1,z1,c1,x,y,z,c) cimg_for_in12C(img,c0,c1,c) cimg_for_in12XYZ(img,x0,y0,z0,x1,y1,z1,x,y,z)

#define cimg_for12x12(img,x,y,z,c,I,T) \
 cimg_for12((img)._height,y) for (int x = 0, \
 _p5##x = 0, _p4##x = 0, _p3##x = 0, _p2##x = 0, _p1##x = 0, \
 _n1##x = 1>=((img)._width)?(img).width()-1:1, \
 _n2##x = 2>=((img)._width)?(img).width()-1:2, \
 _n3##x = 3>=((img)._width)?(img).width()-1:3, \
 _n4##x = 4>=((img)._width)?(img).width()-1:4, \
 _n5##x = 5>=((img)._width)?(img).width()-1:5, \
 _n6##x = (int)( \
 (I[0] = I[1] = I[2] = I[3] = I[4] = I[5] = (T)(img)(0,_p5##y,z,c)), \
 (I[12] = I[13] = I[14] = I[15] = I[16] = I[17] = (T)(img)(0,_p4##y,z,c)), \
 (I[24] = I[25] = I[26] = I[27] = I[28] = I[29] = (T)(img)(0,_p3##y,z,c)), \
 (I[36] = I[37] = I[38] = I[39] = I[40] = I[41] = (T)(img)(0,_p2##y,z,c)), \
 (I[48] = I[49] = I[50] = I[51] = I[52] = I[53] = (T)(img)(0,_p1##y,z,c)), \
 (I[60] = I[61] = I[62] = I[63] = I[64] = I[65] = (T)(img)(0,y,z,c)), \
 (I[72] = I[73] = I[74] = I[75] = I[76] = I[77] = (T)(img)(0,_n1##y,z,c)), \
 (I[84] = I[85] = I[86] = I[87] = I[88] = I[89] = (T)(img)(0,_n2##y,z,c)), \
 (I[96] = I[97] = I[98] = I[99] = I[100] = I[101] = (T)(img)(0,_n3##y,z,c)), \
 (I[108] = I[109] = I[110] = I[111] = I[112] = I[113] = (T)(img)(0,_n4##y,z,c)), \
 (I[120] = I[121] = I[122] = I[123] = I[124] = I[125] = (T)(img)(0,_n5##y,z,c)), \
 (I[132] = I[133] = I[134] = I[135] = I[136] = I[137] = (T)(img)(0,_n6##y,z,c)), \
 (I[6] = (T)(img)(_n1##x,_p5##y,z,c)), \
 (I[18] = (T)(img)(_n1##x,_p4##y,z,c)), \
 (I[30] = (T)(img)(_n1##x,_p3##y,z,c)), \
 (I[42] = (T)(img)(_n1##x,_p2##y,z,c)), \
 (I[54] = (T)(img)(_n1##x,_p1##y,z,c)), \
 (I[66] = (T)(img)(_n1##x,y,z,c)), \
 (I[78] = (T)(img)(_n1##x,_n1##y,z,c)), \
 (I[90] = (T)(img)(_n1##x,_n2##y,z,c)), \
 (I[102] = (T)(img)(_n1##x,_n3##y,z,c)), \
 (I[114] = (T)(img)(_n1##x,_n4##y,z,c)), \
 (I[126] = (T)(img)(_n1##x,_n5##y,z,c)), \
 (I[138] = (T)(img)(_n1##x,_n6##y,z,c)), \
 (I[7] = (T)(img)(_n2##x,_p5##y,z,c)), \
 (I[19] = (T)(img)(_n2##x,_p4##y,z,c)), \
 (I[31] = (T)(img)(_n2##x,_p3##y,z,c)), \
 (I[43] = (T)(img)(_n2##x,_p2##y,z,c)), \
 (I[55] = (T)(img)(_n2##x,_p1##y,z,c)), \
 (I[67] = (T)(img)(_n2##x,y,z,c)), \
 (I[79] = (T)(img)(_n2##x,_n1##y,z,c)), \
 (I[91] = (T)(img)(_n2##x,_n2##y,z,c)), \
 (I[103] = (T)(img)(_n2##x,_n3##y,z,c)), \
 (I[115] = (T)(img)(_n2##x,_n4##y,z,c)), \
 (I[127] = (T)(img)(_n2##x,_n5##y,z,c)), \
 (I[139] = (T)(img)(_n2##x,_n6##y,z,c)), \
 (I[8] = (T)(img)(_n3##x,_p5##y,z,c)), \
 (I[20] = (T)(img)(_n3##x,_p4##y,z,c)), \
 (I[32] = (T)(img)(_n3##x,_p3##y,z,c)), \
 (I[44] = (T)(img)(_n3##x,_p2##y,z,c)), \
 (I[56] = (T)(img)(_n3##x,_p1##y,z,c)), \
 (I[68] = (T)(img)(_n3##x,y,z,c)), \
 (I[80] = (T)(img)(_n3##x,_n1##y,z,c)), \
 (I[92] = (T)(img)(_n3##x,_n2##y,z,c)), \
 (I[104] = (T)(img)(_n3##x,_n3##y,z,c)), \
 (I[116] = (T)(img)(_n3##x,_n4##y,z,c)), \
 (I[128] = (T)(img)(_n3##x,_n5##y,z,c)), \
 (I[140] = (T)(img)(_n3##x,_n6##y,z,c)), \
 (I[9] = (T)(img)(_n4##x,_p5##y,z,c)), \
 (I[21] = (T)(img)(_n4##x,_p4##y,z,c)), \
 (I[33] = (T)(img)(_n4##x,_p3##y,z,c)), \
 (I[45] = (T)(img)(_n4##x,_p2##y,z,c)), \
 (I[57] = (T)(img)(_n4##x,_p1##y,z,c)), \
 (I[69] = (T)(img)(_n4##x,y,z,c)), \
 (I[81] = (T)(img)(_n4##x,_n1##y,z,c)), \
 (I[93] = (T)(img)(_n4##x,_n2##y,z,c)), \
 (I[105] = (T)(img)(_n4##x,_n3##y,z,c)), \
 (I[117] = (T)(img)(_n4##x,_n4##y,z,c)), \
 (I[129] = (T)(img)(_n4##x,_n5##y,z,c)), \
 (I[141] = (T)(img)(_n4##x,_n6##y,z,c)), \
 (I[10] = (T)(img)(_n5##x,_p5##y,z,c)), \
 (I[22] = (T)(img)(_n5##x,_p4##y,z,c)), \
 (I[34] = (T)(img)(_n5##x,_p3##y,z,c)), \
 (I[46] = (T)(img)(_n5##x,_p2##y,z,c)), \
 (I[58] = (T)(img)(_n5##x,_p1##y,z,c)), \
 (I[70] = (T)(img)(_n5##x,y,z,c)), \
 (I[82] = (T)(img)(_n5##x,_n1##y,z,c)), \
 (I[94] = (T)(img)(_n5##x,_n2##y,z,c)), \
 (I[106] = (T)(img)(_n5##x,_n3##y,z,c)), \
 (I[118] = (T)(img)(_n5##x,_n4##y,z,c)), \
 (I[130] = (T)(img)(_n5##x,_n5##y,z,c)), \
 (I[142] = (T)(img)(_n5##x,_n6##y,z,c)), \
 6>=((img)._width)?(img).width()-1:6); \
 (_n6##x<(img).width() && ( \
 (I[11] = (T)(img)(_n6##x,_p5##y,z,c)), \
 (I[23] = (T)(img)(_n6##x,_p4##y,z,c)), \
 (I[35] = (T)(img)(_n6##x,_p3##y,z,c)), \
 (I[47] = (T)(img)(_n6##x,_p2##y,z,c)), \
 (I[59] = (T)(img)(_n6##x,_p1##y,z,c)), \
 (I[71] = (T)(img)(_n6##x,y,z,c)), \
 (I[83] = (T)(img)(_n6##x,_n1##y,z,c)), \
 (I[95] = (T)(img)(_n6##x,_n2##y,z,c)), \
 (I[107] = (T)(img)(_n6##x,_n3##y,z,c)), \
 (I[119] = (T)(img)(_n6##x,_n4##y,z,c)), \
 (I[131] = (T)(img)(_n6##x,_n5##y,z,c)), \
 (I[143] = (T)(img)(_n6##x,_n6##y,z,c)),1)) || \
 _n5##x==--_n6##x || _n4##x==--_n5##x || _n3##x==--_n4##x || _n2##x==--_n3##x || _n1##x==--_n2##x || x==(_n6##x = _n5##x = _n4##x = _n3##x = _n2##x = --_n1##x); \
 I[0] = I[1], I[1] = I[2], I[2] = I[3], I[3] = I[4], I[4] = I[5], I[5] = I[6], I[6] = I[7], I[7] = I[8], I[8] = I[9], I[9] = I[10], I[10] = I[11], \
 I[12] = I[13], I[13] = I[14], I[14] = I[15], I[15] = I[16], I[16] = I[17], I[17] = I[18], I[18] = I[19], I[19] = I[20], I[20] = I[21], I[21] = I[22], I[22] = I[23], \
 I[24] = I[25], I[25] = I[26], I[26] = I[27], I[27] = I[28], I[28] = I[29], I[29] = I[30], I[30] = I[31], I[31] = I[32], I[32] = I[33], I[33] = I[34], I[34] = I[35], \
 I[36] = I[37], I[37] = I[38], I[38] = I[39], I[39] = I[40], I[40] = I[41], I[41] = I[42], I[42] = I[43], I[43] = I[44], I[44] = I[45], I[45] = I[46], I[46] = I[47], \
 I[48] = I[49], I[49] = I[50], I[50] = I[51], I[51] = I[52], I[52] = I[53], I[53] = I[54], I[54] = I[55], I[55] = I[56], I[56] = I[57], I[57] = I[58], I[58] = I[59], \
 I[60] = I[61], I[61] = I[62], I[62] = I[63], I[63] = I[64], I[64] = I[65], I[65] = I[66], I[66] = I[67], I[67] = I[68], I[68] = I[69], I[69] = I[70], I[70] = I[71], \
 I[72] = I[73], I[73] = I[74], I[74] = I[75], I[75] = I[76], I[76] = I[77], I[77] = I[78], I[78] = I[79], I[79] = I[80], I[80] = I[81], I[81] = I[82], I[82] = I[83], \
 I[84] = I[85], I[85] = I[86], I[86] = I[87], I[87] = I[88], I[88] = I[89], I[89] = I[90], I[90] = I[91], I[91] = I[92], I[92] = I[93], I[93] = I[94], I[94] = I[95], \
 I[96] = I[97], I[97] = I[98], I[98] = I[99], I[99] = I[100], I[100] = I[101], I[101] = I[102], I[102] = I[103], I[103] = I[104], I[104] = I[105], I[105] = I[106], I[106] = I[107], \
 I[108] = I[109], I[109] = I[110], I[110] = I[111], I[111] = I[112], I[112] = I[113], I[113] = I[114], I[114] = I[115], I[115] = I[116], I[116] = I[117], I[117] = I[118], I[118] = I[119], \
 I[120] = I[121], I[121] = I[122], I[122] = I[123], I[123] = I[124], I[124] = I[125], I[125] = I[126], I[126] = I[127], I[127] = I[128], I[128] = I[129], I[129] = I[130], I[130] = I[131], \
 I[132] = I[133], I[133] = I[134], I[134] = I[135], I[135] = I[136], I[136] = I[137], I[137] = I[138], I[138] = I[139], I[139] = I[140], I[140] = I[141], I[141] = I[142], I[142] = I[143], \
 _p5##x = _p4##x, _p4##x = _p3##x, _p3##x = _p2##x, _p2##x = _p1##x, _p1##x = x++, ++_n1##x, ++_n2##x, ++_n3##x, ++_n4##x, ++_n5##x, ++_n6##x)

#define cimg_for_in12x12(img,x0,y0,x1,y1,x,y,z,c,I,T) \
 cimg_for_in12((img)._height,y0,y1,y) for (int x = (int)(x0)<0?0:(int)(x0), \
 _p5##x = x-5<0?0:x-5, \
 _p4##x = x-4<0?0:x-4, \
 _p3##x = x-3<0?0:x-3, \
 _p2##x = x-2<0?0:x-2, \
 _p1##x = x-1<0?0:x-1, \
 _n1##x = x+1>=(img).width()?(img).width()-1:x+1, \
 _n2##x = x+2>=(img).width()?(img).width()-1:x+2, \
 _n3##x = x+3>=(img).width()?(img).width()-1:x+3, \
 _n4##x = x+4>=(img).width()?(img).width()-1:x+4, \
 _n5##x = x+5>=(img).width()?(img).width()-1:x+5, \
 _n6##x = (int)( \
 (I[0] = (T)(img)(_p5##x,_p5##y,z,c)), \
 (I[12] = (T)(img)(_p5##x,_p4##y,z,c)), \
 (I[24] = (T)(img)(_p5##x,_p3##y,z,c)), \
 (I[36] = (T)(img)(_p5##x,_p2##y,z,c)), \
 (I[48] = (T)(img)(_p5##x,_p1##y,z,c)), \
 (I[60] = (T)(img)(_p5##x,y,z,c)), \
 (I[72] = (T)(img)(_p5##x,_n1##y,z,c)), \
 (I[84] = (T)(img)(_p5##x,_n2##y,z,c)), \
 (I[96] = (T)(img)(_p5##x,_n3##y,z,c)), \
 (I[108] = (T)(img)(_p5##x,_n4##y,z,c)), \
 (I[120] = (T)(img)(_p5##x,_n5##y,z,c)), \
 (I[132] = (T)(img)(_p5##x,_n6##y,z,c)), \
 (I[1] = (T)(img)(_p4##x,_p5##y,z,c)), \
 (I[13] = (T)(img)(_p4##x,_p4##y,z,c)), \
 (I[25] = (T)(img)(_p4##x,_p3##y,z,c)), \
 (I[37] = (T)(img)(_p4##x,_p2##y,z,c)), \
 (I[49] = (T)(img)(_p4##x,_p1##y,z,c)), \
 (I[61] = (T)(img)(_p4##x,y,z,c)), \
 (I[73] = (T)(img)(_p4##x,_n1##y,z,c)), \
 (I[85] = (T)(img)(_p4##x,_n2##y,z,c)), \
 (I[97] = (T)(img)(_p4##x,_n3##y,z,c)), \
 (I[109] = (T)(img)(_p4##x,_n4##y,z,c)), \
 (I[121] = (T)(img)(_p4##x,_n5##y,z,c)), \
 (I[133] = (T)(img)(_p4##x,_n6##y,z,c)), \
 (I[2] = (T)(img)(_p3##x,_p5##y,z,c)), \
 (I[14] = (T)(img)(_p3##x,_p4##y,z,c)), \
 (I[26] = (T)(img)(_p3##x,_p3##y,z,c)), \
 (I[38] = (T)(img)(_p3##x,_p2##y,z,c)), \
 (I[50] = (T)(img)(_p3##x,_p1##y,z,c)), \
 (I[62] = (T)(img)(_p3##x,y,z,c)), \
 (I[74] = (T)(img)(_p3##x,_n1##y,z,c)), \
 (I[86] = (T)(img)(_p3##x,_n2##y,z,c)), \
 (I[98] = (T)(img)(_p3##x,_n3##y,z,c)), \
 (I[110] = (T)(img)(_p3##x,_n4##y,z,c)), \
 (I[122] = (T)(img)(_p3##x,_n5##y,z,c)), \
 (I[134] = (T)(img)(_p3##x,_n6##y,z,c)), \
 (I[3] = (T)(img)(_p2##x,_p5##y,z,c)), \
 (I[15] = (T)(img)(_p2##x,_p4##y,z,c)), \
 (I[27] = (T)(img)(_p2##x,_p3##y,z,c)), \
 (I[39] = (T)(img)(_p2##x,_p2##y,z,c)), \
 (I[51] = (T)(img)(_p2##x,_p1##y,z,c)), \
 (I[63] = (T)(img)(_p2##x,y,z,c)), \
 (I[75] = (T)(img)(_p2##x,_n1##y,z,c)), \
 (I[87] = (T)(img)(_p2##x,_n2##y,z,c)), \
 (I[99] = (T)(img)(_p2##x,_n3##y,z,c)), \
 (I[111] = (T)(img)(_p2##x,_n4##y,z,c)), \
 (I[123] = (T)(img)(_p2##x,_n5##y,z,c)), \
 (I[135] = (T)(img)(_p2##x,_n6##y,z,c)), \
 (I[4] = (T)(img)(_p1##x,_p5##y,z,c)), \
 (I[16] = (T)(img)(_p1##x,_p4##y,z,c)), \
 (I[28] = (T)(img)(_p1##x,_p3##y,z,c)), \
 (I[40] = (T)(img)(_p1##x,_p2##y,z,c)), \
 (I[52] = (T)(img)(_p1##x,_p1##y,z,c)), \
 (I[64] = (T)(img)(_p1##x,y,z,c)), \
 (I[76] = (T)(img)(_p1##x,_n1##y,z,c)), \
 (I[88] = (T)(img)(_p1##x,_n2##y,z,c)), \
 (I[100] = (T)(img)(_p1##x,_n3##y,z,c)), \
 (I[112] = (T)(img)(_p1##x,_n4##y,z,c)), \
 (I[124] = (T)(img)(_p1##x,_n5##y,z,c)), \
 (I[136] = (T)(img)(_p1##x,_n6##y,z,c)), \
 (I[5] = (T)(img)(x,_p5##y,z,c)), \
 (I[17] = (T)(img)(x,_p4##y,z,c)), \
 (I[29] = (T)(img)(x,_p3##y,z,c)), \
 (I[41] = (T)(img)(x,_p2##y,z,c)), \
 (I[53] = (T)(img)(x,_p1##y,z,c)), \
 (I[65] = (T)(img)(x,y,z,c)), \
 (I[77] = (T)(img)(x,_n1##y,z,c)), \
 (I[89] = (T)(img)(x,_n2##y,z,c)), \
 (I[101] = (T)(img)(x,_n3##y,z,c)), \
 (I[113] = (T)(img)(x,_n4##y,z,c)), \
 (I[125] = (T)(img)(x,_n5##y,z,c)), \
 (I[137] = (T)(img)(x,_n6##y,z,c)), \
 (I[6] = (T)(img)(_n1##x,_p5##y,z,c)), \
 (I[18] = (T)(img)(_n1##x,_p4##y,z,c)), \
 (I[30] = (T)(img)(_n1##x,_p3##y,z,c)), \
 (I[42] = (T)(img)(_n1##x,_p2##y,z,c)), \
 (I[54] = (T)(img)(_n1##x,_p1##y,z,c)), \
 (I[66] = (T)(img)(_n1##x,y,z,c)), \
 (I[78] = (T)(img)(_n1##x,_n1##y,z,c)), \
 (I[90] = (T)(img)(_n1##x,_n2##y,z,c)), \
 (I[102] = (T)(img)(_n1##x,_n3##y,z,c)), \
 (I[114] = (T)(img)(_n1##x,_n4##y,z,c)), \
 (I[126] = (T)(img)(_n1##x,_n5##y,z,c)), \
 (I[138] = (T)(img)(_n1##x,_n6##y,z,c)), \
 (I[7] = (T)(img)(_n2##x,_p5##y,z,c)), \
 (I[19] = (T)(img)(_n2##x,_p4##y,z,c)), \
 (I[31] = (T)(img)(_n2##x,_p3##y,z,c)), \
 (I[43] = (T)(img)(_n2##x,_p2##y,z,c)), \
 (I[55] = (T)(img)(_n2##x,_p1##y,z,c)), \
 (I[67] = (T)(img)(_n2##x,y,z,c)), \
 (I[79] = (T)(img)(_n2##x,_n1##y,z,c)), \
 (I[91] = (T)(img)(_n2##x,_n2##y,z,c)), \
 (I[103] = (T)(img)(_n2##x,_n3##y,z,c)), \
 (I[115] = (T)(img)(_n2##x,_n4##y,z,c)), \
 (I[127] = (T)(img)(_n2##x,_n5##y,z,c)), \
 (I[139] = (T)(img)(_n2##x,_n6##y,z,c)), \
 (I[8] = (T)(img)(_n3##x,_p5##y,z,c)), \
 (I[20] = (T)(img)(_n3##x,_p4##y,z,c)), \
 (I[32] = (T)(img)(_n3##x,_p3##y,z,c)), \
 (I[44] = (T)(img)(_n3##x,_p2##y,z,c)), \
 (I[56] = (T)(img)(_n3##x,_p1##y,z,c)), \
 (I[68] = (T)(img)(_n3##x,y,z,c)), \
 (I[80] = (T)(img)(_n3##x,_n1##y,z,c)), \
 (I[92] = (T)(img)(_n3##x,_n2##y,z,c)), \
 (I[104] = (T)(img)(_n3##x,_n3##y,z,c)), \
 (I[116] = (T)(img)(_n3##x,_n4##y,z,c)), \
 (I[128] = (T)(img)(_n3##x,_n5##y,z,c)), \
 (I[140] = (T)(img)(_n3##x,_n6##y,z,c)), \
 (I[9] = (T)(img)(_n4##x,_p5##y,z,c)), \
 (I[21] = (T)(img)(_n4##x,_p4##y,z,c)), \
 (I[33] = (T)(img)(_n4##x,_p3##y,z,c)), \
 (I[45] = (T)(img)(_n4##x,_p2##y,z,c)), \
 (I[57] = (T)(img)(_n4##x,_p1##y,z,c)), \
 (I[69] = (T)(img)(_n4##x,y,z,c)), \
 (I[81] = (T)(img)(_n4##x,_n1##y,z,c)), \
 (I[93] = (T)(img)(_n4##x,_n2##y,z,c)), \
 (I[105] = (T)(img)(_n4##x,_n3##y,z,c)), \
 (I[117] = (T)(img)(_n4##x,_n4##y,z,c)), \
 (I[129] = (T)(img)(_n4##x,_n5##y,z,c)), \
 (I[141] = (T)(img)(_n4##x,_n6##y,z,c)), \
 (I[10] = (T)(img)(_n5##x,_p5##y,z,c)), \
 (I[22] = (T)(img)(_n5##x,_p4##y,z,c)), \
 (I[34] = (T)(img)(_n5##x,_p3##y,z,c)), \
 (I[46] = (T)(img)(_n5##x,_p2##y,z,c)), \
 (I[58] = (T)(img)(_n5##x,_p1##y,z,c)), \
 (I[70] = (T)(img)(_n5##x,y,z,c)), \
 (I[82] = (T)(img)(_n5##x,_n1##y,z,c)), \
 (I[94] = (T)(img)(_n5##x,_n2##y,z,c)), \
 (I[106] = (T)(img)(_n5##x,_n3##y,z,c)), \
 (I[118] = (T)(img)(_n5##x,_n4##y,z,c)), \
 (I[130] = (T)(img)(_n5##x,_n5##y,z,c)), \
 (I[142] = (T)(img)(_n5##x,_n6##y,z,c)), \
 x+6>=(img).width()?(img).width()-1:x+6); \
 x<=(int)(x1) && ((_n6##x<(img).width() && ( \
 (I[11] = (T)(img)(_n6##x,_p5##y,z,c)), \
 (I[23] = (T)(img)(_n6##x,_p4##y,z,c)), \
 (I[35] = (T)(img)(_n6##x,_p3##y,z,c)), \
 (I[47] = (T)(img)(_n6##x,_p2##y,z,c)), \
 (I[59] = (T)(img)(_n6##x,_p1##y,z,c)), \
 (I[71] = (T)(img)(_n6##x,y,z,c)), \
 (I[83] = (T)(img)(_n6##x,_n1##y,z,c)), \
 (I[95] = (T)(img)(_n6##x,_n2##y,z,c)), \
 (I[107] = (T)(img)(_n6##x,_n3##y,z,c)), \
 (I[119] = (T)(img)(_n6##x,_n4##y,z,c)), \
 (I[131] = (T)(img)(_n6##x,_n5##y,z,c)), \
 (I[143] = (T)(img)(_n6##x,_n6##y,z,c)),1)) || \
 _n5##x==--_n6##x || _n4##x==--_n5##x || _n3##x==--_n4##x || _n2##x==--_n3##x || _n1##x==--_n2##x || x==(_n6##x = _n5##x = _n4##x = _n3##x = _n2##x = --_n1##x)); \
 I[0] = I[1], I[1] = I[2], I[2] = I[3], I[3] = I[4], I[4] = I[5], I[5] = I[6], I[6] = I[7], I[7] = I[8], I[8] = I[9], I[9] = I[10], I[10] = I[11], \
 I[12] = I[13], I[13] = I[14], I[14] = I[15], I[15] = I[16], I[16] = I[17], I[17] = I[18], I[18] = I[19], I[19] = I[20], I[20] = I[21], I[21] = I[22], I[22] = I[23], \
 I[24] = I[25], I[25] = I[26], I[26] = I[27], I[27] = I[28], I[28] = I[29], I[29] = I[30], I[30] = I[31], I[31] = I[32], I[32] = I[33], I[33] = I[34], I[34] = I[35], \
 I[36] = I[37], I[37] = I[38], I[38] = I[39], I[39] = I[40], I[40] = I[41], I[41] = I[42], I[42] = I[43], I[43] = I[44], I[44] = I[45], I[45] = I[46], I[46] = I[47], \
 I[48] = I[49], I[49] = I[50], I[50] = I[51], I[51] = I[52], I[52] = I[53], I[53] = I[54], I[54] = I[55], I[55] = I[56], I[56] = I[57], I[57] = I[58], I[58] = I[59], \
 I[60] = I[61], I[61] = I[62], I[62] = I[63], I[63] = I[64], I[64] = I[65], I[65] = I[66], I[66] = I[67], I[67] = I[68], I[68] = I[69], I[69] = I[70], I[70] = I[71], \
 I[72] = I[73], I[73] = I[74], I[74] = I[75], I[75] = I[76], I[76] = I[77], I[77] = I[78], I[78] = I[79], I[79] = I[80], I[80] = I[81], I[81] = I[82], I[82] = I[83], \
 I[84] = I[85], I[85] = I[86], I[86] = I[87], I[87] = I[88], I[88] = I[89], I[89] = I[90], I[90] = I[91], I[91] = I[92], I[92] = I[93], I[93] = I[94], I[94] = I[95], \
 I[96] = I[97], I[97] = I[98], I[98] = I[99], I[99] = I[100], I[100] = I[101], I[101] = I[102], I[102] = I[103], I[103] = I[104], I[104] = I[105], I[105] = I[106], I[106] = I[107], \
 I[108] = I[109], I[109] = I[110], I[110] = I[111], I[111] = I[112], I[112] = I[113], I[113] = I[114], I[114] = I[115], I[115] = I[116], I[116] = I[117], I[117] = I[118], I[118] = I[119], \
 I[120] = I[121], I[121] = I[122], I[122] = I[123], I[123] = I[124], I[124] = I[125], I[125] = I[126], I[126] = I[127], I[127] = I[128], I[128] = I[129], I[129] = I[130], I[130] = I[131], \
 I[132] = I[133], I[133] = I[134], I[134] = I[135], I[135] = I[136], I[136] = I[137], I[137] = I[138], I[138] = I[139], I[139] = I[140], I[140] = I[141], I[141] = I[142], I[142] = I[143], \
 _p5##x = _p4##x, _p4##x = _p3##x, _p3##x = _p2##x, _p2##x = _p1##x, _p1##x = x++, ++_n1##x, ++_n2##x, ++_n3##x, ++_n4##x, ++_n5##x, ++_n6##x)

#define cimg_get12x12(img,x,y,z,c,I,T) \
 I[0] = (T)(img)(_p5##x,_p5##y,z,c), I[1] = (T)(img)(_p4##x,_p5##y,z,c), I[2] = (T)(img)(_p3##x,_p5##y,z,c), I[3] = (T)(img)(_p2##x,_p5##y,z,c), I[4] = (T)(img)(_p1##x,_p5##y,z,c), I[5] = (T)(img)(x,_p5##y,z,c), I[6] = (T)(img)(_n1##x,_p5##y,z,c), I[7] = (T)(img)(_n2##x,_p5##y,z,c), I[8] = (T)(img)(_n3##x,_p5##y,z,c), I[9] = (T)(img)(_n4##x,_p5##y,z,c), I[10] = (T)(img)(_n5##x,_p5##y,z,c), I[11] = (T)(img)(_n6##x,_p5##y,z,c), \
 I[12] = (T)(img)(_p5##x,_p4##y,z,c), I[13] = (T)(img)(_p4##x,_p4##y,z,c), I[14] = (T)(img)(_p3##x,_p4##y,z,c), I[15] = (T)(img)(_p2##x,_p4##y,z,c), I[16] = (T)(img)(_p1##x,_p4##y,z,c), I[17] = (T)(img)(x,_p4##y,z,c), I[18] = (T)(img)(_n1##x,_p4##y,z,c), I[19] = (T)(img)(_n2##x,_p4##y,z,c), I[20] = (T)(img)(_n3##x,_p4##y,z,c), I[21] = (T)(img)(_n4##x,_p4##y,z,c), I[22] = (T)(img)(_n5##x,_p4##y,z,c), I[23] = (T)(img)(_n6##x,_p4##y,z,c), \
 I[24] = (T)(img)(_p5##x,_p3##y,z,c), I[25] = (T)(img)(_p4##x,_p3##y,z,c), I[26] = (T)(img)(_p3##x,_p3##y,z,c), I[27] = (T)(img)(_p2##x,_p3##y,z,c), I[28] = (T)(img)(_p1##x,_p3##y,z,c), I[29] = (T)(img)(x,_p3##y,z,c), I[30] = (T)(img)(_n1##x,_p3##y,z,c), I[31] = (T)(img)(_n2##x,_p3##y,z,c), I[32] = (T)(img)(_n3##x,_p3##y,z,c), I[33] = (T)(img)(_n4##x,_p3##y,z,c), I[34] = (T)(img)(_n5##x,_p3##y,z,c), I[35] = (T)(img)(_n6##x,_p3##y,z,c), \
 I[36] = (T)(img)(_p5##x,_p2##y,z,c), I[37] = (T)(img)(_p4##x,_p2##y,z,c), I[38] = (T)(img)(_p3##x,_p2##y,z,c), I[39] = (T)(img)(_p2##x,_p2##y,z,c), I[40] = (T)(img)(_p1##x,_p2##y,z,c), I[41] = (T)(img)(x,_p2##y,z,c), I[42] = (T)(img)(_n1##x,_p2##y,z,c), I[43] = (T)(img)(_n2##x,_p2##y,z,c), I[44] = (T)(img)(_n3##x,_p2##y,z,c), I[45] = (T)(img)(_n4##x,_p2##y,z,c), I[46] = (T)(img)(_n5##x,_p2##y,z,c), I[47] = (T)(img)(_n6##x,_p2##y,z,c), \
 I[48] = (T)(img)(_p5##x,_p1##y,z,c), I[49] = (T)(img)(_p4##x,_p1##y,z,c), I[50] = (T)(img)(_p3##x,_p1##y,z,c), I[51] = (T)(img)(_p2##x,_p1##y,z,c), I[52] = (T)(img)(_p1##x,_p1##y,z,c), I[53] = (T)(img)(x,_p1##y,z,c), I[54] = (T)(img)(_n1##x,_p1##y,z,c), I[55] = (T)(img)(_n2##x,_p1##y,z,c), I[56] = (T)(img)(_n3##x,_p1##y,z,c), I[57] = (T)(img)(_n4##x,_p1##y,z,c), I[58] = (T)(img)(_n5##x,_p1##y,z,c), I[59] = (T)(img)(_n6##x,_p1##y,z,c), \
 I[60] = (T)(img)(_p5##x,y,z,c), I[61] = (T)(img)(_p4##x,y,z,c), I[62] = (T)(img)(_p3##x,y,z,c), I[63] = (T)(img)(_p2##x,y,z,c), I[64] = (T)(img)(_p1##x,y,z,c), I[65] = (T)(img)(x,y,z,c), I[66] = (T)(img)(_n1##x,y,z,c), I[67] = (T)(img)(_n2##x,y,z,c), I[68] = (T)(img)(_n3##x,y,z,c), I[69] = (T)(img)(_n4##x,y,z,c), I[70] = (T)(img)(_n5##x,y,z,c), I[71] = (T)(img)(_n6##x,y,z,c), \
 I[72] = (T)(img)(_p5##x,_n1##y,z,c), I[73] = (T)(img)(_p4##x,_n1##y,z,c), I[74] = (T)(img)(_p3##x,_n1##y,z,c), I[75] = (T)(img)(_p2##x,_n1##y,z,c), I[76] = (T)(img)(_p1##x,_n1##y,z,c), I[77] = (T)(img)(x,_n1##y,z,c), I[78] = (T)(img)(_n1##x,_n1##y,z,c), I[79] = (T)(img)(_n2##x,_n1##y,z,c), I[80] = (T)(img)(_n3##x,_n1##y,z,c), I[81] = (T)(img)(_n4##x,_n1##y,z,c), I[82] = (T)(img)(_n5##x,_n1##y,z,c), I[83] = (T)(img)(_n6##x,_n1##y,z,c), \
 I[84] = (T)(img)(_p5##x,_n2##y,z,c), I[85] = (T)(img)(_p4##x,_n2##y,z,c), I[86] = (T)(img)(_p3##x,_n2##y,z,c), I[87] = (T)(img)(_p2##x,_n2##y,z,c), I[88] = (T)(img)(_p1##x,_n2##y,z,c), I[89] = (T)(img)(x,_n2##y,z,c), I[90] = (T)(img)(_n1##x,_n2##y,z,c), I[91] = (T)(img)(_n2##x,_n2##y,z,c), I[92] = (T)(img)(_n3##x,_n2##y,z,c), I[93] = (T)(img)(_n4##x,_n2##y,z,c), I[94] = (T)(img)(_n5##x,_n2##y,z,c), I[95] = (T)(img)(_n6##x,_n2##y,z,c), \
 I[96] = (T)(img)(_p5##x,_n3##y,z,c), I[97] = (T)(img)(_p4##x,_n3##y,z,c), I[98] = (T)(img)(_p3##x,_n3##y,z,c), I[99] = (T)(img)(_p2##x,_n3##y,z,c), I[100] = (T)(img)(_p1##x,_n3##y,z,c), I[101] = (T)(img)(x,_n3##y,z,c), I[102] = (T)(img)(_n1##x,_n3##y,z,c), I[103] = (T)(img)(_n2##x,_n3##y,z,c), I[104] = (T)(img)(_n3##x,_n3##y,z,c), I[105] = (T)(img)(_n4##x,_n3##y,z,c), I[106] = (T)(img)(_n5##x,_n3##y,z,c), I[107] = (T)(img)(_n6##x,_n3##y,z,c), \
 I[108] = (T)(img)(_p5##x,_n4##y,z,c), I[109] = (T)(img)(_p4##x,_n4##y,z,c), I[110] = (T)(img)(_p3##x,_n4##y,z,c), I[111] = (T)(img)(_p2##x,_n4##y,z,c), I[112] = (T)(img)(_p1##x,_n4##y,z,c), I[113] = (T)(img)(x,_n4##y,z,c), I[114] = (T)(img)(_n1##x,_n4##y,z,c), I[115] = (T)(img)(_n2##x,_n4##y,z,c), I[116] = (T)(img)(_n3##x,_n4##y,z,c), I[117] = (T)(img)(_n4##x,_n4##y,z,c), I[118] = (T)(img)(_n5##x,_n4##y,z,c), I[119] = (T)(img)(_n6##x,_n4##y,z,c), \
 I[120] = (T)(img)(_p5##x,_n5##y,z,c), I[121] = (T)(img)(_p4##x,_n5##y,z,c), I[122] = (T)(img)(_p3##x,_n5##y,z,c), I[123] = (T)(img)(_p2##x,_n5##y,z,c), I[124] = (T)(img)(_p1##x,_n5##y,z,c), I[125] = (T)(img)(x,_n5##y,z,c), I[126] = (T)(img)(_n1##x,_n5##y,z,c), I[127] = (T)(img)(_n2##x,_n5##y,z,c), I[128] = (T)(img)(_n3##x,_n5##y,z,c), I[129] = (T)(img)(_n4##x,_n5##y,z,c), I[130] = (T)(img)(_n5##x,_n5##y,z,c), I[131] = (T)(img)(_n6##x,_n5##y,z,c), \
 I[132] = (T)(img)(_p5##x,_n6##y,z,c), I[133] = (T)(img)(_p4##x,_n6##y,z,c), I[134] = (T)(img)(_p3##x,_n6##y,z,c), I[135] = (T)(img)(_p2##x,_n6##y,z,c), I[136] = (T)(img)(_p1##x,_n6##y,z,c), I[137] = (T)(img)(x,_n6##y,z,c), I[138] = (T)(img)(_n1##x,_n6##y,z,c), I[139] = (T)(img)(_n2##x,_n6##y,z,c), I[140] = (T)(img)(_n3##x,_n6##y,z,c), I[141] = (T)(img)(_n4##x,_n6##y,z,c), I[142] = (T)(img)(_n5##x,_n6##y,z,c), I[143] = (T)(img)(_n6##x,_n6##y,z,c);

// Define 13x13 loop macros
//-------------------------
#define cimg_for13(bound,i) for (int i = 0, \
 _p6##i = 0, _p5##i = 0, _p4##i = 0, _p3##i = 0, _p2##i = 0, _p1##i = 0, \
 _n1##i = 1>=(int)(bound)?(int)(bound)-1:1, \
 _n2##i = 2>=(int)(bound)?(int)(bound)-1:2, \
 _n3##i = 3>=(int)(bound)?(int)(bound)-1:3, \
 _n4##i = 4>=(int)(bound)?(int)(bound)-1:4, \
 _n5##i = 5>=(int)(bound)?(int)(bound)-1:5, \
 _n6##i = 6>=(int)(bound)?(int)(bound)-1:6; \
 _n6##i<(int)(bound) || _n5##i==--_n6##i || _n4##i==--_n5##i || _n3##i==--_n4##i || _n2##i==--_n3##i || _n1##i==--_n2##i || \
 i==(_n6##i = _n5##i = _n4##i = _n3##i = _n2##i = --_n1##i); \
 _p6##i = _p5##i, _p5##i = _p4##i, _p4##i = _p3##i, _p3##i = _p2##i, _p2##i = _p1##i, _p1##i = i++, \
 ++_n1##i, ++_n2##i, ++_n3##i, ++_n4##i, ++_n5##i, ++_n6##i)

#define cimg_for13X(img,x) cimg_for13((img)._width,x)
#define cimg_for13Y(img,y) cimg_for13((img)._height,y)
#define cimg_for13Z(img,z) cimg_for13((img)._depth,z)
#define cimg_for13C(img,c) cimg_for13((img)._spectrum,c)
#define cimg_for13XY(img,x,y) cimg_for13Y(img,y) cimg_for13X(img,x)
#define cimg_for13XZ(img,x,z) cimg_for13Z(img,z) cimg_for13X(img,x)
#define cimg_for13XC(img,x,c) cimg_for13C(img,c) cimg_for13X(img,x)
#define cimg_for13YZ(img,y,z) cimg_for13Z(img,z) cimg_for13Y(img,y)
#define cimg_for13YC(img,y,c) cimg_for13C(img,c) cimg_for13Y(img,y)
#define cimg_for13ZC(img,z,c) cimg_for13C(img,c) cimg_for13Z(img,z)
#define cimg_for13XYZ(img,x,y,z) cimg_for13Z(img,z) cimg_for13XY(img,x,y)
#define cimg_for13XZC(img,x,z,c) cimg_for13C(img,c) cimg_for13XZ(img,x,z)
#define cimg_for13YZC(img,y,z,c) cimg_for13C(img,c) cimg_for13YZ(img,y,z)
#define cimg_for13XYZC(img,x,y,z,c) cimg_for13C(img,c) cimg_for13XYZ(img,x,y,z)

#define cimg_for_in13(bound,i0,i1,i) for (int i = (int)(i0)<0?0:(int)(i0), \
 _p6##i = i-6<0?0:i-6, \
 _p5##i = i-5<0?0:i-5, \
 _p4##i = i-4<0?0:i-4, \
 _p3##i = i-3<0?0:i-3, \
 _p2##i = i-2<0?0:i-2, \
 _p1##i = i-1<0?0:i-1, \
 _n1##i = i+1>=(int)(bound)?(int)(bound)-1:i+1, \
 _n2##i = i+2>=(int)(bound)?(int)(bound)-1:i+2, \
 _n3##i = i+3>=(int)(bound)?(int)(bound)-1:i+3, \
 _n4##i = i+4>=(int)(bound)?(int)(bound)-1:i+4, \
 _n5##i = i+5>=(int)(bound)?(int)(bound)-1:i+5, \
 _n6##i = i+6>=(int)(bound)?(int)(bound)-1:i+6; \
 i<=(int)(i1) && (_n6##i<(int)(bound) || _n5##i==--_n6##i || _n4##i==--_n5##i || _n3##i==--_n4##i || _n2##i==--_n3##i || _n1##i==--_n2##i || \
 i==(_n6##i = _n5##i = _n4##i = _n3##i = _n2##i = --_n1##i)); \
 _p6##i = _p5##i, _p5##i = _p4##i, _p4##i = _p3##i, _p3##i = _p2##i, _p2##i = _p1##i, _p1##i = i++, \
 ++_n1##i, ++_n2##i, ++_n3##i, ++_n4##i, ++_n5##i, ++_n6##i)

#define cimg_for_in13X(img,x0,x1,x) cimg_for_in13((img)._width,x0,x1,x)
#define cimg_for_in13Y(img,y0,y1,y) cimg_for_in13((img)._height,y0,y1,y)
#define cimg_for_in13Z(img,z0,z1,z) cimg_for_in13((img)._depth,z0,z1,z)
#define cimg_for_in13C(img,c0,c1,c) cimg_for_in13((img)._spectrum,c0,c1,c)
#define cimg_for_in13XY(img,x0,y0,x1,y1,x,y) cimg_for_in13Y(img,y0,y1,y) cimg_for_in13X(img,x0,x1,x)
#define cimg_for_in13XZ(img,x0,z0,x1,z1,x,z) cimg_for_in13Z(img,z0,z1,z) cimg_for_in13X(img,x0,x1,x)
#define cimg_for_in13XC(img,x0,c0,x1,c1,x,c) cimg_for_in13C(img,c0,c1,c) cimg_for_in13X(img,x0,x1,x)
#define cimg_for_in13YZ(img,y0,z0,y1,z1,y,z) cimg_for_in13Z(img,z0,z1,z) cimg_for_in13Y(img,y0,y1,y)
#define cimg_for_in13YC(img,y0,c0,y1,c1,y,c) cimg_for_in13C(img,c0,c1,c) cimg_for_in13Y(img,y0,y1,y)
#define cimg_for_in13ZC(img,z0,c0,z1,c1,z,c) cimg_for_in13C(img,c0,c1,c) cimg_for_in13Z(img,z0,z1,z)
#define cimg_for_in13XYZ(img,x0,y0,z0,x1,y1,z1,x,y,z) cimg_for_in13Z(img,z0,z1,z) cimg_for_in13XY(img,x0,y0,x1,y1,x,y)
#define cimg_for_in13XZC(img,x0,z0,c0,x1,y1,c1,x,z,c) cimg_for_in13C(img,c0,c1,c) cimg_for_in13XZ(img,x0,y0,x1,y1,x,z)
#define cimg_for_in13YZC(img,y0,z0,c0,y1,z1,c1,y,z,c) cimg_for_in13C(img,c0,c1,c) cimg_for_in13YZ(img,y0,z0,y1,z1,y,z)
#define cimg_for_in13XYZC(img,x0,y0,z0,c0,x1,y1,z1,c1,x,y,z,c) cimg_for_in13C(img,c0,c1,c) cimg_for_in13XYZ(img,x0,y0,z0,x1,y1,z1,x,y,z)

#define cimg_for13x13(img,x,y,z,c,I,T) \
 cimg_for13((img)._height,y) for (int x = 0, \
 _p6##x = 0, _p5##x = 0, _p4##x = 0, _p3##x = 0, _p2##x = 0, _p1##x = 0, \
 _n1##x = 1>=((img)._width)?(img).width()-1:1, \
 _n2##x = 2>=((img)._width)?(img).width()-1:2, \
 _n3##x = 3>=((img)._width)?(img).width()-1:3, \
 _n4##x = 4>=((img)._width)?(img).width()-1:4, \
 _n5##x = 5>=((img)._width)?(img).width()-1:5, \
 _n6##x = (int)( \
 (I[0] = I[1] = I[2] = I[3] = I[4] = I[5] = I[6] = (T)(img)(0,_p6##y,z,c)), \
 (I[13] = I[14] = I[15] = I[16] = I[17] = I[18] = I[19] = (T)(img)(0,_p5##y,z,c)), \
 (I[26] = I[27] = I[28] = I[29] = I[30] = I[31] = I[32] = (T)(img)(0,_p4##y,z,c)), \
 (I[39] = I[40] = I[41] = I[42] = I[43] = I[44] = I[45] = (T)(img)(0,_p3##y,z,c)), \
 (I[52] = I[53] = I[54] = I[55] = I[56] = I[57] = I[58] = (T)(img)(0,_p2##y,z,c)), \
 (I[65] = I[66] = I[67] = I[68] = I[69] = I[70] = I[71] = (T)(img)(0,_p1##y,z,c)), \
 (I[78] = I[79] = I[80] = I[81] = I[82] = I[83] = I[84] = (T)(img)(0,y,z,c)), \
 (I[91] = I[92] = I[93] = I[94] = I[95] = I[96] = I[97] = (T)(img)(0,_n1##y,z,c)), \
 (I[104] = I[105] = I[106] = I[107] = I[108] = I[109] = I[110] = (T)(img)(0,_n2##y,z,c)), \
 (I[117] = I[118] = I[119] = I[120] = I[121] = I[122] = I[123] = (T)(img)(0,_n3##y,z,c)), \
 (I[130] = I[131] = I[132] = I[133] = I[134] = I[135] = I[136] = (T)(img)(0,_n4##y,z,c)), \
 (I[143] = I[144] = I[145] = I[146] = I[147] = I[148] = I[149] = (T)(img)(0,_n5##y,z,c)), \
 (I[156] = I[157] = I[158] = I[159] = I[160] = I[161] = I[162] = (T)(img)(0,_n6##y,z,c)), \
 (I[7] = (T)(img)(_n1##x,_p6##y,z,c)), \
 (I[20] = (T)(img)(_n1##x,_p5##y,z,c)), \
 (I[33] = (T)(img)(_n1##x,_p4##y,z,c)), \
 (I[46] = (T)(img)(_n1##x,_p3##y,z,c)), \
 (I[59] = (T)(img)(_n1##x,_p2##y,z,c)), \
 (I[72] = (T)(img)(_n1##x,_p1##y,z,c)), \
 (I[85] = (T)(img)(_n1##x,y,z,c)), \
 (I[98] = (T)(img)(_n1##x,_n1##y,z,c)), \
 (I[111] = (T)(img)(_n1##x,_n2##y,z,c)), \
 (I[124] = (T)(img)(_n1##x,_n3##y,z,c)), \
 (I[137] = (T)(img)(_n1##x,_n4##y,z,c)), \
 (I[150] = (T)(img)(_n1##x,_n5##y,z,c)), \
 (I[163] = (T)(img)(_n1##x,_n6##y,z,c)), \
 (I[8] = (T)(img)(_n2##x,_p6##y,z,c)), \
 (I[21] = (T)(img)(_n2##x,_p5##y,z,c)), \
 (I[34] = (T)(img)(_n2##x,_p4##y,z,c)), \
 (I[47] = (T)(img)(_n2##x,_p3##y,z,c)), \
 (I[60] = (T)(img)(_n2##x,_p2##y,z,c)), \
 (I[73] = (T)(img)(_n2##x,_p1##y,z,c)), \
 (I[86] = (T)(img)(_n2##x,y,z,c)), \
 (I[99] = (T)(img)(_n2##x,_n1##y,z,c)), \
 (I[112] = (T)(img)(_n2##x,_n2##y,z,c)), \
 (I[125] = (T)(img)(_n2##x,_n3##y,z,c)), \
 (I[138] = (T)(img)(_n2##x,_n4##y,z,c)), \
 (I[151] = (T)(img)(_n2##x,_n5##y,z,c)), \
 (I[164] = (T)(img)(_n2##x,_n6##y,z,c)), \
 (I[9] = (T)(img)(_n3##x,_p6##y,z,c)), \
 (I[22] = (T)(img)(_n3##x,_p5##y,z,c)), \
 (I[35] = (T)(img)(_n3##x,_p4##y,z,c)), \
 (I[48] = (T)(img)(_n3##x,_p3##y,z,c)), \
 (I[61] = (T)(img)(_n3##x,_p2##y,z,c)), \
 (I[74] = (T)(img)(_n3##x,_p1##y,z,c)), \
 (I[87] = (T)(img)(_n3##x,y,z,c)), \
 (I[100] = (T)(img)(_n3##x,_n1##y,z,c)), \
 (I[113] = (T)(img)(_n3##x,_n2##y,z,c)), \
 (I[126] = (T)(img)(_n3##x,_n3##y,z,c)), \
 (I[139] = (T)(img)(_n3##x,_n4##y,z,c)), \
 (I[152] = (T)(img)(_n3##x,_n5##y,z,c)), \
 (I[165] = (T)(img)(_n3##x,_n6##y,z,c)), \
 (I[10] = (T)(img)(_n4##x,_p6##y,z,c)), \
 (I[23] = (T)(img)(_n4##x,_p5##y,z,c)), \
 (I[36] = (T)(img)(_n4##x,_p4##y,z,c)), \
 (I[49] = (T)(img)(_n4##x,_p3##y,z,c)), \
 (I[62] = (T)(img)(_n4##x,_p2##y,z,c)), \
 (I[75] = (T)(img)(_n4##x,_p1##y,z,c)), \
 (I[88] = (T)(img)(_n4##x,y,z,c)), \
 (I[101] = (T)(img)(_n4##x,_n1##y,z,c)), \
 (I[114] = (T)(img)(_n4##x,_n2##y,z,c)), \
 (I[127] = (T)(img)(_n4##x,_n3##y,z,c)), \
 (I[140] = (T)(img)(_n4##x,_n4##y,z,c)), \
 (I[153] = (T)(img)(_n4##x,_n5##y,z,c)), \
 (I[166] = (T)(img)(_n4##x,_n6##y,z,c)), \
 (I[11] = (T)(img)(_n5##x,_p6##y,z,c)), \
 (I[24] = (T)(img)(_n5##x,_p5##y,z,c)), \
 (I[37] = (T)(img)(_n5##x,_p4##y,z,c)), \
 (I[50] = (T)(img)(_n5##x,_p3##y,z,c)), \
 (I[63] = (T)(img)(_n5##x,_p2##y,z,c)), \
 (I[76] = (T)(img)(_n5##x,_p1##y,z,c)), \
 (I[89] = (T)(img)(_n5##x,y,z,c)), \
 (I[102] = (T)(img)(_n5##x,_n1##y,z,c)), \
 (I[115] = (T)(img)(_n5##x,_n2##y,z,c)), \
 (I[128] = (T)(img)(_n5##x,_n3##y,z,c)), \
 (I[141] = (T)(img)(_n5##x,_n4##y,z,c)), \
 (I[154] = (T)(img)(_n5##x,_n5##y,z,c)), \
 (I[167] = (T)(img)(_n5##x,_n6##y,z,c)), \
 6>=((img)._width)?(img).width()-1:6); \
 (_n6##x<(img).width() && ( \
 (I[12] = (T)(img)(_n6##x,_p6##y,z,c)), \
 (I[25] = (T)(img)(_n6##x,_p5##y,z,c)), \
 (I[38] = (T)(img)(_n6##x,_p4##y,z,c)), \
 (I[51] = (T)(img)(_n6##x,_p3##y,z,c)), \
 (I[64] = (T)(img)(_n6##x,_p2##y,z,c)), \
 (I[77] = (T)(img)(_n6##x,_p1##y,z,c)), \
 (I[90] = (T)(img)(_n6##x,y,z,c)), \
 (I[103] = (T)(img)(_n6##x,_n1##y,z,c)), \
 (I[116] = (T)(img)(_n6##x,_n2##y,z,c)), \
 (I[129] = (T)(img)(_n6##x,_n3##y,z,c)), \
 (I[142] = (T)(img)(_n6##x,_n4##y,z,c)), \
 (I[155] = (T)(img)(_n6##x,_n5##y,z,c)), \
 (I[168] = (T)(img)(_n6##x,_n6##y,z,c)),1)) || \
 _n5##x==--_n6##x || _n4##x==--_n5##x || _n3##x==--_n4##x || _n2##x==--_n3##x || _n1##x==--_n2##x || x==(_n6##x = _n5##x = _n4##x = _n3##x = _n2##x = --_n1##x); \
 I[0] = I[1], I[1] = I[2], I[2] = I[3], I[3] = I[4], I[4] = I[5], I[5] = I[6], I[6] = I[7], I[7] = I[8], I[8] = I[9], I[9] = I[10], I[10] = I[11], I[11] = I[12], \
 I[13] = I[14], I[14] = I[15], I[15] = I[16], I[16] = I[17], I[17] = I[18], I[18] = I[19], I[19] = I[20], I[20] = I[21], I[21] = I[22], I[22] = I[23], I[23] = I[24], I[24] = I[25], \
 I[26] = I[27], I[27] = I[28], I[28] = I[29], I[29] = I[30], I[30] = I[31], I[31] = I[32], I[32] = I[33], I[33] = I[34], I[34] = I[35], I[35] = I[36], I[36] = I[37], I[37] = I[38], \
 I[39] = I[40], I[40] = I[41], I[41] = I[42], I[42] = I[43], I[43] = I[44], I[44] = I[45], I[45] = I[46], I[46] = I[47], I[47] = I[48], I[48] = I[49], I[49] = I[50], I[50] = I[51], \
 I[52] = I[53], I[53] = I[54], I[54] = I[55], I[55] = I[56], I[56] = I[57], I[57] = I[58], I[58] = I[59], I[59] = I[60], I[60] = I[61], I[61] = I[62], I[62] = I[63], I[63] = I[64], \
 I[65] = I[66], I[66] = I[67], I[67] = I[68], I[68] = I[69], I[69] = I[70], I[70] = I[71], I[71] = I[72], I[72] = I[73], I[73] = I[74], I[74] = I[75], I[75] = I[76], I[76] = I[77], \
 I[78] = I[79], I[79] = I[80], I[80] = I[81], I[81] = I[82], I[82] = I[83], I[83] = I[84], I[84] = I[85], I[85] = I[86], I[86] = I[87], I[87] = I[88], I[88] = I[89], I[89] = I[90], \
 I[91] = I[92], I[92] = I[93], I[93] = I[94], I[94] = I[95], I[95] = I[96], I[96] = I[97], I[97] = I[98], I[98] = I[99], I[99] = I[100], I[100] = I[101], I[101] = I[102], I[102] = I[103], \
 I[104] = I[105], I[105] = I[106], I[106] = I[107], I[107] = I[108], I[108] = I[109], I[109] = I[110], I[110] = I[111], I[111] = I[112], I[112] = I[113], I[113] = I[114], I[114] = I[115], I[115] = I[116], \
 I[117] = I[118], I[118] = I[119], I[119] = I[120], I[120] = I[121], I[121] = I[122], I[122] = I[123], I[123] = I[124], I[124] = I[125], I[125] = I[126], I[126] = I[127], I[127] = I[128], I[128] = I[129], \
 I[130] = I[131], I[131] = I[132], I[132] = I[133], I[133] = I[134], I[134] = I[135], I[135] = I[136], I[136] = I[137], I[137] = I[138], I[138] = I[139], I[139] = I[140], I[140] = I[141], I[141] = I[142], \
 I[143] = I[144], I[144] = I[145], I[145] = I[146], I[146] = I[147], I[147] = I[148], I[148] = I[149], I[149] = I[150], I[150] = I[151], I[151] = I[152], I[152] = I[153], I[153] = I[154], I[154] = I[155], \
 I[156] = I[157], I[157] = I[158], I[158] = I[159], I[159] = I[160], I[160] = I[161], I[161] = I[162], I[162] = I[163], I[163] = I[164], I[164] = I[165], I[165] = I[166], I[166] = I[167], I[167] = I[168], \
 _p6##x = _p5##x, _p5##x = _p4##x, _p4##x = _p3##x, _p3##x = _p2##x, _p2##x = _p1##x, _p1##x = x++, ++_n1##x, ++_n2##x, ++_n3##x, ++_n4##x, ++_n5##x, ++_n6##x)

#define cimg_for_in13x13(img,x0,y0,x1,y1,x,y,z,c,I,T) \
 cimg_for_in13((img)._height,y0,y1,y) for (int x = (int)(x0)<0?0:(int)(x0), \
 _p6##x = x-6<0?0:x-6, \
 _p5##x = x-5<0?0:x-5, \
 _p4##x = x-4<0?0:x-4, \
 _p3##x = x-3<0?0:x-3, \
 _p2##x = x-2<0?0:x-2, \
 _p1##x = x-1<0?0:x-1, \
 _n1##x = x+1>=(img).width()?(img).width()-1:x+1, \
 _n2##x = x+2>=(img).width()?(img).width()-1:x+2, \
 _n3##x = x+3>=(img).width()?(img).width()-1:x+3, \
 _n4##x = x+4>=(img).width()?(img).width()-1:x+4, \
 _n5##x = x+5>=(img).width()?(img).width()-1:x+5, \
 _n6##x = (int)( \
 (I[0] = (T)(img)(_p6##x,_p6##y,z,c)), \
 (I[13] = (T)(img)(_p6##x,_p5##y,z,c)), \
 (I[26] = (T)(img)(_p6##x,_p4##y,z,c)), \
 (I[39] = (T)(img)(_p6##x,_p3##y,z,c)), \
 (I[52] = (T)(img)(_p6##x,_p2##y,z,c)), \
 (I[65] = (T)(img)(_p6##x,_p1##y,z,c)), \
 (I[78] = (T)(img)(_p6##x,y,z,c)), \
 (I[91] = (T)(img)(_p6##x,_n1##y,z,c)), \
 (I[104] = (T)(img)(_p6##x,_n2##y,z,c)), \
 (I[117] = (T)(img)(_p6##x,_n3##y,z,c)), \
 (I[130] = (T)(img)(_p6##x,_n4##y,z,c)), \
 (I[143] = (T)(img)(_p6##x,_n5##y,z,c)), \
 (I[156] = (T)(img)(_p6##x,_n6##y,z,c)), \
 (I[1] = (T)(img)(_p5##x,_p6##y,z,c)), \
 (I[14] = (T)(img)(_p5##x,_p5##y,z,c)), \
 (I[27] = (T)(img)(_p5##x,_p4##y,z,c)), \
 (I[40] = (T)(img)(_p5##x,_p3##y,z,c)), \
 (I[53] = (T)(img)(_p5##x,_p2##y,z,c)), \
 (I[66] = (T)(img)(_p5##x,_p1##y,z,c)), \
 (I[79] = (T)(img)(_p5##x,y,z,c)), \
 (I[92] = (T)(img)(_p5##x,_n1##y,z,c)), \
 (I[105] = (T)(img)(_p5##x,_n2##y,z,c)), \
 (I[118] = (T)(img)(_p5##x,_n3##y,z,c)), \
 (I[131] = (T)(img)(_p5##x,_n4##y,z,c)), \
 (I[144] = (T)(img)(_p5##x,_n5##y,z,c)), \
 (I[157] = (T)(img)(_p5##x,_n6##y,z,c)), \
 (I[2] = (T)(img)(_p4##x,_p6##y,z,c)), \
 (I[15] = (T)(img)(_p4##x,_p5##y,z,c)), \
 (I[28] = (T)(img)(_p4##x,_p4##y,z,c)), \
 (I[41] = (T)(img)(_p4##x,_p3##y,z,c)), \
 (I[54] = (T)(img)(_p4##x,_p2##y,z,c)), \
 (I[67] = (T)(img)(_p4##x,_p1##y,z,c)), \
 (I[80] = (T)(img)(_p4##x,y,z,c)), \
 (I[93] = (T)(img)(_p4##x,_n1##y,z,c)), \
 (I[106] = (T)(img)(_p4##x,_n2##y,z,c)), \
 (I[119] = (T)(img)(_p4##x,_n3##y,z,c)), \
 (I[132] = (T)(img)(_p4##x,_n4##y,z,c)), \
 (I[145] = (T)(img)(_p4##x,_n5##y,z,c)), \
 (I[158] = (T)(img)(_p4##x,_n6##y,z,c)), \
 (I[3] = (T)(img)(_p3##x,_p6##y,z,c)), \
 (I[16] = (T)(img)(_p3##x,_p5##y,z,c)), \
 (I[29] = (T)(img)(_p3##x,_p4##y,z,c)), \
 (I[42] = (T)(img)(_p3##x,_p3##y,z,c)), \
 (I[55] = (T)(img)(_p3##x,_p2##y,z,c)), \
 (I[68] = (T)(img)(_p3##x,_p1##y,z,c)), \
 (I[81] = (T)(img)(_p3##x,y,z,c)), \
 (I[94] = (T)(img)(_p3##x,_n1##y,z,c)), \
 (I[107] = (T)(img)(_p3##x,_n2##y,z,c)), \
 (I[120] = (T)(img)(_p3##x,_n3##y,z,c)), \
 (I[133] = (T)(img)(_p3##x,_n4##y,z,c)), \
 (I[146] = (T)(img)(_p3##x,_n5##y,z,c)), \
 (I[159] = (T)(img)(_p3##x,_n6##y,z,c)), \
 (I[4] = (T)(img)(_p2##x,_p6##y,z,c)), \
 (I[17] = (T)(img)(_p2##x,_p5##y,z,c)), \
 (I[30] = (T)(img)(_p2##x,_p4##y,z,c)), \
 (I[43] = (T)(img)(_p2##x,_p3##y,z,c)), \
 (I[56] = (T)(img)(_p2##x,_p2##y,z,c)), \
 (I[69] = (T)(img)(_p2##x,_p1##y,z,c)), \
 (I[82] = (T)(img)(_p2##x,y,z,c)), \
 (I[95] = (T)(img)(_p2##x,_n1##y,z,c)), \
 (I[108] = (T)(img)(_p2##x,_n2##y,z,c)), \
 (I[121] = (T)(img)(_p2##x,_n3##y,z,c)), \
 (I[134] = (T)(img)(_p2##x,_n4##y,z,c)), \
 (I[147] = (T)(img)(_p2##x,_n5##y,z,c)), \
 (I[160] = (T)(img)(_p2##x,_n6##y,z,c)), \
 (I[5] = (T)(img)(_p1##x,_p6##y,z,c)), \
 (I[18] = (T)(img)(_p1##x,_p5##y,z,c)), \
 (I[31] = (T)(img)(_p1##x,_p4##y,z,c)), \
 (I[44] = (T)(img)(_p1##x,_p3##y,z,c)), \
 (I[57] = (T)(img)(_p1##x,_p2##y,z,c)), \
 (I[70] = (T)(img)(_p1##x,_p1##y,z,c)), \
 (I[83] = (T)(img)(_p1##x,y,z,c)), \
 (I[96] = (T)(img)(_p1##x,_n1##y,z,c)), \
 (I[109] = (T)(img)(_p1##x,_n2##y,z,c)), \
 (I[122] = (T)(img)(_p1##x,_n3##y,z,c)), \
 (I[135] = (T)(img)(_p1##x,_n4##y,z,c)), \
 (I[148] = (T)(img)(_p1##x,_n5##y,z,c)), \
 (I[161] = (T)(img)(_p1##x,_n6##y,z,c)), \
 (I[6] = (T)(img)(x,_p6##y,z,c)), \
 (I[19] = (T)(img)(x,_p5##y,z,c)), \
 (I[32] = (T)(img)(x,_p4##y,z,c)), \
 (I[45] = (T)(img)(x,_p3##y,z,c)), \
 (I[58] = (T)(img)(x,_p2##y,z,c)), \
 (I[71] = (T)(img)(x,_p1##y,z,c)), \
 (I[84] = (T)(img)(x,y,z,c)), \
 (I[97] = (T)(img)(x,_n1##y,z,c)), \
 (I[110] = (T)(img)(x,_n2##y,z,c)), \
 (I[123] = (T)(img)(x,_n3##y,z,c)), \
 (I[136] = (T)(img)(x,_n4##y,z,c)), \
 (I[149] = (T)(img)(x,_n5##y,z,c)), \
 (I[162] = (T)(img)(x,_n6##y,z,c)), \
 (I[7] = (T)(img)(_n1##x,_p6##y,z,c)), \
 (I[20] = (T)(img)(_n1##x,_p5##y,z,c)), \
 (I[33] = (T)(img)(_n1##x,_p4##y,z,c)), \
 (I[46] = (T)(img)(_n1##x,_p3##y,z,c)), \
 (I[59] = (T)(img)(_n1##x,_p2##y,z,c)), \
 (I[72] = (T)(img)(_n1##x,_p1##y,z,c)), \
 (I[85] = (T)(img)(_n1##x,y,z,c)), \
 (I[98] = (T)(img)(_n1##x,_n1##y,z,c)), \
 (I[111] = (T)(img)(_n1##x,_n2##y,z,c)), \
 (I[124] = (T)(img)(_n1##x,_n3##y,z,c)), \
 (I[137] = (T)(img)(_n1##x,_n4##y,z,c)), \
 (I[150] = (T)(img)(_n1##x,_n5##y,z,c)), \
 (I[163] = (T)(img)(_n1##x,_n6##y,z,c)), \
 (I[8] = (T)(img)(_n2##x,_p6##y,z,c)), \
 (I[21] = (T)(img)(_n2##x,_p5##y,z,c)), \
 (I[34] = (T)(img)(_n2##x,_p4##y,z,c)), \
 (I[47] = (T)(img)(_n2##x,_p3##y,z,c)), \
 (I[60] = (T)(img)(_n2##x,_p2##y,z,c)), \
 (I[73] = (T)(img)(_n2##x,_p1##y,z,c)), \
 (I[86] = (T)(img)(_n2##x,y,z,c)), \
 (I[99] = (T)(img)(_n2##x,_n1##y,z,c)), \
 (I[112] = (T)(img)(_n2##x,_n2##y,z,c)), \
 (I[125] = (T)(img)(_n2##x,_n3##y,z,c)), \
 (I[138] = (T)(img)(_n2##x,_n4##y,z,c)), \
 (I[151] = (T)(img)(_n2##x,_n5##y,z,c)), \
 (I[164] = (T)(img)(_n2##x,_n6##y,z,c)), \
 (I[9] = (T)(img)(_n3##x,_p6##y,z,c)), \
 (I[22] = (T)(img)(_n3##x,_p5##y,z,c)), \
 (I[35] = (T)(img)(_n3##x,_p4##y,z,c)), \
 (I[48] = (T)(img)(_n3##x,_p3##y,z,c)), \
 (I[61] = (T)(img)(_n3##x,_p2##y,z,c)), \
 (I[74] = (T)(img)(_n3##x,_p1##y,z,c)), \
 (I[87] = (T)(img)(_n3##x,y,z,c)), \
 (I[100] = (T)(img)(_n3##x,_n1##y,z,c)), \
 (I[113] = (T)(img)(_n3##x,_n2##y,z,c)), \
 (I[126] = (T)(img)(_n3##x,_n3##y,z,c)), \
 (I[139] = (T)(img)(_n3##x,_n4##y,z,c)), \
 (I[152] = (T)(img)(_n3##x,_n5##y,z,c)), \
 (I[165] = (T)(img)(_n3##x,_n6##y,z,c)), \
 (I[10] = (T)(img)(_n4##x,_p6##y,z,c)), \
 (I[23] = (T)(img)(_n4##x,_p5##y,z,c)), \
 (I[36] = (T)(img)(_n4##x,_p4##y,z,c)), \
 (I[49] = (T)(img)(_n4##x,_p3##y,z,c)), \
 (I[62] = (T)(img)(_n4##x,_p2##y,z,c)), \
 (I[75] = (T)(img)(_n4##x,_p1##y,z,c)), \
 (I[88] = (T)(img)(_n4##x,y,z,c)), \
 (I[101] = (T)(img)(_n4##x,_n1##y,z,c)), \
 (I[114] = (T)(img)(_n4##x,_n2##y,z,c)), \
 (I[127] = (T)(img)(_n4##x,_n3##y,z,c)), \
 (I[140] = (T)(img)(_n4##x,_n4##y,z,c)), \
 (I[153] = (T)(img)(_n4##x,_n5##y,z,c)), \
 (I[166] = (T)(img)(_n4##x,_n6##y,z,c)), \
 (I[11] = (T)(img)(_n5##x,_p6##y,z,c)), \
 (I[24] = (T)(img)(_n5##x,_p5##y,z,c)), \
 (I[37] = (T)(img)(_n5##x,_p4##y,z,c)), \
 (I[50] = (T)(img)(_n5##x,_p3##y,z,c)), \
 (I[63] = (T)(img)(_n5##x,_p2##y,z,c)), \
 (I[76] = (T)(img)(_n5##x,_p1##y,z,c)), \
 (I[89] = (T)(img)(_n5##x,y,z,c)), \
 (I[102] = (T)(img)(_n5##x,_n1##y,z,c)), \
 (I[115] = (T)(img)(_n5##x,_n2##y,z,c)), \
 (I[128] = (T)(img)(_n5##x,_n3##y,z,c)), \
 (I[141] = (T)(img)(_n5##x,_n4##y,z,c)), \
 (I[154] = (T)(img)(_n5##x,_n5##y,z,c)), \
 (I[167] = (T)(img)(_n5##x,_n6##y,z,c)), \
 x+6>=(img).width()?(img).width()-1:x+6); \
 x<=(int)(x1) && ((_n6##x<(img).width() && ( \
 (I[12] = (T)(img)(_n6##x,_p6##y,z,c)), \
 (I[25] = (T)(img)(_n6##x,_p5##y,z,c)), \
 (I[38] = (T)(img)(_n6##x,_p4##y,z,c)), \
 (I[51] = (T)(img)(_n6##x,_p3##y,z,c)), \
 (I[64] = (T)(img)(_n6##x,_p2##y,z,c)), \
 (I[77] = (T)(img)(_n6##x,_p1##y,z,c)), \
 (I[90] = (T)(img)(_n6##x,y,z,c)), \
 (I[103] = (T)(img)(_n6##x,_n1##y,z,c)), \
 (I[116] = (T)(img)(_n6##x,_n2##y,z,c)), \
 (I[129] = (T)(img)(_n6##x,_n3##y,z,c)), \
 (I[142] = (T)(img)(_n6##x,_n4##y,z,c)), \
 (I[155] = (T)(img)(_n6##x,_n5##y,z,c)), \
 (I[168] = (T)(img)(_n6##x,_n6##y,z,c)),1)) || \
 _n5##x==--_n6##x || _n4##x==--_n5##x || _n3##x==--_n4##x || _n2##x==--_n3##x || _n1##x==--_n2##x || x==(_n6##x = _n5##x = _n4##x = _n3##x = _n2##x = --_n1##x)); \
 I[0] = I[1], I[1] = I[2], I[2] = I[3], I[3] = I[4], I[4] = I[5], I[5] = I[6], I[6] = I[7], I[7] = I[8], I[8] = I[9], I[9] = I[10], I[10] = I[11], I[11] = I[12], \
 I[13] = I[14], I[14] = I[15], I[15] = I[16], I[16] = I[17], I[17] = I[18], I[18] = I[19], I[19] = I[20], I[20] = I[21], I[21] = I[22], I[22] = I[23], I[23] = I[24], I[24] = I[25], \
 I[26] = I[27], I[27] = I[28], I[28] = I[29], I[29] = I[30], I[30] = I[31], I[31] = I[32], I[32] = I[33], I[33] = I[34], I[34] = I[35], I[35] = I[36], I[36] = I[37], I[37] = I[38], \
 I[39] = I[40], I[40] = I[41], I[41] = I[42], I[42] = I[43], I[43] = I[44], I[44] = I[45], I[45] = I[46], I[46] = I[47], I[47] = I[48], I[48] = I[49], I[49] = I[50], I[50] = I[51], \
 I[52] = I[53], I[53] = I[54], I[54] = I[55], I[55] = I[56], I[56] = I[57], I[57] = I[58], I[58] = I[59], I[59] = I[60], I[60] = I[61], I[61] = I[62], I[62] = I[63], I[63] = I[64], \
 I[65] = I[66], I[66] = I[67], I[67] = I[68], I[68] = I[69], I[69] = I[70], I[70] = I[71], I[71] = I[72], I[72] = I[73], I[73] = I[74], I[74] = I[75], I[75] = I[76], I[76] = I[77], \
 I[78] = I[79], I[79] = I[80], I[80] = I[81], I[81] = I[82], I[82] = I[83], I[83] = I[84], I[84] = I[85], I[85] = I[86], I[86] = I[87], I[87] = I[88], I[88] = I[89], I[89] = I[90], \
 I[91] = I[92], I[92] = I[93], I[93] = I[94], I[94] = I[95], I[95] = I[96], I[96] = I[97], I[97] = I[98], I[98] = I[99], I[99] = I[100], I[100] = I[101], I[101] = I[102], I[102] = I[103], \
 I[104] = I[105], I[105] = I[106], I[106] = I[107], I[107] = I[108], I[108] = I[109], I[109] = I[110], I[110] = I[111], I[111] = I[112], I[112] = I[113], I[113] = I[114], I[114] = I[115], I[115] = I[116], \
 I[117] = I[118], I[118] = I[119], I[119] = I[120], I[120] = I[121], I[121] = I[122], I[122] = I[123], I[123] = I[124], I[124] = I[125], I[125] = I[126], I[126] = I[127], I[127] = I[128], I[128] = I[129], \
 I[130] = I[131], I[131] = I[132], I[132] = I[133], I[133] = I[134], I[134] = I[135], I[135] = I[136], I[136] = I[137], I[137] = I[138], I[138] = I[139], I[139] = I[140], I[140] = I[141], I[141] = I[142], \
 I[143] = I[144], I[144] = I[145], I[145] = I[146], I[146] = I[147], I[147] = I[148], I[148] = I[149], I[149] = I[150], I[150] = I[151], I[151] = I[152], I[152] = I[153], I[153] = I[154], I[154] = I[155], \
 I[156] = I[157], I[157] = I[158], I[158] = I[159], I[159] = I[160], I[160] = I[161], I[161] = I[162], I[162] = I[163], I[163] = I[164], I[164] = I[165], I[165] = I[166], I[166] = I[167], I[167] = I[168], \
 _p6##x = _p5##x, _p5##x = _p4##x, _p4##x = _p3##x, _p3##x = _p2##x, _p2##x = _p1##x, _p1##x = x++, ++_n1##x, ++_n2##x, ++_n3##x, ++_n4##x, ++_n5##x, ++_n6##x)

#define cimg_get13x13(img,x,y,z,c,I,T) \
 I[0] = (T)(img)(_p6##x,_p6##y,z,c), I[1] = (T)(img)(_p5##x,_p6##y,z,c), I[2] = (T)(img)(_p4##x,_p6##y,z,c), I[3] = (T)(img)(_p3##x,_p6##y,z,c), I[4] = (T)(img)(_p2##x,_p6##y,z,c), I[5] = (T)(img)(_p1##x,_p6##y,z,c), I[6] = (T)(img)(x,_p6##y,z,c), I[7] = (T)(img)(_n1##x,_p6##y,z,c), I[8] = (T)(img)(_n2##x,_p6##y,z,c), I[9] = (T)(img)(_n3##x,_p6##y,z,c), I[10] = (T)(img)(_n4##x,_p6##y,z,c), I[11] = (T)(img)(_n5##x,_p6##y,z,c), I[12] = (T)(img)(_n6##x,_p6##y,z,c), \
 I[13] = (T)(img)(_p6##x,_p5##y,z,c), I[14] = (T)(img)(_p5##x,_p5##y,z,c), I[15] = (T)(img)(_p4##x,_p5##y,z,c), I[16] = (T)(img)(_p3##x,_p5##y,z,c), I[17] = (T)(img)(_p2##x,_p5##y,z,c), I[18] = (T)(img)(_p1##x,_p5##y,z,c), I[19] = (T)(img)(x,_p5##y,z,c), I[20] = (T)(img)(_n1##x,_p5##y,z,c), I[21] = (T)(img)(_n2##x,_p5##y,z,c), I[22] = (T)(img)(_n3##x,_p5##y,z,c), I[23] = (T)(img)(_n4##x,_p5##y,z,c), I[24] = (T)(img)(_n5##x,_p5##y,z,c), I[25] = (T)(img)(_n6##x,_p5##y,z,c), \
 I[26] = (T)(img)(_p6##x,_p4##y,z,c), I[27] = (T)(img)(_p5##x,_p4##y,z,c), I[28] = (T)(img)(_p4##x,_p4##y,z,c), I[29] = (T)(img)(_p3##x,_p4##y,z,c), I[30] = (T)(img)(_p2##x,_p4##y,z,c), I[31] = (T)(img)(_p1##x,_p4##y,z,c), I[32] = (T)(img)(x,_p4##y,z,c), I[33] = (T)(img)(_n1##x,_p4##y,z,c), I[34] = (T)(img)(_n2##x,_p4##y,z,c), I[35] = (T)(img)(_n3##x,_p4##y,z,c), I[36] = (T)(img)(_n4##x,_p4##y,z,c), I[37] = (T)(img)(_n5##x,_p4##y,z,c), I[38] = (T)(img)(_n6##x,_p4##y,z,c), \
 I[39] = (T)(img)(_p6##x,_p3##y,z,c), I[40] = (T)(img)(_p5##x,_p3##y,z,c), I[41] = (T)(img)(_p4##x,_p3##y,z,c), I[42] = (T)(img)(_p3##x,_p3##y,z,c), I[43] = (T)(img)(_p2##x,_p3##y,z,c), I[44] = (T)(img)(_p1##x,_p3##y,z,c), I[45] = (T)(img)(x,_p3##y,z,c), I[46] = (T)(img)(_n1##x,_p3##y,z,c), I[47] = (T)(img)(_n2##x,_p3##y,z,c), I[48] = (T)(img)(_n3##x,_p3##y,z,c), I[49] = (T)(img)(_n4##x,_p3##y,z,c), I[50] = (T)(img)(_n5##x,_p3##y,z,c), I[51] = (T)(img)(_n6##x,_p3##y,z,c), \
 I[52] = (T)(img)(_p6##x,_p2##y,z,c), I[53] = (T)(img)(_p5##x,_p2##y,z,c), I[54] = (T)(img)(_p4##x,_p2##y,z,c), I[55] = (T)(img)(_p3##x,_p2##y,z,c), I[56] = (T)(img)(_p2##x,_p2##y,z,c), I[57] = (T)(img)(_p1##x,_p2##y,z,c), I[58] = (T)(img)(x,_p2##y,z,c), I[59] = (T)(img)(_n1##x,_p2##y,z,c), I[60] = (T)(img)(_n2##x,_p2##y,z,c), I[61] = (T)(img)(_n3##x,_p2##y,z,c), I[62] = (T)(img)(_n4##x,_p2##y,z,c), I[63] = (T)(img)(_n5##x,_p2##y,z,c), I[64] = (T)(img)(_n6##x,_p2##y,z,c), \
 I[65] = (T)(img)(_p6##x,_p1##y,z,c), I[66] = (T)(img)(_p5##x,_p1##y,z,c), I[67] = (T)(img)(_p4##x,_p1##y,z,c), I[68] = (T)(img)(_p3##x,_p1##y,z,c), I[69] = (T)(img)(_p2##x,_p1##y,z,c), I[70] = (T)(img)(_p1##x,_p1##y,z,c), I[71] = (T)(img)(x,_p1##y,z,c), I[72] = (T)(img)(_n1##x,_p1##y,z,c), I[73] = (T)(img)(_n2##x,_p1##y,z,c), I[74] = (T)(img)(_n3##x,_p1##y,z,c), I[75] = (T)(img)(_n4##x,_p1##y,z,c), I[76] = (T)(img)(_n5##x,_p1##y,z,c), I[77] = (T)(img)(_n6##x,_p1##y,z,c), \
 I[78] = (T)(img)(_p6##x,y,z,c), I[79] = (T)(img)(_p5##x,y,z,c), I[80] = (T)(img)(_p4##x,y,z,c), I[81] = (T)(img)(_p3##x,y,z,c), I[82] = (T)(img)(_p2##x,y,z,c), I[83] = (T)(img)(_p1##x,y,z,c), I[84] = (T)(img)(x,y,z,c), I[85] = (T)(img)(_n1##x,y,z,c), I[86] = (T)(img)(_n2##x,y,z,c), I[87] = (T)(img)(_n3##x,y,z,c), I[88] = (T)(img)(_n4##x,y,z,c), I[89] = (T)(img)(_n5##x,y,z,c), I[90] = (T)(img)(_n6##x,y,z,c), \
 I[91] = (T)(img)(_p6##x,_n1##y,z,c), I[92] = (T)(img)(_p5##x,_n1##y,z,c), I[93] = (T)(img)(_p4##x,_n1##y,z,c), I[94] = (T)(img)(_p3##x,_n1##y,z,c), I[95] = (T)(img)(_p2##x,_n1##y,z,c), I[96] = (T)(img)(_p1##x,_n1##y,z,c), I[97] = (T)(img)(x,_n1##y,z,c), I[98] = (T)(img)(_n1##x,_n1##y,z,c), I[99] = (T)(img)(_n2##x,_n1##y,z,c), I[100] = (T)(img)(_n3##x,_n1##y,z,c), I[101] = (T)(img)(_n4##x,_n1##y,z,c), I[102] = (T)(img)(_n5##x,_n1##y,z,c), I[103] = (T)(img)(_n6##x,_n1##y,z,c), \
 I[104] = (T)(img)(_p6##x,_n2##y,z,c), I[105] = (T)(img)(_p5##x,_n2##y,z,c), I[106] = (T)(img)(_p4##x,_n2##y,z,c), I[107] = (T)(img)(_p3##x,_n2##y,z,c), I[108] = (T)(img)(_p2##x,_n2##y,z,c), I[109] = (T)(img)(_p1##x,_n2##y,z,c), I[110] = (T)(img)(x,_n2##y,z,c), I[111] = (T)(img)(_n1##x,_n2##y,z,c), I[112] = (T)(img)(_n2##x,_n2##y,z,c), I[113] = (T)(img)(_n3##x,_n2##y,z,c), I[114] = (T)(img)(_n4##x,_n2##y,z,c), I[115] = (T)(img)(_n5##x,_n2##y,z,c), I[116] = (T)(img)(_n6##x,_n2##y,z,c), \
 I[117] = (T)(img)(_p6##x,_n3##y,z,c), I[118] = (T)(img)(_p5##x,_n3##y,z,c), I[119] = (T)(img)(_p4##x,_n3##y,z,c), I[120] = (T)(img)(_p3##x,_n3##y,z,c), I[121] = (T)(img)(_p2##x,_n3##y,z,c), I[122] = (T)(img)(_p1##x,_n3##y,z,c), I[123] = (T)(img)(x,_n3##y,z,c), I[124] = (T)(img)(_n1##x,_n3##y,z,c), I[125] = (T)(img)(_n2##x,_n3##y,z,c), I[126] = (T)(img)(_n3##x,_n3##y,z,c), I[127] = (T)(img)(_n4##x,_n3##y,z,c), I[128] = (T)(img)(_n5##x,_n3##y,z,c), I[129] = (T)(img)(_n6##x,_n3##y,z,c), \
 I[130] = (T)(img)(_p6##x,_n4##y,z,c), I[131] = (T)(img)(_p5##x,_n4##y,z,c), I[132] = (T)(img)(_p4##x,_n4##y,z,c), I[133] = (T)(img)(_p3##x,_n4##y,z,c), I[134] = (T)(img)(_p2##x,_n4##y,z,c), I[135] = (T)(img)(_p1##x,_n4##y,z,c), I[136] = (T)(img)(x,_n4##y,z,c), I[137] = (T)(img)(_n1##x,_n4##y,z,c), I[138] = (T)(img)(_n2##x,_n4##y,z,c), I[139] = (T)(img)(_n3##x,_n4##y,z,c), I[140] = (T)(img)(_n4##x,_n4##y,z,c), I[141] = (T)(img)(_n5##x,_n4##y,z,c), I[142] = (T)(img)(_n6##x,_n4##y,z,c), \
 I[143] = (T)(img)(_p6##x,_n5##y,z,c), I[144] = (T)(img)(_p5##x,_n5##y,z,c), I[145] = (T)(img)(_p4##x,_n5##y,z,c), I[146] = (T)(img)(_p3##x,_n5##y,z,c), I[147] = (T)(img)(_p2##x,_n5##y,z,c), I[148] = (T)(img)(_p1##x,_n5##y,z,c), I[149] = (T)(img)(x,_n5##y,z,c), I[150] = (T)(img)(_n1##x,_n5##y,z,c), I[151] = (T)(img)(_n2##x,_n5##y,z,c), I[152] = (T)(img)(_n3##x,_n5##y,z,c), I[153] = (T)(img)(_n4##x,_n5##y,z,c), I[154] = (T)(img)(_n5##x,_n5##y,z,c), I[155] = (T)(img)(_n6##x,_n5##y,z,c), \
 I[156] = (T)(img)(_p6##x,_n6##y,z,c), I[157] = (T)(img)(_p5##x,_n6##y,z,c), I[158] = (T)(img)(_p4##x,_n6##y,z,c), I[159] = (T)(img)(_p3##x,_n6##y,z,c), I[160] = (T)(img)(_p2##x,_n6##y,z,c), I[161] = (T)(img)(_p1##x,_n6##y,z,c), I[162] = (T)(img)(x,_n6##y,z,c), I[163] = (T)(img)(_n1##x,_n6##y,z,c), I[164] = (T)(img)(_n2##x,_n6##y,z,c), I[165] = (T)(img)(_n3##x,_n6##y,z,c), I[166] = (T)(img)(_n4##x,_n6##y,z,c), I[167] = (T)(img)(_n5##x,_n6##y,z,c), I[168] = (T)(img)(_n6##x,_n6##y,z,c);

// Define 14x14 loop macros
//-------------------------
#define cimg_for14(bound,i) for (int i = 0, \
 _p6##i = 0, _p5##i = 0, _p4##i = 0, _p3##i = 0, _p2##i = 0, _p1##i = 0, \
 _n1##i = 1>=(int)(bound)?(int)(bound)-1:1, \
 _n2##i = 2>=(int)(bound)?(int)(bound)-1:2, \
 _n3##i = 3>=(int)(bound)?(int)(bound)-1:3, \
 _n4##i = 4>=(int)(bound)?(int)(bound)-1:4, \
 _n5##i = 5>=(int)(bound)?(int)(bound)-1:5, \
 _n6##i = 6>=(int)(bound)?(int)(bound)-1:6, \
 _n7##i = 7>=(int)(bound)?(int)(bound)-1:7; \
 _n7##i<(int)(bound) || _n6##i==--_n7##i || _n5##i==--_n6##i || _n4##i==--_n5##i || _n3##i==--_n4##i || _n2##i==--_n3##i || _n1##i==--_n2##i || \
 i==(_n7##i = _n6##i = _n5##i = _n4##i = _n3##i = _n2##i = --_n1##i); \
 _p6##i = _p5##i, _p5##i = _p4##i, _p4##i = _p3##i, _p3##i = _p2##i, _p2##i = _p1##i, _p1##i = i++, \
 ++_n1##i, ++_n2##i, ++_n3##i, ++_n4##i, ++_n5##i, ++_n6##i, ++_n7##i)

#define cimg_for14X(img,x) cimg_for14((img)._width,x)
#define cimg_for14Y(img,y) cimg_for14((img)._height,y)
#define cimg_for14Z(img,z) cimg_for14((img)._depth,z)
#define cimg_for14C(img,c) cimg_for14((img)._spectrum,c)
#define cimg_for14XY(img,x,y) cimg_for14Y(img,y) cimg_for14X(img,x)
#define cimg_for14XZ(img,x,z) cimg_for14Z(img,z) cimg_for14X(img,x)
#define cimg_for14XC(img,x,c) cimg_for14C(img,c) cimg_for14X(img,x)
#define cimg_for14YZ(img,y,z) cimg_for14Z(img,z) cimg_for14Y(img,y)
#define cimg_for14YC(img,y,c) cimg_for14C(img,c) cimg_for14Y(img,y)
#define cimg_for14ZC(img,z,c) cimg_for14C(img,c) cimg_for14Z(img,z)
#define cimg_for14XYZ(img,x,y,z) cimg_for14Z(img,z) cimg_for14XY(img,x,y)
#define cimg_for14XZC(img,x,z,c) cimg_for14C(img,c) cimg_for14XZ(img,x,z)
#define cimg_for14YZC(img,y,z,c) cimg_for14C(img,c) cimg_for14YZ(img,y,z)
#define cimg_for14XYZC(img,x,y,z,c) cimg_for14C(img,c) cimg_for14XYZ(img,x,y,z)

#define cimg_for_in14(bound,i0,i1,i) for (int i = (int)(i0)<0?0:(int)(i0), \
 _p6##i = i-6<0?0:i-6, \
 _p5##i = i-5<0?0:i-5, \
 _p4##i = i-4<0?0:i-4, \
 _p3##i = i-3<0?0:i-3, \
 _p2##i = i-2<0?0:i-2, \
 _p1##i = i-1<0?0:i-1, \
 _n1##i = i+1>=(int)(bound)?(int)(bound)-1:i+1, \
 _n2##i = i+2>=(int)(bound)?(int)(bound)-1:i+2, \
 _n3##i = i+3>=(int)(bound)?(int)(bound)-1:i+3, \
 _n4##i = i+4>=(int)(bound)?(int)(bound)-1:i+4, \
 _n5##i = i+5>=(int)(bound)?(int)(bound)-1:i+5, \
 _n6##i = i+6>=(int)(bound)?(int)(bound)-1:i+6, \
 _n7##i = i+7>=(int)(bound)?(int)(bound)-1:i+7; \
 i<=(int)(i1) && (_n7##i<(int)(bound) || _n6##i==--_n7##i || _n5##i==--_n6##i || _n4##i==--_n5##i || _n3##i==--_n4##i || _n2##i==--_n3##i || _n1##i==--_n2##i || \
 i==(_n7##i = _n6##i = _n5##i = _n4##i = _n3##i = _n2##i = --_n1##i)); \
 _p6##i = _p5##i, _p5##i = _p4##i, _p4##i = _p3##i, _p3##i = _p2##i, _p2##i = _p1##i, _p1##i = i++, \
 ++_n1##i, ++_n2##i, ++_n3##i, ++_n4##i, ++_n5##i, ++_n6##i, ++_n7##i)

#define cimg_for_in14X(img,x0,x1,x) cimg_for_in14((img)._width,x0,x1,x)
#define cimg_for_in14Y(img,y0,y1,y) cimg_for_in14((img)._height,y0,y1,y)
#define cimg_for_in14Z(img,z0,z1,z) cimg_for_in14((img)._depth,z0,z1,z)
#define cimg_for_in14C(img,c0,c1,c) cimg_for_in14((img)._spectrum,c0,c1,c)
#define cimg_for_in14XY(img,x0,y0,x1,y1,x,y) cimg_for_in14Y(img,y0,y1,y) cimg_for_in14X(img,x0,x1,x)
#define cimg_for_in14XZ(img,x0,z0,x1,z1,x,z) cimg_for_in14Z(img,z0,z1,z) cimg_for_in14X(img,x0,x1,x)
#define cimg_for_in14XC(img,x0,c0,x1,c1,x,c) cimg_for_in14C(img,c0,c1,c) cimg_for_in14X(img,x0,x1,x)
#define cimg_for_in14YZ(img,y0,z0,y1,z1,y,z) cimg_for_in14Z(img,z0,z1,z) cimg_for_in14Y(img,y0,y1,y)
#define cimg_for_in14YC(img,y0,c0,y1,c1,y,c) cimg_for_in14C(img,c0,c1,c) cimg_for_in14Y(img,y0,y1,y)
#define cimg_for_in14ZC(img,z0,c0,z1,c1,z,c) cimg_for_in14C(img,c0,c1,c) cimg_for_in14Z(img,z0,z1,z)
#define cimg_for_in14XYZ(img,x0,y0,z0,x1,y1,z1,x,y,z) cimg_for_in14Z(img,z0,z1,z) cimg_for_in14XY(img,x0,y0,x1,y1,x,y)
#define cimg_for_in14XZC(img,x0,z0,c0,x1,y1,c1,x,z,c) cimg_for_in14C(img,c0,c1,c) cimg_for_in14XZ(img,x0,y0,x1,y1,x,z)
#define cimg_for_in14YZC(img,y0,z0,c0,y1,z1,c1,y,z,c) cimg_for_in14C(img,c0,c1,c) cimg_for_in14YZ(img,y0,z0,y1,z1,y,z)
#define cimg_for_in14XYZC(img,x0,y0,z0,c0,x1,y1,z1,c1,x,y,z,c) cimg_for_in14C(img,c0,c1,c) cimg_for_in14XYZ(img,x0,y0,z0,x1,y1,z1,x,y,z)

#define cimg_for14x14(img,x,y,z,c,I,T) \
 cimg_for14((img)._height,y) for (int x = 0, \
 _p6##x = 0, _p5##x = 0, _p4##x = 0, _p3##x = 0, _p2##x = 0, _p1##x = 0, \
 _n1##x = 1>=((img)._width)?(img).width()-1:1, \
 _n2##x = 2>=((img)._width)?(img).width()-1:2, \
 _n3##x = 3>=((img)._width)?(img).width()-1:3, \
 _n4##x = 4>=((img)._width)?(img).width()-1:4, \
 _n5##x = 5>=((img)._width)?(img).width()-1:5, \
 _n6##x = 6>=((img)._width)?(img).width()-1:6, \
 _n7##x = (int)( \
 (I[0] = I[1] = I[2] = I[3] = I[4] = I[5] = I[6] = (T)(img)(0,_p6##y,z,c)), \
 (I[14] = I[15] = I[16] = I[17] = I[18] = I[19] = I[20] = (T)(img)(0,_p5##y,z,c)), \
 (I[28] = I[29] = I[30] = I[31] = I[32] = I[33] = I[34] = (T)(img)(0,_p4##y,z,c)), \
 (I[42] = I[43] = I[44] = I[45] = I[46] = I[47] = I[48] = (T)(img)(0,_p3##y,z,c)), \
 (I[56] = I[57] = I[58] = I[59] = I[60] = I[61] = I[62] = (T)(img)(0,_p2##y,z,c)), \
 (I[70] = I[71] = I[72] = I[73] = I[74] = I[75] = I[76] = (T)(img)(0,_p1##y,z,c)), \
 (I[84] = I[85] = I[86] = I[87] = I[88] = I[89] = I[90] = (T)(img)(0,y,z,c)), \
 (I[98] = I[99] = I[100] = I[101] = I[102] = I[103] = I[104] = (T)(img)(0,_n1##y,z,c)), \
 (I[112] = I[113] = I[114] = I[115] = I[116] = I[117] = I[118] = (T)(img)(0,_n2##y,z,c)), \
 (I[126] = I[127] = I[128] = I[129] = I[130] = I[131] = I[132] = (T)(img)(0,_n3##y,z,c)), \
 (I[140] = I[141] = I[142] = I[143] = I[144] = I[145] = I[146] = (T)(img)(0,_n4##y,z,c)), \
 (I[154] = I[155] = I[156] = I[157] = I[158] = I[159] = I[160] = (T)(img)(0,_n5##y,z,c)), \
 (I[168] = I[169] = I[170] = I[171] = I[172] = I[173] = I[174] = (T)(img)(0,_n6##y,z,c)), \
 (I[182] = I[183] = I[184] = I[185] = I[186] = I[187] = I[188] = (T)(img)(0,_n7##y,z,c)), \
 (I[7] = (T)(img)(_n1##x,_p6##y,z,c)), \
 (I[21] = (T)(img)(_n1##x,_p5##y,z,c)), \
 (I[35] = (T)(img)(_n1##x,_p4##y,z,c)), \
 (I[49] = (T)(img)(_n1##x,_p3##y,z,c)), \
 (I[63] = (T)(img)(_n1##x,_p2##y,z,c)), \
 (I[77] = (T)(img)(_n1##x,_p1##y,z,c)), \
 (I[91] = (T)(img)(_n1##x,y,z,c)), \
 (I[105] = (T)(img)(_n1##x,_n1##y,z,c)), \
 (I[119] = (T)(img)(_n1##x,_n2##y,z,c)), \
 (I[133] = (T)(img)(_n1##x,_n3##y,z,c)), \
 (I[147] = (T)(img)(_n1##x,_n4##y,z,c)), \
 (I[161] = (T)(img)(_n1##x,_n5##y,z,c)), \
 (I[175] = (T)(img)(_n1##x,_n6##y,z,c)), \
 (I[189] = (T)(img)(_n1##x,_n7##y,z,c)), \
 (I[8] = (T)(img)(_n2##x,_p6##y,z,c)), \
 (I[22] = (T)(img)(_n2##x,_p5##y,z,c)), \
 (I[36] = (T)(img)(_n2##x,_p4##y,z,c)), \
 (I[50] = (T)(img)(_n2##x,_p3##y,z,c)), \
 (I[64] = (T)(img)(_n2##x,_p2##y,z,c)), \
 (I[78] = (T)(img)(_n2##x,_p1##y,z,c)), \
 (I[92] = (T)(img)(_n2##x,y,z,c)), \
 (I[106] = (T)(img)(_n2##x,_n1##y,z,c)), \
 (I[120] = (T)(img)(_n2##x,_n2##y,z,c)), \
 (I[134] = (T)(img)(_n2##x,_n3##y,z,c)), \
 (I[148] = (T)(img)(_n2##x,_n4##y,z,c)), \
 (I[162] = (T)(img)(_n2##x,_n5##y,z,c)), \
 (I[176] = (T)(img)(_n2##x,_n6##y,z,c)), \
 (I[190] = (T)(img)(_n2##x,_n7##y,z,c)), \
 (I[9] = (T)(img)(_n3##x,_p6##y,z,c)), \
 (I[23] = (T)(img)(_n3##x,_p5##y,z,c)), \
 (I[37] = (T)(img)(_n3##x,_p4##y,z,c)), \
 (I[51] = (T)(img)(_n3##x,_p3##y,z,c)), \
 (I[65] = (T)(img)(_n3##x,_p2##y,z,c)), \
 (I[79] = (T)(img)(_n3##x,_p1##y,z,c)), \
 (I[93] = (T)(img)(_n3##x,y,z,c)), \
 (I[107] = (T)(img)(_n3##x,_n1##y,z,c)), \
 (I[121] = (T)(img)(_n3##x,_n2##y,z,c)), \
 (I[135] = (T)(img)(_n3##x,_n3##y,z,c)), \
 (I[149] = (T)(img)(_n3##x,_n4##y,z,c)), \
 (I[163] = (T)(img)(_n3##x,_n5##y,z,c)), \
 (I[177] = (T)(img)(_n3##x,_n6##y,z,c)), \
 (I[191] = (T)(img)(_n3##x,_n7##y,z,c)), \
 (I[10] = (T)(img)(_n4##x,_p6##y,z,c)), \
 (I[24] = (T)(img)(_n4##x,_p5##y,z,c)), \
 (I[38] = (T)(img)(_n4##x,_p4##y,z,c)), \
 (I[52] = (T)(img)(_n4##x,_p3##y,z,c)), \
 (I[66] = (T)(img)(_n4##x,_p2##y,z,c)), \
 (I[80] = (T)(img)(_n4##x,_p1##y,z,c)), \
 (I[94] = (T)(img)(_n4##x,y,z,c)), \
 (I[108] = (T)(img)(_n4##x,_n1##y,z,c)), \
 (I[122] = (T)(img)(_n4##x,_n2##y,z,c)), \
 (I[136] = (T)(img)(_n4##x,_n3##y,z,c)), \
 (I[150] = (T)(img)(_n4##x,_n4##y,z,c)), \
 (I[164] = (T)(img)(_n4##x,_n5##y,z,c)), \
 (I[178] = (T)(img)(_n4##x,_n6##y,z,c)), \
 (I[192] = (T)(img)(_n4##x,_n7##y,z,c)), \
 (I[11] = (T)(img)(_n5##x,_p6##y,z,c)), \
 (I[25] = (T)(img)(_n5##x,_p5##y,z,c)), \
 (I[39] = (T)(img)(_n5##x,_p4##y,z,c)), \
 (I[53] = (T)(img)(_n5##x,_p3##y,z,c)), \
 (I[67] = (T)(img)(_n5##x,_p2##y,z,c)), \
 (I[81] = (T)(img)(_n5##x,_p1##y,z,c)), \
 (I[95] = (T)(img)(_n5##x,y,z,c)), \
 (I[109] = (T)(img)(_n5##x,_n1##y,z,c)), \
 (I[123] = (T)(img)(_n5##x,_n2##y,z,c)), \
 (I[137] = (T)(img)(_n5##x,_n3##y,z,c)), \
 (I[151] = (T)(img)(_n5##x,_n4##y,z,c)), \
 (I[165] = (T)(img)(_n5##x,_n5##y,z,c)), \
 (I[179] = (T)(img)(_n5##x,_n6##y,z,c)), \
 (I[193] = (T)(img)(_n5##x,_n7##y,z,c)), \
 (I[12] = (T)(img)(_n6##x,_p6##y,z,c)), \
 (I[26] = (T)(img)(_n6##x,_p5##y,z,c)), \
 (I[40] = (T)(img)(_n6##x,_p4##y,z,c)), \
 (I[54] = (T)(img)(_n6##x,_p3##y,z,c)), \
 (I[68] = (T)(img)(_n6##x,_p2##y,z,c)), \
 (I[82] = (T)(img)(_n6##x,_p1##y,z,c)), \
 (I[96] = (T)(img)(_n6##x,y,z,c)), \
 (I[110] = (T)(img)(_n6##x,_n1##y,z,c)), \
 (I[124] = (T)(img)(_n6##x,_n2##y,z,c)), \
 (I[138] = (T)(img)(_n6##x,_n3##y,z,c)), \
 (I[152] = (T)(img)(_n6##x,_n4##y,z,c)), \
 (I[166] = (T)(img)(_n6##x,_n5##y,z,c)), \
 (I[180] = (T)(img)(_n6##x,_n6##y,z,c)), \
 (I[194] = (T)(img)(_n6##x,_n7##y,z,c)), \
 7>=((img)._width)?(img).width()-1:7); \
 (_n7##x<(img).width() && ( \
 (I[13] = (T)(img)(_n7##x,_p6##y,z,c)), \
 (I[27] = (T)(img)(_n7##x,_p5##y,z,c)), \
 (I[41] = (T)(img)(_n7##x,_p4##y,z,c)), \
 (I[55] = (T)(img)(_n7##x,_p3##y,z,c)), \
 (I[69] = (T)(img)(_n7##x,_p2##y,z,c)), \
 (I[83] = (T)(img)(_n7##x,_p1##y,z,c)), \
 (I[97] = (T)(img)(_n7##x,y,z,c)), \
 (I[111] = (T)(img)(_n7##x,_n1##y,z,c)), \
 (I[125] = (T)(img)(_n7##x,_n2##y,z,c)), \
 (I[139] = (T)(img)(_n7##x,_n3##y,z,c)), \
 (I[153] = (T)(img)(_n7##x,_n4##y,z,c)), \
 (I[167] = (T)(img)(_n7##x,_n5##y,z,c)), \
 (I[181] = (T)(img)(_n7##x,_n6##y,z,c)), \
 (I[195] = (T)(img)(_n7##x,_n7##y,z,c)),1)) || \
 _n6##x==--_n7##x || _n5##x==--_n6##x || _n4##x==--_n5##x || _n3##x==--_n4##x || _n2##x==--_n3##x || _n1##x==--_n2##x || x==(_n7##x = _n6##x = _n5##x = _n4##x = _n3##x = _n2##x = --_n1##x); \
 I[0] = I[1], I[1] = I[2], I[2] = I[3], I[3] = I[4], I[4] = I[5], I[5] = I[6], I[6] = I[7], I[7] = I[8], I[8] = I[9], I[9] = I[10], I[10] = I[11], I[11] = I[12], I[12] = I[13], \
 I[14] = I[15], I[15] = I[16], I[16] = I[17], I[17] = I[18], I[18] = I[19], I[19] = I[20], I[20] = I[21], I[21] = I[22], I[22] = I[23], I[23] = I[24], I[24] = I[25], I[25] = I[26], I[26] = I[27], \
 I[28] = I[29], I[29] = I[30], I[30] = I[31], I[31] = I[32], I[32] = I[33], I[33] = I[34], I[34] = I[35], I[35] = I[36], I[36] = I[37], I[37] = I[38], I[38] = I[39], I[39] = I[40], I[40] = I[41], \
 I[42] = I[43], I[43] = I[44], I[44] = I[45], I[45] = I[46], I[46] = I[47], I[47] = I[48], I[48] = I[49], I[49] = I[50], I[50] = I[51], I[51] = I[52], I[52] = I[53], I[53] = I[54], I[54] = I[55], \
 I[56] = I[57], I[57] = I[58], I[58] = I[59], I[59] = I[60], I[60] = I[61], I[61] = I[62], I[62] = I[63], I[63] = I[64], I[64] = I[65], I[65] = I[66], I[66] = I[67], I[67] = I[68], I[68] = I[69], \
 I[70] = I[71], I[71] = I[72], I[72] = I[73], I[73] = I[74], I[74] = I[75], I[75] = I[76], I[76] = I[77], I[77] = I[78], I[78] = I[79], I[79] = I[80], I[80] = I[81], I[81] = I[82], I[82] = I[83], \
 I[84] = I[85], I[85] = I[86], I[86] = I[87], I[87] = I[88], I[88] = I[89], I[89] = I[90], I[90] = I[91], I[91] = I[92], I[92] = I[93], I[93] = I[94], I[94] = I[95], I[95] = I[96], I[96] = I[97], \
 I[98] = I[99], I[99] = I[100], I[100] = I[101], I[101] = I[102], I[102] = I[103], I[103] = I[104], I[104] = I[105], I[105] = I[106], I[106] = I[107], I[107] = I[108], I[108] = I[109], I[109] = I[110], I[110] = I[111], \
 I[112] = I[113], I[113] = I[114], I[114] = I[115], I[115] = I[116], I[116] = I[117], I[117] = I[118], I[118] = I[119], I[119] = I[120], I[120] = I[121], I[121] = I[122], I[122] = I[123], I[123] = I[124], I[124] = I[125], \
 I[126] = I[127], I[127] = I[128], I[128] = I[129], I[129] = I[130], I[130] = I[131], I[131] = I[132], I[132] = I[133], I[133] = I[134], I[134] = I[135], I[135] = I[136], I[136] = I[137], I[137] = I[138], I[138] = I[139], \
 I[140] = I[141], I[141] = I[142], I[142] = I[143], I[143] = I[144], I[144] = I[145], I[145] = I[146], I[146] = I[147], I[147] = I[148], I[148] = I[149], I[149] = I[150], I[150] = I[151], I[151] = I[152], I[152] = I[153], \
 I[154] = I[155], I[155] = I[156], I[156] = I[157], I[157] = I[158], I[158] = I[159], I[159] = I[160], I[160] = I[161], I[161] = I[162], I[162] = I[163], I[163] = I[164], I[164] = I[165], I[165] = I[166], I[166] = I[167], \
 I[168] = I[169], I[169] = I[170], I[170] = I[171], I[171] = I[172], I[172] = I[173], I[173] = I[174], I[174] = I[175], I[175] = I[176], I[176] = I[177], I[177] = I[178], I[178] = I[179], I[179] = I[180], I[180] = I[181], \
 I[182] = I[183], I[183] = I[184], I[184] = I[185], I[185] = I[186], I[186] = I[187], I[187] = I[188], I[188] = I[189], I[189] = I[190], I[190] = I[191], I[191] = I[192], I[192] = I[193], I[193] = I[194], I[194] = I[195], \
 _p6##x = _p5##x, _p5##x = _p4##x, _p4##x = _p3##x, _p3##x = _p2##x, _p2##x = _p1##x, _p1##x = x++, ++_n1##x, ++_n2##x, ++_n3##x, ++_n4##x, ++_n5##x, ++_n6##x, ++_n7##x)

#define cimg_for_in14x14(img,x0,y0,x1,y1,x,y,z,c,I,T) \
 cimg_for_in14((img)._height,y0,y1,y) for (int x = (int)(x0)<0?0:(int)(x0), \
 _p6##x = x-6<0?0:x-6, \
 _p5##x = x-5<0?0:x-5, \
 _p4##x = x-4<0?0:x-4, \
 _p3##x = x-3<0?0:x-3, \
 _p2##x = x-2<0?0:x-2, \
 _p1##x = x-1<0?0:x-1, \
 _n1##x = x+1>=(img).width()?(img).width()-1:x+1, \
 _n2##x = x+2>=(img).width()?(img).width()-1:x+2, \
 _n3##x = x+3>=(img).width()?(img).width()-1:x+3, \
 _n4##x = x+4>=(img).width()?(img).width()-1:x+4, \
 _n5##x = x+5>=(img).width()?(img).width()-1:x+5, \
 _n6##x = x+6>=(img).width()?(img).width()-1:x+6, \
 _n7##x = (int)( \
 (I[0] = (T)(img)(_p6##x,_p6##y,z,c)), \
 (I[14] = (T)(img)(_p6##x,_p5##y,z,c)), \
 (I[28] = (T)(img)(_p6##x,_p4##y,z,c)), \
 (I[42] = (T)(img)(_p6##x,_p3##y,z,c)), \
 (I[56] = (T)(img)(_p6##x,_p2##y,z,c)), \
 (I[70] = (T)(img)(_p6##x,_p1##y,z,c)), \
 (I[84] = (T)(img)(_p6##x,y,z,c)), \
 (I[98] = (T)(img)(_p6##x,_n1##y,z,c)), \
 (I[112] = (T)(img)(_p6##x,_n2##y,z,c)), \
 (I[126] = (T)(img)(_p6##x,_n3##y,z,c)), \
 (I[140] = (T)(img)(_p6##x,_n4##y,z,c)), \
 (I[154] = (T)(img)(_p6##x,_n5##y,z,c)), \
 (I[168] = (T)(img)(_p6##x,_n6##y,z,c)), \
 (I[182] = (T)(img)(_p6##x,_n7##y,z,c)), \
 (I[1] = (T)(img)(_p5##x,_p6##y,z,c)), \
 (I[15] = (T)(img)(_p5##x,_p5##y,z,c)), \
 (I[29] = (T)(img)(_p5##x,_p4##y,z,c)), \
 (I[43] = (T)(img)(_p5##x,_p3##y,z,c)), \
 (I[57] = (T)(img)(_p5##x,_p2##y,z,c)), \
 (I[71] = (T)(img)(_p5##x,_p1##y,z,c)), \
 (I[85] = (T)(img)(_p5##x,y,z,c)), \
 (I[99] = (T)(img)(_p5##x,_n1##y,z,c)), \
 (I[113] = (T)(img)(_p5##x,_n2##y,z,c)), \
 (I[127] = (T)(img)(_p5##x,_n3##y,z,c)), \
 (I[141] = (T)(img)(_p5##x,_n4##y,z,c)), \
 (I[155] = (T)(img)(_p5##x,_n5##y,z,c)), \
 (I[169] = (T)(img)(_p5##x,_n6##y,z,c)), \
 (I[183] = (T)(img)(_p5##x,_n7##y,z,c)), \
 (I[2] = (T)(img)(_p4##x,_p6##y,z,c)), \
 (I[16] = (T)(img)(_p4##x,_p5##y,z,c)), \
 (I[30] = (T)(img)(_p4##x,_p4##y,z,c)), \
 (I[44] = (T)(img)(_p4##x,_p3##y,z,c)), \
 (I[58] = (T)(img)(_p4##x,_p2##y,z,c)), \
 (I[72] = (T)(img)(_p4##x,_p1##y,z,c)), \
 (I[86] = (T)(img)(_p4##x,y,z,c)), \
 (I[100] = (T)(img)(_p4##x,_n1##y,z,c)), \
 (I[114] = (T)(img)(_p4##x,_n2##y,z,c)), \
 (I[128] = (T)(img)(_p4##x,_n3##y,z,c)), \
 (I[142] = (T)(img)(_p4##x,_n4##y,z,c)), \
 (I[156] = (T)(img)(_p4##x,_n5##y,z,c)), \
 (I[170] = (T)(img)(_p4##x,_n6##y,z,c)), \
 (I[184] = (T)(img)(_p4##x,_n7##y,z,c)), \
 (I[3] = (T)(img)(_p3##x,_p6##y,z,c)), \
 (I[17] = (T)(img)(_p3##x,_p5##y,z,c)), \
 (I[31] = (T)(img)(_p3##x,_p4##y,z,c)), \
 (I[45] = (T)(img)(_p3##x,_p3##y,z,c)), \
 (I[59] = (T)(img)(_p3##x,_p2##y,z,c)), \
 (I[73] = (T)(img)(_p3##x,_p1##y,z,c)), \
 (I[87] = (T)(img)(_p3##x,y,z,c)), \
 (I[101] = (T)(img)(_p3##x,_n1##y,z,c)), \
 (I[115] = (T)(img)(_p3##x,_n2##y,z,c)), \
 (I[129] = (T)(img)(_p3##x,_n3##y,z,c)), \
 (I[143] = (T)(img)(_p3##x,_n4##y,z,c)), \
 (I[157] = (T)(img)(_p3##x,_n5##y,z,c)), \
 (I[171] = (T)(img)(_p3##x,_n6##y,z,c)), \
 (I[185] = (T)(img)(_p3##x,_n7##y,z,c)), \
 (I[4] = (T)(img)(_p2##x,_p6##y,z,c)), \
 (I[18] = (T)(img)(_p2##x,_p5##y,z,c)), \
 (I[32] = (T)(img)(_p2##x,_p4##y,z,c)), \
 (I[46] = (T)(img)(_p2##x,_p3##y,z,c)), \
 (I[60] = (T)(img)(_p2##x,_p2##y,z,c)), \
 (I[74] = (T)(img)(_p2##x,_p1##y,z,c)), \
 (I[88] = (T)(img)(_p2##x,y,z,c)), \
 (I[102] = (T)(img)(_p2##x,_n1##y,z,c)), \
 (I[116] = (T)(img)(_p2##x,_n2##y,z,c)), \
 (I[130] = (T)(img)(_p2##x,_n3##y,z,c)), \
 (I[144] = (T)(img)(_p2##x,_n4##y,z,c)), \
 (I[158] = (T)(img)(_p2##x,_n5##y,z,c)), \
 (I[172] = (T)(img)(_p2##x,_n6##y,z,c)), \
 (I[186] = (T)(img)(_p2##x,_n7##y,z,c)), \
 (I[5] = (T)(img)(_p1##x,_p6##y,z,c)), \
 (I[19] = (T)(img)(_p1##x,_p5##y,z,c)), \
 (I[33] = (T)(img)(_p1##x,_p4##y,z,c)), \
 (I[47] = (T)(img)(_p1##x,_p3##y,z,c)), \
 (I[61] = (T)(img)(_p1##x,_p2##y,z,c)), \
 (I[75] = (T)(img)(_p1##x,_p1##y,z,c)), \
 (I[89] = (T)(img)(_p1##x,y,z,c)), \
 (I[103] = (T)(img)(_p1##x,_n1##y,z,c)), \
 (I[117] = (T)(img)(_p1##x,_n2##y,z,c)), \
 (I[131] = (T)(img)(_p1##x,_n3##y,z,c)), \
 (I[145] = (T)(img)(_p1##x,_n4##y,z,c)), \
 (I[159] = (T)(img)(_p1##x,_n5##y,z,c)), \
 (I[173] = (T)(img)(_p1##x,_n6##y,z,c)), \
 (I[187] = (T)(img)(_p1##x,_n7##y,z,c)), \
 (I[6] = (T)(img)(x,_p6##y,z,c)), \
 (I[20] = (T)(img)(x,_p5##y,z,c)), \
 (I[34] = (T)(img)(x,_p4##y,z,c)), \
 (I[48] = (T)(img)(x,_p3##y,z,c)), \
 (I[62] = (T)(img)(x,_p2##y,z,c)), \
 (I[76] = (T)(img)(x,_p1##y,z,c)), \
 (I[90] = (T)(img)(x,y,z,c)), \
 (I[104] = (T)(img)(x,_n1##y,z,c)), \
 (I[118] = (T)(img)(x,_n2##y,z,c)), \
 (I[132] = (T)(img)(x,_n3##y,z,c)), \
 (I[146] = (T)(img)(x,_n4##y,z,c)), \
 (I[160] = (T)(img)(x,_n5##y,z,c)), \
 (I[174] = (T)(img)(x,_n6##y,z,c)), \
 (I[188] = (T)(img)(x,_n7##y,z,c)), \
 (I[7] = (T)(img)(_n1##x,_p6##y,z,c)), \
 (I[21] = (T)(img)(_n1##x,_p5##y,z,c)), \
 (I[35] = (T)(img)(_n1##x,_p4##y,z,c)), \
 (I[49] = (T)(img)(_n1##x,_p3##y,z,c)), \
 (I[63] = (T)(img)(_n1##x,_p2##y,z,c)), \
 (I[77] = (T)(img)(_n1##x,_p1##y,z,c)), \
 (I[91] = (T)(img)(_n1##x,y,z,c)), \
 (I[105] = (T)(img)(_n1##x,_n1##y,z,c)), \
 (I[119] = (T)(img)(_n1##x,_n2##y,z,c)), \
 (I[133] = (T)(img)(_n1##x,_n3##y,z,c)), \
 (I[147] = (T)(img)(_n1##x,_n4##y,z,c)), \
 (I[161] = (T)(img)(_n1##x,_n5##y,z,c)), \
 (I[175] = (T)(img)(_n1##x,_n6##y,z,c)), \
 (I[189] = (T)(img)(_n1##x,_n7##y,z,c)), \
 (I[8] = (T)(img)(_n2##x,_p6##y,z,c)), \
 (I[22] = (T)(img)(_n2##x,_p5##y,z,c)), \
 (I[36] = (T)(img)(_n2##x,_p4##y,z,c)), \
 (I[50] = (T)(img)(_n2##x,_p3##y,z,c)), \
 (I[64] = (T)(img)(_n2##x,_p2##y,z,c)), \
 (I[78] = (T)(img)(_n2##x,_p1##y,z,c)), \
 (I[92] = (T)(img)(_n2##x,y,z,c)), \
 (I[106] = (T)(img)(_n2##x,_n1##y,z,c)), \
 (I[120] = (T)(img)(_n2##x,_n2##y,z,c)), \
 (I[134] = (T)(img)(_n2##x,_n3##y,z,c)), \
 (I[148] = (T)(img)(_n2##x,_n4##y,z,c)), \
 (I[162] = (T)(img)(_n2##x,_n5##y,z,c)), \
 (I[176] = (T)(img)(_n2##x,_n6##y,z,c)), \
 (I[190] = (T)(img)(_n2##x,_n7##y,z,c)), \
 (I[9] = (T)(img)(_n3##x,_p6##y,z,c)), \
 (I[23] = (T)(img)(_n3##x,_p5##y,z,c)), \
 (I[37] = (T)(img)(_n3##x,_p4##y,z,c)), \
 (I[51] = (T)(img)(_n3##x,_p3##y,z,c)), \
 (I[65] = (T)(img)(_n3##x,_p2##y,z,c)), \
 (I[79] = (T)(img)(_n3##x,_p1##y,z,c)), \
 (I[93] = (T)(img)(_n3##x,y,z,c)), \
 (I[107] = (T)(img)(_n3##x,_n1##y,z,c)), \
 (I[121] = (T)(img)(_n3##x,_n2##y,z,c)), \
 (I[135] = (T)(img)(_n3##x,_n3##y,z,c)), \
 (I[149] = (T)(img)(_n3##x,_n4##y,z,c)), \
 (I[163] = (T)(img)(_n3##x,_n5##y,z,c)), \
 (I[177] = (T)(img)(_n3##x,_n6##y,z,c)), \
 (I[191] = (T)(img)(_n3##x,_n7##y,z,c)), \
 (I[10] = (T)(img)(_n4##x,_p6##y,z,c)), \
 (I[24] = (T)(img)(_n4##x,_p5##y,z,c)), \
 (I[38] = (T)(img)(_n4##x,_p4##y,z,c)), \
 (I[52] = (T)(img)(_n4##x,_p3##y,z,c)), \
 (I[66] = (T)(img)(_n4##x,_p2##y,z,c)), \
 (I[80] = (T)(img)(_n4##x,_p1##y,z,c)), \
 (I[94] = (T)(img)(_n4##x,y,z,c)), \
 (I[108] = (T)(img)(_n4##x,_n1##y,z,c)), \
 (I[122] = (T)(img)(_n4##x,_n2##y,z,c)), \
 (I[136] = (T)(img)(_n4##x,_n3##y,z,c)), \
 (I[150] = (T)(img)(_n4##x,_n4##y,z,c)), \
 (I[164] = (T)(img)(_n4##x,_n5##y,z,c)), \
 (I[178] = (T)(img)(_n4##x,_n6##y,z,c)), \
 (I[192] = (T)(img)(_n4##x,_n7##y,z,c)), \
 (I[11] = (T)(img)(_n5##x,_p6##y,z,c)), \
 (I[25] = (T)(img)(_n5##x,_p5##y,z,c)), \
 (I[39] = (T)(img)(_n5##x,_p4##y,z,c)), \
 (I[53] = (T)(img)(_n5##x,_p3##y,z,c)), \
 (I[67] = (T)(img)(_n5##x,_p2##y,z,c)), \
 (I[81] = (T)(img)(_n5##x,_p1##y,z,c)), \
 (I[95] = (T)(img)(_n5##x,y,z,c)), \
 (I[109] = (T)(img)(_n5##x,_n1##y,z,c)), \
 (I[123] = (T)(img)(_n5##x,_n2##y,z,c)), \
 (I[137] = (T)(img)(_n5##x,_n3##y,z,c)), \
 (I[151] = (T)(img)(_n5##x,_n4##y,z,c)), \
 (I[165] = (T)(img)(_n5##x,_n5##y,z,c)), \
 (I[179] = (T)(img)(_n5##x,_n6##y,z,c)), \
 (I[193] = (T)(img)(_n5##x,_n7##y,z,c)), \
 (I[12] = (T)(img)(_n6##x,_p6##y,z,c)), \
 (I[26] = (T)(img)(_n6##x,_p5##y,z,c)), \
 (I[40] = (T)(img)(_n6##x,_p4##y,z,c)), \
 (I[54] = (T)(img)(_n6##x,_p3##y,z,c)), \
 (I[68] = (T)(img)(_n6##x,_p2##y,z,c)), \
 (I[82] = (T)(img)(_n6##x,_p1##y,z,c)), \
 (I[96] = (T)(img)(_n6##x,y,z,c)), \
 (I[110] = (T)(img)(_n6##x,_n1##y,z,c)), \
 (I[124] = (T)(img)(_n6##x,_n2##y,z,c)), \
 (I[138] = (T)(img)(_n6##x,_n3##y,z,c)), \
 (I[152] = (T)(img)(_n6##x,_n4##y,z,c)), \
 (I[166] = (T)(img)(_n6##x,_n5##y,z,c)), \
 (I[180] = (T)(img)(_n6##x,_n6##y,z,c)), \
 (I[194] = (T)(img)(_n6##x,_n7##y,z,c)), \
 x+7>=(img).width()?(img).width()-1:x+7); \
 x<=(int)(x1) && ((_n7##x<(img).width() && ( \
 (I[13] = (T)(img)(_n7##x,_p6##y,z,c)), \
 (I[27] = (T)(img)(_n7##x,_p5##y,z,c)), \
 (I[41] = (T)(img)(_n7##x,_p4##y,z,c)), \
 (I[55] = (T)(img)(_n7##x,_p3##y,z,c)), \
 (I[69] = (T)(img)(_n7##x,_p2##y,z,c)), \
 (I[83] = (T)(img)(_n7##x,_p1##y,z,c)), \
 (I[97] = (T)(img)(_n7##x,y,z,c)), \
 (I[111] = (T)(img)(_n7##x,_n1##y,z,c)), \
 (I[125] = (T)(img)(_n7##x,_n2##y,z,c)), \
 (I[139] = (T)(img)(_n7##x,_n3##y,z,c)), \
 (I[153] = (T)(img)(_n7##x,_n4##y,z,c)), \
 (I[167] = (T)(img)(_n7##x,_n5##y,z,c)), \
 (I[181] = (T)(img)(_n7##x,_n6##y,z,c)), \
 (I[195] = (T)(img)(_n7##x,_n7##y,z,c)),1)) || \
 _n6##x==--_n7##x || _n5##x==--_n6##x || _n4##x==--_n5##x || _n3##x==--_n4##x || _n2##x==--_n3##x || _n1##x==--_n2##x || x==(_n7##x = _n6##x = _n5##x = _n4##x = _n3##x = _n2##x = --_n1##x)); \
 I[0] = I[1], I[1] = I[2], I[2] = I[3], I[3] = I[4], I[4] = I[5], I[5] = I[6], I[6] = I[7], I[7] = I[8], I[8] = I[9], I[9] = I[10], I[10] = I[11], I[11] = I[12], I[12] = I[13], \
 I[14] = I[15], I[15] = I[16], I[16] = I[17], I[17] = I[18], I[18] = I[19], I[19] = I[20], I[20] = I[21], I[21] = I[22], I[22] = I[23], I[23] = I[24], I[24] = I[25], I[25] = I[26], I[26] = I[27], \
 I[28] = I[29], I[29] = I[30], I[30] = I[31], I[31] = I[32], I[32] = I[33], I[33] = I[34], I[34] = I[35], I[35] = I[36], I[36] = I[37], I[37] = I[38], I[38] = I[39], I[39] = I[40], I[40] = I[41], \
 I[42] = I[43], I[43] = I[44], I[44] = I[45], I[45] = I[46], I[46] = I[47], I[47] = I[48], I[48] = I[49], I[49] = I[50], I[50] = I[51], I[51] = I[52], I[52] = I[53], I[53] = I[54], I[54] = I[55], \
 I[56] = I[57], I[57] = I[58], I[58] = I[59], I[59] = I[60], I[60] = I[61], I[61] = I[62], I[62] = I[63], I[63] = I[64], I[64] = I[65], I[65] = I[66], I[66] = I[67], I[67] = I[68], I[68] = I[69], \
 I[70] = I[71], I[71] = I[72], I[72] = I[73], I[73] = I[74], I[74] = I[75], I[75] = I[76], I[76] = I[77], I[77] = I[78], I[78] = I[79], I[79] = I[80], I[80] = I[81], I[81] = I[82], I[82] = I[83], \
 I[84] = I[85], I[85] = I[86], I[86] = I[87], I[87] = I[88], I[88] = I[89], I[89] = I[90], I[90] = I[91], I[91] = I[92], I[92] = I[93], I[93] = I[94], I[94] = I[95], I[95] = I[96], I[96] = I[97], \
 I[98] = I[99], I[99] = I[100], I[100] = I[101], I[101] = I[102], I[102] = I[103], I[103] = I[104], I[104] = I[105], I[105] = I[106], I[106] = I[107], I[107] = I[108], I[108] = I[109], I[109] = I[110], I[110] = I[111], \
 I[112] = I[113], I[113] = I[114], I[114] = I[115], I[115] = I[116], I[116] = I[117], I[117] = I[118], I[118] = I[119], I[119] = I[120], I[120] = I[121], I[121] = I[122], I[122] = I[123], I[123] = I[124], I[124] = I[125], \
 I[126] = I[127], I[127] = I[128], I[128] = I[129], I[129] = I[130], I[130] = I[131], I[131] = I[132], I[132] = I[133], I[133] = I[134], I[134] = I[135], I[135] = I[136], I[136] = I[137], I[137] = I[138], I[138] = I[139], \
 I[140] = I[141], I[141] = I[142], I[142] = I[143], I[143] = I[144], I[144] = I[145], I[145] = I[146], I[146] = I[147], I[147] = I[148], I[148] = I[149], I[149] = I[150], I[150] = I[151], I[151] = I[152], I[152] = I[153], \
 I[154] = I[155], I[155] = I[156], I[156] = I[157], I[157] = I[158], I[158] = I[159], I[159] = I[160], I[160] = I[161], I[161] = I[162], I[162] = I[163], I[163] = I[164], I[164] = I[165], I[165] = I[166], I[166] = I[167], \
 I[168] = I[169], I[169] = I[170], I[170] = I[171], I[171] = I[172], I[172] = I[173], I[173] = I[174], I[174] = I[175], I[175] = I[176], I[176] = I[177], I[177] = I[178], I[178] = I[179], I[179] = I[180], I[180] = I[181], \
 I[182] = I[183], I[183] = I[184], I[184] = I[185], I[185] = I[186], I[186] = I[187], I[187] = I[188], I[188] = I[189], I[189] = I[190], I[190] = I[191], I[191] = I[192], I[192] = I[193], I[193] = I[194], I[194] = I[195], \
 _p6##x = _p5##x, _p5##x = _p4##x, _p4##x = _p3##x, _p3##x = _p2##x, _p2##x = _p1##x, _p1##x = x++, ++_n1##x, ++_n2##x, ++_n3##x, ++_n4##x, ++_n5##x, ++_n6##x, ++_n7##x)

#define cimg_get14x14(img,x,y,z,c,I,T) \
 I[0] = (T)(img)(_p6##x,_p6##y,z,c), I[1] = (T)(img)(_p5##x,_p6##y,z,c), I[2] = (T)(img)(_p4##x,_p6##y,z,c), I[3] = (T)(img)(_p3##x,_p6##y,z,c), I[4] = (T)(img)(_p2##x,_p6##y,z,c), I[5] = (T)(img)(_p1##x,_p6##y,z,c), I[6] = (T)(img)(x,_p6##y,z,c), I[7] = (T)(img)(_n1##x,_p6##y,z,c), I[8] = (T)(img)(_n2##x,_p6##y,z,c), I[9] = (T)(img)(_n3##x,_p6##y,z,c), I[10] = (T)(img)(_n4##x,_p6##y,z,c), I[11] = (T)(img)(_n5##x,_p6##y,z,c), I[12] = (T)(img)(_n6##x,_p6##y,z,c), I[13] = (T)(img)(_n7##x,_p6##y,z,c), \
 I[14] = (T)(img)(_p6##x,_p5##y,z,c), I[15] = (T)(img)(_p5##x,_p5##y,z,c), I[16] = (T)(img)(_p4##x,_p5##y,z,c), I[17] = (T)(img)(_p3##x,_p5##y,z,c), I[18] = (T)(img)(_p2##x,_p5##y,z,c), I[19] = (T)(img)(_p1##x,_p5##y,z,c), I[20] = (T)(img)(x,_p5##y,z,c), I[21] = (T)(img)(_n1##x,_p5##y,z,c), I[22] = (T)(img)(_n2##x,_p5##y,z,c), I[23] = (T)(img)(_n3##x,_p5##y,z,c), I[24] = (T)(img)(_n4##x,_p5##y,z,c), I[25] = (T)(img)(_n5##x,_p5##y,z,c), I[26] = (T)(img)(_n6##x,_p5##y,z,c), I[27] = (T)(img)(_n7##x,_p5##y,z,c), \
 I[28] = (T)(img)(_p6##x,_p4##y,z,c), I[29] = (T)(img)(_p5##x,_p4##y,z,c), I[30] = (T)(img)(_p4##x,_p4##y,z,c), I[31] = (T)(img)(_p3##x,_p4##y,z,c), I[32] = (T)(img)(_p2##x,_p4##y,z,c), I[33] = (T)(img)(_p1##x,_p4##y,z,c), I[34] = (T)(img)(x,_p4##y,z,c), I[35] = (T)(img)(_n1##x,_p4##y,z,c), I[36] = (T)(img)(_n2##x,_p4##y,z,c), I[37] = (T)(img)(_n3##x,_p4##y,z,c), I[38] = (T)(img)(_n4##x,_p4##y,z,c), I[39] = (T)(img)(_n5##x,_p4##y,z,c), I[40] = (T)(img)(_n6##x,_p4##y,z,c), I[41] = (T)(img)(_n7##x,_p4##y,z,c), \
 I[42] = (T)(img)(_p6##x,_p3##y,z,c), I[43] = (T)(img)(_p5##x,_p3##y,z,c), I[44] = (T)(img)(_p4##x,_p3##y,z,c), I[45] = (T)(img)(_p3##x,_p3##y,z,c), I[46] = (T)(img)(_p2##x,_p3##y,z,c), I[47] = (T)(img)(_p1##x,_p3##y,z,c), I[48] = (T)(img)(x,_p3##y,z,c), I[49] = (T)(img)(_n1##x,_p3##y,z,c), I[50] = (T)(img)(_n2##x,_p3##y,z,c), I[51] = (T)(img)(_n3##x,_p3##y,z,c), I[52] = (T)(img)(_n4##x,_p3##y,z,c), I[53] = (T)(img)(_n5##x,_p3##y,z,c), I[54] = (T)(img)(_n6##x,_p3##y,z,c), I[55] = (T)(img)(_n7##x,_p3##y,z,c), \
 I[56] = (T)(img)(_p6##x,_p2##y,z,c), I[57] = (T)(img)(_p5##x,_p2##y,z,c), I[58] = (T)(img)(_p4##x,_p2##y,z,c), I[59] = (T)(img)(_p3##x,_p2##y,z,c), I[60] = (T)(img)(_p2##x,_p2##y,z,c), I[61] = (T)(img)(_p1##x,_p2##y,z,c), I[62] = (T)(img)(x,_p2##y,z,c), I[63] = (T)(img)(_n1##x,_p2##y,z,c), I[64] = (T)(img)(_n2##x,_p2##y,z,c), I[65] = (T)(img)(_n3##x,_p2##y,z,c), I[66] = (T)(img)(_n4##x,_p2##y,z,c), I[67] = (T)(img)(_n5##x,_p2##y,z,c), I[68] = (T)(img)(_n6##x,_p2##y,z,c), I[69] = (T)(img)(_n7##x,_p2##y,z,c), \
 I[70] = (T)(img)(_p6##x,_p1##y,z,c), I[71] = (T)(img)(_p5##x,_p1##y,z,c), I[72] = (T)(img)(_p4##x,_p1##y,z,c), I[73] = (T)(img)(_p3##x,_p1##y,z,c), I[74] = (T)(img)(_p2##x,_p1##y,z,c), I[75] = (T)(img)(_p1##x,_p1##y,z,c), I[76] = (T)(img)(x,_p1##y,z,c), I[77] = (T)(img)(_n1##x,_p1##y,z,c), I[78] = (T)(img)(_n2##x,_p1##y,z,c), I[79] = (T)(img)(_n3##x,_p1##y,z,c), I[80] = (T)(img)(_n4##x,_p1##y,z,c), I[81] = (T)(img)(_n5##x,_p1##y,z,c), I[82] = (T)(img)(_n6##x,_p1##y,z,c), I[83] = (T)(img)(_n7##x,_p1##y,z,c), \
 I[84] = (T)(img)(_p6##x,y,z,c), I[85] = (T)(img)(_p5##x,y,z,c), I[86] = (T)(img)(_p4##x,y,z,c), I[87] = (T)(img)(_p3##x,y,z,c), I[88] = (T)(img)(_p2##x,y,z,c), I[89] = (T)(img)(_p1##x,y,z,c), I[90] = (T)(img)(x,y,z,c), I[91] = (T)(img)(_n1##x,y,z,c), I[92] = (T)(img)(_n2##x,y,z,c), I[93] = (T)(img)(_n3##x,y,z,c), I[94] = (T)(img)(_n4##x,y,z,c), I[95] = (T)(img)(_n5##x,y,z,c), I[96] = (T)(img)(_n6##x,y,z,c), I[97] = (T)(img)(_n7##x,y,z,c), \
 I[98] = (T)(img)(_p6##x,_n1##y,z,c), I[99] = (T)(img)(_p5##x,_n1##y,z,c), I[100] = (T)(img)(_p4##x,_n1##y,z,c), I[101] = (T)(img)(_p3##x,_n1##y,z,c), I[102] = (T)(img)(_p2##x,_n1##y,z,c), I[103] = (T)(img)(_p1##x,_n1##y,z,c), I[104] = (T)(img)(x,_n1##y,z,c), I[105] = (T)(img)(_n1##x,_n1##y,z,c), I[106] = (T)(img)(_n2##x,_n1##y,z,c), I[107] = (T)(img)(_n3##x,_n1##y,z,c), I[108] = (T)(img)(_n4##x,_n1##y,z,c), I[109] = (T)(img)(_n5##x,_n1##y,z,c), I[110] = (T)(img)(_n6##x,_n1##y,z,c), I[111] = (T)(img)(_n7##x,_n1##y,z,c), \
 I[112] = (T)(img)(_p6##x,_n2##y,z,c), I[113] = (T)(img)(_p5##x,_n2##y,z,c), I[114] = (T)(img)(_p4##x,_n2##y,z,c), I[115] = (T)(img)(_p3##x,_n2##y,z,c), I[116] = (T)(img)(_p2##x,_n2##y,z,c), I[117] = (T)(img)(_p1##x,_n2##y,z,c), I[118] = (T)(img)(x,_n2##y,z,c), I[119] = (T)(img)(_n1##x,_n2##y,z,c), I[120] = (T)(img)(_n2##x,_n2##y,z,c), I[121] = (T)(img)(_n3##x,_n2##y,z,c), I[122] = (T)(img)(_n4##x,_n2##y,z,c), I[123] = (T)(img)(_n5##x,_n2##y,z,c), I[124] = (T)(img)(_n6##x,_n2##y,z,c), I[125] = (T)(img)(_n7##x,_n2##y,z,c), \
 I[126] = (T)(img)(_p6##x,_n3##y,z,c), I[127] = (T)(img)(_p5##x,_n3##y,z,c), I[128] = (T)(img)(_p4##x,_n3##y,z,c), I[129] = (T)(img)(_p3##x,_n3##y,z,c), I[130] = (T)(img)(_p2##x,_n3##y,z,c), I[131] = (T)(img)(_p1##x,_n3##y,z,c), I[132] = (T)(img)(x,_n3##y,z,c), I[133] = (T)(img)(_n1##x,_n3##y,z,c), I[134] = (T)(img)(_n2##x,_n3##y,z,c), I[135] = (T)(img)(_n3##x,_n3##y,z,c), I[136] = (T)(img)(_n4##x,_n3##y,z,c), I[137] = (T)(img)(_n5##x,_n3##y,z,c), I[138] = (T)(img)(_n6##x,_n3##y,z,c), I[139] = (T)(img)(_n7##x,_n3##y,z,c), \
 I[140] = (T)(img)(_p6##x,_n4##y,z,c), I[141] = (T)(img)(_p5##x,_n4##y,z,c), I[142] = (T)(img)(_p4##x,_n4##y,z,c), I[143] = (T)(img)(_p3##x,_n4##y,z,c), I[144] = (T)(img)(_p2##x,_n4##y,z,c), I[145] = (T)(img)(_p1##x,_n4##y,z,c), I[146] = (T)(img)(x,_n4##y,z,c), I[147] = (T)(img)(_n1##x,_n4##y,z,c), I[148] = (T)(img)(_n2##x,_n4##y,z,c), I[149] = (T)(img)(_n3##x,_n4##y,z,c), I[150] = (T)(img)(_n4##x,_n4##y,z,c), I[151] = (T)(img)(_n5##x,_n4##y,z,c), I[152] = (T)(img)(_n6##x,_n4##y,z,c), I[153] = (T)(img)(_n7##x,_n4##y,z,c), \
 I[154] = (T)(img)(_p6##x,_n5##y,z,c), I[155] = (T)(img)(_p5##x,_n5##y,z,c), I[156] = (T)(img)(_p4##x,_n5##y,z,c), I[157] = (T)(img)(_p3##x,_n5##y,z,c), I[158] = (T)(img)(_p2##x,_n5##y,z,c), I[159] = (T)(img)(_p1##x,_n5##y,z,c), I[160] = (T)(img)(x,_n5##y,z,c), I[161] = (T)(img)(_n1##x,_n5##y,z,c), I[162] = (T)(img)(_n2##x,_n5##y,z,c), I[163] = (T)(img)(_n3##x,_n5##y,z,c), I[164] = (T)(img)(_n4##x,_n5##y,z,c), I[165] = (T)(img)(_n5##x,_n5##y,z,c), I[166] = (T)(img)(_n6##x,_n5##y,z,c), I[167] = (T)(img)(_n7##x,_n5##y,z,c), \
 I[168] = (T)(img)(_p6##x,_n6##y,z,c), I[169] = (T)(img)(_p5##x,_n6##y,z,c), I[170] = (T)(img)(_p4##x,_n6##y,z,c), I[171] = (T)(img)(_p3##x,_n6##y,z,c), I[172] = (T)(img)(_p2##x,_n6##y,z,c), I[173] = (T)(img)(_p1##x,_n6##y,z,c), I[174] = (T)(img)(x,_n6##y,z,c), I[175] = (T)(img)(_n1##x,_n6##y,z,c), I[176] = (T)(img)(_n2##x,_n6##y,z,c), I[177] = (T)(img)(_n3##x,_n6##y,z,c), I[178] = (T)(img)(_n4##x,_n6##y,z,c), I[179] = (T)(img)(_n5##x,_n6##y,z,c), I[180] = (T)(img)(_n6##x,_n6##y,z,c), I[181] = (T)(img)(_n7##x,_n6##y,z,c), \
 I[182] = (T)(img)(_p6##x,_n7##y,z,c), I[183] = (T)(img)(_p5##x,_n7##y,z,c), I[184] = (T)(img)(_p4##x,_n7##y,z,c), I[185] = (T)(img)(_p3##x,_n7##y,z,c), I[186] = (T)(img)(_p2##x,_n7##y,z,c), I[187] = (T)(img)(_p1##x,_n7##y,z,c), I[188] = (T)(img)(x,_n7##y,z,c), I[189] = (T)(img)(_n1##x,_n7##y,z,c), I[190] = (T)(img)(_n2##x,_n7##y,z,c), I[191] = (T)(img)(_n3##x,_n7##y,z,c), I[192] = (T)(img)(_n4##x,_n7##y,z,c), I[193] = (T)(img)(_n5##x,_n7##y,z,c), I[194] = (T)(img)(_n6##x,_n7##y,z,c), I[195] = (T)(img)(_n7##x,_n7##y,z,c);

// Define 15x15 loop macros
//-------------------------
#define cimg_for15(bound,i) for (int i = 0, \
 _p7##i = 0, _p6##i = 0, _p5##i = 0, _p4##i = 0, _p3##i = 0, _p2##i = 0, _p1##i = 0, \
 _n1##i = 1>=(int)(bound)?(int)(bound)-1:1, \
 _n2##i = 2>=(int)(bound)?(int)(bound)-1:2, \
 _n3##i = 3>=(int)(bound)?(int)(bound)-1:3, \
 _n4##i = 4>=(int)(bound)?(int)(bound)-1:4, \
 _n5##i = 5>=(int)(bound)?(int)(bound)-1:5, \
 _n6##i = 6>=(int)(bound)?(int)(bound)-1:6, \
 _n7##i = 7>=(int)(bound)?(int)(bound)-1:7; \
 _n7##i<(int)(bound) || _n6##i==--_n7##i || _n5##i==--_n6##i || _n4##i==--_n5##i || _n3##i==--_n4##i || _n2##i==--_n3##i || _n1##i==--_n2##i || \
 i==(_n7##i = _n6##i = _n5##i = _n4##i = _n3##i = _n2##i = --_n1##i); \
 _p7##i = _p6##i, _p6##i = _p5##i, _p5##i = _p4##i, _p4##i = _p3##i, _p3##i = _p2##i, _p2##i = _p1##i, _p1##i = i++, \
 ++_n1##i, ++_n2##i, ++_n3##i, ++_n4##i, ++_n5##i, ++_n6##i, ++_n7##i)

#define cimg_for15X(img,x) cimg_for15((img)._width,x)
#define cimg_for15Y(img,y) cimg_for15((img)._height,y)
#define cimg_for15Z(img,z) cimg_for15((img)._depth,z)
#define cimg_for15C(img,c) cimg_for15((img)._spectrum,c)
#define cimg_for15XY(img,x,y) cimg_for15Y(img,y) cimg_for15X(img,x)
#define cimg_for15XZ(img,x,z) cimg_for15Z(img,z) cimg_for15X(img,x)
#define cimg_for15XC(img,x,c) cimg_for15C(img,c) cimg_for15X(img,x)
#define cimg_for15YZ(img,y,z) cimg_for15Z(img,z) cimg_for15Y(img,y)
#define cimg_for15YC(img,y,c) cimg_for15C(img,c) cimg_for15Y(img,y)
#define cimg_for15ZC(img,z,c) cimg_for15C(img,c) cimg_for15Z(img,z)
#define cimg_for15XYZ(img,x,y,z) cimg_for15Z(img,z) cimg_for15XY(img,x,y)
#define cimg_for15XZC(img,x,z,c) cimg_for15C(img,c) cimg_for15XZ(img,x,z)
#define cimg_for15YZC(img,y,z,c) cimg_for15C(img,c) cimg_for15YZ(img,y,z)
#define cimg_for15XYZC(img,x,y,z,c) cimg_for15C(img,c) cimg_for15XYZ(img,x,y,z)

#define cimg_for_in15(bound,i0,i1,i) for (int i = (int)(i0)<0?0:(int)(i0), \
 _p7##i = i-7<0?0:i-7, \
 _p6##i = i-6<0?0:i-6, \
 _p5##i = i-5<0?0:i-5, \
 _p4##i = i-4<0?0:i-4, \
 _p3##i = i-3<0?0:i-3, \
 _p2##i = i-2<0?0:i-2, \
 _p1##i = i-1<0?0:i-1, \
 _n1##i = i+1>=(int)(bound)?(int)(bound)-1:i+1, \
 _n2##i = i+2>=(int)(bound)?(int)(bound)-1:i+2, \
 _n3##i = i+3>=(int)(bound)?(int)(bound)-1:i+3, \
 _n4##i = i+4>=(int)(bound)?(int)(bound)-1:i+4, \
 _n5##i = i+5>=(int)(bound)?(int)(bound)-1:i+5, \
 _n6##i = i+6>=(int)(bound)?(int)(bound)-1:i+6, \
 _n7##i = i+7>=(int)(bound)?(int)(bound)-1:i+7; \
 i<=(int)(i1) && (_n7##i<(int)(bound) || _n6##i==--_n7##i || _n5##i==--_n6##i || _n4##i==--_n5##i || _n3##i==--_n4##i || _n2##i==--_n3##i || _n1##i==--_n2##i || \
 i==(_n7##i = _n6##i = _n5##i = _n4##i = _n3##i = _n2##i = --_n1##i)); \
 _p7##i = _p6##i, _p6##i = _p5##i, _p5##i = _p4##i, _p4##i = _p3##i, _p3##i = _p2##i, _p2##i = _p1##i, _p1##i = i++, \
 ++_n1##i, ++_n2##i, ++_n3##i, ++_n4##i, ++_n5##i, ++_n6##i, ++_n7##i)

#define cimg_for_in15X(img,x0,x1,x) cimg_for_in15((img)._width,x0,x1,x)
#define cimg_for_in15Y(img,y0,y1,y) cimg_for_in15((img)._height,y0,y1,y)
#define cimg_for_in15Z(img,z0,z1,z) cimg_for_in15((img)._depth,z0,z1,z)
#define cimg_for_in15C(img,c0,c1,c) cimg_for_in15((img)._spectrum,c0,c1,c)
#define cimg_for_in15XY(img,x0,y0,x1,y1,x,y) cimg_for_in15Y(img,y0,y1,y) cimg_for_in15X(img,x0,x1,x)
#define cimg_for_in15XZ(img,x0,z0,x1,z1,x,z) cimg_for_in15Z(img,z0,z1,z) cimg_for_in15X(img,x0,x1,x)
#define cimg_for_in15XC(img,x0,c0,x1,c1,x,c) cimg_for_in15C(img,c0,c1,c) cimg_for_in15X(img,x0,x1,x)
#define cimg_for_in15YZ(img,y0,z0,y1,z1,y,z) cimg_for_in15Z(img,z0,z1,z) cimg_for_in15Y(img,y0,y1,y)
#define cimg_for_in15YC(img,y0,c0,y1,c1,y,c) cimg_for_in15C(img,c0,c1,c) cimg_for_in15Y(img,y0,y1,y)
#define cimg_for_in15ZC(img,z0,c0,z1,c1,z,c) cimg_for_in15C(img,c0,c1,c) cimg_for_in15Z(img,z0,z1,z)
#define cimg_for_in15XYZ(img,x0,y0,z0,x1,y1,z1,x,y,z) cimg_for_in15Z(img,z0,z1,z) cimg_for_in15XY(img,x0,y0,x1,y1,x,y)
#define cimg_for_in15XZC(img,x0,z0,c0,x1,y1,c1,x,z,c) cimg_for_in15C(img,c0,c1,c) cimg_for_in15XZ(img,x0,y0,x1,y1,x,z)
#define cimg_for_in15YZC(img,y0,z0,c0,y1,z1,c1,y,z,c) cimg_for_in15C(img,c0,c1,c) cimg_for_in15YZ(img,y0,z0,y1,z1,y,z)
#define cimg_for_in15XYZC(img,x0,y0,z0,c0,x1,y1,z1,c1,x,y,z,c) cimg_for_in15C(img,c0,c1,c) cimg_for_in15XYZ(img,x0,y0,z0,x1,y1,z1,x,y,z)

#define cimg_for15x15(img,x,y,z,c,I,T) \
 cimg_for15((img)._height,y) for (int x = 0, \
 _p7##x = 0, _p6##x = 0, _p5##x = 0, _p4##x = 0, _p3##x = 0, _p2##x = 0, _p1##x = 0, \
 _n1##x = 1>=((img)._width)?(img).width()-1:1, \
 _n2##x = 2>=((img)._width)?(img).width()-1:2, \
 _n3##x = 3>=((img)._width)?(img).width()-1:3, \
 _n4##x = 4>=((img)._width)?(img).width()-1:4, \
 _n5##x = 5>=((img)._width)?(img).width()-1:5, \
 _n6##x = 6>=((img)._width)?(img).width()-1:6, \
 _n7##x = (int)( \
 (I[0] = I[1] = I[2] = I[3] = I[4] = I[5] = I[6] = I[7] = (T)(img)(0,_p7##y,z,c)), \
 (I[15] = I[16] = I[17] = I[18] = I[19] = I[20] = I[21] = I[22] = (T)(img)(0,_p6##y,z,c)), \
 (I[30] = I[31] = I[32] = I[33] = I[34] = I[35] = I[36] = I[37] = (T)(img)(0,_p5##y,z,c)), \
 (I[45] = I[46] = I[47] = I[48] = I[49] = I[50] = I[51] = I[52] = (T)(img)(0,_p4##y,z,c)), \
 (I[60] = I[61] = I[62] = I[63] = I[64] = I[65] = I[66] = I[67] = (T)(img)(0,_p3##y,z,c)), \
 (I[75] = I[76] = I[77] = I[78] = I[79] = I[80] = I[81] = I[82] = (T)(img)(0,_p2##y,z,c)), \
 (I[90] = I[91] = I[92] = I[93] = I[94] = I[95] = I[96] = I[97] = (T)(img)(0,_p1##y,z,c)), \
 (I[105] = I[106] = I[107] = I[108] = I[109] = I[110] = I[111] = I[112] = (T)(img)(0,y,z,c)), \
 (I[120] = I[121] = I[122] = I[123] = I[124] = I[125] = I[126] = I[127] = (T)(img)(0,_n1##y,z,c)), \
 (I[135] = I[136] = I[137] = I[138] = I[139] = I[140] = I[141] = I[142] = (T)(img)(0,_n2##y,z,c)), \
 (I[150] = I[151] = I[152] = I[153] = I[154] = I[155] = I[156] = I[157] = (T)(img)(0,_n3##y,z,c)), \
 (I[165] = I[166] = I[167] = I[168] = I[169] = I[170] = I[171] = I[172] = (T)(img)(0,_n4##y,z,c)), \
 (I[180] = I[181] = I[182] = I[183] = I[184] = I[185] = I[186] = I[187] = (T)(img)(0,_n5##y,z,c)), \
 (I[195] = I[196] = I[197] = I[198] = I[199] = I[200] = I[201] = I[202] = (T)(img)(0,_n6##y,z,c)), \
 (I[210] = I[211] = I[212] = I[213] = I[214] = I[215] = I[216] = I[217] = (T)(img)(0,_n7##y,z,c)), \
 (I[8] = (T)(img)(_n1##x,_p7##y,z,c)), \
 (I[23] = (T)(img)(_n1##x,_p6##y,z,c)), \
 (I[38] = (T)(img)(_n1##x,_p5##y,z,c)), \
 (I[53] = (T)(img)(_n1##x,_p4##y,z,c)), \
 (I[68] = (T)(img)(_n1##x,_p3##y,z,c)), \
 (I[83] = (T)(img)(_n1##x,_p2##y,z,c)), \
 (I[98] = (T)(img)(_n1##x,_p1##y,z,c)), \
 (I[113] = (T)(img)(_n1##x,y,z,c)), \
 (I[128] = (T)(img)(_n1##x,_n1##y,z,c)), \
 (I[143] = (T)(img)(_n1##x,_n2##y,z,c)), \
 (I[158] = (T)(img)(_n1##x,_n3##y,z,c)), \
 (I[173] = (T)(img)(_n1##x,_n4##y,z,c)), \
 (I[188] = (T)(img)(_n1##x,_n5##y,z,c)), \
 (I[203] = (T)(img)(_n1##x,_n6##y,z,c)), \
 (I[218] = (T)(img)(_n1##x,_n7##y,z,c)), \
 (I[9] = (T)(img)(_n2##x,_p7##y,z,c)), \
 (I[24] = (T)(img)(_n2##x,_p6##y,z,c)), \
 (I[39] = (T)(img)(_n2##x,_p5##y,z,c)), \
 (I[54] = (T)(img)(_n2##x,_p4##y,z,c)), \
 (I[69] = (T)(img)(_n2##x,_p3##y,z,c)), \
 (I[84] = (T)(img)(_n2##x,_p2##y,z,c)), \
 (I[99] = (T)(img)(_n2##x,_p1##y,z,c)), \
 (I[114] = (T)(img)(_n2##x,y,z,c)), \
 (I[129] = (T)(img)(_n2##x,_n1##y,z,c)), \
 (I[144] = (T)(img)(_n2##x,_n2##y,z,c)), \
 (I[159] = (T)(img)(_n2##x,_n3##y,z,c)), \
 (I[174] = (T)(img)(_n2##x,_n4##y,z,c)), \
 (I[189] = (T)(img)(_n2##x,_n5##y,z,c)), \
 (I[204] = (T)(img)(_n2##x,_n6##y,z,c)), \
 (I[219] = (T)(img)(_n2##x,_n7##y,z,c)), \
 (I[10] = (T)(img)(_n3##x,_p7##y,z,c)), \
 (I[25] = (T)(img)(_n3##x,_p6##y,z,c)), \
 (I[40] = (T)(img)(_n3##x,_p5##y,z,c)), \
 (I[55] = (T)(img)(_n3##x,_p4##y,z,c)), \
 (I[70] = (T)(img)(_n3##x,_p3##y,z,c)), \
 (I[85] = (T)(img)(_n3##x,_p2##y,z,c)), \
 (I[100] = (T)(img)(_n3##x,_p1##y,z,c)), \
 (I[115] = (T)(img)(_n3##x,y,z,c)), \
 (I[130] = (T)(img)(_n3##x,_n1##y,z,c)), \
 (I[145] = (T)(img)(_n3##x,_n2##y,z,c)), \
 (I[160] = (T)(img)(_n3##x,_n3##y,z,c)), \
 (I[175] = (T)(img)(_n3##x,_n4##y,z,c)), \
 (I[190] = (T)(img)(_n3##x,_n5##y,z,c)), \
 (I[205] = (T)(img)(_n3##x,_n6##y,z,c)), \
 (I[220] = (T)(img)(_n3##x,_n7##y,z,c)), \
 (I[11] = (T)(img)(_n4##x,_p7##y,z,c)), \
 (I[26] = (T)(img)(_n4##x,_p6##y,z,c)), \
 (I[41] = (T)(img)(_n4##x,_p5##y,z,c)), \
 (I[56] = (T)(img)(_n4##x,_p4##y,z,c)), \
 (I[71] = (T)(img)(_n4##x,_p3##y,z,c)), \
 (I[86] = (T)(img)(_n4##x,_p2##y,z,c)), \
 (I[101] = (T)(img)(_n4##x,_p1##y,z,c)), \
 (I[116] = (T)(img)(_n4##x,y,z,c)), \
 (I[131] = (T)(img)(_n4##x,_n1##y,z,c)), \
 (I[146] = (T)(img)(_n4##x,_n2##y,z,c)), \
 (I[161] = (T)(img)(_n4##x,_n3##y,z,c)), \
 (I[176] = (T)(img)(_n4##x,_n4##y,z,c)), \
 (I[191] = (T)(img)(_n4##x,_n5##y,z,c)), \
 (I[206] = (T)(img)(_n4##x,_n6##y,z,c)), \
 (I[221] = (T)(img)(_n4##x,_n7##y,z,c)), \
 (I[12] = (T)(img)(_n5##x,_p7##y,z,c)), \
 (I[27] = (T)(img)(_n5##x,_p6##y,z,c)), \
 (I[42] = (T)(img)(_n5##x,_p5##y,z,c)), \
 (I[57] = (T)(img)(_n5##x,_p4##y,z,c)), \
 (I[72] = (T)(img)(_n5##x,_p3##y,z,c)), \
 (I[87] = (T)(img)(_n5##x,_p2##y,z,c)), \
 (I[102] = (T)(img)(_n5##x,_p1##y,z,c)), \
 (I[117] = (T)(img)(_n5##x,y,z,c)), \
 (I[132] = (T)(img)(_n5##x,_n1##y,z,c)), \
 (I[147] = (T)(img)(_n5##x,_n2##y,z,c)), \
 (I[162] = (T)(img)(_n5##x,_n3##y,z,c)), \
 (I[177] = (T)(img)(_n5##x,_n4##y,z,c)), \
 (I[192] = (T)(img)(_n5##x,_n5##y,z,c)), \
 (I[207] = (T)(img)(_n5##x,_n6##y,z,c)), \
 (I[222] = (T)(img)(_n5##x,_n7##y,z,c)), \
 (I[13] = (T)(img)(_n6##x,_p7##y,z,c)), \
 (I[28] = (T)(img)(_n6##x,_p6##y,z,c)), \
 (I[43] = (T)(img)(_n6##x,_p5##y,z,c)), \
 (I[58] = (T)(img)(_n6##x,_p4##y,z,c)), \
 (I[73] = (T)(img)(_n6##x,_p3##y,z,c)), \
 (I[88] = (T)(img)(_n6##x,_p2##y,z,c)), \
 (I[103] = (T)(img)(_n6##x,_p1##y,z,c)), \
 (I[118] = (T)(img)(_n6##x,y,z,c)), \
 (I[133] = (T)(img)(_n6##x,_n1##y,z,c)), \
 (I[148] = (T)(img)(_n6##x,_n2##y,z,c)), \
 (I[163] = (T)(img)(_n6##x,_n3##y,z,c)), \
 (I[178] = (T)(img)(_n6##x,_n4##y,z,c)), \
 (I[193] = (T)(img)(_n6##x,_n5##y,z,c)), \
 (I[208] = (T)(img)(_n6##x,_n6##y,z,c)), \
 (I[223] = (T)(img)(_n6##x,_n7##y,z,c)), \
 7>=((img)._width)?(img).width()-1:7); \
 (_n7##x<(img).width() && ( \
 (I[14] = (T)(img)(_n7##x,_p7##y,z,c)), \
 (I[29] = (T)(img)(_n7##x,_p6##y,z,c)), \
 (I[44] = (T)(img)(_n7##x,_p5##y,z,c)), \
 (I[59] = (T)(img)(_n7##x,_p4##y,z,c)), \
 (I[74] = (T)(img)(_n7##x,_p3##y,z,c)), \
 (I[89] = (T)(img)(_n7##x,_p2##y,z,c)), \
 (I[104] = (T)(img)(_n7##x,_p1##y,z,c)), \
 (I[119] = (T)(img)(_n7##x,y,z,c)), \
 (I[134] = (T)(img)(_n7##x,_n1##y,z,c)), \
 (I[149] = (T)(img)(_n7##x,_n2##y,z,c)), \
 (I[164] = (T)(img)(_n7##x,_n3##y,z,c)), \
 (I[179] = (T)(img)(_n7##x,_n4##y,z,c)), \
 (I[194] = (T)(img)(_n7##x,_n5##y,z,c)), \
 (I[209] = (T)(img)(_n7##x,_n6##y,z,c)), \
 (I[224] = (T)(img)(_n7##x,_n7##y,z,c)),1)) || \
 _n6##x==--_n7##x || _n5##x==--_n6##x || _n4##x==--_n5##x || _n3##x==--_n4##x || _n2##x==--_n3##x || _n1##x==--_n2##x || x==(_n7##x = _n6##x = _n5##x = _n4##x = _n3##x = _n2##x = --_n1##x); \
 I[0] = I[1], I[1] = I[2], I[2] = I[3], I[3] = I[4], I[4] = I[5], I[5] = I[6], I[6] = I[7], I[7] = I[8], I[8] = I[9], I[9] = I[10], I[10] = I[11], I[11] = I[12], I[12] = I[13], I[13] = I[14], \
 I[15] = I[16], I[16] = I[17], I[17] = I[18], I[18] = I[19], I[19] = I[20], I[20] = I[21], I[21] = I[22], I[22] = I[23], I[23] = I[24], I[24] = I[25], I[25] = I[26], I[26] = I[27], I[27] = I[28], I[28] = I[29], \
 I[30] = I[31], I[31] = I[32], I[32] = I[33], I[33] = I[34], I[34] = I[35], I[35] = I[36], I[36] = I[37], I[37] = I[38], I[38] = I[39], I[39] = I[40], I[40] = I[41], I[41] = I[42], I[42] = I[43], I[43] = I[44], \
 I[45] = I[46], I[46] = I[47], I[47] = I[48], I[48] = I[49], I[49] = I[50], I[50] = I[51], I[51] = I[52], I[52] = I[53], I[53] = I[54], I[54] = I[55], I[55] = I[56], I[56] = I[57], I[57] = I[58], I[58] = I[59], \
 I[60] = I[61], I[61] = I[62], I[62] = I[63], I[63] = I[64], I[64] = I[65], I[65] = I[66], I[66] = I[67], I[67] = I[68], I[68] = I[69], I[69] = I[70], I[70] = I[71], I[71] = I[72], I[72] = I[73], I[73] = I[74], \
 I[75] = I[76], I[76] = I[77], I[77] = I[78], I[78] = I[79], I[79] = I[80], I[80] = I[81], I[81] = I[82], I[82] = I[83], I[83] = I[84], I[84] = I[85], I[85] = I[86], I[86] = I[87], I[87] = I[88], I[88] = I[89], \
 I[90] = I[91], I[91] = I[92], I[92] = I[93], I[93] = I[94], I[94] = I[95], I[95] = I[96], I[96] = I[97], I[97] = I[98], I[98] = I[99], I[99] = I[100], I[100] = I[101], I[101] = I[102], I[102] = I[103], I[103] = I[104], \
 I[105] = I[106], I[106] = I[107], I[107] = I[108], I[108] = I[109], I[109] = I[110], I[110] = I[111], I[111] = I[112], I[112] = I[113], I[113] = I[114], I[114] = I[115], I[115] = I[116], I[116] = I[117], I[117] = I[118], I[118] = I[119], \
 I[120] = I[121], I[121] = I[122], I[122] = I[123], I[123] = I[124], I[124] = I[125], I[125] = I[126], I[126] = I[127], I[127] = I[128], I[128] = I[129], I[129] = I[130], I[130] = I[131], I[131] = I[132], I[132] = I[133], I[133] = I[134], \
 I[135] = I[136], I[136] = I[137], I[137] = I[138], I[138] = I[139], I[139] = I[140], I[140] = I[141], I[141] = I[142], I[142] = I[143], I[143] = I[144], I[144] = I[145], I[145] = I[146], I[146] = I[147], I[147] = I[148], I[148] = I[149], \
 I[150] = I[151], I[151] = I[152], I[152] = I[153], I[153] = I[154], I[154] = I[155], I[155] = I[156], I[156] = I[157], I[157] = I[158], I[158] = I[159], I[159] = I[160], I[160] = I[161], I[161] = I[162], I[162] = I[163], I[163] = I[164], \
 I[165] = I[166], I[166] = I[167], I[167] = I[168], I[168] = I[169], I[169] = I[170], I[170] = I[171], I[171] = I[172], I[172] = I[173], I[173] = I[174], I[174] = I[175], I[175] = I[176], I[176] = I[177], I[177] = I[178], I[178] = I[179], \
 I[180] = I[181], I[181] = I[182], I[182] = I[183], I[183] = I[184], I[184] = I[185], I[185] = I[186], I[186] = I[187], I[187] = I[188], I[188] = I[189], I[189] = I[190], I[190] = I[191], I[191] = I[192], I[192] = I[193], I[193] = I[194], \
 I[195] = I[196], I[196] = I[197], I[197] = I[198], I[198] = I[199], I[199] = I[200], I[200] = I[201], I[201] = I[202], I[202] = I[203], I[203] = I[204], I[204] = I[205], I[205] = I[206], I[206] = I[207], I[207] = I[208], I[208] = I[209], \
 I[210] = I[211], I[211] = I[212], I[212] = I[213], I[213] = I[214], I[214] = I[215], I[215] = I[216], I[216] = I[217], I[217] = I[218], I[218] = I[219], I[219] = I[220], I[220] = I[221], I[221] = I[222], I[222] = I[223], I[223] = I[224], \
 _p7##x = _p6##x, _p6##x = _p5##x, _p5##x = _p4##x, _p4##x = _p3##x, _p3##x = _p2##x, _p2##x = _p1##x, _p1##x = x++, ++_n1##x, ++_n2##x, ++_n3##x, ++_n4##x, ++_n5##x, ++_n6##x, ++_n7##x)

#define cimg_for_in15x15(img,x0,y0,x1,y1,x,y,z,c,I,T) \
 cimg_for_in15((img)._height,y0,y1,y) for (int x = (int)(x0)<0?0:(int)(x0), \
 _p7##x = x-7<0?0:x-7, \
 _p6##x = x-6<0?0:x-6, \
 _p5##x = x-5<0?0:x-5, \
 _p4##x = x-4<0?0:x-4, \
 _p3##x = x-3<0?0:x-3, \
 _p2##x = x-2<0?0:x-2, \
 _p1##x = x-1<0?0:x-1, \
 _n1##x = x+1>=(img).width()?(img).width()-1:x+1, \
 _n2##x = x+2>=(img).width()?(img).width()-1:x+2, \
 _n3##x = x+3>=(img).width()?(img).width()-1:x+3, \
 _n4##x = x+4>=(img).width()?(img).width()-1:x+4, \
 _n5##x = x+5>=(img).width()?(img).width()-1:x+5, \
 _n6##x = x+6>=(img).width()?(img).width()-1:x+6, \
 _n7##x = (int)( \
 (I[0] = (T)(img)(_p7##x,_p7##y,z,c)), \
 (I[15] = (T)(img)(_p7##x,_p6##y,z,c)), \
 (I[30] = (T)(img)(_p7##x,_p5##y,z,c)), \
 (I[45] = (T)(img)(_p7##x,_p4##y,z,c)), \
 (I[60] = (T)(img)(_p7##x,_p3##y,z,c)), \
 (I[75] = (T)(img)(_p7##x,_p2##y,z,c)), \
 (I[90] = (T)(img)(_p7##x,_p1##y,z,c)), \
 (I[105] = (T)(img)(_p7##x,y,z,c)), \
 (I[120] = (T)(img)(_p7##x,_n1##y,z,c)), \
 (I[135] = (T)(img)(_p7##x,_n2##y,z,c)), \
 (I[150] = (T)(img)(_p7##x,_n3##y,z,c)), \
 (I[165] = (T)(img)(_p7##x,_n4##y,z,c)), \
 (I[180] = (T)(img)(_p7##x,_n5##y,z,c)), \
 (I[195] = (T)(img)(_p7##x,_n6##y,z,c)), \
 (I[210] = (T)(img)(_p7##x,_n7##y,z,c)), \
 (I[1] = (T)(img)(_p6##x,_p7##y,z,c)), \
 (I[16] = (T)(img)(_p6##x,_p6##y,z,c)), \
 (I[31] = (T)(img)(_p6##x,_p5##y,z,c)), \
 (I[46] = (T)(img)(_p6##x,_p4##y,z,c)), \
 (I[61] = (T)(img)(_p6##x,_p3##y,z,c)), \
 (I[76] = (T)(img)(_p6##x,_p2##y,z,c)), \
 (I[91] = (T)(img)(_p6##x,_p1##y,z,c)), \
 (I[106] = (T)(img)(_p6##x,y,z,c)), \
 (I[121] = (T)(img)(_p6##x,_n1##y,z,c)), \
 (I[136] = (T)(img)(_p6##x,_n2##y,z,c)), \
 (I[151] = (T)(img)(_p6##x,_n3##y,z,c)), \
 (I[166] = (T)(img)(_p6##x,_n4##y,z,c)), \
 (I[181] = (T)(img)(_p6##x,_n5##y,z,c)), \
 (I[196] = (T)(img)(_p6##x,_n6##y,z,c)), \
 (I[211] = (T)(img)(_p6##x,_n7##y,z,c)), \
 (I[2] = (T)(img)(_p5##x,_p7##y,z,c)), \
 (I[17] = (T)(img)(_p5##x,_p6##y,z,c)), \
 (I[32] = (T)(img)(_p5##x,_p5##y,z,c)), \
 (I[47] = (T)(img)(_p5##x,_p4##y,z,c)), \
 (I[62] = (T)(img)(_p5##x,_p3##y,z,c)), \
 (I[77] = (T)(img)(_p5##x,_p2##y,z,c)), \
 (I[92] = (T)(img)(_p5##x,_p1##y,z,c)), \
 (I[107] = (T)(img)(_p5##x,y,z,c)), \
 (I[122] = (T)(img)(_p5##x,_n1##y,z,c)), \
 (I[137] = (T)(img)(_p5##x,_n2##y,z,c)), \
 (I[152] = (T)(img)(_p5##x,_n3##y,z,c)), \
 (I[167] = (T)(img)(_p5##x,_n4##y,z,c)), \
 (I[182] = (T)(img)(_p5##x,_n5##y,z,c)), \
 (I[197] = (T)(img)(_p5##x,_n6##y,z,c)), \
 (I[212] = (T)(img)(_p5##x,_n7##y,z,c)), \
 (I[3] = (T)(img)(_p4##x,_p7##y,z,c)), \
 (I[18] = (T)(img)(_p4##x,_p6##y,z,c)), \
 (I[33] = (T)(img)(_p4##x,_p5##y,z,c)), \
 (I[48] = (T)(img)(_p4##x,_p4##y,z,c)), \
 (I[63] = (T)(img)(_p4##x,_p3##y,z,c)), \
 (I[78] = (T)(img)(_p4##x,_p2##y,z,c)), \
 (I[93] = (T)(img)(_p4##x,_p1##y,z,c)), \
 (I[108] = (T)(img)(_p4##x,y,z,c)), \
 (I[123] = (T)(img)(_p4##x,_n1##y,z,c)), \
 (I[138] = (T)(img)(_p4##x,_n2##y,z,c)), \
 (I[153] = (T)(img)(_p4##x,_n3##y,z,c)), \
 (I[168] = (T)(img)(_p4##x,_n4##y,z,c)), \
 (I[183] = (T)(img)(_p4##x,_n5##y,z,c)), \
 (I[198] = (T)(img)(_p4##x,_n6##y,z,c)), \
 (I[213] = (T)(img)(_p4##x,_n7##y,z,c)), \
 (I[4] = (T)(img)(_p3##x,_p7##y,z,c)), \
 (I[19] = (T)(img)(_p3##x,_p6##y,z,c)), \
 (I[34] = (T)(img)(_p3##x,_p5##y,z,c)), \
 (I[49] = (T)(img)(_p3##x,_p4##y,z,c)), \
 (I[64] = (T)(img)(_p3##x,_p3##y,z,c)), \
 (I[79] = (T)(img)(_p3##x,_p2##y,z,c)), \
 (I[94] = (T)(img)(_p3##x,_p1##y,z,c)), \
 (I[109] = (T)(img)(_p3##x,y,z,c)), \
 (I[124] = (T)(img)(_p3##x,_n1##y,z,c)), \
 (I[139] = (T)(img)(_p3##x,_n2##y,z,c)), \
 (I[154] = (T)(img)(_p3##x,_n3##y,z,c)), \
 (I[169] = (T)(img)(_p3##x,_n4##y,z,c)), \
 (I[184] = (T)(img)(_p3##x,_n5##y,z,c)), \
 (I[199] = (T)(img)(_p3##x,_n6##y,z,c)), \
 (I[214] = (T)(img)(_p3##x,_n7##y,z,c)), \
 (I[5] = (T)(img)(_p2##x,_p7##y,z,c)), \
 (I[20] = (T)(img)(_p2##x,_p6##y,z,c)), \
 (I[35] = (T)(img)(_p2##x,_p5##y,z,c)), \
 (I[50] = (T)(img)(_p2##x,_p4##y,z,c)), \
 (I[65] = (T)(img)(_p2##x,_p3##y,z,c)), \
 (I[80] = (T)(img)(_p2##x,_p2##y,z,c)), \
 (I[95] = (T)(img)(_p2##x,_p1##y,z,c)), \
 (I[110] = (T)(img)(_p2##x,y,z,c)), \
 (I[125] = (T)(img)(_p2##x,_n1##y,z,c)), \
 (I[140] = (T)(img)(_p2##x,_n2##y,z,c)), \
 (I[155] = (T)(img)(_p2##x,_n3##y,z,c)), \
 (I[170] = (T)(img)(_p2##x,_n4##y,z,c)), \
 (I[185] = (T)(img)(_p2##x,_n5##y,z,c)), \
 (I[200] = (T)(img)(_p2##x,_n6##y,z,c)), \
 (I[215] = (T)(img)(_p2##x,_n7##y,z,c)), \
 (I[6] = (T)(img)(_p1##x,_p7##y,z,c)), \
 (I[21] = (T)(img)(_p1##x,_p6##y,z,c)), \
 (I[36] = (T)(img)(_p1##x,_p5##y,z,c)), \
 (I[51] = (T)(img)(_p1##x,_p4##y,z,c)), \
 (I[66] = (T)(img)(_p1##x,_p3##y,z,c)), \
 (I[81] = (T)(img)(_p1##x,_p2##y,z,c)), \
 (I[96] = (T)(img)(_p1##x,_p1##y,z,c)), \
 (I[111] = (T)(img)(_p1##x,y,z,c)), \
 (I[126] = (T)(img)(_p1##x,_n1##y,z,c)), \
 (I[141] = (T)(img)(_p1##x,_n2##y,z,c)), \
 (I[156] = (T)(img)(_p1##x,_n3##y,z,c)), \
 (I[171] = (T)(img)(_p1##x,_n4##y,z,c)), \
 (I[186] = (T)(img)(_p1##x,_n5##y,z,c)), \
 (I[201] = (T)(img)(_p1##x,_n6##y,z,c)), \
 (I[216] = (T)(img)(_p1##x,_n7##y,z,c)), \
 (I[7] = (T)(img)(x,_p7##y,z,c)), \
 (I[22] = (T)(img)(x,_p6##y,z,c)), \
 (I[37] = (T)(img)(x,_p5##y,z,c)), \
 (I[52] = (T)(img)(x,_p4##y,z,c)), \
 (I[67] = (T)(img)(x,_p3##y,z,c)), \
 (I[82] = (T)(img)(x,_p2##y,z,c)), \
 (I[97] = (T)(img)(x,_p1##y,z,c)), \
 (I[112] = (T)(img)(x,y,z,c)), \
 (I[127] = (T)(img)(x,_n1##y,z,c)), \
 (I[142] = (T)(img)(x,_n2##y,z,c)), \
 (I[157] = (T)(img)(x,_n3##y,z,c)), \
 (I[172] = (T)(img)(x,_n4##y,z,c)), \
 (I[187] = (T)(img)(x,_n5##y,z,c)), \
 (I[202] = (T)(img)(x,_n6##y,z,c)), \
 (I[217] = (T)(img)(x,_n7##y,z,c)), \
 (I[8] = (T)(img)(_n1##x,_p7##y,z,c)), \
 (I[23] = (T)(img)(_n1##x,_p6##y,z,c)), \
 (I[38] = (T)(img)(_n1##x,_p5##y,z,c)), \
 (I[53] = (T)(img)(_n1##x,_p4##y,z,c)), \
 (I[68] = (T)(img)(_n1##x,_p3##y,z,c)), \
 (I[83] = (T)(img)(_n1##x,_p2##y,z,c)), \
 (I[98] = (T)(img)(_n1##x,_p1##y,z,c)), \
 (I[113] = (T)(img)(_n1##x,y,z,c)), \
 (I[128] = (T)(img)(_n1##x,_n1##y,z,c)), \
 (I[143] = (T)(img)(_n1##x,_n2##y,z,c)), \
 (I[158] = (T)(img)(_n1##x,_n3##y,z,c)), \
 (I[173] = (T)(img)(_n1##x,_n4##y,z,c)), \
 (I[188] = (T)(img)(_n1##x,_n5##y,z,c)), \
 (I[203] = (T)(img)(_n1##x,_n6##y,z,c)), \
 (I[218] = (T)(img)(_n1##x,_n7##y,z,c)), \
 (I[9] = (T)(img)(_n2##x,_p7##y,z,c)), \
 (I[24] = (T)(img)(_n2##x,_p6##y,z,c)), \
 (I[39] = (T)(img)(_n2##x,_p5##y,z,c)), \
 (I[54] = (T)(img)(_n2##x,_p4##y,z,c)), \
 (I[69] = (T)(img)(_n2##x,_p3##y,z,c)), \
 (I[84] = (T)(img)(_n2##x,_p2##y,z,c)), \
 (I[99] = (T)(img)(_n2##x,_p1##y,z,c)), \
 (I[114] = (T)(img)(_n2##x,y,z,c)), \
 (I[129] = (T)(img)(_n2##x,_n1##y,z,c)), \
 (I[144] = (T)(img)(_n2##x,_n2##y,z,c)), \
 (I[159] = (T)(img)(_n2##x,_n3##y,z,c)), \
 (I[174] = (T)(img)(_n2##x,_n4##y,z,c)), \
 (I[189] = (T)(img)(_n2##x,_n5##y,z,c)), \
 (I[204] = (T)(img)(_n2##x,_n6##y,z,c)), \
 (I[219] = (T)(img)(_n2##x,_n7##y,z,c)), \
 (I[10] = (T)(img)(_n3##x,_p7##y,z,c)), \
 (I[25] = (T)(img)(_n3##x,_p6##y,z,c)), \
 (I[40] = (T)(img)(_n3##x,_p5##y,z,c)), \
 (I[55] = (T)(img)(_n3##x,_p4##y,z,c)), \
 (I[70] = (T)(img)(_n3##x,_p3##y,z,c)), \
 (I[85] = (T)(img)(_n3##x,_p2##y,z,c)), \
 (I[100] = (T)(img)(_n3##x,_p1##y,z,c)), \
 (I[115] = (T)(img)(_n3##x,y,z,c)), \
 (I[130] = (T)(img)(_n3##x,_n1##y,z,c)), \
 (I[145] = (T)(img)(_n3##x,_n2##y,z,c)), \
 (I[160] = (T)(img)(_n3##x,_n3##y,z,c)), \
 (I[175] = (T)(img)(_n3##x,_n4##y,z,c)), \
 (I[190] = (T)(img)(_n3##x,_n5##y,z,c)), \
 (I[205] = (T)(img)(_n3##x,_n6##y,z,c)), \
 (I[220] = (T)(img)(_n3##x,_n7##y,z,c)), \
 (I[11] = (T)(img)(_n4##x,_p7##y,z,c)), \
 (I[26] = (T)(img)(_n4##x,_p6##y,z,c)), \
 (I[41] = (T)(img)(_n4##x,_p5##y,z,c)), \
 (I[56] = (T)(img)(_n4##x,_p4##y,z,c)), \
 (I[71] = (T)(img)(_n4##x,_p3##y,z,c)), \
 (I[86] = (T)(img)(_n4##x,_p2##y,z,c)), \
 (I[101] = (T)(img)(_n4##x,_p1##y,z,c)), \
 (I[116] = (T)(img)(_n4##x,y,z,c)), \
 (I[131] = (T)(img)(_n4##x,_n1##y,z,c)), \
 (I[146] = (T)(img)(_n4##x,_n2##y,z,c)), \
 (I[161] = (T)(img)(_n4##x,_n3##y,z,c)), \
 (I[176] = (T)(img)(_n4##x,_n4##y,z,c)), \
 (I[191] = (T)(img)(_n4##x,_n5##y,z,c)), \
 (I[206] = (T)(img)(_n4##x,_n6##y,z,c)), \
 (I[221] = (T)(img)(_n4##x,_n7##y,z,c)), \
 (I[12] = (T)(img)(_n5##x,_p7##y,z,c)), \
 (I[27] = (T)(img)(_n5##x,_p6##y,z,c)), \
 (I[42] = (T)(img)(_n5##x,_p5##y,z,c)), \
 (I[57] = (T)(img)(_n5##x,_p4##y,z,c)), \
 (I[72] = (T)(img)(_n5##x,_p3##y,z,c)), \
 (I[87] = (T)(img)(_n5##x,_p2##y,z,c)), \
 (I[102] = (T)(img)(_n5##x,_p1##y,z,c)), \
 (I[117] = (T)(img)(_n5##x,y,z,c)), \
 (I[132] = (T)(img)(_n5##x,_n1##y,z,c)), \
 (I[147] = (T)(img)(_n5##x,_n2##y,z,c)), \
 (I[162] = (T)(img)(_n5##x,_n3##y,z,c)), \
 (I[177] = (T)(img)(_n5##x,_n4##y,z,c)), \
 (I[192] = (T)(img)(_n5##x,_n5##y,z,c)), \
 (I[207] = (T)(img)(_n5##x,_n6##y,z,c)), \
 (I[222] = (T)(img)(_n5##x,_n7##y,z,c)), \
 (I[13] = (T)(img)(_n6##x,_p7##y,z,c)), \
 (I[28] = (T)(img)(_n6##x,_p6##y,z,c)), \
 (I[43] = (T)(img)(_n6##x,_p5##y,z,c)), \
 (I[58] = (T)(img)(_n6##x,_p4##y,z,c)), \
 (I[73] = (T)(img)(_n6##x,_p3##y,z,c)), \
 (I[88] = (T)(img)(_n6##x,_p2##y,z,c)), \
 (I[103] = (T)(img)(_n6##x,_p1##y,z,c)), \
 (I[118] = (T)(img)(_n6##x,y,z,c)), \
 (I[133] = (T)(img)(_n6##x,_n1##y,z,c)), \
 (I[148] = (T)(img)(_n6##x,_n2##y,z,c)), \
 (I[163] = (T)(img)(_n6##x,_n3##y,z,c)), \
 (I[178] = (T)(img)(_n6##x,_n4##y,z,c)), \
 (I[193] = (T)(img)(_n6##x,_n5##y,z,c)), \
 (I[208] = (T)(img)(_n6##x,_n6##y,z,c)), \
 (I[223] = (T)(img)(_n6##x,_n7##y,z,c)), \
 x+7>=(img).width()?(img).width()-1:x+7); \
 x<=(int)(x1) && ((_n7##x<(img).width() && ( \
 (I[14] = (T)(img)(_n7##x,_p7##y,z,c)), \
 (I[29] = (T)(img)(_n7##x,_p6##y,z,c)), \
 (I[44] = (T)(img)(_n7##x,_p5##y,z,c)), \
 (I[59] = (T)(img)(_n7##x,_p4##y,z,c)), \
 (I[74] = (T)(img)(_n7##x,_p3##y,z,c)), \
 (I[89] = (T)(img)(_n7##x,_p2##y,z,c)), \
 (I[104] = (T)(img)(_n7##x,_p1##y,z,c)), \
 (I[119] = (T)(img)(_n7##x,y,z,c)), \
 (I[134] = (T)(img)(_n7##x,_n1##y,z,c)), \
 (I[149] = (T)(img)(_n7##x,_n2##y,z,c)), \
 (I[164] = (T)(img)(_n7##x,_n3##y,z,c)), \
 (I[179] = (T)(img)(_n7##x,_n4##y,z,c)), \
 (I[194] = (T)(img)(_n7##x,_n5##y,z,c)), \
 (I[209] = (T)(img)(_n7##x,_n6##y,z,c)), \
 (I[224] = (T)(img)(_n7##x,_n7##y,z,c)),1)) || \
 _n6##x==--_n7##x || _n5##x==--_n6##x || _n4##x==--_n5##x || _n3##x==--_n4##x || _n2##x==--_n3##x || _n1##x==--_n2##x || x==(_n7##x = _n6##x = _n5##x = _n4##x = _n3##x = _n2##x = --_n1##x)); \
 I[0] = I[1], I[1] = I[2], I[2] = I[3], I[3] = I[4], I[4] = I[5], I[5] = I[6], I[6] = I[7], I[7] = I[8], I[8] = I[9], I[9] = I[10], I[10] = I[11], I[11] = I[12], I[12] = I[13], I[13] = I[14], \
 I[15] = I[16], I[16] = I[17], I[17] = I[18], I[18] = I[19], I[19] = I[20], I[20] = I[21], I[21] = I[22], I[22] = I[23], I[23] = I[24], I[24] = I[25], I[25] = I[26], I[26] = I[27], I[27] = I[28], I[28] = I[29], \
 I[30] = I[31], I[31] = I[32], I[32] = I[33], I[33] = I[34], I[34] = I[35], I[35] = I[36], I[36] = I[37], I[37] = I[38], I[38] = I[39], I[39] = I[40], I[40] = I[41], I[41] = I[42], I[42] = I[43], I[43] = I[44], \
 I[45] = I[46], I[46] = I[47], I[47] = I[48], I[48] = I[49], I[49] = I[50], I[50] = I[51], I[51] = I[52], I[52] = I[53], I[53] = I[54], I[54] = I[55], I[55] = I[56], I[56] = I[57], I[57] = I[58], I[58] = I[59], \
 I[60] = I[61], I[61] = I[62], I[62] = I[63], I[63] = I[64], I[64] = I[65], I[65] = I[66], I[66] = I[67], I[67] = I[68], I[68] = I[69], I[69] = I[70], I[70] = I[71], I[71] = I[72], I[72] = I[73], I[73] = I[74], \
 I[75] = I[76], I[76] = I[77], I[77] = I[78], I[78] = I[79], I[79] = I[80], I[80] = I[81], I[81] = I[82], I[82] = I[83], I[83] = I[84], I[84] = I[85], I[85] = I[86], I[86] = I[87], I[87] = I[88], I[88] = I[89], \
 I[90] = I[91], I[91] = I[92], I[92] = I[93], I[93] = I[94], I[94] = I[95], I[95] = I[96], I[96] = I[97], I[97] = I[98], I[98] = I[99], I[99] = I[100], I[100] = I[101], I[101] = I[102], I[102] = I[103], I[103] = I[104], \
 I[105] = I[106], I[106] = I[107], I[107] = I[108], I[108] = I[109], I[109] = I[110], I[110] = I[111], I[111] = I[112], I[112] = I[113], I[113] = I[114], I[114] = I[115], I[115] = I[116], I[116] = I[117], I[117] = I[118], I[118] = I[119], \
 I[120] = I[121], I[121] = I[122], I[122] = I[123], I[123] = I[124], I[124] = I[125], I[125] = I[126], I[126] = I[127], I[127] = I[128], I[128] = I[129], I[129] = I[130], I[130] = I[131], I[131] = I[132], I[132] = I[133], I[133] = I[134], \
 I[135] = I[136], I[136] = I[137], I[137] = I[138], I[138] = I[139], I[139] = I[140], I[140] = I[141], I[141] = I[142], I[142] = I[143], I[143] = I[144], I[144] = I[145], I[145] = I[146], I[146] = I[147], I[147] = I[148], I[148] = I[149], \
 I[150] = I[151], I[151] = I[152], I[152] = I[153], I[153] = I[154], I[154] = I[155], I[155] = I[156], I[156] = I[157], I[157] = I[158], I[158] = I[159], I[159] = I[160], I[160] = I[161], I[161] = I[162], I[162] = I[163], I[163] = I[164], \
 I[165] = I[166], I[166] = I[167], I[167] = I[168], I[168] = I[169], I[169] = I[170], I[170] = I[171], I[171] = I[172], I[172] = I[173], I[173] = I[174], I[174] = I[175], I[175] = I[176], I[176] = I[177], I[177] = I[178], I[178] = I[179], \
 I[180] = I[181], I[181] = I[182], I[182] = I[183], I[183] = I[184], I[184] = I[185], I[185] = I[186], I[186] = I[187], I[187] = I[188], I[188] = I[189], I[189] = I[190], I[190] = I[191], I[191] = I[192], I[192] = I[193], I[193] = I[194], \
 I[195] = I[196], I[196] = I[197], I[197] = I[198], I[198] = I[199], I[199] = I[200], I[200] = I[201], I[201] = I[202], I[202] = I[203], I[203] = I[204], I[204] = I[205], I[205] = I[206], I[206] = I[207], I[207] = I[208], I[208] = I[209], \
 I[210] = I[211], I[211] = I[212], I[212] = I[213], I[213] = I[214], I[214] = I[215], I[215] = I[216], I[216] = I[217], I[217] = I[218], I[218] = I[219], I[219] = I[220], I[220] = I[221], I[221] = I[222], I[222] = I[223], I[223] = I[224], \
 _p7##x = _p6##x, _p6##x = _p5##x, _p5##x = _p4##x, _p4##x = _p3##x, _p3##x = _p2##x, _p2##x = _p1##x, _p1##x = x++, ++_n1##x, ++_n2##x, ++_n3##x, ++_n4##x, ++_n5##x, ++_n6##x, ++_n7##x)

#define cimg_get15x15(img,x,y,z,c,I,T) \
 I[0] = (T)(img)(_p7##x,_p7##y,z,c), I[1] = (T)(img)(_p6##x,_p7##y,z,c), I[2] = (T)(img)(_p5##x,_p7##y,z,c), I[3] = (T)(img)(_p4##x,_p7##y,z,c), I[4] = (T)(img)(_p3##x,_p7##y,z,c), I[5] = (T)(img)(_p2##x,_p7##y,z,c), I[6] = (T)(img)(_p1##x,_p7##y,z,c), I[7] = (T)(img)(x,_p7##y,z,c), I[8] = (T)(img)(_n1##x,_p7##y,z,c), I[9] = (T)(img)(_n2##x,_p7##y,z,c), I[10] = (T)(img)(_n3##x,_p7##y,z,c), I[11] = (T)(img)(_n4##x,_p7##y,z,c), I[12] = (T)(img)(_n5##x,_p7##y,z,c), I[13] = (T)(img)(_n6##x,_p7##y,z,c), I[14] = (T)(img)(_n7##x,_p7##y,z,c), \
 I[15] = (T)(img)(_p7##x,_p6##y,z,c), I[16] = (T)(img)(_p6##x,_p6##y,z,c), I[17] = (T)(img)(_p5##x,_p6##y,z,c), I[18] = (T)(img)(_p4##x,_p6##y,z,c), I[19] = (T)(img)(_p3##x,_p6##y,z,c), I[20] = (T)(img)(_p2##x,_p6##y,z,c), I[21] = (T)(img)(_p1##x,_p6##y,z,c), I[22] = (T)(img)(x,_p6##y,z,c), I[23] = (T)(img)(_n1##x,_p6##y,z,c), I[24] = (T)(img)(_n2##x,_p6##y,z,c), I[25] = (T)(img)(_n3##x,_p6##y,z,c), I[26] = (T)(img)(_n4##x,_p6##y,z,c), I[27] = (T)(img)(_n5##x,_p6##y,z,c), I[28] = (T)(img)(_n6##x,_p6##y,z,c), I[29] = (T)(img)(_n7##x,_p6##y,z,c), \
 I[30] = (T)(img)(_p7##x,_p5##y,z,c), I[31] = (T)(img)(_p6##x,_p5##y,z,c), I[32] = (T)(img)(_p5##x,_p5##y,z,c), I[33] = (T)(img)(_p4##x,_p5##y,z,c), I[34] = (T)(img)(_p3##x,_p5##y,z,c), I[35] = (T)(img)(_p2##x,_p5##y,z,c), I[36] = (T)(img)(_p1##x,_p5##y,z,c), I[37] = (T)(img)(x,_p5##y,z,c), I[38] = (T)(img)(_n1##x,_p5##y,z,c), I[39] = (T)(img)(_n2##x,_p5##y,z,c), I[40] = (T)(img)(_n3##x,_p5##y,z,c), I[41] = (T)(img)(_n4##x,_p5##y,z,c), I[42] = (T)(img)(_n5##x,_p5##y,z,c), I[43] = (T)(img)(_n6##x,_p5##y,z,c), I[44] = (T)(img)(_n7##x,_p5##y,z,c), \
 I[45] = (T)(img)(_p7##x,_p4##y,z,c), I[46] = (T)(img)(_p6##x,_p4##y,z,c), I[47] = (T)(img)(_p5##x,_p4##y,z,c), I[48] = (T)(img)(_p4##x,_p4##y,z,c), I[49] = (T)(img)(_p3##x,_p4##y,z,c), I[50] = (T)(img)(_p2##x,_p4##y,z,c), I[51] = (T)(img)(_p1##x,_p4##y,z,c), I[52] = (T)(img)(x,_p4##y,z,c), I[53] = (T)(img)(_n1##x,_p4##y,z,c), I[54] = (T)(img)(_n2##x,_p4##y,z,c), I[55] = (T)(img)(_n3##x,_p4##y,z,c), I[56] = (T)(img)(_n4##x,_p4##y,z,c), I[57] = (T)(img)(_n5##x,_p4##y,z,c), I[58] = (T)(img)(_n6##x,_p4##y,z,c), I[59] = (T)(img)(_n7##x,_p4##y,z,c), \
 I[60] = (T)(img)(_p7##x,_p3##y,z,c), I[61] = (T)(img)(_p6##x,_p3##y,z,c), I[62] = (T)(img)(_p5##x,_p3##y,z,c), I[63] = (T)(img)(_p4##x,_p3##y,z,c), I[64] = (T)(img)(_p3##x,_p3##y,z,c), I[65] = (T)(img)(_p2##x,_p3##y,z,c), I[66] = (T)(img)(_p1##x,_p3##y,z,c), I[67] = (T)(img)(x,_p3##y,z,c), I[68] = (T)(img)(_n1##x,_p3##y,z,c), I[69] = (T)(img)(_n2##x,_p3##y,z,c), I[70] = (T)(img)(_n3##x,_p3##y,z,c), I[71] = (T)(img)(_n4##x,_p3##y,z,c), I[72] = (T)(img)(_n5##x,_p3##y,z,c), I[73] = (T)(img)(_n6##x,_p3##y,z,c), I[74] = (T)(img)(_n7##x,_p3##y,z,c), \
 I[75] = (T)(img)(_p7##x,_p2##y,z,c), I[76] = (T)(img)(_p6##x,_p2##y,z,c), I[77] = (T)(img)(_p5##x,_p2##y,z,c), I[78] = (T)(img)(_p4##x,_p2##y,z,c), I[79] = (T)(img)(_p3##x,_p2##y,z,c), I[80] = (T)(img)(_p2##x,_p2##y,z,c), I[81] = (T)(img)(_p1##x,_p2##y,z,c), I[82] = (T)(img)(x,_p2##y,z,c), I[83] = (T)(img)(_n1##x,_p2##y,z,c), I[84] = (T)(img)(_n2##x,_p2##y,z,c), I[85] = (T)(img)(_n3##x,_p2##y,z,c), I[86] = (T)(img)(_n4##x,_p2##y,z,c), I[87] = (T)(img)(_n5##x,_p2##y,z,c), I[88] = (T)(img)(_n6##x,_p2##y,z,c), I[89] = (T)(img)(_n7##x,_p2##y,z,c), \
 I[90] = (T)(img)(_p7##x,_p1##y,z,c), I[91] = (T)(img)(_p6##x,_p1##y,z,c), I[92] = (T)(img)(_p5##x,_p1##y,z,c), I[93] = (T)(img)(_p4##x,_p1##y,z,c), I[94] = (T)(img)(_p3##x,_p1##y,z,c), I[95] = (T)(img)(_p2##x,_p1##y,z,c), I[96] = (T)(img)(_p1##x,_p1##y,z,c), I[97] = (T)(img)(x,_p1##y,z,c), I[98] = (T)(img)(_n1##x,_p1##y,z,c), I[99] = (T)(img)(_n2##x,_p1##y,z,c), I[100] = (T)(img)(_n3##x,_p1##y,z,c), I[101] = (T)(img)(_n4##x,_p1##y,z,c), I[102] = (T)(img)(_n5##x,_p1##y,z,c), I[103] = (T)(img)(_n6##x,_p1##y,z,c), I[104] = (T)(img)(_n7##x,_p1##y,z,c), \
 I[105] = (T)(img)(_p7##x,y,z,c), I[106] = (T)(img)(_p6##x,y,z,c), I[107] = (T)(img)(_p5##x,y,z,c), I[108] = (T)(img)(_p4##x,y,z,c), I[109] = (T)(img)(_p3##x,y,z,c), I[110] = (T)(img)(_p2##x,y,z,c), I[111] = (T)(img)(_p1##x,y,z,c), I[112] = (T)(img)(x,y,z,c), I[113] = (T)(img)(_n1##x,y,z,c), I[114] = (T)(img)(_n2##x,y,z,c), I[115] = (T)(img)(_n3##x,y,z,c), I[116] = (T)(img)(_n4##x,y,z,c), I[117] = (T)(img)(_n5##x,y,z,c), I[118] = (T)(img)(_n6##x,y,z,c), I[119] = (T)(img)(_n7##x,y,z,c), \
 I[120] = (T)(img)(_p7##x,_n1##y,z,c), I[121] = (T)(img)(_p6##x,_n1##y,z,c), I[122] = (T)(img)(_p5##x,_n1##y,z,c), I[123] = (T)(img)(_p4##x,_n1##y,z,c), I[124] = (T)(img)(_p3##x,_n1##y,z,c), I[125] = (T)(img)(_p2##x,_n1##y,z,c), I[126] = (T)(img)(_p1##x,_n1##y,z,c), I[127] = (T)(img)(x,_n1##y,z,c), I[128] = (T)(img)(_n1##x,_n1##y,z,c), I[129] = (T)(img)(_n2##x,_n1##y,z,c), I[130] = (T)(img)(_n3##x,_n1##y,z,c), I[131] = (T)(img)(_n4##x,_n1##y,z,c), I[132] = (T)(img)(_n5##x,_n1##y,z,c), I[133] = (T)(img)(_n6##x,_n1##y,z,c), I[134] = (T)(img)(_n7##x,_n1##y,z,c), \
 I[135] = (T)(img)(_p7##x,_n2##y,z,c), I[136] = (T)(img)(_p6##x,_n2##y,z,c), I[137] = (T)(img)(_p5##x,_n2##y,z,c), I[138] = (T)(img)(_p4##x,_n2##y,z,c), I[139] = (T)(img)(_p3##x,_n2##y,z,c), I[140] = (T)(img)(_p2##x,_n2##y,z,c), I[141] = (T)(img)(_p1##x,_n2##y,z,c), I[142] = (T)(img)(x,_n2##y,z,c), I[143] = (T)(img)(_n1##x,_n2##y,z,c), I[144] = (T)(img)(_n2##x,_n2##y,z,c), I[145] = (T)(img)(_n3##x,_n2##y,z,c), I[146] = (T)(img)(_n4##x,_n2##y,z,c), I[147] = (T)(img)(_n5##x,_n2##y,z,c), I[148] = (T)(img)(_n6##x,_n2##y,z,c), I[149] = (T)(img)(_n7##x,_n2##y,z,c), \
 I[150] = (T)(img)(_p7##x,_n3##y,z,c), I[151] = (T)(img)(_p6##x,_n3##y,z,c), I[152] = (T)(img)(_p5##x,_n3##y,z,c), I[153] = (T)(img)(_p4##x,_n3##y,z,c), I[154] = (T)(img)(_p3##x,_n3##y,z,c), I[155] = (T)(img)(_p2##x,_n3##y,z,c), I[156] = (T)(img)(_p1##x,_n3##y,z,c), I[157] = (T)(img)(x,_n3##y,z,c), I[158] = (T)(img)(_n1##x,_n3##y,z,c), I[159] = (T)(img)(_n2##x,_n3##y,z,c), I[160] = (T)(img)(_n3##x,_n3##y,z,c), I[161] = (T)(img)(_n4##x,_n3##y,z,c), I[162] = (T)(img)(_n5##x,_n3##y,z,c), I[163] = (T)(img)(_n6##x,_n3##y,z,c), I[164] = (T)(img)(_n7##x,_n3##y,z,c), \
 I[165] = (T)(img)(_p7##x,_n4##y,z,c), I[166] = (T)(img)(_p6##x,_n4##y,z,c), I[167] = (T)(img)(_p5##x,_n4##y,z,c), I[168] = (T)(img)(_p4##x,_n4##y,z,c), I[169] = (T)(img)(_p3##x,_n4##y,z,c), I[170] = (T)(img)(_p2##x,_n4##y,z,c), I[171] = (T)(img)(_p1##x,_n4##y,z,c), I[172] = (T)(img)(x,_n4##y,z,c), I[173] = (T)(img)(_n1##x,_n4##y,z,c), I[174] = (T)(img)(_n2##x,_n4##y,z,c), I[175] = (T)(img)(_n3##x,_n4##y,z,c), I[176] = (T)(img)(_n4##x,_n4##y,z,c), I[177] = (T)(img)(_n5##x,_n4##y,z,c), I[178] = (T)(img)(_n6##x,_n4##y,z,c), I[179] = (T)(img)(_n7##x,_n4##y,z,c), \
 I[180] = (T)(img)(_p7##x,_n5##y,z,c), I[181] = (T)(img)(_p6##x,_n5##y,z,c), I[182] = (T)(img)(_p5##x,_n5##y,z,c), I[183] = (T)(img)(_p4##x,_n5##y,z,c), I[184] = (T)(img)(_p3##x,_n5##y,z,c), I[185] = (T)(img)(_p2##x,_n5##y,z,c), I[186] = (T)(img)(_p1##x,_n5##y,z,c), I[187] = (T)(img)(x,_n5##y,z,c), I[188] = (T)(img)(_n1##x,_n5##y,z,c), I[189] = (T)(img)(_n2##x,_n5##y,z,c), I[190] = (T)(img)(_n3##x,_n5##y,z,c), I[191] = (T)(img)(_n4##x,_n5##y,z,c), I[192] = (T)(img)(_n5##x,_n5##y,z,c), I[193] = (T)(img)(_n6##x,_n5##y,z,c), I[194] = (T)(img)(_n7##x,_n5##y,z,c), \
 I[195] = (T)(img)(_p7##x,_n6##y,z,c), I[196] = (T)(img)(_p6##x,_n6##y,z,c), I[197] = (T)(img)(_p5##x,_n6##y,z,c), I[198] = (T)(img)(_p4##x,_n6##y,z,c), I[199] = (T)(img)(_p3##x,_n6##y,z,c), I[200] = (T)(img)(_p2##x,_n6##y,z,c), I[201] = (T)(img)(_p1##x,_n6##y,z,c), I[202] = (T)(img)(x,_n6##y,z,c), I[203] = (T)(img)(_n1##x,_n6##y,z,c), I[204] = (T)(img)(_n2##x,_n6##y,z,c), I[205] = (T)(img)(_n3##x,_n6##y,z,c), I[206] = (T)(img)(_n4##x,_n6##y,z,c), I[207] = (T)(img)(_n5##x,_n6##y,z,c), I[208] = (T)(img)(_n6##x,_n6##y,z,c), I[209] = (T)(img)(_n7##x,_n6##y,z,c), \
 I[210] = (T)(img)(_p7##x,_n7##y,z,c), I[211] = (T)(img)(_p6##x,_n7##y,z,c), I[212] = (T)(img)(_p5##x,_n7##y,z,c), I[213] = (T)(img)(_p4##x,_n7##y,z,c), I[214] = (T)(img)(_p3##x,_n7##y,z,c), I[215] = (T)(img)(_p2##x,_n7##y,z,c), I[216] = (T)(img)(_p1##x,_n7##y,z,c), I[217] = (T)(img)(x,_n7##y,z,c), I[218] = (T)(img)(_n1##x,_n7##y,z,c), I[219] = (T)(img)(_n2##x,_n7##y,z,c), I[220] = (T)(img)(_n3##x,_n7##y,z,c), I[221] = (T)(img)(_n4##x,_n7##y,z,c), I[222] = (T)(img)(_n5##x,_n7##y,z,c), I[223] = (T)(img)(_n6##x,_n7##y,z,c), I[224] = (T)(img)(_n7##x,_n7##y,z,c);

// Define 16x16 loop macros
//-------------------------
#define cimg_for16(bound,i) for (int i = 0, \
 _p7##i = 0, _p6##i = 0, _p5##i = 0, _p4##i = 0, _p3##i = 0, _p2##i = 0, _p1##i = 0, \
 _n1##i = 1>=(int)(bound)?(int)(bound)-1:1, \
 _n2##i = 2>=(int)(bound)?(int)(bound)-1:2, \
 _n3##i = 3>=(int)(bound)?(int)(bound)-1:3, \
 _n4##i = 4>=(int)(bound)?(int)(bound)-1:4, \
 _n5##i = 5>=(int)(bound)?(int)(bound)-1:5, \
 _n6##i = 6>=(int)(bound)?(int)(bound)-1:6, \
 _n7##i = 7>=(int)(bound)?(int)(bound)-1:7, \
 _n8##i = 8>=(int)(bound)?(int)(bound)-1:8; \
 _n8##i<(int)(bound) || _n7##i==--_n8##i || _n6##i==--_n7##i || _n5##i==--_n6##i || _n4##i==--_n5##i || _n3##i==--_n4##i || _n2##i==--_n3##i || _n1##i==--_n2##i || \
 i==(_n8##i = _n7##i = _n6##i = _n5##i = _n4##i = _n3##i = _n2##i = --_n1##i); \
 _p7##i = _p6##i, _p6##i = _p5##i, _p5##i = _p4##i, _p4##i = _p3##i, _p3##i = _p2##i, _p2##i = _p1##i, _p1##i = i++, \
 ++_n1##i, ++_n2##i, ++_n3##i, ++_n4##i, ++_n5##i, ++_n6##i, ++_n7##i, ++_n8##i)

#define cimg_for16X(img,x) cimg_for16((img)._width,x)
#define cimg_for16Y(img,y) cimg_for16((img)._height,y)
#define cimg_for16Z(img,z) cimg_for16((img)._depth,z)
#define cimg_for16C(img,c) cimg_for16((img)._spectrum,c)
#define cimg_for16XY(img,x,y) cimg_for16Y(img,y) cimg_for16X(img,x)
#define cimg_for16XZ(img,x,z) cimg_for16Z(img,z) cimg_for16X(img,x)
#define cimg_for16XC(img,x,c) cimg_for16C(img,c) cimg_for16X(img,x)
#define cimg_for16YZ(img,y,z) cimg_for16Z(img,z) cimg_for16Y(img,y)
#define cimg_for16YC(img,y,c) cimg_for16C(img,c) cimg_for16Y(img,y)
#define cimg_for16ZC(img,z,c) cimg_for16C(img,c) cimg_for16Z(img,z)
#define cimg_for16XYZ(img,x,y,z) cimg_for16Z(img,z) cimg_for16XY(img,x,y)
#define cimg_for16XZC(img,x,z,c) cimg_for16C(img,c) cimg_for16XZ(img,x,z)
#define cimg_for16YZC(img,y,z,c) cimg_for16C(img,c) cimg_for16YZ(img,y,z)
#define cimg_for16XYZC(img,x,y,z,c) cimg_for16C(img,c) cimg_for16XYZ(img,x,y,z)

#define cimg_for_in16(bound,i0,i1,i) for (int i = (int)(i0)<0?0:(int)(i0), \
 _p7##i = i-7<0?0:i-7, \
 _p6##i = i-6<0?0:i-6, \
 _p5##i = i-5<0?0:i-5, \
 _p4##i = i-4<0?0:i-4, \
 _p3##i = i-3<0?0:i-3, \
 _p2##i = i-2<0?0:i-2, \
 _p1##i = i-1<0?0:i-1, \
 _n1##i = i+1>=(int)(bound)?(int)(bound)-1:i+1, \
 _n2##i = i+2>=(int)(bound)?(int)(bound)-1:i+2, \
 _n3##i = i+3>=(int)(bound)?(int)(bound)-1:i+3, \
 _n4##i = i+4>=(int)(bound)?(int)(bound)-1:i+4, \
 _n5##i = i+5>=(int)(bound)?(int)(bound)-1:i+5, \
 _n6##i = i+6>=(int)(bound)?(int)(bound)-1:i+6, \
 _n7##i = i+7>=(int)(bound)?(int)(bound)-1:i+7, \
 _n8##i = i+8>=(int)(bound)?(int)(bound)-1:i+8; \
 i<=(int)(i1) && (_n8##i<(int)(bound) || _n7##i==--_n8##i || _n6##i==--_n7##i || _n5##i==--_n6##i || _n4##i==--_n5##i || _n3##i==--_n4##i || _n2##i==--_n3##i || _n1##i==--_n2##i || \
 i==(_n8##i = _n7##i = _n6##i = _n5##i = _n4##i = _n3##i = _n2##i = --_n1##i)); \
 _p7##i = _p6##i, _p6##i = _p5##i, _p5##i = _p4##i, _p4##i = _p3##i, _p3##i = _p2##i, _p2##i = _p1##i, _p1##i = i++, \
 ++_n1##i, ++_n2##i, ++_n3##i, ++_n4##i, ++_n5##i, ++_n6##i, ++_n7##i, ++_n8##i)

#define cimg_for_in16X(img,x0,x1,x) cimg_for_in16((img)._width,x0,x1,x)
#define cimg_for_in16Y(img,y0,y1,y) cimg_for_in16((img)._height,y0,y1,y)
#define cimg_for_in16Z(img,z0,z1,z) cimg_for_in16((img)._depth,z0,z1,z)
#define cimg_for_in16C(img,c0,c1,c) cimg_for_in16((img)._spectrum,c0,c1,c)
#define cimg_for_in16XY(img,x0,y0,x1,y1,x,y) cimg_for_in16Y(img,y0,y1,y) cimg_for_in16X(img,x0,x1,x)
#define cimg_for_in16XZ(img,x0,z0,x1,z1,x,z) cimg_for_in16Z(img,z0,z1,z) cimg_for_in16X(img,x0,x1,x)
#define cimg_for_in16XC(img,x0,c0,x1,c1,x,c) cimg_for_in16C(img,c0,c1,c) cimg_for_in16X(img,x0,x1,x)
#define cimg_for_in16YZ(img,y0,z0,y1,z1,y,z) cimg_for_in16Z(img,z0,z1,z) cimg_for_in16Y(img,y0,y1,y)
#define cimg_for_in16YC(img,y0,c0,y1,c1,y,c) cimg_for_in16C(img,c0,c1,c) cimg_for_in16Y(img,y0,y1,y)
#define cimg_for_in16ZC(img,z0,c0,z1,c1,z,c) cimg_for_in16C(img,c0,c1,c) cimg_for_in16Z(img,z0,z1,z)
#define cimg_for_in16XYZ(img,x0,y0,z0,x1,y1,z1,x,y,z) cimg_for_in16Z(img,z0,z1,z) cimg_for_in16XY(img,x0,y0,x1,y1,x,y)
#define cimg_for_in16XZC(img,x0,z0,c0,x1,y1,c1,x,z,c) cimg_for_in16C(img,c0,c1,c) cimg_for_in16XZ(img,x0,y0,x1,y1,x,z)
#define cimg_for_in16YZC(img,y0,z0,c0,y1,z1,c1,y,z,c) cimg_for_in16C(img,c0,c1,c) cimg_for_in16YZ(img,y0,z0,y1,z1,y,z)
#define cimg_for_in16XYZC(img,x0,y0,z0,c0,x1,y1,z1,c1,x,y,z,c) cimg_for_in16C(img,c0,c1,c) cimg_for_in16XYZ(img,x0,y0,z0,x1,y1,z1,x,y,z)

#define cimg_for16x16(img,x,y,z,c,I,T) \
 cimg_for16((img)._height,y) for (int x = 0, \
 _p7##x = 0, _p6##x = 0, _p5##x = 0, _p4##x = 0, _p3##x = 0, _p2##x = 0, _p1##x = 0, \
 _n1##x = 1>=((img)._width)?(img).width()-1:1, \
 _n2##x = 2>=((img)._width)?(img).width()-1:2, \
 _n3##x = 3>=((img)._width)?(img).width()-1:3, \
 _n4##x = 4>=((img)._width)?(img).width()-1:4, \
 _n5##x = 5>=((img)._width)?(img).width()-1:5, \
 _n6##x = 6>=((img)._width)?(img).width()-1:6, \
 _n7##x = 7>=((img)._width)?(img).width()-1:7, \
 _n8##x = (int)( \
 (I[0] = I[1] = I[2] = I[3] = I[4] = I[5] = I[6] = I[7] = (T)(img)(0,_p7##y,z,c)), \
 (I[16] = I[17] = I[18] = I[19] = I[20] = I[21] = I[22] = I[23] = (T)(img)(0,_p6##y,z,c)), \
 (I[32] = I[33] = I[34] = I[35] = I[36] = I[37] = I[38] = I[39] = (T)(img)(0,_p5##y,z,c)), \
 (I[48] = I[49] = I[50] = I[51] = I[52] = I[53] = I[54] = I[55] = (T)(img)(0,_p4##y,z,c)), \
 (I[64] = I[65] = I[66] = I[67] = I[68] = I[69] = I[70] = I[71] = (T)(img)(0,_p3##y,z,c)), \
 (I[80] = I[81] = I[82] = I[83] = I[84] = I[85] = I[86] = I[87] = (T)(img)(0,_p2##y,z,c)), \
 (I[96] = I[97] = I[98] = I[99] = I[100] = I[101] = I[102] = I[103] = (T)(img)(0,_p1##y,z,c)), \
 (I[112] = I[113] = I[114] = I[115] = I[116] = I[117] = I[118] = I[119] = (T)(img)(0,y,z,c)), \
 (I[128] = I[129] = I[130] = I[131] = I[132] = I[133] = I[134] = I[135] = (T)(img)(0,_n1##y,z,c)), \
 (I[144] = I[145] = I[146] = I[147] = I[148] = I[149] = I[150] = I[151] = (T)(img)(0,_n2##y,z,c)), \
 (I[160] = I[161] = I[162] = I[163] = I[164] = I[165] = I[166] = I[167] = (T)(img)(0,_n3##y,z,c)), \
 (I[176] = I[177] = I[178] = I[179] = I[180] = I[181] = I[182] = I[183] = (T)(img)(0,_n4##y,z,c)), \
 (I[192] = I[193] = I[194] = I[195] = I[196] = I[197] = I[198] = I[199] = (T)(img)(0,_n5##y,z,c)), \
 (I[208] = I[209] = I[210] = I[211] = I[212] = I[213] = I[214] = I[215] = (T)(img)(0,_n6##y,z,c)), \
 (I[224] = I[225] = I[226] = I[227] = I[228] = I[229] = I[230] = I[231] = (T)(img)(0,_n7##y,z,c)), \
 (I[240] = I[241] = I[242] = I[243] = I[244] = I[245] = I[246] = I[247] = (T)(img)(0,_n8##y,z,c)), \
 (I[8] = (T)(img)(_n1##x,_p7##y,z,c)), \
 (I[24] = (T)(img)(_n1##x,_p6##y,z,c)), \
 (I[40] = (T)(img)(_n1##x,_p5##y,z,c)), \
 (I[56] = (T)(img)(_n1##x,_p4##y,z,c)), \
 (I[72] = (T)(img)(_n1##x,_p3##y,z,c)), \
 (I[88] = (T)(img)(_n1##x,_p2##y,z,c)), \
 (I[104] = (T)(img)(_n1##x,_p1##y,z,c)), \
 (I[120] = (T)(img)(_n1##x,y,z,c)), \
 (I[136] = (T)(img)(_n1##x,_n1##y,z,c)), \
 (I[152] = (T)(img)(_n1##x,_n2##y,z,c)), \
 (I[168] = (T)(img)(_n1##x,_n3##y,z,c)), \
 (I[184] = (T)(img)(_n1##x,_n4##y,z,c)), \
 (I[200] = (T)(img)(_n1##x,_n5##y,z,c)), \
 (I[216] = (T)(img)(_n1##x,_n6##y,z,c)), \
 (I[232] = (T)(img)(_n1##x,_n7##y,z,c)), \
 (I[248] = (T)(img)(_n1##x,_n8##y,z,c)), \
 (I[9] = (T)(img)(_n2##x,_p7##y,z,c)), \
 (I[25] = (T)(img)(_n2##x,_p6##y,z,c)), \
 (I[41] = (T)(img)(_n2##x,_p5##y,z,c)), \
 (I[57] = (T)(img)(_n2##x,_p4##y,z,c)), \
 (I[73] = (T)(img)(_n2##x,_p3##y,z,c)), \
 (I[89] = (T)(img)(_n2##x,_p2##y,z,c)), \
 (I[105] = (T)(img)(_n2##x,_p1##y,z,c)), \
 (I[121] = (T)(img)(_n2##x,y,z,c)), \
 (I[137] = (T)(img)(_n2##x,_n1##y,z,c)), \
 (I[153] = (T)(img)(_n2##x,_n2##y,z,c)), \
 (I[169] = (T)(img)(_n2##x,_n3##y,z,c)), \
 (I[185] = (T)(img)(_n2##x,_n4##y,z,c)), \
 (I[201] = (T)(img)(_n2##x,_n5##y,z,c)), \
 (I[217] = (T)(img)(_n2##x,_n6##y,z,c)), \
 (I[233] = (T)(img)(_n2##x,_n7##y,z,c)), \
 (I[249] = (T)(img)(_n2##x,_n8##y,z,c)), \
 (I[10] = (T)(img)(_n3##x,_p7##y,z,c)), \
 (I[26] = (T)(img)(_n3##x,_p6##y,z,c)), \
 (I[42] = (T)(img)(_n3##x,_p5##y,z,c)), \
 (I[58] = (T)(img)(_n3##x,_p4##y,z,c)), \
 (I[74] = (T)(img)(_n3##x,_p3##y,z,c)), \
 (I[90] = (T)(img)(_n3##x,_p2##y,z,c)), \
 (I[106] = (T)(img)(_n3##x,_p1##y,z,c)), \
 (I[122] = (T)(img)(_n3##x,y,z,c)), \
 (I[138] = (T)(img)(_n3##x,_n1##y,z,c)), \
 (I[154] = (T)(img)(_n3##x,_n2##y,z,c)), \
 (I[170] = (T)(img)(_n3##x,_n3##y,z,c)), \
 (I[186] = (T)(img)(_n3##x,_n4##y,z,c)), \
 (I[202] = (T)(img)(_n3##x,_n5##y,z,c)), \
 (I[218] = (T)(img)(_n3##x,_n6##y,z,c)), \
 (I[234] = (T)(img)(_n3##x,_n7##y,z,c)), \
 (I[250] = (T)(img)(_n3##x,_n8##y,z,c)), \
 (I[11] = (T)(img)(_n4##x,_p7##y,z,c)), \
 (I[27] = (T)(img)(_n4##x,_p6##y,z,c)), \
 (I[43] = (T)(img)(_n4##x,_p5##y,z,c)), \
 (I[59] = (T)(img)(_n4##x,_p4##y,z,c)), \
 (I[75] = (T)(img)(_n4##x,_p3##y,z,c)), \
 (I[91] = (T)(img)(_n4##x,_p2##y,z,c)), \
 (I[107] = (T)(img)(_n4##x,_p1##y,z,c)), \
 (I[123] = (T)(img)(_n4##x,y,z,c)), \
 (I[139] = (T)(img)(_n4##x,_n1##y,z,c)), \
 (I[155] = (T)(img)(_n4##x,_n2##y,z,c)), \
 (I[171] = (T)(img)(_n4##x,_n3##y,z,c)), \
 (I[187] = (T)(img)(_n4##x,_n4##y,z,c)), \
 (I[203] = (T)(img)(_n4##x,_n5##y,z,c)), \
 (I[219] = (T)(img)(_n4##x,_n6##y,z,c)), \
 (I[235] = (T)(img)(_n4##x,_n7##y,z,c)), \
 (I[251] = (T)(img)(_n4##x,_n8##y,z,c)), \
 (I[12] = (T)(img)(_n5##x,_p7##y,z,c)), \
 (I[28] = (T)(img)(_n5##x,_p6##y,z,c)), \
 (I[44] = (T)(img)(_n5##x,_p5##y,z,c)), \
 (I[60] = (T)(img)(_n5##x,_p4##y,z,c)), \
 (I[76] = (T)(img)(_n5##x,_p3##y,z,c)), \
 (I[92] = (T)(img)(_n5##x,_p2##y,z,c)), \
 (I[108] = (T)(img)(_n5##x,_p1##y,z,c)), \
 (I[124] = (T)(img)(_n5##x,y,z,c)), \
 (I[140] = (T)(img)(_n5##x,_n1##y,z,c)), \
 (I[156] = (T)(img)(_n5##x,_n2##y,z,c)), \
 (I[172] = (T)(img)(_n5##x,_n3##y,z,c)), \
 (I[188] = (T)(img)(_n5##x,_n4##y,z,c)), \
 (I[204] = (T)(img)(_n5##x,_n5##y,z,c)), \
 (I[220] = (T)(img)(_n5##x,_n6##y,z,c)), \
 (I[236] = (T)(img)(_n5##x,_n7##y,z,c)), \
 (I[252] = (T)(img)(_n5##x,_n8##y,z,c)), \
 (I[13] = (T)(img)(_n6##x,_p7##y,z,c)), \
 (I[29] = (T)(img)(_n6##x,_p6##y,z,c)), \
 (I[45] = (T)(img)(_n6##x,_p5##y,z,c)), \
 (I[61] = (T)(img)(_n6##x,_p4##y,z,c)), \
 (I[77] = (T)(img)(_n6##x,_p3##y,z,c)), \
 (I[93] = (T)(img)(_n6##x,_p2##y,z,c)), \
 (I[109] = (T)(img)(_n6##x,_p1##y,z,c)), \
 (I[125] = (T)(img)(_n6##x,y,z,c)), \
 (I[141] = (T)(img)(_n6##x,_n1##y,z,c)), \
 (I[157] = (T)(img)(_n6##x,_n2##y,z,c)), \
 (I[173] = (T)(img)(_n6##x,_n3##y,z,c)), \
 (I[189] = (T)(img)(_n6##x,_n4##y,z,c)), \
 (I[205] = (T)(img)(_n6##x,_n5##y,z,c)), \
 (I[221] = (T)(img)(_n6##x,_n6##y,z,c)), \
 (I[237] = (T)(img)(_n6##x,_n7##y,z,c)), \
 (I[253] = (T)(img)(_n6##x,_n8##y,z,c)), \
 (I[14] = (T)(img)(_n7##x,_p7##y,z,c)), \
 (I[30] = (T)(img)(_n7##x,_p6##y,z,c)), \
 (I[46] = (T)(img)(_n7##x,_p5##y,z,c)), \
 (I[62] = (T)(img)(_n7##x,_p4##y,z,c)), \
 (I[78] = (T)(img)(_n7##x,_p3##y,z,c)), \
 (I[94] = (T)(img)(_n7##x,_p2##y,z,c)), \
 (I[110] = (T)(img)(_n7##x,_p1##y,z,c)), \
 (I[126] = (T)(img)(_n7##x,y,z,c)), \
 (I[142] = (T)(img)(_n7##x,_n1##y,z,c)), \
 (I[158] = (T)(img)(_n7##x,_n2##y,z,c)), \
 (I[174] = (T)(img)(_n7##x,_n3##y,z,c)), \
 (I[190] = (T)(img)(_n7##x,_n4##y,z,c)), \
 (I[206] = (T)(img)(_n7##x,_n5##y,z,c)), \
 (I[222] = (T)(img)(_n7##x,_n6##y,z,c)), \
 (I[238] = (T)(img)(_n7##x,_n7##y,z,c)), \
 (I[254] = (T)(img)(_n7##x,_n8##y,z,c)), \
 8>=((img)._width)?(img).width()-1:8); \
 (_n8##x<(img).width() && ( \
 (I[15] = (T)(img)(_n8##x,_p7##y,z,c)), \
 (I[31] = (T)(img)(_n8##x,_p6##y,z,c)), \
 (I[47] = (T)(img)(_n8##x,_p5##y,z,c)), \
 (I[63] = (T)(img)(_n8##x,_p4##y,z,c)), \
 (I[79] = (T)(img)(_n8##x,_p3##y,z,c)), \
 (I[95] = (T)(img)(_n8##x,_p2##y,z,c)), \
 (I[111] = (T)(img)(_n8##x,_p1##y,z,c)), \
 (I[127] = (T)(img)(_n8##x,y,z,c)), \
 (I[143] = (T)(img)(_n8##x,_n1##y,z,c)), \
 (I[159] = (T)(img)(_n8##x,_n2##y,z,c)), \
 (I[175] = (T)(img)(_n8##x,_n3##y,z,c)), \
 (I[191] = (T)(img)(_n8##x,_n4##y,z,c)), \
 (I[207] = (T)(img)(_n8##x,_n5##y,z,c)), \
 (I[223] = (T)(img)(_n8##x,_n6##y,z,c)), \
 (I[239] = (T)(img)(_n8##x,_n7##y,z,c)), \
 (I[255] = (T)(img)(_n8##x,_n8##y,z,c)),1)) || \
 _n7##x==--_n8##x || _n6##x==--_n7##x || _n5##x==--_n6##x || _n4##x==--_n5##x || _n3##x==--_n4##x || _n2##x==--_n3##x || _n1##x==--_n2##x || x==(_n8##x = _n7##x = _n6##x = _n5##x = _n4##x = _n3##x = _n2##x = --_n1##x); \
 I[0] = I[1], I[1] = I[2], I[2] = I[3], I[3] = I[4], I[4] = I[5], I[5] = I[6], I[6] = I[7], I[7] = I[8], I[8] = I[9], I[9] = I[10], I[10] = I[11], I[11] = I[12], I[12] = I[13], I[13] = I[14], I[14] = I[15], \
 I[16] = I[17], I[17] = I[18], I[18] = I[19], I[19] = I[20], I[20] = I[21], I[21] = I[22], I[22] = I[23], I[23] = I[24], I[24] = I[25], I[25] = I[26], I[26] = I[27], I[27] = I[28], I[28] = I[29], I[29] = I[30], I[30] = I[31], \
 I[32] = I[33], I[33] = I[34], I[34] = I[35], I[35] = I[36], I[36] = I[37], I[37] = I[38], I[38] = I[39], I[39] = I[40], I[40] = I[41], I[41] = I[42], I[42] = I[43], I[43] = I[44], I[44] = I[45], I[45] = I[46], I[46] = I[47], \
 I[48] = I[49], I[49] = I[50], I[50] = I[51], I[51] = I[52], I[52] = I[53], I[53] = I[54], I[54] = I[55], I[55] = I[56], I[56] = I[57], I[57] = I[58], I[58] = I[59], I[59] = I[60], I[60] = I[61], I[61] = I[62], I[62] = I[63], \
 I[64] = I[65], I[65] = I[66], I[66] = I[67], I[67] = I[68], I[68] = I[69], I[69] = I[70], I[70] = I[71], I[71] = I[72], I[72] = I[73], I[73] = I[74], I[74] = I[75], I[75] = I[76], I[76] = I[77], I[77] = I[78], I[78] = I[79], \
 I[80] = I[81], I[81] = I[82], I[82] = I[83], I[83] = I[84], I[84] = I[85], I[85] = I[86], I[86] = I[87], I[87] = I[88], I[88] = I[89], I[89] = I[90], I[90] = I[91], I[91] = I[92], I[92] = I[93], I[93] = I[94], I[94] = I[95], \
 I[96] = I[97], I[97] = I[98], I[98] = I[99], I[99] = I[100], I[100] = I[101], I[101] = I[102], I[102] = I[103], I[103] = I[104], I[104] = I[105], I[105] = I[106], I[106] = I[107], I[107] = I[108], I[108] = I[109], I[109] = I[110], I[110] = I[111], \
 I[112] = I[113], I[113] = I[114], I[114] = I[115], I[115] = I[116], I[116] = I[117], I[117] = I[118], I[118] = I[119], I[119] = I[120], I[120] = I[121], I[121] = I[122], I[122] = I[123], I[123] = I[124], I[124] = I[125], I[125] = I[126], I[126] = I[127], \
 I[128] = I[129], I[129] = I[130], I[130] = I[131], I[131] = I[132], I[132] = I[133], I[133] = I[134], I[134] = I[135], I[135] = I[136], I[136] = I[137], I[137] = I[138], I[138] = I[139], I[139] = I[140], I[140] = I[141], I[141] = I[142], I[142] = I[143], \
 I[144] = I[145], I[145] = I[146], I[146] = I[147], I[147] = I[148], I[148] = I[149], I[149] = I[150], I[150] = I[151], I[151] = I[152], I[152] = I[153], I[153] = I[154], I[154] = I[155], I[155] = I[156], I[156] = I[157], I[157] = I[158], I[158] = I[159], \
 I[160] = I[161], I[161] = I[162], I[162] = I[163], I[163] = I[164], I[164] = I[165], I[165] = I[166], I[166] = I[167], I[167] = I[168], I[168] = I[169], I[169] = I[170], I[170] = I[171], I[171] = I[172], I[172] = I[173], I[173] = I[174], I[174] = I[175], \
 I[176] = I[177], I[177] = I[178], I[178] = I[179], I[179] = I[180], I[180] = I[181], I[181] = I[182], I[182] = I[183], I[183] = I[184], I[184] = I[185], I[185] = I[186], I[186] = I[187], I[187] = I[188], I[188] = I[189], I[189] = I[190], I[190] = I[191], \
 I[192] = I[193], I[193] = I[194], I[194] = I[195], I[195] = I[196], I[196] = I[197], I[197] = I[198], I[198] = I[199], I[199] = I[200], I[200] = I[201], I[201] = I[202], I[202] = I[203], I[203] = I[204], I[204] = I[205], I[205] = I[206], I[206] = I[207], \
 I[208] = I[209], I[209] = I[210], I[210] = I[211], I[211] = I[212], I[212] = I[213], I[213] = I[214], I[214] = I[215], I[215] = I[216], I[216] = I[217], I[217] = I[218], I[218] = I[219], I[219] = I[220], I[220] = I[221], I[221] = I[222], I[222] = I[223], \
 I[224] = I[225], I[225] = I[226], I[226] = I[227], I[227] = I[228], I[228] = I[229], I[229] = I[230], I[230] = I[231], I[231] = I[232], I[232] = I[233], I[233] = I[234], I[234] = I[235], I[235] = I[236], I[236] = I[237], I[237] = I[238], I[238] = I[239], \
 I[240] = I[241], I[241] = I[242], I[242] = I[243], I[243] = I[244], I[244] = I[245], I[245] = I[246], I[246] = I[247], I[247] = I[248], I[248] = I[249], I[249] = I[250], I[250] = I[251], I[251] = I[252], I[252] = I[253], I[253] = I[254], I[254] = I[255], \
 _p7##x = _p6##x, _p6##x = _p5##x, _p5##x = _p4##x, _p4##x = _p3##x, _p3##x = _p2##x, _p2##x = _p1##x, _p1##x = x++, ++_n1##x, ++_n2##x, ++_n3##x, ++_n4##x, ++_n5##x, ++_n6##x, ++_n7##x, ++_n8##x)

#define cimg_for_in16x16(img,x0,y0,x1,y1,x,y,z,c,I,T) \
 cimg_for_in16((img)._height,y0,y1,y) for (int x = (int)(x0)<0?0:(int)(x0), \
 _p7##x = x-7<0?0:x-7, \
 _p6##x = x-6<0?0:x-6, \
 _p5##x = x-5<0?0:x-5, \
 _p4##x = x-4<0?0:x-4, \
 _p3##x = x-3<0?0:x-3, \
 _p2##x = x-2<0?0:x-2, \
 _p1##x = x-1<0?0:x-1, \
 _n1##x = x+1>=(img).width()?(img).width()-1:x+1, \
 _n2##x = x+2>=(img).width()?(img).width()-1:x+2, \
 _n3##x = x+3>=(img).width()?(img).width()-1:x+3, \
 _n4##x = x+4>=(img).width()?(img).width()-1:x+4, \
 _n5##x = x+5>=(img).width()?(img).width()-1:x+5, \
 _n6##x = x+6>=(img).width()?(img).width()-1:x+6, \
 _n7##x = x+7>=(img).width()?(img).width()-1:x+7, \
 _n8##x = (int)( \
 (I[0] = (T)(img)(_p7##x,_p7##y,z,c)), \
 (I[16] = (T)(img)(_p7##x,_p6##y,z,c)), \
 (I[32] = (T)(img)(_p7##x,_p5##y,z,c)), \
 (I[48] = (T)(img)(_p7##x,_p4##y,z,c)), \
 (I[64] = (T)(img)(_p7##x,_p3##y,z,c)), \
 (I[80] = (T)(img)(_p7##x,_p2##y,z,c)), \
 (I[96] = (T)(img)(_p7##x,_p1##y,z,c)), \
 (I[112] = (T)(img)(_p7##x,y,z,c)), \
 (I[128] = (T)(img)(_p7##x,_n1##y,z,c)), \
 (I[144] = (T)(img)(_p7##x,_n2##y,z,c)), \
 (I[160] = (T)(img)(_p7##x,_n3##y,z,c)), \
 (I[176] = (T)(img)(_p7##x,_n4##y,z,c)), \
 (I[192] = (T)(img)(_p7##x,_n5##y,z,c)), \
 (I[208] = (T)(img)(_p7##x,_n6##y,z,c)), \
 (I[224] = (T)(img)(_p7##x,_n7##y,z,c)), \
 (I[240] = (T)(img)(_p7##x,_n8##y,z,c)), \
 (I[1] = (T)(img)(_p6##x,_p7##y,z,c)), \
 (I[17] = (T)(img)(_p6##x,_p6##y,z,c)), \
 (I[33] = (T)(img)(_p6##x,_p5##y,z,c)), \
 (I[49] = (T)(img)(_p6##x,_p4##y,z,c)), \
 (I[65] = (T)(img)(_p6##x,_p3##y,z,c)), \
 (I[81] = (T)(img)(_p6##x,_p2##y,z,c)), \
 (I[97] = (T)(img)(_p6##x,_p1##y,z,c)), \
 (I[113] = (T)(img)(_p6##x,y,z,c)), \
 (I[129] = (T)(img)(_p6##x,_n1##y,z,c)), \
 (I[145] = (T)(img)(_p6##x,_n2##y,z,c)), \
 (I[161] = (T)(img)(_p6##x,_n3##y,z,c)), \
 (I[177] = (T)(img)(_p6##x,_n4##y,z,c)), \
 (I[193] = (T)(img)(_p6##x,_n5##y,z,c)), \
 (I[209] = (T)(img)(_p6##x,_n6##y,z,c)), \
 (I[225] = (T)(img)(_p6##x,_n7##y,z,c)), \
 (I[241] = (T)(img)(_p6##x,_n8##y,z,c)), \
 (I[2] = (T)(img)(_p5##x,_p7##y,z,c)), \
 (I[18] = (T)(img)(_p5##x,_p6##y,z,c)), \
 (I[34] = (T)(img)(_p5##x,_p5##y,z,c)), \
 (I[50] = (T)(img)(_p5##x,_p4##y,z,c)), \
 (I[66] = (T)(img)(_p5##x,_p3##y,z,c)), \
 (I[82] = (T)(img)(_p5##x,_p2##y,z,c)), \
 (I[98] = (T)(img)(_p5##x,_p1##y,z,c)), \
 (I[114] = (T)(img)(_p5##x,y,z,c)), \
 (I[130] = (T)(img)(_p5##x,_n1##y,z,c)), \
 (I[146] = (T)(img)(_p5##x,_n2##y,z,c)), \
 (I[162] = (T)(img)(_p5##x,_n3##y,z,c)), \
 (I[178] = (T)(img)(_p5##x,_n4##y,z,c)), \
 (I[194] = (T)(img)(_p5##x,_n5##y,z,c)), \
 (I[210] = (T)(img)(_p5##x,_n6##y,z,c)), \
 (I[226] = (T)(img)(_p5##x,_n7##y,z,c)), \
 (I[242] = (T)(img)(_p5##x,_n8##y,z,c)), \
 (I[3] = (T)(img)(_p4##x,_p7##y,z,c)), \
 (I[19] = (T)(img)(_p4##x,_p6##y,z,c)), \
 (I[35] = (T)(img)(_p4##x,_p5##y,z,c)), \
 (I[51] = (T)(img)(_p4##x,_p4##y,z,c)), \
 (I[67] = (T)(img)(_p4##x,_p3##y,z,c)), \
 (I[83] = (T)(img)(_p4##x,_p2##y,z,c)), \
 (I[99] = (T)(img)(_p4##x,_p1##y,z,c)), \
 (I[115] = (T)(img)(_p4##x,y,z,c)), \
 (I[131] = (T)(img)(_p4##x,_n1##y,z,c)), \
 (I[147] = (T)(img)(_p4##x,_n2##y,z,c)), \
 (I[163] = (T)(img)(_p4##x,_n3##y,z,c)), \
 (I[179] = (T)(img)(_p4##x,_n4##y,z,c)), \
 (I[195] = (T)(img)(_p4##x,_n5##y,z,c)), \
 (I[211] = (T)(img)(_p4##x,_n6##y,z,c)), \
 (I[227] = (T)(img)(_p4##x,_n7##y,z,c)), \
 (I[243] = (T)(img)(_p4##x,_n8##y,z,c)), \
 (I[4] = (T)(img)(_p3##x,_p7##y,z,c)), \
 (I[20] = (T)(img)(_p3##x,_p6##y,z,c)), \
 (I[36] = (T)(img)(_p3##x,_p5##y,z,c)), \
 (I[52] = (T)(img)(_p3##x,_p4##y,z,c)), \
 (I[68] = (T)(img)(_p3##x,_p3##y,z,c)), \
 (I[84] = (T)(img)(_p3##x,_p2##y,z,c)), \
 (I[100] = (T)(img)(_p3##x,_p1##y,z,c)), \
 (I[116] = (T)(img)(_p3##x,y,z,c)), \
 (I[132] = (T)(img)(_p3##x,_n1##y,z,c)), \
 (I[148] = (T)(img)(_p3##x,_n2##y,z,c)), \
 (I[164] = (T)(img)(_p3##x,_n3##y,z,c)), \
 (I[180] = (T)(img)(_p3##x,_n4##y,z,c)), \
 (I[196] = (T)(img)(_p3##x,_n5##y,z,c)), \
 (I[212] = (T)(img)(_p3##x,_n6##y,z,c)), \
 (I[228] = (T)(img)(_p3##x,_n7##y,z,c)), \
 (I[244] = (T)(img)(_p3##x,_n8##y,z,c)), \
 (I[5] = (T)(img)(_p2##x,_p7##y,z,c)), \
 (I[21] = (T)(img)(_p2##x,_p6##y,z,c)), \
 (I[37] = (T)(img)(_p2##x,_p5##y,z,c)), \
 (I[53] = (T)(img)(_p2##x,_p4##y,z,c)), \
 (I[69] = (T)(img)(_p2##x,_p3##y,z,c)), \
 (I[85] = (T)(img)(_p2##x,_p2##y,z,c)), \
 (I[101] = (T)(img)(_p2##x,_p1##y,z,c)), \
 (I[117] = (T)(img)(_p2##x,y,z,c)), \
 (I[133] = (T)(img)(_p2##x,_n1##y,z,c)), \
 (I[149] = (T)(img)(_p2##x,_n2##y,z,c)), \
 (I[165] = (T)(img)(_p2##x,_n3##y,z,c)), \
 (I[181] = (T)(img)(_p2##x,_n4##y,z,c)), \
 (I[197] = (T)(img)(_p2##x,_n5##y,z,c)), \
 (I[213] = (T)(img)(_p2##x,_n6##y,z,c)), \
 (I[229] = (T)(img)(_p2##x,_n7##y,z,c)), \
 (I[245] = (T)(img)(_p2##x,_n8##y,z,c)), \
 (I[6] = (T)(img)(_p1##x,_p7##y,z,c)), \
 (I[22] = (T)(img)(_p1##x,_p6##y,z,c)), \
 (I[38] = (T)(img)(_p1##x,_p5##y,z,c)), \
 (I[54] = (T)(img)(_p1##x,_p4##y,z,c)), \
 (I[70] = (T)(img)(_p1##x,_p3##y,z,c)), \
 (I[86] = (T)(img)(_p1##x,_p2##y,z,c)), \
 (I[102] = (T)(img)(_p1##x,_p1##y,z,c)), \
 (I[118] = (T)(img)(_p1##x,y,z,c)), \
 (I[134] = (T)(img)(_p1##x,_n1##y,z,c)), \
 (I[150] = (T)(img)(_p1##x,_n2##y,z,c)), \
 (I[166] = (T)(img)(_p1##x,_n3##y,z,c)), \
 (I[182] = (T)(img)(_p1##x,_n4##y,z,c)), \
 (I[198] = (T)(img)(_p1##x,_n5##y,z,c)), \
 (I[214] = (T)(img)(_p1##x,_n6##y,z,c)), \
 (I[230] = (T)(img)(_p1##x,_n7##y,z,c)), \
 (I[246] = (T)(img)(_p1##x,_n8##y,z,c)), \
 (I[7] = (T)(img)(x,_p7##y,z,c)), \
 (I[23] = (T)(img)(x,_p6##y,z,c)), \
 (I[39] = (T)(img)(x,_p5##y,z,c)), \
 (I[55] = (T)(img)(x,_p4##y,z,c)), \
 (I[71] = (T)(img)(x,_p3##y,z,c)), \
 (I[87] = (T)(img)(x,_p2##y,z,c)), \
 (I[103] = (T)(img)(x,_p1##y,z,c)), \
 (I[119] = (T)(img)(x,y,z,c)), \
 (I[135] = (T)(img)(x,_n1##y,z,c)), \
 (I[151] = (T)(img)(x,_n2##y,z,c)), \
 (I[167] = (T)(img)(x,_n3##y,z,c)), \
 (I[183] = (T)(img)(x,_n4##y,z,c)), \
 (I[199] = (T)(img)(x,_n5##y,z,c)), \
 (I[215] = (T)(img)(x,_n6##y,z,c)), \
 (I[231] = (T)(img)(x,_n7##y,z,c)), \
 (I[247] = (T)(img)(x,_n8##y,z,c)), \
 (I[8] = (T)(img)(_n1##x,_p7##y,z,c)), \
 (I[24] = (T)(img)(_n1##x,_p6##y,z,c)), \
 (I[40] = (T)(img)(_n1##x,_p5##y,z,c)), \
 (I[56] = (T)(img)(_n1##x,_p4##y,z,c)), \
 (I[72] = (T)(img)(_n1##x,_p3##y,z,c)), \
 (I[88] = (T)(img)(_n1##x,_p2##y,z,c)), \
 (I[104] = (T)(img)(_n1##x,_p1##y,z,c)), \
 (I[120] = (T)(img)(_n1##x,y,z,c)), \
 (I[136] = (T)(img)(_n1##x,_n1##y,z,c)), \
 (I[152] = (T)(img)(_n1##x,_n2##y,z,c)), \
 (I[168] = (T)(img)(_n1##x,_n3##y,z,c)), \
 (I[184] = (T)(img)(_n1##x,_n4##y,z,c)), \
 (I[200] = (T)(img)(_n1##x,_n5##y,z,c)), \
 (I[216] = (T)(img)(_n1##x,_n6##y,z,c)), \
 (I[232] = (T)(img)(_n1##x,_n7##y,z,c)), \
 (I[248] = (T)(img)(_n1##x,_n8##y,z,c)), \
 (I[9] = (T)(img)(_n2##x,_p7##y,z,c)), \
 (I[25] = (T)(img)(_n2##x,_p6##y,z,c)), \
 (I[41] = (T)(img)(_n2##x,_p5##y,z,c)), \
 (I[57] = (T)(img)(_n2##x,_p4##y,z,c)), \
 (I[73] = (T)(img)(_n2##x,_p3##y,z,c)), \
 (I[89] = (T)(img)(_n2##x,_p2##y,z,c)), \
 (I[105] = (T)(img)(_n2##x,_p1##y,z,c)), \
 (I[121] = (T)(img)(_n2##x,y,z,c)), \
 (I[137] = (T)(img)(_n2##x,_n1##y,z,c)), \
 (I[153] = (T)(img)(_n2##x,_n2##y,z,c)), \
 (I[169] = (T)(img)(_n2##x,_n3##y,z,c)), \
 (I[185] = (T)(img)(_n2##x,_n4##y,z,c)), \
 (I[201] = (T)(img)(_n2##x,_n5##y,z,c)), \
 (I[217] = (T)(img)(_n2##x,_n6##y,z,c)), \
 (I[233] = (T)(img)(_n2##x,_n7##y,z,c)), \
 (I[249] = (T)(img)(_n2##x,_n8##y,z,c)), \
 (I[10] = (T)(img)(_n3##x,_p7##y,z,c)), \
 (I[26] = (T)(img)(_n3##x,_p6##y,z,c)), \
 (I[42] = (T)(img)(_n3##x,_p5##y,z,c)), \
 (I[58] = (T)(img)(_n3##x,_p4##y,z,c)), \
 (I[74] = (T)(img)(_n3##x,_p3##y,z,c)), \
 (I[90] = (T)(img)(_n3##x,_p2##y,z,c)), \
 (I[106] = (T)(img)(_n3##x,_p1##y,z,c)), \
 (I[122] = (T)(img)(_n3##x,y,z,c)), \
 (I[138] = (T)(img)(_n3##x,_n1##y,z,c)), \
 (I[154] = (T)(img)(_n3##x,_n2##y,z,c)), \
 (I[170] = (T)(img)(_n3##x,_n3##y,z,c)), \
 (I[186] = (T)(img)(_n3##x,_n4##y,z,c)), \
 (I[202] = (T)(img)(_n3##x,_n5##y,z,c)), \
 (I[218] = (T)(img)(_n3##x,_n6##y,z,c)), \
 (I[234] = (T)(img)(_n3##x,_n7##y,z,c)), \
 (I[250] = (T)(img)(_n3##x,_n8##y,z,c)), \
 (I[11] = (T)(img)(_n4##x,_p7##y,z,c)), \
 (I[27] = (T)(img)(_n4##x,_p6##y,z,c)), \
 (I[43] = (T)(img)(_n4##x,_p5##y,z,c)), \
 (I[59] = (T)(img)(_n4##x,_p4##y,z,c)), \
 (I[75] = (T)(img)(_n4##x,_p3##y,z,c)), \
 (I[91] = (T)(img)(_n4##x,_p2##y,z,c)), \
 (I[107] = (T)(img)(_n4##x,_p1##y,z,c)), \
 (I[123] = (T)(img)(_n4##x,y,z,c)), \
 (I[139] = (T)(img)(_n4##x,_n1##y,z,c)), \
 (I[155] = (T)(img)(_n4##x,_n2##y,z,c)), \
 (I[171] = (T)(img)(_n4##x,_n3##y,z,c)), \
 (I[187] = (T)(img)(_n4##x,_n4##y,z,c)), \
 (I[203] = (T)(img)(_n4##x,_n5##y,z,c)), \
 (I[219] = (T)(img)(_n4##x,_n6##y,z,c)), \
 (I[235] = (T)(img)(_n4##x,_n7##y,z,c)), \
 (I[251] = (T)(img)(_n4##x,_n8##y,z,c)), \
 (I[12] = (T)(img)(_n5##x,_p7##y,z,c)), \
 (I[28] = (T)(img)(_n5##x,_p6##y,z,c)), \
 (I[44] = (T)(img)(_n5##x,_p5##y,z,c)), \
 (I[60] = (T)(img)(_n5##x,_p4##y,z,c)), \
 (I[76] = (T)(img)(_n5##x,_p3##y,z,c)), \
 (I[92] = (T)(img)(_n5##x,_p2##y,z,c)), \
 (I[108] = (T)(img)(_n5##x,_p1##y,z,c)), \
 (I[124] = (T)(img)(_n5##x,y,z,c)), \
 (I[140] = (T)(img)(_n5##x,_n1##y,z,c)), \
 (I[156] = (T)(img)(_n5##x,_n2##y,z,c)), \
 (I[172] = (T)(img)(_n5##x,_n3##y,z,c)), \
 (I[188] = (T)(img)(_n5##x,_n4##y,z,c)), \
 (I[204] = (T)(img)(_n5##x,_n5##y,z,c)), \
 (I[220] = (T)(img)(_n5##x,_n6##y,z,c)), \
 (I[236] = (T)(img)(_n5##x,_n7##y,z,c)), \
 (I[252] = (T)(img)(_n5##x,_n8##y,z,c)), \
 (I[13] = (T)(img)(_n6##x,_p7##y,z,c)), \
 (I[29] = (T)(img)(_n6##x,_p6##y,z,c)), \
 (I[45] = (T)(img)(_n6##x,_p5##y,z,c)), \
 (I[61] = (T)(img)(_n6##x,_p4##y,z,c)), \
 (I[77] = (T)(img)(_n6##x,_p3##y,z,c)), \
 (I[93] = (T)(img)(_n6##x,_p2##y,z,c)), \
 (I[109] = (T)(img)(_n6##x,_p1##y,z,c)), \
 (I[125] = (T)(img)(_n6##x,y,z,c)), \
 (I[141] = (T)(img)(_n6##x,_n1##y,z,c)), \
 (I[157] = (T)(img)(_n6##x,_n2##y,z,c)), \
 (I[173] = (T)(img)(_n6##x,_n3##y,z,c)), \
 (I[189] = (T)(img)(_n6##x,_n4##y,z,c)), \
 (I[205] = (T)(img)(_n6##x,_n5##y,z,c)), \
 (I[221] = (T)(img)(_n6##x,_n6##y,z,c)), \
 (I[237] = (T)(img)(_n6##x,_n7##y,z,c)), \
 (I[253] = (T)(img)(_n6##x,_n8##y,z,c)), \
 (I[14] = (T)(img)(_n7##x,_p7##y,z,c)), \
 (I[30] = (T)(img)(_n7##x,_p6##y,z,c)), \
 (I[46] = (T)(img)(_n7##x,_p5##y,z,c)), \
 (I[62] = (T)(img)(_n7##x,_p4##y,z,c)), \
 (I[78] = (T)(img)(_n7##x,_p3##y,z,c)), \
 (I[94] = (T)(img)(_n7##x,_p2##y,z,c)), \
 (I[110] = (T)(img)(_n7##x,_p1##y,z,c)), \
 (I[126] = (T)(img)(_n7##x,y,z,c)), \
 (I[142] = (T)(img)(_n7##x,_n1##y,z,c)), \
 (I[158] = (T)(img)(_n7##x,_n2##y,z,c)), \
 (I[174] = (T)(img)(_n7##x,_n3##y,z,c)), \
 (I[190] = (T)(img)(_n7##x,_n4##y,z,c)), \
 (I[206] = (T)(img)(_n7##x,_n5##y,z,c)), \
 (I[222] = (T)(img)(_n7##x,_n6##y,z,c)), \
 (I[238] = (T)(img)(_n7##x,_n7##y,z,c)), \
 (I[254] = (T)(img)(_n7##x,_n8##y,z,c)), \
 x+8>=(img).width()?(img).width()-1:x+8); \
 x<=(int)(x1) && ((_n8##x<(img).width() && ( \
 (I[15] = (T)(img)(_n8##x,_p7##y,z,c)), \
 (I[31] = (T)(img)(_n8##x,_p6##y,z,c)), \
 (I[47] = (T)(img)(_n8##x,_p5##y,z,c)), \
 (I[63] = (T)(img)(_n8##x,_p4##y,z,c)), \
 (I[79] = (T)(img)(_n8##x,_p3##y,z,c)), \
 (I[95] = (T)(img)(_n8##x,_p2##y,z,c)), \
 (I[111] = (T)(img)(_n8##x,_p1##y,z,c)), \
 (I[127] = (T)(img)(_n8##x,y,z,c)), \
 (I[143] = (T)(img)(_n8##x,_n1##y,z,c)), \
 (I[159] = (T)(img)(_n8##x,_n2##y,z,c)), \
 (I[175] = (T)(img)(_n8##x,_n3##y,z,c)), \
 (I[191] = (T)(img)(_n8##x,_n4##y,z,c)), \
 (I[207] = (T)(img)(_n8##x,_n5##y,z,c)), \
 (I[223] = (T)(img)(_n8##x,_n6##y,z,c)), \
 (I[239] = (T)(img)(_n8##x,_n7##y,z,c)), \
 (I[255] = (T)(img)(_n8##x,_n8##y,z,c)),1)) || \
 _n7##x==--_n8##x || _n6##x==--_n7##x || _n5##x==--_n6##x || _n4##x==--_n5##x || _n3##x==--_n4##x || _n2##x==--_n3##x || _n1##x==--_n2##x || x==(_n8##x = _n7##x = _n6##x = _n5##x = _n4##x = _n3##x = _n2##x = --_n1##x)); \
 I[0] = I[1], I[1] = I[2], I[2] = I[3], I[3] = I[4], I[4] = I[5], I[5] = I[6], I[6] = I[7], I[7] = I[8], I[8] = I[9], I[9] = I[10], I[10] = I[11], I[11] = I[12], I[12] = I[13], I[13] = I[14], I[14] = I[15], \
 I[16] = I[17], I[17] = I[18], I[18] = I[19], I[19] = I[20], I[20] = I[21], I[21] = I[22], I[22] = I[23], I[23] = I[24], I[24] = I[25], I[25] = I[26], I[26] = I[27], I[27] = I[28], I[28] = I[29], I[29] = I[30], I[30] = I[31], \
 I[32] = I[33], I[33] = I[34], I[34] = I[35], I[35] = I[36], I[36] = I[37], I[37] = I[38], I[38] = I[39], I[39] = I[40], I[40] = I[41], I[41] = I[42], I[42] = I[43], I[43] = I[44], I[44] = I[45], I[45] = I[46], I[46] = I[47], \
 I[48] = I[49], I[49] = I[50], I[50] = I[51], I[51] = I[52], I[52] = I[53], I[53] = I[54], I[54] = I[55], I[55] = I[56], I[56] = I[57], I[57] = I[58], I[58] = I[59], I[59] = I[60], I[60] = I[61], I[61] = I[62], I[62] = I[63], \
 I[64] = I[65], I[65] = I[66], I[66] = I[67], I[67] = I[68], I[68] = I[69], I[69] = I[70], I[70] = I[71], I[71] = I[72], I[72] = I[73], I[73] = I[74], I[74] = I[75], I[75] = I[76], I[76] = I[77], I[77] = I[78], I[78] = I[79], \
 I[80] = I[81], I[81] = I[82], I[82] = I[83], I[83] = I[84], I[84] = I[85], I[85] = I[86], I[86] = I[87], I[87] = I[88], I[88] = I[89], I[89] = I[90], I[90] = I[91], I[91] = I[92], I[92] = I[93], I[93] = I[94], I[94] = I[95], \
 I[96] = I[97], I[97] = I[98], I[98] = I[99], I[99] = I[100], I[100] = I[101], I[101] = I[102], I[102] = I[103], I[103] = I[104], I[104] = I[105], I[105] = I[106], I[106] = I[107], I[107] = I[108], I[108] = I[109], I[109] = I[110], I[110] = I[111], \
 I[112] = I[113], I[113] = I[114], I[114] = I[115], I[115] = I[116], I[116] = I[117], I[117] = I[118], I[118] = I[119], I[119] = I[120], I[120] = I[121], I[121] = I[122], I[122] = I[123], I[123] = I[124], I[124] = I[125], I[125] = I[126], I[126] = I[127], \
 I[128] = I[129], I[129] = I[130], I[130] = I[131], I[131] = I[132], I[132] = I[133], I[133] = I[134], I[134] = I[135], I[135] = I[136], I[136] = I[137], I[137] = I[138], I[138] = I[139], I[139] = I[140], I[140] = I[141], I[141] = I[142], I[142] = I[143], \
 I[144] = I[145], I[145] = I[146], I[146] = I[147], I[147] = I[148], I[148] = I[149], I[149] = I[150], I[150] = I[151], I[151] = I[152], I[152] = I[153], I[153] = I[154], I[154] = I[155], I[155] = I[156], I[156] = I[157], I[157] = I[158], I[158] = I[159], \
 I[160] = I[161], I[161] = I[162], I[162] = I[163], I[163] = I[164], I[164] = I[165], I[165] = I[166], I[166] = I[167], I[167] = I[168], I[168] = I[169], I[169] = I[170], I[170] = I[171], I[171] = I[172], I[172] = I[173], I[173] = I[174], I[174] = I[175], \
 I[176] = I[177], I[177] = I[178], I[178] = I[179], I[179] = I[180], I[180] = I[181], I[181] = I[182], I[182] = I[183], I[183] = I[184], I[184] = I[185], I[185] = I[186], I[186] = I[187], I[187] = I[188], I[188] = I[189], I[189] = I[190], I[190] = I[191], \
 I[192] = I[193], I[193] = I[194], I[194] = I[195], I[195] = I[196], I[196] = I[197], I[197] = I[198], I[198] = I[199], I[199] = I[200], I[200] = I[201], I[201] = I[202], I[202] = I[203], I[203] = I[204], I[204] = I[205], I[205] = I[206], I[206] = I[207], \
 I[208] = I[209], I[209] = I[210], I[210] = I[211], I[211] = I[212], I[212] = I[213], I[213] = I[214], I[214] = I[215], I[215] = I[216], I[216] = I[217], I[217] = I[218], I[218] = I[219], I[219] = I[220], I[220] = I[221], I[221] = I[222], I[222] = I[223], \
 I[224] = I[225], I[225] = I[226], I[226] = I[227], I[227] = I[228], I[228] = I[229], I[229] = I[230], I[230] = I[231], I[231] = I[232], I[232] = I[233], I[233] = I[234], I[234] = I[235], I[235] = I[236], I[236] = I[237], I[237] = I[238], I[238] = I[239], \
 I[240] = I[241], I[241] = I[242], I[242] = I[243], I[243] = I[244], I[244] = I[245], I[245] = I[246], I[246] = I[247], I[247] = I[248], I[248] = I[249], I[249] = I[250], I[250] = I[251], I[251] = I[252], I[252] = I[253], I[253] = I[254], I[254] = I[255], \
 _p7##x = _p6##x, _p6##x = _p5##x, _p5##x = _p4##x, _p4##x = _p3##x, _p3##x = _p2##x, _p2##x = _p1##x, _p1##x = x++, ++_n1##x, ++_n2##x, ++_n3##x, ++_n4##x, ++_n5##x, ++_n6##x, ++_n7##x, ++_n8##x)

#define cimg_get16x16(img,x,y,z,c,I,T) \
 I[0] = (T)(img)(_p7##x,_p7##y,z,c), I[1] = (T)(img)(_p6##x,_p7##y,z,c), I[2] = (T)(img)(_p5##x,_p7##y,z,c), I[3] = (T)(img)(_p4##x,_p7##y,z,c), I[4] = (T)(img)(_p3##x,_p7##y,z,c), I[5] = (T)(img)(_p2##x,_p7##y,z,c), I[6] = (T)(img)(_p1##x,_p7##y,z,c), I[7] = (T)(img)(x,_p7##y,z,c), I[8] = (T)(img)(_n1##x,_p7##y,z,c), I[9] = (T)(img)(_n2##x,_p7##y,z,c), I[10] = (T)(img)(_n3##x,_p7##y,z,c), I[11] = (T)(img)(_n4##x,_p7##y,z,c), I[12] = (T)(img)(_n5##x,_p7##y,z,c), I[13] = (T)(img)(_n6##x,_p7##y,z,c), I[14] = (T)(img)(_n7##x,_p7##y,z,c), I[15] = (T)(img)(_n8##x,_p7##y,z,c), \
 I[16] = (T)(img)(_p7##x,_p6##y,z,c), I[17] = (T)(img)(_p6##x,_p6##y,z,c), I[18] = (T)(img)(_p5##x,_p6##y,z,c), I[19] = (T)(img)(_p4##x,_p6##y,z,c), I[20] = (T)(img)(_p3##x,_p6##y,z,c), I[21] = (T)(img)(_p2##x,_p6##y,z,c), I[22] = (T)(img)(_p1##x,_p6##y,z,c), I[23] = (T)(img)(x,_p6##y,z,c), I[24] = (T)(img)(_n1##x,_p6##y,z,c), I[25] = (T)(img)(_n2##x,_p6##y,z,c), I[26] = (T)(img)(_n3##x,_p6##y,z,c), I[27] = (T)(img)(_n4##x,_p6##y,z,c), I[28] = (T)(img)(_n5##x,_p6##y,z,c), I[29] = (T)(img)(_n6##x,_p6##y,z,c), I[30] = (T)(img)(_n7##x,_p6##y,z,c), I[31] = (T)(img)(_n8##x,_p6##y,z,c), \
 I[32] = (T)(img)(_p7##x,_p5##y,z,c), I[33] = (T)(img)(_p6##x,_p5##y,z,c), I[34] = (T)(img)(_p5##x,_p5##y,z,c), I[35] = (T)(img)(_p4##x,_p5##y,z,c), I[36] = (T)(img)(_p3##x,_p5##y,z,c), I[37] = (T)(img)(_p2##x,_p5##y,z,c), I[38] = (T)(img)(_p1##x,_p5##y,z,c), I[39] = (T)(img)(x,_p5##y,z,c), I[40] = (T)(img)(_n1##x,_p5##y,z,c), I[41] = (T)(img)(_n2##x,_p5##y,z,c), I[42] = (T)(img)(_n3##x,_p5##y,z,c), I[43] = (T)(img)(_n4##x,_p5##y,z,c), I[44] = (T)(img)(_n5##x,_p5##y,z,c), I[45] = (T)(img)(_n6##x,_p5##y,z,c), I[46] = (T)(img)(_n7##x,_p5##y,z,c), I[47] = (T)(img)(_n8##x,_p5##y,z,c), \
 I[48] = (T)(img)(_p7##x,_p4##y,z,c), I[49] = (T)(img)(_p6##x,_p4##y,z,c), I[50] = (T)(img)(_p5##x,_p4##y,z,c), I[51] = (T)(img)(_p4##x,_p4##y,z,c), I[52] = (T)(img)(_p3##x,_p4##y,z,c), I[53] = (T)(img)(_p2##x,_p4##y,z,c), I[54] = (T)(img)(_p1##x,_p4##y,z,c), I[55] = (T)(img)(x,_p4##y,z,c), I[56] = (T)(img)(_n1##x,_p4##y,z,c), I[57] = (T)(img)(_n2##x,_p4##y,z,c), I[58] = (T)(img)(_n3##x,_p4##y,z,c), I[59] = (T)(img)(_n4##x,_p4##y,z,c), I[60] = (T)(img)(_n5##x,_p4##y,z,c), I[61] = (T)(img)(_n6##x,_p4##y,z,c), I[62] = (T)(img)(_n7##x,_p4##y,z,c), I[63] = (T)(img)(_n8##x,_p4##y,z,c), \
 I[64] = (T)(img)(_p7##x,_p3##y,z,c), I[65] = (T)(img)(_p6##x,_p3##y,z,c), I[66] = (T)(img)(_p5##x,_p3##y,z,c), I[67] = (T)(img)(_p4##x,_p3##y,z,c), I[68] = (T)(img)(_p3##x,_p3##y,z,c), I[69] = (T)(img)(_p2##x,_p3##y,z,c), I[70] = (T)(img)(_p1##x,_p3##y,z,c), I[71] = (T)(img)(x,_p3##y,z,c), I[72] = (T)(img)(_n1##x,_p3##y,z,c), I[73] = (T)(img)(_n2##x,_p3##y,z,c), I[74] = (T)(img)(_n3##x,_p3##y,z,c), I[75] = (T)(img)(_n4##x,_p3##y,z,c), I[76] = (T)(img)(_n5##x,_p3##y,z,c), I[77] = (T)(img)(_n6##x,_p3##y,z,c), I[78] = (T)(img)(_n7##x,_p3##y,z,c), I[79] = (T)(img)(_n8##x,_p3##y,z,c), \
 I[80] = (T)(img)(_p7##x,_p2##y,z,c), I[81] = (T)(img)(_p6##x,_p2##y,z,c), I[82] = (T)(img)(_p5##x,_p2##y,z,c), I[83] = (T)(img)(_p4##x,_p2##y,z,c), I[84] = (T)(img)(_p3##x,_p2##y,z,c), I[85] = (T)(img)(_p2##x,_p2##y,z,c), I[86] = (T)(img)(_p1##x,_p2##y,z,c), I[87] = (T)(img)(x,_p2##y,z,c), I[88] = (T)(img)(_n1##x,_p2##y,z,c), I[89] = (T)(img)(_n2##x,_p2##y,z,c), I[90] = (T)(img)(_n3##x,_p2##y,z,c), I[91] = (T)(img)(_n4##x,_p2##y,z,c), I[92] = (T)(img)(_n5##x,_p2##y,z,c), I[93] = (T)(img)(_n6##x,_p2##y,z,c), I[94] = (T)(img)(_n7##x,_p2##y,z,c), I[95] = (T)(img)(_n8##x,_p2##y,z,c), \
 I[96] = (T)(img)(_p7##x,_p1##y,z,c), I[97] = (T)(img)(_p6##x,_p1##y,z,c), I[98] = (T)(img)(_p5##x,_p1##y,z,c), I[99] = (T)(img)(_p4##x,_p1##y,z,c), I[100] = (T)(img)(_p3##x,_p1##y,z,c), I[101] = (T)(img)(_p2##x,_p1##y,z,c), I[102] = (T)(img)(_p1##x,_p1##y,z,c), I[103] = (T)(img)(x,_p1##y,z,c), I[104] = (T)(img)(_n1##x,_p1##y,z,c), I[105] = (T)(img)(_n2##x,_p1##y,z,c), I[106] = (T)(img)(_n3##x,_p1##y,z,c), I[107] = (T)(img)(_n4##x,_p1##y,z,c), I[108] = (T)(img)(_n5##x,_p1##y,z,c), I[109] = (T)(img)(_n6##x,_p1##y,z,c), I[110] = (T)(img)(_n7##x,_p1##y,z,c), I[111] = (T)(img)(_n8##x,_p1##y,z,c), \
 I[112] = (T)(img)(_p7##x,y,z,c), I[113] = (T)(img)(_p6##x,y,z,c), I[114] = (T)(img)(_p5##x,y,z,c), I[115] = (T)(img)(_p4##x,y,z,c), I[116] = (T)(img)(_p3##x,y,z,c), I[117] = (T)(img)(_p2##x,y,z,c), I[118] = (T)(img)(_p1##x,y,z,c), I[119] = (T)(img)(x,y,z,c), I[120] = (T)(img)(_n1##x,y,z,c), I[121] = (T)(img)(_n2##x,y,z,c), I[122] = (T)(img)(_n3##x,y,z,c), I[123] = (T)(img)(_n4##x,y,z,c), I[124] = (T)(img)(_n5##x,y,z,c), I[125] = (T)(img)(_n6##x,y,z,c), I[126] = (T)(img)(_n7##x,y,z,c), I[127] = (T)(img)(_n8##x,y,z,c), \
 I[128] = (T)(img)(_p7##x,_n1##y,z,c), I[129] = (T)(img)(_p6##x,_n1##y,z,c), I[130] = (T)(img)(_p5##x,_n1##y,z,c), I[131] = (T)(img)(_p4##x,_n1##y,z,c), I[132] = (T)(img)(_p3##x,_n1##y,z,c), I[133] = (T)(img)(_p2##x,_n1##y,z,c), I[134] = (T)(img)(_p1##x,_n1##y,z,c), I[135] = (T)(img)(x,_n1##y,z,c), I[136] = (T)(img)(_n1##x,_n1##y,z,c), I[137] = (T)(img)(_n2##x,_n1##y,z,c), I[138] = (T)(img)(_n3##x,_n1##y,z,c), I[139] = (T)(img)(_n4##x,_n1##y,z,c), I[140] = (T)(img)(_n5##x,_n1##y,z,c), I[141] = (T)(img)(_n6##x,_n1##y,z,c), I[142] = (T)(img)(_n7##x,_n1##y,z,c), I[143] = (T)(img)(_n8##x,_n1##y,z,c), \
 I[144] = (T)(img)(_p7##x,_n2##y,z,c), I[145] = (T)(img)(_p6##x,_n2##y,z,c), I[146] = (T)(img)(_p5##x,_n2##y,z,c), I[147] = (T)(img)(_p4##x,_n2##y,z,c), I[148] = (T)(img)(_p3##x,_n2##y,z,c), I[149] = (T)(img)(_p2##x,_n2##y,z,c), I[150] = (T)(img)(_p1##x,_n2##y,z,c), I[151] = (T)(img)(x,_n2##y,z,c), I[152] = (T)(img)(_n1##x,_n2##y,z,c), I[153] = (T)(img)(_n2##x,_n2##y,z,c), I[154] = (T)(img)(_n3##x,_n2##y,z,c), I[155] = (T)(img)(_n4##x,_n2##y,z,c), I[156] = (T)(img)(_n5##x,_n2##y,z,c), I[157] = (T)(img)(_n6##x,_n2##y,z,c), I[158] = (T)(img)(_n7##x,_n2##y,z,c), I[159] = (T)(img)(_n8##x,_n2##y,z,c), \
 I[160] = (T)(img)(_p7##x,_n3##y,z,c), I[161] = (T)(img)(_p6##x,_n3##y,z,c), I[162] = (T)(img)(_p5##x,_n3##y,z,c), I[163] = (T)(img)(_p4##x,_n3##y,z,c), I[164] = (T)(img)(_p3##x,_n3##y,z,c), I[165] = (T)(img)(_p2##x,_n3##y,z,c), I[166] = (T)(img)(_p1##x,_n3##y,z,c), I[167] = (T)(img)(x,_n3##y,z,c), I[168] = (T)(img)(_n1##x,_n3##y,z,c), I[169] = (T)(img)(_n2##x,_n3##y,z,c), I[170] = (T)(img)(_n3##x,_n3##y,z,c), I[171] = (T)(img)(_n4##x,_n3##y,z,c), I[172] = (T)(img)(_n5##x,_n3##y,z,c), I[173] = (T)(img)(_n6##x,_n3##y,z,c), I[174] = (T)(img)(_n7##x,_n3##y,z,c), I[175] = (T)(img)(_n8##x,_n3##y,z,c), \
 I[176] = (T)(img)(_p7##x,_n4##y,z,c), I[177] = (T)(img)(_p6##x,_n4##y,z,c), I[178] = (T)(img)(_p5##x,_n4##y,z,c), I[179] = (T)(img)(_p4##x,_n4##y,z,c), I[180] = (T)(img)(_p3##x,_n4##y,z,c), I[181] = (T)(img)(_p2##x,_n4##y,z,c), I[182] = (T)(img)(_p1##x,_n4##y,z,c), I[183] = (T)(img)(x,_n4##y,z,c), I[184] = (T)(img)(_n1##x,_n4##y,z,c), I[185] = (T)(img)(_n2##x,_n4##y,z,c), I[186] = (T)(img)(_n3##x,_n4##y,z,c), I[187] = (T)(img)(_n4##x,_n4##y,z,c), I[188] = (T)(img)(_n5##x,_n4##y,z,c), I[189] = (T)(img)(_n6##x,_n4##y,z,c), I[190] = (T)(img)(_n7##x,_n4##y,z,c), I[191] = (T)(img)(_n8##x,_n4##y,z,c), \
 I[192] = (T)(img)(_p7##x,_n5##y,z,c), I[193] = (T)(img)(_p6##x,_n5##y,z,c), I[194] = (T)(img)(_p5##x,_n5##y,z,c), I[195] = (T)(img)(_p4##x,_n5##y,z,c), I[196] = (T)(img)(_p3##x,_n5##y,z,c), I[197] = (T)(img)(_p2##x,_n5##y,z,c), I[198] = (T)(img)(_p1##x,_n5##y,z,c), I[199] = (T)(img)(x,_n5##y,z,c), I[200] = (T)(img)(_n1##x,_n5##y,z,c), I[201] = (T)(img)(_n2##x,_n5##y,z,c), I[202] = (T)(img)(_n3##x,_n5##y,z,c), I[203] = (T)(img)(_n4##x,_n5##y,z,c), I[204] = (T)(img)(_n5##x,_n5##y,z,c), I[205] = (T)(img)(_n6##x,_n5##y,z,c), I[206] = (T)(img)(_n7##x,_n5##y,z,c), I[207] = (T)(img)(_n8##x,_n5##y,z,c), \
 I[208] = (T)(img)(_p7##x,_n6##y,z,c), I[209] = (T)(img)(_p6##x,_n6##y,z,c), I[210] = (T)(img)(_p5##x,_n6##y,z,c), I[211] = (T)(img)(_p4##x,_n6##y,z,c), I[212] = (T)(img)(_p3##x,_n6##y,z,c), I[213] = (T)(img)(_p2##x,_n6##y,z,c), I[214] = (T)(img)(_p1##x,_n6##y,z,c), I[215] = (T)(img)(x,_n6##y,z,c), I[216] = (T)(img)(_n1##x,_n6##y,z,c), I[217] = (T)(img)(_n2##x,_n6##y,z,c), I[218] = (T)(img)(_n3##x,_n6##y,z,c), I[219] = (T)(img)(_n4##x,_n6##y,z,c), I[220] = (T)(img)(_n5##x,_n6##y,z,c), I[221] = (T)(img)(_n6##x,_n6##y,z,c), I[222] = (T)(img)(_n7##x,_n6##y,z,c), I[223] = (T)(img)(_n8##x,_n6##y,z,c), \
 I[224] = (T)(img)(_p7##x,_n7##y,z,c), I[225] = (T)(img)(_p6##x,_n7##y,z,c), I[226] = (T)(img)(_p5##x,_n7##y,z,c), I[227] = (T)(img)(_p4##x,_n7##y,z,c), I[228] = (T)(img)(_p3##x,_n7##y,z,c), I[229] = (T)(img)(_p2##x,_n7##y,z,c), I[230] = (T)(img)(_p1##x,_n7##y,z,c), I[231] = (T)(img)(x,_n7##y,z,c), I[232] = (T)(img)(_n1##x,_n7##y,z,c), I[233] = (T)(img)(_n2##x,_n7##y,z,c), I[234] = (T)(img)(_n3##x,_n7##y,z,c), I[235] = (T)(img)(_n4##x,_n7##y,z,c), I[236] = (T)(img)(_n5##x,_n7##y,z,c), I[237] = (T)(img)(_n6##x,_n7##y,z,c), I[238] = (T)(img)(_n7##x,_n7##y,z,c), I[239] = (T)(img)(_n8##x,_n7##y,z,c), \
 I[240] = (T)(img)(_p7##x,_n8##y,z,c), I[241] = (T)(img)(_p6##x,_n8##y,z,c), I[242] = (T)(img)(_p5##x,_n8##y,z,c), I[243] = (T)(img)(_p4##x,_n8##y,z,c), I[244] = (T)(img)(_p3##x,_n8##y,z,c), I[245] = (T)(img)(_p2##x,_n8##y,z,c), I[246] = (T)(img)(_p1##x,_n8##y,z,c), I[247] = (T)(img)(x,_n8##y,z,c), I[248] = (T)(img)(_n1##x,_n8##y,z,c), I[249] = (T)(img)(_n2##x,_n8##y,z,c), I[250] = (T)(img)(_n3##x,_n8##y,z,c), I[251] = (T)(img)(_n4##x,_n8##y,z,c), I[252] = (T)(img)(_n5##x,_n8##y,z,c), I[253] = (T)(img)(_n6##x,_n8##y,z,c), I[254] = (T)(img)(_n7##x,_n8##y,z,c), I[255] = (T)(img)(_n8##x,_n8##y,z,c);

// Define 17x17 loop macros
//-------------------------
#define cimg_for17(bound,i) for (int i = 0, \
 _p8##i = 0, _p7##i = 0, _p6##i = 0, _p5##i = 0, _p4##i = 0, _p3##i = 0, _p2##i = 0, _p1##i = 0, \
 _n1##i = 1>=(int)(bound)?(int)(bound)-1:1, \
 _n2##i = 2>=(int)(bound)?(int)(bound)-1:2, \
 _n3##i = 3>=(int)(bound)?(int)(bound)-1:3, \
 _n4##i = 4>=(int)(bound)?(int)(bound)-1:4, \
 _n5##i = 5>=(int)(bound)?(int)(bound)-1:5, \
 _n6##i = 6>=(int)(bound)?(int)(bound)-1:6, \
 _n7##i = 7>=(int)(bound)?(int)(bound)-1:7, \
 _n8##i = 8>=(int)(bound)?(int)(bound)-1:8; \
 _n8##i<(int)(bound) || _n7##i==--_n8##i || _n6##i==--_n7##i || _n5##i==--_n6##i || _n4##i==--_n5##i || _n3##i==--_n4##i || _n2##i==--_n3##i || _n1##i==--_n2##i || \
 i==(_n8##i = _n7##i = _n6##i = _n5##i = _n4##i = _n3##i = _n2##i = --_n1##i); \
 _p8##i = _p7##i, _p7##i = _p6##i, _p6##i = _p5##i, _p5##i = _p4##i, _p4##i = _p3##i, _p3##i = _p2##i, _p2##i = _p1##i, _p1##i = i++, \
 ++_n1##i, ++_n2##i, ++_n3##i, ++_n4##i, ++_n5##i, ++_n6##i, ++_n7##i, ++_n8##i)

#define cimg_for17X(img,x) cimg_for17((img)._width,x)
#define cimg_for17Y(img,y) cimg_for17((img)._height,y)
#define cimg_for17Z(img,z) cimg_for17((img)._depth,z)
#define cimg_for17C(img,c) cimg_for17((img)._spectrum,c)
#define cimg_for17XY(img,x,y) cimg_for17Y(img,y) cimg_for17X(img,x)
#define cimg_for17XZ(img,x,z) cimg_for17Z(img,z) cimg_for17X(img,x)
#define cimg_for17XC(img,x,c) cimg_for17C(img,c) cimg_for17X(img,x)
#define cimg_for17YZ(img,y,z) cimg_for17Z(img,z) cimg_for17Y(img,y)
#define cimg_for17YC(img,y,c) cimg_for17C(img,c) cimg_for17Y(img,y)
#define cimg_for17ZC(img,z,c) cimg_for17C(img,c) cimg_for17Z(img,z)
#define cimg_for17XYZ(img,x,y,z) cimg_for17Z(img,z) cimg_for17XY(img,x,y)
#define cimg_for17XZC(img,x,z,c) cimg_for17C(img,c) cimg_for17XZ(img,x,z)
#define cimg_for17YZC(img,y,z,c) cimg_for17C(img,c) cimg_for17YZ(img,y,z)
#define cimg_for17XYZC(img,x,y,z,c) cimg_for17C(img,c) cimg_for17XYZ(img,x,y,z)

#define cimg_for_in17(bound,i0,i1,i) for (int i = (int)(i0)<0?0:(int)(i0), \
 _p8##i = i-8<0?0:i-8, \
 _p7##i = i-7<0?0:i-7, \
 _p6##i = i-6<0?0:i-6, \
 _p5##i = i-5<0?0:i-5, \
 _p4##i = i-4<0?0:i-4, \
 _p3##i = i-3<0?0:i-3, \
 _p2##i = i-2<0?0:i-2, \
 _p1##i = i-1<0?0:i-1, \
 _n1##i = i+1>=(int)(bound)?(int)(bound)-1:i+1, \
 _n2##i = i+2>=(int)(bound)?(int)(bound)-1:i+2, \
 _n3##i = i+3>=(int)(bound)?(int)(bound)-1:i+3, \
 _n4##i = i+4>=(int)(bound)?(int)(bound)-1:i+4, \
 _n5##i = i+5>=(int)(bound)?(int)(bound)-1:i+5, \
 _n6##i = i+6>=(int)(bound)?(int)(bound)-1:i+6, \
 _n7##i = i+7>=(int)(bound)?(int)(bound)-1:i+7, \
 _n8##i = i+8>=(int)(bound)?(int)(bound)-1:i+8; \
 i<=(int)(i1) && (_n8##i<(int)(bound) || _n7##i==--_n8##i || _n6##i==--_n7##i || _n5##i==--_n6##i || _n4##i==--_n5##i || _n3##i==--_n4##i || _n2##i==--_n3##i || _n1##i==--_n2##i || \
 i==(_n8##i = _n7##i = _n6##i = _n5##i = _n4##i = _n3##i = _n2##i = --_n1##i)); \
 _p8##i = _p7##i, _p7##i = _p6##i, _p6##i = _p5##i, _p5##i = _p4##i, _p4##i = _p3##i, _p3##i = _p2##i, _p2##i = _p1##i, _p1##i = i++, \
 ++_n1##i, ++_n2##i, ++_n3##i, ++_n4##i, ++_n5##i, ++_n6##i, ++_n7##i, ++_n8##i)

#define cimg_for_in17X(img,x0,x1,x) cimg_for_in17((img)._width,x0,x1,x)
#define cimg_for_in17Y(img,y0,y1,y) cimg_for_in17((img)._height,y0,y1,y)
#define cimg_for_in17Z(img,z0,z1,z) cimg_for_in17((img)._depth,z0,z1,z)
#define cimg_for_in17C(img,c0,c1,c) cimg_for_in17((img)._spectrum,c0,c1,c)
#define cimg_for_in17XY(img,x0,y0,x1,y1,x,y) cimg_for_in17Y(img,y0,y1,y) cimg_for_in17X(img,x0,x1,x)
#define cimg_for_in17XZ(img,x0,z0,x1,z1,x,z) cimg_for_in17Z(img,z0,z1,z) cimg_for_in17X(img,x0,x1,x)
#define cimg_for_in17XC(img,x0,c0,x1,c1,x,c) cimg_for_in17C(img,c0,c1,c) cimg_for_in17X(img,x0,x1,x)
#define cimg_for_in17YZ(img,y0,z0,y1,z1,y,z) cimg_for_in17Z(img,z0,z1,z) cimg_for_in17Y(img,y0,y1,y)
#define cimg_for_in17YC(img,y0,c0,y1,c1,y,c) cimg_for_in17C(img,c0,c1,c) cimg_for_in17Y(img,y0,y1,y)
#define cimg_for_in17ZC(img,z0,c0,z1,c1,z,c) cimg_for_in17C(img,c0,c1,c) cimg_for_in17Z(img,z0,z1,z)
#define cimg_for_in17XYZ(img,x0,y0,z0,x1,y1,z1,x,y,z) cimg_for_in17Z(img,z0,z1,z) cimg_for_in17XY(img,x0,y0,x1,y1,x,y)
#define cimg_for_in17XZC(img,x0,z0,c0,x1,y1,c1,x,z,c) cimg_for_in17C(img,c0,c1,c) cimg_for_in17XZ(img,x0,y0,x1,y1,x,z)
#define cimg_for_in17YZC(img,y0,z0,c0,y1,z1,c1,y,z,c) cimg_for_in17C(img,c0,c1,c) cimg_for_in17YZ(img,y0,z0,y1,z1,y,z)
#define cimg_for_in17XYZC(img,x0,y0,z0,c0,x1,y1,z1,c1,x,y,z,c) cimg_for_in17C(img,c0,c1,c) cimg_for_in17XYZ(img,x0,y0,z0,x1,y1,z1,x,y,z)

#define cimg_for17x17(img,x,y,z,c,I,T) \
 cimg_for17((img)._height,y) for (int x = 0, \
 _p8##x = 0, _p7##x = 0, _p6##x = 0, _p5##x = 0, _p4##x = 0, _p3##x = 0, _p2##x = 0, _p1##x = 0, \
 _n1##x = 1>=((img)._width)?(img).width()-1:1, \
 _n2##x = 2>=((img)._width)?(img).width()-1:2, \
 _n3##x = 3>=((img)._width)?(img).width()-1:3, \
 _n4##x = 4>=((img)._width)?(img).width()-1:4, \
 _n5##x = 5>=((img)._width)?(img).width()-1:5, \
 _n6##x = 6>=((img)._width)?(img).width()-1:6, \
 _n7##x = 7>=((img)._width)?(img).width()-1:7, \
 _n8##x = (int)( \
 (I[0] = I[1] = I[2] = I[3] = I[4] = I[5] = I[6] = I[7] = I[8] = (T)(img)(0,_p8##y,z,c)), \
 (I[17] = I[18] = I[19] = I[20] = I[21] = I[22] = I[23] = I[24] = I[25] = (T)(img)(0,_p7##y,z,c)), \
 (I[34] = I[35] = I[36] = I[37] = I[38] = I[39] = I[40] = I[41] = I[42] = (T)(img)(0,_p6##y,z,c)), \
 (I[51] = I[52] = I[53] = I[54] = I[55] = I[56] = I[57] = I[58] = I[59] = (T)(img)(0,_p5##y,z,c)), \
 (I[68] = I[69] = I[70] = I[71] = I[72] = I[73] = I[74] = I[75] = I[76] = (T)(img)(0,_p4##y,z,c)), \
 (I[85] = I[86] = I[87] = I[88] = I[89] = I[90] = I[91] = I[92] = I[93] = (T)(img)(0,_p3##y,z,c)), \
 (I[102] = I[103] = I[104] = I[105] = I[106] = I[107] = I[108] = I[109] = I[110] = (T)(img)(0,_p2##y,z,c)), \
 (I[119] = I[120] = I[121] = I[122] = I[123] = I[124] = I[125] = I[126] = I[127] = (T)(img)(0,_p1##y,z,c)), \
 (I[136] = I[137] = I[138] = I[139] = I[140] = I[141] = I[142] = I[143] = I[144] = (T)(img)(0,y,z,c)), \
 (I[153] = I[154] = I[155] = I[156] = I[157] = I[158] = I[159] = I[160] = I[161] = (T)(img)(0,_n1##y,z,c)), \
 (I[170] = I[171] = I[172] = I[173] = I[174] = I[175] = I[176] = I[177] = I[178] = (T)(img)(0,_n2##y,z,c)), \
 (I[187] = I[188] = I[189] = I[190] = I[191] = I[192] = I[193] = I[194] = I[195] = (T)(img)(0,_n3##y,z,c)), \
 (I[204] = I[205] = I[206] = I[207] = I[208] = I[209] = I[210] = I[211] = I[212] = (T)(img)(0,_n4##y,z,c)), \
 (I[221] = I[222] = I[223] = I[224] = I[225] = I[226] = I[227] = I[228] = I[229] = (T)(img)(0,_n5##y,z,c)), \
 (I[238] = I[239] = I[240] = I[241] = I[242] = I[243] = I[244] = I[245] = I[246] = (T)(img)(0,_n6##y,z,c)), \
 (I[255] = I[256] = I[257] = I[258] = I[259] = I[260] = I[261] = I[262] = I[263] = (T)(img)(0,_n7##y,z,c)), \
 (I[272] = I[273] = I[274] = I[275] = I[276] = I[277] = I[278] = I[279] = I[280] = (T)(img)(0,_n8##y,z,c)), \
 (I[9] = (T)(img)(_n1##x,_p8##y,z,c)), \
 (I[26] = (T)(img)(_n1##x,_p7##y,z,c)), \
 (I[43] = (T)(img)(_n1##x,_p6##y,z,c)), \
 (I[60] = (T)(img)(_n1##x,_p5##y,z,c)), \
 (I[77] = (T)(img)(_n1##x,_p4##y,z,c)), \
 (I[94] = (T)(img)(_n1##x,_p3##y,z,c)), \
 (I[111] = (T)(img)(_n1##x,_p2##y,z,c)), \
 (I[128] = (T)(img)(_n1##x,_p1##y,z,c)), \
 (I[145] = (T)(img)(_n1##x,y,z,c)), \
 (I[162] = (T)(img)(_n1##x,_n1##y,z,c)), \
 (I[179] = (T)(img)(_n1##x,_n2##y,z,c)), \
 (I[196] = (T)(img)(_n1##x,_n3##y,z,c)), \
 (I[213] = (T)(img)(_n1##x,_n4##y,z,c)), \
 (I[230] = (T)(img)(_n1##x,_n5##y,z,c)), \
 (I[247] = (T)(img)(_n1##x,_n6##y,z,c)), \
 (I[264] = (T)(img)(_n1##x,_n7##y,z,c)), \
 (I[281] = (T)(img)(_n1##x,_n8##y,z,c)), \
 (I[10] = (T)(img)(_n2##x,_p8##y,z,c)), \
 (I[27] = (T)(img)(_n2##x,_p7##y,z,c)), \
 (I[44] = (T)(img)(_n2##x,_p6##y,z,c)), \
 (I[61] = (T)(img)(_n2##x,_p5##y,z,c)), \
 (I[78] = (T)(img)(_n2##x,_p4##y,z,c)), \
 (I[95] = (T)(img)(_n2##x,_p3##y,z,c)), \
 (I[112] = (T)(img)(_n2##x,_p2##y,z,c)), \
 (I[129] = (T)(img)(_n2##x,_p1##y,z,c)), \
 (I[146] = (T)(img)(_n2##x,y,z,c)), \
 (I[163] = (T)(img)(_n2##x,_n1##y,z,c)), \
 (I[180] = (T)(img)(_n2##x,_n2##y,z,c)), \
 (I[197] = (T)(img)(_n2##x,_n3##y,z,c)), \
 (I[214] = (T)(img)(_n2##x,_n4##y,z,c)), \
 (I[231] = (T)(img)(_n2##x,_n5##y,z,c)), \
 (I[248] = (T)(img)(_n2##x,_n6##y,z,c)), \
 (I[265] = (T)(img)(_n2##x,_n7##y,z,c)), \
 (I[282] = (T)(img)(_n2##x,_n8##y,z,c)), \
 (I[11] = (T)(img)(_n3##x,_p8##y,z,c)), \
 (I[28] = (T)(img)(_n3##x,_p7##y,z,c)), \
 (I[45] = (T)(img)(_n3##x,_p6##y,z,c)), \
 (I[62] = (T)(img)(_n3##x,_p5##y,z,c)), \
 (I[79] = (T)(img)(_n3##x,_p4##y,z,c)), \
 (I[96] = (T)(img)(_n3##x,_p3##y,z,c)), \
 (I[113] = (T)(img)(_n3##x,_p2##y,z,c)), \
 (I[130] = (T)(img)(_n3##x,_p1##y,z,c)), \
 (I[147] = (T)(img)(_n3##x,y,z,c)), \
 (I[164] = (T)(img)(_n3##x,_n1##y,z,c)), \
 (I[181] = (T)(img)(_n3##x,_n2##y,z,c)), \
 (I[198] = (T)(img)(_n3##x,_n3##y,z,c)), \
 (I[215] = (T)(img)(_n3##x,_n4##y,z,c)), \
 (I[232] = (T)(img)(_n3##x,_n5##y,z,c)), \
 (I[249] = (T)(img)(_n3##x,_n6##y,z,c)), \
 (I[266] = (T)(img)(_n3##x,_n7##y,z,c)), \
 (I[283] = (T)(img)(_n3##x,_n8##y,z,c)), \
 (I[12] = (T)(img)(_n4##x,_p8##y,z,c)), \
 (I[29] = (T)(img)(_n4##x,_p7##y,z,c)), \
 (I[46] = (T)(img)(_n4##x,_p6##y,z,c)), \
 (I[63] = (T)(img)(_n4##x,_p5##y,z,c)), \
 (I[80] = (T)(img)(_n4##x,_p4##y,z,c)), \
 (I[97] = (T)(img)(_n4##x,_p3##y,z,c)), \
 (I[114] = (T)(img)(_n4##x,_p2##y,z,c)), \
 (I[131] = (T)(img)(_n4##x,_p1##y,z,c)), \
 (I[148] = (T)(img)(_n4##x,y,z,c)), \
 (I[165] = (T)(img)(_n4##x,_n1##y,z,c)), \
 (I[182] = (T)(img)(_n4##x,_n2##y,z,c)), \
 (I[199] = (T)(img)(_n4##x,_n3##y,z,c)), \
 (I[216] = (T)(img)(_n4##x,_n4##y,z,c)), \
 (I[233] = (T)(img)(_n4##x,_n5##y,z,c)), \
 (I[250] = (T)(img)(_n4##x,_n6##y,z,c)), \
 (I[267] = (T)(img)(_n4##x,_n7##y,z,c)), \
 (I[284] = (T)(img)(_n4##x,_n8##y,z,c)), \
 (I[13] = (T)(img)(_n5##x,_p8##y,z,c)), \
 (I[30] = (T)(img)(_n5##x,_p7##y,z,c)), \
 (I[47] = (T)(img)(_n5##x,_p6##y,z,c)), \
 (I[64] = (T)(img)(_n5##x,_p5##y,z,c)), \
 (I[81] = (T)(img)(_n5##x,_p4##y,z,c)), \
 (I[98] = (T)(img)(_n5##x,_p3##y,z,c)), \
 (I[115] = (T)(img)(_n5##x,_p2##y,z,c)), \
 (I[132] = (T)(img)(_n5##x,_p1##y,z,c)), \
 (I[149] = (T)(img)(_n5##x,y,z,c)), \
 (I[166] = (T)(img)(_n5##x,_n1##y,z,c)), \
 (I[183] = (T)(img)(_n5##x,_n2##y,z,c)), \
 (I[200] = (T)(img)(_n5##x,_n3##y,z,c)), \
 (I[217] = (T)(img)(_n5##x,_n4##y,z,c)), \
 (I[234] = (T)(img)(_n5##x,_n5##y,z,c)), \
 (I[251] = (T)(img)(_n5##x,_n6##y,z,c)), \
 (I[268] = (T)(img)(_n5##x,_n7##y,z,c)), \
 (I[285] = (T)(img)(_n5##x,_n8##y,z,c)), \
 (I[14] = (T)(img)(_n6##x,_p8##y,z,c)), \
 (I[31] = (T)(img)(_n6##x,_p7##y,z,c)), \
 (I[48] = (T)(img)(_n6##x,_p6##y,z,c)), \
 (I[65] = (T)(img)(_n6##x,_p5##y,z,c)), \
 (I[82] = (T)(img)(_n6##x,_p4##y,z,c)), \
 (I[99] = (T)(img)(_n6##x,_p3##y,z,c)), \
 (I[116] = (T)(img)(_n6##x,_p2##y,z,c)), \
 (I[133] = (T)(img)(_n6##x,_p1##y,z,c)), \
 (I[150] = (T)(img)(_n6##x,y,z,c)), \
 (I[167] = (T)(img)(_n6##x,_n1##y,z,c)), \
 (I[184] = (T)(img)(_n6##x,_n2##y,z,c)), \
 (I[201] = (T)(img)(_n6##x,_n3##y,z,c)), \
 (I[218] = (T)(img)(_n6##x,_n4##y,z,c)), \
 (I[235] = (T)(img)(_n6##x,_n5##y,z,c)), \
 (I[252] = (T)(img)(_n6##x,_n6##y,z,c)), \
 (I[269] = (T)(img)(_n6##x,_n7##y,z,c)), \
 (I[286] = (T)(img)(_n6##x,_n8##y,z,c)), \
 (I[15] = (T)(img)(_n7##x,_p8##y,z,c)), \
 (I[32] = (T)(img)(_n7##x,_p7##y,z,c)), \
 (I[49] = (T)(img)(_n7##x,_p6##y,z,c)), \
 (I[66] = (T)(img)(_n7##x,_p5##y,z,c)), \
 (I[83] = (T)(img)(_n7##x,_p4##y,z,c)), \
 (I[100] = (T)(img)(_n7##x,_p3##y,z,c)), \
 (I[117] = (T)(img)(_n7##x,_p2##y,z,c)), \
 (I[134] = (T)(img)(_n7##x,_p1##y,z,c)), \
 (I[151] = (T)(img)(_n7##x,y,z,c)), \
 (I[168] = (T)(img)(_n7##x,_n1##y,z,c)), \
 (I[185] = (T)(img)(_n7##x,_n2##y,z,c)), \
 (I[202] = (T)(img)(_n7##x,_n3##y,z,c)), \
 (I[219] = (T)(img)(_n7##x,_n4##y,z,c)), \
 (I[236] = (T)(img)(_n7##x,_n5##y,z,c)), \
 (I[253] = (T)(img)(_n7##x,_n6##y,z,c)), \
 (I[270] = (T)(img)(_n7##x,_n7##y,z,c)), \
 (I[287] = (T)(img)(_n7##x,_n8##y,z,c)), \
 8>=((img)._width)?(img).width()-1:8); \
 (_n8##x<(img).width() && ( \
 (I[16] = (T)(img)(_n8##x,_p8##y,z,c)), \
 (I[33] = (T)(img)(_n8##x,_p7##y,z,c)), \
 (I[50] = (T)(img)(_n8##x,_p6##y,z,c)), \
 (I[67] = (T)(img)(_n8##x,_p5##y,z,c)), \
 (I[84] = (T)(img)(_n8##x,_p4##y,z,c)), \
 (I[101] = (T)(img)(_n8##x,_p3##y,z,c)), \
 (I[118] = (T)(img)(_n8##x,_p2##y,z,c)), \
 (I[135] = (T)(img)(_n8##x,_p1##y,z,c)), \
 (I[152] = (T)(img)(_n8##x,y,z,c)), \
 (I[169] = (T)(img)(_n8##x,_n1##y,z,c)), \
 (I[186] = (T)(img)(_n8##x,_n2##y,z,c)), \
 (I[203] = (T)(img)(_n8##x,_n3##y,z,c)), \
 (I[220] = (T)(img)(_n8##x,_n4##y,z,c)), \
 (I[237] = (T)(img)(_n8##x,_n5##y,z,c)), \
 (I[254] = (T)(img)(_n8##x,_n6##y,z,c)), \
 (I[271] = (T)(img)(_n8##x,_n7##y,z,c)), \
 (I[288] = (T)(img)(_n8##x,_n8##y,z,c)),1)) || \
 _n7##x==--_n8##x || _n6##x==--_n7##x || _n5##x==--_n6##x || _n4##x==--_n5##x || _n3##x==--_n4##x || _n2##x==--_n3##x || _n1##x==--_n2##x || x==(_n8##x = _n7##x = _n6##x = _n5##x = _n4##x = _n3##x = _n2##x = --_n1##x); \
 I[0] = I[1], I[1] = I[2], I[2] = I[3], I[3] = I[4], I[4] = I[5], I[5] = I[6], I[6] = I[7], I[7] = I[8], I[8] = I[9], I[9] = I[10], I[10] = I[11], I[11] = I[12], I[12] = I[13], I[13] = I[14], I[14] = I[15], I[15] = I[16], \
 I[17] = I[18], I[18] = I[19], I[19] = I[20], I[20] = I[21], I[21] = I[22], I[22] = I[23], I[23] = I[24], I[24] = I[25], I[25] = I[26], I[26] = I[27], I[27] = I[28], I[28] = I[29], I[29] = I[30], I[30] = I[31], I[31] = I[32], I[32] = I[33], \
 I[34] = I[35], I[35] = I[36], I[36] = I[37], I[37] = I[38], I[38] = I[39], I[39] = I[40], I[40] = I[41], I[41] = I[42], I[42] = I[43], I[43] = I[44], I[44] = I[45], I[45] = I[46], I[46] = I[47], I[47] = I[48], I[48] = I[49], I[49] = I[50], \
 I[51] = I[52], I[52] = I[53], I[53] = I[54], I[54] = I[55], I[55] = I[56], I[56] = I[57], I[57] = I[58], I[58] = I[59], I[59] = I[60], I[60] = I[61], I[61] = I[62], I[62] = I[63], I[63] = I[64], I[64] = I[65], I[65] = I[66], I[66] = I[67], \
 I[68] = I[69], I[69] = I[70], I[70] = I[71], I[71] = I[72], I[72] = I[73], I[73] = I[74], I[74] = I[75], I[75] = I[76], I[76] = I[77], I[77] = I[78], I[78] = I[79], I[79] = I[80], I[80] = I[81], I[81] = I[82], I[82] = I[83], I[83] = I[84], \
 I[85] = I[86], I[86] = I[87], I[87] = I[88], I[88] = I[89], I[89] = I[90], I[90] = I[91], I[91] = I[92], I[92] = I[93], I[93] = I[94], I[94] = I[95], I[95] = I[96], I[96] = I[97], I[97] = I[98], I[98] = I[99], I[99] = I[100], I[100] = I[101], \
 I[102] = I[103], I[103] = I[104], I[104] = I[105], I[105] = I[106], I[106] = I[107], I[107] = I[108], I[108] = I[109], I[109] = I[110], I[110] = I[111], I[111] = I[112], I[112] = I[113], I[113] = I[114], I[114] = I[115], I[115] = I[116], I[116] = I[117], I[117] = I[118], \
 I[119] = I[120], I[120] = I[121], I[121] = I[122], I[122] = I[123], I[123] = I[124], I[124] = I[125], I[125] = I[126], I[126] = I[127], I[127] = I[128], I[128] = I[129], I[129] = I[130], I[130] = I[131], I[131] = I[132], I[132] = I[133], I[133] = I[134], I[134] = I[135], \
 I[136] = I[137], I[137] = I[138], I[138] = I[139], I[139] = I[140], I[140] = I[141], I[141] = I[142], I[142] = I[143], I[143] = I[144], I[144] = I[145], I[145] = I[146], I[146] = I[147], I[147] = I[148], I[148] = I[149], I[149] = I[150], I[150] = I[151], I[151] = I[152], \
 I[153] = I[154], I[154] = I[155], I[155] = I[156], I[156] = I[157], I[157] = I[158], I[158] = I[159], I[159] = I[160], I[160] = I[161], I[161] = I[162], I[162] = I[163], I[163] = I[164], I[164] = I[165], I[165] = I[166], I[166] = I[167], I[167] = I[168], I[168] = I[169], \
 I[170] = I[171], I[171] = I[172], I[172] = I[173], I[173] = I[174], I[174] = I[175], I[175] = I[176], I[176] = I[177], I[177] = I[178], I[178] = I[179], I[179] = I[180], I[180] = I[181], I[181] = I[182], I[182] = I[183], I[183] = I[184], I[184] = I[185], I[185] = I[186], \
 I[187] = I[188], I[188] = I[189], I[189] = I[190], I[190] = I[191], I[191] = I[192], I[192] = I[193], I[193] = I[194], I[194] = I[195], I[195] = I[196], I[196] = I[197], I[197] = I[198], I[198] = I[199], I[199] = I[200], I[200] = I[201], I[201] = I[202], I[202] = I[203], \
 I[204] = I[205], I[205] = I[206], I[206] = I[207], I[207] = I[208], I[208] = I[209], I[209] = I[210], I[210] = I[211], I[211] = I[212], I[212] = I[213], I[213] = I[214], I[214] = I[215], I[215] = I[216], I[216] = I[217], I[217] = I[218], I[218] = I[219], I[219] = I[220], \
 I[221] = I[222], I[222] = I[223], I[223] = I[224], I[224] = I[225], I[225] = I[226], I[226] = I[227], I[227] = I[228], I[228] = I[229], I[229] = I[230], I[230] = I[231], I[231] = I[232], I[232] = I[233], I[233] = I[234], I[234] = I[235], I[235] = I[236], I[236] = I[237], \
 I[238] = I[239], I[239] = I[240], I[240] = I[241], I[241] = I[242], I[242] = I[243], I[243] = I[244], I[244] = I[245], I[245] = I[246], I[246] = I[247], I[247] = I[248], I[248] = I[249], I[249] = I[250], I[250] = I[251], I[251] = I[252], I[252] = I[253], I[253] = I[254], \
 I[255] = I[256], I[256] = I[257], I[257] = I[258], I[258] = I[259], I[259] = I[260], I[260] = I[261], I[261] = I[262], I[262] = I[263], I[263] = I[264], I[264] = I[265], I[265] = I[266], I[266] = I[267], I[267] = I[268], I[268] = I[269], I[269] = I[270], I[270] = I[271], \
 I[272] = I[273], I[273] = I[274], I[274] = I[275], I[275] = I[276], I[276] = I[277], I[277] = I[278], I[278] = I[279], I[279] = I[280], I[280] = I[281], I[281] = I[282], I[282] = I[283], I[283] = I[284], I[284] = I[285], I[285] = I[286], I[286] = I[287], I[287] = I[288], \
 _p8##x = _p7##x, _p7##x = _p6##x, _p6##x = _p5##x, _p5##x = _p4##x, _p4##x = _p3##x, _p3##x = _p2##x, _p2##x = _p1##x, _p1##x = x++, ++_n1##x, ++_n2##x, ++_n3##x, ++_n4##x, ++_n5##x, ++_n6##x, ++_n7##x, ++_n8##x)

#define cimg_for_in17x17(img,x0,y0,x1,y1,x,y,z,c,I,T) \
 cimg_for_in17((img)._height,y0,y1,y) for (int x = (int)(x0)<0?0:(int)(x0), \
 _p8##x = x-8<0?0:x-8, \
 _p7##x = x-7<0?0:x-7, \
 _p6##x = x-6<0?0:x-6, \
 _p5##x = x-5<0?0:x-5, \
 _p4##x = x-4<0?0:x-4, \
 _p3##x = x-3<0?0:x-3, \
 _p2##x = x-2<0?0:x-2, \
 _p1##x = x-1<0?0:x-1, \
 _n1##x = x+1>=(img).width()?(img).width()-1:x+1, \
 _n2##x = x+2>=(img).width()?(img).width()-1:x+2, \
 _n3##x = x+3>=(img).width()?(img).width()-1:x+3, \
 _n4##x = x+4>=(img).width()?(img).width()-1:x+4, \
 _n5##x = x+5>=(img).width()?(img).width()-1:x+5, \
 _n6##x = x+6>=(img).width()?(img).width()-1:x+6, \
 _n7##x = x+7>=(img).width()?(img).width()-1:x+7, \
 _n8##x = (int)( \
 (I[0] = (T)(img)(_p8##x,_p8##y,z,c)), \
 (I[17] = (T)(img)(_p8##x,_p7##y,z,c)), \
 (I[34] = (T)(img)(_p8##x,_p6##y,z,c)), \
 (I[51] = (T)(img)(_p8##x,_p5##y,z,c)), \
 (I[68] = (T)(img)(_p8##x,_p4##y,z,c)), \
 (I[85] = (T)(img)(_p8##x,_p3##y,z,c)), \
 (I[102] = (T)(img)(_p8##x,_p2##y,z,c)), \
 (I[119] = (T)(img)(_p8##x,_p1##y,z,c)), \
 (I[136] = (T)(img)(_p8##x,y,z,c)), \
 (I[153] = (T)(img)(_p8##x,_n1##y,z,c)), \
 (I[170] = (T)(img)(_p8##x,_n2##y,z,c)), \
 (I[187] = (T)(img)(_p8##x,_n3##y,z,c)), \
 (I[204] = (T)(img)(_p8##x,_n4##y,z,c)), \
 (I[221] = (T)(img)(_p8##x,_n5##y,z,c)), \
 (I[238] = (T)(img)(_p8##x,_n6##y,z,c)), \
 (I[255] = (T)(img)(_p8##x,_n7##y,z,c)), \
 (I[272] = (T)(img)(_p8##x,_n8##y,z,c)), \
 (I[1] = (T)(img)(_p7##x,_p8##y,z,c)), \
 (I[18] = (T)(img)(_p7##x,_p7##y,z,c)), \
 (I[35] = (T)(img)(_p7##x,_p6##y,z,c)), \
 (I[52] = (T)(img)(_p7##x,_p5##y,z,c)), \
 (I[69] = (T)(img)(_p7##x,_p4##y,z,c)), \
 (I[86] = (T)(img)(_p7##x,_p3##y,z,c)), \
 (I[103] = (T)(img)(_p7##x,_p2##y,z,c)), \
 (I[120] = (T)(img)(_p7##x,_p1##y,z,c)), \
 (I[137] = (T)(img)(_p7##x,y,z,c)), \
 (I[154] = (T)(img)(_p7##x,_n1##y,z,c)), \
 (I[171] = (T)(img)(_p7##x,_n2##y,z,c)), \
 (I[188] = (T)(img)(_p7##x,_n3##y,z,c)), \
 (I[205] = (T)(img)(_p7##x,_n4##y,z,c)), \
 (I[222] = (T)(img)(_p7##x,_n5##y,z,c)), \
 (I[239] = (T)(img)(_p7##x,_n6##y,z,c)), \
 (I[256] = (T)(img)(_p7##x,_n7##y,z,c)), \
 (I[273] = (T)(img)(_p7##x,_n8##y,z,c)), \
 (I[2] = (T)(img)(_p6##x,_p8##y,z,c)), \
 (I[19] = (T)(img)(_p6##x,_p7##y,z,c)), \
 (I[36] = (T)(img)(_p6##x,_p6##y,z,c)), \
 (I[53] = (T)(img)(_p6##x,_p5##y,z,c)), \
 (I[70] = (T)(img)(_p6##x,_p4##y,z,c)), \
 (I[87] = (T)(img)(_p6##x,_p3##y,z,c)), \
 (I[104] = (T)(img)(_p6##x,_p2##y,z,c)), \
 (I[121] = (T)(img)(_p6##x,_p1##y,z,c)), \
 (I[138] = (T)(img)(_p6##x,y,z,c)), \
 (I[155] = (T)(img)(_p6##x,_n1##y,z,c)), \
 (I[172] = (T)(img)(_p6##x,_n2##y,z,c)), \
 (I[189] = (T)(img)(_p6##x,_n3##y,z,c)), \
 (I[206] = (T)(img)(_p6##x,_n4##y,z,c)), \
 (I[223] = (T)(img)(_p6##x,_n5##y,z,c)), \
 (I[240] = (T)(img)(_p6##x,_n6##y,z,c)), \
 (I[257] = (T)(img)(_p6##x,_n7##y,z,c)), \
 (I[274] = (T)(img)(_p6##x,_n8##y,z,c)), \
 (I[3] = (T)(img)(_p5##x,_p8##y,z,c)), \
 (I[20] = (T)(img)(_p5##x,_p7##y,z,c)), \
 (I[37] = (T)(img)(_p5##x,_p6##y,z,c)), \
 (I[54] = (T)(img)(_p5##x,_p5##y,z,c)), \
 (I[71] = (T)(img)(_p5##x,_p4##y,z,c)), \
 (I[88] = (T)(img)(_p5##x,_p3##y,z,c)), \
 (I[105] = (T)(img)(_p5##x,_p2##y,z,c)), \
 (I[122] = (T)(img)(_p5##x,_p1##y,z,c)), \
 (I[139] = (T)(img)(_p5##x,y,z,c)), \
 (I[156] = (T)(img)(_p5##x,_n1##y,z,c)), \
 (I[173] = (T)(img)(_p5##x,_n2##y,z,c)), \
 (I[190] = (T)(img)(_p5##x,_n3##y,z,c)), \
 (I[207] = (T)(img)(_p5##x,_n4##y,z,c)), \
 (I[224] = (T)(img)(_p5##x,_n5##y,z,c)), \
 (I[241] = (T)(img)(_p5##x,_n6##y,z,c)), \
 (I[258] = (T)(img)(_p5##x,_n7##y,z,c)), \
 (I[275] = (T)(img)(_p5##x,_n8##y,z,c)), \
 (I[4] = (T)(img)(_p4##x,_p8##y,z,c)), \
 (I[21] = (T)(img)(_p4##x,_p7##y,z,c)), \
 (I[38] = (T)(img)(_p4##x,_p6##y,z,c)), \
 (I[55] = (T)(img)(_p4##x,_p5##y,z,c)), \
 (I[72] = (T)(img)(_p4##x,_p4##y,z,c)), \
 (I[89] = (T)(img)(_p4##x,_p3##y,z,c)), \
 (I[106] = (T)(img)(_p4##x,_p2##y,z,c)), \
 (I[123] = (T)(img)(_p4##x,_p1##y,z,c)), \
 (I[140] = (T)(img)(_p4##x,y,z,c)), \
 (I[157] = (T)(img)(_p4##x,_n1##y,z,c)), \
 (I[174] = (T)(img)(_p4##x,_n2##y,z,c)), \
 (I[191] = (T)(img)(_p4##x,_n3##y,z,c)), \
 (I[208] = (T)(img)(_p4##x,_n4##y,z,c)), \
 (I[225] = (T)(img)(_p4##x,_n5##y,z,c)), \
 (I[242] = (T)(img)(_p4##x,_n6##y,z,c)), \
 (I[259] = (T)(img)(_p4##x,_n7##y,z,c)), \
 (I[276] = (T)(img)(_p4##x,_n8##y,z,c)), \
 (I[5] = (T)(img)(_p3##x,_p8##y,z,c)), \
 (I[22] = (T)(img)(_p3##x,_p7##y,z,c)), \
 (I[39] = (T)(img)(_p3##x,_p6##y,z,c)), \
 (I[56] = (T)(img)(_p3##x,_p5##y,z,c)), \
 (I[73] = (T)(img)(_p3##x,_p4##y,z,c)), \
 (I[90] = (T)(img)(_p3##x,_p3##y,z,c)), \
 (I[107] = (T)(img)(_p3##x,_p2##y,z,c)), \
 (I[124] = (T)(img)(_p3##x,_p1##y,z,c)), \
 (I[141] = (T)(img)(_p3##x,y,z,c)), \
 (I[158] = (T)(img)(_p3##x,_n1##y,z,c)), \
 (I[175] = (T)(img)(_p3##x,_n2##y,z,c)), \
 (I[192] = (T)(img)(_p3##x,_n3##y,z,c)), \
 (I[209] = (T)(img)(_p3##x,_n4##y,z,c)), \
 (I[226] = (T)(img)(_p3##x,_n5##y,z,c)), \
 (I[243] = (T)(img)(_p3##x,_n6##y,z,c)), \
 (I[260] = (T)(img)(_p3##x,_n7##y,z,c)), \
 (I[277] = (T)(img)(_p3##x,_n8##y,z,c)), \
 (I[6] = (T)(img)(_p2##x,_p8##y,z,c)), \
 (I[23] = (T)(img)(_p2##x,_p7##y,z,c)), \
 (I[40] = (T)(img)(_p2##x,_p6##y,z,c)), \
 (I[57] = (T)(img)(_p2##x,_p5##y,z,c)), \
 (I[74] = (T)(img)(_p2##x,_p4##y,z,c)), \
 (I[91] = (T)(img)(_p2##x,_p3##y,z,c)), \
 (I[108] = (T)(img)(_p2##x,_p2##y,z,c)), \
 (I[125] = (T)(img)(_p2##x,_p1##y,z,c)), \
 (I[142] = (T)(img)(_p2##x,y,z,c)), \
 (I[159] = (T)(img)(_p2##x,_n1##y,z,c)), \
 (I[176] = (T)(img)(_p2##x,_n2##y,z,c)), \
 (I[193] = (T)(img)(_p2##x,_n3##y,z,c)), \
 (I[210] = (T)(img)(_p2##x,_n4##y,z,c)), \
 (I[227] = (T)(img)(_p2##x,_n5##y,z,c)), \
 (I[244] = (T)(img)(_p2##x,_n6##y,z,c)), \
 (I[261] = (T)(img)(_p2##x,_n7##y,z,c)), \
 (I[278] = (T)(img)(_p2##x,_n8##y,z,c)), \
 (I[7] = (T)(img)(_p1##x,_p8##y,z,c)), \
 (I[24] = (T)(img)(_p1##x,_p7##y,z,c)), \
 (I[41] = (T)(img)(_p1##x,_p6##y,z,c)), \
 (I[58] = (T)(img)(_p1##x,_p5##y,z,c)), \
 (I[75] = (T)(img)(_p1##x,_p4##y,z,c)), \
 (I[92] = (T)(img)(_p1##x,_p3##y,z,c)), \
 (I[109] = (T)(img)(_p1##x,_p2##y,z,c)), \
 (I[126] = (T)(img)(_p1##x,_p1##y,z,c)), \
 (I[143] = (T)(img)(_p1##x,y,z,c)), \
 (I[160] = (T)(img)(_p1##x,_n1##y,z,c)), \
 (I[177] = (T)(img)(_p1##x,_n2##y,z,c)), \
 (I[194] = (T)(img)(_p1##x,_n3##y,z,c)), \
 (I[211] = (T)(img)(_p1##x,_n4##y,z,c)), \
 (I[228] = (T)(img)(_p1##x,_n5##y,z,c)), \
 (I[245] = (T)(img)(_p1##x,_n6##y,z,c)), \
 (I[262] = (T)(img)(_p1##x,_n7##y,z,c)), \
 (I[279] = (T)(img)(_p1##x,_n8##y,z,c)), \
 (I[8] = (T)(img)(x,_p8##y,z,c)), \
 (I[25] = (T)(img)(x,_p7##y,z,c)), \
 (I[42] = (T)(img)(x,_p6##y,z,c)), \
 (I[59] = (T)(img)(x,_p5##y,z,c)), \
 (I[76] = (T)(img)(x,_p4##y,z,c)), \
 (I[93] = (T)(img)(x,_p3##y,z,c)), \
 (I[110] = (T)(img)(x,_p2##y,z,c)), \
 (I[127] = (T)(img)(x,_p1##y,z,c)), \
 (I[144] = (T)(img)(x,y,z,c)), \
 (I[161] = (T)(img)(x,_n1##y,z,c)), \
 (I[178] = (T)(img)(x,_n2##y,z,c)), \
 (I[195] = (T)(img)(x,_n3##y,z,c)), \
 (I[212] = (T)(img)(x,_n4##y,z,c)), \
 (I[229] = (T)(img)(x,_n5##y,z,c)), \
 (I[246] = (T)(img)(x,_n6##y,z,c)), \
 (I[263] = (T)(img)(x,_n7##y,z,c)), \
 (I[280] = (T)(img)(x,_n8##y,z,c)), \
 (I[9] = (T)(img)(_n1##x,_p8##y,z,c)), \
 (I[26] = (T)(img)(_n1##x,_p7##y,z,c)), \
 (I[43] = (T)(img)(_n1##x,_p6##y,z,c)), \
 (I[60] = (T)(img)(_n1##x,_p5##y,z,c)), \
 (I[77] = (T)(img)(_n1##x,_p4##y,z,c)), \
 (I[94] = (T)(img)(_n1##x,_p3##y,z,c)), \
 (I[111] = (T)(img)(_n1##x,_p2##y,z,c)), \
 (I[128] = (T)(img)(_n1##x,_p1##y,z,c)), \
 (I[145] = (T)(img)(_n1##x,y,z,c)), \
 (I[162] = (T)(img)(_n1##x,_n1##y,z,c)), \
 (I[179] = (T)(img)(_n1##x,_n2##y,z,c)), \
 (I[196] = (T)(img)(_n1##x,_n3##y,z,c)), \
 (I[213] = (T)(img)(_n1##x,_n4##y,z,c)), \
 (I[230] = (T)(img)(_n1##x,_n5##y,z,c)), \
 (I[247] = (T)(img)(_n1##x,_n6##y,z,c)), \
 (I[264] = (T)(img)(_n1##x,_n7##y,z,c)), \
 (I[281] = (T)(img)(_n1##x,_n8##y,z,c)), \
 (I[10] = (T)(img)(_n2##x,_p8##y,z,c)), \
 (I[27] = (T)(img)(_n2##x,_p7##y,z,c)), \
 (I[44] = (T)(img)(_n2##x,_p6##y,z,c)), \
 (I[61] = (T)(img)(_n2##x,_p5##y,z,c)), \
 (I[78] = (T)(img)(_n2##x,_p4##y,z,c)), \
 (I[95] = (T)(img)(_n2##x,_p3##y,z,c)), \
 (I[112] = (T)(img)(_n2##x,_p2##y,z,c)), \
 (I[129] = (T)(img)(_n2##x,_p1##y,z,c)), \
 (I[146] = (T)(img)(_n2##x,y,z,c)), \
 (I[163] = (T)(img)(_n2##x,_n1##y,z,c)), \
 (I[180] = (T)(img)(_n2##x,_n2##y,z,c)), \
 (I[197] = (T)(img)(_n2##x,_n3##y,z,c)), \
 (I[214] = (T)(img)(_n2##x,_n4##y,z,c)), \
 (I[231] = (T)(img)(_n2##x,_n5##y,z,c)), \
 (I[248] = (T)(img)(_n2##x,_n6##y,z,c)), \
 (I[265] = (T)(img)(_n2##x,_n7##y,z,c)), \
 (I[282] = (T)(img)(_n2##x,_n8##y,z,c)), \
 (I[11] = (T)(img)(_n3##x,_p8##y,z,c)), \
 (I[28] = (T)(img)(_n3##x,_p7##y,z,c)), \
 (I[45] = (T)(img)(_n3##x,_p6##y,z,c)), \
 (I[62] = (T)(img)(_n3##x,_p5##y,z,c)), \
 (I[79] = (T)(img)(_n3##x,_p4##y,z,c)), \
 (I[96] = (T)(img)(_n3##x,_p3##y,z,c)), \
 (I[113] = (T)(img)(_n3##x,_p2##y,z,c)), \
 (I[130] = (T)(img)(_n3##x,_p1##y,z,c)), \
 (I[147] = (T)(img)(_n3##x,y,z,c)), \
 (I[164] = (T)(img)(_n3##x,_n1##y,z,c)), \
 (I[181] = (T)(img)(_n3##x,_n2##y,z,c)), \
 (I[198] = (T)(img)(_n3##x,_n3##y,z,c)), \
 (I[215] = (T)(img)(_n3##x,_n4##y,z,c)), \
 (I[232] = (T)(img)(_n3##x,_n5##y,z,c)), \
 (I[249] = (T)(img)(_n3##x,_n6##y,z,c)), \
 (I[266] = (T)(img)(_n3##x,_n7##y,z,c)), \
 (I[283] = (T)(img)(_n3##x,_n8##y,z,c)), \
 (I[12] = (T)(img)(_n4##x,_p8##y,z,c)), \
 (I[29] = (T)(img)(_n4##x,_p7##y,z,c)), \
 (I[46] = (T)(img)(_n4##x,_p6##y,z,c)), \
 (I[63] = (T)(img)(_n4##x,_p5##y,z,c)), \
 (I[80] = (T)(img)(_n4##x,_p4##y,z,c)), \
 (I[97] = (T)(img)(_n4##x,_p3##y,z,c)), \
 (I[114] = (T)(img)(_n4##x,_p2##y,z,c)), \
 (I[131] = (T)(img)(_n4##x,_p1##y,z,c)), \
 (I[148] = (T)(img)(_n4##x,y,z,c)), \
 (I[165] = (T)(img)(_n4##x,_n1##y,z,c)), \
 (I[182] = (T)(img)(_n4##x,_n2##y,z,c)), \
 (I[199] = (T)(img)(_n4##x,_n3##y,z,c)), \
 (I[216] = (T)(img)(_n4##x,_n4##y,z,c)), \
 (I[233] = (T)(img)(_n4##x,_n5##y,z,c)), \
 (I[250] = (T)(img)(_n4##x,_n6##y,z,c)), \
 (I[267] = (T)(img)(_n4##x,_n7##y,z,c)), \
 (I[284] = (T)(img)(_n4##x,_n8##y,z,c)), \
 (I[13] = (T)(img)(_n5##x,_p8##y,z,c)), \
 (I[30] = (T)(img)(_n5##x,_p7##y,z,c)), \
 (I[47] = (T)(img)(_n5##x,_p6##y,z,c)), \
 (I[64] = (T)(img)(_n5##x,_p5##y,z,c)), \
 (I[81] = (T)(img)(_n5##x,_p4##y,z,c)), \
 (I[98] = (T)(img)(_n5##x,_p3##y,z,c)), \
 (I[115] = (T)(img)(_n5##x,_p2##y,z,c)), \
 (I[132] = (T)(img)(_n5##x,_p1##y,z,c)), \
 (I[149] = (T)(img)(_n5##x,y,z,c)), \
 (I[166] = (T)(img)(_n5##x,_n1##y,z,c)), \
 (I[183] = (T)(img)(_n5##x,_n2##y,z,c)), \
 (I[200] = (T)(img)(_n5##x,_n3##y,z,c)), \
 (I[217] = (T)(img)(_n5##x,_n4##y,z,c)), \
 (I[234] = (T)(img)(_n5##x,_n5##y,z,c)), \
 (I[251] = (T)(img)(_n5##x,_n6##y,z,c)), \
 (I[268] = (T)(img)(_n5##x,_n7##y,z,c)), \
 (I[285] = (T)(img)(_n5##x,_n8##y,z,c)), \
 (I[14] = (T)(img)(_n6##x,_p8##y,z,c)), \
 (I[31] = (T)(img)(_n6##x,_p7##y,z,c)), \
 (I[48] = (T)(img)(_n6##x,_p6##y,z,c)), \
 (I[65] = (T)(img)(_n6##x,_p5##y,z,c)), \
 (I[82] = (T)(img)(_n6##x,_p4##y,z,c)), \
 (I[99] = (T)(img)(_n6##x,_p3##y,z,c)), \
 (I[116] = (T)(img)(_n6##x,_p2##y,z,c)), \
 (I[133] = (T)(img)(_n6##x,_p1##y,z,c)), \
 (I[150] = (T)(img)(_n6##x,y,z,c)), \
 (I[167] = (T)(img)(_n6##x,_n1##y,z,c)), \
 (I[184] = (T)(img)(_n6##x,_n2##y,z,c)), \
 (I[201] = (T)(img)(_n6##x,_n3##y,z,c)), \
 (I[218] = (T)(img)(_n6##x,_n4##y,z,c)), \
 (I[235] = (T)(img)(_n6##x,_n5##y,z,c)), \
 (I[252] = (T)(img)(_n6##x,_n6##y,z,c)), \
 (I[269] = (T)(img)(_n6##x,_n7##y,z,c)), \
 (I[286] = (T)(img)(_n6##x,_n8##y,z,c)), \
 (I[15] = (T)(img)(_n7##x,_p8##y,z,c)), \
 (I[32] = (T)(img)(_n7##x,_p7##y,z,c)), \
 (I[49] = (T)(img)(_n7##x,_p6##y,z,c)), \
 (I[66] = (T)(img)(_n7##x,_p5##y,z,c)), \
 (I[83] = (T)(img)(_n7##x,_p4##y,z,c)), \
 (I[100] = (T)(img)(_n7##x,_p3##y,z,c)), \
 (I[117] = (T)(img)(_n7##x,_p2##y,z,c)), \
 (I[134] = (T)(img)(_n7##x,_p1##y,z,c)), \
 (I[151] = (T)(img)(_n7##x,y,z,c)), \
 (I[168] = (T)(img)(_n7##x,_n1##y,z,c)), \
 (I[185] = (T)(img)(_n7##x,_n2##y,z,c)), \
 (I[202] = (T)(img)(_n7##x,_n3##y,z,c)), \
 (I[219] = (T)(img)(_n7##x,_n4##y,z,c)), \
 (I[236] = (T)(img)(_n7##x,_n5##y,z,c)), \
 (I[253] = (T)(img)(_n7##x,_n6##y,z,c)), \
 (I[270] = (T)(img)(_n7##x,_n7##y,z,c)), \
 (I[287] = (T)(img)(_n7##x,_n8##y,z,c)), \
 x+8>=(img).width()?(img).width()-1:x+8); \
 x<=(int)(x1) && ((_n8##x<(img).width() && ( \
 (I[16] = (T)(img)(_n8##x,_p8##y,z,c)), \
 (I[33] = (T)(img)(_n8##x,_p7##y,z,c)), \
 (I[50] = (T)(img)(_n8##x,_p6##y,z,c)), \
 (I[67] = (T)(img)(_n8##x,_p5##y,z,c)), \
 (I[84] = (T)(img)(_n8##x,_p4##y,z,c)), \
 (I[101] = (T)(img)(_n8##x,_p3##y,z,c)), \
 (I[118] = (T)(img)(_n8##x,_p2##y,z,c)), \
 (I[135] = (T)(img)(_n8##x,_p1##y,z,c)), \
 (I[152] = (T)(img)(_n8##x,y,z,c)), \
 (I[169] = (T)(img)(_n8##x,_n1##y,z,c)), \
 (I[186] = (T)(img)(_n8##x,_n2##y,z,c)), \
 (I[203] = (T)(img)(_n8##x,_n3##y,z,c)), \
 (I[220] = (T)(img)(_n8##x,_n4##y,z,c)), \
 (I[237] = (T)(img)(_n8##x,_n5##y,z,c)), \
 (I[254] = (T)(img)(_n8##x,_n6##y,z,c)), \
 (I[271] = (T)(img)(_n8##x,_n7##y,z,c)), \
 (I[288] = (T)(img)(_n8##x,_n8##y,z,c)),1)) || \
 _n7##x==--_n8##x || _n6##x==--_n7##x || _n5##x==--_n6##x || _n4##x==--_n5##x || _n3##x==--_n4##x || _n2##x==--_n3##x || _n1##x==--_n2##x || x==(_n8##x = _n7##x = _n6##x = _n5##x = _n4##x = _n3##x = _n2##x = --_n1##x)); \
 I[0] = I[1], I[1] = I[2], I[2] = I[3], I[3] = I[4], I[4] = I[5], I[5] = I[6], I[6] = I[7], I[7] = I[8], I[8] = I[9], I[9] = I[10], I[10] = I[11], I[11] = I[12], I[12] = I[13], I[13] = I[14], I[14] = I[15], I[15] = I[16], \
 I[17] = I[18], I[18] = I[19], I[19] = I[20], I[20] = I[21], I[21] = I[22], I[22] = I[23], I[23] = I[24], I[24] = I[25], I[25] = I[26], I[26] = I[27], I[27] = I[28], I[28] = I[29], I[29] = I[30], I[30] = I[31], I[31] = I[32], I[32] = I[33], \
 I[34] = I[35], I[35] = I[36], I[36] = I[37], I[37] = I[38], I[38] = I[39], I[39] = I[40], I[40] = I[41], I[41] = I[42], I[42] = I[43], I[43] = I[44], I[44] = I[45], I[45] = I[46], I[46] = I[47], I[47] = I[48], I[48] = I[49], I[49] = I[50], \
 I[51] = I[52], I[52] = I[53], I[53] = I[54], I[54] = I[55], I[55] = I[56], I[56] = I[57], I[57] = I[58], I[58] = I[59], I[59] = I[60], I[60] = I[61], I[61] = I[62], I[62] = I[63], I[63] = I[64], I[64] = I[65], I[65] = I[66], I[66] = I[67], \
 I[68] = I[69], I[69] = I[70], I[70] = I[71], I[71] = I[72], I[72] = I[73], I[73] = I[74], I[74] = I[75], I[75] = I[76], I[76] = I[77], I[77] = I[78], I[78] = I[79], I[79] = I[80], I[80] = I[81], I[81] = I[82], I[82] = I[83], I[83] = I[84], \
 I[85] = I[86], I[86] = I[87], I[87] = I[88], I[88] = I[89], I[89] = I[90], I[90] = I[91], I[91] = I[92], I[92] = I[93], I[93] = I[94], I[94] = I[95], I[95] = I[96], I[96] = I[97], I[97] = I[98], I[98] = I[99], I[99] = I[100], I[100] = I[101], \
 I[102] = I[103], I[103] = I[104], I[104] = I[105], I[105] = I[106], I[106] = I[107], I[107] = I[108], I[108] = I[109], I[109] = I[110], I[110] = I[111], I[111] = I[112], I[112] = I[113], I[113] = I[114], I[114] = I[115], I[115] = I[116], I[116] = I[117], I[117] = I[118], \
 I[119] = I[120], I[120] = I[121], I[121] = I[122], I[122] = I[123], I[123] = I[124], I[124] = I[125], I[125] = I[126], I[126] = I[127], I[127] = I[128], I[128] = I[129], I[129] = I[130], I[130] = I[131], I[131] = I[132], I[132] = I[133], I[133] = I[134], I[134] = I[135], \
 I[136] = I[137], I[137] = I[138], I[138] = I[139], I[139] = I[140], I[140] = I[141], I[141] = I[142], I[142] = I[143], I[143] = I[144], I[144] = I[145], I[145] = I[146], I[146] = I[147], I[147] = I[148], I[148] = I[149], I[149] = I[150], I[150] = I[151], I[151] = I[152], \
 I[153] = I[154], I[154] = I[155], I[155] = I[156], I[156] = I[157], I[157] = I[158], I[158] = I[159], I[159] = I[160], I[160] = I[161], I[161] = I[162], I[162] = I[163], I[163] = I[164], I[164] = I[165], I[165] = I[166], I[166] = I[167], I[167] = I[168], I[168] = I[169], \
 I[170] = I[171], I[171] = I[172], I[172] = I[173], I[173] = I[174], I[174] = I[175], I[175] = I[176], I[176] = I[177], I[177] = I[178], I[178] = I[179], I[179] = I[180], I[180] = I[181], I[181] = I[182], I[182] = I[183], I[183] = I[184], I[184] = I[185], I[185] = I[186], \
 I[187] = I[188], I[188] = I[189], I[189] = I[190], I[190] = I[191], I[191] = I[192], I[192] = I[193], I[193] = I[194], I[194] = I[195], I[195] = I[196], I[196] = I[197], I[197] = I[198], I[198] = I[199], I[199] = I[200], I[200] = I[201], I[201] = I[202], I[202] = I[203], \
 I[204] = I[205], I[205] = I[206], I[206] = I[207], I[207] = I[208], I[208] = I[209], I[209] = I[210], I[210] = I[211], I[211] = I[212], I[212] = I[213], I[213] = I[214], I[214] = I[215], I[215] = I[216], I[216] = I[217], I[217] = I[218], I[218] = I[219], I[219] = I[220], \
 I[221] = I[222], I[222] = I[223], I[223] = I[224], I[224] = I[225], I[225] = I[226], I[226] = I[227], I[227] = I[228], I[228] = I[229], I[229] = I[230], I[230] = I[231], I[231] = I[232], I[232] = I[233], I[233] = I[234], I[234] = I[235], I[235] = I[236], I[236] = I[237], \
 I[238] = I[239], I[239] = I[240], I[240] = I[241], I[241] = I[242], I[242] = I[243], I[243] = I[244], I[244] = I[245], I[245] = I[246], I[246] = I[247], I[247] = I[248], I[248] = I[249], I[249] = I[250], I[250] = I[251], I[251] = I[252], I[252] = I[253], I[253] = I[254], \
 I[255] = I[256], I[256] = I[257], I[257] = I[258], I[258] = I[259], I[259] = I[260], I[260] = I[261], I[261] = I[262], I[262] = I[263], I[263] = I[264], I[264] = I[265], I[265] = I[266], I[266] = I[267], I[267] = I[268], I[268] = I[269], I[269] = I[270], I[270] = I[271], \
 I[272] = I[273], I[273] = I[274], I[274] = I[275], I[275] = I[276], I[276] = I[277], I[277] = I[278], I[278] = I[279], I[279] = I[280], I[280] = I[281], I[281] = I[282], I[282] = I[283], I[283] = I[284], I[284] = I[285], I[285] = I[286], I[286] = I[287], I[287] = I[288], \
 _p8##x = _p7##x, _p7##x = _p6##x, _p6##x = _p5##x, _p5##x = _p4##x, _p4##x = _p3##x, _p3##x = _p2##x, _p2##x = _p1##x, _p1##x = x++, ++_n1##x, ++_n2##x, ++_n3##x, ++_n4##x, ++_n5##x, ++_n6##x, ++_n7##x, ++_n8##x)

#define cimg_get17x17(img,x,y,z,c,I,T) \
 I[0] = (T)(img)(_p8##x,_p8##y,z,c), I[1] = (T)(img)(_p7##x,_p8##y,z,c), I[2] = (T)(img)(_p6##x,_p8##y,z,c), I[3] = (T)(img)(_p5##x,_p8##y,z,c), I[4] = (T)(img)(_p4##x,_p8##y,z,c), I[5] = (T)(img)(_p3##x,_p8##y,z,c), I[6] = (T)(img)(_p2##x,_p8##y,z,c), I[7] = (T)(img)(_p1##x,_p8##y,z,c), I[8] = (T)(img)(x,_p8##y,z,c), I[9] = (T)(img)(_n1##x,_p8##y,z,c), I[10] = (T)(img)(_n2##x,_p8##y,z,c), I[11] = (T)(img)(_n3##x,_p8##y,z,c), I[12] = (T)(img)(_n4##x,_p8##y,z,c), I[13] = (T)(img)(_n5##x,_p8##y,z,c), I[14] = (T)(img)(_n6##x,_p8##y,z,c), I[15] = (T)(img)(_n7##x,_p8##y,z,c), I[16] = (T)(img)(_n8##x,_p8##y,z,c), \
 I[17] = (T)(img)(_p8##x,_p7##y,z,c), I[18] = (T)(img)(_p7##x,_p7##y,z,c), I[19] = (T)(img)(_p6##x,_p7##y,z,c), I[20] = (T)(img)(_p5##x,_p7##y,z,c), I[21] = (T)(img)(_p4##x,_p7##y,z,c), I[22] = (T)(img)(_p3##x,_p7##y,z,c), I[23] = (T)(img)(_p2##x,_p7##y,z,c), I[24] = (T)(img)(_p1##x,_p7##y,z,c), I[25] = (T)(img)(x,_p7##y,z,c), I[26] = (T)(img)(_n1##x,_p7##y,z,c), I[27] = (T)(img)(_n2##x,_p7##y,z,c), I[28] = (T)(img)(_n3##x,_p7##y,z,c), I[29] = (T)(img)(_n4##x,_p7##y,z,c), I[30] = (T)(img)(_n5##x,_p7##y,z,c), I[31] = (T)(img)(_n6##x,_p7##y,z,c), I[32] = (T)(img)(_n7##x,_p7##y,z,c), I[33] = (T)(img)(_n8##x,_p7##y,z,c), \
 I[34] = (T)(img)(_p8##x,_p6##y,z,c), I[35] = (T)(img)(_p7##x,_p6##y,z,c), I[36] = (T)(img)(_p6##x,_p6##y,z,c), I[37] = (T)(img)(_p5##x,_p6##y,z,c), I[38] = (T)(img)(_p4##x,_p6##y,z,c), I[39] = (T)(img)(_p3##x,_p6##y,z,c), I[40] = (T)(img)(_p2##x,_p6##y,z,c), I[41] = (T)(img)(_p1##x,_p6##y,z,c), I[42] = (T)(img)(x,_p6##y,z,c), I[43] = (T)(img)(_n1##x,_p6##y,z,c), I[44] = (T)(img)(_n2##x,_p6##y,z,c), I[45] = (T)(img)(_n3##x,_p6##y,z,c), I[46] = (T)(img)(_n4##x,_p6##y,z,c), I[47] = (T)(img)(_n5##x,_p6##y,z,c), I[48] = (T)(img)(_n6##x,_p6##y,z,c), I[49] = (T)(img)(_n7##x,_p6##y,z,c), I[50] = (T)(img)(_n8##x,_p6##y,z,c), \
 I[51] = (T)(img)(_p8##x,_p5##y,z,c), I[52] = (T)(img)(_p7##x,_p5##y,z,c), I[53] = (T)(img)(_p6##x,_p5##y,z,c), I[54] = (T)(img)(_p5##x,_p5##y,z,c), I[55] = (T)(img)(_p4##x,_p5##y,z,c), I[56] = (T)(img)(_p3##x,_p5##y,z,c), I[57] = (T)(img)(_p2##x,_p5##y,z,c), I[58] = (T)(img)(_p1##x,_p5##y,z,c), I[59] = (T)(img)(x,_p5##y,z,c), I[60] = (T)(img)(_n1##x,_p5##y,z,c), I[61] = (T)(img)(_n2##x,_p5##y,z,c), I[62] = (T)(img)(_n3##x,_p5##y,z,c), I[63] = (T)(img)(_n4##x,_p5##y,z,c), I[64] = (T)(img)(_n5##x,_p5##y,z,c), I[65] = (T)(img)(_n6##x,_p5##y,z,c), I[66] = (T)(img)(_n7##x,_p5##y,z,c), I[67] = (T)(img)(_n8##x,_p5##y,z,c), \
 I[68] = (T)(img)(_p8##x,_p4##y,z,c), I[69] = (T)(img)(_p7##x,_p4##y,z,c), I[70] = (T)(img)(_p6##x,_p4##y,z,c), I[71] = (T)(img)(_p5##x,_p4##y,z,c), I[72] = (T)(img)(_p4##x,_p4##y,z,c), I[73] = (T)(img)(_p3##x,_p4##y,z,c), I[74] = (T)(img)(_p2##x,_p4##y,z,c), I[75] = (T)(img)(_p1##x,_p4##y,z,c), I[76] = (T)(img)(x,_p4##y,z,c), I[77] = (T)(img)(_n1##x,_p4##y,z,c), I[78] = (T)(img)(_n2##x,_p4##y,z,c), I[79] = (T)(img)(_n3##x,_p4##y,z,c), I[80] = (T)(img)(_n4##x,_p4##y,z,c), I[81] = (T)(img)(_n5##x,_p4##y,z,c), I[82] = (T)(img)(_n6##x,_p4##y,z,c), I[83] = (T)(img)(_n7##x,_p4##y,z,c), I[84] = (T)(img)(_n8##x,_p4##y,z,c), \
 I[85] = (T)(img)(_p8##x,_p3##y,z,c), I[86] = (T)(img)(_p7##x,_p3##y,z,c), I[87] = (T)(img)(_p6##x,_p3##y,z,c), I[88] = (T)(img)(_p5##x,_p3##y,z,c), I[89] = (T)(img)(_p4##x,_p3##y,z,c), I[90] = (T)(img)(_p3##x,_p3##y,z,c), I[91] = (T)(img)(_p2##x,_p3##y,z,c), I[92] = (T)(img)(_p1##x,_p3##y,z,c), I[93] = (T)(img)(x,_p3##y,z,c), I[94] = (T)(img)(_n1##x,_p3##y,z,c), I[95] = (T)(img)(_n2##x,_p3##y,z,c), I[96] = (T)(img)(_n3##x,_p3##y,z,c), I[97] = (T)(img)(_n4##x,_p3##y,z,c), I[98] = (T)(img)(_n5##x,_p3##y,z,c), I[99] = (T)(img)(_n6##x,_p3##y,z,c), I[100] = (T)(img)(_n7##x,_p3##y,z,c), I[101] = (T)(img)(_n8##x,_p3##y,z,c), \
 I[102] = (T)(img)(_p8##x,_p2##y,z,c), I[103] = (T)(img)(_p7##x,_p2##y,z,c), I[104] = (T)(img)(_p6##x,_p2##y,z,c), I[105] = (T)(img)(_p5##x,_p2##y,z,c), I[106] = (T)(img)(_p4##x,_p2##y,z,c), I[107] = (T)(img)(_p3##x,_p2##y,z,c), I[108] = (T)(img)(_p2##x,_p2##y,z,c), I[109] = (T)(img)(_p1##x,_p2##y,z,c), I[110] = (T)(img)(x,_p2##y,z,c), I[111] = (T)(img)(_n1##x,_p2##y,z,c), I[112] = (T)(img)(_n2##x,_p2##y,z,c), I[113] = (T)(img)(_n3##x,_p2##y,z,c), I[114] = (T)(img)(_n4##x,_p2##y,z,c), I[115] = (T)(img)(_n5##x,_p2##y,z,c), I[116] = (T)(img)(_n6##x,_p2##y,z,c), I[117] = (T)(img)(_n7##x,_p2##y,z,c), I[118] = (T)(img)(_n8##x,_p2##y,z,c), \
 I[119] = (T)(img)(_p8##x,_p1##y,z,c), I[120] = (T)(img)(_p7##x,_p1##y,z,c), I[121] = (T)(img)(_p6##x,_p1##y,z,c), I[122] = (T)(img)(_p5##x,_p1##y,z,c), I[123] = (T)(img)(_p4##x,_p1##y,z,c), I[124] = (T)(img)(_p3##x,_p1##y,z,c), I[125] = (T)(img)(_p2##x,_p1##y,z,c), I[126] = (T)(img)(_p1##x,_p1##y,z,c), I[127] = (T)(img)(x,_p1##y,z,c), I[128] = (T)(img)(_n1##x,_p1##y,z,c), I[129] = (T)(img)(_n2##x,_p1##y,z,c), I[130] = (T)(img)(_n3##x,_p1##y,z,c), I[131] = (T)(img)(_n4##x,_p1##y,z,c), I[132] = (T)(img)(_n5##x,_p1##y,z,c), I[133] = (T)(img)(_n6##x,_p1##y,z,c), I[134] = (T)(img)(_n7##x,_p1##y,z,c), I[135] = (T)(img)(_n8##x,_p1##y,z,c), \
 I[136] = (T)(img)(_p8##x,y,z,c), I[137] = (T)(img)(_p7##x,y,z,c), I[138] = (T)(img)(_p6##x,y,z,c), I[139] = (T)(img)(_p5##x,y,z,c), I[140] = (T)(img)(_p4##x,y,z,c), I[141] = (T)(img)(_p3##x,y,z,c), I[142] = (T)(img)(_p2##x,y,z,c), I[143] = (T)(img)(_p1##x,y,z,c), I[144] = (T)(img)(x,y,z,c), I[145] = (T)(img)(_n1##x,y,z,c), I[146] = (T)(img)(_n2##x,y,z,c), I[147] = (T)(img)(_n3##x,y,z,c), I[148] = (T)(img)(_n4##x,y,z,c), I[149] = (T)(img)(_n5##x,y,z,c), I[150] = (T)(img)(_n6##x,y,z,c), I[151] = (T)(img)(_n7##x,y,z,c), I[152] = (T)(img)(_n8##x,y,z,c), \
 I[153] = (T)(img)(_p8##x,_n1##y,z,c), I[154] = (T)(img)(_p7##x,_n1##y,z,c), I[155] = (T)(img)(_p6##x,_n1##y,z,c), I[156] = (T)(img)(_p5##x,_n1##y,z,c), I[157] = (T)(img)(_p4##x,_n1##y,z,c), I[158] = (T)(img)(_p3##x,_n1##y,z,c), I[159] = (T)(img)(_p2##x,_n1##y,z,c), I[160] = (T)(img)(_p1##x,_n1##y,z,c), I[161] = (T)(img)(x,_n1##y,z,c), I[162] = (T)(img)(_n1##x,_n1##y,z,c), I[163] = (T)(img)(_n2##x,_n1##y,z,c), I[164] = (T)(img)(_n3##x,_n1##y,z,c), I[165] = (T)(img)(_n4##x,_n1##y,z,c), I[166] = (T)(img)(_n5##x,_n1##y,z,c), I[167] = (T)(img)(_n6##x,_n1##y,z,c), I[168] = (T)(img)(_n7##x,_n1##y,z,c), I[169] = (T)(img)(_n8##x,_n1##y,z,c), \
 I[170] = (T)(img)(_p8##x,_n2##y,z,c), I[171] = (T)(img)(_p7##x,_n2##y,z,c), I[172] = (T)(img)(_p6##x,_n2##y,z,c), I[173] = (T)(img)(_p5##x,_n2##y,z,c), I[174] = (T)(img)(_p4##x,_n2##y,z,c), I[175] = (T)(img)(_p3##x,_n2##y,z,c), I[176] = (T)(img)(_p2##x,_n2##y,z,c), I[177] = (T)(img)(_p1##x,_n2##y,z,c), I[178] = (T)(img)(x,_n2##y,z,c), I[179] = (T)(img)(_n1##x,_n2##y,z,c), I[180] = (T)(img)(_n2##x,_n2##y,z,c), I[181] = (T)(img)(_n3##x,_n2##y,z,c), I[182] = (T)(img)(_n4##x,_n2##y,z,c), I[183] = (T)(img)(_n5##x,_n2##y,z,c), I[184] = (T)(img)(_n6##x,_n2##y,z,c), I[185] = (T)(img)(_n7##x,_n2##y,z,c), I[186] = (T)(img)(_n8##x,_n2##y,z,c), \
 I[187] = (T)(img)(_p8##x,_n3##y,z,c), I[188] = (T)(img)(_p7##x,_n3##y,z,c), I[189] = (T)(img)(_p6##x,_n3##y,z,c), I[190] = (T)(img)(_p5##x,_n3##y,z,c), I[191] = (T)(img)(_p4##x,_n3##y,z,c), I[192] = (T)(img)(_p3##x,_n3##y,z,c), I[193] = (T)(img)(_p2##x,_n3##y,z,c), I[194] = (T)(img)(_p1##x,_n3##y,z,c), I[195] = (T)(img)(x,_n3##y,z,c), I[196] = (T)(img)(_n1##x,_n3##y,z,c), I[197] = (T)(img)(_n2##x,_n3##y,z,c), I[198] = (T)(img)(_n3##x,_n3##y,z,c), I[199] = (T)(img)(_n4##x,_n3##y,z,c), I[200] = (T)(img)(_n5##x,_n3##y,z,c), I[201] = (T)(img)(_n6##x,_n3##y,z,c), I[202] = (T)(img)(_n7##x,_n3##y,z,c), I[203] = (T)(img)(_n8##x,_n3##y,z,c), \
 I[204] = (T)(img)(_p8##x,_n4##y,z,c), I[205] = (T)(img)(_p7##x,_n4##y,z,c), I[206] = (T)(img)(_p6##x,_n4##y,z,c), I[207] = (T)(img)(_p5##x,_n4##y,z,c), I[208] = (T)(img)(_p4##x,_n4##y,z,c), I[209] = (T)(img)(_p3##x,_n4##y,z,c), I[210] = (T)(img)(_p2##x,_n4##y,z,c), I[211] = (T)(img)(_p1##x,_n4##y,z,c), I[212] = (T)(img)(x,_n4##y,z,c), I[213] = (T)(img)(_n1##x,_n4##y,z,c), I[214] = (T)(img)(_n2##x,_n4##y,z,c), I[215] = (T)(img)(_n3##x,_n4##y,z,c), I[216] = (T)(img)(_n4##x,_n4##y,z,c), I[217] = (T)(img)(_n5##x,_n4##y,z,c), I[218] = (T)(img)(_n6##x,_n4##y,z,c), I[219] = (T)(img)(_n7##x,_n4##y,z,c), I[220] = (T)(img)(_n8##x,_n4##y,z,c), \
 I[221] = (T)(img)(_p8##x,_n5##y,z,c), I[222] = (T)(img)(_p7##x,_n5##y,z,c), I[223] = (T)(img)(_p6##x,_n5##y,z,c), I[224] = (T)(img)(_p5##x,_n5##y,z,c), I[225] = (T)(img)(_p4##x,_n5##y,z,c), I[226] = (T)(img)(_p3##x,_n5##y,z,c), I[227] = (T)(img)(_p2##x,_n5##y,z,c), I[228] = (T)(img)(_p1##x,_n5##y,z,c), I[229] = (T)(img)(x,_n5##y,z,c), I[230] = (T)(img)(_n1##x,_n5##y,z,c), I[231] = (T)(img)(_n2##x,_n5##y,z,c), I[232] = (T)(img)(_n3##x,_n5##y,z,c), I[233] = (T)(img)(_n4##x,_n5##y,z,c), I[234] = (T)(img)(_n5##x,_n5##y,z,c), I[235] = (T)(img)(_n6##x,_n5##y,z,c), I[236] = (T)(img)(_n7##x,_n5##y,z,c), I[237] = (T)(img)(_n8##x,_n5##y,z,c), \
 I[238] = (T)(img)(_p8##x,_n6##y,z,c), I[239] = (T)(img)(_p7##x,_n6##y,z,c), I[240] = (T)(img)(_p6##x,_n6##y,z,c), I[241] = (T)(img)(_p5##x,_n6##y,z,c), I[242] = (T)(img)(_p4##x,_n6##y,z,c), I[243] = (T)(img)(_p3##x,_n6##y,z,c), I[244] = (T)(img)(_p2##x,_n6##y,z,c), I[245] = (T)(img)(_p1##x,_n6##y,z,c), I[246] = (T)(img)(x,_n6##y,z,c), I[247] = (T)(img)(_n1##x,_n6##y,z,c), I[248] = (T)(img)(_n2##x,_n6##y,z,c), I[249] = (T)(img)(_n3##x,_n6##y,z,c), I[250] = (T)(img)(_n4##x,_n6##y,z,c), I[251] = (T)(img)(_n5##x,_n6##y,z,c), I[252] = (T)(img)(_n6##x,_n6##y,z,c), I[253] = (T)(img)(_n7##x,_n6##y,z,c), I[254] = (T)(img)(_n8##x,_n6##y,z,c), \
 I[255] = (T)(img)(_p8##x,_n7##y,z,c), I[256] = (T)(img)(_p7##x,_n7##y,z,c), I[257] = (T)(img)(_p6##x,_n7##y,z,c), I[258] = (T)(img)(_p5##x,_n7##y,z,c), I[259] = (T)(img)(_p4##x,_n7##y,z,c), I[260] = (T)(img)(_p3##x,_n7##y,z,c), I[261] = (T)(img)(_p2##x,_n7##y,z,c), I[262] = (T)(img)(_p1##x,_n7##y,z,c), I[263] = (T)(img)(x,_n7##y,z,c), I[264] = (T)(img)(_n1##x,_n7##y,z,c), I[265] = (T)(img)(_n2##x,_n7##y,z,c), I[266] = (T)(img)(_n3##x,_n7##y,z,c), I[267] = (T)(img)(_n4##x,_n7##y,z,c), I[268] = (T)(img)(_n5##x,_n7##y,z,c), I[269] = (T)(img)(_n6##x,_n7##y,z,c), I[270] = (T)(img)(_n7##x,_n7##y,z,c), I[271] = (T)(img)(_n8##x,_n7##y,z,c), \
 I[272] = (T)(img)(_p8##x,_n8##y,z,c), I[273] = (T)(img)(_p7##x,_n8##y,z,c), I[274] = (T)(img)(_p6##x,_n8##y,z,c), I[275] = (T)(img)(_p5##x,_n8##y,z,c), I[276] = (T)(img)(_p4##x,_n8##y,z,c), I[277] = (T)(img)(_p3##x,_n8##y,z,c), I[278] = (T)(img)(_p2##x,_n8##y,z,c), I[279] = (T)(img)(_p1##x,_n8##y,z,c), I[280] = (T)(img)(x,_n8##y,z,c), I[281] = (T)(img)(_n1##x,_n8##y,z,c), I[282] = (T)(img)(_n2##x,_n8##y,z,c), I[283] = (T)(img)(_n3##x,_n8##y,z,c), I[284] = (T)(img)(_n4##x,_n8##y,z,c), I[285] = (T)(img)(_n5##x,_n8##y,z,c), I[286] = (T)(img)(_n6##x,_n8##y,z,c), I[287] = (T)(img)(_n7##x,_n8##y,z,c), I[288] = (T)(img)(_n8##x,_n8##y,z,c);

// Define 18x18 loop macros
//-------------------------
#define cimg_for18(bound,i) for (int i = 0, \
 _p8##i = 0, _p7##i = 0, _p6##i = 0, _p5##i = 0, _p4##i = 0, _p3##i = 0, _p2##i = 0, _p1##i = 0, \
 _n1##i = 1>=(int)(bound)?(int)(bound)-1:1, \
 _n2##i = 2>=(int)(bound)?(int)(bound)-1:2, \
 _n3##i = 3>=(int)(bound)?(int)(bound)-1:3, \
 _n4##i = 4>=(int)(bound)?(int)(bound)-1:4, \
 _n5##i = 5>=(int)(bound)?(int)(bound)-1:5, \
 _n6##i = 6>=(int)(bound)?(int)(bound)-1:6, \
 _n7##i = 7>=(int)(bound)?(int)(bound)-1:7, \
 _n8##i = 8>=(int)(bound)?(int)(bound)-1:8, \
 _n9##i = 9>=(int)(bound)?(int)(bound)-1:9; \
 _n9##i<(int)(bound) || _n8##i==--_n9##i || _n7##i==--_n8##i || _n6##i==--_n7##i || _n5##i==--_n6##i || _n4##i==--_n5##i || _n3##i==--_n4##i || _n2##i==--_n3##i || _n1##i==--_n2##i || \
 i==(_n9##i = _n8##i = _n7##i = _n6##i = _n5##i = _n4##i = _n3##i = _n2##i = --_n1##i); \
 _p8##i = _p7##i, _p7##i = _p6##i, _p6##i = _p5##i, _p5##i = _p4##i, _p4##i = _p3##i, _p3##i = _p2##i, _p2##i = _p1##i, _p1##i = i++, \
 ++_n1##i, ++_n2##i, ++_n3##i, ++_n4##i, ++_n5##i, ++_n6##i, ++_n7##i, ++_n8##i, ++_n9##i)

#define cimg_for18X(img,x) cimg_for18((img)._width,x)
#define cimg_for18Y(img,y) cimg_for18((img)._height,y)
#define cimg_for18Z(img,z) cimg_for18((img)._depth,z)
#define cimg_for18C(img,c) cimg_for18((img)._spectrum,c)
#define cimg_for18XY(img,x,y) cimg_for18Y(img,y) cimg_for18X(img,x)
#define cimg_for18XZ(img,x,z) cimg_for18Z(img,z) cimg_for18X(img,x)
#define cimg_for18XC(img,x,c) cimg_for18C(img,c) cimg_for18X(img,x)
#define cimg_for18YZ(img,y,z) cimg_for18Z(img,z) cimg_for18Y(img,y)
#define cimg_for18YC(img,y,c) cimg_for18C(img,c) cimg_for18Y(img,y)
#define cimg_for18ZC(img,z,c) cimg_for18C(img,c) cimg_for18Z(img,z)
#define cimg_for18XYZ(img,x,y,z) cimg_for18Z(img,z) cimg_for18XY(img,x,y)
#define cimg_for18XZC(img,x,z,c) cimg_for18C(img,c) cimg_for18XZ(img,x,z)
#define cimg_for18YZC(img,y,z,c) cimg_for18C(img,c) cimg_for18YZ(img,y,z)
#define cimg_for18XYZC(img,x,y,z,c) cimg_for18C(img,c) cimg_for18XYZ(img,x,y,z)

#define cimg_for_in18(bound,i0,i1,i) for (int i = (int)(i0)<0?0:(int)(i0), \
 _p8##i = i-8<0?0:i-8, \
 _p7##i = i-7<0?0:i-7, \
 _p6##i = i-6<0?0:i-6, \
 _p5##i = i-5<0?0:i-5, \
 _p4##i = i-4<0?0:i-4, \
 _p3##i = i-3<0?0:i-3, \
 _p2##i = i-2<0?0:i-2, \
 _p1##i = i-1<0?0:i-1, \
 _n1##i = i+1>=(int)(bound)?(int)(bound)-1:i+1, \
 _n2##i = i+2>=(int)(bound)?(int)(bound)-1:i+2, \
 _n3##i = i+3>=(int)(bound)?(int)(bound)-1:i+3, \
 _n4##i = i+4>=(int)(bound)?(int)(bound)-1:i+4, \
 _n5##i = i+5>=(int)(bound)?(int)(bound)-1:i+5, \
 _n6##i = i+6>=(int)(bound)?(int)(bound)-1:i+6, \
 _n7##i = i+7>=(int)(bound)?(int)(bound)-1:i+7, \
 _n8##i = i+8>=(int)(bound)?(int)(bound)-1:i+8, \
 _n9##i = i+9>=(int)(bound)?(int)(bound)-1:i+9; \
 i<=(int)(i1) && (_n9##i<(int)(bound) || _n8##i==--_n9##i || _n7##i==--_n8##i || _n6##i==--_n7##i || _n5##i==--_n6##i || _n4##i==--_n5##i || _n3##i==--_n4##i || _n2##i==--_n3##i || _n1##i==--_n2##i || \
 i==(_n9##i = _n8##i = _n7##i = _n6##i = _n5##i = _n4##i = _n3##i = _n2##i = --_n1##i)); \
 _p8##i = _p7##i, _p7##i = _p6##i, _p6##i = _p5##i, _p5##i = _p4##i, _p4##i = _p3##i, _p3##i = _p2##i, _p2##i = _p1##i, _p1##i = i++, \
 ++_n1##i, ++_n2##i, ++_n3##i, ++_n4##i, ++_n5##i, ++_n6##i, ++_n7##i, ++_n8##i, ++_n9##i)

#define cimg_for_in18X(img,x0,x1,x) cimg_for_in18((img)._width,x0,x1,x)
#define cimg_for_in18Y(img,y0,y1,y) cimg_for_in18((img)._height,y0,y1,y)
#define cimg_for_in18Z(img,z0,z1,z) cimg_for_in18((img)._depth,z0,z1,z)
#define cimg_for_in18C(img,c0,c1,c) cimg_for_in18((img)._spectrum,c0,c1,c)
#define cimg_for_in18XY(img,x0,y0,x1,y1,x,y) cimg_for_in18Y(img,y0,y1,y) cimg_for_in18X(img,x0,x1,x)
#define cimg_for_in18XZ(img,x0,z0,x1,z1,x,z) cimg_for_in18Z(img,z0,z1,z) cimg_for_in18X(img,x0,x1,x)
#define cimg_for_in18XC(img,x0,c0,x1,c1,x,c) cimg_for_in18C(img,c0,c1,c) cimg_for_in18X(img,x0,x1,x)
#define cimg_for_in18YZ(img,y0,z0,y1,z1,y,z) cimg_for_in18Z(img,z0,z1,z) cimg_for_in18Y(img,y0,y1,y)
#define cimg_for_in18YC(img,y0,c0,y1,c1,y,c) cimg_for_in18C(img,c0,c1,c) cimg_for_in18Y(img,y0,y1,y)
#define cimg_for_in18ZC(img,z0,c0,z1,c1,z,c) cimg_for_in18C(img,c0,c1,c) cimg_for_in18Z(img,z0,z1,z)
#define cimg_for_in18XYZ(img,x0,y0,z0,x1,y1,z1,x,y,z) cimg_for_in18Z(img,z0,z1,z) cimg_for_in18XY(img,x0,y0,x1,y1,x,y)
#define cimg_for_in18XZC(img,x0,z0,c0,x1,y1,c1,x,z,c) cimg_for_in18C(img,c0,c1,c) cimg_for_in18XZ(img,x0,y0,x1,y1,x,z)
#define cimg_for_in18YZC(img,y0,z0,c0,y1,z1,c1,y,z,c) cimg_for_in18C(img,c0,c1,c) cimg_for_in18YZ(img,y0,z0,y1,z1,y,z)
#define cimg_for_in18XYZC(img,x0,y0,z0,c0,x1,y1,z1,c1,x,y,z,c) cimg_for_in18C(img,c0,c1,c) cimg_for_in18XYZ(img,x0,y0,z0,x1,y1,z1,x,y,z)

#define cimg_for18x18(img,x,y,z,c,I,T) \
 cimg_for18((img)._height,y) for (int x = 0, \
 _p8##x = 0, _p7##x = 0, _p6##x = 0, _p5##x = 0, _p4##x = 0, _p3##x = 0, _p2##x = 0, _p1##x = 0, \
 _n1##x = 1>=((img)._width)?(img).width()-1:1, \
 _n2##x = 2>=((img)._width)?(img).width()-1:2, \
 _n3##x = 3>=((img)._width)?(img).width()-1:3, \
 _n4##x = 4>=((img)._width)?(img).width()-1:4, \
 _n5##x = 5>=((img)._width)?(img).width()-1:5, \
 _n6##x = 6>=((img)._width)?(img).width()-1:6, \
 _n7##x = 7>=((img)._width)?(img).width()-1:7, \
 _n8##x = 8>=((img)._width)?(img).width()-1:8, \
 _n9##x = (int)( \
 (I[0] = I[1] = I[2] = I[3] = I[4] = I[5] = I[6] = I[7] = I[8] = (T)(img)(0,_p8##y,z,c)), \
 (I[18] = I[19] = I[20] = I[21] = I[22] = I[23] = I[24] = I[25] = I[26] = (T)(img)(0,_p7##y,z,c)), \
 (I[36] = I[37] = I[38] = I[39] = I[40] = I[41] = I[42] = I[43] = I[44] = (T)(img)(0,_p6##y,z,c)), \
 (I[54] = I[55] = I[56] = I[57] = I[58] = I[59] = I[60] = I[61] = I[62] = (T)(img)(0,_p5##y,z,c)), \
 (I[72] = I[73] = I[74] = I[75] = I[76] = I[77] = I[78] = I[79] = I[80] = (T)(img)(0,_p4##y,z,c)), \
 (I[90] = I[91] = I[92] = I[93] = I[94] = I[95] = I[96] = I[97] = I[98] = (T)(img)(0,_p3##y,z,c)), \
 (I[108] = I[109] = I[110] = I[111] = I[112] = I[113] = I[114] = I[115] = I[116] = (T)(img)(0,_p2##y,z,c)), \
 (I[126] = I[127] = I[128] = I[129] = I[130] = I[131] = I[132] = I[133] = I[134] = (T)(img)(0,_p1##y,z,c)), \
 (I[144] = I[145] = I[146] = I[147] = I[148] = I[149] = I[150] = I[151] = I[152] = (T)(img)(0,y,z,c)), \
 (I[162] = I[163] = I[164] = I[165] = I[166] = I[167] = I[168] = I[169] = I[170] = (T)(img)(0,_n1##y,z,c)), \
 (I[180] = I[181] = I[182] = I[183] = I[184] = I[185] = I[186] = I[187] = I[188] = (T)(img)(0,_n2##y,z,c)), \
 (I[198] = I[199] = I[200] = I[201] = I[202] = I[203] = I[204] = I[205] = I[206] = (T)(img)(0,_n3##y,z,c)), \
 (I[216] = I[217] = I[218] = I[219] = I[220] = I[221] = I[222] = I[223] = I[224] = (T)(img)(0,_n4##y,z,c)), \
 (I[234] = I[235] = I[236] = I[237] = I[238] = I[239] = I[240] = I[241] = I[242] = (T)(img)(0,_n5##y,z,c)), \
 (I[252] = I[253] = I[254] = I[255] = I[256] = I[257] = I[258] = I[259] = I[260] = (T)(img)(0,_n6##y,z,c)), \
 (I[270] = I[271] = I[272] = I[273] = I[274] = I[275] = I[276] = I[277] = I[278] = (T)(img)(0,_n7##y,z,c)), \
 (I[288] = I[289] = I[290] = I[291] = I[292] = I[293] = I[294] = I[295] = I[296] = (T)(img)(0,_n8##y,z,c)), \
 (I[306] = I[307] = I[308] = I[309] = I[310] = I[311] = I[312] = I[313] = I[314] = (T)(img)(0,_n9##y,z,c)), \
 (I[9] = (T)(img)(_n1##x,_p8##y,z,c)), \
 (I[27] = (T)(img)(_n1##x,_p7##y,z,c)), \
 (I[45] = (T)(img)(_n1##x,_p6##y,z,c)), \
 (I[63] = (T)(img)(_n1##x,_p5##y,z,c)), \
 (I[81] = (T)(img)(_n1##x,_p4##y,z,c)), \
 (I[99] = (T)(img)(_n1##x,_p3##y,z,c)), \
 (I[117] = (T)(img)(_n1##x,_p2##y,z,c)), \
 (I[135] = (T)(img)(_n1##x,_p1##y,z,c)), \
 (I[153] = (T)(img)(_n1##x,y,z,c)), \
 (I[171] = (T)(img)(_n1##x,_n1##y,z,c)), \
 (I[189] = (T)(img)(_n1##x,_n2##y,z,c)), \
 (I[207] = (T)(img)(_n1##x,_n3##y,z,c)), \
 (I[225] = (T)(img)(_n1##x,_n4##y,z,c)), \
 (I[243] = (T)(img)(_n1##x,_n5##y,z,c)), \
 (I[261] = (T)(img)(_n1##x,_n6##y,z,c)), \
 (I[279] = (T)(img)(_n1##x,_n7##y,z,c)), \
 (I[297] = (T)(img)(_n1##x,_n8##y,z,c)), \
 (I[315] = (T)(img)(_n1##x,_n9##y,z,c)), \
 (I[10] = (T)(img)(_n2##x,_p8##y,z,c)), \
 (I[28] = (T)(img)(_n2##x,_p7##y,z,c)), \
 (I[46] = (T)(img)(_n2##x,_p6##y,z,c)), \
 (I[64] = (T)(img)(_n2##x,_p5##y,z,c)), \
 (I[82] = (T)(img)(_n2##x,_p4##y,z,c)), \
 (I[100] = (T)(img)(_n2##x,_p3##y,z,c)), \
 (I[118] = (T)(img)(_n2##x,_p2##y,z,c)), \
 (I[136] = (T)(img)(_n2##x,_p1##y,z,c)), \
 (I[154] = (T)(img)(_n2##x,y,z,c)), \
 (I[172] = (T)(img)(_n2##x,_n1##y,z,c)), \
 (I[190] = (T)(img)(_n2##x,_n2##y,z,c)), \
 (I[208] = (T)(img)(_n2##x,_n3##y,z,c)), \
 (I[226] = (T)(img)(_n2##x,_n4##y,z,c)), \
 (I[244] = (T)(img)(_n2##x,_n5##y,z,c)), \
 (I[262] = (T)(img)(_n2##x,_n6##y,z,c)), \
 (I[280] = (T)(img)(_n2##x,_n7##y,z,c)), \
 (I[298] = (T)(img)(_n2##x,_n8##y,z,c)), \
 (I[316] = (T)(img)(_n2##x,_n9##y,z,c)), \
 (I[11] = (T)(img)(_n3##x,_p8##y,z,c)), \
 (I[29] = (T)(img)(_n3##x,_p7##y,z,c)), \
 (I[47] = (T)(img)(_n3##x,_p6##y,z,c)), \
 (I[65] = (T)(img)(_n3##x,_p5##y,z,c)), \
 (I[83] = (T)(img)(_n3##x,_p4##y,z,c)), \
 (I[101] = (T)(img)(_n3##x,_p3##y,z,c)), \
 (I[119] = (T)(img)(_n3##x,_p2##y,z,c)), \
 (I[137] = (T)(img)(_n3##x,_p1##y,z,c)), \
 (I[155] = (T)(img)(_n3##x,y,z,c)), \
 (I[173] = (T)(img)(_n3##x,_n1##y,z,c)), \
 (I[191] = (T)(img)(_n3##x,_n2##y,z,c)), \
 (I[209] = (T)(img)(_n3##x,_n3##y,z,c)), \
 (I[227] = (T)(img)(_n3##x,_n4##y,z,c)), \
 (I[245] = (T)(img)(_n3##x,_n5##y,z,c)), \
 (I[263] = (T)(img)(_n3##x,_n6##y,z,c)), \
 (I[281] = (T)(img)(_n3##x,_n7##y,z,c)), \
 (I[299] = (T)(img)(_n3##x,_n8##y,z,c)), \
 (I[317] = (T)(img)(_n3##x,_n9##y,z,c)), \
 (I[12] = (T)(img)(_n4##x,_p8##y,z,c)), \
 (I[30] = (T)(img)(_n4##x,_p7##y,z,c)), \
 (I[48] = (T)(img)(_n4##x,_p6##y,z,c)), \
 (I[66] = (T)(img)(_n4##x,_p5##y,z,c)), \
 (I[84] = (T)(img)(_n4##x,_p4##y,z,c)), \
 (I[102] = (T)(img)(_n4##x,_p3##y,z,c)), \
 (I[120] = (T)(img)(_n4##x,_p2##y,z,c)), \
 (I[138] = (T)(img)(_n4##x,_p1##y,z,c)), \
 (I[156] = (T)(img)(_n4##x,y,z,c)), \
 (I[174] = (T)(img)(_n4##x,_n1##y,z,c)), \
 (I[192] = (T)(img)(_n4##x,_n2##y,z,c)), \
 (I[210] = (T)(img)(_n4##x,_n3##y,z,c)), \
 (I[228] = (T)(img)(_n4##x,_n4##y,z,c)), \
 (I[246] = (T)(img)(_n4##x,_n5##y,z,c)), \
 (I[264] = (T)(img)(_n4##x,_n6##y,z,c)), \
 (I[282] = (T)(img)(_n4##x,_n7##y,z,c)), \
 (I[300] = (T)(img)(_n4##x,_n8##y,z,c)), \
 (I[318] = (T)(img)(_n4##x,_n9##y,z,c)), \
 (I[13] = (T)(img)(_n5##x,_p8##y,z,c)), \
 (I[31] = (T)(img)(_n5##x,_p7##y,z,c)), \
 (I[49] = (T)(img)(_n5##x,_p6##y,z,c)), \
 (I[67] = (T)(img)(_n5##x,_p5##y,z,c)), \
 (I[85] = (T)(img)(_n5##x,_p4##y,z,c)), \
 (I[103] = (T)(img)(_n5##x,_p3##y,z,c)), \
 (I[121] = (T)(img)(_n5##x,_p2##y,z,c)), \
 (I[139] = (T)(img)(_n5##x,_p1##y,z,c)), \
 (I[157] = (T)(img)(_n5##x,y,z,c)), \
 (I[175] = (T)(img)(_n5##x,_n1##y,z,c)), \
 (I[193] = (T)(img)(_n5##x,_n2##y,z,c)), \
 (I[211] = (T)(img)(_n5##x,_n3##y,z,c)), \
 (I[229] = (T)(img)(_n5##x,_n4##y,z,c)), \
 (I[247] = (T)(img)(_n5##x,_n5##y,z,c)), \
 (I[265] = (T)(img)(_n5##x,_n6##y,z,c)), \
 (I[283] = (T)(img)(_n5##x,_n7##y,z,c)), \
 (I[301] = (T)(img)(_n5##x,_n8##y,z,c)), \
 (I[319] = (T)(img)(_n5##x,_n9##y,z,c)), \
 (I[14] = (T)(img)(_n6##x,_p8##y,z,c)), \
 (I[32] = (T)(img)(_n6##x,_p7##y,z,c)), \
 (I[50] = (T)(img)(_n6##x,_p6##y,z,c)), \
 (I[68] = (T)(img)(_n6##x,_p5##y,z,c)), \
 (I[86] = (T)(img)(_n6##x,_p4##y,z,c)), \
 (I[104] = (T)(img)(_n6##x,_p3##y,z,c)), \
 (I[122] = (T)(img)(_n6##x,_p2##y,z,c)), \
 (I[140] = (T)(img)(_n6##x,_p1##y,z,c)), \
 (I[158] = (T)(img)(_n6##x,y,z,c)), \
 (I[176] = (T)(img)(_n6##x,_n1##y,z,c)), \
 (I[194] = (T)(img)(_n6##x,_n2##y,z,c)), \
 (I[212] = (T)(img)(_n6##x,_n3##y,z,c)), \
 (I[230] = (T)(img)(_n6##x,_n4##y,z,c)), \
 (I[248] = (T)(img)(_n6##x,_n5##y,z,c)), \
 (I[266] = (T)(img)(_n6##x,_n6##y,z,c)), \
 (I[284] = (T)(img)(_n6##x,_n7##y,z,c)), \
 (I[302] = (T)(img)(_n6##x,_n8##y,z,c)), \
 (I[320] = (T)(img)(_n6##x,_n9##y,z,c)), \
 (I[15] = (T)(img)(_n7##x,_p8##y,z,c)), \
 (I[33] = (T)(img)(_n7##x,_p7##y,z,c)), \
 (I[51] = (T)(img)(_n7##x,_p6##y,z,c)), \
 (I[69] = (T)(img)(_n7##x,_p5##y,z,c)), \
 (I[87] = (T)(img)(_n7##x,_p4##y,z,c)), \
 (I[105] = (T)(img)(_n7##x,_p3##y,z,c)), \
 (I[123] = (T)(img)(_n7##x,_p2##y,z,c)), \
 (I[141] = (T)(img)(_n7##x,_p1##y,z,c)), \
 (I[159] = (T)(img)(_n7##x,y,z,c)), \
 (I[177] = (T)(img)(_n7##x,_n1##y,z,c)), \
 (I[195] = (T)(img)(_n7##x,_n2##y,z,c)), \
 (I[213] = (T)(img)(_n7##x,_n3##y,z,c)), \
 (I[231] = (T)(img)(_n7##x,_n4##y,z,c)), \
 (I[249] = (T)(img)(_n7##x,_n5##y,z,c)), \
 (I[267] = (T)(img)(_n7##x,_n6##y,z,c)), \
 (I[285] = (T)(img)(_n7##x,_n7##y,z,c)), \
 (I[303] = (T)(img)(_n7##x,_n8##y,z,c)), \
 (I[321] = (T)(img)(_n7##x,_n9##y,z,c)), \
 (I[16] = (T)(img)(_n8##x,_p8##y,z,c)), \
 (I[34] = (T)(img)(_n8##x,_p7##y,z,c)), \
 (I[52] = (T)(img)(_n8##x,_p6##y,z,c)), \
 (I[70] = (T)(img)(_n8##x,_p5##y,z,c)), \
 (I[88] = (T)(img)(_n8##x,_p4##y,z,c)), \
 (I[106] = (T)(img)(_n8##x,_p3##y,z,c)), \
 (I[124] = (T)(img)(_n8##x,_p2##y,z,c)), \
 (I[142] = (T)(img)(_n8##x,_p1##y,z,c)), \
 (I[160] = (T)(img)(_n8##x,y,z,c)), \
 (I[178] = (T)(img)(_n8##x,_n1##y,z,c)), \
 (I[196] = (T)(img)(_n8##x,_n2##y,z,c)), \
 (I[214] = (T)(img)(_n8##x,_n3##y,z,c)), \
 (I[232] = (T)(img)(_n8##x,_n4##y,z,c)), \
 (I[250] = (T)(img)(_n8##x,_n5##y,z,c)), \
 (I[268] = (T)(img)(_n8##x,_n6##y,z,c)), \
 (I[286] = (T)(img)(_n8##x,_n7##y,z,c)), \
 (I[304] = (T)(img)(_n8##x,_n8##y,z,c)), \
 (I[322] = (T)(img)(_n8##x,_n9##y,z,c)), \
 9>=((img)._width)?(img).width()-1:9); \
 (_n9##x<(img).width() && ( \
 (I[17] = (T)(img)(_n9##x,_p8##y,z,c)), \
 (I[35] = (T)(img)(_n9##x,_p7##y,z,c)), \
 (I[53] = (T)(img)(_n9##x,_p6##y,z,c)), \
 (I[71] = (T)(img)(_n9##x,_p5##y,z,c)), \
 (I[89] = (T)(img)(_n9##x,_p4##y,z,c)), \
 (I[107] = (T)(img)(_n9##x,_p3##y,z,c)), \
 (I[125] = (T)(img)(_n9##x,_p2##y,z,c)), \
 (I[143] = (T)(img)(_n9##x,_p1##y,z,c)), \
 (I[161] = (T)(img)(_n9##x,y,z,c)), \
 (I[179] = (T)(img)(_n9##x,_n1##y,z,c)), \
 (I[197] = (T)(img)(_n9##x,_n2##y,z,c)), \
 (I[215] = (T)(img)(_n9##x,_n3##y,z,c)), \
 (I[233] = (T)(img)(_n9##x,_n4##y,z,c)), \
 (I[251] = (T)(img)(_n9##x,_n5##y,z,c)), \
 (I[269] = (T)(img)(_n9##x,_n6##y,z,c)), \
 (I[287] = (T)(img)(_n9##x,_n7##y,z,c)), \
 (I[305] = (T)(img)(_n9##x,_n8##y,z,c)), \
 (I[323] = (T)(img)(_n9##x,_n9##y,z,c)),1)) || \
 _n8##x==--_n9##x || _n7##x==--_n8##x || _n6##x==--_n7##x || _n5##x==--_n6##x || _n4##x==--_n5##x || _n3##x==--_n4##x || _n2##x==--_n3##x || _n1##x==--_n2##x || x==(_n9##x = _n8##x = _n7##x = _n6##x = _n5##x = _n4##x = _n3##x = _n2##x = --_n1##x); \
 I[0] = I[1], I[1] = I[2], I[2] = I[3], I[3] = I[4], I[4] = I[5], I[5] = I[6], I[6] = I[7], I[7] = I[8], I[8] = I[9], I[9] = I[10], I[10] = I[11], I[11] = I[12], I[12] = I[13], I[13] = I[14], I[14] = I[15], I[15] = I[16], I[16] = I[17], \
 I[18] = I[19], I[19] = I[20], I[20] = I[21], I[21] = I[22], I[22] = I[23], I[23] = I[24], I[24] = I[25], I[25] = I[26], I[26] = I[27], I[27] = I[28], I[28] = I[29], I[29] = I[30], I[30] = I[31], I[31] = I[32], I[32] = I[33], I[33] = I[34], I[34] = I[35], \
 I[36] = I[37], I[37] = I[38], I[38] = I[39], I[39] = I[40], I[40] = I[41], I[41] = I[42], I[42] = I[43], I[43] = I[44], I[44] = I[45], I[45] = I[46], I[46] = I[47], I[47] = I[48], I[48] = I[49], I[49] = I[50], I[50] = I[51], I[51] = I[52], I[52] = I[53], \
 I[54] = I[55], I[55] = I[56], I[56] = I[57], I[57] = I[58], I[58] = I[59], I[59] = I[60], I[60] = I[61], I[61] = I[62], I[62] = I[63], I[63] = I[64], I[64] = I[65], I[65] = I[66], I[66] = I[67], I[67] = I[68], I[68] = I[69], I[69] = I[70], I[70] = I[71], \
 I[72] = I[73], I[73] = I[74], I[74] = I[75], I[75] = I[76], I[76] = I[77], I[77] = I[78], I[78] = I[79], I[79] = I[80], I[80] = I[81], I[81] = I[82], I[82] = I[83], I[83] = I[84], I[84] = I[85], I[85] = I[86], I[86] = I[87], I[87] = I[88], I[88] = I[89], \
 I[90] = I[91], I[91] = I[92], I[92] = I[93], I[93] = I[94], I[94] = I[95], I[95] = I[96], I[96] = I[97], I[97] = I[98], I[98] = I[99], I[99] = I[100], I[100] = I[101], I[101] = I[102], I[102] = I[103], I[103] = I[104], I[104] = I[105], I[105] = I[106], I[106] = I[107], \
 I[108] = I[109], I[109] = I[110], I[110] = I[111], I[111] = I[112], I[112] = I[113], I[113] = I[114], I[114] = I[115], I[115] = I[116], I[116] = I[117], I[117] = I[118], I[118] = I[119], I[119] = I[120], I[120] = I[121], I[121] = I[122], I[122] = I[123], I[123] = I[124], I[124] = I[125], \
 I[126] = I[127], I[127] = I[128], I[128] = I[129], I[129] = I[130], I[130] = I[131], I[131] = I[132], I[132] = I[133], I[133] = I[134], I[134] = I[135], I[135] = I[136], I[136] = I[137], I[137] = I[138], I[138] = I[139], I[139] = I[140], I[140] = I[141], I[141] = I[142], I[142] = I[143], \
 I[144] = I[145], I[145] = I[146], I[146] = I[147], I[147] = I[148], I[148] = I[149], I[149] = I[150], I[150] = I[151], I[151] = I[152], I[152] = I[153], I[153] = I[154], I[154] = I[155], I[155] = I[156], I[156] = I[157], I[157] = I[158], I[158] = I[159], I[159] = I[160], I[160] = I[161], \
 I[162] = I[163], I[163] = I[164], I[164] = I[165], I[165] = I[166], I[166] = I[167], I[167] = I[168], I[168] = I[169], I[169] = I[170], I[170] = I[171], I[171] = I[172], I[172] = I[173], I[173] = I[174], I[174] = I[175], I[175] = I[176], I[176] = I[177], I[177] = I[178], I[178] = I[179], \
 I[180] = I[181], I[181] = I[182], I[182] = I[183], I[183] = I[184], I[184] = I[185], I[185] = I[186], I[186] = I[187], I[187] = I[188], I[188] = I[189], I[189] = I[190], I[190] = I[191], I[191] = I[192], I[192] = I[193], I[193] = I[194], I[194] = I[195], I[195] = I[196], I[196] = I[197], \
 I[198] = I[199], I[199] = I[200], I[200] = I[201], I[201] = I[202], I[202] = I[203], I[203] = I[204], I[204] = I[205], I[205] = I[206], I[206] = I[207], I[207] = I[208], I[208] = I[209], I[209] = I[210], I[210] = I[211], I[211] = I[212], I[212] = I[213], I[213] = I[214], I[214] = I[215], \
 I[216] = I[217], I[217] = I[218], I[218] = I[219], I[219] = I[220], I[220] = I[221], I[221] = I[222], I[222] = I[223], I[223] = I[224], I[224] = I[225], I[225] = I[226], I[226] = I[227], I[227] = I[228], I[228] = I[229], I[229] = I[230], I[230] = I[231], I[231] = I[232], I[232] = I[233], \
 I[234] = I[235], I[235] = I[236], I[236] = I[237], I[237] = I[238], I[238] = I[239], I[239] = I[240], I[240] = I[241], I[241] = I[242], I[242] = I[243], I[243] = I[244], I[244] = I[245], I[245] = I[246], I[246] = I[247], I[247] = I[248], I[248] = I[249], I[249] = I[250], I[250] = I[251], \
 I[252] = I[253], I[253] = I[254], I[254] = I[255], I[255] = I[256], I[256] = I[257], I[257] = I[258], I[258] = I[259], I[259] = I[260], I[260] = I[261], I[261] = I[262], I[262] = I[263], I[263] = I[264], I[264] = I[265], I[265] = I[266], I[266] = I[267], I[267] = I[268], I[268] = I[269], \
 I[270] = I[271], I[271] = I[272], I[272] = I[273], I[273] = I[274], I[274] = I[275], I[275] = I[276], I[276] = I[277], I[277] = I[278], I[278] = I[279], I[279] = I[280], I[280] = I[281], I[281] = I[282], I[282] = I[283], I[283] = I[284], I[284] = I[285], I[285] = I[286], I[286] = I[287], \
 I[288] = I[289], I[289] = I[290], I[290] = I[291], I[291] = I[292], I[292] = I[293], I[293] = I[294], I[294] = I[295], I[295] = I[296], I[296] = I[297], I[297] = I[298], I[298] = I[299], I[299] = I[300], I[300] = I[301], I[301] = I[302], I[302] = I[303], I[303] = I[304], I[304] = I[305], \
 I[306] = I[307], I[307] = I[308], I[308] = I[309], I[309] = I[310], I[310] = I[311], I[311] = I[312], I[312] = I[313], I[313] = I[314], I[314] = I[315], I[315] = I[316], I[316] = I[317], I[317] = I[318], I[318] = I[319], I[319] = I[320], I[320] = I[321], I[321] = I[322], I[322] = I[323], \
 _p8##x = _p7##x, _p7##x = _p6##x, _p6##x = _p5##x, _p5##x = _p4##x, _p4##x = _p3##x, _p3##x = _p2##x, _p2##x = _p1##x, _p1##x = x++, ++_n1##x, ++_n2##x, ++_n3##x, ++_n4##x, ++_n5##x, ++_n6##x, ++_n7##x, ++_n8##x, ++_n9##x)

#define cimg_for_in18x18(img,x0,y0,x1,y1,x,y,z,c,I,T) \
 cimg_for_in18((img)._height,y0,y1,y) for (int x = (int)(x0)<0?0:(int)(x0), \
 _p8##x = x-8<0?0:x-8, \
 _p7##x = x-7<0?0:x-7, \
 _p6##x = x-6<0?0:x-6, \
 _p5##x = x-5<0?0:x-5, \
 _p4##x = x-4<0?0:x-4, \
 _p3##x = x-3<0?0:x-3, \
 _p2##x = x-2<0?0:x-2, \
 _p1##x = x-1<0?0:x-1, \
 _n1##x = x+1>=(img).width()?(img).width()-1:x+1, \
 _n2##x = x+2>=(img).width()?(img).width()-1:x+2, \
 _n3##x = x+3>=(img).width()?(img).width()-1:x+3, \
 _n4##x = x+4>=(img).width()?(img).width()-1:x+4, \
 _n5##x = x+5>=(img).width()?(img).width()-1:x+5, \
 _n6##x = x+6>=(img).width()?(img).width()-1:x+6, \
 _n7##x = x+7>=(img).width()?(img).width()-1:x+7, \
 _n8##x = x+8>=(img).width()?(img).width()-1:x+8, \
 _n9##x = (int)( \
 (I[0] = (T)(img)(_p8##x,_p8##y,z,c)), \
 (I[18] = (T)(img)(_p8##x,_p7##y,z,c)), \
 (I[36] = (T)(img)(_p8##x,_p6##y,z,c)), \
 (I[54] = (T)(img)(_p8##x,_p5##y,z,c)), \
 (I[72] = (T)(img)(_p8##x,_p4##y,z,c)), \
 (I[90] = (T)(img)(_p8##x,_p3##y,z,c)), \
 (I[108] = (T)(img)(_p8##x,_p2##y,z,c)), \
 (I[126] = (T)(img)(_p8##x,_p1##y,z,c)), \
 (I[144] = (T)(img)(_p8##x,y,z,c)), \
 (I[162] = (T)(img)(_p8##x,_n1##y,z,c)), \
 (I[180] = (T)(img)(_p8##x,_n2##y,z,c)), \
 (I[198] = (T)(img)(_p8##x,_n3##y,z,c)), \
 (I[216] = (T)(img)(_p8##x,_n4##y,z,c)), \
 (I[234] = (T)(img)(_p8##x,_n5##y,z,c)), \
 (I[252] = (T)(img)(_p8##x,_n6##y,z,c)), \
 (I[270] = (T)(img)(_p8##x,_n7##y,z,c)), \
 (I[288] = (T)(img)(_p8##x,_n8##y,z,c)), \
 (I[306] = (T)(img)(_p8##x,_n9##y,z,c)), \
 (I[1] = (T)(img)(_p7##x,_p8##y,z,c)), \
 (I[19] = (T)(img)(_p7##x,_p7##y,z,c)), \
 (I[37] = (T)(img)(_p7##x,_p6##y,z,c)), \
 (I[55] = (T)(img)(_p7##x,_p5##y,z,c)), \
 (I[73] = (T)(img)(_p7##x,_p4##y,z,c)), \
 (I[91] = (T)(img)(_p7##x,_p3##y,z,c)), \
 (I[109] = (T)(img)(_p7##x,_p2##y,z,c)), \
 (I[127] = (T)(img)(_p7##x,_p1##y,z,c)), \
 (I[145] = (T)(img)(_p7##x,y,z,c)), \
 (I[163] = (T)(img)(_p7##x,_n1##y,z,c)), \
 (I[181] = (T)(img)(_p7##x,_n2##y,z,c)), \
 (I[199] = (T)(img)(_p7##x,_n3##y,z,c)), \
 (I[217] = (T)(img)(_p7##x,_n4##y,z,c)), \
 (I[235] = (T)(img)(_p7##x,_n5##y,z,c)), \
 (I[253] = (T)(img)(_p7##x,_n6##y,z,c)), \
 (I[271] = (T)(img)(_p7##x,_n7##y,z,c)), \
 (I[289] = (T)(img)(_p7##x,_n8##y,z,c)), \
 (I[307] = (T)(img)(_p7##x,_n9##y,z,c)), \
 (I[2] = (T)(img)(_p6##x,_p8##y,z,c)), \
 (I[20] = (T)(img)(_p6##x,_p7##y,z,c)), \
 (I[38] = (T)(img)(_p6##x,_p6##y,z,c)), \
 (I[56] = (T)(img)(_p6##x,_p5##y,z,c)), \
 (I[74] = (T)(img)(_p6##x,_p4##y,z,c)), \
 (I[92] = (T)(img)(_p6##x,_p3##y,z,c)), \
 (I[110] = (T)(img)(_p6##x,_p2##y,z,c)), \
 (I[128] = (T)(img)(_p6##x,_p1##y,z,c)), \
 (I[146] = (T)(img)(_p6##x,y,z,c)), \
 (I[164] = (T)(img)(_p6##x,_n1##y,z,c)), \
 (I[182] = (T)(img)(_p6##x,_n2##y,z,c)), \
 (I[200] = (T)(img)(_p6##x,_n3##y,z,c)), \
 (I[218] = (T)(img)(_p6##x,_n4##y,z,c)), \
 (I[236] = (T)(img)(_p6##x,_n5##y,z,c)), \
 (I[254] = (T)(img)(_p6##x,_n6##y,z,c)), \
 (I[272] = (T)(img)(_p6##x,_n7##y,z,c)), \
 (I[290] = (T)(img)(_p6##x,_n8##y,z,c)), \
 (I[308] = (T)(img)(_p6##x,_n9##y,z,c)), \
 (I[3] = (T)(img)(_p5##x,_p8##y,z,c)), \
 (I[21] = (T)(img)(_p5##x,_p7##y,z,c)), \
 (I[39] = (T)(img)(_p5##x,_p6##y,z,c)), \
 (I[57] = (T)(img)(_p5##x,_p5##y,z,c)), \
 (I[75] = (T)(img)(_p5##x,_p4##y,z,c)), \
 (I[93] = (T)(img)(_p5##x,_p3##y,z,c)), \
 (I[111] = (T)(img)(_p5##x,_p2##y,z,c)), \
 (I[129] = (T)(img)(_p5##x,_p1##y,z,c)), \
 (I[147] = (T)(img)(_p5##x,y,z,c)), \
 (I[165] = (T)(img)(_p5##x,_n1##y,z,c)), \
 (I[183] = (T)(img)(_p5##x,_n2##y,z,c)), \
 (I[201] = (T)(img)(_p5##x,_n3##y,z,c)), \
 (I[219] = (T)(img)(_p5##x,_n4##y,z,c)), \
 (I[237] = (T)(img)(_p5##x,_n5##y,z,c)), \
 (I[255] = (T)(img)(_p5##x,_n6##y,z,c)), \
 (I[273] = (T)(img)(_p5##x,_n7##y,z,c)), \
 (I[291] = (T)(img)(_p5##x,_n8##y,z,c)), \
 (I[309] = (T)(img)(_p5##x,_n9##y,z,c)), \
 (I[4] = (T)(img)(_p4##x,_p8##y,z,c)), \
 (I[22] = (T)(img)(_p4##x,_p7##y,z,c)), \
 (I[40] = (T)(img)(_p4##x,_p6##y,z,c)), \
 (I[58] = (T)(img)(_p4##x,_p5##y,z,c)), \
 (I[76] = (T)(img)(_p4##x,_p4##y,z,c)), \
 (I[94] = (T)(img)(_p4##x,_p3##y,z,c)), \
 (I[112] = (T)(img)(_p4##x,_p2##y,z,c)), \
 (I[130] = (T)(img)(_p4##x,_p1##y,z,c)), \
 (I[148] = (T)(img)(_p4##x,y,z,c)), \
 (I[166] = (T)(img)(_p4##x,_n1##y,z,c)), \
 (I[184] = (T)(img)(_p4##x,_n2##y,z,c)), \
 (I[202] = (T)(img)(_p4##x,_n3##y,z,c)), \
 (I[220] = (T)(img)(_p4##x,_n4##y,z,c)), \
 (I[238] = (T)(img)(_p4##x,_n5##y,z,c)), \
 (I[256] = (T)(img)(_p4##x,_n6##y,z,c)), \
 (I[274] = (T)(img)(_p4##x,_n7##y,z,c)), \
 (I[292] = (T)(img)(_p4##x,_n8##y,z,c)), \
 (I[310] = (T)(img)(_p4##x,_n9##y,z,c)), \
 (I[5] = (T)(img)(_p3##x,_p8##y,z,c)), \
 (I[23] = (T)(img)(_p3##x,_p7##y,z,c)), \
 (I[41] = (T)(img)(_p3##x,_p6##y,z,c)), \
 (I[59] = (T)(img)(_p3##x,_p5##y,z,c)), \
 (I[77] = (T)(img)(_p3##x,_p4##y,z,c)), \
 (I[95] = (T)(img)(_p3##x,_p3##y,z,c)), \
 (I[113] = (T)(img)(_p3##x,_p2##y,z,c)), \
 (I[131] = (T)(img)(_p3##x,_p1##y,z,c)), \
 (I[149] = (T)(img)(_p3##x,y,z,c)), \
 (I[167] = (T)(img)(_p3##x,_n1##y,z,c)), \
 (I[185] = (T)(img)(_p3##x,_n2##y,z,c)), \
 (I[203] = (T)(img)(_p3##x,_n3##y,z,c)), \
 (I[221] = (T)(img)(_p3##x,_n4##y,z,c)), \
 (I[239] = (T)(img)(_p3##x,_n5##y,z,c)), \
 (I[257] = (T)(img)(_p3##x,_n6##y,z,c)), \
 (I[275] = (T)(img)(_p3##x,_n7##y,z,c)), \
 (I[293] = (T)(img)(_p3##x,_n8##y,z,c)), \
 (I[311] = (T)(img)(_p3##x,_n9##y,z,c)), \
 (I[6] = (T)(img)(_p2##x,_p8##y,z,c)), \
 (I[24] = (T)(img)(_p2##x,_p7##y,z,c)), \
 (I[42] = (T)(img)(_p2##x,_p6##y,z,c)), \
 (I[60] = (T)(img)(_p2##x,_p5##y,z,c)), \
 (I[78] = (T)(img)(_p2##x,_p4##y,z,c)), \
 (I[96] = (T)(img)(_p2##x,_p3##y,z,c)), \
 (I[114] = (T)(img)(_p2##x,_p2##y,z,c)), \
 (I[132] = (T)(img)(_p2##x,_p1##y,z,c)), \
 (I[150] = (T)(img)(_p2##x,y,z,c)), \
 (I[168] = (T)(img)(_p2##x,_n1##y,z,c)), \
 (I[186] = (T)(img)(_p2##x,_n2##y,z,c)), \
 (I[204] = (T)(img)(_p2##x,_n3##y,z,c)), \
 (I[222] = (T)(img)(_p2##x,_n4##y,z,c)), \
 (I[240] = (T)(img)(_p2##x,_n5##y,z,c)), \
 (I[258] = (T)(img)(_p2##x,_n6##y,z,c)), \
 (I[276] = (T)(img)(_p2##x,_n7##y,z,c)), \
 (I[294] = (T)(img)(_p2##x,_n8##y,z,c)), \
 (I[312] = (T)(img)(_p2##x,_n9##y,z,c)), \
 (I[7] = (T)(img)(_p1##x,_p8##y,z,c)), \
 (I[25] = (T)(img)(_p1##x,_p7##y,z,c)), \
 (I[43] = (T)(img)(_p1##x,_p6##y,z,c)), \
 (I[61] = (T)(img)(_p1##x,_p5##y,z,c)), \
 (I[79] = (T)(img)(_p1##x,_p4##y,z,c)), \
 (I[97] = (T)(img)(_p1##x,_p3##y,z,c)), \
 (I[115] = (T)(img)(_p1##x,_p2##y,z,c)), \
 (I[133] = (T)(img)(_p1##x,_p1##y,z,c)), \
 (I[151] = (T)(img)(_p1##x,y,z,c)), \
 (I[169] = (T)(img)(_p1##x,_n1##y,z,c)), \
 (I[187] = (T)(img)(_p1##x,_n2##y,z,c)), \
 (I[205] = (T)(img)(_p1##x,_n3##y,z,c)), \
 (I[223] = (T)(img)(_p1##x,_n4##y,z,c)), \
 (I[241] = (T)(img)(_p1##x,_n5##y,z,c)), \
 (I[259] = (T)(img)(_p1##x,_n6##y,z,c)), \
 (I[277] = (T)(img)(_p1##x,_n7##y,z,c)), \
 (I[295] = (T)(img)(_p1##x,_n8##y,z,c)), \
 (I[313] = (T)(img)(_p1##x,_n9##y,z,c)), \
 (I[8] = (T)(img)(x,_p8##y,z,c)), \
 (I[26] = (T)(img)(x,_p7##y,z,c)), \
 (I[44] = (T)(img)(x,_p6##y,z,c)), \
 (I[62] = (T)(img)(x,_p5##y,z,c)), \
 (I[80] = (T)(img)(x,_p4##y,z,c)), \
 (I[98] = (T)(img)(x,_p3##y,z,c)), \
 (I[116] = (T)(img)(x,_p2##y,z,c)), \
 (I[134] = (T)(img)(x,_p1##y,z,c)), \
 (I[152] = (T)(img)(x,y,z,c)), \
 (I[170] = (T)(img)(x,_n1##y,z,c)), \
 (I[188] = (T)(img)(x,_n2##y,z,c)), \
 (I[206] = (T)(img)(x,_n3##y,z,c)), \
 (I[224] = (T)(img)(x,_n4##y,z,c)), \
 (I[242] = (T)(img)(x,_n5##y,z,c)), \
 (I[260] = (T)(img)(x,_n6##y,z,c)), \
 (I[278] = (T)(img)(x,_n7##y,z,c)), \
 (I[296] = (T)(img)(x,_n8##y,z,c)), \
 (I[314] = (T)(img)(x,_n9##y,z,c)), \
 (I[9] = (T)(img)(_n1##x,_p8##y,z,c)), \
 (I[27] = (T)(img)(_n1##x,_p7##y,z,c)), \
 (I[45] = (T)(img)(_n1##x,_p6##y,z,c)), \
 (I[63] = (T)(img)(_n1##x,_p5##y,z,c)), \
 (I[81] = (T)(img)(_n1##x,_p4##y,z,c)), \
 (I[99] = (T)(img)(_n1##x,_p3##y,z,c)), \
 (I[117] = (T)(img)(_n1##x,_p2##y,z,c)), \
 (I[135] = (T)(img)(_n1##x,_p1##y,z,c)), \
 (I[153] = (T)(img)(_n1##x,y,z,c)), \
 (I[171] = (T)(img)(_n1##x,_n1##y,z,c)), \
 (I[189] = (T)(img)(_n1##x,_n2##y,z,c)), \
 (I[207] = (T)(img)(_n1##x,_n3##y,z,c)), \
 (I[225] = (T)(img)(_n1##x,_n4##y,z,c)), \
 (I[243] = (T)(img)(_n1##x,_n5##y,z,c)), \
 (I[261] = (T)(img)(_n1##x,_n6##y,z,c)), \
 (I[279] = (T)(img)(_n1##x,_n7##y,z,c)), \
 (I[297] = (T)(img)(_n1##x,_n8##y,z,c)), \
 (I[315] = (T)(img)(_n1##x,_n9##y,z,c)), \
 (I[10] = (T)(img)(_n2##x,_p8##y,z,c)), \
 (I[28] = (T)(img)(_n2##x,_p7##y,z,c)), \
 (I[46] = (T)(img)(_n2##x,_p6##y,z,c)), \
 (I[64] = (T)(img)(_n2##x,_p5##y,z,c)), \
 (I[82] = (T)(img)(_n2##x,_p4##y,z,c)), \
 (I[100] = (T)(img)(_n2##x,_p3##y,z,c)), \
 (I[118] = (T)(img)(_n2##x,_p2##y,z,c)), \
 (I[136] = (T)(img)(_n2##x,_p1##y,z,c)), \
 (I[154] = (T)(img)(_n2##x,y,z,c)), \
 (I[172] = (T)(img)(_n2##x,_n1##y,z,c)), \
 (I[190] = (T)(img)(_n2##x,_n2##y,z,c)), \
 (I[208] = (T)(img)(_n2##x,_n3##y,z,c)), \
 (I[226] = (T)(img)(_n2##x,_n4##y,z,c)), \
 (I[244] = (T)(img)(_n2##x,_n5##y,z,c)), \
 (I[262] = (T)(img)(_n2##x,_n6##y,z,c)), \
 (I[280] = (T)(img)(_n2##x,_n7##y,z,c)), \
 (I[298] = (T)(img)(_n2##x,_n8##y,z,c)), \
 (I[316] = (T)(img)(_n2##x,_n9##y,z,c)), \
 (I[11] = (T)(img)(_n3##x,_p8##y,z,c)), \
 (I[29] = (T)(img)(_n3##x,_p7##y,z,c)), \
 (I[47] = (T)(img)(_n3##x,_p6##y,z,c)), \
 (I[65] = (T)(img)(_n3##x,_p5##y,z,c)), \
 (I[83] = (T)(img)(_n3##x,_p4##y,z,c)), \
 (I[101] = (T)(img)(_n3##x,_p3##y,z,c)), \
 (I[119] = (T)(img)(_n3##x,_p2##y,z,c)), \
 (I[137] = (T)(img)(_n3##x,_p1##y,z,c)), \
 (I[155] = (T)(img)(_n3##x,y,z,c)), \
 (I[173] = (T)(img)(_n3##x,_n1##y,z,c)), \
 (I[191] = (T)(img)(_n3##x,_n2##y,z,c)), \
 (I[209] = (T)(img)(_n3##x,_n3##y,z,c)), \
 (I[227] = (T)(img)(_n3##x,_n4##y,z,c)), \
 (I[245] = (T)(img)(_n3##x,_n5##y,z,c)), \
 (I[263] = (T)(img)(_n3##x,_n6##y,z,c)), \
 (I[281] = (T)(img)(_n3##x,_n7##y,z,c)), \
 (I[299] = (T)(img)(_n3##x,_n8##y,z,c)), \
 (I[317] = (T)(img)(_n3##x,_n9##y,z,c)), \
 (I[12] = (T)(img)(_n4##x,_p8##y,z,c)), \
 (I[30] = (T)(img)(_n4##x,_p7##y,z,c)), \
 (I[48] = (T)(img)(_n4##x,_p6##y,z,c)), \
 (I[66] = (T)(img)(_n4##x,_p5##y,z,c)), \
 (I[84] = (T)(img)(_n4##x,_p4##y,z,c)), \
 (I[102] = (T)(img)(_n4##x,_p3##y,z,c)), \
 (I[120] = (T)(img)(_n4##x,_p2##y,z,c)), \
 (I[138] = (T)(img)(_n4##x,_p1##y,z,c)), \
 (I[156] = (T)(img)(_n4##x,y,z,c)), \
 (I[174] = (T)(img)(_n4##x,_n1##y,z,c)), \
 (I[192] = (T)(img)(_n4##x,_n2##y,z,c)), \
 (I[210] = (T)(img)(_n4##x,_n3##y,z,c)), \
 (I[228] = (T)(img)(_n4##x,_n4##y,z,c)), \
 (I[246] = (T)(img)(_n4##x,_n5##y,z,c)), \
 (I[264] = (T)(img)(_n4##x,_n6##y,z,c)), \
 (I[282] = (T)(img)(_n4##x,_n7##y,z,c)), \
 (I[300] = (T)(img)(_n4##x,_n8##y,z,c)), \
 (I[318] = (T)(img)(_n4##x,_n9##y,z,c)), \
 (I[13] = (T)(img)(_n5##x,_p8##y,z,c)), \
 (I[31] = (T)(img)(_n5##x,_p7##y,z,c)), \
 (I[49] = (T)(img)(_n5##x,_p6##y,z,c)), \
 (I[67] = (T)(img)(_n5##x,_p5##y,z,c)), \
 (I[85] = (T)(img)(_n5##x,_p4##y,z,c)), \
 (I[103] = (T)(img)(_n5##x,_p3##y,z,c)), \
 (I[121] = (T)(img)(_n5##x,_p2##y,z,c)), \
 (I[139] = (T)(img)(_n5##x,_p1##y,z,c)), \
 (I[157] = (T)(img)(_n5##x,y,z,c)), \
 (I[175] = (T)(img)(_n5##x,_n1##y,z,c)), \
 (I[193] = (T)(img)(_n5##x,_n2##y,z,c)), \
 (I[211] = (T)(img)(_n5##x,_n3##y,z,c)), \
 (I[229] = (T)(img)(_n5##x,_n4##y,z,c)), \
 (I[247] = (T)(img)(_n5##x,_n5##y,z,c)), \
 (I[265] = (T)(img)(_n5##x,_n6##y,z,c)), \
 (I[283] = (T)(img)(_n5##x,_n7##y,z,c)), \
 (I[301] = (T)(img)(_n5##x,_n8##y,z,c)), \
 (I[319] = (T)(img)(_n5##x,_n9##y,z,c)), \
 (I[14] = (T)(img)(_n6##x,_p8##y,z,c)), \
 (I[32] = (T)(img)(_n6##x,_p7##y,z,c)), \
 (I[50] = (T)(img)(_n6##x,_p6##y,z,c)), \
 (I[68] = (T)(img)(_n6##x,_p5##y,z,c)), \
 (I[86] = (T)(img)(_n6##x,_p4##y,z,c)), \
 (I[104] = (T)(img)(_n6##x,_p3##y,z,c)), \
 (I[122] = (T)(img)(_n6##x,_p2##y,z,c)), \
 (I[140] = (T)(img)(_n6##x,_p1##y,z,c)), \
 (I[158] = (T)(img)(_n6##x,y,z,c)), \
 (I[176] = (T)(img)(_n6##x,_n1##y,z,c)), \
 (I[194] = (T)(img)(_n6##x,_n2##y,z,c)), \
 (I[212] = (T)(img)(_n6##x,_n3##y,z,c)), \
 (I[230] = (T)(img)(_n6##x,_n4##y,z,c)), \
 (I[248] = (T)(img)(_n6##x,_n5##y,z,c)), \
 (I[266] = (T)(img)(_n6##x,_n6##y,z,c)), \
 (I[284] = (T)(img)(_n6##x,_n7##y,z,c)), \
 (I[302] = (T)(img)(_n6##x,_n8##y,z,c)), \
 (I[320] = (T)(img)(_n6##x,_n9##y,z,c)), \
 (I[15] = (T)(img)(_n7##x,_p8##y,z,c)), \
 (I[33] = (T)(img)(_n7##x,_p7##y,z,c)), \
 (I[51] = (T)(img)(_n7##x,_p6##y,z,c)), \
 (I[69] = (T)(img)(_n7##x,_p5##y,z,c)), \
 (I[87] = (T)(img)(_n7##x,_p4##y,z,c)), \
 (I[105] = (T)(img)(_n7##x,_p3##y,z,c)), \
 (I[123] = (T)(img)(_n7##x,_p2##y,z,c)), \
 (I[141] = (T)(img)(_n7##x,_p1##y,z,c)), \
 (I[159] = (T)(img)(_n7##x,y,z,c)), \
 (I[177] = (T)(img)(_n7##x,_n1##y,z,c)), \
 (I[195] = (T)(img)(_n7##x,_n2##y,z,c)), \
 (I[213] = (T)(img)(_n7##x,_n3##y,z,c)), \
 (I[231] = (T)(img)(_n7##x,_n4##y,z,c)), \
 (I[249] = (T)(img)(_n7##x,_n5##y,z,c)), \
 (I[267] = (T)(img)(_n7##x,_n6##y,z,c)), \
 (I[285] = (T)(img)(_n7##x,_n7##y,z,c)), \
 (I[303] = (T)(img)(_n7##x,_n8##y,z,c)), \
 (I[321] = (T)(img)(_n7##x,_n9##y,z,c)), \
 (I[16] = (T)(img)(_n8##x,_p8##y,z,c)), \
 (I[34] = (T)(img)(_n8##x,_p7##y,z,c)), \
 (I[52] = (T)(img)(_n8##x,_p6##y,z,c)), \
 (I[70] = (T)(img)(_n8##x,_p5##y,z,c)), \
 (I[88] = (T)(img)(_n8##x,_p4##y,z,c)), \
 (I[106] = (T)(img)(_n8##x,_p3##y,z,c)), \
 (I[124] = (T)(img)(_n8##x,_p2##y,z,c)), \
 (I[142] = (T)(img)(_n8##x,_p1##y,z,c)), \
 (I[160] = (T)(img)(_n8##x,y,z,c)), \
 (I[178] = (T)(img)(_n8##x,_n1##y,z,c)), \
 (I[196] = (T)(img)(_n8##x,_n2##y,z,c)), \
 (I[214] = (T)(img)(_n8##x,_n3##y,z,c)), \
 (I[232] = (T)(img)(_n8##x,_n4##y,z,c)), \
 (I[250] = (T)(img)(_n8##x,_n5##y,z,c)), \
 (I[268] = (T)(img)(_n8##x,_n6##y,z,c)), \
 (I[286] = (T)(img)(_n8##x,_n7##y,z,c)), \
 (I[304] = (T)(img)(_n8##x,_n8##y,z,c)), \
 (I[322] = (T)(img)(_n8##x,_n9##y,z,c)), \
 x+9>=(img).width()?(img).width()-1:x+9); \
 x<=(int)(x1) && ((_n9##x<(img).width() && ( \
 (I[17] = (T)(img)(_n9##x,_p8##y,z,c)), \
 (I[35] = (T)(img)(_n9##x,_p7##y,z,c)), \
 (I[53] = (T)(img)(_n9##x,_p6##y,z,c)), \
 (I[71] = (T)(img)(_n9##x,_p5##y,z,c)), \
 (I[89] = (T)(img)(_n9##x,_p4##y,z,c)), \
 (I[107] = (T)(img)(_n9##x,_p3##y,z,c)), \
 (I[125] = (T)(img)(_n9##x,_p2##y,z,c)), \
 (I[143] = (T)(img)(_n9##x,_p1##y,z,c)), \
 (I[161] = (T)(img)(_n9##x,y,z,c)), \
 (I[179] = (T)(img)(_n9##x,_n1##y,z,c)), \
 (I[197] = (T)(img)(_n9##x,_n2##y,z,c)), \
 (I[215] = (T)(img)(_n9##x,_n3##y,z,c)), \
 (I[233] = (T)(img)(_n9##x,_n4##y,z,c)), \
 (I[251] = (T)(img)(_n9##x,_n5##y,z,c)), \
 (I[269] = (T)(img)(_n9##x,_n6##y,z,c)), \
 (I[287] = (T)(img)(_n9##x,_n7##y,z,c)), \
 (I[305] = (T)(img)(_n9##x,_n8##y,z,c)), \
 (I[323] = (T)(img)(_n9##x,_n9##y,z,c)),1)) || \
 _n8##x==--_n9##x || _n7##x==--_n8##x || _n6##x==--_n7##x || _n5##x==--_n6##x || _n4##x==--_n5##x || _n3##x==--_n4##x || _n2##x==--_n3##x || _n1##x==--_n2##x || x==(_n9##x = _n8##x = _n7##x = _n6##x = _n5##x = _n4##x = _n3##x = _n2##x = --_n1##x)); \
 I[0] = I[1], I[1] = I[2], I[2] = I[3], I[3] = I[4], I[4] = I[5], I[5] = I[6], I[6] = I[7], I[7] = I[8], I[8] = I[9], I[9] = I[10], I[10] = I[11], I[11] = I[12], I[12] = I[13], I[13] = I[14], I[14] = I[15], I[15] = I[16], I[16] = I[17], \
 I[18] = I[19], I[19] = I[20], I[20] = I[21], I[21] = I[22], I[22] = I[23], I[23] = I[24], I[24] = I[25], I[25] = I[26], I[26] = I[27], I[27] = I[28], I[28] = I[29], I[29] = I[30], I[30] = I[31], I[31] = I[32], I[32] = I[33], I[33] = I[34], I[34] = I[35], \
 I[36] = I[37], I[37] = I[38], I[38] = I[39], I[39] = I[40], I[40] = I[41], I[41] = I[42], I[42] = I[43], I[43] = I[44], I[44] = I[45], I[45] = I[46], I[46] = I[47], I[47] = I[48], I[48] = I[49], I[49] = I[50], I[50] = I[51], I[51] = I[52], I[52] = I[53], \
 I[54] = I[55], I[55] = I[56], I[56] = I[57], I[57] = I[58], I[58] = I[59], I[59] = I[60], I[60] = I[61], I[61] = I[62], I[62] = I[63], I[63] = I[64], I[64] = I[65], I[65] = I[66], I[66] = I[67], I[67] = I[68], I[68] = I[69], I[69] = I[70], I[70] = I[71], \
 I[72] = I[73], I[73] = I[74], I[74] = I[75], I[75] = I[76], I[76] = I[77], I[77] = I[78], I[78] = I[79], I[79] = I[80], I[80] = I[81], I[81] = I[82], I[82] = I[83], I[83] = I[84], I[84] = I[85], I[85] = I[86], I[86] = I[87], I[87] = I[88], I[88] = I[89], \
 I[90] = I[91], I[91] = I[92], I[92] = I[93], I[93] = I[94], I[94] = I[95], I[95] = I[96], I[96] = I[97], I[97] = I[98], I[98] = I[99], I[99] = I[100], I[100] = I[101], I[101] = I[102], I[102] = I[103], I[103] = I[104], I[104] = I[105], I[105] = I[106], I[106] = I[107], \
 I[108] = I[109], I[109] = I[110], I[110] = I[111], I[111] = I[112], I[112] = I[113], I[113] = I[114], I[114] = I[115], I[115] = I[116], I[116] = I[117], I[117] = I[118], I[118] = I[119], I[119] = I[120], I[120] = I[121], I[121] = I[122], I[122] = I[123], I[123] = I[124], I[124] = I[125], \
 I[126] = I[127], I[127] = I[128], I[128] = I[129], I[129] = I[130], I[130] = I[131], I[131] = I[132], I[132] = I[133], I[133] = I[134], I[134] = I[135], I[135] = I[136], I[136] = I[137], I[137] = I[138], I[138] = I[139], I[139] = I[140], I[140] = I[141], I[141] = I[142], I[142] = I[143], \
 I[144] = I[145], I[145] = I[146], I[146] = I[147], I[147] = I[148], I[148] = I[149], I[149] = I[150], I[150] = I[151], I[151] = I[152], I[152] = I[153], I[153] = I[154], I[154] = I[155], I[155] = I[156], I[156] = I[157], I[157] = I[158], I[158] = I[159], I[159] = I[160], I[160] = I[161], \
 I[162] = I[163], I[163] = I[164], I[164] = I[165], I[165] = I[166], I[166] = I[167], I[167] = I[168], I[168] = I[169], I[169] = I[170], I[170] = I[171], I[171] = I[172], I[172] = I[173], I[173] = I[174], I[174] = I[175], I[175] = I[176], I[176] = I[177], I[177] = I[178], I[178] = I[179], \
 I[180] = I[181], I[181] = I[182], I[182] = I[183], I[183] = I[184], I[184] = I[185], I[185] = I[186], I[186] = I[187], I[187] = I[188], I[188] = I[189], I[189] = I[190], I[190] = I[191], I[191] = I[192], I[192] = I[193], I[193] = I[194], I[194] = I[195], I[195] = I[196], I[196] = I[197], \
 I[198] = I[199], I[199] = I[200], I[200] = I[201], I[201] = I[202], I[202] = I[203], I[203] = I[204], I[204] = I[205], I[205] = I[206], I[206] = I[207], I[207] = I[208], I[208] = I[209], I[209] = I[210], I[210] = I[211], I[211] = I[212], I[212] = I[213], I[213] = I[214], I[214] = I[215], \
 I[216] = I[217], I[217] = I[218], I[218] = I[219], I[219] = I[220], I[220] = I[221], I[221] = I[222], I[222] = I[223], I[223] = I[224], I[224] = I[225], I[225] = I[226], I[226] = I[227], I[227] = I[228], I[228] = I[229], I[229] = I[230], I[230] = I[231], I[231] = I[232], I[232] = I[233], \
 I[234] = I[235], I[235] = I[236], I[236] = I[237], I[237] = I[238], I[238] = I[239], I[239] = I[240], I[240] = I[241], I[241] = I[242], I[242] = I[243], I[243] = I[244], I[244] = I[245], I[245] = I[246], I[246] = I[247], I[247] = I[248], I[248] = I[249], I[249] = I[250], I[250] = I[251], \
 I[252] = I[253], I[253] = I[254], I[254] = I[255], I[255] = I[256], I[256] = I[257], I[257] = I[258], I[258] = I[259], I[259] = I[260], I[260] = I[261], I[261] = I[262], I[262] = I[263], I[263] = I[264], I[264] = I[265], I[265] = I[266], I[266] = I[267], I[267] = I[268], I[268] = I[269], \
 I[270] = I[271], I[271] = I[272], I[272] = I[273], I[273] = I[274], I[274] = I[275], I[275] = I[276], I[276] = I[277], I[277] = I[278], I[278] = I[279], I[279] = I[280], I[280] = I[281], I[281] = I[282], I[282] = I[283], I[283] = I[284], I[284] = I[285], I[285] = I[286], I[286] = I[287], \
 I[288] = I[289], I[289] = I[290], I[290] = I[291], I[291] = I[292], I[292] = I[293], I[293] = I[294], I[294] = I[295], I[295] = I[296], I[296] = I[297], I[297] = I[298], I[298] = I[299], I[299] = I[300], I[300] = I[301], I[301] = I[302], I[302] = I[303], I[303] = I[304], I[304] = I[305], \
 I[306] = I[307], I[307] = I[308], I[308] = I[309], I[309] = I[310], I[310] = I[311], I[311] = I[312], I[312] = I[313], I[313] = I[314], I[314] = I[315], I[315] = I[316], I[316] = I[317], I[317] = I[318], I[318] = I[319], I[319] = I[320], I[320] = I[321], I[321] = I[322], I[322] = I[323], \
 _p8##x = _p7##x, _p7##x = _p6##x, _p6##x = _p5##x, _p5##x = _p4##x, _p4##x = _p3##x, _p3##x = _p2##x, _p2##x = _p1##x, _p1##x = x++, ++_n1##x, ++_n2##x, ++_n3##x, ++_n4##x, ++_n5##x, ++_n6##x, ++_n7##x, ++_n8##x, ++_n9##x)

#define cimg_get18x18(img,x,y,z,c,I,T) \
 I[0] = (T)(img)(_p8##x,_p8##y,z,c), I[1] = (T)(img)(_p7##x,_p8##y,z,c), I[2] = (T)(img)(_p6##x,_p8##y,z,c), I[3] = (T)(img)(_p5##x,_p8##y,z,c), I[4] = (T)(img)(_p4##x,_p8##y,z,c), I[5] = (T)(img)(_p3##x,_p8##y,z,c), I[6] = (T)(img)(_p2##x,_p8##y,z,c), I[7] = (T)(img)(_p1##x,_p8##y,z,c), I[8] = (T)(img)(x,_p8##y,z,c), I[9] = (T)(img)(_n1##x,_p8##y,z,c), I[10] = (T)(img)(_n2##x,_p8##y,z,c), I[11] = (T)(img)(_n3##x,_p8##y,z,c), I[12] = (T)(img)(_n4##x,_p8##y,z,c), I[13] = (T)(img)(_n5##x,_p8##y,z,c), I[14] = (T)(img)(_n6##x,_p8##y,z,c), I[15] = (T)(img)(_n7##x,_p8##y,z,c), I[16] = (T)(img)(_n8##x,_p8##y,z,c), I[17] = (T)(img)(_n9##x,_p8##y,z,c), \
 I[18] = (T)(img)(_p8##x,_p7##y,z,c), I[19] = (T)(img)(_p7##x,_p7##y,z,c), I[20] = (T)(img)(_p6##x,_p7##y,z,c), I[21] = (T)(img)(_p5##x,_p7##y,z,c), I[22] = (T)(img)(_p4##x,_p7##y,z,c), I[23] = (T)(img)(_p3##x,_p7##y,z,c), I[24] = (T)(img)(_p2##x,_p7##y,z,c), I[25] = (T)(img)(_p1##x,_p7##y,z,c), I[26] = (T)(img)(x,_p7##y,z,c), I[27] = (T)(img)(_n1##x,_p7##y,z,c), I[28] = (T)(img)(_n2##x,_p7##y,z,c), I[29] = (T)(img)(_n3##x,_p7##y,z,c), I[30] = (T)(img)(_n4##x,_p7##y,z,c), I[31] = (T)(img)(_n5##x,_p7##y,z,c), I[32] = (T)(img)(_n6##x,_p7##y,z,c), I[33] = (T)(img)(_n7##x,_p7##y,z,c), I[34] = (T)(img)(_n8##x,_p7##y,z,c), I[35] = (T)(img)(_n9##x,_p7##y,z,c), \
 I[36] = (T)(img)(_p8##x,_p6##y,z,c), I[37] = (T)(img)(_p7##x,_p6##y,z,c), I[38] = (T)(img)(_p6##x,_p6##y,z,c), I[39] = (T)(img)(_p5##x,_p6##y,z,c), I[40] = (T)(img)(_p4##x,_p6##y,z,c), I[41] = (T)(img)(_p3##x,_p6##y,z,c), I[42] = (T)(img)(_p2##x,_p6##y,z,c), I[43] = (T)(img)(_p1##x,_p6##y,z,c), I[44] = (T)(img)(x,_p6##y,z,c), I[45] = (T)(img)(_n1##x,_p6##y,z,c), I[46] = (T)(img)(_n2##x,_p6##y,z,c), I[47] = (T)(img)(_n3##x,_p6##y,z,c), I[48] = (T)(img)(_n4##x,_p6##y,z,c), I[49] = (T)(img)(_n5##x,_p6##y,z,c), I[50] = (T)(img)(_n6##x,_p6##y,z,c), I[51] = (T)(img)(_n7##x,_p6##y,z,c), I[52] = (T)(img)(_n8##x,_p6##y,z,c), I[53] = (T)(img)(_n9##x,_p6##y,z,c), \
 I[54] = (T)(img)(_p8##x,_p5##y,z,c), I[55] = (T)(img)(_p7##x,_p5##y,z,c), I[56] = (T)(img)(_p6##x,_p5##y,z,c), I[57] = (T)(img)(_p5##x,_p5##y,z,c), I[58] = (T)(img)(_p4##x,_p5##y,z,c), I[59] = (T)(img)(_p3##x,_p5##y,z,c), I[60] = (T)(img)(_p2##x,_p5##y,z,c), I[61] = (T)(img)(_p1##x,_p5##y,z,c), I[62] = (T)(img)(x,_p5##y,z,c), I[63] = (T)(img)(_n1##x,_p5##y,z,c), I[64] = (T)(img)(_n2##x,_p5##y,z,c), I[65] = (T)(img)(_n3##x,_p5##y,z,c), I[66] = (T)(img)(_n4##x,_p5##y,z,c), I[67] = (T)(img)(_n5##x,_p5##y,z,c), I[68] = (T)(img)(_n6##x,_p5##y,z,c), I[69] = (T)(img)(_n7##x,_p5##y,z,c), I[70] = (T)(img)(_n8##x,_p5##y,z,c), I[71] = (T)(img)(_n9##x,_p5##y,z,c), \
 I[72] = (T)(img)(_p8##x,_p4##y,z,c), I[73] = (T)(img)(_p7##x,_p4##y,z,c), I[74] = (T)(img)(_p6##x,_p4##y,z,c), I[75] = (T)(img)(_p5##x,_p4##y,z,c), I[76] = (T)(img)(_p4##x,_p4##y,z,c), I[77] = (T)(img)(_p3##x,_p4##y,z,c), I[78] = (T)(img)(_p2##x,_p4##y,z,c), I[79] = (T)(img)(_p1##x,_p4##y,z,c), I[80] = (T)(img)(x,_p4##y,z,c), I[81] = (T)(img)(_n1##x,_p4##y,z,c), I[82] = (T)(img)(_n2##x,_p4##y,z,c), I[83] = (T)(img)(_n3##x,_p4##y,z,c), I[84] = (T)(img)(_n4##x,_p4##y,z,c), I[85] = (T)(img)(_n5##x,_p4##y,z,c), I[86] = (T)(img)(_n6##x,_p4##y,z,c), I[87] = (T)(img)(_n7##x,_p4##y,z,c), I[88] = (T)(img)(_n8##x,_p4##y,z,c), I[89] = (T)(img)(_n9##x,_p4##y,z,c), \
 I[90] = (T)(img)(_p8##x,_p3##y,z,c), I[91] = (T)(img)(_p7##x,_p3##y,z,c), I[92] = (T)(img)(_p6##x,_p3##y,z,c), I[93] = (T)(img)(_p5##x,_p3##y,z,c), I[94] = (T)(img)(_p4##x,_p3##y,z,c), I[95] = (T)(img)(_p3##x,_p3##y,z,c), I[96] = (T)(img)(_p2##x,_p3##y,z,c), I[97] = (T)(img)(_p1##x,_p3##y,z,c), I[98] = (T)(img)(x,_p3##y,z,c), I[99] = (T)(img)(_n1##x,_p3##y,z,c), I[100] = (T)(img)(_n2##x,_p3##y,z,c), I[101] = (T)(img)(_n3##x,_p3##y,z,c), I[102] = (T)(img)(_n4##x,_p3##y,z,c), I[103] = (T)(img)(_n5##x,_p3##y,z,c), I[104] = (T)(img)(_n6##x,_p3##y,z,c), I[105] = (T)(img)(_n7##x,_p3##y,z,c), I[106] = (T)(img)(_n8##x,_p3##y,z,c), I[107] = (T)(img)(_n9##x,_p3##y,z,c), \
 I[108] = (T)(img)(_p8##x,_p2##y,z,c), I[109] = (T)(img)(_p7##x,_p2##y,z,c), I[110] = (T)(img)(_p6##x,_p2##y,z,c), I[111] = (T)(img)(_p5##x,_p2##y,z,c), I[112] = (T)(img)(_p4##x,_p2##y,z,c), I[113] = (T)(img)(_p3##x,_p2##y,z,c), I[114] = (T)(img)(_p2##x,_p2##y,z,c), I[115] = (T)(img)(_p1##x,_p2##y,z,c), I[116] = (T)(img)(x,_p2##y,z,c), I[117] = (T)(img)(_n1##x,_p2##y,z,c), I[118] = (T)(img)(_n2##x,_p2##y,z,c), I[119] = (T)(img)(_n3##x,_p2##y,z,c), I[120] = (T)(img)(_n4##x,_p2##y,z,c), I[121] = (T)(img)(_n5##x,_p2##y,z,c), I[122] = (T)(img)(_n6##x,_p2##y,z,c), I[123] = (T)(img)(_n7##x,_p2##y,z,c), I[124] = (T)(img)(_n8##x,_p2##y,z,c), I[125] = (T)(img)(_n9##x,_p2##y,z,c), \
 I[126] = (T)(img)(_p8##x,_p1##y,z,c), I[127] = (T)(img)(_p7##x,_p1##y,z,c), I[128] = (T)(img)(_p6##x,_p1##y,z,c), I[129] = (T)(img)(_p5##x,_p1##y,z,c), I[130] = (T)(img)(_p4##x,_p1##y,z,c), I[131] = (T)(img)(_p3##x,_p1##y,z,c), I[132] = (T)(img)(_p2##x,_p1##y,z,c), I[133] = (T)(img)(_p1##x,_p1##y,z,c), I[134] = (T)(img)(x,_p1##y,z,c), I[135] = (T)(img)(_n1##x,_p1##y,z,c), I[136] = (T)(img)(_n2##x,_p1##y,z,c), I[137] = (T)(img)(_n3##x,_p1##y,z,c), I[138] = (T)(img)(_n4##x,_p1##y,z,c), I[139] = (T)(img)(_n5##x,_p1##y,z,c), I[140] = (T)(img)(_n6##x,_p1##y,z,c), I[141] = (T)(img)(_n7##x,_p1##y,z,c), I[142] = (T)(img)(_n8##x,_p1##y,z,c), I[143] = (T)(img)(_n9##x,_p1##y,z,c), \
 I[144] = (T)(img)(_p8##x,y,z,c), I[145] = (T)(img)(_p7##x,y,z,c), I[146] = (T)(img)(_p6##x,y,z,c), I[147] = (T)(img)(_p5##x,y,z,c), I[148] = (T)(img)(_p4##x,y,z,c), I[149] = (T)(img)(_p3##x,y,z,c), I[150] = (T)(img)(_p2##x,y,z,c), I[151] = (T)(img)(_p1##x,y,z,c), I[152] = (T)(img)(x,y,z,c), I[153] = (T)(img)(_n1##x,y,z,c), I[154] = (T)(img)(_n2##x,y,z,c), I[155] = (T)(img)(_n3##x,y,z,c), I[156] = (T)(img)(_n4##x,y,z,c), I[157] = (T)(img)(_n5##x,y,z,c), I[158] = (T)(img)(_n6##x,y,z,c), I[159] = (T)(img)(_n7##x,y,z,c), I[160] = (T)(img)(_n8##x,y,z,c), I[161] = (T)(img)(_n9##x,y,z,c), \
 I[162] = (T)(img)(_p8##x,_n1##y,z,c), I[163] = (T)(img)(_p7##x,_n1##y,z,c), I[164] = (T)(img)(_p6##x,_n1##y,z,c), I[165] = (T)(img)(_p5##x,_n1##y,z,c), I[166] = (T)(img)(_p4##x,_n1##y,z,c), I[167] = (T)(img)(_p3##x,_n1##y,z,c), I[168] = (T)(img)(_p2##x,_n1##y,z,c), I[169] = (T)(img)(_p1##x,_n1##y,z,c), I[170] = (T)(img)(x,_n1##y,z,c), I[171] = (T)(img)(_n1##x,_n1##y,z,c), I[172] = (T)(img)(_n2##x,_n1##y,z,c), I[173] = (T)(img)(_n3##x,_n1##y,z,c), I[174] = (T)(img)(_n4##x,_n1##y,z,c), I[175] = (T)(img)(_n5##x,_n1##y,z,c), I[176] = (T)(img)(_n6##x,_n1##y,z,c), I[177] = (T)(img)(_n7##x,_n1##y,z,c), I[178] = (T)(img)(_n8##x,_n1##y,z,c), I[179] = (T)(img)(_n9##x,_n1##y,z,c), \
 I[180] = (T)(img)(_p8##x,_n2##y,z,c), I[181] = (T)(img)(_p7##x,_n2##y,z,c), I[182] = (T)(img)(_p6##x,_n2##y,z,c), I[183] = (T)(img)(_p5##x,_n2##y,z,c), I[184] = (T)(img)(_p4##x,_n2##y,z,c), I[185] = (T)(img)(_p3##x,_n2##y,z,c), I[186] = (T)(img)(_p2##x,_n2##y,z,c), I[187] = (T)(img)(_p1##x,_n2##y,z,c), I[188] = (T)(img)(x,_n2##y,z,c), I[189] = (T)(img)(_n1##x,_n2##y,z,c), I[190] = (T)(img)(_n2##x,_n2##y,z,c), I[191] = (T)(img)(_n3##x,_n2##y,z,c), I[192] = (T)(img)(_n4##x,_n2##y,z,c), I[193] = (T)(img)(_n5##x,_n2##y,z,c), I[194] = (T)(img)(_n6##x,_n2##y,z,c), I[195] = (T)(img)(_n7##x,_n2##y,z,c), I[196] = (T)(img)(_n8##x,_n2##y,z,c), I[197] = (T)(img)(_n9##x,_n2##y,z,c), \
 I[198] = (T)(img)(_p8##x,_n3##y,z,c), I[199] = (T)(img)(_p7##x,_n3##y,z,c), I[200] = (T)(img)(_p6##x,_n3##y,z,c), I[201] = (T)(img)(_p5##x,_n3##y,z,c), I[202] = (T)(img)(_p4##x,_n3##y,z,c), I[203] = (T)(img)(_p3##x,_n3##y,z,c), I[204] = (T)(img)(_p2##x,_n3##y,z,c), I[205] = (T)(img)(_p1##x,_n3##y,z,c), I[206] = (T)(img)(x,_n3##y,z,c), I[207] = (T)(img)(_n1##x,_n3##y,z,c), I[208] = (T)(img)(_n2##x,_n3##y,z,c), I[209] = (T)(img)(_n3##x,_n3##y,z,c), I[210] = (T)(img)(_n4##x,_n3##y,z,c), I[211] = (T)(img)(_n5##x,_n3##y,z,c), I[212] = (T)(img)(_n6##x,_n3##y,z,c), I[213] = (T)(img)(_n7##x,_n3##y,z,c), I[214] = (T)(img)(_n8##x,_n3##y,z,c), I[215] = (T)(img)(_n9##x,_n3##y,z,c), \
 I[216] = (T)(img)(_p8##x,_n4##y,z,c), I[217] = (T)(img)(_p7##x,_n4##y,z,c), I[218] = (T)(img)(_p6##x,_n4##y,z,c), I[219] = (T)(img)(_p5##x,_n4##y,z,c), I[220] = (T)(img)(_p4##x,_n4##y,z,c), I[221] = (T)(img)(_p3##x,_n4##y,z,c), I[222] = (T)(img)(_p2##x,_n4##y,z,c), I[223] = (T)(img)(_p1##x,_n4##y,z,c), I[224] = (T)(img)(x,_n4##y,z,c), I[225] = (T)(img)(_n1##x,_n4##y,z,c), I[226] = (T)(img)(_n2##x,_n4##y,z,c), I[227] = (T)(img)(_n3##x,_n4##y,z,c), I[228] = (T)(img)(_n4##x,_n4##y,z,c), I[229] = (T)(img)(_n5##x,_n4##y,z,c), I[230] = (T)(img)(_n6##x,_n4##y,z,c), I[231] = (T)(img)(_n7##x,_n4##y,z,c), I[232] = (T)(img)(_n8##x,_n4##y,z,c), I[233] = (T)(img)(_n9##x,_n4##y,z,c), \
 I[234] = (T)(img)(_p8##x,_n5##y,z,c), I[235] = (T)(img)(_p7##x,_n5##y,z,c), I[236] = (T)(img)(_p6##x,_n5##y,z,c), I[237] = (T)(img)(_p5##x,_n5##y,z,c), I[238] = (T)(img)(_p4##x,_n5##y,z,c), I[239] = (T)(img)(_p3##x,_n5##y,z,c), I[240] = (T)(img)(_p2##x,_n5##y,z,c), I[241] = (T)(img)(_p1##x,_n5##y,z,c), I[242] = (T)(img)(x,_n5##y,z,c), I[243] = (T)(img)(_n1##x,_n5##y,z,c), I[244] = (T)(img)(_n2##x,_n5##y,z,c), I[245] = (T)(img)(_n3##x,_n5##y,z,c), I[246] = (T)(img)(_n4##x,_n5##y,z,c), I[247] = (T)(img)(_n5##x,_n5##y,z,c), I[248] = (T)(img)(_n6##x,_n5##y,z,c), I[249] = (T)(img)(_n7##x,_n5##y,z,c), I[250] = (T)(img)(_n8##x,_n5##y,z,c), I[251] = (T)(img)(_n9##x,_n5##y,z,c), \
 I[252] = (T)(img)(_p8##x,_n6##y,z,c), I[253] = (T)(img)(_p7##x,_n6##y,z,c), I[254] = (T)(img)(_p6##x,_n6##y,z,c), I[255] = (T)(img)(_p5##x,_n6##y,z,c), I[256] = (T)(img)(_p4##x,_n6##y,z,c), I[257] = (T)(img)(_p3##x,_n6##y,z,c), I[258] = (T)(img)(_p2##x,_n6##y,z,c), I[259] = (T)(img)(_p1##x,_n6##y,z,c), I[260] = (T)(img)(x,_n6##y,z,c), I[261] = (T)(img)(_n1##x,_n6##y,z,c), I[262] = (T)(img)(_n2##x,_n6##y,z,c), I[263] = (T)(img)(_n3##x,_n6##y,z,c), I[264] = (T)(img)(_n4##x,_n6##y,z,c), I[265] = (T)(img)(_n5##x,_n6##y,z,c), I[266] = (T)(img)(_n6##x,_n6##y,z,c), I[267] = (T)(img)(_n7##x,_n6##y,z,c), I[268] = (T)(img)(_n8##x,_n6##y,z,c), I[269] = (T)(img)(_n9##x,_n6##y,z,c), \
 I[270] = (T)(img)(_p8##x,_n7##y,z,c), I[271] = (T)(img)(_p7##x,_n7##y,z,c), I[272] = (T)(img)(_p6##x,_n7##y,z,c), I[273] = (T)(img)(_p5##x,_n7##y,z,c), I[274] = (T)(img)(_p4##x,_n7##y,z,c), I[275] = (T)(img)(_p3##x,_n7##y,z,c), I[276] = (T)(img)(_p2##x,_n7##y,z,c), I[277] = (T)(img)(_p1##x,_n7##y,z,c), I[278] = (T)(img)(x,_n7##y,z,c), I[279] = (T)(img)(_n1##x,_n7##y,z,c), I[280] = (T)(img)(_n2##x,_n7##y,z,c), I[281] = (T)(img)(_n3##x,_n7##y,z,c), I[282] = (T)(img)(_n4##x,_n7##y,z,c), I[283] = (T)(img)(_n5##x,_n7##y,z,c), I[284] = (T)(img)(_n6##x,_n7##y,z,c), I[285] = (T)(img)(_n7##x,_n7##y,z,c), I[286] = (T)(img)(_n8##x,_n7##y,z,c), I[287] = (T)(img)(_n9##x,_n7##y,z,c), \
 I[288] = (T)(img)(_p8##x,_n8##y,z,c), I[289] = (T)(img)(_p7##x,_n8##y,z,c), I[290] = (T)(img)(_p6##x,_n8##y,z,c), I[291] = (T)(img)(_p5##x,_n8##y,z,c), I[292] = (T)(img)(_p4##x,_n8##y,z,c), I[293] = (T)(img)(_p3##x,_n8##y,z,c), I[294] = (T)(img)(_p2##x,_n8##y,z,c), I[295] = (T)(img)(_p1##x,_n8##y,z,c), I[296] = (T)(img)(x,_n8##y,z,c), I[297] = (T)(img)(_n1##x,_n8##y,z,c), I[298] = (T)(img)(_n2##x,_n8##y,z,c), I[299] = (T)(img)(_n3##x,_n8##y,z,c), I[300] = (T)(img)(_n4##x,_n8##y,z,c), I[301] = (T)(img)(_n5##x,_n8##y,z,c), I[302] = (T)(img)(_n6##x,_n8##y,z,c), I[303] = (T)(img)(_n7##x,_n8##y,z,c), I[304] = (T)(img)(_n8##x,_n8##y,z,c), I[305] = (T)(img)(_n9##x,_n8##y,z,c), \
 I[306] = (T)(img)(_p8##x,_n9##y,z,c), I[307] = (T)(img)(_p7##x,_n9##y,z,c), I[308] = (T)(img)(_p6##x,_n9##y,z,c), I[309] = (T)(img)(_p5##x,_n9##y,z,c), I[310] = (T)(img)(_p4##x,_n9##y,z,c), I[311] = (T)(img)(_p3##x,_n9##y,z,c), I[312] = (T)(img)(_p2##x,_n9##y,z,c), I[313] = (T)(img)(_p1##x,_n9##y,z,c), I[314] = (T)(img)(x,_n9##y,z,c), I[315] = (T)(img)(_n1##x,_n9##y,z,c), I[316] = (T)(img)(_n2##x,_n9##y,z,c), I[317] = (T)(img)(_n3##x,_n9##y,z,c), I[318] = (T)(img)(_n4##x,_n9##y,z,c), I[319] = (T)(img)(_n5##x,_n9##y,z,c), I[320] = (T)(img)(_n6##x,_n9##y,z,c), I[321] = (T)(img)(_n7##x,_n9##y,z,c), I[322] = (T)(img)(_n8##x,_n9##y,z,c), I[323] = (T)(img)(_n9##x,_n9##y,z,c);

// Define 19x19 loop macros
//-------------------------
#define cimg_for19(bound,i) for (int i = 0, \
 _p9##i = 0, _p8##i = 0, _p7##i = 0, _p6##i = 0, _p5##i = 0, _p4##i = 0, _p3##i = 0, _p2##i = 0, _p1##i = 0, \
 _n1##i = 1>=(int)(bound)?(int)(bound)-1:1, \
 _n2##i = 2>=(int)(bound)?(int)(bound)-1:2, \
 _n3##i = 3>=(int)(bound)?(int)(bound)-1:3, \
 _n4##i = 4>=(int)(bound)?(int)(bound)-1:4, \
 _n5##i = 5>=(int)(bound)?(int)(bound)-1:5, \
 _n6##i = 6>=(int)(bound)?(int)(bound)-1:6, \
 _n7##i = 7>=(int)(bound)?(int)(bound)-1:7, \
 _n8##i = 8>=(int)(bound)?(int)(bound)-1:8, \
 _n9##i = 9>=(int)(bound)?(int)(bound)-1:9; \
 _n9##i<(int)(bound) || _n8##i==--_n9##i || _n7##i==--_n8##i || _n6##i==--_n7##i || _n5##i==--_n6##i || _n4##i==--_n5##i || _n3##i==--_n4##i || _n2##i==--_n3##i || _n1##i==--_n2##i || \
 i==(_n9##i = _n8##i = _n7##i = _n6##i = _n5##i = _n4##i = _n3##i = _n2##i = --_n1##i); \
 _p9##i = _p8##i, _p8##i = _p7##i, _p7##i = _p6##i, _p6##i = _p5##i, _p5##i = _p4##i, _p4##i = _p3##i, _p3##i = _p2##i, _p2##i = _p1##i, _p1##i = i++, \
 ++_n1##i, ++_n2##i, ++_n3##i, ++_n4##i, ++_n5##i, ++_n6##i, ++_n7##i, ++_n8##i, ++_n9##i)

#define cimg_for19X(img,x) cimg_for19((img)._width,x)
#define cimg_for19Y(img,y) cimg_for19((img)._height,y)
#define cimg_for19Z(img,z) cimg_for19((img)._depth,z)
#define cimg_for19C(img,c) cimg_for19((img)._spectrum,c)
#define cimg_for19XY(img,x,y) cimg_for19Y(img,y) cimg_for19X(img,x)
#define cimg_for19XZ(img,x,z) cimg_for19Z(img,z) cimg_for19X(img,x)
#define cimg_for19XC(img,x,c) cimg_for19C(img,c) cimg_for19X(img,x)
#define cimg_for19YZ(img,y,z) cimg_for19Z(img,z) cimg_for19Y(img,y)
#define cimg_for19YC(img,y,c) cimg_for19C(img,c) cimg_for19Y(img,y)
#define cimg_for19ZC(img,z,c) cimg_for19C(img,c) cimg_for19Z(img,z)
#define cimg_for19XYZ(img,x,y,z) cimg_for19Z(img,z) cimg_for19XY(img,x,y)
#define cimg_for19XZC(img,x,z,c) cimg_for19C(img,c) cimg_for19XZ(img,x,z)
#define cimg_for19YZC(img,y,z,c) cimg_for19C(img,c) cimg_for19YZ(img,y,z)
#define cimg_for19XYZC(img,x,y,z,c) cimg_for19C(img,c) cimg_for19XYZ(img,x,y,z)

#define cimg_for_in19(bound,i0,i1,i) for (int i = (int)(i0)<0?0:(int)(i0), \
 _p9##i = i-9<0?0:i-9, \
 _p8##i = i-8<0?0:i-8, \
 _p7##i = i-7<0?0:i-7, \
 _p6##i = i-6<0?0:i-6, \
 _p5##i = i-5<0?0:i-5, \
 _p4##i = i-4<0?0:i-4, \
 _p3##i = i-3<0?0:i-3, \
 _p2##i = i-2<0?0:i-2, \
 _p1##i = i-1<0?0:i-1, \
 _n1##i = i+1>=(int)(bound)?(int)(bound)-1:i+1, \
 _n2##i = i+2>=(int)(bound)?(int)(bound)-1:i+2, \
 _n3##i = i+3>=(int)(bound)?(int)(bound)-1:i+3, \
 _n4##i = i+4>=(int)(bound)?(int)(bound)-1:i+4, \
 _n5##i = i+5>=(int)(bound)?(int)(bound)-1:i+5, \
 _n6##i = i+6>=(int)(bound)?(int)(bound)-1:i+6, \
 _n7##i = i+7>=(int)(bound)?(int)(bound)-1:i+7, \
 _n8##i = i+8>=(int)(bound)?(int)(bound)-1:i+8, \
 _n9##i = i+9>=(int)(bound)?(int)(bound)-1:i+9; \
 i<=(int)(i1) && (_n9##i<(int)(bound) || _n8##i==--_n9##i || _n7##i==--_n8##i || _n6##i==--_n7##i || _n5##i==--_n6##i || _n4##i==--_n5##i || _n3##i==--_n4##i || _n2##i==--_n3##i || _n1##i==--_n2##i || \
 i==(_n9##i = _n8##i = _n7##i = _n6##i = _n5##i = _n4##i = _n3##i = _n2##i = --_n1##i)); \
 _p9##i = _p8##i, _p8##i = _p7##i, _p7##i = _p6##i, _p6##i = _p5##i, _p5##i = _p4##i, _p4##i = _p3##i, _p3##i = _p2##i, _p2##i = _p1##i, _p1##i = i++, \
 ++_n1##i, ++_n2##i, ++_n3##i, ++_n4##i, ++_n5##i, ++_n6##i, ++_n7##i, ++_n8##i, ++_n9##i)

#define cimg_for_in19X(img,x0,x1,x) cimg_for_in19((img)._width,x0,x1,x)
#define cimg_for_in19Y(img,y0,y1,y) cimg_for_in19((img)._height,y0,y1,y)
#define cimg_for_in19Z(img,z0,z1,z) cimg_for_in19((img)._depth,z0,z1,z)
#define cimg_for_in19C(img,c0,c1,c) cimg_for_in19((img)._spectrum,c0,c1,c)
#define cimg_for_in19XY(img,x0,y0,x1,y1,x,y) cimg_for_in19Y(img,y0,y1,y) cimg_for_in19X(img,x0,x1,x)
#define cimg_for_in19XZ(img,x0,z0,x1,z1,x,z) cimg_for_in19Z(img,z0,z1,z) cimg_for_in19X(img,x0,x1,x)
#define cimg_for_in19XC(img,x0,c0,x1,c1,x,c) cimg_for_in19C(img,c0,c1,c) cimg_for_in19X(img,x0,x1,x)
#define cimg_for_in19YZ(img,y0,z0,y1,z1,y,z) cimg_for_in19Z(img,z0,z1,z) cimg_for_in19Y(img,y0,y1,y)
#define cimg_for_in19YC(img,y0,c0,y1,c1,y,c) cimg_for_in19C(img,c0,c1,c) cimg_for_in19Y(img,y0,y1,y)
#define cimg_for_in19ZC(img,z0,c0,z1,c1,z,c) cimg_for_in19C(img,c0,c1,c) cimg_for_in19Z(img,z0,z1,z)
#define cimg_for_in19XYZ(img,x0,y0,z0,x1,y1,z1,x,y,z) cimg_for_in19Z(img,z0,z1,z) cimg_for_in19XY(img,x0,y0,x1,y1,x,y)
#define cimg_for_in19XZC(img,x0,z0,c0,x1,y1,c1,x,z,c) cimg_for_in19C(img,c0,c1,c) cimg_for_in19XZ(img,x0,y0,x1,y1,x,z)
#define cimg_for_in19YZC(img,y0,z0,c0,y1,z1,c1,y,z,c) cimg_for_in19C(img,c0,c1,c) cimg_for_in19YZ(img,y0,z0,y1,z1,y,z)
#define cimg_for_in19XYZC(img,x0,y0,z0,c0,x1,y1,z1,c1,x,y,z,c) cimg_for_in19C(img,c0,c1,c) cimg_for_in19XYZ(img,x0,y0,z0,x1,y1,z1,x,y,z)

#define cimg_for19x19(img,x,y,z,c,I,T) \
 cimg_for19((img)._height,y) for (int x = 0, \
 _p9##x = 0, _p8##x = 0, _p7##x = 0, _p6##x = 0, _p5##x = 0, _p4##x = 0, _p3##x = 0, _p2##x = 0, _p1##x = 0, \
 _n1##x = 1>=((img)._width)?(img).width()-1:1, \
 _n2##x = 2>=((img)._width)?(img).width()-1:2, \
 _n3##x = 3>=((img)._width)?(img).width()-1:3, \
 _n4##x = 4>=((img)._width)?(img).width()-1:4, \
 _n5##x = 5>=((img)._width)?(img).width()-1:5, \
 _n6##x = 6>=((img)._width)?(img).width()-1:6, \
 _n7##x = 7>=((img)._width)?(img).width()-1:7, \
 _n8##x = 8>=((img)._width)?(img).width()-1:8, \
 _n9##x = (int)( \
 (I[0] = I[1] = I[2] = I[3] = I[4] = I[5] = I[6] = I[7] = I[8] = I[9] = (T)(img)(0,_p9##y,z,c)), \
 (I[19] = I[20] = I[21] = I[22] = I[23] = I[24] = I[25] = I[26] = I[27] = I[28] = (T)(img)(0,_p8##y,z,c)), \
 (I[38] = I[39] = I[40] = I[41] = I[42] = I[43] = I[44] = I[45] = I[46] = I[47] = (T)(img)(0,_p7##y,z,c)), \
 (I[57] = I[58] = I[59] = I[60] = I[61] = I[62] = I[63] = I[64] = I[65] = I[66] = (T)(img)(0,_p6##y,z,c)), \
 (I[76] = I[77] = I[78] = I[79] = I[80] = I[81] = I[82] = I[83] = I[84] = I[85] = (T)(img)(0,_p5##y,z,c)), \
 (I[95] = I[96] = I[97] = I[98] = I[99] = I[100] = I[101] = I[102] = I[103] = I[104] = (T)(img)(0,_p4##y,z,c)), \
 (I[114] = I[115] = I[116] = I[117] = I[118] = I[119] = I[120] = I[121] = I[122] = I[123] = (T)(img)(0,_p3##y,z,c)), \
 (I[133] = I[134] = I[135] = I[136] = I[137] = I[138] = I[139] = I[140] = I[141] = I[142] = (T)(img)(0,_p2##y,z,c)), \
 (I[152] = I[153] = I[154] = I[155] = I[156] = I[157] = I[158] = I[159] = I[160] = I[161] = (T)(img)(0,_p1##y,z,c)), \
 (I[171] = I[172] = I[173] = I[174] = I[175] = I[176] = I[177] = I[178] = I[179] = I[180] = (T)(img)(0,y,z,c)), \
 (I[190] = I[191] = I[192] = I[193] = I[194] = I[195] = I[196] = I[197] = I[198] = I[199] = (T)(img)(0,_n1##y,z,c)), \
 (I[209] = I[210] = I[211] = I[212] = I[213] = I[214] = I[215] = I[216] = I[217] = I[218] = (T)(img)(0,_n2##y,z,c)), \
 (I[228] = I[229] = I[230] = I[231] = I[232] = I[233] = I[234] = I[235] = I[236] = I[237] = (T)(img)(0,_n3##y,z,c)), \
 (I[247] = I[248] = I[249] = I[250] = I[251] = I[252] = I[253] = I[254] = I[255] = I[256] = (T)(img)(0,_n4##y,z,c)), \
 (I[266] = I[267] = I[268] = I[269] = I[270] = I[271] = I[272] = I[273] = I[274] = I[275] = (T)(img)(0,_n5##y,z,c)), \
 (I[285] = I[286] = I[287] = I[288] = I[289] = I[290] = I[291] = I[292] = I[293] = I[294] = (T)(img)(0,_n6##y,z,c)), \
 (I[304] = I[305] = I[306] = I[307] = I[308] = I[309] = I[310] = I[311] = I[312] = I[313] = (T)(img)(0,_n7##y,z,c)), \
 (I[323] = I[324] = I[325] = I[326] = I[327] = I[328] = I[329] = I[330] = I[331] = I[332] = (T)(img)(0,_n8##y,z,c)), \
 (I[342] = I[343] = I[344] = I[345] = I[346] = I[347] = I[348] = I[349] = I[350] = I[351] = (T)(img)(0,_n9##y,z,c)), \
 (I[10] = (T)(img)(_n1##x,_p9##y,z,c)), \
 (I[29] = (T)(img)(_n1##x,_p8##y,z,c)), \
 (I[48] = (T)(img)(_n1##x,_p7##y,z,c)), \
 (I[67] = (T)(img)(_n1##x,_p6##y,z,c)), \
 (I[86] = (T)(img)(_n1##x,_p5##y,z,c)), \
 (I[105] = (T)(img)(_n1##x,_p4##y,z,c)), \
 (I[124] = (T)(img)(_n1##x,_p3##y,z,c)), \
 (I[143] = (T)(img)(_n1##x,_p2##y,z,c)), \
 (I[162] = (T)(img)(_n1##x,_p1##y,z,c)), \
 (I[181] = (T)(img)(_n1##x,y,z,c)), \
 (I[200] = (T)(img)(_n1##x,_n1##y,z,c)), \
 (I[219] = (T)(img)(_n1##x,_n2##y,z,c)), \
 (I[238] = (T)(img)(_n1##x,_n3##y,z,c)), \
 (I[257] = (T)(img)(_n1##x,_n4##y,z,c)), \
 (I[276] = (T)(img)(_n1##x,_n5##y,z,c)), \
 (I[295] = (T)(img)(_n1##x,_n6##y,z,c)), \
 (I[314] = (T)(img)(_n1##x,_n7##y,z,c)), \
 (I[333] = (T)(img)(_n1##x,_n8##y,z,c)), \
 (I[352] = (T)(img)(_n1##x,_n9##y,z,c)), \
 (I[11] = (T)(img)(_n2##x,_p9##y,z,c)), \
 (I[30] = (T)(img)(_n2##x,_p8##y,z,c)), \
 (I[49] = (T)(img)(_n2##x,_p7##y,z,c)), \
 (I[68] = (T)(img)(_n2##x,_p6##y,z,c)), \
 (I[87] = (T)(img)(_n2##x,_p5##y,z,c)), \
 (I[106] = (T)(img)(_n2##x,_p4##y,z,c)), \
 (I[125] = (T)(img)(_n2##x,_p3##y,z,c)), \
 (I[144] = (T)(img)(_n2##x,_p2##y,z,c)), \
 (I[163] = (T)(img)(_n2##x,_p1##y,z,c)), \
 (I[182] = (T)(img)(_n2##x,y,z,c)), \
 (I[201] = (T)(img)(_n2##x,_n1##y,z,c)), \
 (I[220] = (T)(img)(_n2##x,_n2##y,z,c)), \
 (I[239] = (T)(img)(_n2##x,_n3##y,z,c)), \
 (I[258] = (T)(img)(_n2##x,_n4##y,z,c)), \
 (I[277] = (T)(img)(_n2##x,_n5##y,z,c)), \
 (I[296] = (T)(img)(_n2##x,_n6##y,z,c)), \
 (I[315] = (T)(img)(_n2##x,_n7##y,z,c)), \
 (I[334] = (T)(img)(_n2##x,_n8##y,z,c)), \
 (I[353] = (T)(img)(_n2##x,_n9##y,z,c)), \
 (I[12] = (T)(img)(_n3##x,_p9##y,z,c)), \
 (I[31] = (T)(img)(_n3##x,_p8##y,z,c)), \
 (I[50] = (T)(img)(_n3##x,_p7##y,z,c)), \
 (I[69] = (T)(img)(_n3##x,_p6##y,z,c)), \
 (I[88] = (T)(img)(_n3##x,_p5##y,z,c)), \
 (I[107] = (T)(img)(_n3##x,_p4##y,z,c)), \
 (I[126] = (T)(img)(_n3##x,_p3##y,z,c)), \
 (I[145] = (T)(img)(_n3##x,_p2##y,z,c)), \
 (I[164] = (T)(img)(_n3##x,_p1##y,z,c)), \
 (I[183] = (T)(img)(_n3##x,y,z,c)), \
 (I[202] = (T)(img)(_n3##x,_n1##y,z,c)), \
 (I[221] = (T)(img)(_n3##x,_n2##y,z,c)), \
 (I[240] = (T)(img)(_n3##x,_n3##y,z,c)), \
 (I[259] = (T)(img)(_n3##x,_n4##y,z,c)), \
 (I[278] = (T)(img)(_n3##x,_n5##y,z,c)), \
 (I[297] = (T)(img)(_n3##x,_n6##y,z,c)), \
 (I[316] = (T)(img)(_n3##x,_n7##y,z,c)), \
 (I[335] = (T)(img)(_n3##x,_n8##y,z,c)), \
 (I[354] = (T)(img)(_n3##x,_n9##y,z,c)), \
 (I[13] = (T)(img)(_n4##x,_p9##y,z,c)), \
 (I[32] = (T)(img)(_n4##x,_p8##y,z,c)), \
 (I[51] = (T)(img)(_n4##x,_p7##y,z,c)), \
 (I[70] = (T)(img)(_n4##x,_p6##y,z,c)), \
 (I[89] = (T)(img)(_n4##x,_p5##y,z,c)), \
 (I[108] = (T)(img)(_n4##x,_p4##y,z,c)), \
 (I[127] = (T)(img)(_n4##x,_p3##y,z,c)), \
 (I[146] = (T)(img)(_n4##x,_p2##y,z,c)), \
 (I[165] = (T)(img)(_n4##x,_p1##y,z,c)), \
 (I[184] = (T)(img)(_n4##x,y,z,c)), \
 (I[203] = (T)(img)(_n4##x,_n1##y,z,c)), \
 (I[222] = (T)(img)(_n4##x,_n2##y,z,c)), \
 (I[241] = (T)(img)(_n4##x,_n3##y,z,c)), \
 (I[260] = (T)(img)(_n4##x,_n4##y,z,c)), \
 (I[279] = (T)(img)(_n4##x,_n5##y,z,c)), \
 (I[298] = (T)(img)(_n4##x,_n6##y,z,c)), \
 (I[317] = (T)(img)(_n4##x,_n7##y,z,c)), \
 (I[336] = (T)(img)(_n4##x,_n8##y,z,c)), \
 (I[355] = (T)(img)(_n4##x,_n9##y,z,c)), \
 (I[14] = (T)(img)(_n5##x,_p9##y,z,c)), \
 (I[33] = (T)(img)(_n5##x,_p8##y,z,c)), \
 (I[52] = (T)(img)(_n5##x,_p7##y,z,c)), \
 (I[71] = (T)(img)(_n5##x,_p6##y,z,c)), \
 (I[90] = (T)(img)(_n5##x,_p5##y,z,c)), \
 (I[109] = (T)(img)(_n5##x,_p4##y,z,c)), \
 (I[128] = (T)(img)(_n5##x,_p3##y,z,c)), \
 (I[147] = (T)(img)(_n5##x,_p2##y,z,c)), \
 (I[166] = (T)(img)(_n5##x,_p1##y,z,c)), \
 (I[185] = (T)(img)(_n5##x,y,z,c)), \
 (I[204] = (T)(img)(_n5##x,_n1##y,z,c)), \
 (I[223] = (T)(img)(_n5##x,_n2##y,z,c)), \
 (I[242] = (T)(img)(_n5##x,_n3##y,z,c)), \
 (I[261] = (T)(img)(_n5##x,_n4##y,z,c)), \
 (I[280] = (T)(img)(_n5##x,_n5##y,z,c)), \
 (I[299] = (T)(img)(_n5##x,_n6##y,z,c)), \
 (I[318] = (T)(img)(_n5##x,_n7##y,z,c)), \
 (I[337] = (T)(img)(_n5##x,_n8##y,z,c)), \
 (I[356] = (T)(img)(_n5##x,_n9##y,z,c)), \
 (I[15] = (T)(img)(_n6##x,_p9##y,z,c)), \
 (I[34] = (T)(img)(_n6##x,_p8##y,z,c)), \
 (I[53] = (T)(img)(_n6##x,_p7##y,z,c)), \
 (I[72] = (T)(img)(_n6##x,_p6##y,z,c)), \
 (I[91] = (T)(img)(_n6##x,_p5##y,z,c)), \
 (I[110] = (T)(img)(_n6##x,_p4##y,z,c)), \
 (I[129] = (T)(img)(_n6##x,_p3##y,z,c)), \
 (I[148] = (T)(img)(_n6##x,_p2##y,z,c)), \
 (I[167] = (T)(img)(_n6##x,_p1##y,z,c)), \
 (I[186] = (T)(img)(_n6##x,y,z,c)), \
 (I[205] = (T)(img)(_n6##x,_n1##y,z,c)), \
 (I[224] = (T)(img)(_n6##x,_n2##y,z,c)), \
 (I[243] = (T)(img)(_n6##x,_n3##y,z,c)), \
 (I[262] = (T)(img)(_n6##x,_n4##y,z,c)), \
 (I[281] = (T)(img)(_n6##x,_n5##y,z,c)), \
 (I[300] = (T)(img)(_n6##x,_n6##y,z,c)), \
 (I[319] = (T)(img)(_n6##x,_n7##y,z,c)), \
 (I[338] = (T)(img)(_n6##x,_n8##y,z,c)), \
 (I[357] = (T)(img)(_n6##x,_n9##y,z,c)), \
 (I[16] = (T)(img)(_n7##x,_p9##y,z,c)), \
 (I[35] = (T)(img)(_n7##x,_p8##y,z,c)), \
 (I[54] = (T)(img)(_n7##x,_p7##y,z,c)), \
 (I[73] = (T)(img)(_n7##x,_p6##y,z,c)), \
 (I[92] = (T)(img)(_n7##x,_p5##y,z,c)), \
 (I[111] = (T)(img)(_n7##x,_p4##y,z,c)), \
 (I[130] = (T)(img)(_n7##x,_p3##y,z,c)), \
 (I[149] = (T)(img)(_n7##x,_p2##y,z,c)), \
 (I[168] = (T)(img)(_n7##x,_p1##y,z,c)), \
 (I[187] = (T)(img)(_n7##x,y,z,c)), \
 (I[206] = (T)(img)(_n7##x,_n1##y,z,c)), \
 (I[225] = (T)(img)(_n7##x,_n2##y,z,c)), \
 (I[244] = (T)(img)(_n7##x,_n3##y,z,c)), \
 (I[263] = (T)(img)(_n7##x,_n4##y,z,c)), \
 (I[282] = (T)(img)(_n7##x,_n5##y,z,c)), \
 (I[301] = (T)(img)(_n7##x,_n6##y,z,c)), \
 (I[320] = (T)(img)(_n7##x,_n7##y,z,c)), \
 (I[339] = (T)(img)(_n7##x,_n8##y,z,c)), \
 (I[358] = (T)(img)(_n7##x,_n9##y,z,c)), \
 (I[17] = (T)(img)(_n8##x,_p9##y,z,c)), \
 (I[36] = (T)(img)(_n8##x,_p8##y,z,c)), \
 (I[55] = (T)(img)(_n8##x,_p7##y,z,c)), \
 (I[74] = (T)(img)(_n8##x,_p6##y,z,c)), \
 (I[93] = (T)(img)(_n8##x,_p5##y,z,c)), \
 (I[112] = (T)(img)(_n8##x,_p4##y,z,c)), \
 (I[131] = (T)(img)(_n8##x,_p3##y,z,c)), \
 (I[150] = (T)(img)(_n8##x,_p2##y,z,c)), \
 (I[169] = (T)(img)(_n8##x,_p1##y,z,c)), \
 (I[188] = (T)(img)(_n8##x,y,z,c)), \
 (I[207] = (T)(img)(_n8##x,_n1##y,z,c)), \
 (I[226] = (T)(img)(_n8##x,_n2##y,z,c)), \
 (I[245] = (T)(img)(_n8##x,_n3##y,z,c)), \
 (I[264] = (T)(img)(_n8##x,_n4##y,z,c)), \
 (I[283] = (T)(img)(_n8##x,_n5##y,z,c)), \
 (I[302] = (T)(img)(_n8##x,_n6##y,z,c)), \
 (I[321] = (T)(img)(_n8##x,_n7##y,z,c)), \
 (I[340] = (T)(img)(_n8##x,_n8##y,z,c)), \
 (I[359] = (T)(img)(_n8##x,_n9##y,z,c)), \
 9>=((img)._width)?(img).width()-1:9); \
 (_n9##x<(img).width() && ( \
 (I[18] = (T)(img)(_n9##x,_p9##y,z,c)), \
 (I[37] = (T)(img)(_n9##x,_p8##y,z,c)), \
 (I[56] = (T)(img)(_n9##x,_p7##y,z,c)), \
 (I[75] = (T)(img)(_n9##x,_p6##y,z,c)), \
 (I[94] = (T)(img)(_n9##x,_p5##y,z,c)), \
 (I[113] = (T)(img)(_n9##x,_p4##y,z,c)), \
 (I[132] = (T)(img)(_n9##x,_p3##y,z,c)), \
 (I[151] = (T)(img)(_n9##x,_p2##y,z,c)), \
 (I[170] = (T)(img)(_n9##x,_p1##y,z,c)), \
 (I[189] = (T)(img)(_n9##x,y,z,c)), \
 (I[208] = (T)(img)(_n9##x,_n1##y,z,c)), \
 (I[227] = (T)(img)(_n9##x,_n2##y,z,c)), \
 (I[246] = (T)(img)(_n9##x,_n3##y,z,c)), \
 (I[265] = (T)(img)(_n9##x,_n4##y,z,c)), \
 (I[284] = (T)(img)(_n9##x,_n5##y,z,c)), \
 (I[303] = (T)(img)(_n9##x,_n6##y,z,c)), \
 (I[322] = (T)(img)(_n9##x,_n7##y,z,c)), \
 (I[341] = (T)(img)(_n9##x,_n8##y,z,c)), \
 (I[360] = (T)(img)(_n9##x,_n9##y,z,c)),1)) || \
 _n8##x==--_n9##x || _n7##x==--_n8##x || _n6##x==--_n7##x || _n5##x==--_n6##x || _n4##x==--_n5##x || _n3##x==--_n4##x || _n2##x==--_n3##x || _n1##x==--_n2##x || x==(_n9##x = _n8##x = _n7##x = _n6##x = _n5##x = _n4##x = _n3##x = _n2##x = --_n1##x); \
 I[0] = I[1], I[1] = I[2], I[2] = I[3], I[3] = I[4], I[4] = I[5], I[5] = I[6], I[6] = I[7], I[7] = I[8], I[8] = I[9], I[9] = I[10], I[10] = I[11], I[11] = I[12], I[12] = I[13], I[13] = I[14], I[14] = I[15], I[15] = I[16], I[16] = I[17], I[17] = I[18], \
 I[19] = I[20], I[20] = I[21], I[21] = I[22], I[22] = I[23], I[23] = I[24], I[24] = I[25], I[25] = I[26], I[26] = I[27], I[27] = I[28], I[28] = I[29], I[29] = I[30], I[30] = I[31], I[31] = I[32], I[32] = I[33], I[33] = I[34], I[34] = I[35], I[35] = I[36], I[36] = I[37], \
 I[38] = I[39], I[39] = I[40], I[40] = I[41], I[41] = I[42], I[42] = I[43], I[43] = I[44], I[44] = I[45], I[45] = I[46], I[46] = I[47], I[47] = I[48], I[48] = I[49], I[49] = I[50], I[50] = I[51], I[51] = I[52], I[52] = I[53], I[53] = I[54], I[54] = I[55], I[55] = I[56], \
 I[57] = I[58], I[58] = I[59], I[59] = I[60], I[60] = I[61], I[61] = I[62], I[62] = I[63], I[63] = I[64], I[64] = I[65], I[65] = I[66], I[66] = I[67], I[67] = I[68], I[68] = I[69], I[69] = I[70], I[70] = I[71], I[71] = I[72], I[72] = I[73], I[73] = I[74], I[74] = I[75], \
 I[76] = I[77], I[77] = I[78], I[78] = I[79], I[79] = I[80], I[80] = I[81], I[81] = I[82], I[82] = I[83], I[83] = I[84], I[84] = I[85], I[85] = I[86], I[86] = I[87], I[87] = I[88], I[88] = I[89], I[89] = I[90], I[90] = I[91], I[91] = I[92], I[92] = I[93], I[93] = I[94], \
 I[95] = I[96], I[96] = I[97], I[97] = I[98], I[98] = I[99], I[99] = I[100], I[100] = I[101], I[101] = I[102], I[102] = I[103], I[103] = I[104], I[104] = I[105], I[105] = I[106], I[106] = I[107], I[107] = I[108], I[108] = I[109], I[109] = I[110], I[110] = I[111], I[111] = I[112], I[112] = I[113], \
 I[114] = I[115], I[115] = I[116], I[116] = I[117], I[117] = I[118], I[118] = I[119], I[119] = I[120], I[120] = I[121], I[121] = I[122], I[122] = I[123], I[123] = I[124], I[124] = I[125], I[125] = I[126], I[126] = I[127], I[127] = I[128], I[128] = I[129], I[129] = I[130], I[130] = I[131], I[131] = I[132], \
 I[133] = I[134], I[134] = I[135], I[135] = I[136], I[136] = I[137], I[137] = I[138], I[138] = I[139], I[139] = I[140], I[140] = I[141], I[141] = I[142], I[142] = I[143], I[143] = I[144], I[144] = I[145], I[145] = I[146], I[146] = I[147], I[147] = I[148], I[148] = I[149], I[149] = I[150], I[150] = I[151], \
 I[152] = I[153], I[153] = I[154], I[154] = I[155], I[155] = I[156], I[156] = I[157], I[157] = I[158], I[158] = I[159], I[159] = I[160], I[160] = I[161], I[161] = I[162], I[162] = I[163], I[163] = I[164], I[164] = I[165], I[165] = I[166], I[166] = I[167], I[167] = I[168], I[168] = I[169], I[169] = I[170], \
 I[171] = I[172], I[172] = I[173], I[173] = I[174], I[174] = I[175], I[175] = I[176], I[176] = I[177], I[177] = I[178], I[178] = I[179], I[179] = I[180], I[180] = I[181], I[181] = I[182], I[182] = I[183], I[183] = I[184], I[184] = I[185], I[185] = I[186], I[186] = I[187], I[187] = I[188], I[188] = I[189], \
 I[190] = I[191], I[191] = I[192], I[192] = I[193], I[193] = I[194], I[194] = I[195], I[195] = I[196], I[196] = I[197], I[197] = I[198], I[198] = I[199], I[199] = I[200], I[200] = I[201], I[201] = I[202], I[202] = I[203], I[203] = I[204], I[204] = I[205], I[205] = I[206], I[206] = I[207], I[207] = I[208], \
 I[209] = I[210], I[210] = I[211], I[211] = I[212], I[212] = I[213], I[213] = I[214], I[214] = I[215], I[215] = I[216], I[216] = I[217], I[217] = I[218], I[218] = I[219], I[219] = I[220], I[220] = I[221], I[221] = I[222], I[222] = I[223], I[223] = I[224], I[224] = I[225], I[225] = I[226], I[226] = I[227], \
 I[228] = I[229], I[229] = I[230], I[230] = I[231], I[231] = I[232], I[232] = I[233], I[233] = I[234], I[234] = I[235], I[235] = I[236], I[236] = I[237], I[237] = I[238], I[238] = I[239], I[239] = I[240], I[240] = I[241], I[241] = I[242], I[242] = I[243], I[243] = I[244], I[244] = I[245], I[245] = I[246], \
 I[247] = I[248], I[248] = I[249], I[249] = I[250], I[250] = I[251], I[251] = I[252], I[252] = I[253], I[253] = I[254], I[254] = I[255], I[255] = I[256], I[256] = I[257], I[257] = I[258], I[258] = I[259], I[259] = I[260], I[260] = I[261], I[261] = I[262], I[262] = I[263], I[263] = I[264], I[264] = I[265], \
 I[266] = I[267], I[267] = I[268], I[268] = I[269], I[269] = I[270], I[270] = I[271], I[271] = I[272], I[272] = I[273], I[273] = I[274], I[274] = I[275], I[275] = I[276], I[276] = I[277], I[277] = I[278], I[278] = I[279], I[279] = I[280], I[280] = I[281], I[281] = I[282], I[282] = I[283], I[283] = I[284], \
 I[285] = I[286], I[286] = I[287], I[287] = I[288], I[288] = I[289], I[289] = I[290], I[290] = I[291], I[291] = I[292], I[292] = I[293], I[293] = I[294], I[294] = I[295], I[295] = I[296], I[296] = I[297], I[297] = I[298], I[298] = I[299], I[299] = I[300], I[300] = I[301], I[301] = I[302], I[302] = I[303], \
 I[304] = I[305], I[305] = I[306], I[306] = I[307], I[307] = I[308], I[308] = I[309], I[309] = I[310], I[310] = I[311], I[311] = I[312], I[312] = I[313], I[313] = I[314], I[314] = I[315], I[315] = I[316], I[316] = I[317], I[317] = I[318], I[318] = I[319], I[319] = I[320], I[320] = I[321], I[321] = I[322], \
 I[323] = I[324], I[324] = I[325], I[325] = I[326], I[326] = I[327], I[327] = I[328], I[328] = I[329], I[329] = I[330], I[330] = I[331], I[331] = I[332], I[332] = I[333], I[333] = I[334], I[334] = I[335], I[335] = I[336], I[336] = I[337], I[337] = I[338], I[338] = I[339], I[339] = I[340], I[340] = I[341], \
 I[342] = I[343], I[343] = I[344], I[344] = I[345], I[345] = I[346], I[346] = I[347], I[347] = I[348], I[348] = I[349], I[349] = I[350], I[350] = I[351], I[351] = I[352], I[352] = I[353], I[353] = I[354], I[354] = I[355], I[355] = I[356], I[356] = I[357], I[357] = I[358], I[358] = I[359], I[359] = I[360], \
 _p9##x = _p8##x, _p8##x = _p7##x, _p7##x = _p6##x, _p6##x = _p5##x, _p5##x = _p4##x, _p4##x = _p3##x, _p3##x = _p2##x, _p2##x = _p1##x, _p1##x = x++, ++_n1##x, ++_n2##x, ++_n3##x, ++_n4##x, ++_n5##x, ++_n6##x, ++_n7##x, ++_n8##x, ++_n9##x)

#define cimg_for_in19x19(img,x0,y0,x1,y1,x,y,z,c,I,T) \
 cimg_for_in19((img)._height,y0,y1,y) for (int x = (int)(x0)<0?0:(int)(x0), \
 _p9##x = x-9<0?0:x-9, \
 _p8##x = x-8<0?0:x-8, \
 _p7##x = x-7<0?0:x-7, \
 _p6##x = x-6<0?0:x-6, \
 _p5##x = x-5<0?0:x-5, \
 _p4##x = x-4<0?0:x-4, \
 _p3##x = x-3<0?0:x-3, \
 _p2##x = x-2<0?0:x-2, \
 _p1##x = x-1<0?0:x-1, \
 _n1##x = x+1>=(img).width()?(img).width()-1:x+1, \
 _n2##x = x+2>=(img).width()?(img).width()-1:x+2, \
 _n3##x = x+3>=(img).width()?(img).width()-1:x+3, \
 _n4##x = x+4>=(img).width()?(img).width()-1:x+4, \
 _n5##x = x+5>=(img).width()?(img).width()-1:x+5, \
 _n6##x = x+6>=(img).width()?(img).width()-1:x+6, \
 _n7##x = x+7>=(img).width()?(img).width()-1:x+7, \
 _n8##x = x+8>=(img).width()?(img).width()-1:x+8, \
 _n9##x = (int)( \
 (I[0] = (T)(img)(_p9##x,_p9##y,z,c)), \
 (I[19] = (T)(img)(_p9##x,_p8##y,z,c)), \
 (I[38] = (T)(img)(_p9##x,_p7##y,z,c)), \
 (I[57] = (T)(img)(_p9##x,_p6##y,z,c)), \
 (I[76] = (T)(img)(_p9##x,_p5##y,z,c)), \
 (I[95] = (T)(img)(_p9##x,_p4##y,z,c)), \
 (I[114] = (T)(img)(_p9##x,_p3##y,z,c)), \
 (I[133] = (T)(img)(_p9##x,_p2##y,z,c)), \
 (I[152] = (T)(img)(_p9##x,_p1##y,z,c)), \
 (I[171] = (T)(img)(_p9##x,y,z,c)), \
 (I[190] = (T)(img)(_p9##x,_n1##y,z,c)), \
 (I[209] = (T)(img)(_p9##x,_n2##y,z,c)), \
 (I[228] = (T)(img)(_p9##x,_n3##y,z,c)), \
 (I[247] = (T)(img)(_p9##x,_n4##y,z,c)), \
 (I[266] = (T)(img)(_p9##x,_n5##y,z,c)), \
 (I[285] = (T)(img)(_p9##x,_n6##y,z,c)), \
 (I[304] = (T)(img)(_p9##x,_n7##y,z,c)), \
 (I[323] = (T)(img)(_p9##x,_n8##y,z,c)), \
 (I[342] = (T)(img)(_p9##x,_n9##y,z,c)), \
 (I[1] = (T)(img)(_p8##x,_p9##y,z,c)), \
 (I[20] = (T)(img)(_p8##x,_p8##y,z,c)), \
 (I[39] = (T)(img)(_p8##x,_p7##y,z,c)), \
 (I[58] = (T)(img)(_p8##x,_p6##y,z,c)), \
 (I[77] = (T)(img)(_p8##x,_p5##y,z,c)), \
 (I[96] = (T)(img)(_p8##x,_p4##y,z,c)), \
 (I[115] = (T)(img)(_p8##x,_p3##y,z,c)), \
 (I[134] = (T)(img)(_p8##x,_p2##y,z,c)), \
 (I[153] = (T)(img)(_p8##x,_p1##y,z,c)), \
 (I[172] = (T)(img)(_p8##x,y,z,c)), \
 (I[191] = (T)(img)(_p8##x,_n1##y,z,c)), \
 (I[210] = (T)(img)(_p8##x,_n2##y,z,c)), \
 (I[229] = (T)(img)(_p8##x,_n3##y,z,c)), \
 (I[248] = (T)(img)(_p8##x,_n4##y,z,c)), \
 (I[267] = (T)(img)(_p8##x,_n5##y,z,c)), \
 (I[286] = (T)(img)(_p8##x,_n6##y,z,c)), \
 (I[305] = (T)(img)(_p8##x,_n7##y,z,c)), \
 (I[324] = (T)(img)(_p8##x,_n8##y,z,c)), \
 (I[343] = (T)(img)(_p8##x,_n9##y,z,c)), \
 (I[2] = (T)(img)(_p7##x,_p9##y,z,c)), \
 (I[21] = (T)(img)(_p7##x,_p8##y,z,c)), \
 (I[40] = (T)(img)(_p7##x,_p7##y,z,c)), \
 (I[59] = (T)(img)(_p7##x,_p6##y,z,c)), \
 (I[78] = (T)(img)(_p7##x,_p5##y,z,c)), \
 (I[97] = (T)(img)(_p7##x,_p4##y,z,c)), \
 (I[116] = (T)(img)(_p7##x,_p3##y,z,c)), \
 (I[135] = (T)(img)(_p7##x,_p2##y,z,c)), \
 (I[154] = (T)(img)(_p7##x,_p1##y,z,c)), \
 (I[173] = (T)(img)(_p7##x,y,z,c)), \
 (I[192] = (T)(img)(_p7##x,_n1##y,z,c)), \
 (I[211] = (T)(img)(_p7##x,_n2##y,z,c)), \
 (I[230] = (T)(img)(_p7##x,_n3##y,z,c)), \
 (I[249] = (T)(img)(_p7##x,_n4##y,z,c)), \
 (I[268] = (T)(img)(_p7##x,_n5##y,z,c)), \
 (I[287] = (T)(img)(_p7##x,_n6##y,z,c)), \
 (I[306] = (T)(img)(_p7##x,_n7##y,z,c)), \
 (I[325] = (T)(img)(_p7##x,_n8##y,z,c)), \
 (I[344] = (T)(img)(_p7##x,_n9##y,z,c)), \
 (I[3] = (T)(img)(_p6##x,_p9##y,z,c)), \
 (I[22] = (T)(img)(_p6##x,_p8##y,z,c)), \
 (I[41] = (T)(img)(_p6##x,_p7##y,z,c)), \
 (I[60] = (T)(img)(_p6##x,_p6##y,z,c)), \
 (I[79] = (T)(img)(_p6##x,_p5##y,z,c)), \
 (I[98] = (T)(img)(_p6##x,_p4##y,z,c)), \
 (I[117] = (T)(img)(_p6##x,_p3##y,z,c)), \
 (I[136] = (T)(img)(_p6##x,_p2##y,z,c)), \
 (I[155] = (T)(img)(_p6##x,_p1##y,z,c)), \
 (I[174] = (T)(img)(_p6##x,y,z,c)), \
 (I[193] = (T)(img)(_p6##x,_n1##y,z,c)), \
 (I[212] = (T)(img)(_p6##x,_n2##y,z,c)), \
 (I[231] = (T)(img)(_p6##x,_n3##y,z,c)), \
 (I[250] = (T)(img)(_p6##x,_n4##y,z,c)), \
 (I[269] = (T)(img)(_p6##x,_n5##y,z,c)), \
 (I[288] = (T)(img)(_p6##x,_n6##y,z,c)), \
 (I[307] = (T)(img)(_p6##x,_n7##y,z,c)), \
 (I[326] = (T)(img)(_p6##x,_n8##y,z,c)), \
 (I[345] = (T)(img)(_p6##x,_n9##y,z,c)), \
 (I[4] = (T)(img)(_p5##x,_p9##y,z,c)), \
 (I[23] = (T)(img)(_p5##x,_p8##y,z,c)), \
 (I[42] = (T)(img)(_p5##x,_p7##y,z,c)), \
 (I[61] = (T)(img)(_p5##x,_p6##y,z,c)), \
 (I[80] = (T)(img)(_p5##x,_p5##y,z,c)), \
 (I[99] = (T)(img)(_p5##x,_p4##y,z,c)), \
 (I[118] = (T)(img)(_p5##x,_p3##y,z,c)), \
 (I[137] = (T)(img)(_p5##x,_p2##y,z,c)), \
 (I[156] = (T)(img)(_p5##x,_p1##y,z,c)), \
 (I[175] = (T)(img)(_p5##x,y,z,c)), \
 (I[194] = (T)(img)(_p5##x,_n1##y,z,c)), \
 (I[213] = (T)(img)(_p5##x,_n2##y,z,c)), \
 (I[232] = (T)(img)(_p5##x,_n3##y,z,c)), \
 (I[251] = (T)(img)(_p5##x,_n4##y,z,c)), \
 (I[270] = (T)(img)(_p5##x,_n5##y,z,c)), \
 (I[289] = (T)(img)(_p5##x,_n6##y,z,c)), \
 (I[308] = (T)(img)(_p5##x,_n7##y,z,c)), \
 (I[327] = (T)(img)(_p5##x,_n8##y,z,c)), \
 (I[346] = (T)(img)(_p5##x,_n9##y,z,c)), \
 (I[5] = (T)(img)(_p4##x,_p9##y,z,c)), \
 (I[24] = (T)(img)(_p4##x,_p8##y,z,c)), \
 (I[43] = (T)(img)(_p4##x,_p7##y,z,c)), \
 (I[62] = (T)(img)(_p4##x,_p6##y,z,c)), \
 (I[81] = (T)(img)(_p4##x,_p5##y,z,c)), \
 (I[100] = (T)(img)(_p4##x,_p4##y,z,c)), \
 (I[119] = (T)(img)(_p4##x,_p3##y,z,c)), \
 (I[138] = (T)(img)(_p4##x,_p2##y,z,c)), \
 (I[157] = (T)(img)(_p4##x,_p1##y,z,c)), \
 (I[176] = (T)(img)(_p4##x,y,z,c)), \
 (I[195] = (T)(img)(_p4##x,_n1##y,z,c)), \
 (I[214] = (T)(img)(_p4##x,_n2##y,z,c)), \
 (I[233] = (T)(img)(_p4##x,_n3##y,z,c)), \
 (I[252] = (T)(img)(_p4##x,_n4##y,z,c)), \
 (I[271] = (T)(img)(_p4##x,_n5##y,z,c)), \
 (I[290] = (T)(img)(_p4##x,_n6##y,z,c)), \
 (I[309] = (T)(img)(_p4##x,_n7##y,z,c)), \
 (I[328] = (T)(img)(_p4##x,_n8##y,z,c)), \
 (I[347] = (T)(img)(_p4##x,_n9##y,z,c)), \
 (I[6] = (T)(img)(_p3##x,_p9##y,z,c)), \
 (I[25] = (T)(img)(_p3##x,_p8##y,z,c)), \
 (I[44] = (T)(img)(_p3##x,_p7##y,z,c)), \
 (I[63] = (T)(img)(_p3##x,_p6##y,z,c)), \
 (I[82] = (T)(img)(_p3##x,_p5##y,z,c)), \
 (I[101] = (T)(img)(_p3##x,_p4##y,z,c)), \
 (I[120] = (T)(img)(_p3##x,_p3##y,z,c)), \
 (I[139] = (T)(img)(_p3##x,_p2##y,z,c)), \
 (I[158] = (T)(img)(_p3##x,_p1##y,z,c)), \
 (I[177] = (T)(img)(_p3##x,y,z,c)), \
 (I[196] = (T)(img)(_p3##x,_n1##y,z,c)), \
 (I[215] = (T)(img)(_p3##x,_n2##y,z,c)), \
 (I[234] = (T)(img)(_p3##x,_n3##y,z,c)), \
 (I[253] = (T)(img)(_p3##x,_n4##y,z,c)), \
 (I[272] = (T)(img)(_p3##x,_n5##y,z,c)), \
 (I[291] = (T)(img)(_p3##x,_n6##y,z,c)), \
 (I[310] = (T)(img)(_p3##x,_n7##y,z,c)), \
 (I[329] = (T)(img)(_p3##x,_n8##y,z,c)), \
 (I[348] = (T)(img)(_p3##x,_n9##y,z,c)), \
 (I[7] = (T)(img)(_p2##x,_p9##y,z,c)), \
 (I[26] = (T)(img)(_p2##x,_p8##y,z,c)), \
 (I[45] = (T)(img)(_p2##x,_p7##y,z,c)), \
 (I[64] = (T)(img)(_p2##x,_p6##y,z,c)), \
 (I[83] = (T)(img)(_p2##x,_p5##y,z,c)), \
 (I[102] = (T)(img)(_p2##x,_p4##y,z,c)), \
 (I[121] = (T)(img)(_p2##x,_p3##y,z,c)), \
 (I[140] = (T)(img)(_p2##x,_p2##y,z,c)), \
 (I[159] = (T)(img)(_p2##x,_p1##y,z,c)), \
 (I[178] = (T)(img)(_p2##x,y,z,c)), \
 (I[197] = (T)(img)(_p2##x,_n1##y,z,c)), \
 (I[216] = (T)(img)(_p2##x,_n2##y,z,c)), \
 (I[235] = (T)(img)(_p2##x,_n3##y,z,c)), \
 (I[254] = (T)(img)(_p2##x,_n4##y,z,c)), \
 (I[273] = (T)(img)(_p2##x,_n5##y,z,c)), \
 (I[292] = (T)(img)(_p2##x,_n6##y,z,c)), \
 (I[311] = (T)(img)(_p2##x,_n7##y,z,c)), \
 (I[330] = (T)(img)(_p2##x,_n8##y,z,c)), \
 (I[349] = (T)(img)(_p2##x,_n9##y,z,c)), \
 (I[8] = (T)(img)(_p1##x,_p9##y,z,c)), \
 (I[27] = (T)(img)(_p1##x,_p8##y,z,c)), \
 (I[46] = (T)(img)(_p1##x,_p7##y,z,c)), \
 (I[65] = (T)(img)(_p1##x,_p6##y,z,c)), \
 (I[84] = (T)(img)(_p1##x,_p5##y,z,c)), \
 (I[103] = (T)(img)(_p1##x,_p4##y,z,c)), \
 (I[122] = (T)(img)(_p1##x,_p3##y,z,c)), \
 (I[141] = (T)(img)(_p1##x,_p2##y,z,c)), \
 (I[160] = (T)(img)(_p1##x,_p1##y,z,c)), \
 (I[179] = (T)(img)(_p1##x,y,z,c)), \
 (I[198] = (T)(img)(_p1##x,_n1##y,z,c)), \
 (I[217] = (T)(img)(_p1##x,_n2##y,z,c)), \
 (I[236] = (T)(img)(_p1##x,_n3##y,z,c)), \
 (I[255] = (T)(img)(_p1##x,_n4##y,z,c)), \
 (I[274] = (T)(img)(_p1##x,_n5##y,z,c)), \
 (I[293] = (T)(img)(_p1##x,_n6##y,z,c)), \
 (I[312] = (T)(img)(_p1##x,_n7##y,z,c)), \
 (I[331] = (T)(img)(_p1##x,_n8##y,z,c)), \
 (I[350] = (T)(img)(_p1##x,_n9##y,z,c)), \
 (I[9] = (T)(img)(x,_p9##y,z,c)), \
 (I[28] = (T)(img)(x,_p8##y,z,c)), \
 (I[47] = (T)(img)(x,_p7##y,z,c)), \
 (I[66] = (T)(img)(x,_p6##y,z,c)), \
 (I[85] = (T)(img)(x,_p5##y,z,c)), \
 (I[104] = (T)(img)(x,_p4##y,z,c)), \
 (I[123] = (T)(img)(x,_p3##y,z,c)), \
 (I[142] = (T)(img)(x,_p2##y,z,c)), \
 (I[161] = (T)(img)(x,_p1##y,z,c)), \
 (I[180] = (T)(img)(x,y,z,c)), \
 (I[199] = (T)(img)(x,_n1##y,z,c)), \
 (I[218] = (T)(img)(x,_n2##y,z,c)), \
 (I[237] = (T)(img)(x,_n3##y,z,c)), \
 (I[256] = (T)(img)(x,_n4##y,z,c)), \
 (I[275] = (T)(img)(x,_n5##y,z,c)), \
 (I[294] = (T)(img)(x,_n6##y,z,c)), \
 (I[313] = (T)(img)(x,_n7##y,z,c)), \
 (I[332] = (T)(img)(x,_n8##y,z,c)), \
 (I[351] = (T)(img)(x,_n9##y,z,c)), \
 (I[10] = (T)(img)(_n1##x,_p9##y,z,c)), \
 (I[29] = (T)(img)(_n1##x,_p8##y,z,c)), \
 (I[48] = (T)(img)(_n1##x,_p7##y,z,c)), \
 (I[67] = (T)(img)(_n1##x,_p6##y,z,c)), \
 (I[86] = (T)(img)(_n1##x,_p5##y,z,c)), \
 (I[105] = (T)(img)(_n1##x,_p4##y,z,c)), \
 (I[124] = (T)(img)(_n1##x,_p3##y,z,c)), \
 (I[143] = (T)(img)(_n1##x,_p2##y,z,c)), \
 (I[162] = (T)(img)(_n1##x,_p1##y,z,c)), \
 (I[181] = (T)(img)(_n1##x,y,z,c)), \
 (I[200] = (T)(img)(_n1##x,_n1##y,z,c)), \
 (I[219] = (T)(img)(_n1##x,_n2##y,z,c)), \
 (I[238] = (T)(img)(_n1##x,_n3##y,z,c)), \
 (I[257] = (T)(img)(_n1##x,_n4##y,z,c)), \
 (I[276] = (T)(img)(_n1##x,_n5##y,z,c)), \
 (I[295] = (T)(img)(_n1##x,_n6##y,z,c)), \
 (I[314] = (T)(img)(_n1##x,_n7##y,z,c)), \
 (I[333] = (T)(img)(_n1##x,_n8##y,z,c)), \
 (I[352] = (T)(img)(_n1##x,_n9##y,z,c)), \
 (I[11] = (T)(img)(_n2##x,_p9##y,z,c)), \
 (I[30] = (T)(img)(_n2##x,_p8##y,z,c)), \
 (I[49] = (T)(img)(_n2##x,_p7##y,z,c)), \
 (I[68] = (T)(img)(_n2##x,_p6##y,z,c)), \
 (I[87] = (T)(img)(_n2##x,_p5##y,z,c)), \
 (I[106] = (T)(img)(_n2##x,_p4##y,z,c)), \
 (I[125] = (T)(img)(_n2##x,_p3##y,z,c)), \
 (I[144] = (T)(img)(_n2##x,_p2##y,z,c)), \
 (I[163] = (T)(img)(_n2##x,_p1##y,z,c)), \
 (I[182] = (T)(img)(_n2##x,y,z,c)), \
 (I[201] = (T)(img)(_n2##x,_n1##y,z,c)), \
 (I[220] = (T)(img)(_n2##x,_n2##y,z,c)), \
 (I[239] = (T)(img)(_n2##x,_n3##y,z,c)), \
 (I[258] = (T)(img)(_n2##x,_n4##y,z,c)), \
 (I[277] = (T)(img)(_n2##x,_n5##y,z,c)), \
 (I[296] = (T)(img)(_n2##x,_n6##y,z,c)), \
 (I[315] = (T)(img)(_n2##x,_n7##y,z,c)), \
 (I[334] = (T)(img)(_n2##x,_n8##y,z,c)), \
 (I[353] = (T)(img)(_n2##x,_n9##y,z,c)), \
 (I[12] = (T)(img)(_n3##x,_p9##y,z,c)), \
 (I[31] = (T)(img)(_n3##x,_p8##y,z,c)), \
 (I[50] = (T)(img)(_n3##x,_p7##y,z,c)), \
 (I[69] = (T)(img)(_n3##x,_p6##y,z,c)), \
 (I[88] = (T)(img)(_n3##x,_p5##y,z,c)), \
 (I[107] = (T)(img)(_n3##x,_p4##y,z,c)), \
 (I[126] = (T)(img)(_n3##x,_p3##y,z,c)), \
 (I[145] = (T)(img)(_n3##x,_p2##y,z,c)), \
 (I[164] = (T)(img)(_n3##x,_p1##y,z,c)), \
 (I[183] = (T)(img)(_n3##x,y,z,c)), \
 (I[202] = (T)(img)(_n3##x,_n1##y,z,c)), \
 (I[221] = (T)(img)(_n3##x,_n2##y,z,c)), \
 (I[240] = (T)(img)(_n3##x,_n3##y,z,c)), \
 (I[259] = (T)(img)(_n3##x,_n4##y,z,c)), \
 (I[278] = (T)(img)(_n3##x,_n5##y,z,c)), \
 (I[297] = (T)(img)(_n3##x,_n6##y,z,c)), \
 (I[316] = (T)(img)(_n3##x,_n7##y,z,c)), \
 (I[335] = (T)(img)(_n3##x,_n8##y,z,c)), \
 (I[354] = (T)(img)(_n3##x,_n9##y,z,c)), \
 (I[13] = (T)(img)(_n4##x,_p9##y,z,c)), \
 (I[32] = (T)(img)(_n4##x,_p8##y,z,c)), \
 (I[51] = (T)(img)(_n4##x,_p7##y,z,c)), \
 (I[70] = (T)(img)(_n4##x,_p6##y,z,c)), \
 (I[89] = (T)(img)(_n4##x,_p5##y,z,c)), \
 (I[108] = (T)(img)(_n4##x,_p4##y,z,c)), \
 (I[127] = (T)(img)(_n4##x,_p3##y,z,c)), \
 (I[146] = (T)(img)(_n4##x,_p2##y,z,c)), \
 (I[165] = (T)(img)(_n4##x,_p1##y,z,c)), \
 (I[184] = (T)(img)(_n4##x,y,z,c)), \
 (I[203] = (T)(img)(_n4##x,_n1##y,z,c)), \
 (I[222] = (T)(img)(_n4##x,_n2##y,z,c)), \
 (I[241] = (T)(img)(_n4##x,_n3##y,z,c)), \
 (I[260] = (T)(img)(_n4##x,_n4##y,z,c)), \
 (I[279] = (T)(img)(_n4##x,_n5##y,z,c)), \
 (I[298] = (T)(img)(_n4##x,_n6##y,z,c)), \
 (I[317] = (T)(img)(_n4##x,_n7##y,z,c)), \
 (I[336] = (T)(img)(_n4##x,_n8##y,z,c)), \
 (I[355] = (T)(img)(_n4##x,_n9##y,z,c)), \
 (I[14] = (T)(img)(_n5##x,_p9##y,z,c)), \
 (I[33] = (T)(img)(_n5##x,_p8##y,z,c)), \
 (I[52] = (T)(img)(_n5##x,_p7##y,z,c)), \
 (I[71] = (T)(img)(_n5##x,_p6##y,z,c)), \
 (I[90] = (T)(img)(_n5##x,_p5##y,z,c)), \
 (I[109] = (T)(img)(_n5##x,_p4##y,z,c)), \
 (I[128] = (T)(img)(_n5##x,_p3##y,z,c)), \
 (I[147] = (T)(img)(_n5##x,_p2##y,z,c)), \
 (I[166] = (T)(img)(_n5##x,_p1##y,z,c)), \
 (I[185] = (T)(img)(_n5##x,y,z,c)), \
 (I[204] = (T)(img)(_n5##x,_n1##y,z,c)), \
 (I[223] = (T)(img)(_n5##x,_n2##y,z,c)), \
 (I[242] = (T)(img)(_n5##x,_n3##y,z,c)), \
 (I[261] = (T)(img)(_n5##x,_n4##y,z,c)), \
 (I[280] = (T)(img)(_n5##x,_n5##y,z,c)), \
 (I[299] = (T)(img)(_n5##x,_n6##y,z,c)), \
 (I[318] = (T)(img)(_n5##x,_n7##y,z,c)), \
 (I[337] = (T)(img)(_n5##x,_n8##y,z,c)), \
 (I[356] = (T)(img)(_n5##x,_n9##y,z,c)), \
 (I[15] = (T)(img)(_n6##x,_p9##y,z,c)), \
 (I[34] = (T)(img)(_n6##x,_p8##y,z,c)), \
 (I[53] = (T)(img)(_n6##x,_p7##y,z,c)), \
 (I[72] = (T)(img)(_n6##x,_p6##y,z,c)), \
 (I[91] = (T)(img)(_n6##x,_p5##y,z,c)), \
 (I[110] = (T)(img)(_n6##x,_p4##y,z,c)), \
 (I[129] = (T)(img)(_n6##x,_p3##y,z,c)), \
 (I[148] = (T)(img)(_n6##x,_p2##y,z,c)), \
 (I[167] = (T)(img)(_n6##x,_p1##y,z,c)), \
 (I[186] = (T)(img)(_n6##x,y,z,c)), \
 (I[205] = (T)(img)(_n6##x,_n1##y,z,c)), \
 (I[224] = (T)(img)(_n6##x,_n2##y,z,c)), \
 (I[243] = (T)(img)(_n6##x,_n3##y,z,c)), \
 (I[262] = (T)(img)(_n6##x,_n4##y,z,c)), \
 (I[281] = (T)(img)(_n6##x,_n5##y,z,c)), \
 (I[300] = (T)(img)(_n6##x,_n6##y,z,c)), \
 (I[319] = (T)(img)(_n6##x,_n7##y,z,c)), \
 (I[338] = (T)(img)(_n6##x,_n8##y,z,c)), \
 (I[357] = (T)(img)(_n6##x,_n9##y,z,c)), \
 (I[16] = (T)(img)(_n7##x,_p9##y,z,c)), \
 (I[35] = (T)(img)(_n7##x,_p8##y,z,c)), \
 (I[54] = (T)(img)(_n7##x,_p7##y,z,c)), \
 (I[73] = (T)(img)(_n7##x,_p6##y,z,c)), \
 (I[92] = (T)(img)(_n7##x,_p5##y,z,c)), \
 (I[111] = (T)(img)(_n7##x,_p4##y,z,c)), \
 (I[130] = (T)(img)(_n7##x,_p3##y,z,c)), \
 (I[149] = (T)(img)(_n7##x,_p2##y,z,c)), \
 (I[168] = (T)(img)(_n7##x,_p1##y,z,c)), \
 (I[187] = (T)(img)(_n7##x,y,z,c)), \
 (I[206] = (T)(img)(_n7##x,_n1##y,z,c)), \
 (I[225] = (T)(img)(_n7##x,_n2##y,z,c)), \
 (I[244] = (T)(img)(_n7##x,_n3##y,z,c)), \
 (I[263] = (T)(img)(_n7##x,_n4##y,z,c)), \
 (I[282] = (T)(img)(_n7##x,_n5##y,z,c)), \
 (I[301] = (T)(img)(_n7##x,_n6##y,z,c)), \
 (I[320] = (T)(img)(_n7##x,_n7##y,z,c)), \
 (I[339] = (T)(img)(_n7##x,_n8##y,z,c)), \
 (I[358] = (T)(img)(_n7##x,_n9##y,z,c)), \
 (I[17] = (T)(img)(_n8##x,_p9##y,z,c)), \
 (I[36] = (T)(img)(_n8##x,_p8##y,z,c)), \
 (I[55] = (T)(img)(_n8##x,_p7##y,z,c)), \
 (I[74] = (T)(img)(_n8##x,_p6##y,z,c)), \
 (I[93] = (T)(img)(_n8##x,_p5##y,z,c)), \
 (I[112] = (T)(img)(_n8##x,_p4##y,z,c)), \
 (I[131] = (T)(img)(_n8##x,_p3##y,z,c)), \
 (I[150] = (T)(img)(_n8##x,_p2##y,z,c)), \
 (I[169] = (T)(img)(_n8##x,_p1##y,z,c)), \
 (I[188] = (T)(img)(_n8##x,y,z,c)), \
 (I[207] = (T)(img)(_n8##x,_n1##y,z,c)), \
 (I[226] = (T)(img)(_n8##x,_n2##y,z,c)), \
 (I[245] = (T)(img)(_n8##x,_n3##y,z,c)), \
 (I[264] = (T)(img)(_n8##x,_n4##y,z,c)), \
 (I[283] = (T)(img)(_n8##x,_n5##y,z,c)), \
 (I[302] = (T)(img)(_n8##x,_n6##y,z,c)), \
 (I[321] = (T)(img)(_n8##x,_n7##y,z,c)), \
 (I[340] = (T)(img)(_n8##x,_n8##y,z,c)), \
 (I[359] = (T)(img)(_n8##x,_n9##y,z,c)), \
 x+9>=(img).width()?(img).width()-1:x+9); \
 x<=(int)(x1) && ((_n9##x<(img).width() && ( \
 (I[18] = (T)(img)(_n9##x,_p9##y,z,c)), \
 (I[37] = (T)(img)(_n9##x,_p8##y,z,c)), \
 (I[56] = (T)(img)(_n9##x,_p7##y,z,c)), \
 (I[75] = (T)(img)(_n9##x,_p6##y,z,c)), \
 (I[94] = (T)(img)(_n9##x,_p5##y,z,c)), \
 (I[113] = (T)(img)(_n9##x,_p4##y,z,c)), \
 (I[132] = (T)(img)(_n9##x,_p3##y,z,c)), \
 (I[151] = (T)(img)(_n9##x,_p2##y,z,c)), \
 (I[170] = (T)(img)(_n9##x,_p1##y,z,c)), \
 (I[189] = (T)(img)(_n9##x,y,z,c)), \
 (I[208] = (T)(img)(_n9##x,_n1##y,z,c)), \
 (I[227] = (T)(img)(_n9##x,_n2##y,z,c)), \
 (I[246] = (T)(img)(_n9##x,_n3##y,z,c)), \
 (I[265] = (T)(img)(_n9##x,_n4##y,z,c)), \
 (I[284] = (T)(img)(_n9##x,_n5##y,z,c)), \
 (I[303] = (T)(img)(_n9##x,_n6##y,z,c)), \
 (I[322] = (T)(img)(_n9##x,_n7##y,z,c)), \
 (I[341] = (T)(img)(_n9##x,_n8##y,z,c)), \
 (I[360] = (T)(img)(_n9##x,_n9##y,z,c)),1)) || \
 _n8##x==--_n9##x || _n7##x==--_n8##x || _n6##x==--_n7##x || _n5##x==--_n6##x || _n4##x==--_n5##x || _n3##x==--_n4##x || _n2##x==--_n3##x || _n1##x==--_n2##x || x==(_n9##x = _n8##x = _n7##x = _n6##x = _n5##x = _n4##x = _n3##x = _n2##x = --_n1##x)); \
 I[0] = I[1], I[1] = I[2], I[2] = I[3], I[3] = I[4], I[4] = I[5], I[5] = I[6], I[6] = I[7], I[7] = I[8], I[8] = I[9], I[9] = I[10], I[10] = I[11], I[11] = I[12], I[12] = I[13], I[13] = I[14], I[14] = I[15], I[15] = I[16], I[16] = I[17], I[17] = I[18], \
 I[19] = I[20], I[20] = I[21], I[21] = I[22], I[22] = I[23], I[23] = I[24], I[24] = I[25], I[25] = I[26], I[26] = I[27], I[27] = I[28], I[28] = I[29], I[29] = I[30], I[30] = I[31], I[31] = I[32], I[32] = I[33], I[33] = I[34], I[34] = I[35], I[35] = I[36], I[36] = I[37], \
 I[38] = I[39], I[39] = I[40], I[40] = I[41], I[41] = I[42], I[42] = I[43], I[43] = I[44], I[44] = I[45], I[45] = I[46], I[46] = I[47], I[47] = I[48], I[48] = I[49], I[49] = I[50], I[50] = I[51], I[51] = I[52], I[52] = I[53], I[53] = I[54], I[54] = I[55], I[55] = I[56], \
 I[57] = I[58], I[58] = I[59], I[59] = I[60], I[60] = I[61], I[61] = I[62], I[62] = I[63], I[63] = I[64], I[64] = I[65], I[65] = I[66], I[66] = I[67], I[67] = I[68], I[68] = I[69], I[69] = I[70], I[70] = I[71], I[71] = I[72], I[72] = I[73], I[73] = I[74], I[74] = I[75], \
 I[76] = I[77], I[77] = I[78], I[78] = I[79], I[79] = I[80], I[80] = I[81], I[81] = I[82], I[82] = I[83], I[83] = I[84], I[84] = I[85], I[85] = I[86], I[86] = I[87], I[87] = I[88], I[88] = I[89], I[89] = I[90], I[90] = I[91], I[91] = I[92], I[92] = I[93], I[93] = I[94], \
 I[95] = I[96], I[96] = I[97], I[97] = I[98], I[98] = I[99], I[99] = I[100], I[100] = I[101], I[101] = I[102], I[102] = I[103], I[103] = I[104], I[104] = I[105], I[105] = I[106], I[106] = I[107], I[107] = I[108], I[108] = I[109], I[109] = I[110], I[110] = I[111], I[111] = I[112], I[112] = I[113], \
 I[114] = I[115], I[115] = I[116], I[116] = I[117], I[117] = I[118], I[118] = I[119], I[119] = I[120], I[120] = I[121], I[121] = I[122], I[122] = I[123], I[123] = I[124], I[124] = I[125], I[125] = I[126], I[126] = I[127], I[127] = I[128], I[128] = I[129], I[129] = I[130], I[130] = I[131], I[131] = I[132], \
 I[133] = I[134], I[134] = I[135], I[135] = I[136], I[136] = I[137], I[137] = I[138], I[138] = I[139], I[139] = I[140], I[140] = I[141], I[141] = I[142], I[142] = I[143], I[143] = I[144], I[144] = I[145], I[145] = I[146], I[146] = I[147], I[147] = I[148], I[148] = I[149], I[149] = I[150], I[150] = I[151], \
 I[152] = I[153], I[153] = I[154], I[154] = I[155], I[155] = I[156], I[156] = I[157], I[157] = I[158], I[158] = I[159], I[159] = I[160], I[160] = I[161], I[161] = I[162], I[162] = I[163], I[163] = I[164], I[164] = I[165], I[165] = I[166], I[166] = I[167], I[167] = I[168], I[168] = I[169], I[169] = I[170], \
 I[171] = I[172], I[172] = I[173], I[173] = I[174], I[174] = I[175], I[175] = I[176], I[176] = I[177], I[177] = I[178], I[178] = I[179], I[179] = I[180], I[180] = I[181], I[181] = I[182], I[182] = I[183], I[183] = I[184], I[184] = I[185], I[185] = I[186], I[186] = I[187], I[187] = I[188], I[188] = I[189], \
 I[190] = I[191], I[191] = I[192], I[192] = I[193], I[193] = I[194], I[194] = I[195], I[195] = I[196], I[196] = I[197], I[197] = I[198], I[198] = I[199], I[199] = I[200], I[200] = I[201], I[201] = I[202], I[202] = I[203], I[203] = I[204], I[204] = I[205], I[205] = I[206], I[206] = I[207], I[207] = I[208], \
 I[209] = I[210], I[210] = I[211], I[211] = I[212], I[212] = I[213], I[213] = I[214], I[214] = I[215], I[215] = I[216], I[216] = I[217], I[217] = I[218], I[218] = I[219], I[219] = I[220], I[220] = I[221], I[221] = I[222], I[222] = I[223], I[223] = I[224], I[224] = I[225], I[225] = I[226], I[226] = I[227], \
 I[228] = I[229], I[229] = I[230], I[230] = I[231], I[231] = I[232], I[232] = I[233], I[233] = I[234], I[234] = I[235], I[235] = I[236], I[236] = I[237], I[237] = I[238], I[238] = I[239], I[239] = I[240], I[240] = I[241], I[241] = I[242], I[242] = I[243], I[243] = I[244], I[244] = I[245], I[245] = I[246], \
 I[247] = I[248], I[248] = I[249], I[249] = I[250], I[250] = I[251], I[251] = I[252], I[252] = I[253], I[253] = I[254], I[254] = I[255], I[255] = I[256], I[256] = I[257], I[257] = I[258], I[258] = I[259], I[259] = I[260], I[260] = I[261], I[261] = I[262], I[262] = I[263], I[263] = I[264], I[264] = I[265], \
 I[266] = I[267], I[267] = I[268], I[268] = I[269], I[269] = I[270], I[270] = I[271], I[271] = I[272], I[272] = I[273], I[273] = I[274], I[274] = I[275], I[275] = I[276], I[276] = I[277], I[277] = I[278], I[278] = I[279], I[279] = I[280], I[280] = I[281], I[281] = I[282], I[282] = I[283], I[283] = I[284], \
 I[285] = I[286], I[286] = I[287], I[287] = I[288], I[288] = I[289], I[289] = I[290], I[290] = I[291], I[291] = I[292], I[292] = I[293], I[293] = I[294], I[294] = I[295], I[295] = I[296], I[296] = I[297], I[297] = I[298], I[298] = I[299], I[299] = I[300], I[300] = I[301], I[301] = I[302], I[302] = I[303], \
 I[304] = I[305], I[305] = I[306], I[306] = I[307], I[307] = I[308], I[308] = I[309], I[309] = I[310], I[310] = I[311], I[311] = I[312], I[312] = I[313], I[313] = I[314], I[314] = I[315], I[315] = I[316], I[316] = I[317], I[317] = I[318], I[318] = I[319], I[319] = I[320], I[320] = I[321], I[321] = I[322], \
 I[323] = I[324], I[324] = I[325], I[325] = I[326], I[326] = I[327], I[327] = I[328], I[328] = I[329], I[329] = I[330], I[330] = I[331], I[331] = I[332], I[332] = I[333], I[333] = I[334], I[334] = I[335], I[335] = I[336], I[336] = I[337], I[337] = I[338], I[338] = I[339], I[339] = I[340], I[340] = I[341], \
 I[342] = I[343], I[343] = I[344], I[344] = I[345], I[345] = I[346], I[346] = I[347], I[347] = I[348], I[348] = I[349], I[349] = I[350], I[350] = I[351], I[351] = I[352], I[352] = I[353], I[353] = I[354], I[354] = I[355], I[355] = I[356], I[356] = I[357], I[357] = I[358], I[358] = I[359], I[359] = I[360], \
 _p9##x = _p8##x, _p8##x = _p7##x, _p7##x = _p6##x, _p6##x = _p5##x, _p5##x = _p4##x, _p4##x = _p3##x, _p3##x = _p2##x, _p2##x = _p1##x, _p1##x = x++, ++_n1##x, ++_n2##x, ++_n3##x, ++_n4##x, ++_n5##x, ++_n6##x, ++_n7##x, ++_n8##x, ++_n9##x)

#define cimg_get19x19(img,x,y,z,c,I,T) \
 I[0] = (T)(img)(_p9##x,_p9##y,z,c), I[1] = (T)(img)(_p8##x,_p9##y,z,c), I[2] = (T)(img)(_p7##x,_p9##y,z,c), I[3] = (T)(img)(_p6##x,_p9##y,z,c), I[4] = (T)(img)(_p5##x,_p9##y,z,c), I[5] = (T)(img)(_p4##x,_p9##y,z,c), I[6] = (T)(img)(_p3##x,_p9##y,z,c), I[7] = (T)(img)(_p2##x,_p9##y,z,c), I[8] = (T)(img)(_p1##x,_p9##y,z,c), I[9] = (T)(img)(x,_p9##y,z,c), I[10] = (T)(img)(_n1##x,_p9##y,z,c), I[11] = (T)(img)(_n2##x,_p9##y,z,c), I[12] = (T)(img)(_n3##x,_p9##y,z,c), I[13] = (T)(img)(_n4##x,_p9##y,z,c), I[14] = (T)(img)(_n5##x,_p9##y,z,c), I[15] = (T)(img)(_n6##x,_p9##y,z,c), I[16] = (T)(img)(_n7##x,_p9##y,z,c), I[17] = (T)(img)(_n8##x,_p9##y,z,c), I[18] = (T)(img)(_n9##x,_p9##y,z,c), \
 I[19] = (T)(img)(_p9##x,_p8##y,z,c), I[20] = (T)(img)(_p8##x,_p8##y,z,c), I[21] = (T)(img)(_p7##x,_p8##y,z,c), I[22] = (T)(img)(_p6##x,_p8##y,z,c), I[23] = (T)(img)(_p5##x,_p8##y,z,c), I[24] = (T)(img)(_p4##x,_p8##y,z,c), I[25] = (T)(img)(_p3##x,_p8##y,z,c), I[26] = (T)(img)(_p2##x,_p8##y,z,c), I[27] = (T)(img)(_p1##x,_p8##y,z,c), I[28] = (T)(img)(x,_p8##y,z,c), I[29] = (T)(img)(_n1##x,_p8##y,z,c), I[30] = (T)(img)(_n2##x,_p8##y,z,c), I[31] = (T)(img)(_n3##x,_p8##y,z,c), I[32] = (T)(img)(_n4##x,_p8##y,z,c), I[33] = (T)(img)(_n5##x,_p8##y,z,c), I[34] = (T)(img)(_n6##x,_p8##y,z,c), I[35] = (T)(img)(_n7##x,_p8##y,z,c), I[36] = (T)(img)(_n8##x,_p8##y,z,c), I[37] = (T)(img)(_n9##x,_p8##y,z,c), \
 I[38] = (T)(img)(_p9##x,_p7##y,z,c), I[39] = (T)(img)(_p8##x,_p7##y,z,c), I[40] = (T)(img)(_p7##x,_p7##y,z,c), I[41] = (T)(img)(_p6##x,_p7##y,z,c), I[42] = (T)(img)(_p5##x,_p7##y,z,c), I[43] = (T)(img)(_p4##x,_p7##y,z,c), I[44] = (T)(img)(_p3##x,_p7##y,z,c), I[45] = (T)(img)(_p2##x,_p7##y,z,c), I[46] = (T)(img)(_p1##x,_p7##y,z,c), I[47] = (T)(img)(x,_p7##y,z,c), I[48] = (T)(img)(_n1##x,_p7##y,z,c), I[49] = (T)(img)(_n2##x,_p7##y,z,c), I[50] = (T)(img)(_n3##x,_p7##y,z,c), I[51] = (T)(img)(_n4##x,_p7##y,z,c), I[52] = (T)(img)(_n5##x,_p7##y,z,c), I[53] = (T)(img)(_n6##x,_p7##y,z,c), I[54] = (T)(img)(_n7##x,_p7##y,z,c), I[55] = (T)(img)(_n8##x,_p7##y,z,c), I[56] = (T)(img)(_n9##x,_p7##y,z,c), \
 I[57] = (T)(img)(_p9##x,_p6##y,z,c), I[58] = (T)(img)(_p8##x,_p6##y,z,c), I[59] = (T)(img)(_p7##x,_p6##y,z,c), I[60] = (T)(img)(_p6##x,_p6##y,z,c), I[61] = (T)(img)(_p5##x,_p6##y,z,c), I[62] = (T)(img)(_p4##x,_p6##y,z,c), I[63] = (T)(img)(_p3##x,_p6##y,z,c), I[64] = (T)(img)(_p2##x,_p6##y,z,c), I[65] = (T)(img)(_p1##x,_p6##y,z,c), I[66] = (T)(img)(x,_p6##y,z,c), I[67] = (T)(img)(_n1##x,_p6##y,z,c), I[68] = (T)(img)(_n2##x,_p6##y,z,c), I[69] = (T)(img)(_n3##x,_p6##y,z,c), I[70] = (T)(img)(_n4##x,_p6##y,z,c), I[71] = (T)(img)(_n5##x,_p6##y,z,c), I[72] = (T)(img)(_n6##x,_p6##y,z,c), I[73] = (T)(img)(_n7##x,_p6##y,z,c), I[74] = (T)(img)(_n8##x,_p6##y,z,c), I[75] = (T)(img)(_n9##x,_p6##y,z,c), \
 I[76] = (T)(img)(_p9##x,_p5##y,z,c), I[77] = (T)(img)(_p8##x,_p5##y,z,c), I[78] = (T)(img)(_p7##x,_p5##y,z,c), I[79] = (T)(img)(_p6##x,_p5##y,z,c), I[80] = (T)(img)(_p5##x,_p5##y,z,c), I[81] = (T)(img)(_p4##x,_p5##y,z,c), I[82] = (T)(img)(_p3##x,_p5##y,z,c), I[83] = (T)(img)(_p2##x,_p5##y,z,c), I[84] = (T)(img)(_p1##x,_p5##y,z,c), I[85] = (T)(img)(x,_p5##y,z,c), I[86] = (T)(img)(_n1##x,_p5##y,z,c), I[87] = (T)(img)(_n2##x,_p5##y,z,c), I[88] = (T)(img)(_n3##x,_p5##y,z,c), I[89] = (T)(img)(_n4##x,_p5##y,z,c), I[90] = (T)(img)(_n5##x,_p5##y,z,c), I[91] = (T)(img)(_n6##x,_p5##y,z,c), I[92] = (T)(img)(_n7##x,_p5##y,z,c), I[93] = (T)(img)(_n8##x,_p5##y,z,c), I[94] = (T)(img)(_n9##x,_p5##y,z,c), \
 I[95] = (T)(img)(_p9##x,_p4##y,z,c), I[96] = (T)(img)(_p8##x,_p4##y,z,c), I[97] = (T)(img)(_p7##x,_p4##y,z,c), I[98] = (T)(img)(_p6##x,_p4##y,z,c), I[99] = (T)(img)(_p5##x,_p4##y,z,c), I[100] = (T)(img)(_p4##x,_p4##y,z,c), I[101] = (T)(img)(_p3##x,_p4##y,z,c), I[102] = (T)(img)(_p2##x,_p4##y,z,c), I[103] = (T)(img)(_p1##x,_p4##y,z,c), I[104] = (T)(img)(x,_p4##y,z,c), I[105] = (T)(img)(_n1##x,_p4##y,z,c), I[106] = (T)(img)(_n2##x,_p4##y,z,c), I[107] = (T)(img)(_n3##x,_p4##y,z,c), I[108] = (T)(img)(_n4##x,_p4##y,z,c), I[109] = (T)(img)(_n5##x,_p4##y,z,c), I[110] = (T)(img)(_n6##x,_p4##y,z,c), I[111] = (T)(img)(_n7##x,_p4##y,z,c), I[112] = (T)(img)(_n8##x,_p4##y,z,c), I[113] = (T)(img)(_n9##x,_p4##y,z,c), \
 I[114] = (T)(img)(_p9##x,_p3##y,z,c), I[115] = (T)(img)(_p8##x,_p3##y,z,c), I[116] = (T)(img)(_p7##x,_p3##y,z,c), I[117] = (T)(img)(_p6##x,_p3##y,z,c), I[118] = (T)(img)(_p5##x,_p3##y,z,c), I[119] = (T)(img)(_p4##x,_p3##y,z,c), I[120] = (T)(img)(_p3##x,_p3##y,z,c), I[121] = (T)(img)(_p2##x,_p3##y,z,c), I[122] = (T)(img)(_p1##x,_p3##y,z,c), I[123] = (T)(img)(x,_p3##y,z,c), I[124] = (T)(img)(_n1##x,_p3##y,z,c), I[125] = (T)(img)(_n2##x,_p3##y,z,c), I[126] = (T)(img)(_n3##x,_p3##y,z,c), I[127] = (T)(img)(_n4##x,_p3##y,z,c), I[128] = (T)(img)(_n5##x,_p3##y,z,c), I[129] = (T)(img)(_n6##x,_p3##y,z,c), I[130] = (T)(img)(_n7##x,_p3##y,z,c), I[131] = (T)(img)(_n8##x,_p3##y,z,c), I[132] = (T)(img)(_n9##x,_p3##y,z,c), \
 I[133] = (T)(img)(_p9##x,_p2##y,z,c), I[134] = (T)(img)(_p8##x,_p2##y,z,c), I[135] = (T)(img)(_p7##x,_p2##y,z,c), I[136] = (T)(img)(_p6##x,_p2##y,z,c), I[137] = (T)(img)(_p5##x,_p2##y,z,c), I[138] = (T)(img)(_p4##x,_p2##y,z,c), I[139] = (T)(img)(_p3##x,_p2##y,z,c), I[140] = (T)(img)(_p2##x,_p2##y,z,c), I[141] = (T)(img)(_p1##x,_p2##y,z,c), I[142] = (T)(img)(x,_p2##y,z,c), I[143] = (T)(img)(_n1##x,_p2##y,z,c), I[144] = (T)(img)(_n2##x,_p2##y,z,c), I[145] = (T)(img)(_n3##x,_p2##y,z,c), I[146] = (T)(img)(_n4##x,_p2##y,z,c), I[147] = (T)(img)(_n5##x,_p2##y,z,c), I[148] = (T)(img)(_n6##x,_p2##y,z,c), I[149] = (T)(img)(_n7##x,_p2##y,z,c), I[150] = (T)(img)(_n8##x,_p2##y,z,c), I[151] = (T)(img)(_n9##x,_p2##y,z,c), \
 I[152] = (T)(img)(_p9##x,_p1##y,z,c), I[153] = (T)(img)(_p8##x,_p1##y,z,c), I[154] = (T)(img)(_p7##x,_p1##y,z,c), I[155] = (T)(img)(_p6##x,_p1##y,z,c), I[156] = (T)(img)(_p5##x,_p1##y,z,c), I[157] = (T)(img)(_p4##x,_p1##y,z,c), I[158] = (T)(img)(_p3##x,_p1##y,z,c), I[159] = (T)(img)(_p2##x,_p1##y,z,c), I[160] = (T)(img)(_p1##x,_p1##y,z,c), I[161] = (T)(img)(x,_p1##y,z,c), I[162] = (T)(img)(_n1##x,_p1##y,z,c), I[163] = (T)(img)(_n2##x,_p1##y,z,c), I[164] = (T)(img)(_n3##x,_p1##y,z,c), I[165] = (T)(img)(_n4##x,_p1##y,z,c), I[166] = (T)(img)(_n5##x,_p1##y,z,c), I[167] = (T)(img)(_n6##x,_p1##y,z,c), I[168] = (T)(img)(_n7##x,_p1##y,z,c), I[169] = (T)(img)(_n8##x,_p1##y,z,c), I[170] = (T)(img)(_n9##x,_p1##y,z,c), \
 I[171] = (T)(img)(_p9##x,y,z,c), I[172] = (T)(img)(_p8##x,y,z,c), I[173] = (T)(img)(_p7##x,y,z,c), I[174] = (T)(img)(_p6##x,y,z,c), I[175] = (T)(img)(_p5##x,y,z,c), I[176] = (T)(img)(_p4##x,y,z,c), I[177] = (T)(img)(_p3##x,y,z,c), I[178] = (T)(img)(_p2##x,y,z,c), I[179] = (T)(img)(_p1##x,y,z,c), I[180] = (T)(img)(x,y,z,c), I[181] = (T)(img)(_n1##x,y,z,c), I[182] = (T)(img)(_n2##x,y,z,c), I[183] = (T)(img)(_n3##x,y,z,c), I[184] = (T)(img)(_n4##x,y,z,c), I[185] = (T)(img)(_n5##x,y,z,c), I[186] = (T)(img)(_n6##x,y,z,c), I[187] = (T)(img)(_n7##x,y,z,c), I[188] = (T)(img)(_n8##x,y,z,c), I[189] = (T)(img)(_n9##x,y,z,c), \
 I[190] = (T)(img)(_p9##x,_n1##y,z,c), I[191] = (T)(img)(_p8##x,_n1##y,z,c), I[192] = (T)(img)(_p7##x,_n1##y,z,c), I[193] = (T)(img)(_p6##x,_n1##y,z,c), I[194] = (T)(img)(_p5##x,_n1##y,z,c), I[195] = (T)(img)(_p4##x,_n1##y,z,c), I[196] = (T)(img)(_p3##x,_n1##y,z,c), I[197] = (T)(img)(_p2##x,_n1##y,z,c), I[198] = (T)(img)(_p1##x,_n1##y,z,c), I[199] = (T)(img)(x,_n1##y,z,c), I[200] = (T)(img)(_n1##x,_n1##y,z,c), I[201] = (T)(img)(_n2##x,_n1##y,z,c), I[202] = (T)(img)(_n3##x,_n1##y,z,c), I[203] = (T)(img)(_n4##x,_n1##y,z,c), I[204] = (T)(img)(_n5##x,_n1##y,z,c), I[205] = (T)(img)(_n6##x,_n1##y,z,c), I[206] = (T)(img)(_n7##x,_n1##y,z,c), I[207] = (T)(img)(_n8##x,_n1##y,z,c), I[208] = (T)(img)(_n9##x,_n1##y,z,c), \
 I[209] = (T)(img)(_p9##x,_n2##y,z,c), I[210] = (T)(img)(_p8##x,_n2##y,z,c), I[211] = (T)(img)(_p7##x,_n2##y,z,c), I[212] = (T)(img)(_p6##x,_n2##y,z,c), I[213] = (T)(img)(_p5##x,_n2##y,z,c), I[214] = (T)(img)(_p4##x,_n2##y,z,c), I[215] = (T)(img)(_p3##x,_n2##y,z,c), I[216] = (T)(img)(_p2##x,_n2##y,z,c), I[217] = (T)(img)(_p1##x,_n2##y,z,c), I[218] = (T)(img)(x,_n2##y,z,c), I[219] = (T)(img)(_n1##x,_n2##y,z,c), I[220] = (T)(img)(_n2##x,_n2##y,z,c), I[221] = (T)(img)(_n3##x,_n2##y,z,c), I[222] = (T)(img)(_n4##x,_n2##y,z,c), I[223] = (T)(img)(_n5##x,_n2##y,z,c), I[224] = (T)(img)(_n6##x,_n2##y,z,c), I[225] = (T)(img)(_n7##x,_n2##y,z,c), I[226] = (T)(img)(_n8##x,_n2##y,z,c), I[227] = (T)(img)(_n9##x,_n2##y,z,c), \
 I[228] = (T)(img)(_p9##x,_n3##y,z,c), I[229] = (T)(img)(_p8##x,_n3##y,z,c), I[230] = (T)(img)(_p7##x,_n3##y,z,c), I[231] = (T)(img)(_p6##x,_n3##y,z,c), I[232] = (T)(img)(_p5##x,_n3##y,z,c), I[233] = (T)(img)(_p4##x,_n3##y,z,c), I[234] = (T)(img)(_p3##x,_n3##y,z,c), I[235] = (T)(img)(_p2##x,_n3##y,z,c), I[236] = (T)(img)(_p1##x,_n3##y,z,c), I[237] = (T)(img)(x,_n3##y,z,c), I[238] = (T)(img)(_n1##x,_n3##y,z,c), I[239] = (T)(img)(_n2##x,_n3##y,z,c), I[240] = (T)(img)(_n3##x,_n3##y,z,c), I[241] = (T)(img)(_n4##x,_n3##y,z,c), I[242] = (T)(img)(_n5##x,_n3##y,z,c), I[243] = (T)(img)(_n6##x,_n3##y,z,c), I[244] = (T)(img)(_n7##x,_n3##y,z,c), I[245] = (T)(img)(_n8##x,_n3##y,z,c), I[246] = (T)(img)(_n9##x,_n3##y,z,c), \
 I[247] = (T)(img)(_p9##x,_n4##y,z,c), I[248] = (T)(img)(_p8##x,_n4##y,z,c), I[249] = (T)(img)(_p7##x,_n4##y,z,c), I[250] = (T)(img)(_p6##x,_n4##y,z,c), I[251] = (T)(img)(_p5##x,_n4##y,z,c), I[252] = (T)(img)(_p4##x,_n4##y,z,c), I[253] = (T)(img)(_p3##x,_n4##y,z,c), I[254] = (T)(img)(_p2##x,_n4##y,z,c), I[255] = (T)(img)(_p1##x,_n4##y,z,c), I[256] = (T)(img)(x,_n4##y,z,c), I[257] = (T)(img)(_n1##x,_n4##y,z,c), I[258] = (T)(img)(_n2##x,_n4##y,z,c), I[259] = (T)(img)(_n3##x,_n4##y,z,c), I[260] = (T)(img)(_n4##x,_n4##y,z,c), I[261] = (T)(img)(_n5##x,_n4##y,z,c), I[262] = (T)(img)(_n6##x,_n4##y,z,c), I[263] = (T)(img)(_n7##x,_n4##y,z,c), I[264] = (T)(img)(_n8##x,_n4##y,z,c), I[265] = (T)(img)(_n9##x,_n4##y,z,c), \
 I[266] = (T)(img)(_p9##x,_n5##y,z,c), I[267] = (T)(img)(_p8##x,_n5##y,z,c), I[268] = (T)(img)(_p7##x,_n5##y,z,c), I[269] = (T)(img)(_p6##x,_n5##y,z,c), I[270] = (T)(img)(_p5##x,_n5##y,z,c), I[271] = (T)(img)(_p4##x,_n5##y,z,c), I[272] = (T)(img)(_p3##x,_n5##y,z,c), I[273] = (T)(img)(_p2##x,_n5##y,z,c), I[274] = (T)(img)(_p1##x,_n5##y,z,c), I[275] = (T)(img)(x,_n5##y,z,c), I[276] = (T)(img)(_n1##x,_n5##y,z,c), I[277] = (T)(img)(_n2##x,_n5##y,z,c), I[278] = (T)(img)(_n3##x,_n5##y,z,c), I[279] = (T)(img)(_n4##x,_n5##y,z,c), I[280] = (T)(img)(_n5##x,_n5##y,z,c), I[281] = (T)(img)(_n6##x,_n5##y,z,c), I[282] = (T)(img)(_n7##x,_n5##y,z,c), I[283] = (T)(img)(_n8##x,_n5##y,z,c), I[284] = (T)(img)(_n9##x,_n5##y,z,c), \
 I[285] = (T)(img)(_p9##x,_n6##y,z,c), I[286] = (T)(img)(_p8##x,_n6##y,z,c), I[287] = (T)(img)(_p7##x,_n6##y,z,c), I[288] = (T)(img)(_p6##x,_n6##y,z,c), I[289] = (T)(img)(_p5##x,_n6##y,z,c), I[290] = (T)(img)(_p4##x,_n6##y,z,c), I[291] = (T)(img)(_p3##x,_n6##y,z,c), I[292] = (T)(img)(_p2##x,_n6##y,z,c), I[293] = (T)(img)(_p1##x,_n6##y,z,c), I[294] = (T)(img)(x,_n6##y,z,c), I[295] = (T)(img)(_n1##x,_n6##y,z,c), I[296] = (T)(img)(_n2##x,_n6##y,z,c), I[297] = (T)(img)(_n3##x,_n6##y,z,c), I[298] = (T)(img)(_n4##x,_n6##y,z,c), I[299] = (T)(img)(_n5##x,_n6##y,z,c), I[300] = (T)(img)(_n6##x,_n6##y,z,c), I[301] = (T)(img)(_n7##x,_n6##y,z,c), I[302] = (T)(img)(_n8##x,_n6##y,z,c), I[303] = (T)(img)(_n9##x,_n6##y,z,c), \
 I[304] = (T)(img)(_p9##x,_n7##y,z,c), I[305] = (T)(img)(_p8##x,_n7##y,z,c), I[306] = (T)(img)(_p7##x,_n7##y,z,c), I[307] = (T)(img)(_p6##x,_n7##y,z,c), I[308] = (T)(img)(_p5##x,_n7##y,z,c), I[309] = (T)(img)(_p4##x,_n7##y,z,c), I[310] = (T)(img)(_p3##x,_n7##y,z,c), I[311] = (T)(img)(_p2##x,_n7##y,z,c), I[312] = (T)(img)(_p1##x,_n7##y,z,c), I[313] = (T)(img)(x,_n7##y,z,c), I[314] = (T)(img)(_n1##x,_n7##y,z,c), I[315] = (T)(img)(_n2##x,_n7##y,z,c), I[316] = (T)(img)(_n3##x,_n7##y,z,c), I[317] = (T)(img)(_n4##x,_n7##y,z,c), I[318] = (T)(img)(_n5##x,_n7##y,z,c), I[319] = (T)(img)(_n6##x,_n7##y,z,c), I[320] = (T)(img)(_n7##x,_n7##y,z,c), I[321] = (T)(img)(_n8##x,_n7##y,z,c), I[322] = (T)(img)(_n9##x,_n7##y,z,c), \
 I[323] = (T)(img)(_p9##x,_n8##y,z,c), I[324] = (T)(img)(_p8##x,_n8##y,z,c), I[325] = (T)(img)(_p7##x,_n8##y,z,c), I[326] = (T)(img)(_p6##x,_n8##y,z,c), I[327] = (T)(img)(_p5##x,_n8##y,z,c), I[328] = (T)(img)(_p4##x,_n8##y,z,c), I[329] = (T)(img)(_p3##x,_n8##y,z,c), I[330] = (T)(img)(_p2##x,_n8##y,z,c), I[331] = (T)(img)(_p1##x,_n8##y,z,c), I[332] = (T)(img)(x,_n8##y,z,c), I[333] = (T)(img)(_n1##x,_n8##y,z,c), I[334] = (T)(img)(_n2##x,_n8##y,z,c), I[335] = (T)(img)(_n3##x,_n8##y,z,c), I[336] = (T)(img)(_n4##x,_n8##y,z,c), I[337] = (T)(img)(_n5##x,_n8##y,z,c), I[338] = (T)(img)(_n6##x,_n8##y,z,c), I[339] = (T)(img)(_n7##x,_n8##y,z,c), I[340] = (T)(img)(_n8##x,_n8##y,z,c), I[341] = (T)(img)(_n9##x,_n8##y,z,c), \
 I[342] = (T)(img)(_p9##x,_n9##y,z,c), I[343] = (T)(img)(_p8##x,_n9##y,z,c), I[344] = (T)(img)(_p7##x,_n9##y,z,c), I[345] = (T)(img)(_p6##x,_n9##y,z,c), I[346] = (T)(img)(_p5##x,_n9##y,z,c), I[347] = (T)(img)(_p4##x,_n9##y,z,c), I[348] = (T)(img)(_p3##x,_n9##y,z,c), I[349] = (T)(img)(_p2##x,_n9##y,z,c), I[350] = (T)(img)(_p1##x,_n9##y,z,c), I[351] = (T)(img)(x,_n9##y,z,c), I[352] = (T)(img)(_n1##x,_n9##y,z,c), I[353] = (T)(img)(_n2##x,_n9##y,z,c), I[354] = (T)(img)(_n3##x,_n9##y,z,c), I[355] = (T)(img)(_n4##x,_n9##y,z,c), I[356] = (T)(img)(_n5##x,_n9##y,z,c), I[357] = (T)(img)(_n6##x,_n9##y,z,c), I[358] = (T)(img)(_n7##x,_n9##y,z,c), I[359] = (T)(img)(_n8##x,_n9##y,z,c), I[360] = (T)(img)(_n9##x,_n9##y,z,c);

// Define 20x20 loop macros
//-------------------------
#define cimg_for20(bound,i) for (int i = 0, \
 _p9##i = 0, _p8##i = 0, _p7##i = 0, _p6##i = 0, _p5##i = 0, _p4##i = 0, _p3##i = 0, _p2##i = 0, _p1##i = 0, \
 _n1##i = 1>=(int)(bound)?(int)(bound)-1:1, \
 _n2##i = 2>=(int)(bound)?(int)(bound)-1:2, \
 _n3##i = 3>=(int)(bound)?(int)(bound)-1:3, \
 _n4##i = 4>=(int)(bound)?(int)(bound)-1:4, \
 _n5##i = 5>=(int)(bound)?(int)(bound)-1:5, \
 _n6##i = 6>=(int)(bound)?(int)(bound)-1:6, \
 _n7##i = 7>=(int)(bound)?(int)(bound)-1:7, \
 _n8##i = 8>=(int)(bound)?(int)(bound)-1:8, \
 _n9##i = 9>=(int)(bound)?(int)(bound)-1:9, \
 _n10##i = 10>=(int)(bound)?(int)(bound)-1:10; \
 _n10##i<(int)(bound) || _n9##i==--_n10##i || _n8##i==--_n9##i || _n7##i==--_n8##i || _n6##i==--_n7##i || _n5##i==--_n6##i || _n4##i==--_n5##i || _n3##i==--_n4##i || _n2##i==--_n3##i || _n1##i==--_n2##i || \
 i==(_n10##i = _n9##i = _n8##i = _n7##i = _n6##i = _n5##i = _n4##i = _n3##i = _n2##i = --_n1##i); \
 _p9##i = _p8##i, _p8##i = _p7##i, _p7##i = _p6##i, _p6##i = _p5##i, _p5##i = _p4##i, _p4##i = _p3##i, _p3##i = _p2##i, _p2##i = _p1##i, _p1##i = i++, \
 ++_n1##i, ++_n2##i, ++_n3##i, ++_n4##i, ++_n5##i, ++_n6##i, ++_n7##i, ++_n8##i, ++_n9##i, ++_n10##i)

#define cimg_for20X(img,x) cimg_for20((img)._width,x)
#define cimg_for20Y(img,y) cimg_for20((img)._height,y)
#define cimg_for20Z(img,z) cimg_for20((img)._depth,z)
#define cimg_for20C(img,c) cimg_for20((img)._spectrum,c)
#define cimg_for20XY(img,x,y) cimg_for20Y(img,y) cimg_for20X(img,x)
#define cimg_for20XZ(img,x,z) cimg_for20Z(img,z) cimg_for20X(img,x)
#define cimg_for20XC(img,x,c) cimg_for20C(img,c) cimg_for20X(img,x)
#define cimg_for20YZ(img,y,z) cimg_for20Z(img,z) cimg_for20Y(img,y)
#define cimg_for20YC(img,y,c) cimg_for20C(img,c) cimg_for20Y(img,y)
#define cimg_for20ZC(img,z,c) cimg_for20C(img,c) cimg_for20Z(img,z)
#define cimg_for20XYZ(img,x,y,z) cimg_for20Z(img,z) cimg_for20XY(img,x,y)
#define cimg_for20XZC(img,x,z,c) cimg_for20C(img,c) cimg_for20XZ(img,x,z)
#define cimg_for20YZC(img,y,z,c) cimg_for20C(img,c) cimg_for20YZ(img,y,z)
#define cimg_for20XYZC(img,x,y,z,c) cimg_for20C(img,c) cimg_for20XYZ(img,x,y,z)

#define cimg_for_in20(bound,i0,i1,i) for (int i = (int)(i0)<0?0:(int)(i0), \
 _p9##i = i-9<0?0:i-9, \
 _p8##i = i-8<0?0:i-8, \
 _p7##i = i-7<0?0:i-7, \
 _p6##i = i-6<0?0:i-6, \
 _p5##i = i-5<0?0:i-5, \
 _p4##i = i-4<0?0:i-4, \
 _p3##i = i-3<0?0:i-3, \
 _p2##i = i-2<0?0:i-2, \
 _p1##i = i-1<0?0:i-1, \
 _n1##i = i+1>=(int)(bound)?(int)(bound)-1:i+1, \
 _n2##i = i+2>=(int)(bound)?(int)(bound)-1:i+2, \
 _n3##i = i+3>=(int)(bound)?(int)(bound)-1:i+3, \
 _n4##i = i+4>=(int)(bound)?(int)(bound)-1:i+4, \
 _n5##i = i+5>=(int)(bound)?(int)(bound)-1:i+5, \
 _n6##i = i+6>=(int)(bound)?(int)(bound)-1:i+6, \
 _n7##i = i+7>=(int)(bound)?(int)(bound)-1:i+7, \
 _n8##i = i+8>=(int)(bound)?(int)(bound)-1:i+8, \
 _n9##i = i+9>=(int)(bound)?(int)(bound)-1:i+9, \
 _n10##i = i+10>=(int)(bound)?(int)(bound)-1:i+10; \
 i<=(int)(i1) && (_n10##i<(int)(bound) || _n9##i==--_n10##i || _n8##i==--_n9##i || _n7##i==--_n8##i || _n6##i==--_n7##i || _n5##i==--_n6##i || _n4##i==--_n5##i || _n3##i==--_n4##i || _n2##i==--_n3##i || _n1##i==--_n2##i || \
 i==(_n10##i = _n9##i = _n8##i = _n7##i = _n6##i = _n5##i = _n4##i = _n3##i = _n2##i = --_n1##i)); \
 _p9##i = _p8##i, _p8##i = _p7##i, _p7##i = _p6##i, _p6##i = _p5##i, _p5##i = _p4##i, _p4##i = _p3##i, _p3##i = _p2##i, _p2##i = _p1##i, _p1##i = i++, \
 ++_n1##i, ++_n2##i, ++_n3##i, ++_n4##i, ++_n5##i, ++_n6##i, ++_n7##i, ++_n8##i, ++_n9##i, ++_n10##i)

#define cimg_for_in20X(img,x0,x1,x) cimg_for_in20((img)._width,x0,x1,x)
#define cimg_for_in20Y(img,y0,y1,y) cimg_for_in20((img)._height,y0,y1,y)
#define cimg_for_in20Z(img,z0,z1,z) cimg_for_in20((img)._depth,z0,z1,z)
#define cimg_for_in20C(img,c0,c1,c) cimg_for_in20((img)._spectrum,c0,c1,c)
#define cimg_for_in20XY(img,x0,y0,x1,y1,x,y) cimg_for_in20Y(img,y0,y1,y) cimg_for_in20X(img,x0,x1,x)
#define cimg_for_in20XZ(img,x0,z0,x1,z1,x,z) cimg_for_in20Z(img,z0,z1,z) cimg_for_in20X(img,x0,x1,x)
#define cimg_for_in20XC(img,x0,c0,x1,c1,x,c) cimg_for_in20C(img,c0,c1,c) cimg_for_in20X(img,x0,x1,x)
#define cimg_for_in20YZ(img,y0,z0,y1,z1,y,z) cimg_for_in20Z(img,z0,z1,z) cimg_for_in20Y(img,y0,y1,y)
#define cimg_for_in20YC(img,y0,c0,y1,c1,y,c) cimg_for_in20C(img,c0,c1,c) cimg_for_in20Y(img,y0,y1,y)
#define cimg_for_in20ZC(img,z0,c0,z1,c1,z,c) cimg_for_in20C(img,c0,c1,c) cimg_for_in20Z(img,z0,z1,z)
#define cimg_for_in20XYZ(img,x0,y0,z0,x1,y1,z1,x,y,z) cimg_for_in20Z(img,z0,z1,z) cimg_for_in20XY(img,x0,y0,x1,y1,x,y)
#define cimg_for_in20XZC(img,x0,z0,c0,x1,y1,c1,x,z,c) cimg_for_in20C(img,c0,c1,c) cimg_for_in20XZ(img,x0,y0,x1,y1,x,z)
#define cimg_for_in20YZC(img,y0,z0,c0,y1,z1,c1,y,z,c) cimg_for_in20C(img,c0,c1,c) cimg_for_in20YZ(img,y0,z0,y1,z1,y,z)
#define cimg_for_in20XYZC(img,x0,y0,z0,c0,x1,y1,z1,c1,x,y,z,c) cimg_for_in20C(img,c0,c1,c) cimg_for_in20XYZ(img,x0,y0,z0,x1,y1,z1,x,y,z)

#define cimg_for20x20(img,x,y,z,c,I,T) \
 cimg_for20((img)._height,y) for (int x = 0, \
 _p9##x = 0, _p8##x = 0, _p7##x = 0, _p6##x = 0, _p5##x = 0, _p4##x = 0, _p3##x = 0, _p2##x = 0, _p1##x = 0, \
 _n1##x = 1>=((img)._width)?(img).width()-1:1, \
 _n2##x = 2>=((img)._width)?(img).width()-1:2, \
 _n3##x = 3>=((img)._width)?(img).width()-1:3, \
 _n4##x = 4>=((img)._width)?(img).width()-1:4, \
 _n5##x = 5>=((img)._width)?(img).width()-1:5, \
 _n6##x = 6>=((img)._width)?(img).width()-1:6, \
 _n7##x = 7>=((img)._width)?(img).width()-1:7, \
 _n8##x = 8>=((img)._width)?(img).width()-1:8, \
 _n9##x = 9>=((img)._width)?(img).width()-1:9, \
 _n10##x = (int)( \
 (I[0] = I[1] = I[2] = I[3] = I[4] = I[5] = I[6] = I[7] = I[8] = I[9] = (T)(img)(0,_p9##y,z,c)), \
 (I[20] = I[21] = I[22] = I[23] = I[24] = I[25] = I[26] = I[27] = I[28] = I[29] = (T)(img)(0,_p8##y,z,c)), \
 (I[40] = I[41] = I[42] = I[43] = I[44] = I[45] = I[46] = I[47] = I[48] = I[49] = (T)(img)(0,_p7##y,z,c)), \
 (I[60] = I[61] = I[62] = I[63] = I[64] = I[65] = I[66] = I[67] = I[68] = I[69] = (T)(img)(0,_p6##y,z,c)), \
 (I[80] = I[81] = I[82] = I[83] = I[84] = I[85] = I[86] = I[87] = I[88] = I[89] = (T)(img)(0,_p5##y,z,c)), \
 (I[100] = I[101] = I[102] = I[103] = I[104] = I[105] = I[106] = I[107] = I[108] = I[109] = (T)(img)(0,_p4##y,z,c)), \
 (I[120] = I[121] = I[122] = I[123] = I[124] = I[125] = I[126] = I[127] = I[128] = I[129] = (T)(img)(0,_p3##y,z,c)), \
 (I[140] = I[141] = I[142] = I[143] = I[144] = I[145] = I[146] = I[147] = I[148] = I[149] = (T)(img)(0,_p2##y,z,c)), \
 (I[160] = I[161] = I[162] = I[163] = I[164] = I[165] = I[166] = I[167] = I[168] = I[169] = (T)(img)(0,_p1##y,z,c)), \
 (I[180] = I[181] = I[182] = I[183] = I[184] = I[185] = I[186] = I[187] = I[188] = I[189] = (T)(img)(0,y,z,c)), \
 (I[200] = I[201] = I[202] = I[203] = I[204] = I[205] = I[206] = I[207] = I[208] = I[209] = (T)(img)(0,_n1##y,z,c)), \
 (I[220] = I[221] = I[222] = I[223] = I[224] = I[225] = I[226] = I[227] = I[228] = I[229] = (T)(img)(0,_n2##y,z,c)), \
 (I[240] = I[241] = I[242] = I[243] = I[244] = I[245] = I[246] = I[247] = I[248] = I[249] = (T)(img)(0,_n3##y,z,c)), \
 (I[260] = I[261] = I[262] = I[263] = I[264] = I[265] = I[266] = I[267] = I[268] = I[269] = (T)(img)(0,_n4##y,z,c)), \
 (I[280] = I[281] = I[282] = I[283] = I[284] = I[285] = I[286] = I[287] = I[288] = I[289] = (T)(img)(0,_n5##y,z,c)), \
 (I[300] = I[301] = I[302] = I[303] = I[304] = I[305] = I[306] = I[307] = I[308] = I[309] = (T)(img)(0,_n6##y,z,c)), \
 (I[320] = I[321] = I[322] = I[323] = I[324] = I[325] = I[326] = I[327] = I[328] = I[329] = (T)(img)(0,_n7##y,z,c)), \
 (I[340] = I[341] = I[342] = I[343] = I[344] = I[345] = I[346] = I[347] = I[348] = I[349] = (T)(img)(0,_n8##y,z,c)), \
 (I[360] = I[361] = I[362] = I[363] = I[364] = I[365] = I[366] = I[367] = I[368] = I[369] = (T)(img)(0,_n9##y,z,c)), \
 (I[380] = I[381] = I[382] = I[383] = I[384] = I[385] = I[386] = I[387] = I[388] = I[389] = (T)(img)(0,_n10##y,z,c)), \
 (I[10] = (T)(img)(_n1##x,_p9##y,z,c)), \
 (I[30] = (T)(img)(_n1##x,_p8##y,z,c)), \
 (I[50] = (T)(img)(_n1##x,_p7##y,z,c)), \
 (I[70] = (T)(img)(_n1##x,_p6##y,z,c)), \
 (I[90] = (T)(img)(_n1##x,_p5##y,z,c)), \
 (I[110] = (T)(img)(_n1##x,_p4##y,z,c)), \
 (I[130] = (T)(img)(_n1##x,_p3##y,z,c)), \
 (I[150] = (T)(img)(_n1##x,_p2##y,z,c)), \
 (I[170] = (T)(img)(_n1##x,_p1##y,z,c)), \
 (I[190] = (T)(img)(_n1##x,y,z,c)), \
 (I[210] = (T)(img)(_n1##x,_n1##y,z,c)), \
 (I[230] = (T)(img)(_n1##x,_n2##y,z,c)), \
 (I[250] = (T)(img)(_n1##x,_n3##y,z,c)), \
 (I[270] = (T)(img)(_n1##x,_n4##y,z,c)), \
 (I[290] = (T)(img)(_n1##x,_n5##y,z,c)), \
 (I[310] = (T)(img)(_n1##x,_n6##y,z,c)), \
 (I[330] = (T)(img)(_n1##x,_n7##y,z,c)), \
 (I[350] = (T)(img)(_n1##x,_n8##y,z,c)), \
 (I[370] = (T)(img)(_n1##x,_n9##y,z,c)), \
 (I[390] = (T)(img)(_n1##x,_n10##y,z,c)), \
 (I[11] = (T)(img)(_n2##x,_p9##y,z,c)), \
 (I[31] = (T)(img)(_n2##x,_p8##y,z,c)), \
 (I[51] = (T)(img)(_n2##x,_p7##y,z,c)), \
 (I[71] = (T)(img)(_n2##x,_p6##y,z,c)), \
 (I[91] = (T)(img)(_n2##x,_p5##y,z,c)), \
 (I[111] = (T)(img)(_n2##x,_p4##y,z,c)), \
 (I[131] = (T)(img)(_n2##x,_p3##y,z,c)), \
 (I[151] = (T)(img)(_n2##x,_p2##y,z,c)), \
 (I[171] = (T)(img)(_n2##x,_p1##y,z,c)), \
 (I[191] = (T)(img)(_n2##x,y,z,c)), \
 (I[211] = (T)(img)(_n2##x,_n1##y,z,c)), \
 (I[231] = (T)(img)(_n2##x,_n2##y,z,c)), \
 (I[251] = (T)(img)(_n2##x,_n3##y,z,c)), \
 (I[271] = (T)(img)(_n2##x,_n4##y,z,c)), \
 (I[291] = (T)(img)(_n2##x,_n5##y,z,c)), \
 (I[311] = (T)(img)(_n2##x,_n6##y,z,c)), \
 (I[331] = (T)(img)(_n2##x,_n7##y,z,c)), \
 (I[351] = (T)(img)(_n2##x,_n8##y,z,c)), \
 (I[371] = (T)(img)(_n2##x,_n9##y,z,c)), \
 (I[391] = (T)(img)(_n2##x,_n10##y,z,c)), \
 (I[12] = (T)(img)(_n3##x,_p9##y,z,c)), \
 (I[32] = (T)(img)(_n3##x,_p8##y,z,c)), \
 (I[52] = (T)(img)(_n3##x,_p7##y,z,c)), \
 (I[72] = (T)(img)(_n3##x,_p6##y,z,c)), \
 (I[92] = (T)(img)(_n3##x,_p5##y,z,c)), \
 (I[112] = (T)(img)(_n3##x,_p4##y,z,c)), \
 (I[132] = (T)(img)(_n3##x,_p3##y,z,c)), \
 (I[152] = (T)(img)(_n3##x,_p2##y,z,c)), \
 (I[172] = (T)(img)(_n3##x,_p1##y,z,c)), \
 (I[192] = (T)(img)(_n3##x,y,z,c)), \
 (I[212] = (T)(img)(_n3##x,_n1##y,z,c)), \
 (I[232] = (T)(img)(_n3##x,_n2##y,z,c)), \
 (I[252] = (T)(img)(_n3##x,_n3##y,z,c)), \
 (I[272] = (T)(img)(_n3##x,_n4##y,z,c)), \
 (I[292] = (T)(img)(_n3##x,_n5##y,z,c)), \
 (I[312] = (T)(img)(_n3##x,_n6##y,z,c)), \
 (I[332] = (T)(img)(_n3##x,_n7##y,z,c)), \
 (I[352] = (T)(img)(_n3##x,_n8##y,z,c)), \
 (I[372] = (T)(img)(_n3##x,_n9##y,z,c)), \
 (I[392] = (T)(img)(_n3##x,_n10##y,z,c)), \
 (I[13] = (T)(img)(_n4##x,_p9##y,z,c)), \
 (I[33] = (T)(img)(_n4##x,_p8##y,z,c)), \
 (I[53] = (T)(img)(_n4##x,_p7##y,z,c)), \
 (I[73] = (T)(img)(_n4##x,_p6##y,z,c)), \
 (I[93] = (T)(img)(_n4##x,_p5##y,z,c)), \
 (I[113] = (T)(img)(_n4##x,_p4##y,z,c)), \
 (I[133] = (T)(img)(_n4##x,_p3##y,z,c)), \
 (I[153] = (T)(img)(_n4##x,_p2##y,z,c)), \
 (I[173] = (T)(img)(_n4##x,_p1##y,z,c)), \
 (I[193] = (T)(img)(_n4##x,y,z,c)), \
 (I[213] = (T)(img)(_n4##x,_n1##y,z,c)), \
 (I[233] = (T)(img)(_n4##x,_n2##y,z,c)), \
 (I[253] = (T)(img)(_n4##x,_n3##y,z,c)), \
 (I[273] = (T)(img)(_n4##x,_n4##y,z,c)), \
 (I[293] = (T)(img)(_n4##x,_n5##y,z,c)), \
 (I[313] = (T)(img)(_n4##x,_n6##y,z,c)), \
 (I[333] = (T)(img)(_n4##x,_n7##y,z,c)), \
 (I[353] = (T)(img)(_n4##x,_n8##y,z,c)), \
 (I[373] = (T)(img)(_n4##x,_n9##y,z,c)), \
 (I[393] = (T)(img)(_n4##x,_n10##y,z,c)), \
 (I[14] = (T)(img)(_n5##x,_p9##y,z,c)), \
 (I[34] = (T)(img)(_n5##x,_p8##y,z,c)), \
 (I[54] = (T)(img)(_n5##x,_p7##y,z,c)), \
 (I[74] = (T)(img)(_n5##x,_p6##y,z,c)), \
 (I[94] = (T)(img)(_n5##x,_p5##y,z,c)), \
 (I[114] = (T)(img)(_n5##x,_p4##y,z,c)), \
 (I[134] = (T)(img)(_n5##x,_p3##y,z,c)), \
 (I[154] = (T)(img)(_n5##x,_p2##y,z,c)), \
 (I[174] = (T)(img)(_n5##x,_p1##y,z,c)), \
 (I[194] = (T)(img)(_n5##x,y,z,c)), \
 (I[214] = (T)(img)(_n5##x,_n1##y,z,c)), \
 (I[234] = (T)(img)(_n5##x,_n2##y,z,c)), \
 (I[254] = (T)(img)(_n5##x,_n3##y,z,c)), \
 (I[274] = (T)(img)(_n5##x,_n4##y,z,c)), \
 (I[294] = (T)(img)(_n5##x,_n5##y,z,c)), \
 (I[314] = (T)(img)(_n5##x,_n6##y,z,c)), \
 (I[334] = (T)(img)(_n5##x,_n7##y,z,c)), \
 (I[354] = (T)(img)(_n5##x,_n8##y,z,c)), \
 (I[374] = (T)(img)(_n5##x,_n9##y,z,c)), \
 (I[394] = (T)(img)(_n5##x,_n10##y,z,c)), \
 (I[15] = (T)(img)(_n6##x,_p9##y,z,c)), \
 (I[35] = (T)(img)(_n6##x,_p8##y,z,c)), \
 (I[55] = (T)(img)(_n6##x,_p7##y,z,c)), \
 (I[75] = (T)(img)(_n6##x,_p6##y,z,c)), \
 (I[95] = (T)(img)(_n6##x,_p5##y,z,c)), \
 (I[115] = (T)(img)(_n6##x,_p4##y,z,c)), \
 (I[135] = (T)(img)(_n6##x,_p3##y,z,c)), \
 (I[155] = (T)(img)(_n6##x,_p2##y,z,c)), \
 (I[175] = (T)(img)(_n6##x,_p1##y,z,c)), \
 (I[195] = (T)(img)(_n6##x,y,z,c)), \
 (I[215] = (T)(img)(_n6##x,_n1##y,z,c)), \
 (I[235] = (T)(img)(_n6##x,_n2##y,z,c)), \
 (I[255] = (T)(img)(_n6##x,_n3##y,z,c)), \
 (I[275] = (T)(img)(_n6##x,_n4##y,z,c)), \
 (I[295] = (T)(img)(_n6##x,_n5##y,z,c)), \
 (I[315] = (T)(img)(_n6##x,_n6##y,z,c)), \
 (I[335] = (T)(img)(_n6##x,_n7##y,z,c)), \
 (I[355] = (T)(img)(_n6##x,_n8##y,z,c)), \
 (I[375] = (T)(img)(_n6##x,_n9##y,z,c)), \
 (I[395] = (T)(img)(_n6##x,_n10##y,z,c)), \
 (I[16] = (T)(img)(_n7##x,_p9##y,z,c)), \
 (I[36] = (T)(img)(_n7##x,_p8##y,z,c)), \
 (I[56] = (T)(img)(_n7##x,_p7##y,z,c)), \
 (I[76] = (T)(img)(_n7##x,_p6##y,z,c)), \
 (I[96] = (T)(img)(_n7##x,_p5##y,z,c)), \
 (I[116] = (T)(img)(_n7##x,_p4##y,z,c)), \
 (I[136] = (T)(img)(_n7##x,_p3##y,z,c)), \
 (I[156] = (T)(img)(_n7##x,_p2##y,z,c)), \
 (I[176] = (T)(img)(_n7##x,_p1##y,z,c)), \
 (I[196] = (T)(img)(_n7##x,y,z,c)), \
 (I[216] = (T)(img)(_n7##x,_n1##y,z,c)), \
 (I[236] = (T)(img)(_n7##x,_n2##y,z,c)), \
 (I[256] = (T)(img)(_n7##x,_n3##y,z,c)), \
 (I[276] = (T)(img)(_n7##x,_n4##y,z,c)), \
 (I[296] = (T)(img)(_n7##x,_n5##y,z,c)), \
 (I[316] = (T)(img)(_n7##x,_n6##y,z,c)), \
 (I[336] = (T)(img)(_n7##x,_n7##y,z,c)), \
 (I[356] = (T)(img)(_n7##x,_n8##y,z,c)), \
 (I[376] = (T)(img)(_n7##x,_n9##y,z,c)), \
 (I[396] = (T)(img)(_n7##x,_n10##y,z,c)), \
 (I[17] = (T)(img)(_n8##x,_p9##y,z,c)), \
 (I[37] = (T)(img)(_n8##x,_p8##y,z,c)), \
 (I[57] = (T)(img)(_n8##x,_p7##y,z,c)), \
 (I[77] = (T)(img)(_n8##x,_p6##y,z,c)), \
 (I[97] = (T)(img)(_n8##x,_p5##y,z,c)), \
 (I[117] = (T)(img)(_n8##x,_p4##y,z,c)), \
 (I[137] = (T)(img)(_n8##x,_p3##y,z,c)), \
 (I[157] = (T)(img)(_n8##x,_p2##y,z,c)), \
 (I[177] = (T)(img)(_n8##x,_p1##y,z,c)), \
 (I[197] = (T)(img)(_n8##x,y,z,c)), \
 (I[217] = (T)(img)(_n8##x,_n1##y,z,c)), \
 (I[237] = (T)(img)(_n8##x,_n2##y,z,c)), \
 (I[257] = (T)(img)(_n8##x,_n3##y,z,c)), \
 (I[277] = (T)(img)(_n8##x,_n4##y,z,c)), \
 (I[297] = (T)(img)(_n8##x,_n5##y,z,c)), \
 (I[317] = (T)(img)(_n8##x,_n6##y,z,c)), \
 (I[337] = (T)(img)(_n8##x,_n7##y,z,c)), \
 (I[357] = (T)(img)(_n8##x,_n8##y,z,c)), \
 (I[377] = (T)(img)(_n8##x,_n9##y,z,c)), \
 (I[397] = (T)(img)(_n8##x,_n10##y,z,c)), \
 (I[18] = (T)(img)(_n9##x,_p9##y,z,c)), \
 (I[38] = (T)(img)(_n9##x,_p8##y,z,c)), \
 (I[58] = (T)(img)(_n9##x,_p7##y,z,c)), \
 (I[78] = (T)(img)(_n9##x,_p6##y,z,c)), \
 (I[98] = (T)(img)(_n9##x,_p5##y,z,c)), \
 (I[118] = (T)(img)(_n9##x,_p4##y,z,c)), \
 (I[138] = (T)(img)(_n9##x,_p3##y,z,c)), \
 (I[158] = (T)(img)(_n9##x,_p2##y,z,c)), \
 (I[178] = (T)(img)(_n9##x,_p1##y,z,c)), \
 (I[198] = (T)(img)(_n9##x,y,z,c)), \
 (I[218] = (T)(img)(_n9##x,_n1##y,z,c)), \
 (I[238] = (T)(img)(_n9##x,_n2##y,z,c)), \
 (I[258] = (T)(img)(_n9##x,_n3##y,z,c)), \
 (I[278] = (T)(img)(_n9##x,_n4##y,z,c)), \
 (I[298] = (T)(img)(_n9##x,_n5##y,z,c)), \
 (I[318] = (T)(img)(_n9##x,_n6##y,z,c)), \
 (I[338] = (T)(img)(_n9##x,_n7##y,z,c)), \
 (I[358] = (T)(img)(_n9##x,_n8##y,z,c)), \
 (I[378] = (T)(img)(_n9##x,_n9##y,z,c)), \
 (I[398] = (T)(img)(_n9##x,_n10##y,z,c)), \
 10>=((img)._width)?(img).width()-1:10); \
 (_n10##x<(img).width() && ( \
 (I[19] = (T)(img)(_n10##x,_p9##y,z,c)), \
 (I[39] = (T)(img)(_n10##x,_p8##y,z,c)), \
 (I[59] = (T)(img)(_n10##x,_p7##y,z,c)), \
 (I[79] = (T)(img)(_n10##x,_p6##y,z,c)), \
 (I[99] = (T)(img)(_n10##x,_p5##y,z,c)), \
 (I[119] = (T)(img)(_n10##x,_p4##y,z,c)), \
 (I[139] = (T)(img)(_n10##x,_p3##y,z,c)), \
 (I[159] = (T)(img)(_n10##x,_p2##y,z,c)), \
 (I[179] = (T)(img)(_n10##x,_p1##y,z,c)), \
 (I[199] = (T)(img)(_n10##x,y,z,c)), \
 (I[219] = (T)(img)(_n10##x,_n1##y,z,c)), \
 (I[239] = (T)(img)(_n10##x,_n2##y,z,c)), \
 (I[259] = (T)(img)(_n10##x,_n3##y,z,c)), \
 (I[279] = (T)(img)(_n10##x,_n4##y,z,c)), \
 (I[299] = (T)(img)(_n10##x,_n5##y,z,c)), \
 (I[319] = (T)(img)(_n10##x,_n6##y,z,c)), \
 (I[339] = (T)(img)(_n10##x,_n7##y,z,c)), \
 (I[359] = (T)(img)(_n10##x,_n8##y,z,c)), \
 (I[379] = (T)(img)(_n10##x,_n9##y,z,c)), \
 (I[399] = (T)(img)(_n10##x,_n10##y,z,c)),1)) || \
 _n9##x==--_n10##x || _n8##x==--_n9##x || _n7##x==--_n8##x || _n6##x==--_n7##x || _n5##x==--_n6##x || _n4##x==--_n5##x || _n3##x==--_n4##x || _n2##x==--_n3##x || _n1##x==--_n2##x || x==(_n10##x = _n9##x = _n8##x = _n7##x = _n6##x = _n5##x = _n4##x = _n3##x = _n2##x = --_n1##x); \
 I[0] = I[1], I[1] = I[2], I[2] = I[3], I[3] = I[4], I[4] = I[5], I[5] = I[6], I[6] = I[7], I[7] = I[8], I[8] = I[9], I[9] = I[10], I[10] = I[11], I[11] = I[12], I[12] = I[13], I[13] = I[14], I[14] = I[15], I[15] = I[16], I[16] = I[17], I[17] = I[18], I[18] = I[19], \
 I[20] = I[21], I[21] = I[22], I[22] = I[23], I[23] = I[24], I[24] = I[25], I[25] = I[26], I[26] = I[27], I[27] = I[28], I[28] = I[29], I[29] = I[30], I[30] = I[31], I[31] = I[32], I[32] = I[33], I[33] = I[34], I[34] = I[35], I[35] = I[36], I[36] = I[37], I[37] = I[38], I[38] = I[39], \
 I[40] = I[41], I[41] = I[42], I[42] = I[43], I[43] = I[44], I[44] = I[45], I[45] = I[46], I[46] = I[47], I[47] = I[48], I[48] = I[49], I[49] = I[50], I[50] = I[51], I[51] = I[52], I[52] = I[53], I[53] = I[54], I[54] = I[55], I[55] = I[56], I[56] = I[57], I[57] = I[58], I[58] = I[59], \
 I[60] = I[61], I[61] = I[62], I[62] = I[63], I[63] = I[64], I[64] = I[65], I[65] = I[66], I[66] = I[67], I[67] = I[68], I[68] = I[69], I[69] = I[70], I[70] = I[71], I[71] = I[72], I[72] = I[73], I[73] = I[74], I[74] = I[75], I[75] = I[76], I[76] = I[77], I[77] = I[78], I[78] = I[79], \
 I[80] = I[81], I[81] = I[82], I[82] = I[83], I[83] = I[84], I[84] = I[85], I[85] = I[86], I[86] = I[87], I[87] = I[88], I[88] = I[89], I[89] = I[90], I[90] = I[91], I[91] = I[92], I[92] = I[93], I[93] = I[94], I[94] = I[95], I[95] = I[96], I[96] = I[97], I[97] = I[98], I[98] = I[99], \
 I[100] = I[101], I[101] = I[102], I[102] = I[103], I[103] = I[104], I[104] = I[105], I[105] = I[106], I[106] = I[107], I[107] = I[108], I[108] = I[109], I[109] = I[110], I[110] = I[111], I[111] = I[112], I[112] = I[113], I[113] = I[114], I[114] = I[115], I[115] = I[116], I[116] = I[117], I[117] = I[118], I[118] = I[119], \
 I[120] = I[121], I[121] = I[122], I[122] = I[123], I[123] = I[124], I[124] = I[125], I[125] = I[126], I[126] = I[127], I[127] = I[128], I[128] = I[129], I[129] = I[130], I[130] = I[131], I[131] = I[132], I[132] = I[133], I[133] = I[134], I[134] = I[135], I[135] = I[136], I[136] = I[137], I[137] = I[138], I[138] = I[139], \
 I[140] = I[141], I[141] = I[142], I[142] = I[143], I[143] = I[144], I[144] = I[145], I[145] = I[146], I[146] = I[147], I[147] = I[148], I[148] = I[149], I[149] = I[150], I[150] = I[151], I[151] = I[152], I[152] = I[153], I[153] = I[154], I[154] = I[155], I[155] = I[156], I[156] = I[157], I[157] = I[158], I[158] = I[159], \
 I[160] = I[161], I[161] = I[162], I[162] = I[163], I[163] = I[164], I[164] = I[165], I[165] = I[166], I[166] = I[167], I[167] = I[168], I[168] = I[169], I[169] = I[170], I[170] = I[171], I[171] = I[172], I[172] = I[173], I[173] = I[174], I[174] = I[175], I[175] = I[176], I[176] = I[177], I[177] = I[178], I[178] = I[179], \
 I[180] = I[181], I[181] = I[182], I[182] = I[183], I[183] = I[184], I[184] = I[185], I[185] = I[186], I[186] = I[187], I[187] = I[188], I[188] = I[189], I[189] = I[190], I[190] = I[191], I[191] = I[192], I[192] = I[193], I[193] = I[194], I[194] = I[195], I[195] = I[196], I[196] = I[197], I[197] = I[198], I[198] = I[199], \
 I[200] = I[201], I[201] = I[202], I[202] = I[203], I[203] = I[204], I[204] = I[205], I[205] = I[206], I[206] = I[207], I[207] = I[208], I[208] = I[209], I[209] = I[210], I[210] = I[211], I[211] = I[212], I[212] = I[213], I[213] = I[214], I[214] = I[215], I[215] = I[216], I[216] = I[217], I[217] = I[218], I[218] = I[219], \
 I[220] = I[221], I[221] = I[222], I[222] = I[223], I[223] = I[224], I[224] = I[225], I[225] = I[226], I[226] = I[227], I[227] = I[228], I[228] = I[229], I[229] = I[230], I[230] = I[231], I[231] = I[232], I[232] = I[233], I[233] = I[234], I[234] = I[235], I[235] = I[236], I[236] = I[237], I[237] = I[238], I[238] = I[239], \
 I[240] = I[241], I[241] = I[242], I[242] = I[243], I[243] = I[244], I[244] = I[245], I[245] = I[246], I[246] = I[247], I[247] = I[248], I[248] = I[249], I[249] = I[250], I[250] = I[251], I[251] = I[252], I[252] = I[253], I[253] = I[254], I[254] = I[255], I[255] = I[256], I[256] = I[257], I[257] = I[258], I[258] = I[259], \
 I[260] = I[261], I[261] = I[262], I[262] = I[263], I[263] = I[264], I[264] = I[265], I[265] = I[266], I[266] = I[267], I[267] = I[268], I[268] = I[269], I[269] = I[270], I[270] = I[271], I[271] = I[272], I[272] = I[273], I[273] = I[274], I[274] = I[275], I[275] = I[276], I[276] = I[277], I[277] = I[278], I[278] = I[279], \
 I[280] = I[281], I[281] = I[282], I[282] = I[283], I[283] = I[284], I[284] = I[285], I[285] = I[286], I[286] = I[287], I[287] = I[288], I[288] = I[289], I[289] = I[290], I[290] = I[291], I[291] = I[292], I[292] = I[293], I[293] = I[294], I[294] = I[295], I[295] = I[296], I[296] = I[297], I[297] = I[298], I[298] = I[299], \
 I[300] = I[301], I[301] = I[302], I[302] = I[303], I[303] = I[304], I[304] = I[305], I[305] = I[306], I[306] = I[307], I[307] = I[308], I[308] = I[309], I[309] = I[310], I[310] = I[311], I[311] = I[312], I[312] = I[313], I[313] = I[314], I[314] = I[315], I[315] = I[316], I[316] = I[317], I[317] = I[318], I[318] = I[319], \
 I[320] = I[321], I[321] = I[322], I[322] = I[323], I[323] = I[324], I[324] = I[325], I[325] = I[326], I[326] = I[327], I[327] = I[328], I[328] = I[329], I[329] = I[330], I[330] = I[331], I[331] = I[332], I[332] = I[333], I[333] = I[334], I[334] = I[335], I[335] = I[336], I[336] = I[337], I[337] = I[338], I[338] = I[339], \
 I[340] = I[341], I[341] = I[342], I[342] = I[343], I[343] = I[344], I[344] = I[345], I[345] = I[346], I[346] = I[347], I[347] = I[348], I[348] = I[349], I[349] = I[350], I[350] = I[351], I[351] = I[352], I[352] = I[353], I[353] = I[354], I[354] = I[355], I[355] = I[356], I[356] = I[357], I[357] = I[358], I[358] = I[359], \
 I[360] = I[361], I[361] = I[362], I[362] = I[363], I[363] = I[364], I[364] = I[365], I[365] = I[366], I[366] = I[367], I[367] = I[368], I[368] = I[369], I[369] = I[370], I[370] = I[371], I[371] = I[372], I[372] = I[373], I[373] = I[374], I[374] = I[375], I[375] = I[376], I[376] = I[377], I[377] = I[378], I[378] = I[379], \
 I[380] = I[381], I[381] = I[382], I[382] = I[383], I[383] = I[384], I[384] = I[385], I[385] = I[386], I[386] = I[387], I[387] = I[388], I[388] = I[389], I[389] = I[390], I[390] = I[391], I[391] = I[392], I[392] = I[393], I[393] = I[394], I[394] = I[395], I[395] = I[396], I[396] = I[397], I[397] = I[398], I[398] = I[399], \
 _p9##x = _p8##x, _p8##x = _p7##x, _p7##x = _p6##x, _p6##x = _p5##x, _p5##x = _p4##x, _p4##x = _p3##x, _p3##x = _p2##x, _p2##x = _p1##x, _p1##x = x++, ++_n1##x, ++_n2##x, ++_n3##x, ++_n4##x, ++_n5##x, ++_n6##x, ++_n7##x, ++_n8##x, ++_n9##x, ++_n10##x)

#define cimg_for_in20x20(img,x0,y0,x1,y1,x,y,z,c,I,T) \
 cimg_for_in20((img)._height,y0,y1,y) for (int x = (int)(x0)<0?0:(int)(x0), \
 _p9##x = x-9<0?0:x-9, \
 _p8##x = x-8<0?0:x-8, \
 _p7##x = x-7<0?0:x-7, \
 _p6##x = x-6<0?0:x-6, \
 _p5##x = x-5<0?0:x-5, \
 _p4##x = x-4<0?0:x-4, \
 _p3##x = x-3<0?0:x-3, \
 _p2##x = x-2<0?0:x-2, \
 _p1##x = x-1<0?0:x-1, \
 _n1##x = x+1>=(img).width()?(img).width()-1:x+1, \
 _n2##x = x+2>=(img).width()?(img).width()-1:x+2, \
 _n3##x = x+3>=(img).width()?(img).width()-1:x+3, \
 _n4##x = x+4>=(img).width()?(img).width()-1:x+4, \
 _n5##x = x+5>=(img).width()?(img).width()-1:x+5, \
 _n6##x = x+6>=(img).width()?(img).width()-1:x+6, \
 _n7##x = x+7>=(img).width()?(img).width()-1:x+7, \
 _n8##x = x+8>=(img).width()?(img).width()-1:x+8, \
 _n9##x = x+9>=(img).width()?(img).width()-1:x+9, \
 _n10##x = (int)( \
 (I[0] = (T)(img)(_p9##x,_p9##y,z,c)), \
 (I[20] = (T)(img)(_p9##x,_p8##y,z,c)), \
 (I[40] = (T)(img)(_p9##x,_p7##y,z,c)), \
 (I[60] = (T)(img)(_p9##x,_p6##y,z,c)), \
 (I[80] = (T)(img)(_p9##x,_p5##y,z,c)), \
 (I[100] = (T)(img)(_p9##x,_p4##y,z,c)), \
 (I[120] = (T)(img)(_p9##x,_p3##y,z,c)), \
 (I[140] = (T)(img)(_p9##x,_p2##y,z,c)), \
 (I[160] = (T)(img)(_p9##x,_p1##y,z,c)), \
 (I[180] = (T)(img)(_p9##x,y,z,c)), \
 (I[200] = (T)(img)(_p9##x,_n1##y,z,c)), \
 (I[220] = (T)(img)(_p9##x,_n2##y,z,c)), \
 (I[240] = (T)(img)(_p9##x,_n3##y,z,c)), \
 (I[260] = (T)(img)(_p9##x,_n4##y,z,c)), \
 (I[280] = (T)(img)(_p9##x,_n5##y,z,c)), \
 (I[300] = (T)(img)(_p9##x,_n6##y,z,c)), \
 (I[320] = (T)(img)(_p9##x,_n7##y,z,c)), \
 (I[340] = (T)(img)(_p9##x,_n8##y,z,c)), \
 (I[360] = (T)(img)(_p9##x,_n9##y,z,c)), \
 (I[380] = (T)(img)(_p9##x,_n10##y,z,c)), \
 (I[1] = (T)(img)(_p8##x,_p9##y,z,c)), \
 (I[21] = (T)(img)(_p8##x,_p8##y,z,c)), \
 (I[41] = (T)(img)(_p8##x,_p7##y,z,c)), \
 (I[61] = (T)(img)(_p8##x,_p6##y,z,c)), \
 (I[81] = (T)(img)(_p8##x,_p5##y,z,c)), \
 (I[101] = (T)(img)(_p8##x,_p4##y,z,c)), \
 (I[121] = (T)(img)(_p8##x,_p3##y,z,c)), \
 (I[141] = (T)(img)(_p8##x,_p2##y,z,c)), \
 (I[161] = (T)(img)(_p8##x,_p1##y,z,c)), \
 (I[181] = (T)(img)(_p8##x,y,z,c)), \
 (I[201] = (T)(img)(_p8##x,_n1##y,z,c)), \
 (I[221] = (T)(img)(_p8##x,_n2##y,z,c)), \
 (I[241] = (T)(img)(_p8##x,_n3##y,z,c)), \
 (I[261] = (T)(img)(_p8##x,_n4##y,z,c)), \
 (I[281] = (T)(img)(_p8##x,_n5##y,z,c)), \
 (I[301] = (T)(img)(_p8##x,_n6##y,z,c)), \
 (I[321] = (T)(img)(_p8##x,_n7##y,z,c)), \
 (I[341] = (T)(img)(_p8##x,_n8##y,z,c)), \
 (I[361] = (T)(img)(_p8##x,_n9##y,z,c)), \
 (I[381] = (T)(img)(_p8##x,_n10##y,z,c)), \
 (I[2] = (T)(img)(_p7##x,_p9##y,z,c)), \
 (I[22] = (T)(img)(_p7##x,_p8##y,z,c)), \
 (I[42] = (T)(img)(_p7##x,_p7##y,z,c)), \
 (I[62] = (T)(img)(_p7##x,_p6##y,z,c)), \
 (I[82] = (T)(img)(_p7##x,_p5##y,z,c)), \
 (I[102] = (T)(img)(_p7##x,_p4##y,z,c)), \
 (I[122] = (T)(img)(_p7##x,_p3##y,z,c)), \
 (I[142] = (T)(img)(_p7##x,_p2##y,z,c)), \
 (I[162] = (T)(img)(_p7##x,_p1##y,z,c)), \
 (I[182] = (T)(img)(_p7##x,y,z,c)), \
 (I[202] = (T)(img)(_p7##x,_n1##y,z,c)), \
 (I[222] = (T)(img)(_p7##x,_n2##y,z,c)), \
 (I[242] = (T)(img)(_p7##x,_n3##y,z,c)), \
 (I[262] = (T)(img)(_p7##x,_n4##y,z,c)), \
 (I[282] = (T)(img)(_p7##x,_n5##y,z,c)), \
 (I[302] = (T)(img)(_p7##x,_n6##y,z,c)), \
 (I[322] = (T)(img)(_p7##x,_n7##y,z,c)), \
 (I[342] = (T)(img)(_p7##x,_n8##y,z,c)), \
 (I[362] = (T)(img)(_p7##x,_n9##y,z,c)), \
 (I[382] = (T)(img)(_p7##x,_n10##y,z,c)), \
 (I[3] = (T)(img)(_p6##x,_p9##y,z,c)), \
 (I[23] = (T)(img)(_p6##x,_p8##y,z,c)), \
 (I[43] = (T)(img)(_p6##x,_p7##y,z,c)), \
 (I[63] = (T)(img)(_p6##x,_p6##y,z,c)), \
 (I[83] = (T)(img)(_p6##x,_p5##y,z,c)), \
 (I[103] = (T)(img)(_p6##x,_p4##y,z,c)), \
 (I[123] = (T)(img)(_p6##x,_p3##y,z,c)), \
 (I[143] = (T)(img)(_p6##x,_p2##y,z,c)), \
 (I[163] = (T)(img)(_p6##x,_p1##y,z,c)), \
 (I[183] = (T)(img)(_p6##x,y,z,c)), \
 (I[203] = (T)(img)(_p6##x,_n1##y,z,c)), \
 (I[223] = (T)(img)(_p6##x,_n2##y,z,c)), \
 (I[243] = (T)(img)(_p6##x,_n3##y,z,c)), \
 (I[263] = (T)(img)(_p6##x,_n4##y,z,c)), \
 (I[283] = (T)(img)(_p6##x,_n5##y,z,c)), \
 (I[303] = (T)(img)(_p6##x,_n6##y,z,c)), \
 (I[323] = (T)(img)(_p6##x,_n7##y,z,c)), \
 (I[343] = (T)(img)(_p6##x,_n8##y,z,c)), \
 (I[363] = (T)(img)(_p6##x,_n9##y,z,c)), \
 (I[383] = (T)(img)(_p6##x,_n10##y,z,c)), \
 (I[4] = (T)(img)(_p5##x,_p9##y,z,c)), \
 (I[24] = (T)(img)(_p5##x,_p8##y,z,c)), \
 (I[44] = (T)(img)(_p5##x,_p7##y,z,c)), \
 (I[64] = (T)(img)(_p5##x,_p6##y,z,c)), \
 (I[84] = (T)(img)(_p5##x,_p5##y,z,c)), \
 (I[104] = (T)(img)(_p5##x,_p4##y,z,c)), \
 (I[124] = (T)(img)(_p5##x,_p3##y,z,c)), \
 (I[144] = (T)(img)(_p5##x,_p2##y,z,c)), \
 (I[164] = (T)(img)(_p5##x,_p1##y,z,c)), \
 (I[184] = (T)(img)(_p5##x,y,z,c)), \
 (I[204] = (T)(img)(_p5##x,_n1##y,z,c)), \
 (I[224] = (T)(img)(_p5##x,_n2##y,z,c)), \
 (I[244] = (T)(img)(_p5##x,_n3##y,z,c)), \
 (I[264] = (T)(img)(_p5##x,_n4##y,z,c)), \
 (I[284] = (T)(img)(_p5##x,_n5##y,z,c)), \
 (I[304] = (T)(img)(_p5##x,_n6##y,z,c)), \
 (I[324] = (T)(img)(_p5##x,_n7##y,z,c)), \
 (I[344] = (T)(img)(_p5##x,_n8##y,z,c)), \
 (I[364] = (T)(img)(_p5##x,_n9##y,z,c)), \
 (I[384] = (T)(img)(_p5##x,_n10##y,z,c)), \
 (I[5] = (T)(img)(_p4##x,_p9##y,z,c)), \
 (I[25] = (T)(img)(_p4##x,_p8##y,z,c)), \
 (I[45] = (T)(img)(_p4##x,_p7##y,z,c)), \
 (I[65] = (T)(img)(_p4##x,_p6##y,z,c)), \
 (I[85] = (T)(img)(_p4##x,_p5##y,z,c)), \
 (I[105] = (T)(img)(_p4##x,_p4##y,z,c)), \
 (I[125] = (T)(img)(_p4##x,_p3##y,z,c)), \
 (I[145] = (T)(img)(_p4##x,_p2##y,z,c)), \
 (I[165] = (T)(img)(_p4##x,_p1##y,z,c)), \
 (I[185] = (T)(img)(_p4##x,y,z,c)), \
 (I[205] = (T)(img)(_p4##x,_n1##y,z,c)), \
 (I[225] = (T)(img)(_p4##x,_n2##y,z,c)), \
 (I[245] = (T)(img)(_p4##x,_n3##y,z,c)), \
 (I[265] = (T)(img)(_p4##x,_n4##y,z,c)), \
 (I[285] = (T)(img)(_p4##x,_n5##y,z,c)), \
 (I[305] = (T)(img)(_p4##x,_n6##y,z,c)), \
 (I[325] = (T)(img)(_p4##x,_n7##y,z,c)), \
 (I[345] = (T)(img)(_p4##x,_n8##y,z,c)), \
 (I[365] = (T)(img)(_p4##x,_n9##y,z,c)), \
 (I[385] = (T)(img)(_p4##x,_n10##y,z,c)), \
 (I[6] = (T)(img)(_p3##x,_p9##y,z,c)), \
 (I[26] = (T)(img)(_p3##x,_p8##y,z,c)), \
 (I[46] = (T)(img)(_p3##x,_p7##y,z,c)), \
 (I[66] = (T)(img)(_p3##x,_p6##y,z,c)), \
 (I[86] = (T)(img)(_p3##x,_p5##y,z,c)), \
 (I[106] = (T)(img)(_p3##x,_p4##y,z,c)), \
 (I[126] = (T)(img)(_p3##x,_p3##y,z,c)), \
 (I[146] = (T)(img)(_p3##x,_p2##y,z,c)), \
 (I[166] = (T)(img)(_p3##x,_p1##y,z,c)), \
 (I[186] = (T)(img)(_p3##x,y,z,c)), \
 (I[206] = (T)(img)(_p3##x,_n1##y,z,c)), \
 (I[226] = (T)(img)(_p3##x,_n2##y,z,c)), \
 (I[246] = (T)(img)(_p3##x,_n3##y,z,c)), \
 (I[266] = (T)(img)(_p3##x,_n4##y,z,c)), \
 (I[286] = (T)(img)(_p3##x,_n5##y,z,c)), \
 (I[306] = (T)(img)(_p3##x,_n6##y,z,c)), \
 (I[326] = (T)(img)(_p3##x,_n7##y,z,c)), \
 (I[346] = (T)(img)(_p3##x,_n8##y,z,c)), \
 (I[366] = (T)(img)(_p3##x,_n9##y,z,c)), \
 (I[386] = (T)(img)(_p3##x,_n10##y,z,c)), \
 (I[7] = (T)(img)(_p2##x,_p9##y,z,c)), \
 (I[27] = (T)(img)(_p2##x,_p8##y,z,c)), \
 (I[47] = (T)(img)(_p2##x,_p7##y,z,c)), \
 (I[67] = (T)(img)(_p2##x,_p6##y,z,c)), \
 (I[87] = (T)(img)(_p2##x,_p5##y,z,c)), \
 (I[107] = (T)(img)(_p2##x,_p4##y,z,c)), \
 (I[127] = (T)(img)(_p2##x,_p3##y,z,c)), \
 (I[147] = (T)(img)(_p2##x,_p2##y,z,c)), \
 (I[167] = (T)(img)(_p2##x,_p1##y,z,c)), \
 (I[187] = (T)(img)(_p2##x,y,z,c)), \
 (I[207] = (T)(img)(_p2##x,_n1##y,z,c)), \
 (I[227] = (T)(img)(_p2##x,_n2##y,z,c)), \
 (I[247] = (T)(img)(_p2##x,_n3##y,z,c)), \
 (I[267] = (T)(img)(_p2##x,_n4##y,z,c)), \
 (I[287] = (T)(img)(_p2##x,_n5##y,z,c)), \
 (I[307] = (T)(img)(_p2##x,_n6##y,z,c)), \
 (I[327] = (T)(img)(_p2##x,_n7##y,z,c)), \
 (I[347] = (T)(img)(_p2##x,_n8##y,z,c)), \
 (I[367] = (T)(img)(_p2##x,_n9##y,z,c)), \
 (I[387] = (T)(img)(_p2##x,_n10##y,z,c)), \
 (I[8] = (T)(img)(_p1##x,_p9##y,z,c)), \
 (I[28] = (T)(img)(_p1##x,_p8##y,z,c)), \
 (I[48] = (T)(img)(_p1##x,_p7##y,z,c)), \
 (I[68] = (T)(img)(_p1##x,_p6##y,z,c)), \
 (I[88] = (T)(img)(_p1##x,_p5##y,z,c)), \
 (I[108] = (T)(img)(_p1##x,_p4##y,z,c)), \
 (I[128] = (T)(img)(_p1##x,_p3##y,z,c)), \
 (I[148] = (T)(img)(_p1##x,_p2##y,z,c)), \
 (I[168] = (T)(img)(_p1##x,_p1##y,z,c)), \
 (I[188] = (T)(img)(_p1##x,y,z,c)), \
 (I[208] = (T)(img)(_p1##x,_n1##y,z,c)), \
 (I[228] = (T)(img)(_p1##x,_n2##y,z,c)), \
 (I[248] = (T)(img)(_p1##x,_n3##y,z,c)), \
 (I[268] = (T)(img)(_p1##x,_n4##y,z,c)), \
 (I[288] = (T)(img)(_p1##x,_n5##y,z,c)), \
 (I[308] = (T)(img)(_p1##x,_n6##y,z,c)), \
 (I[328] = (T)(img)(_p1##x,_n7##y,z,c)), \
 (I[348] = (T)(img)(_p1##x,_n8##y,z,c)), \
 (I[368] = (T)(img)(_p1##x,_n9##y,z,c)), \
 (I[388] = (T)(img)(_p1##x,_n10##y,z,c)), \
 (I[9] = (T)(img)(x,_p9##y,z,c)), \
 (I[29] = (T)(img)(x,_p8##y,z,c)), \
 (I[49] = (T)(img)(x,_p7##y,z,c)), \
 (I[69] = (T)(img)(x,_p6##y,z,c)), \
 (I[89] = (T)(img)(x,_p5##y,z,c)), \
 (I[109] = (T)(img)(x,_p4##y,z,c)), \
 (I[129] = (T)(img)(x,_p3##y,z,c)), \
 (I[149] = (T)(img)(x,_p2##y,z,c)), \
 (I[169] = (T)(img)(x,_p1##y,z,c)), \
 (I[189] = (T)(img)(x,y,z,c)), \
 (I[209] = (T)(img)(x,_n1##y,z,c)), \
 (I[229] = (T)(img)(x,_n2##y,z,c)), \
 (I[249] = (T)(img)(x,_n3##y,z,c)), \
 (I[269] = (T)(img)(x,_n4##y,z,c)), \
 (I[289] = (T)(img)(x,_n5##y,z,c)), \
 (I[309] = (T)(img)(x,_n6##y,z,c)), \
 (I[329] = (T)(img)(x,_n7##y,z,c)), \
 (I[349] = (T)(img)(x,_n8##y,z,c)), \
 (I[369] = (T)(img)(x,_n9##y,z,c)), \
 (I[389] = (T)(img)(x,_n10##y,z,c)), \
 (I[10] = (T)(img)(_n1##x,_p9##y,z,c)), \
 (I[30] = (T)(img)(_n1##x,_p8##y,z,c)), \
 (I[50] = (T)(img)(_n1##x,_p7##y,z,c)), \
 (I[70] = (T)(img)(_n1##x,_p6##y,z,c)), \
 (I[90] = (T)(img)(_n1##x,_p5##y,z,c)), \
 (I[110] = (T)(img)(_n1##x,_p4##y,z,c)), \
 (I[130] = (T)(img)(_n1##x,_p3##y,z,c)), \
 (I[150] = (T)(img)(_n1##x,_p2##y,z,c)), \
 (I[170] = (T)(img)(_n1##x,_p1##y,z,c)), \
 (I[190] = (T)(img)(_n1##x,y,z,c)), \
 (I[210] = (T)(img)(_n1##x,_n1##y,z,c)), \
 (I[230] = (T)(img)(_n1##x,_n2##y,z,c)), \
 (I[250] = (T)(img)(_n1##x,_n3##y,z,c)), \
 (I[270] = (T)(img)(_n1##x,_n4##y,z,c)), \
 (I[290] = (T)(img)(_n1##x,_n5##y,z,c)), \
 (I[310] = (T)(img)(_n1##x,_n6##y,z,c)), \
 (I[330] = (T)(img)(_n1##x,_n7##y,z,c)), \
 (I[350] = (T)(img)(_n1##x,_n8##y,z,c)), \
 (I[370] = (T)(img)(_n1##x,_n9##y,z,c)), \
 (I[390] = (T)(img)(_n1##x,_n10##y,z,c)), \
 (I[11] = (T)(img)(_n2##x,_p9##y,z,c)), \
 (I[31] = (T)(img)(_n2##x,_p8##y,z,c)), \
 (I[51] = (T)(img)(_n2##x,_p7##y,z,c)), \
 (I[71] = (T)(img)(_n2##x,_p6##y,z,c)), \
 (I[91] = (T)(img)(_n2##x,_p5##y,z,c)), \
 (I[111] = (T)(img)(_n2##x,_p4##y,z,c)), \
 (I[131] = (T)(img)(_n2##x,_p3##y,z,c)), \
 (I[151] = (T)(img)(_n2##x,_p2##y,z,c)), \
 (I[171] = (T)(img)(_n2##x,_p1##y,z,c)), \
 (I[191] = (T)(img)(_n2##x,y,z,c)), \
 (I[211] = (T)(img)(_n2##x,_n1##y,z,c)), \
 (I[231] = (T)(img)(_n2##x,_n2##y,z,c)), \
 (I[251] = (T)(img)(_n2##x,_n3##y,z,c)), \
 (I[271] = (T)(img)(_n2##x,_n4##y,z,c)), \
 (I[291] = (T)(img)(_n2##x,_n5##y,z,c)), \
 (I[311] = (T)(img)(_n2##x,_n6##y,z,c)), \
 (I[331] = (T)(img)(_n2##x,_n7##y,z,c)), \
 (I[351] = (T)(img)(_n2##x,_n8##y,z,c)), \
 (I[371] = (T)(img)(_n2##x,_n9##y,z,c)), \
 (I[391] = (T)(img)(_n2##x,_n10##y,z,c)), \
 (I[12] = (T)(img)(_n3##x,_p9##y,z,c)), \
 (I[32] = (T)(img)(_n3##x,_p8##y,z,c)), \
 (I[52] = (T)(img)(_n3##x,_p7##y,z,c)), \
 (I[72] = (T)(img)(_n3##x,_p6##y,z,c)), \
 (I[92] = (T)(img)(_n3##x,_p5##y,z,c)), \
 (I[112] = (T)(img)(_n3##x,_p4##y,z,c)), \
 (I[132] = (T)(img)(_n3##x,_p3##y,z,c)), \
 (I[152] = (T)(img)(_n3##x,_p2##y,z,c)), \
 (I[172] = (T)(img)(_n3##x,_p1##y,z,c)), \
 (I[192] = (T)(img)(_n3##x,y,z,c)), \
 (I[212] = (T)(img)(_n3##x,_n1##y,z,c)), \
 (I[232] = (T)(img)(_n3##x,_n2##y,z,c)), \
 (I[252] = (T)(img)(_n3##x,_n3##y,z,c)), \
 (I[272] = (T)(img)(_n3##x,_n4##y,z,c)), \
 (I[292] = (T)(img)(_n3##x,_n5##y,z,c)), \
 (I[312] = (T)(img)(_n3##x,_n6##y,z,c)), \
 (I[332] = (T)(img)(_n3##x,_n7##y,z,c)), \
 (I[352] = (T)(img)(_n3##x,_n8##y,z,c)), \
 (I[372] = (T)(img)(_n3##x,_n9##y,z,c)), \
 (I[392] = (T)(img)(_n3##x,_n10##y,z,c)), \
 (I[13] = (T)(img)(_n4##x,_p9##y,z,c)), \
 (I[33] = (T)(img)(_n4##x,_p8##y,z,c)), \
 (I[53] = (T)(img)(_n4##x,_p7##y,z,c)), \
 (I[73] = (T)(img)(_n4##x,_p6##y,z,c)), \
 (I[93] = (T)(img)(_n4##x,_p5##y,z,c)), \
 (I[113] = (T)(img)(_n4##x,_p4##y,z,c)), \
 (I[133] = (T)(img)(_n4##x,_p3##y,z,c)), \
 (I[153] = (T)(img)(_n4##x,_p2##y,z,c)), \
 (I[173] = (T)(img)(_n4##x,_p1##y,z,c)), \
 (I[193] = (T)(img)(_n4##x,y,z,c)), \
 (I[213] = (T)(img)(_n4##x,_n1##y,z,c)), \
 (I[233] = (T)(img)(_n4##x,_n2##y,z,c)), \
 (I[253] = (T)(img)(_n4##x,_n3##y,z,c)), \
 (I[273] = (T)(img)(_n4##x,_n4##y,z,c)), \
 (I[293] = (T)(img)(_n4##x,_n5##y,z,c)), \
 (I[313] = (T)(img)(_n4##x,_n6##y,z,c)), \
 (I[333] = (T)(img)(_n4##x,_n7##y,z,c)), \
 (I[353] = (T)(img)(_n4##x,_n8##y,z,c)), \
 (I[373] = (T)(img)(_n4##x,_n9##y,z,c)), \
 (I[393] = (T)(img)(_n4##x,_n10##y,z,c)), \
 (I[14] = (T)(img)(_n5##x,_p9##y,z,c)), \
 (I[34] = (T)(img)(_n5##x,_p8##y,z,c)), \
 (I[54] = (T)(img)(_n5##x,_p7##y,z,c)), \
 (I[74] = (T)(img)(_n5##x,_p6##y,z,c)), \
 (I[94] = (T)(img)(_n5##x,_p5##y,z,c)), \
 (I[114] = (T)(img)(_n5##x,_p4##y,z,c)), \
 (I[134] = (T)(img)(_n5##x,_p3##y,z,c)), \
 (I[154] = (T)(img)(_n5##x,_p2##y,z,c)), \
 (I[174] = (T)(img)(_n5##x,_p1##y,z,c)), \
 (I[194] = (T)(img)(_n5##x,y,z,c)), \
 (I[214] = (T)(img)(_n5##x,_n1##y,z,c)), \
 (I[234] = (T)(img)(_n5##x,_n2##y,z,c)), \
 (I[254] = (T)(img)(_n5##x,_n3##y,z,c)), \
 (I[274] = (T)(img)(_n5##x,_n4##y,z,c)), \
 (I[294] = (T)(img)(_n5##x,_n5##y,z,c)), \
 (I[314] = (T)(img)(_n5##x,_n6##y,z,c)), \
 (I[334] = (T)(img)(_n5##x,_n7##y,z,c)), \
 (I[354] = (T)(img)(_n5##x,_n8##y,z,c)), \
 (I[374] = (T)(img)(_n5##x,_n9##y,z,c)), \
 (I[394] = (T)(img)(_n5##x,_n10##y,z,c)), \
 (I[15] = (T)(img)(_n6##x,_p9##y,z,c)), \
 (I[35] = (T)(img)(_n6##x,_p8##y,z,c)), \
 (I[55] = (T)(img)(_n6##x,_p7##y,z,c)), \
 (I[75] = (T)(img)(_n6##x,_p6##y,z,c)), \
 (I[95] = (T)(img)(_n6##x,_p5##y,z,c)), \
 (I[115] = (T)(img)(_n6##x,_p4##y,z,c)), \
 (I[135] = (T)(img)(_n6##x,_p3##y,z,c)), \
 (I[155] = (T)(img)(_n6##x,_p2##y,z,c)), \
 (I[175] = (T)(img)(_n6##x,_p1##y,z,c)), \
 (I[195] = (T)(img)(_n6##x,y,z,c)), \
 (I[215] = (T)(img)(_n6##x,_n1##y,z,c)), \
 (I[235] = (T)(img)(_n6##x,_n2##y,z,c)), \
 (I[255] = (T)(img)(_n6##x,_n3##y,z,c)), \
 (I[275] = (T)(img)(_n6##x,_n4##y,z,c)), \
 (I[295] = (T)(img)(_n6##x,_n5##y,z,c)), \
 (I[315] = (T)(img)(_n6##x,_n6##y,z,c)), \
 (I[335] = (T)(img)(_n6##x,_n7##y,z,c)), \
 (I[355] = (T)(img)(_n6##x,_n8##y,z,c)), \
 (I[375] = (T)(img)(_n6##x,_n9##y,z,c)), \
 (I[395] = (T)(img)(_n6##x,_n10##y,z,c)), \
 (I[16] = (T)(img)(_n7##x,_p9##y,z,c)), \
 (I[36] = (T)(img)(_n7##x,_p8##y,z,c)), \
 (I[56] = (T)(img)(_n7##x,_p7##y,z,c)), \
 (I[76] = (T)(img)(_n7##x,_p6##y,z,c)), \
 (I[96] = (T)(img)(_n7##x,_p5##y,z,c)), \
 (I[116] = (T)(img)(_n7##x,_p4##y,z,c)), \
 (I[136] = (T)(img)(_n7##x,_p3##y,z,c)), \
 (I[156] = (T)(img)(_n7##x,_p2##y,z,c)), \
 (I[176] = (T)(img)(_n7##x,_p1##y,z,c)), \
 (I[196] = (T)(img)(_n7##x,y,z,c)), \
 (I[216] = (T)(img)(_n7##x,_n1##y,z,c)), \
 (I[236] = (T)(img)(_n7##x,_n2##y,z,c)), \
 (I[256] = (T)(img)(_n7##x,_n3##y,z,c)), \
 (I[276] = (T)(img)(_n7##x,_n4##y,z,c)), \
 (I[296] = (T)(img)(_n7##x,_n5##y,z,c)), \
 (I[316] = (T)(img)(_n7##x,_n6##y,z,c)), \
 (I[336] = (T)(img)(_n7##x,_n7##y,z,c)), \
 (I[356] = (T)(img)(_n7##x,_n8##y,z,c)), \
 (I[376] = (T)(img)(_n7##x,_n9##y,z,c)), \
 (I[396] = (T)(img)(_n7##x,_n10##y,z,c)), \
 (I[17] = (T)(img)(_n8##x,_p9##y,z,c)), \
 (I[37] = (T)(img)(_n8##x,_p8##y,z,c)), \
 (I[57] = (T)(img)(_n8##x,_p7##y,z,c)), \
 (I[77] = (T)(img)(_n8##x,_p6##y,z,c)), \
 (I[97] = (T)(img)(_n8##x,_p5##y,z,c)), \
 (I[117] = (T)(img)(_n8##x,_p4##y,z,c)), \
 (I[137] = (T)(img)(_n8##x,_p3##y,z,c)), \
 (I[157] = (T)(img)(_n8##x,_p2##y,z,c)), \
 (I[177] = (T)(img)(_n8##x,_p1##y,z,c)), \
 (I[197] = (T)(img)(_n8##x,y,z,c)), \
 (I[217] = (T)(img)(_n8##x,_n1##y,z,c)), \
 (I[237] = (T)(img)(_n8##x,_n2##y,z,c)), \
 (I[257] = (T)(img)(_n8##x,_n3##y,z,c)), \
 (I[277] = (T)(img)(_n8##x,_n4##y,z,c)), \
 (I[297] = (T)(img)(_n8##x,_n5##y,z,c)), \
 (I[317] = (T)(img)(_n8##x,_n6##y,z,c)), \
 (I[337] = (T)(img)(_n8##x,_n7##y,z,c)), \
 (I[357] = (T)(img)(_n8##x,_n8##y,z,c)), \
 (I[377] = (T)(img)(_n8##x,_n9##y,z,c)), \
 (I[397] = (T)(img)(_n8##x,_n10##y,z,c)), \
 (I[18] = (T)(img)(_n9##x,_p9##y,z,c)), \
 (I[38] = (T)(img)(_n9##x,_p8##y,z,c)), \
 (I[58] = (T)(img)(_n9##x,_p7##y,z,c)), \
 (I[78] = (T)(img)(_n9##x,_p6##y,z,c)), \
 (I[98] = (T)(img)(_n9##x,_p5##y,z,c)), \
 (I[118] = (T)(img)(_n9##x,_p4##y,z,c)), \
 (I[138] = (T)(img)(_n9##x,_p3##y,z,c)), \
 (I[158] = (T)(img)(_n9##x,_p2##y,z,c)), \
 (I[178] = (T)(img)(_n9##x,_p1##y,z,c)), \
 (I[198] = (T)(img)(_n9##x,y,z,c)), \
 (I[218] = (T)(img)(_n9##x,_n1##y,z,c)), \
 (I[238] = (T)(img)(_n9##x,_n2##y,z,c)), \
 (I[258] = (T)(img)(_n9##x,_n3##y,z,c)), \
 (I[278] = (T)(img)(_n9##x,_n4##y,z,c)), \
 (I[298] = (T)(img)(_n9##x,_n5##y,z,c)), \
 (I[318] = (T)(img)(_n9##x,_n6##y,z,c)), \
 (I[338] = (T)(img)(_n9##x,_n7##y,z,c)), \
 (I[358] = (T)(img)(_n9##x,_n8##y,z,c)), \
 (I[378] = (T)(img)(_n9##x,_n9##y,z,c)), \
 (I[398] = (T)(img)(_n9##x,_n10##y,z,c)), \
 x+10>=(img).width()?(img).width()-1:x+10); \
 x<=(int)(x1) && ((_n10##x<(img).width() && ( \
 (I[19] = (T)(img)(_n10##x,_p9##y,z,c)), \
 (I[39] = (T)(img)(_n10##x,_p8##y,z,c)), \
 (I[59] = (T)(img)(_n10##x,_p7##y,z,c)), \
 (I[79] = (T)(img)(_n10##x,_p6##y,z,c)), \
 (I[99] = (T)(img)(_n10##x,_p5##y,z,c)), \
 (I[119] = (T)(img)(_n10##x,_p4##y,z,c)), \
 (I[139] = (T)(img)(_n10##x,_p3##y,z,c)), \
 (I[159] = (T)(img)(_n10##x,_p2##y,z,c)), \
 (I[179] = (T)(img)(_n10##x,_p1##y,z,c)), \
 (I[199] = (T)(img)(_n10##x,y,z,c)), \
 (I[219] = (T)(img)(_n10##x,_n1##y,z,c)), \
 (I[239] = (T)(img)(_n10##x,_n2##y,z,c)), \
 (I[259] = (T)(img)(_n10##x,_n3##y,z,c)), \
 (I[279] = (T)(img)(_n10##x,_n4##y,z,c)), \
 (I[299] = (T)(img)(_n10##x,_n5##y,z,c)), \
 (I[319] = (T)(img)(_n10##x,_n6##y,z,c)), \
 (I[339] = (T)(img)(_n10##x,_n7##y,z,c)), \
 (I[359] = (T)(img)(_n10##x,_n8##y,z,c)), \
 (I[379] = (T)(img)(_n10##x,_n9##y,z,c)), \
 (I[399] = (T)(img)(_n10##x,_n10##y,z,c)),1)) || \
 _n9##x==--_n10##x || _n8##x==--_n9##x || _n7##x==--_n8##x || _n6##x==--_n7##x || _n5##x==--_n6##x || _n4##x==--_n5##x || _n3##x==--_n4##x || _n2##x==--_n3##x || _n1##x==--_n2##x || x==(_n10##x = _n9##x = _n8##x = _n7##x = _n6##x = _n5##x = _n4##x = _n3##x = _n2##x = --_n1##x)); \
 I[0] = I[1], I[1] = I[2], I[2] = I[3], I[3] = I[4], I[4] = I[5], I[5] = I[6], I[6] = I[7], I[7] = I[8], I[8] = I[9], I[9] = I[10], I[10] = I[11], I[11] = I[12], I[12] = I[13], I[13] = I[14], I[14] = I[15], I[15] = I[16], I[16] = I[17], I[17] = I[18], I[18] = I[19], \
 I[20] = I[21], I[21] = I[22], I[22] = I[23], I[23] = I[24], I[24] = I[25], I[25] = I[26], I[26] = I[27], I[27] = I[28], I[28] = I[29], I[29] = I[30], I[30] = I[31], I[31] = I[32], I[32] = I[33], I[33] = I[34], I[34] = I[35], I[35] = I[36], I[36] = I[37], I[37] = I[38], I[38] = I[39], \
 I[40] = I[41], I[41] = I[42], I[42] = I[43], I[43] = I[44], I[44] = I[45], I[45] = I[46], I[46] = I[47], I[47] = I[48], I[48] = I[49], I[49] = I[50], I[50] = I[51], I[51] = I[52], I[52] = I[53], I[53] = I[54], I[54] = I[55], I[55] = I[56], I[56] = I[57], I[57] = I[58], I[58] = I[59], \
 I[60] = I[61], I[61] = I[62], I[62] = I[63], I[63] = I[64], I[64] = I[65], I[65] = I[66], I[66] = I[67], I[67] = I[68], I[68] = I[69], I[69] = I[70], I[70] = I[71], I[71] = I[72], I[72] = I[73], I[73] = I[74], I[74] = I[75], I[75] = I[76], I[76] = I[77], I[77] = I[78], I[78] = I[79], \
 I[80] = I[81], I[81] = I[82], I[82] = I[83], I[83] = I[84], I[84] = I[85], I[85] = I[86], I[86] = I[87], I[87] = I[88], I[88] = I[89], I[89] = I[90], I[90] = I[91], I[91] = I[92], I[92] = I[93], I[93] = I[94], I[94] = I[95], I[95] = I[96], I[96] = I[97], I[97] = I[98], I[98] = I[99], \
 I[100] = I[101], I[101] = I[102], I[102] = I[103], I[103] = I[104], I[104] = I[105], I[105] = I[106], I[106] = I[107], I[107] = I[108], I[108] = I[109], I[109] = I[110], I[110] = I[111], I[111] = I[112], I[112] = I[113], I[113] = I[114], I[114] = I[115], I[115] = I[116], I[116] = I[117], I[117] = I[118], I[118] = I[119], \
 I[120] = I[121], I[121] = I[122], I[122] = I[123], I[123] = I[124], I[124] = I[125], I[125] = I[126], I[126] = I[127], I[127] = I[128], I[128] = I[129], I[129] = I[130], I[130] = I[131], I[131] = I[132], I[132] = I[133], I[133] = I[134], I[134] = I[135], I[135] = I[136], I[136] = I[137], I[137] = I[138], I[138] = I[139], \
 I[140] = I[141], I[141] = I[142], I[142] = I[143], I[143] = I[144], I[144] = I[145], I[145] = I[146], I[146] = I[147], I[147] = I[148], I[148] = I[149], I[149] = I[150], I[150] = I[151], I[151] = I[152], I[152] = I[153], I[153] = I[154], I[154] = I[155], I[155] = I[156], I[156] = I[157], I[157] = I[158], I[158] = I[159], \
 I[160] = I[161], I[161] = I[162], I[162] = I[163], I[163] = I[164], I[164] = I[165], I[165] = I[166], I[166] = I[167], I[167] = I[168], I[168] = I[169], I[169] = I[170], I[170] = I[171], I[171] = I[172], I[172] = I[173], I[173] = I[174], I[174] = I[175], I[175] = I[176], I[176] = I[177], I[177] = I[178], I[178] = I[179], \
 I[180] = I[181], I[181] = I[182], I[182] = I[183], I[183] = I[184], I[184] = I[185], I[185] = I[186], I[186] = I[187], I[187] = I[188], I[188] = I[189], I[189] = I[190], I[190] = I[191], I[191] = I[192], I[192] = I[193], I[193] = I[194], I[194] = I[195], I[195] = I[196], I[196] = I[197], I[197] = I[198], I[198] = I[199], \
 I[200] = I[201], I[201] = I[202], I[202] = I[203], I[203] = I[204], I[204] = I[205], I[205] = I[206], I[206] = I[207], I[207] = I[208], I[208] = I[209], I[209] = I[210], I[210] = I[211], I[211] = I[212], I[212] = I[213], I[213] = I[214], I[214] = I[215], I[215] = I[216], I[216] = I[217], I[217] = I[218], I[218] = I[219], \
 I[220] = I[221], I[221] = I[222], I[222] = I[223], I[223] = I[224], I[224] = I[225], I[225] = I[226], I[226] = I[227], I[227] = I[228], I[228] = I[229], I[229] = I[230], I[230] = I[231], I[231] = I[232], I[232] = I[233], I[233] = I[234], I[234] = I[235], I[235] = I[236], I[236] = I[237], I[237] = I[238], I[238] = I[239], \
 I[240] = I[241], I[241] = I[242], I[242] = I[243], I[243] = I[244], I[244] = I[245], I[245] = I[246], I[246] = I[247], I[247] = I[248], I[248] = I[249], I[249] = I[250], I[250] = I[251], I[251] = I[252], I[252] = I[253], I[253] = I[254], I[254] = I[255], I[255] = I[256], I[256] = I[257], I[257] = I[258], I[258] = I[259], \
 I[260] = I[261], I[261] = I[262], I[262] = I[263], I[263] = I[264], I[264] = I[265], I[265] = I[266], I[266] = I[267], I[267] = I[268], I[268] = I[269], I[269] = I[270], I[270] = I[271], I[271] = I[272], I[272] = I[273], I[273] = I[274], I[274] = I[275], I[275] = I[276], I[276] = I[277], I[277] = I[278], I[278] = I[279], \
 I[280] = I[281], I[281] = I[282], I[282] = I[283], I[283] = I[284], I[284] = I[285], I[285] = I[286], I[286] = I[287], I[287] = I[288], I[288] = I[289], I[289] = I[290], I[290] = I[291], I[291] = I[292], I[292] = I[293], I[293] = I[294], I[294] = I[295], I[295] = I[296], I[296] = I[297], I[297] = I[298], I[298] = I[299], \
 I[300] = I[301], I[301] = I[302], I[302] = I[303], I[303] = I[304], I[304] = I[305], I[305] = I[306], I[306] = I[307], I[307] = I[308], I[308] = I[309], I[309] = I[310], I[310] = I[311], I[311] = I[312], I[312] = I[313], I[313] = I[314], I[314] = I[315], I[315] = I[316], I[316] = I[317], I[317] = I[318], I[318] = I[319], \
 I[320] = I[321], I[321] = I[322], I[322] = I[323], I[323] = I[324], I[324] = I[325], I[325] = I[326], I[326] = I[327], I[327] = I[328], I[328] = I[329], I[329] = I[330], I[330] = I[331], I[331] = I[332], I[332] = I[333], I[333] = I[334], I[334] = I[335], I[335] = I[336], I[336] = I[337], I[337] = I[338], I[338] = I[339], \
 I[340] = I[341], I[341] = I[342], I[342] = I[343], I[343] = I[344], I[344] = I[345], I[345] = I[346], I[346] = I[347], I[347] = I[348], I[348] = I[349], I[349] = I[350], I[350] = I[351], I[351] = I[352], I[352] = I[353], I[353] = I[354], I[354] = I[355], I[355] = I[356], I[356] = I[357], I[357] = I[358], I[358] = I[359], \
 I[360] = I[361], I[361] = I[362], I[362] = I[363], I[363] = I[364], I[364] = I[365], I[365] = I[366], I[366] = I[367], I[367] = I[368], I[368] = I[369], I[369] = I[370], I[370] = I[371], I[371] = I[372], I[372] = I[373], I[373] = I[374], I[374] = I[375], I[375] = I[376], I[376] = I[377], I[377] = I[378], I[378] = I[379], \
 I[380] = I[381], I[381] = I[382], I[382] = I[383], I[383] = I[384], I[384] = I[385], I[385] = I[386], I[386] = I[387], I[387] = I[388], I[388] = I[389], I[389] = I[390], I[390] = I[391], I[391] = I[392], I[392] = I[393], I[393] = I[394], I[394] = I[395], I[395] = I[396], I[396] = I[397], I[397] = I[398], I[398] = I[399], \
 _p9##x = _p8##x, _p8##x = _p7##x, _p7##x = _p6##x, _p6##x = _p5##x, _p5##x = _p4##x, _p4##x = _p3##x, _p3##x = _p2##x, _p2##x = _p1##x, _p1##x = x++, ++_n1##x, ++_n2##x, ++_n3##x, ++_n4##x, ++_n5##x, ++_n6##x, ++_n7##x, ++_n8##x, ++_n9##x, ++_n10##x)

#define cimg_get20x20(img,x,y,z,c,I,T) \
 I[0] = (T)(img)(_p9##x,_p9##y,z,c), I[1] = (T)(img)(_p8##x,_p9##y,z,c), I[2] = (T)(img)(_p7##x,_p9##y,z,c), I[3] = (T)(img)(_p6##x,_p9##y,z,c), I[4] = (T)(img)(_p5##x,_p9##y,z,c), I[5] = (T)(img)(_p4##x,_p9##y,z,c), I[6] = (T)(img)(_p3##x,_p9##y,z,c), I[7] = (T)(img)(_p2##x,_p9##y,z,c), I[8] = (T)(img)(_p1##x,_p9##y,z,c), I[9] = (T)(img)(x,_p9##y,z,c), I[10] = (T)(img)(_n1##x,_p9##y,z,c), I[11] = (T)(img)(_n2##x,_p9##y,z,c), I[12] = (T)(img)(_n3##x,_p9##y,z,c), I[13] = (T)(img)(_n4##x,_p9##y,z,c), I[14] = (T)(img)(_n5##x,_p9##y,z,c), I[15] = (T)(img)(_n6##x,_p9##y,z,c), I[16] = (T)(img)(_n7##x,_p9##y,z,c), I[17] = (T)(img)(_n8##x,_p9##y,z,c), I[18] = (T)(img)(_n9##x,_p9##y,z,c), I[19] = (T)(img)(_n10##x,_p9##y,z,c), \
 I[20] = (T)(img)(_p9##x,_p8##y,z,c), I[21] = (T)(img)(_p8##x,_p8##y,z,c), I[22] = (T)(img)(_p7##x,_p8##y,z,c), I[23] = (T)(img)(_p6##x,_p8##y,z,c), I[24] = (T)(img)(_p5##x,_p8##y,z,c), I[25] = (T)(img)(_p4##x,_p8##y,z,c), I[26] = (T)(img)(_p3##x,_p8##y,z,c), I[27] = (T)(img)(_p2##x,_p8##y,z,c), I[28] = (T)(img)(_p1##x,_p8##y,z,c), I[29] = (T)(img)(x,_p8##y,z,c), I[30] = (T)(img)(_n1##x,_p8##y,z,c), I[31] = (T)(img)(_n2##x,_p8##y,z,c), I[32] = (T)(img)(_n3##x,_p8##y,z,c), I[33] = (T)(img)(_n4##x,_p8##y,z,c), I[34] = (T)(img)(_n5##x,_p8##y,z,c), I[35] = (T)(img)(_n6##x,_p8##y,z,c), I[36] = (T)(img)(_n7##x,_p8##y,z,c), I[37] = (T)(img)(_n8##x,_p8##y,z,c), I[38] = (T)(img)(_n9##x,_p8##y,z,c), I[39] = (T)(img)(_n10##x,_p8##y,z,c), \
 I[40] = (T)(img)(_p9##x,_p7##y,z,c), I[41] = (T)(img)(_p8##x,_p7##y,z,c), I[42] = (T)(img)(_p7##x,_p7##y,z,c), I[43] = (T)(img)(_p6##x,_p7##y,z,c), I[44] = (T)(img)(_p5##x,_p7##y,z,c), I[45] = (T)(img)(_p4##x,_p7##y,z,c), I[46] = (T)(img)(_p3##x,_p7##y,z,c), I[47] = (T)(img)(_p2##x,_p7##y,z,c), I[48] = (T)(img)(_p1##x,_p7##y,z,c), I[49] = (T)(img)(x,_p7##y,z,c), I[50] = (T)(img)(_n1##x,_p7##y,z,c), I[51] = (T)(img)(_n2##x,_p7##y,z,c), I[52] = (T)(img)(_n3##x,_p7##y,z,c), I[53] = (T)(img)(_n4##x,_p7##y,z,c), I[54] = (T)(img)(_n5##x,_p7##y,z,c), I[55] = (T)(img)(_n6##x,_p7##y,z,c), I[56] = (T)(img)(_n7##x,_p7##y,z,c), I[57] = (T)(img)(_n8##x,_p7##y,z,c), I[58] = (T)(img)(_n9##x,_p7##y,z,c), I[59] = (T)(img)(_n10##x,_p7##y,z,c), \
 I[60] = (T)(img)(_p9##x,_p6##y,z,c), I[61] = (T)(img)(_p8##x,_p6##y,z,c), I[62] = (T)(img)(_p7##x,_p6##y,z,c), I[63] = (T)(img)(_p6##x,_p6##y,z,c), I[64] = (T)(img)(_p5##x,_p6##y,z,c), I[65] = (T)(img)(_p4##x,_p6##y,z,c), I[66] = (T)(img)(_p3##x,_p6##y,z,c), I[67] = (T)(img)(_p2##x,_p6##y,z,c), I[68] = (T)(img)(_p1##x,_p6##y,z,c), I[69] = (T)(img)(x,_p6##y,z,c), I[70] = (T)(img)(_n1##x,_p6##y,z,c), I[71] = (T)(img)(_n2##x,_p6##y,z,c), I[72] = (T)(img)(_n3##x,_p6##y,z,c), I[73] = (T)(img)(_n4##x,_p6##y,z,c), I[74] = (T)(img)(_n5##x,_p6##y,z,c), I[75] = (T)(img)(_n6##x,_p6##y,z,c), I[76] = (T)(img)(_n7##x,_p6##y,z,c), I[77] = (T)(img)(_n8##x,_p6##y,z,c), I[78] = (T)(img)(_n9##x,_p6##y,z,c), I[79] = (T)(img)(_n10##x,_p6##y,z,c), \
 I[80] = (T)(img)(_p9##x,_p5##y,z,c), I[81] = (T)(img)(_p8##x,_p5##y,z,c), I[82] = (T)(img)(_p7##x,_p5##y,z,c), I[83] = (T)(img)(_p6##x,_p5##y,z,c), I[84] = (T)(img)(_p5##x,_p5##y,z,c), I[85] = (T)(img)(_p4##x,_p5##y,z,c), I[86] = (T)(img)(_p3##x,_p5##y,z,c), I[87] = (T)(img)(_p2##x,_p5##y,z,c), I[88] = (T)(img)(_p1##x,_p5##y,z,c), I[89] = (T)(img)(x,_p5##y,z,c), I[90] = (T)(img)(_n1##x,_p5##y,z,c), I[91] = (T)(img)(_n2##x,_p5##y,z,c), I[92] = (T)(img)(_n3##x,_p5##y,z,c), I[93] = (T)(img)(_n4##x,_p5##y,z,c), I[94] = (T)(img)(_n5##x,_p5##y,z,c), I[95] = (T)(img)(_n6##x,_p5##y,z,c), I[96] = (T)(img)(_n7##x,_p5##y,z,c), I[97] = (T)(img)(_n8##x,_p5##y,z,c), I[98] = (T)(img)(_n9##x,_p5##y,z,c), I[99] = (T)(img)(_n10##x,_p5##y,z,c), \
 I[100] = (T)(img)(_p9##x,_p4##y,z,c), I[101] = (T)(img)(_p8##x,_p4##y,z,c), I[102] = (T)(img)(_p7##x,_p4##y,z,c), I[103] = (T)(img)(_p6##x,_p4##y,z,c), I[104] = (T)(img)(_p5##x,_p4##y,z,c), I[105] = (T)(img)(_p4##x,_p4##y,z,c), I[106] = (T)(img)(_p3##x,_p4##y,z,c), I[107] = (T)(img)(_p2##x,_p4##y,z,c), I[108] = (T)(img)(_p1##x,_p4##y,z,c), I[109] = (T)(img)(x,_p4##y,z,c), I[110] = (T)(img)(_n1##x,_p4##y,z,c), I[111] = (T)(img)(_n2##x,_p4##y,z,c), I[112] = (T)(img)(_n3##x,_p4##y,z,c), I[113] = (T)(img)(_n4##x,_p4##y,z,c), I[114] = (T)(img)(_n5##x,_p4##y,z,c), I[115] = (T)(img)(_n6##x,_p4##y,z,c), I[116] = (T)(img)(_n7##x,_p4##y,z,c), I[117] = (T)(img)(_n8##x,_p4##y,z,c), I[118] = (T)(img)(_n9##x,_p4##y,z,c), I[119] = (T)(img)(_n10##x,_p4##y,z,c), \
 I[120] = (T)(img)(_p9##x,_p3##y,z,c), I[121] = (T)(img)(_p8##x,_p3##y,z,c), I[122] = (T)(img)(_p7##x,_p3##y,z,c), I[123] = (T)(img)(_p6##x,_p3##y,z,c), I[124] = (T)(img)(_p5##x,_p3##y,z,c), I[125] = (T)(img)(_p4##x,_p3##y,z,c), I[126] = (T)(img)(_p3##x,_p3##y,z,c), I[127] = (T)(img)(_p2##x,_p3##y,z,c), I[128] = (T)(img)(_p1##x,_p3##y,z,c), I[129] = (T)(img)(x,_p3##y,z,c), I[130] = (T)(img)(_n1##x,_p3##y,z,c), I[131] = (T)(img)(_n2##x,_p3##y,z,c), I[132] = (T)(img)(_n3##x,_p3##y,z,c), I[133] = (T)(img)(_n4##x,_p3##y,z,c), I[134] = (T)(img)(_n5##x,_p3##y,z,c), I[135] = (T)(img)(_n6##x,_p3##y,z,c), I[136] = (T)(img)(_n7##x,_p3##y,z,c), I[137] = (T)(img)(_n8##x,_p3##y,z,c), I[138] = (T)(img)(_n9##x,_p3##y,z,c), I[139] = (T)(img)(_n10##x,_p3##y,z,c), \
 I[140] = (T)(img)(_p9##x,_p2##y,z,c), I[141] = (T)(img)(_p8##x,_p2##y,z,c), I[142] = (T)(img)(_p7##x,_p2##y,z,c), I[143] = (T)(img)(_p6##x,_p2##y,z,c), I[144] = (T)(img)(_p5##x,_p2##y,z,c), I[145] = (T)(img)(_p4##x,_p2##y,z,c), I[146] = (T)(img)(_p3##x,_p2##y,z,c), I[147] = (T)(img)(_p2##x,_p2##y,z,c), I[148] = (T)(img)(_p1##x,_p2##y,z,c), I[149] = (T)(img)(x,_p2##y,z,c), I[150] = (T)(img)(_n1##x,_p2##y,z,c), I[151] = (T)(img)(_n2##x,_p2##y,z,c), I[152] = (T)(img)(_n3##x,_p2##y,z,c), I[153] = (T)(img)(_n4##x,_p2##y,z,c), I[154] = (T)(img)(_n5##x,_p2##y,z,c), I[155] = (T)(img)(_n6##x,_p2##y,z,c), I[156] = (T)(img)(_n7##x,_p2##y,z,c), I[157] = (T)(img)(_n8##x,_p2##y,z,c), I[158] = (T)(img)(_n9##x,_p2##y,z,c), I[159] = (T)(img)(_n10##x,_p2##y,z,c), \
 I[160] = (T)(img)(_p9##x,_p1##y,z,c), I[161] = (T)(img)(_p8##x,_p1##y,z,c), I[162] = (T)(img)(_p7##x,_p1##y,z,c), I[163] = (T)(img)(_p6##x,_p1##y,z,c), I[164] = (T)(img)(_p5##x,_p1##y,z,c), I[165] = (T)(img)(_p4##x,_p1##y,z,c), I[166] = (T)(img)(_p3##x,_p1##y,z,c), I[167] = (T)(img)(_p2##x,_p1##y,z,c), I[168] = (T)(img)(_p1##x,_p1##y,z,c), I[169] = (T)(img)(x,_p1##y,z,c), I[170] = (T)(img)(_n1##x,_p1##y,z,c), I[171] = (T)(img)(_n2##x,_p1##y,z,c), I[172] = (T)(img)(_n3##x,_p1##y,z,c), I[173] = (T)(img)(_n4##x,_p1##y,z,c), I[174] = (T)(img)(_n5##x,_p1##y,z,c), I[175] = (T)(img)(_n6##x,_p1##y,z,c), I[176] = (T)(img)(_n7##x,_p1##y,z,c), I[177] = (T)(img)(_n8##x,_p1##y,z,c), I[178] = (T)(img)(_n9##x,_p1##y,z,c), I[179] = (T)(img)(_n10##x,_p1##y,z,c), \
 I[180] = (T)(img)(_p9##x,y,z,c), I[181] = (T)(img)(_p8##x,y,z,c), I[182] = (T)(img)(_p7##x,y,z,c), I[183] = (T)(img)(_p6##x,y,z,c), I[184] = (T)(img)(_p5##x,y,z,c), I[185] = (T)(img)(_p4##x,y,z,c), I[186] = (T)(img)(_p3##x,y,z,c), I[187] = (T)(img)(_p2##x,y,z,c), I[188] = (T)(img)(_p1##x,y,z,c), I[189] = (T)(img)(x,y,z,c), I[190] = (T)(img)(_n1##x,y,z,c), I[191] = (T)(img)(_n2##x,y,z,c), I[192] = (T)(img)(_n3##x,y,z,c), I[193] = (T)(img)(_n4##x,y,z,c), I[194] = (T)(img)(_n5##x,y,z,c), I[195] = (T)(img)(_n6##x,y,z,c), I[196] = (T)(img)(_n7##x,y,z,c), I[197] = (T)(img)(_n8##x,y,z,c), I[198] = (T)(img)(_n9##x,y,z,c), I[199] = (T)(img)(_n10##x,y,z,c), \
 I[200] = (T)(img)(_p9##x,_n1##y,z,c), I[201] = (T)(img)(_p8##x,_n1##y,z,c), I[202] = (T)(img)(_p7##x,_n1##y,z,c), I[203] = (T)(img)(_p6##x,_n1##y,z,c), I[204] = (T)(img)(_p5##x,_n1##y,z,c), I[205] = (T)(img)(_p4##x,_n1##y,z,c), I[206] = (T)(img)(_p3##x,_n1##y,z,c), I[207] = (T)(img)(_p2##x,_n1##y,z,c), I[208] = (T)(img)(_p1##x,_n1##y,z,c), I[209] = (T)(img)(x,_n1##y,z,c), I[210] = (T)(img)(_n1##x,_n1##y,z,c), I[211] = (T)(img)(_n2##x,_n1##y,z,c), I[212] = (T)(img)(_n3##x,_n1##y,z,c), I[213] = (T)(img)(_n4##x,_n1##y,z,c), I[214] = (T)(img)(_n5##x,_n1##y,z,c), I[215] = (T)(img)(_n6##x,_n1##y,z,c), I[216] = (T)(img)(_n7##x,_n1##y,z,c), I[217] = (T)(img)(_n8##x,_n1##y,z,c), I[218] = (T)(img)(_n9##x,_n1##y,z,c), I[219] = (T)(img)(_n10##x,_n1##y,z,c), \
 I[220] = (T)(img)(_p9##x,_n2##y,z,c), I[221] = (T)(img)(_p8##x,_n2##y,z,c), I[222] = (T)(img)(_p7##x,_n2##y,z,c), I[223] = (T)(img)(_p6##x,_n2##y,z,c), I[224] = (T)(img)(_p5##x,_n2##y,z,c), I[225] = (T)(img)(_p4##x,_n2##y,z,c), I[226] = (T)(img)(_p3##x,_n2##y,z,c), I[227] = (T)(img)(_p2##x,_n2##y,z,c), I[228] = (T)(img)(_p1##x,_n2##y,z,c), I[229] = (T)(img)(x,_n2##y,z,c), I[230] = (T)(img)(_n1##x,_n2##y,z,c), I[231] = (T)(img)(_n2##x,_n2##y,z,c), I[232] = (T)(img)(_n3##x,_n2##y,z,c), I[233] = (T)(img)(_n4##x,_n2##y,z,c), I[234] = (T)(img)(_n5##x,_n2##y,z,c), I[235] = (T)(img)(_n6##x,_n2##y,z,c), I[236] = (T)(img)(_n7##x,_n2##y,z,c), I[237] = (T)(img)(_n8##x,_n2##y,z,c), I[238] = (T)(img)(_n9##x,_n2##y,z,c), I[239] = (T)(img)(_n10##x,_n2##y,z,c), \
 I[240] = (T)(img)(_p9##x,_n3##y,z,c), I[241] = (T)(img)(_p8##x,_n3##y,z,c), I[242] = (T)(img)(_p7##x,_n3##y,z,c), I[243] = (T)(img)(_p6##x,_n3##y,z,c), I[244] = (T)(img)(_p5##x,_n3##y,z,c), I[245] = (T)(img)(_p4##x,_n3##y,z,c), I[246] = (T)(img)(_p3##x,_n3##y,z,c), I[247] = (T)(img)(_p2##x,_n3##y,z,c), I[248] = (T)(img)(_p1##x,_n3##y,z,c), I[249] = (T)(img)(x,_n3##y,z,c), I[250] = (T)(img)(_n1##x,_n3##y,z,c), I[251] = (T)(img)(_n2##x,_n3##y,z,c), I[252] = (T)(img)(_n3##x,_n3##y,z,c), I[253] = (T)(img)(_n4##x,_n3##y,z,c), I[254] = (T)(img)(_n5##x,_n3##y,z,c), I[255] = (T)(img)(_n6##x,_n3##y,z,c), I[256] = (T)(img)(_n7##x,_n3##y,z,c), I[257] = (T)(img)(_n8##x,_n3##y,z,c), I[258] = (T)(img)(_n9##x,_n3##y,z,c), I[259] = (T)(img)(_n10##x,_n3##y,z,c), \
 I[260] = (T)(img)(_p9##x,_n4##y,z,c), I[261] = (T)(img)(_p8##x,_n4##y,z,c), I[262] = (T)(img)(_p7##x,_n4##y,z,c), I[263] = (T)(img)(_p6##x,_n4##y,z,c), I[264] = (T)(img)(_p5##x,_n4##y,z,c), I[265] = (T)(img)(_p4##x,_n4##y,z,c), I[266] = (T)(img)(_p3##x,_n4##y,z,c), I[267] = (T)(img)(_p2##x,_n4##y,z,c), I[268] = (T)(img)(_p1##x,_n4##y,z,c), I[269] = (T)(img)(x,_n4##y,z,c), I[270] = (T)(img)(_n1##x,_n4##y,z,c), I[271] = (T)(img)(_n2##x,_n4##y,z,c), I[272] = (T)(img)(_n3##x,_n4##y,z,c), I[273] = (T)(img)(_n4##x,_n4##y,z,c), I[274] = (T)(img)(_n5##x,_n4##y,z,c), I[275] = (T)(img)(_n6##x,_n4##y,z,c), I[276] = (T)(img)(_n7##x,_n4##y,z,c), I[277] = (T)(img)(_n8##x,_n4##y,z,c), I[278] = (T)(img)(_n9##x,_n4##y,z,c), I[279] = (T)(img)(_n10##x,_n4##y,z,c), \
 I[280] = (T)(img)(_p9##x,_n5##y,z,c), I[281] = (T)(img)(_p8##x,_n5##y,z,c), I[282] = (T)(img)(_p7##x,_n5##y,z,c), I[283] = (T)(img)(_p6##x,_n5##y,z,c), I[284] = (T)(img)(_p5##x,_n5##y,z,c), I[285] = (T)(img)(_p4##x,_n5##y,z,c), I[286] = (T)(img)(_p3##x,_n5##y,z,c), I[287] = (T)(img)(_p2##x,_n5##y,z,c), I[288] = (T)(img)(_p1##x,_n5##y,z,c), I[289] = (T)(img)(x,_n5##y,z,c), I[290] = (T)(img)(_n1##x,_n5##y,z,c), I[291] = (T)(img)(_n2##x,_n5##y,z,c), I[292] = (T)(img)(_n3##x,_n5##y,z,c), I[293] = (T)(img)(_n4##x,_n5##y,z,c), I[294] = (T)(img)(_n5##x,_n5##y,z,c), I[295] = (T)(img)(_n6##x,_n5##y,z,c), I[296] = (T)(img)(_n7##x,_n5##y,z,c), I[297] = (T)(img)(_n8##x,_n5##y,z,c), I[298] = (T)(img)(_n9##x,_n5##y,z,c), I[299] = (T)(img)(_n10##x,_n5##y,z,c), \
 I[300] = (T)(img)(_p9##x,_n6##y,z,c), I[301] = (T)(img)(_p8##x,_n6##y,z,c), I[302] = (T)(img)(_p7##x,_n6##y,z,c), I[303] = (T)(img)(_p6##x,_n6##y,z,c), I[304] = (T)(img)(_p5##x,_n6##y,z,c), I[305] = (T)(img)(_p4##x,_n6##y,z,c), I[306] = (T)(img)(_p3##x,_n6##y,z,c), I[307] = (T)(img)(_p2##x,_n6##y,z,c), I[308] = (T)(img)(_p1##x,_n6##y,z,c), I[309] = (T)(img)(x,_n6##y,z,c), I[310] = (T)(img)(_n1##x,_n6##y,z,c), I[311] = (T)(img)(_n2##x,_n6##y,z,c), I[312] = (T)(img)(_n3##x,_n6##y,z,c), I[313] = (T)(img)(_n4##x,_n6##y,z,c), I[314] = (T)(img)(_n5##x,_n6##y,z,c), I[315] = (T)(img)(_n6##x,_n6##y,z,c), I[316] = (T)(img)(_n7##x,_n6##y,z,c), I[317] = (T)(img)(_n8##x,_n6##y,z,c), I[318] = (T)(img)(_n9##x,_n6##y,z,c), I[319] = (T)(img)(_n10##x,_n6##y,z,c), \
 I[320] = (T)(img)(_p9##x,_n7##y,z,c), I[321] = (T)(img)(_p8##x,_n7##y,z,c), I[322] = (T)(img)(_p7##x,_n7##y,z,c), I[323] = (T)(img)(_p6##x,_n7##y,z,c), I[324] = (T)(img)(_p5##x,_n7##y,z,c), I[325] = (T)(img)(_p4##x,_n7##y,z,c), I[326] = (T)(img)(_p3##x,_n7##y,z,c), I[327] = (T)(img)(_p2##x,_n7##y,z,c), I[328] = (T)(img)(_p1##x,_n7##y,z,c), I[329] = (T)(img)(x,_n7##y,z,c), I[330] = (T)(img)(_n1##x,_n7##y,z,c), I[331] = (T)(img)(_n2##x,_n7##y,z,c), I[332] = (T)(img)(_n3##x,_n7##y,z,c), I[333] = (T)(img)(_n4##x,_n7##y,z,c), I[334] = (T)(img)(_n5##x,_n7##y,z,c), I[335] = (T)(img)(_n6##x,_n7##y,z,c), I[336] = (T)(img)(_n7##x,_n7##y,z,c), I[337] = (T)(img)(_n8##x,_n7##y,z,c), I[338] = (T)(img)(_n9##x,_n7##y,z,c), I[339] = (T)(img)(_n10##x,_n7##y,z,c), \
 I[340] = (T)(img)(_p9##x,_n8##y,z,c), I[341] = (T)(img)(_p8##x,_n8##y,z,c), I[342] = (T)(img)(_p7##x,_n8##y,z,c), I[343] = (T)(img)(_p6##x,_n8##y,z,c), I[344] = (T)(img)(_p5##x,_n8##y,z,c), I[345] = (T)(img)(_p4##x,_n8##y,z,c), I[346] = (T)(img)(_p3##x,_n8##y,z,c), I[347] = (T)(img)(_p2##x,_n8##y,z,c), I[348] = (T)(img)(_p1##x,_n8##y,z,c), I[349] = (T)(img)(x,_n8##y,z,c), I[350] = (T)(img)(_n1##x,_n8##y,z,c), I[351] = (T)(img)(_n2##x,_n8##y,z,c), I[352] = (T)(img)(_n3##x,_n8##y,z,c), I[353] = (T)(img)(_n4##x,_n8##y,z,c), I[354] = (T)(img)(_n5##x,_n8##y,z,c), I[355] = (T)(img)(_n6##x,_n8##y,z,c), I[356] = (T)(img)(_n7##x,_n8##y,z,c), I[357] = (T)(img)(_n8##x,_n8##y,z,c), I[358] = (T)(img)(_n9##x,_n8##y,z,c), I[359] = (T)(img)(_n10##x,_n8##y,z,c), \
 I[360] = (T)(img)(_p9##x,_n9##y,z,c), I[361] = (T)(img)(_p8##x,_n9##y,z,c), I[362] = (T)(img)(_p7##x,_n9##y,z,c), I[363] = (T)(img)(_p6##x,_n9##y,z,c), I[364] = (T)(img)(_p5##x,_n9##y,z,c), I[365] = (T)(img)(_p4##x,_n9##y,z,c), I[366] = (T)(img)(_p3##x,_n9##y,z,c), I[367] = (T)(img)(_p2##x,_n9##y,z,c), I[368] = (T)(img)(_p1##x,_n9##y,z,c), I[369] = (T)(img)(x,_n9##y,z,c), I[370] = (T)(img)(_n1##x,_n9##y,z,c), I[371] = (T)(img)(_n2##x,_n9##y,z,c), I[372] = (T)(img)(_n3##x,_n9##y,z,c), I[373] = (T)(img)(_n4##x,_n9##y,z,c), I[374] = (T)(img)(_n5##x,_n9##y,z,c), I[375] = (T)(img)(_n6##x,_n9##y,z,c), I[376] = (T)(img)(_n7##x,_n9##y,z,c), I[377] = (T)(img)(_n8##x,_n9##y,z,c), I[378] = (T)(img)(_n9##x,_n9##y,z,c), I[379] = (T)(img)(_n10##x,_n9##y,z,c), \
 I[380] = (T)(img)(_p9##x,_n10##y,z,c), I[381] = (T)(img)(_p8##x,_n10##y,z,c), I[382] = (T)(img)(_p7##x,_n10##y,z,c), I[383] = (T)(img)(_p6##x,_n10##y,z,c), I[384] = (T)(img)(_p5##x,_n10##y,z,c), I[385] = (T)(img)(_p4##x,_n10##y,z,c), I[386] = (T)(img)(_p3##x,_n10##y,z,c), I[387] = (T)(img)(_p2##x,_n10##y,z,c), I[388] = (T)(img)(_p1##x,_n10##y,z,c), I[389] = (T)(img)(x,_n10##y,z,c), I[390] = (T)(img)(_n1##x,_n10##y,z,c), I[391] = (T)(img)(_n2##x,_n10##y,z,c), I[392] = (T)(img)(_n3##x,_n10##y,z,c), I[393] = (T)(img)(_n4##x,_n10##y,z,c), I[394] = (T)(img)(_n5##x,_n10##y,z,c), I[395] = (T)(img)(_n6##x,_n10##y,z,c), I[396] = (T)(img)(_n7##x,_n10##y,z,c), I[397] = (T)(img)(_n8##x,_n10##y,z,c), I[398] = (T)(img)(_n9##x,_n10##y,z,c), I[399] = (T)(img)(_n10##x,_n10##y,z,c);

// Define 21x21 loop macros
//-------------------------
#define cimg_for21(bound,i) for (int i = 0, \
 _p10##i = 0, _p9##i = 0, _p8##i = 0, _p7##i = 0, _p6##i = 0, _p5##i = 0, _p4##i = 0, _p3##i = 0, _p2##i = 0, _p1##i = 0, \
 _n1##i = 1>=(int)(bound)?(int)(bound)-1:1, \
 _n2##i = 2>=(int)(bound)?(int)(bound)-1:2, \
 _n3##i = 3>=(int)(bound)?(int)(bound)-1:3, \
 _n4##i = 4>=(int)(bound)?(int)(bound)-1:4, \
 _n5##i = 5>=(int)(bound)?(int)(bound)-1:5, \
 _n6##i = 6>=(int)(bound)?(int)(bound)-1:6, \
 _n7##i = 7>=(int)(bound)?(int)(bound)-1:7, \
 _n8##i = 8>=(int)(bound)?(int)(bound)-1:8, \
 _n9##i = 9>=(int)(bound)?(int)(bound)-1:9, \
 _n10##i = 10>=(int)(bound)?(int)(bound)-1:10; \
 _n10##i<(int)(bound) || _n9##i==--_n10##i || _n8##i==--_n9##i || _n7##i==--_n8##i || _n6##i==--_n7##i || _n5##i==--_n6##i || _n4##i==--_n5##i || _n3##i==--_n4##i || _n2##i==--_n3##i || _n1##i==--_n2##i || \
 i==(_n10##i = _n9##i = _n8##i = _n7##i = _n6##i = _n5##i = _n4##i = _n3##i = _n2##i = --_n1##i); \
 _p10##i = _p9##i, _p9##i = _p8##i, _p8##i = _p7##i, _p7##i = _p6##i, _p6##i = _p5##i, _p5##i = _p4##i, _p4##i = _p3##i, _p3##i = _p2##i, _p2##i = _p1##i, _p1##i = i++, \
 ++_n1##i, ++_n2##i, ++_n3##i, ++_n4##i, ++_n5##i, ++_n6##i, ++_n7##i, ++_n8##i, ++_n9##i, ++_n10##i)

#define cimg_for21X(img,x) cimg_for21((img)._width,x)
#define cimg_for21Y(img,y) cimg_for21((img)._height,y)
#define cimg_for21Z(img,z) cimg_for21((img)._depth,z)
#define cimg_for21C(img,c) cimg_for21((img)._spectrum,c)
#define cimg_for21XY(img,x,y) cimg_for21Y(img,y) cimg_for21X(img,x)
#define cimg_for21XZ(img,x,z) cimg_for21Z(img,z) cimg_for21X(img,x)
#define cimg_for21XC(img,x,c) cimg_for21C(img,c) cimg_for21X(img,x)
#define cimg_for21YZ(img,y,z) cimg_for21Z(img,z) cimg_for21Y(img,y)
#define cimg_for21YC(img,y,c) cimg_for21C(img,c) cimg_for21Y(img,y)
#define cimg_for21ZC(img,z,c) cimg_for21C(img,c) cimg_for21Z(img,z)
#define cimg_for21XYZ(img,x,y,z) cimg_for21Z(img,z) cimg_for21XY(img,x,y)
#define cimg_for21XZC(img,x,z,c) cimg_for21C(img,c) cimg_for21XZ(img,x,z)
#define cimg_for21YZC(img,y,z,c) cimg_for21C(img,c) cimg_for21YZ(img,y,z)
#define cimg_for21XYZC(img,x,y,z,c) cimg_for21C(img,c) cimg_for21XYZ(img,x,y,z)

#define cimg_for_in21(bound,i0,i1,i) for (int i = (int)(i0)<0?0:(int)(i0), \
 _p10##i = i-10<0?0:i-10, \
 _p9##i = i-9<0?0:i-9, \
 _p8##i = i-8<0?0:i-8, \
 _p7##i = i-7<0?0:i-7, \
 _p6##i = i-6<0?0:i-6, \
 _p5##i = i-5<0?0:i-5, \
 _p4##i = i-4<0?0:i-4, \
 _p3##i = i-3<0?0:i-3, \
 _p2##i = i-2<0?0:i-2, \
 _p1##i = i-1<0?0:i-1, \
 _n1##i = i+1>=(int)(bound)?(int)(bound)-1:i+1, \
 _n2##i = i+2>=(int)(bound)?(int)(bound)-1:i+2, \
 _n3##i = i+3>=(int)(bound)?(int)(bound)-1:i+3, \
 _n4##i = i+4>=(int)(bound)?(int)(bound)-1:i+4, \
 _n5##i = i+5>=(int)(bound)?(int)(bound)-1:i+5, \
 _n6##i = i+6>=(int)(bound)?(int)(bound)-1:i+6, \
 _n7##i = i+7>=(int)(bound)?(int)(bound)-1:i+7, \
 _n8##i = i+8>=(int)(bound)?(int)(bound)-1:i+8, \
 _n9##i = i+9>=(int)(bound)?(int)(bound)-1:i+9, \
 _n10##i = i+10>=(int)(bound)?(int)(bound)-1:i+10; \
 i<=(int)(i1) && (_n10##i<(int)(bound) || _n9##i==--_n10##i || _n8##i==--_n9##i || _n7##i==--_n8##i || _n6##i==--_n7##i || _n5##i==--_n6##i || _n4##i==--_n5##i || _n3##i==--_n4##i || _n2##i==--_n3##i || _n1##i==--_n2##i || \
 i==(_n10##i = _n9##i = _n8##i = _n7##i = _n6##i = _n5##i = _n4##i = _n3##i = _n2##i = --_n1##i)); \
 _p10##i = _p9##i, _p9##i = _p8##i, _p8##i = _p7##i, _p7##i = _p6##i, _p6##i = _p5##i, _p5##i = _p4##i, _p4##i = _p3##i, _p3##i = _p2##i, _p2##i = _p1##i, _p1##i = i++, \
 ++_n1##i, ++_n2##i, ++_n3##i, ++_n4##i, ++_n5##i, ++_n6##i, ++_n7##i, ++_n8##i, ++_n9##i, ++_n10##i)

#define cimg_for_in21X(img,x0,x1,x) cimg_for_in21((img)._width,x0,x1,x)
#define cimg_for_in21Y(img,y0,y1,y) cimg_for_in21((img)._height,y0,y1,y)
#define cimg_for_in21Z(img,z0,z1,z) cimg_for_in21((img)._depth,z0,z1,z)
#define cimg_for_in21C(img,c0,c1,c) cimg_for_in21((img)._spectrum,c0,c1,c)
#define cimg_for_in21XY(img,x0,y0,x1,y1,x,y) cimg_for_in21Y(img,y0,y1,y) cimg_for_in21X(img,x0,x1,x)
#define cimg_for_in21XZ(img,x0,z0,x1,z1,x,z) cimg_for_in21Z(img,z0,z1,z) cimg_for_in21X(img,x0,x1,x)
#define cimg_for_in21XC(img,x0,c0,x1,c1,x,c) cimg_for_in21C(img,c0,c1,c) cimg_for_in21X(img,x0,x1,x)
#define cimg_for_in21YZ(img,y0,z0,y1,z1,y,z) cimg_for_in21Z(img,z0,z1,z) cimg_for_in21Y(img,y0,y1,y)
#define cimg_for_in21YC(img,y0,c0,y1,c1,y,c) cimg_for_in21C(img,c0,c1,c) cimg_for_in21Y(img,y0,y1,y)
#define cimg_for_in21ZC(img,z0,c0,z1,c1,z,c) cimg_for_in21C(img,c0,c1,c) cimg_for_in21Z(img,z0,z1,z)
#define cimg_for_in21XYZ(img,x0,y0,z0,x1,y1,z1,x,y,z) cimg_for_in21Z(img,z0,z1,z) cimg_for_in21XY(img,x0,y0,x1,y1,x,y)
#define cimg_for_in21XZC(img,x0,z0,c0,x1,y1,c1,x,z,c) cimg_for_in21C(img,c0,c1,c) cimg_for_in21XZ(img,x0,y0,x1,y1,x,z)
#define cimg_for_in21YZC(img,y0,z0,c0,y1,z1,c1,y,z,c) cimg_for_in21C(img,c0,c1,c) cimg_for_in21YZ(img,y0,z0,y1,z1,y,z)
#define cimg_for_in21XYZC(img,x0,y0,z0,c0,x1,y1,z1,c1,x,y,z,c) cimg_for_in21C(img,c0,c1,c) cimg_for_in21XYZ(img,x0,y0,z0,x1,y1,z1,x,y,z)

#define cimg_for21x21(img,x,y,z,c,I,T) \
 cimg_for21((img)._height,y) for (int x = 0, \
 _p10##x = 0, _p9##x = 0, _p8##x = 0, _p7##x = 0, _p6##x = 0, _p5##x = 0, _p4##x = 0, _p3##x = 0, _p2##x = 0, _p1##x = 0, \
 _n1##x = 1>=((img)._width)?(img).width()-1:1, \
 _n2##x = 2>=((img)._width)?(img).width()-1:2, \
 _n3##x = 3>=((img)._width)?(img).width()-1:3, \
 _n4##x = 4>=((img)._width)?(img).width()-1:4, \
 _n5##x = 5>=((img)._width)?(img).width()-1:5, \
 _n6##x = 6>=((img)._width)?(img).width()-1:6, \
 _n7##x = 7>=((img)._width)?(img).width()-1:7, \
 _n8##x = 8>=((img)._width)?(img).width()-1:8, \
 _n9##x = 9>=((img)._width)?(img).width()-1:9, \
 _n10##x = (int)( \
 (I[0] = I[1] = I[2] = I[3] = I[4] = I[5] = I[6] = I[7] = I[8] = I[9] = I[10] = (T)(img)(0,_p10##y,z,c)), \
 (I[21] = I[22] = I[23] = I[24] = I[25] = I[26] = I[27] = I[28] = I[29] = I[30] = I[31] = (T)(img)(0,_p9##y,z,c)), \
 (I[42] = I[43] = I[44] = I[45] = I[46] = I[47] = I[48] = I[49] = I[50] = I[51] = I[52] = (T)(img)(0,_p8##y,z,c)), \
 (I[63] = I[64] = I[65] = I[66] = I[67] = I[68] = I[69] = I[70] = I[71] = I[72] = I[73] = (T)(img)(0,_p7##y,z,c)), \
 (I[84] = I[85] = I[86] = I[87] = I[88] = I[89] = I[90] = I[91] = I[92] = I[93] = I[94] = (T)(img)(0,_p6##y,z,c)), \
 (I[105] = I[106] = I[107] = I[108] = I[109] = I[110] = I[111] = I[112] = I[113] = I[114] = I[115] = (T)(img)(0,_p5##y,z,c)), \
 (I[126] = I[127] = I[128] = I[129] = I[130] = I[131] = I[132] = I[133] = I[134] = I[135] = I[136] = (T)(img)(0,_p4##y,z,c)), \
 (I[147] = I[148] = I[149] = I[150] = I[151] = I[152] = I[153] = I[154] = I[155] = I[156] = I[157] = (T)(img)(0,_p3##y,z,c)), \
 (I[168] = I[169] = I[170] = I[171] = I[172] = I[173] = I[174] = I[175] = I[176] = I[177] = I[178] = (T)(img)(0,_p2##y,z,c)), \
 (I[189] = I[190] = I[191] = I[192] = I[193] = I[194] = I[195] = I[196] = I[197] = I[198] = I[199] = (T)(img)(0,_p1##y,z,c)), \
 (I[210] = I[211] = I[212] = I[213] = I[214] = I[215] = I[216] = I[217] = I[218] = I[219] = I[220] = (T)(img)(0,y,z,c)), \
 (I[231] = I[232] = I[233] = I[234] = I[235] = I[236] = I[237] = I[238] = I[239] = I[240] = I[241] = (T)(img)(0,_n1##y,z,c)), \
 (I[252] = I[253] = I[254] = I[255] = I[256] = I[257] = I[258] = I[259] = I[260] = I[261] = I[262] = (T)(img)(0,_n2##y,z,c)), \
 (I[273] = I[274] = I[275] = I[276] = I[277] = I[278] = I[279] = I[280] = I[281] = I[282] = I[283] = (T)(img)(0,_n3##y,z,c)), \
 (I[294] = I[295] = I[296] = I[297] = I[298] = I[299] = I[300] = I[301] = I[302] = I[303] = I[304] = (T)(img)(0,_n4##y,z,c)), \
 (I[315] = I[316] = I[317] = I[318] = I[319] = I[320] = I[321] = I[322] = I[323] = I[324] = I[325] = (T)(img)(0,_n5##y,z,c)), \
 (I[336] = I[337] = I[338] = I[339] = I[340] = I[341] = I[342] = I[343] = I[344] = I[345] = I[346] = (T)(img)(0,_n6##y,z,c)), \
 (I[357] = I[358] = I[359] = I[360] = I[361] = I[362] = I[363] = I[364] = I[365] = I[366] = I[367] = (T)(img)(0,_n7##y,z,c)), \
 (I[378] = I[379] = I[380] = I[381] = I[382] = I[383] = I[384] = I[385] = I[386] = I[387] = I[388] = (T)(img)(0,_n8##y,z,c)), \
 (I[399] = I[400] = I[401] = I[402] = I[403] = I[404] = I[405] = I[406] = I[407] = I[408] = I[409] = (T)(img)(0,_n9##y,z,c)), \
 (I[420] = I[421] = I[422] = I[423] = I[424] = I[425] = I[426] = I[427] = I[428] = I[429] = I[430] = (T)(img)(0,_n10##y,z,c)), \
 (I[11] = (T)(img)(_n1##x,_p10##y,z,c)), \
 (I[32] = (T)(img)(_n1##x,_p9##y,z,c)), \
 (I[53] = (T)(img)(_n1##x,_p8##y,z,c)), \
 (I[74] = (T)(img)(_n1##x,_p7##y,z,c)), \
 (I[95] = (T)(img)(_n1##x,_p6##y,z,c)), \
 (I[116] = (T)(img)(_n1##x,_p5##y,z,c)), \
 (I[137] = (T)(img)(_n1##x,_p4##y,z,c)), \
 (I[158] = (T)(img)(_n1##x,_p3##y,z,c)), \
 (I[179] = (T)(img)(_n1##x,_p2##y,z,c)), \
 (I[200] = (T)(img)(_n1##x,_p1##y,z,c)), \
 (I[221] = (T)(img)(_n1##x,y,z,c)), \
 (I[242] = (T)(img)(_n1##x,_n1##y,z,c)), \
 (I[263] = (T)(img)(_n1##x,_n2##y,z,c)), \
 (I[284] = (T)(img)(_n1##x,_n3##y,z,c)), \
 (I[305] = (T)(img)(_n1##x,_n4##y,z,c)), \
 (I[326] = (T)(img)(_n1##x,_n5##y,z,c)), \
 (I[347] = (T)(img)(_n1##x,_n6##y,z,c)), \
 (I[368] = (T)(img)(_n1##x,_n7##y,z,c)), \
 (I[389] = (T)(img)(_n1##x,_n8##y,z,c)), \
 (I[410] = (T)(img)(_n1##x,_n9##y,z,c)), \
 (I[431] = (T)(img)(_n1##x,_n10##y,z,c)), \
 (I[12] = (T)(img)(_n2##x,_p10##y,z,c)), \
 (I[33] = (T)(img)(_n2##x,_p9##y,z,c)), \
 (I[54] = (T)(img)(_n2##x,_p8##y,z,c)), \
 (I[75] = (T)(img)(_n2##x,_p7##y,z,c)), \
 (I[96] = (T)(img)(_n2##x,_p6##y,z,c)), \
 (I[117] = (T)(img)(_n2##x,_p5##y,z,c)), \
 (I[138] = (T)(img)(_n2##x,_p4##y,z,c)), \
 (I[159] = (T)(img)(_n2##x,_p3##y,z,c)), \
 (I[180] = (T)(img)(_n2##x,_p2##y,z,c)), \
 (I[201] = (T)(img)(_n2##x,_p1##y,z,c)), \
 (I[222] = (T)(img)(_n2##x,y,z,c)), \
 (I[243] = (T)(img)(_n2##x,_n1##y,z,c)), \
 (I[264] = (T)(img)(_n2##x,_n2##y,z,c)), \
 (I[285] = (T)(img)(_n2##x,_n3##y,z,c)), \
 (I[306] = (T)(img)(_n2##x,_n4##y,z,c)), \
 (I[327] = (T)(img)(_n2##x,_n5##y,z,c)), \
 (I[348] = (T)(img)(_n2##x,_n6##y,z,c)), \
 (I[369] = (T)(img)(_n2##x,_n7##y,z,c)), \
 (I[390] = (T)(img)(_n2##x,_n8##y,z,c)), \
 (I[411] = (T)(img)(_n2##x,_n9##y,z,c)), \
 (I[432] = (T)(img)(_n2##x,_n10##y,z,c)), \
 (I[13] = (T)(img)(_n3##x,_p10##y,z,c)), \
 (I[34] = (T)(img)(_n3##x,_p9##y,z,c)), \
 (I[55] = (T)(img)(_n3##x,_p8##y,z,c)), \
 (I[76] = (T)(img)(_n3##x,_p7##y,z,c)), \
 (I[97] = (T)(img)(_n3##x,_p6##y,z,c)), \
 (I[118] = (T)(img)(_n3##x,_p5##y,z,c)), \
 (I[139] = (T)(img)(_n3##x,_p4##y,z,c)), \
 (I[160] = (T)(img)(_n3##x,_p3##y,z,c)), \
 (I[181] = (T)(img)(_n3##x,_p2##y,z,c)), \
 (I[202] = (T)(img)(_n3##x,_p1##y,z,c)), \
 (I[223] = (T)(img)(_n3##x,y,z,c)), \
 (I[244] = (T)(img)(_n3##x,_n1##y,z,c)), \
 (I[265] = (T)(img)(_n3##x,_n2##y,z,c)), \
 (I[286] = (T)(img)(_n3##x,_n3##y,z,c)), \
 (I[307] = (T)(img)(_n3##x,_n4##y,z,c)), \
 (I[328] = (T)(img)(_n3##x,_n5##y,z,c)), \
 (I[349] = (T)(img)(_n3##x,_n6##y,z,c)), \
 (I[370] = (T)(img)(_n3##x,_n7##y,z,c)), \
 (I[391] = (T)(img)(_n3##x,_n8##y,z,c)), \
 (I[412] = (T)(img)(_n3##x,_n9##y,z,c)), \
 (I[433] = (T)(img)(_n3##x,_n10##y,z,c)), \
 (I[14] = (T)(img)(_n4##x,_p10##y,z,c)), \
 (I[35] = (T)(img)(_n4##x,_p9##y,z,c)), \
 (I[56] = (T)(img)(_n4##x,_p8##y,z,c)), \
 (I[77] = (T)(img)(_n4##x,_p7##y,z,c)), \
 (I[98] = (T)(img)(_n4##x,_p6##y,z,c)), \
 (I[119] = (T)(img)(_n4##x,_p5##y,z,c)), \
 (I[140] = (T)(img)(_n4##x,_p4##y,z,c)), \
 (I[161] = (T)(img)(_n4##x,_p3##y,z,c)), \
 (I[182] = (T)(img)(_n4##x,_p2##y,z,c)), \
 (I[203] = (T)(img)(_n4##x,_p1##y,z,c)), \
 (I[224] = (T)(img)(_n4##x,y,z,c)), \
 (I[245] = (T)(img)(_n4##x,_n1##y,z,c)), \
 (I[266] = (T)(img)(_n4##x,_n2##y,z,c)), \
 (I[287] = (T)(img)(_n4##x,_n3##y,z,c)), \
 (I[308] = (T)(img)(_n4##x,_n4##y,z,c)), \
 (I[329] = (T)(img)(_n4##x,_n5##y,z,c)), \
 (I[350] = (T)(img)(_n4##x,_n6##y,z,c)), \
 (I[371] = (T)(img)(_n4##x,_n7##y,z,c)), \
 (I[392] = (T)(img)(_n4##x,_n8##y,z,c)), \
 (I[413] = (T)(img)(_n4##x,_n9##y,z,c)), \
 (I[434] = (T)(img)(_n4##x,_n10##y,z,c)), \
 (I[15] = (T)(img)(_n5##x,_p10##y,z,c)), \
 (I[36] = (T)(img)(_n5##x,_p9##y,z,c)), \
 (I[57] = (T)(img)(_n5##x,_p8##y,z,c)), \
 (I[78] = (T)(img)(_n5##x,_p7##y,z,c)), \
 (I[99] = (T)(img)(_n5##x,_p6##y,z,c)), \
 (I[120] = (T)(img)(_n5##x,_p5##y,z,c)), \
 (I[141] = (T)(img)(_n5##x,_p4##y,z,c)), \
 (I[162] = (T)(img)(_n5##x,_p3##y,z,c)), \
 (I[183] = (T)(img)(_n5##x,_p2##y,z,c)), \
 (I[204] = (T)(img)(_n5##x,_p1##y,z,c)), \
 (I[225] = (T)(img)(_n5##x,y,z,c)), \
 (I[246] = (T)(img)(_n5##x,_n1##y,z,c)), \
 (I[267] = (T)(img)(_n5##x,_n2##y,z,c)), \
 (I[288] = (T)(img)(_n5##x,_n3##y,z,c)), \
 (I[309] = (T)(img)(_n5##x,_n4##y,z,c)), \
 (I[330] = (T)(img)(_n5##x,_n5##y,z,c)), \
 (I[351] = (T)(img)(_n5##x,_n6##y,z,c)), \
 (I[372] = (T)(img)(_n5##x,_n7##y,z,c)), \
 (I[393] = (T)(img)(_n5##x,_n8##y,z,c)), \
 (I[414] = (T)(img)(_n5##x,_n9##y,z,c)), \
 (I[435] = (T)(img)(_n5##x,_n10##y,z,c)), \
 (I[16] = (T)(img)(_n6##x,_p10##y,z,c)), \
 (I[37] = (T)(img)(_n6##x,_p9##y,z,c)), \
 (I[58] = (T)(img)(_n6##x,_p8##y,z,c)), \
 (I[79] = (T)(img)(_n6##x,_p7##y,z,c)), \
 (I[100] = (T)(img)(_n6##x,_p6##y,z,c)), \
 (I[121] = (T)(img)(_n6##x,_p5##y,z,c)), \
 (I[142] = (T)(img)(_n6##x,_p4##y,z,c)), \
 (I[163] = (T)(img)(_n6##x,_p3##y,z,c)), \
 (I[184] = (T)(img)(_n6##x,_p2##y,z,c)), \
 (I[205] = (T)(img)(_n6##x,_p1##y,z,c)), \
 (I[226] = (T)(img)(_n6##x,y,z,c)), \
 (I[247] = (T)(img)(_n6##x,_n1##y,z,c)), \
 (I[268] = (T)(img)(_n6##x,_n2##y,z,c)), \
 (I[289] = (T)(img)(_n6##x,_n3##y,z,c)), \
 (I[310] = (T)(img)(_n6##x,_n4##y,z,c)), \
 (I[331] = (T)(img)(_n6##x,_n5##y,z,c)), \
 (I[352] = (T)(img)(_n6##x,_n6##y,z,c)), \
 (I[373] = (T)(img)(_n6##x,_n7##y,z,c)), \
 (I[394] = (T)(img)(_n6##x,_n8##y,z,c)), \
 (I[415] = (T)(img)(_n6##x,_n9##y,z,c)), \
 (I[436] = (T)(img)(_n6##x,_n10##y,z,c)), \
 (I[17] = (T)(img)(_n7##x,_p10##y,z,c)), \
 (I[38] = (T)(img)(_n7##x,_p9##y,z,c)), \
 (I[59] = (T)(img)(_n7##x,_p8##y,z,c)), \
 (I[80] = (T)(img)(_n7##x,_p7##y,z,c)), \
 (I[101] = (T)(img)(_n7##x,_p6##y,z,c)), \
 (I[122] = (T)(img)(_n7##x,_p5##y,z,c)), \
 (I[143] = (T)(img)(_n7##x,_p4##y,z,c)), \
 (I[164] = (T)(img)(_n7##x,_p3##y,z,c)), \
 (I[185] = (T)(img)(_n7##x,_p2##y,z,c)), \
 (I[206] = (T)(img)(_n7##x,_p1##y,z,c)), \
 (I[227] = (T)(img)(_n7##x,y,z,c)), \
 (I[248] = (T)(img)(_n7##x,_n1##y,z,c)), \
 (I[269] = (T)(img)(_n7##x,_n2##y,z,c)), \
 (I[290] = (T)(img)(_n7##x,_n3##y,z,c)), \
 (I[311] = (T)(img)(_n7##x,_n4##y,z,c)), \
 (I[332] = (T)(img)(_n7##x,_n5##y,z,c)), \
 (I[353] = (T)(img)(_n7##x,_n6##y,z,c)), \
 (I[374] = (T)(img)(_n7##x,_n7##y,z,c)), \
 (I[395] = (T)(img)(_n7##x,_n8##y,z,c)), \
 (I[416] = (T)(img)(_n7##x,_n9##y,z,c)), \
 (I[437] = (T)(img)(_n7##x,_n10##y,z,c)), \
 (I[18] = (T)(img)(_n8##x,_p10##y,z,c)), \
 (I[39] = (T)(img)(_n8##x,_p9##y,z,c)), \
 (I[60] = (T)(img)(_n8##x,_p8##y,z,c)), \
 (I[81] = (T)(img)(_n8##x,_p7##y,z,c)), \
 (I[102] = (T)(img)(_n8##x,_p6##y,z,c)), \
 (I[123] = (T)(img)(_n8##x,_p5##y,z,c)), \
 (I[144] = (T)(img)(_n8##x,_p4##y,z,c)), \
 (I[165] = (T)(img)(_n8##x,_p3##y,z,c)), \
 (I[186] = (T)(img)(_n8##x,_p2##y,z,c)), \
 (I[207] = (T)(img)(_n8##x,_p1##y,z,c)), \
 (I[228] = (T)(img)(_n8##x,y,z,c)), \
 (I[249] = (T)(img)(_n8##x,_n1##y,z,c)), \
 (I[270] = (T)(img)(_n8##x,_n2##y,z,c)), \
 (I[291] = (T)(img)(_n8##x,_n3##y,z,c)), \
 (I[312] = (T)(img)(_n8##x,_n4##y,z,c)), \
 (I[333] = (T)(img)(_n8##x,_n5##y,z,c)), \
 (I[354] = (T)(img)(_n8##x,_n6##y,z,c)), \
 (I[375] = (T)(img)(_n8##x,_n7##y,z,c)), \
 (I[396] = (T)(img)(_n8##x,_n8##y,z,c)), \
 (I[417] = (T)(img)(_n8##x,_n9##y,z,c)), \
 (I[438] = (T)(img)(_n8##x,_n10##y,z,c)), \
 (I[19] = (T)(img)(_n9##x,_p10##y,z,c)), \
 (I[40] = (T)(img)(_n9##x,_p9##y,z,c)), \
 (I[61] = (T)(img)(_n9##x,_p8##y,z,c)), \
 (I[82] = (T)(img)(_n9##x,_p7##y,z,c)), \
 (I[103] = (T)(img)(_n9##x,_p6##y,z,c)), \
 (I[124] = (T)(img)(_n9##x,_p5##y,z,c)), \
 (I[145] = (T)(img)(_n9##x,_p4##y,z,c)), \
 (I[166] = (T)(img)(_n9##x,_p3##y,z,c)), \
 (I[187] = (T)(img)(_n9##x,_p2##y,z,c)), \
 (I[208] = (T)(img)(_n9##x,_p1##y,z,c)), \
 (I[229] = (T)(img)(_n9##x,y,z,c)), \
 (I[250] = (T)(img)(_n9##x,_n1##y,z,c)), \
 (I[271] = (T)(img)(_n9##x,_n2##y,z,c)), \
 (I[292] = (T)(img)(_n9##x,_n3##y,z,c)), \
 (I[313] = (T)(img)(_n9##x,_n4##y,z,c)), \
 (I[334] = (T)(img)(_n9##x,_n5##y,z,c)), \
 (I[355] = (T)(img)(_n9##x,_n6##y,z,c)), \
 (I[376] = (T)(img)(_n9##x,_n7##y,z,c)), \
 (I[397] = (T)(img)(_n9##x,_n8##y,z,c)), \
 (I[418] = (T)(img)(_n9##x,_n9##y,z,c)), \
 (I[439] = (T)(img)(_n9##x,_n10##y,z,c)), \
 10>=((img)._width)?(img).width()-1:10); \
 (_n10##x<(img).width() && ( \
 (I[20] = (T)(img)(_n10##x,_p10##y,z,c)), \
 (I[41] = (T)(img)(_n10##x,_p9##y,z,c)), \
 (I[62] = (T)(img)(_n10##x,_p8##y,z,c)), \
 (I[83] = (T)(img)(_n10##x,_p7##y,z,c)), \
 (I[104] = (T)(img)(_n10##x,_p6##y,z,c)), \
 (I[125] = (T)(img)(_n10##x,_p5##y,z,c)), \
 (I[146] = (T)(img)(_n10##x,_p4##y,z,c)), \
 (I[167] = (T)(img)(_n10##x,_p3##y,z,c)), \
 (I[188] = (T)(img)(_n10##x,_p2##y,z,c)), \
 (I[209] = (T)(img)(_n10##x,_p1##y,z,c)), \
 (I[230] = (T)(img)(_n10##x,y,z,c)), \
 (I[251] = (T)(img)(_n10##x,_n1##y,z,c)), \
 (I[272] = (T)(img)(_n10##x,_n2##y,z,c)), \
 (I[293] = (T)(img)(_n10##x,_n3##y,z,c)), \
 (I[314] = (T)(img)(_n10##x,_n4##y,z,c)), \
 (I[335] = (T)(img)(_n10##x,_n5##y,z,c)), \
 (I[356] = (T)(img)(_n10##x,_n6##y,z,c)), \
 (I[377] = (T)(img)(_n10##x,_n7##y,z,c)), \
 (I[398] = (T)(img)(_n10##x,_n8##y,z,c)), \
 (I[419] = (T)(img)(_n10##x,_n9##y,z,c)), \
 (I[440] = (T)(img)(_n10##x,_n10##y,z,c)),1)) || \
 _n9##x==--_n10##x || _n8##x==--_n9##x || _n7##x==--_n8##x || _n6##x==--_n7##x || _n5##x==--_n6##x || _n4##x==--_n5##x || _n3##x==--_n4##x || _n2##x==--_n3##x || _n1##x==--_n2##x || x==(_n10##x = _n9##x = _n8##x = _n7##x = _n6##x = _n5##x = _n4##x = _n3##x = _n2##x = --_n1##x); \
 I[0] = I[1], I[1] = I[2], I[2] = I[3], I[3] = I[4], I[4] = I[5], I[5] = I[6], I[6] = I[7], I[7] = I[8], I[8] = I[9], I[9] = I[10], I[10] = I[11], I[11] = I[12], I[12] = I[13], I[13] = I[14], I[14] = I[15], I[15] = I[16], I[16] = I[17], I[17] = I[18], I[18] = I[19], I[19] = I[20], \
 I[21] = I[22], I[22] = I[23], I[23] = I[24], I[24] = I[25], I[25] = I[26], I[26] = I[27], I[27] = I[28], I[28] = I[29], I[29] = I[30], I[30] = I[31], I[31] = I[32], I[32] = I[33], I[33] = I[34], I[34] = I[35], I[35] = I[36], I[36] = I[37], I[37] = I[38], I[38] = I[39], I[39] = I[40], I[40] = I[41], \
 I[42] = I[43], I[43] = I[44], I[44] = I[45], I[45] = I[46], I[46] = I[47], I[47] = I[48], I[48] = I[49], I[49] = I[50], I[50] = I[51], I[51] = I[52], I[52] = I[53], I[53] = I[54], I[54] = I[55], I[55] = I[56], I[56] = I[57], I[57] = I[58], I[58] = I[59], I[59] = I[60], I[60] = I[61], I[61] = I[62], \
 I[63] = I[64], I[64] = I[65], I[65] = I[66], I[66] = I[67], I[67] = I[68], I[68] = I[69], I[69] = I[70], I[70] = I[71], I[71] = I[72], I[72] = I[73], I[73] = I[74], I[74] = I[75], I[75] = I[76], I[76] = I[77], I[77] = I[78], I[78] = I[79], I[79] = I[80], I[80] = I[81], I[81] = I[82], I[82] = I[83], \
 I[84] = I[85], I[85] = I[86], I[86] = I[87], I[87] = I[88], I[88] = I[89], I[89] = I[90], I[90] = I[91], I[91] = I[92], I[92] = I[93], I[93] = I[94], I[94] = I[95], I[95] = I[96], I[96] = I[97], I[97] = I[98], I[98] = I[99], I[99] = I[100], I[100] = I[101], I[101] = I[102], I[102] = I[103], I[103] = I[104], \
 I[105] = I[106], I[106] = I[107], I[107] = I[108], I[108] = I[109], I[109] = I[110], I[110] = I[111], I[111] = I[112], I[112] = I[113], I[113] = I[114], I[114] = I[115], I[115] = I[116], I[116] = I[117], I[117] = I[118], I[118] = I[119], I[119] = I[120], I[120] = I[121], I[121] = I[122], I[122] = I[123], I[123] = I[124], I[124] = I[125], \
 I[126] = I[127], I[127] = I[128], I[128] = I[129], I[129] = I[130], I[130] = I[131], I[131] = I[132], I[132] = I[133], I[133] = I[134], I[134] = I[135], I[135] = I[136], I[136] = I[137], I[137] = I[138], I[138] = I[139], I[139] = I[140], I[140] = I[141], I[141] = I[142], I[142] = I[143], I[143] = I[144], I[144] = I[145], I[145] = I[146], \
 I[147] = I[148], I[148] = I[149], I[149] = I[150], I[150] = I[151], I[151] = I[152], I[152] = I[153], I[153] = I[154], I[154] = I[155], I[155] = I[156], I[156] = I[157], I[157] = I[158], I[158] = I[159], I[159] = I[160], I[160] = I[161], I[161] = I[162], I[162] = I[163], I[163] = I[164], I[164] = I[165], I[165] = I[166], I[166] = I[167], \
 I[168] = I[169], I[169] = I[170], I[170] = I[171], I[171] = I[172], I[172] = I[173], I[173] = I[174], I[174] = I[175], I[175] = I[176], I[176] = I[177], I[177] = I[178], I[178] = I[179], I[179] = I[180], I[180] = I[181], I[181] = I[182], I[182] = I[183], I[183] = I[184], I[184] = I[185], I[185] = I[186], I[186] = I[187], I[187] = I[188], \
 I[189] = I[190], I[190] = I[191], I[191] = I[192], I[192] = I[193], I[193] = I[194], I[194] = I[195], I[195] = I[196], I[196] = I[197], I[197] = I[198], I[198] = I[199], I[199] = I[200], I[200] = I[201], I[201] = I[202], I[202] = I[203], I[203] = I[204], I[204] = I[205], I[205] = I[206], I[206] = I[207], I[207] = I[208], I[208] = I[209], \
 I[210] = I[211], I[211] = I[212], I[212] = I[213], I[213] = I[214], I[214] = I[215], I[215] = I[216], I[216] = I[217], I[217] = I[218], I[218] = I[219], I[219] = I[220], I[220] = I[221], I[221] = I[222], I[222] = I[223], I[223] = I[224], I[224] = I[225], I[225] = I[226], I[226] = I[227], I[227] = I[228], I[228] = I[229], I[229] = I[230], \
 I[231] = I[232], I[232] = I[233], I[233] = I[234], I[234] = I[235], I[235] = I[236], I[236] = I[237], I[237] = I[238], I[238] = I[239], I[239] = I[240], I[240] = I[241], I[241] = I[242], I[242] = I[243], I[243] = I[244], I[244] = I[245], I[245] = I[246], I[246] = I[247], I[247] = I[248], I[248] = I[249], I[249] = I[250], I[250] = I[251], \
 I[252] = I[253], I[253] = I[254], I[254] = I[255], I[255] = I[256], I[256] = I[257], I[257] = I[258], I[258] = I[259], I[259] = I[260], I[260] = I[261], I[261] = I[262], I[262] = I[263], I[263] = I[264], I[264] = I[265], I[265] = I[266], I[266] = I[267], I[267] = I[268], I[268] = I[269], I[269] = I[270], I[270] = I[271], I[271] = I[272], \
 I[273] = I[274], I[274] = I[275], I[275] = I[276], I[276] = I[277], I[277] = I[278], I[278] = I[279], I[279] = I[280], I[280] = I[281], I[281] = I[282], I[282] = I[283], I[283] = I[284], I[284] = I[285], I[285] = I[286], I[286] = I[287], I[287] = I[288], I[288] = I[289], I[289] = I[290], I[290] = I[291], I[291] = I[292], I[292] = I[293], \
 I[294] = I[295], I[295] = I[296], I[296] = I[297], I[297] = I[298], I[298] = I[299], I[299] = I[300], I[300] = I[301], I[301] = I[302], I[302] = I[303], I[303] = I[304], I[304] = I[305], I[305] = I[306], I[306] = I[307], I[307] = I[308], I[308] = I[309], I[309] = I[310], I[310] = I[311], I[311] = I[312], I[312] = I[313], I[313] = I[314], \
 I[315] = I[316], I[316] = I[317], I[317] = I[318], I[318] = I[319], I[319] = I[320], I[320] = I[321], I[321] = I[322], I[322] = I[323], I[323] = I[324], I[324] = I[325], I[325] = I[326], I[326] = I[327], I[327] = I[328], I[328] = I[329], I[329] = I[330], I[330] = I[331], I[331] = I[332], I[332] = I[333], I[333] = I[334], I[334] = I[335], \
 I[336] = I[337], I[337] = I[338], I[338] = I[339], I[339] = I[340], I[340] = I[341], I[341] = I[342], I[342] = I[343], I[343] = I[344], I[344] = I[345], I[345] = I[346], I[346] = I[347], I[347] = I[348], I[348] = I[349], I[349] = I[350], I[350] = I[351], I[351] = I[352], I[352] = I[353], I[353] = I[354], I[354] = I[355], I[355] = I[356], \
 I[357] = I[358], I[358] = I[359], I[359] = I[360], I[360] = I[361], I[361] = I[362], I[362] = I[363], I[363] = I[364], I[364] = I[365], I[365] = I[366], I[366] = I[367], I[367] = I[368], I[368] = I[369], I[369] = I[370], I[370] = I[371], I[371] = I[372], I[372] = I[373], I[373] = I[374], I[374] = I[375], I[375] = I[376], I[376] = I[377], \
 I[378] = I[379], I[379] = I[380], I[380] = I[381], I[381] = I[382], I[382] = I[383], I[383] = I[384], I[384] = I[385], I[385] = I[386], I[386] = I[387], I[387] = I[388], I[388] = I[389], I[389] = I[390], I[390] = I[391], I[391] = I[392], I[392] = I[393], I[393] = I[394], I[394] = I[395], I[395] = I[396], I[396] = I[397], I[397] = I[398], \
 I[399] = I[400], I[400] = I[401], I[401] = I[402], I[402] = I[403], I[403] = I[404], I[404] = I[405], I[405] = I[406], I[406] = I[407], I[407] = I[408], I[408] = I[409], I[409] = I[410], I[410] = I[411], I[411] = I[412], I[412] = I[413], I[413] = I[414], I[414] = I[415], I[415] = I[416], I[416] = I[417], I[417] = I[418], I[418] = I[419], \
 I[420] = I[421], I[421] = I[422], I[422] = I[423], I[423] = I[424], I[424] = I[425], I[425] = I[426], I[426] = I[427], I[427] = I[428], I[428] = I[429], I[429] = I[430], I[430] = I[431], I[431] = I[432], I[432] = I[433], I[433] = I[434], I[434] = I[435], I[435] = I[436], I[436] = I[437], I[437] = I[438], I[438] = I[439], I[439] = I[440], \
 _p10##x = _p9##x, _p9##x = _p8##x, _p8##x = _p7##x, _p7##x = _p6##x, _p6##x = _p5##x, _p5##x = _p4##x, _p4##x = _p3##x, _p3##x = _p2##x, _p2##x = _p1##x, _p1##x = x++, ++_n1##x, ++_n2##x, ++_n3##x, ++_n4##x, ++_n5##x, ++_n6##x, ++_n7##x, ++_n8##x, ++_n9##x, ++_n10##x)

#define cimg_for_in21x21(img,x0,y0,x1,y1,x,y,z,c,I,T) \
 cimg_for_in21((img)._height,y0,y1,y) for (int x = (int)(x0)<0?0:(int)(x0), \
 _p10##x = x-10<0?0:x-10, \
 _p9##x = x-9<0?0:x-9, \
 _p8##x = x-8<0?0:x-8, \
 _p7##x = x-7<0?0:x-7, \
 _p6##x = x-6<0?0:x-6, \
 _p5##x = x-5<0?0:x-5, \
 _p4##x = x-4<0?0:x-4, \
 _p3##x = x-3<0?0:x-3, \
 _p2##x = x-2<0?0:x-2, \
 _p1##x = x-1<0?0:x-1, \
 _n1##x = x+1>=(img).width()?(img).width()-1:x+1, \
 _n2##x = x+2>=(img).width()?(img).width()-1:x+2, \
 _n3##x = x+3>=(img).width()?(img).width()-1:x+3, \
 _n4##x = x+4>=(img).width()?(img).width()-1:x+4, \
 _n5##x = x+5>=(img).width()?(img).width()-1:x+5, \
 _n6##x = x+6>=(img).width()?(img).width()-1:x+6, \
 _n7##x = x+7>=(img).width()?(img).width()-1:x+7, \
 _n8##x = x+8>=(img).width()?(img).width()-1:x+8, \
 _n9##x = x+9>=(img).width()?(img).width()-1:x+9, \
 _n10##x = (int)( \
 (I[0] = (T)(img)(_p10##x,_p10##y,z,c)), \
 (I[21] = (T)(img)(_p10##x,_p9##y,z,c)), \
 (I[42] = (T)(img)(_p10##x,_p8##y,z,c)), \
 (I[63] = (T)(img)(_p10##x,_p7##y,z,c)), \
 (I[84] = (T)(img)(_p10##x,_p6##y,z,c)), \
 (I[105] = (T)(img)(_p10##x,_p5##y,z,c)), \
 (I[126] = (T)(img)(_p10##x,_p4##y,z,c)), \
 (I[147] = (T)(img)(_p10##x,_p3##y,z,c)), \
 (I[168] = (T)(img)(_p10##x,_p2##y,z,c)), \
 (I[189] = (T)(img)(_p10##x,_p1##y,z,c)), \
 (I[210] = (T)(img)(_p10##x,y,z,c)), \
 (I[231] = (T)(img)(_p10##x,_n1##y,z,c)), \
 (I[252] = (T)(img)(_p10##x,_n2##y,z,c)), \
 (I[273] = (T)(img)(_p10##x,_n3##y,z,c)), \
 (I[294] = (T)(img)(_p10##x,_n4##y,z,c)), \
 (I[315] = (T)(img)(_p10##x,_n5##y,z,c)), \
 (I[336] = (T)(img)(_p10##x,_n6##y,z,c)), \
 (I[357] = (T)(img)(_p10##x,_n7##y,z,c)), \
 (I[378] = (T)(img)(_p10##x,_n8##y,z,c)), \
 (I[399] = (T)(img)(_p10##x,_n9##y,z,c)), \
 (I[420] = (T)(img)(_p10##x,_n10##y,z,c)), \
 (I[1] = (T)(img)(_p9##x,_p10##y,z,c)), \
 (I[22] = (T)(img)(_p9##x,_p9##y,z,c)), \
 (I[43] = (T)(img)(_p9##x,_p8##y,z,c)), \
 (I[64] = (T)(img)(_p9##x,_p7##y,z,c)), \
 (I[85] = (T)(img)(_p9##x,_p6##y,z,c)), \
 (I[106] = (T)(img)(_p9##x,_p5##y,z,c)), \
 (I[127] = (T)(img)(_p9##x,_p4##y,z,c)), \
 (I[148] = (T)(img)(_p9##x,_p3##y,z,c)), \
 (I[169] = (T)(img)(_p9##x,_p2##y,z,c)), \
 (I[190] = (T)(img)(_p9##x,_p1##y,z,c)), \
 (I[211] = (T)(img)(_p9##x,y,z,c)), \
 (I[232] = (T)(img)(_p9##x,_n1##y,z,c)), \
 (I[253] = (T)(img)(_p9##x,_n2##y,z,c)), \
 (I[274] = (T)(img)(_p9##x,_n3##y,z,c)), \
 (I[295] = (T)(img)(_p9##x,_n4##y,z,c)), \
 (I[316] = (T)(img)(_p9##x,_n5##y,z,c)), \
 (I[337] = (T)(img)(_p9##x,_n6##y,z,c)), \
 (I[358] = (T)(img)(_p9##x,_n7##y,z,c)), \
 (I[379] = (T)(img)(_p9##x,_n8##y,z,c)), \
 (I[400] = (T)(img)(_p9##x,_n9##y,z,c)), \
 (I[421] = (T)(img)(_p9##x,_n10##y,z,c)), \
 (I[2] = (T)(img)(_p8##x,_p10##y,z,c)), \
 (I[23] = (T)(img)(_p8##x,_p9##y,z,c)), \
 (I[44] = (T)(img)(_p8##x,_p8##y,z,c)), \
 (I[65] = (T)(img)(_p8##x,_p7##y,z,c)), \
 (I[86] = (T)(img)(_p8##x,_p6##y,z,c)), \
 (I[107] = (T)(img)(_p8##x,_p5##y,z,c)), \
 (I[128] = (T)(img)(_p8##x,_p4##y,z,c)), \
 (I[149] = (T)(img)(_p8##x,_p3##y,z,c)), \
 (I[170] = (T)(img)(_p8##x,_p2##y,z,c)), \
 (I[191] = (T)(img)(_p8##x,_p1##y,z,c)), \
 (I[212] = (T)(img)(_p8##x,y,z,c)), \
 (I[233] = (T)(img)(_p8##x,_n1##y,z,c)), \
 (I[254] = (T)(img)(_p8##x,_n2##y,z,c)), \
 (I[275] = (T)(img)(_p8##x,_n3##y,z,c)), \
 (I[296] = (T)(img)(_p8##x,_n4##y,z,c)), \
 (I[317] = (T)(img)(_p8##x,_n5##y,z,c)), \
 (I[338] = (T)(img)(_p8##x,_n6##y,z,c)), \
 (I[359] = (T)(img)(_p8##x,_n7##y,z,c)), \
 (I[380] = (T)(img)(_p8##x,_n8##y,z,c)), \
 (I[401] = (T)(img)(_p8##x,_n9##y,z,c)), \
 (I[422] = (T)(img)(_p8##x,_n10##y,z,c)), \
 (I[3] = (T)(img)(_p7##x,_p10##y,z,c)), \
 (I[24] = (T)(img)(_p7##x,_p9##y,z,c)), \
 (I[45] = (T)(img)(_p7##x,_p8##y,z,c)), \
 (I[66] = (T)(img)(_p7##x,_p7##y,z,c)), \
 (I[87] = (T)(img)(_p7##x,_p6##y,z,c)), \
 (I[108] = (T)(img)(_p7##x,_p5##y,z,c)), \
 (I[129] = (T)(img)(_p7##x,_p4##y,z,c)), \
 (I[150] = (T)(img)(_p7##x,_p3##y,z,c)), \
 (I[171] = (T)(img)(_p7##x,_p2##y,z,c)), \
 (I[192] = (T)(img)(_p7##x,_p1##y,z,c)), \
 (I[213] = (T)(img)(_p7##x,y,z,c)), \
 (I[234] = (T)(img)(_p7##x,_n1##y,z,c)), \
 (I[255] = (T)(img)(_p7##x,_n2##y,z,c)), \
 (I[276] = (T)(img)(_p7##x,_n3##y,z,c)), \
 (I[297] = (T)(img)(_p7##x,_n4##y,z,c)), \
 (I[318] = (T)(img)(_p7##x,_n5##y,z,c)), \
 (I[339] = (T)(img)(_p7##x,_n6##y,z,c)), \
 (I[360] = (T)(img)(_p7##x,_n7##y,z,c)), \
 (I[381] = (T)(img)(_p7##x,_n8##y,z,c)), \
 (I[402] = (T)(img)(_p7##x,_n9##y,z,c)), \
 (I[423] = (T)(img)(_p7##x,_n10##y,z,c)), \
 (I[4] = (T)(img)(_p6##x,_p10##y,z,c)), \
 (I[25] = (T)(img)(_p6##x,_p9##y,z,c)), \
 (I[46] = (T)(img)(_p6##x,_p8##y,z,c)), \
 (I[67] = (T)(img)(_p6##x,_p7##y,z,c)), \
 (I[88] = (T)(img)(_p6##x,_p6##y,z,c)), \
 (I[109] = (T)(img)(_p6##x,_p5##y,z,c)), \
 (I[130] = (T)(img)(_p6##x,_p4##y,z,c)), \
 (I[151] = (T)(img)(_p6##x,_p3##y,z,c)), \
 (I[172] = (T)(img)(_p6##x,_p2##y,z,c)), \
 (I[193] = (T)(img)(_p6##x,_p1##y,z,c)), \
 (I[214] = (T)(img)(_p6##x,y,z,c)), \
 (I[235] = (T)(img)(_p6##x,_n1##y,z,c)), \
 (I[256] = (T)(img)(_p6##x,_n2##y,z,c)), \
 (I[277] = (T)(img)(_p6##x,_n3##y,z,c)), \
 (I[298] = (T)(img)(_p6##x,_n4##y,z,c)), \
 (I[319] = (T)(img)(_p6##x,_n5##y,z,c)), \
 (I[340] = (T)(img)(_p6##x,_n6##y,z,c)), \
 (I[361] = (T)(img)(_p6##x,_n7##y,z,c)), \
 (I[382] = (T)(img)(_p6##x,_n8##y,z,c)), \
 (I[403] = (T)(img)(_p6##x,_n9##y,z,c)), \
 (I[424] = (T)(img)(_p6##x,_n10##y,z,c)), \
 (I[5] = (T)(img)(_p5##x,_p10##y,z,c)), \
 (I[26] = (T)(img)(_p5##x,_p9##y,z,c)), \
 (I[47] = (T)(img)(_p5##x,_p8##y,z,c)), \
 (I[68] = (T)(img)(_p5##x,_p7##y,z,c)), \
 (I[89] = (T)(img)(_p5##x,_p6##y,z,c)), \
 (I[110] = (T)(img)(_p5##x,_p5##y,z,c)), \
 (I[131] = (T)(img)(_p5##x,_p4##y,z,c)), \
 (I[152] = (T)(img)(_p5##x,_p3##y,z,c)), \
 (I[173] = (T)(img)(_p5##x,_p2##y,z,c)), \
 (I[194] = (T)(img)(_p5##x,_p1##y,z,c)), \
 (I[215] = (T)(img)(_p5##x,y,z,c)), \
 (I[236] = (T)(img)(_p5##x,_n1##y,z,c)), \
 (I[257] = (T)(img)(_p5##x,_n2##y,z,c)), \
 (I[278] = (T)(img)(_p5##x,_n3##y,z,c)), \
 (I[299] = (T)(img)(_p5##x,_n4##y,z,c)), \
 (I[320] = (T)(img)(_p5##x,_n5##y,z,c)), \
 (I[341] = (T)(img)(_p5##x,_n6##y,z,c)), \
 (I[362] = (T)(img)(_p5##x,_n7##y,z,c)), \
 (I[383] = (T)(img)(_p5##x,_n8##y,z,c)), \
 (I[404] = (T)(img)(_p5##x,_n9##y,z,c)), \
 (I[425] = (T)(img)(_p5##x,_n10##y,z,c)), \
 (I[6] = (T)(img)(_p4##x,_p10##y,z,c)), \
 (I[27] = (T)(img)(_p4##x,_p9##y,z,c)), \
 (I[48] = (T)(img)(_p4##x,_p8##y,z,c)), \
 (I[69] = (T)(img)(_p4##x,_p7##y,z,c)), \
 (I[90] = (T)(img)(_p4##x,_p6##y,z,c)), \
 (I[111] = (T)(img)(_p4##x,_p5##y,z,c)), \
 (I[132] = (T)(img)(_p4##x,_p4##y,z,c)), \
 (I[153] = (T)(img)(_p4##x,_p3##y,z,c)), \
 (I[174] = (T)(img)(_p4##x,_p2##y,z,c)), \
 (I[195] = (T)(img)(_p4##x,_p1##y,z,c)), \
 (I[216] = (T)(img)(_p4##x,y,z,c)), \
 (I[237] = (T)(img)(_p4##x,_n1##y,z,c)), \
 (I[258] = (T)(img)(_p4##x,_n2##y,z,c)), \
 (I[279] = (T)(img)(_p4##x,_n3##y,z,c)), \
 (I[300] = (T)(img)(_p4##x,_n4##y,z,c)), \
 (I[321] = (T)(img)(_p4##x,_n5##y,z,c)), \
 (I[342] = (T)(img)(_p4##x,_n6##y,z,c)), \
 (I[363] = (T)(img)(_p4##x,_n7##y,z,c)), \
 (I[384] = (T)(img)(_p4##x,_n8##y,z,c)), \
 (I[405] = (T)(img)(_p4##x,_n9##y,z,c)), \
 (I[426] = (T)(img)(_p4##x,_n10##y,z,c)), \
 (I[7] = (T)(img)(_p3##x,_p10##y,z,c)), \
 (I[28] = (T)(img)(_p3##x,_p9##y,z,c)), \
 (I[49] = (T)(img)(_p3##x,_p8##y,z,c)), \
 (I[70] = (T)(img)(_p3##x,_p7##y,z,c)), \
 (I[91] = (T)(img)(_p3##x,_p6##y,z,c)), \
 (I[112] = (T)(img)(_p3##x,_p5##y,z,c)), \
 (I[133] = (T)(img)(_p3##x,_p4##y,z,c)), \
 (I[154] = (T)(img)(_p3##x,_p3##y,z,c)), \
 (I[175] = (T)(img)(_p3##x,_p2##y,z,c)), \
 (I[196] = (T)(img)(_p3##x,_p1##y,z,c)), \
 (I[217] = (T)(img)(_p3##x,y,z,c)), \
 (I[238] = (T)(img)(_p3##x,_n1##y,z,c)), \
 (I[259] = (T)(img)(_p3##x,_n2##y,z,c)), \
 (I[280] = (T)(img)(_p3##x,_n3##y,z,c)), \
 (I[301] = (T)(img)(_p3##x,_n4##y,z,c)), \
 (I[322] = (T)(img)(_p3##x,_n5##y,z,c)), \
 (I[343] = (T)(img)(_p3##x,_n6##y,z,c)), \
 (I[364] = (T)(img)(_p3##x,_n7##y,z,c)), \
 (I[385] = (T)(img)(_p3##x,_n8##y,z,c)), \
 (I[406] = (T)(img)(_p3##x,_n9##y,z,c)), \
 (I[427] = (T)(img)(_p3##x,_n10##y,z,c)), \
 (I[8] = (T)(img)(_p2##x,_p10##y,z,c)), \
 (I[29] = (T)(img)(_p2##x,_p9##y,z,c)), \
 (I[50] = (T)(img)(_p2##x,_p8##y,z,c)), \
 (I[71] = (T)(img)(_p2##x,_p7##y,z,c)), \
 (I[92] = (T)(img)(_p2##x,_p6##y,z,c)), \
 (I[113] = (T)(img)(_p2##x,_p5##y,z,c)), \
 (I[134] = (T)(img)(_p2##x,_p4##y,z,c)), \
 (I[155] = (T)(img)(_p2##x,_p3##y,z,c)), \
 (I[176] = (T)(img)(_p2##x,_p2##y,z,c)), \
 (I[197] = (T)(img)(_p2##x,_p1##y,z,c)), \
 (I[218] = (T)(img)(_p2##x,y,z,c)), \
 (I[239] = (T)(img)(_p2##x,_n1##y,z,c)), \
 (I[260] = (T)(img)(_p2##x,_n2##y,z,c)), \
 (I[281] = (T)(img)(_p2##x,_n3##y,z,c)), \
 (I[302] = (T)(img)(_p2##x,_n4##y,z,c)), \
 (I[323] = (T)(img)(_p2##x,_n5##y,z,c)), \
 (I[344] = (T)(img)(_p2##x,_n6##y,z,c)), \
 (I[365] = (T)(img)(_p2##x,_n7##y,z,c)), \
 (I[386] = (T)(img)(_p2##x,_n8##y,z,c)), \
 (I[407] = (T)(img)(_p2##x,_n9##y,z,c)), \
 (I[428] = (T)(img)(_p2##x,_n10##y,z,c)), \
 (I[9] = (T)(img)(_p1##x,_p10##y,z,c)), \
 (I[30] = (T)(img)(_p1##x,_p9##y,z,c)), \
 (I[51] = (T)(img)(_p1##x,_p8##y,z,c)), \
 (I[72] = (T)(img)(_p1##x,_p7##y,z,c)), \
 (I[93] = (T)(img)(_p1##x,_p6##y,z,c)), \
 (I[114] = (T)(img)(_p1##x,_p5##y,z,c)), \
 (I[135] = (T)(img)(_p1##x,_p4##y,z,c)), \
 (I[156] = (T)(img)(_p1##x,_p3##y,z,c)), \
 (I[177] = (T)(img)(_p1##x,_p2##y,z,c)), \
 (I[198] = (T)(img)(_p1##x,_p1##y,z,c)), \
 (I[219] = (T)(img)(_p1##x,y,z,c)), \
 (I[240] = (T)(img)(_p1##x,_n1##y,z,c)), \
 (I[261] = (T)(img)(_p1##x,_n2##y,z,c)), \
 (I[282] = (T)(img)(_p1##x,_n3##y,z,c)), \
 (I[303] = (T)(img)(_p1##x,_n4##y,z,c)), \
 (I[324] = (T)(img)(_p1##x,_n5##y,z,c)), \
 (I[345] = (T)(img)(_p1##x,_n6##y,z,c)), \
 (I[366] = (T)(img)(_p1##x,_n7##y,z,c)), \
 (I[387] = (T)(img)(_p1##x,_n8##y,z,c)), \
 (I[408] = (T)(img)(_p1##x,_n9##y,z,c)), \
 (I[429] = (T)(img)(_p1##x,_n10##y,z,c)), \
 (I[10] = (T)(img)(x,_p10##y,z,c)), \
 (I[31] = (T)(img)(x,_p9##y,z,c)), \
 (I[52] = (T)(img)(x,_p8##y,z,c)), \
 (I[73] = (T)(img)(x,_p7##y,z,c)), \
 (I[94] = (T)(img)(x,_p6##y,z,c)), \
 (I[115] = (T)(img)(x,_p5##y,z,c)), \
 (I[136] = (T)(img)(x,_p4##y,z,c)), \
 (I[157] = (T)(img)(x,_p3##y,z,c)), \
 (I[178] = (T)(img)(x,_p2##y,z,c)), \
 (I[199] = (T)(img)(x,_p1##y,z,c)), \
 (I[220] = (T)(img)(x,y,z,c)), \
 (I[241] = (T)(img)(x,_n1##y,z,c)), \
 (I[262] = (T)(img)(x,_n2##y,z,c)), \
 (I[283] = (T)(img)(x,_n3##y,z,c)), \
 (I[304] = (T)(img)(x,_n4##y,z,c)), \
 (I[325] = (T)(img)(x,_n5##y,z,c)), \
 (I[346] = (T)(img)(x,_n6##y,z,c)), \
 (I[367] = (T)(img)(x,_n7##y,z,c)), \
 (I[388] = (T)(img)(x,_n8##y,z,c)), \
 (I[409] = (T)(img)(x,_n9##y,z,c)), \
 (I[430] = (T)(img)(x,_n10##y,z,c)), \
 (I[11] = (T)(img)(_n1##x,_p10##y,z,c)), \
 (I[32] = (T)(img)(_n1##x,_p9##y,z,c)), \
 (I[53] = (T)(img)(_n1##x,_p8##y,z,c)), \
 (I[74] = (T)(img)(_n1##x,_p7##y,z,c)), \
 (I[95] = (T)(img)(_n1##x,_p6##y,z,c)), \
 (I[116] = (T)(img)(_n1##x,_p5##y,z,c)), \
 (I[137] = (T)(img)(_n1##x,_p4##y,z,c)), \
 (I[158] = (T)(img)(_n1##x,_p3##y,z,c)), \
 (I[179] = (T)(img)(_n1##x,_p2##y,z,c)), \
 (I[200] = (T)(img)(_n1##x,_p1##y,z,c)), \
 (I[221] = (T)(img)(_n1##x,y,z,c)), \
 (I[242] = (T)(img)(_n1##x,_n1##y,z,c)), \
 (I[263] = (T)(img)(_n1##x,_n2##y,z,c)), \
 (I[284] = (T)(img)(_n1##x,_n3##y,z,c)), \
 (I[305] = (T)(img)(_n1##x,_n4##y,z,c)), \
 (I[326] = (T)(img)(_n1##x,_n5##y,z,c)), \
 (I[347] = (T)(img)(_n1##x,_n6##y,z,c)), \
 (I[368] = (T)(img)(_n1##x,_n7##y,z,c)), \
 (I[389] = (T)(img)(_n1##x,_n8##y,z,c)), \
 (I[410] = (T)(img)(_n1##x,_n9##y,z,c)), \
 (I[431] = (T)(img)(_n1##x,_n10##y,z,c)), \
 (I[12] = (T)(img)(_n2##x,_p10##y,z,c)), \
 (I[33] = (T)(img)(_n2##x,_p9##y,z,c)), \
 (I[54] = (T)(img)(_n2##x,_p8##y,z,c)), \
 (I[75] = (T)(img)(_n2##x,_p7##y,z,c)), \
 (I[96] = (T)(img)(_n2##x,_p6##y,z,c)), \
 (I[117] = (T)(img)(_n2##x,_p5##y,z,c)), \
 (I[138] = (T)(img)(_n2##x,_p4##y,z,c)), \
 (I[159] = (T)(img)(_n2##x,_p3##y,z,c)), \
 (I[180] = (T)(img)(_n2##x,_p2##y,z,c)), \
 (I[201] = (T)(img)(_n2##x,_p1##y,z,c)), \
 (I[222] = (T)(img)(_n2##x,y,z,c)), \
 (I[243] = (T)(img)(_n2##x,_n1##y,z,c)), \
 (I[264] = (T)(img)(_n2##x,_n2##y,z,c)), \
 (I[285] = (T)(img)(_n2##x,_n3##y,z,c)), \
 (I[306] = (T)(img)(_n2##x,_n4##y,z,c)), \
 (I[327] = (T)(img)(_n2##x,_n5##y,z,c)), \
 (I[348] = (T)(img)(_n2##x,_n6##y,z,c)), \
 (I[369] = (T)(img)(_n2##x,_n7##y,z,c)), \
 (I[390] = (T)(img)(_n2##x,_n8##y,z,c)), \
 (I[411] = (T)(img)(_n2##x,_n9##y,z,c)), \
 (I[432] = (T)(img)(_n2##x,_n10##y,z,c)), \
 (I[13] = (T)(img)(_n3##x,_p10##y,z,c)), \
 (I[34] = (T)(img)(_n3##x,_p9##y,z,c)), \
 (I[55] = (T)(img)(_n3##x,_p8##y,z,c)), \
 (I[76] = (T)(img)(_n3##x,_p7##y,z,c)), \
 (I[97] = (T)(img)(_n3##x,_p6##y,z,c)), \
 (I[118] = (T)(img)(_n3##x,_p5##y,z,c)), \
 (I[139] = (T)(img)(_n3##x,_p4##y,z,c)), \
 (I[160] = (T)(img)(_n3##x,_p3##y,z,c)), \
 (I[181] = (T)(img)(_n3##x,_p2##y,z,c)), \
 (I[202] = (T)(img)(_n3##x,_p1##y,z,c)), \
 (I[223] = (T)(img)(_n3##x,y,z,c)), \
 (I[244] = (T)(img)(_n3##x,_n1##y,z,c)), \
 (I[265] = (T)(img)(_n3##x,_n2##y,z,c)), \
 (I[286] = (T)(img)(_n3##x,_n3##y,z,c)), \
 (I[307] = (T)(img)(_n3##x,_n4##y,z,c)), \
 (I[328] = (T)(img)(_n3##x,_n5##y,z,c)), \
 (I[349] = (T)(img)(_n3##x,_n6##y,z,c)), \
 (I[370] = (T)(img)(_n3##x,_n7##y,z,c)), \
 (I[391] = (T)(img)(_n3##x,_n8##y,z,c)), \
 (I[412] = (T)(img)(_n3##x,_n9##y,z,c)), \
 (I[433] = (T)(img)(_n3##x,_n10##y,z,c)), \
 (I[14] = (T)(img)(_n4##x,_p10##y,z,c)), \
 (I[35] = (T)(img)(_n4##x,_p9##y,z,c)), \
 (I[56] = (T)(img)(_n4##x,_p8##y,z,c)), \
 (I[77] = (T)(img)(_n4##x,_p7##y,z,c)), \
 (I[98] = (T)(img)(_n4##x,_p6##y,z,c)), \
 (I[119] = (T)(img)(_n4##x,_p5##y,z,c)), \
 (I[140] = (T)(img)(_n4##x,_p4##y,z,c)), \
 (I[161] = (T)(img)(_n4##x,_p3##y,z,c)), \
 (I[182] = (T)(img)(_n4##x,_p2##y,z,c)), \
 (I[203] = (T)(img)(_n4##x,_p1##y,z,c)), \
 (I[224] = (T)(img)(_n4##x,y,z,c)), \
 (I[245] = (T)(img)(_n4##x,_n1##y,z,c)), \
 (I[266] = (T)(img)(_n4##x,_n2##y,z,c)), \
 (I[287] = (T)(img)(_n4##x,_n3##y,z,c)), \
 (I[308] = (T)(img)(_n4##x,_n4##y,z,c)), \
 (I[329] = (T)(img)(_n4##x,_n5##y,z,c)), \
 (I[350] = (T)(img)(_n4##x,_n6##y,z,c)), \
 (I[371] = (T)(img)(_n4##x,_n7##y,z,c)), \
 (I[392] = (T)(img)(_n4##x,_n8##y,z,c)), \
 (I[413] = (T)(img)(_n4##x,_n9##y,z,c)), \
 (I[434] = (T)(img)(_n4##x,_n10##y,z,c)), \
 (I[15] = (T)(img)(_n5##x,_p10##y,z,c)), \
 (I[36] = (T)(img)(_n5##x,_p9##y,z,c)), \
 (I[57] = (T)(img)(_n5##x,_p8##y,z,c)), \
 (I[78] = (T)(img)(_n5##x,_p7##y,z,c)), \
 (I[99] = (T)(img)(_n5##x,_p6##y,z,c)), \
 (I[120] = (T)(img)(_n5##x,_p5##y,z,c)), \
 (I[141] = (T)(img)(_n5##x,_p4##y,z,c)), \
 (I[162] = (T)(img)(_n5##x,_p3##y,z,c)), \
 (I[183] = (T)(img)(_n5##x,_p2##y,z,c)), \
 (I[204] = (T)(img)(_n5##x,_p1##y,z,c)), \
 (I[225] = (T)(img)(_n5##x,y,z,c)), \
 (I[246] = (T)(img)(_n5##x,_n1##y,z,c)), \
 (I[267] = (T)(img)(_n5##x,_n2##y,z,c)), \
 (I[288] = (T)(img)(_n5##x,_n3##y,z,c)), \
 (I[309] = (T)(img)(_n5##x,_n4##y,z,c)), \
 (I[330] = (T)(img)(_n5##x,_n5##y,z,c)), \
 (I[351] = (T)(img)(_n5##x,_n6##y,z,c)), \
 (I[372] = (T)(img)(_n5##x,_n7##y,z,c)), \
 (I[393] = (T)(img)(_n5##x,_n8##y,z,c)), \
 (I[414] = (T)(img)(_n5##x,_n9##y,z,c)), \
 (I[435] = (T)(img)(_n5##x,_n10##y,z,c)), \
 (I[16] = (T)(img)(_n6##x,_p10##y,z,c)), \
 (I[37] = (T)(img)(_n6##x,_p9##y,z,c)), \
 (I[58] = (T)(img)(_n6##x,_p8##y,z,c)), \
 (I[79] = (T)(img)(_n6##x,_p7##y,z,c)), \
 (I[100] = (T)(img)(_n6##x,_p6##y,z,c)), \
 (I[121] = (T)(img)(_n6##x,_p5##y,z,c)), \
 (I[142] = (T)(img)(_n6##x,_p4##y,z,c)), \
 (I[163] = (T)(img)(_n6##x,_p3##y,z,c)), \
 (I[184] = (T)(img)(_n6##x,_p2##y,z,c)), \
 (I[205] = (T)(img)(_n6##x,_p1##y,z,c)), \
 (I[226] = (T)(img)(_n6##x,y,z,c)), \
 (I[247] = (T)(img)(_n6##x,_n1##y,z,c)), \
 (I[268] = (T)(img)(_n6##x,_n2##y,z,c)), \
 (I[289] = (T)(img)(_n6##x,_n3##y,z,c)), \
 (I[310] = (T)(img)(_n6##x,_n4##y,z,c)), \
 (I[331] = (T)(img)(_n6##x,_n5##y,z,c)), \
 (I[352] = (T)(img)(_n6##x,_n6##y,z,c)), \
 (I[373] = (T)(img)(_n6##x,_n7##y,z,c)), \
 (I[394] = (T)(img)(_n6##x,_n8##y,z,c)), \
 (I[415] = (T)(img)(_n6##x,_n9##y,z,c)), \
 (I[436] = (T)(img)(_n6##x,_n10##y,z,c)), \
 (I[17] = (T)(img)(_n7##x,_p10##y,z,c)), \
 (I[38] = (T)(img)(_n7##x,_p9##y,z,c)), \
 (I[59] = (T)(img)(_n7##x,_p8##y,z,c)), \
 (I[80] = (T)(img)(_n7##x,_p7##y,z,c)), \
 (I[101] = (T)(img)(_n7##x,_p6##y,z,c)), \
 (I[122] = (T)(img)(_n7##x,_p5##y,z,c)), \
 (I[143] = (T)(img)(_n7##x,_p4##y,z,c)), \
 (I[164] = (T)(img)(_n7##x,_p3##y,z,c)), \
 (I[185] = (T)(img)(_n7##x,_p2##y,z,c)), \
 (I[206] = (T)(img)(_n7##x,_p1##y,z,c)), \
 (I[227] = (T)(img)(_n7##x,y,z,c)), \
 (I[248] = (T)(img)(_n7##x,_n1##y,z,c)), \
 (I[269] = (T)(img)(_n7##x,_n2##y,z,c)), \
 (I[290] = (T)(img)(_n7##x,_n3##y,z,c)), \
 (I[311] = (T)(img)(_n7##x,_n4##y,z,c)), \
 (I[332] = (T)(img)(_n7##x,_n5##y,z,c)), \
 (I[353] = (T)(img)(_n7##x,_n6##y,z,c)), \
 (I[374] = (T)(img)(_n7##x,_n7##y,z,c)), \
 (I[395] = (T)(img)(_n7##x,_n8##y,z,c)), \
 (I[416] = (T)(img)(_n7##x,_n9##y,z,c)), \
 (I[437] = (T)(img)(_n7##x,_n10##y,z,c)), \
 (I[18] = (T)(img)(_n8##x,_p10##y,z,c)), \
 (I[39] = (T)(img)(_n8##x,_p9##y,z,c)), \
 (I[60] = (T)(img)(_n8##x,_p8##y,z,c)), \
 (I[81] = (T)(img)(_n8##x,_p7##y,z,c)), \
 (I[102] = (T)(img)(_n8##x,_p6##y,z,c)), \
 (I[123] = (T)(img)(_n8##x,_p5##y,z,c)), \
 (I[144] = (T)(img)(_n8##x,_p4##y,z,c)), \
 (I[165] = (T)(img)(_n8##x,_p3##y,z,c)), \
 (I[186] = (T)(img)(_n8##x,_p2##y,z,c)), \
 (I[207] = (T)(img)(_n8##x,_p1##y,z,c)), \
 (I[228] = (T)(img)(_n8##x,y,z,c)), \
 (I[249] = (T)(img)(_n8##x,_n1##y,z,c)), \
 (I[270] = (T)(img)(_n8##x,_n2##y,z,c)), \
 (I[291] = (T)(img)(_n8##x,_n3##y,z,c)), \
 (I[312] = (T)(img)(_n8##x,_n4##y,z,c)), \
 (I[333] = (T)(img)(_n8##x,_n5##y,z,c)), \
 (I[354] = (T)(img)(_n8##x,_n6##y,z,c)), \
 (I[375] = (T)(img)(_n8##x,_n7##y,z,c)), \
 (I[396] = (T)(img)(_n8##x,_n8##y,z,c)), \
 (I[417] = (T)(img)(_n8##x,_n9##y,z,c)), \
 (I[438] = (T)(img)(_n8##x,_n10##y,z,c)), \
 (I[19] = (T)(img)(_n9##x,_p10##y,z,c)), \
 (I[40] = (T)(img)(_n9##x,_p9##y,z,c)), \
 (I[61] = (T)(img)(_n9##x,_p8##y,z,c)), \
 (I[82] = (T)(img)(_n9##x,_p7##y,z,c)), \
 (I[103] = (T)(img)(_n9##x,_p6##y,z,c)), \
 (I[124] = (T)(img)(_n9##x,_p5##y,z,c)), \
 (I[145] = (T)(img)(_n9##x,_p4##y,z,c)), \
 (I[166] = (T)(img)(_n9##x,_p3##y,z,c)), \
 (I[187] = (T)(img)(_n9##x,_p2##y,z,c)), \
 (I[208] = (T)(img)(_n9##x,_p1##y,z,c)), \
 (I[229] = (T)(img)(_n9##x,y,z,c)), \
 (I[250] = (T)(img)(_n9##x,_n1##y,z,c)), \
 (I[271] = (T)(img)(_n9##x,_n2##y,z,c)), \
 (I[292] = (T)(img)(_n9##x,_n3##y,z,c)), \
 (I[313] = (T)(img)(_n9##x,_n4##y,z,c)), \
 (I[334] = (T)(img)(_n9##x,_n5##y,z,c)), \
 (I[355] = (T)(img)(_n9##x,_n6##y,z,c)), \
 (I[376] = (T)(img)(_n9##x,_n7##y,z,c)), \
 (I[397] = (T)(img)(_n9##x,_n8##y,z,c)), \
 (I[418] = (T)(img)(_n9##x,_n9##y,z,c)), \
 (I[439] = (T)(img)(_n9##x,_n10##y,z,c)), \
 x+10>=(img).width()?(img).width()-1:x+10); \
 x<=(int)(x1) && ((_n10##x<(img).width() && ( \
 (I[20] = (T)(img)(_n10##x,_p10##y,z,c)), \
 (I[41] = (T)(img)(_n10##x,_p9##y,z,c)), \
 (I[62] = (T)(img)(_n10##x,_p8##y,z,c)), \
 (I[83] = (T)(img)(_n10##x,_p7##y,z,c)), \
 (I[104] = (T)(img)(_n10##x,_p6##y,z,c)), \
 (I[125] = (T)(img)(_n10##x,_p5##y,z,c)), \
 (I[146] = (T)(img)(_n10##x,_p4##y,z,c)), \
 (I[167] = (T)(img)(_n10##x,_p3##y,z,c)), \
 (I[188] = (T)(img)(_n10##x,_p2##y,z,c)), \
 (I[209] = (T)(img)(_n10##x,_p1##y,z,c)), \
 (I[230] = (T)(img)(_n10##x,y,z,c)), \
 (I[251] = (T)(img)(_n10##x,_n1##y,z,c)), \
 (I[272] = (T)(img)(_n10##x,_n2##y,z,c)), \
 (I[293] = (T)(img)(_n10##x,_n3##y,z,c)), \
 (I[314] = (T)(img)(_n10##x,_n4##y,z,c)), \
 (I[335] = (T)(img)(_n10##x,_n5##y,z,c)), \
 (I[356] = (T)(img)(_n10##x,_n6##y,z,c)), \
 (I[377] = (T)(img)(_n10##x,_n7##y,z,c)), \
 (I[398] = (T)(img)(_n10##x,_n8##y,z,c)), \
 (I[419] = (T)(img)(_n10##x,_n9##y,z,c)), \
 (I[440] = (T)(img)(_n10##x,_n10##y,z,c)),1)) || \
 _n9##x==--_n10##x || _n8##x==--_n9##x || _n7##x==--_n8##x || _n6##x==--_n7##x || _n5##x==--_n6##x || _n4##x==--_n5##x || _n3##x==--_n4##x || _n2##x==--_n3##x || _n1##x==--_n2##x || x==(_n10##x = _n9##x = _n8##x = _n7##x = _n6##x = _n5##x = _n4##x = _n3##x = _n2##x = --_n1##x)); \
 I[0] = I[1], I[1] = I[2], I[2] = I[3], I[3] = I[4], I[4] = I[5], I[5] = I[6], I[6] = I[7], I[7] = I[8], I[8] = I[9], I[9] = I[10], I[10] = I[11], I[11] = I[12], I[12] = I[13], I[13] = I[14], I[14] = I[15], I[15] = I[16], I[16] = I[17], I[17] = I[18], I[18] = I[19], I[19] = I[20], \
 I[21] = I[22], I[22] = I[23], I[23] = I[24], I[24] = I[25], I[25] = I[26], I[26] = I[27], I[27] = I[28], I[28] = I[29], I[29] = I[30], I[30] = I[31], I[31] = I[32], I[32] = I[33], I[33] = I[34], I[34] = I[35], I[35] = I[36], I[36] = I[37], I[37] = I[38], I[38] = I[39], I[39] = I[40], I[40] = I[41], \
 I[42] = I[43], I[43] = I[44], I[44] = I[45], I[45] = I[46], I[46] = I[47], I[47] = I[48], I[48] = I[49], I[49] = I[50], I[50] = I[51], I[51] = I[52], I[52] = I[53], I[53] = I[54], I[54] = I[55], I[55] = I[56], I[56] = I[57], I[57] = I[58], I[58] = I[59], I[59] = I[60], I[60] = I[61], I[61] = I[62], \
 I[63] = I[64], I[64] = I[65], I[65] = I[66], I[66] = I[67], I[67] = I[68], I[68] = I[69], I[69] = I[70], I[70] = I[71], I[71] = I[72], I[72] = I[73], I[73] = I[74], I[74] = I[75], I[75] = I[76], I[76] = I[77], I[77] = I[78], I[78] = I[79], I[79] = I[80], I[80] = I[81], I[81] = I[82], I[82] = I[83], \
 I[84] = I[85], I[85] = I[86], I[86] = I[87], I[87] = I[88], I[88] = I[89], I[89] = I[90], I[90] = I[91], I[91] = I[92], I[92] = I[93], I[93] = I[94], I[94] = I[95], I[95] = I[96], I[96] = I[97], I[97] = I[98], I[98] = I[99], I[99] = I[100], I[100] = I[101], I[101] = I[102], I[102] = I[103], I[103] = I[104], \
 I[105] = I[106], I[106] = I[107], I[107] = I[108], I[108] = I[109], I[109] = I[110], I[110] = I[111], I[111] = I[112], I[112] = I[113], I[113] = I[114], I[114] = I[115], I[115] = I[116], I[116] = I[117], I[117] = I[118], I[118] = I[119], I[119] = I[120], I[120] = I[121], I[121] = I[122], I[122] = I[123], I[123] = I[124], I[124] = I[125], \
 I[126] = I[127], I[127] = I[128], I[128] = I[129], I[129] = I[130], I[130] = I[131], I[131] = I[132], I[132] = I[133], I[133] = I[134], I[134] = I[135], I[135] = I[136], I[136] = I[137], I[137] = I[138], I[138] = I[139], I[139] = I[140], I[140] = I[141], I[141] = I[142], I[142] = I[143], I[143] = I[144], I[144] = I[145], I[145] = I[146], \
 I[147] = I[148], I[148] = I[149], I[149] = I[150], I[150] = I[151], I[151] = I[152], I[152] = I[153], I[153] = I[154], I[154] = I[155], I[155] = I[156], I[156] = I[157], I[157] = I[158], I[158] = I[159], I[159] = I[160], I[160] = I[161], I[161] = I[162], I[162] = I[163], I[163] = I[164], I[164] = I[165], I[165] = I[166], I[166] = I[167], \
 I[168] = I[169], I[169] = I[170], I[170] = I[171], I[171] = I[172], I[172] = I[173], I[173] = I[174], I[174] = I[175], I[175] = I[176], I[176] = I[177], I[177] = I[178], I[178] = I[179], I[179] = I[180], I[180] = I[181], I[181] = I[182], I[182] = I[183], I[183] = I[184], I[184] = I[185], I[185] = I[186], I[186] = I[187], I[187] = I[188], \
 I[189] = I[190], I[190] = I[191], I[191] = I[192], I[192] = I[193], I[193] = I[194], I[194] = I[195], I[195] = I[196], I[196] = I[197], I[197] = I[198], I[198] = I[199], I[199] = I[200], I[200] = I[201], I[201] = I[202], I[202] = I[203], I[203] = I[204], I[204] = I[205], I[205] = I[206], I[206] = I[207], I[207] = I[208], I[208] = I[209], \
 I[210] = I[211], I[211] = I[212], I[212] = I[213], I[213] = I[214], I[214] = I[215], I[215] = I[216], I[216] = I[217], I[217] = I[218], I[218] = I[219], I[219] = I[220], I[220] = I[221], I[221] = I[222], I[222] = I[223], I[223] = I[224], I[224] = I[225], I[225] = I[226], I[226] = I[227], I[227] = I[228], I[228] = I[229], I[229] = I[230], \
 I[231] = I[232], I[232] = I[233], I[233] = I[234], I[234] = I[235], I[235] = I[236], I[236] = I[237], I[237] = I[238], I[238] = I[239], I[239] = I[240], I[240] = I[241], I[241] = I[242], I[242] = I[243], I[243] = I[244], I[244] = I[245], I[245] = I[246], I[246] = I[247], I[247] = I[248], I[248] = I[249], I[249] = I[250], I[250] = I[251], \
 I[252] = I[253], I[253] = I[254], I[254] = I[255], I[255] = I[256], I[256] = I[257], I[257] = I[258], I[258] = I[259], I[259] = I[260], I[260] = I[261], I[261] = I[262], I[262] = I[263], I[263] = I[264], I[264] = I[265], I[265] = I[266], I[266] = I[267], I[267] = I[268], I[268] = I[269], I[269] = I[270], I[270] = I[271], I[271] = I[272], \
 I[273] = I[274], I[274] = I[275], I[275] = I[276], I[276] = I[277], I[277] = I[278], I[278] = I[279], I[279] = I[280], I[280] = I[281], I[281] = I[282], I[282] = I[283], I[283] = I[284], I[284] = I[285], I[285] = I[286], I[286] = I[287], I[287] = I[288], I[288] = I[289], I[289] = I[290], I[290] = I[291], I[291] = I[292], I[292] = I[293], \
 I[294] = I[295], I[295] = I[296], I[296] = I[297], I[297] = I[298], I[298] = I[299], I[299] = I[300], I[300] = I[301], I[301] = I[302], I[302] = I[303], I[303] = I[304], I[304] = I[305], I[305] = I[306], I[306] = I[307], I[307] = I[308], I[308] = I[309], I[309] = I[310], I[310] = I[311], I[311] = I[312], I[312] = I[313], I[313] = I[314], \
 I[315] = I[316], I[316] = I[317], I[317] = I[318], I[318] = I[319], I[319] = I[320], I[320] = I[321], I[321] = I[322], I[322] = I[323], I[323] = I[324], I[324] = I[325], I[325] = I[326], I[326] = I[327], I[327] = I[328], I[328] = I[329], I[329] = I[330], I[330] = I[331], I[331] = I[332], I[332] = I[333], I[333] = I[334], I[334] = I[335], \
 I[336] = I[337], I[337] = I[338], I[338] = I[339], I[339] = I[340], I[340] = I[341], I[341] = I[342], I[342] = I[343], I[343] = I[344], I[344] = I[345], I[345] = I[346], I[346] = I[347], I[347] = I[348], I[348] = I[349], I[349] = I[350], I[350] = I[351], I[351] = I[352], I[352] = I[353], I[353] = I[354], I[354] = I[355], I[355] = I[356], \
 I[357] = I[358], I[358] = I[359], I[359] = I[360], I[360] = I[361], I[361] = I[362], I[362] = I[363], I[363] = I[364], I[364] = I[365], I[365] = I[366], I[366] = I[367], I[367] = I[368], I[368] = I[369], I[369] = I[370], I[370] = I[371], I[371] = I[372], I[372] = I[373], I[373] = I[374], I[374] = I[375], I[375] = I[376], I[376] = I[377], \
 I[378] = I[379], I[379] = I[380], I[380] = I[381], I[381] = I[382], I[382] = I[383], I[383] = I[384], I[384] = I[385], I[385] = I[386], I[386] = I[387], I[387] = I[388], I[388] = I[389], I[389] = I[390], I[390] = I[391], I[391] = I[392], I[392] = I[393], I[393] = I[394], I[394] = I[395], I[395] = I[396], I[396] = I[397], I[397] = I[398], \
 I[399] = I[400], I[400] = I[401], I[401] = I[402], I[402] = I[403], I[403] = I[404], I[404] = I[405], I[405] = I[406], I[406] = I[407], I[407] = I[408], I[408] = I[409], I[409] = I[410], I[410] = I[411], I[411] = I[412], I[412] = I[413], I[413] = I[414], I[414] = I[415], I[415] = I[416], I[416] = I[417], I[417] = I[418], I[418] = I[419], \
 I[420] = I[421], I[421] = I[422], I[422] = I[423], I[423] = I[424], I[424] = I[425], I[425] = I[426], I[426] = I[427], I[427] = I[428], I[428] = I[429], I[429] = I[430], I[430] = I[431], I[431] = I[432], I[432] = I[433], I[433] = I[434], I[434] = I[435], I[435] = I[436], I[436] = I[437], I[437] = I[438], I[438] = I[439], I[439] = I[440], \
 _p10##x = _p9##x, _p9##x = _p8##x, _p8##x = _p7##x, _p7##x = _p6##x, _p6##x = _p5##x, _p5##x = _p4##x, _p4##x = _p3##x, _p3##x = _p2##x, _p2##x = _p1##x, _p1##x = x++, ++_n1##x, ++_n2##x, ++_n3##x, ++_n4##x, ++_n5##x, ++_n6##x, ++_n7##x, ++_n8##x, ++_n9##x, ++_n10##x)

#define cimg_get21x21(img,x,y,z,c,I,T) \
 I[0] = (T)(img)(_p10##x,_p10##y,z,c), I[1] = (T)(img)(_p9##x,_p10##y,z,c), I[2] = (T)(img)(_p8##x,_p10##y,z,c), I[3] = (T)(img)(_p7##x,_p10##y,z,c), I[4] = (T)(img)(_p6##x,_p10##y,z,c), I[5] = (T)(img)(_p5##x,_p10##y,z,c), I[6] = (T)(img)(_p4##x,_p10##y,z,c), I[7] = (T)(img)(_p3##x,_p10##y,z,c), I[8] = (T)(img)(_p2##x,_p10##y,z,c), I[9] = (T)(img)(_p1##x,_p10##y,z,c), I[10] = (T)(img)(x,_p10##y,z,c), I[11] = (T)(img)(_n1##x,_p10##y,z,c), I[12] = (T)(img)(_n2##x,_p10##y,z,c), I[13] = (T)(img)(_n3##x,_p10##y,z,c), I[14] = (T)(img)(_n4##x,_p10##y,z,c), I[15] = (T)(img)(_n5##x,_p10##y,z,c), I[16] = (T)(img)(_n6##x,_p10##y,z,c), I[17] = (T)(img)(_n7##x,_p10##y,z,c), I[18] = (T)(img)(_n8##x,_p10##y,z,c), I[19] = (T)(img)(_n9##x,_p10##y,z,c), I[20] = (T)(img)(_n10##x,_p10##y,z,c), \
 I[21] = (T)(img)(_p10##x,_p9##y,z,c), I[22] = (T)(img)(_p9##x,_p9##y,z,c), I[23] = (T)(img)(_p8##x,_p9##y,z,c), I[24] = (T)(img)(_p7##x,_p9##y,z,c), I[25] = (T)(img)(_p6##x,_p9##y,z,c), I[26] = (T)(img)(_p5##x,_p9##y,z,c), I[27] = (T)(img)(_p4##x,_p9##y,z,c), I[28] = (T)(img)(_p3##x,_p9##y,z,c), I[29] = (T)(img)(_p2##x,_p9##y,z,c), I[30] = (T)(img)(_p1##x,_p9##y,z,c), I[31] = (T)(img)(x,_p9##y,z,c), I[32] = (T)(img)(_n1##x,_p9##y,z,c), I[33] = (T)(img)(_n2##x,_p9##y,z,c), I[34] = (T)(img)(_n3##x,_p9##y,z,c), I[35] = (T)(img)(_n4##x,_p9##y,z,c), I[36] = (T)(img)(_n5##x,_p9##y,z,c), I[37] = (T)(img)(_n6##x,_p9##y,z,c), I[38] = (T)(img)(_n7##x,_p9##y,z,c), I[39] = (T)(img)(_n8##x,_p9##y,z,c), I[40] = (T)(img)(_n9##x,_p9##y,z,c), I[41] = (T)(img)(_n10##x,_p9##y,z,c), \
 I[42] = (T)(img)(_p10##x,_p8##y,z,c), I[43] = (T)(img)(_p9##x,_p8##y,z,c), I[44] = (T)(img)(_p8##x,_p8##y,z,c), I[45] = (T)(img)(_p7##x,_p8##y,z,c), I[46] = (T)(img)(_p6##x,_p8##y,z,c), I[47] = (T)(img)(_p5##x,_p8##y,z,c), I[48] = (T)(img)(_p4##x,_p8##y,z,c), I[49] = (T)(img)(_p3##x,_p8##y,z,c), I[50] = (T)(img)(_p2##x,_p8##y,z,c), I[51] = (T)(img)(_p1##x,_p8##y,z,c), I[52] = (T)(img)(x,_p8##y,z,c), I[53] = (T)(img)(_n1##x,_p8##y,z,c), I[54] = (T)(img)(_n2##x,_p8##y,z,c), I[55] = (T)(img)(_n3##x,_p8##y,z,c), I[56] = (T)(img)(_n4##x,_p8##y,z,c), I[57] = (T)(img)(_n5##x,_p8##y,z,c), I[58] = (T)(img)(_n6##x,_p8##y,z,c), I[59] = (T)(img)(_n7##x,_p8##y,z,c), I[60] = (T)(img)(_n8##x,_p8##y,z,c), I[61] = (T)(img)(_n9##x,_p8##y,z,c), I[62] = (T)(img)(_n10##x,_p8##y,z,c), \
 I[63] = (T)(img)(_p10##x,_p7##y,z,c), I[64] = (T)(img)(_p9##x,_p7##y,z,c), I[65] = (T)(img)(_p8##x,_p7##y,z,c), I[66] = (T)(img)(_p7##x,_p7##y,z,c), I[67] = (T)(img)(_p6##x,_p7##y,z,c), I[68] = (T)(img)(_p5##x,_p7##y,z,c), I[69] = (T)(img)(_p4##x,_p7##y,z,c), I[70] = (T)(img)(_p3##x,_p7##y,z,c), I[71] = (T)(img)(_p2##x,_p7##y,z,c), I[72] = (T)(img)(_p1##x,_p7##y,z,c), I[73] = (T)(img)(x,_p7##y,z,c), I[74] = (T)(img)(_n1##x,_p7##y,z,c), I[75] = (T)(img)(_n2##x,_p7##y,z,c), I[76] = (T)(img)(_n3##x,_p7##y,z,c), I[77] = (T)(img)(_n4##x,_p7##y,z,c), I[78] = (T)(img)(_n5##x,_p7##y,z,c), I[79] = (T)(img)(_n6##x,_p7##y,z,c), I[80] = (T)(img)(_n7##x,_p7##y,z,c), I[81] = (T)(img)(_n8##x,_p7##y,z,c), I[82] = (T)(img)(_n9##x,_p7##y,z,c), I[83] = (T)(img)(_n10##x,_p7##y,z,c), \
 I[84] = (T)(img)(_p10##x,_p6##y,z,c), I[85] = (T)(img)(_p9##x,_p6##y,z,c), I[86] = (T)(img)(_p8##x,_p6##y,z,c), I[87] = (T)(img)(_p7##x,_p6##y,z,c), I[88] = (T)(img)(_p6##x,_p6##y,z,c), I[89] = (T)(img)(_p5##x,_p6##y,z,c), I[90] = (T)(img)(_p4##x,_p6##y,z,c), I[91] = (T)(img)(_p3##x,_p6##y,z,c), I[92] = (T)(img)(_p2##x,_p6##y,z,c), I[93] = (T)(img)(_p1##x,_p6##y,z,c), I[94] = (T)(img)(x,_p6##y,z,c), I[95] = (T)(img)(_n1##x,_p6##y,z,c), I[96] = (T)(img)(_n2##x,_p6##y,z,c), I[97] = (T)(img)(_n3##x,_p6##y,z,c), I[98] = (T)(img)(_n4##x,_p6##y,z,c), I[99] = (T)(img)(_n5##x,_p6##y,z,c), I[100] = (T)(img)(_n6##x,_p6##y,z,c), I[101] = (T)(img)(_n7##x,_p6##y,z,c), I[102] = (T)(img)(_n8##x,_p6##y,z,c), I[103] = (T)(img)(_n9##x,_p6##y,z,c), I[104] = (T)(img)(_n10##x,_p6##y,z,c), \
 I[105] = (T)(img)(_p10##x,_p5##y,z,c), I[106] = (T)(img)(_p9##x,_p5##y,z,c), I[107] = (T)(img)(_p8##x,_p5##y,z,c), I[108] = (T)(img)(_p7##x,_p5##y,z,c), I[109] = (T)(img)(_p6##x,_p5##y,z,c), I[110] = (T)(img)(_p5##x,_p5##y,z,c), I[111] = (T)(img)(_p4##x,_p5##y,z,c), I[112] = (T)(img)(_p3##x,_p5##y,z,c), I[113] = (T)(img)(_p2##x,_p5##y,z,c), I[114] = (T)(img)(_p1##x,_p5##y,z,c), I[115] = (T)(img)(x,_p5##y,z,c), I[116] = (T)(img)(_n1##x,_p5##y,z,c), I[117] = (T)(img)(_n2##x,_p5##y,z,c), I[118] = (T)(img)(_n3##x,_p5##y,z,c), I[119] = (T)(img)(_n4##x,_p5##y,z,c), I[120] = (T)(img)(_n5##x,_p5##y,z,c), I[121] = (T)(img)(_n6##x,_p5##y,z,c), I[122] = (T)(img)(_n7##x,_p5##y,z,c), I[123] = (T)(img)(_n8##x,_p5##y,z,c), I[124] = (T)(img)(_n9##x,_p5##y,z,c), I[125] = (T)(img)(_n10##x,_p5##y,z,c), \
 I[126] = (T)(img)(_p10##x,_p4##y,z,c), I[127] = (T)(img)(_p9##x,_p4##y,z,c), I[128] = (T)(img)(_p8##x,_p4##y,z,c), I[129] = (T)(img)(_p7##x,_p4##y,z,c), I[130] = (T)(img)(_p6##x,_p4##y,z,c), I[131] = (T)(img)(_p5##x,_p4##y,z,c), I[132] = (T)(img)(_p4##x,_p4##y,z,c), I[133] = (T)(img)(_p3##x,_p4##y,z,c), I[134] = (T)(img)(_p2##x,_p4##y,z,c), I[135] = (T)(img)(_p1##x,_p4##y,z,c), I[136] = (T)(img)(x,_p4##y,z,c), I[137] = (T)(img)(_n1##x,_p4##y,z,c), I[138] = (T)(img)(_n2##x,_p4##y,z,c), I[139] = (T)(img)(_n3##x,_p4##y,z,c), I[140] = (T)(img)(_n4##x,_p4##y,z,c), I[141] = (T)(img)(_n5##x,_p4##y,z,c), I[142] = (T)(img)(_n6##x,_p4##y,z,c), I[143] = (T)(img)(_n7##x,_p4##y,z,c), I[144] = (T)(img)(_n8##x,_p4##y,z,c), I[145] = (T)(img)(_n9##x,_p4##y,z,c), I[146] = (T)(img)(_n10##x,_p4##y,z,c), \
 I[147] = (T)(img)(_p10##x,_p3##y,z,c), I[148] = (T)(img)(_p9##x,_p3##y,z,c), I[149] = (T)(img)(_p8##x,_p3##y,z,c), I[150] = (T)(img)(_p7##x,_p3##y,z,c), I[151] = (T)(img)(_p6##x,_p3##y,z,c), I[152] = (T)(img)(_p5##x,_p3##y,z,c), I[153] = (T)(img)(_p4##x,_p3##y,z,c), I[154] = (T)(img)(_p3##x,_p3##y,z,c), I[155] = (T)(img)(_p2##x,_p3##y,z,c), I[156] = (T)(img)(_p1##x,_p3##y,z,c), I[157] = (T)(img)(x,_p3##y,z,c), I[158] = (T)(img)(_n1##x,_p3##y,z,c), I[159] = (T)(img)(_n2##x,_p3##y,z,c), I[160] = (T)(img)(_n3##x,_p3##y,z,c), I[161] = (T)(img)(_n4##x,_p3##y,z,c), I[162] = (T)(img)(_n5##x,_p3##y,z,c), I[163] = (T)(img)(_n6##x,_p3##y,z,c), I[164] = (T)(img)(_n7##x,_p3##y,z,c), I[165] = (T)(img)(_n8##x,_p3##y,z,c), I[166] = (T)(img)(_n9##x,_p3##y,z,c), I[167] = (T)(img)(_n10##x,_p3##y,z,c), \
 I[168] = (T)(img)(_p10##x,_p2##y,z,c), I[169] = (T)(img)(_p9##x,_p2##y,z,c), I[170] = (T)(img)(_p8##x,_p2##y,z,c), I[171] = (T)(img)(_p7##x,_p2##y,z,c), I[172] = (T)(img)(_p6##x,_p2##y,z,c), I[173] = (T)(img)(_p5##x,_p2##y,z,c), I[174] = (T)(img)(_p4##x,_p2##y,z,c), I[175] = (T)(img)(_p3##x,_p2##y,z,c), I[176] = (T)(img)(_p2##x,_p2##y,z,c), I[177] = (T)(img)(_p1##x,_p2##y,z,c), I[178] = (T)(img)(x,_p2##y,z,c), I[179] = (T)(img)(_n1##x,_p2##y,z,c), I[180] = (T)(img)(_n2##x,_p2##y,z,c), I[181] = (T)(img)(_n3##x,_p2##y,z,c), I[182] = (T)(img)(_n4##x,_p2##y,z,c), I[183] = (T)(img)(_n5##x,_p2##y,z,c), I[184] = (T)(img)(_n6##x,_p2##y,z,c), I[185] = (T)(img)(_n7##x,_p2##y,z,c), I[186] = (T)(img)(_n8##x,_p2##y,z,c), I[187] = (T)(img)(_n9##x,_p2##y,z,c), I[188] = (T)(img)(_n10##x,_p2##y,z,c), \
 I[189] = (T)(img)(_p10##x,_p1##y,z,c), I[190] = (T)(img)(_p9##x,_p1##y,z,c), I[191] = (T)(img)(_p8##x,_p1##y,z,c), I[192] = (T)(img)(_p7##x,_p1##y,z,c), I[193] = (T)(img)(_p6##x,_p1##y,z,c), I[194] = (T)(img)(_p5##x,_p1##y,z,c), I[195] = (T)(img)(_p4##x,_p1##y,z,c), I[196] = (T)(img)(_p3##x,_p1##y,z,c), I[197] = (T)(img)(_p2##x,_p1##y,z,c), I[198] = (T)(img)(_p1##x,_p1##y,z,c), I[199] = (T)(img)(x,_p1##y,z,c), I[200] = (T)(img)(_n1##x,_p1##y,z,c), I[201] = (T)(img)(_n2##x,_p1##y,z,c), I[202] = (T)(img)(_n3##x,_p1##y,z,c), I[203] = (T)(img)(_n4##x,_p1##y,z,c), I[204] = (T)(img)(_n5##x,_p1##y,z,c), I[205] = (T)(img)(_n6##x,_p1##y,z,c), I[206] = (T)(img)(_n7##x,_p1##y,z,c), I[207] = (T)(img)(_n8##x,_p1##y,z,c), I[208] = (T)(img)(_n9##x,_p1##y,z,c), I[209] = (T)(img)(_n10##x,_p1##y,z,c), \
 I[210] = (T)(img)(_p10##x,y,z,c), I[211] = (T)(img)(_p9##x,y,z,c), I[212] = (T)(img)(_p8##x,y,z,c), I[213] = (T)(img)(_p7##x,y,z,c), I[214] = (T)(img)(_p6##x,y,z,c), I[215] = (T)(img)(_p5##x,y,z,c), I[216] = (T)(img)(_p4##x,y,z,c), I[217] = (T)(img)(_p3##x,y,z,c), I[218] = (T)(img)(_p2##x,y,z,c), I[219] = (T)(img)(_p1##x,y,z,c), I[220] = (T)(img)(x,y,z,c), I[221] = (T)(img)(_n1##x,y,z,c), I[222] = (T)(img)(_n2##x,y,z,c), I[223] = (T)(img)(_n3##x,y,z,c), I[224] = (T)(img)(_n4##x,y,z,c), I[225] = (T)(img)(_n5##x,y,z,c), I[226] = (T)(img)(_n6##x,y,z,c), I[227] = (T)(img)(_n7##x,y,z,c), I[228] = (T)(img)(_n8##x,y,z,c), I[229] = (T)(img)(_n9##x,y,z,c), I[230] = (T)(img)(_n10##x,y,z,c), \
 I[231] = (T)(img)(_p10##x,_n1##y,z,c), I[232] = (T)(img)(_p9##x,_n1##y,z,c), I[233] = (T)(img)(_p8##x,_n1##y,z,c), I[234] = (T)(img)(_p7##x,_n1##y,z,c), I[235] = (T)(img)(_p6##x,_n1##y,z,c), I[236] = (T)(img)(_p5##x,_n1##y,z,c), I[237] = (T)(img)(_p4##x,_n1##y,z,c), I[238] = (T)(img)(_p3##x,_n1##y,z,c), I[239] = (T)(img)(_p2##x,_n1##y,z,c), I[240] = (T)(img)(_p1##x,_n1##y,z,c), I[241] = (T)(img)(x,_n1##y,z,c), I[242] = (T)(img)(_n1##x,_n1##y,z,c), I[243] = (T)(img)(_n2##x,_n1##y,z,c), I[244] = (T)(img)(_n3##x,_n1##y,z,c), I[245] = (T)(img)(_n4##x,_n1##y,z,c), I[246] = (T)(img)(_n5##x,_n1##y,z,c), I[247] = (T)(img)(_n6##x,_n1##y,z,c), I[248] = (T)(img)(_n7##x,_n1##y,z,c), I[249] = (T)(img)(_n8##x,_n1##y,z,c), I[250] = (T)(img)(_n9##x,_n1##y,z,c), I[251] = (T)(img)(_n10##x,_n1##y,z,c), \
 I[252] = (T)(img)(_p10##x,_n2##y,z,c), I[253] = (T)(img)(_p9##x,_n2##y,z,c), I[254] = (T)(img)(_p8##x,_n2##y,z,c), I[255] = (T)(img)(_p7##x,_n2##y,z,c), I[256] = (T)(img)(_p6##x,_n2##y,z,c), I[257] = (T)(img)(_p5##x,_n2##y,z,c), I[258] = (T)(img)(_p4##x,_n2##y,z,c), I[259] = (T)(img)(_p3##x,_n2##y,z,c), I[260] = (T)(img)(_p2##x,_n2##y,z,c), I[261] = (T)(img)(_p1##x,_n2##y,z,c), I[262] = (T)(img)(x,_n2##y,z,c), I[263] = (T)(img)(_n1##x,_n2##y,z,c), I[264] = (T)(img)(_n2##x,_n2##y,z,c), I[265] = (T)(img)(_n3##x,_n2##y,z,c), I[266] = (T)(img)(_n4##x,_n2##y,z,c), I[267] = (T)(img)(_n5##x,_n2##y,z,c), I[268] = (T)(img)(_n6##x,_n2##y,z,c), I[269] = (T)(img)(_n7##x,_n2##y,z,c), I[270] = (T)(img)(_n8##x,_n2##y,z,c), I[271] = (T)(img)(_n9##x,_n2##y,z,c), I[272] = (T)(img)(_n10##x,_n2##y,z,c), \
 I[273] = (T)(img)(_p10##x,_n3##y,z,c), I[274] = (T)(img)(_p9##x,_n3##y,z,c), I[275] = (T)(img)(_p8##x,_n3##y,z,c), I[276] = (T)(img)(_p7##x,_n3##y,z,c), I[277] = (T)(img)(_p6##x,_n3##y,z,c), I[278] = (T)(img)(_p5##x,_n3##y,z,c), I[279] = (T)(img)(_p4##x,_n3##y,z,c), I[280] = (T)(img)(_p3##x,_n3##y,z,c), I[281] = (T)(img)(_p2##x,_n3##y,z,c), I[282] = (T)(img)(_p1##x,_n3##y,z,c), I[283] = (T)(img)(x,_n3##y,z,c), I[284] = (T)(img)(_n1##x,_n3##y,z,c), I[285] = (T)(img)(_n2##x,_n3##y,z,c), I[286] = (T)(img)(_n3##x,_n3##y,z,c), I[287] = (T)(img)(_n4##x,_n3##y,z,c), I[288] = (T)(img)(_n5##x,_n3##y,z,c), I[289] = (T)(img)(_n6##x,_n3##y,z,c), I[290] = (T)(img)(_n7##x,_n3##y,z,c), I[291] = (T)(img)(_n8##x,_n3##y,z,c), I[292] = (T)(img)(_n9##x,_n3##y,z,c), I[293] = (T)(img)(_n10##x,_n3##y,z,c), \
 I[294] = (T)(img)(_p10##x,_n4##y,z,c), I[295] = (T)(img)(_p9##x,_n4##y,z,c), I[296] = (T)(img)(_p8##x,_n4##y,z,c), I[297] = (T)(img)(_p7##x,_n4##y,z,c), I[298] = (T)(img)(_p6##x,_n4##y,z,c), I[299] = (T)(img)(_p5##x,_n4##y,z,c), I[300] = (T)(img)(_p4##x,_n4##y,z,c), I[301] = (T)(img)(_p3##x,_n4##y,z,c), I[302] = (T)(img)(_p2##x,_n4##y,z,c), I[303] = (T)(img)(_p1##x,_n4##y,z,c), I[304] = (T)(img)(x,_n4##y,z,c), I[305] = (T)(img)(_n1##x,_n4##y,z,c), I[306] = (T)(img)(_n2##x,_n4##y,z,c), I[307] = (T)(img)(_n3##x,_n4##y,z,c), I[308] = (T)(img)(_n4##x,_n4##y,z,c), I[309] = (T)(img)(_n5##x,_n4##y,z,c), I[310] = (T)(img)(_n6##x,_n4##y,z,c), I[311] = (T)(img)(_n7##x,_n4##y,z,c), I[312] = (T)(img)(_n8##x,_n4##y,z,c), I[313] = (T)(img)(_n9##x,_n4##y,z,c), I[314] = (T)(img)(_n10##x,_n4##y,z,c), \
 I[315] = (T)(img)(_p10##x,_n5##y,z,c), I[316] = (T)(img)(_p9##x,_n5##y,z,c), I[317] = (T)(img)(_p8##x,_n5##y,z,c), I[318] = (T)(img)(_p7##x,_n5##y,z,c), I[319] = (T)(img)(_p6##x,_n5##y,z,c), I[320] = (T)(img)(_p5##x,_n5##y,z,c), I[321] = (T)(img)(_p4##x,_n5##y,z,c), I[322] = (T)(img)(_p3##x,_n5##y,z,c), I[323] = (T)(img)(_p2##x,_n5##y,z,c), I[324] = (T)(img)(_p1##x,_n5##y,z,c), I[325] = (T)(img)(x,_n5##y,z,c), I[326] = (T)(img)(_n1##x,_n5##y,z,c), I[327] = (T)(img)(_n2##x,_n5##y,z,c), I[328] = (T)(img)(_n3##x,_n5##y,z,c), I[329] = (T)(img)(_n4##x,_n5##y,z,c), I[330] = (T)(img)(_n5##x,_n5##y,z,c), I[331] = (T)(img)(_n6##x,_n5##y,z,c), I[332] = (T)(img)(_n7##x,_n5##y,z,c), I[333] = (T)(img)(_n8##x,_n5##y,z,c), I[334] = (T)(img)(_n9##x,_n5##y,z,c), I[335] = (T)(img)(_n10##x,_n5##y,z,c), \
 I[336] = (T)(img)(_p10##x,_n6##y,z,c), I[337] = (T)(img)(_p9##x,_n6##y,z,c), I[338] = (T)(img)(_p8##x,_n6##y,z,c), I[339] = (T)(img)(_p7##x,_n6##y,z,c), I[340] = (T)(img)(_p6##x,_n6##y,z,c), I[341] = (T)(img)(_p5##x,_n6##y,z,c), I[342] = (T)(img)(_p4##x,_n6##y,z,c), I[343] = (T)(img)(_p3##x,_n6##y,z,c), I[344] = (T)(img)(_p2##x,_n6##y,z,c), I[345] = (T)(img)(_p1##x,_n6##y,z,c), I[346] = (T)(img)(x,_n6##y,z,c), I[347] = (T)(img)(_n1##x,_n6##y,z,c), I[348] = (T)(img)(_n2##x,_n6##y,z,c), I[349] = (T)(img)(_n3##x,_n6##y,z,c), I[350] = (T)(img)(_n4##x,_n6##y,z,c), I[351] = (T)(img)(_n5##x,_n6##y,z,c), I[352] = (T)(img)(_n6##x,_n6##y,z,c), I[353] = (T)(img)(_n7##x,_n6##y,z,c), I[354] = (T)(img)(_n8##x,_n6##y,z,c), I[355] = (T)(img)(_n9##x,_n6##y,z,c), I[356] = (T)(img)(_n10##x,_n6##y,z,c), \
 I[357] = (T)(img)(_p10##x,_n7##y,z,c), I[358] = (T)(img)(_p9##x,_n7##y,z,c), I[359] = (T)(img)(_p8##x,_n7##y,z,c), I[360] = (T)(img)(_p7##x,_n7##y,z,c), I[361] = (T)(img)(_p6##x,_n7##y,z,c), I[362] = (T)(img)(_p5##x,_n7##y,z,c), I[363] = (T)(img)(_p4##x,_n7##y,z,c), I[364] = (T)(img)(_p3##x,_n7##y,z,c), I[365] = (T)(img)(_p2##x,_n7##y,z,c), I[366] = (T)(img)(_p1##x,_n7##y,z,c), I[367] = (T)(img)(x,_n7##y,z,c), I[368] = (T)(img)(_n1##x,_n7##y,z,c), I[369] = (T)(img)(_n2##x,_n7##y,z,c), I[370] = (T)(img)(_n3##x,_n7##y,z,c), I[371] = (T)(img)(_n4##x,_n7##y,z,c), I[372] = (T)(img)(_n5##x,_n7##y,z,c), I[373] = (T)(img)(_n6##x,_n7##y,z,c), I[374] = (T)(img)(_n7##x,_n7##y,z,c), I[375] = (T)(img)(_n8##x,_n7##y,z,c), I[376] = (T)(img)(_n9##x,_n7##y,z,c), I[377] = (T)(img)(_n10##x,_n7##y,z,c), \
 I[378] = (T)(img)(_p10##x,_n8##y,z,c), I[379] = (T)(img)(_p9##x,_n8##y,z,c), I[380] = (T)(img)(_p8##x,_n8##y,z,c), I[381] = (T)(img)(_p7##x,_n8##y,z,c), I[382] = (T)(img)(_p6##x,_n8##y,z,c), I[383] = (T)(img)(_p5##x,_n8##y,z,c), I[384] = (T)(img)(_p4##x,_n8##y,z,c), I[385] = (T)(img)(_p3##x,_n8##y,z,c), I[386] = (T)(img)(_p2##x,_n8##y,z,c), I[387] = (T)(img)(_p1##x,_n8##y,z,c), I[388] = (T)(img)(x,_n8##y,z,c), I[389] = (T)(img)(_n1##x,_n8##y,z,c), I[390] = (T)(img)(_n2##x,_n8##y,z,c), I[391] = (T)(img)(_n3##x,_n8##y,z,c), I[392] = (T)(img)(_n4##x,_n8##y,z,c), I[393] = (T)(img)(_n5##x,_n8##y,z,c), I[394] = (T)(img)(_n6##x,_n8##y,z,c), I[395] = (T)(img)(_n7##x,_n8##y,z,c), I[396] = (T)(img)(_n8##x,_n8##y,z,c), I[397] = (T)(img)(_n9##x,_n8##y,z,c), I[398] = (T)(img)(_n10##x,_n8##y,z,c), \
 I[399] = (T)(img)(_p10##x,_n9##y,z,c), I[400] = (T)(img)(_p9##x,_n9##y,z,c), I[401] = (T)(img)(_p8##x,_n9##y,z,c), I[402] = (T)(img)(_p7##x,_n9##y,z,c), I[403] = (T)(img)(_p6##x,_n9##y,z,c), I[404] = (T)(img)(_p5##x,_n9##y,z,c), I[405] = (T)(img)(_p4##x,_n9##y,z,c), I[406] = (T)(img)(_p3##x,_n9##y,z,c), I[407] = (T)(img)(_p2##x,_n9##y,z,c), I[408] = (T)(img)(_p1##x,_n9##y,z,c), I[409] = (T)(img)(x,_n9##y,z,c), I[410] = (T)(img)(_n1##x,_n9##y,z,c), I[411] = (T)(img)(_n2##x,_n9##y,z,c), I[412] = (T)(img)(_n3##x,_n9##y,z,c), I[413] = (T)(img)(_n4##x,_n9##y,z,c), I[414] = (T)(img)(_n5##x,_n9##y,z,c), I[415] = (T)(img)(_n6##x,_n9##y,z,c), I[416] = (T)(img)(_n7##x,_n9##y,z,c), I[417] = (T)(img)(_n8##x,_n9##y,z,c), I[418] = (T)(img)(_n9##x,_n9##y,z,c), I[419] = (T)(img)(_n10##x,_n9##y,z,c), \
 I[420] = (T)(img)(_p10##x,_n10##y,z,c), I[421] = (T)(img)(_p9##x,_n10##y,z,c), I[422] = (T)(img)(_p8##x,_n10##y,z,c), I[423] = (T)(img)(_p7##x,_n10##y,z,c), I[424] = (T)(img)(_p6##x,_n10##y,z,c), I[425] = (T)(img)(_p5##x,_n10##y,z,c), I[426] = (T)(img)(_p4##x,_n10##y,z,c), I[427] = (T)(img)(_p3##x,_n10##y,z,c), I[428] = (T)(img)(_p2##x,_n10##y,z,c), I[429] = (T)(img)(_p1##x,_n10##y,z,c), I[430] = (T)(img)(x,_n10##y,z,c), I[431] = (T)(img)(_n1##x,_n10##y,z,c), I[432] = (T)(img)(_n2##x,_n10##y,z,c), I[433] = (T)(img)(_n3##x,_n10##y,z,c), I[434] = (T)(img)(_n4##x,_n10##y,z,c), I[435] = (T)(img)(_n5##x,_n10##y,z,c), I[436] = (T)(img)(_n6##x,_n10##y,z,c), I[437] = (T)(img)(_n7##x,_n10##y,z,c), I[438] = (T)(img)(_n8##x,_n10##y,z,c), I[439] = (T)(img)(_n9##x,_n10##y,z,c), I[440] = (T)(img)(_n10##x,_n10##y,z,c);

// Define 22x22 loop macros
//-------------------------
#define cimg_for22(bound,i) for (int i = 0, \
 _p10##i = 0, _p9##i = 0, _p8##i = 0, _p7##i = 0, _p6##i = 0, _p5##i = 0, _p4##i = 0, _p3##i = 0, _p2##i = 0, _p1##i = 0, \
 _n1##i = 1>=(int)(bound)?(int)(bound)-1:1, \
 _n2##i = 2>=(int)(bound)?(int)(bound)-1:2, \
 _n3##i = 3>=(int)(bound)?(int)(bound)-1:3, \
 _n4##i = 4>=(int)(bound)?(int)(bound)-1:4, \
 _n5##i = 5>=(int)(bound)?(int)(bound)-1:5, \
 _n6##i = 6>=(int)(bound)?(int)(bound)-1:6, \
 _n7##i = 7>=(int)(bound)?(int)(bound)-1:7, \
 _n8##i = 8>=(int)(bound)?(int)(bound)-1:8, \
 _n9##i = 9>=(int)(bound)?(int)(bound)-1:9, \
 _n10##i = 10>=(int)(bound)?(int)(bound)-1:10, \
 _n11##i = 11>=(int)(bound)?(int)(bound)-1:11; \
 _n11##i<(int)(bound) || _n10##i==--_n11##i || _n9##i==--_n10##i || _n8##i==--_n9##i || _n7##i==--_n8##i || _n6##i==--_n7##i || _n5##i==--_n6##i || _n4##i==--_n5##i || _n3##i==--_n4##i || _n2##i==--_n3##i || _n1##i==--_n2##i || \
 i==(_n11##i = _n10##i = _n9##i = _n8##i = _n7##i = _n6##i = _n5##i = _n4##i = _n3##i = _n2##i = --_n1##i); \
 _p10##i = _p9##i, _p9##i = _p8##i, _p8##i = _p7##i, _p7##i = _p6##i, _p6##i = _p5##i, _p5##i = _p4##i, _p4##i = _p3##i, _p3##i = _p2##i, _p2##i = _p1##i, _p1##i = i++, \
 ++_n1##i, ++_n2##i, ++_n3##i, ++_n4##i, ++_n5##i, ++_n6##i, ++_n7##i, ++_n8##i, ++_n9##i, ++_n10##i, ++_n11##i)

#define cimg_for22X(img,x) cimg_for22((img)._width,x)
#define cimg_for22Y(img,y) cimg_for22((img)._height,y)
#define cimg_for22Z(img,z) cimg_for22((img)._depth,z)
#define cimg_for22C(img,c) cimg_for22((img)._spectrum,c)
#define cimg_for22XY(img,x,y) cimg_for22Y(img,y) cimg_for22X(img,x)
#define cimg_for22XZ(img,x,z) cimg_for22Z(img,z) cimg_for22X(img,x)
#define cimg_for22XC(img,x,c) cimg_for22C(img,c) cimg_for22X(img,x)
#define cimg_for22YZ(img,y,z) cimg_for22Z(img,z) cimg_for22Y(img,y)
#define cimg_for22YC(img,y,c) cimg_for22C(img,c) cimg_for22Y(img,y)
#define cimg_for22ZC(img,z,c) cimg_for22C(img,c) cimg_for22Z(img,z)
#define cimg_for22XYZ(img,x,y,z) cimg_for22Z(img,z) cimg_for22XY(img,x,y)
#define cimg_for22XZC(img,x,z,c) cimg_for22C(img,c) cimg_for22XZ(img,x,z)
#define cimg_for22YZC(img,y,z,c) cimg_for22C(img,c) cimg_for22YZ(img,y,z)
#define cimg_for22XYZC(img,x,y,z,c) cimg_for22C(img,c) cimg_for22XYZ(img,x,y,z)

#define cimg_for_in22(bound,i0,i1,i) for (int i = (int)(i0)<0?0:(int)(i0), \
 _p10##i = i-10<0?0:i-10, \
 _p9##i = i-9<0?0:i-9, \
 _p8##i = i-8<0?0:i-8, \
 _p7##i = i-7<0?0:i-7, \
 _p6##i = i-6<0?0:i-6, \
 _p5##i = i-5<0?0:i-5, \
 _p4##i = i-4<0?0:i-4, \
 _p3##i = i-3<0?0:i-3, \
 _p2##i = i-2<0?0:i-2, \
 _p1##i = i-1<0?0:i-1, \
 _n1##i = i+1>=(int)(bound)?(int)(bound)-1:i+1, \
 _n2##i = i+2>=(int)(bound)?(int)(bound)-1:i+2, \
 _n3##i = i+3>=(int)(bound)?(int)(bound)-1:i+3, \
 _n4##i = i+4>=(int)(bound)?(int)(bound)-1:i+4, \
 _n5##i = i+5>=(int)(bound)?(int)(bound)-1:i+5, \
 _n6##i = i+6>=(int)(bound)?(int)(bound)-1:i+6, \
 _n7##i = i+7>=(int)(bound)?(int)(bound)-1:i+7, \
 _n8##i = i+8>=(int)(bound)?(int)(bound)-1:i+8, \
 _n9##i = i+9>=(int)(bound)?(int)(bound)-1:i+9, \
 _n10##i = i+10>=(int)(bound)?(int)(bound)-1:i+10, \
 _n11##i = i+11>=(int)(bound)?(int)(bound)-1:i+11; \
 i<=(int)(i1) && (_n11##i<(int)(bound) || _n10##i==--_n11##i || _n9##i==--_n10##i || _n8##i==--_n9##i || _n7##i==--_n8##i || _n6##i==--_n7##i || _n5##i==--_n6##i || _n4##i==--_n5##i || _n3##i==--_n4##i || _n2##i==--_n3##i || _n1##i==--_n2##i || \
 i==(_n11##i = _n10##i = _n9##i = _n8##i = _n7##i = _n6##i = _n5##i = _n4##i = _n3##i = _n2##i = --_n1##i)); \
 _p10##i = _p9##i, _p9##i = _p8##i, _p8##i = _p7##i, _p7##i = _p6##i, _p6##i = _p5##i, _p5##i = _p4##i, _p4##i = _p3##i, _p3##i = _p2##i, _p2##i = _p1##i, _p1##i = i++, \
 ++_n1##i, ++_n2##i, ++_n3##i, ++_n4##i, ++_n5##i, ++_n6##i, ++_n7##i, ++_n8##i, ++_n9##i, ++_n10##i, ++_n11##i)

#define cimg_for_in22X(img,x0,x1,x) cimg_for_in22((img)._width,x0,x1,x)
#define cimg_for_in22Y(img,y0,y1,y) cimg_for_in22((img)._height,y0,y1,y)
#define cimg_for_in22Z(img,z0,z1,z) cimg_for_in22((img)._depth,z0,z1,z)
#define cimg_for_in22C(img,c0,c1,c) cimg_for_in22((img)._spectrum,c0,c1,c)
#define cimg_for_in22XY(img,x0,y0,x1,y1,x,y) cimg_for_in22Y(img,y0,y1,y) cimg_for_in22X(img,x0,x1,x)
#define cimg_for_in22XZ(img,x0,z0,x1,z1,x,z) cimg_for_in22Z(img,z0,z1,z) cimg_for_in22X(img,x0,x1,x)
#define cimg_for_in22XC(img,x0,c0,x1,c1,x,c) cimg_for_in22C(img,c0,c1,c) cimg_for_in22X(img,x0,x1,x)
#define cimg_for_in22YZ(img,y0,z0,y1,z1,y,z) cimg_for_in22Z(img,z0,z1,z) cimg_for_in22Y(img,y0,y1,y)
#define cimg_for_in22YC(img,y0,c0,y1,c1,y,c) cimg_for_in22C(img,c0,c1,c) cimg_for_in22Y(img,y0,y1,y)
#define cimg_for_in22ZC(img,z0,c0,z1,c1,z,c) cimg_for_in22C(img,c0,c1,c) cimg_for_in22Z(img,z0,z1,z)
#define cimg_for_in22XYZ(img,x0,y0,z0,x1,y1,z1,x,y,z) cimg_for_in22Z(img,z0,z1,z) cimg_for_in22XY(img,x0,y0,x1,y1,x,y)
#define cimg_for_in22XZC(img,x0,z0,c0,x1,y1,c1,x,z,c) cimg_for_in22C(img,c0,c1,c) cimg_for_in22XZ(img,x0,y0,x1,y1,x,z)
#define cimg_for_in22YZC(img,y0,z0,c0,y1,z1,c1,y,z,c) cimg_for_in22C(img,c0,c1,c) cimg_for_in22YZ(img,y0,z0,y1,z1,y,z)
#define cimg_for_in22XYZC(img,x0,y0,z0,c0,x1,y1,z1,c1,x,y,z,c) cimg_for_in22C(img,c0,c1,c) cimg_for_in22XYZ(img,x0,y0,z0,x1,y1,z1,x,y,z)

#define cimg_for22x22(img,x,y,z,c,I,T) \
 cimg_for22((img)._height,y) for (int x = 0, \
 _p10##x = 0, _p9##x = 0, _p8##x = 0, _p7##x = 0, _p6##x = 0, _p5##x = 0, _p4##x = 0, _p3##x = 0, _p2##x = 0, _p1##x = 0, \
 _n1##x = 1>=((img)._width)?(img).width()-1:1, \
 _n2##x = 2>=((img)._width)?(img).width()-1:2, \
 _n3##x = 3>=((img)._width)?(img).width()-1:3, \
 _n4##x = 4>=((img)._width)?(img).width()-1:4, \
 _n5##x = 5>=((img)._width)?(img).width()-1:5, \
 _n6##x = 6>=((img)._width)?(img).width()-1:6, \
 _n7##x = 7>=((img)._width)?(img).width()-1:7, \
 _n8##x = 8>=((img)._width)?(img).width()-1:8, \
 _n9##x = 9>=((img)._width)?(img).width()-1:9, \
 _n10##x = 10>=((img)._width)?(img).width()-1:10, \
 _n11##x = (int)( \
 (I[0] = I[1] = I[2] = I[3] = I[4] = I[5] = I[6] = I[7] = I[8] = I[9] = I[10] = (T)(img)(0,_p10##y,z,c)), \
 (I[22] = I[23] = I[24] = I[25] = I[26] = I[27] = I[28] = I[29] = I[30] = I[31] = I[32] = (T)(img)(0,_p9##y,z,c)), \
 (I[44] = I[45] = I[46] = I[47] = I[48] = I[49] = I[50] = I[51] = I[52] = I[53] = I[54] = (T)(img)(0,_p8##y,z,c)), \
 (I[66] = I[67] = I[68] = I[69] = I[70] = I[71] = I[72] = I[73] = I[74] = I[75] = I[76] = (T)(img)(0,_p7##y,z,c)), \
 (I[88] = I[89] = I[90] = I[91] = I[92] = I[93] = I[94] = I[95] = I[96] = I[97] = I[98] = (T)(img)(0,_p6##y,z,c)), \
 (I[110] = I[111] = I[112] = I[113] = I[114] = I[115] = I[116] = I[117] = I[118] = I[119] = I[120] = (T)(img)(0,_p5##y,z,c)), \
 (I[132] = I[133] = I[134] = I[135] = I[136] = I[137] = I[138] = I[139] = I[140] = I[141] = I[142] = (T)(img)(0,_p4##y,z,c)), \
 (I[154] = I[155] = I[156] = I[157] = I[158] = I[159] = I[160] = I[161] = I[162] = I[163] = I[164] = (T)(img)(0,_p3##y,z,c)), \
 (I[176] = I[177] = I[178] = I[179] = I[180] = I[181] = I[182] = I[183] = I[184] = I[185] = I[186] = (T)(img)(0,_p2##y,z,c)), \
 (I[198] = I[199] = I[200] = I[201] = I[202] = I[203] = I[204] = I[205] = I[206] = I[207] = I[208] = (T)(img)(0,_p1##y,z,c)), \
 (I[220] = I[221] = I[222] = I[223] = I[224] = I[225] = I[226] = I[227] = I[228] = I[229] = I[230] = (T)(img)(0,y,z,c)), \
 (I[242] = I[243] = I[244] = I[245] = I[246] = I[247] = I[248] = I[249] = I[250] = I[251] = I[252] = (T)(img)(0,_n1##y,z,c)), \
 (I[264] = I[265] = I[266] = I[267] = I[268] = I[269] = I[270] = I[271] = I[272] = I[273] = I[274] = (T)(img)(0,_n2##y,z,c)), \
 (I[286] = I[287] = I[288] = I[289] = I[290] = I[291] = I[292] = I[293] = I[294] = I[295] = I[296] = (T)(img)(0,_n3##y,z,c)), \
 (I[308] = I[309] = I[310] = I[311] = I[312] = I[313] = I[314] = I[315] = I[316] = I[317] = I[318] = (T)(img)(0,_n4##y,z,c)), \
 (I[330] = I[331] = I[332] = I[333] = I[334] = I[335] = I[336] = I[337] = I[338] = I[339] = I[340] = (T)(img)(0,_n5##y,z,c)), \
 (I[352] = I[353] = I[354] = I[355] = I[356] = I[357] = I[358] = I[359] = I[360] = I[361] = I[362] = (T)(img)(0,_n6##y,z,c)), \
 (I[374] = I[375] = I[376] = I[377] = I[378] = I[379] = I[380] = I[381] = I[382] = I[383] = I[384] = (T)(img)(0,_n7##y,z,c)), \
 (I[396] = I[397] = I[398] = I[399] = I[400] = I[401] = I[402] = I[403] = I[404] = I[405] = I[406] = (T)(img)(0,_n8##y,z,c)), \
 (I[418] = I[419] = I[420] = I[421] = I[422] = I[423] = I[424] = I[425] = I[426] = I[427] = I[428] = (T)(img)(0,_n9##y,z,c)), \
 (I[440] = I[441] = I[442] = I[443] = I[444] = I[445] = I[446] = I[447] = I[448] = I[449] = I[450] = (T)(img)(0,_n10##y,z,c)), \
 (I[462] = I[463] = I[464] = I[465] = I[466] = I[467] = I[468] = I[469] = I[470] = I[471] = I[472] = (T)(img)(0,_n11##y,z,c)), \
 (I[11] = (T)(img)(_n1##x,_p10##y,z,c)), \
 (I[33] = (T)(img)(_n1##x,_p9##y,z,c)), \
 (I[55] = (T)(img)(_n1##x,_p8##y,z,c)), \
 (I[77] = (T)(img)(_n1##x,_p7##y,z,c)), \
 (I[99] = (T)(img)(_n1##x,_p6##y,z,c)), \
 (I[121] = (T)(img)(_n1##x,_p5##y,z,c)), \
 (I[143] = (T)(img)(_n1##x,_p4##y,z,c)), \
 (I[165] = (T)(img)(_n1##x,_p3##y,z,c)), \
 (I[187] = (T)(img)(_n1##x,_p2##y,z,c)), \
 (I[209] = (T)(img)(_n1##x,_p1##y,z,c)), \
 (I[231] = (T)(img)(_n1##x,y,z,c)), \
 (I[253] = (T)(img)(_n1##x,_n1##y,z,c)), \
 (I[275] = (T)(img)(_n1##x,_n2##y,z,c)), \
 (I[297] = (T)(img)(_n1##x,_n3##y,z,c)), \
 (I[319] = (T)(img)(_n1##x,_n4##y,z,c)), \
 (I[341] = (T)(img)(_n1##x,_n5##y,z,c)), \
 (I[363] = (T)(img)(_n1##x,_n6##y,z,c)), \
 (I[385] = (T)(img)(_n1##x,_n7##y,z,c)), \
 (I[407] = (T)(img)(_n1##x,_n8##y,z,c)), \
 (I[429] = (T)(img)(_n1##x,_n9##y,z,c)), \
 (I[451] = (T)(img)(_n1##x,_n10##y,z,c)), \
 (I[473] = (T)(img)(_n1##x,_n11##y,z,c)), \
 (I[12] = (T)(img)(_n2##x,_p10##y,z,c)), \
 (I[34] = (T)(img)(_n2##x,_p9##y,z,c)), \
 (I[56] = (T)(img)(_n2##x,_p8##y,z,c)), \
 (I[78] = (T)(img)(_n2##x,_p7##y,z,c)), \
 (I[100] = (T)(img)(_n2##x,_p6##y,z,c)), \
 (I[122] = (T)(img)(_n2##x,_p5##y,z,c)), \
 (I[144] = (T)(img)(_n2##x,_p4##y,z,c)), \
 (I[166] = (T)(img)(_n2##x,_p3##y,z,c)), \
 (I[188] = (T)(img)(_n2##x,_p2##y,z,c)), \
 (I[210] = (T)(img)(_n2##x,_p1##y,z,c)), \
 (I[232] = (T)(img)(_n2##x,y,z,c)), \
 (I[254] = (T)(img)(_n2##x,_n1##y,z,c)), \
 (I[276] = (T)(img)(_n2##x,_n2##y,z,c)), \
 (I[298] = (T)(img)(_n2##x,_n3##y,z,c)), \
 (I[320] = (T)(img)(_n2##x,_n4##y,z,c)), \
 (I[342] = (T)(img)(_n2##x,_n5##y,z,c)), \
 (I[364] = (T)(img)(_n2##x,_n6##y,z,c)), \
 (I[386] = (T)(img)(_n2##x,_n7##y,z,c)), \
 (I[408] = (T)(img)(_n2##x,_n8##y,z,c)), \
 (I[430] = (T)(img)(_n2##x,_n9##y,z,c)), \
 (I[452] = (T)(img)(_n2##x,_n10##y,z,c)), \
 (I[474] = (T)(img)(_n2##x,_n11##y,z,c)), \
 (I[13] = (T)(img)(_n3##x,_p10##y,z,c)), \
 (I[35] = (T)(img)(_n3##x,_p9##y,z,c)), \
 (I[57] = (T)(img)(_n3##x,_p8##y,z,c)), \
 (I[79] = (T)(img)(_n3##x,_p7##y,z,c)), \
 (I[101] = (T)(img)(_n3##x,_p6##y,z,c)), \
 (I[123] = (T)(img)(_n3##x,_p5##y,z,c)), \
 (I[145] = (T)(img)(_n3##x,_p4##y,z,c)), \
 (I[167] = (T)(img)(_n3##x,_p3##y,z,c)), \
 (I[189] = (T)(img)(_n3##x,_p2##y,z,c)), \
 (I[211] = (T)(img)(_n3##x,_p1##y,z,c)), \
 (I[233] = (T)(img)(_n3##x,y,z,c)), \
 (I[255] = (T)(img)(_n3##x,_n1##y,z,c)), \
 (I[277] = (T)(img)(_n3##x,_n2##y,z,c)), \
 (I[299] = (T)(img)(_n3##x,_n3##y,z,c)), \
 (I[321] = (T)(img)(_n3##x,_n4##y,z,c)), \
 (I[343] = (T)(img)(_n3##x,_n5##y,z,c)), \
 (I[365] = (T)(img)(_n3##x,_n6##y,z,c)), \
 (I[387] = (T)(img)(_n3##x,_n7##y,z,c)), \
 (I[409] = (T)(img)(_n3##x,_n8##y,z,c)), \
 (I[431] = (T)(img)(_n3##x,_n9##y,z,c)), \
 (I[453] = (T)(img)(_n3##x,_n10##y,z,c)), \
 (I[475] = (T)(img)(_n3##x,_n11##y,z,c)), \
 (I[14] = (T)(img)(_n4##x,_p10##y,z,c)), \
 (I[36] = (T)(img)(_n4##x,_p9##y,z,c)), \
 (I[58] = (T)(img)(_n4##x,_p8##y,z,c)), \
 (I[80] = (T)(img)(_n4##x,_p7##y,z,c)), \
 (I[102] = (T)(img)(_n4##x,_p6##y,z,c)), \
 (I[124] = (T)(img)(_n4##x,_p5##y,z,c)), \
 (I[146] = (T)(img)(_n4##x,_p4##y,z,c)), \
 (I[168] = (T)(img)(_n4##x,_p3##y,z,c)), \
 (I[190] = (T)(img)(_n4##x,_p2##y,z,c)), \
 (I[212] = (T)(img)(_n4##x,_p1##y,z,c)), \
 (I[234] = (T)(img)(_n4##x,y,z,c)), \
 (I[256] = (T)(img)(_n4##x,_n1##y,z,c)), \
 (I[278] = (T)(img)(_n4##x,_n2##y,z,c)), \
 (I[300] = (T)(img)(_n4##x,_n3##y,z,c)), \
 (I[322] = (T)(img)(_n4##x,_n4##y,z,c)), \
 (I[344] = (T)(img)(_n4##x,_n5##y,z,c)), \
 (I[366] = (T)(img)(_n4##x,_n6##y,z,c)), \
 (I[388] = (T)(img)(_n4##x,_n7##y,z,c)), \
 (I[410] = (T)(img)(_n4##x,_n8##y,z,c)), \
 (I[432] = (T)(img)(_n4##x,_n9##y,z,c)), \
 (I[454] = (T)(img)(_n4##x,_n10##y,z,c)), \
 (I[476] = (T)(img)(_n4##x,_n11##y,z,c)), \
 (I[15] = (T)(img)(_n5##x,_p10##y,z,c)), \
 (I[37] = (T)(img)(_n5##x,_p9##y,z,c)), \
 (I[59] = (T)(img)(_n5##x,_p8##y,z,c)), \
 (I[81] = (T)(img)(_n5##x,_p7##y,z,c)), \
 (I[103] = (T)(img)(_n5##x,_p6##y,z,c)), \
 (I[125] = (T)(img)(_n5##x,_p5##y,z,c)), \
 (I[147] = (T)(img)(_n5##x,_p4##y,z,c)), \
 (I[169] = (T)(img)(_n5##x,_p3##y,z,c)), \
 (I[191] = (T)(img)(_n5##x,_p2##y,z,c)), \
 (I[213] = (T)(img)(_n5##x,_p1##y,z,c)), \
 (I[235] = (T)(img)(_n5##x,y,z,c)), \
 (I[257] = (T)(img)(_n5##x,_n1##y,z,c)), \
 (I[279] = (T)(img)(_n5##x,_n2##y,z,c)), \
 (I[301] = (T)(img)(_n5##x,_n3##y,z,c)), \
 (I[323] = (T)(img)(_n5##x,_n4##y,z,c)), \
 (I[345] = (T)(img)(_n5##x,_n5##y,z,c)), \
 (I[367] = (T)(img)(_n5##x,_n6##y,z,c)), \
 (I[389] = (T)(img)(_n5##x,_n7##y,z,c)), \
 (I[411] = (T)(img)(_n5##x,_n8##y,z,c)), \
 (I[433] = (T)(img)(_n5##x,_n9##y,z,c)), \
 (I[455] = (T)(img)(_n5##x,_n10##y,z,c)), \
 (I[477] = (T)(img)(_n5##x,_n11##y,z,c)), \
 (I[16] = (T)(img)(_n6##x,_p10##y,z,c)), \
 (I[38] = (T)(img)(_n6##x,_p9##y,z,c)), \
 (I[60] = (T)(img)(_n6##x,_p8##y,z,c)), \
 (I[82] = (T)(img)(_n6##x,_p7##y,z,c)), \
 (I[104] = (T)(img)(_n6##x,_p6##y,z,c)), \
 (I[126] = (T)(img)(_n6##x,_p5##y,z,c)), \
 (I[148] = (T)(img)(_n6##x,_p4##y,z,c)), \
 (I[170] = (T)(img)(_n6##x,_p3##y,z,c)), \
 (I[192] = (T)(img)(_n6##x,_p2##y,z,c)), \
 (I[214] = (T)(img)(_n6##x,_p1##y,z,c)), \
 (I[236] = (T)(img)(_n6##x,y,z,c)), \
 (I[258] = (T)(img)(_n6##x,_n1##y,z,c)), \
 (I[280] = (T)(img)(_n6##x,_n2##y,z,c)), \
 (I[302] = (T)(img)(_n6##x,_n3##y,z,c)), \
 (I[324] = (T)(img)(_n6##x,_n4##y,z,c)), \
 (I[346] = (T)(img)(_n6##x,_n5##y,z,c)), \
 (I[368] = (T)(img)(_n6##x,_n6##y,z,c)), \
 (I[390] = (T)(img)(_n6##x,_n7##y,z,c)), \
 (I[412] = (T)(img)(_n6##x,_n8##y,z,c)), \
 (I[434] = (T)(img)(_n6##x,_n9##y,z,c)), \
 (I[456] = (T)(img)(_n6##x,_n10##y,z,c)), \
 (I[478] = (T)(img)(_n6##x,_n11##y,z,c)), \
 (I[17] = (T)(img)(_n7##x,_p10##y,z,c)), \
 (I[39] = (T)(img)(_n7##x,_p9##y,z,c)), \
 (I[61] = (T)(img)(_n7##x,_p8##y,z,c)), \
 (I[83] = (T)(img)(_n7##x,_p7##y,z,c)), \
 (I[105] = (T)(img)(_n7##x,_p6##y,z,c)), \
 (I[127] = (T)(img)(_n7##x,_p5##y,z,c)), \
 (I[149] = (T)(img)(_n7##x,_p4##y,z,c)), \
 (I[171] = (T)(img)(_n7##x,_p3##y,z,c)), \
 (I[193] = (T)(img)(_n7##x,_p2##y,z,c)), \
 (I[215] = (T)(img)(_n7##x,_p1##y,z,c)), \
 (I[237] = (T)(img)(_n7##x,y,z,c)), \
 (I[259] = (T)(img)(_n7##x,_n1##y,z,c)), \
 (I[281] = (T)(img)(_n7##x,_n2##y,z,c)), \
 (I[303] = (T)(img)(_n7##x,_n3##y,z,c)), \
 (I[325] = (T)(img)(_n7##x,_n4##y,z,c)), \
 (I[347] = (T)(img)(_n7##x,_n5##y,z,c)), \
 (I[369] = (T)(img)(_n7##x,_n6##y,z,c)), \
 (I[391] = (T)(img)(_n7##x,_n7##y,z,c)), \
 (I[413] = (T)(img)(_n7##x,_n8##y,z,c)), \
 (I[435] = (T)(img)(_n7##x,_n9##y,z,c)), \
 (I[457] = (T)(img)(_n7##x,_n10##y,z,c)), \
 (I[479] = (T)(img)(_n7##x,_n11##y,z,c)), \
 (I[18] = (T)(img)(_n8##x,_p10##y,z,c)), \
 (I[40] = (T)(img)(_n8##x,_p9##y,z,c)), \
 (I[62] = (T)(img)(_n8##x,_p8##y,z,c)), \
 (I[84] = (T)(img)(_n8##x,_p7##y,z,c)), \
 (I[106] = (T)(img)(_n8##x,_p6##y,z,c)), \
 (I[128] = (T)(img)(_n8##x,_p5##y,z,c)), \
 (I[150] = (T)(img)(_n8##x,_p4##y,z,c)), \
 (I[172] = (T)(img)(_n8##x,_p3##y,z,c)), \
 (I[194] = (T)(img)(_n8##x,_p2##y,z,c)), \
 (I[216] = (T)(img)(_n8##x,_p1##y,z,c)), \
 (I[238] = (T)(img)(_n8##x,y,z,c)), \
 (I[260] = (T)(img)(_n8##x,_n1##y,z,c)), \
 (I[282] = (T)(img)(_n8##x,_n2##y,z,c)), \
 (I[304] = (T)(img)(_n8##x,_n3##y,z,c)), \
 (I[326] = (T)(img)(_n8##x,_n4##y,z,c)), \
 (I[348] = (T)(img)(_n8##x,_n5##y,z,c)), \
 (I[370] = (T)(img)(_n8##x,_n6##y,z,c)), \
 (I[392] = (T)(img)(_n8##x,_n7##y,z,c)), \
 (I[414] = (T)(img)(_n8##x,_n8##y,z,c)), \
 (I[436] = (T)(img)(_n8##x,_n9##y,z,c)), \
 (I[458] = (T)(img)(_n8##x,_n10##y,z,c)), \
 (I[480] = (T)(img)(_n8##x,_n11##y,z,c)), \
 (I[19] = (T)(img)(_n9##x,_p10##y,z,c)), \
 (I[41] = (T)(img)(_n9##x,_p9##y,z,c)), \
 (I[63] = (T)(img)(_n9##x,_p8##y,z,c)), \
 (I[85] = (T)(img)(_n9##x,_p7##y,z,c)), \
 (I[107] = (T)(img)(_n9##x,_p6##y,z,c)), \
 (I[129] = (T)(img)(_n9##x,_p5##y,z,c)), \
 (I[151] = (T)(img)(_n9##x,_p4##y,z,c)), \
 (I[173] = (T)(img)(_n9##x,_p3##y,z,c)), \
 (I[195] = (T)(img)(_n9##x,_p2##y,z,c)), \
 (I[217] = (T)(img)(_n9##x,_p1##y,z,c)), \
 (I[239] = (T)(img)(_n9##x,y,z,c)), \
 (I[261] = (T)(img)(_n9##x,_n1##y,z,c)), \
 (I[283] = (T)(img)(_n9##x,_n2##y,z,c)), \
 (I[305] = (T)(img)(_n9##x,_n3##y,z,c)), \
 (I[327] = (T)(img)(_n9##x,_n4##y,z,c)), \
 (I[349] = (T)(img)(_n9##x,_n5##y,z,c)), \
 (I[371] = (T)(img)(_n9##x,_n6##y,z,c)), \
 (I[393] = (T)(img)(_n9##x,_n7##y,z,c)), \
 (I[415] = (T)(img)(_n9##x,_n8##y,z,c)), \
 (I[437] = (T)(img)(_n9##x,_n9##y,z,c)), \
 (I[459] = (T)(img)(_n9##x,_n10##y,z,c)), \
 (I[481] = (T)(img)(_n9##x,_n11##y,z,c)), \
 (I[20] = (T)(img)(_n10##x,_p10##y,z,c)), \
 (I[42] = (T)(img)(_n10##x,_p9##y,z,c)), \
 (I[64] = (T)(img)(_n10##x,_p8##y,z,c)), \
 (I[86] = (T)(img)(_n10##x,_p7##y,z,c)), \
 (I[108] = (T)(img)(_n10##x,_p6##y,z,c)), \
 (I[130] = (T)(img)(_n10##x,_p5##y,z,c)), \
 (I[152] = (T)(img)(_n10##x,_p4##y,z,c)), \
 (I[174] = (T)(img)(_n10##x,_p3##y,z,c)), \
 (I[196] = (T)(img)(_n10##x,_p2##y,z,c)), \
 (I[218] = (T)(img)(_n10##x,_p1##y,z,c)), \
 (I[240] = (T)(img)(_n10##x,y,z,c)), \
 (I[262] = (T)(img)(_n10##x,_n1##y,z,c)), \
 (I[284] = (T)(img)(_n10##x,_n2##y,z,c)), \
 (I[306] = (T)(img)(_n10##x,_n3##y,z,c)), \
 (I[328] = (T)(img)(_n10##x,_n4##y,z,c)), \
 (I[350] = (T)(img)(_n10##x,_n5##y,z,c)), \
 (I[372] = (T)(img)(_n10##x,_n6##y,z,c)), \
 (I[394] = (T)(img)(_n10##x,_n7##y,z,c)), \
 (I[416] = (T)(img)(_n10##x,_n8##y,z,c)), \
 (I[438] = (T)(img)(_n10##x,_n9##y,z,c)), \
 (I[460] = (T)(img)(_n10##x,_n10##y,z,c)), \
 (I[482] = (T)(img)(_n10##x,_n11##y,z,c)), \
 11>=((img)._width)?(img).width()-1:11); \
 (_n11##x<(img).width() && ( \
 (I[21] = (T)(img)(_n11##x,_p10##y,z,c)), \
 (I[43] = (T)(img)(_n11##x,_p9##y,z,c)), \
 (I[65] = (T)(img)(_n11##x,_p8##y,z,c)), \
 (I[87] = (T)(img)(_n11##x,_p7##y,z,c)), \
 (I[109] = (T)(img)(_n11##x,_p6##y,z,c)), \
 (I[131] = (T)(img)(_n11##x,_p5##y,z,c)), \
 (I[153] = (T)(img)(_n11##x,_p4##y,z,c)), \
 (I[175] = (T)(img)(_n11##x,_p3##y,z,c)), \
 (I[197] = (T)(img)(_n11##x,_p2##y,z,c)), \
 (I[219] = (T)(img)(_n11##x,_p1##y,z,c)), \
 (I[241] = (T)(img)(_n11##x,y,z,c)), \
 (I[263] = (T)(img)(_n11##x,_n1##y,z,c)), \
 (I[285] = (T)(img)(_n11##x,_n2##y,z,c)), \
 (I[307] = (T)(img)(_n11##x,_n3##y,z,c)), \
 (I[329] = (T)(img)(_n11##x,_n4##y,z,c)), \
 (I[351] = (T)(img)(_n11##x,_n5##y,z,c)), \
 (I[373] = (T)(img)(_n11##x,_n6##y,z,c)), \
 (I[395] = (T)(img)(_n11##x,_n7##y,z,c)), \
 (I[417] = (T)(img)(_n11##x,_n8##y,z,c)), \
 (I[439] = (T)(img)(_n11##x,_n9##y,z,c)), \
 (I[461] = (T)(img)(_n11##x,_n10##y,z,c)), \
 (I[483] = (T)(img)(_n11##x,_n11##y,z,c)),1)) || \
 _n10##x==--_n11##x || _n9##x==--_n10##x || _n8##x==--_n9##x || _n7##x==--_n8##x || _n6##x==--_n7##x || _n5##x==--_n6##x || _n4##x==--_n5##x || _n3##x==--_n4##x || _n2##x==--_n3##x || _n1##x==--_n2##x || x==(_n11##x = _n10##x = _n9##x = _n8##x = _n7##x = _n6##x = _n5##x = _n4##x = _n3##x = _n2##x = --_n1##x); \
 I[0] = I[1], I[1] = I[2], I[2] = I[3], I[3] = I[4], I[4] = I[5], I[5] = I[6], I[6] = I[7], I[7] = I[8], I[8] = I[9], I[9] = I[10], I[10] = I[11], I[11] = I[12], I[12] = I[13], I[13] = I[14], I[14] = I[15], I[15] = I[16], I[16] = I[17], I[17] = I[18], I[18] = I[19], I[19] = I[20], I[20] = I[21], \
 I[22] = I[23], I[23] = I[24], I[24] = I[25], I[25] = I[26], I[26] = I[27], I[27] = I[28], I[28] = I[29], I[29] = I[30], I[30] = I[31], I[31] = I[32], I[32] = I[33], I[33] = I[34], I[34] = I[35], I[35] = I[36], I[36] = I[37], I[37] = I[38], I[38] = I[39], I[39] = I[40], I[40] = I[41], I[41] = I[42], I[42] = I[43], \
 I[44] = I[45], I[45] = I[46], I[46] = I[47], I[47] = I[48], I[48] = I[49], I[49] = I[50], I[50] = I[51], I[51] = I[52], I[52] = I[53], I[53] = I[54], I[54] = I[55], I[55] = I[56], I[56] = I[57], I[57] = I[58], I[58] = I[59], I[59] = I[60], I[60] = I[61], I[61] = I[62], I[62] = I[63], I[63] = I[64], I[64] = I[65], \
 I[66] = I[67], I[67] = I[68], I[68] = I[69], I[69] = I[70], I[70] = I[71], I[71] = I[72], I[72] = I[73], I[73] = I[74], I[74] = I[75], I[75] = I[76], I[76] = I[77], I[77] = I[78], I[78] = I[79], I[79] = I[80], I[80] = I[81], I[81] = I[82], I[82] = I[83], I[83] = I[84], I[84] = I[85], I[85] = I[86], I[86] = I[87], \
 I[88] = I[89], I[89] = I[90], I[90] = I[91], I[91] = I[92], I[92] = I[93], I[93] = I[94], I[94] = I[95], I[95] = I[96], I[96] = I[97], I[97] = I[98], I[98] = I[99], I[99] = I[100], I[100] = I[101], I[101] = I[102], I[102] = I[103], I[103] = I[104], I[104] = I[105], I[105] = I[106], I[106] = I[107], I[107] = I[108], I[108] = I[109], \
 I[110] = I[111], I[111] = I[112], I[112] = I[113], I[113] = I[114], I[114] = I[115], I[115] = I[116], I[116] = I[117], I[117] = I[118], I[118] = I[119], I[119] = I[120], I[120] = I[121], I[121] = I[122], I[122] = I[123], I[123] = I[124], I[124] = I[125], I[125] = I[126], I[126] = I[127], I[127] = I[128], I[128] = I[129], I[129] = I[130], I[130] = I[131], \
 I[132] = I[133], I[133] = I[134], I[134] = I[135], I[135] = I[136], I[136] = I[137], I[137] = I[138], I[138] = I[139], I[139] = I[140], I[140] = I[141], I[141] = I[142], I[142] = I[143], I[143] = I[144], I[144] = I[145], I[145] = I[146], I[146] = I[147], I[147] = I[148], I[148] = I[149], I[149] = I[150], I[150] = I[151], I[151] = I[152], I[152] = I[153], \
 I[154] = I[155], I[155] = I[156], I[156] = I[157], I[157] = I[158], I[158] = I[159], I[159] = I[160], I[160] = I[161], I[161] = I[162], I[162] = I[163], I[163] = I[164], I[164] = I[165], I[165] = I[166], I[166] = I[167], I[167] = I[168], I[168] = I[169], I[169] = I[170], I[170] = I[171], I[171] = I[172], I[172] = I[173], I[173] = I[174], I[174] = I[175], \
 I[176] = I[177], I[177] = I[178], I[178] = I[179], I[179] = I[180], I[180] = I[181], I[181] = I[182], I[182] = I[183], I[183] = I[184], I[184] = I[185], I[185] = I[186], I[186] = I[187], I[187] = I[188], I[188] = I[189], I[189] = I[190], I[190] = I[191], I[191] = I[192], I[192] = I[193], I[193] = I[194], I[194] = I[195], I[195] = I[196], I[196] = I[197], \
 I[198] = I[199], I[199] = I[200], I[200] = I[201], I[201] = I[202], I[202] = I[203], I[203] = I[204], I[204] = I[205], I[205] = I[206], I[206] = I[207], I[207] = I[208], I[208] = I[209], I[209] = I[210], I[210] = I[211], I[211] = I[212], I[212] = I[213], I[213] = I[214], I[214] = I[215], I[215] = I[216], I[216] = I[217], I[217] = I[218], I[218] = I[219], \
 I[220] = I[221], I[221] = I[222], I[222] = I[223], I[223] = I[224], I[224] = I[225], I[225] = I[226], I[226] = I[227], I[227] = I[228], I[228] = I[229], I[229] = I[230], I[230] = I[231], I[231] = I[232], I[232] = I[233], I[233] = I[234], I[234] = I[235], I[235] = I[236], I[236] = I[237], I[237] = I[238], I[238] = I[239], I[239] = I[240], I[240] = I[241], \
 I[242] = I[243], I[243] = I[244], I[244] = I[245], I[245] = I[246], I[246] = I[247], I[247] = I[248], I[248] = I[249], I[249] = I[250], I[250] = I[251], I[251] = I[252], I[252] = I[253], I[253] = I[254], I[254] = I[255], I[255] = I[256], I[256] = I[257], I[257] = I[258], I[258] = I[259], I[259] = I[260], I[260] = I[261], I[261] = I[262], I[262] = I[263], \
 I[264] = I[265], I[265] = I[266], I[266] = I[267], I[267] = I[268], I[268] = I[269], I[269] = I[270], I[270] = I[271], I[271] = I[272], I[272] = I[273], I[273] = I[274], I[274] = I[275], I[275] = I[276], I[276] = I[277], I[277] = I[278], I[278] = I[279], I[279] = I[280], I[280] = I[281], I[281] = I[282], I[282] = I[283], I[283] = I[284], I[284] = I[285], \
 I[286] = I[287], I[287] = I[288], I[288] = I[289], I[289] = I[290], I[290] = I[291], I[291] = I[292], I[292] = I[293], I[293] = I[294], I[294] = I[295], I[295] = I[296], I[296] = I[297], I[297] = I[298], I[298] = I[299], I[299] = I[300], I[300] = I[301], I[301] = I[302], I[302] = I[303], I[303] = I[304], I[304] = I[305], I[305] = I[306], I[306] = I[307], \
 I[308] = I[309], I[309] = I[310], I[310] = I[311], I[311] = I[312], I[312] = I[313], I[313] = I[314], I[314] = I[315], I[315] = I[316], I[316] = I[317], I[317] = I[318], I[318] = I[319], I[319] = I[320], I[320] = I[321], I[321] = I[322], I[322] = I[323], I[323] = I[324], I[324] = I[325], I[325] = I[326], I[326] = I[327], I[327] = I[328], I[328] = I[329], \
 I[330] = I[331], I[331] = I[332], I[332] = I[333], I[333] = I[334], I[334] = I[335], I[335] = I[336], I[336] = I[337], I[337] = I[338], I[338] = I[339], I[339] = I[340], I[340] = I[341], I[341] = I[342], I[342] = I[343], I[343] = I[344], I[344] = I[345], I[345] = I[346], I[346] = I[347], I[347] = I[348], I[348] = I[349], I[349] = I[350], I[350] = I[351], \
 I[352] = I[353], I[353] = I[354], I[354] = I[355], I[355] = I[356], I[356] = I[357], I[357] = I[358], I[358] = I[359], I[359] = I[360], I[360] = I[361], I[361] = I[362], I[362] = I[363], I[363] = I[364], I[364] = I[365], I[365] = I[366], I[366] = I[367], I[367] = I[368], I[368] = I[369], I[369] = I[370], I[370] = I[371], I[371] = I[372], I[372] = I[373], \
 I[374] = I[375], I[375] = I[376], I[376] = I[377], I[377] = I[378], I[378] = I[379], I[379] = I[380], I[380] = I[381], I[381] = I[382], I[382] = I[383], I[383] = I[384], I[384] = I[385], I[385] = I[386], I[386] = I[387], I[387] = I[388], I[388] = I[389], I[389] = I[390], I[390] = I[391], I[391] = I[392], I[392] = I[393], I[393] = I[394], I[394] = I[395], \
 I[396] = I[397], I[397] = I[398], I[398] = I[399], I[399] = I[400], I[400] = I[401], I[401] = I[402], I[402] = I[403], I[403] = I[404], I[404] = I[405], I[405] = I[406], I[406] = I[407], I[407] = I[408], I[408] = I[409], I[409] = I[410], I[410] = I[411], I[411] = I[412], I[412] = I[413], I[413] = I[414], I[414] = I[415], I[415] = I[416], I[416] = I[417], \
 I[418] = I[419], I[419] = I[420], I[420] = I[421], I[421] = I[422], I[422] = I[423], I[423] = I[424], I[424] = I[425], I[425] = I[426], I[426] = I[427], I[427] = I[428], I[428] = I[429], I[429] = I[430], I[430] = I[431], I[431] = I[432], I[432] = I[433], I[433] = I[434], I[434] = I[435], I[435] = I[436], I[436] = I[437], I[437] = I[438], I[438] = I[439], \
 I[440] = I[441], I[441] = I[442], I[442] = I[443], I[443] = I[444], I[444] = I[445], I[445] = I[446], I[446] = I[447], I[447] = I[448], I[448] = I[449], I[449] = I[450], I[450] = I[451], I[451] = I[452], I[452] = I[453], I[453] = I[454], I[454] = I[455], I[455] = I[456], I[456] = I[457], I[457] = I[458], I[458] = I[459], I[459] = I[460], I[460] = I[461], \
 I[462] = I[463], I[463] = I[464], I[464] = I[465], I[465] = I[466], I[466] = I[467], I[467] = I[468], I[468] = I[469], I[469] = I[470], I[470] = I[471], I[471] = I[472], I[472] = I[473], I[473] = I[474], I[474] = I[475], I[475] = I[476], I[476] = I[477], I[477] = I[478], I[478] = I[479], I[479] = I[480], I[480] = I[481], I[481] = I[482], I[482] = I[483], \
 _p10##x = _p9##x, _p9##x = _p8##x, _p8##x = _p7##x, _p7##x = _p6##x, _p6##x = _p5##x, _p5##x = _p4##x, _p4##x = _p3##x, _p3##x = _p2##x, _p2##x = _p1##x, _p1##x = x++, ++_n1##x, ++_n2##x, ++_n3##x, ++_n4##x, ++_n5##x, ++_n6##x, ++_n7##x, ++_n8##x, ++_n9##x, ++_n10##x, ++_n11##x)

#define cimg_for_in22x22(img,x0,y0,x1,y1,x,y,z,c,I,T) \
 cimg_for_in22((img)._height,y0,y1,y) for (int x = (int)(x0)<0?0:(int)(x0), \
 _p10##x = x-10<0?0:x-10, \
 _p9##x = x-9<0?0:x-9, \
 _p8##x = x-8<0?0:x-8, \
 _p7##x = x-7<0?0:x-7, \
 _p6##x = x-6<0?0:x-6, \
 _p5##x = x-5<0?0:x-5, \
 _p4##x = x-4<0?0:x-4, \
 _p3##x = x-3<0?0:x-3, \
 _p2##x = x-2<0?0:x-2, \
 _p1##x = x-1<0?0:x-1, \
 _n1##x = x+1>=(img).width()?(img).width()-1:x+1, \
 _n2##x = x+2>=(img).width()?(img).width()-1:x+2, \
 _n3##x = x+3>=(img).width()?(img).width()-1:x+3, \
 _n4##x = x+4>=(img).width()?(img).width()-1:x+4, \
 _n5##x = x+5>=(img).width()?(img).width()-1:x+5, \
 _n6##x = x+6>=(img).width()?(img).width()-1:x+6, \
 _n7##x = x+7>=(img).width()?(img).width()-1:x+7, \
 _n8##x = x+8>=(img).width()?(img).width()-1:x+8, \
 _n9##x = x+9>=(img).width()?(img).width()-1:x+9, \
 _n10##x = x+10>=(img).width()?(img).width()-1:x+10, \
 _n11##x = (int)( \
 (I[0] = (T)(img)(_p10##x,_p10##y,z,c)), \
 (I[22] = (T)(img)(_p10##x,_p9##y,z,c)), \
 (I[44] = (T)(img)(_p10##x,_p8##y,z,c)), \
 (I[66] = (T)(img)(_p10##x,_p7##y,z,c)), \
 (I[88] = (T)(img)(_p10##x,_p6##y,z,c)), \
 (I[110] = (T)(img)(_p10##x,_p5##y,z,c)), \
 (I[132] = (T)(img)(_p10##x,_p4##y,z,c)), \
 (I[154] = (T)(img)(_p10##x,_p3##y,z,c)), \
 (I[176] = (T)(img)(_p10##x,_p2##y,z,c)), \
 (I[198] = (T)(img)(_p10##x,_p1##y,z,c)), \
 (I[220] = (T)(img)(_p10##x,y,z,c)), \
 (I[242] = (T)(img)(_p10##x,_n1##y,z,c)), \
 (I[264] = (T)(img)(_p10##x,_n2##y,z,c)), \
 (I[286] = (T)(img)(_p10##x,_n3##y,z,c)), \
 (I[308] = (T)(img)(_p10##x,_n4##y,z,c)), \
 (I[330] = (T)(img)(_p10##x,_n5##y,z,c)), \
 (I[352] = (T)(img)(_p10##x,_n6##y,z,c)), \
 (I[374] = (T)(img)(_p10##x,_n7##y,z,c)), \
 (I[396] = (T)(img)(_p10##x,_n8##y,z,c)), \
 (I[418] = (T)(img)(_p10##x,_n9##y,z,c)), \
 (I[440] = (T)(img)(_p10##x,_n10##y,z,c)), \
 (I[462] = (T)(img)(_p10##x,_n11##y,z,c)), \
 (I[1] = (T)(img)(_p9##x,_p10##y,z,c)), \
 (I[23] = (T)(img)(_p9##x,_p9##y,z,c)), \
 (I[45] = (T)(img)(_p9##x,_p8##y,z,c)), \
 (I[67] = (T)(img)(_p9##x,_p7##y,z,c)), \
 (I[89] = (T)(img)(_p9##x,_p6##y,z,c)), \
 (I[111] = (T)(img)(_p9##x,_p5##y,z,c)), \
 (I[133] = (T)(img)(_p9##x,_p4##y,z,c)), \
 (I[155] = (T)(img)(_p9##x,_p3##y,z,c)), \
 (I[177] = (T)(img)(_p9##x,_p2##y,z,c)), \
 (I[199] = (T)(img)(_p9##x,_p1##y,z,c)), \
 (I[221] = (T)(img)(_p9##x,y,z,c)), \
 (I[243] = (T)(img)(_p9##x,_n1##y,z,c)), \
 (I[265] = (T)(img)(_p9##x,_n2##y,z,c)), \
 (I[287] = (T)(img)(_p9##x,_n3##y,z,c)), \
 (I[309] = (T)(img)(_p9##x,_n4##y,z,c)), \
 (I[331] = (T)(img)(_p9##x,_n5##y,z,c)), \
 (I[353] = (T)(img)(_p9##x,_n6##y,z,c)), \
 (I[375] = (T)(img)(_p9##x,_n7##y,z,c)), \
 (I[397] = (T)(img)(_p9##x,_n8##y,z,c)), \
 (I[419] = (T)(img)(_p9##x,_n9##y,z,c)), \
 (I[441] = (T)(img)(_p9##x,_n10##y,z,c)), \
 (I[463] = (T)(img)(_p9##x,_n11##y,z,c)), \
 (I[2] = (T)(img)(_p8##x,_p10##y,z,c)), \
 (I[24] = (T)(img)(_p8##x,_p9##y,z,c)), \
 (I[46] = (T)(img)(_p8##x,_p8##y,z,c)), \
 (I[68] = (T)(img)(_p8##x,_p7##y,z,c)), \
 (I[90] = (T)(img)(_p8##x,_p6##y,z,c)), \
 (I[112] = (T)(img)(_p8##x,_p5##y,z,c)), \
 (I[134] = (T)(img)(_p8##x,_p4##y,z,c)), \
 (I[156] = (T)(img)(_p8##x,_p3##y,z,c)), \
 (I[178] = (T)(img)(_p8##x,_p2##y,z,c)), \
 (I[200] = (T)(img)(_p8##x,_p1##y,z,c)), \
 (I[222] = (T)(img)(_p8##x,y,z,c)), \
 (I[244] = (T)(img)(_p8##x,_n1##y,z,c)), \
 (I[266] = (T)(img)(_p8##x,_n2##y,z,c)), \
 (I[288] = (T)(img)(_p8##x,_n3##y,z,c)), \
 (I[310] = (T)(img)(_p8##x,_n4##y,z,c)), \
 (I[332] = (T)(img)(_p8##x,_n5##y,z,c)), \
 (I[354] = (T)(img)(_p8##x,_n6##y,z,c)), \
 (I[376] = (T)(img)(_p8##x,_n7##y,z,c)), \
 (I[398] = (T)(img)(_p8##x,_n8##y,z,c)), \
 (I[420] = (T)(img)(_p8##x,_n9##y,z,c)), \
 (I[442] = (T)(img)(_p8##x,_n10##y,z,c)), \
 (I[464] = (T)(img)(_p8##x,_n11##y,z,c)), \
 (I[3] = (T)(img)(_p7##x,_p10##y,z,c)), \
 (I[25] = (T)(img)(_p7##x,_p9##y,z,c)), \
 (I[47] = (T)(img)(_p7##x,_p8##y,z,c)), \
 (I[69] = (T)(img)(_p7##x,_p7##y,z,c)), \
 (I[91] = (T)(img)(_p7##x,_p6##y,z,c)), \
 (I[113] = (T)(img)(_p7##x,_p5##y,z,c)), \
 (I[135] = (T)(img)(_p7##x,_p4##y,z,c)), \
 (I[157] = (T)(img)(_p7##x,_p3##y,z,c)), \
 (I[179] = (T)(img)(_p7##x,_p2##y,z,c)), \
 (I[201] = (T)(img)(_p7##x,_p1##y,z,c)), \
 (I[223] = (T)(img)(_p7##x,y,z,c)), \
 (I[245] = (T)(img)(_p7##x,_n1##y,z,c)), \
 (I[267] = (T)(img)(_p7##x,_n2##y,z,c)), \
 (I[289] = (T)(img)(_p7##x,_n3##y,z,c)), \
 (I[311] = (T)(img)(_p7##x,_n4##y,z,c)), \
 (I[333] = (T)(img)(_p7##x,_n5##y,z,c)), \
 (I[355] = (T)(img)(_p7##x,_n6##y,z,c)), \
 (I[377] = (T)(img)(_p7##x,_n7##y,z,c)), \
 (I[399] = (T)(img)(_p7##x,_n8##y,z,c)), \
 (I[421] = (T)(img)(_p7##x,_n9##y,z,c)), \
 (I[443] = (T)(img)(_p7##x,_n10##y,z,c)), \
 (I[465] = (T)(img)(_p7##x,_n11##y,z,c)), \
 (I[4] = (T)(img)(_p6##x,_p10##y,z,c)), \
 (I[26] = (T)(img)(_p6##x,_p9##y,z,c)), \
 (I[48] = (T)(img)(_p6##x,_p8##y,z,c)), \
 (I[70] = (T)(img)(_p6##x,_p7##y,z,c)), \
 (I[92] = (T)(img)(_p6##x,_p6##y,z,c)), \
 (I[114] = (T)(img)(_p6##x,_p5##y,z,c)), \
 (I[136] = (T)(img)(_p6##x,_p4##y,z,c)), \
 (I[158] = (T)(img)(_p6##x,_p3##y,z,c)), \
 (I[180] = (T)(img)(_p6##x,_p2##y,z,c)), \
 (I[202] = (T)(img)(_p6##x,_p1##y,z,c)), \
 (I[224] = (T)(img)(_p6##x,y,z,c)), \
 (I[246] = (T)(img)(_p6##x,_n1##y,z,c)), \
 (I[268] = (T)(img)(_p6##x,_n2##y,z,c)), \
 (I[290] = (T)(img)(_p6##x,_n3##y,z,c)), \
 (I[312] = (T)(img)(_p6##x,_n4##y,z,c)), \
 (I[334] = (T)(img)(_p6##x,_n5##y,z,c)), \
 (I[356] = (T)(img)(_p6##x,_n6##y,z,c)), \
 (I[378] = (T)(img)(_p6##x,_n7##y,z,c)), \
 (I[400] = (T)(img)(_p6##x,_n8##y,z,c)), \
 (I[422] = (T)(img)(_p6##x,_n9##y,z,c)), \
 (I[444] = (T)(img)(_p6##x,_n10##y,z,c)), \
 (I[466] = (T)(img)(_p6##x,_n11##y,z,c)), \
 (I[5] = (T)(img)(_p5##x,_p10##y,z,c)), \
 (I[27] = (T)(img)(_p5##x,_p9##y,z,c)), \
 (I[49] = (T)(img)(_p5##x,_p8##y,z,c)), \
 (I[71] = (T)(img)(_p5##x,_p7##y,z,c)), \
 (I[93] = (T)(img)(_p5##x,_p6##y,z,c)), \
 (I[115] = (T)(img)(_p5##x,_p5##y,z,c)), \
 (I[137] = (T)(img)(_p5##x,_p4##y,z,c)), \
 (I[159] = (T)(img)(_p5##x,_p3##y,z,c)), \
 (I[181] = (T)(img)(_p5##x,_p2##y,z,c)), \
 (I[203] = (T)(img)(_p5##x,_p1##y,z,c)), \
 (I[225] = (T)(img)(_p5##x,y,z,c)), \
 (I[247] = (T)(img)(_p5##x,_n1##y,z,c)), \
 (I[269] = (T)(img)(_p5##x,_n2##y,z,c)), \
 (I[291] = (T)(img)(_p5##x,_n3##y,z,c)), \
 (I[313] = (T)(img)(_p5##x,_n4##y,z,c)), \
 (I[335] = (T)(img)(_p5##x,_n5##y,z,c)), \
 (I[357] = (T)(img)(_p5##x,_n6##y,z,c)), \
 (I[379] = (T)(img)(_p5##x,_n7##y,z,c)), \
 (I[401] = (T)(img)(_p5##x,_n8##y,z,c)), \
 (I[423] = (T)(img)(_p5##x,_n9##y,z,c)), \
 (I[445] = (T)(img)(_p5##x,_n10##y,z,c)), \
 (I[467] = (T)(img)(_p5##x,_n11##y,z,c)), \
 (I[6] = (T)(img)(_p4##x,_p10##y,z,c)), \
 (I[28] = (T)(img)(_p4##x,_p9##y,z,c)), \
 (I[50] = (T)(img)(_p4##x,_p8##y,z,c)), \
 (I[72] = (T)(img)(_p4##x,_p7##y,z,c)), \
 (I[94] = (T)(img)(_p4##x,_p6##y,z,c)), \
 (I[116] = (T)(img)(_p4##x,_p5##y,z,c)), \
 (I[138] = (T)(img)(_p4##x,_p4##y,z,c)), \
 (I[160] = (T)(img)(_p4##x,_p3##y,z,c)), \
 (I[182] = (T)(img)(_p4##x,_p2##y,z,c)), \
 (I[204] = (T)(img)(_p4##x,_p1##y,z,c)), \
 (I[226] = (T)(img)(_p4##x,y,z,c)), \
 (I[248] = (T)(img)(_p4##x,_n1##y,z,c)), \
 (I[270] = (T)(img)(_p4##x,_n2##y,z,c)), \
 (I[292] = (T)(img)(_p4##x,_n3##y,z,c)), \
 (I[314] = (T)(img)(_p4##x,_n4##y,z,c)), \
 (I[336] = (T)(img)(_p4##x,_n5##y,z,c)), \
 (I[358] = (T)(img)(_p4##x,_n6##y,z,c)), \
 (I[380] = (T)(img)(_p4##x,_n7##y,z,c)), \
 (I[402] = (T)(img)(_p4##x,_n8##y,z,c)), \
 (I[424] = (T)(img)(_p4##x,_n9##y,z,c)), \
 (I[446] = (T)(img)(_p4##x,_n10##y,z,c)), \
 (I[468] = (T)(img)(_p4##x,_n11##y,z,c)), \
 (I[7] = (T)(img)(_p3##x,_p10##y,z,c)), \
 (I[29] = (T)(img)(_p3##x,_p9##y,z,c)), \
 (I[51] = (T)(img)(_p3##x,_p8##y,z,c)), \
 (I[73] = (T)(img)(_p3##x,_p7##y,z,c)), \
 (I[95] = (T)(img)(_p3##x,_p6##y,z,c)), \
 (I[117] = (T)(img)(_p3##x,_p5##y,z,c)), \
 (I[139] = (T)(img)(_p3##x,_p4##y,z,c)), \
 (I[161] = (T)(img)(_p3##x,_p3##y,z,c)), \
 (I[183] = (T)(img)(_p3##x,_p2##y,z,c)), \
 (I[205] = (T)(img)(_p3##x,_p1##y,z,c)), \
 (I[227] = (T)(img)(_p3##x,y,z,c)), \
 (I[249] = (T)(img)(_p3##x,_n1##y,z,c)), \
 (I[271] = (T)(img)(_p3##x,_n2##y,z,c)), \
 (I[293] = (T)(img)(_p3##x,_n3##y,z,c)), \
 (I[315] = (T)(img)(_p3##x,_n4##y,z,c)), \
 (I[337] = (T)(img)(_p3##x,_n5##y,z,c)), \
 (I[359] = (T)(img)(_p3##x,_n6##y,z,c)), \
 (I[381] = (T)(img)(_p3##x,_n7##y,z,c)), \
 (I[403] = (T)(img)(_p3##x,_n8##y,z,c)), \
 (I[425] = (T)(img)(_p3##x,_n9##y,z,c)), \
 (I[447] = (T)(img)(_p3##x,_n10##y,z,c)), \
 (I[469] = (T)(img)(_p3##x,_n11##y,z,c)), \
 (I[8] = (T)(img)(_p2##x,_p10##y,z,c)), \
 (I[30] = (T)(img)(_p2##x,_p9##y,z,c)), \
 (I[52] = (T)(img)(_p2##x,_p8##y,z,c)), \
 (I[74] = (T)(img)(_p2##x,_p7##y,z,c)), \
 (I[96] = (T)(img)(_p2##x,_p6##y,z,c)), \
 (I[118] = (T)(img)(_p2##x,_p5##y,z,c)), \
 (I[140] = (T)(img)(_p2##x,_p4##y,z,c)), \
 (I[162] = (T)(img)(_p2##x,_p3##y,z,c)), \
 (I[184] = (T)(img)(_p2##x,_p2##y,z,c)), \
 (I[206] = (T)(img)(_p2##x,_p1##y,z,c)), \
 (I[228] = (T)(img)(_p2##x,y,z,c)), \
 (I[250] = (T)(img)(_p2##x,_n1##y,z,c)), \
 (I[272] = (T)(img)(_p2##x,_n2##y,z,c)), \
 (I[294] = (T)(img)(_p2##x,_n3##y,z,c)), \
 (I[316] = (T)(img)(_p2##x,_n4##y,z,c)), \
 (I[338] = (T)(img)(_p2##x,_n5##y,z,c)), \
 (I[360] = (T)(img)(_p2##x,_n6##y,z,c)), \
 (I[382] = (T)(img)(_p2##x,_n7##y,z,c)), \
 (I[404] = (T)(img)(_p2##x,_n8##y,z,c)), \
 (I[426] = (T)(img)(_p2##x,_n9##y,z,c)), \
 (I[448] = (T)(img)(_p2##x,_n10##y,z,c)), \
 (I[470] = (T)(img)(_p2##x,_n11##y,z,c)), \
 (I[9] = (T)(img)(_p1##x,_p10##y,z,c)), \
 (I[31] = (T)(img)(_p1##x,_p9##y,z,c)), \
 (I[53] = (T)(img)(_p1##x,_p8##y,z,c)), \
 (I[75] = (T)(img)(_p1##x,_p7##y,z,c)), \
 (I[97] = (T)(img)(_p1##x,_p6##y,z,c)), \
 (I[119] = (T)(img)(_p1##x,_p5##y,z,c)), \
 (I[141] = (T)(img)(_p1##x,_p4##y,z,c)), \
 (I[163] = (T)(img)(_p1##x,_p3##y,z,c)), \
 (I[185] = (T)(img)(_p1##x,_p2##y,z,c)), \
 (I[207] = (T)(img)(_p1##x,_p1##y,z,c)), \
 (I[229] = (T)(img)(_p1##x,y,z,c)), \
 (I[251] = (T)(img)(_p1##x,_n1##y,z,c)), \
 (I[273] = (T)(img)(_p1##x,_n2##y,z,c)), \
 (I[295] = (T)(img)(_p1##x,_n3##y,z,c)), \
 (I[317] = (T)(img)(_p1##x,_n4##y,z,c)), \
 (I[339] = (T)(img)(_p1##x,_n5##y,z,c)), \
 (I[361] = (T)(img)(_p1##x,_n6##y,z,c)), \
 (I[383] = (T)(img)(_p1##x,_n7##y,z,c)), \
 (I[405] = (T)(img)(_p1##x,_n8##y,z,c)), \
 (I[427] = (T)(img)(_p1##x,_n9##y,z,c)), \
 (I[449] = (T)(img)(_p1##x,_n10##y,z,c)), \
 (I[471] = (T)(img)(_p1##x,_n11##y,z,c)), \
 (I[10] = (T)(img)(x,_p10##y,z,c)), \
 (I[32] = (T)(img)(x,_p9##y,z,c)), \
 (I[54] = (T)(img)(x,_p8##y,z,c)), \
 (I[76] = (T)(img)(x,_p7##y,z,c)), \
 (I[98] = (T)(img)(x,_p6##y,z,c)), \
 (I[120] = (T)(img)(x,_p5##y,z,c)), \
 (I[142] = (T)(img)(x,_p4##y,z,c)), \
 (I[164] = (T)(img)(x,_p3##y,z,c)), \
 (I[186] = (T)(img)(x,_p2##y,z,c)), \
 (I[208] = (T)(img)(x,_p1##y,z,c)), \
 (I[230] = (T)(img)(x,y,z,c)), \
 (I[252] = (T)(img)(x,_n1##y,z,c)), \
 (I[274] = (T)(img)(x,_n2##y,z,c)), \
 (I[296] = (T)(img)(x,_n3##y,z,c)), \
 (I[318] = (T)(img)(x,_n4##y,z,c)), \
 (I[340] = (T)(img)(x,_n5##y,z,c)), \
 (I[362] = (T)(img)(x,_n6##y,z,c)), \
 (I[384] = (T)(img)(x,_n7##y,z,c)), \
 (I[406] = (T)(img)(x,_n8##y,z,c)), \
 (I[428] = (T)(img)(x,_n9##y,z,c)), \
 (I[450] = (T)(img)(x,_n10##y,z,c)), \
 (I[472] = (T)(img)(x,_n11##y,z,c)), \
 (I[11] = (T)(img)(_n1##x,_p10##y,z,c)), \
 (I[33] = (T)(img)(_n1##x,_p9##y,z,c)), \
 (I[55] = (T)(img)(_n1##x,_p8##y,z,c)), \
 (I[77] = (T)(img)(_n1##x,_p7##y,z,c)), \
 (I[99] = (T)(img)(_n1##x,_p6##y,z,c)), \
 (I[121] = (T)(img)(_n1##x,_p5##y,z,c)), \
 (I[143] = (T)(img)(_n1##x,_p4##y,z,c)), \
 (I[165] = (T)(img)(_n1##x,_p3##y,z,c)), \
 (I[187] = (T)(img)(_n1##x,_p2##y,z,c)), \
 (I[209] = (T)(img)(_n1##x,_p1##y,z,c)), \
 (I[231] = (T)(img)(_n1##x,y,z,c)), \
 (I[253] = (T)(img)(_n1##x,_n1##y,z,c)), \
 (I[275] = (T)(img)(_n1##x,_n2##y,z,c)), \
 (I[297] = (T)(img)(_n1##x,_n3##y,z,c)), \
 (I[319] = (T)(img)(_n1##x,_n4##y,z,c)), \
 (I[341] = (T)(img)(_n1##x,_n5##y,z,c)), \
 (I[363] = (T)(img)(_n1##x,_n6##y,z,c)), \
 (I[385] = (T)(img)(_n1##x,_n7##y,z,c)), \
 (I[407] = (T)(img)(_n1##x,_n8##y,z,c)), \
 (I[429] = (T)(img)(_n1##x,_n9##y,z,c)), \
 (I[451] = (T)(img)(_n1##x,_n10##y,z,c)), \
 (I[473] = (T)(img)(_n1##x,_n11##y,z,c)), \
 (I[12] = (T)(img)(_n2##x,_p10##y,z,c)), \
 (I[34] = (T)(img)(_n2##x,_p9##y,z,c)), \
 (I[56] = (T)(img)(_n2##x,_p8##y,z,c)), \
 (I[78] = (T)(img)(_n2##x,_p7##y,z,c)), \
 (I[100] = (T)(img)(_n2##x,_p6##y,z,c)), \
 (I[122] = (T)(img)(_n2##x,_p5##y,z,c)), \
 (I[144] = (T)(img)(_n2##x,_p4##y,z,c)), \
 (I[166] = (T)(img)(_n2##x,_p3##y,z,c)), \
 (I[188] = (T)(img)(_n2##x,_p2##y,z,c)), \
 (I[210] = (T)(img)(_n2##x,_p1##y,z,c)), \
 (I[232] = (T)(img)(_n2##x,y,z,c)), \
 (I[254] = (T)(img)(_n2##x,_n1##y,z,c)), \
 (I[276] = (T)(img)(_n2##x,_n2##y,z,c)), \
 (I[298] = (T)(img)(_n2##x,_n3##y,z,c)), \
 (I[320] = (T)(img)(_n2##x,_n4##y,z,c)), \
 (I[342] = (T)(img)(_n2##x,_n5##y,z,c)), \
 (I[364] = (T)(img)(_n2##x,_n6##y,z,c)), \
 (I[386] = (T)(img)(_n2##x,_n7##y,z,c)), \
 (I[408] = (T)(img)(_n2##x,_n8##y,z,c)), \
 (I[430] = (T)(img)(_n2##x,_n9##y,z,c)), \
 (I[452] = (T)(img)(_n2##x,_n10##y,z,c)), \
 (I[474] = (T)(img)(_n2##x,_n11##y,z,c)), \
 (I[13] = (T)(img)(_n3##x,_p10##y,z,c)), \
 (I[35] = (T)(img)(_n3##x,_p9##y,z,c)), \
 (I[57] = (T)(img)(_n3##x,_p8##y,z,c)), \
 (I[79] = (T)(img)(_n3##x,_p7##y,z,c)), \
 (I[101] = (T)(img)(_n3##x,_p6##y,z,c)), \
 (I[123] = (T)(img)(_n3##x,_p5##y,z,c)), \
 (I[145] = (T)(img)(_n3##x,_p4##y,z,c)), \
 (I[167] = (T)(img)(_n3##x,_p3##y,z,c)), \
 (I[189] = (T)(img)(_n3##x,_p2##y,z,c)), \
 (I[211] = (T)(img)(_n3##x,_p1##y,z,c)), \
 (I[233] = (T)(img)(_n3##x,y,z,c)), \
 (I[255] = (T)(img)(_n3##x,_n1##y,z,c)), \
 (I[277] = (T)(img)(_n3##x,_n2##y,z,c)), \
 (I[299] = (T)(img)(_n3##x,_n3##y,z,c)), \
 (I[321] = (T)(img)(_n3##x,_n4##y,z,c)), \
 (I[343] = (T)(img)(_n3##x,_n5##y,z,c)), \
 (I[365] = (T)(img)(_n3##x,_n6##y,z,c)), \
 (I[387] = (T)(img)(_n3##x,_n7##y,z,c)), \
 (I[409] = (T)(img)(_n3##x,_n8##y,z,c)), \
 (I[431] = (T)(img)(_n3##x,_n9##y,z,c)), \
 (I[453] = (T)(img)(_n3##x,_n10##y,z,c)), \
 (I[475] = (T)(img)(_n3##x,_n11##y,z,c)), \
 (I[14] = (T)(img)(_n4##x,_p10##y,z,c)), \
 (I[36] = (T)(img)(_n4##x,_p9##y,z,c)), \
 (I[58] = (T)(img)(_n4##x,_p8##y,z,c)), \
 (I[80] = (T)(img)(_n4##x,_p7##y,z,c)), \
 (I[102] = (T)(img)(_n4##x,_p6##y,z,c)), \
 (I[124] = (T)(img)(_n4##x,_p5##y,z,c)), \
 (I[146] = (T)(img)(_n4##x,_p4##y,z,c)), \
 (I[168] = (T)(img)(_n4##x,_p3##y,z,c)), \
 (I[190] = (T)(img)(_n4##x,_p2##y,z,c)), \
 (I[212] = (T)(img)(_n4##x,_p1##y,z,c)), \
 (I[234] = (T)(img)(_n4##x,y,z,c)), \
 (I[256] = (T)(img)(_n4##x,_n1##y,z,c)), \
 (I[278] = (T)(img)(_n4##x,_n2##y,z,c)), \
 (I[300] = (T)(img)(_n4##x,_n3##y,z,c)), \
 (I[322] = (T)(img)(_n4##x,_n4##y,z,c)), \
 (I[344] = (T)(img)(_n4##x,_n5##y,z,c)), \
 (I[366] = (T)(img)(_n4##x,_n6##y,z,c)), \
 (I[388] = (T)(img)(_n4##x,_n7##y,z,c)), \
 (I[410] = (T)(img)(_n4##x,_n8##y,z,c)), \
 (I[432] = (T)(img)(_n4##x,_n9##y,z,c)), \
 (I[454] = (T)(img)(_n4##x,_n10##y,z,c)), \
 (I[476] = (T)(img)(_n4##x,_n11##y,z,c)), \
 (I[15] = (T)(img)(_n5##x,_p10##y,z,c)), \
 (I[37] = (T)(img)(_n5##x,_p9##y,z,c)), \
 (I[59] = (T)(img)(_n5##x,_p8##y,z,c)), \
 (I[81] = (T)(img)(_n5##x,_p7##y,z,c)), \
 (I[103] = (T)(img)(_n5##x,_p6##y,z,c)), \
 (I[125] = (T)(img)(_n5##x,_p5##y,z,c)), \
 (I[147] = (T)(img)(_n5##x,_p4##y,z,c)), \
 (I[169] = (T)(img)(_n5##x,_p3##y,z,c)), \
 (I[191] = (T)(img)(_n5##x,_p2##y,z,c)), \
 (I[213] = (T)(img)(_n5##x,_p1##y,z,c)), \
 (I[235] = (T)(img)(_n5##x,y,z,c)), \
 (I[257] = (T)(img)(_n5##x,_n1##y,z,c)), \
 (I[279] = (T)(img)(_n5##x,_n2##y,z,c)), \
 (I[301] = (T)(img)(_n5##x,_n3##y,z,c)), \
 (I[323] = (T)(img)(_n5##x,_n4##y,z,c)), \
 (I[345] = (T)(img)(_n5##x,_n5##y,z,c)), \
 (I[367] = (T)(img)(_n5##x,_n6##y,z,c)), \
 (I[389] = (T)(img)(_n5##x,_n7##y,z,c)), \
 (I[411] = (T)(img)(_n5##x,_n8##y,z,c)), \
 (I[433] = (T)(img)(_n5##x,_n9##y,z,c)), \
 (I[455] = (T)(img)(_n5##x,_n10##y,z,c)), \
 (I[477] = (T)(img)(_n5##x,_n11##y,z,c)), \
 (I[16] = (T)(img)(_n6##x,_p10##y,z,c)), \
 (I[38] = (T)(img)(_n6##x,_p9##y,z,c)), \
 (I[60] = (T)(img)(_n6##x,_p8##y,z,c)), \
 (I[82] = (T)(img)(_n6##x,_p7##y,z,c)), \
 (I[104] = (T)(img)(_n6##x,_p6##y,z,c)), \
 (I[126] = (T)(img)(_n6##x,_p5##y,z,c)), \
 (I[148] = (T)(img)(_n6##x,_p4##y,z,c)), \
 (I[170] = (T)(img)(_n6##x,_p3##y,z,c)), \
 (I[192] = (T)(img)(_n6##x,_p2##y,z,c)), \
 (I[214] = (T)(img)(_n6##x,_p1##y,z,c)), \
 (I[236] = (T)(img)(_n6##x,y,z,c)), \
 (I[258] = (T)(img)(_n6##x,_n1##y,z,c)), \
 (I[280] = (T)(img)(_n6##x,_n2##y,z,c)), \
 (I[302] = (T)(img)(_n6##x,_n3##y,z,c)), \
 (I[324] = (T)(img)(_n6##x,_n4##y,z,c)), \
 (I[346] = (T)(img)(_n6##x,_n5##y,z,c)), \
 (I[368] = (T)(img)(_n6##x,_n6##y,z,c)), \
 (I[390] = (T)(img)(_n6##x,_n7##y,z,c)), \
 (I[412] = (T)(img)(_n6##x,_n8##y,z,c)), \
 (I[434] = (T)(img)(_n6##x,_n9##y,z,c)), \
 (I[456] = (T)(img)(_n6##x,_n10##y,z,c)), \
 (I[478] = (T)(img)(_n6##x,_n11##y,z,c)), \
 (I[17] = (T)(img)(_n7##x,_p10##y,z,c)), \
 (I[39] = (T)(img)(_n7##x,_p9##y,z,c)), \
 (I[61] = (T)(img)(_n7##x,_p8##y,z,c)), \
 (I[83] = (T)(img)(_n7##x,_p7##y,z,c)), \
 (I[105] = (T)(img)(_n7##x,_p6##y,z,c)), \
 (I[127] = (T)(img)(_n7##x,_p5##y,z,c)), \
 (I[149] = (T)(img)(_n7##x,_p4##y,z,c)), \
 (I[171] = (T)(img)(_n7##x,_p3##y,z,c)), \
 (I[193] = (T)(img)(_n7##x,_p2##y,z,c)), \
 (I[215] = (T)(img)(_n7##x,_p1##y,z,c)), \
 (I[237] = (T)(img)(_n7##x,y,z,c)), \
 (I[259] = (T)(img)(_n7##x,_n1##y,z,c)), \
 (I[281] = (T)(img)(_n7##x,_n2##y,z,c)), \
 (I[303] = (T)(img)(_n7##x,_n3##y,z,c)), \
 (I[325] = (T)(img)(_n7##x,_n4##y,z,c)), \
 (I[347] = (T)(img)(_n7##x,_n5##y,z,c)), \
 (I[369] = (T)(img)(_n7##x,_n6##y,z,c)), \
 (I[391] = (T)(img)(_n7##x,_n7##y,z,c)), \
 (I[413] = (T)(img)(_n7##x,_n8##y,z,c)), \
 (I[435] = (T)(img)(_n7##x,_n9##y,z,c)), \
 (I[457] = (T)(img)(_n7##x,_n10##y,z,c)), \
 (I[479] = (T)(img)(_n7##x,_n11##y,z,c)), \
 (I[18] = (T)(img)(_n8##x,_p10##y,z,c)), \
 (I[40] = (T)(img)(_n8##x,_p9##y,z,c)), \
 (I[62] = (T)(img)(_n8##x,_p8##y,z,c)), \
 (I[84] = (T)(img)(_n8##x,_p7##y,z,c)), \
 (I[106] = (T)(img)(_n8##x,_p6##y,z,c)), \
 (I[128] = (T)(img)(_n8##x,_p5##y,z,c)), \
 (I[150] = (T)(img)(_n8##x,_p4##y,z,c)), \
 (I[172] = (T)(img)(_n8##x,_p3##y,z,c)), \
 (I[194] = (T)(img)(_n8##x,_p2##y,z,c)), \
 (I[216] = (T)(img)(_n8##x,_p1##y,z,c)), \
 (I[238] = (T)(img)(_n8##x,y,z,c)), \
 (I[260] = (T)(img)(_n8##x,_n1##y,z,c)), \
 (I[282] = (T)(img)(_n8##x,_n2##y,z,c)), \
 (I[304] = (T)(img)(_n8##x,_n3##y,z,c)), \
 (I[326] = (T)(img)(_n8##x,_n4##y,z,c)), \
 (I[348] = (T)(img)(_n8##x,_n5##y,z,c)), \
 (I[370] = (T)(img)(_n8##x,_n6##y,z,c)), \
 (I[392] = (T)(img)(_n8##x,_n7##y,z,c)), \
 (I[414] = (T)(img)(_n8##x,_n8##y,z,c)), \
 (I[436] = (T)(img)(_n8##x,_n9##y,z,c)), \
 (I[458] = (T)(img)(_n8##x,_n10##y,z,c)), \
 (I[480] = (T)(img)(_n8##x,_n11##y,z,c)), \
 (I[19] = (T)(img)(_n9##x,_p10##y,z,c)), \
 (I[41] = (T)(img)(_n9##x,_p9##y,z,c)), \
 (I[63] = (T)(img)(_n9##x,_p8##y,z,c)), \
 (I[85] = (T)(img)(_n9##x,_p7##y,z,c)), \
 (I[107] = (T)(img)(_n9##x,_p6##y,z,c)), \
 (I[129] = (T)(img)(_n9##x,_p5##y,z,c)), \
 (I[151] = (T)(img)(_n9##x,_p4##y,z,c)), \
 (I[173] = (T)(img)(_n9##x,_p3##y,z,c)), \
 (I[195] = (T)(img)(_n9##x,_p2##y,z,c)), \
 (I[217] = (T)(img)(_n9##x,_p1##y,z,c)), \
 (I[239] = (T)(img)(_n9##x,y,z,c)), \
 (I[261] = (T)(img)(_n9##x,_n1##y,z,c)), \
 (I[283] = (T)(img)(_n9##x,_n2##y,z,c)), \
 (I[305] = (T)(img)(_n9##x,_n3##y,z,c)), \
 (I[327] = (T)(img)(_n9##x,_n4##y,z,c)), \
 (I[349] = (T)(img)(_n9##x,_n5##y,z,c)), \
 (I[371] = (T)(img)(_n9##x,_n6##y,z,c)), \
 (I[393] = (T)(img)(_n9##x,_n7##y,z,c)), \
 (I[415] = (T)(img)(_n9##x,_n8##y,z,c)), \
 (I[437] = (T)(img)(_n9##x,_n9##y,z,c)), \
 (I[459] = (T)(img)(_n9##x,_n10##y,z,c)), \
 (I[481] = (T)(img)(_n9##x,_n11##y,z,c)), \
 (I[20] = (T)(img)(_n10##x,_p10##y,z,c)), \
 (I[42] = (T)(img)(_n10##x,_p9##y,z,c)), \
 (I[64] = (T)(img)(_n10##x,_p8##y,z,c)), \
 (I[86] = (T)(img)(_n10##x,_p7##y,z,c)), \
 (I[108] = (T)(img)(_n10##x,_p6##y,z,c)), \
 (I[130] = (T)(img)(_n10##x,_p5##y,z,c)), \
 (I[152] = (T)(img)(_n10##x,_p4##y,z,c)), \
 (I[174] = (T)(img)(_n10##x,_p3##y,z,c)), \
 (I[196] = (T)(img)(_n10##x,_p2##y,z,c)), \
 (I[218] = (T)(img)(_n10##x,_p1##y,z,c)), \
 (I[240] = (T)(img)(_n10##x,y,z,c)), \
 (I[262] = (T)(img)(_n10##x,_n1##y,z,c)), \
 (I[284] = (T)(img)(_n10##x,_n2##y,z,c)), \
 (I[306] = (T)(img)(_n10##x,_n3##y,z,c)), \
 (I[328] = (T)(img)(_n10##x,_n4##y,z,c)), \
 (I[350] = (T)(img)(_n10##x,_n5##y,z,c)), \
 (I[372] = (T)(img)(_n10##x,_n6##y,z,c)), \
 (I[394] = (T)(img)(_n10##x,_n7##y,z,c)), \
 (I[416] = (T)(img)(_n10##x,_n8##y,z,c)), \
 (I[438] = (T)(img)(_n10##x,_n9##y,z,c)), \
 (I[460] = (T)(img)(_n10##x,_n10##y,z,c)), \
 (I[482] = (T)(img)(_n10##x,_n11##y,z,c)), \
 x+11>=(img).width()?(img).width()-1:x+11); \
 x<=(int)(x1) && ((_n11##x<(img).width() && ( \
 (I[21] = (T)(img)(_n11##x,_p10##y,z,c)), \
 (I[43] = (T)(img)(_n11##x,_p9##y,z,c)), \
 (I[65] = (T)(img)(_n11##x,_p8##y,z,c)), \
 (I[87] = (T)(img)(_n11##x,_p7##y,z,c)), \
 (I[109] = (T)(img)(_n11##x,_p6##y,z,c)), \
 (I[131] = (T)(img)(_n11##x,_p5##y,z,c)), \
 (I[153] = (T)(img)(_n11##x,_p4##y,z,c)), \
 (I[175] = (T)(img)(_n11##x,_p3##y,z,c)), \
 (I[197] = (T)(img)(_n11##x,_p2##y,z,c)), \
 (I[219] = (T)(img)(_n11##x,_p1##y,z,c)), \
 (I[241] = (T)(img)(_n11##x,y,z,c)), \
 (I[263] = (T)(img)(_n11##x,_n1##y,z,c)), \
 (I[285] = (T)(img)(_n11##x,_n2##y,z,c)), \
 (I[307] = (T)(img)(_n11##x,_n3##y,z,c)), \
 (I[329] = (T)(img)(_n11##x,_n4##y,z,c)), \
 (I[351] = (T)(img)(_n11##x,_n5##y,z,c)), \
 (I[373] = (T)(img)(_n11##x,_n6##y,z,c)), \
 (I[395] = (T)(img)(_n11##x,_n7##y,z,c)), \
 (I[417] = (T)(img)(_n11##x,_n8##y,z,c)), \
 (I[439] = (T)(img)(_n11##x,_n9##y,z,c)), \
 (I[461] = (T)(img)(_n11##x,_n10##y,z,c)), \
 (I[483] = (T)(img)(_n11##x,_n11##y,z,c)),1)) || \
 _n10##x==--_n11##x || _n9##x==--_n10##x || _n8##x==--_n9##x || _n7##x==--_n8##x || _n6##x==--_n7##x || _n5##x==--_n6##x || _n4##x==--_n5##x || _n3##x==--_n4##x || _n2##x==--_n3##x || _n1##x==--_n2##x || x==(_n11##x = _n10##x = _n9##x = _n8##x = _n7##x = _n6##x = _n5##x = _n4##x = _n3##x = _n2##x = --_n1##x)); \
 I[0] = I[1], I[1] = I[2], I[2] = I[3], I[3] = I[4], I[4] = I[5], I[5] = I[6], I[6] = I[7], I[7] = I[8], I[8] = I[9], I[9] = I[10], I[10] = I[11], I[11] = I[12], I[12] = I[13], I[13] = I[14], I[14] = I[15], I[15] = I[16], I[16] = I[17], I[17] = I[18], I[18] = I[19], I[19] = I[20], I[20] = I[21], \
 I[22] = I[23], I[23] = I[24], I[24] = I[25], I[25] = I[26], I[26] = I[27], I[27] = I[28], I[28] = I[29], I[29] = I[30], I[30] = I[31], I[31] = I[32], I[32] = I[33], I[33] = I[34], I[34] = I[35], I[35] = I[36], I[36] = I[37], I[37] = I[38], I[38] = I[39], I[39] = I[40], I[40] = I[41], I[41] = I[42], I[42] = I[43], \
 I[44] = I[45], I[45] = I[46], I[46] = I[47], I[47] = I[48], I[48] = I[49], I[49] = I[50], I[50] = I[51], I[51] = I[52], I[52] = I[53], I[53] = I[54], I[54] = I[55], I[55] = I[56], I[56] = I[57], I[57] = I[58], I[58] = I[59], I[59] = I[60], I[60] = I[61], I[61] = I[62], I[62] = I[63], I[63] = I[64], I[64] = I[65], \
 I[66] = I[67], I[67] = I[68], I[68] = I[69], I[69] = I[70], I[70] = I[71], I[71] = I[72], I[72] = I[73], I[73] = I[74], I[74] = I[75], I[75] = I[76], I[76] = I[77], I[77] = I[78], I[78] = I[79], I[79] = I[80], I[80] = I[81], I[81] = I[82], I[82] = I[83], I[83] = I[84], I[84] = I[85], I[85] = I[86], I[86] = I[87], \
 I[88] = I[89], I[89] = I[90], I[90] = I[91], I[91] = I[92], I[92] = I[93], I[93] = I[94], I[94] = I[95], I[95] = I[96], I[96] = I[97], I[97] = I[98], I[98] = I[99], I[99] = I[100], I[100] = I[101], I[101] = I[102], I[102] = I[103], I[103] = I[104], I[104] = I[105], I[105] = I[106], I[106] = I[107], I[107] = I[108], I[108] = I[109], \
 I[110] = I[111], I[111] = I[112], I[112] = I[113], I[113] = I[114], I[114] = I[115], I[115] = I[116], I[116] = I[117], I[117] = I[118], I[118] = I[119], I[119] = I[120], I[120] = I[121], I[121] = I[122], I[122] = I[123], I[123] = I[124], I[124] = I[125], I[125] = I[126], I[126] = I[127], I[127] = I[128], I[128] = I[129], I[129] = I[130], I[130] = I[131], \
 I[132] = I[133], I[133] = I[134], I[134] = I[135], I[135] = I[136], I[136] = I[137], I[137] = I[138], I[138] = I[139], I[139] = I[140], I[140] = I[141], I[141] = I[142], I[142] = I[143], I[143] = I[144], I[144] = I[145], I[145] = I[146], I[146] = I[147], I[147] = I[148], I[148] = I[149], I[149] = I[150], I[150] = I[151], I[151] = I[152], I[152] = I[153], \
 I[154] = I[155], I[155] = I[156], I[156] = I[157], I[157] = I[158], I[158] = I[159], I[159] = I[160], I[160] = I[161], I[161] = I[162], I[162] = I[163], I[163] = I[164], I[164] = I[165], I[165] = I[166], I[166] = I[167], I[167] = I[168], I[168] = I[169], I[169] = I[170], I[170] = I[171], I[171] = I[172], I[172] = I[173], I[173] = I[174], I[174] = I[175], \
 I[176] = I[177], I[177] = I[178], I[178] = I[179], I[179] = I[180], I[180] = I[181], I[181] = I[182], I[182] = I[183], I[183] = I[184], I[184] = I[185], I[185] = I[186], I[186] = I[187], I[187] = I[188], I[188] = I[189], I[189] = I[190], I[190] = I[191], I[191] = I[192], I[192] = I[193], I[193] = I[194], I[194] = I[195], I[195] = I[196], I[196] = I[197], \
 I[198] = I[199], I[199] = I[200], I[200] = I[201], I[201] = I[202], I[202] = I[203], I[203] = I[204], I[204] = I[205], I[205] = I[206], I[206] = I[207], I[207] = I[208], I[208] = I[209], I[209] = I[210], I[210] = I[211], I[211] = I[212], I[212] = I[213], I[213] = I[214], I[214] = I[215], I[215] = I[216], I[216] = I[217], I[217] = I[218], I[218] = I[219], \
 I[220] = I[221], I[221] = I[222], I[222] = I[223], I[223] = I[224], I[224] = I[225], I[225] = I[226], I[226] = I[227], I[227] = I[228], I[228] = I[229], I[229] = I[230], I[230] = I[231], I[231] = I[232], I[232] = I[233], I[233] = I[234], I[234] = I[235], I[235] = I[236], I[236] = I[237], I[237] = I[238], I[238] = I[239], I[239] = I[240], I[240] = I[241], \
 I[242] = I[243], I[243] = I[244], I[244] = I[245], I[245] = I[246], I[246] = I[247], I[247] = I[248], I[248] = I[249], I[249] = I[250], I[250] = I[251], I[251] = I[252], I[252] = I[253], I[253] = I[254], I[254] = I[255], I[255] = I[256], I[256] = I[257], I[257] = I[258], I[258] = I[259], I[259] = I[260], I[260] = I[261], I[261] = I[262], I[262] = I[263], \
 I[264] = I[265], I[265] = I[266], I[266] = I[267], I[267] = I[268], I[268] = I[269], I[269] = I[270], I[270] = I[271], I[271] = I[272], I[272] = I[273], I[273] = I[274], I[274] = I[275], I[275] = I[276], I[276] = I[277], I[277] = I[278], I[278] = I[279], I[279] = I[280], I[280] = I[281], I[281] = I[282], I[282] = I[283], I[283] = I[284], I[284] = I[285], \
 I[286] = I[287], I[287] = I[288], I[288] = I[289], I[289] = I[290], I[290] = I[291], I[291] = I[292], I[292] = I[293], I[293] = I[294], I[294] = I[295], I[295] = I[296], I[296] = I[297], I[297] = I[298], I[298] = I[299], I[299] = I[300], I[300] = I[301], I[301] = I[302], I[302] = I[303], I[303] = I[304], I[304] = I[305], I[305] = I[306], I[306] = I[307], \
 I[308] = I[309], I[309] = I[310], I[310] = I[311], I[311] = I[312], I[312] = I[313], I[313] = I[314], I[314] = I[315], I[315] = I[316], I[316] = I[317], I[317] = I[318], I[318] = I[319], I[319] = I[320], I[320] = I[321], I[321] = I[322], I[322] = I[323], I[323] = I[324], I[324] = I[325], I[325] = I[326], I[326] = I[327], I[327] = I[328], I[328] = I[329], \
 I[330] = I[331], I[331] = I[332], I[332] = I[333], I[333] = I[334], I[334] = I[335], I[335] = I[336], I[336] = I[337], I[337] = I[338], I[338] = I[339], I[339] = I[340], I[340] = I[341], I[341] = I[342], I[342] = I[343], I[343] = I[344], I[344] = I[345], I[345] = I[346], I[346] = I[347], I[347] = I[348], I[348] = I[349], I[349] = I[350], I[350] = I[351], \
 I[352] = I[353], I[353] = I[354], I[354] = I[355], I[355] = I[356], I[356] = I[357], I[357] = I[358], I[358] = I[359], I[359] = I[360], I[360] = I[361], I[361] = I[362], I[362] = I[363], I[363] = I[364], I[364] = I[365], I[365] = I[366], I[366] = I[367], I[367] = I[368], I[368] = I[369], I[369] = I[370], I[370] = I[371], I[371] = I[372], I[372] = I[373], \
 I[374] = I[375], I[375] = I[376], I[376] = I[377], I[377] = I[378], I[378] = I[379], I[379] = I[380], I[380] = I[381], I[381] = I[382], I[382] = I[383], I[383] = I[384], I[384] = I[385], I[385] = I[386], I[386] = I[387], I[387] = I[388], I[388] = I[389], I[389] = I[390], I[390] = I[391], I[391] = I[392], I[392] = I[393], I[393] = I[394], I[394] = I[395], \
 I[396] = I[397], I[397] = I[398], I[398] = I[399], I[399] = I[400], I[400] = I[401], I[401] = I[402], I[402] = I[403], I[403] = I[404], I[404] = I[405], I[405] = I[406], I[406] = I[407], I[407] = I[408], I[408] = I[409], I[409] = I[410], I[410] = I[411], I[411] = I[412], I[412] = I[413], I[413] = I[414], I[414] = I[415], I[415] = I[416], I[416] = I[417], \
 I[418] = I[419], I[419] = I[420], I[420] = I[421], I[421] = I[422], I[422] = I[423], I[423] = I[424], I[424] = I[425], I[425] = I[426], I[426] = I[427], I[427] = I[428], I[428] = I[429], I[429] = I[430], I[430] = I[431], I[431] = I[432], I[432] = I[433], I[433] = I[434], I[434] = I[435], I[435] = I[436], I[436] = I[437], I[437] = I[438], I[438] = I[439], \
 I[440] = I[441], I[441] = I[442], I[442] = I[443], I[443] = I[444], I[444] = I[445], I[445] = I[446], I[446] = I[447], I[447] = I[448], I[448] = I[449], I[449] = I[450], I[450] = I[451], I[451] = I[452], I[452] = I[453], I[453] = I[454], I[454] = I[455], I[455] = I[456], I[456] = I[457], I[457] = I[458], I[458] = I[459], I[459] = I[460], I[460] = I[461], \
 I[462] = I[463], I[463] = I[464], I[464] = I[465], I[465] = I[466], I[466] = I[467], I[467] = I[468], I[468] = I[469], I[469] = I[470], I[470] = I[471], I[471] = I[472], I[472] = I[473], I[473] = I[474], I[474] = I[475], I[475] = I[476], I[476] = I[477], I[477] = I[478], I[478] = I[479], I[479] = I[480], I[480] = I[481], I[481] = I[482], I[482] = I[483], \
 _p10##x = _p9##x, _p9##x = _p8##x, _p8##x = _p7##x, _p7##x = _p6##x, _p6##x = _p5##x, _p5##x = _p4##x, _p4##x = _p3##x, _p3##x = _p2##x, _p2##x = _p1##x, _p1##x = x++, ++_n1##x, ++_n2##x, ++_n3##x, ++_n4##x, ++_n5##x, ++_n6##x, ++_n7##x, ++_n8##x, ++_n9##x, ++_n10##x, ++_n11##x)

#define cimg_get22x22(img,x,y,z,c,I,T) \
 I[0] = (T)(img)(_p10##x,_p10##y,z,c), I[1] = (T)(img)(_p9##x,_p10##y,z,c), I[2] = (T)(img)(_p8##x,_p10##y,z,c), I[3] = (T)(img)(_p7##x,_p10##y,z,c), I[4] = (T)(img)(_p6##x,_p10##y,z,c), I[5] = (T)(img)(_p5##x,_p10##y,z,c), I[6] = (T)(img)(_p4##x,_p10##y,z,c), I[7] = (T)(img)(_p3##x,_p10##y,z,c), I[8] = (T)(img)(_p2##x,_p10##y,z,c), I[9] = (T)(img)(_p1##x,_p10##y,z,c), I[10] = (T)(img)(x,_p10##y,z,c), I[11] = (T)(img)(_n1##x,_p10##y,z,c), I[12] = (T)(img)(_n2##x,_p10##y,z,c), I[13] = (T)(img)(_n3##x,_p10##y,z,c), I[14] = (T)(img)(_n4##x,_p10##y,z,c), I[15] = (T)(img)(_n5##x,_p10##y,z,c), I[16] = (T)(img)(_n6##x,_p10##y,z,c), I[17] = (T)(img)(_n7##x,_p10##y,z,c), I[18] = (T)(img)(_n8##x,_p10##y,z,c), I[19] = (T)(img)(_n9##x,_p10##y,z,c), I[20] = (T)(img)(_n10##x,_p10##y,z,c), I[21] = (T)(img)(_n11##x,_p10##y,z,c), \
 I[22] = (T)(img)(_p10##x,_p9##y,z,c), I[23] = (T)(img)(_p9##x,_p9##y,z,c), I[24] = (T)(img)(_p8##x,_p9##y,z,c), I[25] = (T)(img)(_p7##x,_p9##y,z,c), I[26] = (T)(img)(_p6##x,_p9##y,z,c), I[27] = (T)(img)(_p5##x,_p9##y,z,c), I[28] = (T)(img)(_p4##x,_p9##y,z,c), I[29] = (T)(img)(_p3##x,_p9##y,z,c), I[30] = (T)(img)(_p2##x,_p9##y,z,c), I[31] = (T)(img)(_p1##x,_p9##y,z,c), I[32] = (T)(img)(x,_p9##y,z,c), I[33] = (T)(img)(_n1##x,_p9##y,z,c), I[34] = (T)(img)(_n2##x,_p9##y,z,c), I[35] = (T)(img)(_n3##x,_p9##y,z,c), I[36] = (T)(img)(_n4##x,_p9##y,z,c), I[37] = (T)(img)(_n5##x,_p9##y,z,c), I[38] = (T)(img)(_n6##x,_p9##y,z,c), I[39] = (T)(img)(_n7##x,_p9##y,z,c), I[40] = (T)(img)(_n8##x,_p9##y,z,c), I[41] = (T)(img)(_n9##x,_p9##y,z,c), I[42] = (T)(img)(_n10##x,_p9##y,z,c), I[43] = (T)(img)(_n11##x,_p9##y,z,c), \
 I[44] = (T)(img)(_p10##x,_p8##y,z,c), I[45] = (T)(img)(_p9##x,_p8##y,z,c), I[46] = (T)(img)(_p8##x,_p8##y,z,c), I[47] = (T)(img)(_p7##x,_p8##y,z,c), I[48] = (T)(img)(_p6##x,_p8##y,z,c), I[49] = (T)(img)(_p5##x,_p8##y,z,c), I[50] = (T)(img)(_p4##x,_p8##y,z,c), I[51] = (T)(img)(_p3##x,_p8##y,z,c), I[52] = (T)(img)(_p2##x,_p8##y,z,c), I[53] = (T)(img)(_p1##x,_p8##y,z,c), I[54] = (T)(img)(x,_p8##y,z,c), I[55] = (T)(img)(_n1##x,_p8##y,z,c), I[56] = (T)(img)(_n2##x,_p8##y,z,c), I[57] = (T)(img)(_n3##x,_p8##y,z,c), I[58] = (T)(img)(_n4##x,_p8##y,z,c), I[59] = (T)(img)(_n5##x,_p8##y,z,c), I[60] = (T)(img)(_n6##x,_p8##y,z,c), I[61] = (T)(img)(_n7##x,_p8##y,z,c), I[62] = (T)(img)(_n8##x,_p8##y,z,c), I[63] = (T)(img)(_n9##x,_p8##y,z,c), I[64] = (T)(img)(_n10##x,_p8##y,z,c), I[65] = (T)(img)(_n11##x,_p8##y,z,c), \
 I[66] = (T)(img)(_p10##x,_p7##y,z,c), I[67] = (T)(img)(_p9##x,_p7##y,z,c), I[68] = (T)(img)(_p8##x,_p7##y,z,c), I[69] = (T)(img)(_p7##x,_p7##y,z,c), I[70] = (T)(img)(_p6##x,_p7##y,z,c), I[71] = (T)(img)(_p5##x,_p7##y,z,c), I[72] = (T)(img)(_p4##x,_p7##y,z,c), I[73] = (T)(img)(_p3##x,_p7##y,z,c), I[74] = (T)(img)(_p2##x,_p7##y,z,c), I[75] = (T)(img)(_p1##x,_p7##y,z,c), I[76] = (T)(img)(x,_p7##y,z,c), I[77] = (T)(img)(_n1##x,_p7##y,z,c), I[78] = (T)(img)(_n2##x,_p7##y,z,c), I[79] = (T)(img)(_n3##x,_p7##y,z,c), I[80] = (T)(img)(_n4##x,_p7##y,z,c), I[81] = (T)(img)(_n5##x,_p7##y,z,c), I[82] = (T)(img)(_n6##x,_p7##y,z,c), I[83] = (T)(img)(_n7##x,_p7##y,z,c), I[84] = (T)(img)(_n8##x,_p7##y,z,c), I[85] = (T)(img)(_n9##x,_p7##y,z,c), I[86] = (T)(img)(_n10##x,_p7##y,z,c), I[87] = (T)(img)(_n11##x,_p7##y,z,c), \
 I[88] = (T)(img)(_p10##x,_p6##y,z,c), I[89] = (T)(img)(_p9##x,_p6##y,z,c), I[90] = (T)(img)(_p8##x,_p6##y,z,c), I[91] = (T)(img)(_p7##x,_p6##y,z,c), I[92] = (T)(img)(_p6##x,_p6##y,z,c), I[93] = (T)(img)(_p5##x,_p6##y,z,c), I[94] = (T)(img)(_p4##x,_p6##y,z,c), I[95] = (T)(img)(_p3##x,_p6##y,z,c), I[96] = (T)(img)(_p2##x,_p6##y,z,c), I[97] = (T)(img)(_p1##x,_p6##y,z,c), I[98] = (T)(img)(x,_p6##y,z,c), I[99] = (T)(img)(_n1##x,_p6##y,z,c), I[100] = (T)(img)(_n2##x,_p6##y,z,c), I[101] = (T)(img)(_n3##x,_p6##y,z,c), I[102] = (T)(img)(_n4##x,_p6##y,z,c), I[103] = (T)(img)(_n5##x,_p6##y,z,c), I[104] = (T)(img)(_n6##x,_p6##y,z,c), I[105] = (T)(img)(_n7##x,_p6##y,z,c), I[106] = (T)(img)(_n8##x,_p6##y,z,c), I[107] = (T)(img)(_n9##x,_p6##y,z,c), I[108] = (T)(img)(_n10##x,_p6##y,z,c), I[109] = (T)(img)(_n11##x,_p6##y,z,c), \
 I[110] = (T)(img)(_p10##x,_p5##y,z,c), I[111] = (T)(img)(_p9##x,_p5##y,z,c), I[112] = (T)(img)(_p8##x,_p5##y,z,c), I[113] = (T)(img)(_p7##x,_p5##y,z,c), I[114] = (T)(img)(_p6##x,_p5##y,z,c), I[115] = (T)(img)(_p5##x,_p5##y,z,c), I[116] = (T)(img)(_p4##x,_p5##y,z,c), I[117] = (T)(img)(_p3##x,_p5##y,z,c), I[118] = (T)(img)(_p2##x,_p5##y,z,c), I[119] = (T)(img)(_p1##x,_p5##y,z,c), I[120] = (T)(img)(x,_p5##y,z,c), I[121] = (T)(img)(_n1##x,_p5##y,z,c), I[122] = (T)(img)(_n2##x,_p5##y,z,c), I[123] = (T)(img)(_n3##x,_p5##y,z,c), I[124] = (T)(img)(_n4##x,_p5##y,z,c), I[125] = (T)(img)(_n5##x,_p5##y,z,c), I[126] = (T)(img)(_n6##x,_p5##y,z,c), I[127] = (T)(img)(_n7##x,_p5##y,z,c), I[128] = (T)(img)(_n8##x,_p5##y,z,c), I[129] = (T)(img)(_n9##x,_p5##y,z,c), I[130] = (T)(img)(_n10##x,_p5##y,z,c), I[131] = (T)(img)(_n11##x,_p5##y,z,c), \
 I[132] = (T)(img)(_p10##x,_p4##y,z,c), I[133] = (T)(img)(_p9##x,_p4##y,z,c), I[134] = (T)(img)(_p8##x,_p4##y,z,c), I[135] = (T)(img)(_p7##x,_p4##y,z,c), I[136] = (T)(img)(_p6##x,_p4##y,z,c), I[137] = (T)(img)(_p5##x,_p4##y,z,c), I[138] = (T)(img)(_p4##x,_p4##y,z,c), I[139] = (T)(img)(_p3##x,_p4##y,z,c), I[140] = (T)(img)(_p2##x,_p4##y,z,c), I[141] = (T)(img)(_p1##x,_p4##y,z,c), I[142] = (T)(img)(x,_p4##y,z,c), I[143] = (T)(img)(_n1##x,_p4##y,z,c), I[144] = (T)(img)(_n2##x,_p4##y,z,c), I[145] = (T)(img)(_n3##x,_p4##y,z,c), I[146] = (T)(img)(_n4##x,_p4##y,z,c), I[147] = (T)(img)(_n5##x,_p4##y,z,c), I[148] = (T)(img)(_n6##x,_p4##y,z,c), I[149] = (T)(img)(_n7##x,_p4##y,z,c), I[150] = (T)(img)(_n8##x,_p4##y,z,c), I[151] = (T)(img)(_n9##x,_p4##y,z,c), I[152] = (T)(img)(_n10##x,_p4##y,z,c), I[153] = (T)(img)(_n11##x,_p4##y,z,c), \
 I[154] = (T)(img)(_p10##x,_p3##y,z,c), I[155] = (T)(img)(_p9##x,_p3##y,z,c), I[156] = (T)(img)(_p8##x,_p3##y,z,c), I[157] = (T)(img)(_p7##x,_p3##y,z,c), I[158] = (T)(img)(_p6##x,_p3##y,z,c), I[159] = (T)(img)(_p5##x,_p3##y,z,c), I[160] = (T)(img)(_p4##x,_p3##y,z,c), I[161] = (T)(img)(_p3##x,_p3##y,z,c), I[162] = (T)(img)(_p2##x,_p3##y,z,c), I[163] = (T)(img)(_p1##x,_p3##y,z,c), I[164] = (T)(img)(x,_p3##y,z,c), I[165] = (T)(img)(_n1##x,_p3##y,z,c), I[166] = (T)(img)(_n2##x,_p3##y,z,c), I[167] = (T)(img)(_n3##x,_p3##y,z,c), I[168] = (T)(img)(_n4##x,_p3##y,z,c), I[169] = (T)(img)(_n5##x,_p3##y,z,c), I[170] = (T)(img)(_n6##x,_p3##y,z,c), I[171] = (T)(img)(_n7##x,_p3##y,z,c), I[172] = (T)(img)(_n8##x,_p3##y,z,c), I[173] = (T)(img)(_n9##x,_p3##y,z,c), I[174] = (T)(img)(_n10##x,_p3##y,z,c), I[175] = (T)(img)(_n11##x,_p3##y,z,c), \
 I[176] = (T)(img)(_p10##x,_p2##y,z,c), I[177] = (T)(img)(_p9##x,_p2##y,z,c), I[178] = (T)(img)(_p8##x,_p2##y,z,c), I[179] = (T)(img)(_p7##x,_p2##y,z,c), I[180] = (T)(img)(_p6##x,_p2##y,z,c), I[181] = (T)(img)(_p5##x,_p2##y,z,c), I[182] = (T)(img)(_p4##x,_p2##y,z,c), I[183] = (T)(img)(_p3##x,_p2##y,z,c), I[184] = (T)(img)(_p2##x,_p2##y,z,c), I[185] = (T)(img)(_p1##x,_p2##y,z,c), I[186] = (T)(img)(x,_p2##y,z,c), I[187] = (T)(img)(_n1##x,_p2##y,z,c), I[188] = (T)(img)(_n2##x,_p2##y,z,c), I[189] = (T)(img)(_n3##x,_p2##y,z,c), I[190] = (T)(img)(_n4##x,_p2##y,z,c), I[191] = (T)(img)(_n5##x,_p2##y,z,c), I[192] = (T)(img)(_n6##x,_p2##y,z,c), I[193] = (T)(img)(_n7##x,_p2##y,z,c), I[194] = (T)(img)(_n8##x,_p2##y,z,c), I[195] = (T)(img)(_n9##x,_p2##y,z,c), I[196] = (T)(img)(_n10##x,_p2##y,z,c), I[197] = (T)(img)(_n11##x,_p2##y,z,c), \
 I[198] = (T)(img)(_p10##x,_p1##y,z,c), I[199] = (T)(img)(_p9##x,_p1##y,z,c), I[200] = (T)(img)(_p8##x,_p1##y,z,c), I[201] = (T)(img)(_p7##x,_p1##y,z,c), I[202] = (T)(img)(_p6##x,_p1##y,z,c), I[203] = (T)(img)(_p5##x,_p1##y,z,c), I[204] = (T)(img)(_p4##x,_p1##y,z,c), I[205] = (T)(img)(_p3##x,_p1##y,z,c), I[206] = (T)(img)(_p2##x,_p1##y,z,c), I[207] = (T)(img)(_p1##x,_p1##y,z,c), I[208] = (T)(img)(x,_p1##y,z,c), I[209] = (T)(img)(_n1##x,_p1##y,z,c), I[210] = (T)(img)(_n2##x,_p1##y,z,c), I[211] = (T)(img)(_n3##x,_p1##y,z,c), I[212] = (T)(img)(_n4##x,_p1##y,z,c), I[213] = (T)(img)(_n5##x,_p1##y,z,c), I[214] = (T)(img)(_n6##x,_p1##y,z,c), I[215] = (T)(img)(_n7##x,_p1##y,z,c), I[216] = (T)(img)(_n8##x,_p1##y,z,c), I[217] = (T)(img)(_n9##x,_p1##y,z,c), I[218] = (T)(img)(_n10##x,_p1##y,z,c), I[219] = (T)(img)(_n11##x,_p1##y,z,c), \
 I[220] = (T)(img)(_p10##x,y,z,c), I[221] = (T)(img)(_p9##x,y,z,c), I[222] = (T)(img)(_p8##x,y,z,c), I[223] = (T)(img)(_p7##x,y,z,c), I[224] = (T)(img)(_p6##x,y,z,c), I[225] = (T)(img)(_p5##x,y,z,c), I[226] = (T)(img)(_p4##x,y,z,c), I[227] = (T)(img)(_p3##x,y,z,c), I[228] = (T)(img)(_p2##x,y,z,c), I[229] = (T)(img)(_p1##x,y,z,c), I[230] = (T)(img)(x,y,z,c), I[231] = (T)(img)(_n1##x,y,z,c), I[232] = (T)(img)(_n2##x,y,z,c), I[233] = (T)(img)(_n3##x,y,z,c), I[234] = (T)(img)(_n4##x,y,z,c), I[235] = (T)(img)(_n5##x,y,z,c), I[236] = (T)(img)(_n6##x,y,z,c), I[237] = (T)(img)(_n7##x,y,z,c), I[238] = (T)(img)(_n8##x,y,z,c), I[239] = (T)(img)(_n9##x,y,z,c), I[240] = (T)(img)(_n10##x,y,z,c), I[241] = (T)(img)(_n11##x,y,z,c), \
 I[242] = (T)(img)(_p10##x,_n1##y,z,c), I[243] = (T)(img)(_p9##x,_n1##y,z,c), I[244] = (T)(img)(_p8##x,_n1##y,z,c), I[245] = (T)(img)(_p7##x,_n1##y,z,c), I[246] = (T)(img)(_p6##x,_n1##y,z,c), I[247] = (T)(img)(_p5##x,_n1##y,z,c), I[248] = (T)(img)(_p4##x,_n1##y,z,c), I[249] = (T)(img)(_p3##x,_n1##y,z,c), I[250] = (T)(img)(_p2##x,_n1##y,z,c), I[251] = (T)(img)(_p1##x,_n1##y,z,c), I[252] = (T)(img)(x,_n1##y,z,c), I[253] = (T)(img)(_n1##x,_n1##y,z,c), I[254] = (T)(img)(_n2##x,_n1##y,z,c), I[255] = (T)(img)(_n3##x,_n1##y,z,c), I[256] = (T)(img)(_n4##x,_n1##y,z,c), I[257] = (T)(img)(_n5##x,_n1##y,z,c), I[258] = (T)(img)(_n6##x,_n1##y,z,c), I[259] = (T)(img)(_n7##x,_n1##y,z,c), I[260] = (T)(img)(_n8##x,_n1##y,z,c), I[261] = (T)(img)(_n9##x,_n1##y,z,c), I[262] = (T)(img)(_n10##x,_n1##y,z,c), I[263] = (T)(img)(_n11##x,_n1##y,z,c), \
 I[264] = (T)(img)(_p10##x,_n2##y,z,c), I[265] = (T)(img)(_p9##x,_n2##y,z,c), I[266] = (T)(img)(_p8##x,_n2##y,z,c), I[267] = (T)(img)(_p7##x,_n2##y,z,c), I[268] = (T)(img)(_p6##x,_n2##y,z,c), I[269] = (T)(img)(_p5##x,_n2##y,z,c), I[270] = (T)(img)(_p4##x,_n2##y,z,c), I[271] = (T)(img)(_p3##x,_n2##y,z,c), I[272] = (T)(img)(_p2##x,_n2##y,z,c), I[273] = (T)(img)(_p1##x,_n2##y,z,c), I[274] = (T)(img)(x,_n2##y,z,c), I[275] = (T)(img)(_n1##x,_n2##y,z,c), I[276] = (T)(img)(_n2##x,_n2##y,z,c), I[277] = (T)(img)(_n3##x,_n2##y,z,c), I[278] = (T)(img)(_n4##x,_n2##y,z,c), I[279] = (T)(img)(_n5##x,_n2##y,z,c), I[280] = (T)(img)(_n6##x,_n2##y,z,c), I[281] = (T)(img)(_n7##x,_n2##y,z,c), I[282] = (T)(img)(_n8##x,_n2##y,z,c), I[283] = (T)(img)(_n9##x,_n2##y,z,c), I[284] = (T)(img)(_n10##x,_n2##y,z,c), I[285] = (T)(img)(_n11##x,_n2##y,z,c), \
 I[286] = (T)(img)(_p10##x,_n3##y,z,c), I[287] = (T)(img)(_p9##x,_n3##y,z,c), I[288] = (T)(img)(_p8##x,_n3##y,z,c), I[289] = (T)(img)(_p7##x,_n3##y,z,c), I[290] = (T)(img)(_p6##x,_n3##y,z,c), I[291] = (T)(img)(_p5##x,_n3##y,z,c), I[292] = (T)(img)(_p4##x,_n3##y,z,c), I[293] = (T)(img)(_p3##x,_n3##y,z,c), I[294] = (T)(img)(_p2##x,_n3##y,z,c), I[295] = (T)(img)(_p1##x,_n3##y,z,c), I[296] = (T)(img)(x,_n3##y,z,c), I[297] = (T)(img)(_n1##x,_n3##y,z,c), I[298] = (T)(img)(_n2##x,_n3##y,z,c), I[299] = (T)(img)(_n3##x,_n3##y,z,c), I[300] = (T)(img)(_n4##x,_n3##y,z,c), I[301] = (T)(img)(_n5##x,_n3##y,z,c), I[302] = (T)(img)(_n6##x,_n3##y,z,c), I[303] = (T)(img)(_n7##x,_n3##y,z,c), I[304] = (T)(img)(_n8##x,_n3##y,z,c), I[305] = (T)(img)(_n9##x,_n3##y,z,c), I[306] = (T)(img)(_n10##x,_n3##y,z,c), I[307] = (T)(img)(_n11##x,_n3##y,z,c), \
 I[308] = (T)(img)(_p10##x,_n4##y,z,c), I[309] = (T)(img)(_p9##x,_n4##y,z,c), I[310] = (T)(img)(_p8##x,_n4##y,z,c), I[311] = (T)(img)(_p7##x,_n4##y,z,c), I[312] = (T)(img)(_p6##x,_n4##y,z,c), I[313] = (T)(img)(_p5##x,_n4##y,z,c), I[314] = (T)(img)(_p4##x,_n4##y,z,c), I[315] = (T)(img)(_p3##x,_n4##y,z,c), I[316] = (T)(img)(_p2##x,_n4##y,z,c), I[317] = (T)(img)(_p1##x,_n4##y,z,c), I[318] = (T)(img)(x,_n4##y,z,c), I[319] = (T)(img)(_n1##x,_n4##y,z,c), I[320] = (T)(img)(_n2##x,_n4##y,z,c), I[321] = (T)(img)(_n3##x,_n4##y,z,c), I[322] = (T)(img)(_n4##x,_n4##y,z,c), I[323] = (T)(img)(_n5##x,_n4##y,z,c), I[324] = (T)(img)(_n6##x,_n4##y,z,c), I[325] = (T)(img)(_n7##x,_n4##y,z,c), I[326] = (T)(img)(_n8##x,_n4##y,z,c), I[327] = (T)(img)(_n9##x,_n4##y,z,c), I[328] = (T)(img)(_n10##x,_n4##y,z,c), I[329] = (T)(img)(_n11##x,_n4##y,z,c), \
 I[330] = (T)(img)(_p10##x,_n5##y,z,c), I[331] = (T)(img)(_p9##x,_n5##y,z,c), I[332] = (T)(img)(_p8##x,_n5##y,z,c), I[333] = (T)(img)(_p7##x,_n5##y,z,c), I[334] = (T)(img)(_p6##x,_n5##y,z,c), I[335] = (T)(img)(_p5##x,_n5##y,z,c), I[336] = (T)(img)(_p4##x,_n5##y,z,c), I[337] = (T)(img)(_p3##x,_n5##y,z,c), I[338] = (T)(img)(_p2##x,_n5##y,z,c), I[339] = (T)(img)(_p1##x,_n5##y,z,c), I[340] = (T)(img)(x,_n5##y,z,c), I[341] = (T)(img)(_n1##x,_n5##y,z,c), I[342] = (T)(img)(_n2##x,_n5##y,z,c), I[343] = (T)(img)(_n3##x,_n5##y,z,c), I[344] = (T)(img)(_n4##x,_n5##y,z,c), I[345] = (T)(img)(_n5##x,_n5##y,z,c), I[346] = (T)(img)(_n6##x,_n5##y,z,c), I[347] = (T)(img)(_n7##x,_n5##y,z,c), I[348] = (T)(img)(_n8##x,_n5##y,z,c), I[349] = (T)(img)(_n9##x,_n5##y,z,c), I[350] = (T)(img)(_n10##x,_n5##y,z,c), I[351] = (T)(img)(_n11##x,_n5##y,z,c), \
 I[352] = (T)(img)(_p10##x,_n6##y,z,c), I[353] = (T)(img)(_p9##x,_n6##y,z,c), I[354] = (T)(img)(_p8##x,_n6##y,z,c), I[355] = (T)(img)(_p7##x,_n6##y,z,c), I[356] = (T)(img)(_p6##x,_n6##y,z,c), I[357] = (T)(img)(_p5##x,_n6##y,z,c), I[358] = (T)(img)(_p4##x,_n6##y,z,c), I[359] = (T)(img)(_p3##x,_n6##y,z,c), I[360] = (T)(img)(_p2##x,_n6##y,z,c), I[361] = (T)(img)(_p1##x,_n6##y,z,c), I[362] = (T)(img)(x,_n6##y,z,c), I[363] = (T)(img)(_n1##x,_n6##y,z,c), I[364] = (T)(img)(_n2##x,_n6##y,z,c), I[365] = (T)(img)(_n3##x,_n6##y,z,c), I[366] = (T)(img)(_n4##x,_n6##y,z,c), I[367] = (T)(img)(_n5##x,_n6##y,z,c), I[368] = (T)(img)(_n6##x,_n6##y,z,c), I[369] = (T)(img)(_n7##x,_n6##y,z,c), I[370] = (T)(img)(_n8##x,_n6##y,z,c), I[371] = (T)(img)(_n9##x,_n6##y,z,c), I[372] = (T)(img)(_n10##x,_n6##y,z,c), I[373] = (T)(img)(_n11##x,_n6##y,z,c), \
 I[374] = (T)(img)(_p10##x,_n7##y,z,c), I[375] = (T)(img)(_p9##x,_n7##y,z,c), I[376] = (T)(img)(_p8##x,_n7##y,z,c), I[377] = (T)(img)(_p7##x,_n7##y,z,c), I[378] = (T)(img)(_p6##x,_n7##y,z,c), I[379] = (T)(img)(_p5##x,_n7##y,z,c), I[380] = (T)(img)(_p4##x,_n7##y,z,c), I[381] = (T)(img)(_p3##x,_n7##y,z,c), I[382] = (T)(img)(_p2##x,_n7##y,z,c), I[383] = (T)(img)(_p1##x,_n7##y,z,c), I[384] = (T)(img)(x,_n7##y,z,c), I[385] = (T)(img)(_n1##x,_n7##y,z,c), I[386] = (T)(img)(_n2##x,_n7##y,z,c), I[387] = (T)(img)(_n3##x,_n7##y,z,c), I[388] = (T)(img)(_n4##x,_n7##y,z,c), I[389] = (T)(img)(_n5##x,_n7##y,z,c), I[390] = (T)(img)(_n6##x,_n7##y,z,c), I[391] = (T)(img)(_n7##x,_n7##y,z,c), I[392] = (T)(img)(_n8##x,_n7##y,z,c), I[393] = (T)(img)(_n9##x,_n7##y,z,c), I[394] = (T)(img)(_n10##x,_n7##y,z,c), I[395] = (T)(img)(_n11##x,_n7##y,z,c), \
 I[396] = (T)(img)(_p10##x,_n8##y,z,c), I[397] = (T)(img)(_p9##x,_n8##y,z,c), I[398] = (T)(img)(_p8##x,_n8##y,z,c), I[399] = (T)(img)(_p7##x,_n8##y,z,c), I[400] = (T)(img)(_p6##x,_n8##y,z,c), I[401] = (T)(img)(_p5##x,_n8##y,z,c), I[402] = (T)(img)(_p4##x,_n8##y,z,c), I[403] = (T)(img)(_p3##x,_n8##y,z,c), I[404] = (T)(img)(_p2##x,_n8##y,z,c), I[405] = (T)(img)(_p1##x,_n8##y,z,c), I[406] = (T)(img)(x,_n8##y,z,c), I[407] = (T)(img)(_n1##x,_n8##y,z,c), I[408] = (T)(img)(_n2##x,_n8##y,z,c), I[409] = (T)(img)(_n3##x,_n8##y,z,c), I[410] = (T)(img)(_n4##x,_n8##y,z,c), I[411] = (T)(img)(_n5##x,_n8##y,z,c), I[412] = (T)(img)(_n6##x,_n8##y,z,c), I[413] = (T)(img)(_n7##x,_n8##y,z,c), I[414] = (T)(img)(_n8##x,_n8##y,z,c), I[415] = (T)(img)(_n9##x,_n8##y,z,c), I[416] = (T)(img)(_n10##x,_n8##y,z,c), I[417] = (T)(img)(_n11##x,_n8##y,z,c), \
 I[418] = (T)(img)(_p10##x,_n9##y,z,c), I[419] = (T)(img)(_p9##x,_n9##y,z,c), I[420] = (T)(img)(_p8##x,_n9##y,z,c), I[421] = (T)(img)(_p7##x,_n9##y,z,c), I[422] = (T)(img)(_p6##x,_n9##y,z,c), I[423] = (T)(img)(_p5##x,_n9##y,z,c), I[424] = (T)(img)(_p4##x,_n9##y,z,c), I[425] = (T)(img)(_p3##x,_n9##y,z,c), I[426] = (T)(img)(_p2##x,_n9##y,z,c), I[427] = (T)(img)(_p1##x,_n9##y,z,c), I[428] = (T)(img)(x,_n9##y,z,c), I[429] = (T)(img)(_n1##x,_n9##y,z,c), I[430] = (T)(img)(_n2##x,_n9##y,z,c), I[431] = (T)(img)(_n3##x,_n9##y,z,c), I[432] = (T)(img)(_n4##x,_n9##y,z,c), I[433] = (T)(img)(_n5##x,_n9##y,z,c), I[434] = (T)(img)(_n6##x,_n9##y,z,c), I[435] = (T)(img)(_n7##x,_n9##y,z,c), I[436] = (T)(img)(_n8##x,_n9##y,z,c), I[437] = (T)(img)(_n9##x,_n9##y,z,c), I[438] = (T)(img)(_n10##x,_n9##y,z,c), I[439] = (T)(img)(_n11##x,_n9##y,z,c), \
 I[440] = (T)(img)(_p10##x,_n10##y,z,c), I[441] = (T)(img)(_p9##x,_n10##y,z,c), I[442] = (T)(img)(_p8##x,_n10##y,z,c), I[443] = (T)(img)(_p7##x,_n10##y,z,c), I[444] = (T)(img)(_p6##x,_n10##y,z,c), I[445] = (T)(img)(_p5##x,_n10##y,z,c), I[446] = (T)(img)(_p4##x,_n10##y,z,c), I[447] = (T)(img)(_p3##x,_n10##y,z,c), I[448] = (T)(img)(_p2##x,_n10##y,z,c), I[449] = (T)(img)(_p1##x,_n10##y,z,c), I[450] = (T)(img)(x,_n10##y,z,c), I[451] = (T)(img)(_n1##x,_n10##y,z,c), I[452] = (T)(img)(_n2##x,_n10##y,z,c), I[453] = (T)(img)(_n3##x,_n10##y,z,c), I[454] = (T)(img)(_n4##x,_n10##y,z,c), I[455] = (T)(img)(_n5##x,_n10##y,z,c), I[456] = (T)(img)(_n6##x,_n10##y,z,c), I[457] = (T)(img)(_n7##x,_n10##y,z,c), I[458] = (T)(img)(_n8##x,_n10##y,z,c), I[459] = (T)(img)(_n9##x,_n10##y,z,c), I[460] = (T)(img)(_n10##x,_n10##y,z,c), I[461] = (T)(img)(_n11##x,_n10##y,z,c), \
 I[462] = (T)(img)(_p10##x,_n11##y,z,c), I[463] = (T)(img)(_p9##x,_n11##y,z,c), I[464] = (T)(img)(_p8##x,_n11##y,z,c), I[465] = (T)(img)(_p7##x,_n11##y,z,c), I[466] = (T)(img)(_p6##x,_n11##y,z,c), I[467] = (T)(img)(_p5##x,_n11##y,z,c), I[468] = (T)(img)(_p4##x,_n11##y,z,c), I[469] = (T)(img)(_p3##x,_n11##y,z,c), I[470] = (T)(img)(_p2##x,_n11##y,z,c), I[471] = (T)(img)(_p1##x,_n11##y,z,c), I[472] = (T)(img)(x,_n11##y,z,c), I[473] = (T)(img)(_n1##x,_n11##y,z,c), I[474] = (T)(img)(_n2##x,_n11##y,z,c), I[475] = (T)(img)(_n3##x,_n11##y,z,c), I[476] = (T)(img)(_n4##x,_n11##y,z,c), I[477] = (T)(img)(_n5##x,_n11##y,z,c), I[478] = (T)(img)(_n6##x,_n11##y,z,c), I[479] = (T)(img)(_n7##x,_n11##y,z,c), I[480] = (T)(img)(_n8##x,_n11##y,z,c), I[481] = (T)(img)(_n9##x,_n11##y,z,c), I[482] = (T)(img)(_n10##x,_n11##y,z,c), I[483] = (T)(img)(_n11##x,_n11##y,z,c);

// Define 23x23 loop macros
//-------------------------
#define cimg_for23(bound,i) for (int i = 0, \
 _p11##i = 0, _p10##i = 0, _p9##i = 0, _p8##i = 0, _p7##i = 0, _p6##i = 0, _p5##i = 0, _p4##i = 0, _p3##i = 0, _p2##i = 0, _p1##i = 0, \
 _n1##i = 1>=(int)(bound)?(int)(bound)-1:1, \
 _n2##i = 2>=(int)(bound)?(int)(bound)-1:2, \
 _n3##i = 3>=(int)(bound)?(int)(bound)-1:3, \
 _n4##i = 4>=(int)(bound)?(int)(bound)-1:4, \
 _n5##i = 5>=(int)(bound)?(int)(bound)-1:5, \
 _n6##i = 6>=(int)(bound)?(int)(bound)-1:6, \
 _n7##i = 7>=(int)(bound)?(int)(bound)-1:7, \
 _n8##i = 8>=(int)(bound)?(int)(bound)-1:8, \
 _n9##i = 9>=(int)(bound)?(int)(bound)-1:9, \
 _n10##i = 10>=(int)(bound)?(int)(bound)-1:10, \
 _n11##i = 11>=(int)(bound)?(int)(bound)-1:11; \
 _n11##i<(int)(bound) || _n10##i==--_n11##i || _n9##i==--_n10##i || _n8##i==--_n9##i || _n7##i==--_n8##i || _n6##i==--_n7##i || _n5##i==--_n6##i || _n4##i==--_n5##i || _n3##i==--_n4##i || _n2##i==--_n3##i || _n1##i==--_n2##i || \
 i==(_n11##i = _n10##i = _n9##i = _n8##i = _n7##i = _n6##i = _n5##i = _n4##i = _n3##i = _n2##i = --_n1##i); \
 _p11##i = _p10##i, _p10##i = _p9##i, _p9##i = _p8##i, _p8##i = _p7##i, _p7##i = _p6##i, _p6##i = _p5##i, _p5##i = _p4##i, _p4##i = _p3##i, _p3##i = _p2##i, _p2##i = _p1##i, _p1##i = i++, \
 ++_n1##i, ++_n2##i, ++_n3##i, ++_n4##i, ++_n5##i, ++_n6##i, ++_n7##i, ++_n8##i, ++_n9##i, ++_n10##i, ++_n11##i)

#define cimg_for23X(img,x) cimg_for23((img)._width,x)
#define cimg_for23Y(img,y) cimg_for23((img)._height,y)
#define cimg_for23Z(img,z) cimg_for23((img)._depth,z)
#define cimg_for23C(img,c) cimg_for23((img)._spectrum,c)
#define cimg_for23XY(img,x,y) cimg_for23Y(img,y) cimg_for23X(img,x)
#define cimg_for23XZ(img,x,z) cimg_for23Z(img,z) cimg_for23X(img,x)
#define cimg_for23XC(img,x,c) cimg_for23C(img,c) cimg_for23X(img,x)
#define cimg_for23YZ(img,y,z) cimg_for23Z(img,z) cimg_for23Y(img,y)
#define cimg_for23YC(img,y,c) cimg_for23C(img,c) cimg_for23Y(img,y)
#define cimg_for23ZC(img,z,c) cimg_for23C(img,c) cimg_for23Z(img,z)
#define cimg_for23XYZ(img,x,y,z) cimg_for23Z(img,z) cimg_for23XY(img,x,y)
#define cimg_for23XZC(img,x,z,c) cimg_for23C(img,c) cimg_for23XZ(img,x,z)
#define cimg_for23YZC(img,y,z,c) cimg_for23C(img,c) cimg_for23YZ(img,y,z)
#define cimg_for23XYZC(img,x,y,z,c) cimg_for23C(img,c) cimg_for23XYZ(img,x,y,z)

#define cimg_for_in23(bound,i0,i1,i) for (int i = (int)(i0)<0?0:(int)(i0), \
 _p11##i = i-11<0?0:i-11, \
 _p10##i = i-10<0?0:i-10, \
 _p9##i = i-9<0?0:i-9, \
 _p8##i = i-8<0?0:i-8, \
 _p7##i = i-7<0?0:i-7, \
 _p6##i = i-6<0?0:i-6, \
 _p5##i = i-5<0?0:i-5, \
 _p4##i = i-4<0?0:i-4, \
 _p3##i = i-3<0?0:i-3, \
 _p2##i = i-2<0?0:i-2, \
 _p1##i = i-1<0?0:i-1, \
 _n1##i = i+1>=(int)(bound)?(int)(bound)-1:i+1, \
 _n2##i = i+2>=(int)(bound)?(int)(bound)-1:i+2, \
 _n3##i = i+3>=(int)(bound)?(int)(bound)-1:i+3, \
 _n4##i = i+4>=(int)(bound)?(int)(bound)-1:i+4, \
 _n5##i = i+5>=(int)(bound)?(int)(bound)-1:i+5, \
 _n6##i = i+6>=(int)(bound)?(int)(bound)-1:i+6, \
 _n7##i = i+7>=(int)(bound)?(int)(bound)-1:i+7, \
 _n8##i = i+8>=(int)(bound)?(int)(bound)-1:i+8, \
 _n9##i = i+9>=(int)(bound)?(int)(bound)-1:i+9, \
 _n10##i = i+10>=(int)(bound)?(int)(bound)-1:i+10, \
 _n11##i = i+11>=(int)(bound)?(int)(bound)-1:i+11; \
 i<=(int)(i1) && (_n11##i<(int)(bound) || _n10##i==--_n11##i || _n9##i==--_n10##i || _n8##i==--_n9##i || _n7##i==--_n8##i || _n6##i==--_n7##i || _n5##i==--_n6##i || _n4##i==--_n5##i || _n3##i==--_n4##i || _n2##i==--_n3##i || _n1##i==--_n2##i || \
 i==(_n11##i = _n10##i = _n9##i = _n8##i = _n7##i = _n6##i = _n5##i = _n4##i = _n3##i = _n2##i = --_n1##i)); \
 _p11##i = _p10##i, _p10##i = _p9##i, _p9##i = _p8##i, _p8##i = _p7##i, _p7##i = _p6##i, _p6##i = _p5##i, _p5##i = _p4##i, _p4##i = _p3##i, _p3##i = _p2##i, _p2##i = _p1##i, _p1##i = i++, \
 ++_n1##i, ++_n2##i, ++_n3##i, ++_n4##i, ++_n5##i, ++_n6##i, ++_n7##i, ++_n8##i, ++_n9##i, ++_n10##i, ++_n11##i)

#define cimg_for_in23X(img,x0,x1,x) cimg_for_in23((img)._width,x0,x1,x)
#define cimg_for_in23Y(img,y0,y1,y) cimg_for_in23((img)._height,y0,y1,y)
#define cimg_for_in23Z(img,z0,z1,z) cimg_for_in23((img)._depth,z0,z1,z)
#define cimg_for_in23C(img,c0,c1,c) cimg_for_in23((img)._spectrum,c0,c1,c)
#define cimg_for_in23XY(img,x0,y0,x1,y1,x,y) cimg_for_in23Y(img,y0,y1,y) cimg_for_in23X(img,x0,x1,x)
#define cimg_for_in23XZ(img,x0,z0,x1,z1,x,z) cimg_for_in23Z(img,z0,z1,z) cimg_for_in23X(img,x0,x1,x)
#define cimg_for_in23XC(img,x0,c0,x1,c1,x,c) cimg_for_in23C(img,c0,c1,c) cimg_for_in23X(img,x0,x1,x)
#define cimg_for_in23YZ(img,y0,z0,y1,z1,y,z) cimg_for_in23Z(img,z0,z1,z) cimg_for_in23Y(img,y0,y1,y)
#define cimg_for_in23YC(img,y0,c0,y1,c1,y,c) cimg_for_in23C(img,c0,c1,c) cimg_for_in23Y(img,y0,y1,y)
#define cimg_for_in23ZC(img,z0,c0,z1,c1,z,c) cimg_for_in23C(img,c0,c1,c) cimg_for_in23Z(img,z0,z1,z)
#define cimg_for_in23XYZ(img,x0,y0,z0,x1,y1,z1,x,y,z) cimg_for_in23Z(img,z0,z1,z) cimg_for_in23XY(img,x0,y0,x1,y1,x,y)
#define cimg_for_in23XZC(img,x0,z0,c0,x1,y1,c1,x,z,c) cimg_for_in23C(img,c0,c1,c) cimg_for_in23XZ(img,x0,y0,x1,y1,x,z)
#define cimg_for_in23YZC(img,y0,z0,c0,y1,z1,c1,y,z,c) cimg_for_in23C(img,c0,c1,c) cimg_for_in23YZ(img,y0,z0,y1,z1,y,z)
#define cimg_for_in23XYZC(img,x0,y0,z0,c0,x1,y1,z1,c1,x,y,z,c) cimg_for_in23C(img,c0,c1,c) cimg_for_in23XYZ(img,x0,y0,z0,x1,y1,z1,x,y,z)

#define cimg_for23x23(img,x,y,z,c,I,T) \
 cimg_for23((img)._height,y) for (int x = 0, \
 _p11##x = 0, _p10##x = 0, _p9##x = 0, _p8##x = 0, _p7##x = 0, _p6##x = 0, _p5##x = 0, _p4##x = 0, _p3##x = 0, _p2##x = 0, _p1##x = 0, \
 _n1##x = 1>=((img)._width)?(img).width()-1:1, \
 _n2##x = 2>=((img)._width)?(img).width()-1:2, \
 _n3##x = 3>=((img)._width)?(img).width()-1:3, \
 _n4##x = 4>=((img)._width)?(img).width()-1:4, \
 _n5##x = 5>=((img)._width)?(img).width()-1:5, \
 _n6##x = 6>=((img)._width)?(img).width()-1:6, \
 _n7##x = 7>=((img)._width)?(img).width()-1:7, \
 _n8##x = 8>=((img)._width)?(img).width()-1:8, \
 _n9##x = 9>=((img)._width)?(img).width()-1:9, \
 _n10##x = 10>=((img)._width)?(img).width()-1:10, \
 _n11##x = (int)( \
 (I[0] = I[1] = I[2] = I[3] = I[4] = I[5] = I[6] = I[7] = I[8] = I[9] = I[10] = I[11] = (T)(img)(0,_p11##y,z,c)), \
 (I[23] = I[24] = I[25] = I[26] = I[27] = I[28] = I[29] = I[30] = I[31] = I[32] = I[33] = I[34] = (T)(img)(0,_p10##y,z,c)), \
 (I[46] = I[47] = I[48] = I[49] = I[50] = I[51] = I[52] = I[53] = I[54] = I[55] = I[56] = I[57] = (T)(img)(0,_p9##y,z,c)), \
 (I[69] = I[70] = I[71] = I[72] = I[73] = I[74] = I[75] = I[76] = I[77] = I[78] = I[79] = I[80] = (T)(img)(0,_p8##y,z,c)), \
 (I[92] = I[93] = I[94] = I[95] = I[96] = I[97] = I[98] = I[99] = I[100] = I[101] = I[102] = I[103] = (T)(img)(0,_p7##y,z,c)), \
 (I[115] = I[116] = I[117] = I[118] = I[119] = I[120] = I[121] = I[122] = I[123] = I[124] = I[125] = I[126] = (T)(img)(0,_p6##y,z,c)), \
 (I[138] = I[139] = I[140] = I[141] = I[142] = I[143] = I[144] = I[145] = I[146] = I[147] = I[148] = I[149] = (T)(img)(0,_p5##y,z,c)), \
 (I[161] = I[162] = I[163] = I[164] = I[165] = I[166] = I[167] = I[168] = I[169] = I[170] = I[171] = I[172] = (T)(img)(0,_p4##y,z,c)), \
 (I[184] = I[185] = I[186] = I[187] = I[188] = I[189] = I[190] = I[191] = I[192] = I[193] = I[194] = I[195] = (T)(img)(0,_p3##y,z,c)), \
 (I[207] = I[208] = I[209] = I[210] = I[211] = I[212] = I[213] = I[214] = I[215] = I[216] = I[217] = I[218] = (T)(img)(0,_p2##y,z,c)), \
 (I[230] = I[231] = I[232] = I[233] = I[234] = I[235] = I[236] = I[237] = I[238] = I[239] = I[240] = I[241] = (T)(img)(0,_p1##y,z,c)), \
 (I[253] = I[254] = I[255] = I[256] = I[257] = I[258] = I[259] = I[260] = I[261] = I[262] = I[263] = I[264] = (T)(img)(0,y,z,c)), \
 (I[276] = I[277] = I[278] = I[279] = I[280] = I[281] = I[282] = I[283] = I[284] = I[285] = I[286] = I[287] = (T)(img)(0,_n1##y,z,c)), \
 (I[299] = I[300] = I[301] = I[302] = I[303] = I[304] = I[305] = I[306] = I[307] = I[308] = I[309] = I[310] = (T)(img)(0,_n2##y,z,c)), \
 (I[322] = I[323] = I[324] = I[325] = I[326] = I[327] = I[328] = I[329] = I[330] = I[331] = I[332] = I[333] = (T)(img)(0,_n3##y,z,c)), \
 (I[345] = I[346] = I[347] = I[348] = I[349] = I[350] = I[351] = I[352] = I[353] = I[354] = I[355] = I[356] = (T)(img)(0,_n4##y,z,c)), \
 (I[368] = I[369] = I[370] = I[371] = I[372] = I[373] = I[374] = I[375] = I[376] = I[377] = I[378] = I[379] = (T)(img)(0,_n5##y,z,c)), \
 (I[391] = I[392] = I[393] = I[394] = I[395] = I[396] = I[397] = I[398] = I[399] = I[400] = I[401] = I[402] = (T)(img)(0,_n6##y,z,c)), \
 (I[414] = I[415] = I[416] = I[417] = I[418] = I[419] = I[420] = I[421] = I[422] = I[423] = I[424] = I[425] = (T)(img)(0,_n7##y,z,c)), \
 (I[437] = I[438] = I[439] = I[440] = I[441] = I[442] = I[443] = I[444] = I[445] = I[446] = I[447] = I[448] = (T)(img)(0,_n8##y,z,c)), \
 (I[460] = I[461] = I[462] = I[463] = I[464] = I[465] = I[466] = I[467] = I[468] = I[469] = I[470] = I[471] = (T)(img)(0,_n9##y,z,c)), \
 (I[483] = I[484] = I[485] = I[486] = I[487] = I[488] = I[489] = I[490] = I[491] = I[492] = I[493] = I[494] = (T)(img)(0,_n10##y,z,c)), \
 (I[506] = I[507] = I[508] = I[509] = I[510] = I[511] = I[512] = I[513] = I[514] = I[515] = I[516] = I[517] = (T)(img)(0,_n11##y,z,c)), \
 (I[12] = (T)(img)(_n1##x,_p11##y,z,c)), \
 (I[35] = (T)(img)(_n1##x,_p10##y,z,c)), \
 (I[58] = (T)(img)(_n1##x,_p9##y,z,c)), \
 (I[81] = (T)(img)(_n1##x,_p8##y,z,c)), \
 (I[104] = (T)(img)(_n1##x,_p7##y,z,c)), \
 (I[127] = (T)(img)(_n1##x,_p6##y,z,c)), \
 (I[150] = (T)(img)(_n1##x,_p5##y,z,c)), \
 (I[173] = (T)(img)(_n1##x,_p4##y,z,c)), \
 (I[196] = (T)(img)(_n1##x,_p3##y,z,c)), \
 (I[219] = (T)(img)(_n1##x,_p2##y,z,c)), \
 (I[242] = (T)(img)(_n1##x,_p1##y,z,c)), \
 (I[265] = (T)(img)(_n1##x,y,z,c)), \
 (I[288] = (T)(img)(_n1##x,_n1##y,z,c)), \
 (I[311] = (T)(img)(_n1##x,_n2##y,z,c)), \
 (I[334] = (T)(img)(_n1##x,_n3##y,z,c)), \
 (I[357] = (T)(img)(_n1##x,_n4##y,z,c)), \
 (I[380] = (T)(img)(_n1##x,_n5##y,z,c)), \
 (I[403] = (T)(img)(_n1##x,_n6##y,z,c)), \
 (I[426] = (T)(img)(_n1##x,_n7##y,z,c)), \
 (I[449] = (T)(img)(_n1##x,_n8##y,z,c)), \
 (I[472] = (T)(img)(_n1##x,_n9##y,z,c)), \
 (I[495] = (T)(img)(_n1##x,_n10##y,z,c)), \
 (I[518] = (T)(img)(_n1##x,_n11##y,z,c)), \
 (I[13] = (T)(img)(_n2##x,_p11##y,z,c)), \
 (I[36] = (T)(img)(_n2##x,_p10##y,z,c)), \
 (I[59] = (T)(img)(_n2##x,_p9##y,z,c)), \
 (I[82] = (T)(img)(_n2##x,_p8##y,z,c)), \
 (I[105] = (T)(img)(_n2##x,_p7##y,z,c)), \
 (I[128] = (T)(img)(_n2##x,_p6##y,z,c)), \
 (I[151] = (T)(img)(_n2##x,_p5##y,z,c)), \
 (I[174] = (T)(img)(_n2##x,_p4##y,z,c)), \
 (I[197] = (T)(img)(_n2##x,_p3##y,z,c)), \
 (I[220] = (T)(img)(_n2##x,_p2##y,z,c)), \
 (I[243] = (T)(img)(_n2##x,_p1##y,z,c)), \
 (I[266] = (T)(img)(_n2##x,y,z,c)), \
 (I[289] = (T)(img)(_n2##x,_n1##y,z,c)), \
 (I[312] = (T)(img)(_n2##x,_n2##y,z,c)), \
 (I[335] = (T)(img)(_n2##x,_n3##y,z,c)), \
 (I[358] = (T)(img)(_n2##x,_n4##y,z,c)), \
 (I[381] = (T)(img)(_n2##x,_n5##y,z,c)), \
 (I[404] = (T)(img)(_n2##x,_n6##y,z,c)), \
 (I[427] = (T)(img)(_n2##x,_n7##y,z,c)), \
 (I[450] = (T)(img)(_n2##x,_n8##y,z,c)), \
 (I[473] = (T)(img)(_n2##x,_n9##y,z,c)), \
 (I[496] = (T)(img)(_n2##x,_n10##y,z,c)), \
 (I[519] = (T)(img)(_n2##x,_n11##y,z,c)), \
 (I[14] = (T)(img)(_n3##x,_p11##y,z,c)), \
 (I[37] = (T)(img)(_n3##x,_p10##y,z,c)), \
 (I[60] = (T)(img)(_n3##x,_p9##y,z,c)), \
 (I[83] = (T)(img)(_n3##x,_p8##y,z,c)), \
 (I[106] = (T)(img)(_n3##x,_p7##y,z,c)), \
 (I[129] = (T)(img)(_n3##x,_p6##y,z,c)), \
 (I[152] = (T)(img)(_n3##x,_p5##y,z,c)), \
 (I[175] = (T)(img)(_n3##x,_p4##y,z,c)), \
 (I[198] = (T)(img)(_n3##x,_p3##y,z,c)), \
 (I[221] = (T)(img)(_n3##x,_p2##y,z,c)), \
 (I[244] = (T)(img)(_n3##x,_p1##y,z,c)), \
 (I[267] = (T)(img)(_n3##x,y,z,c)), \
 (I[290] = (T)(img)(_n3##x,_n1##y,z,c)), \
 (I[313] = (T)(img)(_n3##x,_n2##y,z,c)), \
 (I[336] = (T)(img)(_n3##x,_n3##y,z,c)), \
 (I[359] = (T)(img)(_n3##x,_n4##y,z,c)), \
 (I[382] = (T)(img)(_n3##x,_n5##y,z,c)), \
 (I[405] = (T)(img)(_n3##x,_n6##y,z,c)), \
 (I[428] = (T)(img)(_n3##x,_n7##y,z,c)), \
 (I[451] = (T)(img)(_n3##x,_n8##y,z,c)), \
 (I[474] = (T)(img)(_n3##x,_n9##y,z,c)), \
 (I[497] = (T)(img)(_n3##x,_n10##y,z,c)), \
 (I[520] = (T)(img)(_n3##x,_n11##y,z,c)), \
 (I[15] = (T)(img)(_n4##x,_p11##y,z,c)), \
 (I[38] = (T)(img)(_n4##x,_p10##y,z,c)), \
 (I[61] = (T)(img)(_n4##x,_p9##y,z,c)), \
 (I[84] = (T)(img)(_n4##x,_p8##y,z,c)), \
 (I[107] = (T)(img)(_n4##x,_p7##y,z,c)), \
 (I[130] = (T)(img)(_n4##x,_p6##y,z,c)), \
 (I[153] = (T)(img)(_n4##x,_p5##y,z,c)), \
 (I[176] = (T)(img)(_n4##x,_p4##y,z,c)), \
 (I[199] = (T)(img)(_n4##x,_p3##y,z,c)), \
 (I[222] = (T)(img)(_n4##x,_p2##y,z,c)), \
 (I[245] = (T)(img)(_n4##x,_p1##y,z,c)), \
 (I[268] = (T)(img)(_n4##x,y,z,c)), \
 (I[291] = (T)(img)(_n4##x,_n1##y,z,c)), \
 (I[314] = (T)(img)(_n4##x,_n2##y,z,c)), \
 (I[337] = (T)(img)(_n4##x,_n3##y,z,c)), \
 (I[360] = (T)(img)(_n4##x,_n4##y,z,c)), \
 (I[383] = (T)(img)(_n4##x,_n5##y,z,c)), \
 (I[406] = (T)(img)(_n4##x,_n6##y,z,c)), \
 (I[429] = (T)(img)(_n4##x,_n7##y,z,c)), \
 (I[452] = (T)(img)(_n4##x,_n8##y,z,c)), \
 (I[475] = (T)(img)(_n4##x,_n9##y,z,c)), \
 (I[498] = (T)(img)(_n4##x,_n10##y,z,c)), \
 (I[521] = (T)(img)(_n4##x,_n11##y,z,c)), \
 (I[16] = (T)(img)(_n5##x,_p11##y,z,c)), \
 (I[39] = (T)(img)(_n5##x,_p10##y,z,c)), \
 (I[62] = (T)(img)(_n5##x,_p9##y,z,c)), \
 (I[85] = (T)(img)(_n5##x,_p8##y,z,c)), \
 (I[108] = (T)(img)(_n5##x,_p7##y,z,c)), \
 (I[131] = (T)(img)(_n5##x,_p6##y,z,c)), \
 (I[154] = (T)(img)(_n5##x,_p5##y,z,c)), \
 (I[177] = (T)(img)(_n5##x,_p4##y,z,c)), \
 (I[200] = (T)(img)(_n5##x,_p3##y,z,c)), \
 (I[223] = (T)(img)(_n5##x,_p2##y,z,c)), \
 (I[246] = (T)(img)(_n5##x,_p1##y,z,c)), \
 (I[269] = (T)(img)(_n5##x,y,z,c)), \
 (I[292] = (T)(img)(_n5##x,_n1##y,z,c)), \
 (I[315] = (T)(img)(_n5##x,_n2##y,z,c)), \
 (I[338] = (T)(img)(_n5##x,_n3##y,z,c)), \
 (I[361] = (T)(img)(_n5##x,_n4##y,z,c)), \
 (I[384] = (T)(img)(_n5##x,_n5##y,z,c)), \
 (I[407] = (T)(img)(_n5##x,_n6##y,z,c)), \
 (I[430] = (T)(img)(_n5##x,_n7##y,z,c)), \
 (I[453] = (T)(img)(_n5##x,_n8##y,z,c)), \
 (I[476] = (T)(img)(_n5##x,_n9##y,z,c)), \
 (I[499] = (T)(img)(_n5##x,_n10##y,z,c)), \
 (I[522] = (T)(img)(_n5##x,_n11##y,z,c)), \
 (I[17] = (T)(img)(_n6##x,_p11##y,z,c)), \
 (I[40] = (T)(img)(_n6##x,_p10##y,z,c)), \
 (I[63] = (T)(img)(_n6##x,_p9##y,z,c)), \
 (I[86] = (T)(img)(_n6##x,_p8##y,z,c)), \
 (I[109] = (T)(img)(_n6##x,_p7##y,z,c)), \
 (I[132] = (T)(img)(_n6##x,_p6##y,z,c)), \
 (I[155] = (T)(img)(_n6##x,_p5##y,z,c)), \
 (I[178] = (T)(img)(_n6##x,_p4##y,z,c)), \
 (I[201] = (T)(img)(_n6##x,_p3##y,z,c)), \
 (I[224] = (T)(img)(_n6##x,_p2##y,z,c)), \
 (I[247] = (T)(img)(_n6##x,_p1##y,z,c)), \
 (I[270] = (T)(img)(_n6##x,y,z,c)), \
 (I[293] = (T)(img)(_n6##x,_n1##y,z,c)), \
 (I[316] = (T)(img)(_n6##x,_n2##y,z,c)), \
 (I[339] = (T)(img)(_n6##x,_n3##y,z,c)), \
 (I[362] = (T)(img)(_n6##x,_n4##y,z,c)), \
 (I[385] = (T)(img)(_n6##x,_n5##y,z,c)), \
 (I[408] = (T)(img)(_n6##x,_n6##y,z,c)), \
 (I[431] = (T)(img)(_n6##x,_n7##y,z,c)), \
 (I[454] = (T)(img)(_n6##x,_n8##y,z,c)), \
 (I[477] = (T)(img)(_n6##x,_n9##y,z,c)), \
 (I[500] = (T)(img)(_n6##x,_n10##y,z,c)), \
 (I[523] = (T)(img)(_n6##x,_n11##y,z,c)), \
 (I[18] = (T)(img)(_n7##x,_p11##y,z,c)), \
 (I[41] = (T)(img)(_n7##x,_p10##y,z,c)), \
 (I[64] = (T)(img)(_n7##x,_p9##y,z,c)), \
 (I[87] = (T)(img)(_n7##x,_p8##y,z,c)), \
 (I[110] = (T)(img)(_n7##x,_p7##y,z,c)), \
 (I[133] = (T)(img)(_n7##x,_p6##y,z,c)), \
 (I[156] = (T)(img)(_n7##x,_p5##y,z,c)), \
 (I[179] = (T)(img)(_n7##x,_p4##y,z,c)), \
 (I[202] = (T)(img)(_n7##x,_p3##y,z,c)), \
 (I[225] = (T)(img)(_n7##x,_p2##y,z,c)), \
 (I[248] = (T)(img)(_n7##x,_p1##y,z,c)), \
 (I[271] = (T)(img)(_n7##x,y,z,c)), \
 (I[294] = (T)(img)(_n7##x,_n1##y,z,c)), \
 (I[317] = (T)(img)(_n7##x,_n2##y,z,c)), \
 (I[340] = (T)(img)(_n7##x,_n3##y,z,c)), \
 (I[363] = (T)(img)(_n7##x,_n4##y,z,c)), \
 (I[386] = (T)(img)(_n7##x,_n5##y,z,c)), \
 (I[409] = (T)(img)(_n7##x,_n6##y,z,c)), \
 (I[432] = (T)(img)(_n7##x,_n7##y,z,c)), \
 (I[455] = (T)(img)(_n7##x,_n8##y,z,c)), \
 (I[478] = (T)(img)(_n7##x,_n9##y,z,c)), \
 (I[501] = (T)(img)(_n7##x,_n10##y,z,c)), \
 (I[524] = (T)(img)(_n7##x,_n11##y,z,c)), \
 (I[19] = (T)(img)(_n8##x,_p11##y,z,c)), \
 (I[42] = (T)(img)(_n8##x,_p10##y,z,c)), \
 (I[65] = (T)(img)(_n8##x,_p9##y,z,c)), \
 (I[88] = (T)(img)(_n8##x,_p8##y,z,c)), \
 (I[111] = (T)(img)(_n8##x,_p7##y,z,c)), \
 (I[134] = (T)(img)(_n8##x,_p6##y,z,c)), \
 (I[157] = (T)(img)(_n8##x,_p5##y,z,c)), \
 (I[180] = (T)(img)(_n8##x,_p4##y,z,c)), \
 (I[203] = (T)(img)(_n8##x,_p3##y,z,c)), \
 (I[226] = (T)(img)(_n8##x,_p2##y,z,c)), \
 (I[249] = (T)(img)(_n8##x,_p1##y,z,c)), \
 (I[272] = (T)(img)(_n8##x,y,z,c)), \
 (I[295] = (T)(img)(_n8##x,_n1##y,z,c)), \
 (I[318] = (T)(img)(_n8##x,_n2##y,z,c)), \
 (I[341] = (T)(img)(_n8##x,_n3##y,z,c)), \
 (I[364] = (T)(img)(_n8##x,_n4##y,z,c)), \
 (I[387] = (T)(img)(_n8##x,_n5##y,z,c)), \
 (I[410] = (T)(img)(_n8##x,_n6##y,z,c)), \
 (I[433] = (T)(img)(_n8##x,_n7##y,z,c)), \
 (I[456] = (T)(img)(_n8##x,_n8##y,z,c)), \
 (I[479] = (T)(img)(_n8##x,_n9##y,z,c)), \
 (I[502] = (T)(img)(_n8##x,_n10##y,z,c)), \
 (I[525] = (T)(img)(_n8##x,_n11##y,z,c)), \
 (I[20] = (T)(img)(_n9##x,_p11##y,z,c)), \
 (I[43] = (T)(img)(_n9##x,_p10##y,z,c)), \
 (I[66] = (T)(img)(_n9##x,_p9##y,z,c)), \
 (I[89] = (T)(img)(_n9##x,_p8##y,z,c)), \
 (I[112] = (T)(img)(_n9##x,_p7##y,z,c)), \
 (I[135] = (T)(img)(_n9##x,_p6##y,z,c)), \
 (I[158] = (T)(img)(_n9##x,_p5##y,z,c)), \
 (I[181] = (T)(img)(_n9##x,_p4##y,z,c)), \
 (I[204] = (T)(img)(_n9##x,_p3##y,z,c)), \
 (I[227] = (T)(img)(_n9##x,_p2##y,z,c)), \
 (I[250] = (T)(img)(_n9##x,_p1##y,z,c)), \
 (I[273] = (T)(img)(_n9##x,y,z,c)), \
 (I[296] = (T)(img)(_n9##x,_n1##y,z,c)), \
 (I[319] = (T)(img)(_n9##x,_n2##y,z,c)), \
 (I[342] = (T)(img)(_n9##x,_n3##y,z,c)), \
 (I[365] = (T)(img)(_n9##x,_n4##y,z,c)), \
 (I[388] = (T)(img)(_n9##x,_n5##y,z,c)), \
 (I[411] = (T)(img)(_n9##x,_n6##y,z,c)), \
 (I[434] = (T)(img)(_n9##x,_n7##y,z,c)), \
 (I[457] = (T)(img)(_n9##x,_n8##y,z,c)), \
 (I[480] = (T)(img)(_n9##x,_n9##y,z,c)), \
 (I[503] = (T)(img)(_n9##x,_n10##y,z,c)), \
 (I[526] = (T)(img)(_n9##x,_n11##y,z,c)), \
 (I[21] = (T)(img)(_n10##x,_p11##y,z,c)), \
 (I[44] = (T)(img)(_n10##x,_p10##y,z,c)), \
 (I[67] = (T)(img)(_n10##x,_p9##y,z,c)), \
 (I[90] = (T)(img)(_n10##x,_p8##y,z,c)), \
 (I[113] = (T)(img)(_n10##x,_p7##y,z,c)), \
 (I[136] = (T)(img)(_n10##x,_p6##y,z,c)), \
 (I[159] = (T)(img)(_n10##x,_p5##y,z,c)), \
 (I[182] = (T)(img)(_n10##x,_p4##y,z,c)), \
 (I[205] = (T)(img)(_n10##x,_p3##y,z,c)), \
 (I[228] = (T)(img)(_n10##x,_p2##y,z,c)), \
 (I[251] = (T)(img)(_n10##x,_p1##y,z,c)), \
 (I[274] = (T)(img)(_n10##x,y,z,c)), \
 (I[297] = (T)(img)(_n10##x,_n1##y,z,c)), \
 (I[320] = (T)(img)(_n10##x,_n2##y,z,c)), \
 (I[343] = (T)(img)(_n10##x,_n3##y,z,c)), \
 (I[366] = (T)(img)(_n10##x,_n4##y,z,c)), \
 (I[389] = (T)(img)(_n10##x,_n5##y,z,c)), \
 (I[412] = (T)(img)(_n10##x,_n6##y,z,c)), \
 (I[435] = (T)(img)(_n10##x,_n7##y,z,c)), \
 (I[458] = (T)(img)(_n10##x,_n8##y,z,c)), \
 (I[481] = (T)(img)(_n10##x,_n9##y,z,c)), \
 (I[504] = (T)(img)(_n10##x,_n10##y,z,c)), \
 (I[527] = (T)(img)(_n10##x,_n11##y,z,c)), \
 11>=((img)._width)?(img).width()-1:11); \
 (_n11##x<(img).width() && ( \
 (I[22] = (T)(img)(_n11##x,_p11##y,z,c)), \
 (I[45] = (T)(img)(_n11##x,_p10##y,z,c)), \
 (I[68] = (T)(img)(_n11##x,_p9##y,z,c)), \
 (I[91] = (T)(img)(_n11##x,_p8##y,z,c)), \
 (I[114] = (T)(img)(_n11##x,_p7##y,z,c)), \
 (I[137] = (T)(img)(_n11##x,_p6##y,z,c)), \
 (I[160] = (T)(img)(_n11##x,_p5##y,z,c)), \
 (I[183] = (T)(img)(_n11##x,_p4##y,z,c)), \
 (I[206] = (T)(img)(_n11##x,_p3##y,z,c)), \
 (I[229] = (T)(img)(_n11##x,_p2##y,z,c)), \
 (I[252] = (T)(img)(_n11##x,_p1##y,z,c)), \
 (I[275] = (T)(img)(_n11##x,y,z,c)), \
 (I[298] = (T)(img)(_n11##x,_n1##y,z,c)), \
 (I[321] = (T)(img)(_n11##x,_n2##y,z,c)), \
 (I[344] = (T)(img)(_n11##x,_n3##y,z,c)), \
 (I[367] = (T)(img)(_n11##x,_n4##y,z,c)), \
 (I[390] = (T)(img)(_n11##x,_n5##y,z,c)), \
 (I[413] = (T)(img)(_n11##x,_n6##y,z,c)), \
 (I[436] = (T)(img)(_n11##x,_n7##y,z,c)), \
 (I[459] = (T)(img)(_n11##x,_n8##y,z,c)), \
 (I[482] = (T)(img)(_n11##x,_n9##y,z,c)), \
 (I[505] = (T)(img)(_n11##x,_n10##y,z,c)), \
 (I[528] = (T)(img)(_n11##x,_n11##y,z,c)),1)) || \
 _n10##x==--_n11##x || _n9##x==--_n10##x || _n8##x==--_n9##x || _n7##x==--_n8##x || _n6##x==--_n7##x || _n5##x==--_n6##x || _n4##x==--_n5##x || _n3##x==--_n4##x || _n2##x==--_n3##x || _n1##x==--_n2##x || x==(_n11##x = _n10##x = _n9##x = _n8##x = _n7##x = _n6##x = _n5##x = _n4##x = _n3##x = _n2##x = --_n1##x); \
 I[0] = I[1], I[1] = I[2], I[2] = I[3], I[3] = I[4], I[4] = I[5], I[5] = I[6], I[6] = I[7], I[7] = I[8], I[8] = I[9], I[9] = I[10], I[10] = I[11], I[11] = I[12], I[12] = I[13], I[13] = I[14], I[14] = I[15], I[15] = I[16], I[16] = I[17], I[17] = I[18], I[18] = I[19], I[19] = I[20], I[20] = I[21], I[21] = I[22], \
 I[23] = I[24], I[24] = I[25], I[25] = I[26], I[26] = I[27], I[27] = I[28], I[28] = I[29], I[29] = I[30], I[30] = I[31], I[31] = I[32], I[32] = I[33], I[33] = I[34], I[34] = I[35], I[35] = I[36], I[36] = I[37], I[37] = I[38], I[38] = I[39], I[39] = I[40], I[40] = I[41], I[41] = I[42], I[42] = I[43], I[43] = I[44], I[44] = I[45], \
 I[46] = I[47], I[47] = I[48], I[48] = I[49], I[49] = I[50], I[50] = I[51], I[51] = I[52], I[52] = I[53], I[53] = I[54], I[54] = I[55], I[55] = I[56], I[56] = I[57], I[57] = I[58], I[58] = I[59], I[59] = I[60], I[60] = I[61], I[61] = I[62], I[62] = I[63], I[63] = I[64], I[64] = I[65], I[65] = I[66], I[66] = I[67], I[67] = I[68], \
 I[69] = I[70], I[70] = I[71], I[71] = I[72], I[72] = I[73], I[73] = I[74], I[74] = I[75], I[75] = I[76], I[76] = I[77], I[77] = I[78], I[78] = I[79], I[79] = I[80], I[80] = I[81], I[81] = I[82], I[82] = I[83], I[83] = I[84], I[84] = I[85], I[85] = I[86], I[86] = I[87], I[87] = I[88], I[88] = I[89], I[89] = I[90], I[90] = I[91], \
 I[92] = I[93], I[93] = I[94], I[94] = I[95], I[95] = I[96], I[96] = I[97], I[97] = I[98], I[98] = I[99], I[99] = I[100], I[100] = I[101], I[101] = I[102], I[102] = I[103], I[103] = I[104], I[104] = I[105], I[105] = I[106], I[106] = I[107], I[107] = I[108], I[108] = I[109], I[109] = I[110], I[110] = I[111], I[111] = I[112], I[112] = I[113], I[113] = I[114], \
 I[115] = I[116], I[116] = I[117], I[117] = I[118], I[118] = I[119], I[119] = I[120], I[120] = I[121], I[121] = I[122], I[122] = I[123], I[123] = I[124], I[124] = I[125], I[125] = I[126], I[126] = I[127], I[127] = I[128], I[128] = I[129], I[129] = I[130], I[130] = I[131], I[131] = I[132], I[132] = I[133], I[133] = I[134], I[134] = I[135], I[135] = I[136], I[136] = I[137], \
 I[138] = I[139], I[139] = I[140], I[140] = I[141], I[141] = I[142], I[142] = I[143], I[143] = I[144], I[144] = I[145], I[145] = I[146], I[146] = I[147], I[147] = I[148], I[148] = I[149], I[149] = I[150], I[150] = I[151], I[151] = I[152], I[152] = I[153], I[153] = I[154], I[154] = I[155], I[155] = I[156], I[156] = I[157], I[157] = I[158], I[158] = I[159], I[159] = I[160], \
 I[161] = I[162], I[162] = I[163], I[163] = I[164], I[164] = I[165], I[165] = I[166], I[166] = I[167], I[167] = I[168], I[168] = I[169], I[169] = I[170], I[170] = I[171], I[171] = I[172], I[172] = I[173], I[173] = I[174], I[174] = I[175], I[175] = I[176], I[176] = I[177], I[177] = I[178], I[178] = I[179], I[179] = I[180], I[180] = I[181], I[181] = I[182], I[182] = I[183], \
 I[184] = I[185], I[185] = I[186], I[186] = I[187], I[187] = I[188], I[188] = I[189], I[189] = I[190], I[190] = I[191], I[191] = I[192], I[192] = I[193], I[193] = I[194], I[194] = I[195], I[195] = I[196], I[196] = I[197], I[197] = I[198], I[198] = I[199], I[199] = I[200], I[200] = I[201], I[201] = I[202], I[202] = I[203], I[203] = I[204], I[204] = I[205], I[205] = I[206], \
 I[207] = I[208], I[208] = I[209], I[209] = I[210], I[210] = I[211], I[211] = I[212], I[212] = I[213], I[213] = I[214], I[214] = I[215], I[215] = I[216], I[216] = I[217], I[217] = I[218], I[218] = I[219], I[219] = I[220], I[220] = I[221], I[221] = I[222], I[222] = I[223], I[223] = I[224], I[224] = I[225], I[225] = I[226], I[226] = I[227], I[227] = I[228], I[228] = I[229], \
 I[230] = I[231], I[231] = I[232], I[232] = I[233], I[233] = I[234], I[234] = I[235], I[235] = I[236], I[236] = I[237], I[237] = I[238], I[238] = I[239], I[239] = I[240], I[240] = I[241], I[241] = I[242], I[242] = I[243], I[243] = I[244], I[244] = I[245], I[245] = I[246], I[246] = I[247], I[247] = I[248], I[248] = I[249], I[249] = I[250], I[250] = I[251], I[251] = I[252], \
 I[253] = I[254], I[254] = I[255], I[255] = I[256], I[256] = I[257], I[257] = I[258], I[258] = I[259], I[259] = I[260], I[260] = I[261], I[261] = I[262], I[262] = I[263], I[263] = I[264], I[264] = I[265], I[265] = I[266], I[266] = I[267], I[267] = I[268], I[268] = I[269], I[269] = I[270], I[270] = I[271], I[271] = I[272], I[272] = I[273], I[273] = I[274], I[274] = I[275], \
 I[276] = I[277], I[277] = I[278], I[278] = I[279], I[279] = I[280], I[280] = I[281], I[281] = I[282], I[282] = I[283], I[283] = I[284], I[284] = I[285], I[285] = I[286], I[286] = I[287], I[287] = I[288], I[288] = I[289], I[289] = I[290], I[290] = I[291], I[291] = I[292], I[292] = I[293], I[293] = I[294], I[294] = I[295], I[295] = I[296], I[296] = I[297], I[297] = I[298], \
 I[299] = I[300], I[300] = I[301], I[301] = I[302], I[302] = I[303], I[303] = I[304], I[304] = I[305], I[305] = I[306], I[306] = I[307], I[307] = I[308], I[308] = I[309], I[309] = I[310], I[310] = I[311], I[311] = I[312], I[312] = I[313], I[313] = I[314], I[314] = I[315], I[315] = I[316], I[316] = I[317], I[317] = I[318], I[318] = I[319], I[319] = I[320], I[320] = I[321], \
 I[322] = I[323], I[323] = I[324], I[324] = I[325], I[325] = I[326], I[326] = I[327], I[327] = I[328], I[328] = I[329], I[329] = I[330], I[330] = I[331], I[331] = I[332], I[332] = I[333], I[333] = I[334], I[334] = I[335], I[335] = I[336], I[336] = I[337], I[337] = I[338], I[338] = I[339], I[339] = I[340], I[340] = I[341], I[341] = I[342], I[342] = I[343], I[343] = I[344], \
 I[345] = I[346], I[346] = I[347], I[347] = I[348], I[348] = I[349], I[349] = I[350], I[350] = I[351], I[351] = I[352], I[352] = I[353], I[353] = I[354], I[354] = I[355], I[355] = I[356], I[356] = I[357], I[357] = I[358], I[358] = I[359], I[359] = I[360], I[360] = I[361], I[361] = I[362], I[362] = I[363], I[363] = I[364], I[364] = I[365], I[365] = I[366], I[366] = I[367], \
 I[368] = I[369], I[369] = I[370], I[370] = I[371], I[371] = I[372], I[372] = I[373], I[373] = I[374], I[374] = I[375], I[375] = I[376], I[376] = I[377], I[377] = I[378], I[378] = I[379], I[379] = I[380], I[380] = I[381], I[381] = I[382], I[382] = I[383], I[383] = I[384], I[384] = I[385], I[385] = I[386], I[386] = I[387], I[387] = I[388], I[388] = I[389], I[389] = I[390], \
 I[391] = I[392], I[392] = I[393], I[393] = I[394], I[394] = I[395], I[395] = I[396], I[396] = I[397], I[397] = I[398], I[398] = I[399], I[399] = I[400], I[400] = I[401], I[401] = I[402], I[402] = I[403], I[403] = I[404], I[404] = I[405], I[405] = I[406], I[406] = I[407], I[407] = I[408], I[408] = I[409], I[409] = I[410], I[410] = I[411], I[411] = I[412], I[412] = I[413], \
 I[414] = I[415], I[415] = I[416], I[416] = I[417], I[417] = I[418], I[418] = I[419], I[419] = I[420], I[420] = I[421], I[421] = I[422], I[422] = I[423], I[423] = I[424], I[424] = I[425], I[425] = I[426], I[426] = I[427], I[427] = I[428], I[428] = I[429], I[429] = I[430], I[430] = I[431], I[431] = I[432], I[432] = I[433], I[433] = I[434], I[434] = I[435], I[435] = I[436], \
 I[437] = I[438], I[438] = I[439], I[439] = I[440], I[440] = I[441], I[441] = I[442], I[442] = I[443], I[443] = I[444], I[444] = I[445], I[445] = I[446], I[446] = I[447], I[447] = I[448], I[448] = I[449], I[449] = I[450], I[450] = I[451], I[451] = I[452], I[452] = I[453], I[453] = I[454], I[454] = I[455], I[455] = I[456], I[456] = I[457], I[457] = I[458], I[458] = I[459], \
 I[460] = I[461], I[461] = I[462], I[462] = I[463], I[463] = I[464], I[464] = I[465], I[465] = I[466], I[466] = I[467], I[467] = I[468], I[468] = I[469], I[469] = I[470], I[470] = I[471], I[471] = I[472], I[472] = I[473], I[473] = I[474], I[474] = I[475], I[475] = I[476], I[476] = I[477], I[477] = I[478], I[478] = I[479], I[479] = I[480], I[480] = I[481], I[481] = I[482], \
 I[483] = I[484], I[484] = I[485], I[485] = I[486], I[486] = I[487], I[487] = I[488], I[488] = I[489], I[489] = I[490], I[490] = I[491], I[491] = I[492], I[492] = I[493], I[493] = I[494], I[494] = I[495], I[495] = I[496], I[496] = I[497], I[497] = I[498], I[498] = I[499], I[499] = I[500], I[500] = I[501], I[501] = I[502], I[502] = I[503], I[503] = I[504], I[504] = I[505], \
 I[506] = I[507], I[507] = I[508], I[508] = I[509], I[509] = I[510], I[510] = I[511], I[511] = I[512], I[512] = I[513], I[513] = I[514], I[514] = I[515], I[515] = I[516], I[516] = I[517], I[517] = I[518], I[518] = I[519], I[519] = I[520], I[520] = I[521], I[521] = I[522], I[522] = I[523], I[523] = I[524], I[524] = I[525], I[525] = I[526], I[526] = I[527], I[527] = I[528], \
 _p11##x = _p10##x, _p10##x = _p9##x, _p9##x = _p8##x, _p8##x = _p7##x, _p7##x = _p6##x, _p6##x = _p5##x, _p5##x = _p4##x, _p4##x = _p3##x, _p3##x = _p2##x, _p2##x = _p1##x, _p1##x = x++, ++_n1##x, ++_n2##x, ++_n3##x, ++_n4##x, ++_n5##x, ++_n6##x, ++_n7##x, ++_n8##x, ++_n9##x, ++_n10##x, ++_n11##x)

#define cimg_for_in23x23(img,x0,y0,x1,y1,x,y,z,c,I,T) \
 cimg_for_in23((img)._height,y0,y1,y) for (int x = (int)(x0)<0?0:(int)(x0), \
 _p11##x = x-11<0?0:x-11, \
 _p10##x = x-10<0?0:x-10, \
 _p9##x = x-9<0?0:x-9, \
 _p8##x = x-8<0?0:x-8, \
 _p7##x = x-7<0?0:x-7, \
 _p6##x = x-6<0?0:x-6, \
 _p5##x = x-5<0?0:x-5, \
 _p4##x = x-4<0?0:x-4, \
 _p3##x = x-3<0?0:x-3, \
 _p2##x = x-2<0?0:x-2, \
 _p1##x = x-1<0?0:x-1, \
 _n1##x = x+1>=(img).width()?(img).width()-1:x+1, \
 _n2##x = x+2>=(img).width()?(img).width()-1:x+2, \
 _n3##x = x+3>=(img).width()?(img).width()-1:x+3, \
 _n4##x = x+4>=(img).width()?(img).width()-1:x+4, \
 _n5##x = x+5>=(img).width()?(img).width()-1:x+5, \
 _n6##x = x+6>=(img).width()?(img).width()-1:x+6, \
 _n7##x = x+7>=(img).width()?(img).width()-1:x+7, \
 _n8##x = x+8>=(img).width()?(img).width()-1:x+8, \
 _n9##x = x+9>=(img).width()?(img).width()-1:x+9, \
 _n10##x = x+10>=(img).width()?(img).width()-1:x+10, \
 _n11##x = (int)( \
 (I[0] = (T)(img)(_p11##x,_p11##y,z,c)), \
 (I[23] = (T)(img)(_p11##x,_p10##y,z,c)), \
 (I[46] = (T)(img)(_p11##x,_p9##y,z,c)), \
 (I[69] = (T)(img)(_p11##x,_p8##y,z,c)), \
 (I[92] = (T)(img)(_p11##x,_p7##y,z,c)), \
 (I[115] = (T)(img)(_p11##x,_p6##y,z,c)), \
 (I[138] = (T)(img)(_p11##x,_p5##y,z,c)), \
 (I[161] = (T)(img)(_p11##x,_p4##y,z,c)), \
 (I[184] = (T)(img)(_p11##x,_p3##y,z,c)), \
 (I[207] = (T)(img)(_p11##x,_p2##y,z,c)), \
 (I[230] = (T)(img)(_p11##x,_p1##y,z,c)), \
 (I[253] = (T)(img)(_p11##x,y,z,c)), \
 (I[276] = (T)(img)(_p11##x,_n1##y,z,c)), \
 (I[299] = (T)(img)(_p11##x,_n2##y,z,c)), \
 (I[322] = (T)(img)(_p11##x,_n3##y,z,c)), \
 (I[345] = (T)(img)(_p11##x,_n4##y,z,c)), \
 (I[368] = (T)(img)(_p11##x,_n5##y,z,c)), \
 (I[391] = (T)(img)(_p11##x,_n6##y,z,c)), \
 (I[414] = (T)(img)(_p11##x,_n7##y,z,c)), \
 (I[437] = (T)(img)(_p11##x,_n8##y,z,c)), \
 (I[460] = (T)(img)(_p11##x,_n9##y,z,c)), \
 (I[483] = (T)(img)(_p11##x,_n10##y,z,c)), \
 (I[506] = (T)(img)(_p11##x,_n11##y,z,c)), \
 (I[1] = (T)(img)(_p10##x,_p11##y,z,c)), \
 (I[24] = (T)(img)(_p10##x,_p10##y,z,c)), \
 (I[47] = (T)(img)(_p10##x,_p9##y,z,c)), \
 (I[70] = (T)(img)(_p10##x,_p8##y,z,c)), \
 (I[93] = (T)(img)(_p10##x,_p7##y,z,c)), \
 (I[116] = (T)(img)(_p10##x,_p6##y,z,c)), \
 (I[139] = (T)(img)(_p10##x,_p5##y,z,c)), \
 (I[162] = (T)(img)(_p10##x,_p4##y,z,c)), \
 (I[185] = (T)(img)(_p10##x,_p3##y,z,c)), \
 (I[208] = (T)(img)(_p10##x,_p2##y,z,c)), \
 (I[231] = (T)(img)(_p10##x,_p1##y,z,c)), \
 (I[254] = (T)(img)(_p10##x,y,z,c)), \
 (I[277] = (T)(img)(_p10##x,_n1##y,z,c)), \
 (I[300] = (T)(img)(_p10##x,_n2##y,z,c)), \
 (I[323] = (T)(img)(_p10##x,_n3##y,z,c)), \
 (I[346] = (T)(img)(_p10##x,_n4##y,z,c)), \
 (I[369] = (T)(img)(_p10##x,_n5##y,z,c)), \
 (I[392] = (T)(img)(_p10##x,_n6##y,z,c)), \
 (I[415] = (T)(img)(_p10##x,_n7##y,z,c)), \
 (I[438] = (T)(img)(_p10##x,_n8##y,z,c)), \
 (I[461] = (T)(img)(_p10##x,_n9##y,z,c)), \
 (I[484] = (T)(img)(_p10##x,_n10##y,z,c)), \
 (I[507] = (T)(img)(_p10##x,_n11##y,z,c)), \
 (I[2] = (T)(img)(_p9##x,_p11##y,z,c)), \
 (I[25] = (T)(img)(_p9##x,_p10##y,z,c)), \
 (I[48] = (T)(img)(_p9##x,_p9##y,z,c)), \
 (I[71] = (T)(img)(_p9##x,_p8##y,z,c)), \
 (I[94] = (T)(img)(_p9##x,_p7##y,z,c)), \
 (I[117] = (T)(img)(_p9##x,_p6##y,z,c)), \
 (I[140] = (T)(img)(_p9##x,_p5##y,z,c)), \
 (I[163] = (T)(img)(_p9##x,_p4##y,z,c)), \
 (I[186] = (T)(img)(_p9##x,_p3##y,z,c)), \
 (I[209] = (T)(img)(_p9##x,_p2##y,z,c)), \
 (I[232] = (T)(img)(_p9##x,_p1##y,z,c)), \
 (I[255] = (T)(img)(_p9##x,y,z,c)), \
 (I[278] = (T)(img)(_p9##x,_n1##y,z,c)), \
 (I[301] = (T)(img)(_p9##x,_n2##y,z,c)), \
 (I[324] = (T)(img)(_p9##x,_n3##y,z,c)), \
 (I[347] = (T)(img)(_p9##x,_n4##y,z,c)), \
 (I[370] = (T)(img)(_p9##x,_n5##y,z,c)), \
 (I[393] = (T)(img)(_p9##x,_n6##y,z,c)), \
 (I[416] = (T)(img)(_p9##x,_n7##y,z,c)), \
 (I[439] = (T)(img)(_p9##x,_n8##y,z,c)), \
 (I[462] = (T)(img)(_p9##x,_n9##y,z,c)), \
 (I[485] = (T)(img)(_p9##x,_n10##y,z,c)), \
 (I[508] = (T)(img)(_p9##x,_n11##y,z,c)), \
 (I[3] = (T)(img)(_p8##x,_p11##y,z,c)), \
 (I[26] = (T)(img)(_p8##x,_p10##y,z,c)), \
 (I[49] = (T)(img)(_p8##x,_p9##y,z,c)), \
 (I[72] = (T)(img)(_p8##x,_p8##y,z,c)), \
 (I[95] = (T)(img)(_p8##x,_p7##y,z,c)), \
 (I[118] = (T)(img)(_p8##x,_p6##y,z,c)), \
 (I[141] = (T)(img)(_p8##x,_p5##y,z,c)), \
 (I[164] = (T)(img)(_p8##x,_p4##y,z,c)), \
 (I[187] = (T)(img)(_p8##x,_p3##y,z,c)), \
 (I[210] = (T)(img)(_p8##x,_p2##y,z,c)), \
 (I[233] = (T)(img)(_p8##x,_p1##y,z,c)), \
 (I[256] = (T)(img)(_p8##x,y,z,c)), \
 (I[279] = (T)(img)(_p8##x,_n1##y,z,c)), \
 (I[302] = (T)(img)(_p8##x,_n2##y,z,c)), \
 (I[325] = (T)(img)(_p8##x,_n3##y,z,c)), \
 (I[348] = (T)(img)(_p8##x,_n4##y,z,c)), \
 (I[371] = (T)(img)(_p8##x,_n5##y,z,c)), \
 (I[394] = (T)(img)(_p8##x,_n6##y,z,c)), \
 (I[417] = (T)(img)(_p8##x,_n7##y,z,c)), \
 (I[440] = (T)(img)(_p8##x,_n8##y,z,c)), \
 (I[463] = (T)(img)(_p8##x,_n9##y,z,c)), \
 (I[486] = (T)(img)(_p8##x,_n10##y,z,c)), \
 (I[509] = (T)(img)(_p8##x,_n11##y,z,c)), \
 (I[4] = (T)(img)(_p7##x,_p11##y,z,c)), \
 (I[27] = (T)(img)(_p7##x,_p10##y,z,c)), \
 (I[50] = (T)(img)(_p7##x,_p9##y,z,c)), \
 (I[73] = (T)(img)(_p7##x,_p8##y,z,c)), \
 (I[96] = (T)(img)(_p7##x,_p7##y,z,c)), \
 (I[119] = (T)(img)(_p7##x,_p6##y,z,c)), \
 (I[142] = (T)(img)(_p7##x,_p5##y,z,c)), \
 (I[165] = (T)(img)(_p7##x,_p4##y,z,c)), \
 (I[188] = (T)(img)(_p7##x,_p3##y,z,c)), \
 (I[211] = (T)(img)(_p7##x,_p2##y,z,c)), \
 (I[234] = (T)(img)(_p7##x,_p1##y,z,c)), \
 (I[257] = (T)(img)(_p7##x,y,z,c)), \
 (I[280] = (T)(img)(_p7##x,_n1##y,z,c)), \
 (I[303] = (T)(img)(_p7##x,_n2##y,z,c)), \
 (I[326] = (T)(img)(_p7##x,_n3##y,z,c)), \
 (I[349] = (T)(img)(_p7##x,_n4##y,z,c)), \
 (I[372] = (T)(img)(_p7##x,_n5##y,z,c)), \
 (I[395] = (T)(img)(_p7##x,_n6##y,z,c)), \
 (I[418] = (T)(img)(_p7##x,_n7##y,z,c)), \
 (I[441] = (T)(img)(_p7##x,_n8##y,z,c)), \
 (I[464] = (T)(img)(_p7##x,_n9##y,z,c)), \
 (I[487] = (T)(img)(_p7##x,_n10##y,z,c)), \
 (I[510] = (T)(img)(_p7##x,_n11##y,z,c)), \
 (I[5] = (T)(img)(_p6##x,_p11##y,z,c)), \
 (I[28] = (T)(img)(_p6##x,_p10##y,z,c)), \
 (I[51] = (T)(img)(_p6##x,_p9##y,z,c)), \
 (I[74] = (T)(img)(_p6##x,_p8##y,z,c)), \
 (I[97] = (T)(img)(_p6##x,_p7##y,z,c)), \
 (I[120] = (T)(img)(_p6##x,_p6##y,z,c)), \
 (I[143] = (T)(img)(_p6##x,_p5##y,z,c)), \
 (I[166] = (T)(img)(_p6##x,_p4##y,z,c)), \
 (I[189] = (T)(img)(_p6##x,_p3##y,z,c)), \
 (I[212] = (T)(img)(_p6##x,_p2##y,z,c)), \
 (I[235] = (T)(img)(_p6##x,_p1##y,z,c)), \
 (I[258] = (T)(img)(_p6##x,y,z,c)), \
 (I[281] = (T)(img)(_p6##x,_n1##y,z,c)), \
 (I[304] = (T)(img)(_p6##x,_n2##y,z,c)), \
 (I[327] = (T)(img)(_p6##x,_n3##y,z,c)), \
 (I[350] = (T)(img)(_p6##x,_n4##y,z,c)), \
 (I[373] = (T)(img)(_p6##x,_n5##y,z,c)), \
 (I[396] = (T)(img)(_p6##x,_n6##y,z,c)), \
 (I[419] = (T)(img)(_p6##x,_n7##y,z,c)), \
 (I[442] = (T)(img)(_p6##x,_n8##y,z,c)), \
 (I[465] = (T)(img)(_p6##x,_n9##y,z,c)), \
 (I[488] = (T)(img)(_p6##x,_n10##y,z,c)), \
 (I[511] = (T)(img)(_p6##x,_n11##y,z,c)), \
 (I[6] = (T)(img)(_p5##x,_p11##y,z,c)), \
 (I[29] = (T)(img)(_p5##x,_p10##y,z,c)), \
 (I[52] = (T)(img)(_p5##x,_p9##y,z,c)), \
 (I[75] = (T)(img)(_p5##x,_p8##y,z,c)), \
 (I[98] = (T)(img)(_p5##x,_p7##y,z,c)), \
 (I[121] = (T)(img)(_p5##x,_p6##y,z,c)), \
 (I[144] = (T)(img)(_p5##x,_p5##y,z,c)), \
 (I[167] = (T)(img)(_p5##x,_p4##y,z,c)), \
 (I[190] = (T)(img)(_p5##x,_p3##y,z,c)), \
 (I[213] = (T)(img)(_p5##x,_p2##y,z,c)), \
 (I[236] = (T)(img)(_p5##x,_p1##y,z,c)), \
 (I[259] = (T)(img)(_p5##x,y,z,c)), \
 (I[282] = (T)(img)(_p5##x,_n1##y,z,c)), \
 (I[305] = (T)(img)(_p5##x,_n2##y,z,c)), \
 (I[328] = (T)(img)(_p5##x,_n3##y,z,c)), \
 (I[351] = (T)(img)(_p5##x,_n4##y,z,c)), \
 (I[374] = (T)(img)(_p5##x,_n5##y,z,c)), \
 (I[397] = (T)(img)(_p5##x,_n6##y,z,c)), \
 (I[420] = (T)(img)(_p5##x,_n7##y,z,c)), \
 (I[443] = (T)(img)(_p5##x,_n8##y,z,c)), \
 (I[466] = (T)(img)(_p5##x,_n9##y,z,c)), \
 (I[489] = (T)(img)(_p5##x,_n10##y,z,c)), \
 (I[512] = (T)(img)(_p5##x,_n11##y,z,c)), \
 (I[7] = (T)(img)(_p4##x,_p11##y,z,c)), \
 (I[30] = (T)(img)(_p4##x,_p10##y,z,c)), \
 (I[53] = (T)(img)(_p4##x,_p9##y,z,c)), \
 (I[76] = (T)(img)(_p4##x,_p8##y,z,c)), \
 (I[99] = (T)(img)(_p4##x,_p7##y,z,c)), \
 (I[122] = (T)(img)(_p4##x,_p6##y,z,c)), \
 (I[145] = (T)(img)(_p4##x,_p5##y,z,c)), \
 (I[168] = (T)(img)(_p4##x,_p4##y,z,c)), \
 (I[191] = (T)(img)(_p4##x,_p3##y,z,c)), \
 (I[214] = (T)(img)(_p4##x,_p2##y,z,c)), \
 (I[237] = (T)(img)(_p4##x,_p1##y,z,c)), \
 (I[260] = (T)(img)(_p4##x,y,z,c)), \
 (I[283] = (T)(img)(_p4##x,_n1##y,z,c)), \
 (I[306] = (T)(img)(_p4##x,_n2##y,z,c)), \
 (I[329] = (T)(img)(_p4##x,_n3##y,z,c)), \
 (I[352] = (T)(img)(_p4##x,_n4##y,z,c)), \
 (I[375] = (T)(img)(_p4##x,_n5##y,z,c)), \
 (I[398] = (T)(img)(_p4##x,_n6##y,z,c)), \
 (I[421] = (T)(img)(_p4##x,_n7##y,z,c)), \
 (I[444] = (T)(img)(_p4##x,_n8##y,z,c)), \
 (I[467] = (T)(img)(_p4##x,_n9##y,z,c)), \
 (I[490] = (T)(img)(_p4##x,_n10##y,z,c)), \
 (I[513] = (T)(img)(_p4##x,_n11##y,z,c)), \
 (I[8] = (T)(img)(_p3##x,_p11##y,z,c)), \
 (I[31] = (T)(img)(_p3##x,_p10##y,z,c)), \
 (I[54] = (T)(img)(_p3##x,_p9##y,z,c)), \
 (I[77] = (T)(img)(_p3##x,_p8##y,z,c)), \
 (I[100] = (T)(img)(_p3##x,_p7##y,z,c)), \
 (I[123] = (T)(img)(_p3##x,_p6##y,z,c)), \
 (I[146] = (T)(img)(_p3##x,_p5##y,z,c)), \
 (I[169] = (T)(img)(_p3##x,_p4##y,z,c)), \
 (I[192] = (T)(img)(_p3##x,_p3##y,z,c)), \
 (I[215] = (T)(img)(_p3##x,_p2##y,z,c)), \
 (I[238] = (T)(img)(_p3##x,_p1##y,z,c)), \
 (I[261] = (T)(img)(_p3##x,y,z,c)), \
 (I[284] = (T)(img)(_p3##x,_n1##y,z,c)), \
 (I[307] = (T)(img)(_p3##x,_n2##y,z,c)), \
 (I[330] = (T)(img)(_p3##x,_n3##y,z,c)), \
 (I[353] = (T)(img)(_p3##x,_n4##y,z,c)), \
 (I[376] = (T)(img)(_p3##x,_n5##y,z,c)), \
 (I[399] = (T)(img)(_p3##x,_n6##y,z,c)), \
 (I[422] = (T)(img)(_p3##x,_n7##y,z,c)), \
 (I[445] = (T)(img)(_p3##x,_n8##y,z,c)), \
 (I[468] = (T)(img)(_p3##x,_n9##y,z,c)), \
 (I[491] = (T)(img)(_p3##x,_n10##y,z,c)), \
 (I[514] = (T)(img)(_p3##x,_n11##y,z,c)), \
 (I[9] = (T)(img)(_p2##x,_p11##y,z,c)), \
 (I[32] = (T)(img)(_p2##x,_p10##y,z,c)), \
 (I[55] = (T)(img)(_p2##x,_p9##y,z,c)), \
 (I[78] = (T)(img)(_p2##x,_p8##y,z,c)), \
 (I[101] = (T)(img)(_p2##x,_p7##y,z,c)), \
 (I[124] = (T)(img)(_p2##x,_p6##y,z,c)), \
 (I[147] = (T)(img)(_p2##x,_p5##y,z,c)), \
 (I[170] = (T)(img)(_p2##x,_p4##y,z,c)), \
 (I[193] = (T)(img)(_p2##x,_p3##y,z,c)), \
 (I[216] = (T)(img)(_p2##x,_p2##y,z,c)), \
 (I[239] = (T)(img)(_p2##x,_p1##y,z,c)), \
 (I[262] = (T)(img)(_p2##x,y,z,c)), \
 (I[285] = (T)(img)(_p2##x,_n1##y,z,c)), \
 (I[308] = (T)(img)(_p2##x,_n2##y,z,c)), \
 (I[331] = (T)(img)(_p2##x,_n3##y,z,c)), \
 (I[354] = (T)(img)(_p2##x,_n4##y,z,c)), \
 (I[377] = (T)(img)(_p2##x,_n5##y,z,c)), \
 (I[400] = (T)(img)(_p2##x,_n6##y,z,c)), \
 (I[423] = (T)(img)(_p2##x,_n7##y,z,c)), \
 (I[446] = (T)(img)(_p2##x,_n8##y,z,c)), \
 (I[469] = (T)(img)(_p2##x,_n9##y,z,c)), \
 (I[492] = (T)(img)(_p2##x,_n10##y,z,c)), \
 (I[515] = (T)(img)(_p2##x,_n11##y,z,c)), \
 (I[10] = (T)(img)(_p1##x,_p11##y,z,c)), \
 (I[33] = (T)(img)(_p1##x,_p10##y,z,c)), \
 (I[56] = (T)(img)(_p1##x,_p9##y,z,c)), \
 (I[79] = (T)(img)(_p1##x,_p8##y,z,c)), \
 (I[102] = (T)(img)(_p1##x,_p7##y,z,c)), \
 (I[125] = (T)(img)(_p1##x,_p6##y,z,c)), \
 (I[148] = (T)(img)(_p1##x,_p5##y,z,c)), \
 (I[171] = (T)(img)(_p1##x,_p4##y,z,c)), \
 (I[194] = (T)(img)(_p1##x,_p3##y,z,c)), \
 (I[217] = (T)(img)(_p1##x,_p2##y,z,c)), \
 (I[240] = (T)(img)(_p1##x,_p1##y,z,c)), \
 (I[263] = (T)(img)(_p1##x,y,z,c)), \
 (I[286] = (T)(img)(_p1##x,_n1##y,z,c)), \
 (I[309] = (T)(img)(_p1##x,_n2##y,z,c)), \
 (I[332] = (T)(img)(_p1##x,_n3##y,z,c)), \
 (I[355] = (T)(img)(_p1##x,_n4##y,z,c)), \
 (I[378] = (T)(img)(_p1##x,_n5##y,z,c)), \
 (I[401] = (T)(img)(_p1##x,_n6##y,z,c)), \
 (I[424] = (T)(img)(_p1##x,_n7##y,z,c)), \
 (I[447] = (T)(img)(_p1##x,_n8##y,z,c)), \
 (I[470] = (T)(img)(_p1##x,_n9##y,z,c)), \
 (I[493] = (T)(img)(_p1##x,_n10##y,z,c)), \
 (I[516] = (T)(img)(_p1##x,_n11##y,z,c)), \
 (I[11] = (T)(img)(x,_p11##y,z,c)), \
 (I[34] = (T)(img)(x,_p10##y,z,c)), \
 (I[57] = (T)(img)(x,_p9##y,z,c)), \
 (I[80] = (T)(img)(x,_p8##y,z,c)), \
 (I[103] = (T)(img)(x,_p7##y,z,c)), \
 (I[126] = (T)(img)(x,_p6##y,z,c)), \
 (I[149] = (T)(img)(x,_p5##y,z,c)), \
 (I[172] = (T)(img)(x,_p4##y,z,c)), \
 (I[195] = (T)(img)(x,_p3##y,z,c)), \
 (I[218] = (T)(img)(x,_p2##y,z,c)), \
 (I[241] = (T)(img)(x,_p1##y,z,c)), \
 (I[264] = (T)(img)(x,y,z,c)), \
 (I[287] = (T)(img)(x,_n1##y,z,c)), \
 (I[310] = (T)(img)(x,_n2##y,z,c)), \
 (I[333] = (T)(img)(x,_n3##y,z,c)), \
 (I[356] = (T)(img)(x,_n4##y,z,c)), \
 (I[379] = (T)(img)(x,_n5##y,z,c)), \
 (I[402] = (T)(img)(x,_n6##y,z,c)), \
 (I[425] = (T)(img)(x,_n7##y,z,c)), \
 (I[448] = (T)(img)(x,_n8##y,z,c)), \
 (I[471] = (T)(img)(x,_n9##y,z,c)), \
 (I[494] = (T)(img)(x,_n10##y,z,c)), \
 (I[517] = (T)(img)(x,_n11##y,z,c)), \
 (I[12] = (T)(img)(_n1##x,_p11##y,z,c)), \
 (I[35] = (T)(img)(_n1##x,_p10##y,z,c)), \
 (I[58] = (T)(img)(_n1##x,_p9##y,z,c)), \
 (I[81] = (T)(img)(_n1##x,_p8##y,z,c)), \
 (I[104] = (T)(img)(_n1##x,_p7##y,z,c)), \
 (I[127] = (T)(img)(_n1##x,_p6##y,z,c)), \
 (I[150] = (T)(img)(_n1##x,_p5##y,z,c)), \
 (I[173] = (T)(img)(_n1##x,_p4##y,z,c)), \
 (I[196] = (T)(img)(_n1##x,_p3##y,z,c)), \
 (I[219] = (T)(img)(_n1##x,_p2##y,z,c)), \
 (I[242] = (T)(img)(_n1##x,_p1##y,z,c)), \
 (I[265] = (T)(img)(_n1##x,y,z,c)), \
 (I[288] = (T)(img)(_n1##x,_n1##y,z,c)), \
 (I[311] = (T)(img)(_n1##x,_n2##y,z,c)), \
 (I[334] = (T)(img)(_n1##x,_n3##y,z,c)), \
 (I[357] = (T)(img)(_n1##x,_n4##y,z,c)), \
 (I[380] = (T)(img)(_n1##x,_n5##y,z,c)), \
 (I[403] = (T)(img)(_n1##x,_n6##y,z,c)), \
 (I[426] = (T)(img)(_n1##x,_n7##y,z,c)), \
 (I[449] = (T)(img)(_n1##x,_n8##y,z,c)), \
 (I[472] = (T)(img)(_n1##x,_n9##y,z,c)), \
 (I[495] = (T)(img)(_n1##x,_n10##y,z,c)), \
 (I[518] = (T)(img)(_n1##x,_n11##y,z,c)), \
 (I[13] = (T)(img)(_n2##x,_p11##y,z,c)), \
 (I[36] = (T)(img)(_n2##x,_p10##y,z,c)), \
 (I[59] = (T)(img)(_n2##x,_p9##y,z,c)), \
 (I[82] = (T)(img)(_n2##x,_p8##y,z,c)), \
 (I[105] = (T)(img)(_n2##x,_p7##y,z,c)), \
 (I[128] = (T)(img)(_n2##x,_p6##y,z,c)), \
 (I[151] = (T)(img)(_n2##x,_p5##y,z,c)), \
 (I[174] = (T)(img)(_n2##x,_p4##y,z,c)), \
 (I[197] = (T)(img)(_n2##x,_p3##y,z,c)), \
 (I[220] = (T)(img)(_n2##x,_p2##y,z,c)), \
 (I[243] = (T)(img)(_n2##x,_p1##y,z,c)), \
 (I[266] = (T)(img)(_n2##x,y,z,c)), \
 (I[289] = (T)(img)(_n2##x,_n1##y,z,c)), \
 (I[312] = (T)(img)(_n2##x,_n2##y,z,c)), \
 (I[335] = (T)(img)(_n2##x,_n3##y,z,c)), \
 (I[358] = (T)(img)(_n2##x,_n4##y,z,c)), \
 (I[381] = (T)(img)(_n2##x,_n5##y,z,c)), \
 (I[404] = (T)(img)(_n2##x,_n6##y,z,c)), \
 (I[427] = (T)(img)(_n2##x,_n7##y,z,c)), \
 (I[450] = (T)(img)(_n2##x,_n8##y,z,c)), \
 (I[473] = (T)(img)(_n2##x,_n9##y,z,c)), \
 (I[496] = (T)(img)(_n2##x,_n10##y,z,c)), \
 (I[519] = (T)(img)(_n2##x,_n11##y,z,c)), \
 (I[14] = (T)(img)(_n3##x,_p11##y,z,c)), \
 (I[37] = (T)(img)(_n3##x,_p10##y,z,c)), \
 (I[60] = (T)(img)(_n3##x,_p9##y,z,c)), \
 (I[83] = (T)(img)(_n3##x,_p8##y,z,c)), \
 (I[106] = (T)(img)(_n3##x,_p7##y,z,c)), \
 (I[129] = (T)(img)(_n3##x,_p6##y,z,c)), \
 (I[152] = (T)(img)(_n3##x,_p5##y,z,c)), \
 (I[175] = (T)(img)(_n3##x,_p4##y,z,c)), \
 (I[198] = (T)(img)(_n3##x,_p3##y,z,c)), \
 (I[221] = (T)(img)(_n3##x,_p2##y,z,c)), \
 (I[244] = (T)(img)(_n3##x,_p1##y,z,c)), \
 (I[267] = (T)(img)(_n3##x,y,z,c)), \
 (I[290] = (T)(img)(_n3##x,_n1##y,z,c)), \
 (I[313] = (T)(img)(_n3##x,_n2##y,z,c)), \
 (I[336] = (T)(img)(_n3##x,_n3##y,z,c)), \
 (I[359] = (T)(img)(_n3##x,_n4##y,z,c)), \
 (I[382] = (T)(img)(_n3##x,_n5##y,z,c)), \
 (I[405] = (T)(img)(_n3##x,_n6##y,z,c)), \
 (I[428] = (T)(img)(_n3##x,_n7##y,z,c)), \
 (I[451] = (T)(img)(_n3##x,_n8##y,z,c)), \
 (I[474] = (T)(img)(_n3##x,_n9##y,z,c)), \
 (I[497] = (T)(img)(_n3##x,_n10##y,z,c)), \
 (I[520] = (T)(img)(_n3##x,_n11##y,z,c)), \
 (I[15] = (T)(img)(_n4##x,_p11##y,z,c)), \
 (I[38] = (T)(img)(_n4##x,_p10##y,z,c)), \
 (I[61] = (T)(img)(_n4##x,_p9##y,z,c)), \
 (I[84] = (T)(img)(_n4##x,_p8##y,z,c)), \
 (I[107] = (T)(img)(_n4##x,_p7##y,z,c)), \
 (I[130] = (T)(img)(_n4##x,_p6##y,z,c)), \
 (I[153] = (T)(img)(_n4##x,_p5##y,z,c)), \
 (I[176] = (T)(img)(_n4##x,_p4##y,z,c)), \
 (I[199] = (T)(img)(_n4##x,_p3##y,z,c)), \
 (I[222] = (T)(img)(_n4##x,_p2##y,z,c)), \
 (I[245] = (T)(img)(_n4##x,_p1##y,z,c)), \
 (I[268] = (T)(img)(_n4##x,y,z,c)), \
 (I[291] = (T)(img)(_n4##x,_n1##y,z,c)), \
 (I[314] = (T)(img)(_n4##x,_n2##y,z,c)), \
 (I[337] = (T)(img)(_n4##x,_n3##y,z,c)), \
 (I[360] = (T)(img)(_n4##x,_n4##y,z,c)), \
 (I[383] = (T)(img)(_n4##x,_n5##y,z,c)), \
 (I[406] = (T)(img)(_n4##x,_n6##y,z,c)), \
 (I[429] = (T)(img)(_n4##x,_n7##y,z,c)), \
 (I[452] = (T)(img)(_n4##x,_n8##y,z,c)), \
 (I[475] = (T)(img)(_n4##x,_n9##y,z,c)), \
 (I[498] = (T)(img)(_n4##x,_n10##y,z,c)), \
 (I[521] = (T)(img)(_n4##x,_n11##y,z,c)), \
 (I[16] = (T)(img)(_n5##x,_p11##y,z,c)), \
 (I[39] = (T)(img)(_n5##x,_p10##y,z,c)), \
 (I[62] = (T)(img)(_n5##x,_p9##y,z,c)), \
 (I[85] = (T)(img)(_n5##x,_p8##y,z,c)), \
 (I[108] = (T)(img)(_n5##x,_p7##y,z,c)), \
 (I[131] = (T)(img)(_n5##x,_p6##y,z,c)), \
 (I[154] = (T)(img)(_n5##x,_p5##y,z,c)), \
 (I[177] = (T)(img)(_n5##x,_p4##y,z,c)), \
 (I[200] = (T)(img)(_n5##x,_p3##y,z,c)), \
 (I[223] = (T)(img)(_n5##x,_p2##y,z,c)), \
 (I[246] = (T)(img)(_n5##x,_p1##y,z,c)), \
 (I[269] = (T)(img)(_n5##x,y,z,c)), \
 (I[292] = (T)(img)(_n5##x,_n1##y,z,c)), \
 (I[315] = (T)(img)(_n5##x,_n2##y,z,c)), \
 (I[338] = (T)(img)(_n5##x,_n3##y,z,c)), \
 (I[361] = (T)(img)(_n5##x,_n4##y,z,c)), \
 (I[384] = (T)(img)(_n5##x,_n5##y,z,c)), \
 (I[407] = (T)(img)(_n5##x,_n6##y,z,c)), \
 (I[430] = (T)(img)(_n5##x,_n7##y,z,c)), \
 (I[453] = (T)(img)(_n5##x,_n8##y,z,c)), \
 (I[476] = (T)(img)(_n5##x,_n9##y,z,c)), \
 (I[499] = (T)(img)(_n5##x,_n10##y,z,c)), \
 (I[522] = (T)(img)(_n5##x,_n11##y,z,c)), \
 (I[17] = (T)(img)(_n6##x,_p11##y,z,c)), \
 (I[40] = (T)(img)(_n6##x,_p10##y,z,c)), \
 (I[63] = (T)(img)(_n6##x,_p9##y,z,c)), \
 (I[86] = (T)(img)(_n6##x,_p8##y,z,c)), \
 (I[109] = (T)(img)(_n6##x,_p7##y,z,c)), \
 (I[132] = (T)(img)(_n6##x,_p6##y,z,c)), \
 (I[155] = (T)(img)(_n6##x,_p5##y,z,c)), \
 (I[178] = (T)(img)(_n6##x,_p4##y,z,c)), \
 (I[201] = (T)(img)(_n6##x,_p3##y,z,c)), \
 (I[224] = (T)(img)(_n6##x,_p2##y,z,c)), \
 (I[247] = (T)(img)(_n6##x,_p1##y,z,c)), \
 (I[270] = (T)(img)(_n6##x,y,z,c)), \
 (I[293] = (T)(img)(_n6##x,_n1##y,z,c)), \
 (I[316] = (T)(img)(_n6##x,_n2##y,z,c)), \
 (I[339] = (T)(img)(_n6##x,_n3##y,z,c)), \
 (I[362] = (T)(img)(_n6##x,_n4##y,z,c)), \
 (I[385] = (T)(img)(_n6##x,_n5##y,z,c)), \
 (I[408] = (T)(img)(_n6##x,_n6##y,z,c)), \
 (I[431] = (T)(img)(_n6##x,_n7##y,z,c)), \
 (I[454] = (T)(img)(_n6##x,_n8##y,z,c)), \
 (I[477] = (T)(img)(_n6##x,_n9##y,z,c)), \
 (I[500] = (T)(img)(_n6##x,_n10##y,z,c)), \
 (I[523] = (T)(img)(_n6##x,_n11##y,z,c)), \
 (I[18] = (T)(img)(_n7##x,_p11##y,z,c)), \
 (I[41] = (T)(img)(_n7##x,_p10##y,z,c)), \
 (I[64] = (T)(img)(_n7##x,_p9##y,z,c)), \
 (I[87] = (T)(img)(_n7##x,_p8##y,z,c)), \
 (I[110] = (T)(img)(_n7##x,_p7##y,z,c)), \
 (I[133] = (T)(img)(_n7##x,_p6##y,z,c)), \
 (I[156] = (T)(img)(_n7##x,_p5##y,z,c)), \
 (I[179] = (T)(img)(_n7##x,_p4##y,z,c)), \
 (I[202] = (T)(img)(_n7##x,_p3##y,z,c)), \
 (I[225] = (T)(img)(_n7##x,_p2##y,z,c)), \
 (I[248] = (T)(img)(_n7##x,_p1##y,z,c)), \
 (I[271] = (T)(img)(_n7##x,y,z,c)), \
 (I[294] = (T)(img)(_n7##x,_n1##y,z,c)), \
 (I[317] = (T)(img)(_n7##x,_n2##y,z,c)), \
 (I[340] = (T)(img)(_n7##x,_n3##y,z,c)), \
 (I[363] = (T)(img)(_n7##x,_n4##y,z,c)), \
 (I[386] = (T)(img)(_n7##x,_n5##y,z,c)), \
 (I[409] = (T)(img)(_n7##x,_n6##y,z,c)), \
 (I[432] = (T)(img)(_n7##x,_n7##y,z,c)), \
 (I[455] = (T)(img)(_n7##x,_n8##y,z,c)), \
 (I[478] = (T)(img)(_n7##x,_n9##y,z,c)), \
 (I[501] = (T)(img)(_n7##x,_n10##y,z,c)), \
 (I[524] = (T)(img)(_n7##x,_n11##y,z,c)), \
 (I[19] = (T)(img)(_n8##x,_p11##y,z,c)), \
 (I[42] = (T)(img)(_n8##x,_p10##y,z,c)), \
 (I[65] = (T)(img)(_n8##x,_p9##y,z,c)), \
 (I[88] = (T)(img)(_n8##x,_p8##y,z,c)), \
 (I[111] = (T)(img)(_n8##x,_p7##y,z,c)), \
 (I[134] = (T)(img)(_n8##x,_p6##y,z,c)), \
 (I[157] = (T)(img)(_n8##x,_p5##y,z,c)), \
 (I[180] = (T)(img)(_n8##x,_p4##y,z,c)), \
 (I[203] = (T)(img)(_n8##x,_p3##y,z,c)), \
 (I[226] = (T)(img)(_n8##x,_p2##y,z,c)), \
 (I[249] = (T)(img)(_n8##x,_p1##y,z,c)), \
 (I[272] = (T)(img)(_n8##x,y,z,c)), \
 (I[295] = (T)(img)(_n8##x,_n1##y,z,c)), \
 (I[318] = (T)(img)(_n8##x,_n2##y,z,c)), \
 (I[341] = (T)(img)(_n8##x,_n3##y,z,c)), \
 (I[364] = (T)(img)(_n8##x,_n4##y,z,c)), \
 (I[387] = (T)(img)(_n8##x,_n5##y,z,c)), \
 (I[410] = (T)(img)(_n8##x,_n6##y,z,c)), \
 (I[433] = (T)(img)(_n8##x,_n7##y,z,c)), \
 (I[456] = (T)(img)(_n8##x,_n8##y,z,c)), \
 (I[479] = (T)(img)(_n8##x,_n9##y,z,c)), \
 (I[502] = (T)(img)(_n8##x,_n10##y,z,c)), \
 (I[525] = (T)(img)(_n8##x,_n11##y,z,c)), \
 (I[20] = (T)(img)(_n9##x,_p11##y,z,c)), \
 (I[43] = (T)(img)(_n9##x,_p10##y,z,c)), \
 (I[66] = (T)(img)(_n9##x,_p9##y,z,c)), \
 (I[89] = (T)(img)(_n9##x,_p8##y,z,c)), \
 (I[112] = (T)(img)(_n9##x,_p7##y,z,c)), \
 (I[135] = (T)(img)(_n9##x,_p6##y,z,c)), \
 (I[158] = (T)(img)(_n9##x,_p5##y,z,c)), \
 (I[181] = (T)(img)(_n9##x,_p4##y,z,c)), \
 (I[204] = (T)(img)(_n9##x,_p3##y,z,c)), \
 (I[227] = (T)(img)(_n9##x,_p2##y,z,c)), \
 (I[250] = (T)(img)(_n9##x,_p1##y,z,c)), \
 (I[273] = (T)(img)(_n9##x,y,z,c)), \
 (I[296] = (T)(img)(_n9##x,_n1##y,z,c)), \
 (I[319] = (T)(img)(_n9##x,_n2##y,z,c)), \
 (I[342] = (T)(img)(_n9##x,_n3##y,z,c)), \
 (I[365] = (T)(img)(_n9##x,_n4##y,z,c)), \
 (I[388] = (T)(img)(_n9##x,_n5##y,z,c)), \
 (I[411] = (T)(img)(_n9##x,_n6##y,z,c)), \
 (I[434] = (T)(img)(_n9##x,_n7##y,z,c)), \
 (I[457] = (T)(img)(_n9##x,_n8##y,z,c)), \
 (I[480] = (T)(img)(_n9##x,_n9##y,z,c)), \
 (I[503] = (T)(img)(_n9##x,_n10##y,z,c)), \
 (I[526] = (T)(img)(_n9##x,_n11##y,z,c)), \
 (I[21] = (T)(img)(_n10##x,_p11##y,z,c)), \
 (I[44] = (T)(img)(_n10##x,_p10##y,z,c)), \
 (I[67] = (T)(img)(_n10##x,_p9##y,z,c)), \
 (I[90] = (T)(img)(_n10##x,_p8##y,z,c)), \
 (I[113] = (T)(img)(_n10##x,_p7##y,z,c)), \
 (I[136] = (T)(img)(_n10##x,_p6##y,z,c)), \
 (I[159] = (T)(img)(_n10##x,_p5##y,z,c)), \
 (I[182] = (T)(img)(_n10##x,_p4##y,z,c)), \
 (I[205] = (T)(img)(_n10##x,_p3##y,z,c)), \
 (I[228] = (T)(img)(_n10##x,_p2##y,z,c)), \
 (I[251] = (T)(img)(_n10##x,_p1##y,z,c)), \
 (I[274] = (T)(img)(_n10##x,y,z,c)), \
 (I[297] = (T)(img)(_n10##x,_n1##y,z,c)), \
 (I[320] = (T)(img)(_n10##x,_n2##y,z,c)), \
 (I[343] = (T)(img)(_n10##x,_n3##y,z,c)), \
 (I[366] = (T)(img)(_n10##x,_n4##y,z,c)), \
 (I[389] = (T)(img)(_n10##x,_n5##y,z,c)), \
 (I[412] = (T)(img)(_n10##x,_n6##y,z,c)), \
 (I[435] = (T)(img)(_n10##x,_n7##y,z,c)), \
 (I[458] = (T)(img)(_n10##x,_n8##y,z,c)), \
 (I[481] = (T)(img)(_n10##x,_n9##y,z,c)), \
 (I[504] = (T)(img)(_n10##x,_n10##y,z,c)), \
 (I[527] = (T)(img)(_n10##x,_n11##y,z,c)), \
 x+11>=(img).width()?(img).width()-1:x+11); \
 x<=(int)(x1) && ((_n11##x<(img).width() && ( \
 (I[22] = (T)(img)(_n11##x,_p11##y,z,c)), \
 (I[45] = (T)(img)(_n11##x,_p10##y,z,c)), \
 (I[68] = (T)(img)(_n11##x,_p9##y,z,c)), \
 (I[91] = (T)(img)(_n11##x,_p8##y,z,c)), \
 (I[114] = (T)(img)(_n11##x,_p7##y,z,c)), \
 (I[137] = (T)(img)(_n11##x,_p6##y,z,c)), \
 (I[160] = (T)(img)(_n11##x,_p5##y,z,c)), \
 (I[183] = (T)(img)(_n11##x,_p4##y,z,c)), \
 (I[206] = (T)(img)(_n11##x,_p3##y,z,c)), \
 (I[229] = (T)(img)(_n11##x,_p2##y,z,c)), \
 (I[252] = (T)(img)(_n11##x,_p1##y,z,c)), \
 (I[275] = (T)(img)(_n11##x,y,z,c)), \
 (I[298] = (T)(img)(_n11##x,_n1##y,z,c)), \
 (I[321] = (T)(img)(_n11##x,_n2##y,z,c)), \
 (I[344] = (T)(img)(_n11##x,_n3##y,z,c)), \
 (I[367] = (T)(img)(_n11##x,_n4##y,z,c)), \
 (I[390] = (T)(img)(_n11##x,_n5##y,z,c)), \
 (I[413] = (T)(img)(_n11##x,_n6##y,z,c)), \
 (I[436] = (T)(img)(_n11##x,_n7##y,z,c)), \
 (I[459] = (T)(img)(_n11##x,_n8##y,z,c)), \
 (I[482] = (T)(img)(_n11##x,_n9##y,z,c)), \
 (I[505] = (T)(img)(_n11##x,_n10##y,z,c)), \
 (I[528] = (T)(img)(_n11##x,_n11##y,z,c)),1)) || \
 _n10##x==--_n11##x || _n9##x==--_n10##x || _n8##x==--_n9##x || _n7##x==--_n8##x || _n6##x==--_n7##x || _n5##x==--_n6##x || _n4##x==--_n5##x || _n3##x==--_n4##x || _n2##x==--_n3##x || _n1##x==--_n2##x || x==(_n11##x = _n10##x = _n9##x = _n8##x = _n7##x = _n6##x = _n5##x = _n4##x = _n3##x = _n2##x = --_n1##x)); \
 I[0] = I[1], I[1] = I[2], I[2] = I[3], I[3] = I[4], I[4] = I[5], I[5] = I[6], I[6] = I[7], I[7] = I[8], I[8] = I[9], I[9] = I[10], I[10] = I[11], I[11] = I[12], I[12] = I[13], I[13] = I[14], I[14] = I[15], I[15] = I[16], I[16] = I[17], I[17] = I[18], I[18] = I[19], I[19] = I[20], I[20] = I[21], I[21] = I[22], \
 I[23] = I[24], I[24] = I[25], I[25] = I[26], I[26] = I[27], I[27] = I[28], I[28] = I[29], I[29] = I[30], I[30] = I[31], I[31] = I[32], I[32] = I[33], I[33] = I[34], I[34] = I[35], I[35] = I[36], I[36] = I[37], I[37] = I[38], I[38] = I[39], I[39] = I[40], I[40] = I[41], I[41] = I[42], I[42] = I[43], I[43] = I[44], I[44] = I[45], \
 I[46] = I[47], I[47] = I[48], I[48] = I[49], I[49] = I[50], I[50] = I[51], I[51] = I[52], I[52] = I[53], I[53] = I[54], I[54] = I[55], I[55] = I[56], I[56] = I[57], I[57] = I[58], I[58] = I[59], I[59] = I[60], I[60] = I[61], I[61] = I[62], I[62] = I[63], I[63] = I[64], I[64] = I[65], I[65] = I[66], I[66] = I[67], I[67] = I[68], \
 I[69] = I[70], I[70] = I[71], I[71] = I[72], I[72] = I[73], I[73] = I[74], I[74] = I[75], I[75] = I[76], I[76] = I[77], I[77] = I[78], I[78] = I[79], I[79] = I[80], I[80] = I[81], I[81] = I[82], I[82] = I[83], I[83] = I[84], I[84] = I[85], I[85] = I[86], I[86] = I[87], I[87] = I[88], I[88] = I[89], I[89] = I[90], I[90] = I[91], \
 I[92] = I[93], I[93] = I[94], I[94] = I[95], I[95] = I[96], I[96] = I[97], I[97] = I[98], I[98] = I[99], I[99] = I[100], I[100] = I[101], I[101] = I[102], I[102] = I[103], I[103] = I[104], I[104] = I[105], I[105] = I[106], I[106] = I[107], I[107] = I[108], I[108] = I[109], I[109] = I[110], I[110] = I[111], I[111] = I[112], I[112] = I[113], I[113] = I[114], \
 I[115] = I[116], I[116] = I[117], I[117] = I[118], I[118] = I[119], I[119] = I[120], I[120] = I[121], I[121] = I[122], I[122] = I[123], I[123] = I[124], I[124] = I[125], I[125] = I[126], I[126] = I[127], I[127] = I[128], I[128] = I[129], I[129] = I[130], I[130] = I[131], I[131] = I[132], I[132] = I[133], I[133] = I[134], I[134] = I[135], I[135] = I[136], I[136] = I[137], \
 I[138] = I[139], I[139] = I[140], I[140] = I[141], I[141] = I[142], I[142] = I[143], I[143] = I[144], I[144] = I[145], I[145] = I[146], I[146] = I[147], I[147] = I[148], I[148] = I[149], I[149] = I[150], I[150] = I[151], I[151] = I[152], I[152] = I[153], I[153] = I[154], I[154] = I[155], I[155] = I[156], I[156] = I[157], I[157] = I[158], I[158] = I[159], I[159] = I[160], \
 I[161] = I[162], I[162] = I[163], I[163] = I[164], I[164] = I[165], I[165] = I[166], I[166] = I[167], I[167] = I[168], I[168] = I[169], I[169] = I[170], I[170] = I[171], I[171] = I[172], I[172] = I[173], I[173] = I[174], I[174] = I[175], I[175] = I[176], I[176] = I[177], I[177] = I[178], I[178] = I[179], I[179] = I[180], I[180] = I[181], I[181] = I[182], I[182] = I[183], \
 I[184] = I[185], I[185] = I[186], I[186] = I[187], I[187] = I[188], I[188] = I[189], I[189] = I[190], I[190] = I[191], I[191] = I[192], I[192] = I[193], I[193] = I[194], I[194] = I[195], I[195] = I[196], I[196] = I[197], I[197] = I[198], I[198] = I[199], I[199] = I[200], I[200] = I[201], I[201] = I[202], I[202] = I[203], I[203] = I[204], I[204] = I[205], I[205] = I[206], \
 I[207] = I[208], I[208] = I[209], I[209] = I[210], I[210] = I[211], I[211] = I[212], I[212] = I[213], I[213] = I[214], I[214] = I[215], I[215] = I[216], I[216] = I[217], I[217] = I[218], I[218] = I[219], I[219] = I[220], I[220] = I[221], I[221] = I[222], I[222] = I[223], I[223] = I[224], I[224] = I[225], I[225] = I[226], I[226] = I[227], I[227] = I[228], I[228] = I[229], \
 I[230] = I[231], I[231] = I[232], I[232] = I[233], I[233] = I[234], I[234] = I[235], I[235] = I[236], I[236] = I[237], I[237] = I[238], I[238] = I[239], I[239] = I[240], I[240] = I[241], I[241] = I[242], I[242] = I[243], I[243] = I[244], I[244] = I[245], I[245] = I[246], I[246] = I[247], I[247] = I[248], I[248] = I[249], I[249] = I[250], I[250] = I[251], I[251] = I[252], \
 I[253] = I[254], I[254] = I[255], I[255] = I[256], I[256] = I[257], I[257] = I[258], I[258] = I[259], I[259] = I[260], I[260] = I[261], I[261] = I[262], I[262] = I[263], I[263] = I[264], I[264] = I[265], I[265] = I[266], I[266] = I[267], I[267] = I[268], I[268] = I[269], I[269] = I[270], I[270] = I[271], I[271] = I[272], I[272] = I[273], I[273] = I[274], I[274] = I[275], \
 I[276] = I[277], I[277] = I[278], I[278] = I[279], I[279] = I[280], I[280] = I[281], I[281] = I[282], I[282] = I[283], I[283] = I[284], I[284] = I[285], I[285] = I[286], I[286] = I[287], I[287] = I[288], I[288] = I[289], I[289] = I[290], I[290] = I[291], I[291] = I[292], I[292] = I[293], I[293] = I[294], I[294] = I[295], I[295] = I[296], I[296] = I[297], I[297] = I[298], \
 I[299] = I[300], I[300] = I[301], I[301] = I[302], I[302] = I[303], I[303] = I[304], I[304] = I[305], I[305] = I[306], I[306] = I[307], I[307] = I[308], I[308] = I[309], I[309] = I[310], I[310] = I[311], I[311] = I[312], I[312] = I[313], I[313] = I[314], I[314] = I[315], I[315] = I[316], I[316] = I[317], I[317] = I[318], I[318] = I[319], I[319] = I[320], I[320] = I[321], \
 I[322] = I[323], I[323] = I[324], I[324] = I[325], I[325] = I[326], I[326] = I[327], I[327] = I[328], I[328] = I[329], I[329] = I[330], I[330] = I[331], I[331] = I[332], I[332] = I[333], I[333] = I[334], I[334] = I[335], I[335] = I[336], I[336] = I[337], I[337] = I[338], I[338] = I[339], I[339] = I[340], I[340] = I[341], I[341] = I[342], I[342] = I[343], I[343] = I[344], \
 I[345] = I[346], I[346] = I[347], I[347] = I[348], I[348] = I[349], I[349] = I[350], I[350] = I[351], I[351] = I[352], I[352] = I[353], I[353] = I[354], I[354] = I[355], I[355] = I[356], I[356] = I[357], I[357] = I[358], I[358] = I[359], I[359] = I[360], I[360] = I[361], I[361] = I[362], I[362] = I[363], I[363] = I[364], I[364] = I[365], I[365] = I[366], I[366] = I[367], \
 I[368] = I[369], I[369] = I[370], I[370] = I[371], I[371] = I[372], I[372] = I[373], I[373] = I[374], I[374] = I[375], I[375] = I[376], I[376] = I[377], I[377] = I[378], I[378] = I[379], I[379] = I[380], I[380] = I[381], I[381] = I[382], I[382] = I[383], I[383] = I[384], I[384] = I[385], I[385] = I[386], I[386] = I[387], I[387] = I[388], I[388] = I[389], I[389] = I[390], \
 I[391] = I[392], I[392] = I[393], I[393] = I[394], I[394] = I[395], I[395] = I[396], I[396] = I[397], I[397] = I[398], I[398] = I[399], I[399] = I[400], I[400] = I[401], I[401] = I[402], I[402] = I[403], I[403] = I[404], I[404] = I[405], I[405] = I[406], I[406] = I[407], I[407] = I[408], I[408] = I[409], I[409] = I[410], I[410] = I[411], I[411] = I[412], I[412] = I[413], \
 I[414] = I[415], I[415] = I[416], I[416] = I[417], I[417] = I[418], I[418] = I[419], I[419] = I[420], I[420] = I[421], I[421] = I[422], I[422] = I[423], I[423] = I[424], I[424] = I[425], I[425] = I[426], I[426] = I[427], I[427] = I[428], I[428] = I[429], I[429] = I[430], I[430] = I[431], I[431] = I[432], I[432] = I[433], I[433] = I[434], I[434] = I[435], I[435] = I[436], \
 I[437] = I[438], I[438] = I[439], I[439] = I[440], I[440] = I[441], I[441] = I[442], I[442] = I[443], I[443] = I[444], I[444] = I[445], I[445] = I[446], I[446] = I[447], I[447] = I[448], I[448] = I[449], I[449] = I[450], I[450] = I[451], I[451] = I[452], I[452] = I[453], I[453] = I[454], I[454] = I[455], I[455] = I[456], I[456] = I[457], I[457] = I[458], I[458] = I[459], \
 I[460] = I[461], I[461] = I[462], I[462] = I[463], I[463] = I[464], I[464] = I[465], I[465] = I[466], I[466] = I[467], I[467] = I[468], I[468] = I[469], I[469] = I[470], I[470] = I[471], I[471] = I[472], I[472] = I[473], I[473] = I[474], I[474] = I[475], I[475] = I[476], I[476] = I[477], I[477] = I[478], I[478] = I[479], I[479] = I[480], I[480] = I[481], I[481] = I[482], \
 I[483] = I[484], I[484] = I[485], I[485] = I[486], I[486] = I[487], I[487] = I[488], I[488] = I[489], I[489] = I[490], I[490] = I[491], I[491] = I[492], I[492] = I[493], I[493] = I[494], I[494] = I[495], I[495] = I[496], I[496] = I[497], I[497] = I[498], I[498] = I[499], I[499] = I[500], I[500] = I[501], I[501] = I[502], I[502] = I[503], I[503] = I[504], I[504] = I[505], \
 I[506] = I[507], I[507] = I[508], I[508] = I[509], I[509] = I[510], I[510] = I[511], I[511] = I[512], I[512] = I[513], I[513] = I[514], I[514] = I[515], I[515] = I[516], I[516] = I[517], I[517] = I[518], I[518] = I[519], I[519] = I[520], I[520] = I[521], I[521] = I[522], I[522] = I[523], I[523] = I[524], I[524] = I[525], I[525] = I[526], I[526] = I[527], I[527] = I[528], \
 _p11##x = _p10##x, _p10##x = _p9##x, _p9##x = _p8##x, _p8##x = _p7##x, _p7##x = _p6##x, _p6##x = _p5##x, _p5##x = _p4##x, _p4##x = _p3##x, _p3##x = _p2##x, _p2##x = _p1##x, _p1##x = x++, ++_n1##x, ++_n2##x, ++_n3##x, ++_n4##x, ++_n5##x, ++_n6##x, ++_n7##x, ++_n8##x, ++_n9##x, ++_n10##x, ++_n11##x)

#define cimg_get23x23(img,x,y,z,c,I,T) \
 I[0] = (T)(img)(_p11##x,_p11##y,z,c), I[1] = (T)(img)(_p10##x,_p11##y,z,c), I[2] = (T)(img)(_p9##x,_p11##y,z,c), I[3] = (T)(img)(_p8##x,_p11##y,z,c), I[4] = (T)(img)(_p7##x,_p11##y,z,c), I[5] = (T)(img)(_p6##x,_p11##y,z,c), I[6] = (T)(img)(_p5##x,_p11##y,z,c), I[7] = (T)(img)(_p4##x,_p11##y,z,c), I[8] = (T)(img)(_p3##x,_p11##y,z,c), I[9] = (T)(img)(_p2##x,_p11##y,z,c), I[10] = (T)(img)(_p1##x,_p11##y,z,c), I[11] = (T)(img)(x,_p11##y,z,c), I[12] = (T)(img)(_n1##x,_p11##y,z,c), I[13] = (T)(img)(_n2##x,_p11##y,z,c), I[14] = (T)(img)(_n3##x,_p11##y,z,c), I[15] = (T)(img)(_n4##x,_p11##y,z,c), I[16] = (T)(img)(_n5##x,_p11##y,z,c), I[17] = (T)(img)(_n6##x,_p11##y,z,c), I[18] = (T)(img)(_n7##x,_p11##y,z,c), I[19] = (T)(img)(_n8##x,_p11##y,z,c), I[20] = (T)(img)(_n9##x,_p11##y,z,c), I[21] = (T)(img)(_n10##x,_p11##y,z,c), I[22] = (T)(img)(_n11##x,_p11##y,z,c), \
 I[23] = (T)(img)(_p11##x,_p10##y,z,c), I[24] = (T)(img)(_p10##x,_p10##y,z,c), I[25] = (T)(img)(_p9##x,_p10##y,z,c), I[26] = (T)(img)(_p8##x,_p10##y,z,c), I[27] = (T)(img)(_p7##x,_p10##y,z,c), I[28] = (T)(img)(_p6##x,_p10##y,z,c), I[29] = (T)(img)(_p5##x,_p10##y,z,c), I[30] = (T)(img)(_p4##x,_p10##y,z,c), I[31] = (T)(img)(_p3##x,_p10##y,z,c), I[32] = (T)(img)(_p2##x,_p10##y,z,c), I[33] = (T)(img)(_p1##x,_p10##y,z,c), I[34] = (T)(img)(x,_p10##y,z,c), I[35] = (T)(img)(_n1##x,_p10##y,z,c), I[36] = (T)(img)(_n2##x,_p10##y,z,c), I[37] = (T)(img)(_n3##x,_p10##y,z,c), I[38] = (T)(img)(_n4##x,_p10##y,z,c), I[39] = (T)(img)(_n5##x,_p10##y,z,c), I[40] = (T)(img)(_n6##x,_p10##y,z,c), I[41] = (T)(img)(_n7##x,_p10##y,z,c), I[42] = (T)(img)(_n8##x,_p10##y,z,c), I[43] = (T)(img)(_n9##x,_p10##y,z,c), I[44] = (T)(img)(_n10##x,_p10##y,z,c), I[45] = (T)(img)(_n11##x,_p10##y,z,c), \
 I[46] = (T)(img)(_p11##x,_p9##y,z,c), I[47] = (T)(img)(_p10##x,_p9##y,z,c), I[48] = (T)(img)(_p9##x,_p9##y,z,c), I[49] = (T)(img)(_p8##x,_p9##y,z,c), I[50] = (T)(img)(_p7##x,_p9##y,z,c), I[51] = (T)(img)(_p6##x,_p9##y,z,c), I[52] = (T)(img)(_p5##x,_p9##y,z,c), I[53] = (T)(img)(_p4##x,_p9##y,z,c), I[54] = (T)(img)(_p3##x,_p9##y,z,c), I[55] = (T)(img)(_p2##x,_p9##y,z,c), I[56] = (T)(img)(_p1##x,_p9##y,z,c), I[57] = (T)(img)(x,_p9##y,z,c), I[58] = (T)(img)(_n1##x,_p9##y,z,c), I[59] = (T)(img)(_n2##x,_p9##y,z,c), I[60] = (T)(img)(_n3##x,_p9##y,z,c), I[61] = (T)(img)(_n4##x,_p9##y,z,c), I[62] = (T)(img)(_n5##x,_p9##y,z,c), I[63] = (T)(img)(_n6##x,_p9##y,z,c), I[64] = (T)(img)(_n7##x,_p9##y,z,c), I[65] = (T)(img)(_n8##x,_p9##y,z,c), I[66] = (T)(img)(_n9##x,_p9##y,z,c), I[67] = (T)(img)(_n10##x,_p9##y,z,c), I[68] = (T)(img)(_n11##x,_p9##y,z,c), \
 I[69] = (T)(img)(_p11##x,_p8##y,z,c), I[70] = (T)(img)(_p10##x,_p8##y,z,c), I[71] = (T)(img)(_p9##x,_p8##y,z,c), I[72] = (T)(img)(_p8##x,_p8##y,z,c), I[73] = (T)(img)(_p7##x,_p8##y,z,c), I[74] = (T)(img)(_p6##x,_p8##y,z,c), I[75] = (T)(img)(_p5##x,_p8##y,z,c), I[76] = (T)(img)(_p4##x,_p8##y,z,c), I[77] = (T)(img)(_p3##x,_p8##y,z,c), I[78] = (T)(img)(_p2##x,_p8##y,z,c), I[79] = (T)(img)(_p1##x,_p8##y,z,c), I[80] = (T)(img)(x,_p8##y,z,c), I[81] = (T)(img)(_n1##x,_p8##y,z,c), I[82] = (T)(img)(_n2##x,_p8##y,z,c), I[83] = (T)(img)(_n3##x,_p8##y,z,c), I[84] = (T)(img)(_n4##x,_p8##y,z,c), I[85] = (T)(img)(_n5##x,_p8##y,z,c), I[86] = (T)(img)(_n6##x,_p8##y,z,c), I[87] = (T)(img)(_n7##x,_p8##y,z,c), I[88] = (T)(img)(_n8##x,_p8##y,z,c), I[89] = (T)(img)(_n9##x,_p8##y,z,c), I[90] = (T)(img)(_n10##x,_p8##y,z,c), I[91] = (T)(img)(_n11##x,_p8##y,z,c), \
 I[92] = (T)(img)(_p11##x,_p7##y,z,c), I[93] = (T)(img)(_p10##x,_p7##y,z,c), I[94] = (T)(img)(_p9##x,_p7##y,z,c), I[95] = (T)(img)(_p8##x,_p7##y,z,c), I[96] = (T)(img)(_p7##x,_p7##y,z,c), I[97] = (T)(img)(_p6##x,_p7##y,z,c), I[98] = (T)(img)(_p5##x,_p7##y,z,c), I[99] = (T)(img)(_p4##x,_p7##y,z,c), I[100] = (T)(img)(_p3##x,_p7##y,z,c), I[101] = (T)(img)(_p2##x,_p7##y,z,c), I[102] = (T)(img)(_p1##x,_p7##y,z,c), I[103] = (T)(img)(x,_p7##y,z,c), I[104] = (T)(img)(_n1##x,_p7##y,z,c), I[105] = (T)(img)(_n2##x,_p7##y,z,c), I[106] = (T)(img)(_n3##x,_p7##y,z,c), I[107] = (T)(img)(_n4##x,_p7##y,z,c), I[108] = (T)(img)(_n5##x,_p7##y,z,c), I[109] = (T)(img)(_n6##x,_p7##y,z,c), I[110] = (T)(img)(_n7##x,_p7##y,z,c), I[111] = (T)(img)(_n8##x,_p7##y,z,c), I[112] = (T)(img)(_n9##x,_p7##y,z,c), I[113] = (T)(img)(_n10##x,_p7##y,z,c), I[114] = (T)(img)(_n11##x,_p7##y,z,c), \
 I[115] = (T)(img)(_p11##x,_p6##y,z,c), I[116] = (T)(img)(_p10##x,_p6##y,z,c), I[117] = (T)(img)(_p9##x,_p6##y,z,c), I[118] = (T)(img)(_p8##x,_p6##y,z,c), I[119] = (T)(img)(_p7##x,_p6##y,z,c), I[120] = (T)(img)(_p6##x,_p6##y,z,c), I[121] = (T)(img)(_p5##x,_p6##y,z,c), I[122] = (T)(img)(_p4##x,_p6##y,z,c), I[123] = (T)(img)(_p3##x,_p6##y,z,c), I[124] = (T)(img)(_p2##x,_p6##y,z,c), I[125] = (T)(img)(_p1##x,_p6##y,z,c), I[126] = (T)(img)(x,_p6##y,z,c), I[127] = (T)(img)(_n1##x,_p6##y,z,c), I[128] = (T)(img)(_n2##x,_p6##y,z,c), I[129] = (T)(img)(_n3##x,_p6##y,z,c), I[130] = (T)(img)(_n4##x,_p6##y,z,c), I[131] = (T)(img)(_n5##x,_p6##y,z,c), I[132] = (T)(img)(_n6##x,_p6##y,z,c), I[133] = (T)(img)(_n7##x,_p6##y,z,c), I[134] = (T)(img)(_n8##x,_p6##y,z,c), I[135] = (T)(img)(_n9##x,_p6##y,z,c), I[136] = (T)(img)(_n10##x,_p6##y,z,c), I[137] = (T)(img)(_n11##x,_p6##y,z,c), \
 I[138] = (T)(img)(_p11##x,_p5##y,z,c), I[139] = (T)(img)(_p10##x,_p5##y,z,c), I[140] = (T)(img)(_p9##x,_p5##y,z,c), I[141] = (T)(img)(_p8##x,_p5##y,z,c), I[142] = (T)(img)(_p7##x,_p5##y,z,c), I[143] = (T)(img)(_p6##x,_p5##y,z,c), I[144] = (T)(img)(_p5##x,_p5##y,z,c), I[145] = (T)(img)(_p4##x,_p5##y,z,c), I[146] = (T)(img)(_p3##x,_p5##y,z,c), I[147] = (T)(img)(_p2##x,_p5##y,z,c), I[148] = (T)(img)(_p1##x,_p5##y,z,c), I[149] = (T)(img)(x,_p5##y,z,c), I[150] = (T)(img)(_n1##x,_p5##y,z,c), I[151] = (T)(img)(_n2##x,_p5##y,z,c), I[152] = (T)(img)(_n3##x,_p5##y,z,c), I[153] = (T)(img)(_n4##x,_p5##y,z,c), I[154] = (T)(img)(_n5##x,_p5##y,z,c), I[155] = (T)(img)(_n6##x,_p5##y,z,c), I[156] = (T)(img)(_n7##x,_p5##y,z,c), I[157] = (T)(img)(_n8##x,_p5##y,z,c), I[158] = (T)(img)(_n9##x,_p5##y,z,c), I[159] = (T)(img)(_n10##x,_p5##y,z,c), I[160] = (T)(img)(_n11##x,_p5##y,z,c), \
 I[161] = (T)(img)(_p11##x,_p4##y,z,c), I[162] = (T)(img)(_p10##x,_p4##y,z,c), I[163] = (T)(img)(_p9##x,_p4##y,z,c), I[164] = (T)(img)(_p8##x,_p4##y,z,c), I[165] = (T)(img)(_p7##x,_p4##y,z,c), I[166] = (T)(img)(_p6##x,_p4##y,z,c), I[167] = (T)(img)(_p5##x,_p4##y,z,c), I[168] = (T)(img)(_p4##x,_p4##y,z,c), I[169] = (T)(img)(_p3##x,_p4##y,z,c), I[170] = (T)(img)(_p2##x,_p4##y,z,c), I[171] = (T)(img)(_p1##x,_p4##y,z,c), I[172] = (T)(img)(x,_p4##y,z,c), I[173] = (T)(img)(_n1##x,_p4##y,z,c), I[174] = (T)(img)(_n2##x,_p4##y,z,c), I[175] = (T)(img)(_n3##x,_p4##y,z,c), I[176] = (T)(img)(_n4##x,_p4##y,z,c), I[177] = (T)(img)(_n5##x,_p4##y,z,c), I[178] = (T)(img)(_n6##x,_p4##y,z,c), I[179] = (T)(img)(_n7##x,_p4##y,z,c), I[180] = (T)(img)(_n8##x,_p4##y,z,c), I[181] = (T)(img)(_n9##x,_p4##y,z,c), I[182] = (T)(img)(_n10##x,_p4##y,z,c), I[183] = (T)(img)(_n11##x,_p4##y,z,c), \
 I[184] = (T)(img)(_p11##x,_p3##y,z,c), I[185] = (T)(img)(_p10##x,_p3##y,z,c), I[186] = (T)(img)(_p9##x,_p3##y,z,c), I[187] = (T)(img)(_p8##x,_p3##y,z,c), I[188] = (T)(img)(_p7##x,_p3##y,z,c), I[189] = (T)(img)(_p6##x,_p3##y,z,c), I[190] = (T)(img)(_p5##x,_p3##y,z,c), I[191] = (T)(img)(_p4##x,_p3##y,z,c), I[192] = (T)(img)(_p3##x,_p3##y,z,c), I[193] = (T)(img)(_p2##x,_p3##y,z,c), I[194] = (T)(img)(_p1##x,_p3##y,z,c), I[195] = (T)(img)(x,_p3##y,z,c), I[196] = (T)(img)(_n1##x,_p3##y,z,c), I[197] = (T)(img)(_n2##x,_p3##y,z,c), I[198] = (T)(img)(_n3##x,_p3##y,z,c), I[199] = (T)(img)(_n4##x,_p3##y,z,c), I[200] = (T)(img)(_n5##x,_p3##y,z,c), I[201] = (T)(img)(_n6##x,_p3##y,z,c), I[202] = (T)(img)(_n7##x,_p3##y,z,c), I[203] = (T)(img)(_n8##x,_p3##y,z,c), I[204] = (T)(img)(_n9##x,_p3##y,z,c), I[205] = (T)(img)(_n10##x,_p3##y,z,c), I[206] = (T)(img)(_n11##x,_p3##y,z,c), \
 I[207] = (T)(img)(_p11##x,_p2##y,z,c), I[208] = (T)(img)(_p10##x,_p2##y,z,c), I[209] = (T)(img)(_p9##x,_p2##y,z,c), I[210] = (T)(img)(_p8##x,_p2##y,z,c), I[211] = (T)(img)(_p7##x,_p2##y,z,c), I[212] = (T)(img)(_p6##x,_p2##y,z,c), I[213] = (T)(img)(_p5##x,_p2##y,z,c), I[214] = (T)(img)(_p4##x,_p2##y,z,c), I[215] = (T)(img)(_p3##x,_p2##y,z,c), I[216] = (T)(img)(_p2##x,_p2##y,z,c), I[217] = (T)(img)(_p1##x,_p2##y,z,c), I[218] = (T)(img)(x,_p2##y,z,c), I[219] = (T)(img)(_n1##x,_p2##y,z,c), I[220] = (T)(img)(_n2##x,_p2##y,z,c), I[221] = (T)(img)(_n3##x,_p2##y,z,c), I[222] = (T)(img)(_n4##x,_p2##y,z,c), I[223] = (T)(img)(_n5##x,_p2##y,z,c), I[224] = (T)(img)(_n6##x,_p2##y,z,c), I[225] = (T)(img)(_n7##x,_p2##y,z,c), I[226] = (T)(img)(_n8##x,_p2##y,z,c), I[227] = (T)(img)(_n9##x,_p2##y,z,c), I[228] = (T)(img)(_n10##x,_p2##y,z,c), I[229] = (T)(img)(_n11##x,_p2##y,z,c), \
 I[230] = (T)(img)(_p11##x,_p1##y,z,c), I[231] = (T)(img)(_p10##x,_p1##y,z,c), I[232] = (T)(img)(_p9##x,_p1##y,z,c), I[233] = (T)(img)(_p8##x,_p1##y,z,c), I[234] = (T)(img)(_p7##x,_p1##y,z,c), I[235] = (T)(img)(_p6##x,_p1##y,z,c), I[236] = (T)(img)(_p5##x,_p1##y,z,c), I[237] = (T)(img)(_p4##x,_p1##y,z,c), I[238] = (T)(img)(_p3##x,_p1##y,z,c), I[239] = (T)(img)(_p2##x,_p1##y,z,c), I[240] = (T)(img)(_p1##x,_p1##y,z,c), I[241] = (T)(img)(x,_p1##y,z,c), I[242] = (T)(img)(_n1##x,_p1##y,z,c), I[243] = (T)(img)(_n2##x,_p1##y,z,c), I[244] = (T)(img)(_n3##x,_p1##y,z,c), I[245] = (T)(img)(_n4##x,_p1##y,z,c), I[246] = (T)(img)(_n5##x,_p1##y,z,c), I[247] = (T)(img)(_n6##x,_p1##y,z,c), I[248] = (T)(img)(_n7##x,_p1##y,z,c), I[249] = (T)(img)(_n8##x,_p1##y,z,c), I[250] = (T)(img)(_n9##x,_p1##y,z,c), I[251] = (T)(img)(_n10##x,_p1##y,z,c), I[252] = (T)(img)(_n11##x,_p1##y,z,c), \
 I[253] = (T)(img)(_p11##x,y,z,c), I[254] = (T)(img)(_p10##x,y,z,c), I[255] = (T)(img)(_p9##x,y,z,c), I[256] = (T)(img)(_p8##x,y,z,c), I[257] = (T)(img)(_p7##x,y,z,c), I[258] = (T)(img)(_p6##x,y,z,c), I[259] = (T)(img)(_p5##x,y,z,c), I[260] = (T)(img)(_p4##x,y,z,c), I[261] = (T)(img)(_p3##x,y,z,c), I[262] = (T)(img)(_p2##x,y,z,c), I[263] = (T)(img)(_p1##x,y,z,c), I[264] = (T)(img)(x,y,z,c), I[265] = (T)(img)(_n1##x,y,z,c), I[266] = (T)(img)(_n2##x,y,z,c), I[267] = (T)(img)(_n3##x,y,z,c), I[268] = (T)(img)(_n4##x,y,z,c), I[269] = (T)(img)(_n5##x,y,z,c), I[270] = (T)(img)(_n6##x,y,z,c), I[271] = (T)(img)(_n7##x,y,z,c), I[272] = (T)(img)(_n8##x,y,z,c), I[273] = (T)(img)(_n9##x,y,z,c), I[274] = (T)(img)(_n10##x,y,z,c), I[275] = (T)(img)(_n11##x,y,z,c), \
 I[276] = (T)(img)(_p11##x,_n1##y,z,c), I[277] = (T)(img)(_p10##x,_n1##y,z,c), I[278] = (T)(img)(_p9##x,_n1##y,z,c), I[279] = (T)(img)(_p8##x,_n1##y,z,c), I[280] = (T)(img)(_p7##x,_n1##y,z,c), I[281] = (T)(img)(_p6##x,_n1##y,z,c), I[282] = (T)(img)(_p5##x,_n1##y,z,c), I[283] = (T)(img)(_p4##x,_n1##y,z,c), I[284] = (T)(img)(_p3##x,_n1##y,z,c), I[285] = (T)(img)(_p2##x,_n1##y,z,c), I[286] = (T)(img)(_p1##x,_n1##y,z,c), I[287] = (T)(img)(x,_n1##y,z,c), I[288] = (T)(img)(_n1##x,_n1##y,z,c), I[289] = (T)(img)(_n2##x,_n1##y,z,c), I[290] = (T)(img)(_n3##x,_n1##y,z,c), I[291] = (T)(img)(_n4##x,_n1##y,z,c), I[292] = (T)(img)(_n5##x,_n1##y,z,c), I[293] = (T)(img)(_n6##x,_n1##y,z,c), I[294] = (T)(img)(_n7##x,_n1##y,z,c), I[295] = (T)(img)(_n8##x,_n1##y,z,c), I[296] = (T)(img)(_n9##x,_n1##y,z,c), I[297] = (T)(img)(_n10##x,_n1##y,z,c), I[298] = (T)(img)(_n11##x,_n1##y,z,c), \
 I[299] = (T)(img)(_p11##x,_n2##y,z,c), I[300] = (T)(img)(_p10##x,_n2##y,z,c), I[301] = (T)(img)(_p9##x,_n2##y,z,c), I[302] = (T)(img)(_p8##x,_n2##y,z,c), I[303] = (T)(img)(_p7##x,_n2##y,z,c), I[304] = (T)(img)(_p6##x,_n2##y,z,c), I[305] = (T)(img)(_p5##x,_n2##y,z,c), I[306] = (T)(img)(_p4##x,_n2##y,z,c), I[307] = (T)(img)(_p3##x,_n2##y,z,c), I[308] = (T)(img)(_p2##x,_n2##y,z,c), I[309] = (T)(img)(_p1##x,_n2##y,z,c), I[310] = (T)(img)(x,_n2##y,z,c), I[311] = (T)(img)(_n1##x,_n2##y,z,c), I[312] = (T)(img)(_n2##x,_n2##y,z,c), I[313] = (T)(img)(_n3##x,_n2##y,z,c), I[314] = (T)(img)(_n4##x,_n2##y,z,c), I[315] = (T)(img)(_n5##x,_n2##y,z,c), I[316] = (T)(img)(_n6##x,_n2##y,z,c), I[317] = (T)(img)(_n7##x,_n2##y,z,c), I[318] = (T)(img)(_n8##x,_n2##y,z,c), I[319] = (T)(img)(_n9##x,_n2##y,z,c), I[320] = (T)(img)(_n10##x,_n2##y,z,c), I[321] = (T)(img)(_n11##x,_n2##y,z,c), \
 I[322] = (T)(img)(_p11##x,_n3##y,z,c), I[323] = (T)(img)(_p10##x,_n3##y,z,c), I[324] = (T)(img)(_p9##x,_n3##y,z,c), I[325] = (T)(img)(_p8##x,_n3##y,z,c), I[326] = (T)(img)(_p7##x,_n3##y,z,c), I[327] = (T)(img)(_p6##x,_n3##y,z,c), I[328] = (T)(img)(_p5##x,_n3##y,z,c), I[329] = (T)(img)(_p4##x,_n3##y,z,c), I[330] = (T)(img)(_p3##x,_n3##y,z,c), I[331] = (T)(img)(_p2##x,_n3##y,z,c), I[332] = (T)(img)(_p1##x,_n3##y,z,c), I[333] = (T)(img)(x,_n3##y,z,c), I[334] = (T)(img)(_n1##x,_n3##y,z,c), I[335] = (T)(img)(_n2##x,_n3##y,z,c), I[336] = (T)(img)(_n3##x,_n3##y,z,c), I[337] = (T)(img)(_n4##x,_n3##y,z,c), I[338] = (T)(img)(_n5##x,_n3##y,z,c), I[339] = (T)(img)(_n6##x,_n3##y,z,c), I[340] = (T)(img)(_n7##x,_n3##y,z,c), I[341] = (T)(img)(_n8##x,_n3##y,z,c), I[342] = (T)(img)(_n9##x,_n3##y,z,c), I[343] = (T)(img)(_n10##x,_n3##y,z,c), I[344] = (T)(img)(_n11##x,_n3##y,z,c), \
 I[345] = (T)(img)(_p11##x,_n4##y,z,c), I[346] = (T)(img)(_p10##x,_n4##y,z,c), I[347] = (T)(img)(_p9##x,_n4##y,z,c), I[348] = (T)(img)(_p8##x,_n4##y,z,c), I[349] = (T)(img)(_p7##x,_n4##y,z,c), I[350] = (T)(img)(_p6##x,_n4##y,z,c), I[351] = (T)(img)(_p5##x,_n4##y,z,c), I[352] = (T)(img)(_p4##x,_n4##y,z,c), I[353] = (T)(img)(_p3##x,_n4##y,z,c), I[354] = (T)(img)(_p2##x,_n4##y,z,c), I[355] = (T)(img)(_p1##x,_n4##y,z,c), I[356] = (T)(img)(x,_n4##y,z,c), I[357] = (T)(img)(_n1##x,_n4##y,z,c), I[358] = (T)(img)(_n2##x,_n4##y,z,c), I[359] = (T)(img)(_n3##x,_n4##y,z,c), I[360] = (T)(img)(_n4##x,_n4##y,z,c), I[361] = (T)(img)(_n5##x,_n4##y,z,c), I[362] = (T)(img)(_n6##x,_n4##y,z,c), I[363] = (T)(img)(_n7##x,_n4##y,z,c), I[364] = (T)(img)(_n8##x,_n4##y,z,c), I[365] = (T)(img)(_n9##x,_n4##y,z,c), I[366] = (T)(img)(_n10##x,_n4##y,z,c), I[367] = (T)(img)(_n11##x,_n4##y,z,c), \
 I[368] = (T)(img)(_p11##x,_n5##y,z,c), I[369] = (T)(img)(_p10##x,_n5##y,z,c), I[370] = (T)(img)(_p9##x,_n5##y,z,c), I[371] = (T)(img)(_p8##x,_n5##y,z,c), I[372] = (T)(img)(_p7##x,_n5##y,z,c), I[373] = (T)(img)(_p6##x,_n5##y,z,c), I[374] = (T)(img)(_p5##x,_n5##y,z,c), I[375] = (T)(img)(_p4##x,_n5##y,z,c), I[376] = (T)(img)(_p3##x,_n5##y,z,c), I[377] = (T)(img)(_p2##x,_n5##y,z,c), I[378] = (T)(img)(_p1##x,_n5##y,z,c), I[379] = (T)(img)(x,_n5##y,z,c), I[380] = (T)(img)(_n1##x,_n5##y,z,c), I[381] = (T)(img)(_n2##x,_n5##y,z,c), I[382] = (T)(img)(_n3##x,_n5##y,z,c), I[383] = (T)(img)(_n4##x,_n5##y,z,c), I[384] = (T)(img)(_n5##x,_n5##y,z,c), I[385] = (T)(img)(_n6##x,_n5##y,z,c), I[386] = (T)(img)(_n7##x,_n5##y,z,c), I[387] = (T)(img)(_n8##x,_n5##y,z,c), I[388] = (T)(img)(_n9##x,_n5##y,z,c), I[389] = (T)(img)(_n10##x,_n5##y,z,c), I[390] = (T)(img)(_n11##x,_n5##y,z,c), \
 I[391] = (T)(img)(_p11##x,_n6##y,z,c), I[392] = (T)(img)(_p10##x,_n6##y,z,c), I[393] = (T)(img)(_p9##x,_n6##y,z,c), I[394] = (T)(img)(_p8##x,_n6##y,z,c), I[395] = (T)(img)(_p7##x,_n6##y,z,c), I[396] = (T)(img)(_p6##x,_n6##y,z,c), I[397] = (T)(img)(_p5##x,_n6##y,z,c), I[398] = (T)(img)(_p4##x,_n6##y,z,c), I[399] = (T)(img)(_p3##x,_n6##y,z,c), I[400] = (T)(img)(_p2##x,_n6##y,z,c), I[401] = (T)(img)(_p1##x,_n6##y,z,c), I[402] = (T)(img)(x,_n6##y,z,c), I[403] = (T)(img)(_n1##x,_n6##y,z,c), I[404] = (T)(img)(_n2##x,_n6##y,z,c), I[405] = (T)(img)(_n3##x,_n6##y,z,c), I[406] = (T)(img)(_n4##x,_n6##y,z,c), I[407] = (T)(img)(_n5##x,_n6##y,z,c), I[408] = (T)(img)(_n6##x,_n6##y,z,c), I[409] = (T)(img)(_n7##x,_n6##y,z,c), I[410] = (T)(img)(_n8##x,_n6##y,z,c), I[411] = (T)(img)(_n9##x,_n6##y,z,c), I[412] = (T)(img)(_n10##x,_n6##y,z,c), I[413] = (T)(img)(_n11##x,_n6##y,z,c), \
 I[414] = (T)(img)(_p11##x,_n7##y,z,c), I[415] = (T)(img)(_p10##x,_n7##y,z,c), I[416] = (T)(img)(_p9##x,_n7##y,z,c), I[417] = (T)(img)(_p8##x,_n7##y,z,c), I[418] = (T)(img)(_p7##x,_n7##y,z,c), I[419] = (T)(img)(_p6##x,_n7##y,z,c), I[420] = (T)(img)(_p5##x,_n7##y,z,c), I[421] = (T)(img)(_p4##x,_n7##y,z,c), I[422] = (T)(img)(_p3##x,_n7##y,z,c), I[423] = (T)(img)(_p2##x,_n7##y,z,c), I[424] = (T)(img)(_p1##x,_n7##y,z,c), I[425] = (T)(img)(x,_n7##y,z,c), I[426] = (T)(img)(_n1##x,_n7##y,z,c), I[427] = (T)(img)(_n2##x,_n7##y,z,c), I[428] = (T)(img)(_n3##x,_n7##y,z,c), I[429] = (T)(img)(_n4##x,_n7##y,z,c), I[430] = (T)(img)(_n5##x,_n7##y,z,c), I[431] = (T)(img)(_n6##x,_n7##y,z,c), I[432] = (T)(img)(_n7##x,_n7##y,z,c), I[433] = (T)(img)(_n8##x,_n7##y,z,c), I[434] = (T)(img)(_n9##x,_n7##y,z,c), I[435] = (T)(img)(_n10##x,_n7##y,z,c), I[436] = (T)(img)(_n11##x,_n7##y,z,c), \
 I[437] = (T)(img)(_p11##x,_n8##y,z,c), I[438] = (T)(img)(_p10##x,_n8##y,z,c), I[439] = (T)(img)(_p9##x,_n8##y,z,c), I[440] = (T)(img)(_p8##x,_n8##y,z,c), I[441] = (T)(img)(_p7##x,_n8##y,z,c), I[442] = (T)(img)(_p6##x,_n8##y,z,c), I[443] = (T)(img)(_p5##x,_n8##y,z,c), I[444] = (T)(img)(_p4##x,_n8##y,z,c), I[445] = (T)(img)(_p3##x,_n8##y,z,c), I[446] = (T)(img)(_p2##x,_n8##y,z,c), I[447] = (T)(img)(_p1##x,_n8##y,z,c), I[448] = (T)(img)(x,_n8##y,z,c), I[449] = (T)(img)(_n1##x,_n8##y,z,c), I[450] = (T)(img)(_n2##x,_n8##y,z,c), I[451] = (T)(img)(_n3##x,_n8##y,z,c), I[452] = (T)(img)(_n4##x,_n8##y,z,c), I[453] = (T)(img)(_n5##x,_n8##y,z,c), I[454] = (T)(img)(_n6##x,_n8##y,z,c), I[455] = (T)(img)(_n7##x,_n8##y,z,c), I[456] = (T)(img)(_n8##x,_n8##y,z,c), I[457] = (T)(img)(_n9##x,_n8##y,z,c), I[458] = (T)(img)(_n10##x,_n8##y,z,c), I[459] = (T)(img)(_n11##x,_n8##y,z,c), \
 I[460] = (T)(img)(_p11##x,_n9##y,z,c), I[461] = (T)(img)(_p10##x,_n9##y,z,c), I[462] = (T)(img)(_p9##x,_n9##y,z,c), I[463] = (T)(img)(_p8##x,_n9##y,z,c), I[464] = (T)(img)(_p7##x,_n9##y,z,c), I[465] = (T)(img)(_p6##x,_n9##y,z,c), I[466] = (T)(img)(_p5##x,_n9##y,z,c), I[467] = (T)(img)(_p4##x,_n9##y,z,c), I[468] = (T)(img)(_p3##x,_n9##y,z,c), I[469] = (T)(img)(_p2##x,_n9##y,z,c), I[470] = (T)(img)(_p1##x,_n9##y,z,c), I[471] = (T)(img)(x,_n9##y,z,c), I[472] = (T)(img)(_n1##x,_n9##y,z,c), I[473] = (T)(img)(_n2##x,_n9##y,z,c), I[474] = (T)(img)(_n3##x,_n9##y,z,c), I[475] = (T)(img)(_n4##x,_n9##y,z,c), I[476] = (T)(img)(_n5##x,_n9##y,z,c), I[477] = (T)(img)(_n6##x,_n9##y,z,c), I[478] = (T)(img)(_n7##x,_n9##y,z,c), I[479] = (T)(img)(_n8##x,_n9##y,z,c), I[480] = (T)(img)(_n9##x,_n9##y,z,c), I[481] = (T)(img)(_n10##x,_n9##y,z,c), I[482] = (T)(img)(_n11##x,_n9##y,z,c), \
 I[483] = (T)(img)(_p11##x,_n10##y,z,c), I[484] = (T)(img)(_p10##x,_n10##y,z,c), I[485] = (T)(img)(_p9##x,_n10##y,z,c), I[486] = (T)(img)(_p8##x,_n10##y,z,c), I[487] = (T)(img)(_p7##x,_n10##y,z,c), I[488] = (T)(img)(_p6##x,_n10##y,z,c), I[489] = (T)(img)(_p5##x,_n10##y,z,c), I[490] = (T)(img)(_p4##x,_n10##y,z,c), I[491] = (T)(img)(_p3##x,_n10##y,z,c), I[492] = (T)(img)(_p2##x,_n10##y,z,c), I[493] = (T)(img)(_p1##x,_n10##y,z,c), I[494] = (T)(img)(x,_n10##y,z,c), I[495] = (T)(img)(_n1##x,_n10##y,z,c), I[496] = (T)(img)(_n2##x,_n10##y,z,c), I[497] = (T)(img)(_n3##x,_n10##y,z,c), I[498] = (T)(img)(_n4##x,_n10##y,z,c), I[499] = (T)(img)(_n5##x,_n10##y,z,c), I[500] = (T)(img)(_n6##x,_n10##y,z,c), I[501] = (T)(img)(_n7##x,_n10##y,z,c), I[502] = (T)(img)(_n8##x,_n10##y,z,c), I[503] = (T)(img)(_n9##x,_n10##y,z,c), I[504] = (T)(img)(_n10##x,_n10##y,z,c), I[505] = (T)(img)(_n11##x,_n10##y,z,c), \
 I[506] = (T)(img)(_p11##x,_n11##y,z,c), I[507] = (T)(img)(_p10##x,_n11##y,z,c), I[508] = (T)(img)(_p9##x,_n11##y,z,c), I[509] = (T)(img)(_p8##x,_n11##y,z,c), I[510] = (T)(img)(_p7##x,_n11##y,z,c), I[511] = (T)(img)(_p6##x,_n11##y,z,c), I[512] = (T)(img)(_p5##x,_n11##y,z,c), I[513] = (T)(img)(_p4##x,_n11##y,z,c), I[514] = (T)(img)(_p3##x,_n11##y,z,c), I[515] = (T)(img)(_p2##x,_n11##y,z,c), I[516] = (T)(img)(_p1##x,_n11##y,z,c), I[517] = (T)(img)(x,_n11##y,z,c), I[518] = (T)(img)(_n1##x,_n11##y,z,c), I[519] = (T)(img)(_n2##x,_n11##y,z,c), I[520] = (T)(img)(_n3##x,_n11##y,z,c), I[521] = (T)(img)(_n4##x,_n11##y,z,c), I[522] = (T)(img)(_n5##x,_n11##y,z,c), I[523] = (T)(img)(_n6##x,_n11##y,z,c), I[524] = (T)(img)(_n7##x,_n11##y,z,c), I[525] = (T)(img)(_n8##x,_n11##y,z,c), I[526] = (T)(img)(_n9##x,_n11##y,z,c), I[527] = (T)(img)(_n10##x,_n11##y,z,c), I[528] = (T)(img)(_n11##x,_n11##y,z,c);

// Define 24x24 loop macros
//-------------------------
#define cimg_for24(bound,i) for (int i = 0, \
 _p11##i = 0, _p10##i = 0, _p9##i = 0, _p8##i = 0, _p7##i = 0, _p6##i = 0, _p5##i = 0, _p4##i = 0, _p3##i = 0, _p2##i = 0, _p1##i = 0, \
 _n1##i = 1>=(int)(bound)?(int)(bound)-1:1, \
 _n2##i = 2>=(int)(bound)?(int)(bound)-1:2, \
 _n3##i = 3>=(int)(bound)?(int)(bound)-1:3, \
 _n4##i = 4>=(int)(bound)?(int)(bound)-1:4, \
 _n5##i = 5>=(int)(bound)?(int)(bound)-1:5, \
 _n6##i = 6>=(int)(bound)?(int)(bound)-1:6, \
 _n7##i = 7>=(int)(bound)?(int)(bound)-1:7, \
 _n8##i = 8>=(int)(bound)?(int)(bound)-1:8, \
 _n9##i = 9>=(int)(bound)?(int)(bound)-1:9, \
 _n10##i = 10>=(int)(bound)?(int)(bound)-1:10, \
 _n11##i = 11>=(int)(bound)?(int)(bound)-1:11, \
 _n12##i = 12>=(int)(bound)?(int)(bound)-1:12; \
 _n12##i<(int)(bound) || _n11##i==--_n12##i || _n10##i==--_n11##i || _n9##i==--_n10##i || _n8##i==--_n9##i || _n7##i==--_n8##i || _n6##i==--_n7##i || _n5##i==--_n6##i || _n4##i==--_n5##i || _n3##i==--_n4##i || _n2##i==--_n3##i || _n1##i==--_n2##i || \
 i==(_n12##i = _n11##i = _n10##i = _n9##i = _n8##i = _n7##i = _n6##i = _n5##i = _n4##i = _n3##i = _n2##i = --_n1##i); \
 _p11##i = _p10##i, _p10##i = _p9##i, _p9##i = _p8##i, _p8##i = _p7##i, _p7##i = _p6##i, _p6##i = _p5##i, _p5##i = _p4##i, _p4##i = _p3##i, _p3##i = _p2##i, _p2##i = _p1##i, _p1##i = i++, \
 ++_n1##i, ++_n2##i, ++_n3##i, ++_n4##i, ++_n5##i, ++_n6##i, ++_n7##i, ++_n8##i, ++_n9##i, ++_n10##i, ++_n11##i, ++_n12##i)

#define cimg_for24X(img,x) cimg_for24((img)._width,x)
#define cimg_for24Y(img,y) cimg_for24((img)._height,y)
#define cimg_for24Z(img,z) cimg_for24((img)._depth,z)
#define cimg_for24C(img,c) cimg_for24((img)._spectrum,c)
#define cimg_for24XY(img,x,y) cimg_for24Y(img,y) cimg_for24X(img,x)
#define cimg_for24XZ(img,x,z) cimg_for24Z(img,z) cimg_for24X(img,x)
#define cimg_for24XC(img,x,c) cimg_for24C(img,c) cimg_for24X(img,x)
#define cimg_for24YZ(img,y,z) cimg_for24Z(img,z) cimg_for24Y(img,y)
#define cimg_for24YC(img,y,c) cimg_for24C(img,c) cimg_for24Y(img,y)
#define cimg_for24ZC(img,z,c) cimg_for24C(img,c) cimg_for24Z(img,z)
#define cimg_for24XYZ(img,x,y,z) cimg_for24Z(img,z) cimg_for24XY(img,x,y)
#define cimg_for24XZC(img,x,z,c) cimg_for24C(img,c) cimg_for24XZ(img,x,z)
#define cimg_for24YZC(img,y,z,c) cimg_for24C(img,c) cimg_for24YZ(img,y,z)
#define cimg_for24XYZC(img,x,y,z,c) cimg_for24C(img,c) cimg_for24XYZ(img,x,y,z)

#define cimg_for_in24(bound,i0,i1,i) for (int i = (int)(i0)<0?0:(int)(i0), \
 _p11##i = i-11<0?0:i-11, \
 _p10##i = i-10<0?0:i-10, \
 _p9##i = i-9<0?0:i-9, \
 _p8##i = i-8<0?0:i-8, \
 _p7##i = i-7<0?0:i-7, \
 _p6##i = i-6<0?0:i-6, \
 _p5##i = i-5<0?0:i-5, \
 _p4##i = i-4<0?0:i-4, \
 _p3##i = i-3<0?0:i-3, \
 _p2##i = i-2<0?0:i-2, \
 _p1##i = i-1<0?0:i-1, \
 _n1##i = i+1>=(int)(bound)?(int)(bound)-1:i+1, \
 _n2##i = i+2>=(int)(bound)?(int)(bound)-1:i+2, \
 _n3##i = i+3>=(int)(bound)?(int)(bound)-1:i+3, \
 _n4##i = i+4>=(int)(bound)?(int)(bound)-1:i+4, \
 _n5##i = i+5>=(int)(bound)?(int)(bound)-1:i+5, \
 _n6##i = i+6>=(int)(bound)?(int)(bound)-1:i+6, \
 _n7##i = i+7>=(int)(bound)?(int)(bound)-1:i+7, \
 _n8##i = i+8>=(int)(bound)?(int)(bound)-1:i+8, \
 _n9##i = i+9>=(int)(bound)?(int)(bound)-1:i+9, \
 _n10##i = i+10>=(int)(bound)?(int)(bound)-1:i+10, \
 _n11##i = i+11>=(int)(bound)?(int)(bound)-1:i+11, \
 _n12##i = i+12>=(int)(bound)?(int)(bound)-1:i+12; \
 i<=(int)(i1) && (_n12##i<(int)(bound) || _n11##i==--_n12##i || _n10##i==--_n11##i || _n9##i==--_n10##i || _n8##i==--_n9##i || _n7##i==--_n8##i || _n6##i==--_n7##i || _n5##i==--_n6##i || _n4##i==--_n5##i || _n3##i==--_n4##i || _n2##i==--_n3##i || _n1##i==--_n2##i || \
 i==(_n12##i = _n11##i = _n10##i = _n9##i = _n8##i = _n7##i = _n6##i = _n5##i = _n4##i = _n3##i = _n2##i = --_n1##i)); \
 _p11##i = _p10##i, _p10##i = _p9##i, _p9##i = _p8##i, _p8##i = _p7##i, _p7##i = _p6##i, _p6##i = _p5##i, _p5##i = _p4##i, _p4##i = _p3##i, _p3##i = _p2##i, _p2##i = _p1##i, _p1##i = i++, \
 ++_n1##i, ++_n2##i, ++_n3##i, ++_n4##i, ++_n5##i, ++_n6##i, ++_n7##i, ++_n8##i, ++_n9##i, ++_n10##i, ++_n11##i, ++_n12##i)

#define cimg_for_in24X(img,x0,x1,x) cimg_for_in24((img)._width,x0,x1,x)
#define cimg_for_in24Y(img,y0,y1,y) cimg_for_in24((img)._height,y0,y1,y)
#define cimg_for_in24Z(img,z0,z1,z) cimg_for_in24((img)._depth,z0,z1,z)
#define cimg_for_in24C(img,c0,c1,c) cimg_for_in24((img)._spectrum,c0,c1,c)
#define cimg_for_in24XY(img,x0,y0,x1,y1,x,y) cimg_for_in24Y(img,y0,y1,y) cimg_for_in24X(img,x0,x1,x)
#define cimg_for_in24XZ(img,x0,z0,x1,z1,x,z) cimg_for_in24Z(img,z0,z1,z) cimg_for_in24X(img,x0,x1,x)
#define cimg_for_in24XC(img,x0,c0,x1,c1,x,c) cimg_for_in24C(img,c0,c1,c) cimg_for_in24X(img,x0,x1,x)
#define cimg_for_in24YZ(img,y0,z0,y1,z1,y,z) cimg_for_in24Z(img,z0,z1,z) cimg_for_in24Y(img,y0,y1,y)
#define cimg_for_in24YC(img,y0,c0,y1,c1,y,c) cimg_for_in24C(img,c0,c1,c) cimg_for_in24Y(img,y0,y1,y)
#define cimg_for_in24ZC(img,z0,c0,z1,c1,z,c) cimg_for_in24C(img,c0,c1,c) cimg_for_in24Z(img,z0,z1,z)
#define cimg_for_in24XYZ(img,x0,y0,z0,x1,y1,z1,x,y,z) cimg_for_in24Z(img,z0,z1,z) cimg_for_in24XY(img,x0,y0,x1,y1,x,y)
#define cimg_for_in24XZC(img,x0,z0,c0,x1,y1,c1,x,z,c) cimg_for_in24C(img,c0,c1,c) cimg_for_in24XZ(img,x0,y0,x1,y1,x,z)
#define cimg_for_in24YZC(img,y0,z0,c0,y1,z1,c1,y,z,c) cimg_for_in24C(img,c0,c1,c) cimg_for_in24YZ(img,y0,z0,y1,z1,y,z)
#define cimg_for_in24XYZC(img,x0,y0,z0,c0,x1,y1,z1,c1,x,y,z,c) cimg_for_in24C(img,c0,c1,c) cimg_for_in24XYZ(img,x0,y0,z0,x1,y1,z1,x,y,z)

#define cimg_for24x24(img,x,y,z,c,I,T) \
 cimg_for24((img)._height,y) for (int x = 0, \
 _p11##x = 0, _p10##x = 0, _p9##x = 0, _p8##x = 0, _p7##x = 0, _p6##x = 0, _p5##x = 0, _p4##x = 0, _p3##x = 0, _p2##x = 0, _p1##x = 0, \
 _n1##x = 1>=((img)._width)?(img).width()-1:1, \
 _n2##x = 2>=((img)._width)?(img).width()-1:2, \
 _n3##x = 3>=((img)._width)?(img).width()-1:3, \
 _n4##x = 4>=((img)._width)?(img).width()-1:4, \
 _n5##x = 5>=((img)._width)?(img).width()-1:5, \
 _n6##x = 6>=((img)._width)?(img).width()-1:6, \
 _n7##x = 7>=((img)._width)?(img).width()-1:7, \
 _n8##x = 8>=((img)._width)?(img).width()-1:8, \
 _n9##x = 9>=((img)._width)?(img).width()-1:9, \
 _n10##x = 10>=((img)._width)?(img).width()-1:10, \
 _n11##x = 11>=((img)._width)?(img).width()-1:11, \
 _n12##x = (int)( \
 (I[0] = I[1] = I[2] = I[3] = I[4] = I[5] = I[6] = I[7] = I[8] = I[9] = I[10] = I[11] = (T)(img)(0,_p11##y,z,c)), \
 (I[24] = I[25] = I[26] = I[27] = I[28] = I[29] = I[30] = I[31] = I[32] = I[33] = I[34] = I[35] = (T)(img)(0,_p10##y,z,c)), \
 (I[48] = I[49] = I[50] = I[51] = I[52] = I[53] = I[54] = I[55] = I[56] = I[57] = I[58] = I[59] = (T)(img)(0,_p9##y,z,c)), \
 (I[72] = I[73] = I[74] = I[75] = I[76] = I[77] = I[78] = I[79] = I[80] = I[81] = I[82] = I[83] = (T)(img)(0,_p8##y,z,c)), \
 (I[96] = I[97] = I[98] = I[99] = I[100] = I[101] = I[102] = I[103] = I[104] = I[105] = I[106] = I[107] = (T)(img)(0,_p7##y,z,c)), \
 (I[120] = I[121] = I[122] = I[123] = I[124] = I[125] = I[126] = I[127] = I[128] = I[129] = I[130] = I[131] = (T)(img)(0,_p6##y,z,c)), \
 (I[144] = I[145] = I[146] = I[147] = I[148] = I[149] = I[150] = I[151] = I[152] = I[153] = I[154] = I[155] = (T)(img)(0,_p5##y,z,c)), \
 (I[168] = I[169] = I[170] = I[171] = I[172] = I[173] = I[174] = I[175] = I[176] = I[177] = I[178] = I[179] = (T)(img)(0,_p4##y,z,c)), \
 (I[192] = I[193] = I[194] = I[195] = I[196] = I[197] = I[198] = I[199] = I[200] = I[201] = I[202] = I[203] = (T)(img)(0,_p3##y,z,c)), \
 (I[216] = I[217] = I[218] = I[219] = I[220] = I[221] = I[222] = I[223] = I[224] = I[225] = I[226] = I[227] = (T)(img)(0,_p2##y,z,c)), \
 (I[240] = I[241] = I[242] = I[243] = I[244] = I[245] = I[246] = I[247] = I[248] = I[249] = I[250] = I[251] = (T)(img)(0,_p1##y,z,c)), \
 (I[264] = I[265] = I[266] = I[267] = I[268] = I[269] = I[270] = I[271] = I[272] = I[273] = I[274] = I[275] = (T)(img)(0,y,z,c)), \
 (I[288] = I[289] = I[290] = I[291] = I[292] = I[293] = I[294] = I[295] = I[296] = I[297] = I[298] = I[299] = (T)(img)(0,_n1##y,z,c)), \
 (I[312] = I[313] = I[314] = I[315] = I[316] = I[317] = I[318] = I[319] = I[320] = I[321] = I[322] = I[323] = (T)(img)(0,_n2##y,z,c)), \
 (I[336] = I[337] = I[338] = I[339] = I[340] = I[341] = I[342] = I[343] = I[344] = I[345] = I[346] = I[347] = (T)(img)(0,_n3##y,z,c)), \
 (I[360] = I[361] = I[362] = I[363] = I[364] = I[365] = I[366] = I[367] = I[368] = I[369] = I[370] = I[371] = (T)(img)(0,_n4##y,z,c)), \
 (I[384] = I[385] = I[386] = I[387] = I[388] = I[389] = I[390] = I[391] = I[392] = I[393] = I[394] = I[395] = (T)(img)(0,_n5##y,z,c)), \
 (I[408] = I[409] = I[410] = I[411] = I[412] = I[413] = I[414] = I[415] = I[416] = I[417] = I[418] = I[419] = (T)(img)(0,_n6##y,z,c)), \
 (I[432] = I[433] = I[434] = I[435] = I[436] = I[437] = I[438] = I[439] = I[440] = I[441] = I[442] = I[443] = (T)(img)(0,_n7##y,z,c)), \
 (I[456] = I[457] = I[458] = I[459] = I[460] = I[461] = I[462] = I[463] = I[464] = I[465] = I[466] = I[467] = (T)(img)(0,_n8##y,z,c)), \
 (I[480] = I[481] = I[482] = I[483] = I[484] = I[485] = I[486] = I[487] = I[488] = I[489] = I[490] = I[491] = (T)(img)(0,_n9##y,z,c)), \
 (I[504] = I[505] = I[506] = I[507] = I[508] = I[509] = I[510] = I[511] = I[512] = I[513] = I[514] = I[515] = (T)(img)(0,_n10##y,z,c)), \
 (I[528] = I[529] = I[530] = I[531] = I[532] = I[533] = I[534] = I[535] = I[536] = I[537] = I[538] = I[539] = (T)(img)(0,_n11##y,z,c)), \
 (I[552] = I[553] = I[554] = I[555] = I[556] = I[557] = I[558] = I[559] = I[560] = I[561] = I[562] = I[563] = (T)(img)(0,_n12##y,z,c)), \
 (I[12] = (T)(img)(_n1##x,_p11##y,z,c)), \
 (I[36] = (T)(img)(_n1##x,_p10##y,z,c)), \
 (I[60] = (T)(img)(_n1##x,_p9##y,z,c)), \
 (I[84] = (T)(img)(_n1##x,_p8##y,z,c)), \
 (I[108] = (T)(img)(_n1##x,_p7##y,z,c)), \
 (I[132] = (T)(img)(_n1##x,_p6##y,z,c)), \
 (I[156] = (T)(img)(_n1##x,_p5##y,z,c)), \
 (I[180] = (T)(img)(_n1##x,_p4##y,z,c)), \
 (I[204] = (T)(img)(_n1##x,_p3##y,z,c)), \
 (I[228] = (T)(img)(_n1##x,_p2##y,z,c)), \
 (I[252] = (T)(img)(_n1##x,_p1##y,z,c)), \
 (I[276] = (T)(img)(_n1##x,y,z,c)), \
 (I[300] = (T)(img)(_n1##x,_n1##y,z,c)), \
 (I[324] = (T)(img)(_n1##x,_n2##y,z,c)), \
 (I[348] = (T)(img)(_n1##x,_n3##y,z,c)), \
 (I[372] = (T)(img)(_n1##x,_n4##y,z,c)), \
 (I[396] = (T)(img)(_n1##x,_n5##y,z,c)), \
 (I[420] = (T)(img)(_n1##x,_n6##y,z,c)), \
 (I[444] = (T)(img)(_n1##x,_n7##y,z,c)), \
 (I[468] = (T)(img)(_n1##x,_n8##y,z,c)), \
 (I[492] = (T)(img)(_n1##x,_n9##y,z,c)), \
 (I[516] = (T)(img)(_n1##x,_n10##y,z,c)), \
 (I[540] = (T)(img)(_n1##x,_n11##y,z,c)), \
 (I[564] = (T)(img)(_n1##x,_n12##y,z,c)), \
 (I[13] = (T)(img)(_n2##x,_p11##y,z,c)), \
 (I[37] = (T)(img)(_n2##x,_p10##y,z,c)), \
 (I[61] = (T)(img)(_n2##x,_p9##y,z,c)), \
 (I[85] = (T)(img)(_n2##x,_p8##y,z,c)), \
 (I[109] = (T)(img)(_n2##x,_p7##y,z,c)), \
 (I[133] = (T)(img)(_n2##x,_p6##y,z,c)), \
 (I[157] = (T)(img)(_n2##x,_p5##y,z,c)), \
 (I[181] = (T)(img)(_n2##x,_p4##y,z,c)), \
 (I[205] = (T)(img)(_n2##x,_p3##y,z,c)), \
 (I[229] = (T)(img)(_n2##x,_p2##y,z,c)), \
 (I[253] = (T)(img)(_n2##x,_p1##y,z,c)), \
 (I[277] = (T)(img)(_n2##x,y,z,c)), \
 (I[301] = (T)(img)(_n2##x,_n1##y,z,c)), \
 (I[325] = (T)(img)(_n2##x,_n2##y,z,c)), \
 (I[349] = (T)(img)(_n2##x,_n3##y,z,c)), \
 (I[373] = (T)(img)(_n2##x,_n4##y,z,c)), \
 (I[397] = (T)(img)(_n2##x,_n5##y,z,c)), \
 (I[421] = (T)(img)(_n2##x,_n6##y,z,c)), \
 (I[445] = (T)(img)(_n2##x,_n7##y,z,c)), \
 (I[469] = (T)(img)(_n2##x,_n8##y,z,c)), \
 (I[493] = (T)(img)(_n2##x,_n9##y,z,c)), \
 (I[517] = (T)(img)(_n2##x,_n10##y,z,c)), \
 (I[541] = (T)(img)(_n2##x,_n11##y,z,c)), \
 (I[565] = (T)(img)(_n2##x,_n12##y,z,c)), \
 (I[14] = (T)(img)(_n3##x,_p11##y,z,c)), \
 (I[38] = (T)(img)(_n3##x,_p10##y,z,c)), \
 (I[62] = (T)(img)(_n3##x,_p9##y,z,c)), \
 (I[86] = (T)(img)(_n3##x,_p8##y,z,c)), \
 (I[110] = (T)(img)(_n3##x,_p7##y,z,c)), \
 (I[134] = (T)(img)(_n3##x,_p6##y,z,c)), \
 (I[158] = (T)(img)(_n3##x,_p5##y,z,c)), \
 (I[182] = (T)(img)(_n3##x,_p4##y,z,c)), \
 (I[206] = (T)(img)(_n3##x,_p3##y,z,c)), \
 (I[230] = (T)(img)(_n3##x,_p2##y,z,c)), \
 (I[254] = (T)(img)(_n3##x,_p1##y,z,c)), \
 (I[278] = (T)(img)(_n3##x,y,z,c)), \
 (I[302] = (T)(img)(_n3##x,_n1##y,z,c)), \
 (I[326] = (T)(img)(_n3##x,_n2##y,z,c)), \
 (I[350] = (T)(img)(_n3##x,_n3##y,z,c)), \
 (I[374] = (T)(img)(_n3##x,_n4##y,z,c)), \
 (I[398] = (T)(img)(_n3##x,_n5##y,z,c)), \
 (I[422] = (T)(img)(_n3##x,_n6##y,z,c)), \
 (I[446] = (T)(img)(_n3##x,_n7##y,z,c)), \
 (I[470] = (T)(img)(_n3##x,_n8##y,z,c)), \
 (I[494] = (T)(img)(_n3##x,_n9##y,z,c)), \
 (I[518] = (T)(img)(_n3##x,_n10##y,z,c)), \
 (I[542] = (T)(img)(_n3##x,_n11##y,z,c)), \
 (I[566] = (T)(img)(_n3##x,_n12##y,z,c)), \
 (I[15] = (T)(img)(_n4##x,_p11##y,z,c)), \
 (I[39] = (T)(img)(_n4##x,_p10##y,z,c)), \
 (I[63] = (T)(img)(_n4##x,_p9##y,z,c)), \
 (I[87] = (T)(img)(_n4##x,_p8##y,z,c)), \
 (I[111] = (T)(img)(_n4##x,_p7##y,z,c)), \
 (I[135] = (T)(img)(_n4##x,_p6##y,z,c)), \
 (I[159] = (T)(img)(_n4##x,_p5##y,z,c)), \
 (I[183] = (T)(img)(_n4##x,_p4##y,z,c)), \
 (I[207] = (T)(img)(_n4##x,_p3##y,z,c)), \
 (I[231] = (T)(img)(_n4##x,_p2##y,z,c)), \
 (I[255] = (T)(img)(_n4##x,_p1##y,z,c)), \
 (I[279] = (T)(img)(_n4##x,y,z,c)), \
 (I[303] = (T)(img)(_n4##x,_n1##y,z,c)), \
 (I[327] = (T)(img)(_n4##x,_n2##y,z,c)), \
 (I[351] = (T)(img)(_n4##x,_n3##y,z,c)), \
 (I[375] = (T)(img)(_n4##x,_n4##y,z,c)), \
 (I[399] = (T)(img)(_n4##x,_n5##y,z,c)), \
 (I[423] = (T)(img)(_n4##x,_n6##y,z,c)), \
 (I[447] = (T)(img)(_n4##x,_n7##y,z,c)), \
 (I[471] = (T)(img)(_n4##x,_n8##y,z,c)), \
 (I[495] = (T)(img)(_n4##x,_n9##y,z,c)), \
 (I[519] = (T)(img)(_n4##x,_n10##y,z,c)), \
 (I[543] = (T)(img)(_n4##x,_n11##y,z,c)), \
 (I[567] = (T)(img)(_n4##x,_n12##y,z,c)), \
 (I[16] = (T)(img)(_n5##x,_p11##y,z,c)), \
 (I[40] = (T)(img)(_n5##x,_p10##y,z,c)), \
 (I[64] = (T)(img)(_n5##x,_p9##y,z,c)), \
 (I[88] = (T)(img)(_n5##x,_p8##y,z,c)), \
 (I[112] = (T)(img)(_n5##x,_p7##y,z,c)), \
 (I[136] = (T)(img)(_n5##x,_p6##y,z,c)), \
 (I[160] = (T)(img)(_n5##x,_p5##y,z,c)), \
 (I[184] = (T)(img)(_n5##x,_p4##y,z,c)), \
 (I[208] = (T)(img)(_n5##x,_p3##y,z,c)), \
 (I[232] = (T)(img)(_n5##x,_p2##y,z,c)), \
 (I[256] = (T)(img)(_n5##x,_p1##y,z,c)), \
 (I[280] = (T)(img)(_n5##x,y,z,c)), \
 (I[304] = (T)(img)(_n5##x,_n1##y,z,c)), \
 (I[328] = (T)(img)(_n5##x,_n2##y,z,c)), \
 (I[352] = (T)(img)(_n5##x,_n3##y,z,c)), \
 (I[376] = (T)(img)(_n5##x,_n4##y,z,c)), \
 (I[400] = (T)(img)(_n5##x,_n5##y,z,c)), \
 (I[424] = (T)(img)(_n5##x,_n6##y,z,c)), \
 (I[448] = (T)(img)(_n5##x,_n7##y,z,c)), \
 (I[472] = (T)(img)(_n5##x,_n8##y,z,c)), \
 (I[496] = (T)(img)(_n5##x,_n9##y,z,c)), \
 (I[520] = (T)(img)(_n5##x,_n10##y,z,c)), \
 (I[544] = (T)(img)(_n5##x,_n11##y,z,c)), \
 (I[568] = (T)(img)(_n5##x,_n12##y,z,c)), \
 (I[17] = (T)(img)(_n6##x,_p11##y,z,c)), \
 (I[41] = (T)(img)(_n6##x,_p10##y,z,c)), \
 (I[65] = (T)(img)(_n6##x,_p9##y,z,c)), \
 (I[89] = (T)(img)(_n6##x,_p8##y,z,c)), \
 (I[113] = (T)(img)(_n6##x,_p7##y,z,c)), \
 (I[137] = (T)(img)(_n6##x,_p6##y,z,c)), \
 (I[161] = (T)(img)(_n6##x,_p5##y,z,c)), \
 (I[185] = (T)(img)(_n6##x,_p4##y,z,c)), \
 (I[209] = (T)(img)(_n6##x,_p3##y,z,c)), \
 (I[233] = (T)(img)(_n6##x,_p2##y,z,c)), \
 (I[257] = (T)(img)(_n6##x,_p1##y,z,c)), \
 (I[281] = (T)(img)(_n6##x,y,z,c)), \
 (I[305] = (T)(img)(_n6##x,_n1##y,z,c)), \
 (I[329] = (T)(img)(_n6##x,_n2##y,z,c)), \
 (I[353] = (T)(img)(_n6##x,_n3##y,z,c)), \
 (I[377] = (T)(img)(_n6##x,_n4##y,z,c)), \
 (I[401] = (T)(img)(_n6##x,_n5##y,z,c)), \
 (I[425] = (T)(img)(_n6##x,_n6##y,z,c)), \
 (I[449] = (T)(img)(_n6##x,_n7##y,z,c)), \
 (I[473] = (T)(img)(_n6##x,_n8##y,z,c)), \
 (I[497] = (T)(img)(_n6##x,_n9##y,z,c)), \
 (I[521] = (T)(img)(_n6##x,_n10##y,z,c)), \
 (I[545] = (T)(img)(_n6##x,_n11##y,z,c)), \
 (I[569] = (T)(img)(_n6##x,_n12##y,z,c)), \
 (I[18] = (T)(img)(_n7##x,_p11##y,z,c)), \
 (I[42] = (T)(img)(_n7##x,_p10##y,z,c)), \
 (I[66] = (T)(img)(_n7##x,_p9##y,z,c)), \
 (I[90] = (T)(img)(_n7##x,_p8##y,z,c)), \
 (I[114] = (T)(img)(_n7##x,_p7##y,z,c)), \
 (I[138] = (T)(img)(_n7##x,_p6##y,z,c)), \
 (I[162] = (T)(img)(_n7##x,_p5##y,z,c)), \
 (I[186] = (T)(img)(_n7##x,_p4##y,z,c)), \
 (I[210] = (T)(img)(_n7##x,_p3##y,z,c)), \
 (I[234] = (T)(img)(_n7##x,_p2##y,z,c)), \
 (I[258] = (T)(img)(_n7##x,_p1##y,z,c)), \
 (I[282] = (T)(img)(_n7##x,y,z,c)), \
 (I[306] = (T)(img)(_n7##x,_n1##y,z,c)), \
 (I[330] = (T)(img)(_n7##x,_n2##y,z,c)), \
 (I[354] = (T)(img)(_n7##x,_n3##y,z,c)), \
 (I[378] = (T)(img)(_n7##x,_n4##y,z,c)), \
 (I[402] = (T)(img)(_n7##x,_n5##y,z,c)), \
 (I[426] = (T)(img)(_n7##x,_n6##y,z,c)), \
 (I[450] = (T)(img)(_n7##x,_n7##y,z,c)), \
 (I[474] = (T)(img)(_n7##x,_n8##y,z,c)), \
 (I[498] = (T)(img)(_n7##x,_n9##y,z,c)), \
 (I[522] = (T)(img)(_n7##x,_n10##y,z,c)), \
 (I[546] = (T)(img)(_n7##x,_n11##y,z,c)), \
 (I[570] = (T)(img)(_n7##x,_n12##y,z,c)), \
 (I[19] = (T)(img)(_n8##x,_p11##y,z,c)), \
 (I[43] = (T)(img)(_n8##x,_p10##y,z,c)), \
 (I[67] = (T)(img)(_n8##x,_p9##y,z,c)), \
 (I[91] = (T)(img)(_n8##x,_p8##y,z,c)), \
 (I[115] = (T)(img)(_n8##x,_p7##y,z,c)), \
 (I[139] = (T)(img)(_n8##x,_p6##y,z,c)), \
 (I[163] = (T)(img)(_n8##x,_p5##y,z,c)), \
 (I[187] = (T)(img)(_n8##x,_p4##y,z,c)), \
 (I[211] = (T)(img)(_n8##x,_p3##y,z,c)), \
 (I[235] = (T)(img)(_n8##x,_p2##y,z,c)), \
 (I[259] = (T)(img)(_n8##x,_p1##y,z,c)), \
 (I[283] = (T)(img)(_n8##x,y,z,c)), \
 (I[307] = (T)(img)(_n8##x,_n1##y,z,c)), \
 (I[331] = (T)(img)(_n8##x,_n2##y,z,c)), \
 (I[355] = (T)(img)(_n8##x,_n3##y,z,c)), \
 (I[379] = (T)(img)(_n8##x,_n4##y,z,c)), \
 (I[403] = (T)(img)(_n8##x,_n5##y,z,c)), \
 (I[427] = (T)(img)(_n8##x,_n6##y,z,c)), \
 (I[451] = (T)(img)(_n8##x,_n7##y,z,c)), \
 (I[475] = (T)(img)(_n8##x,_n8##y,z,c)), \
 (I[499] = (T)(img)(_n8##x,_n9##y,z,c)), \
 (I[523] = (T)(img)(_n8##x,_n10##y,z,c)), \
 (I[547] = (T)(img)(_n8##x,_n11##y,z,c)), \
 (I[571] = (T)(img)(_n8##x,_n12##y,z,c)), \
 (I[20] = (T)(img)(_n9##x,_p11##y,z,c)), \
 (I[44] = (T)(img)(_n9##x,_p10##y,z,c)), \
 (I[68] = (T)(img)(_n9##x,_p9##y,z,c)), \
 (I[92] = (T)(img)(_n9##x,_p8##y,z,c)), \
 (I[116] = (T)(img)(_n9##x,_p7##y,z,c)), \
 (I[140] = (T)(img)(_n9##x,_p6##y,z,c)), \
 (I[164] = (T)(img)(_n9##x,_p5##y,z,c)), \
 (I[188] = (T)(img)(_n9##x,_p4##y,z,c)), \
 (I[212] = (T)(img)(_n9##x,_p3##y,z,c)), \
 (I[236] = (T)(img)(_n9##x,_p2##y,z,c)), \
 (I[260] = (T)(img)(_n9##x,_p1##y,z,c)), \
 (I[284] = (T)(img)(_n9##x,y,z,c)), \
 (I[308] = (T)(img)(_n9##x,_n1##y,z,c)), \
 (I[332] = (T)(img)(_n9##x,_n2##y,z,c)), \
 (I[356] = (T)(img)(_n9##x,_n3##y,z,c)), \
 (I[380] = (T)(img)(_n9##x,_n4##y,z,c)), \
 (I[404] = (T)(img)(_n9##x,_n5##y,z,c)), \
 (I[428] = (T)(img)(_n9##x,_n6##y,z,c)), \
 (I[452] = (T)(img)(_n9##x,_n7##y,z,c)), \
 (I[476] = (T)(img)(_n9##x,_n8##y,z,c)), \
 (I[500] = (T)(img)(_n9##x,_n9##y,z,c)), \
 (I[524] = (T)(img)(_n9##x,_n10##y,z,c)), \
 (I[548] = (T)(img)(_n9##x,_n11##y,z,c)), \
 (I[572] = (T)(img)(_n9##x,_n12##y,z,c)), \
 (I[21] = (T)(img)(_n10##x,_p11##y,z,c)), \
 (I[45] = (T)(img)(_n10##x,_p10##y,z,c)), \
 (I[69] = (T)(img)(_n10##x,_p9##y,z,c)), \
 (I[93] = (T)(img)(_n10##x,_p8##y,z,c)), \
 (I[117] = (T)(img)(_n10##x,_p7##y,z,c)), \
 (I[141] = (T)(img)(_n10##x,_p6##y,z,c)), \
 (I[165] = (T)(img)(_n10##x,_p5##y,z,c)), \
 (I[189] = (T)(img)(_n10##x,_p4##y,z,c)), \
 (I[213] = (T)(img)(_n10##x,_p3##y,z,c)), \
 (I[237] = (T)(img)(_n10##x,_p2##y,z,c)), \
 (I[261] = (T)(img)(_n10##x,_p1##y,z,c)), \
 (I[285] = (T)(img)(_n10##x,y,z,c)), \
 (I[309] = (T)(img)(_n10##x,_n1##y,z,c)), \
 (I[333] = (T)(img)(_n10##x,_n2##y,z,c)), \
 (I[357] = (T)(img)(_n10##x,_n3##y,z,c)), \
 (I[381] = (T)(img)(_n10##x,_n4##y,z,c)), \
 (I[405] = (T)(img)(_n10##x,_n5##y,z,c)), \
 (I[429] = (T)(img)(_n10##x,_n6##y,z,c)), \
 (I[453] = (T)(img)(_n10##x,_n7##y,z,c)), \
 (I[477] = (T)(img)(_n10##x,_n8##y,z,c)), \
 (I[501] = (T)(img)(_n10##x,_n9##y,z,c)), \
 (I[525] = (T)(img)(_n10##x,_n10##y,z,c)), \
 (I[549] = (T)(img)(_n10##x,_n11##y,z,c)), \
 (I[573] = (T)(img)(_n10##x,_n12##y,z,c)), \
 (I[22] = (T)(img)(_n11##x,_p11##y,z,c)), \
 (I[46] = (T)(img)(_n11##x,_p10##y,z,c)), \
 (I[70] = (T)(img)(_n11##x,_p9##y,z,c)), \
 (I[94] = (T)(img)(_n11##x,_p8##y,z,c)), \
 (I[118] = (T)(img)(_n11##x,_p7##y,z,c)), \
 (I[142] = (T)(img)(_n11##x,_p6##y,z,c)), \
 (I[166] = (T)(img)(_n11##x,_p5##y,z,c)), \
 (I[190] = (T)(img)(_n11##x,_p4##y,z,c)), \
 (I[214] = (T)(img)(_n11##x,_p3##y,z,c)), \
 (I[238] = (T)(img)(_n11##x,_p2##y,z,c)), \
 (I[262] = (T)(img)(_n11##x,_p1##y,z,c)), \
 (I[286] = (T)(img)(_n11##x,y,z,c)), \
 (I[310] = (T)(img)(_n11##x,_n1##y,z,c)), \
 (I[334] = (T)(img)(_n11##x,_n2##y,z,c)), \
 (I[358] = (T)(img)(_n11##x,_n3##y,z,c)), \
 (I[382] = (T)(img)(_n11##x,_n4##y,z,c)), \
 (I[406] = (T)(img)(_n11##x,_n5##y,z,c)), \
 (I[430] = (T)(img)(_n11##x,_n6##y,z,c)), \
 (I[454] = (T)(img)(_n11##x,_n7##y,z,c)), \
 (I[478] = (T)(img)(_n11##x,_n8##y,z,c)), \
 (I[502] = (T)(img)(_n11##x,_n9##y,z,c)), \
 (I[526] = (T)(img)(_n11##x,_n10##y,z,c)), \
 (I[550] = (T)(img)(_n11##x,_n11##y,z,c)), \
 (I[574] = (T)(img)(_n11##x,_n12##y,z,c)), \
 12>=((img)._width)?(img).width()-1:12); \
 (_n12##x<(img).width() && ( \
 (I[23] = (T)(img)(_n12##x,_p11##y,z,c)), \
 (I[47] = (T)(img)(_n12##x,_p10##y,z,c)), \
 (I[71] = (T)(img)(_n12##x,_p9##y,z,c)), \
 (I[95] = (T)(img)(_n12##x,_p8##y,z,c)), \
 (I[119] = (T)(img)(_n12##x,_p7##y,z,c)), \
 (I[143] = (T)(img)(_n12##x,_p6##y,z,c)), \
 (I[167] = (T)(img)(_n12##x,_p5##y,z,c)), \
 (I[191] = (T)(img)(_n12##x,_p4##y,z,c)), \
 (I[215] = (T)(img)(_n12##x,_p3##y,z,c)), \
 (I[239] = (T)(img)(_n12##x,_p2##y,z,c)), \
 (I[263] = (T)(img)(_n12##x,_p1##y,z,c)), \
 (I[287] = (T)(img)(_n12##x,y,z,c)), \
 (I[311] = (T)(img)(_n12##x,_n1##y,z,c)), \
 (I[335] = (T)(img)(_n12##x,_n2##y,z,c)), \
 (I[359] = (T)(img)(_n12##x,_n3##y,z,c)), \
 (I[383] = (T)(img)(_n12##x,_n4##y,z,c)), \
 (I[407] = (T)(img)(_n12##x,_n5##y,z,c)), \
 (I[431] = (T)(img)(_n12##x,_n6##y,z,c)), \
 (I[455] = (T)(img)(_n12##x,_n7##y,z,c)), \
 (I[479] = (T)(img)(_n12##x,_n8##y,z,c)), \
 (I[503] = (T)(img)(_n12##x,_n9##y,z,c)), \
 (I[527] = (T)(img)(_n12##x,_n10##y,z,c)), \
 (I[551] = (T)(img)(_n12##x,_n11##y,z,c)), \
 (I[575] = (T)(img)(_n12##x,_n12##y,z,c)),1)) || \
 _n11##x==--_n12##x || _n10##x==--_n11##x || _n9##x==--_n10##x || _n8##x==--_n9##x || _n7##x==--_n8##x || _n6##x==--_n7##x || _n5##x==--_n6##x || _n4##x==--_n5##x || _n3##x==--_n4##x || _n2##x==--_n3##x || _n1##x==--_n2##x || x==(_n12##x = _n11##x = _n10##x = _n9##x = _n8##x = _n7##x = _n6##x = _n5##x = _n4##x = _n3##x = _n2##x = --_n1##x); \
 I[0] = I[1], I[1] = I[2], I[2] = I[3], I[3] = I[4], I[4] = I[5], I[5] = I[6], I[6] = I[7], I[7] = I[8], I[8] = I[9], I[9] = I[10], I[10] = I[11], I[11] = I[12], I[12] = I[13], I[13] = I[14], I[14] = I[15], I[15] = I[16], I[16] = I[17], I[17] = I[18], I[18] = I[19], I[19] = I[20], I[20] = I[21], I[21] = I[22], I[22] = I[23], \
 I[24] = I[25], I[25] = I[26], I[26] = I[27], I[27] = I[28], I[28] = I[29], I[29] = I[30], I[30] = I[31], I[31] = I[32], I[32] = I[33], I[33] = I[34], I[34] = I[35], I[35] = I[36], I[36] = I[37], I[37] = I[38], I[38] = I[39], I[39] = I[40], I[40] = I[41], I[41] = I[42], I[42] = I[43], I[43] = I[44], I[44] = I[45], I[45] = I[46], I[46] = I[47], \
 I[48] = I[49], I[49] = I[50], I[50] = I[51], I[51] = I[52], I[52] = I[53], I[53] = I[54], I[54] = I[55], I[55] = I[56], I[56] = I[57], I[57] = I[58], I[58] = I[59], I[59] = I[60], I[60] = I[61], I[61] = I[62], I[62] = I[63], I[63] = I[64], I[64] = I[65], I[65] = I[66], I[66] = I[67], I[67] = I[68], I[68] = I[69], I[69] = I[70], I[70] = I[71], \
 I[72] = I[73], I[73] = I[74], I[74] = I[75], I[75] = I[76], I[76] = I[77], I[77] = I[78], I[78] = I[79], I[79] = I[80], I[80] = I[81], I[81] = I[82], I[82] = I[83], I[83] = I[84], I[84] = I[85], I[85] = I[86], I[86] = I[87], I[87] = I[88], I[88] = I[89], I[89] = I[90], I[90] = I[91], I[91] = I[92], I[92] = I[93], I[93] = I[94], I[94] = I[95], \
 I[96] = I[97], I[97] = I[98], I[98] = I[99], I[99] = I[100], I[100] = I[101], I[101] = I[102], I[102] = I[103], I[103] = I[104], I[104] = I[105], I[105] = I[106], I[106] = I[107], I[107] = I[108], I[108] = I[109], I[109] = I[110], I[110] = I[111], I[111] = I[112], I[112] = I[113], I[113] = I[114], I[114] = I[115], I[115] = I[116], I[116] = I[117], I[117] = I[118], I[118] = I[119], \
 I[120] = I[121], I[121] = I[122], I[122] = I[123], I[123] = I[124], I[124] = I[125], I[125] = I[126], I[126] = I[127], I[127] = I[128], I[128] = I[129], I[129] = I[130], I[130] = I[131], I[131] = I[132], I[132] = I[133], I[133] = I[134], I[134] = I[135], I[135] = I[136], I[136] = I[137], I[137] = I[138], I[138] = I[139], I[139] = I[140], I[140] = I[141], I[141] = I[142], I[142] = I[143], \
 I[144] = I[145], I[145] = I[146], I[146] = I[147], I[147] = I[148], I[148] = I[149], I[149] = I[150], I[150] = I[151], I[151] = I[152], I[152] = I[153], I[153] = I[154], I[154] = I[155], I[155] = I[156], I[156] = I[157], I[157] = I[158], I[158] = I[159], I[159] = I[160], I[160] = I[161], I[161] = I[162], I[162] = I[163], I[163] = I[164], I[164] = I[165], I[165] = I[166], I[166] = I[167], \
 I[168] = I[169], I[169] = I[170], I[170] = I[171], I[171] = I[172], I[172] = I[173], I[173] = I[174], I[174] = I[175], I[175] = I[176], I[176] = I[177], I[177] = I[178], I[178] = I[179], I[179] = I[180], I[180] = I[181], I[181] = I[182], I[182] = I[183], I[183] = I[184], I[184] = I[185], I[185] = I[186], I[186] = I[187], I[187] = I[188], I[188] = I[189], I[189] = I[190], I[190] = I[191], \
 I[192] = I[193], I[193] = I[194], I[194] = I[195], I[195] = I[196], I[196] = I[197], I[197] = I[198], I[198] = I[199], I[199] = I[200], I[200] = I[201], I[201] = I[202], I[202] = I[203], I[203] = I[204], I[204] = I[205], I[205] = I[206], I[206] = I[207], I[207] = I[208], I[208] = I[209], I[209] = I[210], I[210] = I[211], I[211] = I[212], I[212] = I[213], I[213] = I[214], I[214] = I[215], \
 I[216] = I[217], I[217] = I[218], I[218] = I[219], I[219] = I[220], I[220] = I[221], I[221] = I[222], I[222] = I[223], I[223] = I[224], I[224] = I[225], I[225] = I[226], I[226] = I[227], I[227] = I[228], I[228] = I[229], I[229] = I[230], I[230] = I[231], I[231] = I[232], I[232] = I[233], I[233] = I[234], I[234] = I[235], I[235] = I[236], I[236] = I[237], I[237] = I[238], I[238] = I[239], \
 I[240] = I[241], I[241] = I[242], I[242] = I[243], I[243] = I[244], I[244] = I[245], I[245] = I[246], I[246] = I[247], I[247] = I[248], I[248] = I[249], I[249] = I[250], I[250] = I[251], I[251] = I[252], I[252] = I[253], I[253] = I[254], I[254] = I[255], I[255] = I[256], I[256] = I[257], I[257] = I[258], I[258] = I[259], I[259] = I[260], I[260] = I[261], I[261] = I[262], I[262] = I[263], \
 I[264] = I[265], I[265] = I[266], I[266] = I[267], I[267] = I[268], I[268] = I[269], I[269] = I[270], I[270] = I[271], I[271] = I[272], I[272] = I[273], I[273] = I[274], I[274] = I[275], I[275] = I[276], I[276] = I[277], I[277] = I[278], I[278] = I[279], I[279] = I[280], I[280] = I[281], I[281] = I[282], I[282] = I[283], I[283] = I[284], I[284] = I[285], I[285] = I[286], I[286] = I[287], \
 I[288] = I[289], I[289] = I[290], I[290] = I[291], I[291] = I[292], I[292] = I[293], I[293] = I[294], I[294] = I[295], I[295] = I[296], I[296] = I[297], I[297] = I[298], I[298] = I[299], I[299] = I[300], I[300] = I[301], I[301] = I[302], I[302] = I[303], I[303] = I[304], I[304] = I[305], I[305] = I[306], I[306] = I[307], I[307] = I[308], I[308] = I[309], I[309] = I[310], I[310] = I[311], \
 I[312] = I[313], I[313] = I[314], I[314] = I[315], I[315] = I[316], I[316] = I[317], I[317] = I[318], I[318] = I[319], I[319] = I[320], I[320] = I[321], I[321] = I[322], I[322] = I[323], I[323] = I[324], I[324] = I[325], I[325] = I[326], I[326] = I[327], I[327] = I[328], I[328] = I[329], I[329] = I[330], I[330] = I[331], I[331] = I[332], I[332] = I[333], I[333] = I[334], I[334] = I[335], \
 I[336] = I[337], I[337] = I[338], I[338] = I[339], I[339] = I[340], I[340] = I[341], I[341] = I[342], I[342] = I[343], I[343] = I[344], I[344] = I[345], I[345] = I[346], I[346] = I[347], I[347] = I[348], I[348] = I[349], I[349] = I[350], I[350] = I[351], I[351] = I[352], I[352] = I[353], I[353] = I[354], I[354] = I[355], I[355] = I[356], I[356] = I[357], I[357] = I[358], I[358] = I[359], \
 I[360] = I[361], I[361] = I[362], I[362] = I[363], I[363] = I[364], I[364] = I[365], I[365] = I[366], I[366] = I[367], I[367] = I[368], I[368] = I[369], I[369] = I[370], I[370] = I[371], I[371] = I[372], I[372] = I[373], I[373] = I[374], I[374] = I[375], I[375] = I[376], I[376] = I[377], I[377] = I[378], I[378] = I[379], I[379] = I[380], I[380] = I[381], I[381] = I[382], I[382] = I[383], \
 I[384] = I[385], I[385] = I[386], I[386] = I[387], I[387] = I[388], I[388] = I[389], I[389] = I[390], I[390] = I[391], I[391] = I[392], I[392] = I[393], I[393] = I[394], I[394] = I[395], I[395] = I[396], I[396] = I[397], I[397] = I[398], I[398] = I[399], I[399] = I[400], I[400] = I[401], I[401] = I[402], I[402] = I[403], I[403] = I[404], I[404] = I[405], I[405] = I[406], I[406] = I[407], \
 I[408] = I[409], I[409] = I[410], I[410] = I[411], I[411] = I[412], I[412] = I[413], I[413] = I[414], I[414] = I[415], I[415] = I[416], I[416] = I[417], I[417] = I[418], I[418] = I[419], I[419] = I[420], I[420] = I[421], I[421] = I[422], I[422] = I[423], I[423] = I[424], I[424] = I[425], I[425] = I[426], I[426] = I[427], I[427] = I[428], I[428] = I[429], I[429] = I[430], I[430] = I[431], \
 I[432] = I[433], I[433] = I[434], I[434] = I[435], I[435] = I[436], I[436] = I[437], I[437] = I[438], I[438] = I[439], I[439] = I[440], I[440] = I[441], I[441] = I[442], I[442] = I[443], I[443] = I[444], I[444] = I[445], I[445] = I[446], I[446] = I[447], I[447] = I[448], I[448] = I[449], I[449] = I[450], I[450] = I[451], I[451] = I[452], I[452] = I[453], I[453] = I[454], I[454] = I[455], \
 I[456] = I[457], I[457] = I[458], I[458] = I[459], I[459] = I[460], I[460] = I[461], I[461] = I[462], I[462] = I[463], I[463] = I[464], I[464] = I[465], I[465] = I[466], I[466] = I[467], I[467] = I[468], I[468] = I[469], I[469] = I[470], I[470] = I[471], I[471] = I[472], I[472] = I[473], I[473] = I[474], I[474] = I[475], I[475] = I[476], I[476] = I[477], I[477] = I[478], I[478] = I[479], \
 I[480] = I[481], I[481] = I[482], I[482] = I[483], I[483] = I[484], I[484] = I[485], I[485] = I[486], I[486] = I[487], I[487] = I[488], I[488] = I[489], I[489] = I[490], I[490] = I[491], I[491] = I[492], I[492] = I[493], I[493] = I[494], I[494] = I[495], I[495] = I[496], I[496] = I[497], I[497] = I[498], I[498] = I[499], I[499] = I[500], I[500] = I[501], I[501] = I[502], I[502] = I[503], \
 I[504] = I[505], I[505] = I[506], I[506] = I[507], I[507] = I[508], I[508] = I[509], I[509] = I[510], I[510] = I[511], I[511] = I[512], I[512] = I[513], I[513] = I[514], I[514] = I[515], I[515] = I[516], I[516] = I[517], I[517] = I[518], I[518] = I[519], I[519] = I[520], I[520] = I[521], I[521] = I[522], I[522] = I[523], I[523] = I[524], I[524] = I[525], I[525] = I[526], I[526] = I[527], \
 I[528] = I[529], I[529] = I[530], I[530] = I[531], I[531] = I[532], I[532] = I[533], I[533] = I[534], I[534] = I[535], I[535] = I[536], I[536] = I[537], I[537] = I[538], I[538] = I[539], I[539] = I[540], I[540] = I[541], I[541] = I[542], I[542] = I[543], I[543] = I[544], I[544] = I[545], I[545] = I[546], I[546] = I[547], I[547] = I[548], I[548] = I[549], I[549] = I[550], I[550] = I[551], \
 I[552] = I[553], I[553] = I[554], I[554] = I[555], I[555] = I[556], I[556] = I[557], I[557] = I[558], I[558] = I[559], I[559] = I[560], I[560] = I[561], I[561] = I[562], I[562] = I[563], I[563] = I[564], I[564] = I[565], I[565] = I[566], I[566] = I[567], I[567] = I[568], I[568] = I[569], I[569] = I[570], I[570] = I[571], I[571] = I[572], I[572] = I[573], I[573] = I[574], I[574] = I[575], \
 _p11##x = _p10##x, _p10##x = _p9##x, _p9##x = _p8##x, _p8##x = _p7##x, _p7##x = _p6##x, _p6##x = _p5##x, _p5##x = _p4##x, _p4##x = _p3##x, _p3##x = _p2##x, _p2##x = _p1##x, _p1##x = x++, ++_n1##x, ++_n2##x, ++_n3##x, ++_n4##x, ++_n5##x, ++_n6##x, ++_n7##x, ++_n8##x, ++_n9##x, ++_n10##x, ++_n11##x, ++_n12##x)

#define cimg_for_in24x24(img,x0,y0,x1,y1,x,y,z,c,I,T) \
 cimg_for_in24((img)._height,y0,y1,y) for (int x = (int)(x0)<0?0:(int)(x0), \
 _p11##x = x-11<0?0:x-11, \
 _p10##x = x-10<0?0:x-10, \
 _p9##x = x-9<0?0:x-9, \
 _p8##x = x-8<0?0:x-8, \
 _p7##x = x-7<0?0:x-7, \
 _p6##x = x-6<0?0:x-6, \
 _p5##x = x-5<0?0:x-5, \
 _p4##x = x-4<0?0:x-4, \
 _p3##x = x-3<0?0:x-3, \
 _p2##x = x-2<0?0:x-2, \
 _p1##x = x-1<0?0:x-1, \
 _n1##x = x+1>=(img).width()?(img).width()-1:x+1, \
 _n2##x = x+2>=(img).width()?(img).width()-1:x+2, \
 _n3##x = x+3>=(img).width()?(img).width()-1:x+3, \
 _n4##x = x+4>=(img).width()?(img).width()-1:x+4, \
 _n5##x = x+5>=(img).width()?(img).width()-1:x+5, \
 _n6##x = x+6>=(img).width()?(img).width()-1:x+6, \
 _n7##x = x+7>=(img).width()?(img).width()-1:x+7, \
 _n8##x = x+8>=(img).width()?(img).width()-1:x+8, \
 _n9##x = x+9>=(img).width()?(img).width()-1:x+9, \
 _n10##x = x+10>=(img).width()?(img).width()-1:x+10, \
 _n11##x = x+11>=(img).width()?(img).width()-1:x+11, \
 _n12##x = (int)( \
 (I[0] = (T)(img)(_p11##x,_p11##y,z,c)), \
 (I[24] = (T)(img)(_p11##x,_p10##y,z,c)), \
 (I[48] = (T)(img)(_p11##x,_p9##y,z,c)), \
 (I[72] = (T)(img)(_p11##x,_p8##y,z,c)), \
 (I[96] = (T)(img)(_p11##x,_p7##y,z,c)), \
 (I[120] = (T)(img)(_p11##x,_p6##y,z,c)), \
 (I[144] = (T)(img)(_p11##x,_p5##y,z,c)), \
 (I[168] = (T)(img)(_p11##x,_p4##y,z,c)), \
 (I[192] = (T)(img)(_p11##x,_p3##y,z,c)), \
 (I[216] = (T)(img)(_p11##x,_p2##y,z,c)), \
 (I[240] = (T)(img)(_p11##x,_p1##y,z,c)), \
 (I[264] = (T)(img)(_p11##x,y,z,c)), \
 (I[288] = (T)(img)(_p11##x,_n1##y,z,c)), \
 (I[312] = (T)(img)(_p11##x,_n2##y,z,c)), \
 (I[336] = (T)(img)(_p11##x,_n3##y,z,c)), \
 (I[360] = (T)(img)(_p11##x,_n4##y,z,c)), \
 (I[384] = (T)(img)(_p11##x,_n5##y,z,c)), \
 (I[408] = (T)(img)(_p11##x,_n6##y,z,c)), \
 (I[432] = (T)(img)(_p11##x,_n7##y,z,c)), \
 (I[456] = (T)(img)(_p11##x,_n8##y,z,c)), \
 (I[480] = (T)(img)(_p11##x,_n9##y,z,c)), \
 (I[504] = (T)(img)(_p11##x,_n10##y,z,c)), \
 (I[528] = (T)(img)(_p11##x,_n11##y,z,c)), \
 (I[552] = (T)(img)(_p11##x,_n12##y,z,c)), \
 (I[1] = (T)(img)(_p10##x,_p11##y,z,c)), \
 (I[25] = (T)(img)(_p10##x,_p10##y,z,c)), \
 (I[49] = (T)(img)(_p10##x,_p9##y,z,c)), \
 (I[73] = (T)(img)(_p10##x,_p8##y,z,c)), \
 (I[97] = (T)(img)(_p10##x,_p7##y,z,c)), \
 (I[121] = (T)(img)(_p10##x,_p6##y,z,c)), \
 (I[145] = (T)(img)(_p10##x,_p5##y,z,c)), \
 (I[169] = (T)(img)(_p10##x,_p4##y,z,c)), \
 (I[193] = (T)(img)(_p10##x,_p3##y,z,c)), \
 (I[217] = (T)(img)(_p10##x,_p2##y,z,c)), \
 (I[241] = (T)(img)(_p10##x,_p1##y,z,c)), \
 (I[265] = (T)(img)(_p10##x,y,z,c)), \
 (I[289] = (T)(img)(_p10##x,_n1##y,z,c)), \
 (I[313] = (T)(img)(_p10##x,_n2##y,z,c)), \
 (I[337] = (T)(img)(_p10##x,_n3##y,z,c)), \
 (I[361] = (T)(img)(_p10##x,_n4##y,z,c)), \
 (I[385] = (T)(img)(_p10##x,_n5##y,z,c)), \
 (I[409] = (T)(img)(_p10##x,_n6##y,z,c)), \
 (I[433] = (T)(img)(_p10##x,_n7##y,z,c)), \
 (I[457] = (T)(img)(_p10##x,_n8##y,z,c)), \
 (I[481] = (T)(img)(_p10##x,_n9##y,z,c)), \
 (I[505] = (T)(img)(_p10##x,_n10##y,z,c)), \
 (I[529] = (T)(img)(_p10##x,_n11##y,z,c)), \
 (I[553] = (T)(img)(_p10##x,_n12##y,z,c)), \
 (I[2] = (T)(img)(_p9##x,_p11##y,z,c)), \
 (I[26] = (T)(img)(_p9##x,_p10##y,z,c)), \
 (I[50] = (T)(img)(_p9##x,_p9##y,z,c)), \
 (I[74] = (T)(img)(_p9##x,_p8##y,z,c)), \
 (I[98] = (T)(img)(_p9##x,_p7##y,z,c)), \
 (I[122] = (T)(img)(_p9##x,_p6##y,z,c)), \
 (I[146] = (T)(img)(_p9##x,_p5##y,z,c)), \
 (I[170] = (T)(img)(_p9##x,_p4##y,z,c)), \
 (I[194] = (T)(img)(_p9##x,_p3##y,z,c)), \
 (I[218] = (T)(img)(_p9##x,_p2##y,z,c)), \
 (I[242] = (T)(img)(_p9##x,_p1##y,z,c)), \
 (I[266] = (T)(img)(_p9##x,y,z,c)), \
 (I[290] = (T)(img)(_p9##x,_n1##y,z,c)), \
 (I[314] = (T)(img)(_p9##x,_n2##y,z,c)), \
 (I[338] = (T)(img)(_p9##x,_n3##y,z,c)), \
 (I[362] = (T)(img)(_p9##x,_n4##y,z,c)), \
 (I[386] = (T)(img)(_p9##x,_n5##y,z,c)), \
 (I[410] = (T)(img)(_p9##x,_n6##y,z,c)), \
 (I[434] = (T)(img)(_p9##x,_n7##y,z,c)), \
 (I[458] = (T)(img)(_p9##x,_n8##y,z,c)), \
 (I[482] = (T)(img)(_p9##x,_n9##y,z,c)), \
 (I[506] = (T)(img)(_p9##x,_n10##y,z,c)), \
 (I[530] = (T)(img)(_p9##x,_n11##y,z,c)), \
 (I[554] = (T)(img)(_p9##x,_n12##y,z,c)), \
 (I[3] = (T)(img)(_p8##x,_p11##y,z,c)), \
 (I[27] = (T)(img)(_p8##x,_p10##y,z,c)), \
 (I[51] = (T)(img)(_p8##x,_p9##y,z,c)), \
 (I[75] = (T)(img)(_p8##x,_p8##y,z,c)), \
 (I[99] = (T)(img)(_p8##x,_p7##y,z,c)), \
 (I[123] = (T)(img)(_p8##x,_p6##y,z,c)), \
 (I[147] = (T)(img)(_p8##x,_p5##y,z,c)), \
 (I[171] = (T)(img)(_p8##x,_p4##y,z,c)), \
 (I[195] = (T)(img)(_p8##x,_p3##y,z,c)), \
 (I[219] = (T)(img)(_p8##x,_p2##y,z,c)), \
 (I[243] = (T)(img)(_p8##x,_p1##y,z,c)), \
 (I[267] = (T)(img)(_p8##x,y,z,c)), \
 (I[291] = (T)(img)(_p8##x,_n1##y,z,c)), \
 (I[315] = (T)(img)(_p8##x,_n2##y,z,c)), \
 (I[339] = (T)(img)(_p8##x,_n3##y,z,c)), \
 (I[363] = (T)(img)(_p8##x,_n4##y,z,c)), \
 (I[387] = (T)(img)(_p8##x,_n5##y,z,c)), \
 (I[411] = (T)(img)(_p8##x,_n6##y,z,c)), \
 (I[435] = (T)(img)(_p8##x,_n7##y,z,c)), \
 (I[459] = (T)(img)(_p8##x,_n8##y,z,c)), \
 (I[483] = (T)(img)(_p8##x,_n9##y,z,c)), \
 (I[507] = (T)(img)(_p8##x,_n10##y,z,c)), \
 (I[531] = (T)(img)(_p8##x,_n11##y,z,c)), \
 (I[555] = (T)(img)(_p8##x,_n12##y,z,c)), \
 (I[4] = (T)(img)(_p7##x,_p11##y,z,c)), \
 (I[28] = (T)(img)(_p7##x,_p10##y,z,c)), \
 (I[52] = (T)(img)(_p7##x,_p9##y,z,c)), \
 (I[76] = (T)(img)(_p7##x,_p8##y,z,c)), \
 (I[100] = (T)(img)(_p7##x,_p7##y,z,c)), \
 (I[124] = (T)(img)(_p7##x,_p6##y,z,c)), \
 (I[148] = (T)(img)(_p7##x,_p5##y,z,c)), \
 (I[172] = (T)(img)(_p7##x,_p4##y,z,c)), \
 (I[196] = (T)(img)(_p7##x,_p3##y,z,c)), \
 (I[220] = (T)(img)(_p7##x,_p2##y,z,c)), \
 (I[244] = (T)(img)(_p7##x,_p1##y,z,c)), \
 (I[268] = (T)(img)(_p7##x,y,z,c)), \
 (I[292] = (T)(img)(_p7##x,_n1##y,z,c)), \
 (I[316] = (T)(img)(_p7##x,_n2##y,z,c)), \
 (I[340] = (T)(img)(_p7##x,_n3##y,z,c)), \
 (I[364] = (T)(img)(_p7##x,_n4##y,z,c)), \
 (I[388] = (T)(img)(_p7##x,_n5##y,z,c)), \
 (I[412] = (T)(img)(_p7##x,_n6##y,z,c)), \
 (I[436] = (T)(img)(_p7##x,_n7##y,z,c)), \
 (I[460] = (T)(img)(_p7##x,_n8##y,z,c)), \
 (I[484] = (T)(img)(_p7##x,_n9##y,z,c)), \
 (I[508] = (T)(img)(_p7##x,_n10##y,z,c)), \
 (I[532] = (T)(img)(_p7##x,_n11##y,z,c)), \
 (I[556] = (T)(img)(_p7##x,_n12##y,z,c)), \
 (I[5] = (T)(img)(_p6##x,_p11##y,z,c)), \
 (I[29] = (T)(img)(_p6##x,_p10##y,z,c)), \
 (I[53] = (T)(img)(_p6##x,_p9##y,z,c)), \
 (I[77] = (T)(img)(_p6##x,_p8##y,z,c)), \
 (I[101] = (T)(img)(_p6##x,_p7##y,z,c)), \
 (I[125] = (T)(img)(_p6##x,_p6##y,z,c)), \
 (I[149] = (T)(img)(_p6##x,_p5##y,z,c)), \
 (I[173] = (T)(img)(_p6##x,_p4##y,z,c)), \
 (I[197] = (T)(img)(_p6##x,_p3##y,z,c)), \
 (I[221] = (T)(img)(_p6##x,_p2##y,z,c)), \
 (I[245] = (T)(img)(_p6##x,_p1##y,z,c)), \
 (I[269] = (T)(img)(_p6##x,y,z,c)), \
 (I[293] = (T)(img)(_p6##x,_n1##y,z,c)), \
 (I[317] = (T)(img)(_p6##x,_n2##y,z,c)), \
 (I[341] = (T)(img)(_p6##x,_n3##y,z,c)), \
 (I[365] = (T)(img)(_p6##x,_n4##y,z,c)), \
 (I[389] = (T)(img)(_p6##x,_n5##y,z,c)), \
 (I[413] = (T)(img)(_p6##x,_n6##y,z,c)), \
 (I[437] = (T)(img)(_p6##x,_n7##y,z,c)), \
 (I[461] = (T)(img)(_p6##x,_n8##y,z,c)), \
 (I[485] = (T)(img)(_p6##x,_n9##y,z,c)), \
 (I[509] = (T)(img)(_p6##x,_n10##y,z,c)), \
 (I[533] = (T)(img)(_p6##x,_n11##y,z,c)), \
 (I[557] = (T)(img)(_p6##x,_n12##y,z,c)), \
 (I[6] = (T)(img)(_p5##x,_p11##y,z,c)), \
 (I[30] = (T)(img)(_p5##x,_p10##y,z,c)), \
 (I[54] = (T)(img)(_p5##x,_p9##y,z,c)), \
 (I[78] = (T)(img)(_p5##x,_p8##y,z,c)), \
 (I[102] = (T)(img)(_p5##x,_p7##y,z,c)), \
 (I[126] = (T)(img)(_p5##x,_p6##y,z,c)), \
 (I[150] = (T)(img)(_p5##x,_p5##y,z,c)), \
 (I[174] = (T)(img)(_p5##x,_p4##y,z,c)), \
 (I[198] = (T)(img)(_p5##x,_p3##y,z,c)), \
 (I[222] = (T)(img)(_p5##x,_p2##y,z,c)), \
 (I[246] = (T)(img)(_p5##x,_p1##y,z,c)), \
 (I[270] = (T)(img)(_p5##x,y,z,c)), \
 (I[294] = (T)(img)(_p5##x,_n1##y,z,c)), \
 (I[318] = (T)(img)(_p5##x,_n2##y,z,c)), \
 (I[342] = (T)(img)(_p5##x,_n3##y,z,c)), \
 (I[366] = (T)(img)(_p5##x,_n4##y,z,c)), \
 (I[390] = (T)(img)(_p5##x,_n5##y,z,c)), \
 (I[414] = (T)(img)(_p5##x,_n6##y,z,c)), \
 (I[438] = (T)(img)(_p5##x,_n7##y,z,c)), \
 (I[462] = (T)(img)(_p5##x,_n8##y,z,c)), \
 (I[486] = (T)(img)(_p5##x,_n9##y,z,c)), \
 (I[510] = (T)(img)(_p5##x,_n10##y,z,c)), \
 (I[534] = (T)(img)(_p5##x,_n11##y,z,c)), \
 (I[558] = (T)(img)(_p5##x,_n12##y,z,c)), \
 (I[7] = (T)(img)(_p4##x,_p11##y,z,c)), \
 (I[31] = (T)(img)(_p4##x,_p10##y,z,c)), \
 (I[55] = (T)(img)(_p4##x,_p9##y,z,c)), \
 (I[79] = (T)(img)(_p4##x,_p8##y,z,c)), \
 (I[103] = (T)(img)(_p4##x,_p7##y,z,c)), \
 (I[127] = (T)(img)(_p4##x,_p6##y,z,c)), \
 (I[151] = (T)(img)(_p4##x,_p5##y,z,c)), \
 (I[175] = (T)(img)(_p4##x,_p4##y,z,c)), \
 (I[199] = (T)(img)(_p4##x,_p3##y,z,c)), \
 (I[223] = (T)(img)(_p4##x,_p2##y,z,c)), \
 (I[247] = (T)(img)(_p4##x,_p1##y,z,c)), \
 (I[271] = (T)(img)(_p4##x,y,z,c)), \
 (I[295] = (T)(img)(_p4##x,_n1##y,z,c)), \
 (I[319] = (T)(img)(_p4##x,_n2##y,z,c)), \
 (I[343] = (T)(img)(_p4##x,_n3##y,z,c)), \
 (I[367] = (T)(img)(_p4##x,_n4##y,z,c)), \
 (I[391] = (T)(img)(_p4##x,_n5##y,z,c)), \
 (I[415] = (T)(img)(_p4##x,_n6##y,z,c)), \
 (I[439] = (T)(img)(_p4##x,_n7##y,z,c)), \
 (I[463] = (T)(img)(_p4##x,_n8##y,z,c)), \
 (I[487] = (T)(img)(_p4##x,_n9##y,z,c)), \
 (I[511] = (T)(img)(_p4##x,_n10##y,z,c)), \
 (I[535] = (T)(img)(_p4##x,_n11##y,z,c)), \
 (I[559] = (T)(img)(_p4##x,_n12##y,z,c)), \
 (I[8] = (T)(img)(_p3##x,_p11##y,z,c)), \
 (I[32] = (T)(img)(_p3##x,_p10##y,z,c)), \
 (I[56] = (T)(img)(_p3##x,_p9##y,z,c)), \
 (I[80] = (T)(img)(_p3##x,_p8##y,z,c)), \
 (I[104] = (T)(img)(_p3##x,_p7##y,z,c)), \
 (I[128] = (T)(img)(_p3##x,_p6##y,z,c)), \
 (I[152] = (T)(img)(_p3##x,_p5##y,z,c)), \
 (I[176] = (T)(img)(_p3##x,_p4##y,z,c)), \
 (I[200] = (T)(img)(_p3##x,_p3##y,z,c)), \
 (I[224] = (T)(img)(_p3##x,_p2##y,z,c)), \
 (I[248] = (T)(img)(_p3##x,_p1##y,z,c)), \
 (I[272] = (T)(img)(_p3##x,y,z,c)), \
 (I[296] = (T)(img)(_p3##x,_n1##y,z,c)), \
 (I[320] = (T)(img)(_p3##x,_n2##y,z,c)), \
 (I[344] = (T)(img)(_p3##x,_n3##y,z,c)), \
 (I[368] = (T)(img)(_p3##x,_n4##y,z,c)), \
 (I[392] = (T)(img)(_p3##x,_n5##y,z,c)), \
 (I[416] = (T)(img)(_p3##x,_n6##y,z,c)), \
 (I[440] = (T)(img)(_p3##x,_n7##y,z,c)), \
 (I[464] = (T)(img)(_p3##x,_n8##y,z,c)), \
 (I[488] = (T)(img)(_p3##x,_n9##y,z,c)), \
 (I[512] = (T)(img)(_p3##x,_n10##y,z,c)), \
 (I[536] = (T)(img)(_p3##x,_n11##y,z,c)), \
 (I[560] = (T)(img)(_p3##x,_n12##y,z,c)), \
 (I[9] = (T)(img)(_p2##x,_p11##y,z,c)), \
 (I[33] = (T)(img)(_p2##x,_p10##y,z,c)), \
 (I[57] = (T)(img)(_p2##x,_p9##y,z,c)), \
 (I[81] = (T)(img)(_p2##x,_p8##y,z,c)), \
 (I[105] = (T)(img)(_p2##x,_p7##y,z,c)), \
 (I[129] = (T)(img)(_p2##x,_p6##y,z,c)), \
 (I[153] = (T)(img)(_p2##x,_p5##y,z,c)), \
 (I[177] = (T)(img)(_p2##x,_p4##y,z,c)), \
 (I[201] = (T)(img)(_p2##x,_p3##y,z,c)), \
 (I[225] = (T)(img)(_p2##x,_p2##y,z,c)), \
 (I[249] = (T)(img)(_p2##x,_p1##y,z,c)), \
 (I[273] = (T)(img)(_p2##x,y,z,c)), \
 (I[297] = (T)(img)(_p2##x,_n1##y,z,c)), \
 (I[321] = (T)(img)(_p2##x,_n2##y,z,c)), \
 (I[345] = (T)(img)(_p2##x,_n3##y,z,c)), \
 (I[369] = (T)(img)(_p2##x,_n4##y,z,c)), \
 (I[393] = (T)(img)(_p2##x,_n5##y,z,c)), \
 (I[417] = (T)(img)(_p2##x,_n6##y,z,c)), \
 (I[441] = (T)(img)(_p2##x,_n7##y,z,c)), \
 (I[465] = (T)(img)(_p2##x,_n8##y,z,c)), \
 (I[489] = (T)(img)(_p2##x,_n9##y,z,c)), \
 (I[513] = (T)(img)(_p2##x,_n10##y,z,c)), \
 (I[537] = (T)(img)(_p2##x,_n11##y,z,c)), \
 (I[561] = (T)(img)(_p2##x,_n12##y,z,c)), \
 (I[10] = (T)(img)(_p1##x,_p11##y,z,c)), \
 (I[34] = (T)(img)(_p1##x,_p10##y,z,c)), \
 (I[58] = (T)(img)(_p1##x,_p9##y,z,c)), \
 (I[82] = (T)(img)(_p1##x,_p8##y,z,c)), \
 (I[106] = (T)(img)(_p1##x,_p7##y,z,c)), \
 (I[130] = (T)(img)(_p1##x,_p6##y,z,c)), \
 (I[154] = (T)(img)(_p1##x,_p5##y,z,c)), \
 (I[178] = (T)(img)(_p1##x,_p4##y,z,c)), \
 (I[202] = (T)(img)(_p1##x,_p3##y,z,c)), \
 (I[226] = (T)(img)(_p1##x,_p2##y,z,c)), \
 (I[250] = (T)(img)(_p1##x,_p1##y,z,c)), \
 (I[274] = (T)(img)(_p1##x,y,z,c)), \
 (I[298] = (T)(img)(_p1##x,_n1##y,z,c)), \
 (I[322] = (T)(img)(_p1##x,_n2##y,z,c)), \
 (I[346] = (T)(img)(_p1##x,_n3##y,z,c)), \
 (I[370] = (T)(img)(_p1##x,_n4##y,z,c)), \
 (I[394] = (T)(img)(_p1##x,_n5##y,z,c)), \
 (I[418] = (T)(img)(_p1##x,_n6##y,z,c)), \
 (I[442] = (T)(img)(_p1##x,_n7##y,z,c)), \
 (I[466] = (T)(img)(_p1##x,_n8##y,z,c)), \
 (I[490] = (T)(img)(_p1##x,_n9##y,z,c)), \
 (I[514] = (T)(img)(_p1##x,_n10##y,z,c)), \
 (I[538] = (T)(img)(_p1##x,_n11##y,z,c)), \
 (I[562] = (T)(img)(_p1##x,_n12##y,z,c)), \
 (I[11] = (T)(img)(x,_p11##y,z,c)), \
 (I[35] = (T)(img)(x,_p10##y,z,c)), \
 (I[59] = (T)(img)(x,_p9##y,z,c)), \
 (I[83] = (T)(img)(x,_p8##y,z,c)), \
 (I[107] = (T)(img)(x,_p7##y,z,c)), \
 (I[131] = (T)(img)(x,_p6##y,z,c)), \
 (I[155] = (T)(img)(x,_p5##y,z,c)), \
 (I[179] = (T)(img)(x,_p4##y,z,c)), \
 (I[203] = (T)(img)(x,_p3##y,z,c)), \
 (I[227] = (T)(img)(x,_p2##y,z,c)), \
 (I[251] = (T)(img)(x,_p1##y,z,c)), \
 (I[275] = (T)(img)(x,y,z,c)), \
 (I[299] = (T)(img)(x,_n1##y,z,c)), \
 (I[323] = (T)(img)(x,_n2##y,z,c)), \
 (I[347] = (T)(img)(x,_n3##y,z,c)), \
 (I[371] = (T)(img)(x,_n4##y,z,c)), \
 (I[395] = (T)(img)(x,_n5##y,z,c)), \
 (I[419] = (T)(img)(x,_n6##y,z,c)), \
 (I[443] = (T)(img)(x,_n7##y,z,c)), \
 (I[467] = (T)(img)(x,_n8##y,z,c)), \
 (I[491] = (T)(img)(x,_n9##y,z,c)), \
 (I[515] = (T)(img)(x,_n10##y,z,c)), \
 (I[539] = (T)(img)(x,_n11##y,z,c)), \
 (I[563] = (T)(img)(x,_n12##y,z,c)), \
 (I[12] = (T)(img)(_n1##x,_p11##y,z,c)), \
 (I[36] = (T)(img)(_n1##x,_p10##y,z,c)), \
 (I[60] = (T)(img)(_n1##x,_p9##y,z,c)), \
 (I[84] = (T)(img)(_n1##x,_p8##y,z,c)), \
 (I[108] = (T)(img)(_n1##x,_p7##y,z,c)), \
 (I[132] = (T)(img)(_n1##x,_p6##y,z,c)), \
 (I[156] = (T)(img)(_n1##x,_p5##y,z,c)), \
 (I[180] = (T)(img)(_n1##x,_p4##y,z,c)), \
 (I[204] = (T)(img)(_n1##x,_p3##y,z,c)), \
 (I[228] = (T)(img)(_n1##x,_p2##y,z,c)), \
 (I[252] = (T)(img)(_n1##x,_p1##y,z,c)), \
 (I[276] = (T)(img)(_n1##x,y,z,c)), \
 (I[300] = (T)(img)(_n1##x,_n1##y,z,c)), \
 (I[324] = (T)(img)(_n1##x,_n2##y,z,c)), \
 (I[348] = (T)(img)(_n1##x,_n3##y,z,c)), \
 (I[372] = (T)(img)(_n1##x,_n4##y,z,c)), \
 (I[396] = (T)(img)(_n1##x,_n5##y,z,c)), \
 (I[420] = (T)(img)(_n1##x,_n6##y,z,c)), \
 (I[444] = (T)(img)(_n1##x,_n7##y,z,c)), \
 (I[468] = (T)(img)(_n1##x,_n8##y,z,c)), \
 (I[492] = (T)(img)(_n1##x,_n9##y,z,c)), \
 (I[516] = (T)(img)(_n1##x,_n10##y,z,c)), \
 (I[540] = (T)(img)(_n1##x,_n11##y,z,c)), \
 (I[564] = (T)(img)(_n1##x,_n12##y,z,c)), \
 (I[13] = (T)(img)(_n2##x,_p11##y,z,c)), \
 (I[37] = (T)(img)(_n2##x,_p10##y,z,c)), \
 (I[61] = (T)(img)(_n2##x,_p9##y,z,c)), \
 (I[85] = (T)(img)(_n2##x,_p8##y,z,c)), \
 (I[109] = (T)(img)(_n2##x,_p7##y,z,c)), \
 (I[133] = (T)(img)(_n2##x,_p6##y,z,c)), \
 (I[157] = (T)(img)(_n2##x,_p5##y,z,c)), \
 (I[181] = (T)(img)(_n2##x,_p4##y,z,c)), \
 (I[205] = (T)(img)(_n2##x,_p3##y,z,c)), \
 (I[229] = (T)(img)(_n2##x,_p2##y,z,c)), \
 (I[253] = (T)(img)(_n2##x,_p1##y,z,c)), \
 (I[277] = (T)(img)(_n2##x,y,z,c)), \
 (I[301] = (T)(img)(_n2##x,_n1##y,z,c)), \
 (I[325] = (T)(img)(_n2##x,_n2##y,z,c)), \
 (I[349] = (T)(img)(_n2##x,_n3##y,z,c)), \
 (I[373] = (T)(img)(_n2##x,_n4##y,z,c)), \
 (I[397] = (T)(img)(_n2##x,_n5##y,z,c)), \
 (I[421] = (T)(img)(_n2##x,_n6##y,z,c)), \
 (I[445] = (T)(img)(_n2##x,_n7##y,z,c)), \
 (I[469] = (T)(img)(_n2##x,_n8##y,z,c)), \
 (I[493] = (T)(img)(_n2##x,_n9##y,z,c)), \
 (I[517] = (T)(img)(_n2##x,_n10##y,z,c)), \
 (I[541] = (T)(img)(_n2##x,_n11##y,z,c)), \
 (I[565] = (T)(img)(_n2##x,_n12##y,z,c)), \
 (I[14] = (T)(img)(_n3##x,_p11##y,z,c)), \
 (I[38] = (T)(img)(_n3##x,_p10##y,z,c)), \
 (I[62] = (T)(img)(_n3##x,_p9##y,z,c)), \
 (I[86] = (T)(img)(_n3##x,_p8##y,z,c)), \
 (I[110] = (T)(img)(_n3##x,_p7##y,z,c)), \
 (I[134] = (T)(img)(_n3##x,_p6##y,z,c)), \
 (I[158] = (T)(img)(_n3##x,_p5##y,z,c)), \
 (I[182] = (T)(img)(_n3##x,_p4##y,z,c)), \
 (I[206] = (T)(img)(_n3##x,_p3##y,z,c)), \
 (I[230] = (T)(img)(_n3##x,_p2##y,z,c)), \
 (I[254] = (T)(img)(_n3##x,_p1##y,z,c)), \
 (I[278] = (T)(img)(_n3##x,y,z,c)), \
 (I[302] = (T)(img)(_n3##x,_n1##y,z,c)), \
 (I[326] = (T)(img)(_n3##x,_n2##y,z,c)), \
 (I[350] = (T)(img)(_n3##x,_n3##y,z,c)), \
 (I[374] = (T)(img)(_n3##x,_n4##y,z,c)), \
 (I[398] = (T)(img)(_n3##x,_n5##y,z,c)), \
 (I[422] = (T)(img)(_n3##x,_n6##y,z,c)), \
 (I[446] = (T)(img)(_n3##x,_n7##y,z,c)), \
 (I[470] = (T)(img)(_n3##x,_n8##y,z,c)), \
 (I[494] = (T)(img)(_n3##x,_n9##y,z,c)), \
 (I[518] = (T)(img)(_n3##x,_n10##y,z,c)), \
 (I[542] = (T)(img)(_n3##x,_n11##y,z,c)), \
 (I[566] = (T)(img)(_n3##x,_n12##y,z,c)), \
 (I[15] = (T)(img)(_n4##x,_p11##y,z,c)), \
 (I[39] = (T)(img)(_n4##x,_p10##y,z,c)), \
 (I[63] = (T)(img)(_n4##x,_p9##y,z,c)), \
 (I[87] = (T)(img)(_n4##x,_p8##y,z,c)), \
 (I[111] = (T)(img)(_n4##x,_p7##y,z,c)), \
 (I[135] = (T)(img)(_n4##x,_p6##y,z,c)), \
 (I[159] = (T)(img)(_n4##x,_p5##y,z,c)), \
 (I[183] = (T)(img)(_n4##x,_p4##y,z,c)), \
 (I[207] = (T)(img)(_n4##x,_p3##y,z,c)), \
 (I[231] = (T)(img)(_n4##x,_p2##y,z,c)), \
 (I[255] = (T)(img)(_n4##x,_p1##y,z,c)), \
 (I[279] = (T)(img)(_n4##x,y,z,c)), \
 (I[303] = (T)(img)(_n4##x,_n1##y,z,c)), \
 (I[327] = (T)(img)(_n4##x,_n2##y,z,c)), \
 (I[351] = (T)(img)(_n4##x,_n3##y,z,c)), \
 (I[375] = (T)(img)(_n4##x,_n4##y,z,c)), \
 (I[399] = (T)(img)(_n4##x,_n5##y,z,c)), \
 (I[423] = (T)(img)(_n4##x,_n6##y,z,c)), \
 (I[447] = (T)(img)(_n4##x,_n7##y,z,c)), \
 (I[471] = (T)(img)(_n4##x,_n8##y,z,c)), \
 (I[495] = (T)(img)(_n4##x,_n9##y,z,c)), \
 (I[519] = (T)(img)(_n4##x,_n10##y,z,c)), \
 (I[543] = (T)(img)(_n4##x,_n11##y,z,c)), \
 (I[567] = (T)(img)(_n4##x,_n12##y,z,c)), \
 (I[16] = (T)(img)(_n5##x,_p11##y,z,c)), \
 (I[40] = (T)(img)(_n5##x,_p10##y,z,c)), \
 (I[64] = (T)(img)(_n5##x,_p9##y,z,c)), \
 (I[88] = (T)(img)(_n5##x,_p8##y,z,c)), \
 (I[112] = (T)(img)(_n5##x,_p7##y,z,c)), \
 (I[136] = (T)(img)(_n5##x,_p6##y,z,c)), \
 (I[160] = (T)(img)(_n5##x,_p5##y,z,c)), \
 (I[184] = (T)(img)(_n5##x,_p4##y,z,c)), \
 (I[208] = (T)(img)(_n5##x,_p3##y,z,c)), \
 (I[232] = (T)(img)(_n5##x,_p2##y,z,c)), \
 (I[256] = (T)(img)(_n5##x,_p1##y,z,c)), \
 (I[280] = (T)(img)(_n5##x,y,z,c)), \
 (I[304] = (T)(img)(_n5##x,_n1##y,z,c)), \
 (I[328] = (T)(img)(_n5##x,_n2##y,z,c)), \
 (I[352] = (T)(img)(_n5##x,_n3##y,z,c)), \
 (I[376] = (T)(img)(_n5##x,_n4##y,z,c)), \
 (I[400] = (T)(img)(_n5##x,_n5##y,z,c)), \
 (I[424] = (T)(img)(_n5##x,_n6##y,z,c)), \
 (I[448] = (T)(img)(_n5##x,_n7##y,z,c)), \
 (I[472] = (T)(img)(_n5##x,_n8##y,z,c)), \
 (I[496] = (T)(img)(_n5##x,_n9##y,z,c)), \
 (I[520] = (T)(img)(_n5##x,_n10##y,z,c)), \
 (I[544] = (T)(img)(_n5##x,_n11##y,z,c)), \
 (I[568] = (T)(img)(_n5##x,_n12##y,z,c)), \
 (I[17] = (T)(img)(_n6##x,_p11##y,z,c)), \
 (I[41] = (T)(img)(_n6##x,_p10##y,z,c)), \
 (I[65] = (T)(img)(_n6##x,_p9##y,z,c)), \
 (I[89] = (T)(img)(_n6##x,_p8##y,z,c)), \
 (I[113] = (T)(img)(_n6##x,_p7##y,z,c)), \
 (I[137] = (T)(img)(_n6##x,_p6##y,z,c)), \
 (I[161] = (T)(img)(_n6##x,_p5##y,z,c)), \
 (I[185] = (T)(img)(_n6##x,_p4##y,z,c)), \
 (I[209] = (T)(img)(_n6##x,_p3##y,z,c)), \
 (I[233] = (T)(img)(_n6##x,_p2##y,z,c)), \
 (I[257] = (T)(img)(_n6##x,_p1##y,z,c)), \
 (I[281] = (T)(img)(_n6##x,y,z,c)), \
 (I[305] = (T)(img)(_n6##x,_n1##y,z,c)), \
 (I[329] = (T)(img)(_n6##x,_n2##y,z,c)), \
 (I[353] = (T)(img)(_n6##x,_n3##y,z,c)), \
 (I[377] = (T)(img)(_n6##x,_n4##y,z,c)), \
 (I[401] = (T)(img)(_n6##x,_n5##y,z,c)), \
 (I[425] = (T)(img)(_n6##x,_n6##y,z,c)), \
 (I[449] = (T)(img)(_n6##x,_n7##y,z,c)), \
 (I[473] = (T)(img)(_n6##x,_n8##y,z,c)), \
 (I[497] = (T)(img)(_n6##x,_n9##y,z,c)), \
 (I[521] = (T)(img)(_n6##x,_n10##y,z,c)), \
 (I[545] = (T)(img)(_n6##x,_n11##y,z,c)), \
 (I[569] = (T)(img)(_n6##x,_n12##y,z,c)), \
 (I[18] = (T)(img)(_n7##x,_p11##y,z,c)), \
 (I[42] = (T)(img)(_n7##x,_p10##y,z,c)), \
 (I[66] = (T)(img)(_n7##x,_p9##y,z,c)), \
 (I[90] = (T)(img)(_n7##x,_p8##y,z,c)), \
 (I[114] = (T)(img)(_n7##x,_p7##y,z,c)), \
 (I[138] = (T)(img)(_n7##x,_p6##y,z,c)), \
 (I[162] = (T)(img)(_n7##x,_p5##y,z,c)), \
 (I[186] = (T)(img)(_n7##x,_p4##y,z,c)), \
 (I[210] = (T)(img)(_n7##x,_p3##y,z,c)), \
 (I[234] = (T)(img)(_n7##x,_p2##y,z,c)), \
 (I[258] = (T)(img)(_n7##x,_p1##y,z,c)), \
 (I[282] = (T)(img)(_n7##x,y,z,c)), \
 (I[306] = (T)(img)(_n7##x,_n1##y,z,c)), \
 (I[330] = (T)(img)(_n7##x,_n2##y,z,c)), \
 (I[354] = (T)(img)(_n7##x,_n3##y,z,c)), \
 (I[378] = (T)(img)(_n7##x,_n4##y,z,c)), \
 (I[402] = (T)(img)(_n7##x,_n5##y,z,c)), \
 (I[426] = (T)(img)(_n7##x,_n6##y,z,c)), \
 (I[450] = (T)(img)(_n7##x,_n7##y,z,c)), \
 (I[474] = (T)(img)(_n7##x,_n8##y,z,c)), \
 (I[498] = (T)(img)(_n7##x,_n9##y,z,c)), \
 (I[522] = (T)(img)(_n7##x,_n10##y,z,c)), \
 (I[546] = (T)(img)(_n7##x,_n11##y,z,c)), \
 (I[570] = (T)(img)(_n7##x,_n12##y,z,c)), \
 (I[19] = (T)(img)(_n8##x,_p11##y,z,c)), \
 (I[43] = (T)(img)(_n8##x,_p10##y,z,c)), \
 (I[67] = (T)(img)(_n8##x,_p9##y,z,c)), \
 (I[91] = (T)(img)(_n8##x,_p8##y,z,c)), \
 (I[115] = (T)(img)(_n8##x,_p7##y,z,c)), \
 (I[139] = (T)(img)(_n8##x,_p6##y,z,c)), \
 (I[163] = (T)(img)(_n8##x,_p5##y,z,c)), \
 (I[187] = (T)(img)(_n8##x,_p4##y,z,c)), \
 (I[211] = (T)(img)(_n8##x,_p3##y,z,c)), \
 (I[235] = (T)(img)(_n8##x,_p2##y,z,c)), \
 (I[259] = (T)(img)(_n8##x,_p1##y,z,c)), \
 (I[283] = (T)(img)(_n8##x,y,z,c)), \
 (I[307] = (T)(img)(_n8##x,_n1##y,z,c)), \
 (I[331] = (T)(img)(_n8##x,_n2##y,z,c)), \
 (I[355] = (T)(img)(_n8##x,_n3##y,z,c)), \
 (I[379] = (T)(img)(_n8##x,_n4##y,z,c)), \
 (I[403] = (T)(img)(_n8##x,_n5##y,z,c)), \
 (I[427] = (T)(img)(_n8##x,_n6##y,z,c)), \
 (I[451] = (T)(img)(_n8##x,_n7##y,z,c)), \
 (I[475] = (T)(img)(_n8##x,_n8##y,z,c)), \
 (I[499] = (T)(img)(_n8##x,_n9##y,z,c)), \
 (I[523] = (T)(img)(_n8##x,_n10##y,z,c)), \
 (I[547] = (T)(img)(_n8##x,_n11##y,z,c)), \
 (I[571] = (T)(img)(_n8##x,_n12##y,z,c)), \
 (I[20] = (T)(img)(_n9##x,_p11##y,z,c)), \
 (I[44] = (T)(img)(_n9##x,_p10##y,z,c)), \
 (I[68] = (T)(img)(_n9##x,_p9##y,z,c)), \
 (I[92] = (T)(img)(_n9##x,_p8##y,z,c)), \
 (I[116] = (T)(img)(_n9##x,_p7##y,z,c)), \
 (I[140] = (T)(img)(_n9##x,_p6##y,z,c)), \
 (I[164] = (T)(img)(_n9##x,_p5##y,z,c)), \
 (I[188] = (T)(img)(_n9##x,_p4##y,z,c)), \
 (I[212] = (T)(img)(_n9##x,_p3##y,z,c)), \
 (I[236] = (T)(img)(_n9##x,_p2##y,z,c)), \
 (I[260] = (T)(img)(_n9##x,_p1##y,z,c)), \
 (I[284] = (T)(img)(_n9##x,y,z,c)), \
 (I[308] = (T)(img)(_n9##x,_n1##y,z,c)), \
 (I[332] = (T)(img)(_n9##x,_n2##y,z,c)), \
 (I[356] = (T)(img)(_n9##x,_n3##y,z,c)), \
 (I[380] = (T)(img)(_n9##x,_n4##y,z,c)), \
 (I[404] = (T)(img)(_n9##x,_n5##y,z,c)), \
 (I[428] = (T)(img)(_n9##x,_n6##y,z,c)), \
 (I[452] = (T)(img)(_n9##x,_n7##y,z,c)), \
 (I[476] = (T)(img)(_n9##x,_n8##y,z,c)), \
 (I[500] = (T)(img)(_n9##x,_n9##y,z,c)), \
 (I[524] = (T)(img)(_n9##x,_n10##y,z,c)), \
 (I[548] = (T)(img)(_n9##x,_n11##y,z,c)), \
 (I[572] = (T)(img)(_n9##x,_n12##y,z,c)), \
 (I[21] = (T)(img)(_n10##x,_p11##y,z,c)), \
 (I[45] = (T)(img)(_n10##x,_p10##y,z,c)), \
 (I[69] = (T)(img)(_n10##x,_p9##y,z,c)), \
 (I[93] = (T)(img)(_n10##x,_p8##y,z,c)), \
 (I[117] = (T)(img)(_n10##x,_p7##y,z,c)), \
 (I[141] = (T)(img)(_n10##x,_p6##y,z,c)), \
 (I[165] = (T)(img)(_n10##x,_p5##y,z,c)), \
 (I[189] = (T)(img)(_n10##x,_p4##y,z,c)), \
 (I[213] = (T)(img)(_n10##x,_p3##y,z,c)), \
 (I[237] = (T)(img)(_n10##x,_p2##y,z,c)), \
 (I[261] = (T)(img)(_n10##x,_p1##y,z,c)), \
 (I[285] = (T)(img)(_n10##x,y,z,c)), \
 (I[309] = (T)(img)(_n10##x,_n1##y,z,c)), \
 (I[333] = (T)(img)(_n10##x,_n2##y,z,c)), \
 (I[357] = (T)(img)(_n10##x,_n3##y,z,c)), \
 (I[381] = (T)(img)(_n10##x,_n4##y,z,c)), \
 (I[405] = (T)(img)(_n10##x,_n5##y,z,c)), \
 (I[429] = (T)(img)(_n10##x,_n6##y,z,c)), \
 (I[453] = (T)(img)(_n10##x,_n7##y,z,c)), \
 (I[477] = (T)(img)(_n10##x,_n8##y,z,c)), \
 (I[501] = (T)(img)(_n10##x,_n9##y,z,c)), \
 (I[525] = (T)(img)(_n10##x,_n10##y,z,c)), \
 (I[549] = (T)(img)(_n10##x,_n11##y,z,c)), \
 (I[573] = (T)(img)(_n10##x,_n12##y,z,c)), \
 (I[22] = (T)(img)(_n11##x,_p11##y,z,c)), \
 (I[46] = (T)(img)(_n11##x,_p10##y,z,c)), \
 (I[70] = (T)(img)(_n11##x,_p9##y,z,c)), \
 (I[94] = (T)(img)(_n11##x,_p8##y,z,c)), \
 (I[118] = (T)(img)(_n11##x,_p7##y,z,c)), \
 (I[142] = (T)(img)(_n11##x,_p6##y,z,c)), \
 (I[166] = (T)(img)(_n11##x,_p5##y,z,c)), \
 (I[190] = (T)(img)(_n11##x,_p4##y,z,c)), \
 (I[214] = (T)(img)(_n11##x,_p3##y,z,c)), \
 (I[238] = (T)(img)(_n11##x,_p2##y,z,c)), \
 (I[262] = (T)(img)(_n11##x,_p1##y,z,c)), \
 (I[286] = (T)(img)(_n11##x,y,z,c)), \
 (I[310] = (T)(img)(_n11##x,_n1##y,z,c)), \
 (I[334] = (T)(img)(_n11##x,_n2##y,z,c)), \
 (I[358] = (T)(img)(_n11##x,_n3##y,z,c)), \
 (I[382] = (T)(img)(_n11##x,_n4##y,z,c)), \
 (I[406] = (T)(img)(_n11##x,_n5##y,z,c)), \
 (I[430] = (T)(img)(_n11##x,_n6##y,z,c)), \
 (I[454] = (T)(img)(_n11##x,_n7##y,z,c)), \
 (I[478] = (T)(img)(_n11##x,_n8##y,z,c)), \
 (I[502] = (T)(img)(_n11##x,_n9##y,z,c)), \
 (I[526] = (T)(img)(_n11##x,_n10##y,z,c)), \
 (I[550] = (T)(img)(_n11##x,_n11##y,z,c)), \
 (I[574] = (T)(img)(_n11##x,_n12##y,z,c)), \
 x+12>=(img).width()?(img).width()-1:x+12); \
 x<=(int)(x1) && ((_n12##x<(img).width() && ( \
 (I[23] = (T)(img)(_n12##x,_p11##y,z,c)), \
 (I[47] = (T)(img)(_n12##x,_p10##y,z,c)), \
 (I[71] = (T)(img)(_n12##x,_p9##y,z,c)), \
 (I[95] = (T)(img)(_n12##x,_p8##y,z,c)), \
 (I[119] = (T)(img)(_n12##x,_p7##y,z,c)), \
 (I[143] = (T)(img)(_n12##x,_p6##y,z,c)), \
 (I[167] = (T)(img)(_n12##x,_p5##y,z,c)), \
 (I[191] = (T)(img)(_n12##x,_p4##y,z,c)), \
 (I[215] = (T)(img)(_n12##x,_p3##y,z,c)), \
 (I[239] = (T)(img)(_n12##x,_p2##y,z,c)), \
 (I[263] = (T)(img)(_n12##x,_p1##y,z,c)), \
 (I[287] = (T)(img)(_n12##x,y,z,c)), \
 (I[311] = (T)(img)(_n12##x,_n1##y,z,c)), \
 (I[335] = (T)(img)(_n12##x,_n2##y,z,c)), \
 (I[359] = (T)(img)(_n12##x,_n3##y,z,c)), \
 (I[383] = (T)(img)(_n12##x,_n4##y,z,c)), \
 (I[407] = (T)(img)(_n12##x,_n5##y,z,c)), \
 (I[431] = (T)(img)(_n12##x,_n6##y,z,c)), \
 (I[455] = (T)(img)(_n12##x,_n7##y,z,c)), \
 (I[479] = (T)(img)(_n12##x,_n8##y,z,c)), \
 (I[503] = (T)(img)(_n12##x,_n9##y,z,c)), \
 (I[527] = (T)(img)(_n12##x,_n10##y,z,c)), \
 (I[551] = (T)(img)(_n12##x,_n11##y,z,c)), \
 (I[575] = (T)(img)(_n12##x,_n12##y,z,c)),1)) || \
 _n11##x==--_n12##x || _n10##x==--_n11##x || _n9##x==--_n10##x || _n8##x==--_n9##x || _n7##x==--_n8##x || _n6##x==--_n7##x || _n5##x==--_n6##x || _n4##x==--_n5##x || _n3##x==--_n4##x || _n2##x==--_n3##x || _n1##x==--_n2##x || x==(_n12##x = _n11##x = _n10##x = _n9##x = _n8##x = _n7##x = _n6##x = _n5##x = _n4##x = _n3##x = _n2##x = --_n1##x)); \
 I[0] = I[1], I[1] = I[2], I[2] = I[3], I[3] = I[4], I[4] = I[5], I[5] = I[6], I[6] = I[7], I[7] = I[8], I[8] = I[9], I[9] = I[10], I[10] = I[11], I[11] = I[12], I[12] = I[13], I[13] = I[14], I[14] = I[15], I[15] = I[16], I[16] = I[17], I[17] = I[18], I[18] = I[19], I[19] = I[20], I[20] = I[21], I[21] = I[22], I[22] = I[23], \
 I[24] = I[25], I[25] = I[26], I[26] = I[27], I[27] = I[28], I[28] = I[29], I[29] = I[30], I[30] = I[31], I[31] = I[32], I[32] = I[33], I[33] = I[34], I[34] = I[35], I[35] = I[36], I[36] = I[37], I[37] = I[38], I[38] = I[39], I[39] = I[40], I[40] = I[41], I[41] = I[42], I[42] = I[43], I[43] = I[44], I[44] = I[45], I[45] = I[46], I[46] = I[47], \
 I[48] = I[49], I[49] = I[50], I[50] = I[51], I[51] = I[52], I[52] = I[53], I[53] = I[54], I[54] = I[55], I[55] = I[56], I[56] = I[57], I[57] = I[58], I[58] = I[59], I[59] = I[60], I[60] = I[61], I[61] = I[62], I[62] = I[63], I[63] = I[64], I[64] = I[65], I[65] = I[66], I[66] = I[67], I[67] = I[68], I[68] = I[69], I[69] = I[70], I[70] = I[71], \
 I[72] = I[73], I[73] = I[74], I[74] = I[75], I[75] = I[76], I[76] = I[77], I[77] = I[78], I[78] = I[79], I[79] = I[80], I[80] = I[81], I[81] = I[82], I[82] = I[83], I[83] = I[84], I[84] = I[85], I[85] = I[86], I[86] = I[87], I[87] = I[88], I[88] = I[89], I[89] = I[90], I[90] = I[91], I[91] = I[92], I[92] = I[93], I[93] = I[94], I[94] = I[95], \
 I[96] = I[97], I[97] = I[98], I[98] = I[99], I[99] = I[100], I[100] = I[101], I[101] = I[102], I[102] = I[103], I[103] = I[104], I[104] = I[105], I[105] = I[106], I[106] = I[107], I[107] = I[108], I[108] = I[109], I[109] = I[110], I[110] = I[111], I[111] = I[112], I[112] = I[113], I[113] = I[114], I[114] = I[115], I[115] = I[116], I[116] = I[117], I[117] = I[118], I[118] = I[119], \
 I[120] = I[121], I[121] = I[122], I[122] = I[123], I[123] = I[124], I[124] = I[125], I[125] = I[126], I[126] = I[127], I[127] = I[128], I[128] = I[129], I[129] = I[130], I[130] = I[131], I[131] = I[132], I[132] = I[133], I[133] = I[134], I[134] = I[135], I[135] = I[136], I[136] = I[137], I[137] = I[138], I[138] = I[139], I[139] = I[140], I[140] = I[141], I[141] = I[142], I[142] = I[143], \
 I[144] = I[145], I[145] = I[146], I[146] = I[147], I[147] = I[148], I[148] = I[149], I[149] = I[150], I[150] = I[151], I[151] = I[152], I[152] = I[153], I[153] = I[154], I[154] = I[155], I[155] = I[156], I[156] = I[157], I[157] = I[158], I[158] = I[159], I[159] = I[160], I[160] = I[161], I[161] = I[162], I[162] = I[163], I[163] = I[164], I[164] = I[165], I[165] = I[166], I[166] = I[167], \
 I[168] = I[169], I[169] = I[170], I[170] = I[171], I[171] = I[172], I[172] = I[173], I[173] = I[174], I[174] = I[175], I[175] = I[176], I[176] = I[177], I[177] = I[178], I[178] = I[179], I[179] = I[180], I[180] = I[181], I[181] = I[182], I[182] = I[183], I[183] = I[184], I[184] = I[185], I[185] = I[186], I[186] = I[187], I[187] = I[188], I[188] = I[189], I[189] = I[190], I[190] = I[191], \
 I[192] = I[193], I[193] = I[194], I[194] = I[195], I[195] = I[196], I[196] = I[197], I[197] = I[198], I[198] = I[199], I[199] = I[200], I[200] = I[201], I[201] = I[202], I[202] = I[203], I[203] = I[204], I[204] = I[205], I[205] = I[206], I[206] = I[207], I[207] = I[208], I[208] = I[209], I[209] = I[210], I[210] = I[211], I[211] = I[212], I[212] = I[213], I[213] = I[214], I[214] = I[215], \
 I[216] = I[217], I[217] = I[218], I[218] = I[219], I[219] = I[220], I[220] = I[221], I[221] = I[222], I[222] = I[223], I[223] = I[224], I[224] = I[225], I[225] = I[226], I[226] = I[227], I[227] = I[228], I[228] = I[229], I[229] = I[230], I[230] = I[231], I[231] = I[232], I[232] = I[233], I[233] = I[234], I[234] = I[235], I[235] = I[236], I[236] = I[237], I[237] = I[238], I[238] = I[239], \
 I[240] = I[241], I[241] = I[242], I[242] = I[243], I[243] = I[244], I[244] = I[245], I[245] = I[246], I[246] = I[247], I[247] = I[248], I[248] = I[249], I[249] = I[250], I[250] = I[251], I[251] = I[252], I[252] = I[253], I[253] = I[254], I[254] = I[255], I[255] = I[256], I[256] = I[257], I[257] = I[258], I[258] = I[259], I[259] = I[260], I[260] = I[261], I[261] = I[262], I[262] = I[263], \
 I[264] = I[265], I[265] = I[266], I[266] = I[267], I[267] = I[268], I[268] = I[269], I[269] = I[270], I[270] = I[271], I[271] = I[272], I[272] = I[273], I[273] = I[274], I[274] = I[275], I[275] = I[276], I[276] = I[277], I[277] = I[278], I[278] = I[279], I[279] = I[280], I[280] = I[281], I[281] = I[282], I[282] = I[283], I[283] = I[284], I[284] = I[285], I[285] = I[286], I[286] = I[287], \
 I[288] = I[289], I[289] = I[290], I[290] = I[291], I[291] = I[292], I[292] = I[293], I[293] = I[294], I[294] = I[295], I[295] = I[296], I[296] = I[297], I[297] = I[298], I[298] = I[299], I[299] = I[300], I[300] = I[301], I[301] = I[302], I[302] = I[303], I[303] = I[304], I[304] = I[305], I[305] = I[306], I[306] = I[307], I[307] = I[308], I[308] = I[309], I[309] = I[310], I[310] = I[311], \
 I[312] = I[313], I[313] = I[314], I[314] = I[315], I[315] = I[316], I[316] = I[317], I[317] = I[318], I[318] = I[319], I[319] = I[320], I[320] = I[321], I[321] = I[322], I[322] = I[323], I[323] = I[324], I[324] = I[325], I[325] = I[326], I[326] = I[327], I[327] = I[328], I[328] = I[329], I[329] = I[330], I[330] = I[331], I[331] = I[332], I[332] = I[333], I[333] = I[334], I[334] = I[335], \
 I[336] = I[337], I[337] = I[338], I[338] = I[339], I[339] = I[340], I[340] = I[341], I[341] = I[342], I[342] = I[343], I[343] = I[344], I[344] = I[345], I[345] = I[346], I[346] = I[347], I[347] = I[348], I[348] = I[349], I[349] = I[350], I[350] = I[351], I[351] = I[352], I[352] = I[353], I[353] = I[354], I[354] = I[355], I[355] = I[356], I[356] = I[357], I[357] = I[358], I[358] = I[359], \
 I[360] = I[361], I[361] = I[362], I[362] = I[363], I[363] = I[364], I[364] = I[365], I[365] = I[366], I[366] = I[367], I[367] = I[368], I[368] = I[369], I[369] = I[370], I[370] = I[371], I[371] = I[372], I[372] = I[373], I[373] = I[374], I[374] = I[375], I[375] = I[376], I[376] = I[377], I[377] = I[378], I[378] = I[379], I[379] = I[380], I[380] = I[381], I[381] = I[382], I[382] = I[383], \
 I[384] = I[385], I[385] = I[386], I[386] = I[387], I[387] = I[388], I[388] = I[389], I[389] = I[390], I[390] = I[391], I[391] = I[392], I[392] = I[393], I[393] = I[394], I[394] = I[395], I[395] = I[396], I[396] = I[397], I[397] = I[398], I[398] = I[399], I[399] = I[400], I[400] = I[401], I[401] = I[402], I[402] = I[403], I[403] = I[404], I[404] = I[405], I[405] = I[406], I[406] = I[407], \
 I[408] = I[409], I[409] = I[410], I[410] = I[411], I[411] = I[412], I[412] = I[413], I[413] = I[414], I[414] = I[415], I[415] = I[416], I[416] = I[417], I[417] = I[418], I[418] = I[419], I[419] = I[420], I[420] = I[421], I[421] = I[422], I[422] = I[423], I[423] = I[424], I[424] = I[425], I[425] = I[426], I[426] = I[427], I[427] = I[428], I[428] = I[429], I[429] = I[430], I[430] = I[431], \
 I[432] = I[433], I[433] = I[434], I[434] = I[435], I[435] = I[436], I[436] = I[437], I[437] = I[438], I[438] = I[439], I[439] = I[440], I[440] = I[441], I[441] = I[442], I[442] = I[443], I[443] = I[444], I[444] = I[445], I[445] = I[446], I[446] = I[447], I[447] = I[448], I[448] = I[449], I[449] = I[450], I[450] = I[451], I[451] = I[452], I[452] = I[453], I[453] = I[454], I[454] = I[455], \
 I[456] = I[457], I[457] = I[458], I[458] = I[459], I[459] = I[460], I[460] = I[461], I[461] = I[462], I[462] = I[463], I[463] = I[464], I[464] = I[465], I[465] = I[466], I[466] = I[467], I[467] = I[468], I[468] = I[469], I[469] = I[470], I[470] = I[471], I[471] = I[472], I[472] = I[473], I[473] = I[474], I[474] = I[475], I[475] = I[476], I[476] = I[477], I[477] = I[478], I[478] = I[479], \
 I[480] = I[481], I[481] = I[482], I[482] = I[483], I[483] = I[484], I[484] = I[485], I[485] = I[486], I[486] = I[487], I[487] = I[488], I[488] = I[489], I[489] = I[490], I[490] = I[491], I[491] = I[492], I[492] = I[493], I[493] = I[494], I[494] = I[495], I[495] = I[496], I[496] = I[497], I[497] = I[498], I[498] = I[499], I[499] = I[500], I[500] = I[501], I[501] = I[502], I[502] = I[503], \
 I[504] = I[505], I[505] = I[506], I[506] = I[507], I[507] = I[508], I[508] = I[509], I[509] = I[510], I[510] = I[511], I[511] = I[512], I[512] = I[513], I[513] = I[514], I[514] = I[515], I[515] = I[516], I[516] = I[517], I[517] = I[518], I[518] = I[519], I[519] = I[520], I[520] = I[521], I[521] = I[522], I[522] = I[523], I[523] = I[524], I[524] = I[525], I[525] = I[526], I[526] = I[527], \
 I[528] = I[529], I[529] = I[530], I[530] = I[531], I[531] = I[532], I[532] = I[533], I[533] = I[534], I[534] = I[535], I[535] = I[536], I[536] = I[537], I[537] = I[538], I[538] = I[539], I[539] = I[540], I[540] = I[541], I[541] = I[542], I[542] = I[543], I[543] = I[544], I[544] = I[545], I[545] = I[546], I[546] = I[547], I[547] = I[548], I[548] = I[549], I[549] = I[550], I[550] = I[551], \
 I[552] = I[553], I[553] = I[554], I[554] = I[555], I[555] = I[556], I[556] = I[557], I[557] = I[558], I[558] = I[559], I[559] = I[560], I[560] = I[561], I[561] = I[562], I[562] = I[563], I[563] = I[564], I[564] = I[565], I[565] = I[566], I[566] = I[567], I[567] = I[568], I[568] = I[569], I[569] = I[570], I[570] = I[571], I[571] = I[572], I[572] = I[573], I[573] = I[574], I[574] = I[575], \
 _p11##x = _p10##x, _p10##x = _p9##x, _p9##x = _p8##x, _p8##x = _p7##x, _p7##x = _p6##x, _p6##x = _p5##x, _p5##x = _p4##x, _p4##x = _p3##x, _p3##x = _p2##x, _p2##x = _p1##x, _p1##x = x++, ++_n1##x, ++_n2##x, ++_n3##x, ++_n4##x, ++_n5##x, ++_n6##x, ++_n7##x, ++_n8##x, ++_n9##x, ++_n10##x, ++_n11##x, ++_n12##x)

#define cimg_get24x24(img,x,y,z,c,I,T) \
 I[0] = (T)(img)(_p11##x,_p11##y,z,c), I[1] = (T)(img)(_p10##x,_p11##y,z,c), I[2] = (T)(img)(_p9##x,_p11##y,z,c), I[3] = (T)(img)(_p8##x,_p11##y,z,c), I[4] = (T)(img)(_p7##x,_p11##y,z,c), I[5] = (T)(img)(_p6##x,_p11##y,z,c), I[6] = (T)(img)(_p5##x,_p11##y,z,c), I[7] = (T)(img)(_p4##x,_p11##y,z,c), I[8] = (T)(img)(_p3##x,_p11##y,z,c), I[9] = (T)(img)(_p2##x,_p11##y,z,c), I[10] = (T)(img)(_p1##x,_p11##y,z,c), I[11] = (T)(img)(x,_p11##y,z,c), I[12] = (T)(img)(_n1##x,_p11##y,z,c), I[13] = (T)(img)(_n2##x,_p11##y,z,c), I[14] = (T)(img)(_n3##x,_p11##y,z,c), I[15] = (T)(img)(_n4##x,_p11##y,z,c), I[16] = (T)(img)(_n5##x,_p11##y,z,c), I[17] = (T)(img)(_n6##x,_p11##y,z,c), I[18] = (T)(img)(_n7##x,_p11##y,z,c), I[19] = (T)(img)(_n8##x,_p11##y,z,c), I[20] = (T)(img)(_n9##x,_p11##y,z,c), I[21] = (T)(img)(_n10##x,_p11##y,z,c), I[22] = (T)(img)(_n11##x,_p11##y,z,c), I[23] = (T)(img)(_n12##x,_p11##y,z,c), \
 I[24] = (T)(img)(_p11##x,_p10##y,z,c), I[25] = (T)(img)(_p10##x,_p10##y,z,c), I[26] = (T)(img)(_p9##x,_p10##y,z,c), I[27] = (T)(img)(_p8##x,_p10##y,z,c), I[28] = (T)(img)(_p7##x,_p10##y,z,c), I[29] = (T)(img)(_p6##x,_p10##y,z,c), I[30] = (T)(img)(_p5##x,_p10##y,z,c), I[31] = (T)(img)(_p4##x,_p10##y,z,c), I[32] = (T)(img)(_p3##x,_p10##y,z,c), I[33] = (T)(img)(_p2##x,_p10##y,z,c), I[34] = (T)(img)(_p1##x,_p10##y,z,c), I[35] = (T)(img)(x,_p10##y,z,c), I[36] = (T)(img)(_n1##x,_p10##y,z,c), I[37] = (T)(img)(_n2##x,_p10##y,z,c), I[38] = (T)(img)(_n3##x,_p10##y,z,c), I[39] = (T)(img)(_n4##x,_p10##y,z,c), I[40] = (T)(img)(_n5##x,_p10##y,z,c), I[41] = (T)(img)(_n6##x,_p10##y,z,c), I[42] = (T)(img)(_n7##x,_p10##y,z,c), I[43] = (T)(img)(_n8##x,_p10##y,z,c), I[44] = (T)(img)(_n9##x,_p10##y,z,c), I[45] = (T)(img)(_n10##x,_p10##y,z,c), I[46] = (T)(img)(_n11##x,_p10##y,z,c), I[47] = (T)(img)(_n12##x,_p10##y,z,c), \
 I[48] = (T)(img)(_p11##x,_p9##y,z,c), I[49] = (T)(img)(_p10##x,_p9##y,z,c), I[50] = (T)(img)(_p9##x,_p9##y,z,c), I[51] = (T)(img)(_p8##x,_p9##y,z,c), I[52] = (T)(img)(_p7##x,_p9##y,z,c), I[53] = (T)(img)(_p6##x,_p9##y,z,c), I[54] = (T)(img)(_p5##x,_p9##y,z,c), I[55] = (T)(img)(_p4##x,_p9##y,z,c), I[56] = (T)(img)(_p3##x,_p9##y,z,c), I[57] = (T)(img)(_p2##x,_p9##y,z,c), I[58] = (T)(img)(_p1##x,_p9##y,z,c), I[59] = (T)(img)(x,_p9##y,z,c), I[60] = (T)(img)(_n1##x,_p9##y,z,c), I[61] = (T)(img)(_n2##x,_p9##y,z,c), I[62] = (T)(img)(_n3##x,_p9##y,z,c), I[63] = (T)(img)(_n4##x,_p9##y,z,c), I[64] = (T)(img)(_n5##x,_p9##y,z,c), I[65] = (T)(img)(_n6##x,_p9##y,z,c), I[66] = (T)(img)(_n7##x,_p9##y,z,c), I[67] = (T)(img)(_n8##x,_p9##y,z,c), I[68] = (T)(img)(_n9##x,_p9##y,z,c), I[69] = (T)(img)(_n10##x,_p9##y,z,c), I[70] = (T)(img)(_n11##x,_p9##y,z,c), I[71] = (T)(img)(_n12##x,_p9##y,z,c), \
 I[72] = (T)(img)(_p11##x,_p8##y,z,c), I[73] = (T)(img)(_p10##x,_p8##y,z,c), I[74] = (T)(img)(_p9##x,_p8##y,z,c), I[75] = (T)(img)(_p8##x,_p8##y,z,c), I[76] = (T)(img)(_p7##x,_p8##y,z,c), I[77] = (T)(img)(_p6##x,_p8##y,z,c), I[78] = (T)(img)(_p5##x,_p8##y,z,c), I[79] = (T)(img)(_p4##x,_p8##y,z,c), I[80] = (T)(img)(_p3##x,_p8##y,z,c), I[81] = (T)(img)(_p2##x,_p8##y,z,c), I[82] = (T)(img)(_p1##x,_p8##y,z,c), I[83] = (T)(img)(x,_p8##y,z,c), I[84] = (T)(img)(_n1##x,_p8##y,z,c), I[85] = (T)(img)(_n2##x,_p8##y,z,c), I[86] = (T)(img)(_n3##x,_p8##y,z,c), I[87] = (T)(img)(_n4##x,_p8##y,z,c), I[88] = (T)(img)(_n5##x,_p8##y,z,c), I[89] = (T)(img)(_n6##x,_p8##y,z,c), I[90] = (T)(img)(_n7##x,_p8##y,z,c), I[91] = (T)(img)(_n8##x,_p8##y,z,c), I[92] = (T)(img)(_n9##x,_p8##y,z,c), I[93] = (T)(img)(_n10##x,_p8##y,z,c), I[94] = (T)(img)(_n11##x,_p8##y,z,c), I[95] = (T)(img)(_n12##x,_p8##y,z,c), \
 I[96] = (T)(img)(_p11##x,_p7##y,z,c), I[97] = (T)(img)(_p10##x,_p7##y,z,c), I[98] = (T)(img)(_p9##x,_p7##y,z,c), I[99] = (T)(img)(_p8##x,_p7##y,z,c), I[100] = (T)(img)(_p7##x,_p7##y,z,c), I[101] = (T)(img)(_p6##x,_p7##y,z,c), I[102] = (T)(img)(_p5##x,_p7##y,z,c), I[103] = (T)(img)(_p4##x,_p7##y,z,c), I[104] = (T)(img)(_p3##x,_p7##y,z,c), I[105] = (T)(img)(_p2##x,_p7##y,z,c), I[106] = (T)(img)(_p1##x,_p7##y,z,c), I[107] = (T)(img)(x,_p7##y,z,c), I[108] = (T)(img)(_n1##x,_p7##y,z,c), I[109] = (T)(img)(_n2##x,_p7##y,z,c), I[110] = (T)(img)(_n3##x,_p7##y,z,c), I[111] = (T)(img)(_n4##x,_p7##y,z,c), I[112] = (T)(img)(_n5##x,_p7##y,z,c), I[113] = (T)(img)(_n6##x,_p7##y,z,c), I[114] = (T)(img)(_n7##x,_p7##y,z,c), I[115] = (T)(img)(_n8##x,_p7##y,z,c), I[116] = (T)(img)(_n9##x,_p7##y,z,c), I[117] = (T)(img)(_n10##x,_p7##y,z,c), I[118] = (T)(img)(_n11##x,_p7##y,z,c), I[119] = (T)(img)(_n12##x,_p7##y,z,c), \
 I[120] = (T)(img)(_p11##x,_p6##y,z,c), I[121] = (T)(img)(_p10##x,_p6##y,z,c), I[122] = (T)(img)(_p9##x,_p6##y,z,c), I[123] = (T)(img)(_p8##x,_p6##y,z,c), I[124] = (T)(img)(_p7##x,_p6##y,z,c), I[125] = (T)(img)(_p6##x,_p6##y,z,c), I[126] = (T)(img)(_p5##x,_p6##y,z,c), I[127] = (T)(img)(_p4##x,_p6##y,z,c), I[128] = (T)(img)(_p3##x,_p6##y,z,c), I[129] = (T)(img)(_p2##x,_p6##y,z,c), I[130] = (T)(img)(_p1##x,_p6##y,z,c), I[131] = (T)(img)(x,_p6##y,z,c), I[132] = (T)(img)(_n1##x,_p6##y,z,c), I[133] = (T)(img)(_n2##x,_p6##y,z,c), I[134] = (T)(img)(_n3##x,_p6##y,z,c), I[135] = (T)(img)(_n4##x,_p6##y,z,c), I[136] = (T)(img)(_n5##x,_p6##y,z,c), I[137] = (T)(img)(_n6##x,_p6##y,z,c), I[138] = (T)(img)(_n7##x,_p6##y,z,c), I[139] = (T)(img)(_n8##x,_p6##y,z,c), I[140] = (T)(img)(_n9##x,_p6##y,z,c), I[141] = (T)(img)(_n10##x,_p6##y,z,c), I[142] = (T)(img)(_n11##x,_p6##y,z,c), I[143] = (T)(img)(_n12##x,_p6##y,z,c), \
 I[144] = (T)(img)(_p11##x,_p5##y,z,c), I[145] = (T)(img)(_p10##x,_p5##y,z,c), I[146] = (T)(img)(_p9##x,_p5##y,z,c), I[147] = (T)(img)(_p8##x,_p5##y,z,c), I[148] = (T)(img)(_p7##x,_p5##y,z,c), I[149] = (T)(img)(_p6##x,_p5##y,z,c), I[150] = (T)(img)(_p5##x,_p5##y,z,c), I[151] = (T)(img)(_p4##x,_p5##y,z,c), I[152] = (T)(img)(_p3##x,_p5##y,z,c), I[153] = (T)(img)(_p2##x,_p5##y,z,c), I[154] = (T)(img)(_p1##x,_p5##y,z,c), I[155] = (T)(img)(x,_p5##y,z,c), I[156] = (T)(img)(_n1##x,_p5##y,z,c), I[157] = (T)(img)(_n2##x,_p5##y,z,c), I[158] = (T)(img)(_n3##x,_p5##y,z,c), I[159] = (T)(img)(_n4##x,_p5##y,z,c), I[160] = (T)(img)(_n5##x,_p5##y,z,c), I[161] = (T)(img)(_n6##x,_p5##y,z,c), I[162] = (T)(img)(_n7##x,_p5##y,z,c), I[163] = (T)(img)(_n8##x,_p5##y,z,c), I[164] = (T)(img)(_n9##x,_p5##y,z,c), I[165] = (T)(img)(_n10##x,_p5##y,z,c), I[166] = (T)(img)(_n11##x,_p5##y,z,c), I[167] = (T)(img)(_n12##x,_p5##y,z,c), \
 I[168] = (T)(img)(_p11##x,_p4##y,z,c), I[169] = (T)(img)(_p10##x,_p4##y,z,c), I[170] = (T)(img)(_p9##x,_p4##y,z,c), I[171] = (T)(img)(_p8##x,_p4##y,z,c), I[172] = (T)(img)(_p7##x,_p4##y,z,c), I[173] = (T)(img)(_p6##x,_p4##y,z,c), I[174] = (T)(img)(_p5##x,_p4##y,z,c), I[175] = (T)(img)(_p4##x,_p4##y,z,c), I[176] = (T)(img)(_p3##x,_p4##y,z,c), I[177] = (T)(img)(_p2##x,_p4##y,z,c), I[178] = (T)(img)(_p1##x,_p4##y,z,c), I[179] = (T)(img)(x,_p4##y,z,c), I[180] = (T)(img)(_n1##x,_p4##y,z,c), I[181] = (T)(img)(_n2##x,_p4##y,z,c), I[182] = (T)(img)(_n3##x,_p4##y,z,c), I[183] = (T)(img)(_n4##x,_p4##y,z,c), I[184] = (T)(img)(_n5##x,_p4##y,z,c), I[185] = (T)(img)(_n6##x,_p4##y,z,c), I[186] = (T)(img)(_n7##x,_p4##y,z,c), I[187] = (T)(img)(_n8##x,_p4##y,z,c), I[188] = (T)(img)(_n9##x,_p4##y,z,c), I[189] = (T)(img)(_n10##x,_p4##y,z,c), I[190] = (T)(img)(_n11##x,_p4##y,z,c), I[191] = (T)(img)(_n12##x,_p4##y,z,c), \
 I[192] = (T)(img)(_p11##x,_p3##y,z,c), I[193] = (T)(img)(_p10##x,_p3##y,z,c), I[194] = (T)(img)(_p9##x,_p3##y,z,c), I[195] = (T)(img)(_p8##x,_p3##y,z,c), I[196] = (T)(img)(_p7##x,_p3##y,z,c), I[197] = (T)(img)(_p6##x,_p3##y,z,c), I[198] = (T)(img)(_p5##x,_p3##y,z,c), I[199] = (T)(img)(_p4##x,_p3##y,z,c), I[200] = (T)(img)(_p3##x,_p3##y,z,c), I[201] = (T)(img)(_p2##x,_p3##y,z,c), I[202] = (T)(img)(_p1##x,_p3##y,z,c), I[203] = (T)(img)(x,_p3##y,z,c), I[204] = (T)(img)(_n1##x,_p3##y,z,c), I[205] = (T)(img)(_n2##x,_p3##y,z,c), I[206] = (T)(img)(_n3##x,_p3##y,z,c), I[207] = (T)(img)(_n4##x,_p3##y,z,c), I[208] = (T)(img)(_n5##x,_p3##y,z,c), I[209] = (T)(img)(_n6##x,_p3##y,z,c), I[210] = (T)(img)(_n7##x,_p3##y,z,c), I[211] = (T)(img)(_n8##x,_p3##y,z,c), I[212] = (T)(img)(_n9##x,_p3##y,z,c), I[213] = (T)(img)(_n10##x,_p3##y,z,c), I[214] = (T)(img)(_n11##x,_p3##y,z,c), I[215] = (T)(img)(_n12##x,_p3##y,z,c), \
 I[216] = (T)(img)(_p11##x,_p2##y,z,c), I[217] = (T)(img)(_p10##x,_p2##y,z,c), I[218] = (T)(img)(_p9##x,_p2##y,z,c), I[219] = (T)(img)(_p8##x,_p2##y,z,c), I[220] = (T)(img)(_p7##x,_p2##y,z,c), I[221] = (T)(img)(_p6##x,_p2##y,z,c), I[222] = (T)(img)(_p5##x,_p2##y,z,c), I[223] = (T)(img)(_p4##x,_p2##y,z,c), I[224] = (T)(img)(_p3##x,_p2##y,z,c), I[225] = (T)(img)(_p2##x,_p2##y,z,c), I[226] = (T)(img)(_p1##x,_p2##y,z,c), I[227] = (T)(img)(x,_p2##y,z,c), I[228] = (T)(img)(_n1##x,_p2##y,z,c), I[229] = (T)(img)(_n2##x,_p2##y,z,c), I[230] = (T)(img)(_n3##x,_p2##y,z,c), I[231] = (T)(img)(_n4##x,_p2##y,z,c), I[232] = (T)(img)(_n5##x,_p2##y,z,c), I[233] = (T)(img)(_n6##x,_p2##y,z,c), I[234] = (T)(img)(_n7##x,_p2##y,z,c), I[235] = (T)(img)(_n8##x,_p2##y,z,c), I[236] = (T)(img)(_n9##x,_p2##y,z,c), I[237] = (T)(img)(_n10##x,_p2##y,z,c), I[238] = (T)(img)(_n11##x,_p2##y,z,c), I[239] = (T)(img)(_n12##x,_p2##y,z,c), \
 I[240] = (T)(img)(_p11##x,_p1##y,z,c), I[241] = (T)(img)(_p10##x,_p1##y,z,c), I[242] = (T)(img)(_p9##x,_p1##y,z,c), I[243] = (T)(img)(_p8##x,_p1##y,z,c), I[244] = (T)(img)(_p7##x,_p1##y,z,c), I[245] = (T)(img)(_p6##x,_p1##y,z,c), I[246] = (T)(img)(_p5##x,_p1##y,z,c), I[247] = (T)(img)(_p4##x,_p1##y,z,c), I[248] = (T)(img)(_p3##x,_p1##y,z,c), I[249] = (T)(img)(_p2##x,_p1##y,z,c), I[250] = (T)(img)(_p1##x,_p1##y,z,c), I[251] = (T)(img)(x,_p1##y,z,c), I[252] = (T)(img)(_n1##x,_p1##y,z,c), I[253] = (T)(img)(_n2##x,_p1##y,z,c), I[254] = (T)(img)(_n3##x,_p1##y,z,c), I[255] = (T)(img)(_n4##x,_p1##y,z,c), I[256] = (T)(img)(_n5##x,_p1##y,z,c), I[257] = (T)(img)(_n6##x,_p1##y,z,c), I[258] = (T)(img)(_n7##x,_p1##y,z,c), I[259] = (T)(img)(_n8##x,_p1##y,z,c), I[260] = (T)(img)(_n9##x,_p1##y,z,c), I[261] = (T)(img)(_n10##x,_p1##y,z,c), I[262] = (T)(img)(_n11##x,_p1##y,z,c), I[263] = (T)(img)(_n12##x,_p1##y,z,c), \
 I[264] = (T)(img)(_p11##x,y,z,c), I[265] = (T)(img)(_p10##x,y,z,c), I[266] = (T)(img)(_p9##x,y,z,c), I[267] = (T)(img)(_p8##x,y,z,c), I[268] = (T)(img)(_p7##x,y,z,c), I[269] = (T)(img)(_p6##x,y,z,c), I[270] = (T)(img)(_p5##x,y,z,c), I[271] = (T)(img)(_p4##x,y,z,c), I[272] = (T)(img)(_p3##x,y,z,c), I[273] = (T)(img)(_p2##x,y,z,c), I[274] = (T)(img)(_p1##x,y,z,c), I[275] = (T)(img)(x,y,z,c), I[276] = (T)(img)(_n1##x,y,z,c), I[277] = (T)(img)(_n2##x,y,z,c), I[278] = (T)(img)(_n3##x,y,z,c), I[279] = (T)(img)(_n4##x,y,z,c), I[280] = (T)(img)(_n5##x,y,z,c), I[281] = (T)(img)(_n6##x,y,z,c), I[282] = (T)(img)(_n7##x,y,z,c), I[283] = (T)(img)(_n8##x,y,z,c), I[284] = (T)(img)(_n9##x,y,z,c), I[285] = (T)(img)(_n10##x,y,z,c), I[286] = (T)(img)(_n11##x,y,z,c), I[287] = (T)(img)(_n12##x,y,z,c), \
 I[288] = (T)(img)(_p11##x,_n1##y,z,c), I[289] = (T)(img)(_p10##x,_n1##y,z,c), I[290] = (T)(img)(_p9##x,_n1##y,z,c), I[291] = (T)(img)(_p8##x,_n1##y,z,c), I[292] = (T)(img)(_p7##x,_n1##y,z,c), I[293] = (T)(img)(_p6##x,_n1##y,z,c), I[294] = (T)(img)(_p5##x,_n1##y,z,c), I[295] = (T)(img)(_p4##x,_n1##y,z,c), I[296] = (T)(img)(_p3##x,_n1##y,z,c), I[297] = (T)(img)(_p2##x,_n1##y,z,c), I[298] = (T)(img)(_p1##x,_n1##y,z,c), I[299] = (T)(img)(x,_n1##y,z,c), I[300] = (T)(img)(_n1##x,_n1##y,z,c), I[301] = (T)(img)(_n2##x,_n1##y,z,c), I[302] = (T)(img)(_n3##x,_n1##y,z,c), I[303] = (T)(img)(_n4##x,_n1##y,z,c), I[304] = (T)(img)(_n5##x,_n1##y,z,c), I[305] = (T)(img)(_n6##x,_n1##y,z,c), I[306] = (T)(img)(_n7##x,_n1##y,z,c), I[307] = (T)(img)(_n8##x,_n1##y,z,c), I[308] = (T)(img)(_n9##x,_n1##y,z,c), I[309] = (T)(img)(_n10##x,_n1##y,z,c), I[310] = (T)(img)(_n11##x,_n1##y,z,c), I[311] = (T)(img)(_n12##x,_n1##y,z,c), \
 I[312] = (T)(img)(_p11##x,_n2##y,z,c), I[313] = (T)(img)(_p10##x,_n2##y,z,c), I[314] = (T)(img)(_p9##x,_n2##y,z,c), I[315] = (T)(img)(_p8##x,_n2##y,z,c), I[316] = (T)(img)(_p7##x,_n2##y,z,c), I[317] = (T)(img)(_p6##x,_n2##y,z,c), I[318] = (T)(img)(_p5##x,_n2##y,z,c), I[319] = (T)(img)(_p4##x,_n2##y,z,c), I[320] = (T)(img)(_p3##x,_n2##y,z,c), I[321] = (T)(img)(_p2##x,_n2##y,z,c), I[322] = (T)(img)(_p1##x,_n2##y,z,c), I[323] = (T)(img)(x,_n2##y,z,c), I[324] = (T)(img)(_n1##x,_n2##y,z,c), I[325] = (T)(img)(_n2##x,_n2##y,z,c), I[326] = (T)(img)(_n3##x,_n2##y,z,c), I[327] = (T)(img)(_n4##x,_n2##y,z,c), I[328] = (T)(img)(_n5##x,_n2##y,z,c), I[329] = (T)(img)(_n6##x,_n2##y,z,c), I[330] = (T)(img)(_n7##x,_n2##y,z,c), I[331] = (T)(img)(_n8##x,_n2##y,z,c), I[332] = (T)(img)(_n9##x,_n2##y,z,c), I[333] = (T)(img)(_n10##x,_n2##y,z,c), I[334] = (T)(img)(_n11##x,_n2##y,z,c), I[335] = (T)(img)(_n12##x,_n2##y,z,c), \
 I[336] = (T)(img)(_p11##x,_n3##y,z,c), I[337] = (T)(img)(_p10##x,_n3##y,z,c), I[338] = (T)(img)(_p9##x,_n3##y,z,c), I[339] = (T)(img)(_p8##x,_n3##y,z,c), I[340] = (T)(img)(_p7##x,_n3##y,z,c), I[341] = (T)(img)(_p6##x,_n3##y,z,c), I[342] = (T)(img)(_p5##x,_n3##y,z,c), I[343] = (T)(img)(_p4##x,_n3##y,z,c), I[344] = (T)(img)(_p3##x,_n3##y,z,c), I[345] = (T)(img)(_p2##x,_n3##y,z,c), I[346] = (T)(img)(_p1##x,_n3##y,z,c), I[347] = (T)(img)(x,_n3##y,z,c), I[348] = (T)(img)(_n1##x,_n3##y,z,c), I[349] = (T)(img)(_n2##x,_n3##y,z,c), I[350] = (T)(img)(_n3##x,_n3##y,z,c), I[351] = (T)(img)(_n4##x,_n3##y,z,c), I[352] = (T)(img)(_n5##x,_n3##y,z,c), I[353] = (T)(img)(_n6##x,_n3##y,z,c), I[354] = (T)(img)(_n7##x,_n3##y,z,c), I[355] = (T)(img)(_n8##x,_n3##y,z,c), I[356] = (T)(img)(_n9##x,_n3##y,z,c), I[357] = (T)(img)(_n10##x,_n3##y,z,c), I[358] = (T)(img)(_n11##x,_n3##y,z,c), I[359] = (T)(img)(_n12##x,_n3##y,z,c), \
 I[360] = (T)(img)(_p11##x,_n4##y,z,c), I[361] = (T)(img)(_p10##x,_n4##y,z,c), I[362] = (T)(img)(_p9##x,_n4##y,z,c), I[363] = (T)(img)(_p8##x,_n4##y,z,c), I[364] = (T)(img)(_p7##x,_n4##y,z,c), I[365] = (T)(img)(_p6##x,_n4##y,z,c), I[366] = (T)(img)(_p5##x,_n4##y,z,c), I[367] = (T)(img)(_p4##x,_n4##y,z,c), I[368] = (T)(img)(_p3##x,_n4##y,z,c), I[369] = (T)(img)(_p2##x,_n4##y,z,c), I[370] = (T)(img)(_p1##x,_n4##y,z,c), I[371] = (T)(img)(x,_n4##y,z,c), I[372] = (T)(img)(_n1##x,_n4##y,z,c), I[373] = (T)(img)(_n2##x,_n4##y,z,c), I[374] = (T)(img)(_n3##x,_n4##y,z,c), I[375] = (T)(img)(_n4##x,_n4##y,z,c), I[376] = (T)(img)(_n5##x,_n4##y,z,c), I[377] = (T)(img)(_n6##x,_n4##y,z,c), I[378] = (T)(img)(_n7##x,_n4##y,z,c), I[379] = (T)(img)(_n8##x,_n4##y,z,c), I[380] = (T)(img)(_n9##x,_n4##y,z,c), I[381] = (T)(img)(_n10##x,_n4##y,z,c), I[382] = (T)(img)(_n11##x,_n4##y,z,c), I[383] = (T)(img)(_n12##x,_n4##y,z,c), \
 I[384] = (T)(img)(_p11##x,_n5##y,z,c), I[385] = (T)(img)(_p10##x,_n5##y,z,c), I[386] = (T)(img)(_p9##x,_n5##y,z,c), I[387] = (T)(img)(_p8##x,_n5##y,z,c), I[388] = (T)(img)(_p7##x,_n5##y,z,c), I[389] = (T)(img)(_p6##x,_n5##y,z,c), I[390] = (T)(img)(_p5##x,_n5##y,z,c), I[391] = (T)(img)(_p4##x,_n5##y,z,c), I[392] = (T)(img)(_p3##x,_n5##y,z,c), I[393] = (T)(img)(_p2##x,_n5##y,z,c), I[394] = (T)(img)(_p1##x,_n5##y,z,c), I[395] = (T)(img)(x,_n5##y,z,c), I[396] = (T)(img)(_n1##x,_n5##y,z,c), I[397] = (T)(img)(_n2##x,_n5##y,z,c), I[398] = (T)(img)(_n3##x,_n5##y,z,c), I[399] = (T)(img)(_n4##x,_n5##y,z,c), I[400] = (T)(img)(_n5##x,_n5##y,z,c), I[401] = (T)(img)(_n6##x,_n5##y,z,c), I[402] = (T)(img)(_n7##x,_n5##y,z,c), I[403] = (T)(img)(_n8##x,_n5##y,z,c), I[404] = (T)(img)(_n9##x,_n5##y,z,c), I[405] = (T)(img)(_n10##x,_n5##y,z,c), I[406] = (T)(img)(_n11##x,_n5##y,z,c), I[407] = (T)(img)(_n12##x,_n5##y,z,c), \
 I[408] = (T)(img)(_p11##x,_n6##y,z,c), I[409] = (T)(img)(_p10##x,_n6##y,z,c), I[410] = (T)(img)(_p9##x,_n6##y,z,c), I[411] = (T)(img)(_p8##x,_n6##y,z,c), I[412] = (T)(img)(_p7##x,_n6##y,z,c), I[413] = (T)(img)(_p6##x,_n6##y,z,c), I[414] = (T)(img)(_p5##x,_n6##y,z,c), I[415] = (T)(img)(_p4##x,_n6##y,z,c), I[416] = (T)(img)(_p3##x,_n6##y,z,c), I[417] = (T)(img)(_p2##x,_n6##y,z,c), I[418] = (T)(img)(_p1##x,_n6##y,z,c), I[419] = (T)(img)(x,_n6##y,z,c), I[420] = (T)(img)(_n1##x,_n6##y,z,c), I[421] = (T)(img)(_n2##x,_n6##y,z,c), I[422] = (T)(img)(_n3##x,_n6##y,z,c), I[423] = (T)(img)(_n4##x,_n6##y,z,c), I[424] = (T)(img)(_n5##x,_n6##y,z,c), I[425] = (T)(img)(_n6##x,_n6##y,z,c), I[426] = (T)(img)(_n7##x,_n6##y,z,c), I[427] = (T)(img)(_n8##x,_n6##y,z,c), I[428] = (T)(img)(_n9##x,_n6##y,z,c), I[429] = (T)(img)(_n10##x,_n6##y,z,c), I[430] = (T)(img)(_n11##x,_n6##y,z,c), I[431] = (T)(img)(_n12##x,_n6##y,z,c), \
 I[432] = (T)(img)(_p11##x,_n7##y,z,c), I[433] = (T)(img)(_p10##x,_n7##y,z,c), I[434] = (T)(img)(_p9##x,_n7##y,z,c), I[435] = (T)(img)(_p8##x,_n7##y,z,c), I[436] = (T)(img)(_p7##x,_n7##y,z,c), I[437] = (T)(img)(_p6##x,_n7##y,z,c), I[438] = (T)(img)(_p5##x,_n7##y,z,c), I[439] = (T)(img)(_p4##x,_n7##y,z,c), I[440] = (T)(img)(_p3##x,_n7##y,z,c), I[441] = (T)(img)(_p2##x,_n7##y,z,c), I[442] = (T)(img)(_p1##x,_n7##y,z,c), I[443] = (T)(img)(x,_n7##y,z,c), I[444] = (T)(img)(_n1##x,_n7##y,z,c), I[445] = (T)(img)(_n2##x,_n7##y,z,c), I[446] = (T)(img)(_n3##x,_n7##y,z,c), I[447] = (T)(img)(_n4##x,_n7##y,z,c), I[448] = (T)(img)(_n5##x,_n7##y,z,c), I[449] = (T)(img)(_n6##x,_n7##y,z,c), I[450] = (T)(img)(_n7##x,_n7##y,z,c), I[451] = (T)(img)(_n8##x,_n7##y,z,c), I[452] = (T)(img)(_n9##x,_n7##y,z,c), I[453] = (T)(img)(_n10##x,_n7##y,z,c), I[454] = (T)(img)(_n11##x,_n7##y,z,c), I[455] = (T)(img)(_n12##x,_n7##y,z,c), \
 I[456] = (T)(img)(_p11##x,_n8##y,z,c), I[457] = (T)(img)(_p10##x,_n8##y,z,c), I[458] = (T)(img)(_p9##x,_n8##y,z,c), I[459] = (T)(img)(_p8##x,_n8##y,z,c), I[460] = (T)(img)(_p7##x,_n8##y,z,c), I[461] = (T)(img)(_p6##x,_n8##y,z,c), I[462] = (T)(img)(_p5##x,_n8##y,z,c), I[463] = (T)(img)(_p4##x,_n8##y,z,c), I[464] = (T)(img)(_p3##x,_n8##y,z,c), I[465] = (T)(img)(_p2##x,_n8##y,z,c), I[466] = (T)(img)(_p1##x,_n8##y,z,c), I[467] = (T)(img)(x,_n8##y,z,c), I[468] = (T)(img)(_n1##x,_n8##y,z,c), I[469] = (T)(img)(_n2##x,_n8##y,z,c), I[470] = (T)(img)(_n3##x,_n8##y,z,c), I[471] = (T)(img)(_n4##x,_n8##y,z,c), I[472] = (T)(img)(_n5##x,_n8##y,z,c), I[473] = (T)(img)(_n6##x,_n8##y,z,c), I[474] = (T)(img)(_n7##x,_n8##y,z,c), I[475] = (T)(img)(_n8##x,_n8##y,z,c), I[476] = (T)(img)(_n9##x,_n8##y,z,c), I[477] = (T)(img)(_n10##x,_n8##y,z,c), I[478] = (T)(img)(_n11##x,_n8##y,z,c), I[479] = (T)(img)(_n12##x,_n8##y,z,c), \
 I[480] = (T)(img)(_p11##x,_n9##y,z,c), I[481] = (T)(img)(_p10##x,_n9##y,z,c), I[482] = (T)(img)(_p9##x,_n9##y,z,c), I[483] = (T)(img)(_p8##x,_n9##y,z,c), I[484] = (T)(img)(_p7##x,_n9##y,z,c), I[485] = (T)(img)(_p6##x,_n9##y,z,c), I[486] = (T)(img)(_p5##x,_n9##y,z,c), I[487] = (T)(img)(_p4##x,_n9##y,z,c), I[488] = (T)(img)(_p3##x,_n9##y,z,c), I[489] = (T)(img)(_p2##x,_n9##y,z,c), I[490] = (T)(img)(_p1##x,_n9##y,z,c), I[491] = (T)(img)(x,_n9##y,z,c), I[492] = (T)(img)(_n1##x,_n9##y,z,c), I[493] = (T)(img)(_n2##x,_n9##y,z,c), I[494] = (T)(img)(_n3##x,_n9##y,z,c), I[495] = (T)(img)(_n4##x,_n9##y,z,c), I[496] = (T)(img)(_n5##x,_n9##y,z,c), I[497] = (T)(img)(_n6##x,_n9##y,z,c), I[498] = (T)(img)(_n7##x,_n9##y,z,c), I[499] = (T)(img)(_n8##x,_n9##y,z,c), I[500] = (T)(img)(_n9##x,_n9##y,z,c), I[501] = (T)(img)(_n10##x,_n9##y,z,c), I[502] = (T)(img)(_n11##x,_n9##y,z,c), I[503] = (T)(img)(_n12##x,_n9##y,z,c), \
 I[504] = (T)(img)(_p11##x,_n10##y,z,c), I[505] = (T)(img)(_p10##x,_n10##y,z,c), I[506] = (T)(img)(_p9##x,_n10##y,z,c), I[507] = (T)(img)(_p8##x,_n10##y,z,c), I[508] = (T)(img)(_p7##x,_n10##y,z,c), I[509] = (T)(img)(_p6##x,_n10##y,z,c), I[510] = (T)(img)(_p5##x,_n10##y,z,c), I[511] = (T)(img)(_p4##x,_n10##y,z,c), I[512] = (T)(img)(_p3##x,_n10##y,z,c), I[513] = (T)(img)(_p2##x,_n10##y,z,c), I[514] = (T)(img)(_p1##x,_n10##y,z,c), I[515] = (T)(img)(x,_n10##y,z,c), I[516] = (T)(img)(_n1##x,_n10##y,z,c), I[517] = (T)(img)(_n2##x,_n10##y,z,c), I[518] = (T)(img)(_n3##x,_n10##y,z,c), I[519] = (T)(img)(_n4##x,_n10##y,z,c), I[520] = (T)(img)(_n5##x,_n10##y,z,c), I[521] = (T)(img)(_n6##x,_n10##y,z,c), I[522] = (T)(img)(_n7##x,_n10##y,z,c), I[523] = (T)(img)(_n8##x,_n10##y,z,c), I[524] = (T)(img)(_n9##x,_n10##y,z,c), I[525] = (T)(img)(_n10##x,_n10##y,z,c), I[526] = (T)(img)(_n11##x,_n10##y,z,c), I[527] = (T)(img)(_n12##x,_n10##y,z,c), \
 I[528] = (T)(img)(_p11##x,_n11##y,z,c), I[529] = (T)(img)(_p10##x,_n11##y,z,c), I[530] = (T)(img)(_p9##x,_n11##y,z,c), I[531] = (T)(img)(_p8##x,_n11##y,z,c), I[532] = (T)(img)(_p7##x,_n11##y,z,c), I[533] = (T)(img)(_p6##x,_n11##y,z,c), I[534] = (T)(img)(_p5##x,_n11##y,z,c), I[535] = (T)(img)(_p4##x,_n11##y,z,c), I[536] = (T)(img)(_p3##x,_n11##y,z,c), I[537] = (T)(img)(_p2##x,_n11##y,z,c), I[538] = (T)(img)(_p1##x,_n11##y,z,c), I[539] = (T)(img)(x,_n11##y,z,c), I[540] = (T)(img)(_n1##x,_n11##y,z,c), I[541] = (T)(img)(_n2##x,_n11##y,z,c), I[542] = (T)(img)(_n3##x,_n11##y,z,c), I[543] = (T)(img)(_n4##x,_n11##y,z,c), I[544] = (T)(img)(_n5##x,_n11##y,z,c), I[545] = (T)(img)(_n6##x,_n11##y,z,c), I[546] = (T)(img)(_n7##x,_n11##y,z,c), I[547] = (T)(img)(_n8##x,_n11##y,z,c), I[548] = (T)(img)(_n9##x,_n11##y,z,c), I[549] = (T)(img)(_n10##x,_n11##y,z,c), I[550] = (T)(img)(_n11##x,_n11##y,z,c), I[551] = (T)(img)(_n12##x,_n11##y,z,c), \
 I[552] = (T)(img)(_p11##x,_n12##y,z,c), I[553] = (T)(img)(_p10##x,_n12##y,z,c), I[554] = (T)(img)(_p9##x,_n12##y,z,c), I[555] = (T)(img)(_p8##x,_n12##y,z,c), I[556] = (T)(img)(_p7##x,_n12##y,z,c), I[557] = (T)(img)(_p6##x,_n12##y,z,c), I[558] = (T)(img)(_p5##x,_n12##y,z,c), I[559] = (T)(img)(_p4##x,_n12##y,z,c), I[560] = (T)(img)(_p3##x,_n12##y,z,c), I[561] = (T)(img)(_p2##x,_n12##y,z,c), I[562] = (T)(img)(_p1##x,_n12##y,z,c), I[563] = (T)(img)(x,_n12##y,z,c), I[564] = (T)(img)(_n1##x,_n12##y,z,c), I[565] = (T)(img)(_n2##x,_n12##y,z,c), I[566] = (T)(img)(_n3##x,_n12##y,z,c), I[567] = (T)(img)(_n4##x,_n12##y,z,c), I[568] = (T)(img)(_n5##x,_n12##y,z,c), I[569] = (T)(img)(_n6##x,_n12##y,z,c), I[570] = (T)(img)(_n7##x,_n12##y,z,c), I[571] = (T)(img)(_n8##x,_n12##y,z,c), I[572] = (T)(img)(_n9##x,_n12##y,z,c), I[573] = (T)(img)(_n10##x,_n12##y,z,c), I[574] = (T)(img)(_n11##x,_n12##y,z,c), I[575] = (T)(img)(_n12##x,_n12##y,z,c);

// Define 25x25 loop macros
//-------------------------
#define cimg_for25(bound,i) for (int i = 0, \
 _p12##i = 0, _p11##i = 0, _p10##i = 0, _p9##i = 0, _p8##i = 0, _p7##i = 0, _p6##i = 0, _p5##i = 0, _p4##i = 0, _p3##i = 0, _p2##i = 0, _p1##i = 0, \
 _n1##i = 1>=(int)(bound)?(int)(bound)-1:1, \
 _n2##i = 2>=(int)(bound)?(int)(bound)-1:2, \
 _n3##i = 3>=(int)(bound)?(int)(bound)-1:3, \
 _n4##i = 4>=(int)(bound)?(int)(bound)-1:4, \
 _n5##i = 5>=(int)(bound)?(int)(bound)-1:5, \
 _n6##i = 6>=(int)(bound)?(int)(bound)-1:6, \
 _n7##i = 7>=(int)(bound)?(int)(bound)-1:7, \
 _n8##i = 8>=(int)(bound)?(int)(bound)-1:8, \
 _n9##i = 9>=(int)(bound)?(int)(bound)-1:9, \
 _n10##i = 10>=(int)(bound)?(int)(bound)-1:10, \
 _n11##i = 11>=(int)(bound)?(int)(bound)-1:11, \
 _n12##i = 12>=(int)(bound)?(int)(bound)-1:12; \
 _n12##i<(int)(bound) || _n11##i==--_n12##i || _n10##i==--_n11##i || _n9##i==--_n10##i || _n8##i==--_n9##i || _n7##i==--_n8##i || _n6##i==--_n7##i || _n5##i==--_n6##i || _n4##i==--_n5##i || _n3##i==--_n4##i || _n2##i==--_n3##i || _n1##i==--_n2##i || \
 i==(_n12##i = _n11##i = _n10##i = _n9##i = _n8##i = _n7##i = _n6##i = _n5##i = _n4##i = _n3##i = _n2##i = --_n1##i); \
 _p12##i = _p11##i, _p11##i = _p10##i, _p10##i = _p9##i, _p9##i = _p8##i, _p8##i = _p7##i, _p7##i = _p6##i, _p6##i = _p5##i, _p5##i = _p4##i, _p4##i = _p3##i, _p3##i = _p2##i, _p2##i = _p1##i, _p1##i = i++, \
 ++_n1##i, ++_n2##i, ++_n3##i, ++_n4##i, ++_n5##i, ++_n6##i, ++_n7##i, ++_n8##i, ++_n9##i, ++_n10##i, ++_n11##i, ++_n12##i)

#define cimg_for25X(img,x) cimg_for25((img)._width,x)
#define cimg_for25Y(img,y) cimg_for25((img)._height,y)
#define cimg_for25Z(img,z) cimg_for25((img)._depth,z)
#define cimg_for25C(img,c) cimg_for25((img)._spectrum,c)
#define cimg_for25XY(img,x,y) cimg_for25Y(img,y) cimg_for25X(img,x)
#define cimg_for25XZ(img,x,z) cimg_for25Z(img,z) cimg_for25X(img,x)
#define cimg_for25XC(img,x,c) cimg_for25C(img,c) cimg_for25X(img,x)
#define cimg_for25YZ(img,y,z) cimg_for25Z(img,z) cimg_for25Y(img,y)
#define cimg_for25YC(img,y,c) cimg_for25C(img,c) cimg_for25Y(img,y)
#define cimg_for25ZC(img,z,c) cimg_for25C(img,c) cimg_for25Z(img,z)
#define cimg_for25XYZ(img,x,y,z) cimg_for25Z(img,z) cimg_for25XY(img,x,y)
#define cimg_for25XZC(img,x,z,c) cimg_for25C(img,c) cimg_for25XZ(img,x,z)
#define cimg_for25YZC(img,y,z,c) cimg_for25C(img,c) cimg_for25YZ(img,y,z)
#define cimg_for25XYZC(img,x,y,z,c) cimg_for25C(img,c) cimg_for25XYZ(img,x,y,z)

#define cimg_for_in25(bound,i0,i1,i) for (int i = (int)(i0)<0?0:(int)(i0), \
 _p12##i = i-12<0?0:i-12, \
 _p11##i = i-11<0?0:i-11, \
 _p10##i = i-10<0?0:i-10, \
 _p9##i = i-9<0?0:i-9, \
 _p8##i = i-8<0?0:i-8, \
 _p7##i = i-7<0?0:i-7, \
 _p6##i = i-6<0?0:i-6, \
 _p5##i = i-5<0?0:i-5, \
 _p4##i = i-4<0?0:i-4, \
 _p3##i = i-3<0?0:i-3, \
 _p2##i = i-2<0?0:i-2, \
 _p1##i = i-1<0?0:i-1, \
 _n1##i = i+1>=(int)(bound)?(int)(bound)-1:i+1, \
 _n2##i = i+2>=(int)(bound)?(int)(bound)-1:i+2, \
 _n3##i = i+3>=(int)(bound)?(int)(bound)-1:i+3, \
 _n4##i = i+4>=(int)(bound)?(int)(bound)-1:i+4, \
 _n5##i = i+5>=(int)(bound)?(int)(bound)-1:i+5, \
 _n6##i = i+6>=(int)(bound)?(int)(bound)-1:i+6, \
 _n7##i = i+7>=(int)(bound)?(int)(bound)-1:i+7, \
 _n8##i = i+8>=(int)(bound)?(int)(bound)-1:i+8, \
 _n9##i = i+9>=(int)(bound)?(int)(bound)-1:i+9, \
 _n10##i = i+10>=(int)(bound)?(int)(bound)-1:i+10, \
 _n11##i = i+11>=(int)(bound)?(int)(bound)-1:i+11, \
 _n12##i = i+12>=(int)(bound)?(int)(bound)-1:i+12; \
 i<=(int)(i1) && (_n12##i<(int)(bound) || _n11##i==--_n12##i || _n10##i==--_n11##i || _n9##i==--_n10##i || _n8##i==--_n9##i || _n7##i==--_n8##i || _n6##i==--_n7##i || _n5##i==--_n6##i || _n4##i==--_n5##i || _n3##i==--_n4##i || _n2##i==--_n3##i || _n1##i==--_n2##i || \
 i==(_n12##i = _n11##i = _n10##i = _n9##i = _n8##i = _n7##i = _n6##i = _n5##i = _n4##i = _n3##i = _n2##i = --_n1##i)); \
 _p12##i = _p11##i, _p11##i = _p10##i, _p10##i = _p9##i, _p9##i = _p8##i, _p8##i = _p7##i, _p7##i = _p6##i, _p6##i = _p5##i, _p5##i = _p4##i, _p4##i = _p3##i, _p3##i = _p2##i, _p2##i = _p1##i, _p1##i = i++, \
 ++_n1##i, ++_n2##i, ++_n3##i, ++_n4##i, ++_n5##i, ++_n6##i, ++_n7##i, ++_n8##i, ++_n9##i, ++_n10##i, ++_n11##i, ++_n12##i)

#define cimg_for_in25X(img,x0,x1,x) cimg_for_in25((img)._width,x0,x1,x)
#define cimg_for_in25Y(img,y0,y1,y) cimg_for_in25((img)._height,y0,y1,y)
#define cimg_for_in25Z(img,z0,z1,z) cimg_for_in25((img)._depth,z0,z1,z)
#define cimg_for_in25C(img,c0,c1,c) cimg_for_in25((img)._spectrum,c0,c1,c)
#define cimg_for_in25XY(img,x0,y0,x1,y1,x,y) cimg_for_in25Y(img,y0,y1,y) cimg_for_in25X(img,x0,x1,x)
#define cimg_for_in25XZ(img,x0,z0,x1,z1,x,z) cimg_for_in25Z(img,z0,z1,z) cimg_for_in25X(img,x0,x1,x)
#define cimg_for_in25XC(img,x0,c0,x1,c1,x,c) cimg_for_in25C(img,c0,c1,c) cimg_for_in25X(img,x0,x1,x)
#define cimg_for_in25YZ(img,y0,z0,y1,z1,y,z) cimg_for_in25Z(img,z0,z1,z) cimg_for_in25Y(img,y0,y1,y)
#define cimg_for_in25YC(img,y0,c0,y1,c1,y,c) cimg_for_in25C(img,c0,c1,c) cimg_for_in25Y(img,y0,y1,y)
#define cimg_for_in25ZC(img,z0,c0,z1,c1,z,c) cimg_for_in25C(img,c0,c1,c) cimg_for_in25Z(img,z0,z1,z)
#define cimg_for_in25XYZ(img,x0,y0,z0,x1,y1,z1,x,y,z) cimg_for_in25Z(img,z0,z1,z) cimg_for_in25XY(img,x0,y0,x1,y1,x,y)
#define cimg_for_in25XZC(img,x0,z0,c0,x1,y1,c1,x,z,c) cimg_for_in25C(img,c0,c1,c) cimg_for_in25XZ(img,x0,y0,x1,y1,x,z)
#define cimg_for_in25YZC(img,y0,z0,c0,y1,z1,c1,y,z,c) cimg_for_in25C(img,c0,c1,c) cimg_for_in25YZ(img,y0,z0,y1,z1,y,z)
#define cimg_for_in25XYZC(img,x0,y0,z0,c0,x1,y1,z1,c1,x,y,z,c) cimg_for_in25C(img,c0,c1,c) cimg_for_in25XYZ(img,x0,y0,z0,x1,y1,z1,x,y,z)

#define cimg_for25x25(img,x,y,z,c,I,T) \
 cimg_for25((img)._height,y) for (int x = 0, \
 _p12##x = 0, _p11##x = 0, _p10##x = 0, _p9##x = 0, _p8##x = 0, _p7##x = 0, _p6##x = 0, _p5##x = 0, _p4##x = 0, _p3##x = 0, _p2##x = 0, _p1##x = 0, \
 _n1##x = 1>=((img)._width)?(img).width()-1:1, \
 _n2##x = 2>=((img)._width)?(img).width()-1:2, \
 _n3##x = 3>=((img)._width)?(img).width()-1:3, \
 _n4##x = 4>=((img)._width)?(img).width()-1:4, \
 _n5##x = 5>=((img)._width)?(img).width()-1:5, \
 _n6##x = 6>=((img)._width)?(img).width()-1:6, \
 _n7##x = 7>=((img)._width)?(img).width()-1:7, \
 _n8##x = 8>=((img)._width)?(img).width()-1:8, \
 _n9##x = 9>=((img)._width)?(img).width()-1:9, \
 _n10##x = 10>=((img)._width)?(img).width()-1:10, \
 _n11##x = 11>=((img)._width)?(img).width()-1:11, \
 _n12##x = (int)( \
 (I[0] = I[1] = I[2] = I[3] = I[4] = I[5] = I[6] = I[7] = I[8] = I[9] = I[10] = I[11] = I[12] = (T)(img)(0,_p12##y,z,c)), \
 (I[25] = I[26] = I[27] = I[28] = I[29] = I[30] = I[31] = I[32] = I[33] = I[34] = I[35] = I[36] = I[37] = (T)(img)(0,_p11##y,z,c)), \
 (I[50] = I[51] = I[52] = I[53] = I[54] = I[55] = I[56] = I[57] = I[58] = I[59] = I[60] = I[61] = I[62] = (T)(img)(0,_p10##y,z,c)), \
 (I[75] = I[76] = I[77] = I[78] = I[79] = I[80] = I[81] = I[82] = I[83] = I[84] = I[85] = I[86] = I[87] = (T)(img)(0,_p9##y,z,c)), \
 (I[100] = I[101] = I[102] = I[103] = I[104] = I[105] = I[106] = I[107] = I[108] = I[109] = I[110] = I[111] = I[112] = (T)(img)(0,_p8##y,z,c)), \
 (I[125] = I[126] = I[127] = I[128] = I[129] = I[130] = I[131] = I[132] = I[133] = I[134] = I[135] = I[136] = I[137] = (T)(img)(0,_p7##y,z,c)), \
 (I[150] = I[151] = I[152] = I[153] = I[154] = I[155] = I[156] = I[157] = I[158] = I[159] = I[160] = I[161] = I[162] = (T)(img)(0,_p6##y,z,c)), \
 (I[175] = I[176] = I[177] = I[178] = I[179] = I[180] = I[181] = I[182] = I[183] = I[184] = I[185] = I[186] = I[187] = (T)(img)(0,_p5##y,z,c)), \
 (I[200] = I[201] = I[202] = I[203] = I[204] = I[205] = I[206] = I[207] = I[208] = I[209] = I[210] = I[211] = I[212] = (T)(img)(0,_p4##y,z,c)), \
 (I[225] = I[226] = I[227] = I[228] = I[229] = I[230] = I[231] = I[232] = I[233] = I[234] = I[235] = I[236] = I[237] = (T)(img)(0,_p3##y,z,c)), \
 (I[250] = I[251] = I[252] = I[253] = I[254] = I[255] = I[256] = I[257] = I[258] = I[259] = I[260] = I[261] = I[262] = (T)(img)(0,_p2##y,z,c)), \
 (I[275] = I[276] = I[277] = I[278] = I[279] = I[280] = I[281] = I[282] = I[283] = I[284] = I[285] = I[286] = I[287] = (T)(img)(0,_p1##y,z,c)), \
 (I[300] = I[301] = I[302] = I[303] = I[304] = I[305] = I[306] = I[307] = I[308] = I[309] = I[310] = I[311] = I[312] = (T)(img)(0,y,z,c)), \
 (I[325] = I[326] = I[327] = I[328] = I[329] = I[330] = I[331] = I[332] = I[333] = I[334] = I[335] = I[336] = I[337] = (T)(img)(0,_n1##y,z,c)), \
 (I[350] = I[351] = I[352] = I[353] = I[354] = I[355] = I[356] = I[357] = I[358] = I[359] = I[360] = I[361] = I[362] = (T)(img)(0,_n2##y,z,c)), \
 (I[375] = I[376] = I[377] = I[378] = I[379] = I[380] = I[381] = I[382] = I[383] = I[384] = I[385] = I[386] = I[387] = (T)(img)(0,_n3##y,z,c)), \
 (I[400] = I[401] = I[402] = I[403] = I[404] = I[405] = I[406] = I[407] = I[408] = I[409] = I[410] = I[411] = I[412] = (T)(img)(0,_n4##y,z,c)), \
 (I[425] = I[426] = I[427] = I[428] = I[429] = I[430] = I[431] = I[432] = I[433] = I[434] = I[435] = I[436] = I[437] = (T)(img)(0,_n5##y,z,c)), \
 (I[450] = I[451] = I[452] = I[453] = I[454] = I[455] = I[456] = I[457] = I[458] = I[459] = I[460] = I[461] = I[462] = (T)(img)(0,_n6##y,z,c)), \
 (I[475] = I[476] = I[477] = I[478] = I[479] = I[480] = I[481] = I[482] = I[483] = I[484] = I[485] = I[486] = I[487] = (T)(img)(0,_n7##y,z,c)), \
 (I[500] = I[501] = I[502] = I[503] = I[504] = I[505] = I[506] = I[507] = I[508] = I[509] = I[510] = I[511] = I[512] = (T)(img)(0,_n8##y,z,c)), \
 (I[525] = I[526] = I[527] = I[528] = I[529] = I[530] = I[531] = I[532] = I[533] = I[534] = I[535] = I[536] = I[537] = (T)(img)(0,_n9##y,z,c)), \
 (I[550] = I[551] = I[552] = I[553] = I[554] = I[555] = I[556] = I[557] = I[558] = I[559] = I[560] = I[561] = I[562] = (T)(img)(0,_n10##y,z,c)), \
 (I[575] = I[576] = I[577] = I[578] = I[579] = I[580] = I[581] = I[582] = I[583] = I[584] = I[585] = I[586] = I[587] = (T)(img)(0,_n11##y,z,c)), \
 (I[600] = I[601] = I[602] = I[603] = I[604] = I[605] = I[606] = I[607] = I[608] = I[609] = I[610] = I[611] = I[612] = (T)(img)(0,_n12##y,z,c)), \
 (I[13] = (T)(img)(_n1##x,_p12##y,z,c)), \
 (I[38] = (T)(img)(_n1##x,_p11##y,z,c)), \
 (I[63] = (T)(img)(_n1##x,_p10##y,z,c)), \
 (I[88] = (T)(img)(_n1##x,_p9##y,z,c)), \
 (I[113] = (T)(img)(_n1##x,_p8##y,z,c)), \
 (I[138] = (T)(img)(_n1##x,_p7##y,z,c)), \
 (I[163] = (T)(img)(_n1##x,_p6##y,z,c)), \
 (I[188] = (T)(img)(_n1##x,_p5##y,z,c)), \
 (I[213] = (T)(img)(_n1##x,_p4##y,z,c)), \
 (I[238] = (T)(img)(_n1##x,_p3##y,z,c)), \
 (I[263] = (T)(img)(_n1##x,_p2##y,z,c)), \
 (I[288] = (T)(img)(_n1##x,_p1##y,z,c)), \
 (I[313] = (T)(img)(_n1##x,y,z,c)), \
 (I[338] = (T)(img)(_n1##x,_n1##y,z,c)), \
 (I[363] = (T)(img)(_n1##x,_n2##y,z,c)), \
 (I[388] = (T)(img)(_n1##x,_n3##y,z,c)), \
 (I[413] = (T)(img)(_n1##x,_n4##y,z,c)), \
 (I[438] = (T)(img)(_n1##x,_n5##y,z,c)), \
 (I[463] = (T)(img)(_n1##x,_n6##y,z,c)), \
 (I[488] = (T)(img)(_n1##x,_n7##y,z,c)), \
 (I[513] = (T)(img)(_n1##x,_n8##y,z,c)), \
 (I[538] = (T)(img)(_n1##x,_n9##y,z,c)), \
 (I[563] = (T)(img)(_n1##x,_n10##y,z,c)), \
 (I[588] = (T)(img)(_n1##x,_n11##y,z,c)), \
 (I[613] = (T)(img)(_n1##x,_n12##y,z,c)), \
 (I[14] = (T)(img)(_n2##x,_p12##y,z,c)), \
 (I[39] = (T)(img)(_n2##x,_p11##y,z,c)), \
 (I[64] = (T)(img)(_n2##x,_p10##y,z,c)), \
 (I[89] = (T)(img)(_n2##x,_p9##y,z,c)), \
 (I[114] = (T)(img)(_n2##x,_p8##y,z,c)), \
 (I[139] = (T)(img)(_n2##x,_p7##y,z,c)), \
 (I[164] = (T)(img)(_n2##x,_p6##y,z,c)), \
 (I[189] = (T)(img)(_n2##x,_p5##y,z,c)), \
 (I[214] = (T)(img)(_n2##x,_p4##y,z,c)), \
 (I[239] = (T)(img)(_n2##x,_p3##y,z,c)), \
 (I[264] = (T)(img)(_n2##x,_p2##y,z,c)), \
 (I[289] = (T)(img)(_n2##x,_p1##y,z,c)), \
 (I[314] = (T)(img)(_n2##x,y,z,c)), \
 (I[339] = (T)(img)(_n2##x,_n1##y,z,c)), \
 (I[364] = (T)(img)(_n2##x,_n2##y,z,c)), \
 (I[389] = (T)(img)(_n2##x,_n3##y,z,c)), \
 (I[414] = (T)(img)(_n2##x,_n4##y,z,c)), \
 (I[439] = (T)(img)(_n2##x,_n5##y,z,c)), \
 (I[464] = (T)(img)(_n2##x,_n6##y,z,c)), \
 (I[489] = (T)(img)(_n2##x,_n7##y,z,c)), \
 (I[514] = (T)(img)(_n2##x,_n8##y,z,c)), \
 (I[539] = (T)(img)(_n2##x,_n9##y,z,c)), \
 (I[564] = (T)(img)(_n2##x,_n10##y,z,c)), \
 (I[589] = (T)(img)(_n2##x,_n11##y,z,c)), \
 (I[614] = (T)(img)(_n2##x,_n12##y,z,c)), \
 (I[15] = (T)(img)(_n3##x,_p12##y,z,c)), \
 (I[40] = (T)(img)(_n3##x,_p11##y,z,c)), \
 (I[65] = (T)(img)(_n3##x,_p10##y,z,c)), \
 (I[90] = (T)(img)(_n3##x,_p9##y,z,c)), \
 (I[115] = (T)(img)(_n3##x,_p8##y,z,c)), \
 (I[140] = (T)(img)(_n3##x,_p7##y,z,c)), \
 (I[165] = (T)(img)(_n3##x,_p6##y,z,c)), \
 (I[190] = (T)(img)(_n3##x,_p5##y,z,c)), \
 (I[215] = (T)(img)(_n3##x,_p4##y,z,c)), \
 (I[240] = (T)(img)(_n3##x,_p3##y,z,c)), \
 (I[265] = (T)(img)(_n3##x,_p2##y,z,c)), \
 (I[290] = (T)(img)(_n3##x,_p1##y,z,c)), \
 (I[315] = (T)(img)(_n3##x,y,z,c)), \
 (I[340] = (T)(img)(_n3##x,_n1##y,z,c)), \
 (I[365] = (T)(img)(_n3##x,_n2##y,z,c)), \
 (I[390] = (T)(img)(_n3##x,_n3##y,z,c)), \
 (I[415] = (T)(img)(_n3##x,_n4##y,z,c)), \
 (I[440] = (T)(img)(_n3##x,_n5##y,z,c)), \
 (I[465] = (T)(img)(_n3##x,_n6##y,z,c)), \
 (I[490] = (T)(img)(_n3##x,_n7##y,z,c)), \
 (I[515] = (T)(img)(_n3##x,_n8##y,z,c)), \
 (I[540] = (T)(img)(_n3##x,_n9##y,z,c)), \
 (I[565] = (T)(img)(_n3##x,_n10##y,z,c)), \
 (I[590] = (T)(img)(_n3##x,_n11##y,z,c)), \
 (I[615] = (T)(img)(_n3##x,_n12##y,z,c)), \
 (I[16] = (T)(img)(_n4##x,_p12##y,z,c)), \
 (I[41] = (T)(img)(_n4##x,_p11##y,z,c)), \
 (I[66] = (T)(img)(_n4##x,_p10##y,z,c)), \
 (I[91] = (T)(img)(_n4##x,_p9##y,z,c)), \
 (I[116] = (T)(img)(_n4##x,_p8##y,z,c)), \
 (I[141] = (T)(img)(_n4##x,_p7##y,z,c)), \
 (I[166] = (T)(img)(_n4##x,_p6##y,z,c)), \
 (I[191] = (T)(img)(_n4##x,_p5##y,z,c)), \
 (I[216] = (T)(img)(_n4##x,_p4##y,z,c)), \
 (I[241] = (T)(img)(_n4##x,_p3##y,z,c)), \
 (I[266] = (T)(img)(_n4##x,_p2##y,z,c)), \
 (I[291] = (T)(img)(_n4##x,_p1##y,z,c)), \
 (I[316] = (T)(img)(_n4##x,y,z,c)), \
 (I[341] = (T)(img)(_n4##x,_n1##y,z,c)), \
 (I[366] = (T)(img)(_n4##x,_n2##y,z,c)), \
 (I[391] = (T)(img)(_n4##x,_n3##y,z,c)), \
 (I[416] = (T)(img)(_n4##x,_n4##y,z,c)), \
 (I[441] = (T)(img)(_n4##x,_n5##y,z,c)), \
 (I[466] = (T)(img)(_n4##x,_n6##y,z,c)), \
 (I[491] = (T)(img)(_n4##x,_n7##y,z,c)), \
 (I[516] = (T)(img)(_n4##x,_n8##y,z,c)), \
 (I[541] = (T)(img)(_n4##x,_n9##y,z,c)), \
 (I[566] = (T)(img)(_n4##x,_n10##y,z,c)), \
 (I[591] = (T)(img)(_n4##x,_n11##y,z,c)), \
 (I[616] = (T)(img)(_n4##x,_n12##y,z,c)), \
 (I[17] = (T)(img)(_n5##x,_p12##y,z,c)), \
 (I[42] = (T)(img)(_n5##x,_p11##y,z,c)), \
 (I[67] = (T)(img)(_n5##x,_p10##y,z,c)), \
 (I[92] = (T)(img)(_n5##x,_p9##y,z,c)), \
 (I[117] = (T)(img)(_n5##x,_p8##y,z,c)), \
 (I[142] = (T)(img)(_n5##x,_p7##y,z,c)), \
 (I[167] = (T)(img)(_n5##x,_p6##y,z,c)), \
 (I[192] = (T)(img)(_n5##x,_p5##y,z,c)), \
 (I[217] = (T)(img)(_n5##x,_p4##y,z,c)), \
 (I[242] = (T)(img)(_n5##x,_p3##y,z,c)), \
 (I[267] = (T)(img)(_n5##x,_p2##y,z,c)), \
 (I[292] = (T)(img)(_n5##x,_p1##y,z,c)), \
 (I[317] = (T)(img)(_n5##x,y,z,c)), \
 (I[342] = (T)(img)(_n5##x,_n1##y,z,c)), \
 (I[367] = (T)(img)(_n5##x,_n2##y,z,c)), \
 (I[392] = (T)(img)(_n5##x,_n3##y,z,c)), \
 (I[417] = (T)(img)(_n5##x,_n4##y,z,c)), \
 (I[442] = (T)(img)(_n5##x,_n5##y,z,c)), \
 (I[467] = (T)(img)(_n5##x,_n6##y,z,c)), \
 (I[492] = (T)(img)(_n5##x,_n7##y,z,c)), \
 (I[517] = (T)(img)(_n5##x,_n8##y,z,c)), \
 (I[542] = (T)(img)(_n5##x,_n9##y,z,c)), \
 (I[567] = (T)(img)(_n5##x,_n10##y,z,c)), \
 (I[592] = (T)(img)(_n5##x,_n11##y,z,c)), \
 (I[617] = (T)(img)(_n5##x,_n12##y,z,c)), \
 (I[18] = (T)(img)(_n6##x,_p12##y,z,c)), \
 (I[43] = (T)(img)(_n6##x,_p11##y,z,c)), \
 (I[68] = (T)(img)(_n6##x,_p10##y,z,c)), \
 (I[93] = (T)(img)(_n6##x,_p9##y,z,c)), \
 (I[118] = (T)(img)(_n6##x,_p8##y,z,c)), \
 (I[143] = (T)(img)(_n6##x,_p7##y,z,c)), \
 (I[168] = (T)(img)(_n6##x,_p6##y,z,c)), \
 (I[193] = (T)(img)(_n6##x,_p5##y,z,c)), \
 (I[218] = (T)(img)(_n6##x,_p4##y,z,c)), \
 (I[243] = (T)(img)(_n6##x,_p3##y,z,c)), \
 (I[268] = (T)(img)(_n6##x,_p2##y,z,c)), \
 (I[293] = (T)(img)(_n6##x,_p1##y,z,c)), \
 (I[318] = (T)(img)(_n6##x,y,z,c)), \
 (I[343] = (T)(img)(_n6##x,_n1##y,z,c)), \
 (I[368] = (T)(img)(_n6##x,_n2##y,z,c)), \
 (I[393] = (T)(img)(_n6##x,_n3##y,z,c)), \
 (I[418] = (T)(img)(_n6##x,_n4##y,z,c)), \
 (I[443] = (T)(img)(_n6##x,_n5##y,z,c)), \
 (I[468] = (T)(img)(_n6##x,_n6##y,z,c)), \
 (I[493] = (T)(img)(_n6##x,_n7##y,z,c)), \
 (I[518] = (T)(img)(_n6##x,_n8##y,z,c)), \
 (I[543] = (T)(img)(_n6##x,_n9##y,z,c)), \
 (I[568] = (T)(img)(_n6##x,_n10##y,z,c)), \
 (I[593] = (T)(img)(_n6##x,_n11##y,z,c)), \
 (I[618] = (T)(img)(_n6##x,_n12##y,z,c)), \
 (I[19] = (T)(img)(_n7##x,_p12##y,z,c)), \
 (I[44] = (T)(img)(_n7##x,_p11##y,z,c)), \
 (I[69] = (T)(img)(_n7##x,_p10##y,z,c)), \
 (I[94] = (T)(img)(_n7##x,_p9##y,z,c)), \
 (I[119] = (T)(img)(_n7##x,_p8##y,z,c)), \
 (I[144] = (T)(img)(_n7##x,_p7##y,z,c)), \
 (I[169] = (T)(img)(_n7##x,_p6##y,z,c)), \
 (I[194] = (T)(img)(_n7##x,_p5##y,z,c)), \
 (I[219] = (T)(img)(_n7##x,_p4##y,z,c)), \
 (I[244] = (T)(img)(_n7##x,_p3##y,z,c)), \
 (I[269] = (T)(img)(_n7##x,_p2##y,z,c)), \
 (I[294] = (T)(img)(_n7##x,_p1##y,z,c)), \
 (I[319] = (T)(img)(_n7##x,y,z,c)), \
 (I[344] = (T)(img)(_n7##x,_n1##y,z,c)), \
 (I[369] = (T)(img)(_n7##x,_n2##y,z,c)), \
 (I[394] = (T)(img)(_n7##x,_n3##y,z,c)), \
 (I[419] = (T)(img)(_n7##x,_n4##y,z,c)), \
 (I[444] = (T)(img)(_n7##x,_n5##y,z,c)), \
 (I[469] = (T)(img)(_n7##x,_n6##y,z,c)), \
 (I[494] = (T)(img)(_n7##x,_n7##y,z,c)), \
 (I[519] = (T)(img)(_n7##x,_n8##y,z,c)), \
 (I[544] = (T)(img)(_n7##x,_n9##y,z,c)), \
 (I[569] = (T)(img)(_n7##x,_n10##y,z,c)), \
 (I[594] = (T)(img)(_n7##x,_n11##y,z,c)), \
 (I[619] = (T)(img)(_n7##x,_n12##y,z,c)), \
 (I[20] = (T)(img)(_n8##x,_p12##y,z,c)), \
 (I[45] = (T)(img)(_n8##x,_p11##y,z,c)), \
 (I[70] = (T)(img)(_n8##x,_p10##y,z,c)), \
 (I[95] = (T)(img)(_n8##x,_p9##y,z,c)), \
 (I[120] = (T)(img)(_n8##x,_p8##y,z,c)), \
 (I[145] = (T)(img)(_n8##x,_p7##y,z,c)), \
 (I[170] = (T)(img)(_n8##x,_p6##y,z,c)), \
 (I[195] = (T)(img)(_n8##x,_p5##y,z,c)), \
 (I[220] = (T)(img)(_n8##x,_p4##y,z,c)), \
 (I[245] = (T)(img)(_n8##x,_p3##y,z,c)), \
 (I[270] = (T)(img)(_n8##x,_p2##y,z,c)), \
 (I[295] = (T)(img)(_n8##x,_p1##y,z,c)), \
 (I[320] = (T)(img)(_n8##x,y,z,c)), \
 (I[345] = (T)(img)(_n8##x,_n1##y,z,c)), \
 (I[370] = (T)(img)(_n8##x,_n2##y,z,c)), \
 (I[395] = (T)(img)(_n8##x,_n3##y,z,c)), \
 (I[420] = (T)(img)(_n8##x,_n4##y,z,c)), \
 (I[445] = (T)(img)(_n8##x,_n5##y,z,c)), \
 (I[470] = (T)(img)(_n8##x,_n6##y,z,c)), \
 (I[495] = (T)(img)(_n8##x,_n7##y,z,c)), \
 (I[520] = (T)(img)(_n8##x,_n8##y,z,c)), \
 (I[545] = (T)(img)(_n8##x,_n9##y,z,c)), \
 (I[570] = (T)(img)(_n8##x,_n10##y,z,c)), \
 (I[595] = (T)(img)(_n8##x,_n11##y,z,c)), \
 (I[620] = (T)(img)(_n8##x,_n12##y,z,c)), \
 (I[21] = (T)(img)(_n9##x,_p12##y,z,c)), \
 (I[46] = (T)(img)(_n9##x,_p11##y,z,c)), \
 (I[71] = (T)(img)(_n9##x,_p10##y,z,c)), \
 (I[96] = (T)(img)(_n9##x,_p9##y,z,c)), \
 (I[121] = (T)(img)(_n9##x,_p8##y,z,c)), \
 (I[146] = (T)(img)(_n9##x,_p7##y,z,c)), \
 (I[171] = (T)(img)(_n9##x,_p6##y,z,c)), \
 (I[196] = (T)(img)(_n9##x,_p5##y,z,c)), \
 (I[221] = (T)(img)(_n9##x,_p4##y,z,c)), \
 (I[246] = (T)(img)(_n9##x,_p3##y,z,c)), \
 (I[271] = (T)(img)(_n9##x,_p2##y,z,c)), \
 (I[296] = (T)(img)(_n9##x,_p1##y,z,c)), \
 (I[321] = (T)(img)(_n9##x,y,z,c)), \
 (I[346] = (T)(img)(_n9##x,_n1##y,z,c)), \
 (I[371] = (T)(img)(_n9##x,_n2##y,z,c)), \
 (I[396] = (T)(img)(_n9##x,_n3##y,z,c)), \
 (I[421] = (T)(img)(_n9##x,_n4##y,z,c)), \
 (I[446] = (T)(img)(_n9##x,_n5##y,z,c)), \
 (I[471] = (T)(img)(_n9##x,_n6##y,z,c)), \
 (I[496] = (T)(img)(_n9##x,_n7##y,z,c)), \
 (I[521] = (T)(img)(_n9##x,_n8##y,z,c)), \
 (I[546] = (T)(img)(_n9##x,_n9##y,z,c)), \
 (I[571] = (T)(img)(_n9##x,_n10##y,z,c)), \
 (I[596] = (T)(img)(_n9##x,_n11##y,z,c)), \
 (I[621] = (T)(img)(_n9##x,_n12##y,z,c)), \
 (I[22] = (T)(img)(_n10##x,_p12##y,z,c)), \
 (I[47] = (T)(img)(_n10##x,_p11##y,z,c)), \
 (I[72] = (T)(img)(_n10##x,_p10##y,z,c)), \
 (I[97] = (T)(img)(_n10##x,_p9##y,z,c)), \
 (I[122] = (T)(img)(_n10##x,_p8##y,z,c)), \
 (I[147] = (T)(img)(_n10##x,_p7##y,z,c)), \
 (I[172] = (T)(img)(_n10##x,_p6##y,z,c)), \
 (I[197] = (T)(img)(_n10##x,_p5##y,z,c)), \
 (I[222] = (T)(img)(_n10##x,_p4##y,z,c)), \
 (I[247] = (T)(img)(_n10##x,_p3##y,z,c)), \
 (I[272] = (T)(img)(_n10##x,_p2##y,z,c)), \
 (I[297] = (T)(img)(_n10##x,_p1##y,z,c)), \
 (I[322] = (T)(img)(_n10##x,y,z,c)), \
 (I[347] = (T)(img)(_n10##x,_n1##y,z,c)), \
 (I[372] = (T)(img)(_n10##x,_n2##y,z,c)), \
 (I[397] = (T)(img)(_n10##x,_n3##y,z,c)), \
 (I[422] = (T)(img)(_n10##x,_n4##y,z,c)), \
 (I[447] = (T)(img)(_n10##x,_n5##y,z,c)), \
 (I[472] = (T)(img)(_n10##x,_n6##y,z,c)), \
 (I[497] = (T)(img)(_n10##x,_n7##y,z,c)), \
 (I[522] = (T)(img)(_n10##x,_n8##y,z,c)), \
 (I[547] = (T)(img)(_n10##x,_n9##y,z,c)), \
 (I[572] = (T)(img)(_n10##x,_n10##y,z,c)), \
 (I[597] = (T)(img)(_n10##x,_n11##y,z,c)), \
 (I[622] = (T)(img)(_n10##x,_n12##y,z,c)), \
 (I[23] = (T)(img)(_n11##x,_p12##y,z,c)), \
 (I[48] = (T)(img)(_n11##x,_p11##y,z,c)), \
 (I[73] = (T)(img)(_n11##x,_p10##y,z,c)), \
 (I[98] = (T)(img)(_n11##x,_p9##y,z,c)), \
 (I[123] = (T)(img)(_n11##x,_p8##y,z,c)), \
 (I[148] = (T)(img)(_n11##x,_p7##y,z,c)), \
 (I[173] = (T)(img)(_n11##x,_p6##y,z,c)), \
 (I[198] = (T)(img)(_n11##x,_p5##y,z,c)), \
 (I[223] = (T)(img)(_n11##x,_p4##y,z,c)), \
 (I[248] = (T)(img)(_n11##x,_p3##y,z,c)), \
 (I[273] = (T)(img)(_n11##x,_p2##y,z,c)), \
 (I[298] = (T)(img)(_n11##x,_p1##y,z,c)), \
 (I[323] = (T)(img)(_n11##x,y,z,c)), \
 (I[348] = (T)(img)(_n11##x,_n1##y,z,c)), \
 (I[373] = (T)(img)(_n11##x,_n2##y,z,c)), \
 (I[398] = (T)(img)(_n11##x,_n3##y,z,c)), \
 (I[423] = (T)(img)(_n11##x,_n4##y,z,c)), \
 (I[448] = (T)(img)(_n11##x,_n5##y,z,c)), \
 (I[473] = (T)(img)(_n11##x,_n6##y,z,c)), \
 (I[498] = (T)(img)(_n11##x,_n7##y,z,c)), \
 (I[523] = (T)(img)(_n11##x,_n8##y,z,c)), \
 (I[548] = (T)(img)(_n11##x,_n9##y,z,c)), \
 (I[573] = (T)(img)(_n11##x,_n10##y,z,c)), \
 (I[598] = (T)(img)(_n11##x,_n11##y,z,c)), \
 (I[623] = (T)(img)(_n11##x,_n12##y,z,c)), \
 12>=((img)._width)?(img).width()-1:12); \
 (_n12##x<(img).width() && ( \
 (I[24] = (T)(img)(_n12##x,_p12##y,z,c)), \
 (I[49] = (T)(img)(_n12##x,_p11##y,z,c)), \
 (I[74] = (T)(img)(_n12##x,_p10##y,z,c)), \
 (I[99] = (T)(img)(_n12##x,_p9##y,z,c)), \
 (I[124] = (T)(img)(_n12##x,_p8##y,z,c)), \
 (I[149] = (T)(img)(_n12##x,_p7##y,z,c)), \
 (I[174] = (T)(img)(_n12##x,_p6##y,z,c)), \
 (I[199] = (T)(img)(_n12##x,_p5##y,z,c)), \
 (I[224] = (T)(img)(_n12##x,_p4##y,z,c)), \
 (I[249] = (T)(img)(_n12##x,_p3##y,z,c)), \
 (I[274] = (T)(img)(_n12##x,_p2##y,z,c)), \
 (I[299] = (T)(img)(_n12##x,_p1##y,z,c)), \
 (I[324] = (T)(img)(_n12##x,y,z,c)), \
 (I[349] = (T)(img)(_n12##x,_n1##y,z,c)), \
 (I[374] = (T)(img)(_n12##x,_n2##y,z,c)), \
 (I[399] = (T)(img)(_n12##x,_n3##y,z,c)), \
 (I[424] = (T)(img)(_n12##x,_n4##y,z,c)), \
 (I[449] = (T)(img)(_n12##x,_n5##y,z,c)), \
 (I[474] = (T)(img)(_n12##x,_n6##y,z,c)), \
 (I[499] = (T)(img)(_n12##x,_n7##y,z,c)), \
 (I[524] = (T)(img)(_n12##x,_n8##y,z,c)), \
 (I[549] = (T)(img)(_n12##x,_n9##y,z,c)), \
 (I[574] = (T)(img)(_n12##x,_n10##y,z,c)), \
 (I[599] = (T)(img)(_n12##x,_n11##y,z,c)), \
 (I[624] = (T)(img)(_n12##x,_n12##y,z,c)),1)) || \
 _n11##x==--_n12##x || _n10##x==--_n11##x || _n9##x==--_n10##x || _n8##x==--_n9##x || _n7##x==--_n8##x || _n6##x==--_n7##x || _n5##x==--_n6##x || _n4##x==--_n5##x || _n3##x==--_n4##x || _n2##x==--_n3##x || _n1##x==--_n2##x || x==(_n12##x = _n11##x = _n10##x = _n9##x = _n8##x = _n7##x = _n6##x = _n5##x = _n4##x = _n3##x = _n2##x = --_n1##x); \
 I[0] = I[1], I[1] = I[2], I[2] = I[3], I[3] = I[4], I[4] = I[5], I[5] = I[6], I[6] = I[7], I[7] = I[8], I[8] = I[9], I[9] = I[10], I[10] = I[11], I[11] = I[12], I[12] = I[13], I[13] = I[14], I[14] = I[15], I[15] = I[16], I[16] = I[17], I[17] = I[18], I[18] = I[19], I[19] = I[20], I[20] = I[21], I[21] = I[22], I[22] = I[23], I[23] = I[24], \
 I[25] = I[26], I[26] = I[27], I[27] = I[28], I[28] = I[29], I[29] = I[30], I[30] = I[31], I[31] = I[32], I[32] = I[33], I[33] = I[34], I[34] = I[35], I[35] = I[36], I[36] = I[37], I[37] = I[38], I[38] = I[39], I[39] = I[40], I[40] = I[41], I[41] = I[42], I[42] = I[43], I[43] = I[44], I[44] = I[45], I[45] = I[46], I[46] = I[47], I[47] = I[48], I[48] = I[49], \
 I[50] = I[51], I[51] = I[52], I[52] = I[53], I[53] = I[54], I[54] = I[55], I[55] = I[56], I[56] = I[57], I[57] = I[58], I[58] = I[59], I[59] = I[60], I[60] = I[61], I[61] = I[62], I[62] = I[63], I[63] = I[64], I[64] = I[65], I[65] = I[66], I[66] = I[67], I[67] = I[68], I[68] = I[69], I[69] = I[70], I[70] = I[71], I[71] = I[72], I[72] = I[73], I[73] = I[74], \
 I[75] = I[76], I[76] = I[77], I[77] = I[78], I[78] = I[79], I[79] = I[80], I[80] = I[81], I[81] = I[82], I[82] = I[83], I[83] = I[84], I[84] = I[85], I[85] = I[86], I[86] = I[87], I[87] = I[88], I[88] = I[89], I[89] = I[90], I[90] = I[91], I[91] = I[92], I[92] = I[93], I[93] = I[94], I[94] = I[95], I[95] = I[96], I[96] = I[97], I[97] = I[98], I[98] = I[99], \
 I[100] = I[101], I[101] = I[102], I[102] = I[103], I[103] = I[104], I[104] = I[105], I[105] = I[106], I[106] = I[107], I[107] = I[108], I[108] = I[109], I[109] = I[110], I[110] = I[111], I[111] = I[112], I[112] = I[113], I[113] = I[114], I[114] = I[115], I[115] = I[116], I[116] = I[117], I[117] = I[118], I[118] = I[119], I[119] = I[120], I[120] = I[121], I[121] = I[122], I[122] = I[123], I[123] = I[124], \
 I[125] = I[126], I[126] = I[127], I[127] = I[128], I[128] = I[129], I[129] = I[130], I[130] = I[131], I[131] = I[132], I[132] = I[133], I[133] = I[134], I[134] = I[135], I[135] = I[136], I[136] = I[137], I[137] = I[138], I[138] = I[139], I[139] = I[140], I[140] = I[141], I[141] = I[142], I[142] = I[143], I[143] = I[144], I[144] = I[145], I[145] = I[146], I[146] = I[147], I[147] = I[148], I[148] = I[149], \
 I[150] = I[151], I[151] = I[152], I[152] = I[153], I[153] = I[154], I[154] = I[155], I[155] = I[156], I[156] = I[157], I[157] = I[158], I[158] = I[159], I[159] = I[160], I[160] = I[161], I[161] = I[162], I[162] = I[163], I[163] = I[164], I[164] = I[165], I[165] = I[166], I[166] = I[167], I[167] = I[168], I[168] = I[169], I[169] = I[170], I[170] = I[171], I[171] = I[172], I[172] = I[173], I[173] = I[174], \
 I[175] = I[176], I[176] = I[177], I[177] = I[178], I[178] = I[179], I[179] = I[180], I[180] = I[181], I[181] = I[182], I[182] = I[183], I[183] = I[184], I[184] = I[185], I[185] = I[186], I[186] = I[187], I[187] = I[188], I[188] = I[189], I[189] = I[190], I[190] = I[191], I[191] = I[192], I[192] = I[193], I[193] = I[194], I[194] = I[195], I[195] = I[196], I[196] = I[197], I[197] = I[198], I[198] = I[199], \
 I[200] = I[201], I[201] = I[202], I[202] = I[203], I[203] = I[204], I[204] = I[205], I[205] = I[206], I[206] = I[207], I[207] = I[208], I[208] = I[209], I[209] = I[210], I[210] = I[211], I[211] = I[212], I[212] = I[213], I[213] = I[214], I[214] = I[215], I[215] = I[216], I[216] = I[217], I[217] = I[218], I[218] = I[219], I[219] = I[220], I[220] = I[221], I[221] = I[222], I[222] = I[223], I[223] = I[224], \
 I[225] = I[226], I[226] = I[227], I[227] = I[228], I[228] = I[229], I[229] = I[230], I[230] = I[231], I[231] = I[232], I[232] = I[233], I[233] = I[234], I[234] = I[235], I[235] = I[236], I[236] = I[237], I[237] = I[238], I[238] = I[239], I[239] = I[240], I[240] = I[241], I[241] = I[242], I[242] = I[243], I[243] = I[244], I[244] = I[245], I[245] = I[246], I[246] = I[247], I[247] = I[248], I[248] = I[249], \
 I[250] = I[251], I[251] = I[252], I[252] = I[253], I[253] = I[254], I[254] = I[255], I[255] = I[256], I[256] = I[257], I[257] = I[258], I[258] = I[259], I[259] = I[260], I[260] = I[261], I[261] = I[262], I[262] = I[263], I[263] = I[264], I[264] = I[265], I[265] = I[266], I[266] = I[267], I[267] = I[268], I[268] = I[269], I[269] = I[270], I[270] = I[271], I[271] = I[272], I[272] = I[273], I[273] = I[274], \
 I[275] = I[276], I[276] = I[277], I[277] = I[278], I[278] = I[279], I[279] = I[280], I[280] = I[281], I[281] = I[282], I[282] = I[283], I[283] = I[284], I[284] = I[285], I[285] = I[286], I[286] = I[287], I[287] = I[288], I[288] = I[289], I[289] = I[290], I[290] = I[291], I[291] = I[292], I[292] = I[293], I[293] = I[294], I[294] = I[295], I[295] = I[296], I[296] = I[297], I[297] = I[298], I[298] = I[299], \
 I[300] = I[301], I[301] = I[302], I[302] = I[303], I[303] = I[304], I[304] = I[305], I[305] = I[306], I[306] = I[307], I[307] = I[308], I[308] = I[309], I[309] = I[310], I[310] = I[311], I[311] = I[312], I[312] = I[313], I[313] = I[314], I[314] = I[315], I[315] = I[316], I[316] = I[317], I[317] = I[318], I[318] = I[319], I[319] = I[320], I[320] = I[321], I[321] = I[322], I[322] = I[323], I[323] = I[324], \
 I[325] = I[326], I[326] = I[327], I[327] = I[328], I[328] = I[329], I[329] = I[330], I[330] = I[331], I[331] = I[332], I[332] = I[333], I[333] = I[334], I[334] = I[335], I[335] = I[336], I[336] = I[337], I[337] = I[338], I[338] = I[339], I[339] = I[340], I[340] = I[341], I[341] = I[342], I[342] = I[343], I[343] = I[344], I[344] = I[345], I[345] = I[346], I[346] = I[347], I[347] = I[348], I[348] = I[349], \
 I[350] = I[351], I[351] = I[352], I[352] = I[353], I[353] = I[354], I[354] = I[355], I[355] = I[356], I[356] = I[357], I[357] = I[358], I[358] = I[359], I[359] = I[360], I[360] = I[361], I[361] = I[362], I[362] = I[363], I[363] = I[364], I[364] = I[365], I[365] = I[366], I[366] = I[367], I[367] = I[368], I[368] = I[369], I[369] = I[370], I[370] = I[371], I[371] = I[372], I[372] = I[373], I[373] = I[374], \
 I[375] = I[376], I[376] = I[377], I[377] = I[378], I[378] = I[379], I[379] = I[380], I[380] = I[381], I[381] = I[382], I[382] = I[383], I[383] = I[384], I[384] = I[385], I[385] = I[386], I[386] = I[387], I[387] = I[388], I[388] = I[389], I[389] = I[390], I[390] = I[391], I[391] = I[392], I[392] = I[393], I[393] = I[394], I[394] = I[395], I[395] = I[396], I[396] = I[397], I[397] = I[398], I[398] = I[399], \
 I[400] = I[401], I[401] = I[402], I[402] = I[403], I[403] = I[404], I[404] = I[405], I[405] = I[406], I[406] = I[407], I[407] = I[408], I[408] = I[409], I[409] = I[410], I[410] = I[411], I[411] = I[412], I[412] = I[413], I[413] = I[414], I[414] = I[415], I[415] = I[416], I[416] = I[417], I[417] = I[418], I[418] = I[419], I[419] = I[420], I[420] = I[421], I[421] = I[422], I[422] = I[423], I[423] = I[424], \
 I[425] = I[426], I[426] = I[427], I[427] = I[428], I[428] = I[429], I[429] = I[430], I[430] = I[431], I[431] = I[432], I[432] = I[433], I[433] = I[434], I[434] = I[435], I[435] = I[436], I[436] = I[437], I[437] = I[438], I[438] = I[439], I[439] = I[440], I[440] = I[441], I[441] = I[442], I[442] = I[443], I[443] = I[444], I[444] = I[445], I[445] = I[446], I[446] = I[447], I[447] = I[448], I[448] = I[449], \
 I[450] = I[451], I[451] = I[452], I[452] = I[453], I[453] = I[454], I[454] = I[455], I[455] = I[456], I[456] = I[457], I[457] = I[458], I[458] = I[459], I[459] = I[460], I[460] = I[461], I[461] = I[462], I[462] = I[463], I[463] = I[464], I[464] = I[465], I[465] = I[466], I[466] = I[467], I[467] = I[468], I[468] = I[469], I[469] = I[470], I[470] = I[471], I[471] = I[472], I[472] = I[473], I[473] = I[474], \
 I[475] = I[476], I[476] = I[477], I[477] = I[478], I[478] = I[479], I[479] = I[480], I[480] = I[481], I[481] = I[482], I[482] = I[483], I[483] = I[484], I[484] = I[485], I[485] = I[486], I[486] = I[487], I[487] = I[488], I[488] = I[489], I[489] = I[490], I[490] = I[491], I[491] = I[492], I[492] = I[493], I[493] = I[494], I[494] = I[495], I[495] = I[496], I[496] = I[497], I[497] = I[498], I[498] = I[499], \
 I[500] = I[501], I[501] = I[502], I[502] = I[503], I[503] = I[504], I[504] = I[505], I[505] = I[506], I[506] = I[507], I[507] = I[508], I[508] = I[509], I[509] = I[510], I[510] = I[511], I[511] = I[512], I[512] = I[513], I[513] = I[514], I[514] = I[515], I[515] = I[516], I[516] = I[517], I[517] = I[518], I[518] = I[519], I[519] = I[520], I[520] = I[521], I[521] = I[522], I[522] = I[523], I[523] = I[524], \
 I[525] = I[526], I[526] = I[527], I[527] = I[528], I[528] = I[529], I[529] = I[530], I[530] = I[531], I[531] = I[532], I[532] = I[533], I[533] = I[534], I[534] = I[535], I[535] = I[536], I[536] = I[537], I[537] = I[538], I[538] = I[539], I[539] = I[540], I[540] = I[541], I[541] = I[542], I[542] = I[543], I[543] = I[544], I[544] = I[545], I[545] = I[546], I[546] = I[547], I[547] = I[548], I[548] = I[549], \
 I[550] = I[551], I[551] = I[552], I[552] = I[553], I[553] = I[554], I[554] = I[555], I[555] = I[556], I[556] = I[557], I[557] = I[558], I[558] = I[559], I[559] = I[560], I[560] = I[561], I[561] = I[562], I[562] = I[563], I[563] = I[564], I[564] = I[565], I[565] = I[566], I[566] = I[567], I[567] = I[568], I[568] = I[569], I[569] = I[570], I[570] = I[571], I[571] = I[572], I[572] = I[573], I[573] = I[574], \
 I[575] = I[576], I[576] = I[577], I[577] = I[578], I[578] = I[579], I[579] = I[580], I[580] = I[581], I[581] = I[582], I[582] = I[583], I[583] = I[584], I[584] = I[585], I[585] = I[586], I[586] = I[587], I[587] = I[588], I[588] = I[589], I[589] = I[590], I[590] = I[591], I[591] = I[592], I[592] = I[593], I[593] = I[594], I[594] = I[595], I[595] = I[596], I[596] = I[597], I[597] = I[598], I[598] = I[599], \
 I[600] = I[601], I[601] = I[602], I[602] = I[603], I[603] = I[604], I[604] = I[605], I[605] = I[606], I[606] = I[607], I[607] = I[608], I[608] = I[609], I[609] = I[610], I[610] = I[611], I[611] = I[612], I[612] = I[613], I[613] = I[614], I[614] = I[615], I[615] = I[616], I[616] = I[617], I[617] = I[618], I[618] = I[619], I[619] = I[620], I[620] = I[621], I[621] = I[622], I[622] = I[623], I[623] = I[624], \
 _p12##x = _p11##x, _p11##x = _p10##x, _p10##x = _p9##x, _p9##x = _p8##x, _p8##x = _p7##x, _p7##x = _p6##x, _p6##x = _p5##x, _p5##x = _p4##x, _p4##x = _p3##x, _p3##x = _p2##x, _p2##x = _p1##x, _p1##x = x++, ++_n1##x, ++_n2##x, ++_n3##x, ++_n4##x, ++_n5##x, ++_n6##x, ++_n7##x, ++_n8##x, ++_n9##x, ++_n10##x, ++_n11##x, ++_n12##x)

#define cimg_for_in25x25(img,x0,y0,x1,y1,x,y,z,c,I,T) \
 cimg_for_in25((img)._height,y0,y1,y) for (int x = (int)(x0)<0?0:(int)(x0), \
 _p12##x = x-12<0?0:x-12, \
 _p11##x = x-11<0?0:x-11, \
 _p10##x = x-10<0?0:x-10, \
 _p9##x = x-9<0?0:x-9, \
 _p8##x = x-8<0?0:x-8, \
 _p7##x = x-7<0?0:x-7, \
 _p6##x = x-6<0?0:x-6, \
 _p5##x = x-5<0?0:x-5, \
 _p4##x = x-4<0?0:x-4, \
 _p3##x = x-3<0?0:x-3, \
 _p2##x = x-2<0?0:x-2, \
 _p1##x = x-1<0?0:x-1, \
 _n1##x = x+1>=(img).width()?(img).width()-1:x+1, \
 _n2##x = x+2>=(img).width()?(img).width()-1:x+2, \
 _n3##x = x+3>=(img).width()?(img).width()-1:x+3, \
 _n4##x = x+4>=(img).width()?(img).width()-1:x+4, \
 _n5##x = x+5>=(img).width()?(img).width()-1:x+5, \
 _n6##x = x+6>=(img).width()?(img).width()-1:x+6, \
 _n7##x = x+7>=(img).width()?(img).width()-1:x+7, \
 _n8##x = x+8>=(img).width()?(img).width()-1:x+8, \
 _n9##x = x+9>=(img).width()?(img).width()-1:x+9, \
 _n10##x = x+10>=(img).width()?(img).width()-1:x+10, \
 _n11##x = x+11>=(img).width()?(img).width()-1:x+11, \
 _n12##x = (int)( \
 (I[0] = (T)(img)(_p12##x,_p12##y,z,c)), \
 (I[25] = (T)(img)(_p12##x,_p11##y,z,c)), \
 (I[50] = (T)(img)(_p12##x,_p10##y,z,c)), \
 (I[75] = (T)(img)(_p12##x,_p9##y,z,c)), \
 (I[100] = (T)(img)(_p12##x,_p8##y,z,c)), \
 (I[125] = (T)(img)(_p12##x,_p7##y,z,c)), \
 (I[150] = (T)(img)(_p12##x,_p6##y,z,c)), \
 (I[175] = (T)(img)(_p12##x,_p5##y,z,c)), \
 (I[200] = (T)(img)(_p12##x,_p4##y,z,c)), \
 (I[225] = (T)(img)(_p12##x,_p3##y,z,c)), \
 (I[250] = (T)(img)(_p12##x,_p2##y,z,c)), \
 (I[275] = (T)(img)(_p12##x,_p1##y,z,c)), \
 (I[300] = (T)(img)(_p12##x,y,z,c)), \
 (I[325] = (T)(img)(_p12##x,_n1##y,z,c)), \
 (I[350] = (T)(img)(_p12##x,_n2##y,z,c)), \
 (I[375] = (T)(img)(_p12##x,_n3##y,z,c)), \
 (I[400] = (T)(img)(_p12##x,_n4##y,z,c)), \
 (I[425] = (T)(img)(_p12##x,_n5##y,z,c)), \
 (I[450] = (T)(img)(_p12##x,_n6##y,z,c)), \
 (I[475] = (T)(img)(_p12##x,_n7##y,z,c)), \
 (I[500] = (T)(img)(_p12##x,_n8##y,z,c)), \
 (I[525] = (T)(img)(_p12##x,_n9##y,z,c)), \
 (I[550] = (T)(img)(_p12##x,_n10##y,z,c)), \
 (I[575] = (T)(img)(_p12##x,_n11##y,z,c)), \
 (I[600] = (T)(img)(_p12##x,_n12##y,z,c)), \
 (I[1] = (T)(img)(_p11##x,_p12##y,z,c)), \
 (I[26] = (T)(img)(_p11##x,_p11##y,z,c)), \
 (I[51] = (T)(img)(_p11##x,_p10##y,z,c)), \
 (I[76] = (T)(img)(_p11##x,_p9##y,z,c)), \
 (I[101] = (T)(img)(_p11##x,_p8##y,z,c)), \
 (I[126] = (T)(img)(_p11##x,_p7##y,z,c)), \
 (I[151] = (T)(img)(_p11##x,_p6##y,z,c)), \
 (I[176] = (T)(img)(_p11##x,_p5##y,z,c)), \
 (I[201] = (T)(img)(_p11##x,_p4##y,z,c)), \
 (I[226] = (T)(img)(_p11##x,_p3##y,z,c)), \
 (I[251] = (T)(img)(_p11##x,_p2##y,z,c)), \
 (I[276] = (T)(img)(_p11##x,_p1##y,z,c)), \
 (I[301] = (T)(img)(_p11##x,y,z,c)), \
 (I[326] = (T)(img)(_p11##x,_n1##y,z,c)), \
 (I[351] = (T)(img)(_p11##x,_n2##y,z,c)), \
 (I[376] = (T)(img)(_p11##x,_n3##y,z,c)), \
 (I[401] = (T)(img)(_p11##x,_n4##y,z,c)), \
 (I[426] = (T)(img)(_p11##x,_n5##y,z,c)), \
 (I[451] = (T)(img)(_p11##x,_n6##y,z,c)), \
 (I[476] = (T)(img)(_p11##x,_n7##y,z,c)), \
 (I[501] = (T)(img)(_p11##x,_n8##y,z,c)), \
 (I[526] = (T)(img)(_p11##x,_n9##y,z,c)), \
 (I[551] = (T)(img)(_p11##x,_n10##y,z,c)), \
 (I[576] = (T)(img)(_p11##x,_n11##y,z,c)), \
 (I[601] = (T)(img)(_p11##x,_n12##y,z,c)), \
 (I[2] = (T)(img)(_p10##x,_p12##y,z,c)), \
 (I[27] = (T)(img)(_p10##x,_p11##y,z,c)), \
 (I[52] = (T)(img)(_p10##x,_p10##y,z,c)), \
 (I[77] = (T)(img)(_p10##x,_p9##y,z,c)), \
 (I[102] = (T)(img)(_p10##x,_p8##y,z,c)), \
 (I[127] = (T)(img)(_p10##x,_p7##y,z,c)), \
 (I[152] = (T)(img)(_p10##x,_p6##y,z,c)), \
 (I[177] = (T)(img)(_p10##x,_p5##y,z,c)), \
 (I[202] = (T)(img)(_p10##x,_p4##y,z,c)), \
 (I[227] = (T)(img)(_p10##x,_p3##y,z,c)), \
 (I[252] = (T)(img)(_p10##x,_p2##y,z,c)), \
 (I[277] = (T)(img)(_p10##x,_p1##y,z,c)), \
 (I[302] = (T)(img)(_p10##x,y,z,c)), \
 (I[327] = (T)(img)(_p10##x,_n1##y,z,c)), \
 (I[352] = (T)(img)(_p10##x,_n2##y,z,c)), \
 (I[377] = (T)(img)(_p10##x,_n3##y,z,c)), \
 (I[402] = (T)(img)(_p10##x,_n4##y,z,c)), \
 (I[427] = (T)(img)(_p10##x,_n5##y,z,c)), \
 (I[452] = (T)(img)(_p10##x,_n6##y,z,c)), \
 (I[477] = (T)(img)(_p10##x,_n7##y,z,c)), \
 (I[502] = (T)(img)(_p10##x,_n8##y,z,c)), \
 (I[527] = (T)(img)(_p10##x,_n9##y,z,c)), \
 (I[552] = (T)(img)(_p10##x,_n10##y,z,c)), \
 (I[577] = (T)(img)(_p10##x,_n11##y,z,c)), \
 (I[602] = (T)(img)(_p10##x,_n12##y,z,c)), \
 (I[3] = (T)(img)(_p9##x,_p12##y,z,c)), \
 (I[28] = (T)(img)(_p9##x,_p11##y,z,c)), \
 (I[53] = (T)(img)(_p9##x,_p10##y,z,c)), \
 (I[78] = (T)(img)(_p9##x,_p9##y,z,c)), \
 (I[103] = (T)(img)(_p9##x,_p8##y,z,c)), \
 (I[128] = (T)(img)(_p9##x,_p7##y,z,c)), \
 (I[153] = (T)(img)(_p9##x,_p6##y,z,c)), \
 (I[178] = (T)(img)(_p9##x,_p5##y,z,c)), \
 (I[203] = (T)(img)(_p9##x,_p4##y,z,c)), \
 (I[228] = (T)(img)(_p9##x,_p3##y,z,c)), \
 (I[253] = (T)(img)(_p9##x,_p2##y,z,c)), \
 (I[278] = (T)(img)(_p9##x,_p1##y,z,c)), \
 (I[303] = (T)(img)(_p9##x,y,z,c)), \
 (I[328] = (T)(img)(_p9##x,_n1##y,z,c)), \
 (I[353] = (T)(img)(_p9##x,_n2##y,z,c)), \
 (I[378] = (T)(img)(_p9##x,_n3##y,z,c)), \
 (I[403] = (T)(img)(_p9##x,_n4##y,z,c)), \
 (I[428] = (T)(img)(_p9##x,_n5##y,z,c)), \
 (I[453] = (T)(img)(_p9##x,_n6##y,z,c)), \
 (I[478] = (T)(img)(_p9##x,_n7##y,z,c)), \
 (I[503] = (T)(img)(_p9##x,_n8##y,z,c)), \
 (I[528] = (T)(img)(_p9##x,_n9##y,z,c)), \
 (I[553] = (T)(img)(_p9##x,_n10##y,z,c)), \
 (I[578] = (T)(img)(_p9##x,_n11##y,z,c)), \
 (I[603] = (T)(img)(_p9##x,_n12##y,z,c)), \
 (I[4] = (T)(img)(_p8##x,_p12##y,z,c)), \
 (I[29] = (T)(img)(_p8##x,_p11##y,z,c)), \
 (I[54] = (T)(img)(_p8##x,_p10##y,z,c)), \
 (I[79] = (T)(img)(_p8##x,_p9##y,z,c)), \
 (I[104] = (T)(img)(_p8##x,_p8##y,z,c)), \
 (I[129] = (T)(img)(_p8##x,_p7##y,z,c)), \
 (I[154] = (T)(img)(_p8##x,_p6##y,z,c)), \
 (I[179] = (T)(img)(_p8##x,_p5##y,z,c)), \
 (I[204] = (T)(img)(_p8##x,_p4##y,z,c)), \
 (I[229] = (T)(img)(_p8##x,_p3##y,z,c)), \
 (I[254] = (T)(img)(_p8##x,_p2##y,z,c)), \
 (I[279] = (T)(img)(_p8##x,_p1##y,z,c)), \
 (I[304] = (T)(img)(_p8##x,y,z,c)), \
 (I[329] = (T)(img)(_p8##x,_n1##y,z,c)), \
 (I[354] = (T)(img)(_p8##x,_n2##y,z,c)), \
 (I[379] = (T)(img)(_p8##x,_n3##y,z,c)), \
 (I[404] = (T)(img)(_p8##x,_n4##y,z,c)), \
 (I[429] = (T)(img)(_p8##x,_n5##y,z,c)), \
 (I[454] = (T)(img)(_p8##x,_n6##y,z,c)), \
 (I[479] = (T)(img)(_p8##x,_n7##y,z,c)), \
 (I[504] = (T)(img)(_p8##x,_n8##y,z,c)), \
 (I[529] = (T)(img)(_p8##x,_n9##y,z,c)), \
 (I[554] = (T)(img)(_p8##x,_n10##y,z,c)), \
 (I[579] = (T)(img)(_p8##x,_n11##y,z,c)), \
 (I[604] = (T)(img)(_p8##x,_n12##y,z,c)), \
 (I[5] = (T)(img)(_p7##x,_p12##y,z,c)), \
 (I[30] = (T)(img)(_p7##x,_p11##y,z,c)), \
 (I[55] = (T)(img)(_p7##x,_p10##y,z,c)), \
 (I[80] = (T)(img)(_p7##x,_p9##y,z,c)), \
 (I[105] = (T)(img)(_p7##x,_p8##y,z,c)), \
 (I[130] = (T)(img)(_p7##x,_p7##y,z,c)), \
 (I[155] = (T)(img)(_p7##x,_p6##y,z,c)), \
 (I[180] = (T)(img)(_p7##x,_p5##y,z,c)), \
 (I[205] = (T)(img)(_p7##x,_p4##y,z,c)), \
 (I[230] = (T)(img)(_p7##x,_p3##y,z,c)), \
 (I[255] = (T)(img)(_p7##x,_p2##y,z,c)), \
 (I[280] = (T)(img)(_p7##x,_p1##y,z,c)), \
 (I[305] = (T)(img)(_p7##x,y,z,c)), \
 (I[330] = (T)(img)(_p7##x,_n1##y,z,c)), \
 (I[355] = (T)(img)(_p7##x,_n2##y,z,c)), \
 (I[380] = (T)(img)(_p7##x,_n3##y,z,c)), \
 (I[405] = (T)(img)(_p7##x,_n4##y,z,c)), \
 (I[430] = (T)(img)(_p7##x,_n5##y,z,c)), \
 (I[455] = (T)(img)(_p7##x,_n6##y,z,c)), \
 (I[480] = (T)(img)(_p7##x,_n7##y,z,c)), \
 (I[505] = (T)(img)(_p7##x,_n8##y,z,c)), \
 (I[530] = (T)(img)(_p7##x,_n9##y,z,c)), \
 (I[555] = (T)(img)(_p7##x,_n10##y,z,c)), \
 (I[580] = (T)(img)(_p7##x,_n11##y,z,c)), \
 (I[605] = (T)(img)(_p7##x,_n12##y,z,c)), \
 (I[6] = (T)(img)(_p6##x,_p12##y,z,c)), \
 (I[31] = (T)(img)(_p6##x,_p11##y,z,c)), \
 (I[56] = (T)(img)(_p6##x,_p10##y,z,c)), \
 (I[81] = (T)(img)(_p6##x,_p9##y,z,c)), \
 (I[106] = (T)(img)(_p6##x,_p8##y,z,c)), \
 (I[131] = (T)(img)(_p6##x,_p7##y,z,c)), \
 (I[156] = (T)(img)(_p6##x,_p6##y,z,c)), \
 (I[181] = (T)(img)(_p6##x,_p5##y,z,c)), \
 (I[206] = (T)(img)(_p6##x,_p4##y,z,c)), \
 (I[231] = (T)(img)(_p6##x,_p3##y,z,c)), \
 (I[256] = (T)(img)(_p6##x,_p2##y,z,c)), \
 (I[281] = (T)(img)(_p6##x,_p1##y,z,c)), \
 (I[306] = (T)(img)(_p6##x,y,z,c)), \
 (I[331] = (T)(img)(_p6##x,_n1##y,z,c)), \
 (I[356] = (T)(img)(_p6##x,_n2##y,z,c)), \
 (I[381] = (T)(img)(_p6##x,_n3##y,z,c)), \
 (I[406] = (T)(img)(_p6##x,_n4##y,z,c)), \
 (I[431] = (T)(img)(_p6##x,_n5##y,z,c)), \
 (I[456] = (T)(img)(_p6##x,_n6##y,z,c)), \
 (I[481] = (T)(img)(_p6##x,_n7##y,z,c)), \
 (I[506] = (T)(img)(_p6##x,_n8##y,z,c)), \
 (I[531] = (T)(img)(_p6##x,_n9##y,z,c)), \
 (I[556] = (T)(img)(_p6##x,_n10##y,z,c)), \
 (I[581] = (T)(img)(_p6##x,_n11##y,z,c)), \
 (I[606] = (T)(img)(_p6##x,_n12##y,z,c)), \
 (I[7] = (T)(img)(_p5##x,_p12##y,z,c)), \
 (I[32] = (T)(img)(_p5##x,_p11##y,z,c)), \
 (I[57] = (T)(img)(_p5##x,_p10##y,z,c)), \
 (I[82] = (T)(img)(_p5##x,_p9##y,z,c)), \
 (I[107] = (T)(img)(_p5##x,_p8##y,z,c)), \
 (I[132] = (T)(img)(_p5##x,_p7##y,z,c)), \
 (I[157] = (T)(img)(_p5##x,_p6##y,z,c)), \
 (I[182] = (T)(img)(_p5##x,_p5##y,z,c)), \
 (I[207] = (T)(img)(_p5##x,_p4##y,z,c)), \
 (I[232] = (T)(img)(_p5##x,_p3##y,z,c)), \
 (I[257] = (T)(img)(_p5##x,_p2##y,z,c)), \
 (I[282] = (T)(img)(_p5##x,_p1##y,z,c)), \
 (I[307] = (T)(img)(_p5##x,y,z,c)), \
 (I[332] = (T)(img)(_p5##x,_n1##y,z,c)), \
 (I[357] = (T)(img)(_p5##x,_n2##y,z,c)), \
 (I[382] = (T)(img)(_p5##x,_n3##y,z,c)), \
 (I[407] = (T)(img)(_p5##x,_n4##y,z,c)), \
 (I[432] = (T)(img)(_p5##x,_n5##y,z,c)), \
 (I[457] = (T)(img)(_p5##x,_n6##y,z,c)), \
 (I[482] = (T)(img)(_p5##x,_n7##y,z,c)), \
 (I[507] = (T)(img)(_p5##x,_n8##y,z,c)), \
 (I[532] = (T)(img)(_p5##x,_n9##y,z,c)), \
 (I[557] = (T)(img)(_p5##x,_n10##y,z,c)), \
 (I[582] = (T)(img)(_p5##x,_n11##y,z,c)), \
 (I[607] = (T)(img)(_p5##x,_n12##y,z,c)), \
 (I[8] = (T)(img)(_p4##x,_p12##y,z,c)), \
 (I[33] = (T)(img)(_p4##x,_p11##y,z,c)), \
 (I[58] = (T)(img)(_p4##x,_p10##y,z,c)), \
 (I[83] = (T)(img)(_p4##x,_p9##y,z,c)), \
 (I[108] = (T)(img)(_p4##x,_p8##y,z,c)), \
 (I[133] = (T)(img)(_p4##x,_p7##y,z,c)), \
 (I[158] = (T)(img)(_p4##x,_p6##y,z,c)), \
 (I[183] = (T)(img)(_p4##x,_p5##y,z,c)), \
 (I[208] = (T)(img)(_p4##x,_p4##y,z,c)), \
 (I[233] = (T)(img)(_p4##x,_p3##y,z,c)), \
 (I[258] = (T)(img)(_p4##x,_p2##y,z,c)), \
 (I[283] = (T)(img)(_p4##x,_p1##y,z,c)), \
 (I[308] = (T)(img)(_p4##x,y,z,c)), \
 (I[333] = (T)(img)(_p4##x,_n1##y,z,c)), \
 (I[358] = (T)(img)(_p4##x,_n2##y,z,c)), \
 (I[383] = (T)(img)(_p4##x,_n3##y,z,c)), \
 (I[408] = (T)(img)(_p4##x,_n4##y,z,c)), \
 (I[433] = (T)(img)(_p4##x,_n5##y,z,c)), \
 (I[458] = (T)(img)(_p4##x,_n6##y,z,c)), \
 (I[483] = (T)(img)(_p4##x,_n7##y,z,c)), \
 (I[508] = (T)(img)(_p4##x,_n8##y,z,c)), \
 (I[533] = (T)(img)(_p4##x,_n9##y,z,c)), \
 (I[558] = (T)(img)(_p4##x,_n10##y,z,c)), \
 (I[583] = (T)(img)(_p4##x,_n11##y,z,c)), \
 (I[608] = (T)(img)(_p4##x,_n12##y,z,c)), \
 (I[9] = (T)(img)(_p3##x,_p12##y,z,c)), \
 (I[34] = (T)(img)(_p3##x,_p11##y,z,c)), \
 (I[59] = (T)(img)(_p3##x,_p10##y,z,c)), \
 (I[84] = (T)(img)(_p3##x,_p9##y,z,c)), \
 (I[109] = (T)(img)(_p3##x,_p8##y,z,c)), \
 (I[134] = (T)(img)(_p3##x,_p7##y,z,c)), \
 (I[159] = (T)(img)(_p3##x,_p6##y,z,c)), \
 (I[184] = (T)(img)(_p3##x,_p5##y,z,c)), \
 (I[209] = (T)(img)(_p3##x,_p4##y,z,c)), \
 (I[234] = (T)(img)(_p3##x,_p3##y,z,c)), \
 (I[259] = (T)(img)(_p3##x,_p2##y,z,c)), \
 (I[284] = (T)(img)(_p3##x,_p1##y,z,c)), \
 (I[309] = (T)(img)(_p3##x,y,z,c)), \
 (I[334] = (T)(img)(_p3##x,_n1##y,z,c)), \
 (I[359] = (T)(img)(_p3##x,_n2##y,z,c)), \
 (I[384] = (T)(img)(_p3##x,_n3##y,z,c)), \
 (I[409] = (T)(img)(_p3##x,_n4##y,z,c)), \
 (I[434] = (T)(img)(_p3##x,_n5##y,z,c)), \
 (I[459] = (T)(img)(_p3##x,_n6##y,z,c)), \
 (I[484] = (T)(img)(_p3##x,_n7##y,z,c)), \
 (I[509] = (T)(img)(_p3##x,_n8##y,z,c)), \
 (I[534] = (T)(img)(_p3##x,_n9##y,z,c)), \
 (I[559] = (T)(img)(_p3##x,_n10##y,z,c)), \
 (I[584] = (T)(img)(_p3##x,_n11##y,z,c)), \
 (I[609] = (T)(img)(_p3##x,_n12##y,z,c)), \
 (I[10] = (T)(img)(_p2##x,_p12##y,z,c)), \
 (I[35] = (T)(img)(_p2##x,_p11##y,z,c)), \
 (I[60] = (T)(img)(_p2##x,_p10##y,z,c)), \
 (I[85] = (T)(img)(_p2##x,_p9##y,z,c)), \
 (I[110] = (T)(img)(_p2##x,_p8##y,z,c)), \
 (I[135] = (T)(img)(_p2##x,_p7##y,z,c)), \
 (I[160] = (T)(img)(_p2##x,_p6##y,z,c)), \
 (I[185] = (T)(img)(_p2##x,_p5##y,z,c)), \
 (I[210] = (T)(img)(_p2##x,_p4##y,z,c)), \
 (I[235] = (T)(img)(_p2##x,_p3##y,z,c)), \
 (I[260] = (T)(img)(_p2##x,_p2##y,z,c)), \
 (I[285] = (T)(img)(_p2##x,_p1##y,z,c)), \
 (I[310] = (T)(img)(_p2##x,y,z,c)), \
 (I[335] = (T)(img)(_p2##x,_n1##y,z,c)), \
 (I[360] = (T)(img)(_p2##x,_n2##y,z,c)), \
 (I[385] = (T)(img)(_p2##x,_n3##y,z,c)), \
 (I[410] = (T)(img)(_p2##x,_n4##y,z,c)), \
 (I[435] = (T)(img)(_p2##x,_n5##y,z,c)), \
 (I[460] = (T)(img)(_p2##x,_n6##y,z,c)), \
 (I[485] = (T)(img)(_p2##x,_n7##y,z,c)), \
 (I[510] = (T)(img)(_p2##x,_n8##y,z,c)), \
 (I[535] = (T)(img)(_p2##x,_n9##y,z,c)), \
 (I[560] = (T)(img)(_p2##x,_n10##y,z,c)), \
 (I[585] = (T)(img)(_p2##x,_n11##y,z,c)), \
 (I[610] = (T)(img)(_p2##x,_n12##y,z,c)), \
 (I[11] = (T)(img)(_p1##x,_p12##y,z,c)), \
 (I[36] = (T)(img)(_p1##x,_p11##y,z,c)), \
 (I[61] = (T)(img)(_p1##x,_p10##y,z,c)), \
 (I[86] = (T)(img)(_p1##x,_p9##y,z,c)), \
 (I[111] = (T)(img)(_p1##x,_p8##y,z,c)), \
 (I[136] = (T)(img)(_p1##x,_p7##y,z,c)), \
 (I[161] = (T)(img)(_p1##x,_p6##y,z,c)), \
 (I[186] = (T)(img)(_p1##x,_p5##y,z,c)), \
 (I[211] = (T)(img)(_p1##x,_p4##y,z,c)), \
 (I[236] = (T)(img)(_p1##x,_p3##y,z,c)), \
 (I[261] = (T)(img)(_p1##x,_p2##y,z,c)), \
 (I[286] = (T)(img)(_p1##x,_p1##y,z,c)), \
 (I[311] = (T)(img)(_p1##x,y,z,c)), \
 (I[336] = (T)(img)(_p1##x,_n1##y,z,c)), \
 (I[361] = (T)(img)(_p1##x,_n2##y,z,c)), \
 (I[386] = (T)(img)(_p1##x,_n3##y,z,c)), \
 (I[411] = (T)(img)(_p1##x,_n4##y,z,c)), \
 (I[436] = (T)(img)(_p1##x,_n5##y,z,c)), \
 (I[461] = (T)(img)(_p1##x,_n6##y,z,c)), \
 (I[486] = (T)(img)(_p1##x,_n7##y,z,c)), \
 (I[511] = (T)(img)(_p1##x,_n8##y,z,c)), \
 (I[536] = (T)(img)(_p1##x,_n9##y,z,c)), \
 (I[561] = (T)(img)(_p1##x,_n10##y,z,c)), \
 (I[586] = (T)(img)(_p1##x,_n11##y,z,c)), \
 (I[611] = (T)(img)(_p1##x,_n12##y,z,c)), \
 (I[12] = (T)(img)(x,_p12##y,z,c)), \
 (I[37] = (T)(img)(x,_p11##y,z,c)), \
 (I[62] = (T)(img)(x,_p10##y,z,c)), \
 (I[87] = (T)(img)(x,_p9##y,z,c)), \
 (I[112] = (T)(img)(x,_p8##y,z,c)), \
 (I[137] = (T)(img)(x,_p7##y,z,c)), \
 (I[162] = (T)(img)(x,_p6##y,z,c)), \
 (I[187] = (T)(img)(x,_p5##y,z,c)), \
 (I[212] = (T)(img)(x,_p4##y,z,c)), \
 (I[237] = (T)(img)(x,_p3##y,z,c)), \
 (I[262] = (T)(img)(x,_p2##y,z,c)), \
 (I[287] = (T)(img)(x,_p1##y,z,c)), \
 (I[312] = (T)(img)(x,y,z,c)), \
 (I[337] = (T)(img)(x,_n1##y,z,c)), \
 (I[362] = (T)(img)(x,_n2##y,z,c)), \
 (I[387] = (T)(img)(x,_n3##y,z,c)), \
 (I[412] = (T)(img)(x,_n4##y,z,c)), \
 (I[437] = (T)(img)(x,_n5##y,z,c)), \
 (I[462] = (T)(img)(x,_n6##y,z,c)), \
 (I[487] = (T)(img)(x,_n7##y,z,c)), \
 (I[512] = (T)(img)(x,_n8##y,z,c)), \
 (I[537] = (T)(img)(x,_n9##y,z,c)), \
 (I[562] = (T)(img)(x,_n10##y,z,c)), \
 (I[587] = (T)(img)(x,_n11##y,z,c)), \
 (I[612] = (T)(img)(x,_n12##y,z,c)), \
 (I[13] = (T)(img)(_n1##x,_p12##y,z,c)), \
 (I[38] = (T)(img)(_n1##x,_p11##y,z,c)), \
 (I[63] = (T)(img)(_n1##x,_p10##y,z,c)), \
 (I[88] = (T)(img)(_n1##x,_p9##y,z,c)), \
 (I[113] = (T)(img)(_n1##x,_p8##y,z,c)), \
 (I[138] = (T)(img)(_n1##x,_p7##y,z,c)), \
 (I[163] = (T)(img)(_n1##x,_p6##y,z,c)), \
 (I[188] = (T)(img)(_n1##x,_p5##y,z,c)), \
 (I[213] = (T)(img)(_n1##x,_p4##y,z,c)), \
 (I[238] = (T)(img)(_n1##x,_p3##y,z,c)), \
 (I[263] = (T)(img)(_n1##x,_p2##y,z,c)), \
 (I[288] = (T)(img)(_n1##x,_p1##y,z,c)), \
 (I[313] = (T)(img)(_n1##x,y,z,c)), \
 (I[338] = (T)(img)(_n1##x,_n1##y,z,c)), \
 (I[363] = (T)(img)(_n1##x,_n2##y,z,c)), \
 (I[388] = (T)(img)(_n1##x,_n3##y,z,c)), \
 (I[413] = (T)(img)(_n1##x,_n4##y,z,c)), \
 (I[438] = (T)(img)(_n1##x,_n5##y,z,c)), \
 (I[463] = (T)(img)(_n1##x,_n6##y,z,c)), \
 (I[488] = (T)(img)(_n1##x,_n7##y,z,c)), \
 (I[513] = (T)(img)(_n1##x,_n8##y,z,c)), \
 (I[538] = (T)(img)(_n1##x,_n9##y,z,c)), \
 (I[563] = (T)(img)(_n1##x,_n10##y,z,c)), \
 (I[588] = (T)(img)(_n1##x,_n11##y,z,c)), \
 (I[613] = (T)(img)(_n1##x,_n12##y,z,c)), \
 (I[14] = (T)(img)(_n2##x,_p12##y,z,c)), \
 (I[39] = (T)(img)(_n2##x,_p11##y,z,c)), \
 (I[64] = (T)(img)(_n2##x,_p10##y,z,c)), \
 (I[89] = (T)(img)(_n2##x,_p9##y,z,c)), \
 (I[114] = (T)(img)(_n2##x,_p8##y,z,c)), \
 (I[139] = (T)(img)(_n2##x,_p7##y,z,c)), \
 (I[164] = (T)(img)(_n2##x,_p6##y,z,c)), \
 (I[189] = (T)(img)(_n2##x,_p5##y,z,c)), \
 (I[214] = (T)(img)(_n2##x,_p4##y,z,c)), \
 (I[239] = (T)(img)(_n2##x,_p3##y,z,c)), \
 (I[264] = (T)(img)(_n2##x,_p2##y,z,c)), \
 (I[289] = (T)(img)(_n2##x,_p1##y,z,c)), \
 (I[314] = (T)(img)(_n2##x,y,z,c)), \
 (I[339] = (T)(img)(_n2##x,_n1##y,z,c)), \
 (I[364] = (T)(img)(_n2##x,_n2##y,z,c)), \
 (I[389] = (T)(img)(_n2##x,_n3##y,z,c)), \
 (I[414] = (T)(img)(_n2##x,_n4##y,z,c)), \
 (I[439] = (T)(img)(_n2##x,_n5##y,z,c)), \
 (I[464] = (T)(img)(_n2##x,_n6##y,z,c)), \
 (I[489] = (T)(img)(_n2##x,_n7##y,z,c)), \
 (I[514] = (T)(img)(_n2##x,_n8##y,z,c)), \
 (I[539] = (T)(img)(_n2##x,_n9##y,z,c)), \
 (I[564] = (T)(img)(_n2##x,_n10##y,z,c)), \
 (I[589] = (T)(img)(_n2##x,_n11##y,z,c)), \
 (I[614] = (T)(img)(_n2##x,_n12##y,z,c)), \
 (I[15] = (T)(img)(_n3##x,_p12##y,z,c)), \
 (I[40] = (T)(img)(_n3##x,_p11##y,z,c)), \
 (I[65] = (T)(img)(_n3##x,_p10##y,z,c)), \
 (I[90] = (T)(img)(_n3##x,_p9##y,z,c)), \
 (I[115] = (T)(img)(_n3##x,_p8##y,z,c)), \
 (I[140] = (T)(img)(_n3##x,_p7##y,z,c)), \
 (I[165] = (T)(img)(_n3##x,_p6##y,z,c)), \
 (I[190] = (T)(img)(_n3##x,_p5##y,z,c)), \
 (I[215] = (T)(img)(_n3##x,_p4##y,z,c)), \
 (I[240] = (T)(img)(_n3##x,_p3##y,z,c)), \
 (I[265] = (T)(img)(_n3##x,_p2##y,z,c)), \
 (I[290] = (T)(img)(_n3##x,_p1##y,z,c)), \
 (I[315] = (T)(img)(_n3##x,y,z,c)), \
 (I[340] = (T)(img)(_n3##x,_n1##y,z,c)), \
 (I[365] = (T)(img)(_n3##x,_n2##y,z,c)), \
 (I[390] = (T)(img)(_n3##x,_n3##y,z,c)), \
 (I[415] = (T)(img)(_n3##x,_n4##y,z,c)), \
 (I[440] = (T)(img)(_n3##x,_n5##y,z,c)), \
 (I[465] = (T)(img)(_n3##x,_n6##y,z,c)), \
 (I[490] = (T)(img)(_n3##x,_n7##y,z,c)), \
 (I[515] = (T)(img)(_n3##x,_n8##y,z,c)), \
 (I[540] = (T)(img)(_n3##x,_n9##y,z,c)), \
 (I[565] = (T)(img)(_n3##x,_n10##y,z,c)), \
 (I[590] = (T)(img)(_n3##x,_n11##y,z,c)), \
 (I[615] = (T)(img)(_n3##x,_n12##y,z,c)), \
 (I[16] = (T)(img)(_n4##x,_p12##y,z,c)), \
 (I[41] = (T)(img)(_n4##x,_p11##y,z,c)), \
 (I[66] = (T)(img)(_n4##x,_p10##y,z,c)), \
 (I[91] = (T)(img)(_n4##x,_p9##y,z,c)), \
 (I[116] = (T)(img)(_n4##x,_p8##y,z,c)), \
 (I[141] = (T)(img)(_n4##x,_p7##y,z,c)), \
 (I[166] = (T)(img)(_n4##x,_p6##y,z,c)), \
 (I[191] = (T)(img)(_n4##x,_p5##y,z,c)), \
 (I[216] = (T)(img)(_n4##x,_p4##y,z,c)), \
 (I[241] = (T)(img)(_n4##x,_p3##y,z,c)), \
 (I[266] = (T)(img)(_n4##x,_p2##y,z,c)), \
 (I[291] = (T)(img)(_n4##x,_p1##y,z,c)), \
 (I[316] = (T)(img)(_n4##x,y,z,c)), \
 (I[341] = (T)(img)(_n4##x,_n1##y,z,c)), \
 (I[366] = (T)(img)(_n4##x,_n2##y,z,c)), \
 (I[391] = (T)(img)(_n4##x,_n3##y,z,c)), \
 (I[416] = (T)(img)(_n4##x,_n4##y,z,c)), \
 (I[441] = (T)(img)(_n4##x,_n5##y,z,c)), \
 (I[466] = (T)(img)(_n4##x,_n6##y,z,c)), \
 (I[491] = (T)(img)(_n4##x,_n7##y,z,c)), \
 (I[516] = (T)(img)(_n4##x,_n8##y,z,c)), \
 (I[541] = (T)(img)(_n4##x,_n9##y,z,c)), \
 (I[566] = (T)(img)(_n4##x,_n10##y,z,c)), \
 (I[591] = (T)(img)(_n4##x,_n11##y,z,c)), \
 (I[616] = (T)(img)(_n4##x,_n12##y,z,c)), \
 (I[17] = (T)(img)(_n5##x,_p12##y,z,c)), \
 (I[42] = (T)(img)(_n5##x,_p11##y,z,c)), \
 (I[67] = (T)(img)(_n5##x,_p10##y,z,c)), \
 (I[92] = (T)(img)(_n5##x,_p9##y,z,c)), \
 (I[117] = (T)(img)(_n5##x,_p8##y,z,c)), \
 (I[142] = (T)(img)(_n5##x,_p7##y,z,c)), \
 (I[167] = (T)(img)(_n5##x,_p6##y,z,c)), \
 (I[192] = (T)(img)(_n5##x,_p5##y,z,c)), \
 (I[217] = (T)(img)(_n5##x,_p4##y,z,c)), \
 (I[242] = (T)(img)(_n5##x,_p3##y,z,c)), \
 (I[267] = (T)(img)(_n5##x,_p2##y,z,c)), \
 (I[292] = (T)(img)(_n5##x,_p1##y,z,c)), \
 (I[317] = (T)(img)(_n5##x,y,z,c)), \
 (I[342] = (T)(img)(_n5##x,_n1##y,z,c)), \
 (I[367] = (T)(img)(_n5##x,_n2##y,z,c)), \
 (I[392] = (T)(img)(_n5##x,_n3##y,z,c)), \
 (I[417] = (T)(img)(_n5##x,_n4##y,z,c)), \
 (I[442] = (T)(img)(_n5##x,_n5##y,z,c)), \
 (I[467] = (T)(img)(_n5##x,_n6##y,z,c)), \
 (I[492] = (T)(img)(_n5##x,_n7##y,z,c)), \
 (I[517] = (T)(img)(_n5##x,_n8##y,z,c)), \
 (I[542] = (T)(img)(_n5##x,_n9##y,z,c)), \
 (I[567] = (T)(img)(_n5##x,_n10##y,z,c)), \
 (I[592] = (T)(img)(_n5##x,_n11##y,z,c)), \
 (I[617] = (T)(img)(_n5##x,_n12##y,z,c)), \
 (I[18] = (T)(img)(_n6##x,_p12##y,z,c)), \
 (I[43] = (T)(img)(_n6##x,_p11##y,z,c)), \
 (I[68] = (T)(img)(_n6##x,_p10##y,z,c)), \
 (I[93] = (T)(img)(_n6##x,_p9##y,z,c)), \
 (I[118] = (T)(img)(_n6##x,_p8##y,z,c)), \
 (I[143] = (T)(img)(_n6##x,_p7##y,z,c)), \
 (I[168] = (T)(img)(_n6##x,_p6##y,z,c)), \
 (I[193] = (T)(img)(_n6##x,_p5##y,z,c)), \
 (I[218] = (T)(img)(_n6##x,_p4##y,z,c)), \
 (I[243] = (T)(img)(_n6##x,_p3##y,z,c)), \
 (I[268] = (T)(img)(_n6##x,_p2##y,z,c)), \
 (I[293] = (T)(img)(_n6##x,_p1##y,z,c)), \
 (I[318] = (T)(img)(_n6##x,y,z,c)), \
 (I[343] = (T)(img)(_n6##x,_n1##y,z,c)), \
 (I[368] = (T)(img)(_n6##x,_n2##y,z,c)), \
 (I[393] = (T)(img)(_n6##x,_n3##y,z,c)), \
 (I[418] = (T)(img)(_n6##x,_n4##y,z,c)), \
 (I[443] = (T)(img)(_n6##x,_n5##y,z,c)), \
 (I[468] = (T)(img)(_n6##x,_n6##y,z,c)), \
 (I[493] = (T)(img)(_n6##x,_n7##y,z,c)), \
 (I[518] = (T)(img)(_n6##x,_n8##y,z,c)), \
 (I[543] = (T)(img)(_n6##x,_n9##y,z,c)), \
 (I[568] = (T)(img)(_n6##x,_n10##y,z,c)), \
 (I[593] = (T)(img)(_n6##x,_n11##y,z,c)), \
 (I[618] = (T)(img)(_n6##x,_n12##y,z,c)), \
 (I[19] = (T)(img)(_n7##x,_p12##y,z,c)), \
 (I[44] = (T)(img)(_n7##x,_p11##y,z,c)), \
 (I[69] = (T)(img)(_n7##x,_p10##y,z,c)), \
 (I[94] = (T)(img)(_n7##x,_p9##y,z,c)), \
 (I[119] = (T)(img)(_n7##x,_p8##y,z,c)), \
 (I[144] = (T)(img)(_n7##x,_p7##y,z,c)), \
 (I[169] = (T)(img)(_n7##x,_p6##y,z,c)), \
 (I[194] = (T)(img)(_n7##x,_p5##y,z,c)), \
 (I[219] = (T)(img)(_n7##x,_p4##y,z,c)), \
 (I[244] = (T)(img)(_n7##x,_p3##y,z,c)), \
 (I[269] = (T)(img)(_n7##x,_p2##y,z,c)), \
 (I[294] = (T)(img)(_n7##x,_p1##y,z,c)), \
 (I[319] = (T)(img)(_n7##x,y,z,c)), \
 (I[344] = (T)(img)(_n7##x,_n1##y,z,c)), \
 (I[369] = (T)(img)(_n7##x,_n2##y,z,c)), \
 (I[394] = (T)(img)(_n7##x,_n3##y,z,c)), \
 (I[419] = (T)(img)(_n7##x,_n4##y,z,c)), \
 (I[444] = (T)(img)(_n7##x,_n5##y,z,c)), \
 (I[469] = (T)(img)(_n7##x,_n6##y,z,c)), \
 (I[494] = (T)(img)(_n7##x,_n7##y,z,c)), \
 (I[519] = (T)(img)(_n7##x,_n8##y,z,c)), \
 (I[544] = (T)(img)(_n7##x,_n9##y,z,c)), \
 (I[569] = (T)(img)(_n7##x,_n10##y,z,c)), \
 (I[594] = (T)(img)(_n7##x,_n11##y,z,c)), \
 (I[619] = (T)(img)(_n7##x,_n12##y,z,c)), \
 (I[20] = (T)(img)(_n8##x,_p12##y,z,c)), \
 (I[45] = (T)(img)(_n8##x,_p11##y,z,c)), \
 (I[70] = (T)(img)(_n8##x,_p10##y,z,c)), \
 (I[95] = (T)(img)(_n8##x,_p9##y,z,c)), \
 (I[120] = (T)(img)(_n8##x,_p8##y,z,c)), \
 (I[145] = (T)(img)(_n8##x,_p7##y,z,c)), \
 (I[170] = (T)(img)(_n8##x,_p6##y,z,c)), \
 (I[195] = (T)(img)(_n8##x,_p5##y,z,c)), \
 (I[220] = (T)(img)(_n8##x,_p4##y,z,c)), \
 (I[245] = (T)(img)(_n8##x,_p3##y,z,c)), \
 (I[270] = (T)(img)(_n8##x,_p2##y,z,c)), \
 (I[295] = (T)(img)(_n8##x,_p1##y,z,c)), \
 (I[320] = (T)(img)(_n8##x,y,z,c)), \
 (I[345] = (T)(img)(_n8##x,_n1##y,z,c)), \
 (I[370] = (T)(img)(_n8##x,_n2##y,z,c)), \
 (I[395] = (T)(img)(_n8##x,_n3##y,z,c)), \
 (I[420] = (T)(img)(_n8##x,_n4##y,z,c)), \
 (I[445] = (T)(img)(_n8##x,_n5##y,z,c)), \
 (I[470] = (T)(img)(_n8##x,_n6##y,z,c)), \
 (I[495] = (T)(img)(_n8##x,_n7##y,z,c)), \
 (I[520] = (T)(img)(_n8##x,_n8##y,z,c)), \
 (I[545] = (T)(img)(_n8##x,_n9##y,z,c)), \
 (I[570] = (T)(img)(_n8##x,_n10##y,z,c)), \
 (I[595] = (T)(img)(_n8##x,_n11##y,z,c)), \
 (I[620] = (T)(img)(_n8##x,_n12##y,z,c)), \
 (I[21] = (T)(img)(_n9##x,_p12##y,z,c)), \
 (I[46] = (T)(img)(_n9##x,_p11##y,z,c)), \
 (I[71] = (T)(img)(_n9##x,_p10##y,z,c)), \
 (I[96] = (T)(img)(_n9##x,_p9##y,z,c)), \
 (I[121] = (T)(img)(_n9##x,_p8##y,z,c)), \
 (I[146] = (T)(img)(_n9##x,_p7##y,z,c)), \
 (I[171] = (T)(img)(_n9##x,_p6##y,z,c)), \
 (I[196] = (T)(img)(_n9##x,_p5##y,z,c)), \
 (I[221] = (T)(img)(_n9##x,_p4##y,z,c)), \
 (I[246] = (T)(img)(_n9##x,_p3##y,z,c)), \
 (I[271] = (T)(img)(_n9##x,_p2##y,z,c)), \
 (I[296] = (T)(img)(_n9##x,_p1##y,z,c)), \
 (I[321] = (T)(img)(_n9##x,y,z,c)), \
 (I[346] = (T)(img)(_n9##x,_n1##y,z,c)), \
 (I[371] = (T)(img)(_n9##x,_n2##y,z,c)), \
 (I[396] = (T)(img)(_n9##x,_n3##y,z,c)), \
 (I[421] = (T)(img)(_n9##x,_n4##y,z,c)), \
 (I[446] = (T)(img)(_n9##x,_n5##y,z,c)), \
 (I[471] = (T)(img)(_n9##x,_n6##y,z,c)), \
 (I[496] = (T)(img)(_n9##x,_n7##y,z,c)), \
 (I[521] = (T)(img)(_n9##x,_n8##y,z,c)), \
 (I[546] = (T)(img)(_n9##x,_n9##y,z,c)), \
 (I[571] = (T)(img)(_n9##x,_n10##y,z,c)), \
 (I[596] = (T)(img)(_n9##x,_n11##y,z,c)), \
 (I[621] = (T)(img)(_n9##x,_n12##y,z,c)), \
 (I[22] = (T)(img)(_n10##x,_p12##y,z,c)), \
 (I[47] = (T)(img)(_n10##x,_p11##y,z,c)), \
 (I[72] = (T)(img)(_n10##x,_p10##y,z,c)), \
 (I[97] = (T)(img)(_n10##x,_p9##y,z,c)), \
 (I[122] = (T)(img)(_n10##x,_p8##y,z,c)), \
 (I[147] = (T)(img)(_n10##x,_p7##y,z,c)), \
 (I[172] = (T)(img)(_n10##x,_p6##y,z,c)), \
 (I[197] = (T)(img)(_n10##x,_p5##y,z,c)), \
 (I[222] = (T)(img)(_n10##x,_p4##y,z,c)), \
 (I[247] = (T)(img)(_n10##x,_p3##y,z,c)), \
 (I[272] = (T)(img)(_n10##x,_p2##y,z,c)), \
 (I[297] = (T)(img)(_n10##x,_p1##y,z,c)), \
 (I[322] = (T)(img)(_n10##x,y,z,c)), \
 (I[347] = (T)(img)(_n10##x,_n1##y,z,c)), \
 (I[372] = (T)(img)(_n10##x,_n2##y,z,c)), \
 (I[397] = (T)(img)(_n10##x,_n3##y,z,c)), \
 (I[422] = (T)(img)(_n10##x,_n4##y,z,c)), \
 (I[447] = (T)(img)(_n10##x,_n5##y,z,c)), \
 (I[472] = (T)(img)(_n10##x,_n6##y,z,c)), \
 (I[497] = (T)(img)(_n10##x,_n7##y,z,c)), \
 (I[522] = (T)(img)(_n10##x,_n8##y,z,c)), \
 (I[547] = (T)(img)(_n10##x,_n9##y,z,c)), \
 (I[572] = (T)(img)(_n10##x,_n10##y,z,c)), \
 (I[597] = (T)(img)(_n10##x,_n11##y,z,c)), \
 (I[622] = (T)(img)(_n10##x,_n12##y,z,c)), \
 (I[23] = (T)(img)(_n11##x,_p12##y,z,c)), \
 (I[48] = (T)(img)(_n11##x,_p11##y,z,c)), \
 (I[73] = (T)(img)(_n11##x,_p10##y,z,c)), \
 (I[98] = (T)(img)(_n11##x,_p9##y,z,c)), \
 (I[123] = (T)(img)(_n11##x,_p8##y,z,c)), \
 (I[148] = (T)(img)(_n11##x,_p7##y,z,c)), \
 (I[173] = (T)(img)(_n11##x,_p6##y,z,c)), \
 (I[198] = (T)(img)(_n11##x,_p5##y,z,c)), \
 (I[223] = (T)(img)(_n11##x,_p4##y,z,c)), \
 (I[248] = (T)(img)(_n11##x,_p3##y,z,c)), \
 (I[273] = (T)(img)(_n11##x,_p2##y,z,c)), \
 (I[298] = (T)(img)(_n11##x,_p1##y,z,c)), \
 (I[323] = (T)(img)(_n11##x,y,z,c)), \
 (I[348] = (T)(img)(_n11##x,_n1##y,z,c)), \
 (I[373] = (T)(img)(_n11##x,_n2##y,z,c)), \
 (I[398] = (T)(img)(_n11##x,_n3##y,z,c)), \
 (I[423] = (T)(img)(_n11##x,_n4##y,z,c)), \
 (I[448] = (T)(img)(_n11##x,_n5##y,z,c)), \
 (I[473] = (T)(img)(_n11##x,_n6##y,z,c)), \
 (I[498] = (T)(img)(_n11##x,_n7##y,z,c)), \
 (I[523] = (T)(img)(_n11##x,_n8##y,z,c)), \
 (I[548] = (T)(img)(_n11##x,_n9##y,z,c)), \
 (I[573] = (T)(img)(_n11##x,_n10##y,z,c)), \
 (I[598] = (T)(img)(_n11##x,_n11##y,z,c)), \
 (I[623] = (T)(img)(_n11##x,_n12##y,z,c)), \
 x+12>=(img).width()?(img).width()-1:x+12); \
 x<=(int)(x1) && ((_n12##x<(img).width() && ( \
 (I[24] = (T)(img)(_n12##x,_p12##y,z,c)), \
 (I[49] = (T)(img)(_n12##x,_p11##y,z,c)), \
 (I[74] = (T)(img)(_n12##x,_p10##y,z,c)), \
 (I[99] = (T)(img)(_n12##x,_p9##y,z,c)), \
 (I[124] = (T)(img)(_n12##x,_p8##y,z,c)), \
 (I[149] = (T)(img)(_n12##x,_p7##y,z,c)), \
 (I[174] = (T)(img)(_n12##x,_p6##y,z,c)), \
 (I[199] = (T)(img)(_n12##x,_p5##y,z,c)), \
 (I[224] = (T)(img)(_n12##x,_p4##y,z,c)), \
 (I[249] = (T)(img)(_n12##x,_p3##y,z,c)), \
 (I[274] = (T)(img)(_n12##x,_p2##y,z,c)), \
 (I[299] = (T)(img)(_n12##x,_p1##y,z,c)), \
 (I[324] = (T)(img)(_n12##x,y,z,c)), \
 (I[349] = (T)(img)(_n12##x,_n1##y,z,c)), \
 (I[374] = (T)(img)(_n12##x,_n2##y,z,c)), \
 (I[399] = (T)(img)(_n12##x,_n3##y,z,c)), \
 (I[424] = (T)(img)(_n12##x,_n4##y,z,c)), \
 (I[449] = (T)(img)(_n12##x,_n5##y,z,c)), \
 (I[474] = (T)(img)(_n12##x,_n6##y,z,c)), \
 (I[499] = (T)(img)(_n12##x,_n7##y,z,c)), \
 (I[524] = (T)(img)(_n12##x,_n8##y,z,c)), \
 (I[549] = (T)(img)(_n12##x,_n9##y,z,c)), \
 (I[574] = (T)(img)(_n12##x,_n10##y,z,c)), \
 (I[599] = (T)(img)(_n12##x,_n11##y,z,c)), \
 (I[624] = (T)(img)(_n12##x,_n12##y,z,c)),1)) || \
 _n11##x==--_n12##x || _n10##x==--_n11##x || _n9##x==--_n10##x || _n8##x==--_n9##x || _n7##x==--_n8##x || _n6##x==--_n7##x || _n5##x==--_n6##x || _n4##x==--_n5##x || _n3##x==--_n4##x || _n2##x==--_n3##x || _n1##x==--_n2##x || x==(_n12##x = _n11##x = _n10##x = _n9##x = _n8##x = _n7##x = _n6##x = _n5##x = _n4##x = _n3##x = _n2##x = --_n1##x)); \
 I[0] = I[1], I[1] = I[2], I[2] = I[3], I[3] = I[4], I[4] = I[5], I[5] = I[6], I[6] = I[7], I[7] = I[8], I[8] = I[9], I[9] = I[10], I[10] = I[11], I[11] = I[12], I[12] = I[13], I[13] = I[14], I[14] = I[15], I[15] = I[16], I[16] = I[17], I[17] = I[18], I[18] = I[19], I[19] = I[20], I[20] = I[21], I[21] = I[22], I[22] = I[23], I[23] = I[24], \
 I[25] = I[26], I[26] = I[27], I[27] = I[28], I[28] = I[29], I[29] = I[30], I[30] = I[31], I[31] = I[32], I[32] = I[33], I[33] = I[34], I[34] = I[35], I[35] = I[36], I[36] = I[37], I[37] = I[38], I[38] = I[39], I[39] = I[40], I[40] = I[41], I[41] = I[42], I[42] = I[43], I[43] = I[44], I[44] = I[45], I[45] = I[46], I[46] = I[47], I[47] = I[48], I[48] = I[49], \
 I[50] = I[51], I[51] = I[52], I[52] = I[53], I[53] = I[54], I[54] = I[55], I[55] = I[56], I[56] = I[57], I[57] = I[58], I[58] = I[59], I[59] = I[60], I[60] = I[61], I[61] = I[62], I[62] = I[63], I[63] = I[64], I[64] = I[65], I[65] = I[66], I[66] = I[67], I[67] = I[68], I[68] = I[69], I[69] = I[70], I[70] = I[71], I[71] = I[72], I[72] = I[73], I[73] = I[74], \
 I[75] = I[76], I[76] = I[77], I[77] = I[78], I[78] = I[79], I[79] = I[80], I[80] = I[81], I[81] = I[82], I[82] = I[83], I[83] = I[84], I[84] = I[85], I[85] = I[86], I[86] = I[87], I[87] = I[88], I[88] = I[89], I[89] = I[90], I[90] = I[91], I[91] = I[92], I[92] = I[93], I[93] = I[94], I[94] = I[95], I[95] = I[96], I[96] = I[97], I[97] = I[98], I[98] = I[99], \
 I[100] = I[101], I[101] = I[102], I[102] = I[103], I[103] = I[104], I[104] = I[105], I[105] = I[106], I[106] = I[107], I[107] = I[108], I[108] = I[109], I[109] = I[110], I[110] = I[111], I[111] = I[112], I[112] = I[113], I[113] = I[114], I[114] = I[115], I[115] = I[116], I[116] = I[117], I[117] = I[118], I[118] = I[119], I[119] = I[120], I[120] = I[121], I[121] = I[122], I[122] = I[123], I[123] = I[124], \
 I[125] = I[126], I[126] = I[127], I[127] = I[128], I[128] = I[129], I[129] = I[130], I[130] = I[131], I[131] = I[132], I[132] = I[133], I[133] = I[134], I[134] = I[135], I[135] = I[136], I[136] = I[137], I[137] = I[138], I[138] = I[139], I[139] = I[140], I[140] = I[141], I[141] = I[142], I[142] = I[143], I[143] = I[144], I[144] = I[145], I[145] = I[146], I[146] = I[147], I[147] = I[148], I[148] = I[149], \
 I[150] = I[151], I[151] = I[152], I[152] = I[153], I[153] = I[154], I[154] = I[155], I[155] = I[156], I[156] = I[157], I[157] = I[158], I[158] = I[159], I[159] = I[160], I[160] = I[161], I[161] = I[162], I[162] = I[163], I[163] = I[164], I[164] = I[165], I[165] = I[166], I[166] = I[167], I[167] = I[168], I[168] = I[169], I[169] = I[170], I[170] = I[171], I[171] = I[172], I[172] = I[173], I[173] = I[174], \
 I[175] = I[176], I[176] = I[177], I[177] = I[178], I[178] = I[179], I[179] = I[180], I[180] = I[181], I[181] = I[182], I[182] = I[183], I[183] = I[184], I[184] = I[185], I[185] = I[186], I[186] = I[187], I[187] = I[188], I[188] = I[189], I[189] = I[190], I[190] = I[191], I[191] = I[192], I[192] = I[193], I[193] = I[194], I[194] = I[195], I[195] = I[196], I[196] = I[197], I[197] = I[198], I[198] = I[199], \
 I[200] = I[201], I[201] = I[202], I[202] = I[203], I[203] = I[204], I[204] = I[205], I[205] = I[206], I[206] = I[207], I[207] = I[208], I[208] = I[209], I[209] = I[210], I[210] = I[211], I[211] = I[212], I[212] = I[213], I[213] = I[214], I[214] = I[215], I[215] = I[216], I[216] = I[217], I[217] = I[218], I[218] = I[219], I[219] = I[220], I[220] = I[221], I[221] = I[222], I[222] = I[223], I[223] = I[224], \
 I[225] = I[226], I[226] = I[227], I[227] = I[228], I[228] = I[229], I[229] = I[230], I[230] = I[231], I[231] = I[232], I[232] = I[233], I[233] = I[234], I[234] = I[235], I[235] = I[236], I[236] = I[237], I[237] = I[238], I[238] = I[239], I[239] = I[240], I[240] = I[241], I[241] = I[242], I[242] = I[243], I[243] = I[244], I[244] = I[245], I[245] = I[246], I[246] = I[247], I[247] = I[248], I[248] = I[249], \
 I[250] = I[251], I[251] = I[252], I[252] = I[253], I[253] = I[254], I[254] = I[255], I[255] = I[256], I[256] = I[257], I[257] = I[258], I[258] = I[259], I[259] = I[260], I[260] = I[261], I[261] = I[262], I[262] = I[263], I[263] = I[264], I[264] = I[265], I[265] = I[266], I[266] = I[267], I[267] = I[268], I[268] = I[269], I[269] = I[270], I[270] = I[271], I[271] = I[272], I[272] = I[273], I[273] = I[274], \
 I[275] = I[276], I[276] = I[277], I[277] = I[278], I[278] = I[279], I[279] = I[280], I[280] = I[281], I[281] = I[282], I[282] = I[283], I[283] = I[284], I[284] = I[285], I[285] = I[286], I[286] = I[287], I[287] = I[288], I[288] = I[289], I[289] = I[290], I[290] = I[291], I[291] = I[292], I[292] = I[293], I[293] = I[294], I[294] = I[295], I[295] = I[296], I[296] = I[297], I[297] = I[298], I[298] = I[299], \
 I[300] = I[301], I[301] = I[302], I[302] = I[303], I[303] = I[304], I[304] = I[305], I[305] = I[306], I[306] = I[307], I[307] = I[308], I[308] = I[309], I[309] = I[310], I[310] = I[311], I[311] = I[312], I[312] = I[313], I[313] = I[314], I[314] = I[315], I[315] = I[316], I[316] = I[317], I[317] = I[318], I[318] = I[319], I[319] = I[320], I[320] = I[321], I[321] = I[322], I[322] = I[323], I[323] = I[324], \
 I[325] = I[326], I[326] = I[327], I[327] = I[328], I[328] = I[329], I[329] = I[330], I[330] = I[331], I[331] = I[332], I[332] = I[333], I[333] = I[334], I[334] = I[335], I[335] = I[336], I[336] = I[337], I[337] = I[338], I[338] = I[339], I[339] = I[340], I[340] = I[341], I[341] = I[342], I[342] = I[343], I[343] = I[344], I[344] = I[345], I[345] = I[346], I[346] = I[347], I[347] = I[348], I[348] = I[349], \
 I[350] = I[351], I[351] = I[352], I[352] = I[353], I[353] = I[354], I[354] = I[355], I[355] = I[356], I[356] = I[357], I[357] = I[358], I[358] = I[359], I[359] = I[360], I[360] = I[361], I[361] = I[362], I[362] = I[363], I[363] = I[364], I[364] = I[365], I[365] = I[366], I[366] = I[367], I[367] = I[368], I[368] = I[369], I[369] = I[370], I[370] = I[371], I[371] = I[372], I[372] = I[373], I[373] = I[374], \
 I[375] = I[376], I[376] = I[377], I[377] = I[378], I[378] = I[379], I[379] = I[380], I[380] = I[381], I[381] = I[382], I[382] = I[383], I[383] = I[384], I[384] = I[385], I[385] = I[386], I[386] = I[387], I[387] = I[388], I[388] = I[389], I[389] = I[390], I[390] = I[391], I[391] = I[392], I[392] = I[393], I[393] = I[394], I[394] = I[395], I[395] = I[396], I[396] = I[397], I[397] = I[398], I[398] = I[399], \
 I[400] = I[401], I[401] = I[402], I[402] = I[403], I[403] = I[404], I[404] = I[405], I[405] = I[406], I[406] = I[407], I[407] = I[408], I[408] = I[409], I[409] = I[410], I[410] = I[411], I[411] = I[412], I[412] = I[413], I[413] = I[414], I[414] = I[415], I[415] = I[416], I[416] = I[417], I[417] = I[418], I[418] = I[419], I[419] = I[420], I[420] = I[421], I[421] = I[422], I[422] = I[423], I[423] = I[424], \
 I[425] = I[426], I[426] = I[427], I[427] = I[428], I[428] = I[429], I[429] = I[430], I[430] = I[431], I[431] = I[432], I[432] = I[433], I[433] = I[434], I[434] = I[435], I[435] = I[436], I[436] = I[437], I[437] = I[438], I[438] = I[439], I[439] = I[440], I[440] = I[441], I[441] = I[442], I[442] = I[443], I[443] = I[444], I[444] = I[445], I[445] = I[446], I[446] = I[447], I[447] = I[448], I[448] = I[449], \
 I[450] = I[451], I[451] = I[452], I[452] = I[453], I[453] = I[454], I[454] = I[455], I[455] = I[456], I[456] = I[457], I[457] = I[458], I[458] = I[459], I[459] = I[460], I[460] = I[461], I[461] = I[462], I[462] = I[463], I[463] = I[464], I[464] = I[465], I[465] = I[466], I[466] = I[467], I[467] = I[468], I[468] = I[469], I[469] = I[470], I[470] = I[471], I[471] = I[472], I[472] = I[473], I[473] = I[474], \
 I[475] = I[476], I[476] = I[477], I[477] = I[478], I[478] = I[479], I[479] = I[480], I[480] = I[481], I[481] = I[482], I[482] = I[483], I[483] = I[484], I[484] = I[485], I[485] = I[486], I[486] = I[487], I[487] = I[488], I[488] = I[489], I[489] = I[490], I[490] = I[491], I[491] = I[492], I[492] = I[493], I[493] = I[494], I[494] = I[495], I[495] = I[496], I[496] = I[497], I[497] = I[498], I[498] = I[499], \
 I[500] = I[501], I[501] = I[502], I[502] = I[503], I[503] = I[504], I[504] = I[505], I[505] = I[506], I[506] = I[507], I[507] = I[508], I[508] = I[509], I[509] = I[510], I[510] = I[511], I[511] = I[512], I[512] = I[513], I[513] = I[514], I[514] = I[515], I[515] = I[516], I[516] = I[517], I[517] = I[518], I[518] = I[519], I[519] = I[520], I[520] = I[521], I[521] = I[522], I[522] = I[523], I[523] = I[524], \
 I[525] = I[526], I[526] = I[527], I[527] = I[528], I[528] = I[529], I[529] = I[530], I[530] = I[531], I[531] = I[532], I[532] = I[533], I[533] = I[534], I[534] = I[535], I[535] = I[536], I[536] = I[537], I[537] = I[538], I[538] = I[539], I[539] = I[540], I[540] = I[541], I[541] = I[542], I[542] = I[543], I[543] = I[544], I[544] = I[545], I[545] = I[546], I[546] = I[547], I[547] = I[548], I[548] = I[549], \
 I[550] = I[551], I[551] = I[552], I[552] = I[553], I[553] = I[554], I[554] = I[555], I[555] = I[556], I[556] = I[557], I[557] = I[558], I[558] = I[559], I[559] = I[560], I[560] = I[561], I[561] = I[562], I[562] = I[563], I[563] = I[564], I[564] = I[565], I[565] = I[566], I[566] = I[567], I[567] = I[568], I[568] = I[569], I[569] = I[570], I[570] = I[571], I[571] = I[572], I[572] = I[573], I[573] = I[574], \
 I[575] = I[576], I[576] = I[577], I[577] = I[578], I[578] = I[579], I[579] = I[580], I[580] = I[581], I[581] = I[582], I[582] = I[583], I[583] = I[584], I[584] = I[585], I[585] = I[586], I[586] = I[587], I[587] = I[588], I[588] = I[589], I[589] = I[590], I[590] = I[591], I[591] = I[592], I[592] = I[593], I[593] = I[594], I[594] = I[595], I[595] = I[596], I[596] = I[597], I[597] = I[598], I[598] = I[599], \
 I[600] = I[601], I[601] = I[602], I[602] = I[603], I[603] = I[604], I[604] = I[605], I[605] = I[606], I[606] = I[607], I[607] = I[608], I[608] = I[609], I[609] = I[610], I[610] = I[611], I[611] = I[612], I[612] = I[613], I[613] = I[614], I[614] = I[615], I[615] = I[616], I[616] = I[617], I[617] = I[618], I[618] = I[619], I[619] = I[620], I[620] = I[621], I[621] = I[622], I[622] = I[623], I[623] = I[624], \
 _p12##x = _p11##x, _p11##x = _p10##x, _p10##x = _p9##x, _p9##x = _p8##x, _p8##x = _p7##x, _p7##x = _p6##x, _p6##x = _p5##x, _p5##x = _p4##x, _p4##x = _p3##x, _p3##x = _p2##x, _p2##x = _p1##x, _p1##x = x++, ++_n1##x, ++_n2##x, ++_n3##x, ++_n4##x, ++_n5##x, ++_n6##x, ++_n7##x, ++_n8##x, ++_n9##x, ++_n10##x, ++_n11##x, ++_n12##x)

#define cimg_get25x25(img,x,y,z,c,I,T) \
 I[0] = (T)(img)(_p12##x,_p12##y,z,c), I[1] = (T)(img)(_p11##x,_p12##y,z,c), I[2] = (T)(img)(_p10##x,_p12##y,z,c), I[3] = (T)(img)(_p9##x,_p12##y,z,c), I[4] = (T)(img)(_p8##x,_p12##y,z,c), I[5] = (T)(img)(_p7##x,_p12##y,z,c), I[6] = (T)(img)(_p6##x,_p12##y,z,c), I[7] = (T)(img)(_p5##x,_p12##y,z,c), I[8] = (T)(img)(_p4##x,_p12##y,z,c), I[9] = (T)(img)(_p3##x,_p12##y,z,c), I[10] = (T)(img)(_p2##x,_p12##y,z,c), I[11] = (T)(img)(_p1##x,_p12##y,z,c), I[12] = (T)(img)(x,_p12##y,z,c), I[13] = (T)(img)(_n1##x,_p12##y,z,c), I[14] = (T)(img)(_n2##x,_p12##y,z,c), I[15] = (T)(img)(_n3##x,_p12##y,z,c), I[16] = (T)(img)(_n4##x,_p12##y,z,c), I[17] = (T)(img)(_n5##x,_p12##y,z,c), I[18] = (T)(img)(_n6##x,_p12##y,z,c), I[19] = (T)(img)(_n7##x,_p12##y,z,c), I[20] = (T)(img)(_n8##x,_p12##y,z,c), I[21] = (T)(img)(_n9##x,_p12##y,z,c), I[22] = (T)(img)(_n10##x,_p12##y,z,c), I[23] = (T)(img)(_n11##x,_p12##y,z,c), I[24] = (T)(img)(_n12##x,_p12##y,z,c), \
 I[25] = (T)(img)(_p12##x,_p11##y,z,c), I[26] = (T)(img)(_p11##x,_p11##y,z,c), I[27] = (T)(img)(_p10##x,_p11##y,z,c), I[28] = (T)(img)(_p9##x,_p11##y,z,c), I[29] = (T)(img)(_p8##x,_p11##y,z,c), I[30] = (T)(img)(_p7##x,_p11##y,z,c), I[31] = (T)(img)(_p6##x,_p11##y,z,c), I[32] = (T)(img)(_p5##x,_p11##y,z,c), I[33] = (T)(img)(_p4##x,_p11##y,z,c), I[34] = (T)(img)(_p3##x,_p11##y,z,c), I[35] = (T)(img)(_p2##x,_p11##y,z,c), I[36] = (T)(img)(_p1##x,_p11##y,z,c), I[37] = (T)(img)(x,_p11##y,z,c), I[38] = (T)(img)(_n1##x,_p11##y,z,c), I[39] = (T)(img)(_n2##x,_p11##y,z,c), I[40] = (T)(img)(_n3##x,_p11##y,z,c), I[41] = (T)(img)(_n4##x,_p11##y,z,c), I[42] = (T)(img)(_n5##x,_p11##y,z,c), I[43] = (T)(img)(_n6##x,_p11##y,z,c), I[44] = (T)(img)(_n7##x,_p11##y,z,c), I[45] = (T)(img)(_n8##x,_p11##y,z,c), I[46] = (T)(img)(_n9##x,_p11##y,z,c), I[47] = (T)(img)(_n10##x,_p11##y,z,c), I[48] = (T)(img)(_n11##x,_p11##y,z,c), I[49] = (T)(img)(_n12##x,_p11##y,z,c), \
 I[50] = (T)(img)(_p12##x,_p10##y,z,c), I[51] = (T)(img)(_p11##x,_p10##y,z,c), I[52] = (T)(img)(_p10##x,_p10##y,z,c), I[53] = (T)(img)(_p9##x,_p10##y,z,c), I[54] = (T)(img)(_p8##x,_p10##y,z,c), I[55] = (T)(img)(_p7##x,_p10##y,z,c), I[56] = (T)(img)(_p6##x,_p10##y,z,c), I[57] = (T)(img)(_p5##x,_p10##y,z,c), I[58] = (T)(img)(_p4##x,_p10##y,z,c), I[59] = (T)(img)(_p3##x,_p10##y,z,c), I[60] = (T)(img)(_p2##x,_p10##y,z,c), I[61] = (T)(img)(_p1##x,_p10##y,z,c), I[62] = (T)(img)(x,_p10##y,z,c), I[63] = (T)(img)(_n1##x,_p10##y,z,c), I[64] = (T)(img)(_n2##x,_p10##y,z,c), I[65] = (T)(img)(_n3##x,_p10##y,z,c), I[66] = (T)(img)(_n4##x,_p10##y,z,c), I[67] = (T)(img)(_n5##x,_p10##y,z,c), I[68] = (T)(img)(_n6##x,_p10##y,z,c), I[69] = (T)(img)(_n7##x,_p10##y,z,c), I[70] = (T)(img)(_n8##x,_p10##y,z,c), I[71] = (T)(img)(_n9##x,_p10##y,z,c), I[72] = (T)(img)(_n10##x,_p10##y,z,c), I[73] = (T)(img)(_n11##x,_p10##y,z,c), I[74] = (T)(img)(_n12##x,_p10##y,z,c), \
 I[75] = (T)(img)(_p12##x,_p9##y,z,c), I[76] = (T)(img)(_p11##x,_p9##y,z,c), I[77] = (T)(img)(_p10##x,_p9##y,z,c), I[78] = (T)(img)(_p9##x,_p9##y,z,c), I[79] = (T)(img)(_p8##x,_p9##y,z,c), I[80] = (T)(img)(_p7##x,_p9##y,z,c), I[81] = (T)(img)(_p6##x,_p9##y,z,c), I[82] = (T)(img)(_p5##x,_p9##y,z,c), I[83] = (T)(img)(_p4##x,_p9##y,z,c), I[84] = (T)(img)(_p3##x,_p9##y,z,c), I[85] = (T)(img)(_p2##x,_p9##y,z,c), I[86] = (T)(img)(_p1##x,_p9##y,z,c), I[87] = (T)(img)(x,_p9##y,z,c), I[88] = (T)(img)(_n1##x,_p9##y,z,c), I[89] = (T)(img)(_n2##x,_p9##y,z,c), I[90] = (T)(img)(_n3##x,_p9##y,z,c), I[91] = (T)(img)(_n4##x,_p9##y,z,c), I[92] = (T)(img)(_n5##x,_p9##y,z,c), I[93] = (T)(img)(_n6##x,_p9##y,z,c), I[94] = (T)(img)(_n7##x,_p9##y,z,c), I[95] = (T)(img)(_n8##x,_p9##y,z,c), I[96] = (T)(img)(_n9##x,_p9##y,z,c), I[97] = (T)(img)(_n10##x,_p9##y,z,c), I[98] = (T)(img)(_n11##x,_p9##y,z,c), I[99] = (T)(img)(_n12##x,_p9##y,z,c), \
 I[100] = (T)(img)(_p12##x,_p8##y,z,c), I[101] = (T)(img)(_p11##x,_p8##y,z,c), I[102] = (T)(img)(_p10##x,_p8##y,z,c), I[103] = (T)(img)(_p9##x,_p8##y,z,c), I[104] = (T)(img)(_p8##x,_p8##y,z,c), I[105] = (T)(img)(_p7##x,_p8##y,z,c), I[106] = (T)(img)(_p6##x,_p8##y,z,c), I[107] = (T)(img)(_p5##x,_p8##y,z,c), I[108] = (T)(img)(_p4##x,_p8##y,z,c), I[109] = (T)(img)(_p3##x,_p8##y,z,c), I[110] = (T)(img)(_p2##x,_p8##y,z,c), I[111] = (T)(img)(_p1##x,_p8##y,z,c), I[112] = (T)(img)(x,_p8##y,z,c), I[113] = (T)(img)(_n1##x,_p8##y,z,c), I[114] = (T)(img)(_n2##x,_p8##y,z,c), I[115] = (T)(img)(_n3##x,_p8##y,z,c), I[116] = (T)(img)(_n4##x,_p8##y,z,c), I[117] = (T)(img)(_n5##x,_p8##y,z,c), I[118] = (T)(img)(_n6##x,_p8##y,z,c), I[119] = (T)(img)(_n7##x,_p8##y,z,c), I[120] = (T)(img)(_n8##x,_p8##y,z,c), I[121] = (T)(img)(_n9##x,_p8##y,z,c), I[122] = (T)(img)(_n10##x,_p8##y,z,c), I[123] = (T)(img)(_n11##x,_p8##y,z,c), I[124] = (T)(img)(_n12##x,_p8##y,z,c), \
 I[125] = (T)(img)(_p12##x,_p7##y,z,c), I[126] = (T)(img)(_p11##x,_p7##y,z,c), I[127] = (T)(img)(_p10##x,_p7##y,z,c), I[128] = (T)(img)(_p9##x,_p7##y,z,c), I[129] = (T)(img)(_p8##x,_p7##y,z,c), I[130] = (T)(img)(_p7##x,_p7##y,z,c), I[131] = (T)(img)(_p6##x,_p7##y,z,c), I[132] = (T)(img)(_p5##x,_p7##y,z,c), I[133] = (T)(img)(_p4##x,_p7##y,z,c), I[134] = (T)(img)(_p3##x,_p7##y,z,c), I[135] = (T)(img)(_p2##x,_p7##y,z,c), I[136] = (T)(img)(_p1##x,_p7##y,z,c), I[137] = (T)(img)(x,_p7##y,z,c), I[138] = (T)(img)(_n1##x,_p7##y,z,c), I[139] = (T)(img)(_n2##x,_p7##y,z,c), I[140] = (T)(img)(_n3##x,_p7##y,z,c), I[141] = (T)(img)(_n4##x,_p7##y,z,c), I[142] = (T)(img)(_n5##x,_p7##y,z,c), I[143] = (T)(img)(_n6##x,_p7##y,z,c), I[144] = (T)(img)(_n7##x,_p7##y,z,c), I[145] = (T)(img)(_n8##x,_p7##y,z,c), I[146] = (T)(img)(_n9##x,_p7##y,z,c), I[147] = (T)(img)(_n10##x,_p7##y,z,c), I[148] = (T)(img)(_n11##x,_p7##y,z,c), I[149] = (T)(img)(_n12##x,_p7##y,z,c), \
 I[150] = (T)(img)(_p12##x,_p6##y,z,c), I[151] = (T)(img)(_p11##x,_p6##y,z,c), I[152] = (T)(img)(_p10##x,_p6##y,z,c), I[153] = (T)(img)(_p9##x,_p6##y,z,c), I[154] = (T)(img)(_p8##x,_p6##y,z,c), I[155] = (T)(img)(_p7##x,_p6##y,z,c), I[156] = (T)(img)(_p6##x,_p6##y,z,c), I[157] = (T)(img)(_p5##x,_p6##y,z,c), I[158] = (T)(img)(_p4##x,_p6##y,z,c), I[159] = (T)(img)(_p3##x,_p6##y,z,c), I[160] = (T)(img)(_p2##x,_p6##y,z,c), I[161] = (T)(img)(_p1##x,_p6##y,z,c), I[162] = (T)(img)(x,_p6##y,z,c), I[163] = (T)(img)(_n1##x,_p6##y,z,c), I[164] = (T)(img)(_n2##x,_p6##y,z,c), I[165] = (T)(img)(_n3##x,_p6##y,z,c), I[166] = (T)(img)(_n4##x,_p6##y,z,c), I[167] = (T)(img)(_n5##x,_p6##y,z,c), I[168] = (T)(img)(_n6##x,_p6##y,z,c), I[169] = (T)(img)(_n7##x,_p6##y,z,c), I[170] = (T)(img)(_n8##x,_p6##y,z,c), I[171] = (T)(img)(_n9##x,_p6##y,z,c), I[172] = (T)(img)(_n10##x,_p6##y,z,c), I[173] = (T)(img)(_n11##x,_p6##y,z,c), I[174] = (T)(img)(_n12##x,_p6##y,z,c), \
 I[175] = (T)(img)(_p12##x,_p5##y,z,c), I[176] = (T)(img)(_p11##x,_p5##y,z,c), I[177] = (T)(img)(_p10##x,_p5##y,z,c), I[178] = (T)(img)(_p9##x,_p5##y,z,c), I[179] = (T)(img)(_p8##x,_p5##y,z,c), I[180] = (T)(img)(_p7##x,_p5##y,z,c), I[181] = (T)(img)(_p6##x,_p5##y,z,c), I[182] = (T)(img)(_p5##x,_p5##y,z,c), I[183] = (T)(img)(_p4##x,_p5##y,z,c), I[184] = (T)(img)(_p3##x,_p5##y,z,c), I[185] = (T)(img)(_p2##x,_p5##y,z,c), I[186] = (T)(img)(_p1##x,_p5##y,z,c), I[187] = (T)(img)(x,_p5##y,z,c), I[188] = (T)(img)(_n1##x,_p5##y,z,c), I[189] = (T)(img)(_n2##x,_p5##y,z,c), I[190] = (T)(img)(_n3##x,_p5##y,z,c), I[191] = (T)(img)(_n4##x,_p5##y,z,c), I[192] = (T)(img)(_n5##x,_p5##y,z,c), I[193] = (T)(img)(_n6##x,_p5##y,z,c), I[194] = (T)(img)(_n7##x,_p5##y,z,c), I[195] = (T)(img)(_n8##x,_p5##y,z,c), I[196] = (T)(img)(_n9##x,_p5##y,z,c), I[197] = (T)(img)(_n10##x,_p5##y,z,c), I[198] = (T)(img)(_n11##x,_p5##y,z,c), I[199] = (T)(img)(_n12##x,_p5##y,z,c), \
 I[200] = (T)(img)(_p12##x,_p4##y,z,c), I[201] = (T)(img)(_p11##x,_p4##y,z,c), I[202] = (T)(img)(_p10##x,_p4##y,z,c), I[203] = (T)(img)(_p9##x,_p4##y,z,c), I[204] = (T)(img)(_p8##x,_p4##y,z,c), I[205] = (T)(img)(_p7##x,_p4##y,z,c), I[206] = (T)(img)(_p6##x,_p4##y,z,c), I[207] = (T)(img)(_p5##x,_p4##y,z,c), I[208] = (T)(img)(_p4##x,_p4##y,z,c), I[209] = (T)(img)(_p3##x,_p4##y,z,c), I[210] = (T)(img)(_p2##x,_p4##y,z,c), I[211] = (T)(img)(_p1##x,_p4##y,z,c), I[212] = (T)(img)(x,_p4##y,z,c), I[213] = (T)(img)(_n1##x,_p4##y,z,c), I[214] = (T)(img)(_n2##x,_p4##y,z,c), I[215] = (T)(img)(_n3##x,_p4##y,z,c), I[216] = (T)(img)(_n4##x,_p4##y,z,c), I[217] = (T)(img)(_n5##x,_p4##y,z,c), I[218] = (T)(img)(_n6##x,_p4##y,z,c), I[219] = (T)(img)(_n7##x,_p4##y,z,c), I[220] = (T)(img)(_n8##x,_p4##y,z,c), I[221] = (T)(img)(_n9##x,_p4##y,z,c), I[222] = (T)(img)(_n10##x,_p4##y,z,c), I[223] = (T)(img)(_n11##x,_p4##y,z,c), I[224] = (T)(img)(_n12##x,_p4##y,z,c), \
 I[225] = (T)(img)(_p12##x,_p3##y,z,c), I[226] = (T)(img)(_p11##x,_p3##y,z,c), I[227] = (T)(img)(_p10##x,_p3##y,z,c), I[228] = (T)(img)(_p9##x,_p3##y,z,c), I[229] = (T)(img)(_p8##x,_p3##y,z,c), I[230] = (T)(img)(_p7##x,_p3##y,z,c), I[231] = (T)(img)(_p6##x,_p3##y,z,c), I[232] = (T)(img)(_p5##x,_p3##y,z,c), I[233] = (T)(img)(_p4##x,_p3##y,z,c), I[234] = (T)(img)(_p3##x,_p3##y,z,c), I[235] = (T)(img)(_p2##x,_p3##y,z,c), I[236] = (T)(img)(_p1##x,_p3##y,z,c), I[237] = (T)(img)(x,_p3##y,z,c), I[238] = (T)(img)(_n1##x,_p3##y,z,c), I[239] = (T)(img)(_n2##x,_p3##y,z,c), I[240] = (T)(img)(_n3##x,_p3##y,z,c), I[241] = (T)(img)(_n4##x,_p3##y,z,c), I[242] = (T)(img)(_n5##x,_p3##y,z,c), I[243] = (T)(img)(_n6##x,_p3##y,z,c), I[244] = (T)(img)(_n7##x,_p3##y,z,c), I[245] = (T)(img)(_n8##x,_p3##y,z,c), I[246] = (T)(img)(_n9##x,_p3##y,z,c), I[247] = (T)(img)(_n10##x,_p3##y,z,c), I[248] = (T)(img)(_n11##x,_p3##y,z,c), I[249] = (T)(img)(_n12##x,_p3##y,z,c), \
 I[250] = (T)(img)(_p12##x,_p2##y,z,c), I[251] = (T)(img)(_p11##x,_p2##y,z,c), I[252] = (T)(img)(_p10##x,_p2##y,z,c), I[253] = (T)(img)(_p9##x,_p2##y,z,c), I[254] = (T)(img)(_p8##x,_p2##y,z,c), I[255] = (T)(img)(_p7##x,_p2##y,z,c), I[256] = (T)(img)(_p6##x,_p2##y,z,c), I[257] = (T)(img)(_p5##x,_p2##y,z,c), I[258] = (T)(img)(_p4##x,_p2##y,z,c), I[259] = (T)(img)(_p3##x,_p2##y,z,c), I[260] = (T)(img)(_p2##x,_p2##y,z,c), I[261] = (T)(img)(_p1##x,_p2##y,z,c), I[262] = (T)(img)(x,_p2##y,z,c), I[263] = (T)(img)(_n1##x,_p2##y,z,c), I[264] = (T)(img)(_n2##x,_p2##y,z,c), I[265] = (T)(img)(_n3##x,_p2##y,z,c), I[266] = (T)(img)(_n4##x,_p2##y,z,c), I[267] = (T)(img)(_n5##x,_p2##y,z,c), I[268] = (T)(img)(_n6##x,_p2##y,z,c), I[269] = (T)(img)(_n7##x,_p2##y,z,c), I[270] = (T)(img)(_n8##x,_p2##y,z,c), I[271] = (T)(img)(_n9##x,_p2##y,z,c), I[272] = (T)(img)(_n10##x,_p2##y,z,c), I[273] = (T)(img)(_n11##x,_p2##y,z,c), I[274] = (T)(img)(_n12##x,_p2##y,z,c), \
 I[275] = (T)(img)(_p12##x,_p1##y,z,c), I[276] = (T)(img)(_p11##x,_p1##y,z,c), I[277] = (T)(img)(_p10##x,_p1##y,z,c), I[278] = (T)(img)(_p9##x,_p1##y,z,c), I[279] = (T)(img)(_p8##x,_p1##y,z,c), I[280] = (T)(img)(_p7##x,_p1##y,z,c), I[281] = (T)(img)(_p6##x,_p1##y,z,c), I[282] = (T)(img)(_p5##x,_p1##y,z,c), I[283] = (T)(img)(_p4##x,_p1##y,z,c), I[284] = (T)(img)(_p3##x,_p1##y,z,c), I[285] = (T)(img)(_p2##x,_p1##y,z,c), I[286] = (T)(img)(_p1##x,_p1##y,z,c), I[287] = (T)(img)(x,_p1##y,z,c), I[288] = (T)(img)(_n1##x,_p1##y,z,c), I[289] = (T)(img)(_n2##x,_p1##y,z,c), I[290] = (T)(img)(_n3##x,_p1##y,z,c), I[291] = (T)(img)(_n4##x,_p1##y,z,c), I[292] = (T)(img)(_n5##x,_p1##y,z,c), I[293] = (T)(img)(_n6##x,_p1##y,z,c), I[294] = (T)(img)(_n7##x,_p1##y,z,c), I[295] = (T)(img)(_n8##x,_p1##y,z,c), I[296] = (T)(img)(_n9##x,_p1##y,z,c), I[297] = (T)(img)(_n10##x,_p1##y,z,c), I[298] = (T)(img)(_n11##x,_p1##y,z,c), I[299] = (T)(img)(_n12##x,_p1##y,z,c), \
 I[300] = (T)(img)(_p12##x,y,z,c), I[301] = (T)(img)(_p11##x,y,z,c), I[302] = (T)(img)(_p10##x,y,z,c), I[303] = (T)(img)(_p9##x,y,z,c), I[304] = (T)(img)(_p8##x,y,z,c), I[305] = (T)(img)(_p7##x,y,z,c), I[306] = (T)(img)(_p6##x,y,z,c), I[307] = (T)(img)(_p5##x,y,z,c), I[308] = (T)(img)(_p4##x,y,z,c), I[309] = (T)(img)(_p3##x,y,z,c), I[310] = (T)(img)(_p2##x,y,z,c), I[311] = (T)(img)(_p1##x,y,z,c), I[312] = (T)(img)(x,y,z,c), I[313] = (T)(img)(_n1##x,y,z,c), I[314] = (T)(img)(_n2##x,y,z,c), I[315] = (T)(img)(_n3##x,y,z,c), I[316] = (T)(img)(_n4##x,y,z,c), I[317] = (T)(img)(_n5##x,y,z,c), I[318] = (T)(img)(_n6##x,y,z,c), I[319] = (T)(img)(_n7##x,y,z,c), I[320] = (T)(img)(_n8##x,y,z,c), I[321] = (T)(img)(_n9##x,y,z,c), I[322] = (T)(img)(_n10##x,y,z,c), I[323] = (T)(img)(_n11##x,y,z,c), I[324] = (T)(img)(_n12##x,y,z,c), \
 I[325] = (T)(img)(_p12##x,_n1##y,z,c), I[326] = (T)(img)(_p11##x,_n1##y,z,c), I[327] = (T)(img)(_p10##x,_n1##y,z,c), I[328] = (T)(img)(_p9##x,_n1##y,z,c), I[329] = (T)(img)(_p8##x,_n1##y,z,c), I[330] = (T)(img)(_p7##x,_n1##y,z,c), I[331] = (T)(img)(_p6##x,_n1##y,z,c), I[332] = (T)(img)(_p5##x,_n1##y,z,c), I[333] = (T)(img)(_p4##x,_n1##y,z,c), I[334] = (T)(img)(_p3##x,_n1##y,z,c), I[335] = (T)(img)(_p2##x,_n1##y,z,c), I[336] = (T)(img)(_p1##x,_n1##y,z,c), I[337] = (T)(img)(x,_n1##y,z,c), I[338] = (T)(img)(_n1##x,_n1##y,z,c), I[339] = (T)(img)(_n2##x,_n1##y,z,c), I[340] = (T)(img)(_n3##x,_n1##y,z,c), I[341] = (T)(img)(_n4##x,_n1##y,z,c), I[342] = (T)(img)(_n5##x,_n1##y,z,c), I[343] = (T)(img)(_n6##x,_n1##y,z,c), I[344] = (T)(img)(_n7##x,_n1##y,z,c), I[345] = (T)(img)(_n8##x,_n1##y,z,c), I[346] = (T)(img)(_n9##x,_n1##y,z,c), I[347] = (T)(img)(_n10##x,_n1##y,z,c), I[348] = (T)(img)(_n11##x,_n1##y,z,c), I[349] = (T)(img)(_n12##x,_n1##y,z,c), \
 I[350] = (T)(img)(_p12##x,_n2##y,z,c), I[351] = (T)(img)(_p11##x,_n2##y,z,c), I[352] = (T)(img)(_p10##x,_n2##y,z,c), I[353] = (T)(img)(_p9##x,_n2##y,z,c), I[354] = (T)(img)(_p8##x,_n2##y,z,c), I[355] = (T)(img)(_p7##x,_n2##y,z,c), I[356] = (T)(img)(_p6##x,_n2##y,z,c), I[357] = (T)(img)(_p5##x,_n2##y,z,c), I[358] = (T)(img)(_p4##x,_n2##y,z,c), I[359] = (T)(img)(_p3##x,_n2##y,z,c), I[360] = (T)(img)(_p2##x,_n2##y,z,c), I[361] = (T)(img)(_p1##x,_n2##y,z,c), I[362] = (T)(img)(x,_n2##y,z,c), I[363] = (T)(img)(_n1##x,_n2##y,z,c), I[364] = (T)(img)(_n2##x,_n2##y,z,c), I[365] = (T)(img)(_n3##x,_n2##y,z,c), I[366] = (T)(img)(_n4##x,_n2##y,z,c), I[367] = (T)(img)(_n5##x,_n2##y,z,c), I[368] = (T)(img)(_n6##x,_n2##y,z,c), I[369] = (T)(img)(_n7##x,_n2##y,z,c), I[370] = (T)(img)(_n8##x,_n2##y,z,c), I[371] = (T)(img)(_n9##x,_n2##y,z,c), I[372] = (T)(img)(_n10##x,_n2##y,z,c), I[373] = (T)(img)(_n11##x,_n2##y,z,c), I[374] = (T)(img)(_n12##x,_n2##y,z,c), \
 I[375] = (T)(img)(_p12##x,_n3##y,z,c), I[376] = (T)(img)(_p11##x,_n3##y,z,c), I[377] = (T)(img)(_p10##x,_n3##y,z,c), I[378] = (T)(img)(_p9##x,_n3##y,z,c), I[379] = (T)(img)(_p8##x,_n3##y,z,c), I[380] = (T)(img)(_p7##x,_n3##y,z,c), I[381] = (T)(img)(_p6##x,_n3##y,z,c), I[382] = (T)(img)(_p5##x,_n3##y,z,c), I[383] = (T)(img)(_p4##x,_n3##y,z,c), I[384] = (T)(img)(_p3##x,_n3##y,z,c), I[385] = (T)(img)(_p2##x,_n3##y,z,c), I[386] = (T)(img)(_p1##x,_n3##y,z,c), I[387] = (T)(img)(x,_n3##y,z,c), I[388] = (T)(img)(_n1##x,_n3##y,z,c), I[389] = (T)(img)(_n2##x,_n3##y,z,c), I[390] = (T)(img)(_n3##x,_n3##y,z,c), I[391] = (T)(img)(_n4##x,_n3##y,z,c), I[392] = (T)(img)(_n5##x,_n3##y,z,c), I[393] = (T)(img)(_n6##x,_n3##y,z,c), I[394] = (T)(img)(_n7##x,_n3##y,z,c), I[395] = (T)(img)(_n8##x,_n3##y,z,c), I[396] = (T)(img)(_n9##x,_n3##y,z,c), I[397] = (T)(img)(_n10##x,_n3##y,z,c), I[398] = (T)(img)(_n11##x,_n3##y,z,c), I[399] = (T)(img)(_n12##x,_n3##y,z,c), \
 I[400] = (T)(img)(_p12##x,_n4##y,z,c), I[401] = (T)(img)(_p11##x,_n4##y,z,c), I[402] = (T)(img)(_p10##x,_n4##y,z,c), I[403] = (T)(img)(_p9##x,_n4##y,z,c), I[404] = (T)(img)(_p8##x,_n4##y,z,c), I[405] = (T)(img)(_p7##x,_n4##y,z,c), I[406] = (T)(img)(_p6##x,_n4##y,z,c), I[407] = (T)(img)(_p5##x,_n4##y,z,c), I[408] = (T)(img)(_p4##x,_n4##y,z,c), I[409] = (T)(img)(_p3##x,_n4##y,z,c), I[410] = (T)(img)(_p2##x,_n4##y,z,c), I[411] = (T)(img)(_p1##x,_n4##y,z,c), I[412] = (T)(img)(x,_n4##y,z,c), I[413] = (T)(img)(_n1##x,_n4##y,z,c), I[414] = (T)(img)(_n2##x,_n4##y,z,c), I[415] = (T)(img)(_n3##x,_n4##y,z,c), I[416] = (T)(img)(_n4##x,_n4##y,z,c), I[417] = (T)(img)(_n5##x,_n4##y,z,c), I[418] = (T)(img)(_n6##x,_n4##y,z,c), I[419] = (T)(img)(_n7##x,_n4##y,z,c), I[420] = (T)(img)(_n8##x,_n4##y,z,c), I[421] = (T)(img)(_n9##x,_n4##y,z,c), I[422] = (T)(img)(_n10##x,_n4##y,z,c), I[423] = (T)(img)(_n11##x,_n4##y,z,c), I[424] = (T)(img)(_n12##x,_n4##y,z,c), \
 I[425] = (T)(img)(_p12##x,_n5##y,z,c), I[426] = (T)(img)(_p11##x,_n5##y,z,c), I[427] = (T)(img)(_p10##x,_n5##y,z,c), I[428] = (T)(img)(_p9##x,_n5##y,z,c), I[429] = (T)(img)(_p8##x,_n5##y,z,c), I[430] = (T)(img)(_p7##x,_n5##y,z,c), I[431] = (T)(img)(_p6##x,_n5##y,z,c), I[432] = (T)(img)(_p5##x,_n5##y,z,c), I[433] = (T)(img)(_p4##x,_n5##y,z,c), I[434] = (T)(img)(_p3##x,_n5##y,z,c), I[435] = (T)(img)(_p2##x,_n5##y,z,c), I[436] = (T)(img)(_p1##x,_n5##y,z,c), I[437] = (T)(img)(x,_n5##y,z,c), I[438] = (T)(img)(_n1##x,_n5##y,z,c), I[439] = (T)(img)(_n2##x,_n5##y,z,c), I[440] = (T)(img)(_n3##x,_n5##y,z,c), I[441] = (T)(img)(_n4##x,_n5##y,z,c), I[442] = (T)(img)(_n5##x,_n5##y,z,c), I[443] = (T)(img)(_n6##x,_n5##y,z,c), I[444] = (T)(img)(_n7##x,_n5##y,z,c), I[445] = (T)(img)(_n8##x,_n5##y,z,c), I[446] = (T)(img)(_n9##x,_n5##y,z,c), I[447] = (T)(img)(_n10##x,_n5##y,z,c), I[448] = (T)(img)(_n11##x,_n5##y,z,c), I[449] = (T)(img)(_n12##x,_n5##y,z,c), \
 I[450] = (T)(img)(_p12##x,_n6##y,z,c), I[451] = (T)(img)(_p11##x,_n6##y,z,c), I[452] = (T)(img)(_p10##x,_n6##y,z,c), I[453] = (T)(img)(_p9##x,_n6##y,z,c), I[454] = (T)(img)(_p8##x,_n6##y,z,c), I[455] = (T)(img)(_p7##x,_n6##y,z,c), I[456] = (T)(img)(_p6##x,_n6##y,z,c), I[457] = (T)(img)(_p5##x,_n6##y,z,c), I[458] = (T)(img)(_p4##x,_n6##y,z,c), I[459] = (T)(img)(_p3##x,_n6##y,z,c), I[460] = (T)(img)(_p2##x,_n6##y,z,c), I[461] = (T)(img)(_p1##x,_n6##y,z,c), I[462] = (T)(img)(x,_n6##y,z,c), I[463] = (T)(img)(_n1##x,_n6##y,z,c), I[464] = (T)(img)(_n2##x,_n6##y,z,c), I[465] = (T)(img)(_n3##x,_n6##y,z,c), I[466] = (T)(img)(_n4##x,_n6##y,z,c), I[467] = (T)(img)(_n5##x,_n6##y,z,c), I[468] = (T)(img)(_n6##x,_n6##y,z,c), I[469] = (T)(img)(_n7##x,_n6##y,z,c), I[470] = (T)(img)(_n8##x,_n6##y,z,c), I[471] = (T)(img)(_n9##x,_n6##y,z,c), I[472] = (T)(img)(_n10##x,_n6##y,z,c), I[473] = (T)(img)(_n11##x,_n6##y,z,c), I[474] = (T)(img)(_n12##x,_n6##y,z,c), \
 I[475] = (T)(img)(_p12##x,_n7##y,z,c), I[476] = (T)(img)(_p11##x,_n7##y,z,c), I[477] = (T)(img)(_p10##x,_n7##y,z,c), I[478] = (T)(img)(_p9##x,_n7##y,z,c), I[479] = (T)(img)(_p8##x,_n7##y,z,c), I[480] = (T)(img)(_p7##x,_n7##y,z,c), I[481] = (T)(img)(_p6##x,_n7##y,z,c), I[482] = (T)(img)(_p5##x,_n7##y,z,c), I[483] = (T)(img)(_p4##x,_n7##y,z,c), I[484] = (T)(img)(_p3##x,_n7##y,z,c), I[485] = (T)(img)(_p2##x,_n7##y,z,c), I[486] = (T)(img)(_p1##x,_n7##y,z,c), I[487] = (T)(img)(x,_n7##y,z,c), I[488] = (T)(img)(_n1##x,_n7##y,z,c), I[489] = (T)(img)(_n2##x,_n7##y,z,c), I[490] = (T)(img)(_n3##x,_n7##y,z,c), I[491] = (T)(img)(_n4##x,_n7##y,z,c), I[492] = (T)(img)(_n5##x,_n7##y,z,c), I[493] = (T)(img)(_n6##x,_n7##y,z,c), I[494] = (T)(img)(_n7##x,_n7##y,z,c), I[495] = (T)(img)(_n8##x,_n7##y,z,c), I[496] = (T)(img)(_n9##x,_n7##y,z,c), I[497] = (T)(img)(_n10##x,_n7##y,z,c), I[498] = (T)(img)(_n11##x,_n7##y,z,c), I[499] = (T)(img)(_n12##x,_n7##y,z,c), \
 I[500] = (T)(img)(_p12##x,_n8##y,z,c), I[501] = (T)(img)(_p11##x,_n8##y,z,c), I[502] = (T)(img)(_p10##x,_n8##y,z,c), I[503] = (T)(img)(_p9##x,_n8##y,z,c), I[504] = (T)(img)(_p8##x,_n8##y,z,c), I[505] = (T)(img)(_p7##x,_n8##y,z,c), I[506] = (T)(img)(_p6##x,_n8##y,z,c), I[507] = (T)(img)(_p5##x,_n8##y,z,c), I[508] = (T)(img)(_p4##x,_n8##y,z,c), I[509] = (T)(img)(_p3##x,_n8##y,z,c), I[510] = (T)(img)(_p2##x,_n8##y,z,c), I[511] = (T)(img)(_p1##x,_n8##y,z,c), I[512] = (T)(img)(x,_n8##y,z,c), I[513] = (T)(img)(_n1##x,_n8##y,z,c), I[514] = (T)(img)(_n2##x,_n8##y,z,c), I[515] = (T)(img)(_n3##x,_n8##y,z,c), I[516] = (T)(img)(_n4##x,_n8##y,z,c), I[517] = (T)(img)(_n5##x,_n8##y,z,c), I[518] = (T)(img)(_n6##x,_n8##y,z,c), I[519] = (T)(img)(_n7##x,_n8##y,z,c), I[520] = (T)(img)(_n8##x,_n8##y,z,c), I[521] = (T)(img)(_n9##x,_n8##y,z,c), I[522] = (T)(img)(_n10##x,_n8##y,z,c), I[523] = (T)(img)(_n11##x,_n8##y,z,c), I[524] = (T)(img)(_n12##x,_n8##y,z,c), \
 I[525] = (T)(img)(_p12##x,_n9##y,z,c), I[526] = (T)(img)(_p11##x,_n9##y,z,c), I[527] = (T)(img)(_p10##x,_n9##y,z,c), I[528] = (T)(img)(_p9##x,_n9##y,z,c), I[529] = (T)(img)(_p8##x,_n9##y,z,c), I[530] = (T)(img)(_p7##x,_n9##y,z,c), I[531] = (T)(img)(_p6##x,_n9##y,z,c), I[532] = (T)(img)(_p5##x,_n9##y,z,c), I[533] = (T)(img)(_p4##x,_n9##y,z,c), I[534] = (T)(img)(_p3##x,_n9##y,z,c), I[535] = (T)(img)(_p2##x,_n9##y,z,c), I[536] = (T)(img)(_p1##x,_n9##y,z,c), I[537] = (T)(img)(x,_n9##y,z,c), I[538] = (T)(img)(_n1##x,_n9##y,z,c), I[539] = (T)(img)(_n2##x,_n9##y,z,c), I[540] = (T)(img)(_n3##x,_n9##y,z,c), I[541] = (T)(img)(_n4##x,_n9##y,z,c), I[542] = (T)(img)(_n5##x,_n9##y,z,c), I[543] = (T)(img)(_n6##x,_n9##y,z,c), I[544] = (T)(img)(_n7##x,_n9##y,z,c), I[545] = (T)(img)(_n8##x,_n9##y,z,c), I[546] = (T)(img)(_n9##x,_n9##y,z,c), I[547] = (T)(img)(_n10##x,_n9##y,z,c), I[548] = (T)(img)(_n11##x,_n9##y,z,c), I[549] = (T)(img)(_n12##x,_n9##y,z,c), \
 I[550] = (T)(img)(_p12##x,_n10##y,z,c), I[551] = (T)(img)(_p11##x,_n10##y,z,c), I[552] = (T)(img)(_p10##x,_n10##y,z,c), I[553] = (T)(img)(_p9##x,_n10##y,z,c), I[554] = (T)(img)(_p8##x,_n10##y,z,c), I[555] = (T)(img)(_p7##x,_n10##y,z,c), I[556] = (T)(img)(_p6##x,_n10##y,z,c), I[557] = (T)(img)(_p5##x,_n10##y,z,c), I[558] = (T)(img)(_p4##x,_n10##y,z,c), I[559] = (T)(img)(_p3##x,_n10##y,z,c), I[560] = (T)(img)(_p2##x,_n10##y,z,c), I[561] = (T)(img)(_p1##x,_n10##y,z,c), I[562] = (T)(img)(x,_n10##y,z,c), I[563] = (T)(img)(_n1##x,_n10##y,z,c), I[564] = (T)(img)(_n2##x,_n10##y,z,c), I[565] = (T)(img)(_n3##x,_n10##y,z,c), I[566] = (T)(img)(_n4##x,_n10##y,z,c), I[567] = (T)(img)(_n5##x,_n10##y,z,c), I[568] = (T)(img)(_n6##x,_n10##y,z,c), I[569] = (T)(img)(_n7##x,_n10##y,z,c), I[570] = (T)(img)(_n8##x,_n10##y,z,c), I[571] = (T)(img)(_n9##x,_n10##y,z,c), I[572] = (T)(img)(_n10##x,_n10##y,z,c), I[573] = (T)(img)(_n11##x,_n10##y,z,c), I[574] = (T)(img)(_n12##x,_n10##y,z,c), \
 I[575] = (T)(img)(_p12##x,_n11##y,z,c), I[576] = (T)(img)(_p11##x,_n11##y,z,c), I[577] = (T)(img)(_p10##x,_n11##y,z,c), I[578] = (T)(img)(_p9##x,_n11##y,z,c), I[579] = (T)(img)(_p8##x,_n11##y,z,c), I[580] = (T)(img)(_p7##x,_n11##y,z,c), I[581] = (T)(img)(_p6##x,_n11##y,z,c), I[582] = (T)(img)(_p5##x,_n11##y,z,c), I[583] = (T)(img)(_p4##x,_n11##y,z,c), I[584] = (T)(img)(_p3##x,_n11##y,z,c), I[585] = (T)(img)(_p2##x,_n11##y,z,c), I[586] = (T)(img)(_p1##x,_n11##y,z,c), I[587] = (T)(img)(x,_n11##y,z,c), I[588] = (T)(img)(_n1##x,_n11##y,z,c), I[589] = (T)(img)(_n2##x,_n11##y,z,c), I[590] = (T)(img)(_n3##x,_n11##y,z,c), I[591] = (T)(img)(_n4##x,_n11##y,z,c), I[592] = (T)(img)(_n5##x,_n11##y,z,c), I[593] = (T)(img)(_n6##x,_n11##y,z,c), I[594] = (T)(img)(_n7##x,_n11##y,z,c), I[595] = (T)(img)(_n8##x,_n11##y,z,c), I[596] = (T)(img)(_n9##x,_n11##y,z,c), I[597] = (T)(img)(_n10##x,_n11##y,z,c), I[598] = (T)(img)(_n11##x,_n11##y,z,c), I[599] = (T)(img)(_n12##x,_n11##y,z,c), \
 I[600] = (T)(img)(_p12##x,_n12##y,z,c), I[601] = (T)(img)(_p11##x,_n12##y,z,c), I[602] = (T)(img)(_p10##x,_n12##y,z,c), I[603] = (T)(img)(_p9##x,_n12##y,z,c), I[604] = (T)(img)(_p8##x,_n12##y,z,c), I[605] = (T)(img)(_p7##x,_n12##y,z,c), I[606] = (T)(img)(_p6##x,_n12##y,z,c), I[607] = (T)(img)(_p5##x,_n12##y,z,c), I[608] = (T)(img)(_p4##x,_n12##y,z,c), I[609] = (T)(img)(_p3##x,_n12##y,z,c), I[610] = (T)(img)(_p2##x,_n12##y,z,c), I[611] = (T)(img)(_p1##x,_n12##y,z,c), I[612] = (T)(img)(x,_n12##y,z,c), I[613] = (T)(img)(_n1##x,_n12##y,z,c), I[614] = (T)(img)(_n2##x,_n12##y,z,c), I[615] = (T)(img)(_n3##x,_n12##y,z,c), I[616] = (T)(img)(_n4##x,_n12##y,z,c), I[617] = (T)(img)(_n5##x,_n12##y,z,c), I[618] = (T)(img)(_n6##x,_n12##y,z,c), I[619] = (T)(img)(_n7##x,_n12##y,z,c), I[620] = (T)(img)(_n8##x,_n12##y,z,c), I[621] = (T)(img)(_n9##x,_n12##y,z,c), I[622] = (T)(img)(_n10##x,_n12##y,z,c), I[623] = (T)(img)(_n11##x,_n12##y,z,c), I[624] = (T)(img)(_n12##x,_n12##y,z,c);

// Define 26x26 loop macros
//-------------------------
#define cimg_for26(bound,i) for (int i = 0, \
 _p12##i = 0, _p11##i = 0, _p10##i = 0, _p9##i = 0, _p8##i = 0, _p7##i = 0, _p6##i = 0, _p5##i = 0, _p4##i = 0, _p3##i = 0, _p2##i = 0, _p1##i = 0, \
 _n1##i = 1>=(int)(bound)?(int)(bound)-1:1, \
 _n2##i = 2>=(int)(bound)?(int)(bound)-1:2, \
 _n3##i = 3>=(int)(bound)?(int)(bound)-1:3, \
 _n4##i = 4>=(int)(bound)?(int)(bound)-1:4, \
 _n5##i = 5>=(int)(bound)?(int)(bound)-1:5, \
 _n6##i = 6>=(int)(bound)?(int)(bound)-1:6, \
 _n7##i = 7>=(int)(bound)?(int)(bound)-1:7, \
 _n8##i = 8>=(int)(bound)?(int)(bound)-1:8, \
 _n9##i = 9>=(int)(bound)?(int)(bound)-1:9, \
 _n10##i = 10>=(int)(bound)?(int)(bound)-1:10, \
 _n11##i = 11>=(int)(bound)?(int)(bound)-1:11, \
 _n12##i = 12>=(int)(bound)?(int)(bound)-1:12, \
 _n13##i = 13>=(int)(bound)?(int)(bound)-1:13; \
 _n13##i<(int)(bound) || _n12##i==--_n13##i || _n11##i==--_n12##i || _n10##i==--_n11##i || _n9##i==--_n10##i || _n8##i==--_n9##i || _n7##i==--_n8##i || _n6##i==--_n7##i || _n5##i==--_n6##i || _n4##i==--_n5##i || _n3##i==--_n4##i || _n2##i==--_n3##i || _n1##i==--_n2##i || \
 i==(_n13##i = _n12##i = _n11##i = _n10##i = _n9##i = _n8##i = _n7##i = _n6##i = _n5##i = _n4##i = _n3##i = _n2##i = --_n1##i); \
 _p12##i = _p11##i, _p11##i = _p10##i, _p10##i = _p9##i, _p9##i = _p8##i, _p8##i = _p7##i, _p7##i = _p6##i, _p6##i = _p5##i, _p5##i = _p4##i, _p4##i = _p3##i, _p3##i = _p2##i, _p2##i = _p1##i, _p1##i = i++, \
 ++_n1##i, ++_n2##i, ++_n3##i, ++_n4##i, ++_n5##i, ++_n6##i, ++_n7##i, ++_n8##i, ++_n9##i, ++_n10##i, ++_n11##i, ++_n12##i, ++_n13##i)

#define cimg_for26X(img,x) cimg_for26((img)._width,x)
#define cimg_for26Y(img,y) cimg_for26((img)._height,y)
#define cimg_for26Z(img,z) cimg_for26((img)._depth,z)
#define cimg_for26C(img,c) cimg_for26((img)._spectrum,c)
#define cimg_for26XY(img,x,y) cimg_for26Y(img,y) cimg_for26X(img,x)
#define cimg_for26XZ(img,x,z) cimg_for26Z(img,z) cimg_for26X(img,x)
#define cimg_for26XC(img,x,c) cimg_for26C(img,c) cimg_for26X(img,x)
#define cimg_for26YZ(img,y,z) cimg_for26Z(img,z) cimg_for26Y(img,y)
#define cimg_for26YC(img,y,c) cimg_for26C(img,c) cimg_for26Y(img,y)
#define cimg_for26ZC(img,z,c) cimg_for26C(img,c) cimg_for26Z(img,z)
#define cimg_for26XYZ(img,x,y,z) cimg_for26Z(img,z) cimg_for26XY(img,x,y)
#define cimg_for26XZC(img,x,z,c) cimg_for26C(img,c) cimg_for26XZ(img,x,z)
#define cimg_for26YZC(img,y,z,c) cimg_for26C(img,c) cimg_for26YZ(img,y,z)
#define cimg_for26XYZC(img,x,y,z,c) cimg_for26C(img,c) cimg_for26XYZ(img,x,y,z)

#define cimg_for_in26(bound,i0,i1,i) for (int i = (int)(i0)<0?0:(int)(i0), \
 _p12##i = i-12<0?0:i-12, \
 _p11##i = i-11<0?0:i-11, \
 _p10##i = i-10<0?0:i-10, \
 _p9##i = i-9<0?0:i-9, \
 _p8##i = i-8<0?0:i-8, \
 _p7##i = i-7<0?0:i-7, \
 _p6##i = i-6<0?0:i-6, \
 _p5##i = i-5<0?0:i-5, \
 _p4##i = i-4<0?0:i-4, \
 _p3##i = i-3<0?0:i-3, \
 _p2##i = i-2<0?0:i-2, \
 _p1##i = i-1<0?0:i-1, \
 _n1##i = i+1>=(int)(bound)?(int)(bound)-1:i+1, \
 _n2##i = i+2>=(int)(bound)?(int)(bound)-1:i+2, \
 _n3##i = i+3>=(int)(bound)?(int)(bound)-1:i+3, \
 _n4##i = i+4>=(int)(bound)?(int)(bound)-1:i+4, \
 _n5##i = i+5>=(int)(bound)?(int)(bound)-1:i+5, \
 _n6##i = i+6>=(int)(bound)?(int)(bound)-1:i+6, \
 _n7##i = i+7>=(int)(bound)?(int)(bound)-1:i+7, \
 _n8##i = i+8>=(int)(bound)?(int)(bound)-1:i+8, \
 _n9##i = i+9>=(int)(bound)?(int)(bound)-1:i+9, \
 _n10##i = i+10>=(int)(bound)?(int)(bound)-1:i+10, \
 _n11##i = i+11>=(int)(bound)?(int)(bound)-1:i+11, \
 _n12##i = i+12>=(int)(bound)?(int)(bound)-1:i+12, \
 _n13##i = i+13>=(int)(bound)?(int)(bound)-1:i+13; \
 i<=(int)(i1) && (_n13##i<(int)(bound) || _n12##i==--_n13##i || _n11##i==--_n12##i || _n10##i==--_n11##i || _n9##i==--_n10##i || _n8##i==--_n9##i || _n7##i==--_n8##i || _n6##i==--_n7##i || _n5##i==--_n6##i || _n4##i==--_n5##i || _n3##i==--_n4##i || _n2##i==--_n3##i || _n1##i==--_n2##i || \
 i==(_n13##i = _n12##i = _n11##i = _n10##i = _n9##i = _n8##i = _n7##i = _n6##i = _n5##i = _n4##i = _n3##i = _n2##i = --_n1##i)); \
 _p12##i = _p11##i, _p11##i = _p10##i, _p10##i = _p9##i, _p9##i = _p8##i, _p8##i = _p7##i, _p7##i = _p6##i, _p6##i = _p5##i, _p5##i = _p4##i, _p4##i = _p3##i, _p3##i = _p2##i, _p2##i = _p1##i, _p1##i = i++, \
 ++_n1##i, ++_n2##i, ++_n3##i, ++_n4##i, ++_n5##i, ++_n6##i, ++_n7##i, ++_n8##i, ++_n9##i, ++_n10##i, ++_n11##i, ++_n12##i, ++_n13##i)

#define cimg_for_in26X(img,x0,x1,x) cimg_for_in26((img)._width,x0,x1,x)
#define cimg_for_in26Y(img,y0,y1,y) cimg_for_in26((img)._height,y0,y1,y)
#define cimg_for_in26Z(img,z0,z1,z) cimg_for_in26((img)._depth,z0,z1,z)
#define cimg_for_in26C(img,c0,c1,c) cimg_for_in26((img)._spectrum,c0,c1,c)
#define cimg_for_in26XY(img,x0,y0,x1,y1,x,y) cimg_for_in26Y(img,y0,y1,y) cimg_for_in26X(img,x0,x1,x)
#define cimg_for_in26XZ(img,x0,z0,x1,z1,x,z) cimg_for_in26Z(img,z0,z1,z) cimg_for_in26X(img,x0,x1,x)
#define cimg_for_in26XC(img,x0,c0,x1,c1,x,c) cimg_for_in26C(img,c0,c1,c) cimg_for_in26X(img,x0,x1,x)
#define cimg_for_in26YZ(img,y0,z0,y1,z1,y,z) cimg_for_in26Z(img,z0,z1,z) cimg_for_in26Y(img,y0,y1,y)
#define cimg_for_in26YC(img,y0,c0,y1,c1,y,c) cimg_for_in26C(img,c0,c1,c) cimg_for_in26Y(img,y0,y1,y)
#define cimg_for_in26ZC(img,z0,c0,z1,c1,z,c) cimg_for_in26C(img,c0,c1,c) cimg_for_in26Z(img,z0,z1,z)
#define cimg_for_in26XYZ(img,x0,y0,z0,x1,y1,z1,x,y,z) cimg_for_in26Z(img,z0,z1,z) cimg_for_in26XY(img,x0,y0,x1,y1,x,y)
#define cimg_for_in26XZC(img,x0,z0,c0,x1,y1,c1,x,z,c) cimg_for_in26C(img,c0,c1,c) cimg_for_in26XZ(img,x0,y0,x1,y1,x,z)
#define cimg_for_in26YZC(img,y0,z0,c0,y1,z1,c1,y,z,c) cimg_for_in26C(img,c0,c1,c) cimg_for_in26YZ(img,y0,z0,y1,z1,y,z)
#define cimg_for_in26XYZC(img,x0,y0,z0,c0,x1,y1,z1,c1,x,y,z,c) cimg_for_in26C(img,c0,c1,c) cimg_for_in26XYZ(img,x0,y0,z0,x1,y1,z1,x,y,z)

#define cimg_for26x26(img,x,y,z,c,I,T) \
 cimg_for26((img)._height,y) for (int x = 0, \
 _p12##x = 0, _p11##x = 0, _p10##x = 0, _p9##x = 0, _p8##x = 0, _p7##x = 0, _p6##x = 0, _p5##x = 0, _p4##x = 0, _p3##x = 0, _p2##x = 0, _p1##x = 0, \
 _n1##x = 1>=((img)._width)?(img).width()-1:1, \
 _n2##x = 2>=((img)._width)?(img).width()-1:2, \
 _n3##x = 3>=((img)._width)?(img).width()-1:3, \
 _n4##x = 4>=((img)._width)?(img).width()-1:4, \
 _n5##x = 5>=((img)._width)?(img).width()-1:5, \
 _n6##x = 6>=((img)._width)?(img).width()-1:6, \
 _n7##x = 7>=((img)._width)?(img).width()-1:7, \
 _n8##x = 8>=((img)._width)?(img).width()-1:8, \
 _n9##x = 9>=((img)._width)?(img).width()-1:9, \
 _n10##x = 10>=((img)._width)?(img).width()-1:10, \
 _n11##x = 11>=((img)._width)?(img).width()-1:11, \
 _n12##x = 12>=((img)._width)?(img).width()-1:12, \
 _n13##x = (int)( \
 (I[0] = I[1] = I[2] = I[3] = I[4] = I[5] = I[6] = I[7] = I[8] = I[9] = I[10] = I[11] = I[12] = (T)(img)(0,_p12##y,z,c)), \
 (I[26] = I[27] = I[28] = I[29] = I[30] = I[31] = I[32] = I[33] = I[34] = I[35] = I[36] = I[37] = I[38] = (T)(img)(0,_p11##y,z,c)), \
 (I[52] = I[53] = I[54] = I[55] = I[56] = I[57] = I[58] = I[59] = I[60] = I[61] = I[62] = I[63] = I[64] = (T)(img)(0,_p10##y,z,c)), \
 (I[78] = I[79] = I[80] = I[81] = I[82] = I[83] = I[84] = I[85] = I[86] = I[87] = I[88] = I[89] = I[90] = (T)(img)(0,_p9##y,z,c)), \
 (I[104] = I[105] = I[106] = I[107] = I[108] = I[109] = I[110] = I[111] = I[112] = I[113] = I[114] = I[115] = I[116] = (T)(img)(0,_p8##y,z,c)), \
 (I[130] = I[131] = I[132] = I[133] = I[134] = I[135] = I[136] = I[137] = I[138] = I[139] = I[140] = I[141] = I[142] = (T)(img)(0,_p7##y,z,c)), \
 (I[156] = I[157] = I[158] = I[159] = I[160] = I[161] = I[162] = I[163] = I[164] = I[165] = I[166] = I[167] = I[168] = (T)(img)(0,_p6##y,z,c)), \
 (I[182] = I[183] = I[184] = I[185] = I[186] = I[187] = I[188] = I[189] = I[190] = I[191] = I[192] = I[193] = I[194] = (T)(img)(0,_p5##y,z,c)), \
 (I[208] = I[209] = I[210] = I[211] = I[212] = I[213] = I[214] = I[215] = I[216] = I[217] = I[218] = I[219] = I[220] = (T)(img)(0,_p4##y,z,c)), \
 (I[234] = I[235] = I[236] = I[237] = I[238] = I[239] = I[240] = I[241] = I[242] = I[243] = I[244] = I[245] = I[246] = (T)(img)(0,_p3##y,z,c)), \
 (I[260] = I[261] = I[262] = I[263] = I[264] = I[265] = I[266] = I[267] = I[268] = I[269] = I[270] = I[271] = I[272] = (T)(img)(0,_p2##y,z,c)), \
 (I[286] = I[287] = I[288] = I[289] = I[290] = I[291] = I[292] = I[293] = I[294] = I[295] = I[296] = I[297] = I[298] = (T)(img)(0,_p1##y,z,c)), \
 (I[312] = I[313] = I[314] = I[315] = I[316] = I[317] = I[318] = I[319] = I[320] = I[321] = I[322] = I[323] = I[324] = (T)(img)(0,y,z,c)), \
 (I[338] = I[339] = I[340] = I[341] = I[342] = I[343] = I[344] = I[345] = I[346] = I[347] = I[348] = I[349] = I[350] = (T)(img)(0,_n1##y,z,c)), \
 (I[364] = I[365] = I[366] = I[367] = I[368] = I[369] = I[370] = I[371] = I[372] = I[373] = I[374] = I[375] = I[376] = (T)(img)(0,_n2##y,z,c)), \
 (I[390] = I[391] = I[392] = I[393] = I[394] = I[395] = I[396] = I[397] = I[398] = I[399] = I[400] = I[401] = I[402] = (T)(img)(0,_n3##y,z,c)), \
 (I[416] = I[417] = I[418] = I[419] = I[420] = I[421] = I[422] = I[423] = I[424] = I[425] = I[426] = I[427] = I[428] = (T)(img)(0,_n4##y,z,c)), \
 (I[442] = I[443] = I[444] = I[445] = I[446] = I[447] = I[448] = I[449] = I[450] = I[451] = I[452] = I[453] = I[454] = (T)(img)(0,_n5##y,z,c)), \
 (I[468] = I[469] = I[470] = I[471] = I[472] = I[473] = I[474] = I[475] = I[476] = I[477] = I[478] = I[479] = I[480] = (T)(img)(0,_n6##y,z,c)), \
 (I[494] = I[495] = I[496] = I[497] = I[498] = I[499] = I[500] = I[501] = I[502] = I[503] = I[504] = I[505] = I[506] = (T)(img)(0,_n7##y,z,c)), \
 (I[520] = I[521] = I[522] = I[523] = I[524] = I[525] = I[526] = I[527] = I[528] = I[529] = I[530] = I[531] = I[532] = (T)(img)(0,_n8##y,z,c)), \
 (I[546] = I[547] = I[548] = I[549] = I[550] = I[551] = I[552] = I[553] = I[554] = I[555] = I[556] = I[557] = I[558] = (T)(img)(0,_n9##y,z,c)), \
 (I[572] = I[573] = I[574] = I[575] = I[576] = I[577] = I[578] = I[579] = I[580] = I[581] = I[582] = I[583] = I[584] = (T)(img)(0,_n10##y,z,c)), \
 (I[598] = I[599] = I[600] = I[601] = I[602] = I[603] = I[604] = I[605] = I[606] = I[607] = I[608] = I[609] = I[610] = (T)(img)(0,_n11##y,z,c)), \
 (I[624] = I[625] = I[626] = I[627] = I[628] = I[629] = I[630] = I[631] = I[632] = I[633] = I[634] = I[635] = I[636] = (T)(img)(0,_n12##y,z,c)), \
 (I[650] = I[651] = I[652] = I[653] = I[654] = I[655] = I[656] = I[657] = I[658] = I[659] = I[660] = I[661] = I[662] = (T)(img)(0,_n13##y,z,c)), \
 (I[13] = (T)(img)(_n1##x,_p12##y,z,c)), \
 (I[39] = (T)(img)(_n1##x,_p11##y,z,c)), \
 (I[65] = (T)(img)(_n1##x,_p10##y,z,c)), \
 (I[91] = (T)(img)(_n1##x,_p9##y,z,c)), \
 (I[117] = (T)(img)(_n1##x,_p8##y,z,c)), \
 (I[143] = (T)(img)(_n1##x,_p7##y,z,c)), \
 (I[169] = (T)(img)(_n1##x,_p6##y,z,c)), \
 (I[195] = (T)(img)(_n1##x,_p5##y,z,c)), \
 (I[221] = (T)(img)(_n1##x,_p4##y,z,c)), \
 (I[247] = (T)(img)(_n1##x,_p3##y,z,c)), \
 (I[273] = (T)(img)(_n1##x,_p2##y,z,c)), \
 (I[299] = (T)(img)(_n1##x,_p1##y,z,c)), \
 (I[325] = (T)(img)(_n1##x,y,z,c)), \
 (I[351] = (T)(img)(_n1##x,_n1##y,z,c)), \
 (I[377] = (T)(img)(_n1##x,_n2##y,z,c)), \
 (I[403] = (T)(img)(_n1##x,_n3##y,z,c)), \
 (I[429] = (T)(img)(_n1##x,_n4##y,z,c)), \
 (I[455] = (T)(img)(_n1##x,_n5##y,z,c)), \
 (I[481] = (T)(img)(_n1##x,_n6##y,z,c)), \
 (I[507] = (T)(img)(_n1##x,_n7##y,z,c)), \
 (I[533] = (T)(img)(_n1##x,_n8##y,z,c)), \
 (I[559] = (T)(img)(_n1##x,_n9##y,z,c)), \
 (I[585] = (T)(img)(_n1##x,_n10##y,z,c)), \
 (I[611] = (T)(img)(_n1##x,_n11##y,z,c)), \
 (I[637] = (T)(img)(_n1##x,_n12##y,z,c)), \
 (I[663] = (T)(img)(_n1##x,_n13##y,z,c)), \
 (I[14] = (T)(img)(_n2##x,_p12##y,z,c)), \
 (I[40] = (T)(img)(_n2##x,_p11##y,z,c)), \
 (I[66] = (T)(img)(_n2##x,_p10##y,z,c)), \
 (I[92] = (T)(img)(_n2##x,_p9##y,z,c)), \
 (I[118] = (T)(img)(_n2##x,_p8##y,z,c)), \
 (I[144] = (T)(img)(_n2##x,_p7##y,z,c)), \
 (I[170] = (T)(img)(_n2##x,_p6##y,z,c)), \
 (I[196] = (T)(img)(_n2##x,_p5##y,z,c)), \
 (I[222] = (T)(img)(_n2##x,_p4##y,z,c)), \
 (I[248] = (T)(img)(_n2##x,_p3##y,z,c)), \
 (I[274] = (T)(img)(_n2##x,_p2##y,z,c)), \
 (I[300] = (T)(img)(_n2##x,_p1##y,z,c)), \
 (I[326] = (T)(img)(_n2##x,y,z,c)), \
 (I[352] = (T)(img)(_n2##x,_n1##y,z,c)), \
 (I[378] = (T)(img)(_n2##x,_n2##y,z,c)), \
 (I[404] = (T)(img)(_n2##x,_n3##y,z,c)), \
 (I[430] = (T)(img)(_n2##x,_n4##y,z,c)), \
 (I[456] = (T)(img)(_n2##x,_n5##y,z,c)), \
 (I[482] = (T)(img)(_n2##x,_n6##y,z,c)), \
 (I[508] = (T)(img)(_n2##x,_n7##y,z,c)), \
 (I[534] = (T)(img)(_n2##x,_n8##y,z,c)), \
 (I[560] = (T)(img)(_n2##x,_n9##y,z,c)), \
 (I[586] = (T)(img)(_n2##x,_n10##y,z,c)), \
 (I[612] = (T)(img)(_n2##x,_n11##y,z,c)), \
 (I[638] = (T)(img)(_n2##x,_n12##y,z,c)), \
 (I[664] = (T)(img)(_n2##x,_n13##y,z,c)), \
 (I[15] = (T)(img)(_n3##x,_p12##y,z,c)), \
 (I[41] = (T)(img)(_n3##x,_p11##y,z,c)), \
 (I[67] = (T)(img)(_n3##x,_p10##y,z,c)), \
 (I[93] = (T)(img)(_n3##x,_p9##y,z,c)), \
 (I[119] = (T)(img)(_n3##x,_p8##y,z,c)), \
 (I[145] = (T)(img)(_n3##x,_p7##y,z,c)), \
 (I[171] = (T)(img)(_n3##x,_p6##y,z,c)), \
 (I[197] = (T)(img)(_n3##x,_p5##y,z,c)), \
 (I[223] = (T)(img)(_n3##x,_p4##y,z,c)), \
 (I[249] = (T)(img)(_n3##x,_p3##y,z,c)), \
 (I[275] = (T)(img)(_n3##x,_p2##y,z,c)), \
 (I[301] = (T)(img)(_n3##x,_p1##y,z,c)), \
 (I[327] = (T)(img)(_n3##x,y,z,c)), \
 (I[353] = (T)(img)(_n3##x,_n1##y,z,c)), \
 (I[379] = (T)(img)(_n3##x,_n2##y,z,c)), \
 (I[405] = (T)(img)(_n3##x,_n3##y,z,c)), \
 (I[431] = (T)(img)(_n3##x,_n4##y,z,c)), \
 (I[457] = (T)(img)(_n3##x,_n5##y,z,c)), \
 (I[483] = (T)(img)(_n3##x,_n6##y,z,c)), \
 (I[509] = (T)(img)(_n3##x,_n7##y,z,c)), \
 (I[535] = (T)(img)(_n3##x,_n8##y,z,c)), \
 (I[561] = (T)(img)(_n3##x,_n9##y,z,c)), \
 (I[587] = (T)(img)(_n3##x,_n10##y,z,c)), \
 (I[613] = (T)(img)(_n3##x,_n11##y,z,c)), \
 (I[639] = (T)(img)(_n3##x,_n12##y,z,c)), \
 (I[665] = (T)(img)(_n3##x,_n13##y,z,c)), \
 (I[16] = (T)(img)(_n4##x,_p12##y,z,c)), \
 (I[42] = (T)(img)(_n4##x,_p11##y,z,c)), \
 (I[68] = (T)(img)(_n4##x,_p10##y,z,c)), \
 (I[94] = (T)(img)(_n4##x,_p9##y,z,c)), \
 (I[120] = (T)(img)(_n4##x,_p8##y,z,c)), \
 (I[146] = (T)(img)(_n4##x,_p7##y,z,c)), \
 (I[172] = (T)(img)(_n4##x,_p6##y,z,c)), \
 (I[198] = (T)(img)(_n4##x,_p5##y,z,c)), \
 (I[224] = (T)(img)(_n4##x,_p4##y,z,c)), \
 (I[250] = (T)(img)(_n4##x,_p3##y,z,c)), \
 (I[276] = (T)(img)(_n4##x,_p2##y,z,c)), \
 (I[302] = (T)(img)(_n4##x,_p1##y,z,c)), \
 (I[328] = (T)(img)(_n4##x,y,z,c)), \
 (I[354] = (T)(img)(_n4##x,_n1##y,z,c)), \
 (I[380] = (T)(img)(_n4##x,_n2##y,z,c)), \
 (I[406] = (T)(img)(_n4##x,_n3##y,z,c)), \
 (I[432] = (T)(img)(_n4##x,_n4##y,z,c)), \
 (I[458] = (T)(img)(_n4##x,_n5##y,z,c)), \
 (I[484] = (T)(img)(_n4##x,_n6##y,z,c)), \
 (I[510] = (T)(img)(_n4##x,_n7##y,z,c)), \
 (I[536] = (T)(img)(_n4##x,_n8##y,z,c)), \
 (I[562] = (T)(img)(_n4##x,_n9##y,z,c)), \
 (I[588] = (T)(img)(_n4##x,_n10##y,z,c)), \
 (I[614] = (T)(img)(_n4##x,_n11##y,z,c)), \
 (I[640] = (T)(img)(_n4##x,_n12##y,z,c)), \
 (I[666] = (T)(img)(_n4##x,_n13##y,z,c)), \
 (I[17] = (T)(img)(_n5##x,_p12##y,z,c)), \
 (I[43] = (T)(img)(_n5##x,_p11##y,z,c)), \
 (I[69] = (T)(img)(_n5##x,_p10##y,z,c)), \
 (I[95] = (T)(img)(_n5##x,_p9##y,z,c)), \
 (I[121] = (T)(img)(_n5##x,_p8##y,z,c)), \
 (I[147] = (T)(img)(_n5##x,_p7##y,z,c)), \
 (I[173] = (T)(img)(_n5##x,_p6##y,z,c)), \
 (I[199] = (T)(img)(_n5##x,_p5##y,z,c)), \
 (I[225] = (T)(img)(_n5##x,_p4##y,z,c)), \
 (I[251] = (T)(img)(_n5##x,_p3##y,z,c)), \
 (I[277] = (T)(img)(_n5##x,_p2##y,z,c)), \
 (I[303] = (T)(img)(_n5##x,_p1##y,z,c)), \
 (I[329] = (T)(img)(_n5##x,y,z,c)), \
 (I[355] = (T)(img)(_n5##x,_n1##y,z,c)), \
 (I[381] = (T)(img)(_n5##x,_n2##y,z,c)), \
 (I[407] = (T)(img)(_n5##x,_n3##y,z,c)), \
 (I[433] = (T)(img)(_n5##x,_n4##y,z,c)), \
 (I[459] = (T)(img)(_n5##x,_n5##y,z,c)), \
 (I[485] = (T)(img)(_n5##x,_n6##y,z,c)), \
 (I[511] = (T)(img)(_n5##x,_n7##y,z,c)), \
 (I[537] = (T)(img)(_n5##x,_n8##y,z,c)), \
 (I[563] = (T)(img)(_n5##x,_n9##y,z,c)), \
 (I[589] = (T)(img)(_n5##x,_n10##y,z,c)), \
 (I[615] = (T)(img)(_n5##x,_n11##y,z,c)), \
 (I[641] = (T)(img)(_n5##x,_n12##y,z,c)), \
 (I[667] = (T)(img)(_n5##x,_n13##y,z,c)), \
 (I[18] = (T)(img)(_n6##x,_p12##y,z,c)), \
 (I[44] = (T)(img)(_n6##x,_p11##y,z,c)), \
 (I[70] = (T)(img)(_n6##x,_p10##y,z,c)), \
 (I[96] = (T)(img)(_n6##x,_p9##y,z,c)), \
 (I[122] = (T)(img)(_n6##x,_p8##y,z,c)), \
 (I[148] = (T)(img)(_n6##x,_p7##y,z,c)), \
 (I[174] = (T)(img)(_n6##x,_p6##y,z,c)), \
 (I[200] = (T)(img)(_n6##x,_p5##y,z,c)), \
 (I[226] = (T)(img)(_n6##x,_p4##y,z,c)), \
 (I[252] = (T)(img)(_n6##x,_p3##y,z,c)), \
 (I[278] = (T)(img)(_n6##x,_p2##y,z,c)), \
 (I[304] = (T)(img)(_n6##x,_p1##y,z,c)), \
 (I[330] = (T)(img)(_n6##x,y,z,c)), \
 (I[356] = (T)(img)(_n6##x,_n1##y,z,c)), \
 (I[382] = (T)(img)(_n6##x,_n2##y,z,c)), \
 (I[408] = (T)(img)(_n6##x,_n3##y,z,c)), \
 (I[434] = (T)(img)(_n6##x,_n4##y,z,c)), \
 (I[460] = (T)(img)(_n6##x,_n5##y,z,c)), \
 (I[486] = (T)(img)(_n6##x,_n6##y,z,c)), \
 (I[512] = (T)(img)(_n6##x,_n7##y,z,c)), \
 (I[538] = (T)(img)(_n6##x,_n8##y,z,c)), \
 (I[564] = (T)(img)(_n6##x,_n9##y,z,c)), \
 (I[590] = (T)(img)(_n6##x,_n10##y,z,c)), \
 (I[616] = (T)(img)(_n6##x,_n11##y,z,c)), \
 (I[642] = (T)(img)(_n6##x,_n12##y,z,c)), \
 (I[668] = (T)(img)(_n6##x,_n13##y,z,c)), \
 (I[19] = (T)(img)(_n7##x,_p12##y,z,c)), \
 (I[45] = (T)(img)(_n7##x,_p11##y,z,c)), \
 (I[71] = (T)(img)(_n7##x,_p10##y,z,c)), \
 (I[97] = (T)(img)(_n7##x,_p9##y,z,c)), \
 (I[123] = (T)(img)(_n7##x,_p8##y,z,c)), \
 (I[149] = (T)(img)(_n7##x,_p7##y,z,c)), \
 (I[175] = (T)(img)(_n7##x,_p6##y,z,c)), \
 (I[201] = (T)(img)(_n7##x,_p5##y,z,c)), \
 (I[227] = (T)(img)(_n7##x,_p4##y,z,c)), \
 (I[253] = (T)(img)(_n7##x,_p3##y,z,c)), \
 (I[279] = (T)(img)(_n7##x,_p2##y,z,c)), \
 (I[305] = (T)(img)(_n7##x,_p1##y,z,c)), \
 (I[331] = (T)(img)(_n7##x,y,z,c)), \
 (I[357] = (T)(img)(_n7##x,_n1##y,z,c)), \
 (I[383] = (T)(img)(_n7##x,_n2##y,z,c)), \
 (I[409] = (T)(img)(_n7##x,_n3##y,z,c)), \
 (I[435] = (T)(img)(_n7##x,_n4##y,z,c)), \
 (I[461] = (T)(img)(_n7##x,_n5##y,z,c)), \
 (I[487] = (T)(img)(_n7##x,_n6##y,z,c)), \
 (I[513] = (T)(img)(_n7##x,_n7##y,z,c)), \
 (I[539] = (T)(img)(_n7##x,_n8##y,z,c)), \
 (I[565] = (T)(img)(_n7##x,_n9##y,z,c)), \
 (I[591] = (T)(img)(_n7##x,_n10##y,z,c)), \
 (I[617] = (T)(img)(_n7##x,_n11##y,z,c)), \
 (I[643] = (T)(img)(_n7##x,_n12##y,z,c)), \
 (I[669] = (T)(img)(_n7##x,_n13##y,z,c)), \
 (I[20] = (T)(img)(_n8##x,_p12##y,z,c)), \
 (I[46] = (T)(img)(_n8##x,_p11##y,z,c)), \
 (I[72] = (T)(img)(_n8##x,_p10##y,z,c)), \
 (I[98] = (T)(img)(_n8##x,_p9##y,z,c)), \
 (I[124] = (T)(img)(_n8##x,_p8##y,z,c)), \
 (I[150] = (T)(img)(_n8##x,_p7##y,z,c)), \
 (I[176] = (T)(img)(_n8##x,_p6##y,z,c)), \
 (I[202] = (T)(img)(_n8##x,_p5##y,z,c)), \
 (I[228] = (T)(img)(_n8##x,_p4##y,z,c)), \
 (I[254] = (T)(img)(_n8##x,_p3##y,z,c)), \
 (I[280] = (T)(img)(_n8##x,_p2##y,z,c)), \
 (I[306] = (T)(img)(_n8##x,_p1##y,z,c)), \
 (I[332] = (T)(img)(_n8##x,y,z,c)), \
 (I[358] = (T)(img)(_n8##x,_n1##y,z,c)), \
 (I[384] = (T)(img)(_n8##x,_n2##y,z,c)), \
 (I[410] = (T)(img)(_n8##x,_n3##y,z,c)), \
 (I[436] = (T)(img)(_n8##x,_n4##y,z,c)), \
 (I[462] = (T)(img)(_n8##x,_n5##y,z,c)), \
 (I[488] = (T)(img)(_n8##x,_n6##y,z,c)), \
 (I[514] = (T)(img)(_n8##x,_n7##y,z,c)), \
 (I[540] = (T)(img)(_n8##x,_n8##y,z,c)), \
 (I[566] = (T)(img)(_n8##x,_n9##y,z,c)), \
 (I[592] = (T)(img)(_n8##x,_n10##y,z,c)), \
 (I[618] = (T)(img)(_n8##x,_n11##y,z,c)), \
 (I[644] = (T)(img)(_n8##x,_n12##y,z,c)), \
 (I[670] = (T)(img)(_n8##x,_n13##y,z,c)), \
 (I[21] = (T)(img)(_n9##x,_p12##y,z,c)), \
 (I[47] = (T)(img)(_n9##x,_p11##y,z,c)), \
 (I[73] = (T)(img)(_n9##x,_p10##y,z,c)), \
 (I[99] = (T)(img)(_n9##x,_p9##y,z,c)), \
 (I[125] = (T)(img)(_n9##x,_p8##y,z,c)), \
 (I[151] = (T)(img)(_n9##x,_p7##y,z,c)), \
 (I[177] = (T)(img)(_n9##x,_p6##y,z,c)), \
 (I[203] = (T)(img)(_n9##x,_p5##y,z,c)), \
 (I[229] = (T)(img)(_n9##x,_p4##y,z,c)), \
 (I[255] = (T)(img)(_n9##x,_p3##y,z,c)), \
 (I[281] = (T)(img)(_n9##x,_p2##y,z,c)), \
 (I[307] = (T)(img)(_n9##x,_p1##y,z,c)), \
 (I[333] = (T)(img)(_n9##x,y,z,c)), \
 (I[359] = (T)(img)(_n9##x,_n1##y,z,c)), \
 (I[385] = (T)(img)(_n9##x,_n2##y,z,c)), \
 (I[411] = (T)(img)(_n9##x,_n3##y,z,c)), \
 (I[437] = (T)(img)(_n9##x,_n4##y,z,c)), \
 (I[463] = (T)(img)(_n9##x,_n5##y,z,c)), \
 (I[489] = (T)(img)(_n9##x,_n6##y,z,c)), \
 (I[515] = (T)(img)(_n9##x,_n7##y,z,c)), \
 (I[541] = (T)(img)(_n9##x,_n8##y,z,c)), \
 (I[567] = (T)(img)(_n9##x,_n9##y,z,c)), \
 (I[593] = (T)(img)(_n9##x,_n10##y,z,c)), \
 (I[619] = (T)(img)(_n9##x,_n11##y,z,c)), \
 (I[645] = (T)(img)(_n9##x,_n12##y,z,c)), \
 (I[671] = (T)(img)(_n9##x,_n13##y,z,c)), \
 (I[22] = (T)(img)(_n10##x,_p12##y,z,c)), \
 (I[48] = (T)(img)(_n10##x,_p11##y,z,c)), \
 (I[74] = (T)(img)(_n10##x,_p10##y,z,c)), \
 (I[100] = (T)(img)(_n10##x,_p9##y,z,c)), \
 (I[126] = (T)(img)(_n10##x,_p8##y,z,c)), \
 (I[152] = (T)(img)(_n10##x,_p7##y,z,c)), \
 (I[178] = (T)(img)(_n10##x,_p6##y,z,c)), \
 (I[204] = (T)(img)(_n10##x,_p5##y,z,c)), \
 (I[230] = (T)(img)(_n10##x,_p4##y,z,c)), \
 (I[256] = (T)(img)(_n10##x,_p3##y,z,c)), \
 (I[282] = (T)(img)(_n10##x,_p2##y,z,c)), \
 (I[308] = (T)(img)(_n10##x,_p1##y,z,c)), \
 (I[334] = (T)(img)(_n10##x,y,z,c)), \
 (I[360] = (T)(img)(_n10##x,_n1##y,z,c)), \
 (I[386] = (T)(img)(_n10##x,_n2##y,z,c)), \
 (I[412] = (T)(img)(_n10##x,_n3##y,z,c)), \
 (I[438] = (T)(img)(_n10##x,_n4##y,z,c)), \
 (I[464] = (T)(img)(_n10##x,_n5##y,z,c)), \
 (I[490] = (T)(img)(_n10##x,_n6##y,z,c)), \
 (I[516] = (T)(img)(_n10##x,_n7##y,z,c)), \
 (I[542] = (T)(img)(_n10##x,_n8##y,z,c)), \
 (I[568] = (T)(img)(_n10##x,_n9##y,z,c)), \
 (I[594] = (T)(img)(_n10##x,_n10##y,z,c)), \
 (I[620] = (T)(img)(_n10##x,_n11##y,z,c)), \
 (I[646] = (T)(img)(_n10##x,_n12##y,z,c)), \
 (I[672] = (T)(img)(_n10##x,_n13##y,z,c)), \
 (I[23] = (T)(img)(_n11##x,_p12##y,z,c)), \
 (I[49] = (T)(img)(_n11##x,_p11##y,z,c)), \
 (I[75] = (T)(img)(_n11##x,_p10##y,z,c)), \
 (I[101] = (T)(img)(_n11##x,_p9##y,z,c)), \
 (I[127] = (T)(img)(_n11##x,_p8##y,z,c)), \
 (I[153] = (T)(img)(_n11##x,_p7##y,z,c)), \
 (I[179] = (T)(img)(_n11##x,_p6##y,z,c)), \
 (I[205] = (T)(img)(_n11##x,_p5##y,z,c)), \
 (I[231] = (T)(img)(_n11##x,_p4##y,z,c)), \
 (I[257] = (T)(img)(_n11##x,_p3##y,z,c)), \
 (I[283] = (T)(img)(_n11##x,_p2##y,z,c)), \
 (I[309] = (T)(img)(_n11##x,_p1##y,z,c)), \
 (I[335] = (T)(img)(_n11##x,y,z,c)), \
 (I[361] = (T)(img)(_n11##x,_n1##y,z,c)), \
 (I[387] = (T)(img)(_n11##x,_n2##y,z,c)), \
 (I[413] = (T)(img)(_n11##x,_n3##y,z,c)), \
 (I[439] = (T)(img)(_n11##x,_n4##y,z,c)), \
 (I[465] = (T)(img)(_n11##x,_n5##y,z,c)), \
 (I[491] = (T)(img)(_n11##x,_n6##y,z,c)), \
 (I[517] = (T)(img)(_n11##x,_n7##y,z,c)), \
 (I[543] = (T)(img)(_n11##x,_n8##y,z,c)), \
 (I[569] = (T)(img)(_n11##x,_n9##y,z,c)), \
 (I[595] = (T)(img)(_n11##x,_n10##y,z,c)), \
 (I[621] = (T)(img)(_n11##x,_n11##y,z,c)), \
 (I[647] = (T)(img)(_n11##x,_n12##y,z,c)), \
 (I[673] = (T)(img)(_n11##x,_n13##y,z,c)), \
 (I[24] = (T)(img)(_n12##x,_p12##y,z,c)), \
 (I[50] = (T)(img)(_n12##x,_p11##y,z,c)), \
 (I[76] = (T)(img)(_n12##x,_p10##y,z,c)), \
 (I[102] = (T)(img)(_n12##x,_p9##y,z,c)), \
 (I[128] = (T)(img)(_n12##x,_p8##y,z,c)), \
 (I[154] = (T)(img)(_n12##x,_p7##y,z,c)), \
 (I[180] = (T)(img)(_n12##x,_p6##y,z,c)), \
 (I[206] = (T)(img)(_n12##x,_p5##y,z,c)), \
 (I[232] = (T)(img)(_n12##x,_p4##y,z,c)), \
 (I[258] = (T)(img)(_n12##x,_p3##y,z,c)), \
 (I[284] = (T)(img)(_n12##x,_p2##y,z,c)), \
 (I[310] = (T)(img)(_n12##x,_p1##y,z,c)), \
 (I[336] = (T)(img)(_n12##x,y,z,c)), \
 (I[362] = (T)(img)(_n12##x,_n1##y,z,c)), \
 (I[388] = (T)(img)(_n12##x,_n2##y,z,c)), \
 (I[414] = (T)(img)(_n12##x,_n3##y,z,c)), \
 (I[440] = (T)(img)(_n12##x,_n4##y,z,c)), \
 (I[466] = (T)(img)(_n12##x,_n5##y,z,c)), \
 (I[492] = (T)(img)(_n12##x,_n6##y,z,c)), \
 (I[518] = (T)(img)(_n12##x,_n7##y,z,c)), \
 (I[544] = (T)(img)(_n12##x,_n8##y,z,c)), \
 (I[570] = (T)(img)(_n12##x,_n9##y,z,c)), \
 (I[596] = (T)(img)(_n12##x,_n10##y,z,c)), \
 (I[622] = (T)(img)(_n12##x,_n11##y,z,c)), \
 (I[648] = (T)(img)(_n12##x,_n12##y,z,c)), \
 (I[674] = (T)(img)(_n12##x,_n13##y,z,c)), \
 13>=((img)._width)?(img).width()-1:13); \
 (_n13##x<(img).width() && ( \
 (I[25] = (T)(img)(_n13##x,_p12##y,z,c)), \
 (I[51] = (T)(img)(_n13##x,_p11##y,z,c)), \
 (I[77] = (T)(img)(_n13##x,_p10##y,z,c)), \
 (I[103] = (T)(img)(_n13##x,_p9##y,z,c)), \
 (I[129] = (T)(img)(_n13##x,_p8##y,z,c)), \
 (I[155] = (T)(img)(_n13##x,_p7##y,z,c)), \
 (I[181] = (T)(img)(_n13##x,_p6##y,z,c)), \
 (I[207] = (T)(img)(_n13##x,_p5##y,z,c)), \
 (I[233] = (T)(img)(_n13##x,_p4##y,z,c)), \
 (I[259] = (T)(img)(_n13##x,_p3##y,z,c)), \
 (I[285] = (T)(img)(_n13##x,_p2##y,z,c)), \
 (I[311] = (T)(img)(_n13##x,_p1##y,z,c)), \
 (I[337] = (T)(img)(_n13##x,y,z,c)), \
 (I[363] = (T)(img)(_n13##x,_n1##y,z,c)), \
 (I[389] = (T)(img)(_n13##x,_n2##y,z,c)), \
 (I[415] = (T)(img)(_n13##x,_n3##y,z,c)), \
 (I[441] = (T)(img)(_n13##x,_n4##y,z,c)), \
 (I[467] = (T)(img)(_n13##x,_n5##y,z,c)), \
 (I[493] = (T)(img)(_n13##x,_n6##y,z,c)), \
 (I[519] = (T)(img)(_n13##x,_n7##y,z,c)), \
 (I[545] = (T)(img)(_n13##x,_n8##y,z,c)), \
 (I[571] = (T)(img)(_n13##x,_n9##y,z,c)), \
 (I[597] = (T)(img)(_n13##x,_n10##y,z,c)), \
 (I[623] = (T)(img)(_n13##x,_n11##y,z,c)), \
 (I[649] = (T)(img)(_n13##x,_n12##y,z,c)), \
 (I[675] = (T)(img)(_n13##x,_n13##y,z,c)),1)) || \
 _n12##x==--_n13##x || _n11##x==--_n12##x || _n10##x==--_n11##x || _n9##x==--_n10##x || _n8##x==--_n9##x || _n7##x==--_n8##x || _n6##x==--_n7##x || _n5##x==--_n6##x || _n4##x==--_n5##x || _n3##x==--_n4##x || _n2##x==--_n3##x || _n1##x==--_n2##x || x==(_n13##x = _n12##x = _n11##x = _n10##x = _n9##x = _n8##x = _n7##x = _n6##x = _n5##x = _n4##x = _n3##x = _n2##x = --_n1##x); \
 I[0] = I[1], I[1] = I[2], I[2] = I[3], I[3] = I[4], I[4] = I[5], I[5] = I[6], I[6] = I[7], I[7] = I[8], I[8] = I[9], I[9] = I[10], I[10] = I[11], I[11] = I[12], I[12] = I[13], I[13] = I[14], I[14] = I[15], I[15] = I[16], I[16] = I[17], I[17] = I[18], I[18] = I[19], I[19] = I[20], I[20] = I[21], I[21] = I[22], I[22] = I[23], I[23] = I[24], I[24] = I[25], \
 I[26] = I[27], I[27] = I[28], I[28] = I[29], I[29] = I[30], I[30] = I[31], I[31] = I[32], I[32] = I[33], I[33] = I[34], I[34] = I[35], I[35] = I[36], I[36] = I[37], I[37] = I[38], I[38] = I[39], I[39] = I[40], I[40] = I[41], I[41] = I[42], I[42] = I[43], I[43] = I[44], I[44] = I[45], I[45] = I[46], I[46] = I[47], I[47] = I[48], I[48] = I[49], I[49] = I[50], I[50] = I[51], \
 I[52] = I[53], I[53] = I[54], I[54] = I[55], I[55] = I[56], I[56] = I[57], I[57] = I[58], I[58] = I[59], I[59] = I[60], I[60] = I[61], I[61] = I[62], I[62] = I[63], I[63] = I[64], I[64] = I[65], I[65] = I[66], I[66] = I[67], I[67] = I[68], I[68] = I[69], I[69] = I[70], I[70] = I[71], I[71] = I[72], I[72] = I[73], I[73] = I[74], I[74] = I[75], I[75] = I[76], I[76] = I[77], \
 I[78] = I[79], I[79] = I[80], I[80] = I[81], I[81] = I[82], I[82] = I[83], I[83] = I[84], I[84] = I[85], I[85] = I[86], I[86] = I[87], I[87] = I[88], I[88] = I[89], I[89] = I[90], I[90] = I[91], I[91] = I[92], I[92] = I[93], I[93] = I[94], I[94] = I[95], I[95] = I[96], I[96] = I[97], I[97] = I[98], I[98] = I[99], I[99] = I[100], I[100] = I[101], I[101] = I[102], I[102] = I[103], \
 I[104] = I[105], I[105] = I[106], I[106] = I[107], I[107] = I[108], I[108] = I[109], I[109] = I[110], I[110] = I[111], I[111] = I[112], I[112] = I[113], I[113] = I[114], I[114] = I[115], I[115] = I[116], I[116] = I[117], I[117] = I[118], I[118] = I[119], I[119] = I[120], I[120] = I[121], I[121] = I[122], I[122] = I[123], I[123] = I[124], I[124] = I[125], I[125] = I[126], I[126] = I[127], I[127] = I[128], I[128] = I[129], \
 I[130] = I[131], I[131] = I[132], I[132] = I[133], I[133] = I[134], I[134] = I[135], I[135] = I[136], I[136] = I[137], I[137] = I[138], I[138] = I[139], I[139] = I[140], I[140] = I[141], I[141] = I[142], I[142] = I[143], I[143] = I[144], I[144] = I[145], I[145] = I[146], I[146] = I[147], I[147] = I[148], I[148] = I[149], I[149] = I[150], I[150] = I[151], I[151] = I[152], I[152] = I[153], I[153] = I[154], I[154] = I[155], \
 I[156] = I[157], I[157] = I[158], I[158] = I[159], I[159] = I[160], I[160] = I[161], I[161] = I[162], I[162] = I[163], I[163] = I[164], I[164] = I[165], I[165] = I[166], I[166] = I[167], I[167] = I[168], I[168] = I[169], I[169] = I[170], I[170] = I[171], I[171] = I[172], I[172] = I[173], I[173] = I[174], I[174] = I[175], I[175] = I[176], I[176] = I[177], I[177] = I[178], I[178] = I[179], I[179] = I[180], I[180] = I[181], \
 I[182] = I[183], I[183] = I[184], I[184] = I[185], I[185] = I[186], I[186] = I[187], I[187] = I[188], I[188] = I[189], I[189] = I[190], I[190] = I[191], I[191] = I[192], I[192] = I[193], I[193] = I[194], I[194] = I[195], I[195] = I[196], I[196] = I[197], I[197] = I[198], I[198] = I[199], I[199] = I[200], I[200] = I[201], I[201] = I[202], I[202] = I[203], I[203] = I[204], I[204] = I[205], I[205] = I[206], I[206] = I[207], \
 I[208] = I[209], I[209] = I[210], I[210] = I[211], I[211] = I[212], I[212] = I[213], I[213] = I[214], I[214] = I[215], I[215] = I[216], I[216] = I[217], I[217] = I[218], I[218] = I[219], I[219] = I[220], I[220] = I[221], I[221] = I[222], I[222] = I[223], I[223] = I[224], I[224] = I[225], I[225] = I[226], I[226] = I[227], I[227] = I[228], I[228] = I[229], I[229] = I[230], I[230] = I[231], I[231] = I[232], I[232] = I[233], \
 I[234] = I[235], I[235] = I[236], I[236] = I[237], I[237] = I[238], I[238] = I[239], I[239] = I[240], I[240] = I[241], I[241] = I[242], I[242] = I[243], I[243] = I[244], I[244] = I[245], I[245] = I[246], I[246] = I[247], I[247] = I[248], I[248] = I[249], I[249] = I[250], I[250] = I[251], I[251] = I[252], I[252] = I[253], I[253] = I[254], I[254] = I[255], I[255] = I[256], I[256] = I[257], I[257] = I[258], I[258] = I[259], \
 I[260] = I[261], I[261] = I[262], I[262] = I[263], I[263] = I[264], I[264] = I[265], I[265] = I[266], I[266] = I[267], I[267] = I[268], I[268] = I[269], I[269] = I[270], I[270] = I[271], I[271] = I[272], I[272] = I[273], I[273] = I[274], I[274] = I[275], I[275] = I[276], I[276] = I[277], I[277] = I[278], I[278] = I[279], I[279] = I[280], I[280] = I[281], I[281] = I[282], I[282] = I[283], I[283] = I[284], I[284] = I[285], \
 I[286] = I[287], I[287] = I[288], I[288] = I[289], I[289] = I[290], I[290] = I[291], I[291] = I[292], I[292] = I[293], I[293] = I[294], I[294] = I[295], I[295] = I[296], I[296] = I[297], I[297] = I[298], I[298] = I[299], I[299] = I[300], I[300] = I[301], I[301] = I[302], I[302] = I[303], I[303] = I[304], I[304] = I[305], I[305] = I[306], I[306] = I[307], I[307] = I[308], I[308] = I[309], I[309] = I[310], I[310] = I[311], \
 I[312] = I[313], I[313] = I[314], I[314] = I[315], I[315] = I[316], I[316] = I[317], I[317] = I[318], I[318] = I[319], I[319] = I[320], I[320] = I[321], I[321] = I[322], I[322] = I[323], I[323] = I[324], I[324] = I[325], I[325] = I[326], I[326] = I[327], I[327] = I[328], I[328] = I[329], I[329] = I[330], I[330] = I[331], I[331] = I[332], I[332] = I[333], I[333] = I[334], I[334] = I[335], I[335] = I[336], I[336] = I[337], \
 I[338] = I[339], I[339] = I[340], I[340] = I[341], I[341] = I[342], I[342] = I[343], I[343] = I[344], I[344] = I[345], I[345] = I[346], I[346] = I[347], I[347] = I[348], I[348] = I[349], I[349] = I[350], I[350] = I[351], I[351] = I[352], I[352] = I[353], I[353] = I[354], I[354] = I[355], I[355] = I[356], I[356] = I[357], I[357] = I[358], I[358] = I[359], I[359] = I[360], I[360] = I[361], I[361] = I[362], I[362] = I[363], \
 I[364] = I[365], I[365] = I[366], I[366] = I[367], I[367] = I[368], I[368] = I[369], I[369] = I[370], I[370] = I[371], I[371] = I[372], I[372] = I[373], I[373] = I[374], I[374] = I[375], I[375] = I[376], I[376] = I[377], I[377] = I[378], I[378] = I[379], I[379] = I[380], I[380] = I[381], I[381] = I[382], I[382] = I[383], I[383] = I[384], I[384] = I[385], I[385] = I[386], I[386] = I[387], I[387] = I[388], I[388] = I[389], \
 I[390] = I[391], I[391] = I[392], I[392] = I[393], I[393] = I[394], I[394] = I[395], I[395] = I[396], I[396] = I[397], I[397] = I[398], I[398] = I[399], I[399] = I[400], I[400] = I[401], I[401] = I[402], I[402] = I[403], I[403] = I[404], I[404] = I[405], I[405] = I[406], I[406] = I[407], I[407] = I[408], I[408] = I[409], I[409] = I[410], I[410] = I[411], I[411] = I[412], I[412] = I[413], I[413] = I[414], I[414] = I[415], \
 I[416] = I[417], I[417] = I[418], I[418] = I[419], I[419] = I[420], I[420] = I[421], I[421] = I[422], I[422] = I[423], I[423] = I[424], I[424] = I[425], I[425] = I[426], I[426] = I[427], I[427] = I[428], I[428] = I[429], I[429] = I[430], I[430] = I[431], I[431] = I[432], I[432] = I[433], I[433] = I[434], I[434] = I[435], I[435] = I[436], I[436] = I[437], I[437] = I[438], I[438] = I[439], I[439] = I[440], I[440] = I[441], \
 I[442] = I[443], I[443] = I[444], I[444] = I[445], I[445] = I[446], I[446] = I[447], I[447] = I[448], I[448] = I[449], I[449] = I[450], I[450] = I[451], I[451] = I[452], I[452] = I[453], I[453] = I[454], I[454] = I[455], I[455] = I[456], I[456] = I[457], I[457] = I[458], I[458] = I[459], I[459] = I[460], I[460] = I[461], I[461] = I[462], I[462] = I[463], I[463] = I[464], I[464] = I[465], I[465] = I[466], I[466] = I[467], \
 I[468] = I[469], I[469] = I[470], I[470] = I[471], I[471] = I[472], I[472] = I[473], I[473] = I[474], I[474] = I[475], I[475] = I[476], I[476] = I[477], I[477] = I[478], I[478] = I[479], I[479] = I[480], I[480] = I[481], I[481] = I[482], I[482] = I[483], I[483] = I[484], I[484] = I[485], I[485] = I[486], I[486] = I[487], I[487] = I[488], I[488] = I[489], I[489] = I[490], I[490] = I[491], I[491] = I[492], I[492] = I[493], \
 I[494] = I[495], I[495] = I[496], I[496] = I[497], I[497] = I[498], I[498] = I[499], I[499] = I[500], I[500] = I[501], I[501] = I[502], I[502] = I[503], I[503] = I[504], I[504] = I[505], I[505] = I[506], I[506] = I[507], I[507] = I[508], I[508] = I[509], I[509] = I[510], I[510] = I[511], I[511] = I[512], I[512] = I[513], I[513] = I[514], I[514] = I[515], I[515] = I[516], I[516] = I[517], I[517] = I[518], I[518] = I[519], \
 I[520] = I[521], I[521] = I[522], I[522] = I[523], I[523] = I[524], I[524] = I[525], I[525] = I[526], I[526] = I[527], I[527] = I[528], I[528] = I[529], I[529] = I[530], I[530] = I[531], I[531] = I[532], I[532] = I[533], I[533] = I[534], I[534] = I[535], I[535] = I[536], I[536] = I[537], I[537] = I[538], I[538] = I[539], I[539] = I[540], I[540] = I[541], I[541] = I[542], I[542] = I[543], I[543] = I[544], I[544] = I[545], \
 I[546] = I[547], I[547] = I[548], I[548] = I[549], I[549] = I[550], I[550] = I[551], I[551] = I[552], I[552] = I[553], I[553] = I[554], I[554] = I[555], I[555] = I[556], I[556] = I[557], I[557] = I[558], I[558] = I[559], I[559] = I[560], I[560] = I[561], I[561] = I[562], I[562] = I[563], I[563] = I[564], I[564] = I[565], I[565] = I[566], I[566] = I[567], I[567] = I[568], I[568] = I[569], I[569] = I[570], I[570] = I[571], \
 I[572] = I[573], I[573] = I[574], I[574] = I[575], I[575] = I[576], I[576] = I[577], I[577] = I[578], I[578] = I[579], I[579] = I[580], I[580] = I[581], I[581] = I[582], I[582] = I[583], I[583] = I[584], I[584] = I[585], I[585] = I[586], I[586] = I[587], I[587] = I[588], I[588] = I[589], I[589] = I[590], I[590] = I[591], I[591] = I[592], I[592] = I[593], I[593] = I[594], I[594] = I[595], I[595] = I[596], I[596] = I[597], \
 I[598] = I[599], I[599] = I[600], I[600] = I[601], I[601] = I[602], I[602] = I[603], I[603] = I[604], I[604] = I[605], I[605] = I[606], I[606] = I[607], I[607] = I[608], I[608] = I[609], I[609] = I[610], I[610] = I[611], I[611] = I[612], I[612] = I[613], I[613] = I[614], I[614] = I[615], I[615] = I[616], I[616] = I[617], I[617] = I[618], I[618] = I[619], I[619] = I[620], I[620] = I[621], I[621] = I[622], I[622] = I[623], \
 I[624] = I[625], I[625] = I[626], I[626] = I[627], I[627] = I[628], I[628] = I[629], I[629] = I[630], I[630] = I[631], I[631] = I[632], I[632] = I[633], I[633] = I[634], I[634] = I[635], I[635] = I[636], I[636] = I[637], I[637] = I[638], I[638] = I[639], I[639] = I[640], I[640] = I[641], I[641] = I[642], I[642] = I[643], I[643] = I[644], I[644] = I[645], I[645] = I[646], I[646] = I[647], I[647] = I[648], I[648] = I[649], \
 I[650] = I[651], I[651] = I[652], I[652] = I[653], I[653] = I[654], I[654] = I[655], I[655] = I[656], I[656] = I[657], I[657] = I[658], I[658] = I[659], I[659] = I[660], I[660] = I[661], I[661] = I[662], I[662] = I[663], I[663] = I[664], I[664] = I[665], I[665] = I[666], I[666] = I[667], I[667] = I[668], I[668] = I[669], I[669] = I[670], I[670] = I[671], I[671] = I[672], I[672] = I[673], I[673] = I[674], I[674] = I[675], \
 _p12##x = _p11##x, _p11##x = _p10##x, _p10##x = _p9##x, _p9##x = _p8##x, _p8##x = _p7##x, _p7##x = _p6##x, _p6##x = _p5##x, _p5##x = _p4##x, _p4##x = _p3##x, _p3##x = _p2##x, _p2##x = _p1##x, _p1##x = x++, ++_n1##x, ++_n2##x, ++_n3##x, ++_n4##x, ++_n5##x, ++_n6##x, ++_n7##x, ++_n8##x, ++_n9##x, ++_n10##x, ++_n11##x, ++_n12##x, ++_n13##x)

#define cimg_for_in26x26(img,x0,y0,x1,y1,x,y,z,c,I,T) \
 cimg_for_in26((img)._height,y0,y1,y) for (int x = (int)(x0)<0?0:(int)(x0), \
 _p12##x = x-12<0?0:x-12, \
 _p11##x = x-11<0?0:x-11, \
 _p10##x = x-10<0?0:x-10, \
 _p9##x = x-9<0?0:x-9, \
 _p8##x = x-8<0?0:x-8, \
 _p7##x = x-7<0?0:x-7, \
 _p6##x = x-6<0?0:x-6, \
 _p5##x = x-5<0?0:x-5, \
 _p4##x = x-4<0?0:x-4, \
 _p3##x = x-3<0?0:x-3, \
 _p2##x = x-2<0?0:x-2, \
 _p1##x = x-1<0?0:x-1, \
 _n1##x = x+1>=(img).width()?(img).width()-1:x+1, \
 _n2##x = x+2>=(img).width()?(img).width()-1:x+2, \
 _n3##x = x+3>=(img).width()?(img).width()-1:x+3, \
 _n4##x = x+4>=(img).width()?(img).width()-1:x+4, \
 _n5##x = x+5>=(img).width()?(img).width()-1:x+5, \
 _n6##x = x+6>=(img).width()?(img).width()-1:x+6, \
 _n7##x = x+7>=(img).width()?(img).width()-1:x+7, \
 _n8##x = x+8>=(img).width()?(img).width()-1:x+8, \
 _n9##x = x+9>=(img).width()?(img).width()-1:x+9, \
 _n10##x = x+10>=(img).width()?(img).width()-1:x+10, \
 _n11##x = x+11>=(img).width()?(img).width()-1:x+11, \
 _n12##x = x+12>=(img).width()?(img).width()-1:x+12, \
 _n13##x = (int)( \
 (I[0] = (T)(img)(_p12##x,_p12##y,z,c)), \
 (I[26] = (T)(img)(_p12##x,_p11##y,z,c)), \
 (I[52] = (T)(img)(_p12##x,_p10##y,z,c)), \
 (I[78] = (T)(img)(_p12##x,_p9##y,z,c)), \
 (I[104] = (T)(img)(_p12##x,_p8##y,z,c)), \
 (I[130] = (T)(img)(_p12##x,_p7##y,z,c)), \
 (I[156] = (T)(img)(_p12##x,_p6##y,z,c)), \
 (I[182] = (T)(img)(_p12##x,_p5##y,z,c)), \
 (I[208] = (T)(img)(_p12##x,_p4##y,z,c)), \
 (I[234] = (T)(img)(_p12##x,_p3##y,z,c)), \
 (I[260] = (T)(img)(_p12##x,_p2##y,z,c)), \
 (I[286] = (T)(img)(_p12##x,_p1##y,z,c)), \
 (I[312] = (T)(img)(_p12##x,y,z,c)), \
 (I[338] = (T)(img)(_p12##x,_n1##y,z,c)), \
 (I[364] = (T)(img)(_p12##x,_n2##y,z,c)), \
 (I[390] = (T)(img)(_p12##x,_n3##y,z,c)), \
 (I[416] = (T)(img)(_p12##x,_n4##y,z,c)), \
 (I[442] = (T)(img)(_p12##x,_n5##y,z,c)), \
 (I[468] = (T)(img)(_p12##x,_n6##y,z,c)), \
 (I[494] = (T)(img)(_p12##x,_n7##y,z,c)), \
 (I[520] = (T)(img)(_p12##x,_n8##y,z,c)), \
 (I[546] = (T)(img)(_p12##x,_n9##y,z,c)), \
 (I[572] = (T)(img)(_p12##x,_n10##y,z,c)), \
 (I[598] = (T)(img)(_p12##x,_n11##y,z,c)), \
 (I[624] = (T)(img)(_p12##x,_n12##y,z,c)), \
 (I[650] = (T)(img)(_p12##x,_n13##y,z,c)), \
 (I[1] = (T)(img)(_p11##x,_p12##y,z,c)), \
 (I[27] = (T)(img)(_p11##x,_p11##y,z,c)), \
 (I[53] = (T)(img)(_p11##x,_p10##y,z,c)), \
 (I[79] = (T)(img)(_p11##x,_p9##y,z,c)), \
 (I[105] = (T)(img)(_p11##x,_p8##y,z,c)), \
 (I[131] = (T)(img)(_p11##x,_p7##y,z,c)), \
 (I[157] = (T)(img)(_p11##x,_p6##y,z,c)), \
 (I[183] = (T)(img)(_p11##x,_p5##y,z,c)), \
 (I[209] = (T)(img)(_p11##x,_p4##y,z,c)), \
 (I[235] = (T)(img)(_p11##x,_p3##y,z,c)), \
 (I[261] = (T)(img)(_p11##x,_p2##y,z,c)), \
 (I[287] = (T)(img)(_p11##x,_p1##y,z,c)), \
 (I[313] = (T)(img)(_p11##x,y,z,c)), \
 (I[339] = (T)(img)(_p11##x,_n1##y,z,c)), \
 (I[365] = (T)(img)(_p11##x,_n2##y,z,c)), \
 (I[391] = (T)(img)(_p11##x,_n3##y,z,c)), \
 (I[417] = (T)(img)(_p11##x,_n4##y,z,c)), \
 (I[443] = (T)(img)(_p11##x,_n5##y,z,c)), \
 (I[469] = (T)(img)(_p11##x,_n6##y,z,c)), \
 (I[495] = (T)(img)(_p11##x,_n7##y,z,c)), \
 (I[521] = (T)(img)(_p11##x,_n8##y,z,c)), \
 (I[547] = (T)(img)(_p11##x,_n9##y,z,c)), \
 (I[573] = (T)(img)(_p11##x,_n10##y,z,c)), \
 (I[599] = (T)(img)(_p11##x,_n11##y,z,c)), \
 (I[625] = (T)(img)(_p11##x,_n12##y,z,c)), \
 (I[651] = (T)(img)(_p11##x,_n13##y,z,c)), \
 (I[2] = (T)(img)(_p10##x,_p12##y,z,c)), \
 (I[28] = (T)(img)(_p10##x,_p11##y,z,c)), \
 (I[54] = (T)(img)(_p10##x,_p10##y,z,c)), \
 (I[80] = (T)(img)(_p10##x,_p9##y,z,c)), \
 (I[106] = (T)(img)(_p10##x,_p8##y,z,c)), \
 (I[132] = (T)(img)(_p10##x,_p7##y,z,c)), \
 (I[158] = (T)(img)(_p10##x,_p6##y,z,c)), \
 (I[184] = (T)(img)(_p10##x,_p5##y,z,c)), \
 (I[210] = (T)(img)(_p10##x,_p4##y,z,c)), \
 (I[236] = (T)(img)(_p10##x,_p3##y,z,c)), \
 (I[262] = (T)(img)(_p10##x,_p2##y,z,c)), \
 (I[288] = (T)(img)(_p10##x,_p1##y,z,c)), \
 (I[314] = (T)(img)(_p10##x,y,z,c)), \
 (I[340] = (T)(img)(_p10##x,_n1##y,z,c)), \
 (I[366] = (T)(img)(_p10##x,_n2##y,z,c)), \
 (I[392] = (T)(img)(_p10##x,_n3##y,z,c)), \
 (I[418] = (T)(img)(_p10##x,_n4##y,z,c)), \
 (I[444] = (T)(img)(_p10##x,_n5##y,z,c)), \
 (I[470] = (T)(img)(_p10##x,_n6##y,z,c)), \
 (I[496] = (T)(img)(_p10##x,_n7##y,z,c)), \
 (I[522] = (T)(img)(_p10##x,_n8##y,z,c)), \
 (I[548] = (T)(img)(_p10##x,_n9##y,z,c)), \
 (I[574] = (T)(img)(_p10##x,_n10##y,z,c)), \
 (I[600] = (T)(img)(_p10##x,_n11##y,z,c)), \
 (I[626] = (T)(img)(_p10##x,_n12##y,z,c)), \
 (I[652] = (T)(img)(_p10##x,_n13##y,z,c)), \
 (I[3] = (T)(img)(_p9##x,_p12##y,z,c)), \
 (I[29] = (T)(img)(_p9##x,_p11##y,z,c)), \
 (I[55] = (T)(img)(_p9##x,_p10##y,z,c)), \
 (I[81] = (T)(img)(_p9##x,_p9##y,z,c)), \
 (I[107] = (T)(img)(_p9##x,_p8##y,z,c)), \
 (I[133] = (T)(img)(_p9##x,_p7##y,z,c)), \
 (I[159] = (T)(img)(_p9##x,_p6##y,z,c)), \
 (I[185] = (T)(img)(_p9##x,_p5##y,z,c)), \
 (I[211] = (T)(img)(_p9##x,_p4##y,z,c)), \
 (I[237] = (T)(img)(_p9##x,_p3##y,z,c)), \
 (I[263] = (T)(img)(_p9##x,_p2##y,z,c)), \
 (I[289] = (T)(img)(_p9##x,_p1##y,z,c)), \
 (I[315] = (T)(img)(_p9##x,y,z,c)), \
 (I[341] = (T)(img)(_p9##x,_n1##y,z,c)), \
 (I[367] = (T)(img)(_p9##x,_n2##y,z,c)), \
 (I[393] = (T)(img)(_p9##x,_n3##y,z,c)), \
 (I[419] = (T)(img)(_p9##x,_n4##y,z,c)), \
 (I[445] = (T)(img)(_p9##x,_n5##y,z,c)), \
 (I[471] = (T)(img)(_p9##x,_n6##y,z,c)), \
 (I[497] = (T)(img)(_p9##x,_n7##y,z,c)), \
 (I[523] = (T)(img)(_p9##x,_n8##y,z,c)), \
 (I[549] = (T)(img)(_p9##x,_n9##y,z,c)), \
 (I[575] = (T)(img)(_p9##x,_n10##y,z,c)), \
 (I[601] = (T)(img)(_p9##x,_n11##y,z,c)), \
 (I[627] = (T)(img)(_p9##x,_n12##y,z,c)), \
 (I[653] = (T)(img)(_p9##x,_n13##y,z,c)), \
 (I[4] = (T)(img)(_p8##x,_p12##y,z,c)), \
 (I[30] = (T)(img)(_p8##x,_p11##y,z,c)), \
 (I[56] = (T)(img)(_p8##x,_p10##y,z,c)), \
 (I[82] = (T)(img)(_p8##x,_p9##y,z,c)), \
 (I[108] = (T)(img)(_p8##x,_p8##y,z,c)), \
 (I[134] = (T)(img)(_p8##x,_p7##y,z,c)), \
 (I[160] = (T)(img)(_p8##x,_p6##y,z,c)), \
 (I[186] = (T)(img)(_p8##x,_p5##y,z,c)), \
 (I[212] = (T)(img)(_p8##x,_p4##y,z,c)), \
 (I[238] = (T)(img)(_p8##x,_p3##y,z,c)), \
 (I[264] = (T)(img)(_p8##x,_p2##y,z,c)), \
 (I[290] = (T)(img)(_p8##x,_p1##y,z,c)), \
 (I[316] = (T)(img)(_p8##x,y,z,c)), \
 (I[342] = (T)(img)(_p8##x,_n1##y,z,c)), \
 (I[368] = (T)(img)(_p8##x,_n2##y,z,c)), \
 (I[394] = (T)(img)(_p8##x,_n3##y,z,c)), \
 (I[420] = (T)(img)(_p8##x,_n4##y,z,c)), \
 (I[446] = (T)(img)(_p8##x,_n5##y,z,c)), \
 (I[472] = (T)(img)(_p8##x,_n6##y,z,c)), \
 (I[498] = (T)(img)(_p8##x,_n7##y,z,c)), \
 (I[524] = (T)(img)(_p8##x,_n8##y,z,c)), \
 (I[550] = (T)(img)(_p8##x,_n9##y,z,c)), \
 (I[576] = (T)(img)(_p8##x,_n10##y,z,c)), \
 (I[602] = (T)(img)(_p8##x,_n11##y,z,c)), \
 (I[628] = (T)(img)(_p8##x,_n12##y,z,c)), \
 (I[654] = (T)(img)(_p8##x,_n13##y,z,c)), \
 (I[5] = (T)(img)(_p7##x,_p12##y,z,c)), \
 (I[31] = (T)(img)(_p7##x,_p11##y,z,c)), \
 (I[57] = (T)(img)(_p7##x,_p10##y,z,c)), \
 (I[83] = (T)(img)(_p7##x,_p9##y,z,c)), \
 (I[109] = (T)(img)(_p7##x,_p8##y,z,c)), \
 (I[135] = (T)(img)(_p7##x,_p7##y,z,c)), \
 (I[161] = (T)(img)(_p7##x,_p6##y,z,c)), \
 (I[187] = (T)(img)(_p7##x,_p5##y,z,c)), \
 (I[213] = (T)(img)(_p7##x,_p4##y,z,c)), \
 (I[239] = (T)(img)(_p7##x,_p3##y,z,c)), \
 (I[265] = (T)(img)(_p7##x,_p2##y,z,c)), \
 (I[291] = (T)(img)(_p7##x,_p1##y,z,c)), \
 (I[317] = (T)(img)(_p7##x,y,z,c)), \
 (I[343] = (T)(img)(_p7##x,_n1##y,z,c)), \
 (I[369] = (T)(img)(_p7##x,_n2##y,z,c)), \
 (I[395] = (T)(img)(_p7##x,_n3##y,z,c)), \
 (I[421] = (T)(img)(_p7##x,_n4##y,z,c)), \
 (I[447] = (T)(img)(_p7##x,_n5##y,z,c)), \
 (I[473] = (T)(img)(_p7##x,_n6##y,z,c)), \
 (I[499] = (T)(img)(_p7##x,_n7##y,z,c)), \
 (I[525] = (T)(img)(_p7##x,_n8##y,z,c)), \
 (I[551] = (T)(img)(_p7##x,_n9##y,z,c)), \
 (I[577] = (T)(img)(_p7##x,_n10##y,z,c)), \
 (I[603] = (T)(img)(_p7##x,_n11##y,z,c)), \
 (I[629] = (T)(img)(_p7##x,_n12##y,z,c)), \
 (I[655] = (T)(img)(_p7##x,_n13##y,z,c)), \
 (I[6] = (T)(img)(_p6##x,_p12##y,z,c)), \
 (I[32] = (T)(img)(_p6##x,_p11##y,z,c)), \
 (I[58] = (T)(img)(_p6##x,_p10##y,z,c)), \
 (I[84] = (T)(img)(_p6##x,_p9##y,z,c)), \
 (I[110] = (T)(img)(_p6##x,_p8##y,z,c)), \
 (I[136] = (T)(img)(_p6##x,_p7##y,z,c)), \
 (I[162] = (T)(img)(_p6##x,_p6##y,z,c)), \
 (I[188] = (T)(img)(_p6##x,_p5##y,z,c)), \
 (I[214] = (T)(img)(_p6##x,_p4##y,z,c)), \
 (I[240] = (T)(img)(_p6##x,_p3##y,z,c)), \
 (I[266] = (T)(img)(_p6##x,_p2##y,z,c)), \
 (I[292] = (T)(img)(_p6##x,_p1##y,z,c)), \
 (I[318] = (T)(img)(_p6##x,y,z,c)), \
 (I[344] = (T)(img)(_p6##x,_n1##y,z,c)), \
 (I[370] = (T)(img)(_p6##x,_n2##y,z,c)), \
 (I[396] = (T)(img)(_p6##x,_n3##y,z,c)), \
 (I[422] = (T)(img)(_p6##x,_n4##y,z,c)), \
 (I[448] = (T)(img)(_p6##x,_n5##y,z,c)), \
 (I[474] = (T)(img)(_p6##x,_n6##y,z,c)), \
 (I[500] = (T)(img)(_p6##x,_n7##y,z,c)), \
 (I[526] = (T)(img)(_p6##x,_n8##y,z,c)), \
 (I[552] = (T)(img)(_p6##x,_n9##y,z,c)), \
 (I[578] = (T)(img)(_p6##x,_n10##y,z,c)), \
 (I[604] = (T)(img)(_p6##x,_n11##y,z,c)), \
 (I[630] = (T)(img)(_p6##x,_n12##y,z,c)), \
 (I[656] = (T)(img)(_p6##x,_n13##y,z,c)), \
 (I[7] = (T)(img)(_p5##x,_p12##y,z,c)), \
 (I[33] = (T)(img)(_p5##x,_p11##y,z,c)), \
 (I[59] = (T)(img)(_p5##x,_p10##y,z,c)), \
 (I[85] = (T)(img)(_p5##x,_p9##y,z,c)), \
 (I[111] = (T)(img)(_p5##x,_p8##y,z,c)), \
 (I[137] = (T)(img)(_p5##x,_p7##y,z,c)), \
 (I[163] = (T)(img)(_p5##x,_p6##y,z,c)), \
 (I[189] = (T)(img)(_p5##x,_p5##y,z,c)), \
 (I[215] = (T)(img)(_p5##x,_p4##y,z,c)), \
 (I[241] = (T)(img)(_p5##x,_p3##y,z,c)), \
 (I[267] = (T)(img)(_p5##x,_p2##y,z,c)), \
 (I[293] = (T)(img)(_p5##x,_p1##y,z,c)), \
 (I[319] = (T)(img)(_p5##x,y,z,c)), \
 (I[345] = (T)(img)(_p5##x,_n1##y,z,c)), \
 (I[371] = (T)(img)(_p5##x,_n2##y,z,c)), \
 (I[397] = (T)(img)(_p5##x,_n3##y,z,c)), \
 (I[423] = (T)(img)(_p5##x,_n4##y,z,c)), \
 (I[449] = (T)(img)(_p5##x,_n5##y,z,c)), \
 (I[475] = (T)(img)(_p5##x,_n6##y,z,c)), \
 (I[501] = (T)(img)(_p5##x,_n7##y,z,c)), \
 (I[527] = (T)(img)(_p5##x,_n8##y,z,c)), \
 (I[553] = (T)(img)(_p5##x,_n9##y,z,c)), \
 (I[579] = (T)(img)(_p5##x,_n10##y,z,c)), \
 (I[605] = (T)(img)(_p5##x,_n11##y,z,c)), \
 (I[631] = (T)(img)(_p5##x,_n12##y,z,c)), \
 (I[657] = (T)(img)(_p5##x,_n13##y,z,c)), \
 (I[8] = (T)(img)(_p4##x,_p12##y,z,c)), \
 (I[34] = (T)(img)(_p4##x,_p11##y,z,c)), \
 (I[60] = (T)(img)(_p4##x,_p10##y,z,c)), \
 (I[86] = (T)(img)(_p4##x,_p9##y,z,c)), \
 (I[112] = (T)(img)(_p4##x,_p8##y,z,c)), \
 (I[138] = (T)(img)(_p4##x,_p7##y,z,c)), \
 (I[164] = (T)(img)(_p4##x,_p6##y,z,c)), \
 (I[190] = (T)(img)(_p4##x,_p5##y,z,c)), \
 (I[216] = (T)(img)(_p4##x,_p4##y,z,c)), \
 (I[242] = (T)(img)(_p4##x,_p3##y,z,c)), \
 (I[268] = (T)(img)(_p4##x,_p2##y,z,c)), \
 (I[294] = (T)(img)(_p4##x,_p1##y,z,c)), \
 (I[320] = (T)(img)(_p4##x,y,z,c)), \
 (I[346] = (T)(img)(_p4##x,_n1##y,z,c)), \
 (I[372] = (T)(img)(_p4##x,_n2##y,z,c)), \
 (I[398] = (T)(img)(_p4##x,_n3##y,z,c)), \
 (I[424] = (T)(img)(_p4##x,_n4##y,z,c)), \
 (I[450] = (T)(img)(_p4##x,_n5##y,z,c)), \
 (I[476] = (T)(img)(_p4##x,_n6##y,z,c)), \
 (I[502] = (T)(img)(_p4##x,_n7##y,z,c)), \
 (I[528] = (T)(img)(_p4##x,_n8##y,z,c)), \
 (I[554] = (T)(img)(_p4##x,_n9##y,z,c)), \
 (I[580] = (T)(img)(_p4##x,_n10##y,z,c)), \
 (I[606] = (T)(img)(_p4##x,_n11##y,z,c)), \
 (I[632] = (T)(img)(_p4##x,_n12##y,z,c)), \
 (I[658] = (T)(img)(_p4##x,_n13##y,z,c)), \
 (I[9] = (T)(img)(_p3##x,_p12##y,z,c)), \
 (I[35] = (T)(img)(_p3##x,_p11##y,z,c)), \
 (I[61] = (T)(img)(_p3##x,_p10##y,z,c)), \
 (I[87] = (T)(img)(_p3##x,_p9##y,z,c)), \
 (I[113] = (T)(img)(_p3##x,_p8##y,z,c)), \
 (I[139] = (T)(img)(_p3##x,_p7##y,z,c)), \
 (I[165] = (T)(img)(_p3##x,_p6##y,z,c)), \
 (I[191] = (T)(img)(_p3##x,_p5##y,z,c)), \
 (I[217] = (T)(img)(_p3##x,_p4##y,z,c)), \
 (I[243] = (T)(img)(_p3##x,_p3##y,z,c)), \
 (I[269] = (T)(img)(_p3##x,_p2##y,z,c)), \
 (I[295] = (T)(img)(_p3##x,_p1##y,z,c)), \
 (I[321] = (T)(img)(_p3##x,y,z,c)), \
 (I[347] = (T)(img)(_p3##x,_n1##y,z,c)), \
 (I[373] = (T)(img)(_p3##x,_n2##y,z,c)), \
 (I[399] = (T)(img)(_p3##x,_n3##y,z,c)), \
 (I[425] = (T)(img)(_p3##x,_n4##y,z,c)), \
 (I[451] = (T)(img)(_p3##x,_n5##y,z,c)), \
 (I[477] = (T)(img)(_p3##x,_n6##y,z,c)), \
 (I[503] = (T)(img)(_p3##x,_n7##y,z,c)), \
 (I[529] = (T)(img)(_p3##x,_n8##y,z,c)), \
 (I[555] = (T)(img)(_p3##x,_n9##y,z,c)), \
 (I[581] = (T)(img)(_p3##x,_n10##y,z,c)), \
 (I[607] = (T)(img)(_p3##x,_n11##y,z,c)), \
 (I[633] = (T)(img)(_p3##x,_n12##y,z,c)), \
 (I[659] = (T)(img)(_p3##x,_n13##y,z,c)), \
 (I[10] = (T)(img)(_p2##x,_p12##y,z,c)), \
 (I[36] = (T)(img)(_p2##x,_p11##y,z,c)), \
 (I[62] = (T)(img)(_p2##x,_p10##y,z,c)), \
 (I[88] = (T)(img)(_p2##x,_p9##y,z,c)), \
 (I[114] = (T)(img)(_p2##x,_p8##y,z,c)), \
 (I[140] = (T)(img)(_p2##x,_p7##y,z,c)), \
 (I[166] = (T)(img)(_p2##x,_p6##y,z,c)), \
 (I[192] = (T)(img)(_p2##x,_p5##y,z,c)), \
 (I[218] = (T)(img)(_p2##x,_p4##y,z,c)), \
 (I[244] = (T)(img)(_p2##x,_p3##y,z,c)), \
 (I[270] = (T)(img)(_p2##x,_p2##y,z,c)), \
 (I[296] = (T)(img)(_p2##x,_p1##y,z,c)), \
 (I[322] = (T)(img)(_p2##x,y,z,c)), \
 (I[348] = (T)(img)(_p2##x,_n1##y,z,c)), \
 (I[374] = (T)(img)(_p2##x,_n2##y,z,c)), \
 (I[400] = (T)(img)(_p2##x,_n3##y,z,c)), \
 (I[426] = (T)(img)(_p2##x,_n4##y,z,c)), \
 (I[452] = (T)(img)(_p2##x,_n5##y,z,c)), \
 (I[478] = (T)(img)(_p2##x,_n6##y,z,c)), \
 (I[504] = (T)(img)(_p2##x,_n7##y,z,c)), \
 (I[530] = (T)(img)(_p2##x,_n8##y,z,c)), \
 (I[556] = (T)(img)(_p2##x,_n9##y,z,c)), \
 (I[582] = (T)(img)(_p2##x,_n10##y,z,c)), \
 (I[608] = (T)(img)(_p2##x,_n11##y,z,c)), \
 (I[634] = (T)(img)(_p2##x,_n12##y,z,c)), \
 (I[660] = (T)(img)(_p2##x,_n13##y,z,c)), \
 (I[11] = (T)(img)(_p1##x,_p12##y,z,c)), \
 (I[37] = (T)(img)(_p1##x,_p11##y,z,c)), \
 (I[63] = (T)(img)(_p1##x,_p10##y,z,c)), \
 (I[89] = (T)(img)(_p1##x,_p9##y,z,c)), \
 (I[115] = (T)(img)(_p1##x,_p8##y,z,c)), \
 (I[141] = (T)(img)(_p1##x,_p7##y,z,c)), \
 (I[167] = (T)(img)(_p1##x,_p6##y,z,c)), \
 (I[193] = (T)(img)(_p1##x,_p5##y,z,c)), \
 (I[219] = (T)(img)(_p1##x,_p4##y,z,c)), \
 (I[245] = (T)(img)(_p1##x,_p3##y,z,c)), \
 (I[271] = (T)(img)(_p1##x,_p2##y,z,c)), \
 (I[297] = (T)(img)(_p1##x,_p1##y,z,c)), \
 (I[323] = (T)(img)(_p1##x,y,z,c)), \
 (I[349] = (T)(img)(_p1##x,_n1##y,z,c)), \
 (I[375] = (T)(img)(_p1##x,_n2##y,z,c)), \
 (I[401] = (T)(img)(_p1##x,_n3##y,z,c)), \
 (I[427] = (T)(img)(_p1##x,_n4##y,z,c)), \
 (I[453] = (T)(img)(_p1##x,_n5##y,z,c)), \
 (I[479] = (T)(img)(_p1##x,_n6##y,z,c)), \
 (I[505] = (T)(img)(_p1##x,_n7##y,z,c)), \
 (I[531] = (T)(img)(_p1##x,_n8##y,z,c)), \
 (I[557] = (T)(img)(_p1##x,_n9##y,z,c)), \
 (I[583] = (T)(img)(_p1##x,_n10##y,z,c)), \
 (I[609] = (T)(img)(_p1##x,_n11##y,z,c)), \
 (I[635] = (T)(img)(_p1##x,_n12##y,z,c)), \
 (I[661] = (T)(img)(_p1##x,_n13##y,z,c)), \
 (I[12] = (T)(img)(x,_p12##y,z,c)), \
 (I[38] = (T)(img)(x,_p11##y,z,c)), \
 (I[64] = (T)(img)(x,_p10##y,z,c)), \
 (I[90] = (T)(img)(x,_p9##y,z,c)), \
 (I[116] = (T)(img)(x,_p8##y,z,c)), \
 (I[142] = (T)(img)(x,_p7##y,z,c)), \
 (I[168] = (T)(img)(x,_p6##y,z,c)), \
 (I[194] = (T)(img)(x,_p5##y,z,c)), \
 (I[220] = (T)(img)(x,_p4##y,z,c)), \
 (I[246] = (T)(img)(x,_p3##y,z,c)), \
 (I[272] = (T)(img)(x,_p2##y,z,c)), \
 (I[298] = (T)(img)(x,_p1##y,z,c)), \
 (I[324] = (T)(img)(x,y,z,c)), \
 (I[350] = (T)(img)(x,_n1##y,z,c)), \
 (I[376] = (T)(img)(x,_n2##y,z,c)), \
 (I[402] = (T)(img)(x,_n3##y,z,c)), \
 (I[428] = (T)(img)(x,_n4##y,z,c)), \
 (I[454] = (T)(img)(x,_n5##y,z,c)), \
 (I[480] = (T)(img)(x,_n6##y,z,c)), \
 (I[506] = (T)(img)(x,_n7##y,z,c)), \
 (I[532] = (T)(img)(x,_n8##y,z,c)), \
 (I[558] = (T)(img)(x,_n9##y,z,c)), \
 (I[584] = (T)(img)(x,_n10##y,z,c)), \
 (I[610] = (T)(img)(x,_n11##y,z,c)), \
 (I[636] = (T)(img)(x,_n12##y,z,c)), \
 (I[662] = (T)(img)(x,_n13##y,z,c)), \
 (I[13] = (T)(img)(_n1##x,_p12##y,z,c)), \
 (I[39] = (T)(img)(_n1##x,_p11##y,z,c)), \
 (I[65] = (T)(img)(_n1##x,_p10##y,z,c)), \
 (I[91] = (T)(img)(_n1##x,_p9##y,z,c)), \
 (I[117] = (T)(img)(_n1##x,_p8##y,z,c)), \
 (I[143] = (T)(img)(_n1##x,_p7##y,z,c)), \
 (I[169] = (T)(img)(_n1##x,_p6##y,z,c)), \
 (I[195] = (T)(img)(_n1##x,_p5##y,z,c)), \
 (I[221] = (T)(img)(_n1##x,_p4##y,z,c)), \
 (I[247] = (T)(img)(_n1##x,_p3##y,z,c)), \
 (I[273] = (T)(img)(_n1##x,_p2##y,z,c)), \
 (I[299] = (T)(img)(_n1##x,_p1##y,z,c)), \
 (I[325] = (T)(img)(_n1##x,y,z,c)), \
 (I[351] = (T)(img)(_n1##x,_n1##y,z,c)), \
 (I[377] = (T)(img)(_n1##x,_n2##y,z,c)), \
 (I[403] = (T)(img)(_n1##x,_n3##y,z,c)), \
 (I[429] = (T)(img)(_n1##x,_n4##y,z,c)), \
 (I[455] = (T)(img)(_n1##x,_n5##y,z,c)), \
 (I[481] = (T)(img)(_n1##x,_n6##y,z,c)), \
 (I[507] = (T)(img)(_n1##x,_n7##y,z,c)), \
 (I[533] = (T)(img)(_n1##x,_n8##y,z,c)), \
 (I[559] = (T)(img)(_n1##x,_n9##y,z,c)), \
 (I[585] = (T)(img)(_n1##x,_n10##y,z,c)), \
 (I[611] = (T)(img)(_n1##x,_n11##y,z,c)), \
 (I[637] = (T)(img)(_n1##x,_n12##y,z,c)), \
 (I[663] = (T)(img)(_n1##x,_n13##y,z,c)), \
 (I[14] = (T)(img)(_n2##x,_p12##y,z,c)), \
 (I[40] = (T)(img)(_n2##x,_p11##y,z,c)), \
 (I[66] = (T)(img)(_n2##x,_p10##y,z,c)), \
 (I[92] = (T)(img)(_n2##x,_p9##y,z,c)), \
 (I[118] = (T)(img)(_n2##x,_p8##y,z,c)), \
 (I[144] = (T)(img)(_n2##x,_p7##y,z,c)), \
 (I[170] = (T)(img)(_n2##x,_p6##y,z,c)), \
 (I[196] = (T)(img)(_n2##x,_p5##y,z,c)), \
 (I[222] = (T)(img)(_n2##x,_p4##y,z,c)), \
 (I[248] = (T)(img)(_n2##x,_p3##y,z,c)), \
 (I[274] = (T)(img)(_n2##x,_p2##y,z,c)), \
 (I[300] = (T)(img)(_n2##x,_p1##y,z,c)), \
 (I[326] = (T)(img)(_n2##x,y,z,c)), \
 (I[352] = (T)(img)(_n2##x,_n1##y,z,c)), \
 (I[378] = (T)(img)(_n2##x,_n2##y,z,c)), \
 (I[404] = (T)(img)(_n2##x,_n3##y,z,c)), \
 (I[430] = (T)(img)(_n2##x,_n4##y,z,c)), \
 (I[456] = (T)(img)(_n2##x,_n5##y,z,c)), \
 (I[482] = (T)(img)(_n2##x,_n6##y,z,c)), \
 (I[508] = (T)(img)(_n2##x,_n7##y,z,c)), \
 (I[534] = (T)(img)(_n2##x,_n8##y,z,c)), \
 (I[560] = (T)(img)(_n2##x,_n9##y,z,c)), \
 (I[586] = (T)(img)(_n2##x,_n10##y,z,c)), \
 (I[612] = (T)(img)(_n2##x,_n11##y,z,c)), \
 (I[638] = (T)(img)(_n2##x,_n12##y,z,c)), \
 (I[664] = (T)(img)(_n2##x,_n13##y,z,c)), \
 (I[15] = (T)(img)(_n3##x,_p12##y,z,c)), \
 (I[41] = (T)(img)(_n3##x,_p11##y,z,c)), \
 (I[67] = (T)(img)(_n3##x,_p10##y,z,c)), \
 (I[93] = (T)(img)(_n3##x,_p9##y,z,c)), \
 (I[119] = (T)(img)(_n3##x,_p8##y,z,c)), \
 (I[145] = (T)(img)(_n3##x,_p7##y,z,c)), \
 (I[171] = (T)(img)(_n3##x,_p6##y,z,c)), \
 (I[197] = (T)(img)(_n3##x,_p5##y,z,c)), \
 (I[223] = (T)(img)(_n3##x,_p4##y,z,c)), \
 (I[249] = (T)(img)(_n3##x,_p3##y,z,c)), \
 (I[275] = (T)(img)(_n3##x,_p2##y,z,c)), \
 (I[301] = (T)(img)(_n3##x,_p1##y,z,c)), \
 (I[327] = (T)(img)(_n3##x,y,z,c)), \
 (I[353] = (T)(img)(_n3##x,_n1##y,z,c)), \
 (I[379] = (T)(img)(_n3##x,_n2##y,z,c)), \
 (I[405] = (T)(img)(_n3##x,_n3##y,z,c)), \
 (I[431] = (T)(img)(_n3##x,_n4##y,z,c)), \
 (I[457] = (T)(img)(_n3##x,_n5##y,z,c)), \
 (I[483] = (T)(img)(_n3##x,_n6##y,z,c)), \
 (I[509] = (T)(img)(_n3##x,_n7##y,z,c)), \
 (I[535] = (T)(img)(_n3##x,_n8##y,z,c)), \
 (I[561] = (T)(img)(_n3##x,_n9##y,z,c)), \
 (I[587] = (T)(img)(_n3##x,_n10##y,z,c)), \
 (I[613] = (T)(img)(_n3##x,_n11##y,z,c)), \
 (I[639] = (T)(img)(_n3##x,_n12##y,z,c)), \
 (I[665] = (T)(img)(_n3##x,_n13##y,z,c)), \
 (I[16] = (T)(img)(_n4##x,_p12##y,z,c)), \
 (I[42] = (T)(img)(_n4##x,_p11##y,z,c)), \
 (I[68] = (T)(img)(_n4##x,_p10##y,z,c)), \
 (I[94] = (T)(img)(_n4##x,_p9##y,z,c)), \
 (I[120] = (T)(img)(_n4##x,_p8##y,z,c)), \
 (I[146] = (T)(img)(_n4##x,_p7##y,z,c)), \
 (I[172] = (T)(img)(_n4##x,_p6##y,z,c)), \
 (I[198] = (T)(img)(_n4##x,_p5##y,z,c)), \
 (I[224] = (T)(img)(_n4##x,_p4##y,z,c)), \
 (I[250] = (T)(img)(_n4##x,_p3##y,z,c)), \
 (I[276] = (T)(img)(_n4##x,_p2##y,z,c)), \
 (I[302] = (T)(img)(_n4##x,_p1##y,z,c)), \
 (I[328] = (T)(img)(_n4##x,y,z,c)), \
 (I[354] = (T)(img)(_n4##x,_n1##y,z,c)), \
 (I[380] = (T)(img)(_n4##x,_n2##y,z,c)), \
 (I[406] = (T)(img)(_n4##x,_n3##y,z,c)), \
 (I[432] = (T)(img)(_n4##x,_n4##y,z,c)), \
 (I[458] = (T)(img)(_n4##x,_n5##y,z,c)), \
 (I[484] = (T)(img)(_n4##x,_n6##y,z,c)), \
 (I[510] = (T)(img)(_n4##x,_n7##y,z,c)), \
 (I[536] = (T)(img)(_n4##x,_n8##y,z,c)), \
 (I[562] = (T)(img)(_n4##x,_n9##y,z,c)), \
 (I[588] = (T)(img)(_n4##x,_n10##y,z,c)), \
 (I[614] = (T)(img)(_n4##x,_n11##y,z,c)), \
 (I[640] = (T)(img)(_n4##x,_n12##y,z,c)), \
 (I[666] = (T)(img)(_n4##x,_n13##y,z,c)), \
 (I[17] = (T)(img)(_n5##x,_p12##y,z,c)), \
 (I[43] = (T)(img)(_n5##x,_p11##y,z,c)), \
 (I[69] = (T)(img)(_n5##x,_p10##y,z,c)), \
 (I[95] = (T)(img)(_n5##x,_p9##y,z,c)), \
 (I[121] = (T)(img)(_n5##x,_p8##y,z,c)), \
 (I[147] = (T)(img)(_n5##x,_p7##y,z,c)), \
 (I[173] = (T)(img)(_n5##x,_p6##y,z,c)), \
 (I[199] = (T)(img)(_n5##x,_p5##y,z,c)), \
 (I[225] = (T)(img)(_n5##x,_p4##y,z,c)), \
 (I[251] = (T)(img)(_n5##x,_p3##y,z,c)), \
 (I[277] = (T)(img)(_n5##x,_p2##y,z,c)), \
 (I[303] = (T)(img)(_n5##x,_p1##y,z,c)), \
 (I[329] = (T)(img)(_n5##x,y,z,c)), \
 (I[355] = (T)(img)(_n5##x,_n1##y,z,c)), \
 (I[381] = (T)(img)(_n5##x,_n2##y,z,c)), \
 (I[407] = (T)(img)(_n5##x,_n3##y,z,c)), \
 (I[433] = (T)(img)(_n5##x,_n4##y,z,c)), \
 (I[459] = (T)(img)(_n5##x,_n5##y,z,c)), \
 (I[485] = (T)(img)(_n5##x,_n6##y,z,c)), \
 (I[511] = (T)(img)(_n5##x,_n7##y,z,c)), \
 (I[537] = (T)(img)(_n5##x,_n8##y,z,c)), \
 (I[563] = (T)(img)(_n5##x,_n9##y,z,c)), \
 (I[589] = (T)(img)(_n5##x,_n10##y,z,c)), \
 (I[615] = (T)(img)(_n5##x,_n11##y,z,c)), \
 (I[641] = (T)(img)(_n5##x,_n12##y,z,c)), \
 (I[667] = (T)(img)(_n5##x,_n13##y,z,c)), \
 (I[18] = (T)(img)(_n6##x,_p12##y,z,c)), \
 (I[44] = (T)(img)(_n6##x,_p11##y,z,c)), \
 (I[70] = (T)(img)(_n6##x,_p10##y,z,c)), \
 (I[96] = (T)(img)(_n6##x,_p9##y,z,c)), \
 (I[122] = (T)(img)(_n6##x,_p8##y,z,c)), \
 (I[148] = (T)(img)(_n6##x,_p7##y,z,c)), \
 (I[174] = (T)(img)(_n6##x,_p6##y,z,c)), \
 (I[200] = (T)(img)(_n6##x,_p5##y,z,c)), \
 (I[226] = (T)(img)(_n6##x,_p4##y,z,c)), \
 (I[252] = (T)(img)(_n6##x,_p3##y,z,c)), \
 (I[278] = (T)(img)(_n6##x,_p2##y,z,c)), \
 (I[304] = (T)(img)(_n6##x,_p1##y,z,c)), \
 (I[330] = (T)(img)(_n6##x,y,z,c)), \
 (I[356] = (T)(img)(_n6##x,_n1##y,z,c)), \
 (I[382] = (T)(img)(_n6##x,_n2##y,z,c)), \
 (I[408] = (T)(img)(_n6##x,_n3##y,z,c)), \
 (I[434] = (T)(img)(_n6##x,_n4##y,z,c)), \
 (I[460] = (T)(img)(_n6##x,_n5##y,z,c)), \
 (I[486] = (T)(img)(_n6##x,_n6##y,z,c)), \
 (I[512] = (T)(img)(_n6##x,_n7##y,z,c)), \
 (I[538] = (T)(img)(_n6##x,_n8##y,z,c)), \
 (I[564] = (T)(img)(_n6##x,_n9##y,z,c)), \
 (I[590] = (T)(img)(_n6##x,_n10##y,z,c)), \
 (I[616] = (T)(img)(_n6##x,_n11##y,z,c)), \
 (I[642] = (T)(img)(_n6##x,_n12##y,z,c)), \
 (I[668] = (T)(img)(_n6##x,_n13##y,z,c)), \
 (I[19] = (T)(img)(_n7##x,_p12##y,z,c)), \
 (I[45] = (T)(img)(_n7##x,_p11##y,z,c)), \
 (I[71] = (T)(img)(_n7##x,_p10##y,z,c)), \
 (I[97] = (T)(img)(_n7##x,_p9##y,z,c)), \
 (I[123] = (T)(img)(_n7##x,_p8##y,z,c)), \
 (I[149] = (T)(img)(_n7##x,_p7##y,z,c)), \
 (I[175] = (T)(img)(_n7##x,_p6##y,z,c)), \
 (I[201] = (T)(img)(_n7##x,_p5##y,z,c)), \
 (I[227] = (T)(img)(_n7##x,_p4##y,z,c)), \
 (I[253] = (T)(img)(_n7##x,_p3##y,z,c)), \
 (I[279] = (T)(img)(_n7##x,_p2##y,z,c)), \
 (I[305] = (T)(img)(_n7##x,_p1##y,z,c)), \
 (I[331] = (T)(img)(_n7##x,y,z,c)), \
 (I[357] = (T)(img)(_n7##x,_n1##y,z,c)), \
 (I[383] = (T)(img)(_n7##x,_n2##y,z,c)), \
 (I[409] = (T)(img)(_n7##x,_n3##y,z,c)), \
 (I[435] = (T)(img)(_n7##x,_n4##y,z,c)), \
 (I[461] = (T)(img)(_n7##x,_n5##y,z,c)), \
 (I[487] = (T)(img)(_n7##x,_n6##y,z,c)), \
 (I[513] = (T)(img)(_n7##x,_n7##y,z,c)), \
 (I[539] = (T)(img)(_n7##x,_n8##y,z,c)), \
 (I[565] = (T)(img)(_n7##x,_n9##y,z,c)), \
 (I[591] = (T)(img)(_n7##x,_n10##y,z,c)), \
 (I[617] = (T)(img)(_n7##x,_n11##y,z,c)), \
 (I[643] = (T)(img)(_n7##x,_n12##y,z,c)), \
 (I[669] = (T)(img)(_n7##x,_n13##y,z,c)), \
 (I[20] = (T)(img)(_n8##x,_p12##y,z,c)), \
 (I[46] = (T)(img)(_n8##x,_p11##y,z,c)), \
 (I[72] = (T)(img)(_n8##x,_p10##y,z,c)), \
 (I[98] = (T)(img)(_n8##x,_p9##y,z,c)), \
 (I[124] = (T)(img)(_n8##x,_p8##y,z,c)), \
 (I[150] = (T)(img)(_n8##x,_p7##y,z,c)), \
 (I[176] = (T)(img)(_n8##x,_p6##y,z,c)), \
 (I[202] = (T)(img)(_n8##x,_p5##y,z,c)), \
 (I[228] = (T)(img)(_n8##x,_p4##y,z,c)), \
 (I[254] = (T)(img)(_n8##x,_p3##y,z,c)), \
 (I[280] = (T)(img)(_n8##x,_p2##y,z,c)), \
 (I[306] = (T)(img)(_n8##x,_p1##y,z,c)), \
 (I[332] = (T)(img)(_n8##x,y,z,c)), \
 (I[358] = (T)(img)(_n8##x,_n1##y,z,c)), \
 (I[384] = (T)(img)(_n8##x,_n2##y,z,c)), \
 (I[410] = (T)(img)(_n8##x,_n3##y,z,c)), \
 (I[436] = (T)(img)(_n8##x,_n4##y,z,c)), \
 (I[462] = (T)(img)(_n8##x,_n5##y,z,c)), \
 (I[488] = (T)(img)(_n8##x,_n6##y,z,c)), \
 (I[514] = (T)(img)(_n8##x,_n7##y,z,c)), \
 (I[540] = (T)(img)(_n8##x,_n8##y,z,c)), \
 (I[566] = (T)(img)(_n8##x,_n9##y,z,c)), \
 (I[592] = (T)(img)(_n8##x,_n10##y,z,c)), \
 (I[618] = (T)(img)(_n8##x,_n11##y,z,c)), \
 (I[644] = (T)(img)(_n8##x,_n12##y,z,c)), \
 (I[670] = (T)(img)(_n8##x,_n13##y,z,c)), \
 (I[21] = (T)(img)(_n9##x,_p12##y,z,c)), \
 (I[47] = (T)(img)(_n9##x,_p11##y,z,c)), \
 (I[73] = (T)(img)(_n9##x,_p10##y,z,c)), \
 (I[99] = (T)(img)(_n9##x,_p9##y,z,c)), \
 (I[125] = (T)(img)(_n9##x,_p8##y,z,c)), \
 (I[151] = (T)(img)(_n9##x,_p7##y,z,c)), \
 (I[177] = (T)(img)(_n9##x,_p6##y,z,c)), \
 (I[203] = (T)(img)(_n9##x,_p5##y,z,c)), \
 (I[229] = (T)(img)(_n9##x,_p4##y,z,c)), \
 (I[255] = (T)(img)(_n9##x,_p3##y,z,c)), \
 (I[281] = (T)(img)(_n9##x,_p2##y,z,c)), \
 (I[307] = (T)(img)(_n9##x,_p1##y,z,c)), \
 (I[333] = (T)(img)(_n9##x,y,z,c)), \
 (I[359] = (T)(img)(_n9##x,_n1##y,z,c)), \
 (I[385] = (T)(img)(_n9##x,_n2##y,z,c)), \
 (I[411] = (T)(img)(_n9##x,_n3##y,z,c)), \
 (I[437] = (T)(img)(_n9##x,_n4##y,z,c)), \
 (I[463] = (T)(img)(_n9##x,_n5##y,z,c)), \
 (I[489] = (T)(img)(_n9##x,_n6##y,z,c)), \
 (I[515] = (T)(img)(_n9##x,_n7##y,z,c)), \
 (I[541] = (T)(img)(_n9##x,_n8##y,z,c)), \
 (I[567] = (T)(img)(_n9##x,_n9##y,z,c)), \
 (I[593] = (T)(img)(_n9##x,_n10##y,z,c)), \
 (I[619] = (T)(img)(_n9##x,_n11##y,z,c)), \
 (I[645] = (T)(img)(_n9##x,_n12##y,z,c)), \
 (I[671] = (T)(img)(_n9##x,_n13##y,z,c)), \
 (I[22] = (T)(img)(_n10##x,_p12##y,z,c)), \
 (I[48] = (T)(img)(_n10##x,_p11##y,z,c)), \
 (I[74] = (T)(img)(_n10##x,_p10##y,z,c)), \
 (I[100] = (T)(img)(_n10##x,_p9##y,z,c)), \
 (I[126] = (T)(img)(_n10##x,_p8##y,z,c)), \
 (I[152] = (T)(img)(_n10##x,_p7##y,z,c)), \
 (I[178] = (T)(img)(_n10##x,_p6##y,z,c)), \
 (I[204] = (T)(img)(_n10##x,_p5##y,z,c)), \
 (I[230] = (T)(img)(_n10##x,_p4##y,z,c)), \
 (I[256] = (T)(img)(_n10##x,_p3##y,z,c)), \
 (I[282] = (T)(img)(_n10##x,_p2##y,z,c)), \
 (I[308] = (T)(img)(_n10##x,_p1##y,z,c)), \
 (I[334] = (T)(img)(_n10##x,y,z,c)), \
 (I[360] = (T)(img)(_n10##x,_n1##y,z,c)), \
 (I[386] = (T)(img)(_n10##x,_n2##y,z,c)), \
 (I[412] = (T)(img)(_n10##x,_n3##y,z,c)), \
 (I[438] = (T)(img)(_n10##x,_n4##y,z,c)), \
 (I[464] = (T)(img)(_n10##x,_n5##y,z,c)), \
 (I[490] = (T)(img)(_n10##x,_n6##y,z,c)), \
 (I[516] = (T)(img)(_n10##x,_n7##y,z,c)), \
 (I[542] = (T)(img)(_n10##x,_n8##y,z,c)), \
 (I[568] = (T)(img)(_n10##x,_n9##y,z,c)), \
 (I[594] = (T)(img)(_n10##x,_n10##y,z,c)), \
 (I[620] = (T)(img)(_n10##x,_n11##y,z,c)), \
 (I[646] = (T)(img)(_n10##x,_n12##y,z,c)), \
 (I[672] = (T)(img)(_n10##x,_n13##y,z,c)), \
 (I[23] = (T)(img)(_n11##x,_p12##y,z,c)), \
 (I[49] = (T)(img)(_n11##x,_p11##y,z,c)), \
 (I[75] = (T)(img)(_n11##x,_p10##y,z,c)), \
 (I[101] = (T)(img)(_n11##x,_p9##y,z,c)), \
 (I[127] = (T)(img)(_n11##x,_p8##y,z,c)), \
 (I[153] = (T)(img)(_n11##x,_p7##y,z,c)), \
 (I[179] = (T)(img)(_n11##x,_p6##y,z,c)), \
 (I[205] = (T)(img)(_n11##x,_p5##y,z,c)), \
 (I[231] = (T)(img)(_n11##x,_p4##y,z,c)), \
 (I[257] = (T)(img)(_n11##x,_p3##y,z,c)), \
 (I[283] = (T)(img)(_n11##x,_p2##y,z,c)), \
 (I[309] = (T)(img)(_n11##x,_p1##y,z,c)), \
 (I[335] = (T)(img)(_n11##x,y,z,c)), \
 (I[361] = (T)(img)(_n11##x,_n1##y,z,c)), \
 (I[387] = (T)(img)(_n11##x,_n2##y,z,c)), \
 (I[413] = (T)(img)(_n11##x,_n3##y,z,c)), \
 (I[439] = (T)(img)(_n11##x,_n4##y,z,c)), \
 (I[465] = (T)(img)(_n11##x,_n5##y,z,c)), \
 (I[491] = (T)(img)(_n11##x,_n6##y,z,c)), \
 (I[517] = (T)(img)(_n11##x,_n7##y,z,c)), \
 (I[543] = (T)(img)(_n11##x,_n8##y,z,c)), \
 (I[569] = (T)(img)(_n11##x,_n9##y,z,c)), \
 (I[595] = (T)(img)(_n11##x,_n10##y,z,c)), \
 (I[621] = (T)(img)(_n11##x,_n11##y,z,c)), \
 (I[647] = (T)(img)(_n11##x,_n12##y,z,c)), \
 (I[673] = (T)(img)(_n11##x,_n13##y,z,c)), \
 (I[24] = (T)(img)(_n12##x,_p12##y,z,c)), \
 (I[50] = (T)(img)(_n12##x,_p11##y,z,c)), \
 (I[76] = (T)(img)(_n12##x,_p10##y,z,c)), \
 (I[102] = (T)(img)(_n12##x,_p9##y,z,c)), \
 (I[128] = (T)(img)(_n12##x,_p8##y,z,c)), \
 (I[154] = (T)(img)(_n12##x,_p7##y,z,c)), \
 (I[180] = (T)(img)(_n12##x,_p6##y,z,c)), \
 (I[206] = (T)(img)(_n12##x,_p5##y,z,c)), \
 (I[232] = (T)(img)(_n12##x,_p4##y,z,c)), \
 (I[258] = (T)(img)(_n12##x,_p3##y,z,c)), \
 (I[284] = (T)(img)(_n12##x,_p2##y,z,c)), \
 (I[310] = (T)(img)(_n12##x,_p1##y,z,c)), \
 (I[336] = (T)(img)(_n12##x,y,z,c)), \
 (I[362] = (T)(img)(_n12##x,_n1##y,z,c)), \
 (I[388] = (T)(img)(_n12##x,_n2##y,z,c)), \
 (I[414] = (T)(img)(_n12##x,_n3##y,z,c)), \
 (I[440] = (T)(img)(_n12##x,_n4##y,z,c)), \
 (I[466] = (T)(img)(_n12##x,_n5##y,z,c)), \
 (I[492] = (T)(img)(_n12##x,_n6##y,z,c)), \
 (I[518] = (T)(img)(_n12##x,_n7##y,z,c)), \
 (I[544] = (T)(img)(_n12##x,_n8##y,z,c)), \
 (I[570] = (T)(img)(_n12##x,_n9##y,z,c)), \
 (I[596] = (T)(img)(_n12##x,_n10##y,z,c)), \
 (I[622] = (T)(img)(_n12##x,_n11##y,z,c)), \
 (I[648] = (T)(img)(_n12##x,_n12##y,z,c)), \
 (I[674] = (T)(img)(_n12##x,_n13##y,z,c)), \
 x+13>=(img).width()?(img).width()-1:x+13); \
 x<=(int)(x1) && ((_n13##x<(img).width() && ( \
 (I[25] = (T)(img)(_n13##x,_p12##y,z,c)), \
 (I[51] = (T)(img)(_n13##x,_p11##y,z,c)), \
 (I[77] = (T)(img)(_n13##x,_p10##y,z,c)), \
 (I[103] = (T)(img)(_n13##x,_p9##y,z,c)), \
 (I[129] = (T)(img)(_n13##x,_p8##y,z,c)), \
 (I[155] = (T)(img)(_n13##x,_p7##y,z,c)), \
 (I[181] = (T)(img)(_n13##x,_p6##y,z,c)), \
 (I[207] = (T)(img)(_n13##x,_p5##y,z,c)), \
 (I[233] = (T)(img)(_n13##x,_p4##y,z,c)), \
 (I[259] = (T)(img)(_n13##x,_p3##y,z,c)), \
 (I[285] = (T)(img)(_n13##x,_p2##y,z,c)), \
 (I[311] = (T)(img)(_n13##x,_p1##y,z,c)), \
 (I[337] = (T)(img)(_n13##x,y,z,c)), \
 (I[363] = (T)(img)(_n13##x,_n1##y,z,c)), \
 (I[389] = (T)(img)(_n13##x,_n2##y,z,c)), \
 (I[415] = (T)(img)(_n13##x,_n3##y,z,c)), \
 (I[441] = (T)(img)(_n13##x,_n4##y,z,c)), \
 (I[467] = (T)(img)(_n13##x,_n5##y,z,c)), \
 (I[493] = (T)(img)(_n13##x,_n6##y,z,c)), \
 (I[519] = (T)(img)(_n13##x,_n7##y,z,c)), \
 (I[545] = (T)(img)(_n13##x,_n8##y,z,c)), \
 (I[571] = (T)(img)(_n13##x,_n9##y,z,c)), \
 (I[597] = (T)(img)(_n13##x,_n10##y,z,c)), \
 (I[623] = (T)(img)(_n13##x,_n11##y,z,c)), \
 (I[649] = (T)(img)(_n13##x,_n12##y,z,c)), \
 (I[675] = (T)(img)(_n13##x,_n13##y,z,c)),1)) || \
 _n12##x==--_n13##x || _n11##x==--_n12##x || _n10##x==--_n11##x || _n9##x==--_n10##x || _n8##x==--_n9##x || _n7##x==--_n8##x || _n6##x==--_n7##x || _n5##x==--_n6##x || _n4##x==--_n5##x || _n3##x==--_n4##x || _n2##x==--_n3##x || _n1##x==--_n2##x || x==(_n13##x = _n12##x = _n11##x = _n10##x = _n9##x = _n8##x = _n7##x = _n6##x = _n5##x = _n4##x = _n3##x = _n2##x = --_n1##x)); \
 I[0] = I[1], I[1] = I[2], I[2] = I[3], I[3] = I[4], I[4] = I[5], I[5] = I[6], I[6] = I[7], I[7] = I[8], I[8] = I[9], I[9] = I[10], I[10] = I[11], I[11] = I[12], I[12] = I[13], I[13] = I[14], I[14] = I[15], I[15] = I[16], I[16] = I[17], I[17] = I[18], I[18] = I[19], I[19] = I[20], I[20] = I[21], I[21] = I[22], I[22] = I[23], I[23] = I[24], I[24] = I[25], \
 I[26] = I[27], I[27] = I[28], I[28] = I[29], I[29] = I[30], I[30] = I[31], I[31] = I[32], I[32] = I[33], I[33] = I[34], I[34] = I[35], I[35] = I[36], I[36] = I[37], I[37] = I[38], I[38] = I[39], I[39] = I[40], I[40] = I[41], I[41] = I[42], I[42] = I[43], I[43] = I[44], I[44] = I[45], I[45] = I[46], I[46] = I[47], I[47] = I[48], I[48] = I[49], I[49] = I[50], I[50] = I[51], \
 I[52] = I[53], I[53] = I[54], I[54] = I[55], I[55] = I[56], I[56] = I[57], I[57] = I[58], I[58] = I[59], I[59] = I[60], I[60] = I[61], I[61] = I[62], I[62] = I[63], I[63] = I[64], I[64] = I[65], I[65] = I[66], I[66] = I[67], I[67] = I[68], I[68] = I[69], I[69] = I[70], I[70] = I[71], I[71] = I[72], I[72] = I[73], I[73] = I[74], I[74] = I[75], I[75] = I[76], I[76] = I[77], \
 I[78] = I[79], I[79] = I[80], I[80] = I[81], I[81] = I[82], I[82] = I[83], I[83] = I[84], I[84] = I[85], I[85] = I[86], I[86] = I[87], I[87] = I[88], I[88] = I[89], I[89] = I[90], I[90] = I[91], I[91] = I[92], I[92] = I[93], I[93] = I[94], I[94] = I[95], I[95] = I[96], I[96] = I[97], I[97] = I[98], I[98] = I[99], I[99] = I[100], I[100] = I[101], I[101] = I[102], I[102] = I[103], \
 I[104] = I[105], I[105] = I[106], I[106] = I[107], I[107] = I[108], I[108] = I[109], I[109] = I[110], I[110] = I[111], I[111] = I[112], I[112] = I[113], I[113] = I[114], I[114] = I[115], I[115] = I[116], I[116] = I[117], I[117] = I[118], I[118] = I[119], I[119] = I[120], I[120] = I[121], I[121] = I[122], I[122] = I[123], I[123] = I[124], I[124] = I[125], I[125] = I[126], I[126] = I[127], I[127] = I[128], I[128] = I[129], \
 I[130] = I[131], I[131] = I[132], I[132] = I[133], I[133] = I[134], I[134] = I[135], I[135] = I[136], I[136] = I[137], I[137] = I[138], I[138] = I[139], I[139] = I[140], I[140] = I[141], I[141] = I[142], I[142] = I[143], I[143] = I[144], I[144] = I[145], I[145] = I[146], I[146] = I[147], I[147] = I[148], I[148] = I[149], I[149] = I[150], I[150] = I[151], I[151] = I[152], I[152] = I[153], I[153] = I[154], I[154] = I[155], \
 I[156] = I[157], I[157] = I[158], I[158] = I[159], I[159] = I[160], I[160] = I[161], I[161] = I[162], I[162] = I[163], I[163] = I[164], I[164] = I[165], I[165] = I[166], I[166] = I[167], I[167] = I[168], I[168] = I[169], I[169] = I[170], I[170] = I[171], I[171] = I[172], I[172] = I[173], I[173] = I[174], I[174] = I[175], I[175] = I[176], I[176] = I[177], I[177] = I[178], I[178] = I[179], I[179] = I[180], I[180] = I[181], \
 I[182] = I[183], I[183] = I[184], I[184] = I[185], I[185] = I[186], I[186] = I[187], I[187] = I[188], I[188] = I[189], I[189] = I[190], I[190] = I[191], I[191] = I[192], I[192] = I[193], I[193] = I[194], I[194] = I[195], I[195] = I[196], I[196] = I[197], I[197] = I[198], I[198] = I[199], I[199] = I[200], I[200] = I[201], I[201] = I[202], I[202] = I[203], I[203] = I[204], I[204] = I[205], I[205] = I[206], I[206] = I[207], \
 I[208] = I[209], I[209] = I[210], I[210] = I[211], I[211] = I[212], I[212] = I[213], I[213] = I[214], I[214] = I[215], I[215] = I[216], I[216] = I[217], I[217] = I[218], I[218] = I[219], I[219] = I[220], I[220] = I[221], I[221] = I[222], I[222] = I[223], I[223] = I[224], I[224] = I[225], I[225] = I[226], I[226] = I[227], I[227] = I[228], I[228] = I[229], I[229] = I[230], I[230] = I[231], I[231] = I[232], I[232] = I[233], \
 I[234] = I[235], I[235] = I[236], I[236] = I[237], I[237] = I[238], I[238] = I[239], I[239] = I[240], I[240] = I[241], I[241] = I[242], I[242] = I[243], I[243] = I[244], I[244] = I[245], I[245] = I[246], I[246] = I[247], I[247] = I[248], I[248] = I[249], I[249] = I[250], I[250] = I[251], I[251] = I[252], I[252] = I[253], I[253] = I[254], I[254] = I[255], I[255] = I[256], I[256] = I[257], I[257] = I[258], I[258] = I[259], \
 I[260] = I[261], I[261] = I[262], I[262] = I[263], I[263] = I[264], I[264] = I[265], I[265] = I[266], I[266] = I[267], I[267] = I[268], I[268] = I[269], I[269] = I[270], I[270] = I[271], I[271] = I[272], I[272] = I[273], I[273] = I[274], I[274] = I[275], I[275] = I[276], I[276] = I[277], I[277] = I[278], I[278] = I[279], I[279] = I[280], I[280] = I[281], I[281] = I[282], I[282] = I[283], I[283] = I[284], I[284] = I[285], \
 I[286] = I[287], I[287] = I[288], I[288] = I[289], I[289] = I[290], I[290] = I[291], I[291] = I[292], I[292] = I[293], I[293] = I[294], I[294] = I[295], I[295] = I[296], I[296] = I[297], I[297] = I[298], I[298] = I[299], I[299] = I[300], I[300] = I[301], I[301] = I[302], I[302] = I[303], I[303] = I[304], I[304] = I[305], I[305] = I[306], I[306] = I[307], I[307] = I[308], I[308] = I[309], I[309] = I[310], I[310] = I[311], \
 I[312] = I[313], I[313] = I[314], I[314] = I[315], I[315] = I[316], I[316] = I[317], I[317] = I[318], I[318] = I[319], I[319] = I[320], I[320] = I[321], I[321] = I[322], I[322] = I[323], I[323] = I[324], I[324] = I[325], I[325] = I[326], I[326] = I[327], I[327] = I[328], I[328] = I[329], I[329] = I[330], I[330] = I[331], I[331] = I[332], I[332] = I[333], I[333] = I[334], I[334] = I[335], I[335] = I[336], I[336] = I[337], \
 I[338] = I[339], I[339] = I[340], I[340] = I[341], I[341] = I[342], I[342] = I[343], I[343] = I[344], I[344] = I[345], I[345] = I[346], I[346] = I[347], I[347] = I[348], I[348] = I[349], I[349] = I[350], I[350] = I[351], I[351] = I[352], I[352] = I[353], I[353] = I[354], I[354] = I[355], I[355] = I[356], I[356] = I[357], I[357] = I[358], I[358] = I[359], I[359] = I[360], I[360] = I[361], I[361] = I[362], I[362] = I[363], \
 I[364] = I[365], I[365] = I[366], I[366] = I[367], I[367] = I[368], I[368] = I[369], I[369] = I[370], I[370] = I[371], I[371] = I[372], I[372] = I[373], I[373] = I[374], I[374] = I[375], I[375] = I[376], I[376] = I[377], I[377] = I[378], I[378] = I[379], I[379] = I[380], I[380] = I[381], I[381] = I[382], I[382] = I[383], I[383] = I[384], I[384] = I[385], I[385] = I[386], I[386] = I[387], I[387] = I[388], I[388] = I[389], \
 I[390] = I[391], I[391] = I[392], I[392] = I[393], I[393] = I[394], I[394] = I[395], I[395] = I[396], I[396] = I[397], I[397] = I[398], I[398] = I[399], I[399] = I[400], I[400] = I[401], I[401] = I[402], I[402] = I[403], I[403] = I[404], I[404] = I[405], I[405] = I[406], I[406] = I[407], I[407] = I[408], I[408] = I[409], I[409] = I[410], I[410] = I[411], I[411] = I[412], I[412] = I[413], I[413] = I[414], I[414] = I[415], \
 I[416] = I[417], I[417] = I[418], I[418] = I[419], I[419] = I[420], I[420] = I[421], I[421] = I[422], I[422] = I[423], I[423] = I[424], I[424] = I[425], I[425] = I[426], I[426] = I[427], I[427] = I[428], I[428] = I[429], I[429] = I[430], I[430] = I[431], I[431] = I[432], I[432] = I[433], I[433] = I[434], I[434] = I[435], I[435] = I[436], I[436] = I[437], I[437] = I[438], I[438] = I[439], I[439] = I[440], I[440] = I[441], \
 I[442] = I[443], I[443] = I[444], I[444] = I[445], I[445] = I[446], I[446] = I[447], I[447] = I[448], I[448] = I[449], I[449] = I[450], I[450] = I[451], I[451] = I[452], I[452] = I[453], I[453] = I[454], I[454] = I[455], I[455] = I[456], I[456] = I[457], I[457] = I[458], I[458] = I[459], I[459] = I[460], I[460] = I[461], I[461] = I[462], I[462] = I[463], I[463] = I[464], I[464] = I[465], I[465] = I[466], I[466] = I[467], \
 I[468] = I[469], I[469] = I[470], I[470] = I[471], I[471] = I[472], I[472] = I[473], I[473] = I[474], I[474] = I[475], I[475] = I[476], I[476] = I[477], I[477] = I[478], I[478] = I[479], I[479] = I[480], I[480] = I[481], I[481] = I[482], I[482] = I[483], I[483] = I[484], I[484] = I[485], I[485] = I[486], I[486] = I[487], I[487] = I[488], I[488] = I[489], I[489] = I[490], I[490] = I[491], I[491] = I[492], I[492] = I[493], \
 I[494] = I[495], I[495] = I[496], I[496] = I[497], I[497] = I[498], I[498] = I[499], I[499] = I[500], I[500] = I[501], I[501] = I[502], I[502] = I[503], I[503] = I[504], I[504] = I[505], I[505] = I[506], I[506] = I[507], I[507] = I[508], I[508] = I[509], I[509] = I[510], I[510] = I[511], I[511] = I[512], I[512] = I[513], I[513] = I[514], I[514] = I[515], I[515] = I[516], I[516] = I[517], I[517] = I[518], I[518] = I[519], \
 I[520] = I[521], I[521] = I[522], I[522] = I[523], I[523] = I[524], I[524] = I[525], I[525] = I[526], I[526] = I[527], I[527] = I[528], I[528] = I[529], I[529] = I[530], I[530] = I[531], I[531] = I[532], I[532] = I[533], I[533] = I[534], I[534] = I[535], I[535] = I[536], I[536] = I[537], I[537] = I[538], I[538] = I[539], I[539] = I[540], I[540] = I[541], I[541] = I[542], I[542] = I[543], I[543] = I[544], I[544] = I[545], \
 I[546] = I[547], I[547] = I[548], I[548] = I[549], I[549] = I[550], I[550] = I[551], I[551] = I[552], I[552] = I[553], I[553] = I[554], I[554] = I[555], I[555] = I[556], I[556] = I[557], I[557] = I[558], I[558] = I[559], I[559] = I[560], I[560] = I[561], I[561] = I[562], I[562] = I[563], I[563] = I[564], I[564] = I[565], I[565] = I[566], I[566] = I[567], I[567] = I[568], I[568] = I[569], I[569] = I[570], I[570] = I[571], \
 I[572] = I[573], I[573] = I[574], I[574] = I[575], I[575] = I[576], I[576] = I[577], I[577] = I[578], I[578] = I[579], I[579] = I[580], I[580] = I[581], I[581] = I[582], I[582] = I[583], I[583] = I[584], I[584] = I[585], I[585] = I[586], I[586] = I[587], I[587] = I[588], I[588] = I[589], I[589] = I[590], I[590] = I[591], I[591] = I[592], I[592] = I[593], I[593] = I[594], I[594] = I[595], I[595] = I[596], I[596] = I[597], \
 I[598] = I[599], I[599] = I[600], I[600] = I[601], I[601] = I[602], I[602] = I[603], I[603] = I[604], I[604] = I[605], I[605] = I[606], I[606] = I[607], I[607] = I[608], I[608] = I[609], I[609] = I[610], I[610] = I[611], I[611] = I[612], I[612] = I[613], I[613] = I[614], I[614] = I[615], I[615] = I[616], I[616] = I[617], I[617] = I[618], I[618] = I[619], I[619] = I[620], I[620] = I[621], I[621] = I[622], I[622] = I[623], \
 I[624] = I[625], I[625] = I[626], I[626] = I[627], I[627] = I[628], I[628] = I[629], I[629] = I[630], I[630] = I[631], I[631] = I[632], I[632] = I[633], I[633] = I[634], I[634] = I[635], I[635] = I[636], I[636] = I[637], I[637] = I[638], I[638] = I[639], I[639] = I[640], I[640] = I[641], I[641] = I[642], I[642] = I[643], I[643] = I[644], I[644] = I[645], I[645] = I[646], I[646] = I[647], I[647] = I[648], I[648] = I[649], \
 I[650] = I[651], I[651] = I[652], I[652] = I[653], I[653] = I[654], I[654] = I[655], I[655] = I[656], I[656] = I[657], I[657] = I[658], I[658] = I[659], I[659] = I[660], I[660] = I[661], I[661] = I[662], I[662] = I[663], I[663] = I[664], I[664] = I[665], I[665] = I[666], I[666] = I[667], I[667] = I[668], I[668] = I[669], I[669] = I[670], I[670] = I[671], I[671] = I[672], I[672] = I[673], I[673] = I[674], I[674] = I[675], \
 _p12##x = _p11##x, _p11##x = _p10##x, _p10##x = _p9##x, _p9##x = _p8##x, _p8##x = _p7##x, _p7##x = _p6##x, _p6##x = _p5##x, _p5##x = _p4##x, _p4##x = _p3##x, _p3##x = _p2##x, _p2##x = _p1##x, _p1##x = x++, ++_n1##x, ++_n2##x, ++_n3##x, ++_n4##x, ++_n5##x, ++_n6##x, ++_n7##x, ++_n8##x, ++_n9##x, ++_n10##x, ++_n11##x, ++_n12##x, ++_n13##x)

#define cimg_get26x26(img,x,y,z,c,I,T) \
 I[0] = (T)(img)(_p12##x,_p12##y,z,c), I[1] = (T)(img)(_p11##x,_p12##y,z,c), I[2] = (T)(img)(_p10##x,_p12##y,z,c), I[3] = (T)(img)(_p9##x,_p12##y,z,c), I[4] = (T)(img)(_p8##x,_p12##y,z,c), I[5] = (T)(img)(_p7##x,_p12##y,z,c), I[6] = (T)(img)(_p6##x,_p12##y,z,c), I[7] = (T)(img)(_p5##x,_p12##y,z,c), I[8] = (T)(img)(_p4##x,_p12##y,z,c), I[9] = (T)(img)(_p3##x,_p12##y,z,c), I[10] = (T)(img)(_p2##x,_p12##y,z,c), I[11] = (T)(img)(_p1##x,_p12##y,z,c), I[12] = (T)(img)(x,_p12##y,z,c), I[13] = (T)(img)(_n1##x,_p12##y,z,c), I[14] = (T)(img)(_n2##x,_p12##y,z,c), I[15] = (T)(img)(_n3##x,_p12##y,z,c), I[16] = (T)(img)(_n4##x,_p12##y,z,c), I[17] = (T)(img)(_n5##x,_p12##y,z,c), I[18] = (T)(img)(_n6##x,_p12##y,z,c), I[19] = (T)(img)(_n7##x,_p12##y,z,c), I[20] = (T)(img)(_n8##x,_p12##y,z,c), I[21] = (T)(img)(_n9##x,_p12##y,z,c), I[22] = (T)(img)(_n10##x,_p12##y,z,c), I[23] = (T)(img)(_n11##x,_p12##y,z,c), I[24] = (T)(img)(_n12##x,_p12##y,z,c), I[25] = (T)(img)(_n13##x,_p12##y,z,c), \
 I[26] = (T)(img)(_p12##x,_p11##y,z,c), I[27] = (T)(img)(_p11##x,_p11##y,z,c), I[28] = (T)(img)(_p10##x,_p11##y,z,c), I[29] = (T)(img)(_p9##x,_p11##y,z,c), I[30] = (T)(img)(_p8##x,_p11##y,z,c), I[31] = (T)(img)(_p7##x,_p11##y,z,c), I[32] = (T)(img)(_p6##x,_p11##y,z,c), I[33] = (T)(img)(_p5##x,_p11##y,z,c), I[34] = (T)(img)(_p4##x,_p11##y,z,c), I[35] = (T)(img)(_p3##x,_p11##y,z,c), I[36] = (T)(img)(_p2##x,_p11##y,z,c), I[37] = (T)(img)(_p1##x,_p11##y,z,c), I[38] = (T)(img)(x,_p11##y,z,c), I[39] = (T)(img)(_n1##x,_p11##y,z,c), I[40] = (T)(img)(_n2##x,_p11##y,z,c), I[41] = (T)(img)(_n3##x,_p11##y,z,c), I[42] = (T)(img)(_n4##x,_p11##y,z,c), I[43] = (T)(img)(_n5##x,_p11##y,z,c), I[44] = (T)(img)(_n6##x,_p11##y,z,c), I[45] = (T)(img)(_n7##x,_p11##y,z,c), I[46] = (T)(img)(_n8##x,_p11##y,z,c), I[47] = (T)(img)(_n9##x,_p11##y,z,c), I[48] = (T)(img)(_n10##x,_p11##y,z,c), I[49] = (T)(img)(_n11##x,_p11##y,z,c), I[50] = (T)(img)(_n12##x,_p11##y,z,c), I[51] = (T)(img)(_n13##x,_p11##y,z,c), \
 I[52] = (T)(img)(_p12##x,_p10##y,z,c), I[53] = (T)(img)(_p11##x,_p10##y,z,c), I[54] = (T)(img)(_p10##x,_p10##y,z,c), I[55] = (T)(img)(_p9##x,_p10##y,z,c), I[56] = (T)(img)(_p8##x,_p10##y,z,c), I[57] = (T)(img)(_p7##x,_p10##y,z,c), I[58] = (T)(img)(_p6##x,_p10##y,z,c), I[59] = (T)(img)(_p5##x,_p10##y,z,c), I[60] = (T)(img)(_p4##x,_p10##y,z,c), I[61] = (T)(img)(_p3##x,_p10##y,z,c), I[62] = (T)(img)(_p2##x,_p10##y,z,c), I[63] = (T)(img)(_p1##x,_p10##y,z,c), I[64] = (T)(img)(x,_p10##y,z,c), I[65] = (T)(img)(_n1##x,_p10##y,z,c), I[66] = (T)(img)(_n2##x,_p10##y,z,c), I[67] = (T)(img)(_n3##x,_p10##y,z,c), I[68] = (T)(img)(_n4##x,_p10##y,z,c), I[69] = (T)(img)(_n5##x,_p10##y,z,c), I[70] = (T)(img)(_n6##x,_p10##y,z,c), I[71] = (T)(img)(_n7##x,_p10##y,z,c), I[72] = (T)(img)(_n8##x,_p10##y,z,c), I[73] = (T)(img)(_n9##x,_p10##y,z,c), I[74] = (T)(img)(_n10##x,_p10##y,z,c), I[75] = (T)(img)(_n11##x,_p10##y,z,c), I[76] = (T)(img)(_n12##x,_p10##y,z,c), I[77] = (T)(img)(_n13##x,_p10##y,z,c), \
 I[78] = (T)(img)(_p12##x,_p9##y,z,c), I[79] = (T)(img)(_p11##x,_p9##y,z,c), I[80] = (T)(img)(_p10##x,_p9##y,z,c), I[81] = (T)(img)(_p9##x,_p9##y,z,c), I[82] = (T)(img)(_p8##x,_p9##y,z,c), I[83] = (T)(img)(_p7##x,_p9##y,z,c), I[84] = (T)(img)(_p6##x,_p9##y,z,c), I[85] = (T)(img)(_p5##x,_p9##y,z,c), I[86] = (T)(img)(_p4##x,_p9##y,z,c), I[87] = (T)(img)(_p3##x,_p9##y,z,c), I[88] = (T)(img)(_p2##x,_p9##y,z,c), I[89] = (T)(img)(_p1##x,_p9##y,z,c), I[90] = (T)(img)(x,_p9##y,z,c), I[91] = (T)(img)(_n1##x,_p9##y,z,c), I[92] = (T)(img)(_n2##x,_p9##y,z,c), I[93] = (T)(img)(_n3##x,_p9##y,z,c), I[94] = (T)(img)(_n4##x,_p9##y,z,c), I[95] = (T)(img)(_n5##x,_p9##y,z,c), I[96] = (T)(img)(_n6##x,_p9##y,z,c), I[97] = (T)(img)(_n7##x,_p9##y,z,c), I[98] = (T)(img)(_n8##x,_p9##y,z,c), I[99] = (T)(img)(_n9##x,_p9##y,z,c), I[100] = (T)(img)(_n10##x,_p9##y,z,c), I[101] = (T)(img)(_n11##x,_p9##y,z,c), I[102] = (T)(img)(_n12##x,_p9##y,z,c), I[103] = (T)(img)(_n13##x,_p9##y,z,c), \
 I[104] = (T)(img)(_p12##x,_p8##y,z,c), I[105] = (T)(img)(_p11##x,_p8##y,z,c), I[106] = (T)(img)(_p10##x,_p8##y,z,c), I[107] = (T)(img)(_p9##x,_p8##y,z,c), I[108] = (T)(img)(_p8##x,_p8##y,z,c), I[109] = (T)(img)(_p7##x,_p8##y,z,c), I[110] = (T)(img)(_p6##x,_p8##y,z,c), I[111] = (T)(img)(_p5##x,_p8##y,z,c), I[112] = (T)(img)(_p4##x,_p8##y,z,c), I[113] = (T)(img)(_p3##x,_p8##y,z,c), I[114] = (T)(img)(_p2##x,_p8##y,z,c), I[115] = (T)(img)(_p1##x,_p8##y,z,c), I[116] = (T)(img)(x,_p8##y,z,c), I[117] = (T)(img)(_n1##x,_p8##y,z,c), I[118] = (T)(img)(_n2##x,_p8##y,z,c), I[119] = (T)(img)(_n3##x,_p8##y,z,c), I[120] = (T)(img)(_n4##x,_p8##y,z,c), I[121] = (T)(img)(_n5##x,_p8##y,z,c), I[122] = (T)(img)(_n6##x,_p8##y,z,c), I[123] = (T)(img)(_n7##x,_p8##y,z,c), I[124] = (T)(img)(_n8##x,_p8##y,z,c), I[125] = (T)(img)(_n9##x,_p8##y,z,c), I[126] = (T)(img)(_n10##x,_p8##y,z,c), I[127] = (T)(img)(_n11##x,_p8##y,z,c), I[128] = (T)(img)(_n12##x,_p8##y,z,c), I[129] = (T)(img)(_n13##x,_p8##y,z,c), \
 I[130] = (T)(img)(_p12##x,_p7##y,z,c), I[131] = (T)(img)(_p11##x,_p7##y,z,c), I[132] = (T)(img)(_p10##x,_p7##y,z,c), I[133] = (T)(img)(_p9##x,_p7##y,z,c), I[134] = (T)(img)(_p8##x,_p7##y,z,c), I[135] = (T)(img)(_p7##x,_p7##y,z,c), I[136] = (T)(img)(_p6##x,_p7##y,z,c), I[137] = (T)(img)(_p5##x,_p7##y,z,c), I[138] = (T)(img)(_p4##x,_p7##y,z,c), I[139] = (T)(img)(_p3##x,_p7##y,z,c), I[140] = (T)(img)(_p2##x,_p7##y,z,c), I[141] = (T)(img)(_p1##x,_p7##y,z,c), I[142] = (T)(img)(x,_p7##y,z,c), I[143] = (T)(img)(_n1##x,_p7##y,z,c), I[144] = (T)(img)(_n2##x,_p7##y,z,c), I[145] = (T)(img)(_n3##x,_p7##y,z,c), I[146] = (T)(img)(_n4##x,_p7##y,z,c), I[147] = (T)(img)(_n5##x,_p7##y,z,c), I[148] = (T)(img)(_n6##x,_p7##y,z,c), I[149] = (T)(img)(_n7##x,_p7##y,z,c), I[150] = (T)(img)(_n8##x,_p7##y,z,c), I[151] = (T)(img)(_n9##x,_p7##y,z,c), I[152] = (T)(img)(_n10##x,_p7##y,z,c), I[153] = (T)(img)(_n11##x,_p7##y,z,c), I[154] = (T)(img)(_n12##x,_p7##y,z,c), I[155] = (T)(img)(_n13##x,_p7##y,z,c), \
 I[156] = (T)(img)(_p12##x,_p6##y,z,c), I[157] = (T)(img)(_p11##x,_p6##y,z,c), I[158] = (T)(img)(_p10##x,_p6##y,z,c), I[159] = (T)(img)(_p9##x,_p6##y,z,c), I[160] = (T)(img)(_p8##x,_p6##y,z,c), I[161] = (T)(img)(_p7##x,_p6##y,z,c), I[162] = (T)(img)(_p6##x,_p6##y,z,c), I[163] = (T)(img)(_p5##x,_p6##y,z,c), I[164] = (T)(img)(_p4##x,_p6##y,z,c), I[165] = (T)(img)(_p3##x,_p6##y,z,c), I[166] = (T)(img)(_p2##x,_p6##y,z,c), I[167] = (T)(img)(_p1##x,_p6##y,z,c), I[168] = (T)(img)(x,_p6##y,z,c), I[169] = (T)(img)(_n1##x,_p6##y,z,c), I[170] = (T)(img)(_n2##x,_p6##y,z,c), I[171] = (T)(img)(_n3##x,_p6##y,z,c), I[172] = (T)(img)(_n4##x,_p6##y,z,c), I[173] = (T)(img)(_n5##x,_p6##y,z,c), I[174] = (T)(img)(_n6##x,_p6##y,z,c), I[175] = (T)(img)(_n7##x,_p6##y,z,c), I[176] = (T)(img)(_n8##x,_p6##y,z,c), I[177] = (T)(img)(_n9##x,_p6##y,z,c), I[178] = (T)(img)(_n10##x,_p6##y,z,c), I[179] = (T)(img)(_n11##x,_p6##y,z,c), I[180] = (T)(img)(_n12##x,_p6##y,z,c), I[181] = (T)(img)(_n13##x,_p6##y,z,c), \
 I[182] = (T)(img)(_p12##x,_p5##y,z,c), I[183] = (T)(img)(_p11##x,_p5##y,z,c), I[184] = (T)(img)(_p10##x,_p5##y,z,c), I[185] = (T)(img)(_p9##x,_p5##y,z,c), I[186] = (T)(img)(_p8##x,_p5##y,z,c), I[187] = (T)(img)(_p7##x,_p5##y,z,c), I[188] = (T)(img)(_p6##x,_p5##y,z,c), I[189] = (T)(img)(_p5##x,_p5##y,z,c), I[190] = (T)(img)(_p4##x,_p5##y,z,c), I[191] = (T)(img)(_p3##x,_p5##y,z,c), I[192] = (T)(img)(_p2##x,_p5##y,z,c), I[193] = (T)(img)(_p1##x,_p5##y,z,c), I[194] = (T)(img)(x,_p5##y,z,c), I[195] = (T)(img)(_n1##x,_p5##y,z,c), I[196] = (T)(img)(_n2##x,_p5##y,z,c), I[197] = (T)(img)(_n3##x,_p5##y,z,c), I[198] = (T)(img)(_n4##x,_p5##y,z,c), I[199] = (T)(img)(_n5##x,_p5##y,z,c), I[200] = (T)(img)(_n6##x,_p5##y,z,c), I[201] = (T)(img)(_n7##x,_p5##y,z,c), I[202] = (T)(img)(_n8##x,_p5##y,z,c), I[203] = (T)(img)(_n9##x,_p5##y,z,c), I[204] = (T)(img)(_n10##x,_p5##y,z,c), I[205] = (T)(img)(_n11##x,_p5##y,z,c), I[206] = (T)(img)(_n12##x,_p5##y,z,c), I[207] = (T)(img)(_n13##x,_p5##y,z,c), \
 I[208] = (T)(img)(_p12##x,_p4##y,z,c), I[209] = (T)(img)(_p11##x,_p4##y,z,c), I[210] = (T)(img)(_p10##x,_p4##y,z,c), I[211] = (T)(img)(_p9##x,_p4##y,z,c), I[212] = (T)(img)(_p8##x,_p4##y,z,c), I[213] = (T)(img)(_p7##x,_p4##y,z,c), I[214] = (T)(img)(_p6##x,_p4##y,z,c), I[215] = (T)(img)(_p5##x,_p4##y,z,c), I[216] = (T)(img)(_p4##x,_p4##y,z,c), I[217] = (T)(img)(_p3##x,_p4##y,z,c), I[218] = (T)(img)(_p2##x,_p4##y,z,c), I[219] = (T)(img)(_p1##x,_p4##y,z,c), I[220] = (T)(img)(x,_p4##y,z,c), I[221] = (T)(img)(_n1##x,_p4##y,z,c), I[222] = (T)(img)(_n2##x,_p4##y,z,c), I[223] = (T)(img)(_n3##x,_p4##y,z,c), I[224] = (T)(img)(_n4##x,_p4##y,z,c), I[225] = (T)(img)(_n5##x,_p4##y,z,c), I[226] = (T)(img)(_n6##x,_p4##y,z,c), I[227] = (T)(img)(_n7##x,_p4##y,z,c), I[228] = (T)(img)(_n8##x,_p4##y,z,c), I[229] = (T)(img)(_n9##x,_p4##y,z,c), I[230] = (T)(img)(_n10##x,_p4##y,z,c), I[231] = (T)(img)(_n11##x,_p4##y,z,c), I[232] = (T)(img)(_n12##x,_p4##y,z,c), I[233] = (T)(img)(_n13##x,_p4##y,z,c), \
 I[234] = (T)(img)(_p12##x,_p3##y,z,c), I[235] = (T)(img)(_p11##x,_p3##y,z,c), I[236] = (T)(img)(_p10##x,_p3##y,z,c), I[237] = (T)(img)(_p9##x,_p3##y,z,c), I[238] = (T)(img)(_p8##x,_p3##y,z,c), I[239] = (T)(img)(_p7##x,_p3##y,z,c), I[240] = (T)(img)(_p6##x,_p3##y,z,c), I[241] = (T)(img)(_p5##x,_p3##y,z,c), I[242] = (T)(img)(_p4##x,_p3##y,z,c), I[243] = (T)(img)(_p3##x,_p3##y,z,c), I[244] = (T)(img)(_p2##x,_p3##y,z,c), I[245] = (T)(img)(_p1##x,_p3##y,z,c), I[246] = (T)(img)(x,_p3##y,z,c), I[247] = (T)(img)(_n1##x,_p3##y,z,c), I[248] = (T)(img)(_n2##x,_p3##y,z,c), I[249] = (T)(img)(_n3##x,_p3##y,z,c), I[250] = (T)(img)(_n4##x,_p3##y,z,c), I[251] = (T)(img)(_n5##x,_p3##y,z,c), I[252] = (T)(img)(_n6##x,_p3##y,z,c), I[253] = (T)(img)(_n7##x,_p3##y,z,c), I[254] = (T)(img)(_n8##x,_p3##y,z,c), I[255] = (T)(img)(_n9##x,_p3##y,z,c), I[256] = (T)(img)(_n10##x,_p3##y,z,c), I[257] = (T)(img)(_n11##x,_p3##y,z,c), I[258] = (T)(img)(_n12##x,_p3##y,z,c), I[259] = (T)(img)(_n13##x,_p3##y,z,c), \
 I[260] = (T)(img)(_p12##x,_p2##y,z,c), I[261] = (T)(img)(_p11##x,_p2##y,z,c), I[262] = (T)(img)(_p10##x,_p2##y,z,c), I[263] = (T)(img)(_p9##x,_p2##y,z,c), I[264] = (T)(img)(_p8##x,_p2##y,z,c), I[265] = (T)(img)(_p7##x,_p2##y,z,c), I[266] = (T)(img)(_p6##x,_p2##y,z,c), I[267] = (T)(img)(_p5##x,_p2##y,z,c), I[268] = (T)(img)(_p4##x,_p2##y,z,c), I[269] = (T)(img)(_p3##x,_p2##y,z,c), I[270] = (T)(img)(_p2##x,_p2##y,z,c), I[271] = (T)(img)(_p1##x,_p2##y,z,c), I[272] = (T)(img)(x,_p2##y,z,c), I[273] = (T)(img)(_n1##x,_p2##y,z,c), I[274] = (T)(img)(_n2##x,_p2##y,z,c), I[275] = (T)(img)(_n3##x,_p2##y,z,c), I[276] = (T)(img)(_n4##x,_p2##y,z,c), I[277] = (T)(img)(_n5##x,_p2##y,z,c), I[278] = (T)(img)(_n6##x,_p2##y,z,c), I[279] = (T)(img)(_n7##x,_p2##y,z,c), I[280] = (T)(img)(_n8##x,_p2##y,z,c), I[281] = (T)(img)(_n9##x,_p2##y,z,c), I[282] = (T)(img)(_n10##x,_p2##y,z,c), I[283] = (T)(img)(_n11##x,_p2##y,z,c), I[284] = (T)(img)(_n12##x,_p2##y,z,c), I[285] = (T)(img)(_n13##x,_p2##y,z,c), \
 I[286] = (T)(img)(_p12##x,_p1##y,z,c), I[287] = (T)(img)(_p11##x,_p1##y,z,c), I[288] = (T)(img)(_p10##x,_p1##y,z,c), I[289] = (T)(img)(_p9##x,_p1##y,z,c), I[290] = (T)(img)(_p8##x,_p1##y,z,c), I[291] = (T)(img)(_p7##x,_p1##y,z,c), I[292] = (T)(img)(_p6##x,_p1##y,z,c), I[293] = (T)(img)(_p5##x,_p1##y,z,c), I[294] = (T)(img)(_p4##x,_p1##y,z,c), I[295] = (T)(img)(_p3##x,_p1##y,z,c), I[296] = (T)(img)(_p2##x,_p1##y,z,c), I[297] = (T)(img)(_p1##x,_p1##y,z,c), I[298] = (T)(img)(x,_p1##y,z,c), I[299] = (T)(img)(_n1##x,_p1##y,z,c), I[300] = (T)(img)(_n2##x,_p1##y,z,c), I[301] = (T)(img)(_n3##x,_p1##y,z,c), I[302] = (T)(img)(_n4##x,_p1##y,z,c), I[303] = (T)(img)(_n5##x,_p1##y,z,c), I[304] = (T)(img)(_n6##x,_p1##y,z,c), I[305] = (T)(img)(_n7##x,_p1##y,z,c), I[306] = (T)(img)(_n8##x,_p1##y,z,c), I[307] = (T)(img)(_n9##x,_p1##y,z,c), I[308] = (T)(img)(_n10##x,_p1##y,z,c), I[309] = (T)(img)(_n11##x,_p1##y,z,c), I[310] = (T)(img)(_n12##x,_p1##y,z,c), I[311] = (T)(img)(_n13##x,_p1##y,z,c), \
 I[312] = (T)(img)(_p12##x,y,z,c), I[313] = (T)(img)(_p11##x,y,z,c), I[314] = (T)(img)(_p10##x,y,z,c), I[315] = (T)(img)(_p9##x,y,z,c), I[316] = (T)(img)(_p8##x,y,z,c), I[317] = (T)(img)(_p7##x,y,z,c), I[318] = (T)(img)(_p6##x,y,z,c), I[319] = (T)(img)(_p5##x,y,z,c), I[320] = (T)(img)(_p4##x,y,z,c), I[321] = (T)(img)(_p3##x,y,z,c), I[322] = (T)(img)(_p2##x,y,z,c), I[323] = (T)(img)(_p1##x,y,z,c), I[324] = (T)(img)(x,y,z,c), I[325] = (T)(img)(_n1##x,y,z,c), I[326] = (T)(img)(_n2##x,y,z,c), I[327] = (T)(img)(_n3##x,y,z,c), I[328] = (T)(img)(_n4##x,y,z,c), I[329] = (T)(img)(_n5##x,y,z,c), I[330] = (T)(img)(_n6##x,y,z,c), I[331] = (T)(img)(_n7##x,y,z,c), I[332] = (T)(img)(_n8##x,y,z,c), I[333] = (T)(img)(_n9##x,y,z,c), I[334] = (T)(img)(_n10##x,y,z,c), I[335] = (T)(img)(_n11##x,y,z,c), I[336] = (T)(img)(_n12##x,y,z,c), I[337] = (T)(img)(_n13##x,y,z,c), \
 I[338] = (T)(img)(_p12##x,_n1##y,z,c), I[339] = (T)(img)(_p11##x,_n1##y,z,c), I[340] = (T)(img)(_p10##x,_n1##y,z,c), I[341] = (T)(img)(_p9##x,_n1##y,z,c), I[342] = (T)(img)(_p8##x,_n1##y,z,c), I[343] = (T)(img)(_p7##x,_n1##y,z,c), I[344] = (T)(img)(_p6##x,_n1##y,z,c), I[345] = (T)(img)(_p5##x,_n1##y,z,c), I[346] = (T)(img)(_p4##x,_n1##y,z,c), I[347] = (T)(img)(_p3##x,_n1##y,z,c), I[348] = (T)(img)(_p2##x,_n1##y,z,c), I[349] = (T)(img)(_p1##x,_n1##y,z,c), I[350] = (T)(img)(x,_n1##y,z,c), I[351] = (T)(img)(_n1##x,_n1##y,z,c), I[352] = (T)(img)(_n2##x,_n1##y,z,c), I[353] = (T)(img)(_n3##x,_n1##y,z,c), I[354] = (T)(img)(_n4##x,_n1##y,z,c), I[355] = (T)(img)(_n5##x,_n1##y,z,c), I[356] = (T)(img)(_n6##x,_n1##y,z,c), I[357] = (T)(img)(_n7##x,_n1##y,z,c), I[358] = (T)(img)(_n8##x,_n1##y,z,c), I[359] = (T)(img)(_n9##x,_n1##y,z,c), I[360] = (T)(img)(_n10##x,_n1##y,z,c), I[361] = (T)(img)(_n11##x,_n1##y,z,c), I[362] = (T)(img)(_n12##x,_n1##y,z,c), I[363] = (T)(img)(_n13##x,_n1##y,z,c), \
 I[364] = (T)(img)(_p12##x,_n2##y,z,c), I[365] = (T)(img)(_p11##x,_n2##y,z,c), I[366] = (T)(img)(_p10##x,_n2##y,z,c), I[367] = (T)(img)(_p9##x,_n2##y,z,c), I[368] = (T)(img)(_p8##x,_n2##y,z,c), I[369] = (T)(img)(_p7##x,_n2##y,z,c), I[370] = (T)(img)(_p6##x,_n2##y,z,c), I[371] = (T)(img)(_p5##x,_n2##y,z,c), I[372] = (T)(img)(_p4##x,_n2##y,z,c), I[373] = (T)(img)(_p3##x,_n2##y,z,c), I[374] = (T)(img)(_p2##x,_n2##y,z,c), I[375] = (T)(img)(_p1##x,_n2##y,z,c), I[376] = (T)(img)(x,_n2##y,z,c), I[377] = (T)(img)(_n1##x,_n2##y,z,c), I[378] = (T)(img)(_n2##x,_n2##y,z,c), I[379] = (T)(img)(_n3##x,_n2##y,z,c), I[380] = (T)(img)(_n4##x,_n2##y,z,c), I[381] = (T)(img)(_n5##x,_n2##y,z,c), I[382] = (T)(img)(_n6##x,_n2##y,z,c), I[383] = (T)(img)(_n7##x,_n2##y,z,c), I[384] = (T)(img)(_n8##x,_n2##y,z,c), I[385] = (T)(img)(_n9##x,_n2##y,z,c), I[386] = (T)(img)(_n10##x,_n2##y,z,c), I[387] = (T)(img)(_n11##x,_n2##y,z,c), I[388] = (T)(img)(_n12##x,_n2##y,z,c), I[389] = (T)(img)(_n13##x,_n2##y,z,c), \
 I[390] = (T)(img)(_p12##x,_n3##y,z,c), I[391] = (T)(img)(_p11##x,_n3##y,z,c), I[392] = (T)(img)(_p10##x,_n3##y,z,c), I[393] = (T)(img)(_p9##x,_n3##y,z,c), I[394] = (T)(img)(_p8##x,_n3##y,z,c), I[395] = (T)(img)(_p7##x,_n3##y,z,c), I[396] = (T)(img)(_p6##x,_n3##y,z,c), I[397] = (T)(img)(_p5##x,_n3##y,z,c), I[398] = (T)(img)(_p4##x,_n3##y,z,c), I[399] = (T)(img)(_p3##x,_n3##y,z,c), I[400] = (T)(img)(_p2##x,_n3##y,z,c), I[401] = (T)(img)(_p1##x,_n3##y,z,c), I[402] = (T)(img)(x,_n3##y,z,c), I[403] = (T)(img)(_n1##x,_n3##y,z,c), I[404] = (T)(img)(_n2##x,_n3##y,z,c), I[405] = (T)(img)(_n3##x,_n3##y,z,c), I[406] = (T)(img)(_n4##x,_n3##y,z,c), I[407] = (T)(img)(_n5##x,_n3##y,z,c), I[408] = (T)(img)(_n6##x,_n3##y,z,c), I[409] = (T)(img)(_n7##x,_n3##y,z,c), I[410] = (T)(img)(_n8##x,_n3##y,z,c), I[411] = (T)(img)(_n9##x,_n3##y,z,c), I[412] = (T)(img)(_n10##x,_n3##y,z,c), I[413] = (T)(img)(_n11##x,_n3##y,z,c), I[414] = (T)(img)(_n12##x,_n3##y,z,c), I[415] = (T)(img)(_n13##x,_n3##y,z,c), \
 I[416] = (T)(img)(_p12##x,_n4##y,z,c), I[417] = (T)(img)(_p11##x,_n4##y,z,c), I[418] = (T)(img)(_p10##x,_n4##y,z,c), I[419] = (T)(img)(_p9##x,_n4##y,z,c), I[420] = (T)(img)(_p8##x,_n4##y,z,c), I[421] = (T)(img)(_p7##x,_n4##y,z,c), I[422] = (T)(img)(_p6##x,_n4##y,z,c), I[423] = (T)(img)(_p5##x,_n4##y,z,c), I[424] = (T)(img)(_p4##x,_n4##y,z,c), I[425] = (T)(img)(_p3##x,_n4##y,z,c), I[426] = (T)(img)(_p2##x,_n4##y,z,c), I[427] = (T)(img)(_p1##x,_n4##y,z,c), I[428] = (T)(img)(x,_n4##y,z,c), I[429] = (T)(img)(_n1##x,_n4##y,z,c), I[430] = (T)(img)(_n2##x,_n4##y,z,c), I[431] = (T)(img)(_n3##x,_n4##y,z,c), I[432] = (T)(img)(_n4##x,_n4##y,z,c), I[433] = (T)(img)(_n5##x,_n4##y,z,c), I[434] = (T)(img)(_n6##x,_n4##y,z,c), I[435] = (T)(img)(_n7##x,_n4##y,z,c), I[436] = (T)(img)(_n8##x,_n4##y,z,c), I[437] = (T)(img)(_n9##x,_n4##y,z,c), I[438] = (T)(img)(_n10##x,_n4##y,z,c), I[439] = (T)(img)(_n11##x,_n4##y,z,c), I[440] = (T)(img)(_n12##x,_n4##y,z,c), I[441] = (T)(img)(_n13##x,_n4##y,z,c), \
 I[442] = (T)(img)(_p12##x,_n5##y,z,c), I[443] = (T)(img)(_p11##x,_n5##y,z,c), I[444] = (T)(img)(_p10##x,_n5##y,z,c), I[445] = (T)(img)(_p9##x,_n5##y,z,c), I[446] = (T)(img)(_p8##x,_n5##y,z,c), I[447] = (T)(img)(_p7##x,_n5##y,z,c), I[448] = (T)(img)(_p6##x,_n5##y,z,c), I[449] = (T)(img)(_p5##x,_n5##y,z,c), I[450] = (T)(img)(_p4##x,_n5##y,z,c), I[451] = (T)(img)(_p3##x,_n5##y,z,c), I[452] = (T)(img)(_p2##x,_n5##y,z,c), I[453] = (T)(img)(_p1##x,_n5##y,z,c), I[454] = (T)(img)(x,_n5##y,z,c), I[455] = (T)(img)(_n1##x,_n5##y,z,c), I[456] = (T)(img)(_n2##x,_n5##y,z,c), I[457] = (T)(img)(_n3##x,_n5##y,z,c), I[458] = (T)(img)(_n4##x,_n5##y,z,c), I[459] = (T)(img)(_n5##x,_n5##y,z,c), I[460] = (T)(img)(_n6##x,_n5##y,z,c), I[461] = (T)(img)(_n7##x,_n5##y,z,c), I[462] = (T)(img)(_n8##x,_n5##y,z,c), I[463] = (T)(img)(_n9##x,_n5##y,z,c), I[464] = (T)(img)(_n10##x,_n5##y,z,c), I[465] = (T)(img)(_n11##x,_n5##y,z,c), I[466] = (T)(img)(_n12##x,_n5##y,z,c), I[467] = (T)(img)(_n13##x,_n5##y,z,c), \
 I[468] = (T)(img)(_p12##x,_n6##y,z,c), I[469] = (T)(img)(_p11##x,_n6##y,z,c), I[470] = (T)(img)(_p10##x,_n6##y,z,c), I[471] = (T)(img)(_p9##x,_n6##y,z,c), I[472] = (T)(img)(_p8##x,_n6##y,z,c), I[473] = (T)(img)(_p7##x,_n6##y,z,c), I[474] = (T)(img)(_p6##x,_n6##y,z,c), I[475] = (T)(img)(_p5##x,_n6##y,z,c), I[476] = (T)(img)(_p4##x,_n6##y,z,c), I[477] = (T)(img)(_p3##x,_n6##y,z,c), I[478] = (T)(img)(_p2##x,_n6##y,z,c), I[479] = (T)(img)(_p1##x,_n6##y,z,c), I[480] = (T)(img)(x,_n6##y,z,c), I[481] = (T)(img)(_n1##x,_n6##y,z,c), I[482] = (T)(img)(_n2##x,_n6##y,z,c), I[483] = (T)(img)(_n3##x,_n6##y,z,c), I[484] = (T)(img)(_n4##x,_n6##y,z,c), I[485] = (T)(img)(_n5##x,_n6##y,z,c), I[486] = (T)(img)(_n6##x,_n6##y,z,c), I[487] = (T)(img)(_n7##x,_n6##y,z,c), I[488] = (T)(img)(_n8##x,_n6##y,z,c), I[489] = (T)(img)(_n9##x,_n6##y,z,c), I[490] = (T)(img)(_n10##x,_n6##y,z,c), I[491] = (T)(img)(_n11##x,_n6##y,z,c), I[492] = (T)(img)(_n12##x,_n6##y,z,c), I[493] = (T)(img)(_n13##x,_n6##y,z,c), \
 I[494] = (T)(img)(_p12##x,_n7##y,z,c), I[495] = (T)(img)(_p11##x,_n7##y,z,c), I[496] = (T)(img)(_p10##x,_n7##y,z,c), I[497] = (T)(img)(_p9##x,_n7##y,z,c), I[498] = (T)(img)(_p8##x,_n7##y,z,c), I[499] = (T)(img)(_p7##x,_n7##y,z,c), I[500] = (T)(img)(_p6##x,_n7##y,z,c), I[501] = (T)(img)(_p5##x,_n7##y,z,c), I[502] = (T)(img)(_p4##x,_n7##y,z,c), I[503] = (T)(img)(_p3##x,_n7##y,z,c), I[504] = (T)(img)(_p2##x,_n7##y,z,c), I[505] = (T)(img)(_p1##x,_n7##y,z,c), I[506] = (T)(img)(x,_n7##y,z,c), I[507] = (T)(img)(_n1##x,_n7##y,z,c), I[508] = (T)(img)(_n2##x,_n7##y,z,c), I[509] = (T)(img)(_n3##x,_n7##y,z,c), I[510] = (T)(img)(_n4##x,_n7##y,z,c), I[511] = (T)(img)(_n5##x,_n7##y,z,c), I[512] = (T)(img)(_n6##x,_n7##y,z,c), I[513] = (T)(img)(_n7##x,_n7##y,z,c), I[514] = (T)(img)(_n8##x,_n7##y,z,c), I[515] = (T)(img)(_n9##x,_n7##y,z,c), I[516] = (T)(img)(_n10##x,_n7##y,z,c), I[517] = (T)(img)(_n11##x,_n7##y,z,c), I[518] = (T)(img)(_n12##x,_n7##y,z,c), I[519] = (T)(img)(_n13##x,_n7##y,z,c), \
 I[520] = (T)(img)(_p12##x,_n8##y,z,c), I[521] = (T)(img)(_p11##x,_n8##y,z,c), I[522] = (T)(img)(_p10##x,_n8##y,z,c), I[523] = (T)(img)(_p9##x,_n8##y,z,c), I[524] = (T)(img)(_p8##x,_n8##y,z,c), I[525] = (T)(img)(_p7##x,_n8##y,z,c), I[526] = (T)(img)(_p6##x,_n8##y,z,c), I[527] = (T)(img)(_p5##x,_n8##y,z,c), I[528] = (T)(img)(_p4##x,_n8##y,z,c), I[529] = (T)(img)(_p3##x,_n8##y,z,c), I[530] = (T)(img)(_p2##x,_n8##y,z,c), I[531] = (T)(img)(_p1##x,_n8##y,z,c), I[532] = (T)(img)(x,_n8##y,z,c), I[533] = (T)(img)(_n1##x,_n8##y,z,c), I[534] = (T)(img)(_n2##x,_n8##y,z,c), I[535] = (T)(img)(_n3##x,_n8##y,z,c), I[536] = (T)(img)(_n4##x,_n8##y,z,c), I[537] = (T)(img)(_n5##x,_n8##y,z,c), I[538] = (T)(img)(_n6##x,_n8##y,z,c), I[539] = (T)(img)(_n7##x,_n8##y,z,c), I[540] = (T)(img)(_n8##x,_n8##y,z,c), I[541] = (T)(img)(_n9##x,_n8##y,z,c), I[542] = (T)(img)(_n10##x,_n8##y,z,c), I[543] = (T)(img)(_n11##x,_n8##y,z,c), I[544] = (T)(img)(_n12##x,_n8##y,z,c), I[545] = (T)(img)(_n13##x,_n8##y,z,c), \
 I[546] = (T)(img)(_p12##x,_n9##y,z,c), I[547] = (T)(img)(_p11##x,_n9##y,z,c), I[548] = (T)(img)(_p10##x,_n9##y,z,c), I[549] = (T)(img)(_p9##x,_n9##y,z,c), I[550] = (T)(img)(_p8##x,_n9##y,z,c), I[551] = (T)(img)(_p7##x,_n9##y,z,c), I[552] = (T)(img)(_p6##x,_n9##y,z,c), I[553] = (T)(img)(_p5##x,_n9##y,z,c), I[554] = (T)(img)(_p4##x,_n9##y,z,c), I[555] = (T)(img)(_p3##x,_n9##y,z,c), I[556] = (T)(img)(_p2##x,_n9##y,z,c), I[557] = (T)(img)(_p1##x,_n9##y,z,c), I[558] = (T)(img)(x,_n9##y,z,c), I[559] = (T)(img)(_n1##x,_n9##y,z,c), I[560] = (T)(img)(_n2##x,_n9##y,z,c), I[561] = (T)(img)(_n3##x,_n9##y,z,c), I[562] = (T)(img)(_n4##x,_n9##y,z,c), I[563] = (T)(img)(_n5##x,_n9##y,z,c), I[564] = (T)(img)(_n6##x,_n9##y,z,c), I[565] = (T)(img)(_n7##x,_n9##y,z,c), I[566] = (T)(img)(_n8##x,_n9##y,z,c), I[567] = (T)(img)(_n9##x,_n9##y,z,c), I[568] = (T)(img)(_n10##x,_n9##y,z,c), I[569] = (T)(img)(_n11##x,_n9##y,z,c), I[570] = (T)(img)(_n12##x,_n9##y,z,c), I[571] = (T)(img)(_n13##x,_n9##y,z,c), \
 I[572] = (T)(img)(_p12##x,_n10##y,z,c), I[573] = (T)(img)(_p11##x,_n10##y,z,c), I[574] = (T)(img)(_p10##x,_n10##y,z,c), I[575] = (T)(img)(_p9##x,_n10##y,z,c), I[576] = (T)(img)(_p8##x,_n10##y,z,c), I[577] = (T)(img)(_p7##x,_n10##y,z,c), I[578] = (T)(img)(_p6##x,_n10##y,z,c), I[579] = (T)(img)(_p5##x,_n10##y,z,c), I[580] = (T)(img)(_p4##x,_n10##y,z,c), I[581] = (T)(img)(_p3##x,_n10##y,z,c), I[582] = (T)(img)(_p2##x,_n10##y,z,c), I[583] = (T)(img)(_p1##x,_n10##y,z,c), I[584] = (T)(img)(x,_n10##y,z,c), I[585] = (T)(img)(_n1##x,_n10##y,z,c), I[586] = (T)(img)(_n2##x,_n10##y,z,c), I[587] = (T)(img)(_n3##x,_n10##y,z,c), I[588] = (T)(img)(_n4##x,_n10##y,z,c), I[589] = (T)(img)(_n5##x,_n10##y,z,c), I[590] = (T)(img)(_n6##x,_n10##y,z,c), I[591] = (T)(img)(_n7##x,_n10##y,z,c), I[592] = (T)(img)(_n8##x,_n10##y,z,c), I[593] = (T)(img)(_n9##x,_n10##y,z,c), I[594] = (T)(img)(_n10##x,_n10##y,z,c), I[595] = (T)(img)(_n11##x,_n10##y,z,c), I[596] = (T)(img)(_n12##x,_n10##y,z,c), I[597] = (T)(img)(_n13##x,_n10##y,z,c), \
 I[598] = (T)(img)(_p12##x,_n11##y,z,c), I[599] = (T)(img)(_p11##x,_n11##y,z,c), I[600] = (T)(img)(_p10##x,_n11##y,z,c), I[601] = (T)(img)(_p9##x,_n11##y,z,c), I[602] = (T)(img)(_p8##x,_n11##y,z,c), I[603] = (T)(img)(_p7##x,_n11##y,z,c), I[604] = (T)(img)(_p6##x,_n11##y,z,c), I[605] = (T)(img)(_p5##x,_n11##y,z,c), I[606] = (T)(img)(_p4##x,_n11##y,z,c), I[607] = (T)(img)(_p3##x,_n11##y,z,c), I[608] = (T)(img)(_p2##x,_n11##y,z,c), I[609] = (T)(img)(_p1##x,_n11##y,z,c), I[610] = (T)(img)(x,_n11##y,z,c), I[611] = (T)(img)(_n1##x,_n11##y,z,c), I[612] = (T)(img)(_n2##x,_n11##y,z,c), I[613] = (T)(img)(_n3##x,_n11##y,z,c), I[614] = (T)(img)(_n4##x,_n11##y,z,c), I[615] = (T)(img)(_n5##x,_n11##y,z,c), I[616] = (T)(img)(_n6##x,_n11##y,z,c), I[617] = (T)(img)(_n7##x,_n11##y,z,c), I[618] = (T)(img)(_n8##x,_n11##y,z,c), I[619] = (T)(img)(_n9##x,_n11##y,z,c), I[620] = (T)(img)(_n10##x,_n11##y,z,c), I[621] = (T)(img)(_n11##x,_n11##y,z,c), I[622] = (T)(img)(_n12##x,_n11##y,z,c), I[623] = (T)(img)(_n13##x,_n11##y,z,c), \
 I[624] = (T)(img)(_p12##x,_n12##y,z,c), I[625] = (T)(img)(_p11##x,_n12##y,z,c), I[626] = (T)(img)(_p10##x,_n12##y,z,c), I[627] = (T)(img)(_p9##x,_n12##y,z,c), I[628] = (T)(img)(_p8##x,_n12##y,z,c), I[629] = (T)(img)(_p7##x,_n12##y,z,c), I[630] = (T)(img)(_p6##x,_n12##y,z,c), I[631] = (T)(img)(_p5##x,_n12##y,z,c), I[632] = (T)(img)(_p4##x,_n12##y,z,c), I[633] = (T)(img)(_p3##x,_n12##y,z,c), I[634] = (T)(img)(_p2##x,_n12##y,z,c), I[635] = (T)(img)(_p1##x,_n12##y,z,c), I[636] = (T)(img)(x,_n12##y,z,c), I[637] = (T)(img)(_n1##x,_n12##y,z,c), I[638] = (T)(img)(_n2##x,_n12##y,z,c), I[639] = (T)(img)(_n3##x,_n12##y,z,c), I[640] = (T)(img)(_n4##x,_n12##y,z,c), I[641] = (T)(img)(_n5##x,_n12##y,z,c), I[642] = (T)(img)(_n6##x,_n12##y,z,c), I[643] = (T)(img)(_n7##x,_n12##y,z,c), I[644] = (T)(img)(_n8##x,_n12##y,z,c), I[645] = (T)(img)(_n9##x,_n12##y,z,c), I[646] = (T)(img)(_n10##x,_n12##y,z,c), I[647] = (T)(img)(_n11##x,_n12##y,z,c), I[648] = (T)(img)(_n12##x,_n12##y,z,c), I[649] = (T)(img)(_n13##x,_n12##y,z,c), \
 I[650] = (T)(img)(_p12##x,_n13##y,z,c), I[651] = (T)(img)(_p11##x,_n13##y,z,c), I[652] = (T)(img)(_p10##x,_n13##y,z,c), I[653] = (T)(img)(_p9##x,_n13##y,z,c), I[654] = (T)(img)(_p8##x,_n13##y,z,c), I[655] = (T)(img)(_p7##x,_n13##y,z,c), I[656] = (T)(img)(_p6##x,_n13##y,z,c), I[657] = (T)(img)(_p5##x,_n13##y,z,c), I[658] = (T)(img)(_p4##x,_n13##y,z,c), I[659] = (T)(img)(_p3##x,_n13##y,z,c), I[660] = (T)(img)(_p2##x,_n13##y,z,c), I[661] = (T)(img)(_p1##x,_n13##y,z,c), I[662] = (T)(img)(x,_n13##y,z,c), I[663] = (T)(img)(_n1##x,_n13##y,z,c), I[664] = (T)(img)(_n2##x,_n13##y,z,c), I[665] = (T)(img)(_n3##x,_n13##y,z,c), I[666] = (T)(img)(_n4##x,_n13##y,z,c), I[667] = (T)(img)(_n5##x,_n13##y,z,c), I[668] = (T)(img)(_n6##x,_n13##y,z,c), I[669] = (T)(img)(_n7##x,_n13##y,z,c), I[670] = (T)(img)(_n8##x,_n13##y,z,c), I[671] = (T)(img)(_n9##x,_n13##y,z,c), I[672] = (T)(img)(_n10##x,_n13##y,z,c), I[673] = (T)(img)(_n11##x,_n13##y,z,c), I[674] = (T)(img)(_n12##x,_n13##y,z,c), I[675] = (T)(img)(_n13##x,_n13##y,z,c);

// Define 27x27 loop macros
//-------------------------
#define cimg_for27(bound,i) for (int i = 0, \
 _p13##i = 0, _p12##i = 0, _p11##i = 0, _p10##i = 0, _p9##i = 0, _p8##i = 0, _p7##i = 0, _p6##i = 0, _p5##i = 0, _p4##i = 0, _p3##i = 0, _p2##i = 0, _p1##i = 0, \
 _n1##i = 1>=(int)(bound)?(int)(bound)-1:1, \
 _n2##i = 2>=(int)(bound)?(int)(bound)-1:2, \
 _n3##i = 3>=(int)(bound)?(int)(bound)-1:3, \
 _n4##i = 4>=(int)(bound)?(int)(bound)-1:4, \
 _n5##i = 5>=(int)(bound)?(int)(bound)-1:5, \
 _n6##i = 6>=(int)(bound)?(int)(bound)-1:6, \
 _n7##i = 7>=(int)(bound)?(int)(bound)-1:7, \
 _n8##i = 8>=(int)(bound)?(int)(bound)-1:8, \
 _n9##i = 9>=(int)(bound)?(int)(bound)-1:9, \
 _n10##i = 10>=(int)(bound)?(int)(bound)-1:10, \
 _n11##i = 11>=(int)(bound)?(int)(bound)-1:11, \
 _n12##i = 12>=(int)(bound)?(int)(bound)-1:12, \
 _n13##i = 13>=(int)(bound)?(int)(bound)-1:13; \
 _n13##i<(int)(bound) || _n12##i==--_n13##i || _n11##i==--_n12##i || _n10##i==--_n11##i || _n9##i==--_n10##i || _n8##i==--_n9##i || _n7##i==--_n8##i || _n6##i==--_n7##i || _n5##i==--_n6##i || _n4##i==--_n5##i || _n3##i==--_n4##i || _n2##i==--_n3##i || _n1##i==--_n2##i || \
 i==(_n13##i = _n12##i = _n11##i = _n10##i = _n9##i = _n8##i = _n7##i = _n6##i = _n5##i = _n4##i = _n3##i = _n2##i = --_n1##i); \
 _p13##i = _p12##i, _p12##i = _p11##i, _p11##i = _p10##i, _p10##i = _p9##i, _p9##i = _p8##i, _p8##i = _p7##i, _p7##i = _p6##i, _p6##i = _p5##i, _p5##i = _p4##i, _p4##i = _p3##i, _p3##i = _p2##i, _p2##i = _p1##i, _p1##i = i++, \
 ++_n1##i, ++_n2##i, ++_n3##i, ++_n4##i, ++_n5##i, ++_n6##i, ++_n7##i, ++_n8##i, ++_n9##i, ++_n10##i, ++_n11##i, ++_n12##i, ++_n13##i)

#define cimg_for27X(img,x) cimg_for27((img)._width,x)
#define cimg_for27Y(img,y) cimg_for27((img)._height,y)
#define cimg_for27Z(img,z) cimg_for27((img)._depth,z)
#define cimg_for27C(img,c) cimg_for27((img)._spectrum,c)
#define cimg_for27XY(img,x,y) cimg_for27Y(img,y) cimg_for27X(img,x)
#define cimg_for27XZ(img,x,z) cimg_for27Z(img,z) cimg_for27X(img,x)
#define cimg_for27XC(img,x,c) cimg_for27C(img,c) cimg_for27X(img,x)
#define cimg_for27YZ(img,y,z) cimg_for27Z(img,z) cimg_for27Y(img,y)
#define cimg_for27YC(img,y,c) cimg_for27C(img,c) cimg_for27Y(img,y)
#define cimg_for27ZC(img,z,c) cimg_for27C(img,c) cimg_for27Z(img,z)
#define cimg_for27XYZ(img,x,y,z) cimg_for27Z(img,z) cimg_for27XY(img,x,y)
#define cimg_for27XZC(img,x,z,c) cimg_for27C(img,c) cimg_for27XZ(img,x,z)
#define cimg_for27YZC(img,y,z,c) cimg_for27C(img,c) cimg_for27YZ(img,y,z)
#define cimg_for27XYZC(img,x,y,z,c) cimg_for27C(img,c) cimg_for27XYZ(img,x,y,z)

#define cimg_for_in27(bound,i0,i1,i) for (int i = (int)(i0)<0?0:(int)(i0), \
 _p13##i = i-13<0?0:i-13, \
 _p12##i = i-12<0?0:i-12, \
 _p11##i = i-11<0?0:i-11, \
 _p10##i = i-10<0?0:i-10, \
 _p9##i = i-9<0?0:i-9, \
 _p8##i = i-8<0?0:i-8, \
 _p7##i = i-7<0?0:i-7, \
 _p6##i = i-6<0?0:i-6, \
 _p5##i = i-5<0?0:i-5, \
 _p4##i = i-4<0?0:i-4, \
 _p3##i = i-3<0?0:i-3, \
 _p2##i = i-2<0?0:i-2, \
 _p1##i = i-1<0?0:i-1, \
 _n1##i = i+1>=(int)(bound)?(int)(bound)-1:i+1, \
 _n2##i = i+2>=(int)(bound)?(int)(bound)-1:i+2, \
 _n3##i = i+3>=(int)(bound)?(int)(bound)-1:i+3, \
 _n4##i = i+4>=(int)(bound)?(int)(bound)-1:i+4, \
 _n5##i = i+5>=(int)(bound)?(int)(bound)-1:i+5, \
 _n6##i = i+6>=(int)(bound)?(int)(bound)-1:i+6, \
 _n7##i = i+7>=(int)(bound)?(int)(bound)-1:i+7, \
 _n8##i = i+8>=(int)(bound)?(int)(bound)-1:i+8, \
 _n9##i = i+9>=(int)(bound)?(int)(bound)-1:i+9, \
 _n10##i = i+10>=(int)(bound)?(int)(bound)-1:i+10, \
 _n11##i = i+11>=(int)(bound)?(int)(bound)-1:i+11, \
 _n12##i = i+12>=(int)(bound)?(int)(bound)-1:i+12, \
 _n13##i = i+13>=(int)(bound)?(int)(bound)-1:i+13; \
 i<=(int)(i1) && (_n13##i<(int)(bound) || _n12##i==--_n13##i || _n11##i==--_n12##i || _n10##i==--_n11##i || _n9##i==--_n10##i || _n8##i==--_n9##i || _n7##i==--_n8##i || _n6##i==--_n7##i || _n5##i==--_n6##i || _n4##i==--_n5##i || _n3##i==--_n4##i || _n2##i==--_n3##i || _n1##i==--_n2##i || \
 i==(_n13##i = _n12##i = _n11##i = _n10##i = _n9##i = _n8##i = _n7##i = _n6##i = _n5##i = _n4##i = _n3##i = _n2##i = --_n1##i)); \
 _p13##i = _p12##i, _p12##i = _p11##i, _p11##i = _p10##i, _p10##i = _p9##i, _p9##i = _p8##i, _p8##i = _p7##i, _p7##i = _p6##i, _p6##i = _p5##i, _p5##i = _p4##i, _p4##i = _p3##i, _p3##i = _p2##i, _p2##i = _p1##i, _p1##i = i++, \
 ++_n1##i, ++_n2##i, ++_n3##i, ++_n4##i, ++_n5##i, ++_n6##i, ++_n7##i, ++_n8##i, ++_n9##i, ++_n10##i, ++_n11##i, ++_n12##i, ++_n13##i)

#define cimg_for_in27X(img,x0,x1,x) cimg_for_in27((img)._width,x0,x1,x)
#define cimg_for_in27Y(img,y0,y1,y) cimg_for_in27((img)._height,y0,y1,y)
#define cimg_for_in27Z(img,z0,z1,z) cimg_for_in27((img)._depth,z0,z1,z)
#define cimg_for_in27C(img,c0,c1,c) cimg_for_in27((img)._spectrum,c0,c1,c)
#define cimg_for_in27XY(img,x0,y0,x1,y1,x,y) cimg_for_in27Y(img,y0,y1,y) cimg_for_in27X(img,x0,x1,x)
#define cimg_for_in27XZ(img,x0,z0,x1,z1,x,z) cimg_for_in27Z(img,z0,z1,z) cimg_for_in27X(img,x0,x1,x)
#define cimg_for_in27XC(img,x0,c0,x1,c1,x,c) cimg_for_in27C(img,c0,c1,c) cimg_for_in27X(img,x0,x1,x)
#define cimg_for_in27YZ(img,y0,z0,y1,z1,y,z) cimg_for_in27Z(img,z0,z1,z) cimg_for_in27Y(img,y0,y1,y)
#define cimg_for_in27YC(img,y0,c0,y1,c1,y,c) cimg_for_in27C(img,c0,c1,c) cimg_for_in27Y(img,y0,y1,y)
#define cimg_for_in27ZC(img,z0,c0,z1,c1,z,c) cimg_for_in27C(img,c0,c1,c) cimg_for_in27Z(img,z0,z1,z)
#define cimg_for_in27XYZ(img,x0,y0,z0,x1,y1,z1,x,y,z) cimg_for_in27Z(img,z0,z1,z) cimg_for_in27XY(img,x0,y0,x1,y1,x,y)
#define cimg_for_in27XZC(img,x0,z0,c0,x1,y1,c1,x,z,c) cimg_for_in27C(img,c0,c1,c) cimg_for_in27XZ(img,x0,y0,x1,y1,x,z)
#define cimg_for_in27YZC(img,y0,z0,c0,y1,z1,c1,y,z,c) cimg_for_in27C(img,c0,c1,c) cimg_for_in27YZ(img,y0,z0,y1,z1,y,z)
#define cimg_for_in27XYZC(img,x0,y0,z0,c0,x1,y1,z1,c1,x,y,z,c) cimg_for_in27C(img,c0,c1,c) cimg_for_in27XYZ(img,x0,y0,z0,x1,y1,z1,x,y,z)

#define cimg_for27x27(img,x,y,z,c,I,T) \
 cimg_for27((img)._height,y) for (int x = 0, \
 _p13##x = 0, _p12##x = 0, _p11##x = 0, _p10##x = 0, _p9##x = 0, _p8##x = 0, _p7##x = 0, _p6##x = 0, _p5##x = 0, _p4##x = 0, _p3##x = 0, _p2##x = 0, _p1##x = 0, \
 _n1##x = 1>=((img)._width)?(img).width()-1:1, \
 _n2##x = 2>=((img)._width)?(img).width()-1:2, \
 _n3##x = 3>=((img)._width)?(img).width()-1:3, \
 _n4##x = 4>=((img)._width)?(img).width()-1:4, \
 _n5##x = 5>=((img)._width)?(img).width()-1:5, \
 _n6##x = 6>=((img)._width)?(img).width()-1:6, \
 _n7##x = 7>=((img)._width)?(img).width()-1:7, \
 _n8##x = 8>=((img)._width)?(img).width()-1:8, \
 _n9##x = 9>=((img)._width)?(img).width()-1:9, \
 _n10##x = 10>=((img)._width)?(img).width()-1:10, \
 _n11##x = 11>=((img)._width)?(img).width()-1:11, \
 _n12##x = 12>=((img)._width)?(img).width()-1:12, \
 _n13##x = (int)( \
 (I[0] = I[1] = I[2] = I[3] = I[4] = I[5] = I[6] = I[7] = I[8] = I[9] = I[10] = I[11] = I[12] = I[13] = (T)(img)(0,_p13##y,z,c)), \
 (I[27] = I[28] = I[29] = I[30] = I[31] = I[32] = I[33] = I[34] = I[35] = I[36] = I[37] = I[38] = I[39] = I[40] = (T)(img)(0,_p12##y,z,c)), \
 (I[54] = I[55] = I[56] = I[57] = I[58] = I[59] = I[60] = I[61] = I[62] = I[63] = I[64] = I[65] = I[66] = I[67] = (T)(img)(0,_p11##y,z,c)), \
 (I[81] = I[82] = I[83] = I[84] = I[85] = I[86] = I[87] = I[88] = I[89] = I[90] = I[91] = I[92] = I[93] = I[94] = (T)(img)(0,_p10##y,z,c)), \
 (I[108] = I[109] = I[110] = I[111] = I[112] = I[113] = I[114] = I[115] = I[116] = I[117] = I[118] = I[119] = I[120] = I[121] = (T)(img)(0,_p9##y,z,c)), \
 (I[135] = I[136] = I[137] = I[138] = I[139] = I[140] = I[141] = I[142] = I[143] = I[144] = I[145] = I[146] = I[147] = I[148] = (T)(img)(0,_p8##y,z,c)), \
 (I[162] = I[163] = I[164] = I[165] = I[166] = I[167] = I[168] = I[169] = I[170] = I[171] = I[172] = I[173] = I[174] = I[175] = (T)(img)(0,_p7##y,z,c)), \
 (I[189] = I[190] = I[191] = I[192] = I[193] = I[194] = I[195] = I[196] = I[197] = I[198] = I[199] = I[200] = I[201] = I[202] = (T)(img)(0,_p6##y,z,c)), \
 (I[216] = I[217] = I[218] = I[219] = I[220] = I[221] = I[222] = I[223] = I[224] = I[225] = I[226] = I[227] = I[228] = I[229] = (T)(img)(0,_p5##y,z,c)), \
 (I[243] = I[244] = I[245] = I[246] = I[247] = I[248] = I[249] = I[250] = I[251] = I[252] = I[253] = I[254] = I[255] = I[256] = (T)(img)(0,_p4##y,z,c)), \
 (I[270] = I[271] = I[272] = I[273] = I[274] = I[275] = I[276] = I[277] = I[278] = I[279] = I[280] = I[281] = I[282] = I[283] = (T)(img)(0,_p3##y,z,c)), \
 (I[297] = I[298] = I[299] = I[300] = I[301] = I[302] = I[303] = I[304] = I[305] = I[306] = I[307] = I[308] = I[309] = I[310] = (T)(img)(0,_p2##y,z,c)), \
 (I[324] = I[325] = I[326] = I[327] = I[328] = I[329] = I[330] = I[331] = I[332] = I[333] = I[334] = I[335] = I[336] = I[337] = (T)(img)(0,_p1##y,z,c)), \
 (I[351] = I[352] = I[353] = I[354] = I[355] = I[356] = I[357] = I[358] = I[359] = I[360] = I[361] = I[362] = I[363] = I[364] = (T)(img)(0,y,z,c)), \
 (I[378] = I[379] = I[380] = I[381] = I[382] = I[383] = I[384] = I[385] = I[386] = I[387] = I[388] = I[389] = I[390] = I[391] = (T)(img)(0,_n1##y,z,c)), \
 (I[405] = I[406] = I[407] = I[408] = I[409] = I[410] = I[411] = I[412] = I[413] = I[414] = I[415] = I[416] = I[417] = I[418] = (T)(img)(0,_n2##y,z,c)), \
 (I[432] = I[433] = I[434] = I[435] = I[436] = I[437] = I[438] = I[439] = I[440] = I[441] = I[442] = I[443] = I[444] = I[445] = (T)(img)(0,_n3##y,z,c)), \
 (I[459] = I[460] = I[461] = I[462] = I[463] = I[464] = I[465] = I[466] = I[467] = I[468] = I[469] = I[470] = I[471] = I[472] = (T)(img)(0,_n4##y,z,c)), \
 (I[486] = I[487] = I[488] = I[489] = I[490] = I[491] = I[492] = I[493] = I[494] = I[495] = I[496] = I[497] = I[498] = I[499] = (T)(img)(0,_n5##y,z,c)), \
 (I[513] = I[514] = I[515] = I[516] = I[517] = I[518] = I[519] = I[520] = I[521] = I[522] = I[523] = I[524] = I[525] = I[526] = (T)(img)(0,_n6##y,z,c)), \
 (I[540] = I[541] = I[542] = I[543] = I[544] = I[545] = I[546] = I[547] = I[548] = I[549] = I[550] = I[551] = I[552] = I[553] = (T)(img)(0,_n7##y,z,c)), \
 (I[567] = I[568] = I[569] = I[570] = I[571] = I[572] = I[573] = I[574] = I[575] = I[576] = I[577] = I[578] = I[579] = I[580] = (T)(img)(0,_n8##y,z,c)), \
 (I[594] = I[595] = I[596] = I[597] = I[598] = I[599] = I[600] = I[601] = I[602] = I[603] = I[604] = I[605] = I[606] = I[607] = (T)(img)(0,_n9##y,z,c)), \
 (I[621] = I[622] = I[623] = I[624] = I[625] = I[626] = I[627] = I[628] = I[629] = I[630] = I[631] = I[632] = I[633] = I[634] = (T)(img)(0,_n10##y,z,c)), \
 (I[648] = I[649] = I[650] = I[651] = I[652] = I[653] = I[654] = I[655] = I[656] = I[657] = I[658] = I[659] = I[660] = I[661] = (T)(img)(0,_n11##y,z,c)), \
 (I[675] = I[676] = I[677] = I[678] = I[679] = I[680] = I[681] = I[682] = I[683] = I[684] = I[685] = I[686] = I[687] = I[688] = (T)(img)(0,_n12##y,z,c)), \
 (I[702] = I[703] = I[704] = I[705] = I[706] = I[707] = I[708] = I[709] = I[710] = I[711] = I[712] = I[713] = I[714] = I[715] = (T)(img)(0,_n13##y,z,c)), \
 (I[14] = (T)(img)(_n1##x,_p13##y,z,c)), \
 (I[41] = (T)(img)(_n1##x,_p12##y,z,c)), \
 (I[68] = (T)(img)(_n1##x,_p11##y,z,c)), \
 (I[95] = (T)(img)(_n1##x,_p10##y,z,c)), \
 (I[122] = (T)(img)(_n1##x,_p9##y,z,c)), \
 (I[149] = (T)(img)(_n1##x,_p8##y,z,c)), \
 (I[176] = (T)(img)(_n1##x,_p7##y,z,c)), \
 (I[203] = (T)(img)(_n1##x,_p6##y,z,c)), \
 (I[230] = (T)(img)(_n1##x,_p5##y,z,c)), \
 (I[257] = (T)(img)(_n1##x,_p4##y,z,c)), \
 (I[284] = (T)(img)(_n1##x,_p3##y,z,c)), \
 (I[311] = (T)(img)(_n1##x,_p2##y,z,c)), \
 (I[338] = (T)(img)(_n1##x,_p1##y,z,c)), \
 (I[365] = (T)(img)(_n1##x,y,z,c)), \
 (I[392] = (T)(img)(_n1##x,_n1##y,z,c)), \
 (I[419] = (T)(img)(_n1##x,_n2##y,z,c)), \
 (I[446] = (T)(img)(_n1##x,_n3##y,z,c)), \
 (I[473] = (T)(img)(_n1##x,_n4##y,z,c)), \
 (I[500] = (T)(img)(_n1##x,_n5##y,z,c)), \
 (I[527] = (T)(img)(_n1##x,_n6##y,z,c)), \
 (I[554] = (T)(img)(_n1##x,_n7##y,z,c)), \
 (I[581] = (T)(img)(_n1##x,_n8##y,z,c)), \
 (I[608] = (T)(img)(_n1##x,_n9##y,z,c)), \
 (I[635] = (T)(img)(_n1##x,_n10##y,z,c)), \
 (I[662] = (T)(img)(_n1##x,_n11##y,z,c)), \
 (I[689] = (T)(img)(_n1##x,_n12##y,z,c)), \
 (I[716] = (T)(img)(_n1##x,_n13##y,z,c)), \
 (I[15] = (T)(img)(_n2##x,_p13##y,z,c)), \
 (I[42] = (T)(img)(_n2##x,_p12##y,z,c)), \
 (I[69] = (T)(img)(_n2##x,_p11##y,z,c)), \
 (I[96] = (T)(img)(_n2##x,_p10##y,z,c)), \
 (I[123] = (T)(img)(_n2##x,_p9##y,z,c)), \
 (I[150] = (T)(img)(_n2##x,_p8##y,z,c)), \
 (I[177] = (T)(img)(_n2##x,_p7##y,z,c)), \
 (I[204] = (T)(img)(_n2##x,_p6##y,z,c)), \
 (I[231] = (T)(img)(_n2##x,_p5##y,z,c)), \
 (I[258] = (T)(img)(_n2##x,_p4##y,z,c)), \
 (I[285] = (T)(img)(_n2##x,_p3##y,z,c)), \
 (I[312] = (T)(img)(_n2##x,_p2##y,z,c)), \
 (I[339] = (T)(img)(_n2##x,_p1##y,z,c)), \
 (I[366] = (T)(img)(_n2##x,y,z,c)), \
 (I[393] = (T)(img)(_n2##x,_n1##y,z,c)), \
 (I[420] = (T)(img)(_n2##x,_n2##y,z,c)), \
 (I[447] = (T)(img)(_n2##x,_n3##y,z,c)), \
 (I[474] = (T)(img)(_n2##x,_n4##y,z,c)), \
 (I[501] = (T)(img)(_n2##x,_n5##y,z,c)), \
 (I[528] = (T)(img)(_n2##x,_n6##y,z,c)), \
 (I[555] = (T)(img)(_n2##x,_n7##y,z,c)), \
 (I[582] = (T)(img)(_n2##x,_n8##y,z,c)), \
 (I[609] = (T)(img)(_n2##x,_n9##y,z,c)), \
 (I[636] = (T)(img)(_n2##x,_n10##y,z,c)), \
 (I[663] = (T)(img)(_n2##x,_n11##y,z,c)), \
 (I[690] = (T)(img)(_n2##x,_n12##y,z,c)), \
 (I[717] = (T)(img)(_n2##x,_n13##y,z,c)), \
 (I[16] = (T)(img)(_n3##x,_p13##y,z,c)), \
 (I[43] = (T)(img)(_n3##x,_p12##y,z,c)), \
 (I[70] = (T)(img)(_n3##x,_p11##y,z,c)), \
 (I[97] = (T)(img)(_n3##x,_p10##y,z,c)), \
 (I[124] = (T)(img)(_n3##x,_p9##y,z,c)), \
 (I[151] = (T)(img)(_n3##x,_p8##y,z,c)), \
 (I[178] = (T)(img)(_n3##x,_p7##y,z,c)), \
 (I[205] = (T)(img)(_n3##x,_p6##y,z,c)), \
 (I[232] = (T)(img)(_n3##x,_p5##y,z,c)), \
 (I[259] = (T)(img)(_n3##x,_p4##y,z,c)), \
 (I[286] = (T)(img)(_n3##x,_p3##y,z,c)), \
 (I[313] = (T)(img)(_n3##x,_p2##y,z,c)), \
 (I[340] = (T)(img)(_n3##x,_p1##y,z,c)), \
 (I[367] = (T)(img)(_n3##x,y,z,c)), \
 (I[394] = (T)(img)(_n3##x,_n1##y,z,c)), \
 (I[421] = (T)(img)(_n3##x,_n2##y,z,c)), \
 (I[448] = (T)(img)(_n3##x,_n3##y,z,c)), \
 (I[475] = (T)(img)(_n3##x,_n4##y,z,c)), \
 (I[502] = (T)(img)(_n3##x,_n5##y,z,c)), \
 (I[529] = (T)(img)(_n3##x,_n6##y,z,c)), \
 (I[556] = (T)(img)(_n3##x,_n7##y,z,c)), \
 (I[583] = (T)(img)(_n3##x,_n8##y,z,c)), \
 (I[610] = (T)(img)(_n3##x,_n9##y,z,c)), \
 (I[637] = (T)(img)(_n3##x,_n10##y,z,c)), \
 (I[664] = (T)(img)(_n3##x,_n11##y,z,c)), \
 (I[691] = (T)(img)(_n3##x,_n12##y,z,c)), \
 (I[718] = (T)(img)(_n3##x,_n13##y,z,c)), \
 (I[17] = (T)(img)(_n4##x,_p13##y,z,c)), \
 (I[44] = (T)(img)(_n4##x,_p12##y,z,c)), \
 (I[71] = (T)(img)(_n4##x,_p11##y,z,c)), \
 (I[98] = (T)(img)(_n4##x,_p10##y,z,c)), \
 (I[125] = (T)(img)(_n4##x,_p9##y,z,c)), \
 (I[152] = (T)(img)(_n4##x,_p8##y,z,c)), \
 (I[179] = (T)(img)(_n4##x,_p7##y,z,c)), \
 (I[206] = (T)(img)(_n4##x,_p6##y,z,c)), \
 (I[233] = (T)(img)(_n4##x,_p5##y,z,c)), \
 (I[260] = (T)(img)(_n4##x,_p4##y,z,c)), \
 (I[287] = (T)(img)(_n4##x,_p3##y,z,c)), \
 (I[314] = (T)(img)(_n4##x,_p2##y,z,c)), \
 (I[341] = (T)(img)(_n4##x,_p1##y,z,c)), \
 (I[368] = (T)(img)(_n4##x,y,z,c)), \
 (I[395] = (T)(img)(_n4##x,_n1##y,z,c)), \
 (I[422] = (T)(img)(_n4##x,_n2##y,z,c)), \
 (I[449] = (T)(img)(_n4##x,_n3##y,z,c)), \
 (I[476] = (T)(img)(_n4##x,_n4##y,z,c)), \
 (I[503] = (T)(img)(_n4##x,_n5##y,z,c)), \
 (I[530] = (T)(img)(_n4##x,_n6##y,z,c)), \
 (I[557] = (T)(img)(_n4##x,_n7##y,z,c)), \
 (I[584] = (T)(img)(_n4##x,_n8##y,z,c)), \
 (I[611] = (T)(img)(_n4##x,_n9##y,z,c)), \
 (I[638] = (T)(img)(_n4##x,_n10##y,z,c)), \
 (I[665] = (T)(img)(_n4##x,_n11##y,z,c)), \
 (I[692] = (T)(img)(_n4##x,_n12##y,z,c)), \
 (I[719] = (T)(img)(_n4##x,_n13##y,z,c)), \
 (I[18] = (T)(img)(_n5##x,_p13##y,z,c)), \
 (I[45] = (T)(img)(_n5##x,_p12##y,z,c)), \
 (I[72] = (T)(img)(_n5##x,_p11##y,z,c)), \
 (I[99] = (T)(img)(_n5##x,_p10##y,z,c)), \
 (I[126] = (T)(img)(_n5##x,_p9##y,z,c)), \
 (I[153] = (T)(img)(_n5##x,_p8##y,z,c)), \
 (I[180] = (T)(img)(_n5##x,_p7##y,z,c)), \
 (I[207] = (T)(img)(_n5##x,_p6##y,z,c)), \
 (I[234] = (T)(img)(_n5##x,_p5##y,z,c)), \
 (I[261] = (T)(img)(_n5##x,_p4##y,z,c)), \
 (I[288] = (T)(img)(_n5##x,_p3##y,z,c)), \
 (I[315] = (T)(img)(_n5##x,_p2##y,z,c)), \
 (I[342] = (T)(img)(_n5##x,_p1##y,z,c)), \
 (I[369] = (T)(img)(_n5##x,y,z,c)), \
 (I[396] = (T)(img)(_n5##x,_n1##y,z,c)), \
 (I[423] = (T)(img)(_n5##x,_n2##y,z,c)), \
 (I[450] = (T)(img)(_n5##x,_n3##y,z,c)), \
 (I[477] = (T)(img)(_n5##x,_n4##y,z,c)), \
 (I[504] = (T)(img)(_n5##x,_n5##y,z,c)), \
 (I[531] = (T)(img)(_n5##x,_n6##y,z,c)), \
 (I[558] = (T)(img)(_n5##x,_n7##y,z,c)), \
 (I[585] = (T)(img)(_n5##x,_n8##y,z,c)), \
 (I[612] = (T)(img)(_n5##x,_n9##y,z,c)), \
 (I[639] = (T)(img)(_n5##x,_n10##y,z,c)), \
 (I[666] = (T)(img)(_n5##x,_n11##y,z,c)), \
 (I[693] = (T)(img)(_n5##x,_n12##y,z,c)), \
 (I[720] = (T)(img)(_n5##x,_n13##y,z,c)), \
 (I[19] = (T)(img)(_n6##x,_p13##y,z,c)), \
 (I[46] = (T)(img)(_n6##x,_p12##y,z,c)), \
 (I[73] = (T)(img)(_n6##x,_p11##y,z,c)), \
 (I[100] = (T)(img)(_n6##x,_p10##y,z,c)), \
 (I[127] = (T)(img)(_n6##x,_p9##y,z,c)), \
 (I[154] = (T)(img)(_n6##x,_p8##y,z,c)), \
 (I[181] = (T)(img)(_n6##x,_p7##y,z,c)), \
 (I[208] = (T)(img)(_n6##x,_p6##y,z,c)), \
 (I[235] = (T)(img)(_n6##x,_p5##y,z,c)), \
 (I[262] = (T)(img)(_n6##x,_p4##y,z,c)), \
 (I[289] = (T)(img)(_n6##x,_p3##y,z,c)), \
 (I[316] = (T)(img)(_n6##x,_p2##y,z,c)), \
 (I[343] = (T)(img)(_n6##x,_p1##y,z,c)), \
 (I[370] = (T)(img)(_n6##x,y,z,c)), \
 (I[397] = (T)(img)(_n6##x,_n1##y,z,c)), \
 (I[424] = (T)(img)(_n6##x,_n2##y,z,c)), \
 (I[451] = (T)(img)(_n6##x,_n3##y,z,c)), \
 (I[478] = (T)(img)(_n6##x,_n4##y,z,c)), \
 (I[505] = (T)(img)(_n6##x,_n5##y,z,c)), \
 (I[532] = (T)(img)(_n6##x,_n6##y,z,c)), \
 (I[559] = (T)(img)(_n6##x,_n7##y,z,c)), \
 (I[586] = (T)(img)(_n6##x,_n8##y,z,c)), \
 (I[613] = (T)(img)(_n6##x,_n9##y,z,c)), \
 (I[640] = (T)(img)(_n6##x,_n10##y,z,c)), \
 (I[667] = (T)(img)(_n6##x,_n11##y,z,c)), \
 (I[694] = (T)(img)(_n6##x,_n12##y,z,c)), \
 (I[721] = (T)(img)(_n6##x,_n13##y,z,c)), \
 (I[20] = (T)(img)(_n7##x,_p13##y,z,c)), \
 (I[47] = (T)(img)(_n7##x,_p12##y,z,c)), \
 (I[74] = (T)(img)(_n7##x,_p11##y,z,c)), \
 (I[101] = (T)(img)(_n7##x,_p10##y,z,c)), \
 (I[128] = (T)(img)(_n7##x,_p9##y,z,c)), \
 (I[155] = (T)(img)(_n7##x,_p8##y,z,c)), \
 (I[182] = (T)(img)(_n7##x,_p7##y,z,c)), \
 (I[209] = (T)(img)(_n7##x,_p6##y,z,c)), \
 (I[236] = (T)(img)(_n7##x,_p5##y,z,c)), \
 (I[263] = (T)(img)(_n7##x,_p4##y,z,c)), \
 (I[290] = (T)(img)(_n7##x,_p3##y,z,c)), \
 (I[317] = (T)(img)(_n7##x,_p2##y,z,c)), \
 (I[344] = (T)(img)(_n7##x,_p1##y,z,c)), \
 (I[371] = (T)(img)(_n7##x,y,z,c)), \
 (I[398] = (T)(img)(_n7##x,_n1##y,z,c)), \
 (I[425] = (T)(img)(_n7##x,_n2##y,z,c)), \
 (I[452] = (T)(img)(_n7##x,_n3##y,z,c)), \
 (I[479] = (T)(img)(_n7##x,_n4##y,z,c)), \
 (I[506] = (T)(img)(_n7##x,_n5##y,z,c)), \
 (I[533] = (T)(img)(_n7##x,_n6##y,z,c)), \
 (I[560] = (T)(img)(_n7##x,_n7##y,z,c)), \
 (I[587] = (T)(img)(_n7##x,_n8##y,z,c)), \
 (I[614] = (T)(img)(_n7##x,_n9##y,z,c)), \
 (I[641] = (T)(img)(_n7##x,_n10##y,z,c)), \
 (I[668] = (T)(img)(_n7##x,_n11##y,z,c)), \
 (I[695] = (T)(img)(_n7##x,_n12##y,z,c)), \
 (I[722] = (T)(img)(_n7##x,_n13##y,z,c)), \
 (I[21] = (T)(img)(_n8##x,_p13##y,z,c)), \
 (I[48] = (T)(img)(_n8##x,_p12##y,z,c)), \
 (I[75] = (T)(img)(_n8##x,_p11##y,z,c)), \
 (I[102] = (T)(img)(_n8##x,_p10##y,z,c)), \
 (I[129] = (T)(img)(_n8##x,_p9##y,z,c)), \
 (I[156] = (T)(img)(_n8##x,_p8##y,z,c)), \
 (I[183] = (T)(img)(_n8##x,_p7##y,z,c)), \
 (I[210] = (T)(img)(_n8##x,_p6##y,z,c)), \
 (I[237] = (T)(img)(_n8##x,_p5##y,z,c)), \
 (I[264] = (T)(img)(_n8##x,_p4##y,z,c)), \
 (I[291] = (T)(img)(_n8##x,_p3##y,z,c)), \
 (I[318] = (T)(img)(_n8##x,_p2##y,z,c)), \
 (I[345] = (T)(img)(_n8##x,_p1##y,z,c)), \
 (I[372] = (T)(img)(_n8##x,y,z,c)), \
 (I[399] = (T)(img)(_n8##x,_n1##y,z,c)), \
 (I[426] = (T)(img)(_n8##x,_n2##y,z,c)), \
 (I[453] = (T)(img)(_n8##x,_n3##y,z,c)), \
 (I[480] = (T)(img)(_n8##x,_n4##y,z,c)), \
 (I[507] = (T)(img)(_n8##x,_n5##y,z,c)), \
 (I[534] = (T)(img)(_n8##x,_n6##y,z,c)), \
 (I[561] = (T)(img)(_n8##x,_n7##y,z,c)), \
 (I[588] = (T)(img)(_n8##x,_n8##y,z,c)), \
 (I[615] = (T)(img)(_n8##x,_n9##y,z,c)), \
 (I[642] = (T)(img)(_n8##x,_n10##y,z,c)), \
 (I[669] = (T)(img)(_n8##x,_n11##y,z,c)), \
 (I[696] = (T)(img)(_n8##x,_n12##y,z,c)), \
 (I[723] = (T)(img)(_n8##x,_n13##y,z,c)), \
 (I[22] = (T)(img)(_n9##x,_p13##y,z,c)), \
 (I[49] = (T)(img)(_n9##x,_p12##y,z,c)), \
 (I[76] = (T)(img)(_n9##x,_p11##y,z,c)), \
 (I[103] = (T)(img)(_n9##x,_p10##y,z,c)), \
 (I[130] = (T)(img)(_n9##x,_p9##y,z,c)), \
 (I[157] = (T)(img)(_n9##x,_p8##y,z,c)), \
 (I[184] = (T)(img)(_n9##x,_p7##y,z,c)), \
 (I[211] = (T)(img)(_n9##x,_p6##y,z,c)), \
 (I[238] = (T)(img)(_n9##x,_p5##y,z,c)), \
 (I[265] = (T)(img)(_n9##x,_p4##y,z,c)), \
 (I[292] = (T)(img)(_n9##x,_p3##y,z,c)), \
 (I[319] = (T)(img)(_n9##x,_p2##y,z,c)), \
 (I[346] = (T)(img)(_n9##x,_p1##y,z,c)), \
 (I[373] = (T)(img)(_n9##x,y,z,c)), \
 (I[400] = (T)(img)(_n9##x,_n1##y,z,c)), \
 (I[427] = (T)(img)(_n9##x,_n2##y,z,c)), \
 (I[454] = (T)(img)(_n9##x,_n3##y,z,c)), \
 (I[481] = (T)(img)(_n9##x,_n4##y,z,c)), \
 (I[508] = (T)(img)(_n9##x,_n5##y,z,c)), \
 (I[535] = (T)(img)(_n9##x,_n6##y,z,c)), \
 (I[562] = (T)(img)(_n9##x,_n7##y,z,c)), \
 (I[589] = (T)(img)(_n9##x,_n8##y,z,c)), \
 (I[616] = (T)(img)(_n9##x,_n9##y,z,c)), \
 (I[643] = (T)(img)(_n9##x,_n10##y,z,c)), \
 (I[670] = (T)(img)(_n9##x,_n11##y,z,c)), \
 (I[697] = (T)(img)(_n9##x,_n12##y,z,c)), \
 (I[724] = (T)(img)(_n9##x,_n13##y,z,c)), \
 (I[23] = (T)(img)(_n10##x,_p13##y,z,c)), \
 (I[50] = (T)(img)(_n10##x,_p12##y,z,c)), \
 (I[77] = (T)(img)(_n10##x,_p11##y,z,c)), \
 (I[104] = (T)(img)(_n10##x,_p10##y,z,c)), \
 (I[131] = (T)(img)(_n10##x,_p9##y,z,c)), \
 (I[158] = (T)(img)(_n10##x,_p8##y,z,c)), \
 (I[185] = (T)(img)(_n10##x,_p7##y,z,c)), \
 (I[212] = (T)(img)(_n10##x,_p6##y,z,c)), \
 (I[239] = (T)(img)(_n10##x,_p5##y,z,c)), \
 (I[266] = (T)(img)(_n10##x,_p4##y,z,c)), \
 (I[293] = (T)(img)(_n10##x,_p3##y,z,c)), \
 (I[320] = (T)(img)(_n10##x,_p2##y,z,c)), \
 (I[347] = (T)(img)(_n10##x,_p1##y,z,c)), \
 (I[374] = (T)(img)(_n10##x,y,z,c)), \
 (I[401] = (T)(img)(_n10##x,_n1##y,z,c)), \
 (I[428] = (T)(img)(_n10##x,_n2##y,z,c)), \
 (I[455] = (T)(img)(_n10##x,_n3##y,z,c)), \
 (I[482] = (T)(img)(_n10##x,_n4##y,z,c)), \
 (I[509] = (T)(img)(_n10##x,_n5##y,z,c)), \
 (I[536] = (T)(img)(_n10##x,_n6##y,z,c)), \
 (I[563] = (T)(img)(_n10##x,_n7##y,z,c)), \
 (I[590] = (T)(img)(_n10##x,_n8##y,z,c)), \
 (I[617] = (T)(img)(_n10##x,_n9##y,z,c)), \
 (I[644] = (T)(img)(_n10##x,_n10##y,z,c)), \
 (I[671] = (T)(img)(_n10##x,_n11##y,z,c)), \
 (I[698] = (T)(img)(_n10##x,_n12##y,z,c)), \
 (I[725] = (T)(img)(_n10##x,_n13##y,z,c)), \
 (I[24] = (T)(img)(_n11##x,_p13##y,z,c)), \
 (I[51] = (T)(img)(_n11##x,_p12##y,z,c)), \
 (I[78] = (T)(img)(_n11##x,_p11##y,z,c)), \
 (I[105] = (T)(img)(_n11##x,_p10##y,z,c)), \
 (I[132] = (T)(img)(_n11##x,_p9##y,z,c)), \
 (I[159] = (T)(img)(_n11##x,_p8##y,z,c)), \
 (I[186] = (T)(img)(_n11##x,_p7##y,z,c)), \
 (I[213] = (T)(img)(_n11##x,_p6##y,z,c)), \
 (I[240] = (T)(img)(_n11##x,_p5##y,z,c)), \
 (I[267] = (T)(img)(_n11##x,_p4##y,z,c)), \
 (I[294] = (T)(img)(_n11##x,_p3##y,z,c)), \
 (I[321] = (T)(img)(_n11##x,_p2##y,z,c)), \
 (I[348] = (T)(img)(_n11##x,_p1##y,z,c)), \
 (I[375] = (T)(img)(_n11##x,y,z,c)), \
 (I[402] = (T)(img)(_n11##x,_n1##y,z,c)), \
 (I[429] = (T)(img)(_n11##x,_n2##y,z,c)), \
 (I[456] = (T)(img)(_n11##x,_n3##y,z,c)), \
 (I[483] = (T)(img)(_n11##x,_n4##y,z,c)), \
 (I[510] = (T)(img)(_n11##x,_n5##y,z,c)), \
 (I[537] = (T)(img)(_n11##x,_n6##y,z,c)), \
 (I[564] = (T)(img)(_n11##x,_n7##y,z,c)), \
 (I[591] = (T)(img)(_n11##x,_n8##y,z,c)), \
 (I[618] = (T)(img)(_n11##x,_n9##y,z,c)), \
 (I[645] = (T)(img)(_n11##x,_n10##y,z,c)), \
 (I[672] = (T)(img)(_n11##x,_n11##y,z,c)), \
 (I[699] = (T)(img)(_n11##x,_n12##y,z,c)), \
 (I[726] = (T)(img)(_n11##x,_n13##y,z,c)), \
 (I[25] = (T)(img)(_n12##x,_p13##y,z,c)), \
 (I[52] = (T)(img)(_n12##x,_p12##y,z,c)), \
 (I[79] = (T)(img)(_n12##x,_p11##y,z,c)), \
 (I[106] = (T)(img)(_n12##x,_p10##y,z,c)), \
 (I[133] = (T)(img)(_n12##x,_p9##y,z,c)), \
 (I[160] = (T)(img)(_n12##x,_p8##y,z,c)), \
 (I[187] = (T)(img)(_n12##x,_p7##y,z,c)), \
 (I[214] = (T)(img)(_n12##x,_p6##y,z,c)), \
 (I[241] = (T)(img)(_n12##x,_p5##y,z,c)), \
 (I[268] = (T)(img)(_n12##x,_p4##y,z,c)), \
 (I[295] = (T)(img)(_n12##x,_p3##y,z,c)), \
 (I[322] = (T)(img)(_n12##x,_p2##y,z,c)), \
 (I[349] = (T)(img)(_n12##x,_p1##y,z,c)), \
 (I[376] = (T)(img)(_n12##x,y,z,c)), \
 (I[403] = (T)(img)(_n12##x,_n1##y,z,c)), \
 (I[430] = (T)(img)(_n12##x,_n2##y,z,c)), \
 (I[457] = (T)(img)(_n12##x,_n3##y,z,c)), \
 (I[484] = (T)(img)(_n12##x,_n4##y,z,c)), \
 (I[511] = (T)(img)(_n12##x,_n5##y,z,c)), \
 (I[538] = (T)(img)(_n12##x,_n6##y,z,c)), \
 (I[565] = (T)(img)(_n12##x,_n7##y,z,c)), \
 (I[592] = (T)(img)(_n12##x,_n8##y,z,c)), \
 (I[619] = (T)(img)(_n12##x,_n9##y,z,c)), \
 (I[646] = (T)(img)(_n12##x,_n10##y,z,c)), \
 (I[673] = (T)(img)(_n12##x,_n11##y,z,c)), \
 (I[700] = (T)(img)(_n12##x,_n12##y,z,c)), \
 (I[727] = (T)(img)(_n12##x,_n13##y,z,c)), \
 13>=((img)._width)?(img).width()-1:13); \
 (_n13##x<(img).width() && ( \
 (I[26] = (T)(img)(_n13##x,_p13##y,z,c)), \
 (I[53] = (T)(img)(_n13##x,_p12##y,z,c)), \
 (I[80] = (T)(img)(_n13##x,_p11##y,z,c)), \
 (I[107] = (T)(img)(_n13##x,_p10##y,z,c)), \
 (I[134] = (T)(img)(_n13##x,_p9##y,z,c)), \
 (I[161] = (T)(img)(_n13##x,_p8##y,z,c)), \
 (I[188] = (T)(img)(_n13##x,_p7##y,z,c)), \
 (I[215] = (T)(img)(_n13##x,_p6##y,z,c)), \
 (I[242] = (T)(img)(_n13##x,_p5##y,z,c)), \
 (I[269] = (T)(img)(_n13##x,_p4##y,z,c)), \
 (I[296] = (T)(img)(_n13##x,_p3##y,z,c)), \
 (I[323] = (T)(img)(_n13##x,_p2##y,z,c)), \
 (I[350] = (T)(img)(_n13##x,_p1##y,z,c)), \
 (I[377] = (T)(img)(_n13##x,y,z,c)), \
 (I[404] = (T)(img)(_n13##x,_n1##y,z,c)), \
 (I[431] = (T)(img)(_n13##x,_n2##y,z,c)), \
 (I[458] = (T)(img)(_n13##x,_n3##y,z,c)), \
 (I[485] = (T)(img)(_n13##x,_n4##y,z,c)), \
 (I[512] = (T)(img)(_n13##x,_n5##y,z,c)), \
 (I[539] = (T)(img)(_n13##x,_n6##y,z,c)), \
 (I[566] = (T)(img)(_n13##x,_n7##y,z,c)), \
 (I[593] = (T)(img)(_n13##x,_n8##y,z,c)), \
 (I[620] = (T)(img)(_n13##x,_n9##y,z,c)), \
 (I[647] = (T)(img)(_n13##x,_n10##y,z,c)), \
 (I[674] = (T)(img)(_n13##x,_n11##y,z,c)), \
 (I[701] = (T)(img)(_n13##x,_n12##y,z,c)), \
 (I[728] = (T)(img)(_n13##x,_n13##y,z,c)),1)) || \
 _n12##x==--_n13##x || _n11##x==--_n12##x || _n10##x==--_n11##x || _n9##x==--_n10##x || _n8##x==--_n9##x || _n7##x==--_n8##x || _n6##x==--_n7##x || _n5##x==--_n6##x || _n4##x==--_n5##x || _n3##x==--_n4##x || _n2##x==--_n3##x || _n1##x==--_n2##x || x==(_n13##x = _n12##x = _n11##x = _n10##x = _n9##x = _n8##x = _n7##x = _n6##x = _n5##x = _n4##x = _n3##x = _n2##x = --_n1##x); \
 I[0] = I[1], I[1] = I[2], I[2] = I[3], I[3] = I[4], I[4] = I[5], I[5] = I[6], I[6] = I[7], I[7] = I[8], I[8] = I[9], I[9] = I[10], I[10] = I[11], I[11] = I[12], I[12] = I[13], I[13] = I[14], I[14] = I[15], I[15] = I[16], I[16] = I[17], I[17] = I[18], I[18] = I[19], I[19] = I[20], I[20] = I[21], I[21] = I[22], I[22] = I[23], I[23] = I[24], I[24] = I[25], I[25] = I[26], \
 I[27] = I[28], I[28] = I[29], I[29] = I[30], I[30] = I[31], I[31] = I[32], I[32] = I[33], I[33] = I[34], I[34] = I[35], I[35] = I[36], I[36] = I[37], I[37] = I[38], I[38] = I[39], I[39] = I[40], I[40] = I[41], I[41] = I[42], I[42] = I[43], I[43] = I[44], I[44] = I[45], I[45] = I[46], I[46] = I[47], I[47] = I[48], I[48] = I[49], I[49] = I[50], I[50] = I[51], I[51] = I[52], I[52] = I[53], \
 I[54] = I[55], I[55] = I[56], I[56] = I[57], I[57] = I[58], I[58] = I[59], I[59] = I[60], I[60] = I[61], I[61] = I[62], I[62] = I[63], I[63] = I[64], I[64] = I[65], I[65] = I[66], I[66] = I[67], I[67] = I[68], I[68] = I[69], I[69] = I[70], I[70] = I[71], I[71] = I[72], I[72] = I[73], I[73] = I[74], I[74] = I[75], I[75] = I[76], I[76] = I[77], I[77] = I[78], I[78] = I[79], I[79] = I[80], \
 I[81] = I[82], I[82] = I[83], I[83] = I[84], I[84] = I[85], I[85] = I[86], I[86] = I[87], I[87] = I[88], I[88] = I[89], I[89] = I[90], I[90] = I[91], I[91] = I[92], I[92] = I[93], I[93] = I[94], I[94] = I[95], I[95] = I[96], I[96] = I[97], I[97] = I[98], I[98] = I[99], I[99] = I[100], I[100] = I[101], I[101] = I[102], I[102] = I[103], I[103] = I[104], I[104] = I[105], I[105] = I[106], I[106] = I[107], \
 I[108] = I[109], I[109] = I[110], I[110] = I[111], I[111] = I[112], I[112] = I[113], I[113] = I[114], I[114] = I[115], I[115] = I[116], I[116] = I[117], I[117] = I[118], I[118] = I[119], I[119] = I[120], I[120] = I[121], I[121] = I[122], I[122] = I[123], I[123] = I[124], I[124] = I[125], I[125] = I[126], I[126] = I[127], I[127] = I[128], I[128] = I[129], I[129] = I[130], I[130] = I[131], I[131] = I[132], I[132] = I[133], I[133] = I[134], \
 I[135] = I[136], I[136] = I[137], I[137] = I[138], I[138] = I[139], I[139] = I[140], I[140] = I[141], I[141] = I[142], I[142] = I[143], I[143] = I[144], I[144] = I[145], I[145] = I[146], I[146] = I[147], I[147] = I[148], I[148] = I[149], I[149] = I[150], I[150] = I[151], I[151] = I[152], I[152] = I[153], I[153] = I[154], I[154] = I[155], I[155] = I[156], I[156] = I[157], I[157] = I[158], I[158] = I[159], I[159] = I[160], I[160] = I[161], \
 I[162] = I[163], I[163] = I[164], I[164] = I[165], I[165] = I[166], I[166] = I[167], I[167] = I[168], I[168] = I[169], I[169] = I[170], I[170] = I[171], I[171] = I[172], I[172] = I[173], I[173] = I[174], I[174] = I[175], I[175] = I[176], I[176] = I[177], I[177] = I[178], I[178] = I[179], I[179] = I[180], I[180] = I[181], I[181] = I[182], I[182] = I[183], I[183] = I[184], I[184] = I[185], I[185] = I[186], I[186] = I[187], I[187] = I[188], \
 I[189] = I[190], I[190] = I[191], I[191] = I[192], I[192] = I[193], I[193] = I[194], I[194] = I[195], I[195] = I[196], I[196] = I[197], I[197] = I[198], I[198] = I[199], I[199] = I[200], I[200] = I[201], I[201] = I[202], I[202] = I[203], I[203] = I[204], I[204] = I[205], I[205] = I[206], I[206] = I[207], I[207] = I[208], I[208] = I[209], I[209] = I[210], I[210] = I[211], I[211] = I[212], I[212] = I[213], I[213] = I[214], I[214] = I[215], \
 I[216] = I[217], I[217] = I[218], I[218] = I[219], I[219] = I[220], I[220] = I[221], I[221] = I[222], I[222] = I[223], I[223] = I[224], I[224] = I[225], I[225] = I[226], I[226] = I[227], I[227] = I[228], I[228] = I[229], I[229] = I[230], I[230] = I[231], I[231] = I[232], I[232] = I[233], I[233] = I[234], I[234] = I[235], I[235] = I[236], I[236] = I[237], I[237] = I[238], I[238] = I[239], I[239] = I[240], I[240] = I[241], I[241] = I[242], \
 I[243] = I[244], I[244] = I[245], I[245] = I[246], I[246] = I[247], I[247] = I[248], I[248] = I[249], I[249] = I[250], I[250] = I[251], I[251] = I[252], I[252] = I[253], I[253] = I[254], I[254] = I[255], I[255] = I[256], I[256] = I[257], I[257] = I[258], I[258] = I[259], I[259] = I[260], I[260] = I[261], I[261] = I[262], I[262] = I[263], I[263] = I[264], I[264] = I[265], I[265] = I[266], I[266] = I[267], I[267] = I[268], I[268] = I[269], \
 I[270] = I[271], I[271] = I[272], I[272] = I[273], I[273] = I[274], I[274] = I[275], I[275] = I[276], I[276] = I[277], I[277] = I[278], I[278] = I[279], I[279] = I[280], I[280] = I[281], I[281] = I[282], I[282] = I[283], I[283] = I[284], I[284] = I[285], I[285] = I[286], I[286] = I[287], I[287] = I[288], I[288] = I[289], I[289] = I[290], I[290] = I[291], I[291] = I[292], I[292] = I[293], I[293] = I[294], I[294] = I[295], I[295] = I[296], \
 I[297] = I[298], I[298] = I[299], I[299] = I[300], I[300] = I[301], I[301] = I[302], I[302] = I[303], I[303] = I[304], I[304] = I[305], I[305] = I[306], I[306] = I[307], I[307] = I[308], I[308] = I[309], I[309] = I[310], I[310] = I[311], I[311] = I[312], I[312] = I[313], I[313] = I[314], I[314] = I[315], I[315] = I[316], I[316] = I[317], I[317] = I[318], I[318] = I[319], I[319] = I[320], I[320] = I[321], I[321] = I[322], I[322] = I[323], \
 I[324] = I[325], I[325] = I[326], I[326] = I[327], I[327] = I[328], I[328] = I[329], I[329] = I[330], I[330] = I[331], I[331] = I[332], I[332] = I[333], I[333] = I[334], I[334] = I[335], I[335] = I[336], I[336] = I[337], I[337] = I[338], I[338] = I[339], I[339] = I[340], I[340] = I[341], I[341] = I[342], I[342] = I[343], I[343] = I[344], I[344] = I[345], I[345] = I[346], I[346] = I[347], I[347] = I[348], I[348] = I[349], I[349] = I[350], \
 I[351] = I[352], I[352] = I[353], I[353] = I[354], I[354] = I[355], I[355] = I[356], I[356] = I[357], I[357] = I[358], I[358] = I[359], I[359] = I[360], I[360] = I[361], I[361] = I[362], I[362] = I[363], I[363] = I[364], I[364] = I[365], I[365] = I[366], I[366] = I[367], I[367] = I[368], I[368] = I[369], I[369] = I[370], I[370] = I[371], I[371] = I[372], I[372] = I[373], I[373] = I[374], I[374] = I[375], I[375] = I[376], I[376] = I[377], \
 I[378] = I[379], I[379] = I[380], I[380] = I[381], I[381] = I[382], I[382] = I[383], I[383] = I[384], I[384] = I[385], I[385] = I[386], I[386] = I[387], I[387] = I[388], I[388] = I[389], I[389] = I[390], I[390] = I[391], I[391] = I[392], I[392] = I[393], I[393] = I[394], I[394] = I[395], I[395] = I[396], I[396] = I[397], I[397] = I[398], I[398] = I[399], I[399] = I[400], I[400] = I[401], I[401] = I[402], I[402] = I[403], I[403] = I[404], \
 I[405] = I[406], I[406] = I[407], I[407] = I[408], I[408] = I[409], I[409] = I[410], I[410] = I[411], I[411] = I[412], I[412] = I[413], I[413] = I[414], I[414] = I[415], I[415] = I[416], I[416] = I[417], I[417] = I[418], I[418] = I[419], I[419] = I[420], I[420] = I[421], I[421] = I[422], I[422] = I[423], I[423] = I[424], I[424] = I[425], I[425] = I[426], I[426] = I[427], I[427] = I[428], I[428] = I[429], I[429] = I[430], I[430] = I[431], \
 I[432] = I[433], I[433] = I[434], I[434] = I[435], I[435] = I[436], I[436] = I[437], I[437] = I[438], I[438] = I[439], I[439] = I[440], I[440] = I[441], I[441] = I[442], I[442] = I[443], I[443] = I[444], I[444] = I[445], I[445] = I[446], I[446] = I[447], I[447] = I[448], I[448] = I[449], I[449] = I[450], I[450] = I[451], I[451] = I[452], I[452] = I[453], I[453] = I[454], I[454] = I[455], I[455] = I[456], I[456] = I[457], I[457] = I[458], \
 I[459] = I[460], I[460] = I[461], I[461] = I[462], I[462] = I[463], I[463] = I[464], I[464] = I[465], I[465] = I[466], I[466] = I[467], I[467] = I[468], I[468] = I[469], I[469] = I[470], I[470] = I[471], I[471] = I[472], I[472] = I[473], I[473] = I[474], I[474] = I[475], I[475] = I[476], I[476] = I[477], I[477] = I[478], I[478] = I[479], I[479] = I[480], I[480] = I[481], I[481] = I[482], I[482] = I[483], I[483] = I[484], I[484] = I[485], \
 I[486] = I[487], I[487] = I[488], I[488] = I[489], I[489] = I[490], I[490] = I[491], I[491] = I[492], I[492] = I[493], I[493] = I[494], I[494] = I[495], I[495] = I[496], I[496] = I[497], I[497] = I[498], I[498] = I[499], I[499] = I[500], I[500] = I[501], I[501] = I[502], I[502] = I[503], I[503] = I[504], I[504] = I[505], I[505] = I[506], I[506] = I[507], I[507] = I[508], I[508] = I[509], I[509] = I[510], I[510] = I[511], I[511] = I[512], \
 I[513] = I[514], I[514] = I[515], I[515] = I[516], I[516] = I[517], I[517] = I[518], I[518] = I[519], I[519] = I[520], I[520] = I[521], I[521] = I[522], I[522] = I[523], I[523] = I[524], I[524] = I[525], I[525] = I[526], I[526] = I[527], I[527] = I[528], I[528] = I[529], I[529] = I[530], I[530] = I[531], I[531] = I[532], I[532] = I[533], I[533] = I[534], I[534] = I[535], I[535] = I[536], I[536] = I[537], I[537] = I[538], I[538] = I[539], \
 I[540] = I[541], I[541] = I[542], I[542] = I[543], I[543] = I[544], I[544] = I[545], I[545] = I[546], I[546] = I[547], I[547] = I[548], I[548] = I[549], I[549] = I[550], I[550] = I[551], I[551] = I[552], I[552] = I[553], I[553] = I[554], I[554] = I[555], I[555] = I[556], I[556] = I[557], I[557] = I[558], I[558] = I[559], I[559] = I[560], I[560] = I[561], I[561] = I[562], I[562] = I[563], I[563] = I[564], I[564] = I[565], I[565] = I[566], \
 I[567] = I[568], I[568] = I[569], I[569] = I[570], I[570] = I[571], I[571] = I[572], I[572] = I[573], I[573] = I[574], I[574] = I[575], I[575] = I[576], I[576] = I[577], I[577] = I[578], I[578] = I[579], I[579] = I[580], I[580] = I[581], I[581] = I[582], I[582] = I[583], I[583] = I[584], I[584] = I[585], I[585] = I[586], I[586] = I[587], I[587] = I[588], I[588] = I[589], I[589] = I[590], I[590] = I[591], I[591] = I[592], I[592] = I[593], \
 I[594] = I[595], I[595] = I[596], I[596] = I[597], I[597] = I[598], I[598] = I[599], I[599] = I[600], I[600] = I[601], I[601] = I[602], I[602] = I[603], I[603] = I[604], I[604] = I[605], I[605] = I[606], I[606] = I[607], I[607] = I[608], I[608] = I[609], I[609] = I[610], I[610] = I[611], I[611] = I[612], I[612] = I[613], I[613] = I[614], I[614] = I[615], I[615] = I[616], I[616] = I[617], I[617] = I[618], I[618] = I[619], I[619] = I[620], \
 I[621] = I[622], I[622] = I[623], I[623] = I[624], I[624] = I[625], I[625] = I[626], I[626] = I[627], I[627] = I[628], I[628] = I[629], I[629] = I[630], I[630] = I[631], I[631] = I[632], I[632] = I[633], I[633] = I[634], I[634] = I[635], I[635] = I[636], I[636] = I[637], I[637] = I[638], I[638] = I[639], I[639] = I[640], I[640] = I[641], I[641] = I[642], I[642] = I[643], I[643] = I[644], I[644] = I[645], I[645] = I[646], I[646] = I[647], \
 I[648] = I[649], I[649] = I[650], I[650] = I[651], I[651] = I[652], I[652] = I[653], I[653] = I[654], I[654] = I[655], I[655] = I[656], I[656] = I[657], I[657] = I[658], I[658] = I[659], I[659] = I[660], I[660] = I[661], I[661] = I[662], I[662] = I[663], I[663] = I[664], I[664] = I[665], I[665] = I[666], I[666] = I[667], I[667] = I[668], I[668] = I[669], I[669] = I[670], I[670] = I[671], I[671] = I[672], I[672] = I[673], I[673] = I[674], \
 I[675] = I[676], I[676] = I[677], I[677] = I[678], I[678] = I[679], I[679] = I[680], I[680] = I[681], I[681] = I[682], I[682] = I[683], I[683] = I[684], I[684] = I[685], I[685] = I[686], I[686] = I[687], I[687] = I[688], I[688] = I[689], I[689] = I[690], I[690] = I[691], I[691] = I[692], I[692] = I[693], I[693] = I[694], I[694] = I[695], I[695] = I[696], I[696] = I[697], I[697] = I[698], I[698] = I[699], I[699] = I[700], I[700] = I[701], \
 I[702] = I[703], I[703] = I[704], I[704] = I[705], I[705] = I[706], I[706] = I[707], I[707] = I[708], I[708] = I[709], I[709] = I[710], I[710] = I[711], I[711] = I[712], I[712] = I[713], I[713] = I[714], I[714] = I[715], I[715] = I[716], I[716] = I[717], I[717] = I[718], I[718] = I[719], I[719] = I[720], I[720] = I[721], I[721] = I[722], I[722] = I[723], I[723] = I[724], I[724] = I[725], I[725] = I[726], I[726] = I[727], I[727] = I[728], \
 _p13##x = _p12##x, _p12##x = _p11##x, _p11##x = _p10##x, _p10##x = _p9##x, _p9##x = _p8##x, _p8##x = _p7##x, _p7##x = _p6##x, _p6##x = _p5##x, _p5##x = _p4##x, _p4##x = _p3##x, _p3##x = _p2##x, _p2##x = _p1##x, _p1##x = x++, ++_n1##x, ++_n2##x, ++_n3##x, ++_n4##x, ++_n5##x, ++_n6##x, ++_n7##x, ++_n8##x, ++_n9##x, ++_n10##x, ++_n11##x, ++_n12##x, ++_n13##x)

#define cimg_for_in27x27(img,x0,y0,x1,y1,x,y,z,c,I,T) \
 cimg_for_in27((img)._height,y0,y1,y) for (int x = (int)(x0)<0?0:(int)(x0), \
 _p13##x = x-13<0?0:x-13, \
 _p12##x = x-12<0?0:x-12, \
 _p11##x = x-11<0?0:x-11, \
 _p10##x = x-10<0?0:x-10, \
 _p9##x = x-9<0?0:x-9, \
 _p8##x = x-8<0?0:x-8, \
 _p7##x = x-7<0?0:x-7, \
 _p6##x = x-6<0?0:x-6, \
 _p5##x = x-5<0?0:x-5, \
 _p4##x = x-4<0?0:x-4, \
 _p3##x = x-3<0?0:x-3, \
 _p2##x = x-2<0?0:x-2, \
 _p1##x = x-1<0?0:x-1, \
 _n1##x = x+1>=(img).width()?(img).width()-1:x+1, \
 _n2##x = x+2>=(img).width()?(img).width()-1:x+2, \
 _n3##x = x+3>=(img).width()?(img).width()-1:x+3, \
 _n4##x = x+4>=(img).width()?(img).width()-1:x+4, \
 _n5##x = x+5>=(img).width()?(img).width()-1:x+5, \
 _n6##x = x+6>=(img).width()?(img).width()-1:x+6, \
 _n7##x = x+7>=(img).width()?(img).width()-1:x+7, \
 _n8##x = x+8>=(img).width()?(img).width()-1:x+8, \
 _n9##x = x+9>=(img).width()?(img).width()-1:x+9, \
 _n10##x = x+10>=(img).width()?(img).width()-1:x+10, \
 _n11##x = x+11>=(img).width()?(img).width()-1:x+11, \
 _n12##x = x+12>=(img).width()?(img).width()-1:x+12, \
 _n13##x = (int)( \
 (I[0] = (T)(img)(_p13##x,_p13##y,z,c)), \
 (I[27] = (T)(img)(_p13##x,_p12##y,z,c)), \
 (I[54] = (T)(img)(_p13##x,_p11##y,z,c)), \
 (I[81] = (T)(img)(_p13##x,_p10##y,z,c)), \
 (I[108] = (T)(img)(_p13##x,_p9##y,z,c)), \
 (I[135] = (T)(img)(_p13##x,_p8##y,z,c)), \
 (I[162] = (T)(img)(_p13##x,_p7##y,z,c)), \
 (I[189] = (T)(img)(_p13##x,_p6##y,z,c)), \
 (I[216] = (T)(img)(_p13##x,_p5##y,z,c)), \
 (I[243] = (T)(img)(_p13##x,_p4##y,z,c)), \
 (I[270] = (T)(img)(_p13##x,_p3##y,z,c)), \
 (I[297] = (T)(img)(_p13##x,_p2##y,z,c)), \
 (I[324] = (T)(img)(_p13##x,_p1##y,z,c)), \
 (I[351] = (T)(img)(_p13##x,y,z,c)), \
 (I[378] = (T)(img)(_p13##x,_n1##y,z,c)), \
 (I[405] = (T)(img)(_p13##x,_n2##y,z,c)), \
 (I[432] = (T)(img)(_p13##x,_n3##y,z,c)), \
 (I[459] = (T)(img)(_p13##x,_n4##y,z,c)), \
 (I[486] = (T)(img)(_p13##x,_n5##y,z,c)), \
 (I[513] = (T)(img)(_p13##x,_n6##y,z,c)), \
 (I[540] = (T)(img)(_p13##x,_n7##y,z,c)), \
 (I[567] = (T)(img)(_p13##x,_n8##y,z,c)), \
 (I[594] = (T)(img)(_p13##x,_n9##y,z,c)), \
 (I[621] = (T)(img)(_p13##x,_n10##y,z,c)), \
 (I[648] = (T)(img)(_p13##x,_n11##y,z,c)), \
 (I[675] = (T)(img)(_p13##x,_n12##y,z,c)), \
 (I[702] = (T)(img)(_p13##x,_n13##y,z,c)), \
 (I[1] = (T)(img)(_p12##x,_p13##y,z,c)), \
 (I[28] = (T)(img)(_p12##x,_p12##y,z,c)), \
 (I[55] = (T)(img)(_p12##x,_p11##y,z,c)), \
 (I[82] = (T)(img)(_p12##x,_p10##y,z,c)), \
 (I[109] = (T)(img)(_p12##x,_p9##y,z,c)), \
 (I[136] = (T)(img)(_p12##x,_p8##y,z,c)), \
 (I[163] = (T)(img)(_p12##x,_p7##y,z,c)), \
 (I[190] = (T)(img)(_p12##x,_p6##y,z,c)), \
 (I[217] = (T)(img)(_p12##x,_p5##y,z,c)), \
 (I[244] = (T)(img)(_p12##x,_p4##y,z,c)), \
 (I[271] = (T)(img)(_p12##x,_p3##y,z,c)), \
 (I[298] = (T)(img)(_p12##x,_p2##y,z,c)), \
 (I[325] = (T)(img)(_p12##x,_p1##y,z,c)), \
 (I[352] = (T)(img)(_p12##x,y,z,c)), \
 (I[379] = (T)(img)(_p12##x,_n1##y,z,c)), \
 (I[406] = (T)(img)(_p12##x,_n2##y,z,c)), \
 (I[433] = (T)(img)(_p12##x,_n3##y,z,c)), \
 (I[460] = (T)(img)(_p12##x,_n4##y,z,c)), \
 (I[487] = (T)(img)(_p12##x,_n5##y,z,c)), \
 (I[514] = (T)(img)(_p12##x,_n6##y,z,c)), \
 (I[541] = (T)(img)(_p12##x,_n7##y,z,c)), \
 (I[568] = (T)(img)(_p12##x,_n8##y,z,c)), \
 (I[595] = (T)(img)(_p12##x,_n9##y,z,c)), \
 (I[622] = (T)(img)(_p12##x,_n10##y,z,c)), \
 (I[649] = (T)(img)(_p12##x,_n11##y,z,c)), \
 (I[676] = (T)(img)(_p12##x,_n12##y,z,c)), \
 (I[703] = (T)(img)(_p12##x,_n13##y,z,c)), \
 (I[2] = (T)(img)(_p11##x,_p13##y,z,c)), \
 (I[29] = (T)(img)(_p11##x,_p12##y,z,c)), \
 (I[56] = (T)(img)(_p11##x,_p11##y,z,c)), \
 (I[83] = (T)(img)(_p11##x,_p10##y,z,c)), \
 (I[110] = (T)(img)(_p11##x,_p9##y,z,c)), \
 (I[137] = (T)(img)(_p11##x,_p8##y,z,c)), \
 (I[164] = (T)(img)(_p11##x,_p7##y,z,c)), \
 (I[191] = (T)(img)(_p11##x,_p6##y,z,c)), \
 (I[218] = (T)(img)(_p11##x,_p5##y,z,c)), \
 (I[245] = (T)(img)(_p11##x,_p4##y,z,c)), \
 (I[272] = (T)(img)(_p11##x,_p3##y,z,c)), \
 (I[299] = (T)(img)(_p11##x,_p2##y,z,c)), \
 (I[326] = (T)(img)(_p11##x,_p1##y,z,c)), \
 (I[353] = (T)(img)(_p11##x,y,z,c)), \
 (I[380] = (T)(img)(_p11##x,_n1##y,z,c)), \
 (I[407] = (T)(img)(_p11##x,_n2##y,z,c)), \
 (I[434] = (T)(img)(_p11##x,_n3##y,z,c)), \
 (I[461] = (T)(img)(_p11##x,_n4##y,z,c)), \
 (I[488] = (T)(img)(_p11##x,_n5##y,z,c)), \
 (I[515] = (T)(img)(_p11##x,_n6##y,z,c)), \
 (I[542] = (T)(img)(_p11##x,_n7##y,z,c)), \
 (I[569] = (T)(img)(_p11##x,_n8##y,z,c)), \
 (I[596] = (T)(img)(_p11##x,_n9##y,z,c)), \
 (I[623] = (T)(img)(_p11##x,_n10##y,z,c)), \
 (I[650] = (T)(img)(_p11##x,_n11##y,z,c)), \
 (I[677] = (T)(img)(_p11##x,_n12##y,z,c)), \
 (I[704] = (T)(img)(_p11##x,_n13##y,z,c)), \
 (I[3] = (T)(img)(_p10##x,_p13##y,z,c)), \
 (I[30] = (T)(img)(_p10##x,_p12##y,z,c)), \
 (I[57] = (T)(img)(_p10##x,_p11##y,z,c)), \
 (I[84] = (T)(img)(_p10##x,_p10##y,z,c)), \
 (I[111] = (T)(img)(_p10##x,_p9##y,z,c)), \
 (I[138] = (T)(img)(_p10##x,_p8##y,z,c)), \
 (I[165] = (T)(img)(_p10##x,_p7##y,z,c)), \
 (I[192] = (T)(img)(_p10##x,_p6##y,z,c)), \
 (I[219] = (T)(img)(_p10##x,_p5##y,z,c)), \
 (I[246] = (T)(img)(_p10##x,_p4##y,z,c)), \
 (I[273] = (T)(img)(_p10##x,_p3##y,z,c)), \
 (I[300] = (T)(img)(_p10##x,_p2##y,z,c)), \
 (I[327] = (T)(img)(_p10##x,_p1##y,z,c)), \
 (I[354] = (T)(img)(_p10##x,y,z,c)), \
 (I[381] = (T)(img)(_p10##x,_n1##y,z,c)), \
 (I[408] = (T)(img)(_p10##x,_n2##y,z,c)), \
 (I[435] = (T)(img)(_p10##x,_n3##y,z,c)), \
 (I[462] = (T)(img)(_p10##x,_n4##y,z,c)), \
 (I[489] = (T)(img)(_p10##x,_n5##y,z,c)), \
 (I[516] = (T)(img)(_p10##x,_n6##y,z,c)), \
 (I[543] = (T)(img)(_p10##x,_n7##y,z,c)), \
 (I[570] = (T)(img)(_p10##x,_n8##y,z,c)), \
 (I[597] = (T)(img)(_p10##x,_n9##y,z,c)), \
 (I[624] = (T)(img)(_p10##x,_n10##y,z,c)), \
 (I[651] = (T)(img)(_p10##x,_n11##y,z,c)), \
 (I[678] = (T)(img)(_p10##x,_n12##y,z,c)), \
 (I[705] = (T)(img)(_p10##x,_n13##y,z,c)), \
 (I[4] = (T)(img)(_p9##x,_p13##y,z,c)), \
 (I[31] = (T)(img)(_p9##x,_p12##y,z,c)), \
 (I[58] = (T)(img)(_p9##x,_p11##y,z,c)), \
 (I[85] = (T)(img)(_p9##x,_p10##y,z,c)), \
 (I[112] = (T)(img)(_p9##x,_p9##y,z,c)), \
 (I[139] = (T)(img)(_p9##x,_p8##y,z,c)), \
 (I[166] = (T)(img)(_p9##x,_p7##y,z,c)), \
 (I[193] = (T)(img)(_p9##x,_p6##y,z,c)), \
 (I[220] = (T)(img)(_p9##x,_p5##y,z,c)), \
 (I[247] = (T)(img)(_p9##x,_p4##y,z,c)), \
 (I[274] = (T)(img)(_p9##x,_p3##y,z,c)), \
 (I[301] = (T)(img)(_p9##x,_p2##y,z,c)), \
 (I[328] = (T)(img)(_p9##x,_p1##y,z,c)), \
 (I[355] = (T)(img)(_p9##x,y,z,c)), \
 (I[382] = (T)(img)(_p9##x,_n1##y,z,c)), \
 (I[409] = (T)(img)(_p9##x,_n2##y,z,c)), \
 (I[436] = (T)(img)(_p9##x,_n3##y,z,c)), \
 (I[463] = (T)(img)(_p9##x,_n4##y,z,c)), \
 (I[490] = (T)(img)(_p9##x,_n5##y,z,c)), \
 (I[517] = (T)(img)(_p9##x,_n6##y,z,c)), \
 (I[544] = (T)(img)(_p9##x,_n7##y,z,c)), \
 (I[571] = (T)(img)(_p9##x,_n8##y,z,c)), \
 (I[598] = (T)(img)(_p9##x,_n9##y,z,c)), \
 (I[625] = (T)(img)(_p9##x,_n10##y,z,c)), \
 (I[652] = (T)(img)(_p9##x,_n11##y,z,c)), \
 (I[679] = (T)(img)(_p9##x,_n12##y,z,c)), \
 (I[706] = (T)(img)(_p9##x,_n13##y,z,c)), \
 (I[5] = (T)(img)(_p8##x,_p13##y,z,c)), \
 (I[32] = (T)(img)(_p8##x,_p12##y,z,c)), \
 (I[59] = (T)(img)(_p8##x,_p11##y,z,c)), \
 (I[86] = (T)(img)(_p8##x,_p10##y,z,c)), \
 (I[113] = (T)(img)(_p8##x,_p9##y,z,c)), \
 (I[140] = (T)(img)(_p8##x,_p8##y,z,c)), \
 (I[167] = (T)(img)(_p8##x,_p7##y,z,c)), \
 (I[194] = (T)(img)(_p8##x,_p6##y,z,c)), \
 (I[221] = (T)(img)(_p8##x,_p5##y,z,c)), \
 (I[248] = (T)(img)(_p8##x,_p4##y,z,c)), \
 (I[275] = (T)(img)(_p8##x,_p3##y,z,c)), \
 (I[302] = (T)(img)(_p8##x,_p2##y,z,c)), \
 (I[329] = (T)(img)(_p8##x,_p1##y,z,c)), \
 (I[356] = (T)(img)(_p8##x,y,z,c)), \
 (I[383] = (T)(img)(_p8##x,_n1##y,z,c)), \
 (I[410] = (T)(img)(_p8##x,_n2##y,z,c)), \
 (I[437] = (T)(img)(_p8##x,_n3##y,z,c)), \
 (I[464] = (T)(img)(_p8##x,_n4##y,z,c)), \
 (I[491] = (T)(img)(_p8##x,_n5##y,z,c)), \
 (I[518] = (T)(img)(_p8##x,_n6##y,z,c)), \
 (I[545] = (T)(img)(_p8##x,_n7##y,z,c)), \
 (I[572] = (T)(img)(_p8##x,_n8##y,z,c)), \
 (I[599] = (T)(img)(_p8##x,_n9##y,z,c)), \
 (I[626] = (T)(img)(_p8##x,_n10##y,z,c)), \
 (I[653] = (T)(img)(_p8##x,_n11##y,z,c)), \
 (I[680] = (T)(img)(_p8##x,_n12##y,z,c)), \
 (I[707] = (T)(img)(_p8##x,_n13##y,z,c)), \
 (I[6] = (T)(img)(_p7##x,_p13##y,z,c)), \
 (I[33] = (T)(img)(_p7##x,_p12##y,z,c)), \
 (I[60] = (T)(img)(_p7##x,_p11##y,z,c)), \
 (I[87] = (T)(img)(_p7##x,_p10##y,z,c)), \
 (I[114] = (T)(img)(_p7##x,_p9##y,z,c)), \
 (I[141] = (T)(img)(_p7##x,_p8##y,z,c)), \
 (I[168] = (T)(img)(_p7##x,_p7##y,z,c)), \
 (I[195] = (T)(img)(_p7##x,_p6##y,z,c)), \
 (I[222] = (T)(img)(_p7##x,_p5##y,z,c)), \
 (I[249] = (T)(img)(_p7##x,_p4##y,z,c)), \
 (I[276] = (T)(img)(_p7##x,_p3##y,z,c)), \
 (I[303] = (T)(img)(_p7##x,_p2##y,z,c)), \
 (I[330] = (T)(img)(_p7##x,_p1##y,z,c)), \
 (I[357] = (T)(img)(_p7##x,y,z,c)), \
 (I[384] = (T)(img)(_p7##x,_n1##y,z,c)), \
 (I[411] = (T)(img)(_p7##x,_n2##y,z,c)), \
 (I[438] = (T)(img)(_p7##x,_n3##y,z,c)), \
 (I[465] = (T)(img)(_p7##x,_n4##y,z,c)), \
 (I[492] = (T)(img)(_p7##x,_n5##y,z,c)), \
 (I[519] = (T)(img)(_p7##x,_n6##y,z,c)), \
 (I[546] = (T)(img)(_p7##x,_n7##y,z,c)), \
 (I[573] = (T)(img)(_p7##x,_n8##y,z,c)), \
 (I[600] = (T)(img)(_p7##x,_n9##y,z,c)), \
 (I[627] = (T)(img)(_p7##x,_n10##y,z,c)), \
 (I[654] = (T)(img)(_p7##x,_n11##y,z,c)), \
 (I[681] = (T)(img)(_p7##x,_n12##y,z,c)), \
 (I[708] = (T)(img)(_p7##x,_n13##y,z,c)), \
 (I[7] = (T)(img)(_p6##x,_p13##y,z,c)), \
 (I[34] = (T)(img)(_p6##x,_p12##y,z,c)), \
 (I[61] = (T)(img)(_p6##x,_p11##y,z,c)), \
 (I[88] = (T)(img)(_p6##x,_p10##y,z,c)), \
 (I[115] = (T)(img)(_p6##x,_p9##y,z,c)), \
 (I[142] = (T)(img)(_p6##x,_p8##y,z,c)), \
 (I[169] = (T)(img)(_p6##x,_p7##y,z,c)), \
 (I[196] = (T)(img)(_p6##x,_p6##y,z,c)), \
 (I[223] = (T)(img)(_p6##x,_p5##y,z,c)), \
 (I[250] = (T)(img)(_p6##x,_p4##y,z,c)), \
 (I[277] = (T)(img)(_p6##x,_p3##y,z,c)), \
 (I[304] = (T)(img)(_p6##x,_p2##y,z,c)), \
 (I[331] = (T)(img)(_p6##x,_p1##y,z,c)), \
 (I[358] = (T)(img)(_p6##x,y,z,c)), \
 (I[385] = (T)(img)(_p6##x,_n1##y,z,c)), \
 (I[412] = (T)(img)(_p6##x,_n2##y,z,c)), \
 (I[439] = (T)(img)(_p6##x,_n3##y,z,c)), \
 (I[466] = (T)(img)(_p6##x,_n4##y,z,c)), \
 (I[493] = (T)(img)(_p6##x,_n5##y,z,c)), \
 (I[520] = (T)(img)(_p6##x,_n6##y,z,c)), \
 (I[547] = (T)(img)(_p6##x,_n7##y,z,c)), \
 (I[574] = (T)(img)(_p6##x,_n8##y,z,c)), \
 (I[601] = (T)(img)(_p6##x,_n9##y,z,c)), \
 (I[628] = (T)(img)(_p6##x,_n10##y,z,c)), \
 (I[655] = (T)(img)(_p6##x,_n11##y,z,c)), \
 (I[682] = (T)(img)(_p6##x,_n12##y,z,c)), \
 (I[709] = (T)(img)(_p6##x,_n13##y,z,c)), \
 (I[8] = (T)(img)(_p5##x,_p13##y,z,c)), \
 (I[35] = (T)(img)(_p5##x,_p12##y,z,c)), \
 (I[62] = (T)(img)(_p5##x,_p11##y,z,c)), \
 (I[89] = (T)(img)(_p5##x,_p10##y,z,c)), \
 (I[116] = (T)(img)(_p5##x,_p9##y,z,c)), \
 (I[143] = (T)(img)(_p5##x,_p8##y,z,c)), \
 (I[170] = (T)(img)(_p5##x,_p7##y,z,c)), \
 (I[197] = (T)(img)(_p5##x,_p6##y,z,c)), \
 (I[224] = (T)(img)(_p5##x,_p5##y,z,c)), \
 (I[251] = (T)(img)(_p5##x,_p4##y,z,c)), \
 (I[278] = (T)(img)(_p5##x,_p3##y,z,c)), \
 (I[305] = (T)(img)(_p5##x,_p2##y,z,c)), \
 (I[332] = (T)(img)(_p5##x,_p1##y,z,c)), \
 (I[359] = (T)(img)(_p5##x,y,z,c)), \
 (I[386] = (T)(img)(_p5##x,_n1##y,z,c)), \
 (I[413] = (T)(img)(_p5##x,_n2##y,z,c)), \
 (I[440] = (T)(img)(_p5##x,_n3##y,z,c)), \
 (I[467] = (T)(img)(_p5##x,_n4##y,z,c)), \
 (I[494] = (T)(img)(_p5##x,_n5##y,z,c)), \
 (I[521] = (T)(img)(_p5##x,_n6##y,z,c)), \
 (I[548] = (T)(img)(_p5##x,_n7##y,z,c)), \
 (I[575] = (T)(img)(_p5##x,_n8##y,z,c)), \
 (I[602] = (T)(img)(_p5##x,_n9##y,z,c)), \
 (I[629] = (T)(img)(_p5##x,_n10##y,z,c)), \
 (I[656] = (T)(img)(_p5##x,_n11##y,z,c)), \
 (I[683] = (T)(img)(_p5##x,_n12##y,z,c)), \
 (I[710] = (T)(img)(_p5##x,_n13##y,z,c)), \
 (I[9] = (T)(img)(_p4##x,_p13##y,z,c)), \
 (I[36] = (T)(img)(_p4##x,_p12##y,z,c)), \
 (I[63] = (T)(img)(_p4##x,_p11##y,z,c)), \
 (I[90] = (T)(img)(_p4##x,_p10##y,z,c)), \
 (I[117] = (T)(img)(_p4##x,_p9##y,z,c)), \
 (I[144] = (T)(img)(_p4##x,_p8##y,z,c)), \
 (I[171] = (T)(img)(_p4##x,_p7##y,z,c)), \
 (I[198] = (T)(img)(_p4##x,_p6##y,z,c)), \
 (I[225] = (T)(img)(_p4##x,_p5##y,z,c)), \
 (I[252] = (T)(img)(_p4##x,_p4##y,z,c)), \
 (I[279] = (T)(img)(_p4##x,_p3##y,z,c)), \
 (I[306] = (T)(img)(_p4##x,_p2##y,z,c)), \
 (I[333] = (T)(img)(_p4##x,_p1##y,z,c)), \
 (I[360] = (T)(img)(_p4##x,y,z,c)), \
 (I[387] = (T)(img)(_p4##x,_n1##y,z,c)), \
 (I[414] = (T)(img)(_p4##x,_n2##y,z,c)), \
 (I[441] = (T)(img)(_p4##x,_n3##y,z,c)), \
 (I[468] = (T)(img)(_p4##x,_n4##y,z,c)), \
 (I[495] = (T)(img)(_p4##x,_n5##y,z,c)), \
 (I[522] = (T)(img)(_p4##x,_n6##y,z,c)), \
 (I[549] = (T)(img)(_p4##x,_n7##y,z,c)), \
 (I[576] = (T)(img)(_p4##x,_n8##y,z,c)), \
 (I[603] = (T)(img)(_p4##x,_n9##y,z,c)), \
 (I[630] = (T)(img)(_p4##x,_n10##y,z,c)), \
 (I[657] = (T)(img)(_p4##x,_n11##y,z,c)), \
 (I[684] = (T)(img)(_p4##x,_n12##y,z,c)), \
 (I[711] = (T)(img)(_p4##x,_n13##y,z,c)), \
 (I[10] = (T)(img)(_p3##x,_p13##y,z,c)), \
 (I[37] = (T)(img)(_p3##x,_p12##y,z,c)), \
 (I[64] = (T)(img)(_p3##x,_p11##y,z,c)), \
 (I[91] = (T)(img)(_p3##x,_p10##y,z,c)), \
 (I[118] = (T)(img)(_p3##x,_p9##y,z,c)), \
 (I[145] = (T)(img)(_p3##x,_p8##y,z,c)), \
 (I[172] = (T)(img)(_p3##x,_p7##y,z,c)), \
 (I[199] = (T)(img)(_p3##x,_p6##y,z,c)), \
 (I[226] = (T)(img)(_p3##x,_p5##y,z,c)), \
 (I[253] = (T)(img)(_p3##x,_p4##y,z,c)), \
 (I[280] = (T)(img)(_p3##x,_p3##y,z,c)), \
 (I[307] = (T)(img)(_p3##x,_p2##y,z,c)), \
 (I[334] = (T)(img)(_p3##x,_p1##y,z,c)), \
 (I[361] = (T)(img)(_p3##x,y,z,c)), \
 (I[388] = (T)(img)(_p3##x,_n1##y,z,c)), \
 (I[415] = (T)(img)(_p3##x,_n2##y,z,c)), \
 (I[442] = (T)(img)(_p3##x,_n3##y,z,c)), \
 (I[469] = (T)(img)(_p3##x,_n4##y,z,c)), \
 (I[496] = (T)(img)(_p3##x,_n5##y,z,c)), \
 (I[523] = (T)(img)(_p3##x,_n6##y,z,c)), \
 (I[550] = (T)(img)(_p3##x,_n7##y,z,c)), \
 (I[577] = (T)(img)(_p3##x,_n8##y,z,c)), \
 (I[604] = (T)(img)(_p3##x,_n9##y,z,c)), \
 (I[631] = (T)(img)(_p3##x,_n10##y,z,c)), \
 (I[658] = (T)(img)(_p3##x,_n11##y,z,c)), \
 (I[685] = (T)(img)(_p3##x,_n12##y,z,c)), \
 (I[712] = (T)(img)(_p3##x,_n13##y,z,c)), \
 (I[11] = (T)(img)(_p2##x,_p13##y,z,c)), \
 (I[38] = (T)(img)(_p2##x,_p12##y,z,c)), \
 (I[65] = (T)(img)(_p2##x,_p11##y,z,c)), \
 (I[92] = (T)(img)(_p2##x,_p10##y,z,c)), \
 (I[119] = (T)(img)(_p2##x,_p9##y,z,c)), \
 (I[146] = (T)(img)(_p2##x,_p8##y,z,c)), \
 (I[173] = (T)(img)(_p2##x,_p7##y,z,c)), \
 (I[200] = (T)(img)(_p2##x,_p6##y,z,c)), \
 (I[227] = (T)(img)(_p2##x,_p5##y,z,c)), \
 (I[254] = (T)(img)(_p2##x,_p4##y,z,c)), \
 (I[281] = (T)(img)(_p2##x,_p3##y,z,c)), \
 (I[308] = (T)(img)(_p2##x,_p2##y,z,c)), \
 (I[335] = (T)(img)(_p2##x,_p1##y,z,c)), \
 (I[362] = (T)(img)(_p2##x,y,z,c)), \
 (I[389] = (T)(img)(_p2##x,_n1##y,z,c)), \
 (I[416] = (T)(img)(_p2##x,_n2##y,z,c)), \
 (I[443] = (T)(img)(_p2##x,_n3##y,z,c)), \
 (I[470] = (T)(img)(_p2##x,_n4##y,z,c)), \
 (I[497] = (T)(img)(_p2##x,_n5##y,z,c)), \
 (I[524] = (T)(img)(_p2##x,_n6##y,z,c)), \
 (I[551] = (T)(img)(_p2##x,_n7##y,z,c)), \
 (I[578] = (T)(img)(_p2##x,_n8##y,z,c)), \
 (I[605] = (T)(img)(_p2##x,_n9##y,z,c)), \
 (I[632] = (T)(img)(_p2##x,_n10##y,z,c)), \
 (I[659] = (T)(img)(_p2##x,_n11##y,z,c)), \
 (I[686] = (T)(img)(_p2##x,_n12##y,z,c)), \
 (I[713] = (T)(img)(_p2##x,_n13##y,z,c)), \
 (I[12] = (T)(img)(_p1##x,_p13##y,z,c)), \
 (I[39] = (T)(img)(_p1##x,_p12##y,z,c)), \
 (I[66] = (T)(img)(_p1##x,_p11##y,z,c)), \
 (I[93] = (T)(img)(_p1##x,_p10##y,z,c)), \
 (I[120] = (T)(img)(_p1##x,_p9##y,z,c)), \
 (I[147] = (T)(img)(_p1##x,_p8##y,z,c)), \
 (I[174] = (T)(img)(_p1##x,_p7##y,z,c)), \
 (I[201] = (T)(img)(_p1##x,_p6##y,z,c)), \
 (I[228] = (T)(img)(_p1##x,_p5##y,z,c)), \
 (I[255] = (T)(img)(_p1##x,_p4##y,z,c)), \
 (I[282] = (T)(img)(_p1##x,_p3##y,z,c)), \
 (I[309] = (T)(img)(_p1##x,_p2##y,z,c)), \
 (I[336] = (T)(img)(_p1##x,_p1##y,z,c)), \
 (I[363] = (T)(img)(_p1##x,y,z,c)), \
 (I[390] = (T)(img)(_p1##x,_n1##y,z,c)), \
 (I[417] = (T)(img)(_p1##x,_n2##y,z,c)), \
 (I[444] = (T)(img)(_p1##x,_n3##y,z,c)), \
 (I[471] = (T)(img)(_p1##x,_n4##y,z,c)), \
 (I[498] = (T)(img)(_p1##x,_n5##y,z,c)), \
 (I[525] = (T)(img)(_p1##x,_n6##y,z,c)), \
 (I[552] = (T)(img)(_p1##x,_n7##y,z,c)), \
 (I[579] = (T)(img)(_p1##x,_n8##y,z,c)), \
 (I[606] = (T)(img)(_p1##x,_n9##y,z,c)), \
 (I[633] = (T)(img)(_p1##x,_n10##y,z,c)), \
 (I[660] = (T)(img)(_p1##x,_n11##y,z,c)), \
 (I[687] = (T)(img)(_p1##x,_n12##y,z,c)), \
 (I[714] = (T)(img)(_p1##x,_n13##y,z,c)), \
 (I[13] = (T)(img)(x,_p13##y,z,c)), \
 (I[40] = (T)(img)(x,_p12##y,z,c)), \
 (I[67] = (T)(img)(x,_p11##y,z,c)), \
 (I[94] = (T)(img)(x,_p10##y,z,c)), \
 (I[121] = (T)(img)(x,_p9##y,z,c)), \
 (I[148] = (T)(img)(x,_p8##y,z,c)), \
 (I[175] = (T)(img)(x,_p7##y,z,c)), \
 (I[202] = (T)(img)(x,_p6##y,z,c)), \
 (I[229] = (T)(img)(x,_p5##y,z,c)), \
 (I[256] = (T)(img)(x,_p4##y,z,c)), \
 (I[283] = (T)(img)(x,_p3##y,z,c)), \
 (I[310] = (T)(img)(x,_p2##y,z,c)), \
 (I[337] = (T)(img)(x,_p1##y,z,c)), \
 (I[364] = (T)(img)(x,y,z,c)), \
 (I[391] = (T)(img)(x,_n1##y,z,c)), \
 (I[418] = (T)(img)(x,_n2##y,z,c)), \
 (I[445] = (T)(img)(x,_n3##y,z,c)), \
 (I[472] = (T)(img)(x,_n4##y,z,c)), \
 (I[499] = (T)(img)(x,_n5##y,z,c)), \
 (I[526] = (T)(img)(x,_n6##y,z,c)), \
 (I[553] = (T)(img)(x,_n7##y,z,c)), \
 (I[580] = (T)(img)(x,_n8##y,z,c)), \
 (I[607] = (T)(img)(x,_n9##y,z,c)), \
 (I[634] = (T)(img)(x,_n10##y,z,c)), \
 (I[661] = (T)(img)(x,_n11##y,z,c)), \
 (I[688] = (T)(img)(x,_n12##y,z,c)), \
 (I[715] = (T)(img)(x,_n13##y,z,c)), \
 (I[14] = (T)(img)(_n1##x,_p13##y,z,c)), \
 (I[41] = (T)(img)(_n1##x,_p12##y,z,c)), \
 (I[68] = (T)(img)(_n1##x,_p11##y,z,c)), \
 (I[95] = (T)(img)(_n1##x,_p10##y,z,c)), \
 (I[122] = (T)(img)(_n1##x,_p9##y,z,c)), \
 (I[149] = (T)(img)(_n1##x,_p8##y,z,c)), \
 (I[176] = (T)(img)(_n1##x,_p7##y,z,c)), \
 (I[203] = (T)(img)(_n1##x,_p6##y,z,c)), \
 (I[230] = (T)(img)(_n1##x,_p5##y,z,c)), \
 (I[257] = (T)(img)(_n1##x,_p4##y,z,c)), \
 (I[284] = (T)(img)(_n1##x,_p3##y,z,c)), \
 (I[311] = (T)(img)(_n1##x,_p2##y,z,c)), \
 (I[338] = (T)(img)(_n1##x,_p1##y,z,c)), \
 (I[365] = (T)(img)(_n1##x,y,z,c)), \
 (I[392] = (T)(img)(_n1##x,_n1##y,z,c)), \
 (I[419] = (T)(img)(_n1##x,_n2##y,z,c)), \
 (I[446] = (T)(img)(_n1##x,_n3##y,z,c)), \
 (I[473] = (T)(img)(_n1##x,_n4##y,z,c)), \
 (I[500] = (T)(img)(_n1##x,_n5##y,z,c)), \
 (I[527] = (T)(img)(_n1##x,_n6##y,z,c)), \
 (I[554] = (T)(img)(_n1##x,_n7##y,z,c)), \
 (I[581] = (T)(img)(_n1##x,_n8##y,z,c)), \
 (I[608] = (T)(img)(_n1##x,_n9##y,z,c)), \
 (I[635] = (T)(img)(_n1##x,_n10##y,z,c)), \
 (I[662] = (T)(img)(_n1##x,_n11##y,z,c)), \
 (I[689] = (T)(img)(_n1##x,_n12##y,z,c)), \
 (I[716] = (T)(img)(_n1##x,_n13##y,z,c)), \
 (I[15] = (T)(img)(_n2##x,_p13##y,z,c)), \
 (I[42] = (T)(img)(_n2##x,_p12##y,z,c)), \
 (I[69] = (T)(img)(_n2##x,_p11##y,z,c)), \
 (I[96] = (T)(img)(_n2##x,_p10##y,z,c)), \
 (I[123] = (T)(img)(_n2##x,_p9##y,z,c)), \
 (I[150] = (T)(img)(_n2##x,_p8##y,z,c)), \
 (I[177] = (T)(img)(_n2##x,_p7##y,z,c)), \
 (I[204] = (T)(img)(_n2##x,_p6##y,z,c)), \
 (I[231] = (T)(img)(_n2##x,_p5##y,z,c)), \
 (I[258] = (T)(img)(_n2##x,_p4##y,z,c)), \
 (I[285] = (T)(img)(_n2##x,_p3##y,z,c)), \
 (I[312] = (T)(img)(_n2##x,_p2##y,z,c)), \
 (I[339] = (T)(img)(_n2##x,_p1##y,z,c)), \
 (I[366] = (T)(img)(_n2##x,y,z,c)), \
 (I[393] = (T)(img)(_n2##x,_n1##y,z,c)), \
 (I[420] = (T)(img)(_n2##x,_n2##y,z,c)), \
 (I[447] = (T)(img)(_n2##x,_n3##y,z,c)), \
 (I[474] = (T)(img)(_n2##x,_n4##y,z,c)), \
 (I[501] = (T)(img)(_n2##x,_n5##y,z,c)), \
 (I[528] = (T)(img)(_n2##x,_n6##y,z,c)), \
 (I[555] = (T)(img)(_n2##x,_n7##y,z,c)), \
 (I[582] = (T)(img)(_n2##x,_n8##y,z,c)), \
 (I[609] = (T)(img)(_n2##x,_n9##y,z,c)), \
 (I[636] = (T)(img)(_n2##x,_n10##y,z,c)), \
 (I[663] = (T)(img)(_n2##x,_n11##y,z,c)), \
 (I[690] = (T)(img)(_n2##x,_n12##y,z,c)), \
 (I[717] = (T)(img)(_n2##x,_n13##y,z,c)), \
 (I[16] = (T)(