/* Generated from tcp.scm by the CHICKEN compiler
   http://www.call-cc.org
   2016-05-28 13:48
   Version 4.11.0 (rev ce980c4)
   linux-unix-gnu-x86-64 [ 64bit manyargs ptables ]
   compiled 2016-05-28 on yves.more-magic.net (Linux)
   command line: tcp.scm -optimize-level 2 -include-path . -include-path ./ -inline -ignore-repository -feature chicken-bootstrap -no-warnings -specialize -types ./types.db -explicit-use -no-trace -output-file tcp.c
   unit: tcp
*/

#include "chicken.h"

#ifdef _WIN32
# include <winsock2.h>
# include <ws2tcpip.h>
/* Beware: winsock2.h must come BEFORE windows.h */
# define socklen_t	 int
static WSADATA wsa;
# ifndef SHUT_RD
#  define SHUT_RD	  SD_RECEIVE
# endif
# ifndef SHUT_WR
#  define SHUT_WR	  SD_SEND
# endif

# define typecorrect_getsockopt(socket, level, optname, optval, optlen)	\
    getsockopt(socket, level, optname, (char *)optval, optlen)

static C_word make_socket_nonblocking (C_word sock) {
  int fd = C_unfix(sock);
  C_return(C_mk_bool(ioctlsocket(fd, FIONBIO, (void *)&fd) != SOCKET_ERROR)) ;
}

/* This is a bit of a hack, but it keeps things simple */
static C_TLS char *last_wsa_errorstring = NULL;

static char *errormsg_from_code(int code) {
  int bufsize;
  if (last_wsa_errorstring != NULL) {
    LocalFree(last_wsa_errorstring);
    last_wsa_errorstring = NULL;
  }
  bufsize = FormatMessage(
	FORMAT_MESSAGE_ALLOCATE_BUFFER |
	FORMAT_MESSAGE_FROM_SYSTEM |
	FORMAT_MESSAGE_IGNORE_INSERTS,
	NULL, code, MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),
	(LPTSTR) &last_wsa_errorstring, 0, NULL);
  if (bufsize == 0) return "ERROR WHILE FETCHING ERROR";
  return last_wsa_errorstring;
}

# define get_last_socket_error()  WSAGetLastError()
# define should_retry_call()      (WSAGetLastError() == WSAEWOULDBLOCK)
/* Not EINPROGRESS in winsock.  Nonblocking connect returns EWOULDBLOCK... */
# define call_in_progress()       (WSAGetLastError() == WSAEWOULDBLOCK)
# define call_was_interrupted()   (WSAGetLastError() == WSAEINTR) /* ? */

#else
# include <errno.h>
# include <fcntl.h>
# include <sys/socket.h>
# include <sys/time.h>
# include <netinet/in.h>
# include <netdb.h>
# include <signal.h>
# define closesocket     close
# define INVALID_SOCKET  -1
# define SOCKET_ERROR    -1
# define typecorrect_getsockopt getsockopt

static C_word make_socket_nonblocking (C_word sock) {
  int fd = C_unfix(sock);
  int val = fcntl(fd, F_GETFL, 0);
  if(val == -1) C_return(C_SCHEME_FALSE);
  C_return(C_mk_bool(fcntl(fd, F_SETFL, val | O_NONBLOCK) != -1));
}

# define get_last_socket_error()  errno
# define errormsg_from_code(e)    strerror(e)

# define should_retry_call()      (errno == EAGAIN || errno == EWOULDBLOCK)
# define call_was_interrupted()   (errno == EINTR)
# define call_in_progress()       (errno == EINPROGRESS)
#endif

#ifdef ECOS
#include <sys/sockio.h>
#endif

#ifndef h_addr
# define h_addr  h_addr_list[ 0 ]
#endif

static char addr_buffer[ 20 ];

static int C_set_socket_options(int socket)
{
  int yes = 1; 
  int r;

  r = setsockopt(socket, SOL_SOCKET, SO_REUSEADDR, (const char *)&yes, sizeof(int));
  
  if(r != 0) return r;

#ifdef SO_NOSIGPIPE
  /*
   * Avoid SIGPIPE (iOS uses *only* SIGPIPE otherwise, not returning EPIPE).
   * For consistency we do this everywhere the option is supported.
   */
  r = setsockopt(socket, SOL_SOCKET, SO_NOSIGPIPE, (const char *)&yes, sizeof(int));
#endif

  return r;
}


static C_PTABLE_ENTRY *create_ptable(void);
C_noret_decl(C_ports_toplevel)
C_externimport void C_ccall C_ports_toplevel(C_word c,C_word *av) C_noret;
C_noret_decl(C_scheduler_toplevel)
C_externimport void C_ccall C_scheduler_toplevel(C_word c,C_word *av) C_noret;

static C_TLS C_word lf[94];
static double C_possibly_force_alignment;
static C_char C_TLS li0[] C_aligned={C_lihdr(0,0,53),40,35,35,110,101,116,35,103,101,116,104,111,115,116,97,100,100,114,32,115,97,100,100,114,50,49,57,50,50,54,32,104,111,115,116,50,50,48,50,50,55,32,112,111,114,116,50,50,49,50,50,56,41,0,0,0};
static C_char C_TLS li1[] C_aligned={C_lihdr(0,0,32),40,116,99,112,45,108,105,115,116,101,110,32,112,111,114,116,51,56,48,32,46,32,116,109,112,51,55,57,51,56,49,41};
static C_char C_TLS li2[] C_aligned={C_lihdr(0,0,20),40,116,99,112,45,108,105,115,116,101,110,101,114,63,32,120,52,48,55,41,0,0,0,0};
static C_char C_TLS li3[] C_aligned={C_lihdr(0,0,19),40,116,99,112,45,99,108,111,115,101,32,116,99,112,108,52,49,48,41,0,0,0,0,0};
static C_char C_TLS li4[] C_aligned={C_lihdr(0,0,13),40,102,95,49,54,49,51,32,120,52,50,51,41,0,0,0};
static C_char C_TLS li5[] C_aligned={C_lihdr(0,0,14),40,99,104,101,99,107,32,108,111,99,52,50,50,41,0,0};
static C_char C_TLS li6[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char C_TLS li7[] C_aligned={C_lihdr(0,0,12),40,114,101,97,100,45,105,110,112,117,116,41,0,0,0,0};
static C_char C_TLS li8[] C_aligned={C_lihdr(0,0,7),40,97,49,56,50,55,41,0};
static C_char C_TLS li9[] C_aligned={C_lihdr(0,0,30),40,108,111,111,112,32,108,101,110,53,51,54,32,111,102,102,115,101,116,53,51,55,32,100,108,119,53,51,56,41,0,0};
static C_char C_TLS li10[] C_aligned={C_lihdr(0,0,13),40,111,117,116,112,117,116,32,115,53,51,51,41,0,0,0};
static C_char C_TLS li11[] C_aligned={C_lihdr(0,0,13),40,102,95,50,48,49,48,32,115,53,54,52,41,0,0,0};
static C_char C_TLS li12[] C_aligned={C_lihdr(0,0,13),40,102,95,50,48,51,48,32,115,53,54,55,41,0,0,0};
static C_char C_TLS li13[] C_aligned={C_lihdr(0,0,7),40,97,49,57,50,51,41,0};
static C_char C_TLS li14[] C_aligned={C_lihdr(0,0,8),40,102,95,49,57,57,52,41};
static C_char C_TLS li15[] C_aligned={C_lihdr(0,0,7),40,97,50,48,52,53,41,0};
static C_char C_TLS li16[] C_aligned={C_lihdr(0,0,7),40,97,50,48,54,55,41,0};
static C_char C_TLS li17[] C_aligned={C_lihdr(0,0,7),40,97,50,49,48,57,41,0};
static C_char C_TLS li18[] C_aligned={C_lihdr(0,0,7),40,97,50,49,53,57,41,0};
static C_char C_TLS li19[] C_aligned={C_lihdr(0,0,25),40,108,111,111,112,32,110,52,57,53,32,109,52,57,54,32,115,116,97,114,116,52,57,55,41,0,0,0,0,0,0,0};
static C_char C_TLS li20[] C_aligned={C_lihdr(0,0,34),40,97,50,49,55,55,32,112,52,57,48,32,110,52,57,49,32,100,101,115,116,52,57,50,32,115,116,97,114,116,52,57,51,41,0,0,0,0,0,0};
static C_char C_TLS li21[] C_aligned={C_lihdr(0,0,14),40,97,50,50,55,48,32,112,111,115,53,49,52,41,0,0};
static C_char C_TLS li22[] C_aligned={C_lihdr(0,0,7),40,97,50,50,54,48,41,0};
static C_char C_TLS li23[] C_aligned={C_lihdr(0,0,37),40,97,50,51,49,54,32,110,101,120,116,53,50,50,32,108,105,110,101,53,50,51,32,102,117,108,108,45,108,105,110,101,63,53,50,52,41,0,0,0};
static C_char C_TLS li24[] C_aligned={C_lihdr(0,0,21),40,97,50,50,52,50,32,112,53,48,56,32,108,105,109,105,116,53,48,57,41,0,0,0};
static C_char C_TLS li25[] C_aligned={C_lihdr(0,0,12),40,97,50,51,54,53,32,112,53,50,57,41,0,0,0,0};
static C_char C_TLS li26[] C_aligned={C_lihdr(0,0,29),40,35,35,110,101,116,35,105,111,45,112,111,114,116,115,32,108,111,99,52,51,50,32,102,100,52,51,51,41,0,0,0};
static C_char C_TLS li27[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char C_TLS li28[] C_aligned={C_lihdr(0,0,20),40,116,99,112,45,97,99,99,101,112,116,32,116,99,112,108,53,56,54,41,0,0,0,0};
static C_char C_TLS li29[] C_aligned={C_lihdr(0,0,27),40,116,99,112,45,97,99,99,101,112,116,45,114,101,97,100,121,63,32,116,99,112,108,54,48,54,41,0,0,0,0,0};
static C_char C_TLS li30[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char C_TLS li31[] C_aligned={C_lihdr(0,0,11),40,108,111,111,112,32,105,51,51,57,41,0,0,0,0,0};
static C_char C_TLS li32[] C_aligned={C_lihdr(0,0,7),40,97,50,56,49,49,41,0};
static C_char C_TLS li33[] C_aligned={C_lihdr(0,0,29),40,97,50,56,49,55,32,104,111,115,116,54,50,57,54,51,49,32,112,111,114,116,54,51,48,54,51,50,41,0,0,0};
static C_char C_TLS li34[] C_aligned={C_lihdr(0,0,31),40,116,99,112,45,99,111,110,110,101,99,116,32,104,111,115,116,54,49,56,32,46,32,109,111,114,101,54,49,57,41,0};
static C_char C_TLS li35[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,116,99,112,45,112,111,114,116,45,62,102,105,108,101,110,111,32,112,54,56,55,41,0,0,0};
static C_char C_TLS li36[] C_aligned={C_lihdr(0,0,20),40,116,99,112,45,97,100,100,114,101,115,115,101,115,32,112,54,57,48,41,0,0,0,0};
static C_char C_TLS li37[] C_aligned={C_lihdr(0,0,23),40,116,99,112,45,112,111,114,116,45,110,117,109,98,101,114,115,32,112,55,48,52,41,0};
static C_char C_TLS li38[] C_aligned={C_lihdr(0,0,27),40,116,99,112,45,108,105,115,116,101,110,101,114,45,112,111,114,116,32,116,99,112,108,55,49,54,41,0,0,0,0,0};
static C_char C_TLS li39[] C_aligned={C_lihdr(0,0,23),40,116,99,112,45,97,98,97,110,100,111,110,45,112,111,114,116,32,112,55,50,52,41,0};
static C_char C_TLS li40[] C_aligned={C_lihdr(0,0,26),40,116,99,112,45,108,105,115,116,101,110,101,114,45,102,105,108,101,110,111,32,108,55,50,55,41,0,0,0,0,0,0};
static C_char C_TLS li41[] C_aligned={C_lihdr(0,0,10),40,116,111,112,108,101,118,101,108,41,0,0,0,0,0,0};


#define return(x) C_cblock C_r = (C_fix((C_word)(x))); goto C_ret; C_cblockend
C_regparm static C_word C_fcall stub614(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int socket=(int )C_unfix(C_a0);
int err, optlen;optlen = sizeof(err);if (typecorrect_getsockopt(socket, SOL_SOCKET, SO_ERROR, &err, (socklen_t *)&optlen) == SOCKET_ERROR)  C_return(SOCKET_ERROR);C_return(err);
C_ret:
#undef return

return C_r;}

#define return(x) C_cblock C_r = (((C_word)(x))); goto C_ret; C_cblockend
C_regparm static C_word C_fcall stub350(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * saddr=(void * )C_data_pointer_or_null(C_a0);
unsigned short port=(unsigned short )(unsigned short)C_unfix(C_a1);
struct sockaddr_in *addr = (struct sockaddr_in *)saddr;memset(addr, 0, sizeof(struct sockaddr_in));addr->sin_family = AF_INET;addr->sin_port = htons(port);addr->sin_addr.s_addr = htonl(INADDR_ANY);
C_ret:
#undef return

return C_r;}

#define return(x) C_cblock C_r = (C_mk_bool((x))); goto C_ret; C_cblockend
C_regparm static C_word C_fcall stub222(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * saddr=(void * )C_data_pointer_or_null(C_a0);
char * host=(char * )C_string_or_null(C_a1);
unsigned short port=(unsigned short )(unsigned short)C_unfix(C_a2);
struct hostent *he = gethostbyname(host);struct sockaddr_in *addr = (struct sockaddr_in *)saddr;if(he == NULL) C_return(0);memset(addr, 0, sizeof(struct sockaddr_in));addr->sin_family = AF_INET;addr->sin_port = htons((short)port);addr->sin_addr = *((struct in_addr *)he->h_addr);C_return(1);
C_ret:
#undef return

return C_r;}

#define return(x) C_cblock C_r = (C_fix((C_word)(x))); goto C_ret; C_cblockend
C_regparm static C_word C_fcall stub210(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * serv=(char * )C_string_or_null(C_a0);
char * proto=(char * )C_string_or_null(C_a1);
struct servent *se;
     if((se = getservbyname(serv, proto)) == NULL) C_return(0);
     else C_return(ntohs(se->s_port));
C_ret:
#undef return

return C_r;}

#define return(x) C_cblock C_r = (C_mk_bool((x))); goto C_ret; C_cblockend
C_regparm static C_word C_fcall stub205(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
#ifdef _WIN32
     C_return(WSAStartup(MAKEWORD(1, 1), &wsa) == 0);
#else
     signal(SIGPIPE, SIG_IGN);
     C_return(1);
#endif
C_ret:
#undef return

return C_r;}

#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_ret; C_cblockend
C_regparm static C_word C_fcall stub200(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int s=(int )C_unfix(C_a0);
struct sockaddr_in sa;unsigned char *ptr;unsigned int len = sizeof(struct sockaddr_in);if(getpeername(s, (struct sockaddr *)&sa, ((socklen_t *)&len)) != 0) C_return(NULL);ptr = (unsigned char *)&sa.sin_addr;C_snprintf(addr_buffer, sizeof(addr_buffer), "%d.%d.%d.%d", ptr[ 0 ], ptr[ 1 ], ptr[ 2 ], ptr[ 3 ]);C_return(addr_buffer);
C_ret:
#undef return

return C_r;}

#define return(x) C_cblock C_r = (C_fix((C_word)(x))); goto C_ret; C_cblockend
C_regparm static C_word C_fcall stub195(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int s=(int )C_unfix(C_a0);
struct sockaddr_in sa;int len = sizeof(struct sockaddr_in);if(getpeername(s, (struct sockaddr *)&sa, (socklen_t *)(&len)) != 0) C_return(-1);else C_return(ntohs(sa.sin_port));
C_ret:
#undef return

return C_r;}

#define return(x) C_cblock C_r = (C_fix((C_word)(x))); goto C_ret; C_cblockend
C_regparm static C_word C_fcall stub190(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int s=(int )C_unfix(C_a0);
struct sockaddr_in sa;int len = sizeof(struct sockaddr_in);if(getsockname(s, (struct sockaddr *)&sa, (socklen_t *)(&len)) != 0) C_return(-1);else C_return(ntohs(sa.sin_port));
C_ret:
#undef return

return C_r;}

#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_ret; C_cblockend
C_regparm static C_word C_fcall stub184(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int s=(int )C_unfix(C_a0);
struct sockaddr_in sa;unsigned char *ptr;int len = sizeof(struct sockaddr_in);if(getsockname(s, (struct sockaddr *)&sa, (socklen_t *)&len) != 0) C_return(NULL);ptr = (unsigned char *)&sa.sin_addr;C_snprintf(addr_buffer, sizeof(addr_buffer), "%d.%d.%d.%d", ptr[ 0 ], ptr[ 1 ], ptr[ 2 ], ptr[ 3 ]);C_return(addr_buffer);
C_ret:
#undef return

return C_r;}

#define return(x) C_cblock C_r = (C_fix((C_word)(x))); goto C_ret; C_cblockend
C_regparm static C_word C_fcall stub173(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3,C_word C_a4){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int s=(int )C_unfix(C_a0);
void * msg=(void * )C_data_pointer_or_null(C_a1);
int offset=(int )C_unfix(C_a2);
int len=(int )C_unfix(C_a3);
int flags=(int )C_unfix(C_a4);
C_return(send(s, (char *)msg+offset, len, flags));
C_ret:
#undef return

return C_r;}

/* from k1143 */
C_regparm static C_word C_fcall stub164(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_fix((C_word)C_set_socket_options(t0));
return C_r;}

/* from k1136 */
C_regparm static C_word C_fcall stub159(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_fix((C_word)C_check_fd_ready(t0));
return C_r;}

/* from k1126 */
C_regparm static C_word C_fcall stub150(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
void * t1=(void * )C_data_pointer_or_null(C_a1);
int t2=(int )C_unfix(C_a2);
C_r=C_fix((C_word)connect(t0,t1,t2));
return C_r;}

/* from k1111 */
C_regparm static C_word C_fcall stub142(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
int t1=(int )C_unfix(C_a1);
C_r=C_fix((C_word)shutdown(t0,t1));
return C_r;}

/* from k1097 */
C_regparm static C_word C_fcall stub131(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
void * t1=(void * )C_data_pointer_or_null(C_a1);
int t2=(int )C_unfix(C_a2);
int t3=(int )C_unfix(C_a3);
C_r=C_fix((C_word)recv(t0,t1,t2,t3));
return C_r;}

/* from k1078 */
C_regparm static C_word C_fcall stub123(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_fix((C_word)closesocket(t0));
return C_r;}

/* from k1065 */
C_regparm static C_word C_fcall stub112(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
void * t1=(void * )C_c_pointer_or_null(C_a1);
void * t2=(void * )C_c_pointer_or_null(C_a2);
C_r=C_fix((C_word)accept(t0,t1,t2));
return C_r;}

/* from k1050 */
C_regparm static C_word C_fcall stub104(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
int t1=(int )C_unfix(C_a1);
C_r=C_fix((C_word)listen(t0,t1));
return C_r;}

/* from k1036 */
C_regparm static C_word C_fcall stub94(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
void * t1=(void * )C_data_pointer_or_null(C_a1);
int t2=(int )C_unfix(C_a2);
C_r=C_fix((C_word)bind(t0,t1,t2));
return C_r;}

/* from k1021 */
C_regparm static C_word C_fcall stub85(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
int t1=(int )C_unfix(C_a1);
int t2=(int )C_unfix(C_a2);
C_r=C_fix((C_word)socket(t0,t1,t2));
return C_r;}

/* from ##net#interrupted? */
C_regparm static C_word C_fcall stub79(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_mk_bool(call_was_interrupted());
return C_r;}

/* from ##net#in-progress? */
C_regparm static C_word C_fcall stub76(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_mk_bool(call_in_progress());
return C_r;}

/* from ##net#retry? */
C_regparm static C_word C_fcall stub73(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_mk_bool(should_retry_call());
return C_r;}

/* from k997 */
C_regparm static C_word C_fcall stub68(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)errormsg_from_code(t0));
return C_r;}

/* from ##net#last-error-code */
C_regparm static C_word C_fcall stub64(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)get_last_socket_error());
return C_r;}

C_noret_decl(f_3065)
static void C_ccall f_3065(C_word c,C_word *av) C_noret;
C_noret_decl(f_1483)
static void C_ccall f_1483(C_word c,C_word *av) C_noret;
C_noret_decl(f_1480)
static void C_ccall f_1480(C_word c,C_word *av) C_noret;
C_noret_decl(f_3061)
static void C_ccall f_3061(C_word c,C_word *av) C_noret;
C_noret_decl(f_3069)
static void C_ccall f_3069(C_word c,C_word *av) C_noret;
C_noret_decl(f_3073)
static void C_ccall f_3073(C_word c,C_word *av) C_noret;
C_noret_decl(f_2468)
static void C_ccall f_2468(C_word c,C_word *av) C_noret;
C_noret_decl(f_1474)
static void C_ccall f_1474(C_word c,C_word *av) C_noret;
C_noret_decl(f_2712)
static void C_ccall f_2712(C_word c,C_word *av) C_noret;
C_noret_decl(f_2704)
static void C_ccall f_2704(C_word c,C_word *av) C_noret;
C_noret_decl(f_2708)
static void C_ccall f_2708(C_word c,C_word *av) C_noret;
C_noret_decl(f_2118)
static void C_fcall f_2118(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1887)
static void C_ccall f_1887(C_word c,C_word *av) C_noret;
C_noret_decl(f_2110)
static void C_ccall f_2110(C_word c,C_word *av) C_noret;
C_noret_decl(f_2731)
static void C_ccall f_2731(C_word c,C_word *av) C_noret;
C_noret_decl(f_1894)
static void C_ccall f_1894(C_word c,C_word *av) C_noret;
C_noret_decl(f_1897)
static void C_ccall f_1897(C_word c,C_word *av) C_noret;
C_noret_decl(f_1563)
static void C_ccall f_1563(C_word c,C_word *av) C_noret;
C_noret_decl(f_2135)
static void C_ccall f_2135(C_word c,C_word *av) C_noret;
C_noret_decl(f_2139)
static void C_ccall f_2139(C_word c,C_word *av) C_noret;
C_noret_decl(f_2131)
static void C_ccall f_2131(C_word c,C_word *av) C_noret;
C_noret_decl(f_2102)
static void C_ccall f_2102(C_word c,C_word *av) C_noret;
C_noret_decl(f_1583)
static void C_ccall f_1583(C_word c,C_word *av) C_noret;
C_noret_decl(f_1587)
static void C_ccall f_1587(C_word c,C_word *av) C_noret;
C_noret_decl(f_1591)
static void C_ccall f_1591(C_word c,C_word *av) C_noret;
C_noret_decl(f_2010)
static void C_ccall f_2010(C_word c,C_word *av) C_noret;
C_noret_decl(f_2015)
static void C_ccall f_2015(C_word c,C_word *av) C_noret;
C_noret_decl(f_2124)
static void C_fcall f_2124(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2600)
static void C_ccall f_2600(C_word c,C_word *av) C_noret;
C_noret_decl(f_2619)
static void C_ccall f_2619(C_word c,C_word *av) C_noret;
C_noret_decl(f_2030)
static void C_ccall f_2030(C_word c,C_word *av) C_noret;
C_noret_decl(f_2366)
static void C_ccall f_2366(C_word c,C_word *av) C_noret;
C_noret_decl(f_2004)
static void C_ccall f_2004(C_word c,C_word *av) C_noret;
C_noret_decl(f_1447)
static void C_ccall f_1447(C_word c,C_word *av) C_noret;
C_noret_decl(f_2376)
static void C_ccall f_2376(C_word c,C_word *av) C_noret;
C_noret_decl(f_1912)
static void C_ccall f_1912(C_word c,C_word *av) C_noret;
C_noret_decl(f_1693)
static void C_ccall f_1693(C_word c,C_word *av) C_noret;
C_noret_decl(f_1696)
static void C_ccall f_1696(C_word c,C_word *av) C_noret;
C_noret_decl(f_1699)
static void C_ccall f_1699(C_word c,C_word *av) C_noret;
C_noret_decl(f_1671)
static void C_ccall f_1671(C_word c,C_word *av) C_noret;
C_noret_decl(f_1915)
static void C_ccall f_1915(C_word c,C_word *av) C_noret;
C_noret_decl(f_2024)
static void C_ccall f_2024(C_word c,C_word *av) C_noret;
C_noret_decl(f_2261)
static void C_ccall f_2261(C_word c,C_word *av) C_noret;
C_noret_decl(f_1421)
static void C_ccall f_1421(C_word c,C_word *av) C_noret;
C_noret_decl(f_1425)
static void C_ccall f_1425(C_word c,C_word *av) C_noret;
C_noret_decl(f_1924)
static void C_ccall f_1924(C_word c,C_word *av) C_noret;
C_noret_decl(f_1663)
static void C_ccall f_1663(C_word c,C_word *av) C_noret;
C_noret_decl(f_1666)
static void C_fcall f_1666(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2271)
static void C_ccall f_2271(C_word c,C_word *av) C_noret;
C_noret_decl(f_2739)
static void C_ccall f_2739(C_word c,C_word *av) C_noret;
C_noret_decl(f_1274)
static void C_fcall f_1274(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2735)
static void C_ccall f_2735(C_word c,C_word *av) C_noret;
C_noret_decl(f_1935)
static void C_fcall f_1935(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1932)
static void C_fcall f_1932(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2287)
static void C_ccall f_2287(C_word c,C_word *av) C_noret;
C_noret_decl(f_1401)
static void C_ccall f_1401(C_word c,C_word *av) C_noret;
C_noret_decl(f_1941)
static void C_fcall f_1941(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1948)
static void C_ccall f_1948(C_word c,C_word *av) C_noret;
C_noret_decl(f_2757)
static void C_ccall f_2757(C_word c,C_word *av) C_noret;
C_noret_decl(f_1952)
static void C_ccall f_1952(C_word c,C_word *av) C_noret;
C_noret_decl(f_1956)
static void C_ccall f_1956(C_word c,C_word *av) C_noret;
C_noret_decl(f_2504)
static void C_ccall f_2504(C_word c,C_word *av) C_noret;
C_noret_decl(f_1690)
static void C_ccall f_1690(C_word c,C_word *av) C_noret;
C_noret_decl(f_2502)
static void C_ccall f_2502(C_word c,C_word *av) C_noret;
C_noret_decl(f_2627)
static void C_ccall f_2627(C_word c,C_word *av) C_noret;
C_noret_decl(f_2623)
static void C_ccall f_2623(C_word c,C_word *av) C_noret;
C_noret_decl(f_2514)
static void C_ccall f_2514(C_word c,C_word *av) C_noret;
C_noret_decl(f_2588)
static void C_ccall f_2588(C_word c,C_word *av) C_noret;
C_noret_decl(f_2585)
static void C_ccall f_2585(C_word c,C_word *av) C_noret;
C_noret_decl(f_1554)
static void C_ccall f_1554(C_word c,C_word *av) C_noret;
C_noret_decl(f_2591)
static void C_ccall f_2591(C_word c,C_word *av) C_noret;
C_noret_decl(f_2992)
static void C_ccall f_2992(C_word c,C_word *av) C_noret;
C_noret_decl(f_2594)
static void C_ccall f_2594(C_word c,C_word *av) C_noret;
C_noret_decl(f_2256)
static void C_fcall f_2256(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1297)
static void C_ccall f_1297(C_word c,C_word *av) C_noret;
C_noret_decl(f_2649)
static void C_ccall f_2649(C_word c,C_word *av) C_noret;
C_noret_decl(f_2645)
static void C_ccall f_2645(C_word c,C_word *av) C_noret;
C_noret_decl(f_1994)
static void C_ccall f_1994(C_word c,C_word *av) C_noret;
C_noret_decl(f_2657)
static void C_ccall f_2657(C_word c,C_word *av) C_noret;
C_noret_decl(f_2653)
static void C_ccall f_2653(C_word c,C_word *av) C_noret;
C_noret_decl(f_2184)
static void C_fcall f_2184(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_1502)
static void C_ccall f_1502(C_word c,C_word *av) C_noret;
C_noret_decl(f_1506)
static void C_ccall f_1506(C_word c,C_word *av) C_noret;
C_noret_decl(f_3005)
static void C_ccall f_3005(C_word c,C_word *av) C_noret;
C_noret_decl(f_2854)
static void C_ccall f_2854(C_word c,C_word *av) C_noret;
C_noret_decl(f_2909)
static void C_ccall f_2909(C_word c,C_word *av) C_noret;
C_noret_decl(f_2905)
static void C_ccall f_2905(C_word c,C_word *av) C_noret;
C_noret_decl(f_1365)
static void C_ccall f_1365(C_word c,C_word *av) C_noret;
C_noret_decl(f_2828)
static void C_ccall f_2828(C_word c,C_word *av) C_noret;
C_noret_decl(f_1362)
static void C_ccall f_1362(C_word c,C_word *av) C_noret;
C_noret_decl(f_3015)
static void C_ccall f_3015(C_word c,C_word *av) C_noret;
C_noret_decl(f_3019)
static void C_ccall f_3019(C_word c,C_word *av) C_noret;
C_noret_decl(f_1417)
static void C_ccall f_1417(C_word c,C_word *av) C_noret;
C_noret_decl(f_2178)
static void C_ccall f_2178(C_word c,C_word *av) C_noret;
C_noret_decl(f_1377)
static void C_ccall f_1377(C_word c,C_word *av) C_noret;
C_noret_decl(f_1374)
static void C_ccall f_1374(C_word c,C_word *av) C_noret;
C_noret_decl(f_3023)
static void C_ccall f_3023(C_word c,C_word *av) C_noret;
C_noret_decl(f_1371)
static void C_ccall f_1371(C_word c,C_word *av) C_noret;
C_noret_decl(f_2927)
static void C_ccall f_2927(C_word c,C_word *av) C_noret;
C_noret_decl(f_2921)
static void C_ccall f_2921(C_word c,C_word *av) C_noret;
C_noret_decl(f_1772)
static void C_fcall f_1772(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1774)
static void C_fcall f_1774(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_2840)
static void C_ccall f_2840(C_word c,C_word *av) C_noret;
C_noret_decl(f_1393)
static void C_ccall f_1393(C_word c,C_word *av) C_noret;
C_noret_decl(f_1397)
static void C_ccall f_1397(C_word c,C_word *av) C_noret;
C_noret_decl(f_2527)
static void C_ccall f_2527(C_word c,C_word *av) C_noret;
C_noret_decl(f_2164)
static void C_ccall f_2164(C_word c,C_word *av) C_noret;
C_noret_decl(f_2160)
static void C_ccall f_2160(C_word c,C_word *av) C_noret;
C_noret_decl(f_2535)
static void C_ccall f_2535(C_word c,C_word *av) C_noret;
C_noret_decl(f_2419)
static void C_ccall f_2419(C_word c,C_word *av) C_noret;
C_noret_decl(f_1646)
static void C_ccall f_1646(C_word c,C_word *av) C_noret;
C_noret_decl(f_1640)
static void C_ccall f_1640(C_word c,C_word *av) C_noret;
C_noret_decl(f_2531)
static void C_ccall f_2531(C_word c,C_word *av) C_noret;
C_noret_decl(f_1642)
static void C_fcall f_1642(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2427)
static void C_ccall f_2427(C_word c,C_word *av) C_noret;
C_noret_decl(f_1655)
static void C_ccall f_1655(C_word c,C_word *av) C_noret;
C_noret_decl(f_1649)
static void C_ccall f_1649(C_word c,C_word *av) C_noret;
C_noret_decl(f_2422)
static void C_fcall f_2422(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2554)
static void C_ccall f_2554(C_word c,C_word *av) C_noret;
C_noret_decl(f_1658)
static void C_fcall f_1658(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1659)
static void C_fcall f_1659(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1510)
static void C_ccall f_1510(C_word c,C_word *av) C_noret;
C_noret_decl(f_2877)
static void C_ccall f_2877(C_word c,C_word *av) C_noret;
C_noret_decl(f_2870)
static void C_ccall f_2870(C_word c,C_word *av) C_noret;
C_noret_decl(f_2874)
static void C_ccall f_2874(C_word c,C_word *av) C_noret;
C_noret_decl(f_1636)
static void C_ccall f_1636(C_word c,C_word *av) C_noret;
C_noret_decl(f_1632)
static void C_ccall f_1632(C_word c,C_word *av) C_noret;
C_noret_decl(f_1628)
static void C_ccall f_1628(C_word c,C_word *av) C_noret;
C_noret_decl(f_1240)
static void C_fcall f_1240(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2952)
static void C_ccall f_2952(C_word c,C_word *av) C_noret;
C_noret_decl(f_2956)
static void C_ccall f_2956(C_word c,C_word *av) C_noret;
C_noret_decl(f_2892)
static void C_ccall f_2892(C_word c,C_word *av) C_noret;
C_noret_decl(f_1213)
static void C_ccall f_1213(C_word c,C_word *av) C_noret;
C_noret_decl(f_1249)
static void C_ccall f_1249(C_word c,C_word *av) C_noret;
C_noret_decl(f_1978)
static void C_fcall f_1978(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2867)
static void C_ccall f_2867(C_word c,C_word *av) C_noret;
C_noret_decl(f_2860)
static void C_ccall f_2860(C_word c,C_word *av) C_noret;
C_noret_decl(f_1220)
static void C_ccall f_1220(C_word c,C_word *av) C_noret;
C_noret_decl(f_2050)
static void C_ccall f_2050(C_word c,C_word *av) C_noret;
C_noret_decl(f_1224)
static void C_ccall f_1224(C_word c,C_word *av) C_noret;
C_noret_decl(C_tcp_toplevel)
C_externexport void C_ccall C_tcp_toplevel(C_word c,C_word *av) C_noret;
C_noret_decl(f_1981)
static void C_ccall f_1981(C_word c,C_word *av) C_noret;
C_noret_decl(f_2409)
static void C_ccall f_2409(C_word c,C_word *av) C_noret;
C_noret_decl(f_2405)
static void C_ccall f_2405(C_word c,C_word *av) C_noret;
C_noret_decl(f_2401)
static void C_ccall f_2401(C_word c,C_word *av) C_noret;
C_noret_decl(f_2888)
static void C_ccall f_2888(C_word c,C_word *av) C_noret;
C_noret_decl(f_2884)
static void C_ccall f_2884(C_word c,C_word *av) C_noret;
C_noret_decl(f_2913)
static void C_ccall f_2913(C_word c,C_word *av) C_noret;
C_noret_decl(f_985)
static void C_ccall f_985(C_word c,C_word *av) C_noret;
C_noret_decl(f_982)
static void C_ccall f_982(C_word c,C_word *av) C_noret;
C_noret_decl(f_2046)
static void C_ccall f_2046(C_word c,C_word *av) C_noret;
C_noret_decl(f_2960)
static void C_ccall f_2960(C_word c,C_word *av) C_noret;
C_noret_decl(f_2397)
static void C_ccall f_2397(C_word c,C_word *av) C_noret;
C_noret_decl(f_2317)
static void C_ccall f_2317(C_word c,C_word *av) C_noret;
C_noret_decl(f_1735)
static void C_ccall f_1735(C_word c,C_word *av) C_noret;
C_noret_decl(f_1731)
static void C_ccall f_1731(C_word c,C_word *av) C_noret;
C_noret_decl(f_2984)
static void C_ccall f_2984(C_word c,C_word *av) C_noret;
C_noret_decl(f_2098)
static void C_ccall f_2098(C_word c,C_word *av) C_noret;
C_noret_decl(f_2980)
static void C_ccall f_2980(C_word c,C_word *av) C_noret;
C_noret_decl(f_2676)
static void C_ccall f_2676(C_word c,C_word *av) C_noret;
C_noret_decl(f_2437)
static void C_ccall f_2437(C_word c,C_word *av) C_noret;
C_noret_decl(f_2094)
static void C_ccall f_2094(C_word c,C_word *av) C_noret;
C_noret_decl(f_2434)
static void C_ccall f_2434(C_word c,C_word *av) C_noret;
C_noret_decl(f_2939)
static void C_ccall f_2939(C_word c,C_word *av) C_noret;
C_noret_decl(f_2936)
static void C_ccall f_2936(C_word c,C_word *av) C_noret;
C_noret_decl(f_2673)
static void C_ccall f_2673(C_word c,C_word *av) C_noret;
C_noret_decl(f_2431)
static void C_ccall f_2431(C_word c,C_word *av) C_noret;
C_noret_decl(f_2068)
static void C_ccall f_2068(C_word c,C_word *av) C_noret;
C_noret_decl(f_1756)
static void C_ccall f_1756(C_word c,C_word *av) C_noret;
C_noret_decl(f_1753)
static void C_ccall f_1753(C_word c,C_word *av) C_noret;
C_noret_decl(f_2440)
static void C_ccall f_2440(C_word c,C_word *av) C_noret;
C_noret_decl(f_1757)
static void C_fcall f_1757(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2761)
static void C_ccall f_2761(C_word c,C_word *av) C_noret;
C_noret_decl(f_979)
static void C_ccall f_979(C_word c,C_word *av) C_noret;
C_noret_decl(f_2765)
static void C_ccall f_2765(C_word c,C_word *av) C_noret;
C_noret_decl(f_1605)
static void C_ccall f_1605(C_word c,C_word *av) C_noret;
C_noret_decl(f_1304)
static void C_ccall f_1304(C_word c,C_word *av) C_noret;
C_noret_decl(f_1301)
static void C_ccall f_1301(C_word c,C_word *av) C_noret;
C_noret_decl(f_1307)
static void C_ccall f_1307(C_word c,C_word *av) C_noret;
C_noret_decl(f_1727)
static void C_ccall f_1727(C_word c,C_word *av) C_noret;
C_noret_decl(f_1828)
static void C_ccall f_1828(C_word c,C_word *av) C_noret;
C_noret_decl(f_2081)
static void C_ccall f_2081(C_word c,C_word *av) C_noret;
C_noret_decl(f_2976)
static void C_ccall f_2976(C_word c,C_word *av) C_noret;
C_noret_decl(f_1611)
static void C_fcall f_1611(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1613)
static void C_ccall f_1613(C_word c,C_word *av) C_noret;
C_noret_decl(f_1799)
static void C_ccall f_1799(C_word c,C_word *av) C_noret;
C_noret_decl(f_1796)
static void C_ccall f_1796(C_word c,C_word *av) C_noret;
C_noret_decl(f_1317)
static void C_ccall f_1317(C_word c,C_word *av) C_noret;
C_noret_decl(f_2789)
static void C_ccall f_2789(C_word c,C_word *av) C_noret;
C_noret_decl(f_2781)
static void C_ccall f_2781(C_word c,C_word *av) C_noret;
C_noret_decl(f_1839)
static void C_ccall f_1839(C_word c,C_word *av) C_noret;
C_noret_decl(f_2785)
static void C_ccall f_2785(C_word c,C_word *av) C_noret;
C_noret_decl(f_1321)
static void C_ccall f_1321(C_word c,C_word *av) C_noret;
C_noret_decl(f_1325)
static void C_ccall f_1325(C_word c,C_word *av) C_noret;
C_noret_decl(f_1761)
static void C_ccall f_1761(C_word c,C_word *av) C_noret;
C_noret_decl(f_2798)
static void C_ccall f_2798(C_word c,C_word *av) C_noret;
C_noret_decl(f_1802)
static void C_ccall f_1802(C_word c,C_word *av) C_noret;
C_noret_decl(f_1805)
static void C_ccall f_1805(C_word c,C_word *av) C_noret;
C_noret_decl(f_1847)
static void C_ccall f_1847(C_word c,C_word *av) C_noret;
C_noret_decl(f_2567)
static void C_ccall f_2567(C_word c,C_word *av) C_noret;
C_noret_decl(f_2561)
static void C_ccall f_2561(C_word c,C_word *av) C_noret;
C_noret_decl(f_2564)
static void C_fcall f_2564(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1843)
static void C_ccall f_1843(C_word c,C_word *av) C_noret;
C_noret_decl(f_2579)
static void C_ccall f_2579(C_word c,C_word *av) C_noret;
C_noret_decl(f_2573)
static void C_ccall f_2573(C_word c,C_word *av) C_noret;
C_noret_decl(f_2818)
static void C_ccall f_2818(C_word c,C_word *av) C_noret;
C_noret_decl(f_2812)
static void C_ccall f_2812(C_word c,C_word *av) C_noret;
C_noret_decl(f_2476)
static void C_ccall f_2476(C_word c,C_word *av) C_noret;
C_noret_decl(f_2472)
static void C_ccall f_2472(C_word c,C_word *av) C_noret;
C_noret_decl(f_2232)
static void C_ccall f_2232(C_word c,C_word *av) C_noret;
C_noret_decl(f_2247)
static void C_ccall f_2247(C_word c,C_word *av) C_noret;
C_noret_decl(f_2243)
static void C_ccall f_2243(C_word c,C_word *av) C_noret;
C_noret_decl(f_2836)
static void C_ccall f_2836(C_word c,C_word *av) C_noret;
C_noret_decl(f_1455)
static void C_ccall f_1455(C_word c,C_word *av) C_noret;
C_noret_decl(f_3031)
static void C_ccall f_3031(C_word c,C_word *av) C_noret;
C_noret_decl(f_2804)
static void C_ccall f_2804(C_word c,C_word *av) C_noret;
C_noret_decl(f_3041)
static void C_ccall f_3041(C_word c,C_word *av) C_noret;
C_noret_decl(f_3050)
static void C_ccall f_3050(C_word c,C_word *av) C_noret;

C_noret_decl(trf_2118)
static void C_ccall trf_2118(C_word c,C_word *av) C_noret;
static void C_ccall trf_2118(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_2118(t0,t1);}

C_noret_decl(trf_2124)
static void C_ccall trf_2124(C_word c,C_word *av) C_noret;
static void C_ccall trf_2124(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_2124(t0,t1);}

C_noret_decl(trf_1666)
static void C_ccall trf_1666(C_word c,C_word *av) C_noret;
static void C_ccall trf_1666(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_1666(t0,t1);}

C_noret_decl(trf_1274)
static void C_ccall trf_1274(C_word c,C_word *av) C_noret;
static void C_ccall trf_1274(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_1274(t0,t1,t2);}

C_noret_decl(trf_1935)
static void C_ccall trf_1935(C_word c,C_word *av) C_noret;
static void C_ccall trf_1935(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_1935(t0,t1);}

C_noret_decl(trf_1932)
static void C_ccall trf_1932(C_word c,C_word *av) C_noret;
static void C_ccall trf_1932(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_1932(t0,t1);}

C_noret_decl(trf_1941)
static void C_ccall trf_1941(C_word c,C_word *av) C_noret;
static void C_ccall trf_1941(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_1941(t0,t1);}

C_noret_decl(trf_2256)
static void C_ccall trf_2256(C_word c,C_word *av) C_noret;
static void C_ccall trf_2256(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_2256(t0,t1);}

C_noret_decl(trf_2184)
static void C_ccall trf_2184(C_word c,C_word *av) C_noret;
static void C_ccall trf_2184(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_2184(t0,t1,t2,t3,t4);}

C_noret_decl(trf_1772)
static void C_ccall trf_1772(C_word c,C_word *av) C_noret;
static void C_ccall trf_1772(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_1772(t0,t1);}

C_noret_decl(trf_1774)
static void C_ccall trf_1774(C_word c,C_word *av) C_noret;
static void C_ccall trf_1774(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_1774(t0,t1,t2,t3,t4);}

C_noret_decl(trf_1642)
static void C_ccall trf_1642(C_word c,C_word *av) C_noret;
static void C_ccall trf_1642(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_1642(t0,t1,t2,t3);}

C_noret_decl(trf_2422)
static void C_ccall trf_2422(C_word c,C_word *av) C_noret;
static void C_ccall trf_2422(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_2422(t0,t1);}

C_noret_decl(trf_1658)
static void C_ccall trf_1658(C_word c,C_word *av) C_noret;
static void C_ccall trf_1658(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_1658(t0,t1);}

C_noret_decl(trf_1659)
static void C_ccall trf_1659(C_word c,C_word *av) C_noret;
static void C_ccall trf_1659(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_1659(t0,t1);}

C_noret_decl(trf_1240)
static void C_ccall trf_1240(C_word c,C_word *av) C_noret;
static void C_ccall trf_1240(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_1240(t0,t1,t2,t3);}

C_noret_decl(trf_1978)
static void C_ccall trf_1978(C_word c,C_word *av) C_noret;
static void C_ccall trf_1978(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_1978(t0,t1);}

C_noret_decl(trf_1757)
static void C_ccall trf_1757(C_word c,C_word *av) C_noret;
static void C_ccall trf_1757(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_1757(t0,t1,t2);}

C_noret_decl(trf_1611)
static void C_ccall trf_1611(C_word c,C_word *av) C_noret;
static void C_ccall trf_1611(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_1611(t0,t1);}

C_noret_decl(trf_2564)
static void C_ccall trf_2564(C_word c,C_word *av) C_noret;
static void C_ccall trf_2564(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_2564(t0,t1);}

/* k3063 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_3065(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_3065,2,av);}
/* tcp.scm:351: make-parameter */
t2=*((C_word*)lf[90]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=C_SCHEME_FALSE;
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k1481 in k1478 in k1472 in tcp-listen in k1211 in k983 in k980 in k977 */
static void C_ccall f_1483(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(3,c,1))){C_save_and_reclaim((void *)f_1483,2,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_a_i_record2(&a,2,lf[3],((C_word*)t0)[3]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k1478 in k1472 in tcp-listen in k1211 in k983 in k980 in k977 */
static void C_ccall f_1480(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a;
if(!C_demand(C_calculate_demand(13,c,3))){C_save_and_reclaim((void *)f_1480,2,av);}
a=C_alloc(13);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1483,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=C_i_foreign_fixnum_argumentp(t2);
t5=C_i_foreign_fixnum_argumentp(((C_word*)t0)[3]);
t6=stub104(C_SCHEME_UNDEFINED,t4,t5);
t7=C_eqp(C_fix((C_word)SOCKET_ERROR),t6);
if(C_truep(t7)){
t8=stub64(C_SCHEME_UNDEFINED);
t9=t8;
t10=C_i_foreign_fixnum_argumentp(t2);
t11=stub123(C_SCHEME_UNDEFINED,t10);
t12=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1502,a[2]=t3,a[3]=t2,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t13=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1506,a[2]=t12,a[3]=t9,tmp=(C_word)a,a+=4,tmp);
/* ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[8]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[8]+1);
av2[1]=t13;
av2[2]=lf[9];
av2[3]=lf[10];
tp(4,av2);}}
else{
t8=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t8;
av2[1]=C_a_i_record2(&a,2,lf[3],t2);
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}}

/* k3059 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_3061(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_3061,2,av);}
/* tcp.scm:352: make-parameter */
t2=*((C_word*)lf[90]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=C_SCHEME_FALSE;
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k3067 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_3069(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_3069,2,av);}
/* tcp.scm:350: make-parameter */
t2=*((C_word*)lf[90]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=C_fix(60000);
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k3071 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_3073(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_3073,2,av);}
/* tcp.scm:349: make-parameter */
t2=*((C_word*)lf[90]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=C_fix(60000);
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k2466 in k2438 in k2435 in k2432 in k2429 in loop in k2420 in k2417 in tcp-accept in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2468(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,5))){C_save_and_reclaim((void *)f_2468,2,av);}
/* tcp.scm:560: ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[5];
av2[3]=lf[59];
av2[4]=t1;
av2[5]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}

/* k1472 in tcp-listen in k1211 in k983 in k980 in k977 */
static void C_ccall f_1474(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(!C_demand(C_calculate_demand(11,c,2))){C_save_and_reclaim((void *)f_1474,2,av);}
a=C_alloc(11);
t2=C_i_check_exact(((C_word*)t0)[2]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1480,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t4=t3;
t5=C_fix((C_word)SOCK_STREAM);
t6=((C_word*)t0)[5];
t7=((C_word*)t0)[4];
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1362,a[2]=t5,a[3]=t4,a[4]=t6,a[5]=t7,tmp=(C_word)a,a+=6,tmp);
/* tcp.scm:296: make-string */
t9=*((C_word*)lf[16]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t9;
av2[1]=t8;
av2[2]=C_fix((C_word)sizeof(struct sockaddr_in));
((C_proc)(void*)(*((C_word*)t9+1)))(3,av2);}}

/* k2710 in k2706 in loop in k2589 in k2586 in k2583 in k2577 in k2571 in k2565 in k2562 in k2559 in tcp-connect in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2712(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_2712,2,av);}
/* tcp.scm:607: string-append */
t2=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k2702 in loop in k2589 in k2586 in k2583 in k2577 in k2571 in k2565 in k2562 in k2559 in tcp-connect in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2704(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,7))){C_save_and_reclaim((void *)f_2704,2,av);}
/* tcp.scm:607: ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);{
C_word *av2;
if(c >= 8) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(8);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[5];
av2[3]=lf[64];
av2[4]=t1;
av2[5]=((C_word*)t0)[3];
av2[6]=((C_word*)((C_word*)t0)[4])[1];
av2[7]=((C_word*)((C_word*)t0)[5])[1];
((C_proc)(void*)(*((C_word*)t2+1)))(8,av2);}}

/* k2706 in loop in k2589 in k2586 in k2583 in k2577 in k2571 in k2565 in k2562 in k2559 in tcp-connect in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2708(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_demand(C_calculate_demand(9,c,3))){C_save_and_reclaim((void *)f_2708,2,av);}
a=C_alloc(9);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2712,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=C_a_i_bytevector(&a,1,C_fix(3));
t5=C_i_foreign_fixnum_argumentp(((C_word*)t0)[3]);
t6=stub68(t4,t5);
/* tcp.scm:163: ##sys#peek-c-string */
t7=*((C_word*)lf[7]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t7;
av2[1]=t3;
av2[2]=t6;
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t7+1)))(4,av2);}}

/* k2116 in a2109 in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_fcall f_2118(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_demand(C_calculate_demand(4,0,2))){
C_save_and_reclaim_args((void *)trf_2118,2,t0,t1);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2124,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep(((C_word*)((C_word*)t0)[4])[1])){
t3=((C_word*)t0)[3];
t4=C_i_foreign_fixnum_argumentp(t3);
t5=stub123(C_SCHEME_UNDEFINED,t4);
t6=t2;
f_2124(t6,C_eqp(C_fix((C_word)SOCKET_ERROR),t5));}
else{
t3=t2;
f_2124(t3,C_SCHEME_FALSE);}}

/* k1885 in loop in k1770 in k1759 in output in k1754 in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_1887(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,4))){C_save_and_reclaim((void *)f_1887,2,av);}
a=C_alloc(4);
t2=C_a_i_plus(&a,2,t1,((C_word*)t0)[2]);
/* tcp.scm:501: loop */
t3=((C_word*)((C_word*)t0)[3])[1];
f_1774(t3,((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)t0)[6],t2);}

/* a2109 in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2110(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(5,c,2))){C_save_and_reclaim((void *)f_2110,2,av);}
a=C_alloc(5);
if(C_truep(((C_word*)((C_word*)t0)[2])[1])){
t2=C_SCHEME_UNDEFINED;
t3=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t2=C_set_block_item(((C_word*)t0)[2],0,C_SCHEME_TRUE);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2118,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_slot(((C_word*)t0)[5],C_fix(1)))){
t4=t3;
f_2118(t4,C_SCHEME_UNDEFINED);}
else{
t4=((C_word*)t0)[3];
t5=C_fix((C_word)SHUT_RD);
t6=C_i_foreign_fixnum_argumentp(t4);
t7=C_i_foreign_fixnum_argumentp(t5);
t8=t3;
f_2118(t8,stub142(C_SCHEME_UNDEFINED,t6,t7));}}}

/* k2729 in k2586 in k2583 in k2577 in k2571 in k2565 in k2562 in k2559 in tcp-connect in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2731(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,5))){C_save_and_reclaim((void *)f_2731,2,av);}
/* tcp.scm:596: ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[5];
av2[3]=lf[64];
av2[4]=t1;
av2[5]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}

/* k1892 in k1759 in output in k1754 in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_1894(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,1))){C_save_and_reclaim((void *)f_1894,2,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];
f_1772(t2,C_a_i_plus(&a,2,t1,((C_word*)t0)[3]));}

/* k1895 in k1754 in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_1897(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(!C_demand(C_calculate_demand(6,c,3))){C_save_and_reclaim((void *)f_1897,2,av);}
a=C_alloc(6);
t2=t1;
t3=C_i_setslot(((C_word*)t0)[2],C_fix(3),lf[41]);
t4=C_i_setslot(t2,C_fix(3),lf[42]);
t5=C_i_setslot(((C_word*)t0)[2],C_fix(7),lf[43]);
t6=C_i_setslot(t2,C_fix(7),lf[43]);
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1912,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],a[4]=t2,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* tcp.scm:535: ##sys#set-port-data! */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[44]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[44]+1);
av2[1]=t7;
av2[2]=((C_word*)t0)[2];
av2[3]=((C_word*)t0)[4];
tp(4,av2);}}

/* tcp-close in k1211 in k983 in k980 in k977 */
static void C_ccall f_1563(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(7,c,3))){C_save_and_reclaim((void *)f_1563,3,av);}
a=C_alloc(7);
t3=C_i_check_structure(t2,lf[3]);
t4=C_slot(t2,C_fix(1));
t5=C_i_foreign_fixnum_argumentp(t4);
t6=stub123(C_SCHEME_UNDEFINED,t5);
t7=C_eqp(C_fix((C_word)SOCKET_ERROR),t6);
if(C_truep(t7)){
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1583,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1587,a[2]=t8,tmp=(C_word)a,a+=3,tmp);
/* ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[8]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[8]+1);
av2[1]=t9;
av2[2]=lf[21];
av2[3]=lf[10];
tp(4,av2);}}
else{
t8=C_SCHEME_UNDEFINED;
t9=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t9;
av2[1]=t8;
((C_proc)(void*)(*((C_word*)t9+1)))(2,av2);}}}

/* k2133 in k2122 in k2116 in a2109 in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2135(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(!C_demand(C_calculate_demand(9,c,3))){C_save_and_reclaim((void *)f_2135,2,av);}
a=C_alloc(9);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2139,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=stub64(C_SCHEME_UNDEFINED);
t5=C_a_i_bytevector(&a,1,C_fix(3));
t6=C_i_foreign_fixnum_argumentp(t4);
t7=stub68(t5,t6);
/* tcp.scm:163: ##sys#peek-c-string */
t8=*((C_word*)lf[7]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t8;
av2[1]=t3;
av2[2]=t7;
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t8+1)))(4,av2);}}

/* k2137 in k2133 in k2122 in k2116 in a2109 in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2139(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_2139,2,av);}
/* tcp.scm:416: string-append */
t2=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k2129 in k2122 in k2116 in a2109 in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2131(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,5))){C_save_and_reclaim((void *)f_2131,2,av);}
/* tcp.scm:416: ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[5];
av2[3]=C_SCHEME_FALSE;
av2[4]=t1;
av2[5]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}

/* k2100 in k2096 in a2067 in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2102(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_2102,2,av);}
/* tcp.scm:409: string-append */
t2=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k1581 in tcp-close in k1211 in k983 in k980 in k977 */
static void C_ccall f_1583(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,5))){C_save_and_reclaim((void *)f_1583,2,av);}
/* tcp.scm:333: ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[5];
av2[3]=lf[20];
av2[4]=t1;
av2[5]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}

/* k1585 in tcp-close in k1211 in k983 in k980 in k977 */
static void C_ccall f_1587(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(!C_demand(C_calculate_demand(9,c,3))){C_save_and_reclaim((void *)f_1587,2,av);}
a=C_alloc(9);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1591,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=stub64(C_SCHEME_UNDEFINED);
t5=C_a_i_bytevector(&a,1,C_fix(3));
t6=C_i_foreign_fixnum_argumentp(t4);
t7=stub68(t5,t6);
/* tcp.scm:163: ##sys#peek-c-string */
t8=*((C_word*)lf[7]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t8;
av2[1]=t3;
av2[2]=t7;
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t8+1)))(4,av2);}}

/* k1589 in k1585 in tcp-close in k1211 in k983 in k980 in k977 */
static void C_ccall f_1591(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_1591,2,av);}
/* tcp.scm:333: string-append */
t2=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* f_2010 in k1754 in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2010(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(6,c,3))){C_save_and_reclaim((void *)f_2010,3,av);}
a=C_alloc(6);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2015,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* tcp.scm:510: ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[8]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[8]+1);
av2[1]=t3;
av2[2]=((C_word*)((C_word*)t0)[2])[1];
av2[3]=t2;
tp(4,av2);}}

/* k2013 */
static void C_ccall f_2015(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,2))){C_save_and_reclaim((void *)f_2015,2,av);}
a=C_alloc(4);
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,t1);
t3=C_block_size(((C_word*)((C_word*)t0)[2])[1]);
if(C_truep(C_fixnum_greater_or_equal_p(t3,((C_word*)t0)[3]))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2024,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* tcp.scm:512: output */
t5=((C_word*)t0)[5];
f_1757(t5,t4,((C_word*)((C_word*)t0)[2])[1]);}
else{
t4=C_SCHEME_UNDEFINED;
t5=((C_word*)t0)[4];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* k2122 in k2116 in a2109 in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_fcall f_2124(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(7,0,3))){
C_save_and_reclaim_args((void *)trf_2124,2,t0,t1);}
a=C_alloc(7);
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2131,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2135,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[8]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[8]+1);
av2[1]=t3;
av2[2]=lf[51];
av2[3]=lf[10];
tp(4,av2);}}
else{
t2=((C_word*)t0)[2];{
C_word av2[2];
av2[0]=t2;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* k2598 in k2592 in k2589 in k2586 in k2583 in k2577 in k2571 in k2565 in k2562 in k2559 in tcp-connect in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2600(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_2600,2,av);}
/* tcp.scm:615: ##net#io-ports */
t2=lf[27];
f_1642(t2,((C_word*)t0)[2],lf[64],((C_word*)t0)[3]);}

/* k2617 in k2592 in k2589 in k2586 in k2583 in k2577 in k2571 in k2565 in k2562 in k2559 in tcp-connect in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2619(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,5))){C_save_and_reclaim((void *)f_2619,2,av);}
/* tcp.scm:611: ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[5];
av2[3]=lf[64];
av2[4]=t1;
av2[5]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}

/* f_2030 in k1754 in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2030(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(0,c,2))){C_save_and_reclaim((void *)f_2030,3,av);}
t3=C_block_size(t2);
if(C_truep(C_fixnum_greaterp(t3,C_fix(0)))){
/* tcp.scm:516: output */
t4=((C_word*)t0)[2];
f_1757(t4,t1,t2);}
else{
t4=C_SCHEME_UNDEFINED;
t5=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* a2365 in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2366(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(5,c,4))){C_save_and_reclaim((void *)f_2366,3,av);}
a=C_alloc(5);
if(C_truep(C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]))){
t3=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=lf[53];
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2376,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* tcp.scm:471: ##sys#substring */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[54]+1));
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[54]+1);
av2[1]=t3;
av2[2]=((C_word*)t0)[4];
av2[3]=((C_word*)((C_word*)t0)[2])[1];
av2[4]=((C_word*)((C_word*)t0)[3])[1];
tp(5,av2);}}}

/* k2002 */
static void C_ccall f_2004(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_2004,2,av);}
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,lf[48]);
t3=((C_word*)t0)[3];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* k1445 in k1360 in k1472 in tcp-listen in k1211 in k983 in k980 in k977 */
static void C_ccall f_1447(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,6))){C_save_and_reclaim((void *)f_1447,2,av);}
if(C_truep(t1)){
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=t2;
f_1365(2,av2);}}
else{
/* tcp.scm:299: ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);{
C_word *av2;
if(c >= 7) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(7);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[5];
av2[3]=lf[2];
av2[4]=lf[15];
av2[5]=((C_word*)t0)[3];
av2[6]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t2+1)))(7,av2);}}}

/* k2374 in a2365 in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2376(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_2376,2,av);}
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=((C_word*)t0)[4];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* k1910 in k1895 in k1754 in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_1912(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(5,c,3))){C_save_and_reclaim((void *)f_1912,2,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1915,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* tcp.scm:536: ##sys#set-port-data! */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[44]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[44]+1);
av2[1]=t2;
av2[2]=((C_word*)t0)[4];
av2[3]=((C_word*)t0)[5];
tp(4,av2);}}

/* k1691 in k1688 in loop in k1664 in k1661 in read-input in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_1693(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(6,c,2))){C_save_and_reclaim((void *)f_1693,2,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1696,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
/* tcp.scm:379: ##sys#thread-yield! */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[31]+1));
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=*((C_word*)lf[31]+1);
av2[1]=t2;
tp(2,av2);}}

/* k1694 in k1691 in k1688 in loop in k1664 in k1661 in read-input in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_1696(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,5))){C_save_and_reclaim((void *)f_1696,2,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1699,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_slot(*((C_word*)lf[28]+1),C_fix(13)))){
/* tcp.scm:381: ##sys#signal-hook */
t3=*((C_word*)lf[4]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[29];
av2[3]=lf[30];
av2[4]=((C_word*)t0)[4];
av2[5]=((C_word*)t0)[5];
((C_proc)(void*)(*((C_word*)t3+1)))(6,av2);}}
else{
/* tcp.scm:384: loop */
t3=((C_word*)((C_word*)t0)[2])[1];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[3];
f_1671(2,av2);}}}

/* k1697 in k1694 in k1691 in k1688 in loop in k1664 in k1661 in read-input in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 in ... */
static void C_ccall f_1699(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_1699,2,av);}
/* tcp.scm:384: loop */
t2=((C_word*)((C_word*)t0)[2])[1];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
f_1671(2,av2);}}

/* loop in k1664 in k1661 in read-input in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_1671(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(7,c,3))){C_save_and_reclaim((void *)f_1671,2,av);}
a=C_alloc(7);
t2=((C_word*)t0)[2];
t3=C_i_foreign_fixnum_argumentp(t2);
t4=(C_truep(((C_word*)t0)[3])?C_i_foreign_block_argumentp(((C_word*)t0)[3]):C_SCHEME_FALSE);
t5=C_i_foreign_fixnum_argumentp(C_fix(1024));
t6=C_i_foreign_fixnum_argumentp(C_fix(0));
t7=stub131(C_SCHEME_UNDEFINED,t3,t4,t5,t6);
t8=C_eqp(C_fix((C_word)SOCKET_ERROR),t7);
if(C_truep(t8)){
if(C_truep(stub73(C_SCHEME_UNDEFINED))){
t9=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1690,a[2]=((C_word*)t0)[4],a[3]=t1,a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[2],tmp=(C_word)a,a+=6,tmp);
if(C_truep(((C_word*)t0)[6])){
/* tcp.scm:376: ##sys#thread-block-for-timeout! */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[34]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[34]+1);
av2[1]=t9;
av2[2]=*((C_word*)lf[28]+1);
av2[3]=((C_word*)t0)[6];
tp(4,av2);}}
else{
t10=t9;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t10;
av2[1]=C_SCHEME_UNDEFINED;
f_1690(2,av2);}}}
else{
if(C_truep(stub79(C_SCHEME_UNDEFINED))){
/* tcp.scm:386: ##sys#dispatch-interrupt */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[35]+1));
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[35]+1);
av2[1]=t1;
av2[2]=((C_word*)((C_word*)t0)[4])[1];
tp(3,av2);}}
else{
t9=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1727,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t10=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1731,a[2]=t9,tmp=(C_word)a,a+=3,tmp);
/* ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[8]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[8]+1);
av2[1]=t10;
av2[2]=lf[36];
av2[3]=lf[10];
tp(4,av2);}}}}
else{
t9=C_mutate2(((C_word *)((C_word*)t0)[7])+1,t7);
t10=C_i_set_i_slot(((C_word*)t0)[8],C_fix(4),t7);
t11=C_set_block_item(((C_word*)t0)[9],0,C_fix(0));
t12=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t12;
av2[1]=t11;
((C_proc)(void*)(*((C_word*)t12+1)))(2,av2);}}}

/* k1913 in k1910 in k1895 in k1754 in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_1915(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_1915,2,av);}
/* tcp.scm:537: values */{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=((C_word*)t0)[4];
C_values(4,av2);}}

/* k2022 in k2013 */
static void C_ccall f_2024(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_2024,2,av);}
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,lf[45]);
t3=((C_word*)t0)[3];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* a2260 in k2254 in k2245 in a2242 in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2261(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(8,c,5))){C_save_and_reclaim((void *)f_2261,2,av);}
a=C_alloc(8);
t2=C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]);
t3=C_i_fixnum_min(((C_word*)((C_word*)t0)[4])[1],t2);
t4=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2271,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word)li21),tmp=(C_word)a,a+=8,tmp);
/* tcp.scm:444: ##sys#scan-buffer-line */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[52]+1));
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[52]+1);
av2[1]=t1;
av2[2]=((C_word*)t0)[5];
av2[3]=t3;
av2[4]=((C_word*)((C_word*)t0)[2])[1];
av2[5]=t4;
tp(6,av2);}}

/* k1419 in k1369 in k1363 in k1360 in k1472 in tcp-listen in k1211 in k983 in k980 in k977 */
static void C_ccall f_1421(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(!C_demand(C_calculate_demand(9,c,3))){C_save_and_reclaim((void *)f_1421,2,av);}
a=C_alloc(9);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1425,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=stub64(C_SCHEME_UNDEFINED);
t5=C_a_i_bytevector(&a,1,C_fix(3));
t6=C_i_foreign_fixnum_argumentp(t4);
t7=stub68(t5,t6);
/* tcp.scm:163: ##sys#peek-c-string */
t8=*((C_word*)lf[7]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t8;
av2[1]=t3;
av2[2]=t7;
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t8+1)))(4,av2);}}

/* k1423 in k1419 in k1369 in k1363 in k1360 in k1472 in tcp-listen in k1211 in k983 in k980 in k977 */
static void C_ccall f_1425(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_1425,2,av);}
/* tcp.scm:308: string-append */
t2=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* a1923 in k1754 in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_1924(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(11,c,2))){C_save_and_reclaim((void *)f_1924,2,av);}
a=C_alloc(11);
if(C_truep(((C_word*)((C_word*)t0)[2])[1])){
t2=C_SCHEME_UNDEFINED;
t3=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t2=C_set_block_item(((C_word*)t0)[2],0,C_SCHEME_TRUE);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1932,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1978,a[2]=((C_word*)t0)[6],a[3]=t3,a[4]=((C_word*)t0)[7],tmp=(C_word)a,a+=5,tmp);
if(C_truep(((C_word*)((C_word*)t0)[6])[1])){
t5=C_block_size(((C_word*)((C_word*)t0)[6])[1]);
t6=t4;
f_1978(t6,C_fixnum_greaterp(t5,C_fix(0)));}
else{
t5=t4;
f_1978(t5,C_SCHEME_FALSE);}}}

/* k1661 in read-input in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_1663(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(13,c,2))){C_save_and_reclaim((void *)f_1663,2,av);}
a=C_alloc(13);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_1666,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],tmp=(C_word)a,a+=9,tmp);
if(C_truep(t2)){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1753,a[2]=t3,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* tcp.scm:370: current-milliseconds */
t5=*((C_word*)lf[37]+1);{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
t4=t3;
f_1666(t4,C_SCHEME_FALSE);}}

/* k1664 in k1661 in read-input in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_fcall f_1666(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_demand(C_calculate_demand(13,0,2))){
C_save_and_reclaim_args((void *)trf_1666,2,t0,t1);}
a=C_alloc(13);
t2=t1;
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_1671,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t4,a[5]=((C_word*)t0)[4],a[6]=t2,a[7]=((C_word*)t0)[5],a[8]=((C_word*)t0)[6],a[9]=((C_word*)t0)[7],a[10]=((C_word)li6),tmp=(C_word)a,a+=11,tmp));
t6=((C_word*)t4)[1];{
C_word av2[2];
av2[0]=t6;
av2[1]=((C_word*)t0)[8];
f_1671(2,av2);}}

/* a2270 in a2260 in k2254 in k2245 in a2242 in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2271(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(8,c,4))){C_save_and_reclaim((void *)f_2271,3,av);}
a=C_alloc(8);
t3=C_fixnum_difference(t2,((C_word*)((C_word*)t0)[2])[1]);
t4=t3;
if(C_truep(C_fixnum_greater_or_equal_p(t4,((C_word*)((C_word*)t0)[3])[1]))){
/* tcp.scm:451: values */{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=0;
av2[1]=t1;
av2[2]=C_SCHEME_FALSE;
av2[3]=t2;
av2[4]=C_SCHEME_FALSE;
C_values(5,av2);}}
else{
t5=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2287,a[2]=((C_word*)t0)[3],a[3]=t4,a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[4],a[6]=t1,a[7]=((C_word*)t0)[5],tmp=(C_word)a,a+=8,tmp);
/* tcp.scm:452: read-input */
t6=((C_word*)t0)[6];
f_1659(t6,t5);}}

/* k2737 in k2733 in k2586 in k2583 in k2577 in k2571 in k2565 in k2562 in k2559 in tcp-connect in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2739(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_2739,2,av);}
/* tcp.scm:596: string-append */
t2=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* loop in a2811 in k2565 in k2562 in k2559 in tcp-connect in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_fcall f_1274(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
loop:
if(!C_demand(C_calculate_demand(5,0,4))){
C_save_and_reclaim_args((void *)trf_1274,3,t0,t1,t2);}
a=C_alloc(5);
if(C_truep(C_fixnum_greater_or_equal_p(t2,((C_word*)t0)[2]))){
/* tcp.scm:275: values */{
C_word av2[4];
av2[0]=0;
av2[1]=t1;
av2[2]=((C_word*)t0)[3];
av2[3]=C_SCHEME_FALSE;
C_values(4,av2);}}
else{
t3=C_subchar(((C_word*)t0)[3],t2);
if(C_truep(C_i_char_equalp(t3,C_make_character(58)))){
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1297,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t5=C_fixnum_plus(t2,C_fix(1));
/* tcp.scm:279: substring */
t6=*((C_word*)lf[75]+1);{
C_word av2[5];
av2[0]=t6;
av2[1]=t4;
av2[2]=((C_word*)t0)[3];
av2[3]=t5;
av2[4]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t6+1)))(5,av2);}}
else{
t4=C_fixnum_plus(t2,C_fix(1));
/* tcp.scm:285: loop */
t7=t1;
t8=t4;
t1=t7;
t2=t8;
goto loop;}}}

/* k2733 in k2586 in k2583 in k2577 in k2571 in k2565 in k2562 in k2559 in tcp-connect in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2735(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_demand(C_calculate_demand(9,c,3))){C_save_and_reclaim((void *)f_2735,2,av);}
a=C_alloc(9);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2739,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=C_a_i_bytevector(&a,1,C_fix(3));
t5=C_i_foreign_fixnum_argumentp(((C_word*)t0)[3]);
t6=stub68(t4,t5);
/* tcp.scm:163: ##sys#peek-c-string */
t7=*((C_word*)lf[7]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t7;
av2[1]=t3;
av2[2]=t6;
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t7+1)))(4,av2);}}

/* k1933 in k1930 in a1923 in k1754 in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_fcall f_1935(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_demand(C_calculate_demand(4,0,2))){
C_save_and_reclaim_args((void *)trf_1935,2,t0,t1);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1941,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep(((C_word*)((C_word*)t0)[4])[1])){
t3=((C_word*)t0)[3];
t4=C_i_foreign_fixnum_argumentp(t3);
t5=stub123(C_SCHEME_UNDEFINED,t4);
t6=t2;
f_1941(t6,C_eqp(C_fix((C_word)SOCKET_ERROR),t5));}
else{
t3=t2;
f_1941(t3,C_SCHEME_FALSE);}}

/* k1930 in a1923 in k1754 in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_fcall f_1932(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_demand(C_calculate_demand(5,0,2))){
C_save_and_reclaim_args((void *)trf_1932,2,t0,t1);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1935,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_slot(((C_word*)t0)[5],C_fix(2)))){
t3=t2;
f_1935(t3,C_SCHEME_UNDEFINED);}
else{
t3=((C_word*)t0)[3];
t4=C_fix((C_word)SHUT_WR);
t5=C_i_foreign_fixnum_argumentp(t3);
t6=C_i_foreign_fixnum_argumentp(t4);
t7=t2;
f_1935(t7,stub142(C_SCHEME_UNDEFINED,t5,t6));}}

/* k2285 in a2270 in a2260 in k2254 in k2245 in a2242 in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2287(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_2287,2,av);}
t2=C_fixnum_difference(((C_word*)((C_word*)t0)[2])[1],((C_word*)t0)[3]);
t3=C_mutate2(((C_word *)((C_word*)t0)[2])+1,t2);
if(C_truep(C_fixnum_lessp(((C_word*)((C_word*)t0)[4])[1],((C_word*)((C_word*)t0)[5])[1]))){
t4=C_fixnum_plus(((C_word*)((C_word*)t0)[4])[1],((C_word*)((C_word*)t0)[2])[1]);
t5=C_i_fixnum_min(((C_word*)((C_word*)t0)[5])[1],t4);
/* tcp.scm:455: values */{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=0;
av2[1]=((C_word*)t0)[6];
av2[2]=((C_word*)t0)[7];
av2[3]=((C_word*)((C_word*)t0)[4])[1];
av2[4]=t5;
C_values(5,av2);}}
else{
/* tcp.scm:458: values */{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=0;
av2[1]=((C_word*)t0)[6];
av2[2]=C_SCHEME_FALSE;
av2[3]=((C_word*)((C_word*)t0)[4])[1];
av2[4]=C_SCHEME_FALSE;
C_values(5,av2);}}}

/* k1399 in k1395 in k1372 in k1369 in k1363 in k1360 in k1472 in tcp-listen in k1211 in k983 in k980 in k977 */
static void C_ccall f_1401(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_1401,2,av);}
/* tcp.scm:310: string-append */
t2=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k1939 in k1933 in k1930 in a1923 in k1754 in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_fcall f_1941(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(7,0,3))){
C_save_and_reclaim_args((void *)trf_1941,2,t0,t1);}
a=C_alloc(7);
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1948,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1952,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[8]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[8]+1);
av2[1]=t3;
av2[2]=lf[46];
av2[3]=lf[10];
tp(4,av2);}}
else{
t2=((C_word*)t0)[2];{
C_word av2[2];
av2[0]=t2;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* k1946 in k1939 in k1933 in k1930 in a1923 in k1754 in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_1948(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,5))){C_save_and_reclaim((void *)f_1948,2,av);}
/* tcp.scm:525: ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[5];
av2[3]=C_SCHEME_FALSE;
av2[4]=t1;
av2[5]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}

/* k2755 in k2583 in k2577 in k2571 in k2565 in k2562 in k2559 in tcp-connect in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2757(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,5))){C_save_and_reclaim((void *)f_2757,2,av);}
/* tcp.scm:594: ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[5];
av2[3]=lf[64];
av2[4]=t1;
av2[5]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}

/* k1950 in k1939 in k1933 in k1930 in a1923 in k1754 in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_1952(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(!C_demand(C_calculate_demand(9,c,3))){C_save_and_reclaim((void *)f_1952,2,av);}
a=C_alloc(9);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1956,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=stub64(C_SCHEME_UNDEFINED);
t5=C_a_i_bytevector(&a,1,C_fix(3));
t6=C_i_foreign_fixnum_argumentp(t4);
t7=stub68(t5,t6);
/* tcp.scm:163: ##sys#peek-c-string */
t8=*((C_word*)lf[7]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t8;
av2[1]=t3;
av2[2]=t7;
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t8+1)))(4,av2);}}

/* k1954 in k1950 in k1939 in k1933 in k1930 in a1923 in k1754 in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_1956(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_1956,2,av);}
/* tcp.scm:525: string-append */
t2=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* tcp-accept-ready? in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2504(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(11,c,3))){C_save_and_reclaim((void *)f_2504,3,av);}
a=C_alloc(11);
t3=C_i_check_structure_2(t2,lf[3],lf[62]);
t4=C_slot(t2,C_fix(1));
t5=C_i_foreign_fixnum_argumentp(t4);
t6=stub159(C_SCHEME_UNDEFINED,t5);
t7=t6;
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2514,a[2]=t1,a[3]=t7,tmp=(C_word)a,a+=4,tmp);
t9=C_eqp(C_fix((C_word)SOCKET_ERROR),t7);
if(C_truep(t9)){
t10=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2527,a[2]=t8,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t11=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2531,a[2]=t10,tmp=(C_word)a,a+=3,tmp);
/* ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[8]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[8]+1);
av2[1]=t11;
av2[2]=lf[63];
av2[3]=lf[10];
tp(4,av2);}}
else{
t10=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t10;
av2[1]=C_eqp(C_fix(1),t7);
((C_proc)(void*)(*((C_word*)t10+1)))(2,av2);}}}

/* k1688 in loop in k1664 in k1661 in read-input in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_1690(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(6,c,4))){C_save_and_reclaim((void *)f_1690,2,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1693,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
/* tcp.scm:378: ##sys#thread-block-for-i/o! */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[32]+1));
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[32]+1);
av2[1]=t2;
av2[2]=*((C_word*)lf[28]+1);
av2[3]=((C_word*)t0)[5];
av2[4]=lf[33];
tp(5,av2);}}

/* k2500 in k2417 in tcp-accept in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2502(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,1))){C_save_and_reclaim((void *)f_2502,2,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];
f_2422(t2,C_a_i_plus(&a,2,((C_word*)t0)[3],t1));}

/* k2625 in k2621 in k2592 in k2589 in k2586 in k2583 in k2577 in k2571 in k2565 in k2562 in k2559 in tcp-connect in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2627(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_2627,2,av);}
/* tcp.scm:611: string-append */
t2=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k2621 in k2592 in k2589 in k2586 in k2583 in k2577 in k2571 in k2565 in k2562 in k2559 in tcp-connect in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2623(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_demand(C_calculate_demand(9,c,3))){C_save_and_reclaim((void *)f_2623,2,av);}
a=C_alloc(9);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2627,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=C_a_i_bytevector(&a,1,C_fix(3));
t5=C_i_foreign_fixnum_argumentp(((C_word*)t0)[3]);
t6=stub68(t4,t5);
/* tcp.scm:163: ##sys#peek-c-string */
t7=*((C_word*)lf[7]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t7;
av2[1]=t3;
av2[2]=t6;
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t7+1)))(4,av2);}}

/* k2512 in tcp-accept-ready? in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2514(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_2514,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_eqp(C_fix(1),((C_word*)t0)[3]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k2586 in k2583 in k2577 in k2571 in k2565 in k2562 in k2559 in tcp-connect in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2588(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(!C_demand(C_calculate_demand(16,c,3))){C_save_and_reclaim((void *)f_2588,2,av);}
a=C_alloc(16);
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2591,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],tmp=(C_word)a,a+=8,tmp);
if(C_truep(make_socket_nonblocking(((C_word*)t0)[2]))){
t3=t2;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=C_SCHEME_UNDEFINED;
f_2591(2,av2);}}
else{
t3=stub64(C_SCHEME_UNDEFINED);
t4=t3;
t5=C_i_foreign_fixnum_argumentp(((C_word*)t0)[2]);
t6=stub123(C_SCHEME_UNDEFINED,t5);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2731,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2735,a[2]=t7,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
/* ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[8]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[8]+1);
av2[1]=t8;
av2[2]=lf[68];
av2[3]=lf[10];
tp(4,av2);}}}

/* k2583 in k2577 in k2571 in k2565 in k2562 in k2559 in tcp-connect in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2585(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a;
if(!C_demand(C_calculate_demand(16,c,3))){C_save_and_reclaim((void *)f_2585,2,av);}
a=C_alloc(16);
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2588,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],tmp=(C_word)a,a+=8,tmp);
t3=C_i_foreign_fixnum_argumentp(((C_word*)t0)[2]);
t4=stub164(C_SCHEME_UNDEFINED,t3);
t5=C_eqp(C_fix((C_word)SOCKET_ERROR),t4);
if(C_truep(t5)){
t6=stub64(C_SCHEME_UNDEFINED);
t7=t6;
t8=C_i_foreign_fixnum_argumentp(((C_word*)t0)[2]);
t9=stub123(C_SCHEME_UNDEFINED,t8);
t10=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2757,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t11=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2761,a[2]=t10,a[3]=t7,tmp=(C_word)a,a+=4,tmp);
/* ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[8]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[8]+1);
av2[1]=t11;
av2[2]=lf[69];
av2[3]=lf[10];
tp(4,av2);}}
else{
t6=t2;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t6;
av2[1]=C_SCHEME_UNDEFINED;
f_2588(2,av2);}}}

/* tcp-listener? in k1211 in k983 in k980 in k977 */
static void C_ccall f_1554(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_1554,3,av);}
t3=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=(C_truep(C_blockp(t2))?C_i_structurep(t2,lf[3]):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* k2589 in k2586 in k2583 in k2577 in k2571 in k2565 in k2562 in k2559 in tcp-connect in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2591(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_demand(C_calculate_demand(15,c,2))){C_save_and_reclaim((void *)f_2591,2,av);}
a=C_alloc(15);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2594,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_2657,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t4,a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word)li30),tmp=(C_word)a,a+=9,tmp));
t6=((C_word*)t4)[1];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t6;
av2[1]=t2;
f_2657(2,av2);}}

/* tcp-listener-port in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2992(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(12,c,3))){C_save_and_reclaim((void *)f_2992,3,av);}
a=C_alloc(12);
t3=C_i_check_structure_2(t2,lf[3],lf[86]);
t4=C_slot(t2,C_fix(1));
t5=t4;
t6=C_i_foreign_fixnum_argumentp(t5);
t7=stub190(C_SCHEME_UNDEFINED,t6);
t8=t7;
t9=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3005,a[2]=t1,a[3]=t8,tmp=(C_word)a,a+=4,tmp);
t10=C_eqp(C_fix(-1),t8);
if(C_truep(t10)){
t11=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3015,a[2]=t9,a[3]=t2,a[4]=t5,tmp=(C_word)a,a+=5,tmp);
t12=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3019,a[2]=t11,tmp=(C_word)a,a+=3,tmp);
/* ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[8]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[8]+1);
av2[1]=t12;
av2[2]=lf[87];
av2[3]=lf[10];
tp(4,av2);}}
else{
t11=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t11;
av2[1]=t8;
((C_proc)(void*)(*((C_word*)t11+1)))(2,av2);}}}

/* k2592 in k2589 in k2586 in k2583 in k2577 in k2571 in k2565 in k2562 in k2559 in tcp-connect in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2594(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word *a;
if(!C_demand(C_calculate_demand(12,c,3))){C_save_and_reclaim((void *)f_2594,2,av);}
a=C_alloc(12);
t2=C_i_foreign_fixnum_argumentp(((C_word*)t0)[2]);
t3=stub614(C_SCHEME_UNDEFINED,t2);
t4=t3;
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2600,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t6=C_eqp(C_fix((C_word)SOCKET_ERROR),t4);
if(C_truep(t6)){
t7=stub64(C_SCHEME_UNDEFINED);
t8=t7;
t9=C_i_foreign_fixnum_argumentp(((C_word*)t0)[2]);
t10=stub123(C_SCHEME_UNDEFINED,t9);
t11=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2619,a[2]=t5,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t12=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2623,a[2]=t11,a[3]=t8,tmp=(C_word)a,a+=4,tmp);
/* ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[8]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[8]+1);
av2[1]=t12;
av2[2]=lf[65];
av2[3]=lf[10];
tp(4,av2);}}
else{
if(C_truep(C_fixnum_greaterp(t4,C_fix(0)))){
t7=C_i_foreign_fixnum_argumentp(((C_word*)t0)[2]);
t8=stub123(C_SCHEME_UNDEFINED,t7);
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2645,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
t10=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2649,a[2]=t9,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
/* ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[8]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[8]+1);
av2[1]=t10;
av2[2]=lf[66];
av2[3]=lf[10];
tp(4,av2);}}
else{
/* tcp.scm:615: ##net#io-ports */
t7=lf[27];
f_1642(t7,((C_word*)t0)[3],lf[64],((C_word*)t0)[2]);}}}

/* k2254 in k2245 in a2242 in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_fcall f_2256(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_demand(C_calculate_demand(15,0,5))){
C_save_and_reclaim_args((void *)trf_2256,2,t0,t1);}
a=C_alloc(15);
t2=t1;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2261,a[2]=((C_word*)t0)[2],a[3]=t3,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word)li22),tmp=(C_word)a,a+=8,tmp);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2317,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[2],a[4]=((C_word)li23),tmp=(C_word)a,a+=5,tmp);
/* tcp.scm:442: ##sys#call-with-values */{
C_word av2[4];
av2[0]=0;
av2[1]=((C_word*)t0)[7];
av2[2]=t4;
av2[3]=t5;
C_call_with_values(4,av2);}}

/* k1295 in loop in a2811 in k2565 in k2562 in k2559 in tcp-connect in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_1297(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,4))){C_save_and_reclaim((void *)f_1297,2,av);}
a=C_alloc(4);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1301,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* tcp.scm:280: substring */
t4=*((C_word*)lf[75]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[3];
av2[3]=C_fix(0);
av2[4]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t4+1)))(5,av2);}}

/* k2647 in k2592 in k2589 in k2586 in k2583 in k2577 in k2571 in k2565 in k2562 in k2559 in tcp-connect in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2649(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_demand(C_calculate_demand(9,c,3))){C_save_and_reclaim((void *)f_2649,2,av);}
a=C_alloc(9);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2653,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=C_a_i_bytevector(&a,1,C_fix(3));
t5=C_i_foreign_fixnum_argumentp(((C_word*)t0)[3]);
t6=stub68(t4,t5);
/* tcp.scm:163: ##sys#peek-c-string */
t7=*((C_word*)lf[7]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t7;
av2[1]=t3;
av2[2]=t6;
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t7+1)))(4,av2);}}

/* k2643 in k2592 in k2589 in k2586 in k2583 in k2577 in k2571 in k2565 in k2562 in k2559 in tcp-connect in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2645(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_2645,2,av);}
/* tcp.scm:614: ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[5];
av2[3]=lf[64];
av2[4]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(5,av2);}}

/* f_1994 in k1754 in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_1994(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(4,c,2))){C_save_and_reclaim((void *)f_1994,2,av);}
a=C_alloc(4);
t2=C_block_size(((C_word*)((C_word*)t0)[2])[1]);
if(C_truep(C_fixnum_greaterp(t2,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2004,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* tcp.scm:529: output */
t4=((C_word*)t0)[3];
f_1757(t4,t3,((C_word*)((C_word*)t0)[2])[1]);}
else{
t3=C_SCHEME_UNDEFINED;
t4=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* loop in k2589 in k2586 in k2583 in k2577 in k2571 in k2565 in k2562 in k2559 in tcp-connect in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2657(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(10,c,3))){C_save_and_reclaim((void *)f_2657,2,av);}
a=C_alloc(10);
t2=C_fix((C_word)sizeof(struct sockaddr_in));
t3=C_i_foreign_fixnum_argumentp(((C_word*)t0)[2]);
t4=(C_truep(((C_word*)t0)[3])?C_i_foreign_block_argumentp(((C_word*)t0)[3]):C_SCHEME_FALSE);
t5=C_i_foreign_fixnum_argumentp(t2);
t6=stub150(C_SCHEME_UNDEFINED,t3,t4,t5);
t7=C_eqp(C_fix((C_word)SOCKET_ERROR),t6);
if(C_truep(t7)){
if(C_truep(stub76(C_SCHEME_UNDEFINED))){
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2673,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
if(C_truep(((C_word*)t0)[4])){
/* tcp.scm:601: ##sys#thread-block-for-timeout! */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[34]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[34]+1);
av2[1]=t8;
av2[2]=*((C_word*)lf[28]+1);
av2[3]=((C_word*)t0)[4];
tp(4,av2);}}
else{
t9=t8;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t9;
av2[1]=C_SCHEME_UNDEFINED;
f_2673(2,av2);}}}
else{
if(C_truep(stub79(C_SCHEME_UNDEFINED))){
/* tcp.scm:605: ##sys#dispatch-interrupt */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[35]+1));
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[35]+1);
av2[1]=t1;
av2[2]=((C_word*)((C_word*)t0)[5])[1];
tp(3,av2);}}
else{
t8=stub64(C_SCHEME_UNDEFINED);
t9=t8;
t10=C_i_foreign_fixnum_argumentp(((C_word*)t0)[2]);
t11=stub123(C_SCHEME_UNDEFINED,t10);
t12=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2704,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],tmp=(C_word)a,a+=6,tmp);
t13=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2708,a[2]=t12,a[3]=t9,tmp=(C_word)a,a+=4,tmp);
/* ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[8]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[8]+1);
av2[1]=t13;
av2[2]=lf[67];
av2[3]=lf[10];
tp(4,av2);}}}}
else{
t8=C_SCHEME_UNDEFINED;
t9=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t9;
av2[1]=t8;
((C_proc)(void*)(*((C_word*)t9+1)))(2,av2);}}}

/* k2651 in k2647 in k2592 in k2589 in k2586 in k2583 in k2577 in k2571 in k2565 in k2562 in k2559 in tcp-connect in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2653(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_2653,2,av);}
/* tcp.scm:614: string-append */
t2=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* loop in a2177 in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_fcall f_2184(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word *a;
loop:
if(!C_demand(C_calculate_demand(8,0,4))){
C_save_and_reclaim_args((void *)trf_2184,5,t0,t1,t2,t3,t4);}
a=C_alloc(8);
t5=C_eqp(t2,C_fix(0));
if(C_truep(t5)){
t6=t3;
t7=t1;{
C_word av2[2];
av2[0]=t7;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
if(C_truep(C_fixnum_lessp(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]))){
t6=C_fixnum_difference(((C_word*)((C_word*)t0)[3])[1],((C_word*)((C_word*)t0)[2])[1]);
t7=C_fixnum_lessp(t2,t6);
t8=(C_truep(t7)?t2:t6);
t9=C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],t8);
t10=C_substring_copy(((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)((C_word*)t0)[2])[1],t9,t4);
t11=C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],t8);
t12=C_mutate2(((C_word *)((C_word*)t0)[2])+1,t11);
t13=C_fixnum_difference(t2,t8);
t14=C_fixnum_plus(t3,t8);
t15=C_fixnum_plus(t4,t8);
/* tcp.scm:431: loop */
t17=t1;
t18=t13;
t19=t14;
t20=t15;
t1=t17;
t2=t18;
t3=t19;
t4=t20;
goto loop;}
else{
t6=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2232,a[2]=((C_word*)t0)[3],a[3]=t3,a[4]=t1,a[5]=((C_word*)t0)[6],a[6]=t2,a[7]=t4,tmp=(C_word)a,a+=8,tmp);
/* tcp.scm:433: read-input */
t7=((C_word*)t0)[7];
f_1659(t7,t6);}}}

/* k1500 in k1478 in k1472 in tcp-listen in k1211 in k983 in k980 in k977 */
static void C_ccall f_1502(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,6))){C_save_and_reclaim((void *)f_1502,2,av);}
/* tcp.scm:322: ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);{
C_word *av2;
if(c >= 7) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(7);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[5];
av2[3]=lf[2];
av2[4]=t1;
av2[5]=((C_word*)t0)[3];
av2[6]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t2+1)))(7,av2);}}

/* k1504 in k1478 in k1472 in tcp-listen in k1211 in k983 in k980 in k977 */
static void C_ccall f_1506(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_demand(C_calculate_demand(9,c,3))){C_save_and_reclaim((void *)f_1506,2,av);}
a=C_alloc(9);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1510,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=C_a_i_bytevector(&a,1,C_fix(3));
t5=C_i_foreign_fixnum_argumentp(((C_word*)t0)[3]);
t6=stub68(t4,t5);
/* tcp.scm:163: ##sys#peek-c-string */
t7=*((C_word*)lf[7]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t7;
av2[1]=t3;
av2[2]=t6;
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t7+1)))(4,av2);}}

/* k3003 in tcp-listener-port in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_3005(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_3005,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* tcp-addresses in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2854(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(4,c,2))){C_save_and_reclaim((void *)f_2854,3,av);}
a=C_alloc(4);
t3=t2;
t4=C_i_check_port_2(t3,C_fix(0),C_SCHEME_TRUE,lf[80]);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2860,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* tcp.scm:625: ##sys#tcp-port->fileno */
t6=*((C_word*)lf[76]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t6;
av2[1]=t5;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}

/* k2907 in k2865 in k2858 in tcp-addresses in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2909(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(!C_demand(C_calculate_demand(9,c,3))){C_save_and_reclaim((void *)f_2909,2,av);}
a=C_alloc(9);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2913,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=stub64(C_SCHEME_UNDEFINED);
t5=C_a_i_bytevector(&a,1,C_fix(3));
t6=C_i_foreign_fixnum_argumentp(t4);
t7=stub68(t5,t6);
/* tcp.scm:163: ##sys#peek-c-string */
t8=*((C_word*)lf[7]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t8;
av2[1]=t3;
av2[2]=t7;
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t8+1)))(4,av2);}}

/* k2903 in k2865 in k2858 in tcp-addresses in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2905(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,5))){C_save_and_reclaim((void *)f_2905,2,av);}
/* tcp.scm:627: ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[5];
av2[3]=lf[80];
av2[4]=t1;
av2[5]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}

/* k1363 in k1360 in k1472 in tcp-listen in k1211 in k983 in k980 in k977 */
static void C_ccall f_1365(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(!C_demand(C_calculate_demand(7,c,2))){C_save_and_reclaim((void *)f_1365,2,av);}
a=C_alloc(7);
t2=C_fix((C_word)AF_INET);
t3=C_i_foreign_fixnum_argumentp(t2);
t4=C_i_foreign_fixnum_argumentp(((C_word*)t0)[2]);
t5=C_i_foreign_fixnum_argumentp(C_fix(0));
t6=stub85(C_SCHEME_UNDEFINED,t3,t4,t5);
t7=t6;
t8=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_1371,a[2]=((C_word*)t0)[3],a[3]=t7,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],tmp=(C_word)a,a+=7,tmp);
t9=C_eqp(C_fix((C_word)INVALID_SOCKET),t7);
if(C_truep(t9)){
/* tcp.scm:305: ##sys#error */
t10=*((C_word*)lf[13]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t10;
av2[1]=t8;
av2[2]=lf[14];
((C_proc)(void*)(*((C_word*)t10+1)))(3,av2);}}
else{
t10=t8;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t10;
av2[1]=C_SCHEME_UNDEFINED;
f_1371(2,av2);}}}

/* k2826 in k2559 in tcp-connect in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2828(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,1))){C_save_and_reclaim((void *)f_2828,2,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];
f_2564(t2,C_a_i_plus(&a,2,t1,((C_word*)t0)[3]));}

/* k1360 in k1472 in tcp-listen in k1211 in k983 in k980 in k977 */
static void C_ccall f_1362(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_demand(C_calculate_demand(12,c,4))){C_save_and_reclaim((void *)f_1362,2,av);}
a=C_alloc(12);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_1365,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
if(C_truep(((C_word*)t0)[4])){
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1447,a[2]=t3,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
/* tcp.scm:298: ##net#gethostaddr */
f_1240(t4,t2,((C_word*)t0)[4],((C_word*)t0)[5]);}
else{
t4=(C_truep(t2)?C_i_foreign_block_argumentp(t2):C_SCHEME_FALSE);
t5=C_i_foreign_fixnum_argumentp(((C_word*)t0)[5]);
t6=t3;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t6;
av2[1]=stub350(C_SCHEME_UNDEFINED,t4,t5);
f_1365(2,av2);}}}

/* k3013 in tcp-listener-port in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_3015(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,6))){C_save_and_reclaim((void *)f_3015,2,av);}
/* tcp.scm:648: ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);{
C_word *av2;
if(c >= 7) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(7);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[5];
av2[3]=lf[86];
av2[4]=t1;
av2[5]=((C_word*)t0)[3];
av2[6]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t2+1)))(7,av2);}}

/* k3017 in tcp-listener-port in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_3019(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(!C_demand(C_calculate_demand(9,c,3))){C_save_and_reclaim((void *)f_3019,2,av);}
a=C_alloc(9);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3023,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=stub64(C_SCHEME_UNDEFINED);
t5=C_a_i_bytevector(&a,1,C_fix(3));
t6=C_i_foreign_fixnum_argumentp(t4);
t7=stub68(t5,t6);
/* tcp.scm:163: ##sys#peek-c-string */
t8=*((C_word*)lf[7]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t8;
av2[1]=t3;
av2[2]=t7;
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t8+1)))(4,av2);}}

/* k1415 in k1369 in k1363 in k1360 in k1472 in tcp-listen in k1211 in k983 in k980 in k977 */
static void C_ccall f_1417(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,5))){C_save_and_reclaim((void *)f_1417,2,av);}
/* tcp.scm:308: ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[5];
av2[3]=lf[2];
av2[4]=t1;
av2[5]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}

/* a2177 in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2178(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5=av[5];
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(c!=6) C_bad_argc_2(c,6,t0);
if(!C_demand(C_calculate_demand(11,c,5))){C_save_and_reclaim((void *)f_2178,6,av);}
a=C_alloc(11);
t6=C_SCHEME_UNDEFINED;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_set_block_item(t7,0,(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_2184,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t4,a[6]=t7,a[7]=((C_word*)t0)[5],a[8]=((C_word)li19),tmp=(C_word)a,a+=9,tmp));
t9=((C_word*)t7)[1];
f_2184(t9,t1,t3,C_fix(0),t5);}

/* k1375 in k1372 in k1369 in k1363 in k1360 in k1472 in tcp-listen in k1211 in k983 in k980 in k977 */
static void C_ccall f_1377(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_1377,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k1372 in k1369 in k1363 in k1360 in k1472 in tcp-listen in k1211 in k983 in k980 in k977 */
static void C_ccall f_1374(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a;
if(!C_demand(C_calculate_demand(14,c,3))){C_save_and_reclaim((void *)f_1374,2,av);}
a=C_alloc(14);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1377,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=C_fix((C_word)sizeof(struct sockaddr_in));
t4=C_i_foreign_fixnum_argumentp(((C_word*)t0)[3]);
t5=(C_truep(((C_word*)t0)[4])?C_i_foreign_block_argumentp(((C_word*)t0)[4]):C_SCHEME_FALSE);
t6=C_i_foreign_fixnum_argumentp(t3);
t7=stub94(C_SCHEME_UNDEFINED,t4,t5,t6);
t8=C_eqp(C_fix((C_word)SOCKET_ERROR),t7);
if(C_truep(t8)){
t9=stub64(C_SCHEME_UNDEFINED);
t10=t9;
t11=C_i_foreign_fixnum_argumentp(((C_word*)t0)[3]);
t12=stub123(C_SCHEME_UNDEFINED,t11);
t13=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1393,a[2]=t2,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],tmp=(C_word)a,a+=6,tmp);
t14=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1397,a[2]=t13,a[3]=t10,tmp=(C_word)a,a+=4,tmp);
/* ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[8]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[8]+1);
av2[1]=t14;
av2[2]=lf[11];
av2[3]=lf[10];
tp(4,av2);}}
else{
t9=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t9;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t9+1)))(2,av2);}}}

/* k3021 in k3017 in tcp-listener-port in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_3023(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_3023,2,av);}
/* tcp.scm:648: string-append */
t2=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k1369 in k1363 in k1360 in k1472 in tcp-listen in k1211 in k983 in k980 in k977 */
static void C_ccall f_1371(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(!C_demand(C_calculate_demand(14,c,3))){C_save_and_reclaim((void *)f_1371,2,av);}
a=C_alloc(14);
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_1374,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],tmp=(C_word)a,a+=7,tmp);
t3=C_i_foreign_fixnum_argumentp(((C_word*)t0)[3]);
t4=stub164(C_SCHEME_UNDEFINED,t3);
t5=C_eqp(C_fix((C_word)SOCKET_ERROR),t4);
if(C_truep(t5)){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1417,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1421,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[8]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[8]+1);
av2[1]=t7;
av2[2]=lf[12];
av2[3]=lf[10];
tp(4,av2);}}
else{
t6=t2;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t6;
av2[1]=C_SCHEME_UNDEFINED;
f_1374(2,av2);}}}

/* k2925 in tcp-port-numbers in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2927(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a;
if(!C_demand(C_calculate_demand(13,c,3))){C_save_and_reclaim((void *)f_2927,2,av);}
a=C_alloc(13);
t2=C_i_foreign_fixnum_argumentp(t1);
t3=stub190(C_SCHEME_UNDEFINED,t2);
t4=t3;
t5=C_i_foreign_fixnum_argumentp(t1);
t6=stub195(C_SCHEME_UNDEFINED,t5);
t7=t6;
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2936,a[2]=((C_word*)t0)[2],a[3]=t4,a[4]=t7,a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
t9=C_eqp(C_fix(-1),t4);
if(C_truep(t9)){
t10=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2976,a[2]=t8,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t11=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2980,a[2]=t10,tmp=(C_word)a,a+=3,tmp);
/* ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[8]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[8]+1);
av2[1]=t11;
av2[2]=lf[85];
av2[3]=lf[10];
tp(4,av2);}}
else{
t10=t8;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t10;
av2[1]=C_SCHEME_UNDEFINED;
f_2936(2,av2);}}}

/* tcp-port-numbers in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2921(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(4,c,2))){C_save_and_reclaim((void *)f_2921,3,av);}
a=C_alloc(4);
t3=t2;
t4=C_i_check_port_2(t3,C_fix(0),C_SCHEME_TRUE,lf[83]);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2927,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* tcp.scm:634: ##sys#tcp-port->fileno */
t6=*((C_word*)lf[76]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t6;
av2[1]=t5;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}

/* k1770 in k1759 in output in k1754 in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_fcall f_1772(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(9,0,5))){
C_save_and_reclaim_args((void *)trf_1772,2,t0,t1);}
a=C_alloc(9);
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_1774,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,a[5]=((C_word*)t0)[4],a[6]=((C_word)li9),tmp=(C_word)a,a+=7,tmp));
t5=((C_word*)t3)[1];
f_1774(t5,((C_word*)t0)[5],((C_word*)t0)[6],C_fix(0),t1);}

/* loop in k1770 in k1759 in output in k1754 in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_fcall f_1774(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word *a;
loop:
if(!C_demand(C_calculate_demand(9,0,4))){
C_save_and_reclaim_args((void *)trf_1774,5,t0,t1,t2,t3,t4);}
a=C_alloc(9);
t5=C_i_fixnum_min(C_fix(8192),t2);
t6=((C_word*)t0)[2];
t7=((C_word*)t0)[3];
t8=t3;
t9=C_i_foreign_fixnum_argumentp(t6);
t10=(C_truep(t7)?C_i_foreign_block_argumentp(t7):C_SCHEME_FALSE);
t11=C_i_foreign_fixnum_argumentp(t8);
t12=C_i_foreign_fixnum_argumentp(t5);
t13=C_i_foreign_fixnum_argumentp(C_fix(0));
t14=stub173(C_SCHEME_UNDEFINED,t9,t10,t11,t12,t13);
t15=C_eqp(C_fix((C_word)SOCKET_ERROR),t14);
if(C_truep(t15)){
if(C_truep(stub73(C_SCHEME_UNDEFINED))){
t16=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_1796,a[2]=((C_word*)t0)[4],a[3]=t1,a[4]=t2,a[5]=t3,a[6]=t4,a[7]=((C_word*)t0)[5],a[8]=((C_word*)t0)[2],tmp=(C_word)a,a+=9,tmp);
if(C_truep(t4)){
/* tcp.scm:486: ##sys#thread-block-for-timeout! */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[34]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[34]+1);
av2[1]=t16;
av2[2]=*((C_word*)lf[28]+1);
av2[3]=t4;
tp(4,av2);}}
else{
t17=t16;{
C_word av2[2];
av2[0]=t17;
av2[1]=C_SCHEME_UNDEFINED;
f_1796(2,av2);}}}
else{
if(C_truep(stub79(C_SCHEME_UNDEFINED))){
t16=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_1828,a[2]=((C_word*)t0)[4],a[3]=t2,a[4]=t3,a[5]=t4,a[6]=((C_word)li8),tmp=(C_word)a,a+=7,tmp);
/* tcp.scm:496: ##sys#dispatch-interrupt */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[35]+1));
C_word av2[3];
av2[0]=*((C_word*)lf[35]+1);
av2[1]=t1;
av2[2]=t16;
tp(3,av2);}}
else{
t16=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1839,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t17=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1843,a[2]=t16,tmp=(C_word)a,a+=3,tmp);
/* ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[8]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[8]+1);
av2[1]=t17;
av2[2]=lf[40];
av2[3]=lf[10];
tp(4,av2);}}}}
else{
if(C_truep(C_fixnum_lessp(t14,t2))){
t16=C_fixnum_difference(t2,t14);
t17=t16;
t18=C_fixnum_plus(t3,t14);
t19=t18;
t20=C_eqp(t14,C_fix(0));
if(C_truep(t20)){
/* tcp.scm:501: loop */
t23=t1;
t24=t17;
t25=t19;
t26=((C_word*)t0)[5];
t1=t23;
t2=t24;
t3=t25;
t4=t26;
goto loop;}
else{
if(C_truep(((C_word*)t0)[5])){
t21=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_1887,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[4],a[4]=t1,a[5]=t17,a[6]=t19,tmp=(C_word)a,a+=7,tmp);
/* tcp.scm:505: current-milliseconds */
t22=*((C_word*)lf[37]+1);{
C_word av2[2];
av2[0]=t22;
av2[1]=t21;
((C_proc)(void*)(*((C_word*)t22+1)))(2,av2);}}
else{
/* tcp.scm:501: loop */
t23=t1;
t24=t17;
t25=t19;
t26=C_SCHEME_FALSE;
t1=t23;
t2=t24;
t3=t25;
t4=t26;
goto loop;}}}
else{
t16=t1;{
C_word av2[2];
av2[0]=t16;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t16+1)))(2,av2);}}}}

/* k2838 in tcp-port->fileno in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2840(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_2840,2,av);}
if(C_truep(C_i_vectorp(t1))){
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_slot(t1,C_fix(0));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
/* tcp.scm:621: error */
t2=*((C_word*)lf[77]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[76];
av2[3]=lf[78];
av2[4]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(5,av2);}}}

/* k1391 in k1372 in k1369 in k1363 in k1360 in k1472 in tcp-listen in k1211 in k983 in k980 in k977 */
static void C_ccall f_1393(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,7))){C_save_and_reclaim((void *)f_1393,2,av);}
/* tcp.scm:310: ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);{
C_word *av2;
if(c >= 8) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(8);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[5];
av2[3]=lf[2];
av2[4]=t1;
av2[5]=((C_word*)t0)[3];
av2[6]=((C_word*)t0)[4];
av2[7]=((C_word*)t0)[5];
((C_proc)(void*)(*((C_word*)t2+1)))(8,av2);}}

/* k1395 in k1372 in k1369 in k1363 in k1360 in k1472 in tcp-listen in k1211 in k983 in k980 in k977 */
static void C_ccall f_1397(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_demand(C_calculate_demand(9,c,3))){C_save_and_reclaim((void *)f_1397,2,av);}
a=C_alloc(9);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1401,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=C_a_i_bytevector(&a,1,C_fix(3));
t5=C_i_foreign_fixnum_argumentp(((C_word*)t0)[3]);
t6=stub68(t4,t5);
/* tcp.scm:163: ##sys#peek-c-string */
t7=*((C_word*)lf[7]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t7;
av2[1]=t3;
av2[2]=t6;
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t7+1)))(4,av2);}}

/* k2525 in tcp-accept-ready? in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2527(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,5))){C_save_and_reclaim((void *)f_2527,2,av);}
/* tcp.scm:567: ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[5];
av2[3]=lf[62];
av2[4]=t1;
av2[5]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}

/* k2162 in a2159 in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2164(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_2164,2,av);}
if(C_truep(C_fixnum_lessp(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]))){
t2=C_subchar(((C_word*)t0)[4],((C_word*)((C_word*)t0)[2])[1]);
t3=((C_word*)t0)[5];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t2=((C_word*)t0)[5];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_SCHEME_END_OF_FILE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* a2159 in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2160(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(6,c,2))){C_save_and_reclaim((void *)f_2160,2,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2164,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
if(C_truep(C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]))){
/* tcp.scm:419: read-input */
t3=((C_word*)t0)[5];
f_1659(t3,t2);}
else{
t3=t2;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=C_SCHEME_UNDEFINED;
f_2164(2,av2);}}}

/* k2533 in k2529 in tcp-accept-ready? in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2535(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_2535,2,av);}
/* tcp.scm:567: string-append */
t2=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k2417 in tcp-accept in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2419(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(10,c,2))){C_save_and_reclaim((void *)f_2419,2,av);}
a=C_alloc(10);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2422,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
if(C_truep(t2)){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2502,a[2]=t3,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* tcp.scm:543: current-milliseconds */
t5=*((C_word*)lf[37]+1);{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
t4=t3;
f_2422(t4,C_SCHEME_FALSE);}}

/* k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_1646(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(5,c,3))){C_save_and_reclaim((void *)f_1646,2,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1649,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[57]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[57]+1);
av2[1]=t2;
av2[2]=C_fix(1024);
av2[3]=C_make_character(32);
tp(4,av2);}}

/* k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_1640(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a;
if(!C_demand(C_calculate_demand(31,c,4))){C_save_and_reclaim((void *)f_1640,2,av);}
a=C_alloc(31);
t2=C_mutate2((C_word*)lf[26]+1 /* (set! tcp-accept-timeout ...) */,t1);
t3=*((C_word*)lf[22]+1);
t4=C_mutate2(&lf[27] /* (set! ##net#io-ports ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1642,a[2]=t3,a[3]=((C_word)li26),tmp=(C_word)a,a+=4,tmp));
t5=C_mutate2((C_word*)lf[59]+1 /* (set! tcp-accept ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2409,a[2]=((C_word)li28),tmp=(C_word)a,a+=3,tmp));
t6=C_mutate2((C_word*)lf[62]+1 /* (set! tcp-accept-ready? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2504,a[2]=((C_word)li29),tmp=(C_word)a,a+=3,tmp));
t7=C_mutate2((C_word*)lf[64]+1 /* (set! tcp-connect ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2554,a[2]=((C_word)li34),tmp=(C_word)a,a+=3,tmp));
t8=C_mutate2((C_word*)lf[76]+1 /* (set! ##sys#tcp-port->fileno ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2836,a[2]=((C_word)li35),tmp=(C_word)a,a+=3,tmp));
t9=C_mutate2((C_word*)lf[80]+1 /* (set! tcp-addresses ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2854,a[2]=((C_word)li36),tmp=(C_word)a,a+=3,tmp));
t10=C_mutate2((C_word*)lf[83]+1 /* (set! tcp-port-numbers ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2921,a[2]=((C_word)li37),tmp=(C_word)a,a+=3,tmp));
t11=C_mutate2((C_word*)lf[86]+1 /* (set! tcp-listener-port ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2992,a[2]=((C_word)li38),tmp=(C_word)a,a+=3,tmp));
t12=C_mutate2((C_word*)lf[88]+1 /* (set! tcp-abandon-port ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3031,a[2]=((C_word)li39),tmp=(C_word)a,a+=3,tmp));
t13=C_mutate2((C_word*)lf[89]+1 /* (set! tcp-listener-fileno ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3050,a[2]=((C_word)li40),tmp=(C_word)a,a+=3,tmp));
t14=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t14;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t14+1)))(2,av2);}}

/* k2529 in tcp-accept-ready? in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2531(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(!C_demand(C_calculate_demand(9,c,3))){C_save_and_reclaim((void *)f_2531,2,av);}
a=C_alloc(9);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2535,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=stub64(C_SCHEME_UNDEFINED);
t5=C_a_i_bytevector(&a,1,C_fix(3));
t6=C_i_foreign_fixnum_argumentp(t4);
t7=stub68(t5,t6);
/* tcp.scm:163: ##sys#peek-c-string */
t8=*((C_word*)lf[7]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t8;
av2[1]=t3;
av2[2]=t7;
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t8+1)))(4,av2);}}

/* ##net#io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_fcall f_1642(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a;
if(!C_demand(C_calculate_demand(14,0,3))){
C_save_and_reclaim_args((void *)trf_1642,4,t0,t1,t2,t3);}
a=C_alloc(14);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1646,a[2]=t3,a[3]=t1,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
if(C_truep(make_socket_nonblocking(t3))){
t5=t4;{
C_word av2[2];
av2[0]=t5;
av2[1]=C_SCHEME_UNDEFINED;
f_1646(2,av2);}}
else{
t5=stub64(C_SCHEME_UNDEFINED);
t6=t5;
t7=t3;
t8=C_i_foreign_fixnum_argumentp(t7);
t9=stub123(C_SCHEME_UNDEFINED,t8);
t10=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2397,a[2]=t4,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t11=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2401,a[2]=t10,a[3]=t6,tmp=(C_word)a,a+=4,tmp);
/* ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[8]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[8]+1);
av2[1]=t11;
av2[2]=lf[58];
av2[3]=lf[10];
tp(4,av2);}}}

/* loop in k2420 in k2417 in tcp-accept in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2427(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(7,c,3))){C_save_and_reclaim((void *)f_2427,2,av);}
a=C_alloc(7);
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2431,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
if(C_truep(((C_word*)t0)[6])){
/* tcp.scm:546: ##sys#thread-block-for-timeout! */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[34]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[34]+1);
av2[1]=t2;
av2[2]=*((C_word*)lf[28]+1);
av2[3]=((C_word*)t0)[6];
tp(4,av2);}}
else{
t3=t2;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=C_SCHEME_UNDEFINED;
f_2431(2,av2);}}}

/* k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_1655(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(11,c,2))){C_save_and_reclaim((void *)f_1655,2,av);}
a=C_alloc(11);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_1658,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=t2,a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],tmp=(C_word)a,a+=11,tmp);
if(C_truep(t2)){
t4=C_fixnum_greaterp(t2,C_fix(0));
t5=t3;
f_1658(t5,(C_truep(t4)?lf[56]:C_SCHEME_FALSE));}
else{
t4=t3;
f_1658(t4,C_SCHEME_FALSE);}}

/* k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_1649(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a;
if(!C_demand(C_calculate_demand(24,c,2))){C_save_and_reclaim((void *)f_1649,2,av);}
a=C_alloc(24);
t2=t1;
t3=C_a_i_vector5(&a,5,((C_word*)t0)[2],C_SCHEME_FALSE,C_SCHEME_FALSE,t2,C_fix(0));
t4=t3;
t5=C_fix(0);
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_fix(0);
t8=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t9=C_SCHEME_FALSE;
t10=(*a=C_VECTOR_TYPE|1,a[1]=t9,tmp=(C_word)a,a+=2,tmp);
t11=C_SCHEME_FALSE;
t12=(*a=C_VECTOR_TYPE|1,a[1]=t11,tmp=(C_word)a,a+=2,tmp);
t13=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_1655,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=t6,a[5]=t4,a[6]=t8,a[7]=((C_word*)t0)[3],a[8]=t12,a[9]=t10,tmp=(C_word)a,a+=10,tmp);
/* tcp.scm:365: tbs */
t14=((C_word*)t0)[4];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t14;
av2[1]=t13;
((C_proc)(void*)(*((C_word*)t14+1)))(2,av2);}}

/* k2420 in k2417 in tcp-accept in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_fcall f_2422(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_demand(C_calculate_demand(10,0,2))){
C_save_and_reclaim_args((void *)trf_2422,2,t0,t1);}
a=C_alloc(10);
t2=t1;
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2427,a[2]=((C_word*)t0)[2],a[3]=t4,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=t2,a[7]=((C_word)li27),tmp=(C_word)a,a+=8,tmp));
t6=((C_word*)t4)[1];{
C_word av2[2];
av2[0]=t6;
av2[1]=((C_word*)t0)[5];
f_2427(2,av2);}}

/* tcp-connect in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2554(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +9,c,2))){
C_save_and_reclaim((void*)f_2554,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+9);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t5=C_i_nullp(t3);
t6=(C_truep(t5)?C_SCHEME_FALSE:C_i_car(t3));
t7=t6;
t8=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2561,a[2]=t4,a[3]=t8,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* tcp.scm:580: tcp-connect-timeout */
t10=*((C_word*)lf[25]+1);{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t10;
av2[1]=t9;
((C_proc)(void*)(*((C_word*)t10+1)))(2,av2);}}

/* k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_fcall f_1658(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word *a;
if(!C_demand(C_calculate_demand(66,0,8))){
C_save_and_reclaim_args((void *)trf_1658,2,t0,t1);}
a=C_alloc(66);
t2=t1;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_1659,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word)li7),tmp=(C_word)a,a+=8,tmp);
t5=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_1756,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[5],a[5]=t3,a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],tmp=(C_word)a,a+=9,tmp);
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2046,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[3],a[5]=t4,a[6]=((C_word)li15),tmp=(C_word)a,a+=7,tmp);
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2068,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[2],a[5]=((C_word)li16),tmp=(C_word)a,a+=6,tmp);
t8=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2110,a[2]=((C_word*)t0)[10],a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[9],a[5]=((C_word*)t0)[5],a[6]=((C_word)li17),tmp=(C_word)a,a+=7,tmp);
t9=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2160,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[3],a[5]=t4,a[6]=((C_word)li18),tmp=(C_word)a,a+=7,tmp);
t10=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2178,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[3],a[5]=t4,a[6]=((C_word)li20),tmp=(C_word)a,a+=7,tmp);
t11=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2243,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[3],a[5]=t4,a[6]=((C_word)li24),tmp=(C_word)a,a+=7,tmp);
t12=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2366,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[3],a[5]=((C_word)li25),tmp=(C_word)a,a+=6,tmp);
/* tcp.scm:394: make-input-port */
t13=*((C_word*)lf[55]+1);{
C_word av2[9];
av2[0]=t13;
av2[1]=t5;
av2[2]=t6;
av2[3]=t7;
av2[4]=t8;
av2[5]=t9;
av2[6]=t10;
av2[7]=t11;
av2[8]=t12;
((C_proc)(void*)(*((C_word*)t13+1)))(9,av2);}}

/* read-input in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_fcall f_1659(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(8,0,2))){
C_save_and_reclaim_args((void *)trf_1659,2,t0,t1);}
a=C_alloc(8);
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_1663,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=t1,tmp=(C_word)a,a+=8,tmp);
/* tcp.scm:369: tcp-read-timeout */
t3=*((C_word*)lf[23]+1);{
C_word av2[2];
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* k1508 in k1504 in k1478 in k1472 in tcp-listen in k1211 in k983 in k980 in k977 */
static void C_ccall f_1510(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_1510,2,av);}
/* tcp.scm:322: string-append */
t2=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k2875 in k2872 in k2868 in k2865 in k2858 in tcp-addresses in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2877(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_2877,2,av);}
/* tcp.scm:626: values */{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
C_values(4,av2);}}

/* k2868 in k2865 in k2858 in tcp-addresses in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2870(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_demand(C_calculate_demand(10,c,3))){C_save_and_reclaim((void *)f_2870,2,av);}
a=C_alloc(10);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2874,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t4=C_a_i_bytevector(&a,1,C_fix(3));
t5=C_i_foreign_fixnum_argumentp(((C_word*)t0)[4]);
t6=stub200(t4,t5);
/* tcp.scm:209: ##sys#peek-c-string */
t7=*((C_word*)lf[7]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t7;
av2[1]=t3;
av2[2]=t6;
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t7+1)))(4,av2);}}

/* k2872 in k2868 in k2865 in k2858 in tcp-addresses in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2874(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(11,c,3))){C_save_and_reclaim((void *)f_2874,2,av);}
a=C_alloc(11);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2877,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t1)){
t3=t1;
/* tcp.scm:626: values */{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t3;
C_values(4,av2);}}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2884,a[2]=t2,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2888,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[8]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[8]+1);
av2[1]=t4;
av2[2]=lf[81];
av2[3]=lf[10];
tp(4,av2);}}}

/* k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_1636(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(6,c,2))){C_save_and_reclaim((void *)f_1636,2,av);}
a=C_alloc(6);
t2=C_mutate2((C_word*)lf[25]+1 /* (set! tcp-connect-timeout ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1640,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3061,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* tcp.scm:352: check */
f_1611(t4,lf[26]);}

/* k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_1632(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(7,c,2))){C_save_and_reclaim((void *)f_1632,2,av);}
a=C_alloc(7);
t2=C_mutate2((C_word*)lf[24]+1 /* (set! tcp-write-timeout ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1636,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3065,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* tcp.scm:351: check */
f_1611(t4,lf[25]);}

/* k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_1628(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(7,c,2))){C_save_and_reclaim((void *)f_1628,2,av);}
a=C_alloc(7);
t2=C_mutate2((C_word*)lf[23]+1 /* (set! tcp-read-timeout ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1632,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3069,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* tcp.scm:350: check */
f_1611(t4,lf[24]);}

/* ##net#gethostaddr in k1211 in k983 in k980 in k977 */
static void C_fcall f_1240(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(!C_demand(C_calculate_demand(5,0,2))){
C_save_and_reclaim_args((void *)trf_1240,4,t1,t2,t3,t4);}
a=C_alloc(5);
t5=(C_truep(t2)?C_i_foreign_block_argumentp(t2):C_SCHEME_FALSE);
t6=t5;
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1249,a[2]=t4,a[3]=t1,a[4]=t6,tmp=(C_word)a,a+=5,tmp);
if(C_truep(t3)){
t8=C_i_foreign_string_argumentp(t3);
/* tcp.scm:239: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[1]+1));
C_word av2[3];
av2[0]=*((C_word*)lf[1]+1);
av2[1]=t7;
av2[2]=t8;
tp(3,av2);}}
else{
t8=C_i_foreign_fixnum_argumentp(t4);
t9=t1;{
C_word av2[2];
av2[0]=t9;
av2[1]=stub222(C_SCHEME_UNDEFINED,t6,C_SCHEME_FALSE,t8);
((C_proc)(void*)(*((C_word*)t9+1)))(2,av2);}}}

/* k2950 in k2934 in k2925 in tcp-port-numbers in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2952(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,5))){C_save_and_reclaim((void *)f_2952,2,av);}
/* tcp.scm:640: ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[5];
av2[3]=lf[83];
av2[4]=t1;
av2[5]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}

/* k2954 in k2934 in k2925 in tcp-port-numbers in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2956(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(!C_demand(C_calculate_demand(9,c,3))){C_save_and_reclaim((void *)f_2956,2,av);}
a=C_alloc(9);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2960,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=stub64(C_SCHEME_UNDEFINED);
t5=C_a_i_bytevector(&a,1,C_fix(3));
t6=C_i_foreign_fixnum_argumentp(t4);
t7=stub68(t5,t6);
/* tcp.scm:163: ##sys#peek-c-string */
t8=*((C_word*)lf[7]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t8;
av2[1]=t3;
av2[2]=t7;
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t8+1)))(4,av2);}}

/* k2890 in k2886 in k2872 in k2868 in k2865 in k2858 in tcp-addresses in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2892(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_2892,2,av);}
/* tcp.scm:629: string-append */
t2=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k1211 in k983 in k980 in k977 */
static void C_ccall f_1213(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_demand(C_calculate_demand(15,c,5))){C_save_and_reclaim((void *)f_1213,2,av);}
a=C_alloc(15);
t2=C_mutate2(&lf[0] /* (set! ##net#gethostaddr ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1240,a[2]=((C_word)li0),tmp=(C_word)a,a+=3,tmp));
t3=C_mutate2((C_word*)lf[2]+1 /* (set! tcp-listen ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1455,a[2]=((C_word)li1),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate2((C_word*)lf[19]+1 /* (set! tcp-listener? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1554,a[2]=((C_word)li2),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate2((C_word*)lf[20]+1 /* (set! tcp-close ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1563,a[2]=((C_word)li3),tmp=(C_word)a,a+=3,tmp));
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1605,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* tcp.scm:338: make-parameter */
t7=*((C_word*)lf[90]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t7;
av2[1]=t6;
av2[2]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t7+1)))(3,av2);}}

/* k1247 in gethostaddr in k1211 in k983 in k980 in k977 */
static void C_ccall f_1249(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_1249,2,av);}
t2=C_i_foreign_fixnum_argumentp(((C_word*)t0)[2]);
t3=((C_word*)t0)[3];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=stub222(C_SCHEME_UNDEFINED,((C_word*)t0)[4],t1,t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* k1976 in a1923 in k1754 in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_fcall f_1978(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(4,0,2))){
C_save_and_reclaim_args((void *)trf_1978,2,t0,t1);}
a=C_alloc(4);
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1981,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* tcp.scm:521: output */
t3=((C_word*)t0)[4];
f_1757(t3,t2,((C_word*)((C_word*)t0)[2])[1]);}
else{
t2=((C_word*)t0)[3];
f_1932(t2,C_SCHEME_UNDEFINED);}}

/* k2865 in k2858 in tcp-addresses in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2867(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(12,c,3))){C_save_and_reclaim((void *)f_2867,2,av);}
a=C_alloc(12);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2870,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
if(C_truep(t1)){
t3=t2;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=t1;
f_2870(2,av2);}}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2905,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2909,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[8]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[8]+1);
av2[1]=t4;
av2[2]=lf[82];
av2[3]=lf[10];
tp(4,av2);}}}

/* k2858 in tcp-addresses in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2860(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_demand(C_calculate_demand(10,c,3))){C_save_and_reclaim((void *)f_2860,2,av);}
a=C_alloc(10);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2867,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t4=C_a_i_bytevector(&a,1,C_fix(3));
t5=C_i_foreign_fixnum_argumentp(t2);
t6=stub184(t4,t5);
/* tcp.scm:185: ##sys#peek-c-string */
t7=*((C_word*)lf[7]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t7;
av2[1]=t3;
av2[2]=t6;
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t7+1)))(4,av2);}}

/* k1218 in k1299 in k1295 in loop in a2811 in k2565 in k2562 in k2559 in tcp-connect in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_1220(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,2))){C_save_and_reclaim((void *)f_1220,2,av);}
a=C_alloc(4);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1224,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(((C_word*)t0)[3])){
t4=C_i_foreign_string_argumentp(((C_word*)t0)[3]);
/* tcp.scm:233: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[1]+1));
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[1]+1);
av2[1]=t3;
av2[2]=t4;
tp(3,av2);}}
else{
t4=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=stub210(C_SCHEME_UNDEFINED,t2,C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* k2048 in a2045 in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2050(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_2050,2,av);}
if(C_truep(C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]))){
t2=((C_word*)t0)[4];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_SCHEME_END_OF_FILE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
t2=C_subchar(((C_word*)t0)[5],((C_word*)((C_word*)t0)[2])[1]);
t3=C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],C_fix(1));
t4=C_mutate2(((C_word *)((C_word*)t0)[2])+1,t3);
t5=((C_word*)t0)[4];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t5;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* k1222 in k1218 in k1299 in k1295 in loop in a2811 in k2565 in k2562 in k2559 in tcp-connect in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_1224(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_1224,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=stub210(C_SCHEME_UNDEFINED,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* toplevel */
static C_TLS int toplevel_initialized=0;

void C_ccall C_tcp_toplevel(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(toplevel_initialized) {C_kontinue(t1,C_SCHEME_UNDEFINED);}
else C_toplevel_entry(C_text("tcp_toplevel"));
C_check_nursery_minimum(C_calculate_demand(3,c,2));
if(!C_demand(C_calculate_demand(3,c,2))){
C_save_and_reclaim((void*)C_tcp_toplevel,c,av);}
toplevel_initialized=1;
if(!C_demand_2(343)){
C_save(t1);
C_rereclaim2(343*sizeof(C_word),1);
t1=C_restore;}
a=C_alloc(3);
C_initialize_lf(lf,94);
lf[1]=C_h_intern(&lf[1],17,"\003sysmake-c-string");
lf[2]=C_h_intern(&lf[2],10,"tcp-listen");
lf[3]=C_h_intern(&lf[3],12,"tcp-listener");
lf[4]=C_h_intern(&lf[4],15,"\003syssignal-hook");
lf[5]=C_h_intern(&lf[5],14,"\000network-error");
lf[6]=C_h_intern(&lf[6],13,"string-append");
lf[7]=C_h_intern(&lf[7],17,"\003syspeek-c-string");
lf[8]=C_h_intern(&lf[8],17,"\003sysstring-append");
lf[9]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot listen on socket");
lf[10]=C_decode_literal(C_heaptop,"\376B\000\000\003 - ");
lf[11]=C_decode_literal(C_heaptop,"\376B\000\000\025cannot bind to socket");
lf[12]=C_decode_literal(C_heaptop,"\376B\000\000\035error while setting up socket");
lf[13]=C_h_intern(&lf[13],9,"\003syserror");
lf[14]=C_decode_literal(C_heaptop,"\376B\000\000\024cannot create socket");
lf[15]=C_decode_literal(C_heaptop,"\376B\000\000\037getting listener host IP failed");
lf[16]=C_h_intern(&lf[16],11,"make-string");
lf[17]=C_h_intern(&lf[17],13,"\000domain-error");
lf[18]=C_decode_literal(C_heaptop,"\376B\000\000\023invalid port number");
lf[19]=C_h_intern(&lf[19],13,"tcp-listener\077");
lf[20]=C_h_intern(&lf[20],9,"tcp-close");
lf[21]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot close TCP socket");
lf[22]=C_h_intern(&lf[22],15,"tcp-buffer-size");
lf[23]=C_h_intern(&lf[23],16,"tcp-read-timeout");
lf[24]=C_h_intern(&lf[24],17,"tcp-write-timeout");
lf[25]=C_h_intern(&lf[25],19,"tcp-connect-timeout");
lf[26]=C_h_intern(&lf[26],18,"tcp-accept-timeout");
lf[28]=C_h_intern(&lf[28],18,"\003syscurrent-thread");
lf[29]=C_h_intern(&lf[29],22,"\000network-timeout-error");
lf[30]=C_decode_literal(C_heaptop,"\376B\000\000\030read operation timed out");
lf[31]=C_h_intern(&lf[31],17,"\003systhread-yield!");
lf[32]=C_h_intern(&lf[32],25,"\003systhread-block-for-i/o!");
lf[33]=C_h_intern(&lf[33],6,"\000input");
lf[34]=C_h_intern(&lf[34],29,"\003systhread-block-for-timeout!");
lf[35]=C_h_intern(&lf[35],22,"\003sysdispatch-interrupt");
lf[36]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot read from socket");
lf[37]=C_h_intern(&lf[37],20,"current-milliseconds");
lf[38]=C_decode_literal(C_heaptop,"\376B\000\000\031write operation timed out");
lf[39]=C_h_intern(&lf[39],7,"\000output");
lf[40]=C_decode_literal(C_heaptop,"\376B\000\000\026cannot write to socket");
lf[41]=C_decode_literal(C_heaptop,"\376B\000\000\005(tcp)");
lf[42]=C_decode_literal(C_heaptop,"\376B\000\000\005(tcp)");
lf[43]=C_h_intern(&lf[43],6,"socket");
lf[44]=C_h_intern(&lf[44],18,"\003sysset-port-data!");
lf[45]=C_decode_literal(C_heaptop,"\376B\000\000\000");
lf[46]=C_decode_literal(C_heaptop,"\376B\000\000\037cannot close socket output port");
lf[47]=C_decode_literal(C_heaptop,"\376B\000\000\000");
lf[48]=C_decode_literal(C_heaptop,"\376B\000\000\000");
lf[49]=C_h_intern(&lf[49],16,"make-output-port");
lf[50]=C_decode_literal(C_heaptop,"\376B\000\000\035cannot check socket for input");
lf[51]=C_decode_literal(C_heaptop,"\376B\000\000\036cannot close socket input port");
lf[52]=C_h_intern(&lf[52],20,"\003sysscan-buffer-line");
lf[53]=C_decode_literal(C_heaptop,"\376B\000\000\000");
lf[54]=C_h_intern(&lf[54],13,"\003syssubstring");
lf[55]=C_h_intern(&lf[55],15,"make-input-port");
lf[56]=C_decode_literal(C_heaptop,"\376B\000\000\000");
lf[57]=C_h_intern(&lf[57],15,"\003sysmake-string");
lf[58]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot create TCP ports");
lf[59]=C_h_intern(&lf[59],10,"tcp-accept");
lf[60]=C_decode_literal(C_heaptop,"\376B\000\000\036could not accept from listener");
lf[61]=C_decode_literal(C_heaptop,"\376B\000\000\032accept operation timed out");
lf[62]=C_h_intern(&lf[62],17,"tcp-accept-ready\077");
lf[63]=C_decode_literal(C_heaptop,"\376B\000\000\035cannot check socket for input");
lf[64]=C_h_intern(&lf[64],11,"tcp-connect");
lf[65]=C_decode_literal(C_heaptop,"\376B\000\000\023getsockopt() failed");
lf[66]=C_decode_literal(C_heaptop,"\376B\000\000\024cannot create socket");
lf[67]=C_decode_literal(C_heaptop,"\376B\000\000\030cannot connect to socket");
lf[68]=C_decode_literal(C_heaptop,"\376B\000\000\016fcntl() failed");
lf[69]=C_decode_literal(C_heaptop,"\376B\000\000\035error while setting up socket");
lf[70]=C_decode_literal(C_heaptop,"\376B\000\000\024cannot create socket");
lf[71]=C_decode_literal(C_heaptop,"\376B\000\000\030cannot find host address");
lf[72]=C_decode_literal(C_heaptop,"\376B\000\000\021no port specified");
lf[73]=C_decode_literal(C_heaptop,"\376B\000\000 cannot compute port from service");
lf[74]=C_decode_literal(C_heaptop,"\376B\000\000\003tcp");
lf[75]=C_h_intern(&lf[75],9,"substring");
lf[76]=C_h_intern(&lf[76],20,"\003systcp-port->fileno");
lf[77]=C_h_intern(&lf[77],5,"error");
lf[78]=C_decode_literal(C_heaptop,"\376B\000\000)argument does not appear to be a TCP port");
lf[79]=C_h_intern(&lf[79],13,"\003sysport-data");
lf[80]=C_h_intern(&lf[80],13,"tcp-addresses");
lf[81]=C_decode_literal(C_heaptop,"\376B\000\000\035cannot compute remote address");
lf[82]=C_decode_literal(C_heaptop,"\376B\000\000\034cannot compute local address");
lf[83]=C_h_intern(&lf[83],16,"tcp-port-numbers");
lf[84]=C_decode_literal(C_heaptop,"\376B\000\000\032cannot compute remote port");
lf[85]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot compute local port");
lf[86]=C_h_intern(&lf[86],17,"tcp-listener-port");
lf[87]=C_decode_literal(C_heaptop,"\376B\000\000\033cannot obtain listener port");
lf[88]=C_h_intern(&lf[88],16,"tcp-abandon-port");
lf[89]=C_h_intern(&lf[89],19,"tcp-listener-fileno");
lf[90]=C_h_intern(&lf[90],14,"make-parameter");
lf[91]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot initialize Winsock");
lf[92]=C_h_intern(&lf[92],17,"register-feature!");
lf[93]=C_h_intern(&lf[93],3,"tcp");
C_register_lf2(lf,94,create_ptable());{}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_979,a[2]=t1,tmp=(C_word)a,a+=3,tmp);{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=C_SCHEME_UNDEFINED;
av2[1]=t2;
C_ports_toplevel(2,av2);}}

/* k1979 in k1976 in a1923 in k1754 in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_1981(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_1981,2,av);}
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,lf[47]);
t3=((C_word*)t0)[3];
f_1932(t3,t2);}

/* tcp-accept in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2409(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(5,c,2))){C_save_and_reclaim((void *)f_2409,3,av);}
a=C_alloc(5);
t3=C_i_check_structure(t2,lf[3]);
t4=C_slot(t2,C_fix(1));
t5=t4;
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2419,a[2]=t5,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* tcp.scm:542: tcp-accept-timeout */
t7=*((C_word*)lf[26]+1);{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t7;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}

/* k2403 in k2399 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2405(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_2405,2,av);}
/* tcp.scm:358: string-append */
t2=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k2399 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2401(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_demand(C_calculate_demand(9,c,3))){C_save_and_reclaim((void *)f_2401,2,av);}
a=C_alloc(9);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2405,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=C_a_i_bytevector(&a,1,C_fix(3));
t5=C_i_foreign_fixnum_argumentp(((C_word*)t0)[3]);
t6=stub68(t4,t5);
/* tcp.scm:163: ##sys#peek-c-string */
t7=*((C_word*)lf[7]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t7;
av2[1]=t3;
av2[2]=t6;
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t7+1)))(4,av2);}}

/* k2886 in k2872 in k2868 in k2865 in k2858 in tcp-addresses in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2888(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(!C_demand(C_calculate_demand(9,c,3))){C_save_and_reclaim((void *)f_2888,2,av);}
a=C_alloc(9);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2892,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=stub64(C_SCHEME_UNDEFINED);
t5=C_a_i_bytevector(&a,1,C_fix(3));
t6=C_i_foreign_fixnum_argumentp(t4);
t7=stub68(t5,t6);
/* tcp.scm:163: ##sys#peek-c-string */
t8=*((C_word*)lf[7]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t8;
av2[1]=t3;
av2[2]=t7;
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t8+1)))(4,av2);}}

/* k2882 in k2872 in k2868 in k2865 in k2858 in tcp-addresses in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2884(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,5))){C_save_and_reclaim((void *)f_2884,2,av);}
/* tcp.scm:629: ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[5];
av2[3]=lf[80];
av2[4]=t1;
av2[5]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}

/* k2911 in k2907 in k2865 in k2858 in tcp-addresses in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2913(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_2913,2,av);}
/* tcp.scm:627: string-append */
t2=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k983 in k980 in k977 */
static void C_ccall f_985(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(3,c,3))){C_save_and_reclaim((void *)f_985,2,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1213,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
if(C_truep(stub205(C_SCHEME_UNDEFINED))){
t3=t2;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=C_SCHEME_UNDEFINED;
f_1213(2,av2);}}
else{
/* tcp.scm:230: ##sys#signal-hook */
t3=*((C_word*)lf[4]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[5];
av2[3]=lf[91];
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}}

/* k980 in k977 */
static void C_ccall f_982(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(3,c,2))){C_save_and_reclaim((void *)f_982,2,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_985,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* tcp.scm:145: register-feature! */
t3=*((C_word*)lf[92]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[93];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* a2045 in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2046(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(6,c,2))){C_save_and_reclaim((void *)f_2046,2,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2050,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
if(C_truep(C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]))){
/* tcp.scm:397: read-input */
t3=((C_word*)t0)[5];
f_1659(t3,t2);}
else{
t3=t2;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=C_SCHEME_UNDEFINED;
f_2050(2,av2);}}}

/* k2958 in k2954 in k2934 in k2925 in tcp-port-numbers in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2960(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_2960,2,av);}
/* tcp.scm:640: string-append */
t2=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k2395 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2397(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,5))){C_save_and_reclaim((void *)f_2397,2,av);}
/* tcp.scm:358: ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[5];
av2[3]=((C_word*)t0)[3];
av2[4]=t1;
av2[5]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}

/* a2316 in k2254 in k2245 in a2242 in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2317(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_2317,5,av);}
if(C_truep(t4)){
t5=C_slot(((C_word*)t0)[2],C_fix(4));
t6=C_fixnum_plus(t5,C_fix(1));
t7=C_i_set_i_slot(((C_word*)t0)[2],C_fix(4),t6);
t8=C_i_set_i_slot(((C_word*)t0)[2],C_fix(5),C_fix(0));
t9=C_mutate2(((C_word *)((C_word*)t0)[3])+1,t2);
t10=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t10;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t10+1)))(2,av2);}}
else{
t5=C_slot(((C_word*)t0)[2],C_fix(5));
t6=C_block_size(t3);
t7=C_fixnum_plus(t5,t6);
t8=C_i_set_i_slot(((C_word*)t0)[2],C_fix(5),t7);
t9=C_mutate2(((C_word *)((C_word*)t0)[3])+1,t2);
t10=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t10;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t10+1)))(2,av2);}}}

/* k1733 in k1729 in loop in k1664 in k1661 in read-input in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_1735(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_1735,2,av);}
/* tcp.scm:388: string-append */
t2=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k1729 in loop in k1664 in k1661 in read-input in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_1731(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(!C_demand(C_calculate_demand(9,c,3))){C_save_and_reclaim((void *)f_1731,2,av);}
a=C_alloc(9);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1735,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=stub64(C_SCHEME_UNDEFINED);
t5=C_a_i_bytevector(&a,1,C_fix(3));
t6=C_i_foreign_fixnum_argumentp(t4);
t7=stub68(t5,t6);
/* tcp.scm:163: ##sys#peek-c-string */
t8=*((C_word*)lf[7]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t8;
av2[1]=t3;
av2[2]=t7;
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t8+1)))(4,av2);}}

/* k2982 in k2978 in k2925 in tcp-port-numbers in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2984(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_2984,2,av);}
/* tcp.scm:638: string-append */
t2=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k2096 in a2067 in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2098(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(!C_demand(C_calculate_demand(9,c,3))){C_save_and_reclaim((void *)f_2098,2,av);}
a=C_alloc(9);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2102,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=stub64(C_SCHEME_UNDEFINED);
t5=C_a_i_bytevector(&a,1,C_fix(3));
t6=C_i_foreign_fixnum_argumentp(t4);
t7=stub68(t5,t6);
/* tcp.scm:163: ##sys#peek-c-string */
t8=*((C_word*)lf[7]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t8;
av2[1]=t3;
av2[2]=t7;
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t8+1)))(4,av2);}}

/* k2978 in k2925 in tcp-port-numbers in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2980(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(!C_demand(C_calculate_demand(9,c,3))){C_save_and_reclaim((void *)f_2980,2,av);}
a=C_alloc(9);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2984,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=stub64(C_SCHEME_UNDEFINED);
t5=C_a_i_bytevector(&a,1,C_fix(3));
t6=C_i_foreign_fixnum_argumentp(t4);
t7=stub68(t5,t6);
/* tcp.scm:163: ##sys#peek-c-string */
t8=*((C_word*)lf[7]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t8;
av2[1]=t3;
av2[2]=t7;
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t8+1)))(4,av2);}}

/* k2674 in k2671 in loop in k2589 in k2586 in k2583 in k2577 in k2571 in k2565 in k2562 in k2559 in tcp-connect in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2676(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_2676,2,av);}
/* tcp.scm:603: ##sys#thread-yield! */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[31]+1));
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=*((C_word*)lf[31]+1);
av2[1]=((C_word*)t0)[2];
tp(2,av2);}}

/* k2435 in k2432 in k2429 in loop in k2420 in k2417 in tcp-accept in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2437(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(6,c,6))){C_save_and_reclaim((void *)f_2437,2,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2440,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
if(C_truep(C_slot(*((C_word*)lf[28]+1),C_fix(13)))){
/* tcp.scm:550: ##sys#signal-hook */
t3=*((C_word*)lf[4]+1);{
C_word *av2;
if(c >= 7) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(7);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[29];
av2[3]=lf[59];
av2[4]=lf[61];
av2[5]=((C_word*)t0)[6];
av2[6]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t3+1)))(7,av2);}}
else{
t3=t2;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=C_SCHEME_UNDEFINED;
f_2440(2,av2);}}}

/* k2092 in a2067 in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2094(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,5))){C_save_and_reclaim((void *)f_2094,2,av);}
/* tcp.scm:409: ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[5];
av2[3]=C_SCHEME_FALSE;
av2[4]=t1;
av2[5]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}

/* k2432 in k2429 in loop in k2420 in k2417 in tcp-accept in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2434(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(7,c,2))){C_save_and_reclaim((void *)f_2434,2,av);}
a=C_alloc(7);
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2437,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],tmp=(C_word)a,a+=7,tmp);
/* tcp.scm:548: ##sys#thread-yield! */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[31]+1));
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=*((C_word*)lf[31]+1);
av2[1]=t2;
tp(2,av2);}}

/* k2937 in k2934 in k2925 in tcp-port-numbers in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2939(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_2939,2,av);}
/* tcp.scm:641: values */{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=((C_word*)t0)[4];
C_values(4,av2);}}

/* k2934 in k2925 in tcp-port-numbers in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2936(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_demand(C_calculate_demand(12,c,3))){C_save_and_reclaim((void *)f_2936,2,av);}
a=C_alloc(12);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2939,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t3=C_eqp(C_fix(-1),((C_word*)t0)[4]);
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2952,a[2]=t2,a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2956,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[8]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[8]+1);
av2[1]=t5;
av2[2]=lf[84];
av2[3]=lf[10];
tp(4,av2);}}
else{
/* tcp.scm:641: values */{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=((C_word*)t0)[4];
C_values(4,av2);}}}

/* k2671 in loop in k2589 in k2586 in k2583 in k2577 in k2571 in k2565 in k2562 in k2559 in tcp-connect in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2673(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(3,c,4))){C_save_and_reclaim((void *)f_2673,2,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2676,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* tcp.scm:602: ##sys#thread-block-for-i/o! */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[32]+1));
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[32]+1);
av2[1]=t2;
av2[2]=*((C_word*)lf[28]+1);
av2[3]=((C_word*)t0)[3];
av2[4]=lf[39];
tp(5,av2);}}

/* k2429 in loop in k2420 in k2417 in tcp-accept in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2431(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(7,c,4))){C_save_and_reclaim((void *)f_2431,2,av);}
a=C_alloc(7);
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2434,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],tmp=(C_word)a,a+=7,tmp);
/* tcp.scm:547: ##sys#thread-block-for-i/o! */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[32]+1));
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[32]+1);
av2[1]=t2;
av2[2]=*((C_word*)lf[28]+1);
av2[3]=((C_word*)t0)[2];
av2[4]=lf[33];
tp(5,av2);}}

/* a2067 in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2068(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(11,c,3))){C_save_and_reclaim((void *)f_2068,2,av);}
a=C_alloc(11);
t2=C_fixnum_lessp(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]);
if(C_truep(t2)){
t3=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t3=((C_word*)t0)[4];
t4=C_i_foreign_fixnum_argumentp(t3);
t5=stub159(C_SCHEME_UNDEFINED,t4);
t6=t5;
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2081,a[2]=t1,a[3]=t6,tmp=(C_word)a,a+=4,tmp);
t8=C_eqp(C_fix((C_word)SOCKET_ERROR),t6);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2094,a[2]=t7,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t10=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2098,a[2]=t9,tmp=(C_word)a,a+=3,tmp);
/* ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[8]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[8]+1);
av2[1]=t10;
av2[2]=lf[50];
av2[3]=lf[10];
tp(4,av2);}}
else{
t9=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t9;
av2[1]=C_eqp(t6,C_fix(1));
((C_proc)(void*)(*((C_word*)t9+1)))(2,av2);}}}}

/* k1754 in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_1756(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(!C_demand(C_calculate_demand(29,c,4))){C_save_and_reclaim((void *)f_1756,2,av);}
a=C_alloc(29);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1757,a[2]=((C_word*)t0)[2],a[3]=((C_word)li10),tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1897,a[2]=t2,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t5=(C_truep(((C_word*)((C_word*)t0)[5])[1])?(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2010,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=t3,a[5]=((C_word)li11),tmp=(C_word)a,a+=6,tmp):(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2030,a[2]=t3,a[3]=((C_word)li12),tmp=(C_word)a,a+=4,tmp));
t6=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_1924,a[2]=((C_word*)t0)[7],a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[8],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=t3,a[8]=((C_word)li13),tmp=(C_word)a,a+=9,tmp);
if(C_truep(((C_word*)((C_word*)t0)[5])[1])){
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1994,a[2]=((C_word*)t0)[5],a[3]=t3,a[4]=((C_word)li14),tmp=(C_word)a,a+=5,tmp);
/* tcp.scm:507: make-output-port */
t8=*((C_word*)lf[49]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t8;
av2[1]=t4;
av2[2]=t5;
av2[3]=t6;
av2[4]=t7;
((C_proc)(void*)(*((C_word*)t8+1)))(5,av2);}}
else{
/* tcp.scm:507: make-output-port */
t7=*((C_word*)lf[49]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t7;
av2[1]=t4;
av2[2]=t5;
av2[3]=t6;
av2[4]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t7+1)))(5,av2);}}}

/* k1751 in k1661 in read-input in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_1753(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,1))){C_save_and_reclaim((void *)f_1753,2,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];
f_1666(t2,C_a_i_plus(&a,2,t1,((C_word*)t0)[3]));}

/* k2438 in k2435 in k2432 in k2429 in loop in k2420 in k2417 in tcp-accept in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2440(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_demand(C_calculate_demand(7,c,3))){C_save_and_reclaim((void *)f_2440,2,av);}
a=C_alloc(7);
t2=C_i_foreign_fixnum_argumentp(((C_word*)t0)[2]);
t3=stub112(C_SCHEME_UNDEFINED,t2,C_SCHEME_FALSE,C_SCHEME_FALSE);
t4=C_eqp(C_fix((C_word)INVALID_SOCKET),t3);
if(C_truep(t4)){
if(C_truep(stub79(C_SCHEME_UNDEFINED))){
/* tcp.scm:558: ##sys#dispatch-interrupt */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[35]+1));
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[35]+1);
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)((C_word*)t0)[4])[1];
tp(3,av2);}}
else{
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2468,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2472,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
/* ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[8]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[8]+1);
av2[1]=t6;
av2[2]=lf[60];
av2[3]=lf[10];
tp(4,av2);}}}
else{
/* tcp.scm:556: ##net#io-ports */
t5=lf[27];
f_1642(t5,((C_word*)t0)[3],lf[59],t3);}}

/* output in k1754 in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_fcall f_1757(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(5,0,2))){
C_save_and_reclaim_args((void *)trf_1757,3,t0,t1,t2);}
a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1761,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* tcp.scm:477: tcp-write-timeout */
t4=*((C_word*)lf[24]+1);{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* k2759 in k2583 in k2577 in k2571 in k2565 in k2562 in k2559 in tcp-connect in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2761(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_demand(C_calculate_demand(9,c,3))){C_save_and_reclaim((void *)f_2761,2,av);}
a=C_alloc(9);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2765,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=C_a_i_bytevector(&a,1,C_fix(3));
t5=C_i_foreign_fixnum_argumentp(((C_word*)t0)[3]);
t6=stub68(t4,t5);
/* tcp.scm:163: ##sys#peek-c-string */
t7=*((C_word*)lf[7]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t7;
av2[1]=t3;
av2[2]=t6;
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t7+1)))(4,av2);}}

/* k977 */
static void C_ccall f_979(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(3,c,2))){C_save_and_reclaim((void *)f_979,2,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_982,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=C_SCHEME_UNDEFINED;
av2[1]=t2;
C_scheduler_toplevel(2,av2);}}

/* k2763 in k2759 in k2583 in k2577 in k2571 in k2565 in k2562 in k2559 in tcp-connect in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2765(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_2765,2,av);}
/* tcp.scm:594: string-append */
t2=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_1605(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(!C_demand(C_calculate_demand(10,c,3))){C_save_and_reclaim((void *)f_1605,2,av);}
a=C_alloc(10);
t2=C_mutate2((C_word*)lf[22]+1 /* (set! tcp-buffer-size ...) */,t1);
t3=C_set_block_item(lf[23] /* tcp-read-timeout */,0,C_SCHEME_UNDEFINED);
t4=C_set_block_item(lf[24] /* tcp-write-timeout */,0,C_SCHEME_UNDEFINED);
t5=C_set_block_item(lf[25] /* tcp-connect-timeout */,0,C_SCHEME_UNDEFINED);
t6=C_set_block_item(lf[26] /* tcp-accept-timeout */,0,C_SCHEME_UNDEFINED);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1611,a[2]=((C_word)li5),tmp=(C_word)a,a+=3,tmp);
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1628,a[2]=((C_word*)t0)[2],a[3]=t7,tmp=(C_word)a,a+=4,tmp);
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3073,a[2]=t8,tmp=(C_word)a,a+=3,tmp);
/* tcp.scm:349: check */
f_1611(t9,lf[23]);}

/* k1302 in k1299 in k1295 in loop in a2811 in k2565 in k2562 in k2559 in tcp-connect in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_1304(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_demand(C_calculate_demand(12,c,3))){C_save_and_reclaim((void *)f_1304,2,av);}
a=C_alloc(12);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1307,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t4=C_eqp(C_fix(0),t2);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1317,a[2]=t3,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1321,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
/* ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[8]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[8]+1);
av2[1]=t6;
av2[2]=lf[73];
av2[3]=lf[10];
tp(4,av2);}}
else{
/* tcp.scm:278: values */{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t2;
C_values(4,av2);}}}

/* k1299 in k1295 in loop in a2811 in k2565 in k2562 in k2559 in tcp-connect in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_1301(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(!C_demand(C_calculate_demand(9,c,2))){C_save_and_reclaim((void *)f_1301,2,av);}
a=C_alloc(9);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1304,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t4=t3;
t5=lf[74];
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1220,a[2]=t4,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
if(C_truep(t2)){
t7=C_i_foreign_string_argumentp(t2);
/* tcp.scm:233: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[1]+1));
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[1]+1);
av2[1]=t6;
av2[2]=t7;
tp(3,av2);}}
else{
t7=t6;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t7;
av2[1]=C_SCHEME_FALSE;
f_1220(2,av2);}}}

/* k1305 in k1302 in k1299 in k1295 in loop in a2811 in k2565 in k2562 in k2559 in tcp-connect in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_1307(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_1307,2,av);}
/* tcp.scm:278: values */{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=((C_word*)t0)[4];
C_values(4,av2);}}

/* k1725 in loop in k1664 in k1661 in read-input in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_1727(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,5))){C_save_and_reclaim((void *)f_1727,2,av);}
/* tcp.scm:388: ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[5];
av2[3]=C_SCHEME_FALSE;
av2[4]=t1;
av2[5]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}

/* a1827 in loop in k1770 in k1759 in output in k1754 in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_1828(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_1828,2,av);}
/* tcp.scm:497: g556 */
t2=((C_word*)((C_word*)t0)[2])[1];
f_1774(t2,t1,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5]);}

/* k2079 in a2067 in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2081(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_2081,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_eqp(((C_word*)t0)[3],C_fix(1));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k2974 in k2925 in tcp-port-numbers in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2976(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,5))){C_save_and_reclaim((void *)f_2976,2,av);}
/* tcp.scm:638: ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[5];
av2[3]=lf[83];
av2[4]=t1;
av2[5]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}

/* check in k1603 in k1211 in k983 in k980 in k977 */
static void C_fcall f_1611(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(4,0,3))){
C_save_and_reclaim_args((void *)trf_1611,2,t1,t2);}
a=C_alloc(4);
t3=t1;{
C_word av2[2];
av2[0]=t3;
av2[1]=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1613,a[2]=t2,a[3]=((C_word)li4),tmp=(C_word)a,a+=4,tmp);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* f_1613 in check in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_1613(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_1613,3,av);}
if(C_truep(t2)){
t3=C_i_check_exact_2(t2,((C_word*)t0)[2]);
t4=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t3=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k1797 in k1794 in loop in k1770 in k1759 in output in k1754 in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_1799(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(9,c,2))){C_save_and_reclaim((void *)f_1799,2,av);}
a=C_alloc(9);
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_1802,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],tmp=(C_word)a,a+=9,tmp);
/* tcp.scm:489: ##sys#thread-yield! */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[31]+1));
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=*((C_word*)lf[31]+1);
av2[1]=t2;
tp(2,av2);}}

/* k1794 in loop in k1770 in k1759 in output in k1754 in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_1796(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(9,c,4))){C_save_and_reclaim((void *)f_1796,2,av);}
a=C_alloc(9);
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_1799,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],tmp=(C_word)a,a+=9,tmp);
/* tcp.scm:488: ##sys#thread-block-for-i/o! */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[32]+1));
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[32]+1);
av2[1]=t2;
av2[2]=*((C_word*)lf[28]+1);
av2[3]=((C_word*)t0)[8];
av2[4]=lf[39];
tp(5,av2);}}

/* k1315 in k1302 in k1299 in k1295 in loop in a2811 in k2565 in k2562 in k2559 in tcp-connect in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_1317(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,5))){C_save_and_reclaim((void *)f_1317,2,av);}
/* tcp.scm:283: ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[5];
av2[3]=lf[64];
av2[4]=t1;
av2[5]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}

/* k2787 in k2783 in k2577 in k2571 in k2565 in k2562 in k2559 in tcp-connect in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2789(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_2789,2,av);}
/* tcp.scm:592: string-append */
t2=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k2779 in k2577 in k2571 in k2565 in k2562 in k2559 in tcp-connect in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2781(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,6))){C_save_and_reclaim((void *)f_2781,2,av);}
/* tcp.scm:592: ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);{
C_word *av2;
if(c >= 7) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(7);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[5];
av2[3]=lf[64];
av2[4]=t1;
av2[5]=((C_word*)((C_word*)t0)[3])[1];
av2[6]=((C_word*)((C_word*)t0)[4])[1];
((C_proc)(void*)(*((C_word*)t2+1)))(7,av2);}}

/* k1837 in loop in k1770 in k1759 in output in k1754 in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_1839(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,5))){C_save_and_reclaim((void *)f_1839,2,av);}
/* tcp.scm:499: ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[5];
av2[3]=C_SCHEME_FALSE;
av2[4]=t1;
av2[5]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}

/* k2783 in k2577 in k2571 in k2565 in k2562 in k2559 in tcp-connect in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2785(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(!C_demand(C_calculate_demand(9,c,3))){C_save_and_reclaim((void *)f_2785,2,av);}
a=C_alloc(9);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2789,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=stub64(C_SCHEME_UNDEFINED);
t5=C_a_i_bytevector(&a,1,C_fix(3));
t6=C_i_foreign_fixnum_argumentp(t4);
t7=stub68(t5,t6);
/* tcp.scm:163: ##sys#peek-c-string */
t8=*((C_word*)lf[7]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t8;
av2[1]=t3;
av2[2]=t7;
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t8+1)))(4,av2);}}

/* k1319 in k1302 in k1299 in k1295 in loop in a2811 in k2565 in k2562 in k2559 in tcp-connect in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_1321(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(!C_demand(C_calculate_demand(9,c,3))){C_save_and_reclaim((void *)f_1321,2,av);}
a=C_alloc(9);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1325,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=stub64(C_SCHEME_UNDEFINED);
t5=C_a_i_bytevector(&a,1,C_fix(3));
t6=C_i_foreign_fixnum_argumentp(t4);
t7=stub68(t5,t6);
/* tcp.scm:163: ##sys#peek-c-string */
t8=*((C_word*)lf[7]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t8;
av2[1]=t3;
av2[2]=t7;
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t8+1)))(4,av2);}}

/* k1323 in k1319 in k1302 in k1299 in k1295 in loop in a2811 in k2565 in k2562 in k2559 in tcp-connect in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_1325(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_1325,2,av);}
/* tcp.scm:283: string-append */
t2=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k1759 in output in k1754 in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_1761(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_demand(C_calculate_demand(11,c,2))){C_save_and_reclaim((void *)f_1761,2,av);}
a=C_alloc(11);
t2=t1;
t3=C_block_size(((C_word*)t0)[2]);
t4=t3;
t5=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_1772,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],a[4]=t2,a[5]=((C_word*)t0)[4],a[6]=t4,tmp=(C_word)a,a+=7,tmp);
if(C_truep(t2)){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1894,a[2]=t5,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* tcp.scm:480: current-milliseconds */
t7=*((C_word*)lf[37]+1);{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t7;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t6=t5;
f_1772(t6,C_SCHEME_FALSE);}}

/* k2796 in k2571 in k2565 in k2562 in k2559 in tcp-connect in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2798(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,5))){C_save_and_reclaim((void *)f_2798,2,av);}
if(C_truep(t1)){
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_SCHEME_UNDEFINED;
f_2579(2,av2);}}
else{
/* tcp.scm:589: ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[5];
av2[3]=lf[64];
av2[4]=lf[71];
av2[5]=((C_word*)((C_word*)t0)[3])[1];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}}

/* k1800 in k1797 in k1794 in loop in k1770 in k1759 in output in k1754 in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 in ... */
static void C_ccall f_1802(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(7,c,5))){C_save_and_reclaim((void *)f_1802,2,av);}
a=C_alloc(7);
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_1805,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],tmp=(C_word)a,a+=7,tmp);
if(C_truep(C_slot(*((C_word*)lf[28]+1),C_fix(13)))){
/* tcp.scm:491: ##sys#signal-hook */
t3=*((C_word*)lf[4]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[29];
av2[3]=lf[38];
av2[4]=((C_word*)t0)[7];
av2[5]=((C_word*)t0)[8];
((C_proc)(void*)(*((C_word*)t3+1)))(6,av2);}}
else{
/* tcp.scm:494: loop */
t3=((C_word*)((C_word*)t0)[2])[1];
f_1774(t3,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)t0)[6]);}}

/* k1803 in k1800 in k1797 in k1794 in loop in k1770 in k1759 in output in k1754 in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in ... */
static void C_ccall f_1805(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_1805,2,av);}
/* tcp.scm:494: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_1774(t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)t0)[6]);}

/* k1845 in k1841 in loop in k1770 in k1759 in output in k1754 in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_1847(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_1847,2,av);}
/* tcp.scm:499: string-append */
t2=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k2565 in k2562 in k2559 in tcp-connect in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2567(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(!C_demand(C_calculate_demand(21,c,4))){C_save_and_reclaim((void *)f_2567,2,av);}
a=C_alloc(21);
t2=t1;
t3=C_i_check_string(((C_word*)((C_word*)t0)[2])[1]);
t4=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2573,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=t2,a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[2],tmp=(C_word)a,a+=7,tmp);
if(C_truep(((C_word*)((C_word*)t0)[3])[1])){
t5=t4;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t5;
av2[1]=C_SCHEME_UNDEFINED;
f_2573(2,av2);}}
else{
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2804,a[2]=((C_word*)t0)[3],a[3]=t4,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2812,a[2]=((C_word*)t0)[2],a[3]=((C_word)li32),tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2818,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word)li33),tmp=(C_word)a,a+=5,tmp);
/* tcp.scm:585: ##sys#call-with-values */{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t5;
av2[2]=t6;
av2[3]=t7;
C_call_with_values(4,av2);}}}

/* k2559 in tcp-connect in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2561(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(9,c,2))){C_save_and_reclaim((void *)f_2561,2,av);}
a=C_alloc(9);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2564,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
if(C_truep(t2)){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2828,a[2]=t3,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* tcp.scm:581: current-milliseconds */
t5=*((C_word*)lf[37]+1);{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
t4=t3;
f_2564(t4,C_SCHEME_FALSE);}}

/* k2562 in k2559 in tcp-connect in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_fcall f_2564(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(6,0,2))){
C_save_and_reclaim_args((void *)trf_2564,2,t0,t1);}
a=C_alloc(6);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2567,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
/* tcp.scm:582: make-string */
t4=*((C_word*)lf[16]+1);{
C_word av2[3];
av2[0]=t4;
av2[1]=t3;
av2[2]=C_fix((C_word)sizeof(struct sockaddr_in));
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k1841 in loop in k1770 in k1759 in output in k1754 in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_1843(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(!C_demand(C_calculate_demand(9,c,3))){C_save_and_reclaim((void *)f_1843,2,av);}
a=C_alloc(9);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1847,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=stub64(C_SCHEME_UNDEFINED);
t5=C_a_i_bytevector(&a,1,C_fix(3));
t6=C_i_foreign_fixnum_argumentp(t4);
t7=stub68(t5,t6);
/* tcp.scm:163: ##sys#peek-c-string */
t8=*((C_word*)lf[7]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t8;
av2[1]=t3;
av2[2]=t7;
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t8+1)))(4,av2);}}

/* k2577 in k2571 in k2565 in k2562 in k2559 in tcp-connect in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2579(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word *a;
if(!C_demand(C_calculate_demand(16,c,3))){C_save_and_reclaim((void *)f_2579,2,av);}
a=C_alloc(16);
t2=C_fix((C_word)AF_INET);
t3=C_fix((C_word)SOCK_STREAM);
t4=C_i_foreign_fixnum_argumentp(t2);
t5=C_i_foreign_fixnum_argumentp(t3);
t6=C_i_foreign_fixnum_argumentp(C_fix(0));
t7=stub85(C_SCHEME_UNDEFINED,t4,t5,t6);
t8=t7;
t9=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2585,a[2]=t8,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t10=C_eqp(C_fix((C_word)INVALID_SOCKET),t8);
if(C_truep(t10)){
t11=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2781,a[2]=t9,a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],tmp=(C_word)a,a+=5,tmp);
t12=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2785,a[2]=t11,tmp=(C_word)a,a+=3,tmp);
/* ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[8]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[8]+1);
av2[1]=t12;
av2[2]=lf[70];
av2[3]=lf[10];
tp(4,av2);}}
else{
t11=t9;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t11;
av2[1]=C_SCHEME_UNDEFINED;
f_2585(2,av2);}}}

/* k2571 in k2565 in k2562 in k2559 in tcp-connect in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2573(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(11,c,4))){C_save_and_reclaim((void *)f_2573,2,av);}
a=C_alloc(11);
t2=C_i_check_exact(((C_word*)((C_word*)t0)[2])[1]);
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2579,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[2],tmp=(C_word)a,a+=7,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2798,a[2]=t3,a[3]=((C_word*)t0)[6],tmp=(C_word)a,a+=4,tmp);
/* tcp.scm:588: ##net#gethostaddr */
f_1240(t4,((C_word*)t0)[4],((C_word*)((C_word*)t0)[6])[1],((C_word*)((C_word*)t0)[2])[1]);}

/* a2817 in k2565 in k2562 in k2559 in tcp-connect in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2818(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_2818,4,av);}
t4=C_mutate2(((C_word *)((C_word*)t0)[2])+1,t2);
t5=C_mutate2(((C_word *)((C_word*)t0)[3])+1,t3);
t6=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}

/* a2811 in k2565 in k2562 in k2559 in tcp-connect in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2812(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(8,c,3))){C_save_and_reclaim((void *)f_2812,2,av);}
a=C_alloc(8);
t2=((C_word*)((C_word*)t0)[2])[1];
t3=C_block_size(t2);
t4=t3;
t5=C_SCHEME_UNDEFINED;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_set_block_item(t6,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1274,a[2]=t4,a[3]=t2,a[4]=t6,a[5]=((C_word)li31),tmp=(C_word)a,a+=6,tmp));
t8=((C_word*)t6)[1];
f_1274(t8,t1,C_fix(0));}

/* k2474 in k2470 in k2438 in k2435 in k2432 in k2429 in loop in k2420 in k2417 in tcp-accept in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2476(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_2476,2,av);}
/* tcp.scm:560: string-append */
t2=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k2470 in k2438 in k2435 in k2432 in k2429 in loop in k2420 in k2417 in tcp-accept in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2472(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(!C_demand(C_calculate_demand(9,c,3))){C_save_and_reclaim((void *)f_2472,2,av);}
a=C_alloc(9);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2476,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=stub64(C_SCHEME_UNDEFINED);
t5=C_a_i_bytevector(&a,1,C_fix(3));
t6=C_i_foreign_fixnum_argumentp(t4);
t7=stub68(t5,t6);
/* tcp.scm:163: ##sys#peek-c-string */
t8=*((C_word*)lf[7]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t8;
av2[1]=t3;
av2[2]=t7;
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t8+1)))(4,av2);}}

/* k2230 in loop in a2177 in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2232(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_2232,2,av);}
t2=C_eqp(((C_word*)((C_word*)t0)[2])[1],C_fix(0));
if(C_truep(t2)){
t3=((C_word*)t0)[3];
t4=((C_word*)t0)[4];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
/* tcp.scm:436: loop */
t3=((C_word*)((C_word*)t0)[5])[1];
f_2184(t3,((C_word*)t0)[4],((C_word*)t0)[6],((C_word*)t0)[3],((C_word*)t0)[7]);}}

/* k2245 in a2242 in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2247(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(8,c,2))){C_save_and_reclaim((void *)f_2247,2,av);}
a=C_alloc(8);
if(C_truep(C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]))){
t2=((C_word*)t0)[4];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_SCHEME_END_OF_FILE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
t2=((C_word*)t0)[5];
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2256,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[4],tmp=(C_word)a,a+=8,tmp);
if(C_truep(t2)){
t4=t3;
f_2256(t4,t2);}
else{
t4=C_fudge(C_fix(21));
t5=t3;
f_2256(t5,C_fixnum_difference(t4,((C_word*)((C_word*)t0)[2])[1]));}}}

/* a2242 in k1656 in k1653 in k1647 in k1644 in io-ports in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2243(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_demand(C_calculate_demand(9,c,2))){C_save_and_reclaim((void *)f_2243,4,av);}
a=C_alloc(9);
t4=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_2247,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=t3,a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[5],a[8]=t2,tmp=(C_word)a,a+=9,tmp);
if(C_truep(C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]))){
/* tcp.scm:439: read-input */
t5=((C_word*)t0)[5];
f_1659(t5,t4);}
else{
t5=t4;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t5;
av2[1]=C_SCHEME_UNDEFINED;
f_2247(2,av2);}}}

/* ##sys#tcp-port->fileno in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2836(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(4,c,2))){C_save_and_reclaim((void *)f_2836,3,av);}
a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2840,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* tcp.scm:618: ##sys#port-data */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[79]+1));
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[79]+1);
av2[1]=t3;
av2[2]=t2;
tp(3,av2);}}

/* tcp-listen in k1211 in k983 in k980 in k977 */
static void C_ccall f_1455(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +6,c,5))){
C_save_and_reclaim((void*)f_1455,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+6);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_fix(100):C_i_car(t3));
t6=t5;
t7=C_i_nullp(t3);
t8=(C_truep(t7)?C_SCHEME_END_OF_LIST:C_i_cdr(t3));
t9=C_i_nullp(t8);
t10=(C_truep(t9)?C_SCHEME_FALSE:C_i_car(t8));
t11=t10;
t12=C_i_nullp(t8);
t13=(C_truep(t12)?C_SCHEME_END_OF_LIST:C_i_cdr(t8));
t14=C_i_check_exact(t2);
t15=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1474,a[2]=t6,a[3]=t1,a[4]=t2,a[5]=t11,tmp=(C_word)a,a+=6,tmp);
t16=C_fixnum_lessp(t2,C_fix(0));
if(C_truep(t16)){
if(C_truep(t16)){
/* tcp.scm:318: ##sys#signal-hook */
t17=*((C_word*)lf[4]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t17;
av2[1]=t15;
av2[2]=lf[17];
av2[3]=lf[2];
av2[4]=lf[18];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t17+1)))(6,av2);}}
else{
t17=t15;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t17;
av2[1]=C_SCHEME_UNDEFINED;
f_1474(2,av2);}}}
else{
if(C_truep(C_fixnum_greaterp(t2,C_fix(65535)))){
/* tcp.scm:318: ##sys#signal-hook */
t17=*((C_word*)lf[4]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t17;
av2[1]=t15;
av2[2]=lf[17];
av2[3]=lf[2];
av2[4]=lf[18];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t17+1)))(6,av2);}}
else{
t17=t15;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t17;
av2[1]=C_SCHEME_UNDEFINED;
f_1474(2,av2);}}}}

/* tcp-abandon-port in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_3031(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(4,c,2))){C_save_and_reclaim((void *)f_3031,3,av);}
a=C_alloc(4);
t3=t2;
t4=C_i_check_port_2(t3,C_fix(0),C_SCHEME_TRUE,lf[88]);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3041,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* tcp.scm:654: ##sys#port-data */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[79]+1));
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[79]+1);
av2[1]=t5;
av2[2]=t2;
tp(3,av2);}}

/* k2802 in k2565 in k2562 in k2559 in tcp-connect in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_2804(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,5))){C_save_and_reclaim((void *)f_2804,2,av);}
if(C_truep(((C_word*)((C_word*)t0)[2])[1])){
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[3];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=t2;
f_2573(2,av2);}}
else{
/* tcp.scm:586: ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=lf[17];
av2[3]=lf[64];
av2[4]=lf[72];
av2[5]=((C_word*)((C_word*)t0)[4])[1];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}}

/* k3039 in tcp-abandon-port in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_3041(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_3041,2,av);}
t2=C_slot(((C_word*)t0)[2],C_fix(1));
t3=((C_word*)t0)[3];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=(C_truep(t2)?C_i_set_i_slot(t1,C_fix(1),C_SCHEME_TRUE):C_i_set_i_slot(t1,C_fix(2),C_SCHEME_TRUE));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* tcp-listener-fileno in k1638 in k1634 in k1630 in k1626 in k1603 in k1211 in k983 in k980 in k977 */
static void C_ccall f_3050(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_3050,3,av);}
t3=C_i_check_structure_2(t2,lf[3],lf[89]);
t4=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=C_slot(t2,C_fix(1));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

#ifdef C_ENABLE_PTABLES
static C_PTABLE_ENTRY ptable[219] = {
{"f_3065:tcp_2escm",(void*)f_3065},
{"f_1483:tcp_2escm",(void*)f_1483},
{"f_1480:tcp_2escm",(void*)f_1480},
{"f_3061:tcp_2escm",(void*)f_3061},
{"f_3069:tcp_2escm",(void*)f_3069},
{"f_3073:tcp_2escm",(void*)f_3073},
{"f_2468:tcp_2escm",(void*)f_2468},
{"f_1474:tcp_2escm",(void*)f_1474},
{"f_2712:tcp_2escm",(void*)f_2712},
{"f_2704:tcp_2escm",(void*)f_2704},
{"f_2708:tcp_2escm",(void*)f_2708},
{"f_2118:tcp_2escm",(void*)f_2118},
{"f_1887:tcp_2escm",(void*)f_1887},
{"f_2110:tcp_2escm",(void*)f_2110},
{"f_2731:tcp_2escm",(void*)f_2731},
{"f_1894:tcp_2escm",(void*)f_1894},
{"f_1897:tcp_2escm",(void*)f_1897},
{"f_1563:tcp_2escm",(void*)f_1563},
{"f_2135:tcp_2escm",(void*)f_2135},
{"f_2139:tcp_2escm",(void*)f_2139},
{"f_2131:tcp_2escm",(void*)f_2131},
{"f_2102:tcp_2escm",(void*)f_2102},
{"f_1583:tcp_2escm",(void*)f_1583},
{"f_1587:tcp_2escm",(void*)f_1587},
{"f_1591:tcp_2escm",(void*)f_1591},
{"f_2010:tcp_2escm",(void*)f_2010},
{"f_2015:tcp_2escm",(void*)f_2015},
{"f_2124:tcp_2escm",(void*)f_2124},
{"f_2600:tcp_2escm",(void*)f_2600},
{"f_2619:tcp_2escm",(void*)f_2619},
{"f_2030:tcp_2escm",(void*)f_2030},
{"f_2366:tcp_2escm",(void*)f_2366},
{"f_2004:tcp_2escm",(void*)f_2004},
{"f_1447:tcp_2escm",(void*)f_1447},
{"f_2376:tcp_2escm",(void*)f_2376},
{"f_1912:tcp_2escm",(void*)f_1912},
{"f_1693:tcp_2escm",(void*)f_1693},
{"f_1696:tcp_2escm",(void*)f_1696},
{"f_1699:tcp_2escm",(void*)f_1699},
{"f_1671:tcp_2escm",(void*)f_1671},
{"f_1915:tcp_2escm",(void*)f_1915},
{"f_2024:tcp_2escm",(void*)f_2024},
{"f_2261:tcp_2escm",(void*)f_2261},
{"f_1421:tcp_2escm",(void*)f_1421},
{"f_1425:tcp_2escm",(void*)f_1425},
{"f_1924:tcp_2escm",(void*)f_1924},
{"f_1663:tcp_2escm",(void*)f_1663},
{"f_1666:tcp_2escm",(void*)f_1666},
{"f_2271:tcp_2escm",(void*)f_2271},
{"f_2739:tcp_2escm",(void*)f_2739},
{"f_1274:tcp_2escm",(void*)f_1274},
{"f_2735:tcp_2escm",(void*)f_2735},
{"f_1935:tcp_2escm",(void*)f_1935},
{"f_1932:tcp_2escm",(void*)f_1932},
{"f_2287:tcp_2escm",(void*)f_2287},
{"f_1401:tcp_2escm",(void*)f_1401},
{"f_1941:tcp_2escm",(void*)f_1941},
{"f_1948:tcp_2escm",(void*)f_1948},
{"f_2757:tcp_2escm",(void*)f_2757},
{"f_1952:tcp_2escm",(void*)f_1952},
{"f_1956:tcp_2escm",(void*)f_1956},
{"f_2504:tcp_2escm",(void*)f_2504},
{"f_1690:tcp_2escm",(void*)f_1690},
{"f_2502:tcp_2escm",(void*)f_2502},
{"f_2627:tcp_2escm",(void*)f_2627},
{"f_2623:tcp_2escm",(void*)f_2623},
{"f_2514:tcp_2escm",(void*)f_2514},
{"f_2588:tcp_2escm",(void*)f_2588},
{"f_2585:tcp_2escm",(void*)f_2585},
{"f_1554:tcp_2escm",(void*)f_1554},
{"f_2591:tcp_2escm",(void*)f_2591},
{"f_2992:tcp_2escm",(void*)f_2992},
{"f_2594:tcp_2escm",(void*)f_2594},
{"f_2256:tcp_2escm",(void*)f_2256},
{"f_1297:tcp_2escm",(void*)f_1297},
{"f_2649:tcp_2escm",(void*)f_2649},
{"f_2645:tcp_2escm",(void*)f_2645},
{"f_1994:tcp_2escm",(void*)f_1994},
{"f_2657:tcp_2escm",(void*)f_2657},
{"f_2653:tcp_2escm",(void*)f_2653},
{"f_2184:tcp_2escm",(void*)f_2184},
{"f_1502:tcp_2escm",(void*)f_1502},
{"f_1506:tcp_2escm",(void*)f_1506},
{"f_3005:tcp_2escm",(void*)f_3005},
{"f_2854:tcp_2escm",(void*)f_2854},
{"f_2909:tcp_2escm",(void*)f_2909},
{"f_2905:tcp_2escm",(void*)f_2905},
{"f_1365:tcp_2escm",(void*)f_1365},
{"f_2828:tcp_2escm",(void*)f_2828},
{"f_1362:tcp_2escm",(void*)f_1362},
{"f_3015:tcp_2escm",(void*)f_3015},
{"f_3019:tcp_2escm",(void*)f_3019},
{"f_1417:tcp_2escm",(void*)f_1417},
{"f_2178:tcp_2escm",(void*)f_2178},
{"f_1377:tcp_2escm",(void*)f_1377},
{"f_1374:tcp_2escm",(void*)f_1374},
{"f_3023:tcp_2escm",(void*)f_3023},
{"f_1371:tcp_2escm",(void*)f_1371},
{"f_2927:tcp_2escm",(void*)f_2927},
{"f_2921:tcp_2escm",(void*)f_2921},
{"f_1772:tcp_2escm",(void*)f_1772},
{"f_1774:tcp_2escm",(void*)f_1774},
{"f_2840:tcp_2escm",(void*)f_2840},
{"f_1393:tcp_2escm",(void*)f_1393},
{"f_1397:tcp_2escm",(void*)f_1397},
{"f_2527:tcp_2escm",(void*)f_2527},
{"f_2164:tcp_2escm",(void*)f_2164},
{"f_2160:tcp_2escm",(void*)f_2160},
{"f_2535:tcp_2escm",(void*)f_2535},
{"f_2419:tcp_2escm",(void*)f_2419},
{"f_1646:tcp_2escm",(void*)f_1646},
{"f_1640:tcp_2escm",(void*)f_1640},
{"f_2531:tcp_2escm",(void*)f_2531},
{"f_1642:tcp_2escm",(void*)f_1642},
{"f_2427:tcp_2escm",(void*)f_2427},
{"f_1655:tcp_2escm",(void*)f_1655},
{"f_1649:tcp_2escm",(void*)f_1649},
{"f_2422:tcp_2escm",(void*)f_2422},
{"f_2554:tcp_2escm",(void*)f_2554},
{"f_1658:tcp_2escm",(void*)f_1658},
{"f_1659:tcp_2escm",(void*)f_1659},
{"f_1510:tcp_2escm",(void*)f_1510},
{"f_2877:tcp_2escm",(void*)f_2877},
{"f_2870:tcp_2escm",(void*)f_2870},
{"f_2874:tcp_2escm",(void*)f_2874},
{"f_1636:tcp_2escm",(void*)f_1636},
{"f_1632:tcp_2escm",(void*)f_1632},
{"f_1628:tcp_2escm",(void*)f_1628},
{"f_1240:tcp_2escm",(void*)f_1240},
{"f_2952:tcp_2escm",(void*)f_2952},
{"f_2956:tcp_2escm",(void*)f_2956},
{"f_2892:tcp_2escm",(void*)f_2892},
{"f_1213:tcp_2escm",(void*)f_1213},
{"f_1249:tcp_2escm",(void*)f_1249},
{"f_1978:tcp_2escm",(void*)f_1978},
{"f_2867:tcp_2escm",(void*)f_2867},
{"f_2860:tcp_2escm",(void*)f_2860},
{"f_1220:tcp_2escm",(void*)f_1220},
{"f_2050:tcp_2escm",(void*)f_2050},
{"f_1224:tcp_2escm",(void*)f_1224},
{"toplevel:tcp_2escm",(void*)C_tcp_toplevel},
{"f_1981:tcp_2escm",(void*)f_1981},
{"f_2409:tcp_2escm",(void*)f_2409},
{"f_2405:tcp_2escm",(void*)f_2405},
{"f_2401:tcp_2escm",(void*)f_2401},
{"f_2888:tcp_2escm",(void*)f_2888},
{"f_2884:tcp_2escm",(void*)f_2884},
{"f_2913:tcp_2escm",(void*)f_2913},
{"f_985:tcp_2escm",(void*)f_985},
{"f_982:tcp_2escm",(void*)f_982},
{"f_2046:tcp_2escm",(void*)f_2046},
{"f_2960:tcp_2escm",(void*)f_2960},
{"f_2397:tcp_2escm",(void*)f_2397},
{"f_2317:tcp_2escm",(void*)f_2317},
{"f_1735:tcp_2escm",(void*)f_1735},
{"f_1731:tcp_2escm",(void*)f_1731},
{"f_2984:tcp_2escm",(void*)f_2984},
{"f_2098:tcp_2escm",(void*)f_2098},
{"f_2980:tcp_2escm",(void*)f_2980},
{"f_2676:tcp_2escm",(void*)f_2676},
{"f_2437:tcp_2escm",(void*)f_2437},
{"f_2094:tcp_2escm",(void*)f_2094},
{"f_2434:tcp_2escm",(void*)f_2434},
{"f_2939:tcp_2escm",(void*)f_2939},
{"f_2936:tcp_2escm",(void*)f_2936},
{"f_2673:tcp_2escm",(void*)f_2673},
{"f_2431:tcp_2escm",(void*)f_2431},
{"f_2068:tcp_2escm",(void*)f_2068},
{"f_1756:tcp_2escm",(void*)f_1756},
{"f_1753:tcp_2escm",(void*)f_1753},
{"f_2440:tcp_2escm",(void*)f_2440},
{"f_1757:tcp_2escm",(void*)f_1757},
{"f_2761:tcp_2escm",(void*)f_2761},
{"f_979:tcp_2escm",(void*)f_979},
{"f_2765:tcp_2escm",(void*)f_2765},
{"f_1605:tcp_2escm",(void*)f_1605},
{"f_1304:tcp_2escm",(void*)f_1304},
{"f_1301:tcp_2escm",(void*)f_1301},
{"f_1307:tcp_2escm",(void*)f_1307},
{"f_1727:tcp_2escm",(void*)f_1727},
{"f_1828:tcp_2escm",(void*)f_1828},
{"f_2081:tcp_2escm",(void*)f_2081},
{"f_2976:tcp_2escm",(void*)f_2976},
{"f_1611:tcp_2escm",(void*)f_1611},
{"f_1613:tcp_2escm",(void*)f_1613},
{"f_1799:tcp_2escm",(void*)f_1799},
{"f_1796:tcp_2escm",(void*)f_1796},
{"f_1317:tcp_2escm",(void*)f_1317},
{"f_2789:tcp_2escm",(void*)f_2789},
{"f_2781:tcp_2escm",(void*)f_2781},
{"f_1839:tcp_2escm",(void*)f_1839},
{"f_2785:tcp_2escm",(void*)f_2785},
{"f_1321:tcp_2escm",(void*)f_1321},
{"f_1325:tcp_2escm",(void*)f_1325},
{"f_1761:tcp_2escm",(void*)f_1761},
{"f_2798:tcp_2escm",(void*)f_2798},
{"f_1802:tcp_2escm",(void*)f_1802},
{"f_1805:tcp_2escm",(void*)f_1805},
{"f_1847:tcp_2escm",(void*)f_1847},
{"f_2567:tcp_2escm",(void*)f_2567},
{"f_2561:tcp_2escm",(void*)f_2561},
{"f_2564:tcp_2escm",(void*)f_2564},
{"f_1843:tcp_2escm",(void*)f_1843},
{"f_2579:tcp_2escm",(void*)f_2579},
{"f_2573:tcp_2escm",(void*)f_2573},
{"f_2818:tcp_2escm",(void*)f_2818},
{"f_2812:tcp_2escm",(void*)f_2812},
{"f_2476:tcp_2escm",(void*)f_2476},
{"f_2472:tcp_2escm",(void*)f_2472},
{"f_2232:tcp_2escm",(void*)f_2232},
{"f_2247:tcp_2escm",(void*)f_2247},
{"f_2243:tcp_2escm",(void*)f_2243},
{"f_2836:tcp_2escm",(void*)f_2836},
{"f_1455:tcp_2escm",(void*)f_1455},
{"f_3031:tcp_2escm",(void*)f_3031},
{"f_2804:tcp_2escm",(void*)f_2804},
{"f_3041:tcp_2escm",(void*)f_3041},
{"f_3050:tcp_2escm",(void*)f_3050},
{NULL,NULL}};
#endif

static C_PTABLE_ENTRY *create_ptable(void){
#ifdef C_ENABLE_PTABLES
return ptable;
#else
return NULL;
#endif
}

/*
o|eliminated procedure checks: 166 
o|specializations:
o|  3 (##sys#check-open-port * *)
o|  1 (make-string fixnum)
o|  24 (string-append string string)
(o e)|safe calls: 336 
o|Removed `not' forms: 1 
o|inlining procedure: k1276 
o|inlining procedure: k1276 
o|inlining procedure: k1305 
o|inlining procedure: "(tcp.scm:283) last-error-code" 
o|substituted constant variable: a1330 
o|substituted constant variable: a1331 
o|inlining procedure: k1305 
o|contracted procedure: "(tcp.scm:281) getservbyname" 
o|inlining procedure: k1222 
o|inlining procedure: k1222 
o|inlining procedure: k1481 
o|substituted constant variable: a1511 
o|substituted constant variable: a1512 
o|inlining procedure: "(tcp.scm:322) close" 
o|inlining procedure: "(tcp.scm:322) last-error-code" 
o|inlining procedure: k1481 
o|contracted procedure: "(tcp.scm:321) listen" 
o|contracted procedure: "(tcp.scm:320) bind-socket" 
o|inlining procedure: k1375 
o|substituted constant variable: a1402 
o|substituted constant variable: a1403 
o|inlining procedure: "(tcp.scm:310) close" 
o|inlining procedure: "(tcp.scm:310) last-error-code" 
o|inlining procedure: k1375 
o|contracted procedure: "(tcp.scm:309) bind" 
o|inlining procedure: "(tcp.scm:308) last-error-code" 
o|substituted constant variable: a1430 
o|substituted constant variable: a1431 
o|inlining procedure: "(tcp.scm:307) set-socket-options" 
o|inlining procedure: k1442 
o|inlining procedure: k1442 
o|contracted procedure: "(tcp.scm:302) fresh-addr" 
o|inlining procedure: k1556 
o|inlining procedure: k1556 
o|inlining procedure: k1571 
o|inlining procedure: "(tcp.scm:333) last-error-code" 
o|substituted constant variable: a1596 
o|substituted constant variable: a1597 
o|inlining procedure: k1571 
o|inlining procedure: "(tcp.scm:332) close" 
o|inlining procedure: k1615 
o|inlining procedure: k1615 
o|inlining procedure: k1676 
o|inlining procedure: k1697 
o|inlining procedure: k1697 
o|inlining procedure: k1712 
o|inlining procedure: k1712 
o|inlining procedure: "(tcp.scm:388) last-error-code" 
o|substituted constant variable: a1740 
o|substituted constant variable: a1741 
o|inlining procedure: "(tcp.scm:385) interrupted?" 
o|inlining procedure: "(tcp.scm:374) retry?" 
o|inlining procedure: k1676 
o|contracted procedure: "(tcp.scm:372) recv" 
o|inlining procedure: k1782 
o|inlining procedure: k1818 
o|inlining procedure: k1818 
o|inlining procedure: "(tcp.scm:499) last-error-code" 
o|substituted constant variable: a1852 
o|substituted constant variable: a1853 
o|inlining procedure: "(tcp.scm:495) interrupted?" 
o|inlining procedure: "(tcp.scm:484) retry?" 
o|inlining procedure: k1782 
o|inlining procedure: k1872 
o|inlining procedure: k1872 
o|contracted procedure: "(tcp.scm:482) send" 
o|inlining procedure: k1926 
o|inlining procedure: k1926 
o|inlining procedure: "(tcp.scm:525) last-error-code" 
o|substituted constant variable: a1961 
o|substituted constant variable: a1962 
o|inlining procedure: "(tcp.scm:524) close" 
o|inlining procedure: k1991 
o|inlining procedure: k1996 
o|inlining procedure: k1996 
o|inlining procedure: k1991 
o|inlining procedure: k2016 
o|inlining procedure: k2016 
o|inlining procedure: k2032 
o|inlining procedure: k2032 
o|inlining procedure: k2051 
o|inlining procedure: k2051 
o|inlining procedure: k2073 
o|inlining procedure: k2073 
o|inlining procedure: "(tcp.scm:409) last-error-code" 
o|substituted constant variable: a2107 
o|substituted constant variable: a2108 
o|inlining procedure: "(tcp.scm:407) check-fd-ready" 
o|inlining procedure: k2112 
o|inlining procedure: k2112 
o|inlining procedure: "(tcp.scm:416) last-error-code" 
o|substituted constant variable: a2144 
o|substituted constant variable: a2145 
o|inlining procedure: "(tcp.scm:415) close" 
o|inlining procedure: k2165 
o|inlining procedure: k2165 
o|inlining procedure: k2186 
o|inlining procedure: k2186 
o|inlining procedure: k2233 
o|inlining procedure: k2233 
o|inlining procedure: k2248 
o|inlining procedure: k2248 
o|inlining procedure: k2276 
o|inlining procedure: k2276 
o|inlining procedure: k2319 
o|inlining procedure: k2319 
o|inlining procedure: k2368 
o|inlining procedure: k2368 
o|inlining procedure: k2378 
o|inlining procedure: k2378 
o|substituted constant variable: a2384 
o|substituted constant variable: a2406 
o|substituted constant variable: a2407 
o|inlining procedure: "(tcp.scm:358) close" 
o|inlining procedure: "(tcp.scm:358) last-error-code" 
o|contracted procedure: k2447 
o|inlining procedure: k2444 
o|inlining procedure: "(tcp.scm:560) last-error-code" 
o|substituted constant variable: a2481 
o|substituted constant variable: a2482 
o|inlining procedure: "(tcp.scm:557) interrupted?" 
o|inlining procedure: k2444 
o|contracted procedure: "(tcp.scm:554) accept" 
o|inlining procedure: k1065 
o|inlining procedure: k1065 
o|inlining procedure: k2512 
o|inlining procedure: "(tcp.scm:567) last-error-code" 
o|substituted constant variable: a2540 
o|substituted constant variable: a2541 
o|inlining procedure: k2512 
o|inlining procedure: "(tcp.scm:565) check-fd-ready" 
o|inlining procedure: k2598 
o|substituted constant variable: a2628 
o|substituted constant variable: a2629 
o|inlining procedure: "(tcp.scm:611) close" 
o|inlining procedure: "(tcp.scm:611) last-error-code" 
o|inlining procedure: k2598 
o|substituted constant variable: a2654 
o|substituted constant variable: a2655 
o|inlining procedure: "(tcp.scm:613) close" 
o|contracted procedure: "(tcp.scm:609) get-socket-error" 
o|inlining procedure: k2659 
o|inlining procedure: k2683 
o|inlining procedure: k2683 
o|substituted constant variable: a2713 
o|substituted constant variable: a2714 
o|inlining procedure: "(tcp.scm:607) close" 
o|inlining procedure: "(tcp.scm:607) last-error-code" 
o|inlining procedure: "(tcp.scm:604) interrupted?" 
o|contracted procedure: "(tcp.scm:599) in-progress?" 
o|inlining procedure: k2659 
o|contracted procedure: "(tcp.scm:598) connect" 
o|substituted constant variable: a2740 
o|substituted constant variable: a2741 
o|inlining procedure: "(tcp.scm:596) close" 
o|inlining procedure: "(tcp.scm:596) last-error-code" 
o|substituted constant variable: a2766 
o|substituted constant variable: a2767 
o|inlining procedure: "(tcp.scm:594) close" 
o|inlining procedure: "(tcp.scm:594) last-error-code" 
o|inlining procedure: "(tcp.scm:593) set-socket-options" 
o|inlining procedure: "(tcp.scm:592) last-error-code" 
o|substituted constant variable: a2794 
o|substituted constant variable: a2795 
o|inlining procedure: k2805 
o|inlining procedure: k2805 
o|inlining procedure: k2841 
o|inlining procedure: k2841 
o|substituted constant variable: a2857 
o|inlining procedure: k2875 
o|inlining procedure: k2875 
o|inlining procedure: "(tcp.scm:629) last-error-code" 
o|substituted constant variable: a2897 
o|substituted constant variable: a2898 
o|contracted procedure: "(tcp.scm:629) getpeername" 
o|inlining procedure: "(tcp.scm:627) last-error-code" 
o|substituted constant variable: a2918 
o|substituted constant variable: a2919 
o|contracted procedure: "(tcp.scm:627) getsockname" 
o|substituted constant variable: a2924 
o|inlining procedure: k2937 
o|inlining procedure: "(tcp.scm:640) last-error-code" 
o|substituted constant variable: a2965 
o|substituted constant variable: a2966 
o|inlining procedure: k2937 
o|inlining procedure: "(tcp.scm:638) last-error-code" 
o|substituted constant variable: a2989 
o|substituted constant variable: a2990 
o|contracted procedure: "(tcp.scm:636) getpeerport" 
o|inlining procedure: "(tcp.scm:635) getsockport" 
o|inlining procedure: k3003 
o|inlining procedure: "(tcp.scm:648) last-error-code" 
o|substituted constant variable: a3028 
o|substituted constant variable: a3029 
o|inlining procedure: k3003 
o|inlining procedure: "(tcp.scm:646) getsockport" 
o|substituted constant variable: a3034 
o|inlining procedure: k3043 
o|inlining procedure: k3043 
o|folded constant expression: (fx* (quote 60) (quote 1000)) 
o|contracted procedure: "(tcp.scm:229) startup" 
o|replaced variables: 303 
o|removed binding forms: 146 
o|removed side-effect free assignment to unused variable: ##net#last-error-code 
o|removed side-effect free assignment to unused variable: ##net#retry? 
o|removed side-effect free assignment to unused variable: ##net#interrupted? 
o|removed side-effect free assignment to unused variable: ##net#close 
o|removed side-effect free assignment to unused variable: ##net#check-fd-ready 
o|removed side-effect free assignment to unused variable: ##net#set-socket-options 
o|removed side-effect free assignment to unused variable: ##net#getsockport 
o|substituted constant variable: r15573131 
o|contracted procedure: k1622 
o|substituted constant variable: int130137 
o|substituted constant variable: int129136 
o|inlining procedure: k1872 
o|substituted constant variable: flags172180 
o|substituted constant variable: r19923186 
o|substituted constant variable: r19923186 
o|substituted constant variable: r20523192 
o|inlining procedure: k2079 
o|substituted constant variable: r21663213 
o|substituted constant variable: r22493218 
o|substituted constant variable: r23693230 
o|substituted constant variable: r23793232 
o|substituted constant variable: r23793233 
o|substituted constant variable: c-pointer110117 
o|substituted constant variable: c-pointer111118 
o|substituted constant variable: c-pointer111118 
o|substituted constant variable: c-pointer111118 
o|substituted constant variable: r10663247 
o|substituted constant variable: r10663247 
o|substituted constant variable: c-pointer110117 
o|substituted constant variable: c-pointer110117 
o|inlining procedure: k2598 
o|contracted procedure: "(tcp.scm:585) parse-host" 
o|substituted constant variable: r12233091 
o|substituted constant variable: r12233091 
o|substituted constant variable: r30443361 
o|substituted constant variable: r30443361 
o|substituted constant variable: r30443363 
o|substituted constant variable: r30443363 
o|replaced variables: 94 
o|removed binding forms: 366 
o|removed conditional forms: 2 
o|inlining procedure: k1427 
o|inlining procedure: k1520 
o|inlining procedure: k1593 
o|substituted constant variable: r1623 
o|inlining procedure: k1737 
o|inlining procedure: k1803 
o|inlining procedure: k1849 
o|substituted constant variable: r18733369 
o|inlining procedure: k1958 
o|inlining procedure: k2104 
o|inlining procedure: k2141 
o|inlining procedure: k2478 
o|contracted procedure: k1061 
o|inlining procedure: k2537 
o|inlining procedure: k2791 
o|inlining procedure: k1327 
o|substituted constant variable: proto336 
o|inlining procedure: k2894 
o|inlining procedure: k2915 
o|inlining procedure: k2962 
o|inlining procedure: k2986 
o|inlining procedure: k3025 
o|inlining procedure: k3074 
o|replaced variables: 6 
o|removed binding forms: 134 
o|contracted procedure: k1490 
o|contracted procedure: k1381 
o|contracted procedure: k1685 
o|contracted procedure: k1715 
o|contracted procedure: k1791 
o|contracted procedure: k1821 
o|contracted procedure: k2385 
o|contracted procedure: k2456 
o|substituted constant variable: r1062 
o|substituted constant variable: r1062 
o|contracted procedure: k2607 
o|contracted procedure: k2668 
o|contracted procedure: k2686 
o|contracted procedure: k2692 
o|contracted procedure: k2719 
o|contracted procedure: k2745 
o|substituted constant variable: minute421 
o|substituted constant variable: minute421 
o|simplifications: ((let . 8)) 
o|replaced variables: 1 
o|removed binding forms: 40 
o|removed side-effect free assignment to unused variable: minute421 
o|removed binding forms: 3 
o|converted assignments to bindings: (check420) 
o|simplifications: ((let . 1)) 
o|removed binding forms: 2 
o|simplifications: ((if . 16) (##core#call . 198)) 
o|  call simplifications:
o|    vector?
o|    ##sys#check-string
o|    char=?
o|    vector
o|    ##sys#fudge
o|    ##sys#call-with-values	2
o|    fx>=	9
o|    ##sys#setslot	4
o|    values	11
o|    ##sys#size	7
o|    fxmin	3
o|    fx-	6
o|    fx+	12
o|    fx=
o|    +	5
o|    ##sys#setislot	6
o|    ##sys#check-structure	5
o|    ##sys#slot	14
o|    ##sys#structure?
o|    car	3
o|    null?	5
o|    cdr	2
o|    fx<	7
o|    fx>	6
o|    ##sys#check-exact	4
o|    eq?	26
o|    ##sys#make-structure	2
o|    ##sys#foreign-block-argument	6
o|    ##sys#foreign-string-argument	3
o|    ##sys#foreign-fixnum-argument	43
o|contracted procedure: k997 
o|contracted procedure: k1013 
o|contracted procedure: k1017 
o|contracted procedure: k1021 
o|contracted procedure: k1107 
o|contracted procedure: k1111 
o|contracted procedure: k1243 
o|contracted procedure: k1251 
o|contracted procedure: k1258 
o|contracted procedure: k1547 
o|contracted procedure: k1457 
o|contracted procedure: k1541 
o|contracted procedure: k1460 
o|contracted procedure: k1535 
o|contracted procedure: k1463 
o|contracted procedure: k1529 
o|contracted procedure: k1466 
o|contracted procedure: k1469 
o|contracted procedure: k1475 
o|contracted procedure: k1487 
o|contracted procedure: k10783103 
o|contracted procedure: k1046 
o|contracted procedure: k1050 
o|contracted procedure: k1378 
o|contracted procedure: k10783117 
o|contracted procedure: k1028 
o|contracted procedure: k1032 
o|contracted procedure: k1036 
o|contracted procedure: k1408 
o|contracted procedure: k11433127 
o|contracted procedure: k1436 
o|contracted procedure: k1347 
o|contracted procedure: k1351 
o|contracted procedure: k1517 
o|contracted procedure: k1520 
o|contracted procedure: k1565 
o|contracted procedure: k1568 
o|contracted procedure: k1574 
o|contracted procedure: k10783140 
o|contracted procedure: k1615 
o|contracted procedure: k1650 
o|contracted procedure: k1679 
o|contracted procedure: k1703 
o|contracted procedure: k1743 
o|contracted procedure: k1085 
o|contracted procedure: k1089 
o|contracted procedure: k1093 
o|contracted procedure: k1097 
o|contracted procedure: k1766 
o|contracted procedure: k1776 
o|contracted procedure: k1785 
o|contracted procedure: k1809 
o|contracted procedure: k1857 
o|contracted procedure: k1864 
o|contracted procedure: k1868 
o|contracted procedure: k1875 
o|contracted procedure: k1872 
o|contracted procedure: k1150 
o|contracted procedure: k1154 
o|contracted procedure: k1158 
o|contracted procedure: k1162 
o|contracted procedure: k1166 
o|contracted procedure: k1898 
o|contracted procedure: k1901 
o|contracted procedure: k1904 
o|contracted procedure: k1907 
o|contracted procedure: k1920 
o|contracted procedure: k2027 
o|contracted procedure: k2019 
o|contracted procedure: k2042 
o|contracted procedure: k2035 
o|contracted procedure: k10783181 
o|contracted procedure: k1970 
o|contracted procedure: k1987 
o|contracted procedure: k2007 
o|contracted procedure: k1999 
o|contracted procedure: k2054 
o|contracted procedure: k2058 
o|contracted procedure: k2061 
o|contracted procedure: k2070 
o|contracted procedure: k2085 
o|contracted procedure: k11363202 
o|contracted procedure: k10783211 
o|contracted procedure: k2153 
o|contracted procedure: k2168 
o|contracted procedure: k2171 
o|contracted procedure: k2189 
o|contracted procedure: k2195 
o|contracted procedure: k2198 
o|contracted procedure: k2227 
o|contracted procedure: k2201 
o|contracted procedure: k2205 
o|contracted procedure: k2209 
o|contracted procedure: k2216 
o|contracted procedure: k2220 
o|contracted procedure: k2224 
o|contracted procedure: k2236 
o|contracted procedure: k2251 
o|contracted procedure: k2313 
o|contracted procedure: k2267 
o|contracted procedure: k2273 
o|contracted procedure: k2279 
o|contracted procedure: k2289 
o|contracted procedure: k2295 
o|contracted procedure: k2306 
o|contracted procedure: k2302 
o|contracted procedure: k2334 
o|contracted procedure: k2330 
o|contracted procedure: k2323 
o|inlining procedure: k2319 
o|contracted procedure: k2345 
o|contracted procedure: k2349 
o|contracted procedure: k2341 
o|inlining procedure: k2319 
o|contracted procedure: k2356 
o|contracted procedure: k2359 
o|contracted procedure: k2371 
o|contracted procedure: k2381 
o|contracted procedure: k10783239 
o|contracted procedure: k2411 
o|contracted procedure: k2414 
o|contracted procedure: k2484 
o|contracted procedure: k1057 
o|contracted procedure: k2487 
o|contracted procedure: k2506 
o|contracted procedure: k2518 
o|contracted procedure: k2543 
o|contracted procedure: k11363265 
o|contracted procedure: k2829 
o|contracted procedure: k2556 
o|contracted procedure: k2568 
o|contracted procedure: k2574 
o|contracted procedure: k2604 
o|contracted procedure: k10783276 
o|contracted procedure: k2633 
o|contracted procedure: k10783288 
o|contracted procedure: k2550 
o|contracted procedure: k2662 
o|contracted procedure: k10783297 
o|contracted procedure: k1118 
o|contracted procedure: k1122 
o|contracted procedure: k1126 
o|contracted procedure: k10783306 
o|contracted procedure: k2742 
o|contracted procedure: k10783313 
o|contracted procedure: k11433320 
o|contracted procedure: k2772 
o|contracted procedure: k1267 
o|contracted procedure: k1279 
o|contracted procedure: k1288 
o|contracted procedure: k1308 
o|contracted procedure: k1229 
o|contracted procedure: k1236 
o|contracted procedure: k1333 
o|contracted procedure: k1340 
o|contracted procedure: k2844 
o|contracted procedure: k1205 
o|contracted procedure: k1180 
o|contracted procedure: k2943 
o|contracted procedure: k2967 
o|contracted procedure: k1194 
o|contracted procedure: k11873349 
o|contracted procedure: k2994 
o|contracted procedure: k2997 
o|contracted procedure: k3006 
o|contracted procedure: k11873360 
o|contracted procedure: k3046 
o|contracted procedure: k3052 
o|simplifications: ((let . 24)) 
o|removed binding forms: 166 
o|inlining procedure: k1247 
o|inlining procedure: "(tcp.scm:322) error-code->message" 
o|inlining procedure: "(tcp.scm:310) error-code->message" 
o|inlining procedure: "(tcp.scm:308) error-code->message" 
o|inlining procedure: "(tcp.scm:333) error-code->message" 
o|inlining procedure: "(tcp.scm:388) error-code->message" 
o|inlining procedure: "(tcp.scm:499) error-code->message" 
o|inlining procedure: "(tcp.scm:525) error-code->message" 
o|inlining procedure: "(tcp.scm:523) shutdown" 
o|inlining procedure: "(tcp.scm:409) error-code->message" 
o|inlining procedure: "(tcp.scm:416) error-code->message" 
o|inlining procedure: "(tcp.scm:414) shutdown" 
o|inlining procedure: "(tcp.scm:358) error-code->message" 
o|inlining procedure: "(tcp.scm:560) error-code->message" 
o|inlining procedure: "(tcp.scm:567) error-code->message" 
o|inlining procedure: "(tcp.scm:611) error-code->message" 
o|inlining procedure: "(tcp.scm:614) error-code->message" 
o|inlining procedure: "(tcp.scm:607) error-code->message" 
o|inlining procedure: "(tcp.scm:596) error-code->message" 
o|inlining procedure: "(tcp.scm:594) error-code->message" 
o|inlining procedure: "(tcp.scm:592) error-code->message" 
o|inlining procedure: "(tcp.scm:283) error-code->message" 
o|inlining procedure: "(tcp.scm:629) error-code->message" 
o|inlining procedure: "(tcp.scm:627) error-code->message" 
o|inlining procedure: "(tcp.scm:640) error-code->message" 
o|inlining procedure: "(tcp.scm:638) error-code->message" 
o|inlining procedure: "(tcp.scm:648) error-code->message" 
o|replaced variables: 93 
o|removed binding forms: 1 
o|removed side-effect free assignment to unused variable: ##net#error-code->message 
o|removed side-effect free assignment to unused variable: ##net#shutdown 
o|substituted constant variable: r12483506 
o|substituted constant variable: r12483506 
o|inlining procedure: k1967 
o|inlining procedure: k2150 
o|replaced variables: 52 
o|removed binding forms: 67 
o|contracted procedure: k1514 
o|contracted procedure: k1493 
o|contracted procedure: k1405 
o|contracted procedure: k1384 
o|contracted procedure: k1433 
o|inlining procedure: "(tcp.scm:303) socket" 
o|contracted procedure: k1599 
o|contracted procedure: k1673 
o|contracted procedure: k1779 
o|contracted procedure: k2076 
o|contracted procedure: k2388 
o|contracted procedure: k2441 
o|contracted procedure: k2509 
o|contracted procedure: k2595 
o|contracted procedure: k2610 
o|contracted procedure: k2636 
o|contracted procedure: k2716 
o|contracted procedure: k2695 
o|contracted procedure: k2722 
o|contracted procedure: k2769 
o|contracted procedure: k2748 
o|inlining procedure: "(tcp.scm:590) socket" 
o|contracted procedure: k2928 
o|contracted procedure: k2931 
o|contracted procedure: k3000 
o|removed binding forms: 81 
o|removed side-effect free assignment to unused variable: ##net#socket 
o|substituted constant variable: int84893670 
o|substituted constant variable: int84893687 
o|replaced variables: 5 
o|removed binding forms: 7 
o|contracted procedure: k1366 
o|contracted procedure: k2580 
o|removed binding forms: 2 
o|customizable procedures: (check420 k2562 loop338 k2420 ##net#io-ports k1656 k2254 loop494 k2116 k2122 read-input450 k1976 k1930 k1933 k1939 output532 k1770 loop535 k1664 ##net#gethostaddr) 
o|calls to known targets: 84 
o|identified direct recursive calls: f_1774 2 
o|identified direct recursive calls: f_2184 1 
o|identified direct recursive calls: f_1274 1 
o|fast box initializations: 6 
o|fast global references: 5 
o|fast global assignments: 2 
o|dropping unused closure argument: f_1240 
o|dropping unused closure argument: f_1611 
*/
/* end of file */
