/* Generated from posixwin.scm by the Chicken compiler
   2006-02-17 19:42
   Version 2, Build 3 - linux-unix-gnu-x86 - [ libffi dload ptables ]
   command line: posixwin.scm -quiet -no-trace -no-lambda-info -optimize-level 2 -unsafe -feature unsafe -include-path . -output-file uposixwin.c -explicit-use
   unit: posix
*/

#include "chicken.h"

#ifndef WIN32_LEAN_AND_MEAN
# define WIN32_LEAN_AND_MEAN
#endif
#include <windows.h>

#if _MSC_VER > 1300
#include <winsock2.h>
#include <ws2tcpip.h>
#else
#include <winsock.h>
#endif

#include <errno.h>
#include <io.h>
#include <stdio.h>
#include <process.h>

static int C_not_implemented(void);
int C_not_implemented() { return -1; }

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <direct.h>

#include <time.h>

#define ARG_MAX 256
#define PIPE_BUF 512

static C_TLS char *C_exec_args[ ARG_MAX ];
static C_TLS struct group *C_group;
static C_TLS int C_pipefds[ 2 ];
static C_TLS time_t C_secs;
static C_TLS struct tm C_tm;
static C_TLS struct stat C_statbuf;
/* pipe handles */
static C_TLS HANDLE C_rd0, C_wr0, C_wr0_, C_rd1, C_wr1, C_rd1_;
static C_TLS HANDLE C_save0, C_save1; /* saved I/O handles */
static C_TLS char C_rdbuf; /* one-char buffer for read */
static C_TLS int C_exstatus;

static C_TLS char C_hostname[256];
static C_TLS char C_osver[16];
static C_TLS char C_osrel[16];
static C_TLS char C_processor[16];

#define C_mkdir(str)        C_fix(mkdir(C_c_string(str)))
#define C_chdir(str)        C_fix(chdir(C_c_string(str)))
#define C_rmdir(str)        C_fix(rmdir(C_c_string(str)))

#ifndef __WATCOMC__
/* DIRENT stuff */
struct dirent
{
    char *		d_name;
};

typedef struct
{
    struct _finddata_t	fdata;
    int			handle;
    struct dirent	current;
} DIR;

static DIR *opendir(const char *name);
static int closedir(DIR *dir);
static struct dirent *readdir(DIR *dir);

static DIR *opendir(const char *name)
{
    int name_len = strlen(name);
    DIR *dir = (DIR *)malloc(sizeof(DIR));
    char *what;
    if (!dir)
    {
	errno = ENOMEM;
	return NULL;
    }
    what = (char *)malloc(name_len + 3);
    if (!what)
    {
	free(dir);
	errno = ENOMEM;
	return NULL;
    }
    strcpy(what, name);
    if (strchr("\\/", name[name_len - 1]))
	strcat(what, "*");
    else
	strcat(what, "\\*");

    dir->handle = _findfirst(what, &dir->fdata);
    if (dir->handle == -1)
    {
	free(what);
	free(dir);
	return NULL;
    }
    dir->current.d_name = NULL; /* as the first-time indicator */
    free(what);
    return dir;
}
static int closedir(DIR * dir)
{
    if (dir)
    {
	int res = _findclose(dir->handle);
	free(dir);
	return res;
    }
    return -1;
}
static struct dirent *readdir(DIR * dir)
{
    if (dir)
    {
	if (!dir->current.d_name /* first time after opendir */
	     || _findnext(dir->handle, &dir->fdata) != -1)
	{
	    dir->current.d_name = dir->fdata.name;
	    return &dir->current;
	}
    }
    return NULL;
}
#endif /* ifndef __WATCOMC__ */

#ifdef __WATCOMC__
# define mktemp _mktemp
/* there is no P_DETACH in Watcom CRTL */
# define P_DETACH P_NOWAIT
#endif

#define C_opendir(x,h)		C_set_block_item(h, 0, (C_word) opendir(C_c_string(x)))
#define C_closedir(h)   	(closedir((DIR *)C_block_item(h, 0)), C_SCHEME_UNDEFINED)
#define C_readdir(h,e)		C_set_block_item(e, 0, (C_word) readdir((DIR *)C_block_item(h, 0)))
#define C_foundfile(e,b)	(strcpy(C_c_string(b), ((struct dirent *) C_block_item(e, 0))->d_name),	C_fix(strlen(((struct dirent *) C_block_item(e, 0))->d_name)))

#define C_curdir(buf)       (getcwd(C_c_string(buf), 256) ? C_fix(strlen(C_c_string(buf))) : C_SCHEME_FALSE)

#define open_binary_input_pipe(a, n, name)   C_mpointer(a, _popen(C_c_string(name), "r"))
#define open_text_input_pipe(a, n, name)     open_binary_input_pipe(a, n, name)
#define open_binary_output_pipe(a, n, name)  C_mpointer(a, _popen(C_c_string(name), "w"))
#define open_text_output_pipe(a, n, name)    open_binary_output_pipe(a, n, name)
#define close_pipe(p)                        C_fix(_pclose(C_port_file(p)))

#define C_set_file_ptr(port, ptr)  (C_set_block_item(port, 0, (C_block_item(ptr, 0))), C_SCHEME_UNDEFINED)

#define C_getpid            getpid
#define C_chmod(fn, m)      C_fix(chmod(C_data_pointer(fn), C_unfix(m)))
#define C_fdopen(a, n, fd, m) C_mpointer(a, fdopen(C_unfix(fd), C_c_string(m)))
#define C_C_fileno(p)       C_fix(fileno(C_port_file(p)))
#define C_dup(x)            C_fix(dup(C_unfix(x)))
#define C_dup2(x, y)        C_fix(dup2(C_unfix(x), C_unfix(y)))
#define C_setvbuf(p, m, s)  C_fix(setvbuf(C_port_file(p), NULL, C_unfix(m), C_unfix(s)))
#define C_access(fn, m)     C_fix(access((char *)C_data_pointer(fn), C_unfix(m)))
#define C_pipe(d)           C_fix(_pipe(C_pipefds, PIPE_BUF, O_BINARY))
#define C_close(fd)         C_fix(close(C_unfix(fd)))

#define C_getenventry(i)   environ[ i ]

#define C_putenv(s)         C_fix(putenv((char *)C_data_pointer(s)))
#define C_stat(fn)          C_fix(stat((char *)C_data_pointer(fn), &C_statbuf))
#define C_fstat(f)          C_fix(fstat(C_unfix(f), &C_statbuf))

static C_word C_fcall C_setenv(C_word x, C_word y);
C_word C_fcall C_setenv(C_word x, C_word y) {
  char *sx = C_data_pointer(x),
       *sy = C_data_pointer(y);
  int n1 = C_strlen(sx), n2 = C_strlen(sy);				       
  char *buf = (char *)C_malloc(n1 + n2 + 2);
  if(buf == NULL) return(C_fix(0));
  else {
    C_strcpy(buf, sx);
    buf[ n1 ] = '=';
    C_strcpy(buf + n1 + 1, sy);
    return(C_fix(putenv(buf)));
  }
}

static void C_fcall C_set_exec_arg(int i, char *a, int len);
void C_fcall C_set_exec_arg(int i, char *a, int len) {
  char *ptr;
  if(a != NULL) {
    ptr = (char *)C_malloc(len + 1);
    C_memcpy(ptr, a, len);
    ptr[ len ] = '\0';
  }
  else ptr = NULL;
  C_exec_args[ i ] = ptr;
}

static void C_fcall C_free_exec_args();
void C_fcall C_free_exec_args() {
  char **a = C_exec_args;
  while((*a) != NULL) C_free(*(a++));
}

#define C_execvp(f)         C_fix(execvp(C_data_pointer(f), C_exec_args))

/* MS replacement for the fork-exec pair */
#define C_spawnvp(m, f)	    C_fix(spawnvp(C_unfix(m), C_data_pointer(f), C_exec_args))

#define C_open(fn, fl, m)   C_fix(open(C_c_string(fn), C_unfix(fl), C_unfix(m)))
#define C_read(fd, b, n)    C_fix(read(C_unfix(fd), C_data_pointer(b), C_unfix(n)))
#define C_write(fd, b, n)   C_fix(write(C_unfix(fd), C_data_pointer(b), C_unfix(n)))
#define C_mkstemp(t)        C_fix(mktemp(C_c_string(t)))

#define C_ftell(p)            C_fix(ftell(C_port_file(p)))
#define C_fseek(p, n, w)      C_mk_nbool(fseek(C_port_file(p), C_unfix(n), C_unfix(w)))
#define C_lseek(fd, o, w)     C_fix(lseek(C_unfix(fd), C_unfix(o), C_unfix(w)))

#define C_ctime(n)          (C_secs = (n), ctime(&C_secs))

#define C_asctime(v)        (memset(&C_tm, 0, sizeof(struct tm)), C_tm.tm_sec = C_unfix(C_block_item(v, 0)), C_tm.tm_min = C_unfix(C_block_item(v, 1)), C_tm.tm_hour = C_unfix(C_block_item(v, 2)), C_tm.tm_mday = C_unfix(C_block_item(v, 3)), C_tm.tm_mon = C_unfix(C_block_item(v, 4)), C_tm.tm_year = C_unfix(C_block_item(v, 5)), C_tm.tm_wday = C_unfix(C_block_item(v, 6)), C_tm.tm_yday = C_unfix(C_block_item(v, 7)), C_tm.tm_isdst = (C_block_item(v, 8) != C_SCHEME_FALSE), asctime(&C_tm) )
#define C_mktime(v)        (memset(&C_tm, 0, sizeof(struct tm)), C_tm.tm_sec = C_unfix(C_block_item(v, 0)), C_tm.tm_min = C_unfix(C_block_item(v, 1)), C_tm.tm_hour = C_unfix(C_block_item(v, 2)), C_tm.tm_mday = C_unfix(C_block_item(v, 3)), C_tm.tm_mon = C_unfix(C_block_item(v, 4)), C_tm.tm_year = C_unfix(C_block_item(v, 5)), C_tm.tm_wday = C_unfix(C_block_item(v, 6)), C_tm.tm_yday = C_unfix(C_block_item(v, 7)), C_tm.tm_isdst = (C_block_item(v, 8) != C_SCHEME_FALSE), (C_temporary_flonum = mktime(&C_tm)) != -1)

/* mapping from Win32 error codes to errno */
typedef struct
{
    DWORD   win32;
    int	    libc;
} errmap_t;
static errmap_t errmap[] =
{
    {ERROR_INVALID_FUNCTION,      EINVAL},
    {ERROR_FILE_NOT_FOUND,        ENOENT},
    {ERROR_PATH_NOT_FOUND,        ENOENT},
    {ERROR_TOO_MANY_OPEN_FILES,   EMFILE},
    {ERROR_ACCESS_DENIED,         EACCES},
    {ERROR_INVALID_HANDLE,        EBADF},
    {ERROR_ARENA_TRASHED,         ENOMEM},
    {ERROR_NOT_ENOUGH_MEMORY,     ENOMEM},
    {ERROR_INVALID_BLOCK,         ENOMEM},
    {ERROR_BAD_ENVIRONMENT,       E2BIG},
    {ERROR_BAD_FORMAT,            ENOEXEC},
    {ERROR_INVALID_ACCESS,        EINVAL},
    {ERROR_INVALID_DATA,          EINVAL},
    {ERROR_INVALID_DRIVE,         ENOENT},
    {ERROR_CURRENT_DIRECTORY,     EACCES},
    {ERROR_NOT_SAME_DEVICE,       EXDEV},
    {ERROR_NO_MORE_FILES,         ENOENT},
    {ERROR_LOCK_VIOLATION,        EACCES},
    {ERROR_BAD_NETPATH,           ENOENT},
    {ERROR_NETWORK_ACCESS_DENIED, EACCES},
    {ERROR_BAD_NET_NAME,          ENOENT},
    {ERROR_FILE_EXISTS,           EEXIST},
    {ERROR_CANNOT_MAKE,           EACCES},
    {ERROR_FAIL_I24,              EACCES},
    {ERROR_INVALID_PARAMETER,     EINVAL},
    {ERROR_NO_PROC_SLOTS,         EAGAIN},
    {ERROR_DRIVE_LOCKED,          EACCES},
    {ERROR_BROKEN_PIPE,           EPIPE},
    {ERROR_DISK_FULL,             ENOSPC},
    {ERROR_INVALID_TARGET_HANDLE, EBADF},
    {ERROR_INVALID_HANDLE,        EINVAL},
    {ERROR_WAIT_NO_CHILDREN,      ECHILD},
    {ERROR_CHILD_NOT_COMPLETE,    ECHILD},
    {ERROR_DIRECT_ACCESS_HANDLE,  EBADF},
    {ERROR_NEGATIVE_SEEK,         EINVAL},
    {ERROR_SEEK_ON_DEVICE,        EACCES},
    {ERROR_DIR_NOT_EMPTY,         ENOTEMPTY},
    {ERROR_NOT_LOCKED,            EACCES},
    {ERROR_BAD_PATHNAME,          ENOENT},
    {ERROR_MAX_THRDS_REACHED,     EAGAIN},
    {ERROR_LOCK_FAILED,           EACCES},
    {ERROR_ALREADY_EXISTS,        EEXIST},
    {ERROR_FILENAME_EXCED_RANGE,  ENOENT},
    {ERROR_NESTING_NOT_ALLOWED,   EAGAIN},
    {ERROR_NOT_ENOUGH_QUOTA,      ENOMEM},
    {0, 0}
};

static void set_errno(DWORD w32err)
{
    errmap_t *map = errmap;
    for (; errmap->win32; ++map)
    {
	if (errmap->win32 == w32err)
	{
	    errno = errmap->libc;
	    return;
	}
    }
}

/* functions for creating process with redirected I/O */
static int zero_handles()
{
    C_rd0 = C_wr0 = C_wr0_ = INVALID_HANDLE_VALUE;
    C_rd1 = C_wr1 = C_rd1_ = INVALID_HANDLE_VALUE;
    C_save0 = C_save1 = INVALID_HANDLE_VALUE;
    return 1;
}
static int close_handles()
{
    if (C_rd0 != INVALID_HANDLE_VALUE)
	CloseHandle(C_rd0);
    if (C_rd1 != INVALID_HANDLE_VALUE)
	CloseHandle(C_rd1);
    if (C_wr0 != INVALID_HANDLE_VALUE)
	CloseHandle(C_wr0);
    if (C_wr1 != INVALID_HANDLE_VALUE)
	CloseHandle(C_wr1);
    if (C_rd1_ != INVALID_HANDLE_VALUE)
	CloseHandle(C_rd1_);
    if (C_wr0_ != INVALID_HANDLE_VALUE)
	CloseHandle(C_wr0_);
    if (C_save0 != INVALID_HANDLE_VALUE)
    {
	SetStdHandle(STD_INPUT_HANDLE, C_save0);
	CloseHandle(C_save0);
    }
    if (C_save1 != INVALID_HANDLE_VALUE)
    {
	SetStdHandle(STD_OUTPUT_HANDLE, C_save1);
	CloseHandle(C_save1);
    }
    return zero_handles();
}
static int redir_io()
{
    SECURITY_ATTRIBUTES sa;
    sa.nLength = sizeof(SECURITY_ATTRIBUTES);
    sa.bInheritHandle = TRUE;
    sa.lpSecurityDescriptor = NULL;

    zero_handles();

    C_save0 = GetStdHandle(STD_INPUT_HANDLE);
    C_save1 = GetStdHandle(STD_OUTPUT_HANDLE);
    if (!CreatePipe(&C_rd0, &C_wr0, &sa, 0)
	    || !SetStdHandle(STD_INPUT_HANDLE, C_rd0)
	    || !DuplicateHandle(GetCurrentProcess(), C_wr0, GetCurrentProcess(),
		&C_wr0_, 0, FALSE, DUPLICATE_SAME_ACCESS)
	    || !CreatePipe(&C_rd1, &C_wr1, &sa, 0)
	    || !SetStdHandle(STD_OUTPUT_HANDLE, C_wr1)
	    || !DuplicateHandle(GetCurrentProcess(), C_rd1, GetCurrentProcess(),
		&C_rd1_, 0, FALSE, DUPLICATE_SAME_ACCESS))
    {
	set_errno(GetLastError());
	close_handles();
	return 0;
    }

    CloseHandle(C_wr0);
    C_wr0 = INVALID_HANDLE_VALUE;
    CloseHandle(C_rd1);
    C_rd1 = INVALID_HANDLE_VALUE;
    return 1;
}
static int run_process(char *cmdline)
{
    PROCESS_INFORMATION pi;
    STARTUPINFO si;

    ZeroMemory(&pi, sizeof(PROCESS_INFORMATION));
    ZeroMemory(&si, sizeof(STARTUPINFO));
    si.cb = sizeof(STARTUPINFO);

    C_wr0_ = C_rd1_ = INVALID_HANDLE_VALUE; /* these handles are saved */

    if (CreateProcess(NULL, cmdline, NULL, NULL, TRUE, 0, NULL,
		NULL, &si, &pi))
    {
	CloseHandle(pi.hThread);

	SetStdHandle(STD_INPUT_HANDLE, C_save0);
	SetStdHandle(STD_OUTPUT_HANDLE, C_save1);
	C_save0 = C_save1 = INVALID_HANDLE_VALUE;

	CloseHandle(C_rd0);
	CloseHandle(C_wr1);
	C_rd0 = C_wr1 = INVALID_HANDLE_VALUE;
	return (int)pi.hProcess;
    }
    else
    {
	set_errno(GetLastError());
	return 0;
    }
}
static int pipe_write(int hpipe, void* buf, int count)
{
    DWORD done = 0;
    if (WriteFile((HANDLE)hpipe, buf, count, &done, NULL))
	return 1;
    else
    {
	set_errno(GetLastError());
	return 0;
    }
}
static int pipe_read(int hpipe)
{
    DWORD done = 0;
    /* TODO:
    if (!pipe_ready(hpipe))
	go_to_sleep;
    */
    if (ReadFile((HANDLE)hpipe, &C_rdbuf, 1, &done, NULL))
    {
	if (done > 0) /* not EOF yet */
	    return 1;
	else
	    return -1;
    }
    set_errno(GetLastError());
    return 0;
}
static int pipe_ready(int hpipe)
{
    DWORD avail = 0;
    if (PeekNamedPipe((HANDLE)hpipe, NULL, 0, NULL, &avail, NULL) && avail)
	return 1;
    else 
    {
	Sleep(0); /* give pipe a chance */
	if (PeekNamedPipe((HANDLE)hpipe, NULL, 0, NULL, &avail, NULL))
	    return (avail > 0);
	else
	    return 0;
    }
}

#define C_zero_handles() C_fix(zero_handles())
#define C_close_handles() C_fix(close_handles())
#define C_redir_io() (redir_io() ? C_SCHEME_TRUE : C_SCHEME_FALSE)
#define C_run_process(cmdline) C_fix(run_process(C_c_string(cmdline)))
#define C_pipe_write(h, b, n) (pipe_write(C_unfix(h), C_c_string(b), C_unfix(n)) ? C_SCHEME_TRUE : C_SCHEME_FALSE)
#define C_pipe_read(h) C_fix(pipe_read(C_unfix(h)))
#define C_pipe_ready(h) (pipe_ready(C_unfix(h)) ? C_SCHEME_TRUE : C_SCHEME_FALSE)
#define close_handle(h) CloseHandle((HANDLE)h)

int process_wait(int h, int t)
{   
    if (WaitForSingleObject((HANDLE)h, (t ? 0 : INFINITE)) == WAIT_OBJECT_0)
    {
	DWORD ret;
	if (GetExitCodeProcess((HANDLE)h, &ret))
	{
	    CloseHandle((HANDLE)h);
	    C_exstatus = ret;
	    return 1;
	}
    }
    set_errno(GetLastError());
    return 0;
}

#define C_process_wait(p, t) (process_wait(C_unfix(p), C_truep(t)) ? C_SCHEME_TRUE : C_SCHEME_FALSE)
#define C_sleep(t) (Sleep(C_unfix(t) * 1000), C_SCHEME_UNDEFINED)

int get_hostname()
{
    WSADATA wsa;
    if (WSAStartup(MAKEWORD(1, 1), &wsa) == 0)
    {
	int nok = gethostname(C_hostname, 256);
	WSACleanup();
	return !nok;
    }
    return 0;
}

int sysinfo()
{
    OSVERSIONINFO ovf;
    ZeroMemory(&ovf, sizeof(ovf));
    ovf.dwOSVersionInfoSize = sizeof(ovf);
    if (get_hostname() && GetVersionEx(&ovf))
    {
	SYSTEM_INFO si;
	_snprintf(C_osver, sizeof(C_osver) - 1, "%d.%d.%d", 
			   ovf.dwMajorVersion, ovf.dwMinorVersion, ovf.dwBuildNumber);
	switch (ovf.dwPlatformId)
	{
	case VER_PLATFORM_WIN32s:
	    strncpy(C_osrel, "Win32s", sizeof(C_osrel) - 1);
	    break;
	case VER_PLATFORM_WIN32_WINDOWS:
	    strncpy(C_osrel, "Win9x", sizeof(C_osrel) - 1);
	    break;
	case VER_PLATFORM_WIN32_NT:
	default:
	    strncpy(C_osrel, "WinNT", sizeof(C_osrel) - 1);
	    break;
	}
	GetSystemInfo(&si);
	switch (si.wProcessorArchitecture)
	{
    	case PROCESSOR_ARCHITECTURE_INTEL:
	    strncpy(C_processor, "Intel", sizeof(C_processor) - 1);
	    break;
    	case PROCESSOR_ARCHITECTURE_UNKNOWN:
	default:
	    strncpy(C_processor, "Unknown", sizeof(C_processor) - 1);
	    break;
	}
	return 1;
    }
    set_errno(GetLastError());
    return 0;
}

#define C_get_hostname() (get_hostname() ? C_SCHEME_TRUE : C_SCHEME_FALSE)
#define C_sysinfo() (sysinfo() ? C_SCHEME_TRUE : C_SCHEME_FALSE)


static C_PTABLE_ENTRY *create_ptable(void);
C_noret_decl(C_scheduler_toplevel)
C_externimport void C_ccall C_scheduler_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_regex_toplevel)
C_externimport void C_ccall C_regex_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_extras_toplevel)
C_externimport void C_ccall C_extras_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_utils_toplevel)
C_externimport void C_ccall C_utils_toplevel(C_word c,C_word d,C_word k) C_noret;

static C_TLS C_word lf[247];


/* from close-handle in k673 in k670 in k667 in k664 in k661 */
static C_word C_fcall stub425(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub425(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_truep(C_a0);
C_r=C_fix((C_word)close_handle(t0));
return C_r;}

/* from get-shell in k673 in k670 in k667 in k664 in k661 */
#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_return; C_cblockend
static C_word C_fcall stub416(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub416(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
    char *ret = getenv("COMSPEC");
    if (ret)
	return (ret);
    else
    {
	OSVERSIONINFO ovf;
	ovf.dwOSVersionInfoSize = sizeof(ovf);
	if (GetVersionEx(&ovf) && (ovf.dwPlatformId == VER_PLATFORM_WIN32_NT))
	    return ("cmd.exe");
	else
	    return ("command.com");
    }
C_return:
#undef return

return C_r;}

/* from current-process-id in k673 in k670 in k667 in k664 in k661 */
static C_word C_fcall stub414(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub414(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getpid());
return C_r;}

/* from freeargs */
static C_word C_fcall stub394(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub394(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_free_exec_args();
return C_r;}

/* from k2356 */
static C_word C_fcall stub387(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub387(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
void * t1=(void * )C_data_pointer_or_null(C_a1);
int t2=(int )C_unfix(C_a2);
C_set_exec_arg(t0,t1,t2);
return C_r;}

/* from freeargs */
static C_word C_fcall stub345(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub345(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_free_exec_args();
return C_r;}

/* from k2216 */
static C_word C_fcall stub338(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub338(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
void * t1=(void * )C_data_pointer_or_null(C_a1);
int t2=(int )C_unfix(C_a2);
C_set_exec_arg(t0,t1,t2);
return C_r;}

/* from ex0 */
static C_word C_fcall stub291(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub291(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
_exit(t0);
return C_r;}

/* from asctime */
static C_word C_fcall stub277(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub277(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
C_r=C_mpointer(&C_a,(void*)C_asctime(t0));
return C_r;}

/* from ctime */
static C_word C_fcall stub268(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub268(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_num_to_int(C_a0);
C_r=C_mpointer(&C_a,(void*)C_ctime(t0));
return C_r;}

/* from get */
static C_word C_fcall stub253(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub253(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)C_getenventry(t0));
return C_r;}

C_noret_decl(C_posix_toplevel)
C_externexport void C_ccall C_posix_toplevel(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_663)
static void C_ccall f_663(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_666)
static void C_ccall f_666(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_669)
static void C_ccall f_669(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_672)
static void C_ccall f_672(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_675)
static void C_ccall f_675(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2716)
static void C_ccall f_2716(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_2716)
static void C_ccall f_2716r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_2864)
static void C_fcall f_2864(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2870)
static void C_ccall f_2870(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2859)
static void C_fcall f_2859(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2854)
static void C_fcall f_2854(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2718)
static void C_fcall f_2718(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_2841)
static void C_ccall f_2841(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2849)
static void C_ccall f_2849(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2722)
static void C_fcall f_2722(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2829)
static void C_ccall f_2829(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2732)
static void C_ccall f_2732(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2734)
static void C_fcall f_2734(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2753)
static void C_ccall f_2753(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2815)
static void C_ccall f_2815(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2822)
static void C_ccall f_2822(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2809)
static void C_ccall f_2809(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2768)
static void C_ccall f_2768(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2799)
static void C_ccall f_2799(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2785)
static void C_ccall f_2785(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2797)
static void C_ccall f_2797(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2793)
static void C_ccall f_2793(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2780)
static void C_ccall f_2780(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2778)
static void C_ccall f_2778(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2833)
static void C_ccall f_2833(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2685)
static void C_ccall f_2685(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2711)
static void C_ccall f_2711(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2696)
static void C_ccall f_2696(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2700)
static void C_ccall f_2700(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2704)
static void C_ccall f_2704(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2708)
static void C_ccall f_2708(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2673)
static void C_ccall f_2673(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2670)
static void C_ccall f_2670(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2631)
static void C_ccall f_2631(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_2631)
static void C_ccall f_2631r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_2650)
static void C_ccall f_2650(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2483)
static void C_ccall f_2483(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_2483)
static void C_ccall f_2483r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_2586)
static void C_fcall f_2586(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2581)
static void C_fcall f_2581(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2485)
static void C_fcall f_2485(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2577)
static void C_ccall f_2577(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2492)
static void C_ccall f_2492(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2564)
static void C_ccall f_2564(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2567)
static void C_ccall f_2567(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2570)
static void C_ccall f_2570(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2557)
static void C_ccall f_2557(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2554)
static void C_ccall f_2554(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2530)
static void C_ccall f_2530(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2505)
static void C_ccall f_2505(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2524)
static void C_ccall f_2524(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2511)
static void C_ccall f_2511(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2509)
static void C_ccall f_2509(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2480)
static C_word C_fcall f_2480(C_word t0);
C_noret_decl(f_2451)
static void C_ccall f_2451(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_2451)
static void C_ccall f_2451r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_2468)
static void C_ccall f_2468(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2445)
static void C_ccall f_2445(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2442)
static void C_ccall f_2442(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2361)
static void C_ccall f_2361(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_2361)
static void C_ccall f_2361r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_2368)
static void C_ccall f_2368(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2376)
static void C_fcall f_2376(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2409)
static void C_ccall f_2409(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2390)
static void C_ccall f_2390(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2393)
static void C_ccall f_2393(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2396)
static void C_ccall f_2396(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2353)
static C_word C_fcall f_2353(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_2221)
static void C_ccall f_2221(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_2221)
static void C_ccall f_2221r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_2308)
static void C_fcall f_2308(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2303)
static void C_fcall f_2303(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2223)
static void C_fcall f_2223(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2230)
static void C_ccall f_2230(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2238)
static void C_fcall f_2238(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2271)
static void C_ccall f_2271(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2252)
static void C_ccall f_2252(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2255)
static void C_ccall f_2255(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2213)
static C_word C_fcall f_2213(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_2104)
static void C_ccall f_2104(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2104)
static void C_ccall f_2104r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_2110)
static void C_fcall f_2110(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2131)
static void C_ccall f_2131(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_2202)
static void C_ccall f_2202(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2135)
static void C_ccall f_2135(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2142)
static void C_ccall f_2142(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2144)
static void C_fcall f_2144(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2161)
static void C_ccall f_2161(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2171)
static void C_ccall f_2171(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2175)
static void C_ccall f_2175(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2125)
static void C_ccall f_2125(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2051)
static void C_ccall f_2051(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_2051)
static void C_ccall f_2051r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_2058)
static void C_ccall f_2058(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2032)
static void C_ccall f_2032(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2032)
static void C_ccall f_2032r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_2036)
static void C_ccall f_2036(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2002)
static void C_ccall f_2002(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2009)
static void C_ccall f_2009(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1974)
static void C_ccall f_1974(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1981)
static void C_ccall f_1981(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1984)
static void C_ccall f_1984(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1987)
static void C_ccall f_1987(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1957)
static void C_ccall f_1957(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1961)
static void C_ccall f_1961(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1964)
static void C_ccall f_1964(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1946)
static void C_ccall f_1946(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1940)
static void C_ccall f_1940(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1875)
static void C_ccall f_1875(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1881)
static void C_fcall f_1881(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1885)
static void C_ccall f_1885(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1893)
static void C_fcall f_1893(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1919)
static void C_ccall f_1919(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1923)
static void C_ccall f_1923(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1911)
static void C_ccall f_1911(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1863)
static void C_ccall f_1863(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1868)
static void C_ccall f_1868(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1852)
static void C_ccall f_1852(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_1857)
static void C_ccall f_1857(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1861)
static void C_ccall f_1861(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1828)
static void C_ccall f_1828(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_1828)
static void C_ccall f_1828r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_1832)
static void C_fcall f_1832(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1841)
static void C_ccall f_1841(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1835)
static void C_ccall f_1835(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1796)
static void C_ccall f_1796(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1826)
static void C_ccall f_1826(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1812)
static void C_ccall f_1812(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1806)
static void C_ccall f_1806(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1785)
static void C_ccall f_1785(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_1785)
static void C_ccall f_1785r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_1794)
static void C_ccall f_1794(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1774)
static void C_ccall f_1774(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_1774)
static void C_ccall f_1774r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_1783)
static void C_ccall f_1783(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1756)
static void C_fcall f_1756(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_1760)
static void C_ccall f_1760(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1772)
static void C_ccall f_1772(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1719)
static void C_fcall f_1719(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1727)
static void C_ccall f_1727(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1710)
static void C_ccall f_1710(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1704)
static void C_ccall f_1704(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1698)
static void C_ccall f_1698(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1677)
static void C_fcall f_1677(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1696)
static void C_ccall f_1696(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1692)
static void C_ccall f_1692(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1684)
static void C_ccall f_1684(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1653)
static void C_ccall f_1653(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_1675)
static void C_ccall f_1675(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1671)
static void C_ccall f_1671(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1663)
static void C_ccall f_1663(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1597)
static void C_ccall f_1597(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1610)
static void C_ccall f_1610(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1601)
static void C_ccall f_1601(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1577)
static void C_ccall f_1577(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_1577)
static void C_ccall f_1577r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_1581)
static void C_ccall f_1581(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1587)
static void C_ccall f_1587(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_1587)
static void C_ccall f_1587r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_1591)
static void C_ccall f_1591(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1557)
static void C_ccall f_1557(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_1557)
static void C_ccall f_1557r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_1561)
static void C_ccall f_1561(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1567)
static void C_ccall f_1567(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_1567)
static void C_ccall f_1567r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_1571)
static void C_ccall f_1571(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1533)
static void C_ccall f_1533(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_1533)
static void C_ccall f_1533r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_1537)
static void C_ccall f_1537(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1548)
static void C_ccall f_1548(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_1548)
static void C_ccall f_1548r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_1552)
static void C_ccall f_1552(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1542)
static void C_ccall f_1542(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1509)
static void C_ccall f_1509(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_1509)
static void C_ccall f_1509r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_1513)
static void C_ccall f_1513(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1524)
static void C_ccall f_1524(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_1524)
static void C_ccall f_1524r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_1528)
static void C_ccall f_1528(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1518)
static void C_ccall f_1518(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1493)
static void C_ccall f_1493(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1497)
static void C_ccall f_1497(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1460)
static void C_ccall f_1460(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_1460)
static void C_ccall f_1460r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_1488)
static void C_ccall f_1488(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1478)
static void C_ccall f_1478(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1471)
static void C_ccall f_1471(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1427)
static void C_ccall f_1427(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_1427)
static void C_ccall f_1427r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_1455)
static void C_ccall f_1455(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1445)
static void C_ccall f_1445(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1438)
static void C_ccall f_1438(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1409)
static void C_fcall f_1409(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_1413)
static void C_ccall f_1413(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1425)
static void C_ccall f_1425(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1403)
static void C_fcall f_1403(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1391)
static C_word C_fcall f_1391(C_word t0);
C_noret_decl(f_1348)
static void C_ccall f_1348(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_1348)
static void C_ccall f_1348r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_1352)
static void C_fcall f_1352(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1361)
static void C_ccall f_1361(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1364)
static void C_ccall f_1364(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1328)
static void C_ccall f_1328(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1346)
static void C_ccall f_1346(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1332)
static void C_ccall f_1332(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1174)
static void C_ccall f_1174(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_1174)
static void C_ccall f_1174r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_1279)
static void C_fcall f_1279(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1287)
static void C_ccall f_1287(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1274)
static void C_fcall f_1274(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1176)
static void C_fcall f_1176(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_1180)
static void C_ccall f_1180(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1183)
static void C_ccall f_1183(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1186)
static void C_ccall f_1186(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1273)
static void C_ccall f_1273(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1190)
static void C_ccall f_1190(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1207)
static void C_fcall f_1207(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1217)
static void C_ccall f_1217(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1229)
static void C_fcall f_1229(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1239)
static void C_ccall f_1239(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1199)
static void C_ccall f_1199(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1150)
static void C_ccall f_1150(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1172)
static void C_ccall f_1172(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1168)
static void C_ccall f_1168(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1160)
static void C_ccall f_1160(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1126)
static void C_ccall f_1126(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1148)
static void C_ccall f_1148(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1144)
static void C_ccall f_1144(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1136)
static void C_ccall f_1136(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1102)
static void C_ccall f_1102(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1124)
static void C_ccall f_1124(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1120)
static void C_ccall f_1120(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1112)
static void C_ccall f_1112(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1047)
static void C_ccall f_1047(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_1047)
static void C_ccall f_1047r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_1054)
static void C_ccall f_1054(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1069)
static void C_ccall f_1069(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1060)
static void C_ccall f_1060(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1063)
static void C_ccall f_1063(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1007)
static void C_ccall f_1007(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1026)
static void C_ccall f_1026(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1011)
static void C_ccall f_1011(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1020)
static void C_ccall f_1020(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1014)
static void C_ccall f_1014(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1004)
static void C_ccall f_1004(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_984)
static void C_ccall f_984(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1002)
static void C_ccall f_1002(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_988)
static void C_ccall f_988(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_978)
static void C_ccall f_978(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_982)
static void C_ccall f_982(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_972)
static void C_ccall f_972(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_976)
static void C_ccall f_976(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_966)
static void C_ccall f_966(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_970)
static void C_ccall f_970(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_960)
static void C_ccall f_960(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_964)
static void C_ccall f_964(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_954)
static void C_ccall f_954(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_958)
static void C_ccall f_958(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_948)
static void C_ccall f_948(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_952)
static void C_ccall f_952(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_920)
static void C_ccall f_920(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_920)
static void C_ccall f_920r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_924)
static void C_fcall f_924(C_word t0,C_word t1) C_noret;
C_noret_decl(f_927)
static void C_ccall f_927(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_882)
static void C_fcall f_882(C_word t0,C_word t1) C_noret;
C_noret_decl(f_915)
static void C_ccall f_915(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_911)
static void C_ccall f_911(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_886)
static void C_ccall f_886(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_895)
static void C_ccall f_895(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_847)
static void C_ccall f_847(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_851)
static void C_ccall f_851(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_854)
static void C_ccall f_854(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_874)
static void C_ccall f_874(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_857)
static void C_ccall f_857(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_864)
static void C_ccall f_864(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_811)
static void C_ccall f_811(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_811)
static void C_ccall f_811r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_815)
static void C_ccall f_815(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_827)
static void C_ccall f_827(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_821)
static void C_ccall f_821(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_772)
static void C_ccall f_772(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_772)
static void C_ccall f_772r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_776)
static void C_ccall f_776(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_779)
static void C_ccall f_779(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_791)
static void C_ccall f_791(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_782)
static void C_ccall f_782(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_757)
static void C_ccall f_757(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_767)
static void C_ccall f_767(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_725)
static void C_ccall f_725(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_725)
static void C_ccall f_725r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_749)
static void C_ccall f_749(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_733)
static void C_ccall f_733(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_742)
static void C_ccall f_742(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_736)
static void C_ccall f_736(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_677)
static void C_ccall f_677(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_683)
static void C_ccall f_683(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_692)
static void C_ccall f_692(C_word c,C_word t0,C_word t1) C_noret;

C_noret_decl(trf_2864)
static void C_fcall trf_2864(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2864(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2864(t0,t1);}

C_noret_decl(trf_2859)
static void C_fcall trf_2859(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2859(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_2859(t0,t1,t2);}

C_noret_decl(trf_2854)
static void C_fcall trf_2854(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2854(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_2854(t0,t1,t2,t3);}

C_noret_decl(trf_2718)
static void C_fcall trf_2718(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2718(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_2718(t0,t1,t2,t3,t4);}

C_noret_decl(trf_2722)
static void C_fcall trf_2722(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2722(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2722(t0,t1);}

C_noret_decl(trf_2734)
static void C_fcall trf_2734(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2734(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_2734(t0,t1,t2,t3);}

C_noret_decl(trf_2586)
static void C_fcall trf_2586(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2586(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2586(t0,t1);}

C_noret_decl(trf_2581)
static void C_fcall trf_2581(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2581(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2581(t0,t1);}

C_noret_decl(trf_2485)
static void C_fcall trf_2485(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2485(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2485(t0,t1);}

C_noret_decl(trf_2376)
static void C_fcall trf_2376(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2376(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_2376(t0,t1,t2,t3);}

C_noret_decl(trf_2308)
static void C_fcall trf_2308(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2308(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2308(t0,t1);}

C_noret_decl(trf_2303)
static void C_fcall trf_2303(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2303(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_2303(t0,t1,t2);}

C_noret_decl(trf_2223)
static void C_fcall trf_2223(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2223(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_2223(t0,t1,t2);}

C_noret_decl(trf_2238)
static void C_fcall trf_2238(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2238(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_2238(t0,t1,t2,t3);}

C_noret_decl(trf_2110)
static void C_fcall trf_2110(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2110(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_2110(t0,t1,t2);}

C_noret_decl(trf_2144)
static void C_fcall trf_2144(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2144(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_2144(t0,t1,t2);}

C_noret_decl(trf_1881)
static void C_fcall trf_1881(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1881(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_1881(t0,t1,t2);}

C_noret_decl(trf_1893)
static void C_fcall trf_1893(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1893(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_1893(t0,t1,t2);}

C_noret_decl(trf_1832)
static void C_fcall trf_1832(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1832(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1832(t0,t1);}

C_noret_decl(trf_1756)
static void C_fcall trf_1756(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1756(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_1756(t0,t1,t2,t3);}

C_noret_decl(trf_1719)
static void C_fcall trf_1719(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1719(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_1719(t0,t1,t2);}

C_noret_decl(trf_1677)
static void C_fcall trf_1677(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1677(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_1677(t0,t1,t2);}

C_noret_decl(trf_1409)
static void C_fcall trf_1409(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1409(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_1409(t0,t1,t2,t3);}

C_noret_decl(trf_1403)
static void C_fcall trf_1403(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1403(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1403(t0,t1);}

C_noret_decl(trf_1352)
static void C_fcall trf_1352(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1352(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1352(t0,t1);}

C_noret_decl(trf_1279)
static void C_fcall trf_1279(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1279(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1279(t0,t1);}

C_noret_decl(trf_1274)
static void C_fcall trf_1274(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1274(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_1274(t0,t1,t2);}

C_noret_decl(trf_1176)
static void C_fcall trf_1176(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1176(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_1176(t0,t1,t2,t3);}

C_noret_decl(trf_1207)
static void C_fcall trf_1207(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1207(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1207(t0,t1);}

C_noret_decl(trf_1229)
static void C_fcall trf_1229(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1229(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1229(t0,t1);}

C_noret_decl(trf_924)
static void C_fcall trf_924(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_924(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_924(t0,t1);}

C_noret_decl(trf_882)
static void C_fcall trf_882(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_882(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_882(t0,t1);}

C_noret_decl(tr5)
static void C_fcall tr5(C_proc5 k) C_regparm C_noret;
C_regparm static void C_fcall tr5(C_proc5 k){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
(k)(5,t0,t1,t2,t3,t4);}

C_noret_decl(tr3)
static void C_fcall tr3(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3(C_proc3 k){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
(k)(3,t0,t1,t2);}

C_noret_decl(tr4)
static void C_fcall tr4(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4(C_proc4 k){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
(k)(4,t0,t1,t2,t3);}

C_noret_decl(tr2)
static void C_fcall tr2(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2(C_proc2 k){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
(k)(2,t0,t1);}

C_noret_decl(tr2r)
static void C_fcall tr2r(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2r(C_proc2 k){
int n;
C_word *a,t2;
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
n=C_rest_count(0);
a=C_alloc(n*3);
t2=C_restore_rest(a,n);
(k)(t0,t1,t2);}

C_noret_decl(tr3r)
static void C_fcall tr3r(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3r(C_proc3 k){
int n;
C_word *a,t3;
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
n=C_rest_count(0);
a=C_alloc(n*3);
t3=C_restore_rest(a,n);
(k)(t0,t1,t2,t3);}

C_noret_decl(tr4r)
static void C_fcall tr4r(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4r(C_proc4 k){
int n;
C_word *a,t4;
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
n=C_rest_count(0);
a=C_alloc(n*3);
t4=C_restore_rest(a,n);
(k)(t0,t1,t2,t3,t4);}

C_noret_decl(tr2rv)
static void C_fcall tr2rv(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2rv(C_proc2 k){
int n;
C_word *a,t2;
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
n=C_rest_count(0);
a=C_alloc(n+1);
t2=C_restore_rest_vector(a,n);
(k)(t0,t1,t2);}

C_noret_decl(tr4rv)
static void C_fcall tr4rv(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4rv(C_proc4 k){
int n;
C_word *a,t4;
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
n=C_rest_count(0);
a=C_alloc(n+1);
t4=C_restore_rest_vector(a,n);
(k)(t0,t1,t2,t3,t4);}

C_noret_decl(tr3rv)
static void C_fcall tr3rv(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3rv(C_proc3 k){
int n;
C_word *a,t3;
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
n=C_rest_count(0);
a=C_alloc(n+1);
t3=C_restore_rest_vector(a,n);
(k)(t0,t1,t2,t3);}

/* toplevel */
static C_TLS int toplevel_initialized=0;
C_noret_decl(toplevel_trampoline)
static void C_fcall toplevel_trampoline(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall toplevel_trampoline(void *dummy){
C_posix_toplevel(2,C_SCHEME_UNDEFINED,C_restore);}

void C_ccall C_posix_toplevel(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(toplevel_initialized) C_kontinue(t1,C_SCHEME_UNDEFINED);
else C_toplevel_entry(C_text("posix_toplevel"));
C_check_nursery_minimum(3);
if(!C_demand(3)){
C_save(t1);
C_reclaim((void*)toplevel_trampoline,NULL);}
toplevel_initialized=1;
if(!C_demand_2(1638)){
C_save(t1);
C_rereclaim2(1638*sizeof(C_word), 1);
t1=C_restore;}
a=C_alloc(3);
C_initialize_lf(lf,247);
lf[1]=C_static_string(C_heaptop,27,"too many optional arguments");
lf[3]=C_h_intern(&lf[3],18,"\003syscurrent-thread");
lf[4]=C_h_intern(&lf[4],12,"\003sysschedule");
lf[5]=C_h_intern(&lf[5],8,"pipe/buf");
lf[6]=C_h_intern(&lf[6],11,"open/rdonly");
lf[7]=C_h_intern(&lf[7],11,"open/wronly");
lf[8]=C_h_intern(&lf[8],9,"open/rdwr");
lf[9]=C_h_intern(&lf[9],9,"open/read");
lf[10]=C_h_intern(&lf[10],10,"open/write");
lf[11]=C_h_intern(&lf[11],10,"open/creat");
lf[12]=C_h_intern(&lf[12],11,"open/append");
lf[13]=C_h_intern(&lf[13],9,"open/excl");
lf[14]=C_h_intern(&lf[14],10,"open/trunc");
lf[15]=C_h_intern(&lf[15],11,"open/binary");
lf[16]=C_h_intern(&lf[16],9,"open/text");
lf[17]=C_h_intern(&lf[17],10,"perm/irusr");
lf[18]=C_h_intern(&lf[18],10,"perm/iwusr");
lf[19]=C_h_intern(&lf[19],10,"perm/ixusr");
lf[20]=C_h_intern(&lf[20],10,"perm/irgrp");
lf[21]=C_h_intern(&lf[21],10,"perm/iwgrp");
lf[22]=C_h_intern(&lf[22],10,"perm/ixgrp");
lf[23]=C_h_intern(&lf[23],10,"perm/iroth");
lf[24]=C_h_intern(&lf[24],10,"perm/iwoth");
lf[25]=C_h_intern(&lf[25],10,"perm/ixoth");
lf[26]=C_h_intern(&lf[26],10,"perm/irwxu");
lf[27]=C_h_intern(&lf[27],10,"perm/irwxg");
lf[28]=C_h_intern(&lf[28],10,"perm/irwxo");
lf[29]=C_h_intern(&lf[29],9,"file-open");
lf[30]=C_h_intern(&lf[30],15,"\003syssignal-hook");
lf[31]=C_h_intern(&lf[31],11,"\000file-error");
lf[32]=C_static_string(C_heaptop,17,"can not open file");
lf[33]=C_h_intern(&lf[33],16,"\003sysupdate-errno");
lf[34]=C_h_intern(&lf[34],17,"\003sysmake-c-string");
lf[35]=C_h_intern(&lf[35],20,"\003sysexpand-home-path");
lf[36]=C_h_intern(&lf[36],10,"file-close");
lf[37]=C_static_string(C_heaptop,18,"can not close file");
lf[38]=C_h_intern(&lf[38],11,"make-string");
lf[39]=C_h_intern(&lf[39],9,"file-read");
lf[40]=C_static_string(C_heaptop,22,"can not read from file");
lf[41]=C_h_intern(&lf[41],11,"\000type-error");
lf[42]=C_static_string(C_heaptop,47,"bad argument type - not a string or byte-vector");
lf[43]=C_h_intern(&lf[43],10,"file-write");
lf[44]=C_static_string(C_heaptop,21,"can not write to file");
lf[45]=C_static_string(C_heaptop,47,"bad argument type - not a string or byte-vector");
lf[46]=C_h_intern(&lf[46],13,"string-length");
lf[47]=C_h_intern(&lf[47],12,"file-mkstemp");
lf[48]=C_h_intern(&lf[48],13,"\003syssubstring");
lf[49]=C_static_string(C_heaptop,29,"can not create temporary file");
lf[50]=C_h_intern(&lf[50],8,"seek/set");
lf[51]=C_h_intern(&lf[51],8,"seek/end");
lf[52]=C_h_intern(&lf[52],8,"seek/cur");
lf[54]=C_static_string(C_heaptop,19,"can not access file");
lf[55]=C_static_string(C_heaptop,42,"bad argument type - not a fixnum or string");
lf[56]=C_h_intern(&lf[56],9,"file-stat");
lf[57]=C_h_intern(&lf[57],9,"file-size");
lf[58]=C_h_intern(&lf[58],22,"file-modification-time");
lf[59]=C_h_intern(&lf[59],16,"file-access-time");
lf[60]=C_h_intern(&lf[60],16,"file-change-time");
lf[61]=C_h_intern(&lf[61],10,"file-owner");
lf[62]=C_h_intern(&lf[62],16,"file-permissions");
lf[63]=C_h_intern(&lf[63],13,"regular-file\077");
lf[64]=C_h_intern(&lf[64],13,"\003sysfile-info");
lf[65]=C_h_intern(&lf[65],14,"symbolic-link\077");
lf[66]=C_h_intern(&lf[66],13,"file-position");
lf[67]=C_static_string(C_heaptop,38,"can not retrieve file position of port");
lf[68]=C_h_intern(&lf[68],6,"stream");
lf[69]=C_static_string(C_heaptop,12,"invalid file");
lf[70]=C_h_intern(&lf[70],5,"port\077");
lf[71]=C_h_intern(&lf[71],18,"set-file-position!");
lf[72]=C_static_string(C_heaptop,25,"can not set file position");
lf[73]=C_static_string(C_heaptop,12,"invalid file");
lf[74]=C_h_intern(&lf[74],13,"\000bounds-error");
lf[75]=C_static_string(C_heaptop,30,"invalid negative port position");
lf[76]=C_h_intern(&lf[76],16,"create-directory");
lf[77]=C_static_string(C_heaptop,24,"can not create directory");
lf[78]=C_h_intern(&lf[78],16,"change-directory");
lf[79]=C_static_string(C_heaptop,32,"can not change current directory");
lf[80]=C_h_intern(&lf[80],16,"delete-directory");
lf[81]=C_static_string(C_heaptop,24,"can not delete directory");
lf[82]=C_h_intern(&lf[82],13,"string-append");
lf[83]=C_h_intern(&lf[83],6,"string");
lf[84]=C_h_intern(&lf[84],9,"directory");
lf[85]=C_static_string(C_heaptop,22,"can not open directory");
lf[86]=C_h_intern(&lf[86],16,"\003sysmake-pointer");
lf[87]=C_h_intern(&lf[87],17,"current-directory");
lf[88]=C_h_intern(&lf[88],10,"directory\077");
lf[89]=C_static_string(C_heaptop,34,"can not retrieve current directory");
lf[90]=C_h_intern(&lf[90],5,"\000text");
lf[91]=C_h_intern(&lf[91],9,"\003syserror");
lf[92]=C_static_string(C_heaptop,35,"illegal input/output mode specifier");
lf[93]=C_static_string(C_heaptop,17,"can not open pipe");
lf[94]=C_h_intern(&lf[94],13,"\003sysmake-port");
lf[95]=C_h_intern(&lf[95],21,"\003sysstream-port-class");
lf[96]=C_static_string(C_heaptop,6,"(pipe)");
lf[97]=C_h_intern(&lf[97],15,"open-input-pipe");
lf[98]=C_h_intern(&lf[98],7,"\000binary");
lf[99]=C_h_intern(&lf[99],16,"open-output-pipe");
lf[100]=C_h_intern(&lf[100],16,"close-input-pipe");
lf[101]=C_static_string(C_heaptop,24,"error while closing pipe");
lf[102]=C_h_intern(&lf[102],17,"close-output-pipe");
lf[103]=C_h_intern(&lf[103],20,"call-with-input-pipe");
lf[104]=C_h_intern(&lf[104],21,"call-with-output-pipe");
lf[105]=C_h_intern(&lf[105],20,"with-input-from-pipe");
lf[106]=C_h_intern(&lf[106],18,"\003sysstandard-input");
lf[107]=C_h_intern(&lf[107],19,"with-output-to-pipe");
lf[108]=C_h_intern(&lf[108],19,"\003sysstandard-output");
lf[109]=C_h_intern(&lf[109],11,"create-pipe");
lf[110]=C_static_string(C_heaptop,19,"can not create pipe");
lf[111]=C_h_intern(&lf[111],10,"errno/perm");
lf[112]=C_h_intern(&lf[112],11,"errno/noent");
lf[113]=C_h_intern(&lf[113],10,"errno/srch");
lf[114]=C_h_intern(&lf[114],10,"errno/intr");
lf[115]=C_h_intern(&lf[115],8,"errno/io");
lf[116]=C_h_intern(&lf[116],12,"errno/noexec");
lf[117]=C_h_intern(&lf[117],10,"errno/badf");
lf[118]=C_h_intern(&lf[118],11,"errno/child");
lf[119]=C_h_intern(&lf[119],11,"errno/nomem");
lf[120]=C_h_intern(&lf[120],11,"errno/acces");
lf[121]=C_h_intern(&lf[121],11,"errno/fault");
lf[122]=C_h_intern(&lf[122],10,"errno/busy");
lf[123]=C_h_intern(&lf[123],11,"errno/exist");
lf[124]=C_h_intern(&lf[124],12,"errno/notdir");
lf[125]=C_h_intern(&lf[125],11,"errno/isdir");
lf[126]=C_h_intern(&lf[126],11,"errno/inval");
lf[127]=C_h_intern(&lf[127],11,"errno/mfile");
lf[128]=C_h_intern(&lf[128],11,"errno/nospc");
lf[129]=C_h_intern(&lf[129],11,"errno/spipe");
lf[130]=C_h_intern(&lf[130],10,"errno/pipe");
lf[131]=C_h_intern(&lf[131],11,"errno/again");
lf[132]=C_h_intern(&lf[132],10,"errno/rofs");
lf[133]=C_h_intern(&lf[133],10,"errno/nxio");
lf[134]=C_h_intern(&lf[134],10,"errno/2big");
lf[135]=C_h_intern(&lf[135],10,"errno/xdev");
lf[136]=C_h_intern(&lf[136],11,"errno/nodev");
lf[137]=C_h_intern(&lf[137],11,"errno/nfile");
lf[138]=C_h_intern(&lf[138],11,"errno/notty");
lf[139]=C_h_intern(&lf[139],10,"errno/fbig");
lf[140]=C_h_intern(&lf[140],11,"errno/mlink");
lf[141]=C_h_intern(&lf[141],9,"errno/dom");
lf[142]=C_h_intern(&lf[142],11,"errno/range");
lf[143]=C_h_intern(&lf[143],12,"errno/deadlk");
lf[144]=C_h_intern(&lf[144],17,"errno/nametoolong");
lf[145]=C_h_intern(&lf[145],11,"errno/nolck");
lf[146]=C_h_intern(&lf[146],11,"errno/nosys");
lf[147]=C_h_intern(&lf[147],14,"errno/notempty");
lf[148]=C_h_intern(&lf[148],11,"errno/ilseq");
lf[149]=C_h_intern(&lf[149],16,"change-file-mode");
lf[150]=C_static_string(C_heaptop,24,"can not change file mode");
lf[151]=C_h_intern(&lf[151],17,"file-read-access\077");
lf[152]=C_h_intern(&lf[152],18,"file-write-access\077");
lf[153]=C_h_intern(&lf[153],20,"file-execute-access\077");
lf[154]=C_h_intern(&lf[154],12,"fileno/stdin");
lf[155]=C_h_intern(&lf[155],13,"fileno/stdout");
lf[156]=C_h_intern(&lf[156],13,"fileno/stderr");
lf[157]=C_h_intern(&lf[157],7,"\000append");
lf[158]=C_static_string(C_heaptop,27,"invalid mode for input file");
lf[159]=C_static_string(C_heaptop,1,"a");
lf[160]=C_static_string(C_heaptop,21,"invalid mode argument");
lf[161]=C_static_string(C_heaptop,1,"r");
lf[162]=C_static_string(C_heaptop,1,"w");
lf[163]=C_static_string(C_heaptop,17,"can not open file");
lf[164]=C_static_string(C_heaptop,8,"(fdport)");
lf[165]=C_h_intern(&lf[165],16,"open-input-file*");
lf[166]=C_h_intern(&lf[166],17,"open-output-file*");
lf[167]=C_h_intern(&lf[167],12,"port->fileno");
lf[168]=C_static_string(C_heaptop,25,"port has no attached file");
lf[169]=C_static_string(C_heaptop,38,"can not access file-descriptor of port");
lf[170]=C_h_intern(&lf[170],25,"\003syspeek-unsigned-integer");
lf[171]=C_h_intern(&lf[171],16,"duplicate-fileno");
lf[172]=C_static_string(C_heaptop,33,"can not duplicate file descriptor");
lf[173]=C_h_intern(&lf[173],6,"setenv");
lf[174]=C_h_intern(&lf[174],8,"unsetenv");
lf[175]=C_h_intern(&lf[175],9,"substring");
lf[176]=C_h_intern(&lf[176],19,"current-environment");
lf[177]=C_h_intern(&lf[177],17,"\003syspeek-c-string");
lf[178]=C_h_intern(&lf[178],19,"seconds->local-time");
lf[179]=C_h_intern(&lf[179],18,"\003sysdecode-seconds");
lf[180]=C_h_intern(&lf[180],17,"seconds->utc-time");
lf[181]=C_h_intern(&lf[181],15,"seconds->string");
lf[182]=C_static_string(C_heaptop,33,"can not convert seconds to string");
lf[183]=C_h_intern(&lf[183],12,"time->string");
lf[184]=C_static_string(C_heaptop,29,"can not time vector to string");
lf[185]=C_static_string(C_heaptop,21,"time vector too short");
lf[186]=C_h_intern(&lf[186],19,"local-time->seconds");
lf[187]=C_h_intern(&lf[187],15,"\003syscons-flonum");
lf[188]=C_static_string(C_heaptop,38,"can not convert time vector to seconds");
lf[189]=C_static_string(C_heaptop,21,"time vector too short");
lf[190]=C_h_intern(&lf[190],5,"_exit");
lf[191]=C_h_intern(&lf[191],23,"\003syscleanup-before-exit");
lf[192]=C_h_intern(&lf[192],19,"set-buffering-mode!");
lf[193]=C_static_string(C_heaptop,26,"can not set buffering mode");
lf[194]=C_h_intern(&lf[194],5,"\000full");
lf[195]=C_h_intern(&lf[195],5,"\000line");
lf[196]=C_h_intern(&lf[196],5,"\000none");
lf[197]=C_static_string(C_heaptop,22,"invalid buffering-mode");
lf[198]=C_h_intern(&lf[198],12,"glob->regexp");
lf[199]=C_h_intern(&lf[199],13,"make-pathname");
lf[200]=C_h_intern(&lf[200],18,"decompose-pathname");
lf[201]=C_h_intern(&lf[201],4,"glob");
lf[202]=C_h_intern(&lf[202],12,"string-match");
lf[203]=C_static_string(C_heaptop,1,".");
lf[204]=C_static_string(C_heaptop,1,"*");
lf[205]=C_h_intern(&lf[205],13,"spawn/overlay");
lf[206]=C_h_intern(&lf[206],10,"spawn/wait");
lf[207]=C_h_intern(&lf[207],12,"spawn/nowait");
lf[208]=C_h_intern(&lf[208],13,"spawn/nowaito");
lf[209]=C_h_intern(&lf[209],12,"spawn/detach");
lf[210]=C_h_intern(&lf[210],24,"pathname-strip-directory");
lf[211]=C_h_intern(&lf[211],15,"process-execute");
lf[212]=C_static_string(C_heaptop,23,"can not execute process");
lf[213]=C_h_intern(&lf[213],13,"process-spawn");
lf[214]=C_static_string(C_heaptop,23,"can not execute process");
lf[215]=C_h_intern(&lf[215],18,"current-process-id");
lf[216]=C_h_intern(&lf[216],9,"get-shell");
lf[217]=C_h_intern(&lf[217],6,"getenv");
lf[218]=C_h_intern(&lf[218],11,"process-run");
lf[219]=C_static_string(C_heaptop,2,"/c");
lf[221]=C_h_intern(&lf[221],15,"make-input-port");
lf[222]=C_h_intern(&lf[222],16,"make-output-port");
lf[223]=C_h_intern(&lf[223],7,"process");
lf[224]=C_static_string(C_heaptop,23,"could not write to pipe");
lf[225]=C_static_string(C_heaptop,24,"could not read from pipe");
lf[226]=C_static_string(C_heaptop,24,"could not create process");
lf[227]=C_h_intern(&lf[227],14,"C_close_handle");
lf[228]=C_static_string(C_heaptop,4," /c ");
lf[229]=C_static_string(C_heaptop,1,"\000");
lf[230]=C_static_string(C_heaptop,22,"could not redirect I/O");
lf[231]=C_h_intern(&lf[231],12,"process-wait");
lf[232]=C_h_intern(&lf[232],5,"sleep");
lf[233]=C_h_intern(&lf[233],13,"get-host-name");
lf[234]=C_static_string(C_heaptop,26,"can not retrieve host-name");
lf[235]=C_h_intern(&lf[235],18,"system-information");
lf[236]=C_static_string(C_heaptop,7,"windows");
lf[237]=C_static_string(C_heaptop,35,"can not retrieve system-information");
lf[238]=C_h_intern(&lf[238],10,"find-files");
lf[239]=C_static_string(C_heaptop,1,".");
lf[240]=C_static_string(C_heaptop,2,"..");
lf[241]=C_static_string(C_heaptop,1,"*");
lf[242]=C_h_intern(&lf[242],16,"\003sysdynamic-wind");
lf[243]=C_h_intern(&lf[243],13,"pathname-file");
lf[244]=C_static_string(C_heaptop,1,"*");
lf[245]=C_h_intern(&lf[245],17,"register-feature!");
lf[246]=C_h_intern(&lf[246],5,"posix");
C_register_lf2(lf,247,create_ptable());
t2=C_mutate(&lf[0],lf[1]);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_663,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
C_scheduler_toplevel(2,C_SCHEME_UNDEFINED,t3);}

/* k661 */
static void C_ccall f_663(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_663,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_666,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_regex_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k664 in k661 */
static void C_ccall f_666(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_666,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_669,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_extras_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k667 in k664 in k661 */
static void C_ccall f_669(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_669,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_672,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_utils_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k670 in k667 in k664 in k661 */
static void C_ccall f_672(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_672,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_675,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 612  register-feature! */
t3=*((C_word*)lf[245]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,lf[246]);}

/* k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_675(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word t72;
C_word t73;
C_word t74;
C_word t75;
C_word t76;
C_word t77;
C_word t78;
C_word t79;
C_word t80;
C_word t81;
C_word t82;
C_word t83;
C_word t84;
C_word t85;
C_word t86;
C_word t87;
C_word t88;
C_word t89;
C_word t90;
C_word t91;
C_word t92;
C_word t93;
C_word t94;
C_word t95;
C_word t96;
C_word t97;
C_word t98;
C_word t99;
C_word t100;
C_word t101;
C_word t102;
C_word t103;
C_word t104;
C_word t105;
C_word t106;
C_word t107;
C_word t108;
C_word t109;
C_word t110;
C_word t111;
C_word t112;
C_word t113;
C_word t114;
C_word t115;
C_word t116;
C_word t117;
C_word t118;
C_word t119;
C_word t120;
C_word t121;
C_word t122;
C_word t123;
C_word t124;
C_word t125;
C_word t126;
C_word t127;
C_word t128;
C_word t129;
C_word t130;
C_word t131;
C_word t132;
C_word t133;
C_word t134;
C_word t135;
C_word t136;
C_word t137;
C_word t138;
C_word t139;
C_word t140;
C_word t141;
C_word t142;
C_word t143;
C_word t144;
C_word t145;
C_word t146;
C_word t147;
C_word t148;
C_word t149;
C_word t150;
C_word t151;
C_word t152;
C_word t153;
C_word t154;
C_word t155;
C_word t156;
C_word t157;
C_word t158;
C_word t159;
C_word t160;
C_word t161;
C_word t162;
C_word t163;
C_word t164;
C_word t165;
C_word t166;
C_word t167;
C_word t168;
C_word t169;
C_word t170;
C_word t171;
C_word t172;
C_word t173;
C_word t174;
C_word ab[188],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_675,2,t0,t1);}
t2=C_mutate(&lf[2],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_677,tmp=(C_word)a,a+=2,tmp));
t3=C_mutate((C_word*)lf[5]+1,C_fix((C_word)PIPE_BUF));
t4=C_mutate((C_word*)lf[6]+1,C_fix((C_word)O_RDONLY));
t5=C_mutate((C_word*)lf[7]+1,C_fix((C_word)O_WRONLY));
t6=C_mutate((C_word*)lf[8]+1,C_fix((C_word)O_RDWR));
t7=C_mutate((C_word*)lf[9]+1,C_fix((C_word)O_RDWR));
t8=C_mutate((C_word*)lf[10]+1,C_fix((C_word)O_WRONLY));
t9=C_mutate((C_word*)lf[11]+1,C_fix((C_word)O_CREAT));
t10=C_mutate((C_word*)lf[12]+1,C_fix((C_word)O_APPEND));
t11=C_mutate((C_word*)lf[13]+1,C_fix((C_word)O_EXCL));
t12=C_mutate((C_word*)lf[14]+1,C_fix((C_word)O_TRUNC));
t13=C_mutate((C_word*)lf[15]+1,C_fix((C_word)O_BINARY));
t14=C_mutate((C_word*)lf[16]+1,C_fix((C_word)O_TEXT));
t15=C_mutate((C_word*)lf[17]+1,C_fix((C_word)S_IREAD));
t16=C_mutate((C_word*)lf[18]+1,C_fix((C_word)S_IWRITE));
t17=C_mutate((C_word*)lf[19]+1,C_fix((C_word)S_IEXEC));
t18=C_mutate((C_word*)lf[20]+1,C_fix((C_word)S_IREAD));
t19=C_mutate((C_word*)lf[21]+1,C_fix((C_word)S_IWRITE));
t20=C_mutate((C_word*)lf[22]+1,C_fix((C_word)S_IEXEC));
t21=C_mutate((C_word*)lf[23]+1,C_fix((C_word)S_IREAD));
t22=C_mutate((C_word*)lf[24]+1,C_fix((C_word)S_IWRITE));
t23=C_mutate((C_word*)lf[25]+1,C_fix((C_word)S_IEXEC));
t24=C_mutate((C_word*)lf[26]+1,C_fix((C_word)S_IREAD | S_IWRITE | S_IEXEC));
t25=C_mutate((C_word*)lf[27]+1,C_fix((C_word)S_IREAD | S_IWRITE | S_IEXEC));
t26=C_mutate((C_word*)lf[28]+1,C_fix((C_word)S_IREAD | S_IWRITE | S_IEXEC));
t27=(C_word)C_u_fixnum_or(C_fix((C_word)S_IREAD),C_fix((C_word)S_IREAD));
t28=(C_word)C_a_i_bitwise_ior(&a,2,C_fix((C_word)S_IREAD | S_IWRITE | S_IEXEC),t27);
t29=C_mutate((C_word*)lf[29]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_725,a[2]=t28,tmp=(C_word)a,a+=3,tmp));
t30=C_mutate((C_word*)lf[36]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_757,tmp=(C_word)a,a+=2,tmp));
t31=*((C_word*)lf[38]+1);
t32=C_mutate((C_word*)lf[39]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_772,a[2]=t31,tmp=(C_word)a,a+=3,tmp));
t33=C_mutate((C_word*)lf[43]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_811,tmp=(C_word)a,a+=2,tmp));
t34=*((C_word*)lf[46]+1);
t35=C_mutate((C_word*)lf[47]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_847,a[2]=t34,tmp=(C_word)a,a+=3,tmp));
t36=C_mutate((C_word*)lf[50]+1,C_fix((C_word)SEEK_SET));
t37=C_mutate((C_word*)lf[51]+1,C_fix((C_word)SEEK_END));
t38=C_mutate((C_word*)lf[52]+1,C_fix((C_word)SEEK_CUR));
t39=C_mutate(&lf[53],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_882,tmp=(C_word)a,a+=2,tmp));
t40=C_mutate((C_word*)lf[56]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_920,tmp=(C_word)a,a+=2,tmp));
t41=C_mutate((C_word*)lf[57]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_948,tmp=(C_word)a,a+=2,tmp));
t42=C_mutate((C_word*)lf[58]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_954,tmp=(C_word)a,a+=2,tmp));
t43=C_mutate((C_word*)lf[59]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_960,tmp=(C_word)a,a+=2,tmp));
t44=C_mutate((C_word*)lf[60]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_966,tmp=(C_word)a,a+=2,tmp));
t45=C_mutate((C_word*)lf[61]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_972,tmp=(C_word)a,a+=2,tmp));
t46=C_mutate((C_word*)lf[62]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_978,tmp=(C_word)a,a+=2,tmp));
t47=C_mutate((C_word*)lf[63]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_984,tmp=(C_word)a,a+=2,tmp));
t48=C_mutate((C_word*)lf[65]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1004,tmp=(C_word)a,a+=2,tmp));
t49=C_mutate((C_word*)lf[66]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1007,tmp=(C_word)a,a+=2,tmp));
t50=C_mutate((C_word*)lf[71]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1047,tmp=(C_word)a,a+=2,tmp));
t51=C_mutate((C_word*)lf[76]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1102,tmp=(C_word)a,a+=2,tmp));
t52=C_mutate((C_word*)lf[78]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1126,tmp=(C_word)a,a+=2,tmp));
t53=C_mutate((C_word*)lf[80]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1150,tmp=(C_word)a,a+=2,tmp));
t54=*((C_word*)lf[82]+1);
t55=*((C_word*)lf[38]+1);
t56=*((C_word*)lf[83]+1);
t57=C_mutate((C_word*)lf[84]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1174,a[2]=t55,tmp=(C_word)a,a+=3,tmp));
t58=C_mutate((C_word*)lf[88]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1328,tmp=(C_word)a,a+=2,tmp));
t59=*((C_word*)lf[38]+1);
t60=C_mutate((C_word*)lf[87]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1348,a[2]=t59,tmp=(C_word)a,a+=3,tmp));
t61=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1391,tmp=(C_word)a,a+=2,tmp);
t62=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1403,tmp=(C_word)a,a+=2,tmp);
t63=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1409,tmp=(C_word)a,a+=2,tmp);
t64=C_mutate((C_word*)lf[97]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1427,a[2]=t62,a[3]=t63,a[4]=t61,tmp=(C_word)a,a+=5,tmp));
t65=C_mutate((C_word*)lf[99]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1460,a[2]=t62,a[3]=t63,a[4]=t61,tmp=(C_word)a,a+=5,tmp));
t66=C_mutate((C_word*)lf[100]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1493,tmp=(C_word)a,a+=2,tmp));
t67=C_mutate((C_word*)lf[102]+1,*((C_word*)lf[100]+1));
t68=*((C_word*)lf[97]+1);
t69=*((C_word*)lf[99]+1);
t70=*((C_word*)lf[100]+1);
t71=*((C_word*)lf[102]+1);
t72=C_mutate((C_word*)lf[103]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1509,a[2]=t68,a[3]=t70,tmp=(C_word)a,a+=4,tmp));
t73=C_mutate((C_word*)lf[104]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1533,a[2]=t69,a[3]=t71,tmp=(C_word)a,a+=4,tmp));
t74=C_mutate((C_word*)lf[105]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1557,a[2]=t68,a[3]=t70,tmp=(C_word)a,a+=4,tmp));
t75=C_mutate((C_word*)lf[107]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1577,a[2]=t69,a[3]=t71,tmp=(C_word)a,a+=4,tmp));
t76=C_mutate((C_word*)lf[109]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1597,tmp=(C_word)a,a+=2,tmp));
t77=C_mutate((C_word*)lf[111]+1,C_fix((C_word)EPERM));
t78=C_mutate((C_word*)lf[112]+1,C_fix((C_word)ENOENT));
t79=C_mutate((C_word*)lf[113]+1,C_fix((C_word)ESRCH));
t80=C_mutate((C_word*)lf[114]+1,C_fix((C_word)EINTR));
t81=C_mutate((C_word*)lf[115]+1,C_fix((C_word)EIO));
t82=C_mutate((C_word*)lf[116]+1,C_fix((C_word)ENOEXEC));
t83=C_mutate((C_word*)lf[117]+1,C_fix((C_word)EBADF));
t84=C_mutate((C_word*)lf[118]+1,C_fix((C_word)ECHILD));
t85=C_mutate((C_word*)lf[119]+1,C_fix((C_word)ENOMEM));
t86=C_mutate((C_word*)lf[120]+1,C_fix((C_word)EACCES));
t87=C_mutate((C_word*)lf[121]+1,C_fix((C_word)EFAULT));
t88=C_mutate((C_word*)lf[122]+1,C_fix((C_word)EBUSY));
t89=C_mutate((C_word*)lf[123]+1,C_fix((C_word)EEXIST));
t90=C_mutate((C_word*)lf[124]+1,C_fix((C_word)ENOTDIR));
t91=C_mutate((C_word*)lf[125]+1,C_fix((C_word)EISDIR));
t92=C_mutate((C_word*)lf[126]+1,C_fix((C_word)EINVAL));
t93=C_mutate((C_word*)lf[127]+1,C_fix((C_word)EMFILE));
t94=C_mutate((C_word*)lf[128]+1,C_fix((C_word)ENOSPC));
t95=C_mutate((C_word*)lf[129]+1,C_fix((C_word)ESPIPE));
t96=C_mutate((C_word*)lf[130]+1,C_fix((C_word)EPIPE));
t97=C_mutate((C_word*)lf[131]+1,C_fix((C_word)EAGAIN));
t98=C_mutate((C_word*)lf[132]+1,C_fix((C_word)EROFS));
t99=C_mutate((C_word*)lf[133]+1,C_fix((C_word)ENXIO));
t100=C_mutate((C_word*)lf[134]+1,C_fix((C_word)E2BIG));
t101=C_mutate((C_word*)lf[135]+1,C_fix((C_word)EXDEV));
t102=C_mutate((C_word*)lf[136]+1,C_fix((C_word)ENODEV));
t103=C_mutate((C_word*)lf[137]+1,C_fix((C_word)ENFILE));
t104=C_mutate((C_word*)lf[138]+1,C_fix((C_word)ENOTTY));
t105=C_mutate((C_word*)lf[139]+1,C_fix((C_word)EFBIG));
t106=C_mutate((C_word*)lf[140]+1,C_fix((C_word)EMLINK));
t107=C_mutate((C_word*)lf[141]+1,C_fix((C_word)EDOM));
t108=C_mutate((C_word*)lf[142]+1,C_fix((C_word)ERANGE));
t109=C_mutate((C_word*)lf[143]+1,C_fix((C_word)EDEADLK));
t110=C_mutate((C_word*)lf[144]+1,C_fix((C_word)ENAMETOOLONG));
t111=C_mutate((C_word*)lf[145]+1,C_fix((C_word)ENOLCK));
t112=C_mutate((C_word*)lf[146]+1,C_fix((C_word)ENOSYS));
t113=C_mutate((C_word*)lf[147]+1,C_fix((C_word)ENOTEMPTY));
t114=C_mutate((C_word*)lf[148]+1,C_fix((C_word)EILSEQ));
t115=C_mutate((C_word*)lf[149]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1653,tmp=(C_word)a,a+=2,tmp));
t116=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1677,tmp=(C_word)a,a+=2,tmp);
t117=C_mutate((C_word*)lf[151]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1698,a[2]=t116,tmp=(C_word)a,a+=3,tmp));
t118=C_mutate((C_word*)lf[152]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1704,a[2]=t116,tmp=(C_word)a,a+=3,tmp));
t119=C_mutate((C_word*)lf[153]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1710,a[2]=t116,tmp=(C_word)a,a+=3,tmp));
t120=C_mutate((C_word*)lf[154]+1,C_fix((C_word)0));
t121=C_mutate((C_word*)lf[155]+1,C_fix((C_word)1));
t122=C_mutate((C_word*)lf[156]+1,C_fix((C_word)2));
t123=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1719,tmp=(C_word)a,a+=2,tmp);
t124=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1756,tmp=(C_word)a,a+=2,tmp);
t125=C_mutate((C_word*)lf[165]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1774,a[2]=t123,a[3]=t124,tmp=(C_word)a,a+=4,tmp));
t126=C_mutate((C_word*)lf[166]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1785,a[2]=t123,a[3]=t124,tmp=(C_word)a,a+=4,tmp));
t127=C_mutate((C_word*)lf[167]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1796,tmp=(C_word)a,a+=2,tmp));
t128=C_mutate((C_word*)lf[171]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1828,tmp=(C_word)a,a+=2,tmp));
t129=C_mutate((C_word*)lf[173]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1852,tmp=(C_word)a,a+=2,tmp));
t130=C_mutate((C_word*)lf[174]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1863,tmp=(C_word)a,a+=2,tmp));
t131=*((C_word*)lf[175]+1);
t132=C_mutate((C_word*)lf[176]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1875,a[2]=t131,tmp=(C_word)a,a+=3,tmp));
t133=C_mutate((C_word*)lf[178]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1940,tmp=(C_word)a,a+=2,tmp));
t134=C_mutate((C_word*)lf[180]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1946,tmp=(C_word)a,a+=2,tmp));
t135=C_mutate((C_word*)lf[181]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1957,tmp=(C_word)a,a+=2,tmp));
t136=C_mutate((C_word*)lf[183]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1974,tmp=(C_word)a,a+=2,tmp));
t137=C_mutate((C_word*)lf[186]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2002,tmp=(C_word)a,a+=2,tmp));
t138=C_mutate((C_word*)lf[190]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2032,tmp=(C_word)a,a+=2,tmp));
t139=C_mutate((C_word*)lf[192]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2051,tmp=(C_word)a,a+=2,tmp));
t140=*((C_word*)lf[198]+1);
t141=*((C_word*)lf[84]+1);
t142=*((C_word*)lf[199]+1);
t143=*((C_word*)lf[200]+1);
t144=C_mutate((C_word*)lf[201]+1,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2104,a[2]=t140,a[3]=t141,a[4]=t142,a[5]=t143,tmp=(C_word)a,a+=6,tmp));
t145=C_mutate((C_word*)lf[205]+1,C_fix((C_word)P_OVERLAY));
t146=C_mutate((C_word*)lf[206]+1,C_fix((C_word)P_WAIT));
t147=C_mutate((C_word*)lf[207]+1,C_fix((C_word)P_NOWAIT));
t148=C_mutate((C_word*)lf[208]+1,C_fix((C_word)P_NOWAITO));
t149=C_mutate((C_word*)lf[209]+1,C_fix((C_word)P_DETACH));
t150=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2213,tmp=(C_word)a,a+=2,tmp);
t151=*((C_word*)lf[210]+1);
t152=C_mutate((C_word*)lf[211]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2221,a[2]=t151,a[3]=t150,tmp=(C_word)a,a+=4,tmp));
t153=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2353,tmp=(C_word)a,a+=2,tmp);
t154=*((C_word*)lf[210]+1);
t155=C_mutate((C_word*)lf[213]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2361,a[2]=t154,a[3]=t153,tmp=(C_word)a,a+=4,tmp));
t156=C_mutate((C_word*)lf[215]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2442,tmp=(C_word)a,a+=2,tmp));
t157=C_mutate((C_word*)lf[216]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2445,tmp=(C_word)a,a+=2,tmp));
t158=*((C_word*)lf[213]+1);
t159=*((C_word*)lf[217]+1);
t160=C_mutate((C_word*)lf[218]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2451,a[2]=t158,tmp=(C_word)a,a+=3,tmp));
t161=C_mutate(&lf[220],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2480,tmp=(C_word)a,a+=2,tmp));
t162=*((C_word*)lf[221]+1);
t163=*((C_word*)lf[222]+1);
t164=C_mutate((C_word*)lf[223]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2483,a[2]=t162,a[3]=t163,tmp=(C_word)a,a+=4,tmp));
t165=C_mutate((C_word*)lf[231]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2631,tmp=(C_word)a,a+=2,tmp));
t166=C_mutate((C_word*)lf[232]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2670,tmp=(C_word)a,a+=2,tmp));
t167=C_mutate((C_word*)lf[233]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2673,tmp=(C_word)a,a+=2,tmp));
t168=C_mutate((C_word*)lf[235]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2685,tmp=(C_word)a,a+=2,tmp));
t169=*((C_word*)lf[201]+1);
t170=*((C_word*)lf[202]+1);
t171=*((C_word*)lf[199]+1);
t172=*((C_word*)lf[88]+1);
t173=C_mutate((C_word*)lf[238]+1,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2716,a[2]=t172,a[3]=t171,a[4]=t169,a[5]=t170,tmp=(C_word)a,a+=6,tmp));
t174=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t174+1)))(2,t174,C_SCHEME_UNDEFINED);}

/* find-files in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2716(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+17)){
C_save_and_reclaim((void*)tr4r,(void*)f_2716r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_2716r(t0,t1,t2,t3,t4);}}

static void C_ccall f_2716r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a=C_alloc(17);
t5=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2718,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=t3,tmp=(C_word)a,a+=8,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2854,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2859,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2864,a[2]=t7,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_nullp(t4))){
/* def-action483514 */
t9=t8;
f_2864(t9,t1);}
else{
t9=(C_word)C_u_i_car(t4);
t10=(C_word)C_slot(t4,C_fix(1));
if(C_truep((C_word)C_i_nullp(t10))){
/* def-id484512 */
t11=t7;
f_2859(t11,t1,t9);}
else{
t11=(C_word)C_u_i_car(t10);
t12=(C_word)C_slot(t10,C_fix(1));
if(C_truep((C_word)C_i_nullp(t12))){
/* def-limit485509 */
t13=t6;
f_2854(t13,t1,t9,t11);}
else{
t13=(C_word)C_u_i_car(t12);
t14=(C_word)C_slot(t12,C_fix(1));
/* body481487 */
t15=t5;
f_2718(t15,t1,t9,t11,t13);}}}}

/* def-action483 in find-files in k673 in k670 in k667 in k664 in k661 */
static void C_fcall f_2864(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2864,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2870,tmp=(C_word)a,a+=2,tmp);
/* def-id484512 */
t3=((C_word*)t0)[2];
f_2859(t3,t1,t2);}

/* a2869 in def-action483 in find-files in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2870(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_2870,4,t0,t1,t2,t3);}
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_a_i_cons(&a,2,t2,t3));}

/* def-id484 in find-files in k673 in k670 in k667 in k664 in k661 */
static void C_fcall f_2859(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2859,NULL,3,t0,t1,t2);}
/* def-limit485509 */
t3=((C_word*)t0)[2];
f_2854(t3,t1,t2,C_SCHEME_END_OF_LIST);}

/* def-limit485 in find-files in k673 in k670 in k667 in k664 in k661 */
static void C_fcall f_2854(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2854,NULL,4,t0,t1,t2,t3);}
/* body481487 */
t4=((C_word*)t0)[2];
f_2718(t4,t1,t2,t3,C_SCHEME_FALSE);}

/* body481 in find-files in k673 in k670 in k667 in k664 in k661 */
static void C_fcall f_2718(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[20],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2718,NULL,5,t0,t1,t2,t3,t4);}
t5=C_fix(0);
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_2722,a[2]=((C_word*)t0)[2],a[3]=t3,a[4]=t1,a[5]=((C_word*)t0)[3],a[6]=t2,a[7]=((C_word*)t0)[4],a[8]=((C_word*)t0)[5],a[9]=t6,a[10]=((C_word*)t0)[6],a[11]=((C_word*)t0)[7],tmp=(C_word)a,a+=12,tmp);
t8=t4;
if(C_truep(t8)){
t9=(C_word)C_fixnump(t4);
t10=t7;
f_2722(t10,(C_truep(t9)?(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2849,a[2]=t4,a[3]=t6,tmp=(C_word)a,a+=4,tmp):t4));}
else{
t9=t7;
f_2722(t9,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2841,tmp=(C_word)a,a+=2,tmp));}}

/* f_2841 in body481 in find-files in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2841(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2841,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_TRUE);}

/* f_2849 in body481 in find-files in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2849(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2849,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_fixnum_lessp(((C_word*)((C_word*)t0)[3])[1],((C_word*)t0)[2]));}

/* k2720 in body481 in find-files in k673 in k670 in k667 in k664 in k661 */
static void C_fcall f_2722(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2722,NULL,2,t0,t1);}
t2=(C_word)C_i_stringp(((C_word*)t0)[11]);
t3=(C_truep(t2)?(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2833,a[2]=((C_word*)t0)[11],a[3]=((C_word*)t0)[10],tmp=(C_word)a,a+=4,tmp):((C_word*)t0)[11]);
t4=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_2732,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t3,a[6]=((C_word*)t0)[6],a[7]=t1,a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],tmp=(C_word)a,a+=11,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2829,a[2]=t4,a[3]=((C_word*)t0)[8],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1457 make-pathname */
t6=((C_word*)t0)[7];
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t5,((C_word*)t0)[2],lf[244]);}

/* k2827 in k2720 in body481 in find-files in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2829(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1457 glob */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2730 in k2720 in body481 in find-files in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2732(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2732,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_2734,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=t3,tmp=(C_word)a,a+=10,tmp));
t5=((C_word*)t3)[1];
f_2734(t5,((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* loop in k2730 in k2720 in body481 in find-files in k673 in k670 in k667 in k664 in k661 */
static void C_fcall f_2734(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2734,NULL,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t4=(C_word)C_slot(t2,C_fix(0));
t5=(C_word)C_slot(t2,C_fix(1));
t6=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_2753,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t4,a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=t3,a[10]=t5,a[11]=t1,a[12]=((C_word*)t0)[9],tmp=(C_word)a,a+=13,tmp);
/* posixwin.scm: 1463 directory? */
t7=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,t4);}}

/* k2751 in loop in k2730 in k2720 in body481 in find-files in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2753(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2753,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_2809,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[11],a[10]=((C_word*)t0)[12],tmp=(C_word)a,a+=11,tmp);
/* posixwin.scm: 1464 pathname-file */
t3=*((C_word*)lf[243]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[5]);}
else{
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2815,a[2]=((C_word*)t0)[9],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[10],a[6]=((C_word*)t0)[11],a[7]=((C_word*)t0)[12],tmp=(C_word)a,a+=8,tmp);
/* posixwin.scm: 1470 pproc */
t3=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[5]);}}

/* k2813 in k2751 in loop in k2730 in k2720 in body481 in find-files in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2815(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2815,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2822,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1470 action */
t3=((C_word*)t0)[4];
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
/* posixwin.scm: 1471 loop */
t2=((C_word*)((C_word*)t0)[7])[1];
f_2734(t2,((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[2]);}}

/* k2820 in k2813 in k2751 in loop in k2730 in k2720 in body481 in find-files in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2822(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1470 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_2734(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k2807 in k2751 in loop in k2730 in k2720 in body481 in find-files in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2809(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2809,2,t0,t1);}
if(C_truep((C_truep((C_word)C_i_equalp(t1,lf[239]))?C_SCHEME_TRUE:(C_truep((C_word)C_i_equalp(t1,lf[240]))?C_SCHEME_TRUE:C_SCHEME_FALSE)))){
/* posixwin.scm: 1464 loop */
t2=((C_word*)((C_word*)t0)[10])[1];
f_2734(t2,((C_word*)t0)[9],((C_word*)t0)[8],((C_word*)t0)[7]);}
else{
t2=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_2768,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[6],tmp=(C_word)a,a+=10,tmp);
/* posixwin.scm: 1465 lproc */
t3=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[3]);}}

/* k2766 in k2807 in k2751 in loop in k2730 in k2720 in body481 in find-files in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2768(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[26],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2768,2,t0,t1);}
if(C_truep(t1)){
t2=(C_word)C_u_fixnum_plus(((C_word*)((C_word*)t0)[9])[1],C_fix(1));
t3=t2;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_SCHEME_FALSE;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2778,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],tmp=(C_word)a,a+=5,tmp);
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2780,a[2]=t4,a[3]=((C_word*)t0)[9],a[4]=t6,tmp=(C_word)a,a+=5,tmp);
t9=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2785,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[8],tmp=(C_word)a,a+=7,tmp);
t10=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2799,a[2]=t6,a[3]=((C_word*)t0)[9],a[4]=t4,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1467 ##sys#dynamic-wind */
t11=*((C_word*)lf[242]+1);
((C_proc5)(void*)(*((C_word*)t11+1)))(5,t11,t7,t8,t9,t10);}
else{
/* posixwin.scm: 1469 loop */
t2=((C_word*)((C_word*)t0)[8])[1];
f_2734(t2,((C_word*)t0)[7],((C_word*)t0)[6],((C_word*)t0)[5]);}}

/* a2798 in k2766 in k2807 in k2751 in loop in k2730 in k2720 in body481 in find-files in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2799(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2799,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)((C_word*)t0)[2])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* a2784 in k2766 in k2807 in k2751 in loop in k2730 in k2720 in body481 in find-files in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2785(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2785,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2793,a[2]=((C_word*)t0)[5],a[3]=t1,a[4]=((C_word*)t0)[6],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2797,a[2]=t2,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1468 make-pathname */
t4=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,((C_word*)t0)[2],lf[241]);}

/* k2795 in a2784 in k2766 in k2807 in k2751 in loop in k2730 in k2720 in body481 in find-files in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2797(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1468 glob */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2791 in a2784 in k2766 in k2807 in k2751 in loop in k2730 in k2720 in body481 in find-files in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2793(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1468 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_2734(t2,((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* a2779 in k2766 in k2807 in k2751 in loop in k2730 in k2720 in body481 in find-files in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2780(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2780,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)((C_word*)t0)[2])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k2776 in k2766 in k2807 in k2751 in loop in k2730 in k2720 in body481 in find-files in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2778(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1466 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_2734(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* f_2833 in k2720 in body481 in find-files in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2833(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2833,3,t0,t1,t2);}
/* posixwin.scm: 1455 string-match */
t3=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,((C_word*)t0)[2],t2);}

/* system-information in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2685(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2685,2,t0,t1);}
if(C_truep((C_word)C_sysinfo())){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2696,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[177]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_hostname),C_fix(0));}
else{
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2711,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1432 ##sys#update-errno */
t3=*((C_word*)lf[33]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

/* k2709 in system-information in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2711(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1433 ##sys#error */
t2=*((C_word*)lf[91]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[235],lf[237]);}

/* k2694 in system-information in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2696(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2696,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2700,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[177]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_osrel),C_fix(0));}

/* k2698 in k2694 in system-information in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2700(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2700,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2704,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[177]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_osver),C_fix(0));}

/* k2702 in k2698 in k2694 in system-information in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2704(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2704,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2708,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[177]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_processor),C_fix(0));}

/* k2706 in k2702 in k2698 in k2694 in system-information in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2708(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2708,2,t0,t1);}
t2=((C_word*)t0)[5];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_list(&a,5,lf[236],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1));}

/* get-host-name in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2673(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2673,2,t0,t1);}
if(C_truep((C_word)C_get_hostname())){
/* ##sys#peek-c-string */
t2=*((C_word*)lf[177]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,C_mpointer(&a,(void*)C_hostname),C_fix(0));}
else{
/* posixwin.scm: 1425 ##sys#error */
t2=*((C_word*)lf[91]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[233],lf[234]);}}

/* sleep in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2670(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2670,3,t0,t1,t2);}
t3=(C_word)C_sleep(t2);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_fix(0));}

/* process-wait in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2631(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr3r,(void*)f_2631r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_2631r(t0,t1,t2,t3);}}

static void C_ccall f_2631r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a=C_alloc(3);
t4=(C_word)C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:(C_word)C_u_i_car(t3));
t6=(C_word)C_i_nullp(t3);
t7=(C_truep(t6)?C_SCHEME_END_OF_LIST:(C_word)C_slot(t3,C_fix(1)));
if(C_truep((C_word)C_process_wait(t2,t5))){
/* posixwin.scm: 1406 values */
C_values(5,0,t1,t2,C_SCHEME_TRUE,C_fix((C_word)C_exstatus));}
else{
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2650,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1408 ##sys#update-errno */
t9=*((C_word*)lf[33]+1);
((C_proc2)(void*)(*((C_word*)t9+1)))(2,t9,t8);}}

/* k2648 in process-wait in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2650(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1409 values */
C_values(5,0,((C_word*)t0)[2],C_fix(0),C_SCHEME_FALSE,C_fix(0));}

/* process in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2483(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+11)){
C_save_and_reclaim((void*)tr3r,(void*)f_2483r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_2483r(t0,t1,t2,t3);}}

static void C_ccall f_2483r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(11);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2485,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2581,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2586,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
/* def-args437455 */
t7=t6;
f_2586(t7,t1);}
else{
t7=(C_word)C_u_i_car(t3);
t8=(C_word)C_slot(t3,C_fix(1));
if(C_truep((C_word)C_i_nullp(t8))){
/* def-env438453 */
t9=t5;
f_2581(t9,t1);}
else{
t9=(C_word)C_u_i_car(t8);
t10=(C_word)C_slot(t8,C_fix(1));
/* body435440 */
t11=t4;
f_2485(t11,t1);}}}

/* def-args437 in process in k673 in k670 in k667 in k664 in k661 */
static void C_fcall f_2586(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2586,NULL,2,t0,t1);}
/* def-env438453 */
t2=((C_word*)t0)[2];
f_2581(t2,t1);}

/* def-env438 in process in k673 in k670 in k667 in k664 in k661 */
static void C_fcall f_2581(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2581,NULL,2,t0,t1);}
/* body435440 */
t2=((C_word*)t0)[2];
f_2485(t2,t1);}

/* body435 in process in k673 in k670 in k667 in k664 in k661 */
static void C_fcall f_2485(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2485,NULL,2,t0,t1);}
if(C_truep((C_word)C_redir_io())){
t2=C_fix((C_word)C_wr0_);
t3=C_fix((C_word)C_rd1_);
t4=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2492,a[2]=((C_word*)t0)[3],a[3]=t3,a[4]=((C_word*)t0)[4],a[5]=t2,a[6]=t1,tmp=(C_word)a,a+=7,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2577,a[2]=((C_word*)t0)[2],a[3]=t4,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1367 get-shell */
t6=*((C_word*)lf[216]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
/* posixwin.scm: 1398 ##sys#error */
t2=*((C_word*)lf[91]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[223],lf[230]);}}

/* k2575 in body435 in process in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2577(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1367 string-append */
t2=*((C_word*)lf[82]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],t1,lf[228],((C_word*)t0)[2],lf[229]);}

/* k2490 in body435 in process in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2492(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[20],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2492,2,t0,t1);}
t2=(C_word)C_run_process(t1);
if(C_truep((C_word)C_fixnum_greaterp(t2,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2505,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=t2,a[5]=((C_word*)t0)[6],tmp=(C_word)a,a+=6,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2530,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2554,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2557,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1371 make-input-port */
t7=((C_word*)t0)[2];
((C_proc5)(void*)(*((C_word*)t7+1)))(5,t7,t3,t4,t5,t6);}
else{
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2564,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[6],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1393 ##sys#update-errno */
t4=*((C_word*)lf[33]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k2562 in k2490 in body435 in process in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2564(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2564,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2567,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1394 C_close_handle */
t3=*((C_word*)lf[227]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

/* k2565 in k2562 in k2490 in body435 in process in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2567(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2567,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2570,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1395 C_close_handle */
t3=*((C_word*)lf[227]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

/* k2568 in k2565 in k2562 in k2490 in body435 in process in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2570(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1396 ##sys#error */
t2=*((C_word*)lf[91]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[223],lf[226]);}

/* a2556 in k2490 in body435 in process in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2557(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2557,2,t0,t1);}
/* posixwin.scm: 1380 close-handle */
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,f_2480(((C_word*)t0)[2]));}

/* a2553 in k2490 in body435 in process in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2554(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2554,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_pipe_ready(((C_word*)t0)[2]));}

/* a2529 in k2490 in body435 in process in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2530(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2530,2,t0,t1);}
t2=(C_word)C_pipe_read(((C_word*)t0)[2]);
switch(t2){
case C_fix(-1):
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_END_OF_FILE);
case C_fix(0):
/* posixwin.scm: 1375 ##sys#error */
t3=*((C_word*)lf[91]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,lf[223],lf[225]);
default:
t3=(C_word)C_eqp(t2,C_fix(1));
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_truep(t3)?C_make_character((C_word)C_rdbuf):C_SCHEME_UNDEFINED));}}

/* k2503 in k2490 in body435 in process in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2505(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2505,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2509,a[2]=((C_word*)t0)[4],a[3]=t1,a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2511,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2524,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1384 make-output-port */
t5=((C_word*)t0)[2];
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t2,t3,t4);}

/* a2523 in k2503 in k2490 in body435 in process in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2524(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2524,2,t0,t1);}
/* posixwin.scm: 1389 close-handle */
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,f_2480(((C_word*)t0)[2]));}

/* a2510 in k2503 in k2490 in body435 in process in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2511(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2511,3,t0,t1,t2);}
t3=(C_word)C_fix((C_word)C_header_size(t2));
if(C_truep((C_word)C_pipe_write(((C_word*)t0)[2],t2,t3))){
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}
else{
/* posixwin.scm: 1387 ##sys#error */
t4=*((C_word*)lf[91]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t1,lf[223],lf[224]);}}

/* k2507 in k2503 in k2490 in body435 in process in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2509(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1370 values */
C_values(5,0,((C_word*)t0)[4],((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* close-handle in k673 in k670 in k667 in k664 in k661 */
static C_word C_fcall f_2480(C_word t1){
C_word tmp;
C_word t2;
return((C_word)stub425(C_SCHEME_UNDEFINED,t1));}

/* process-run in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2451(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3rv,(void*)f_2451r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_2451r(t0,t1,t2,t3);}}

static void C_ccall f_2451r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(5);
t4=(C_word)C_notvemptyp(t3);
t5=(C_truep(t4)?(C_word)C_slot(t3,C_fix(0)):C_SCHEME_FALSE);
if(C_truep(t5)){
/* posixwin.scm: 1349 process-spawn */
t6=((C_word*)t0)[2];
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t1,*((C_word*)lf[207]+1),t2,t5);}
else{
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2468,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1350 get-shell */
t7=*((C_word*)lf[216]+1);
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}}

/* k2466 in process-run in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2468(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2468,2,t0,t1);}
t2=(C_word)C_a_i_list(&a,2,lf[219],((C_word*)t0)[4]);
/* posixwin.scm: 1350 process-spawn */
t3=((C_word*)t0)[3];
((C_proc5)(void*)(*((C_word*)t3+1)))(5,t3,((C_word*)t0)[2],*((C_word*)lf[207]+1),t1,t2);}

/* get-shell in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2445(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2445,2,t0,t1);}
t2=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t3=*((C_word*)lf[177]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,(C_word)stub416(t2),C_fix(0));}

/* current-process-id in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2442(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2442,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub414(C_SCHEME_UNDEFINED));}

/* process-spawn in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2361(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+7)){
C_save_and_reclaim((void*)tr4rv,(void*)f_2361r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_2361r(t0,t1,t2,t3,t4);}}

static void C_ccall f_2361r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(7);
t5=(C_word)C_notvemptyp(t4);
t6=(C_truep(t5)?(C_word)C_slot(t4,C_fix(0)):C_SCHEME_END_OF_LIST);
t7=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2368,a[2]=t6,a[3]=t1,a[4]=t3,a[5]=t2,a[6]=((C_word*)t0)[3],tmp=(C_word)a,a+=7,tmp);
/* posixwin.scm: 1308 pathname-strip-directory */
t8=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t3);}

/* k2366 in process-spawn in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2368(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2368,2,t0,t1);}
t2=(C_word)C_block_size(t1);
t3=f_2353(C_fix(0),t1,t2);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2376,a[2]=t5,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],tmp=(C_word)a,a+=6,tmp));
t7=((C_word*)t5)[1];
f_2376(t7,((C_word*)t0)[3],((C_word*)t0)[2],C_fix(1));}

/* do401 in k2366 in process-spawn in k673 in k670 in k667 in k664 in k661 */
static void C_fcall f_2376(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a;
loop:
a=C_alloc(8);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_2376,NULL,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
t4=f_2353(t3,C_SCHEME_FALSE,C_fix(0));
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2390,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2409,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1315 ##sys#expand-home-path */
t7=*((C_word*)lf[35]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,((C_word*)t0)[3]);}
else{
t4=(C_word)C_u_i_car(t2);
t5=(C_word)C_block_size(t4);
t6=f_2353(t3,t4,t5);
t7=(C_word)C_slot(t2,C_fix(1));
t8=(C_word)C_u_fixnum_plus(t3,C_fix(1));
t13=t1;
t14=t7;
t15=t8;
t1=t13;
t2=t14;
t3=t15;
goto loop;}}

/* k2407 in do401 in k2366 in process-spawn in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2409(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1315 ##sys#make-c-string */
t2=*((C_word*)lf[34]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2388 in do401 in k2366 in process-spawn in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2390(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2390,2,t0,t1);}
t2=(C_word)C_spawnvp(((C_word*)t0)[4],t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2393,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1316 ##sys#update-errno */
t4=*((C_word*)lf[33]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k2391 in k2388 in do401 in k2366 in process-spawn in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2393(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2393,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2396,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_eqp(((C_word*)t0)[3],C_fix(-1));
if(C_truep(t3)){
t4=(C_word)stub394(C_SCHEME_UNDEFINED);
/* posixwin.scm: 1319 ##sys#error */
t5=*((C_word*)lf[91]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t2,lf[213],lf[214],((C_word*)t0)[2]);}
else{
t4=t2;
f_2396(2,t4,C_SCHEME_UNDEFINED);}}

/* k2394 in k2391 in k2388 in do401 in k2366 in process-spawn in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2396(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* setarg in k673 in k670 in k667 in k664 in k661 */
static C_word C_fcall f_2353(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
t4=(C_truep(t2)?t2:C_SCHEME_FALSE);
return((C_word)stub387(C_SCHEME_UNDEFINED,t1,t4,t3));}

/* process-execute in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2221(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+11)){
C_save_and_reclaim((void*)tr3r,(void*)f_2221r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_2221r(t0,t1,t2,t3);}}

static void C_ccall f_2221r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(11);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2223,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2303,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2308,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
/* def-arglist354376 */
t7=t6;
f_2308(t7,t1);}
else{
t7=(C_word)C_u_i_car(t3);
t8=(C_word)C_slot(t3,C_fix(1));
if(C_truep((C_word)C_i_nullp(t8))){
/* def-envlist355374 */
t9=t5;
f_2303(t9,t1,t7);}
else{
t9=(C_word)C_u_i_car(t8);
t10=(C_word)C_slot(t8,C_fix(1));
/* body352357 */
t11=t4;
f_2223(t11,t1,t7);}}}

/* def-arglist354 in process-execute in k673 in k670 in k667 in k664 in k661 */
static void C_fcall f_2308(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2308,NULL,2,t0,t1);}
/* def-envlist355374 */
t2=((C_word*)t0)[2];
f_2303(t2,t1,C_SCHEME_END_OF_LIST);}

/* def-envlist355 in process-execute in k673 in k670 in k667 in k664 in k661 */
static void C_fcall f_2303(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2303,NULL,3,t0,t1,t2);}
/* body352357 */
t3=((C_word*)t0)[2];
f_2223(t3,t1,t2);}

/* body352 in process-execute in k673 in k670 in k667 in k664 in k661 */
static void C_fcall f_2223(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2223,NULL,3,t0,t1,t2);}
t3=(C_word)C_i_pairp(t2);
t4=(C_truep(t3)?(C_word)C_u_i_car(t2):C_SCHEME_END_OF_LIST);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2230,a[2]=t4,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1284 pathname-strip-directory */
t6=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,((C_word*)t0)[3]);}

/* k2228 in body352 in process-execute in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2230(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2230,2,t0,t1);}
t2=(C_word)C_block_size(t1);
t3=f_2213(C_fix(0),t1,t2);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2238,a[2]=t5,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp));
t7=((C_word*)t5)[1];
f_2238(t7,((C_word*)t0)[3],((C_word*)t0)[2],C_fix(1));}

/* do362 in k2228 in body352 in process-execute in k673 in k670 in k667 in k664 in k661 */
static void C_fcall f_2238(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a;
loop:
a=C_alloc(7);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_2238,NULL,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
t4=f_2213(t3,C_SCHEME_FALSE,C_fix(0));
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2252,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2271,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1290 ##sys#expand-home-path */
t7=*((C_word*)lf[35]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,((C_word*)t0)[3]);}
else{
t4=(C_word)C_u_i_car(t2);
t5=(C_word)C_block_size(t4);
t6=f_2213(t3,t4,t5);
t7=(C_word)C_slot(t2,C_fix(1));
t8=(C_word)C_u_fixnum_plus(t3,C_fix(1));
t13=t1;
t14=t7;
t15=t8;
t1=t13;
t2=t14;
t3=t15;
goto loop;}}

/* k2269 in do362 in k2228 in body352 in process-execute in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2271(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1290 ##sys#make-c-string */
t2=*((C_word*)lf[34]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2250 in do362 in k2228 in body352 in process-execute in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2252(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2252,2,t0,t1);}
t2=(C_word)C_execvp(t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2255,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1291 ##sys#update-errno */
t4=*((C_word*)lf[33]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k2253 in k2250 in do362 in k2228 in body352 in process-execute in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2255(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=(C_word)C_eqp(((C_word*)t0)[4],C_fix(-1));
if(C_truep(t2)){
t3=(C_word)stub345(C_SCHEME_UNDEFINED);
/* posixwin.scm: 1294 ##sys#error */
t4=*((C_word*)lf[91]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,((C_word*)t0)[3],lf[211],lf[212],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* setarg in k673 in k670 in k667 in k664 in k661 */
static C_word C_fcall f_2213(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
t4=(C_truep(t2)?t2:C_SCHEME_FALSE);
return((C_word)stub338(C_SCHEME_UNDEFINED,t1,t4,t3));}

/* glob in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2104(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+9)){
C_save_and_reclaim((void*)tr2r,(void*)f_2104r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2104r(t0,t1,t2);}}

static void C_ccall f_2104r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(9);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2110,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t4,a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp));
t6=((C_word*)t4)[1];
f_2110(t6,t1,t2);}

/* conc in glob in k673 in k670 in k667 in k664 in k661 */
static void C_fcall f_2110(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2110,NULL,3,t0,t1,t2);}
if(C_truep((C_word)C_i_nullp(t2))){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_END_OF_LIST);}
else{
t3=(C_word)C_u_i_car(t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2125,a[2]=t3,a[3]=((C_word*)t0)[6],tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2131,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t2,tmp=(C_word)a,a+=7,tmp);
/* ##sys#call-with-values */
C_u_call_with_values(4,0,t1,t4,t5);}}

/* a2130 in conc in glob in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2131(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_2131,5,t0,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2135,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=t2,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2202,a[2]=t5,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t7=(C_truep(t3)?t3:lf[204]);
/* posixwin.scm: 1254 make-pathname */
t8=((C_word*)t0)[4];
((C_proc5)(void*)(*((C_word*)t8+1)))(5,t8,t6,C_SCHEME_FALSE,t7,t4);}

/* k2200 in a2130 in conc in glob in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2202(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1254 glob->regexp */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2133 in a2130 in conc in glob in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2135(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2135,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2142,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],tmp=(C_word)a,a+=8,tmp);
t3=(C_truep(((C_word*)t0)[4])?((C_word*)t0)[4]:lf[203]);
/* posixwin.scm: 1255 directory */
t4=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t2,t3);}

/* k2140 in k2133 in a2130 in conc in glob in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2142(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2142,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2144,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t3,a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],tmp=(C_word)a,a+=8,tmp));
t5=((C_word*)t3)[1];
f_2144(t5,((C_word*)t0)[2],t1);}

/* loop in k2140 in k2133 in a2130 in conc in glob in k673 in k670 in k667 in k664 in k661 */
static void C_fcall f_2144(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2144,NULL,3,t0,t1,t2);}
if(C_truep((C_word)C_i_nullp(t2))){
t3=(C_word)C_slot(((C_word*)t0)[7],C_fix(1));
/* posixwin.scm: 1256 conc */
t4=((C_word*)((C_word*)t0)[6])[1];
f_2110(t4,t1,t3);}
else{
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2161,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t2,a[6]=t1,tmp=(C_word)a,a+=7,tmp);
t4=(C_word)C_u_i_car(t2);
/* posixwin.scm: 1257 string-match */
t5=*((C_word*)lf[202]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t3,((C_word*)t0)[2],t4);}}

/* k2159 in loop in k2140 in k2133 in a2130 in conc in glob in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2161(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2161,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2171,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],tmp=(C_word)a,a+=5,tmp);
t3=(C_word)C_u_i_car(t1);
/* posixwin.scm: 1258 make-pathname */
t4=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,((C_word*)t0)[2],t3);}
else{
t2=(C_word)C_slot(((C_word*)t0)[5],C_fix(1));
/* posixwin.scm: 1259 loop */
t3=((C_word*)((C_word*)t0)[4])[1];
f_2144(t3,((C_word*)t0)[6],t2);}}

/* k2169 in k2159 in loop in k2140 in k2133 in a2130 in conc in glob in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2171(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2171,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2175,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_slot(((C_word*)t0)[3],C_fix(1));
/* posixwin.scm: 1258 loop */
t4=((C_word*)((C_word*)t0)[2])[1];
f_2144(t4,t2,t3);}

/* k2173 in k2169 in k2159 in loop in k2140 in k2133 in a2130 in conc in glob in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2175(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2175,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* a2124 in conc in glob in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2125(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2125,2,t0,t1);}
/* posixwin.scm: 1253 decompose-pathname */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,((C_word*)t0)[2]);}

/* set-buffering-mode! in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2051(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4rv,(void*)f_2051r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_2051r(t0,t1,t2,t3,t4);}}

static void C_ccall f_2051r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a=C_alloc(5);
t5=(C_word)C_notvemptyp(t4);
t6=(C_truep(t5)?(C_word)C_slot(t4,C_fix(0)):C_fix((C_word)BUFSIZ));
t7=t3;
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2058,a[2]=t1,a[3]=t6,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t9=(C_word)C_eqp(t7,lf[194]);
if(C_truep(t9)){
t10=t8;
f_2058(2,t10,C_fix((C_word)_IOFBF));}
else{
t10=(C_word)C_eqp(t7,lf[195]);
if(C_truep(t10)){
t11=t8;
f_2058(2,t11,C_fix((C_word)_IOLBF));}
else{
t11=(C_word)C_eqp(t7,lf[196]);
if(C_truep(t11)){
t12=t8;
f_2058(2,t12,C_fix((C_word)_IONBF));}
else{
/* posixwin.scm: 1233 ##sys#error */
t12=*((C_word*)lf[91]+1);
((C_proc6)(void*)(*((C_word*)t12+1)))(6,t12,t8,lf[192],lf[197],t3,t2);}}}}

/* k2056 in set-buffering-mode! in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2058(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
t2=(C_word)C_slot(((C_word*)t0)[4],C_fix(7));
t3=(C_word)C_eqp(lf[68],t2);
t4=(C_truep(t3)?(C_word)C_setvbuf(((C_word*)t0)[4],t1,((C_word*)t0)[3]):C_fix(-1));
if(C_truep((C_word)C_fixnum_lessp(t4,C_fix(0)))){
/* posixwin.scm: 1239 ##sys#error */
t5=*((C_word*)lf[91]+1);
((C_proc7)(void*)(*((C_word*)t5+1)))(7,t5,((C_word*)t0)[2],lf[192],lf[193],((C_word*)t0)[4],t1,((C_word*)t0)[3]);}
else{
t5=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_SCHEME_UNDEFINED);}}

/* _exit in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2032(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2rv,(void*)f_2032r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest_vector(a,C_rest_count(0));
f_2032r(t0,t1,t2);}}

static void C_ccall f_2032r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2036,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1217 ##sys#cleanup-before-exit */
t4=*((C_word*)lf[191]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k2034 in _exit in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2036(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
t2=(C_word)C_notvemptyp(((C_word*)t0)[3]);
t3=(C_truep(t2)?(C_word)C_slot(((C_word*)t0)[3],C_fix(0)):C_fix(0));
t4=((C_word*)t0)[2];
t5=t4;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,(C_word)stub291(C_SCHEME_UNDEFINED,t3));}

/* local-time->seconds in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2002(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2002,3,t0,t1,t2);}
t3=(C_word)C_i_check_vector_2(t2,lf[186]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2009,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t5=(C_word)C_block_size(t2);
if(C_truep((C_word)C_fixnum_lessp(t5,C_fix(10)))){
/* posixwin.scm: 1205 ##sys#error */
t6=*((C_word*)lf[91]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t4,lf[186],lf[189],t2);}
else{
t6=t4;
f_2009(2,t6,C_SCHEME_UNDEFINED);}}

/* k2007 in local-time->seconds in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_2009(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_mktime(((C_word*)t0)[3]))){
/* posixwin.scm: 1207 ##sys#cons-flonum */
t2=*((C_word*)lf[187]+1);
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}
else{
/* posixwin.scm: 1208 ##sys#error */
t2=*((C_word*)lf[91]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[186],lf[188],((C_word*)t0)[3]);}}

/* time->string in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1974(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1974,3,t0,t1,t2);}
t3=(C_word)C_i_check_vector_2(t2,lf[183]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1981,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(C_word)C_block_size(t2);
if(C_truep((C_word)C_fixnum_lessp(t5,C_fix(10)))){
/* posixwin.scm: 1198 ##sys#error */
t6=*((C_word*)lf[91]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t4,lf[183],lf[185],t2);}
else{
t6=t4;
f_1981(2,t6,C_SCHEME_UNDEFINED);}}

/* k1979 in time->string in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1981(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1981,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1984,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=((C_word*)t0)[2];
t4=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t5=*((C_word*)lf[177]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t2,(C_word)stub277(t4,t3),C_fix(0));}

/* k1982 in k1979 in time->string in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1984(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1984,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1987,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t1)){
t3=t2;
f_1987(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posixwin.scm: 1200 ##sys#error */
t3=*((C_word*)lf[91]+1);
((C_proc5)(void*)(*((C_word*)t3+1)))(5,t3,t2,lf[183],lf[184],((C_word*)t0)[2]);}}

/* k1985 in k1982 in k1979 in time->string in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1987(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* seconds->string in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1957(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1957,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1961,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=t2;
t5=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t6=*((C_word*)lf[177]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t3,(C_word)stub268(t5,t4),C_fix(0));}

/* k1959 in seconds->string in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1961(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1961,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1964,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t1)){
t3=t2;
f_1964(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posixwin.scm: 1191 ##sys#error */
t3=*((C_word*)lf[91]+1);
((C_proc5)(void*)(*((C_word*)t3+1)))(5,t3,t2,lf[181],lf[182],((C_word*)t0)[2]);}}

/* k1962 in k1959 in seconds->string in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1964(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* seconds->utc-time in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1946(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1946,3,t0,t1,t2);}
/* posixwin.scm: 1185 ##sys#decode-seconds */
t3=*((C_word*)lf[179]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,t2,C_SCHEME_TRUE);}

/* seconds->local-time in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1940(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1940,3,t0,t1,t2);}
/* posixwin.scm: 1181 ##sys#decode-seconds */
t3=*((C_word*)lf[179]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,t2,C_SCHEME_FALSE);}

/* current-environment in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1875(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1875,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1881,a[2]=((C_word*)t0)[2],a[3]=t3,tmp=(C_word)a,a+=4,tmp));
t5=((C_word*)t3)[1];
f_1881(t5,t1,C_fix(0));}

/* loop in current-environment in k673 in k670 in k667 in k664 in k661 */
static void C_fcall f_1881(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1881,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1885,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t4=t2;
t5=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t6=*((C_word*)lf[177]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t3,(C_word)stub253(t5,t4),C_fix(0));}

/* k1883 in loop in current-environment in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1885(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1885,2,t0,t1);}
if(C_truep(t1)){
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_1893,a[2]=t3,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t1,tmp=(C_word)a,a+=7,tmp));
t5=((C_word*)t3)[1];
f_1893(t5,((C_word*)t0)[2],C_fix(0));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_END_OF_LIST);}}

/* scan in k1883 in loop in current-environment in k673 in k670 in k667 in k664 in k661 */
static void C_fcall f_1893(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
loop:
a=C_alloc(8);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_1893,NULL,3,t0,t1,t2);}
t3=(C_word)C_eqp(C_make_character(61),(C_word)C_subchar(((C_word*)t0)[6],t2));
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_1919,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[6],a[4]=t2,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=t1,tmp=(C_word)a,a+=8,tmp);
/* posixwin.scm: 1173 substring */
t5=((C_word*)t0)[3];
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t4,((C_word*)t0)[6],C_fix(0),t2);}
else{
t4=(C_word)C_u_fixnum_plus(t2,C_fix(1));
/* posixwin.scm: 1174 scan */
t7=t1;
t8=t4;
t1=t7;
t2=t8;
goto loop;}}

/* k1917 in scan in k1883 in loop in current-environment in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1919(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1919,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1923,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t3=(C_word)C_u_fixnum_plus(((C_word*)t0)[4],C_fix(1));
t4=(C_word)C_block_size(((C_word*)t0)[3]);
/* posixwin.scm: 1173 substring */
t5=((C_word*)t0)[2];
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t2,((C_word*)t0)[3],t3,t4);}

/* k1921 in k1917 in scan in k1883 in loop in current-environment in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1923(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1923,2,t0,t1);}
t2=(C_word)C_a_i_cons(&a,2,((C_word*)t0)[5],t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1911,a[2]=t2,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_u_fixnum_plus(((C_word*)t0)[3],C_fix(1));
/* posixwin.scm: 1173 loop */
t5=((C_word*)((C_word*)t0)[2])[1];
f_1881(t5,t3,t4);}

/* k1909 in k1921 in k1917 in scan in k1883 in loop in current-environment in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1911(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1911,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* unsetenv in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1863(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1863,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1868,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1161 ##sys#make-c-string */
t4=*((C_word*)lf[34]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,t2);}

/* k1866 in unsetenv in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1868(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_putenv(t1);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}

/* setenv in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1852(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_1852,4,t0,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1857,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1156 ##sys#make-c-string */
t5=*((C_word*)lf[34]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k1855 in setenv in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1857(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1857,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1861,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1156 ##sys#make-c-string */
t3=*((C_word*)lf[34]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

/* k1859 in k1855 in setenv in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1861(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_setenv(((C_word*)t0)[3],t1);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}

/* duplicate-fileno in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1828(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3rv,(void*)f_1828r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_1828r(t0,t1,t2,t3);}}

static void C_ccall f_1828r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1832,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_vemptyp(t3))){
t5=t4;
f_1832(t5,(C_word)C_dup(t2));}
else{
t5=(C_word)C_slot(t3,C_fix(0));
t6=t4;
f_1832(t6,(C_word)C_dup2(t2,t5));}}

/* k1830 in duplicate-fileno in k673 in k670 in k667 in k664 in k661 */
static void C_fcall f_1832(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1832,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1835,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1841,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1146 ##sys#update-errno */
t4=*((C_word*)lf[33]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t2;
f_1835(2,t3,C_SCHEME_UNDEFINED);}}

/* k1839 in k1830 in duplicate-fileno in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1841(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1147 ##sys#signal-hook */
t2=*((C_word*)lf[30]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[31],lf[171],lf[172],((C_word*)t0)[2]);}

/* k1833 in k1830 in duplicate-fileno in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1835(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* port->fileno in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1796(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1796,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1826,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1129 ##sys#peek-unsigned-integer */
t4=*((C_word*)lf[170]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,t2,C_fix(0));}

/* k1824 in port->fileno in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1826(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1826,2,t0,t1);}
if(C_truep((C_word)C_i_zerop(t1))){
/* posixwin.scm: 1135 ##sys#signal-hook */
t2=*((C_word*)lf[30]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[41],lf[167],lf[168],((C_word*)t0)[2]);}
else{
t2=(C_word)C_C_fileno(((C_word*)t0)[2]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1806,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1812,a[2]=((C_word*)t0)[2],a[3]=t3,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1132 ##sys#update-errno */
t5=*((C_word*)lf[33]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t3;
f_1806(2,t4,C_SCHEME_UNDEFINED);}}}

/* k1810 in k1824 in port->fileno in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1812(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1133 ##sys#signal-hook */
t2=*((C_word*)lf[30]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[31],lf[167],lf[169],((C_word*)t0)[2]);}

/* k1804 in k1824 in port->fileno in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1806(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* open-output-file* in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1785(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_1785r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_1785r(t0,t1,t2,t3);}}

static void C_ccall f_1785r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1794,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1124 mode */
f_1719(t4,C_SCHEME_FALSE,t3);}

/* k1792 in open-output-file* in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1794(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1794,2,t0,t1);}
t2=(C_word)C_fdopen(&a,2,((C_word*)t0)[4],t1);
/* posixwin.scm: 1124 check */
f_1756(((C_word*)t0)[2],((C_word*)t0)[4],C_SCHEME_FALSE,t2);}

/* open-input-file* in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1774(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_1774r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_1774r(t0,t1,t2,t3);}}

static void C_ccall f_1774r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1783,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1120 mode */
f_1719(t4,C_SCHEME_TRUE,t3);}

/* k1781 in open-input-file* in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1783(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1783,2,t0,t1);}
t2=(C_word)C_fdopen(&a,2,((C_word*)t0)[4],t1);
/* posixwin.scm: 1120 check */
f_1756(((C_word*)t0)[2],((C_word*)t0)[4],C_SCHEME_TRUE,t2);}

/* check in k673 in k670 in k667 in k664 in k661 */
static void C_fcall f_1756(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1756,NULL,4,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1760,a[2]=t3,a[3]=t2,a[4]=t1,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1111 ##sys#update-errno */
t6=*((C_word*)lf[33]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}

/* k1758 in check in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1760(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1760,2,t0,t1);}
if(C_truep((C_word)C_null_pointerp(((C_word*)t0)[5]))){
/* posixwin.scm: 1113 ##sys#signal-hook */
t2=*((C_word*)lf[30]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[4],lf[31],lf[163],((C_word*)t0)[3]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1772,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1114 ##sys#make-port */
t3=*((C_word*)lf[94]+1);
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,t2,((C_word*)t0)[2],*((C_word*)lf[95]+1),lf[164],lf[68]);}}

/* k1770 in k1758 in check in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1772(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_set_file_ptr(t1,((C_word*)t0)[3]);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}

/* mode in k673 in k670 in k667 in k664 in k661 */
static void C_fcall f_1719(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1719,NULL,3,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1727,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_pairp(t3))){
t5=(C_word)C_u_i_car(t3);
t6=(C_word)C_eqp(t5,lf[157]);
if(C_truep(t6)){
t7=t2;
if(C_truep(t7)){
/* posixwin.scm: 1106 ##sys#error */
t8=*((C_word*)lf[91]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t4,lf[158],t5);}
else{
t8=t4;
f_1727(2,t8,lf[159]);}}
else{
/* posixwin.scm: 1107 ##sys#error */
t7=*((C_word*)lf[91]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t4,lf[160],t5);}}
else{
t5=t4;
f_1727(2,t5,(C_truep(t2)?lf[161]:lf[162]));}}

/* k1725 in mode in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1727(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1102 ##sys#make-c-string */
t2=*((C_word*)lf[34]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* file-execute-access? in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1710(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1710,3,t0,t1,t2);}
/* posixwin.scm: 1086 check */
f_1677(t1,t2,C_fix((C_word)2));}

/* file-write-access? in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1704(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1704,3,t0,t1,t2);}
/* posixwin.scm: 1085 check */
f_1677(t1,t2,C_fix((C_word)4));}

/* file-read-access? in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1698(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1698,3,t0,t1,t2);}
/* posixwin.scm: 1084 check */
f_1677(t1,t2,C_fix((C_word)2));}

/* check in k673 in k670 in k667 in k664 in k661 */
static void C_fcall f_1677(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1677,NULL,3,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1692,a[2]=t1,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1696,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1081 ##sys#expand-home-path */
t6=*((C_word*)lf[35]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}

/* k1694 in check in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1696(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1081 ##sys#make-c-string */
t2=*((C_word*)lf[34]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1690 in check in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1692(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1692,2,t0,t1);}
t2=(C_word)C_access(t1,((C_word*)t0)[3]);
t3=(C_word)C_eqp(C_fix(0),t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1684,a[2]=t3,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t3)){
t5=t4;
f_1684(2,t5,C_SCHEME_UNDEFINED);}
else{
/* posixwin.scm: 1082 ##sys#update-errno */
t5=*((C_word*)lf[33]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}}

/* k1682 in k1690 in check in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1684(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* change-file-mode in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1653(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_1653,4,t0,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1671,a[2]=t2,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1675,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1070 ##sys#expand-home-path */
t6=*((C_word*)lf[35]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}

/* k1673 in change-file-mode in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1675(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1070 ##sys#make-c-string */
t2=*((C_word*)lf[34]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1669 in change-file-mode in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1671(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1671,2,t0,t1);}
t2=(C_word)C_chmod(t1,((C_word*)t0)[4]);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1663,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1071 ##sys#update-errno */
t4=*((C_word*)lf[33]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k1661 in k1669 in change-file-mode in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1663(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1072 ##sys#signal-hook */
t2=*((C_word*)lf[30]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[4],lf[31],lf[149],lf[150],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* create-pipe in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1597(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1597,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1601,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_pipe(C_SCHEME_FALSE),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1610,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 978  ##sys#update-errno */
t4=*((C_word*)lf[33]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t2;
f_1601(2,t3,C_SCHEME_UNDEFINED);}}

/* k1608 in create-pipe in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1610(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 979  ##sys#signal-hook */
t2=*((C_word*)lf[30]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[31],lf[109],lf[110]);}

/* k1599 in create-pipe in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1601(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 980  values */
C_values(4,0,((C_word*)t0)[2],C_fix((C_word)C_pipefds[ 0 ]),C_fix((C_word)C_pipefds[ 1 ]));}

/* with-output-to-pipe in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1577(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4r,(void*)f_1577r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_1577r(t0,t1,t2,t3,t4);}}

static void C_ccall f_1577r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t5=*((C_word*)lf[108]+1);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1581,a[2]=t3,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t5,tmp=(C_word)a,a+=6,tmp);
C_apply(5,0,t6,((C_word*)t0)[2],t2,t4);}

/* k1579 in with-output-to-pipe in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1581(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1581,2,t0,t1);}
t2=C_mutate((C_word*)lf[108]+1,t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1587,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 963  ##sys#call-with-values */
C_u_call_with_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t3);}

/* a1586 in k1579 in with-output-to-pipe in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1587(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr2r,(void*)f_1587r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_1587r(t0,t1,t2);}}

static void C_ccall f_1587r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1591,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 965  close-output-pipe */
t4=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k1589 in a1586 in k1579 in with-output-to-pipe in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1591(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate((C_word*)lf[108]+1,((C_word*)t0)[4]);
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* with-input-from-pipe in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1557(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4r,(void*)f_1557r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_1557r(t0,t1,t2,t3,t4);}}

static void C_ccall f_1557r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t5=*((C_word*)lf[106]+1);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1561,a[2]=t3,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t5,tmp=(C_word)a,a+=6,tmp);
C_apply(5,0,t6,((C_word*)t0)[2],t2,t4);}

/* k1559 in with-input-from-pipe in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1561(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1561,2,t0,t1);}
t2=C_mutate((C_word*)lf[106]+1,t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1567,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 953  ##sys#call-with-values */
C_u_call_with_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t3);}

/* a1566 in k1559 in with-input-from-pipe in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1567(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr2r,(void*)f_1567r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_1567r(t0,t1,t2);}}

static void C_ccall f_1567r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1571,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 955  close-input-pipe */
t4=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k1569 in a1566 in k1559 in with-input-from-pipe in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1571(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate((C_word*)lf[106]+1,((C_word*)t0)[4]);
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* call-with-output-pipe in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1533(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_1533r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_1533r(t0,t1,t2,t3,t4);}}

static void C_ccall f_1533r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1537,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
C_apply(5,0,t5,((C_word*)t0)[2],t2,t4);}

/* k1535 in call-with-output-pipe in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1537(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1537,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1542,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1548,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 943  ##sys#call-with-values */
C_u_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

/* a1547 in k1535 in call-with-output-pipe in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1548(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_1548r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_1548r(t0,t1,t2);}}

static void C_ccall f_1548r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1552,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 946  close-output-pipe */
t4=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k1550 in a1547 in k1535 in call-with-output-pipe in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1552(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* a1541 in k1535 in call-with-output-pipe in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1542(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1542,2,t0,t1);}
/* posixwin.scm: 944  proc */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,((C_word*)t0)[2]);}

/* call-with-input-pipe in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1509(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_1509r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_1509r(t0,t1,t2,t3,t4);}}

static void C_ccall f_1509r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1513,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
C_apply(5,0,t5,((C_word*)t0)[2],t2,t4);}

/* k1511 in call-with-input-pipe in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1513(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1513,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1518,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1524,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 935  ##sys#call-with-values */
C_u_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

/* a1523 in k1511 in call-with-input-pipe in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1524(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_1524r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_1524r(t0,t1,t2);}}

static void C_ccall f_1524r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1528,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 938  close-input-pipe */
t4=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k1526 in a1523 in k1511 in call-with-input-pipe in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1528(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* a1517 in k1511 in call-with-input-pipe in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1518(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1518,2,t0,t1);}
/* posixwin.scm: 936  proc */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,((C_word*)t0)[2]);}

/* close-input-pipe in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1493(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1493,3,t0,t1,t2);}
t3=(C_word)close_pipe(t2);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1497,a[2]=t2,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 924  ##sys#update-errno */
t5=*((C_word*)lf[33]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}

/* k1495 in close-input-pipe in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1497(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_eqp(C_fix(-1),((C_word*)t0)[4]);
if(C_truep(t2)){
/* posixwin.scm: 925  ##sys#signal-hook */
t3=*((C_word*)lf[30]+1);
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,((C_word*)t0)[3],lf[31],lf[100],lf[101],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* open-output-pipe in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1460(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+11)){
C_save_and_reclaim((void*)tr3r,(void*)f_1460r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_1460r(t0,t1,t2,t3);}}

static void C_ccall f_1460r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(11);
t4=f_1391(t3);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1471,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t6=(C_word)C_eqp(t4,lf[90]);
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1478,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 917  ##sys#make-c-string */
t8=*((C_word*)lf[34]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}
else{
t7=(C_word)C_eqp(t4,lf[98]);
if(C_truep(t7)){
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1488,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 918  ##sys#make-c-string */
t9=*((C_word*)lf[34]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}
else{
/* posixwin.scm: 919  badmode */
f_1403(t5,t4);}}}

/* k1486 in open-output-pipe in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1488(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1488,2,t0,t1);}
t2=((C_word*)t0)[2];
f_1471(2,t2,(C_word)open_binary_output_pipe(&a,1,t1));}

/* k1476 in open-output-pipe in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1478(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1478,2,t0,t1);}
t2=((C_word*)t0)[2];
f_1471(2,t2,(C_word)open_text_output_pipe(&a,1,t1));}

/* k1469 in open-output-pipe in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1471(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 914  check */
f_1409(((C_word*)t0)[3],((C_word*)t0)[2],C_SCHEME_FALSE,t1);}

/* open-input-pipe in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1427(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+11)){
C_save_and_reclaim((void*)tr3r,(void*)f_1427r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_1427r(t0,t1,t2,t3);}}

static void C_ccall f_1427r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(11);
t4=f_1391(t3);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1438,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t6=(C_word)C_eqp(t4,lf[90]);
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1445,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 907  ##sys#make-c-string */
t8=*((C_word*)lf[34]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}
else{
t7=(C_word)C_eqp(t4,lf[98]);
if(C_truep(t7)){
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1455,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 908  ##sys#make-c-string */
t9=*((C_word*)lf[34]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}
else{
/* posixwin.scm: 909  badmode */
f_1403(t5,t4);}}}

/* k1453 in open-input-pipe in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1455(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1455,2,t0,t1);}
t2=((C_word*)t0)[2];
f_1438(2,t2,(C_word)open_binary_input_pipe(&a,1,t1));}

/* k1443 in open-input-pipe in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1445(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1445,2,t0,t1);}
t2=((C_word*)t0)[2];
f_1438(2,t2,(C_word)open_text_input_pipe(&a,1,t1));}

/* k1436 in open-input-pipe in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1438(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 904  check */
f_1409(((C_word*)t0)[3],((C_word*)t0)[2],C_SCHEME_TRUE,t1);}

/* check in k673 in k670 in k667 in k664 in k661 */
static void C_fcall f_1409(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1409,NULL,4,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1413,a[2]=t3,a[3]=t2,a[4]=t1,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 894  ##sys#update-errno */
t6=*((C_word*)lf[33]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}

/* k1411 in check in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1413(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1413,2,t0,t1);}
if(C_truep((C_word)C_null_pointerp(((C_word*)t0)[5]))){
/* posixwin.scm: 896  ##sys#signal-hook */
t2=*((C_word*)lf[30]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[4],lf[31],lf[93],((C_word*)t0)[3]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1425,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 897  ##sys#make-port */
t3=*((C_word*)lf[94]+1);
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,t2,((C_word*)t0)[2],*((C_word*)lf[95]+1),lf[96],lf[68]);}}

/* k1423 in k1411 in check in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1425(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_set_file_ptr(t1,((C_word*)t0)[3]);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}

/* badmode in k673 in k670 in k667 in k664 in k661 */
static void C_fcall f_1403(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1403,NULL,2,t1,t2);}
/* posixwin.scm: 892  ##sys#error */
t3=*((C_word*)lf[91]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,lf[92],t2);}

/* mode in k673 in k670 in k667 in k664 in k661 */
static C_word C_fcall f_1391(C_word t1){
C_word tmp;
C_word t2;
C_word t3;
t2=(C_word)C_i_pairp(t1);
return((C_truep(t2)?(C_word)C_slot(t1,C_fix(0)):lf[90]));}

/* current-directory in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1348(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_1348r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_1348r(t0,t1,t2);}}

static void C_ccall f_1348r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1352,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t2))){
t4=t3;
f_1352(t4,C_SCHEME_FALSE);}
else{
t4=(C_word)C_slot(t2,C_fix(1));
t5=(C_word)C_i_nullp(t4);
t6=t3;
f_1352(t6,(C_truep(t5)?(C_word)C_u_i_car(t2):C_SCHEME_TRUE));}}

/* k1350 in current-directory in k673 in k670 in k667 in k664 in k661 */
static void C_fcall f_1352(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1352,NULL,2,t0,t1);}
if(C_truep(t1)){
/* posixwin.scm: 879  change-directory */
t2=*((C_word*)lf[78]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[3],t1);}
else{
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1361,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 880  make-string */
t3=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,C_fix(256));}}

/* k1359 in k1350 in current-directory in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1361(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1361,2,t0,t1);}
t2=(C_word)C_curdir(t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1364,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 882  ##sys#update-errno */
t4=*((C_word*)lf[33]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k1362 in k1359 in k1350 in current-directory in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1364(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(((C_word*)t0)[4])){
/* posixwin.scm: 884  ##sys#substring */
t2=*((C_word*)lf[48]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],((C_word*)t0)[2],C_fix(0),((C_word*)t0)[4]);}
else{
/* posixwin.scm: 885  ##sys#signal-hook */
t2=*((C_word*)lf[30]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[31],lf[87],lf[89]);}}

/* directory? in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1328(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1328,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1332,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1346,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 872  ##sys#expand-home-path */
t5=*((C_word*)lf[35]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k1344 in directory? in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1346(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 872  ##sys#file-info */
t2=*((C_word*)lf[64]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1330 in directory? in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1332(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(t1,C_fix(4));
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_eqp(C_fix(1),t2));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* directory in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1174(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+9)){
C_save_and_reclaim((void*)tr2r,(void*)f_1174r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_1174r(t0,t1,t2);}}

static void C_ccall f_1174r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(9);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1176,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1274,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1279,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_nullp(t2))){
/* def-spec89114 */
t6=t5;
f_1279(t6,t1);}
else{
t6=(C_word)C_u_i_car(t2);
t7=(C_word)C_slot(t2,C_fix(1));
if(C_truep((C_word)C_i_nullp(t7))){
/* def-show-dotfiles?90112 */
t8=t4;
f_1274(t8,t1,t6);}
else{
t8=(C_word)C_u_i_car(t7);
t9=(C_word)C_slot(t7,C_fix(1));
/* body8792 */
t10=t3;
f_1176(t10,t1,t6,t8);}}}

/* def-spec89 in directory in k673 in k670 in k667 in k664 in k661 */
static void C_fcall f_1279(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1279,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1287,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 843  current-directory */
t3=*((C_word*)lf[87]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

/* k1285 in def-spec89 in directory in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1287(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* def-show-dotfiles?90112 */
t2=((C_word*)t0)[3];
f_1274(t2,((C_word*)t0)[2],t1);}

/* def-show-dotfiles?90 in directory in k673 in k670 in k667 in k664 in k661 */
static void C_fcall f_1274(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1274,NULL,3,t0,t1,t2);}
/* body8792 */
t3=((C_word*)t0)[2];
f_1176(t3,t1,t2,C_SCHEME_FALSE);}

/* body87 in directory in k673 in k670 in k667 in k664 in k661 */
static void C_fcall f_1176(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1176,NULL,4,t0,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1180,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 845  make-string */
t5=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,C_fix(256));}

/* k1178 in body87 in directory in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1180(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1180,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1183,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 846  ##sys#make-pointer */
t3=*((C_word*)lf[86]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

/* k1181 in k1178 in body87 in directory in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1183(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1183,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_1186,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t1,tmp=(C_word)a,a+=7,tmp);
/* posixwin.scm: 847  ##sys#make-pointer */
t3=*((C_word*)lf[86]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

/* k1184 in k1181 in k1178 in body87 in directory in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1186(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1186,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_1190,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1273,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 848  ##sys#expand-home-path */
t4=*((C_word*)lf[35]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[4]);}

/* k1271 in k1184 in k1181 in k1178 in body87 in directory in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1273(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 848  ##sys#make-c-string */
t2=*((C_word*)lf[34]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1188 in k1184 in k1181 in k1178 in body87 in directory in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1190(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1190,2,t0,t1);}
t2=(C_word)C_opendir(t1,((C_word*)t0)[7]);
if(C_truep((C_word)C_null_pointerp(((C_word*)t0)[7]))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1199,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 851  ##sys#update-errno */
t4=*((C_word*)lf[33]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_1207,a[2]=((C_word*)t0)[2],a[3]=t4,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[7],tmp=(C_word)a,a+=7,tmp));
t6=((C_word*)t4)[1];
f_1207(t6,((C_word*)t0)[6]);}}

/* loop in k1188 in k1184 in k1181 in k1178 in body87 in directory in k673 in k670 in k667 in k664 in k661 */
static void C_fcall f_1207(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1207,NULL,2,t0,t1);}
t2=(C_word)C_readdir(((C_word*)t0)[6],((C_word*)t0)[5]);
if(C_truep((C_word)C_null_pointerp(((C_word*)t0)[5]))){
t3=(C_word)C_closedir(((C_word*)t0)[6]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_END_OF_LIST);}
else{
t3=(C_word)C_foundfile(((C_word*)t0)[5],((C_word*)t0)[4]);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1217,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t3,tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 860  ##sys#substring */
t5=*((C_word*)lf[48]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t4,((C_word*)t0)[4],C_fix(0),t3);}}

/* k1215 in loop in k1188 in k1184 in k1181 in k1178 in body87 in directory in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1217(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1217,2,t0,t1);}
t2=(C_word)C_subchar(t1,C_fix(0));
t3=(C_word)C_i_greaterp(((C_word*)t0)[5],C_fix(1));
t4=(C_truep(t3)?(C_word)C_subchar(t1,C_fix(1)):C_SCHEME_FALSE);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1229,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t6=(C_word)C_eqp(t2,C_make_character(46));
if(C_truep(t6)){
t7=(C_word)C_i_not(t4);
if(C_truep(t7)){
t8=t5;
f_1229(t8,t7);}
else{
t8=(C_word)C_eqp(t4,C_make_character(46));
t9=(C_truep(t8)?(C_word)C_eqp(((C_word*)t0)[5],C_fix(2)):C_SCHEME_FALSE);
t10=t5;
f_1229(t10,(C_truep(t9)?t9:(C_word)C_i_not(((C_word*)t0)[2])));}}
else{
t7=t5;
f_1229(t7,C_SCHEME_FALSE);}}

/* k1227 in k1215 in loop in k1188 in k1184 in k1181 in k1178 in body87 in directory in k673 in k670 in k667 in k664 in k661 */
static void C_fcall f_1229(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1229,NULL,2,t0,t1);}
if(C_truep(t1)){
/* posixwin.scm: 867  loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_1207(t2,((C_word*)t0)[3]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1239,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 868  loop */
t3=((C_word*)((C_word*)t0)[4])[1];
f_1207(t3,t2);}}

/* k1237 in k1227 in k1215 in loop in k1188 in k1184 in k1181 in k1178 in body87 in directory in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1239(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1239,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* k1197 in k1188 in k1184 in k1181 in k1178 in body87 in directory in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1199(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 852  ##sys#signal-hook */
t2=*((C_word*)lf[30]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[31],lf[84],lf[85],((C_word*)t0)[2]);}

/* delete-directory in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1150(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1150,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1168,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1172,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 835  ##sys#expand-home-path */
t5=*((C_word*)lf[35]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k1170 in delete-directory in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1172(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 835  ##sys#make-c-string */
t2=*((C_word*)lf[34]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1166 in delete-directory in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1168(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1168,2,t0,t1);}
t2=(C_word)C_rmdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1160,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 836  ##sys#update-errno */
t4=*((C_word*)lf[33]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k1158 in k1166 in delete-directory in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1160(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 837  ##sys#signal-hook */
t2=*((C_word*)lf[30]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[31],lf[80],lf[81],((C_word*)t0)[2]);}

/* change-directory in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1126(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1126,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1144,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1148,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 828  ##sys#expand-home-path */
t5=*((C_word*)lf[35]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k1146 in change-directory in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1148(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 828  ##sys#make-c-string */
t2=*((C_word*)lf[34]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1142 in change-directory in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1144(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1144,2,t0,t1);}
t2=(C_word)C_chdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1136,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 829  ##sys#update-errno */
t4=*((C_word*)lf[33]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k1134 in k1142 in change-directory in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1136(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 830  ##sys#signal-hook */
t2=*((C_word*)lf[30]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[31],lf[78],lf[79],((C_word*)t0)[2]);}

/* create-directory in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1102(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1102,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1120,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1124,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 821  ##sys#expand-home-path */
t5=*((C_word*)lf[35]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k1122 in create-directory in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1124(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 821  ##sys#make-c-string */
t2=*((C_word*)lf[34]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1118 in create-directory in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1120(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1120,2,t0,t1);}
t2=(C_word)C_mkdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1112,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 822  ##sys#update-errno */
t4=*((C_word*)lf[33]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k1110 in k1118 in create-directory in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1112(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 823  ##sys#signal-hook */
t2=*((C_word*)lf[30]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[31],lf[76],lf[77],((C_word*)t0)[2]);}

/* set-file-position! in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1047(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4rv,(void*)f_1047r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_1047r(t0,t1,t2,t3,t4);}}

static void C_ccall f_1047r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(6);
t5=(C_word)C_notvemptyp(t4);
t6=(C_truep(t5)?(C_word)C_slot(t4,C_fix(0)):C_fix((C_word)SEEK_SET));
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1054,a[2]=t6,a[3]=t3,a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
if(C_truep((C_word)C_fixnum_lessp(t3,C_fix(0)))){
/* posixwin.scm: 806  ##sys#signal-hook */
t8=*((C_word*)lf[30]+1);
((C_proc7)(void*)(*((C_word*)t8+1)))(7,t8,t7,lf[74],lf[71],lf[75],t3,t2);}
else{
t8=t7;
f_1054(2,t8,C_SCHEME_UNDEFINED);}}

/* k1052 in set-file-position! in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1054(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1054,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1060,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1069,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 807  port? */
t4=*((C_word*)lf[70]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[4]);}

/* k1067 in k1052 in set-file-position! in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1069(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(((C_word*)t0)[5],C_fix(7));
t3=(C_word)C_eqp(t2,lf[68]);
t4=((C_word*)t0)[4];
f_1060(2,t4,(C_truep(t3)?(C_word)C_fseek(((C_word*)t0)[5],((C_word*)t0)[3],((C_word*)t0)[2]):C_SCHEME_FALSE));}
else{
if(C_truep((C_word)C_fixnump(((C_word*)t0)[5]))){
t2=((C_word*)t0)[4];
f_1060(2,t2,(C_word)C_lseek(((C_word*)t0)[5],((C_word*)t0)[3],((C_word*)t0)[2]));}
else{
/* posixwin.scm: 811  ##sys#signal-hook */
t2=*((C_word*)lf[30]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[41],lf[71],lf[73],((C_word*)t0)[5]);}}}

/* k1058 in k1052 in set-file-position! in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1060(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1060,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}
else{
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1063,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 812  ##sys#update-errno */
t3=*((C_word*)lf[33]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

/* k1061 in k1058 in k1052 in set-file-position! in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1063(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 813  ##sys#signal-hook */
t2=*((C_word*)lf[30]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[4],lf[31],lf[71],lf[72],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* file-position in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1007(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1007,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1011,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1026,a[2]=t3,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 790  port? */
t5=*((C_word*)lf[70]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k1024 in file-position in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1026(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(((C_word*)t0)[3],C_fix(7));
t3=(C_word)C_eqp(t2,lf[68]);
t4=((C_word*)t0)[2];
f_1011(2,t4,(C_truep(t3)?(C_word)C_ftell(((C_word*)t0)[3]):C_fix(-1)));}
else{
if(C_truep((C_word)C_fixnump(((C_word*)t0)[3]))){
t2=((C_word*)t0)[2];
f_1011(2,t2,(C_word)C_lseek(((C_word*)t0)[3],C_fix(0),C_fix((C_word)SEEK_CUR)));}
else{
/* posixwin.scm: 795  ##sys#signal-hook */
t2=*((C_word*)lf[30]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[2],lf[41],lf[66],lf[69],((C_word*)t0)[3]);}}}

/* k1009 in file-position in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1011(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1011,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1014,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1020,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 797  ##sys#update-errno */
t4=*((C_word*)lf[33]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t2;
f_1014(2,t3,C_SCHEME_UNDEFINED);}}

/* k1018 in k1009 in file-position in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1020(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 798  ##sys#signal-hook */
t2=*((C_word*)lf[30]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[31],lf[66],lf[67],((C_word*)t0)[2]);}

/* k1012 in k1009 in file-position in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1014(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* symbolic-link? in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1004(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1004,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_FALSE);}

/* regular-file? in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_984(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_984,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_988,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1002,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 781  ##sys#expand-home-path */
t5=*((C_word*)lf[35]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k1000 in regular-file? in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_1002(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 781  ##sys#file-info */
t2=*((C_word*)lf[64]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k986 in regular-file? in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_988(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(t1,C_fix(4));
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_eqp(C_fix(0),t2));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* file-permissions in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_978(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_978,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_982,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 777  ##sys#stat */
f_882(t3,t2);}

/* k980 in file-permissions in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_982(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_mode));}

/* file-owner in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_972(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_972,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_976,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 776  ##sys#stat */
f_882(t3,t2);}

/* k974 in file-owner in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_976(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_uid));}

/* file-change-time in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_966(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_966,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_970,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 775  ##sys#stat */
f_882(t3,t2);}

/* k968 in file-change-time in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_970(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_970,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_ctime));}

/* file-access-time in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_960(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_960,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_964,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 774  ##sys#stat */
f_882(t3,t2);}

/* k962 in file-access-time in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_964(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_964,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_atime));}

/* file-modification-time in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_954(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_954,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_958,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 773  ##sys#stat */
f_882(t3,t2);}

/* k956 in file-modification-time in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_958(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_958,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_mtime));}

/* file-size in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_948(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_948,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_952,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 772  ##sys#stat */
f_882(t3,t2);}

/* k950 in file-size in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_952(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_size));}

/* file-stat in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_920(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f_920r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_920r(t0,t1,t2,t3);}}

static void C_ccall f_920r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(4);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_924,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
t5=t4;
f_924(t5,C_SCHEME_FALSE);}
else{
t5=(C_word)C_slot(t3,C_fix(1));
t6=(C_word)C_i_nullp(t5);
t7=t4;
f_924(t7,(C_truep(t6)?(C_word)C_u_i_car(t3):C_SCHEME_TRUE));}}

/* k922 in file-stat in k673 in k670 in k667 in k664 in k661 */
static void C_fcall f_924(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_924,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_927,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 767  ##sys#stat */
f_882(t2,((C_word*)t0)[2]);}

/* k925 in k922 in file-stat in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_927(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[22],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_927,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_vector(&a,9,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_ino),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_mode),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_nlink),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_uid),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_gid),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_size),C_flonum(&a,C_statbuf.st_atime),C_flonum(&a,C_statbuf.st_ctime),C_flonum(&a,C_statbuf.st_mtime)));}

/* ##sys#stat in k673 in k670 in k667 in k664 in k661 */
static void C_fcall f_882(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_882,NULL,2,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_886,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnump(t2))){
t4=t3;
f_886(2,t4,(C_word)C_fstat(t2));}
else{
if(C_truep((C_word)C_i_stringp(t2))){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_911,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_915,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 760  ##sys#expand-home-path */
t6=*((C_word*)lf[35]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}
else{
/* posixwin.scm: 761  ##sys#signal-hook */
t4=*((C_word*)lf[30]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,lf[41],lf[55],t2);}}}

/* k913 in ##sys#stat in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_915(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 760  ##sys#make-c-string */
t2=*((C_word*)lf[34]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k909 in ##sys#stat in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_911(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
f_886(2,t2,(C_word)C_stat(t1));}

/* k884 in ##sys#stat in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_886(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_886,2,t0,t1);}
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_895,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 763  ##sys#update-errno */
t3=*((C_word*)lf[33]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

/* k893 in k884 in ##sys#stat in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_895(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 764  ##sys#signal-hook */
t2=*((C_word*)lf[30]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[31],lf[54],((C_word*)t0)[2]);}

/* file-mkstemp in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_847(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_847,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_851,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 729  ##sys#make-c-string */
t4=*((C_word*)lf[34]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,t2);}

/* k849 in file-mkstemp in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_851(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_851,2,t0,t1);}
t2=(C_word)C_mkstemp(t1);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_854,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=t2,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 731  string-length */
t4=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,t1);}

/* k852 in k849 in file-mkstemp in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_854(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_854,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_857,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
t3=(C_word)C_eqp(C_fix(-1),((C_word*)t0)[4]);
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_874,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 733  ##sys#update-errno */
t5=*((C_word*)lf[33]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t2;
f_857(2,t4,C_SCHEME_UNDEFINED);}}

/* k872 in k852 in k849 in file-mkstemp in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_874(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 734  ##sys#signal-hook */
t2=*((C_word*)lf[30]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[31],lf[47],lf[49],((C_word*)t0)[2]);}

/* k855 in k852 in k849 in file-mkstemp in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_857(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_857,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_864,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_u_fixnum_difference(((C_word*)t0)[3],C_fix(1));
/* posixwin.scm: 735  ##sys#substring */
t4=*((C_word*)lf[48]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t2,((C_word*)t0)[2],C_fix(0),t3);}

/* k862 in k855 in k852 in k849 in file-mkstemp in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_864(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 735  values */
C_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* file-write in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_811(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4rv,(void*)f_811r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_811r(t0,t1,t2,t3,t4);}}

static void C_ccall f_811r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_815,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t6=(C_truep((C_word)C_blockp(t3))?(C_word)C_byteblockp(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t5;
f_815(2,t7,C_SCHEME_UNDEFINED);}
else{
/* posixwin.scm: 716  ##sys#signal-hook */
t7=*((C_word*)lf[30]+1);
((C_proc6)(void*)(*((C_word*)t7+1)))(6,t7,t5,lf[41],lf[43],lf[45],t3);}}

/* k813 in file-write in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_815(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_815,2,t0,t1);}
t2=(C_word)C_notvemptyp(((C_word*)t0)[5]);
t3=(C_truep(t2)?(C_word)C_slot(((C_word*)t0)[5],C_fix(0)):(C_word)C_block_size(((C_word*)t0)[4]));
t4=(C_word)C_write(((C_word*)t0)[3],((C_word*)t0)[4],t3);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_821,a[2]=t4,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t6=(C_word)C_eqp(C_fix(-1),t4);
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_827,a[2]=t3,a[3]=((C_word*)t0)[3],a[4]=t5,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 721  ##sys#update-errno */
t8=*((C_word*)lf[33]+1);
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,t7);}
else{
t7=t5;
f_821(2,t7,C_SCHEME_UNDEFINED);}}

/* k825 in k813 in file-write in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_827(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 722  ##sys#signal-hook */
t2=*((C_word*)lf[30]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[4],lf[31],lf[43],lf[44],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k819 in k813 in file-write in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_821(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* file-read in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_772(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4rv,(void*)f_772r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_772r(t0,t1,t2,t3,t4);}}

static void C_ccall f_772r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_776,a[2]=t1,a[3]=t3,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
if(C_truep((C_word)C_notvemptyp(t4))){
t6=t5;
f_776(2,t6,(C_word)C_slot(t4,C_fix(0)));}
else{
/* posixwin.scm: 703  make-string */
t6=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t3);}}

/* k774 in file-read in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_776(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_776,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_779,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t3=(C_truep((C_word)C_blockp(t1))?(C_word)C_byteblockp(t1):C_SCHEME_FALSE);
if(C_truep(t3)){
t4=t2;
f_779(2,t4,C_SCHEME_UNDEFINED);}
else{
/* posixwin.scm: 705  ##sys#signal-hook */
t4=*((C_word*)lf[30]+1);
((C_proc6)(void*)(*((C_word*)t4+1)))(6,t4,t2,lf[41],lf[39],lf[42],t1);}}

/* k777 in k774 in file-read in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_779(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_779,2,t0,t1);}
t2=(C_word)C_read(((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_782,a[2]=t2,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t4=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_791,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[5],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 708  ##sys#update-errno */
t6=*((C_word*)lf[33]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t5=t3;
f_782(2,t5,C_SCHEME_UNDEFINED);}}

/* k789 in k777 in k774 in file-read in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_791(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 709  ##sys#signal-hook */
t2=*((C_word*)lf[30]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[4],lf[31],lf[39],lf[40],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k780 in k777 in k774 in file-read in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_782(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_782,2,t0,t1);}
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_list(&a,2,((C_word*)t0)[3],((C_word*)t0)[2]));}

/* file-close in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_757(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_757,3,t0,t1,t2);}
if(C_truep((C_word)C_fixnum_lessp((C_word)C_close(t2),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_767,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 695  ##sys#update-errno */
t4=*((C_word*)lf[33]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k765 in file-close in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_767(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 696  ##sys#signal-hook */
t2=*((C_word*)lf[30]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[31],lf[36],lf[37],((C_word*)t0)[2]);}

/* file-open in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_725(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+9)){
C_save_and_reclaim((void*)tr4rv,(void*)f_725r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_725r(t0,t1,t2,t3,t4);}}

static void C_ccall f_725r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a=C_alloc(9);
t5=(C_word)C_notvemptyp(t4);
t6=(C_truep(t5)?(C_word)C_slot(t4,C_fix(0)):((C_word*)t0)[2]);
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_733,a[2]=t2,a[3]=t1,a[4]=t6,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_749,a[2]=t7,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 685  ##sys#expand-home-path */
t9=*((C_word*)lf[35]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}

/* k747 in file-open in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_749(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 685  ##sys#make-c-string */
t2=*((C_word*)lf[34]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k731 in file-open in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_733(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_733,2,t0,t1);}
t2=(C_word)C_open(t1,((C_word*)t0)[5],((C_word*)t0)[4]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_736,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_742,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[2],a[5]=t3,tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 687  ##sys#update-errno */
t6=*((C_word*)lf[33]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t5=t3;
f_736(2,t5,C_SCHEME_UNDEFINED);}}

/* k740 in k731 in file-open in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_742(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 688  ##sys#signal-hook */
t2=*((C_word*)lf[30]+1);
((C_proc8)(void*)(*((C_word*)t2+1)))(8,t2,((C_word*)t0)[5],lf[31],lf[29],lf[32],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k734 in k731 in file-open in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_736(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* yield in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_677(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_677,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_683,tmp=(C_word)a,a+=2,tmp);
/* posixwin.scm: 617  ##sys#call-with-current-continuation */
C_call_cc(3,0,t1,t2);}

/* a682 in yield in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_683(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_683,3,t0,t1,t2);}
t3=*((C_word*)lf[3]+1);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_692,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
t5=(C_word)C_i_setslot(t3,C_fix(1),t4);
/* posixwin.scm: 621  ##sys#schedule */
t6=*((C_word*)lf[4]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t1);}

/* a691 in a682 in yield in k673 in k670 in k667 in k664 in k661 */
static void C_ccall f_692(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_692,2,t0,t1);}
/* posixwin.scm: 620  return */
t2=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,C_SCHEME_UNDEFINED);}

#ifdef C_ENABLE_PTABLES
static C_PTABLE_ENTRY ptable[275] = {
{"toplevelposixwin.scm",(void*)C_posix_toplevel},
{"f_663posixwin.scm",(void*)f_663},
{"f_666posixwin.scm",(void*)f_666},
{"f_669posixwin.scm",(void*)f_669},
{"f_672posixwin.scm",(void*)f_672},
{"f_675posixwin.scm",(void*)f_675},
{"f_2716posixwin.scm",(void*)f_2716},
{"f_2864posixwin.scm",(void*)f_2864},
{"f_2870posixwin.scm",(void*)f_2870},
{"f_2859posixwin.scm",(void*)f_2859},
{"f_2854posixwin.scm",(void*)f_2854},
{"f_2718posixwin.scm",(void*)f_2718},
{"f_2841posixwin.scm",(void*)f_2841},
{"f_2849posixwin.scm",(void*)f_2849},
{"f_2722posixwin.scm",(void*)f_2722},
{"f_2829posixwin.scm",(void*)f_2829},
{"f_2732posixwin.scm",(void*)f_2732},
{"f_2734posixwin.scm",(void*)f_2734},
{"f_2753posixwin.scm",(void*)f_2753},
{"f_2815posixwin.scm",(void*)f_2815},
{"f_2822posixwin.scm",(void*)f_2822},
{"f_2809posixwin.scm",(void*)f_2809},
{"f_2768posixwin.scm",(void*)f_2768},
{"f_2799posixwin.scm",(void*)f_2799},
{"f_2785posixwin.scm",(void*)f_2785},
{"f_2797posixwin.scm",(void*)f_2797},
{"f_2793posixwin.scm",(void*)f_2793},
{"f_2780posixwin.scm",(void*)f_2780},
{"f_2778posixwin.scm",(void*)f_2778},
{"f_2833posixwin.scm",(void*)f_2833},
{"f_2685posixwin.scm",(void*)f_2685},
{"f_2711posixwin.scm",(void*)f_2711},
{"f_2696posixwin.scm",(void*)f_2696},
{"f_2700posixwin.scm",(void*)f_2700},
{"f_2704posixwin.scm",(void*)f_2704},
{"f_2708posixwin.scm",(void*)f_2708},
{"f_2673posixwin.scm",(void*)f_2673},
{"f_2670posixwin.scm",(void*)f_2670},
{"f_2631posixwin.scm",(void*)f_2631},
{"f_2650posixwin.scm",(void*)f_2650},
{"f_2483posixwin.scm",(void*)f_2483},
{"f_2586posixwin.scm",(void*)f_2586},
{"f_2581posixwin.scm",(void*)f_2581},
{"f_2485posixwin.scm",(void*)f_2485},
{"f_2577posixwin.scm",(void*)f_2577},
{"f_2492posixwin.scm",(void*)f_2492},
{"f_2564posixwin.scm",(void*)f_2564},
{"f_2567posixwin.scm",(void*)f_2567},
{"f_2570posixwin.scm",(void*)f_2570},
{"f_2557posixwin.scm",(void*)f_2557},
{"f_2554posixwin.scm",(void*)f_2554},
{"f_2530posixwin.scm",(void*)f_2530},
{"f_2505posixwin.scm",(void*)f_2505},
{"f_2524posixwin.scm",(void*)f_2524},
{"f_2511posixwin.scm",(void*)f_2511},
{"f_2509posixwin.scm",(void*)f_2509},
{"f_2480posixwin.scm",(void*)f_2480},
{"f_2451posixwin.scm",(void*)f_2451},
{"f_2468posixwin.scm",(void*)f_2468},
{"f_2445posixwin.scm",(void*)f_2445},
{"f_2442posixwin.scm",(void*)f_2442},
{"f_2361posixwin.scm",(void*)f_2361},
{"f_2368posixwin.scm",(void*)f_2368},
{"f_2376posixwin.scm",(void*)f_2376},
{"f_2409posixwin.scm",(void*)f_2409},
{"f_2390posixwin.scm",(void*)f_2390},
{"f_2393posixwin.scm",(void*)f_2393},
{"f_2396posixwin.scm",(void*)f_2396},
{"f_2353posixwin.scm",(void*)f_2353},
{"f_2221posixwin.scm",(void*)f_2221},
{"f_2308posixwin.scm",(void*)f_2308},
{"f_2303posixwin.scm",(void*)f_2303},
{"f_2223posixwin.scm",(void*)f_2223},
{"f_2230posixwin.scm",(void*)f_2230},
{"f_2238posixwin.scm",(void*)f_2238},
{"f_2271posixwin.scm",(void*)f_2271},
{"f_2252posixwin.scm",(void*)f_2252},
{"f_2255posixwin.scm",(void*)f_2255},
{"f_2213posixwin.scm",(void*)f_2213},
{"f_2104posixwin.scm",(void*)f_2104},
{"f_2110posixwin.scm",(void*)f_2110},
{"f_2131posixwin.scm",(void*)f_2131},
{"f_2202posixwin.scm",(void*)f_2202},
{"f_2135posixwin.scm",(void*)f_2135},
{"f_2142posixwin.scm",(void*)f_2142},
{"f_2144posixwin.scm",(void*)f_2144},
{"f_2161posixwin.scm",(void*)f_2161},
{"f_2171posixwin.scm",(void*)f_2171},
{"f_2175posixwin.scm",(void*)f_2175},
{"f_2125posixwin.scm",(void*)f_2125},
{"f_2051posixwin.scm",(void*)f_2051},
{"f_2058posixwin.scm",(void*)f_2058},
{"f_2032posixwin.scm",(void*)f_2032},
{"f_2036posixwin.scm",(void*)f_2036},
{"f_2002posixwin.scm",(void*)f_2002},
{"f_2009posixwin.scm",(void*)f_2009},
{"f_1974posixwin.scm",(void*)f_1974},
{"f_1981posixwin.scm",(void*)f_1981},
{"f_1984posixwin.scm",(void*)f_1984},
{"f_1987posixwin.scm",(void*)f_1987},
{"f_1957posixwin.scm",(void*)f_1957},
{"f_1961posixwin.scm",(void*)f_1961},
{"f_1964posixwin.scm",(void*)f_1964},
{"f_1946posixwin.scm",(void*)f_1946},
{"f_1940posixwin.scm",(void*)f_1940},
{"f_1875posixwin.scm",(void*)f_1875},
{"f_1881posixwin.scm",(void*)f_1881},
{"f_1885posixwin.scm",(void*)f_1885},
{"f_1893posixwin.scm",(void*)f_1893},
{"f_1919posixwin.scm",(void*)f_1919},
{"f_1923posixwin.scm",(void*)f_1923},
{"f_1911posixwin.scm",(void*)f_1911},
{"f_1863posixwin.scm",(void*)f_1863},
{"f_1868posixwin.scm",(void*)f_1868},
{"f_1852posixwin.scm",(void*)f_1852},
{"f_1857posixwin.scm",(void*)f_1857},
{"f_1861posixwin.scm",(void*)f_1861},
{"f_1828posixwin.scm",(void*)f_1828},
{"f_1832posixwin.scm",(void*)f_1832},
{"f_1841posixwin.scm",(void*)f_1841},
{"f_1835posixwin.scm",(void*)f_1835},
{"f_1796posixwin.scm",(void*)f_1796},
{"f_1826posixwin.scm",(void*)f_1826},
{"f_1812posixwin.scm",(void*)f_1812},
{"f_1806posixwin.scm",(void*)f_1806},
{"f_1785posixwin.scm",(void*)f_1785},
{"f_1794posixwin.scm",(void*)f_1794},
{"f_1774posixwin.scm",(void*)f_1774},
{"f_1783posixwin.scm",(void*)f_1783},
{"f_1756posixwin.scm",(void*)f_1756},
{"f_1760posixwin.scm",(void*)f_1760},
{"f_1772posixwin.scm",(void*)f_1772},
{"f_1719posixwin.scm",(void*)f_1719},
{"f_1727posixwin.scm",(void*)f_1727},
{"f_1710posixwin.scm",(void*)f_1710},
{"f_1704posixwin.scm",(void*)f_1704},
{"f_1698posixwin.scm",(void*)f_1698},
{"f_1677posixwin.scm",(void*)f_1677},
{"f_1696posixwin.scm",(void*)f_1696},
{"f_1692posixwin.scm",(void*)f_1692},
{"f_1684posixwin.scm",(void*)f_1684},
{"f_1653posixwin.scm",(void*)f_1653},
{"f_1675posixwin.scm",(void*)f_1675},
{"f_1671posixwin.scm",(void*)f_1671},
{"f_1663posixwin.scm",(void*)f_1663},
{"f_1597posixwin.scm",(void*)f_1597},
{"f_1610posixwin.scm",(void*)f_1610},
{"f_1601posixwin.scm",(void*)f_1601},
{"f_1577posixwin.scm",(void*)f_1577},
{"f_1581posixwin.scm",(void*)f_1581},
{"f_1587posixwin.scm",(void*)f_1587},
{"f_1591posixwin.scm",(void*)f_1591},
{"f_1557posixwin.scm",(void*)f_1557},
{"f_1561posixwin.scm",(void*)f_1561},
{"f_1567posixwin.scm",(void*)f_1567},
{"f_1571posixwin.scm",(void*)f_1571},
{"f_1533posixwin.scm",(void*)f_1533},
{"f_1537posixwin.scm",(void*)f_1537},
{"f_1548posixwin.scm",(void*)f_1548},
{"f_1552posixwin.scm",(void*)f_1552},
{"f_1542posixwin.scm",(void*)f_1542},
{"f_1509posixwin.scm",(void*)f_1509},
{"f_1513posixwin.scm",(void*)f_1513},
{"f_1524posixwin.scm",(void*)f_1524},
{"f_1528posixwin.scm",(void*)f_1528},
{"f_1518posixwin.scm",(void*)f_1518},
{"f_1493posixwin.scm",(void*)f_1493},
{"f_1497posixwin.scm",(void*)f_1497},
{"f_1460posixwin.scm",(void*)f_1460},
{"f_1488posixwin.scm",(void*)f_1488},
{"f_1478posixwin.scm",(void*)f_1478},
{"f_1471posixwin.scm",(void*)f_1471},
{"f_1427posixwin.scm",(void*)f_1427},
{"f_1455posixwin.scm",(void*)f_1455},
{"f_1445posixwin.scm",(void*)f_1445},
{"f_1438posixwin.scm",(void*)f_1438},
{"f_1409posixwin.scm",(void*)f_1409},
{"f_1413posixwin.scm",(void*)f_1413},
{"f_1425posixwin.scm",(void*)f_1425},
{"f_1403posixwin.scm",(void*)f_1403},
{"f_1391posixwin.scm",(void*)f_1391},
{"f_1348posixwin.scm",(void*)f_1348},
{"f_1352posixwin.scm",(void*)f_1352},
{"f_1361posixwin.scm",(void*)f_1361},
{"f_1364posixwin.scm",(void*)f_1364},
{"f_1328posixwin.scm",(void*)f_1328},
{"f_1346posixwin.scm",(void*)f_1346},
{"f_1332posixwin.scm",(void*)f_1332},
{"f_1174posixwin.scm",(void*)f_1174},
{"f_1279posixwin.scm",(void*)f_1279},
{"f_1287posixwin.scm",(void*)f_1287},
{"f_1274posixwin.scm",(void*)f_1274},
{"f_1176posixwin.scm",(void*)f_1176},
{"f_1180posixwin.scm",(void*)f_1180},
{"f_1183posixwin.scm",(void*)f_1183},
{"f_1186posixwin.scm",(void*)f_1186},
{"f_1273posixwin.scm",(void*)f_1273},
{"f_1190posixwin.scm",(void*)f_1190},
{"f_1207posixwin.scm",(void*)f_1207},
{"f_1217posixwin.scm",(void*)f_1217},
{"f_1229posixwin.scm",(void*)f_1229},
{"f_1239posixwin.scm",(void*)f_1239},
{"f_1199posixwin.scm",(void*)f_1199},
{"f_1150posixwin.scm",(void*)f_1150},
{"f_1172posixwin.scm",(void*)f_1172},
{"f_1168posixwin.scm",(void*)f_1168},
{"f_1160posixwin.scm",(void*)f_1160},
{"f_1126posixwin.scm",(void*)f_1126},
{"f_1148posixwin.scm",(void*)f_1148},
{"f_1144posixwin.scm",(void*)f_1144},
{"f_1136posixwin.scm",(void*)f_1136},
{"f_1102posixwin.scm",(void*)f_1102},
{"f_1124posixwin.scm",(void*)f_1124},
{"f_1120posixwin.scm",(void*)f_1120},
{"f_1112posixwin.scm",(void*)f_1112},
{"f_1047posixwin.scm",(void*)f_1047},
{"f_1054posixwin.scm",(void*)f_1054},
{"f_1069posixwin.scm",(void*)f_1069},
{"f_1060posixwin.scm",(void*)f_1060},
{"f_1063posixwin.scm",(void*)f_1063},
{"f_1007posixwin.scm",(void*)f_1007},
{"f_1026posixwin.scm",(void*)f_1026},
{"f_1011posixwin.scm",(void*)f_1011},
{"f_1020posixwin.scm",(void*)f_1020},
{"f_1014posixwin.scm",(void*)f_1014},
{"f_1004posixwin.scm",(void*)f_1004},
{"f_984posixwin.scm",(void*)f_984},
{"f_1002posixwin.scm",(void*)f_1002},
{"f_988posixwin.scm",(void*)f_988},
{"f_978posixwin.scm",(void*)f_978},
{"f_982posixwin.scm",(void*)f_982},
{"f_972posixwin.scm",(void*)f_972},
{"f_976posixwin.scm",(void*)f_976},
{"f_966posixwin.scm",(void*)f_966},
{"f_970posixwin.scm",(void*)f_970},
{"f_960posixwin.scm",(void*)f_960},
{"f_964posixwin.scm",(void*)f_964},
{"f_954posixwin.scm",(void*)f_954},
{"f_958posixwin.scm",(void*)f_958},
{"f_948posixwin.scm",(void*)f_948},
{"f_952posixwin.scm",(void*)f_952},
{"f_920posixwin.scm",(void*)f_920},
{"f_924posixwin.scm",(void*)f_924},
{"f_927posixwin.scm",(void*)f_927},
{"f_882posixwin.scm",(void*)f_882},
{"f_915posixwin.scm",(void*)f_915},
{"f_911posixwin.scm",(void*)f_911},
{"f_886posixwin.scm",(void*)f_886},
{"f_895posixwin.scm",(void*)f_895},
{"f_847posixwin.scm",(void*)f_847},
{"f_851posixwin.scm",(void*)f_851},
{"f_854posixwin.scm",(void*)f_854},
{"f_874posixwin.scm",(void*)f_874},
{"f_857posixwin.scm",(void*)f_857},
{"f_864posixwin.scm",(void*)f_864},
{"f_811posixwin.scm",(void*)f_811},
{"f_815posixwin.scm",(void*)f_815},
{"f_827posixwin.scm",(void*)f_827},
{"f_821posixwin.scm",(void*)f_821},
{"f_772posixwin.scm",(void*)f_772},
{"f_776posixwin.scm",(void*)f_776},
{"f_779posixwin.scm",(void*)f_779},
{"f_791posixwin.scm",(void*)f_791},
{"f_782posixwin.scm",(void*)f_782},
{"f_757posixwin.scm",(void*)f_757},
{"f_767posixwin.scm",(void*)f_767},
{"f_725posixwin.scm",(void*)f_725},
{"f_749posixwin.scm",(void*)f_749},
{"f_733posixwin.scm",(void*)f_733},
{"f_742posixwin.scm",(void*)f_742},
{"f_736posixwin.scm",(void*)f_736},
{"f_677posixwin.scm",(void*)f_677},
{"f_683posixwin.scm",(void*)f_683},
{"f_692posixwin.scm",(void*)f_692},
{NULL,NULL}};
#endif

static C_PTABLE_ENTRY *create_ptable(void){
#ifdef C_ENABLE_PTABLES
return ptable;
#else
return NULL;
#endif
}
/* end of file */
