/* Output from p2c 1.21alpha-07.Dec.93, the Pascal-to-C translator */
/* From input file "cht-1.7.pp" */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifndef P2C_H
#define P2C_H


/* Header file for code generated by "p2c", the Pascal-to-C translator */

/* "p2c"  Copyright (C) 1989, 1990, 1991, 1992, 1993 Free Software Foundation.
 * By Dave Gillespie, daveg@synaptics.com.  Version 1.21alpha-07.Dec.93.
 * This file may be copied, modified, etc. in any way.  It is not restricted
 * by the licence agreement accompanying p2c itself.
 */


#include <stdio.h>
#include <unistd.h>
#define DOUBLE double



/* If the following heuristic fails, compile -DBSD=0 for non-BSD systems,
   or -DBSD=1 for BSD systems. */

#ifdef M_XENIX
# define BSD 0
#endif

#ifdef vms
# define BSD 0
# ifndef __STDC__
#  define __STDC__ 1
# endif
#endif

#ifdef __TURBOC__
# define MSDOS 1
#endif

#ifdef MSDOS
# define BSD 0
#endif

#ifdef FILE       /* a #define in BSD, a typedef in SYSV (hp-ux, at least) */
# ifndef BSD	  /*  (a convenient, but horrible kludge!) */
#  define BSD 1
# endif
#endif

#ifdef BSD
# if !BSD
#  undef BSD
# endif
#endif


#if (defined(__STDC__) && !defined(M_XENIX)) || defined(__TURBOC__)
# include <stdlib.h>
# include <stddef.h>
# define HAS_STDLIB
# if defined(vms) || defined(__TURBOC__)
#  define NON_ANSI_CAT
# endif
#else
# ifndef BSD
#  ifndef __TURBOC__
#   include <memory.h>
#  endif
# endif
# ifdef hpux
#  ifdef _INCLUDE__STDC__
#   include <stddef.h>
#   include <stdlib.h>
#   define HAS_STDLIB
#  endif
# endif
# include <sys/types.h>
# if !defined(MSDOS) || defined(__TURBOC__)
#  define NON_ANSI_CAT
# endif
#endif

#if defined(NON_ANSI_CAT) && !defined(ANSI_CAT)
# ifdef NON_ANSI_CAT_ALTERNATE
#  define __CAT__(a,b)a/**/b
# else
#  define __ID__(a)a
#  define __CAT__(a,b)__ID__(a)b
# endif
#else
# define __CAT__(a,b)a##b
#endif


#ifdef BSD
# include <strings.h>
# define memcpy(a,b,n) (bcopy(b,a,n),a)
# define memcmp(a,b,n) bcmp(a,b,n)
# define strchr(s,c) index(s,c)
# define strrchr(s,c) rindex(s,c)
#else
# include <string.h>
#endif

#include <ctype.h>
#include <math.h>
#include <setjmp.h>
#include <assert.h>


#ifndef NO_LACK
#ifdef vms

#define LACK_LABS
#define LACK_MEMMOVE
#define LACK_MEMCPY

#else

#define LACK_LABS       /* Undefine these if your library has these */
#define LACK_MEMMOVE

#endif
#endif


typedef struct __p2c_jmp_buf {
    struct __p2c_jmp_buf *next;
    jmp_buf jbuf;
} __p2c_jmp_buf;


/* Warning: The following will not work if setjmp is used simultaneously.
   This also violates the ANSI restriction about using vars after longjmp,
   but a typical implementation of longjmp will get it right anyway. */

#ifndef FAKE_TRY
# define TRY(x)         do { __p2c_jmp_buf __try_jb;  \
			     __try_jb.next = __top_jb;  \
			     if (!setjmp((__top_jb = &__try_jb)->jbuf)) {
# define RECOVER(x)	__top_jb = __try_jb.next; } else {
# define RECOVER2(x,L)  __top_jb = __try_jb.next; } else {  \
			     if (0) { L: __top_jb = __try_jb.next; }
# define ENDTRY(x)      } } while (0) 
#else
# define TRY(x)         if (1) {
# define RECOVER(x)     } else do {
# define RECOVER2(x,L)  } else do { L: ;
# define ENDTRY(x)      } while (0)
#endif



#ifdef M_XENIX  /* avoid compiler bug */
# define SHORT_MAX  (32767)
# define SHORT_MIN  (-32768)
#endif


/* The following definitions work only on twos-complement machines */
#ifndef SHORT_MAX
# define SHORT_MAX  ((short)(((unsigned short) -1) >> 1))
# define SHORT_MIN  (~SHORT_MAX)
#endif

#ifndef INT_MAX
# define INT_MAX    ((int)(((unsigned int) -1) >> 1))
# define INT_MIN    (~INT_MAX)
#endif

#ifndef LONG_MAX
# define LONG_MAX   ((long)(((unsigned long) -1) >> 1))
# define LONG_MIN   (~LONG_MAX)
#endif

#ifndef SEEK_SET
# define SEEK_SET   0
# define SEEK_CUR   1
# define SEEK_END   2
#endif

#ifndef EXIT_SUCCESS
# ifdef vms
#  define EXIT_SUCCESS  1
#  define EXIT_FAILURE  (02000000000L)
# else
#  define EXIT_SUCCESS  0
#  define EXIT_FAILURE  1
# endif
#endif


#define SETBITS  32


#if defined(__STDC__) || defined(__TURBOC__)
# if !defined(vms) && !defined(M_LINT)
#  define Signed    signed
# else
#  define Signed
# endif
# define Void       void      /* Void f() = procedure */
# ifndef Const
#  define Const     const
# endif
# ifndef Volatile
# define Volatile   volatile
# endif
# ifdef M_LINT
#  define PP(x)     ()
#  define PV()	    ()
typedef char *Anyptr;
# else
#  define PP(x)     x         /* function prototype */
#  define PV()      (void)    /* null function prototype */
typedef void *Anyptr;
# endif
#else
# define Signed
# define Void       void
# ifndef Const
#  define Const
# endif
# ifndef Volatile
#  define Volatile
# endif
# define PP(x)      ()
# define PV()       ()
typedef char *Anyptr;
#endif

#ifdef __GNUC__
# define Inline     inline
#else
# define Inline
#endif

#define Register    register  /* Register variables */
#define Char        char      /* Characters (not bytes) */

#ifndef Static
# define Static     static    /* Private global funcs and vars */
#endif

#ifndef Local
# define Local      static    /* Nested functions */
#endif

typedef Signed   char schar;
typedef unsigned char uchar;
typedef unsigned char boolean;

#ifndef NO_DECLARE_ALFA
typedef Char alfa[10];
#endif

#ifndef true
# define true    1
# define false   0
#endif

#ifndef TRUE
# define TRUE    1
# define FALSE   0
#endif


typedef struct {
    Anyptr proc, link;
} _PROCEDURE;

#ifndef _FNSIZE
# define _FNSIZE  120
#endif


extern Void    PASCAL_MAIN  PP( (int, Char **) );
extern Char    **P_argv;
extern int     P_argc;
extern short   P_escapecode;
extern int     P_ioresult;
extern __p2c_jmp_buf *__top_jb;


#ifdef P2C_H_PROTO   /* if you have Ansi C but non-prototyped header files */
extern Char    *strcat      PP( (Char *, Const Char *) );
extern Char    *strchr      PP( (Const Char *, int) );
extern int      strcmp      PP( (Const Char *, Const Char *) );
extern Char    *strcpy      PP( (Char *, Const Char *) );
extern size_t   strlen      PP( (Const Char *) );
extern Char    *strncat     PP( (Char *, Const Char *, size_t) );
extern int      strncmp     PP( (Const Char *, Const Char *, size_t) );
extern Char    *strncpy     PP( (Char *, Const Char *, size_t) );
extern Char    *strrchr     PP( (Const Char *, int) );

extern Anyptr   memchr      PP( (Const Anyptr, int, size_t) );
extern Anyptr   memmove     PP( (Anyptr, Const Anyptr, size_t) );
extern Anyptr   memset      PP( (Anyptr, int, size_t) );
#ifndef memcpy
extern Anyptr   memcpy      PP( (Anyptr, Const Anyptr, size_t) );
extern int      memcmp      PP( (Const Anyptr, Const Anyptr, size_t) );
#endif

extern int      atoi        PP( (Const Char *) );
extern double   atof        PP( (Const Char *) );
extern long     atol        PP( (Const Char *) );
extern double   strtod      PP( (Const Char *, Char **) );
extern long     strtol      PP( (Const Char *, Char **, int) );
#endif /*P2C_H_PROTO*/

#ifndef HAS_STDLIB
#ifndef NO_DECLARE_MALLOC
extern Anyptr   malloc      PP( (size_t) );
extern Void     free        PP( (Anyptr) );
#endif
#endif

extern int      _OutMem     PV();
extern int      _CaseCheck  PV();
extern int      _NilCheck   PV();
extern int	_Escape     PP( (int) );
extern int	_EscIO      PP( (int) );
extern int	_EscIO2     PP( (int, Char *) );

extern long     ipow        PP( (long, long) );
extern long     P_imax      PP( (long, long) );
extern long     P_imin      PP( (long, long) );
extern double   P_rmax      PP( (double, double) );
extern double   P_rmin      PP( (double, double) );
extern Char    *strsub      PP( (Char *, Char *, int, int) );
extern Char    *strltrim    PP( (Char *) );
extern Char    *strrtrim    PP( (Char *) );
extern Char    *strrpt      PP( (Char *, Char *, int) );
extern Char    *strpad      PP( (Char *, Char *, int, int) );
extern int      strpos2     PP( (Char *, Char *, int) );
extern long     memavail    PV();
extern int      P_peek      PP( (FILE *) );
extern int      P_eof       PP( (FILE *) );
extern int      P_eoln      PP( (FILE *) );
extern Void     P_readpaoc  PP( (FILE *, Char *, int) );
extern Void     P_readlnpaoc PP( (FILE *, Char *, int) );
extern long     P_maxpos    PP( (FILE *) );
extern Char    *P_trimname  PP( (Char *, int) );
extern long    *P_setunion  PP( (long *, long *, long *) );
extern long    *P_setint    PP( (long *, long *, long *) );
extern long    *P_setdiff   PP( (long *, long *, long *) );
extern long    *P_setxor    PP( (long *, long *, long *) );
extern int      P_inset     PP( (unsigned, long *) );
extern int      P_setequal  PP( (long *, long *) );
extern int      P_subset    PP( (long *, long *) );
extern long    *P_addset    PP( (long *, unsigned) );
extern long    *P_addsetr   PP( (long *, unsigned, unsigned) );
extern long    *P_remset    PP( (long *, unsigned) );
extern long    *P_setcpy    PP( (long *, long *) );
extern long    *P_expset    PP( (long *, long) );
extern long     P_packset   PP( (long *) );
extern int      P_getcmdline PP( (int, int, Char *) );
extern Void     TimeStamp   PP( (int *, int *, int *,
				 int *, int *, int *) );
extern Void	P_sun_argv  PP( (char *, int, int) );
extern FILE    *_skipspaces PP( (FILE *) );
extern FILE    *_skipnlspaces PP( (FILE *) );


/* I/O error handling */
#define _CHKIO(cond,ior,val,def)  ((cond) ? P_ioresult=0,(val)  \
					  : P_ioresult=(ior),(def))
#define _SETIO(cond,ior)          (P_ioresult = (cond) ? 0 : (ior))

/* Following defines are suitable for the HP Pascal operating system */
#define FileNotFound     10
#define FileNotOpen      13
#define FileWriteError   38
#define BadInputFormat   14
#define EndOfFile        30

#define FILENOTFOUND     10
#define FILENOTOPEN      13
#define FILEWRITEERROR   38
#define BADINPUTFORMAT   14
#define ENDOFFILE        30

/* Creating temporary files */
#if (defined(BSD) || defined(NO_TMPFILE)) && !defined(HAVE_TMPFILE)
# define tmpfile()  (fopen(tmpnam(NULL), "w+"))
#endif

/* File buffers */
#define FILEBUF(f,sc,type) sc int __CAT__(f,_BFLAGS);   \
			   sc type __CAT__(f,_BUFFER)
#define FILEBUFNC(f,type)  int __CAT__(f,_BFLAGS);   \
			   type __CAT__(f,_BUFFER)

#define RESETBUF(f,type)   (__CAT__(f,_BFLAGS) = 1)
#define SETUPBUF(f,type)   (__CAT__(f,_BFLAGS) = 0)

#define GETFBUF(f,type)    (*((__CAT__(f,_BFLAGS) == 1 &&   \
			       ((__CAT__(f,_BFLAGS) = 2),   \
				fread(&__CAT__(f,_BUFFER),  \
				      sizeof(type),1,(f)))),\
			      &__CAT__(f,_BUFFER)))
#define AGETFBUF(f,type)   ((__CAT__(f,_BFLAGS) == 1 &&   \
			     ((__CAT__(f,_BFLAGS) = 2),   \
			      fread(__CAT__(f,_BUFFER),  \
				    sizeof(type),1,(f)))),\
			    __CAT__(f,_BUFFER))

#define PUTFBUF(f,type,v)  (GETFBUF(f,type) = (v))
#define CPUTFBUF(f,v)      (PUTFBUF(f,char,v))
#define APUTFBUF(f,type,v) (memcpy(AGETFBUF(f,type), (v),  \
				   sizeof(__CAT__(f,_BUFFER))))

#define GET(f,type)        (__CAT__(f,_BFLAGS) == 1 ?   \
			    fread(&__CAT__(f,_BUFFER),sizeof(type),1,(f)) :  \
			    (__CAT__(f,_BFLAGS) = 1))

#define PUT(f,type)        (fwrite(&__CAT__(f,_BUFFER),sizeof(type),1,(f)),  \
			    (__CAT__(f,_BFLAGS) = 0))
#define CPUT(f)            (PUT(f,char))

#define BUFEOF(f)	   (__CAT__(f,_BFLAGS) != 2 && P_eof(f))
#define BUFFPOS(f)	   (ftell(f) - (__CAT__(f,_BFLAGS) == 2))

typedef struct {
    FILE *f;
    int f_BFLAGS;    /* FILEBUFNC(f,Char); */
    Char f_BUFFER;
    Char name[_FNSIZE];
} _TEXT;

/* Memory allocation */
#ifdef __GCC__
# define Malloc(n)  (malloc(n) ?: (Anyptr)_OutMem())
#else
extern Anyptr __MallocTemp__;
# define Malloc(n)  ((__MallocTemp__ = malloc(n)) ? __MallocTemp__ : (Anyptr)_OutMem())
#endif
#define FreeR(p)    (free((Anyptr)(p)))    /* used if arg is an rvalue */
#define Free(p)     (free((Anyptr)(p)), (p)=NULL)

/* sign extension */
#define SEXT(x,n)   ((x) | -(((x) & (1L<<((n)-1))) << 1))

/* packed arrays */   /* BEWARE: these are untested! */
#define P_getbits_UB(a,i,n,L)   ((int)((a)[(i)>>(L)-(n)] >>   \
				       (((~(i))&((1<<(L)-(n))-1)) << (n)) &  \
				       (1<<(1<<(n)))-1))

#define P_getbits_SB(a,i,n,L)   ((int)((a)[(i)>>(L)-(n)] <<   \
				       (16 - ((((~(i))&((1<<(L)-(n))-1))+1) <<\
					      (n)) >> (16-(1<<(n))))))

#define P_putbits_UB(a,i,x,n,L) ((a)[(i)>>(L)-(n)] |=   \
				 (x) << (((~(i))&((1<<(L)-(n))-1)) << (n)))

#define P_putbits_SB(a,i,x,n,L) ((a)[(i)>>(L)-(n)] |=   \
				 ((x) & (1<<(1<<(n)))-1) <<   \
				 (((~(i))&((1<<(L)-(n))-1)) << (n)))

#define P_clrbits_B(a,i,n,L)    ((a)[(i)>>(L)-(n)] &=   \
				 ~( ((1<<(1<<(n)))-1) <<   \
				   (((~(i))&((1<<(L)-(n))-1)) << (n))) )

/* small packed arrays */
#define P_getbits_US(v,i,n)     ((int)((v) >> ((i)<<(n)) & (1<<(1<<(n)))-1))
#define P_getbits_SS(v,i,n)     ((int)((long)(v) << (SETBITS - (((i)+1) << (n))) >> (SETBITS-(1<<(n)))))
#define P_putbits_US(v,i,x,n)   ((v) |= (x) << ((i) << (n)))
#define P_putbits_SS(v,i,x,n)   ((v) |= ((x) & (1<<(1<<(n)))-1) << ((i)<<(n)))
#define P_clrbits_S(v,i,n)      ((v) &= ~( ((1<<(1<<(n)))-1) << ((i)<<(n)) ))

#define P_max(a,b)   ((a) > (b) ? (a) : (b))
#define P_min(a,b)   ((a) < (b) ? (a) : (b))


/* Fix ANSI-isms */

#ifdef LACK_LABS
# ifndef labs
#  define labs  my_labs
   extern long my_labs PP( (long) );
# endif
#endif

#ifdef LACK_MEMMOVE
# ifndef memmove
#  define memmove  my_memmove
   extern Anyptr my_memmove PP( (Anyptr, Const Anyptr, size_t) );
# endif
#endif

#ifdef LACK_MEMCPY
# ifndef memcpy
#  define memcpy  my_memcpy
   extern Anyptr my_memcpy PP( (Anyptr, Const Anyptr, size_t) );
# endif
# ifndef memcmp
#  define memcmp  my_memcmp
   extern int my_memcmp PP( (Const Anyptr, Const Anyptr, size_t) );
# endif
# ifndef memset
#  define memset  my_memset
   extern Anyptr my_memset PP( (Anyptr, int, size_t) );
# endif
#endif

/* Fix toupper/tolower on Suns and other stupid BSD systems */
#ifdef toupper
# undef toupper
# undef tolower
# define toupper(c)   my_toupper(c)
# define tolower(c)   my_tolower(c)
#endif

#ifndef _toupper
# if 'A' == 65 && 'a' == 97
#  define _toupper(c)  ((c)-'a'+'A')
#  define _tolower(c)  ((c)-'A'+'a')
# else
#  ifdef toupper
#   undef toupper   /* hope these are shadowing real functions, */
#   undef tolower   /* because my_toupper calls _toupper! */
#  endif
#  define _toupper(c)  toupper(c)
#  define _tolower(c)  tolower(c)
# endif
#endif


#endif    /* P2C_H */



/* End. */




/* Run-time library for use with "p2c", the Pascal to C translator */

/* "p2c"  Copyright (C) 1989, 1990, 1991, 1992, 1993 Free Software Foundation.
 * By Dave Gillespie, daveg@synaptics.com.  Version --VERSION--.
 * This file may be copied, modified, etc. in any way.  It is not restricted
 * by the licence agreement accompanying p2c itself.
 */





#ifndef NO_TIME
# include <time.h>
#endif


#define Isspace(c)  isspace(c)      /* or "((c) == ' ')" if preferred */




int P_argc;
char **P_argv;

short P_escapecode;
int P_ioresult;

long EXCP_LINE;    /* Used by Pascal workstation system */

Anyptr __MallocTemp__;

__p2c_jmp_buf *__top_jb;




void PASCAL_MAIN(argc, argv)
int argc;
char **argv;
{
    P_argc = argc;
    P_argv = argv;
    __top_jb = NULL;

#ifdef LOCAL_INIT
    LOCAL_INIT();
#endif
}





/* In case your system lacks these... */

long my_labs(x)
long x;
{
    return((x > 0) ? x : -x);
}


#ifdef __STDC__
Anyptr my_memmove(Anyptr d, Const Anyptr s, size_t n)
#else
Anyptr my_memmove(d, s, n)
Anyptr d, s;
register int n;
#endif
{
    register char *dd = (char *)d, *ss = (char *)s;
    if (dd < ss || dd - ss >= n) {
#if defined(bcopy) && defined(memcpy)
        my_memcpy(dd, ss, n);
#else
	memcpy(dd, ss, n);
#endif
    } else if (n > 0) {
	dd += n;
	ss += n;
	while (n-- > 0)
	    *--dd = *--ss;
    }
    return d;
}


#ifdef __STDC__
Anyptr my_memcpy(Anyptr d, Const Anyptr s, size_t n)
#else
Anyptr my_memcpy(d, s, n)
Anyptr d, s;
register int n;
#endif
{
    register char *ss = (char *)s, *dd = (char *)d;
    while (n-- > 0)
	*dd++ = *ss++;
    return d;
}

#ifdef __STDC__
int my_memcmp(Const Anyptr s1, Const Anyptr s2, size_t n)
#else
int my_memcmp(s1, s2, n)
Anyptr s1, s2;
register int n;
#endif
{
    register char *a = (char *)s1, *b = (char *)s2;
    register int i;
    while (n-- > 0)
	if ((i = (*a++) - (*b++)) != 0)
	    return i;
    return 0;
}

#ifdef __STDC__
Anyptr my_memset(Anyptr d, int c, size_t n)
#else
Anyptr my_memset(d, c, n)
Anyptr d;
register int c;
register int n;
#endif
{
    register char *dd = (char *)d;
    while (n-- > 0)
	*dd++ = c;
    return d;
}


int my_toupper(c)
int c;
{
    if (islower(c))
	return _toupper(c);
    else
	return c;
}


int my_tolower(c)
int c;
{
    if (isupper(c))
	return _tolower(c);
    else
	return c;
}




long ipow(a, b)
long a, b;
{
    long v;

    if (a == 0 || a == 1)
	return a;
    if (a == -1)
	return (b & 1) ? -1 : 1;
    if (b < 0)
	return 0;
    if (a == 2)
	return 1L << b;
    v = (b & 1) ? a : 1;
    while ((b >>= 1) > 0) {
	a *= a;
	if (b & 1)
	    v *= a;
    }
    return v;
}


long P_imax(a, b)
long a, b;
{
    if (a > b)
	return a;
    else
	return b;
}

long P_imin(a, b)
long a, b;
{
    if (a < b)
	return a;
    else
	return b;
}


double P_rmax(a, b)
double a, b;
{
    if (a > b)
	return a;
    else
	return b;
}

double P_rmin(a, b)
double a, b;
{
    if (a < b)
	return a;
    else
	return b;
}




/* Common string functions: */

/* Store in "ret" the substring of length "len" starting from "pos" (1-based).
   Store a shorter or null string if out-of-range.  Return "ret". */

char *strsub(ret, s, pos, len)
register char *ret, *s;
register int pos, len;
{
    register char *s2;

    if (--pos < 0 || len <= 0) {
        *ret = 0;
        return ret;
    }
    while (pos > 0) {
        if (!*s++) {
            *ret = 0;
            return ret;
        }
        pos--;
    }
    s2 = ret;
    while (--len >= 0) {
        if (!(*s2++ = *s++))
            return ret;
    }
    *s2 = 0;
    return ret;
}


/* Return the index of the first occurrence of "pat" as a substring of "s",
   starting at index "pos" (1-based).  Result is 1-based, 0 if not found. */

int strpos2(s, pat, pos)
char *s;
register char *pat;
register int pos;
{
    register char *cp, ch;
    register int slen;

    if (--pos < 0)
        return 0;
    slen = strlen(s) - pos;
    cp = s + pos;
    if (!(ch = *pat++))
        return 0;
    pos = strlen(pat);
    slen -= pos;
    while (--slen >= 0) {
        if (*cp++ == ch && !strncmp(cp, pat, pos))
            return cp - s;
    }
    return 0;
}


/* Case-insensitive version of strcmp. */

int strcicmp(s1, s2)
register char *s1, *s2;
{
    register unsigned char c1, c2;

    while (*s1) {
	if (*s1++ != *s2++) {
	    if (!s2[-1])
		return 1;
	    c1 = toupper(s1[-1]);
	    c2 = toupper(s2[-1]);
	    if (c1 != c2)
		return c1 - c2;
	}
    }
    if (*s2)
	return -1;
    return 0;
}




/* HP and Turbo Pascal string functions: */

/* Trim blanks at left end of string. */

char *strltrim(s)
register char *s;
{
    while (Isspace(*s++)) ;
    return s - 1;
}


/* Trim blanks at right end of string. */

char *strrtrim(s)
register char *s;
{
    register char *s2 = s;

    if (!*s)
	return s;
    while (*++s2) ;
    while (s2 > s && Isspace(*--s2))
        *s2 = 0;
    return s;
}


/* Store in "ret" "num" copies of string "s".  Return "ret". */

char *strrpt(ret, s, num)
char *ret;
register char *s;
register int num;
{
    register char *s2 = ret;
    register char *s1;

    while (--num >= 0) {
        s1 = s;
        while ((*s2++ = *s1++)) ;
        s2--;
    }
    return ret;
}


/* Store in "ret" string "s" with enough pad chars added to reach "size". */

char *strpad(ret, s, padchar, num)
char *ret;
register char *s;
register int padchar, num;
{
    register char *d = ret;

    if (s == d) {
	while (*d++) ;
    } else {
	while ((*d++ = *s++)) ;
    }
    num -= (--d - ret);
    while (--num >= 0)
	*d++ = padchar;
    *d = 0;
    return ret;
}


/* Copy the substring of length "len" from index "spos" of "s" (1-based)
   to index "dpos" of "d", lengthening "d" if necessary.  Length and
   indices must be in-range. */

void strmove(len, s, spos, d, dpos)
register char *s, *d;
register int len, spos, dpos;
{
    s += spos - 1;
    d += dpos - 1;
    while (*d && --len >= 0)
	*d++ = *s++;
    if (len > 0) {
	while (--len >= 0)
	    *d++ = *s++;
	*d = 0;
    }
}


/* Delete the substring of length "len" at index "pos" from "s".
   Delete less if out-of-range. */

void strdelete(s, pos, len)
register char *s;
register int pos, len;
{
    register int slen;

    if (--pos < 0)
        return;
    slen = strlen(s) - pos;
    if (slen <= 0)
        return;
    s += pos;
    if (slen <= len) {
        *s = 0;
        return;
    }
    while ((*s = s[len])) s++;
}


/* Insert string "src" at index "pos" of "dst". */

void strinsert(src, dst, pos)
register char *src, *dst;
register int pos;
{
    register int slen, dlen;

    if (--pos < 0)
        return;
    dlen = strlen(dst);
    dst += dlen;
    dlen -= pos;
    if (dlen <= 0) {
        strcpy(dst, src);
        return;
    }
    slen = strlen(src);
    do {
        dst[slen] = *dst;
        --dst;
    } while (--dlen >= 0);
    dst++;
    while (--slen >= 0)
        *dst++ = *src++;
}




/* File functions */

/* Peek at next character of input stream; return EOF at end-of-file. */

int P_peek(f)
FILE *f;
{
    int ch;

    ch = getc(f);
    if (ch == EOF)
	return EOF;
    ungetc(ch, f);
    return (ch == '\n') ? ' ' : ch;
}


/* Check if at end of file, using Pascal "eof" semantics.  End-of-file for
   stdin is broken; remove the special case for it to be broken in a
   different way. */

int P_eof(f)
FILE *f;
{
    register int ch;

    if (feof(f))
	return 1;
#ifdef HAVE_ISATTY
    if (isatty(fileno(f)))
#else
    if (f == stdin)
#endif
	return 0;    /* not safe to look-ahead on the keyboard! */
    ch = getc(f);
    if (ch == EOF)
	return 1;
    ungetc(ch, f);
    return 0;
}


/* Check if at end of line (or end of entire file). */

int P_eoln(f)
FILE *f;
{
    register int ch;

    ch = getc(f);
    if (ch == EOF)
        return 1;
    ungetc(ch, f);
    return (ch == '\n');
}


/* Skip whitespace (including newlines) in a file. */

FILE *_skipnlspaces(f)
FILE *f;
{
  register int ch;

  do {
    ch = getc(f);
  } while (ch == ' ' || ch == '\t' || ch == '\n');
  if (ch != EOF)
    ungetc(ch, f);
  return f;
}


/* Skip whitespace (not including newlines) in a file. */

FILE *_skipspaces(f)
FILE *f;
{
  register int ch;

  do {
    ch = getc(f);
  } while (ch == ' ' || ch == '\t');
  if (ch != EOF)
    ungetc(ch, f);
  return f;
}


/* Read a packed array of characters from a file. */

Void P_readpaoc(f, s, len)
FILE *f;
char *s;
int len;
{
    int ch;

    for (;;) {
	if (len <= 0)
	    return;
	ch = getc(f);
	if (ch == EOF || ch == '\n')
	    break;
	*s++ = ch;
	--len;
    }
    while (--len >= 0)
	*s++ = ' ';
    if (ch != EOF)
	ungetc(ch, f);
}

Void P_readlnpaoc(f, s, len)
FILE *f;
char *s;
int len;
{
    int ch;

    for (;;) {
	ch = getc(f);
	if (ch == EOF || ch == '\n')
	    break;
	if (len > 0) {
	    *s++ = ch;
	    --len;
	}
    }
    while (--len >= 0)
	*s++ = ' ';
}


/* Compute maximum legal "seek" index in file (0-based). */

long P_maxpos(f)
FILE *f;
{
    long savepos = ftell(f);
    long val;

    if (fseek(f, 0L, SEEK_END))
        return -1;
    val = ftell(f);
    if (fseek(f, savepos, SEEK_SET))
        return -1;
    return val;
}


/* Use packed array of char for a file name. */

Char *P_trimname(fn, len)
register Char *fn;
register int len;
{
    static Char fnbuf[256];
    register Char *cp = fnbuf;
    
    while (--len >= 0 && *fn && !isspace(*fn))
	*cp++ = *fn++;
    *cp = 0;
    return fnbuf;
}




/* Pascal's "memavail" doesn't make much sense in Unix with virtual memory.
   We fix memory size as 10Meg as a reasonable compromise. */

long memavail()
{
    return 10000000;            /* worry about this later! */
}

long maxavail()
{
    return memavail();
}




/* Sets are stored as an array of longs.  S[0] is the size of the set;
   S[N] is the N'th 32-bit chunk of the set.  S[0] equals the maximum
   I such that S[I] is nonzero.  S[0] is zero for an empty set.  Within
   each long, bits are packed from lsb to msb.  The first bit of the
   set is the element with ordinal value 0.  (Thus, for a "set of 5..99",
   the lowest five bits of the first long are unused and always zero.) */

/* (Sets with 32 or fewer elements are normally stored as plain longs.) */

long *P_setunion(d, s1, s2)         /* d := s1 + s2 */
register long *d, *s1, *s2;
{
    long *dbase = d++;
    register int sz1 = *s1++, sz2 = *s2++;
    while (sz1 > 0 && sz2 > 0) {
        *d++ = *s1++ | *s2++;
	sz1--, sz2--;
    }
    while (--sz1 >= 0)
	*d++ = *s1++;
    while (--sz2 >= 0)
	*d++ = *s2++;
    *dbase = d - dbase - 1;
    return dbase;
}


long *P_setint(d, s1, s2)           /* d := s1 * s2 */
register long *d, *s1, *s2;
{
    long *dbase = d++;
    register int sz1 = *s1++, sz2 = *s2++;
    while (--sz1 >= 0 && --sz2 >= 0)
        *d++ = *s1++ & *s2++;
    while (--d > dbase && !*d) ;
    *dbase = d - dbase;
    return dbase;
}


long *P_setdiff(d, s1, s2)          /* d := s1 - s2 */
register long *d, *s1, *s2;
{
    long *dbase = d++;
    register int sz1 = *s1++, sz2 = *s2++;
    while (--sz1 >= 0 && --sz2 >= 0)
        *d++ = *s1++ & ~*s2++;
    if (sz1 >= 0) {
        while (sz1-- >= 0)
            *d++ = *s1++;
    }
    while (--d > dbase && !*d) ;
    *dbase = d - dbase;
    return dbase;
}


long *P_setxor(d, s1, s2)         /* d := s1 / s2 */
register long *d, *s1, *s2;
{
    long *dbase = d++;
    register int sz1 = *s1++, sz2 = *s2++;
    while (sz1 > 0 && sz2 > 0) {
        *d++ = *s1++ ^ *s2++;
	sz1--, sz2--;
    }
    while (--sz1 >= 0)
	*d++ = *s1++;
    while (--sz2 >= 0)
	*d++ = *s2++;
    while (--d > dbase && !*d) ;
    *dbase = d - dbase;
    return dbase;
}


int P_inset(val, s)                 /* val IN s */
register unsigned val;
register long *s;
{
    register int bit;
    bit = val % SETBITS;
    val /= SETBITS;
    if (val < *s++ && ((1L<<bit) & s[val]))
	return 1;
    return 0;
}


long *P_addset(s, val)              /* s := s + [val] */
register long *s;
register unsigned val;
{
    register long *sbase = s;
    register int bit, size;
    bit = val % SETBITS;
    val /= SETBITS;
    size = *s;
    if (++val > size) {
        s += size;
        while (val > size)
            *++s = 0, size++;
        *sbase = size;
    } else
        s += val;
    *s |= 1L<<bit;
    return sbase;
}


long *P_addsetr(s, v1, v2)              /* s := s + [v1..v2] */
register long *s;
register unsigned v1, v2;
{
    register long *sbase = s;
    register int b1, b2, size;
    if ((int)v1 > (int)v2)
	return sbase;
    b1 = v1 % SETBITS;
    v1 /= SETBITS;
    b2 = v2 % SETBITS;
    v2 /= SETBITS;
    size = *s;
    v1++;
    if (++v2 > size) {
        while (v2 > size)
            s[++size] = 0;
        s[v2] = 0;
        *s = v2;
    }
    s += v1;
    if (v1 == v2) {
        *s |= (~((-2L)<<(b2-b1))) << b1;
    } else {
        *s++ |= (-1L) << b1;
        while (++v1 < v2)
            *s++ = -1;
        *s |= ~((-2L) << b2);
    }
    return sbase;
}


long *P_remset(s, val)              /* s := s - [val] */
register long *s;
register unsigned val;
{
    register int bit;
    bit = val % SETBITS;
    val /= SETBITS;
    if (++val <= *s) {
	if (!(s[val] &= ~(1L<<bit)))
	    while (*s && !s[*s])
		(*s)--;
    }
    return s;
}


int P_setequal(s1, s2)              /* s1 = s2 */
register long *s1, *s2;
{
    register int size = *s1++;
    if (*s2++ != size)
        return 0;
    while (--size >= 0) {
        if (*s1++ != *s2++)
            return 0;
    }
    return 1;
}


int P_subset(s1, s2)                /* s1 <= s2 */
register long *s1, *s2;
{
    register int sz1 = *s1++, sz2 = *s2++;
    if (sz1 > sz2)
        return 0;
    while (--sz1 >= 0) {
        if (*s1++ & ~*s2++)
            return 0;
    }
    return 1;
}


long *P_setcpy(d, s)                /* d := s */
register long *d, *s;
{
    register long *save_d = d;

#ifdef SETCPY_MEMCPY
    memcpy(d, s, (*s + 1) * sizeof(long));
#else
    register int i = *s + 1;
    while (--i >= 0)
        *d++ = *s++;
#endif
    return save_d;
}


/* s is a "smallset", i.e., a 32-bit or less set stored
   directly in a long. */

long *P_expset(d, s)                /* d := s */
register long *d;
register long s;
{
    if (s) {
	d[1] = s;
	*d = 1;
    } else
        *d = 0;
    return d;
}


long P_packset(s)                   /* convert s to a small-set */
register long *s;
{
    if (*s++)
        return *s;
    else
        return 0;
}





/* Oregon Software Pascal extensions, courtesy of William Bader */

int P_getcmdline(l, h, line)
int l, h;
Char *line;
{
    int i, len;
    char *s;
    
    h = h - l + 1;
    len = 0;
    for(i = 1; i < P_argc; i++) {
	s = P_argv[i];
	while (*s) {
	    if (len >= h) return len;
	    line[len++] = *s++;
	}
	if (len >= h) return len;
	line[len++] = ' ';
    }
    return len;
}

Void TimeStamp(Day, Month, Year, Hour, Min, Sec)
int *Day, *Month, *Year, *Hour, *Min, *Sec;
{
#ifndef NO_TIME
    struct tm *tm;
    long clock;

    time(&clock);
    tm = localtime(&clock);
    *Day = tm->tm_mday;
    *Month = tm->tm_mon + 1;		/* Jan = 0 */
    *Year = tm->tm_year;
    if (*Year < 1900)
	*Year += 1900;     /* year since 1900 */
    *Hour = tm->tm_hour;
    *Min = tm->tm_min;
    *Sec = tm->tm_sec;
#endif
}

Void VAXdate(s)
char *s;
{
    long clock;
    char *c;
    int i;
    static int where[] = {8, 9, 0, 4, 5, 6, 0, 20, 21, 22, 23};

    time(&clock);
    c = ctime(&clock);
    for (i = 0; i < 11; i++)
	s[i] = my_toupper(c[where[i]]);
    s[2] = '-';
    s[6] = '-';
}

Void VAXtime(s)
char *s;
{
    long clock;
    char *c;
    int i;

    time(&clock);
    c = ctime(&clock);
    for (i = 0; i < 8; i++)
	s[i] = c[i+11];
    s[8] = '.';
    s[9] = '0';
    s[10] = '0';
}




/* SUN Berkeley Pascal extensions */

Void P_sun_argv(s, len, n)
register char *s;
register int len, n;
{
    register char *cp;

    if ((unsigned)n < P_argc)
	cp = P_argv[n];
    else
	cp = "";
    while (*cp && --len >= 0)
	*s++ = *cp++;
    while (--len >= 0)
	*s++ = ' ';
}




int _OutMem()
{
    return _Escape(-2);
}

int _CaseCheck()
{
    return _Escape(-9);
}

int _NilCheck()
{
    return _Escape(-3);
}





/* The following is suitable for the HP Pascal operating system.
   It might want to be revised when emulating another system. */

char *_ShowEscape(buf, code, ior, prefix)
char *buf, *prefix;
int code, ior;
{
    char *bufp;

    if (prefix && *prefix) {
        strcpy(buf, prefix);
	strcat(buf, ": ");
        bufp = buf + strlen(buf);
    } else {
        bufp = buf;
    }
    if (code == -10) {
        sprintf(bufp, "Pascal system I/O error %d", ior);
        switch (ior) {
            case 3:
                strcat(buf, " (illegal I/O request)");
                break;
            case 7:
                strcat(buf, " (bad file name)");
                break;
            case FileNotFound:   /*10*/
                strcat(buf, " (file not found)");
                break;
            case FileNotOpen:    /*13*/
                strcat(buf, " (file not open)");
                break;
            case BadInputFormat: /*14*/
                strcat(buf, " (bad input format)");
                break;
            case 24:
                strcat(buf, " (not open for reading)");
                break;
            case 25:
                strcat(buf, " (not open for writing)");
                break;
            case 26:
                strcat(buf, " (not open for direct access)");
                break;
            case 28:
                strcat(buf, " (string subscript out of range)");
                break;
            case EndOfFile:      /*30*/
                strcat(buf, " (end-of-file)");
                break;
            case FileWriteError: /*38*/
		strcat(buf, " (file write error)");
		break;
        }
    } else {
        sprintf(bufp, "Pascal system error %d", code);
        switch (code) {
            case -2:
                strcat(buf, " (out of memory)");
                break;
            case -3:
                strcat(buf, " (reference to NIL pointer)");
                break;
            case -4:
                strcat(buf, " (integer overflow)");
                break;
            case -5:
                strcat(buf, " (divide by zero)");
                break;
            case -6:
                strcat(buf, " (real math overflow)");
                break;
            case -8:
                strcat(buf, " (value range error)");
                break;
            case -9:
                strcat(buf, " (CASE value range error)");
                break;
            case -12:
                strcat(buf, " (bus error)");
                break;
            case -20:
                strcat(buf, " (stopped by user)");
                break;
        }
    }
    return buf;
}


int _Escape(code)
int code;
{
    char buf[100];

    P_escapecode = code;
    if (__top_jb) {
	__p2c_jmp_buf *jb = __top_jb;
	__top_jb = jb->next;
	longjmp(jb->jbuf, 1);
    }
    if (code == 0)
        exit(EXIT_SUCCESS);
    if (code == -1)
        exit(EXIT_FAILURE);
    fprintf(stderr, "%s\n", _ShowEscape(buf, P_escapecode, P_ioresult, ""));
    exit(EXIT_FAILURE);
}

int _EscIO(code)
int code;
{
    P_ioresult = code;
    return _Escape(-10);
}

int _EscIO2(code, name)
int code;
char *name;
{
    P_ioresult = code;
    if (!__top_jb && name && *name) {
	char buf[100];
	fprintf(stderr, "%s: %s\n",
		name, _ShowEscape(buf, P_escapecode, P_ioresult, ""));
	exit(EXIT_FAILURE);
    }
    return _Escape(-10);
}

/* End. */


typedef struct TPoint {
  long X, Y, C, H, N, O, P, S, Si, B, Br, Cl, F, I, Mg, Na, K, RecCount;
  struct TPoint *Last;
} TPoint;

typedef struct TBond {
  long X1, Y1, X2, Y2, RecCount;
  struct TBond *Last;
} TBond;


Static long C, H, N, O, P, S, Si, B, Br, Cl, F, I, Mg, Na, K, X1, X2, Y1, Y2,
	    T;
Static FILE *IFile;
Static TPoint *Point, *Last, *Current;
Static TBond *Bond, *LastB, *CurrentB;
Static Char sss[256], A[256], subs[256], Alert[256];
Static Char sssb[7];
Static double M, Me;
Static Char separator;
Static long Count, code, atoms, rep, range, bonds;
Static boolean Abandon, debug, verbose, fa, nobonds;
Static long Sensi = 5;   /*bonds and labels joint precision sensitivity*/
Static Char IFile_NAME[_FNSIZE];


Static Void doBonds()
{
  do {
    fscanf(IFile, "%ld%ld%ld%ld%ld%*[^\n]", &X1, &Y1, &X2, &Y2, &T);
    getc(IFile);
    bonds--;
    if (debug)
      printf("%ld; %ld; %ld; %ld; %ld\n", X1, Y1, X2, Y2, T);
    if (T == 11)
      range = ((X1 - X2) * (X1 - X2) + (Y1 - Y2) * (Y1 - Y2)) * 4;

    LastB = Bond;
    Bond = (TBond *)Malloc(sizeof(TBond));
    Bond->X1 = X1;
    Bond->X2 = X2;
    Bond->Y1 = Y1;
    Bond->Y2 = Y2;
    Bond->Last = LastB;
    CurrentB = Bond;
    Bond = Bond->Last;
    while (Bond->Last != NULL) {
      if ((labs(Bond->X1 - X1) < Sensi && labs(Bond->Y1 - Y1) < Sensi &&
	   labs(Bond->X2 - X2) < Sensi && labs(Bond->Y2 - Y2) < Sensi) ||
	  (labs(Bond->X2 - X1) < Sensi && labs(Bond->Y2 - Y1) < Sensi &&
	   labs(Bond->X1 - X2) < Sensi && labs(Bond->Y1 - Y2) < Sensi)) {
	if (debug)
	  printf("  ! Bond overlap\n");
	strcat(Alert, "!");
      }
      Bond = Bond->Last;
    }
    Bond = CurrentB;

    Abandon = false;
    Current = Point;
    while (Point->Last != NULL) {
      if (T == 11) {
	Abandon = true;
	if ((Point->X - X1) * (Point->X - X1) +
	    (Point->Y - Y1) * (Point->Y - Y1) < range) {
	  if (Point->H > 0)
	    Point->H--;
	  if (debug)
	    printf("Ring --> stripped one H from %ld %ld\n",
		   Point->X, Point->Y);
	}
      } else {
	if (labs(Point->X - X1) < Sensi && labs(Point->Y - Y1) < Sensi) {
	  if (debug)
	    printf("  %ld --> Joined at %ld %ld\n", Point->RecCount, X1, Y1);
	  if (T == 0 || T == 5 || T == 6 || T == 7 || T == 10 || T == 12 ||
	      T == 13)
	    Point->H--;
	  if (T == 1 || T == 2 || T == 4 || T == 14 || T == 15 )
	    Point->H -= 2;
	  if (T == 3)
	    Point->H -= 3;
	  if (Point->H < 0) {
	  	if (debug) printf("Point^.X=%ld, Point^.Y=%ld has H count <0 !\n",Point->X,Point->Y);
	  	Point->H = 0;
	  	}
	  Abandon = true;
	}
      }
      Point = Point->Last;
    }
    Point = Current;

    if (!Abandon) {
      Count++;
      Last = Point;
      Point = (TPoint *)Malloc(sizeof(TPoint));
      Point->X = X1;
      if (debug)
	printf("  Point^.X=%ld", Point->X);
      Point->Y = Y1;
      if (debug)
	printf("  Point^.Y=%ld", Point->Y);
      if (T != 11)
	Point->C = 1;
      else
	Point->C = 0;
      if (debug)
	printf("  Point^.C=%ld", Point->C);
      if (T == 0 || T == 5 || T == 6 || T == 7 || T == 10 || T == 12 ||
	  T == 13)
	Point->H = 3;
      if (T == 1 || T == 2 || T == 4 || T == 14 || T == 15)
	Point->H = 2;
      if (T == 3)
	Point->H = 1;
      if (debug)
	printf("  Point^.H=%ld", Point->H);
      Point->N = 0;
      Point->O = 0;
      Point->P = 0;
      Point->S = 0;
      Point->Si = 0;
      Point->B = 0;
      Point->Br = 0;
      Point->Cl = 0;
      Point->F = 0;
      Point->I = 0;
      Point->Na = 0;
      Point->Mg = 0;
      Point->K = 0;
      Point->RecCount = Count;
      if (debug)
	printf("  Point^.RecCount=%ld\n", Point->RecCount);
      Point->Last = Last;
    }

    if (T != 11) {
      Abandon = false;
      Current = Point;
      while (Point->Last != NULL) {
	if (labs(Point->X - X2) < Sensi && labs(Point->Y - Y2) < Sensi) {
	  if (debug)
	    printf("  %ld --> Joined at %ld %ld\n", Point->RecCount, X2, Y2);
	  if (T == 0 || T == 5 || T == 6 || T == 7 || T == 10 || T == 12 ||
	      T == 13)
	    Point->H--;
	  if (T == 1 || T == 2 || T == 4 || T == 14 || T == 15)
	    Point->H -= 2;
	  if (T == 3)
	    Point->H -= 3;
	  if (Point->H < 0) {
	  	  	  if (debug) printf("Point^.X=%ld, Point^.Y=%ld has H count <0 !\n",Point->X,Point->Y);
			  Point->H = 0;
			  }
	  Abandon = true;
	}
	Point = Point->Last;
      }
      Point = Current;

      if (!Abandon) {
	Count++;
	Last = Point;
	Point = (TPoint *)Malloc(sizeof(TPoint));
	Point->X = X2;
	if (debug)
	  printf("  Point^.X=%ld", Point->X);
	Point->Y = Y2;
	if (debug)
	  printf("  Point^.Y=%ld", Point->Y);
	if (T != 11)
	  Point->C = 1;
	else
	  Point->C = 0;
	if (debug)
	  printf("  Point^.C=%ld", Point->C);
	if (T == 0 || T == 5 || T == 6 || T == 7 || T == 10 || T == 12 ||
	    T == 13)
	  Point->H = 3;
	if (T == 1 || T == 2 || T == 4 || T == 14 || T == 15 )
	  Point->H = 2;
	if (T == 3)
	  Point->H = 1;
	if (debug)
	  printf("  Point^.H=%ld", Point->H);
	Point->N = 0;
	Point->O = 0;
	Point->P = 0;
	Point->S = 0;
	Point->Si = 0;
	Point->B = 0;
	Point->Br = 0;
	Point->Cl = 0;
	Point->F = 0;
	Point->I = 0;
	Point->Mg = 0;
	Point->Na = 0;
	Point->K = 0;
	Point->RecCount = Count;
	if (debug)
	  printf("  Point^.RecCount=%ld\n", Point->RecCount);
	Point->Last = Last;
      }
    }
  } while (bonds != 0);
}


Static Void doLabels()
{
  long mul, gmul, gmpos, ggmul, ggmpos;
  boolean stripped;
  Char STR2[256];
  long FORLIM;
  Char *TEMP;

  if (debug)
    printf("---- and now parse the labels ---------\n");
  if (verbose)
    printf("HeteroAtoms: %ld\n", atoms);
  FORLIM = atoms;
  for (rep = 1; rep <= FORLIM; rep++) {
    fscanf(IFile, "%ld%ld%c", &X1, &Y1, &separator);
    fgets(sss, 256, IFile);
    TEMP = strchr(sss, '\n');
    if (TEMP != NULL)
      *TEMP = 0;
    sprintf(A, "%.*s", strpos2(sss, "\t", 1) - 1, sss);

    if (debug)
      printf("Atom %s X=%ld Y=%ld sss: %s\n", A, X1, Y1, sss);
    if (nobonds)
    {   /*initialize the Point structure if no bonds, only labels, defined*/
      Count++;
      Last = Point;
      Point = (TPoint *)Malloc(sizeof(TPoint));
      Point->X = X1;
      Point->Y = Y1;
      Point->C = 0;
      Point->H = 0;
      Point->N = 0;
      Point->O = 0;
      Point->P = 0;
      Point->S = 0;
      Point->Si = 0;
      Point->B = 0;
      Point->Br = 0;
      Point->Cl = 0;
      Point->F = 0;
      Point->I = 0;
      Point->Mg = 0;
      Point->Na = 0;
      Point->K = 0;
      Point->RecCount = Count;
      Point->Last = Last;
    }
    Current = Point;
    while (Point->Last != NULL) {
      if (labs(Point->X - X1) < Sensi && labs(Point->Y - Y1) < Sensi) {
	if (debug)
	  printf("  [%ld]\n", Point->RecCount);
	Point->C = 0;   /*we substitute -CH_x(-) by -R(-)*/
	Point->H = 0;
	Point->N = 0;
	Point->O = 0;
	Point->P = 0;
	Point->S = 0;
	Point->Si = 0;
	Point->B = 0;
	Point->Br = 0;
	Point->Cl = 0;
	Point->F = 0;
	Point->I = 0;
	Point->Mg = 0;
	Point->Na = 0;
	Point->K = 0;
	mul = 1;
	gmul = 1;
	ggmul = 1;
	while (*A != '\0') {
	  stripped = false;
	  if (strlen(A) >= 5) {
	    sprintf(subs, "%.5s", A);
	    if (strlen(A) > 6) {
	      if (A[5] == '_') {
	       if (A[6]!= '{') {
		sprintf(STR2, "%c", A[6]);
	        if (A[7]=='_') sprintf(STR2, "%c%c", A[6],A[8]);
		code = (sscanf(STR2, "%ld", &mul) == 0);
		}else{
		mul=7;
		while(A[mul]!='}'){STR2[mul-7]=A[mul]; mul++ ; }
		STR2[mul-6]='\0'; 
		code = (sscanf(STR2, "%ld", &mul) == 0);
		}  
	      } else
		mul = 1;
	    }
	    mul *= gmul * ggmul;
	    if (!strcmp(subs, "TBDMS")) {  /*Tert-butyldimethylsilyl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul * 6;
	      Point->H += mul * 15;
	      Point->Si += mul;
	      strcpy(A, strsub(STR2, A, 6, (int)(strlen(A) - 5)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "TBDPS")) {  /*Tert-butyldiphenylsilyl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul * 16;
	      Point->H += mul * 19;
	      Point->Si += mul;
	      strcpy(A, strsub(STR2, A, 6, (int)(strlen(A) - 5)));
	      stripped = true;
	    }
	    if (A[0] == '[') {
	      ggmpos = strpos2(A, "]", 1);
	      if (ggmpos != 0) {
		if (A[ggmpos] == '_') {
	       if (A[ggmpos+1]!= '{') {
		sprintf(STR2, "%c", A[ggmpos+1]);
	        if (A[ggmpos+2]=='_') sprintf(STR2, "%c%c", A[ggmpos+1],A[ggmpos+3]);
		code = (sscanf(STR2, "%ld", &ggmul) == 0);
		}else{
		ggmul=ggmpos+2;
		while(A[ggmul]!='}'){STR2[ggmul-ggmpos-2]=A[ggmul]; ggmul++ ; }
		STR2[ggmul-ggmpos-1]='\0'; 
		code = (sscanf(STR2, "%ld", &ggmul) == 0);
		}  
		} else
		  ggmul = 1;
	      }
	    }
	    if (A[0] == '(') {
	      gmpos = strpos2(A, ")", 1);
	      if (gmpos != 0) {
		if (A[gmpos] == '_') {
	       if (A[gmpos+1]!= '{') {
		sprintf(STR2, "%c", A[gmpos+1]);
	        if (A[gmpos+2]=='_') sprintf(STR2, "%c%c", A[gmpos+1],A[gmpos+3]);
		code = (sscanf(STR2, "%ld", &gmul) == 0);
		}else{
		gmul=gmpos+2;
		while(A[gmul]!='}'){STR2[gmul-gmpos-2]=A[gmul]; gmul++ ; }
		STR2[gmul-gmpos-1]='\0'; 
		code = (sscanf(STR2, "%ld", &gmul) == 0);
		}  
		} else
		  gmul = 1;
	      }
	    }
	  }
	  if (strlen(A) >= 4 && !stripped) {
	    sprintf(subs, "%.4s", A);
	    if (strlen(A) > 5) {
	      if (A[4] == '_') {
	       if (A[5]!= '{') {
		sprintf(STR2, "%c", A[5]);
	        if (A[6]=='_') sprintf(STR2, "%c%c", A[5],A[7]);
		code = (sscanf(STR2, "%ld", &mul) == 0);
		}else{
		mul=6;
		while(A[mul]!='}'){STR2[mul-6]=A[mul]; mul++ ; }
		STR2[mul-5]='\0'; 
		code = (sscanf(STR2, "%ld", &mul) == 0);
		}  
	      } else
		mul = 1;
	    }
	    mul *= gmul * ggmul;
	    if (!strcmp(subs, "DBAM"))
	    {  /*dibutylaminomethylene; =R, used as the N prot.*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul * 9;
	      Point->H += mul * 19;
	      Point->N += mul;
	      strcpy(A, strsub(STR2, A, 5, (int)(strlen(A) - 4)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "DMAM"))
	    {  /*dimethylaminomethylene; =R, used as the N prot.*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul * 3;
	      Point->H += mul * 7;
	      Point->N += mul;
	      strcpy(A, strsub(STR2, A, 5, (int)(strlen(A) - 4)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "DMTr")) {  /*dimethoxytrityl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul * 21;
	      Point->H += mul * 19;
	      Point->O += mul * 2;
	      strcpy(A, strsub(STR2, A, 5, (int)(strlen(A) - 4)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "MMTr")) {  /*monomethoxytrityl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul * 20;
	      Point->H += mul * 16;
	      Point->O += mul;
	      strcpy(A, strsub(STR2, A, 5, (int)(strlen(A) - 4)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "TMTr")) {  /*trimethoxytrityl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul * 22;
	      Point->H += mul * 22;
	      Point->O += mul * 3;
	      strcpy(A, strsub(STR2, A, 5, (int)(strlen(A) - 4)));
	      stripped = true;
	    }
	  }
	  if (strlen(A) >= 3 && !stripped) {
	    sprintf(subs, "%.3s", A);
	    if (strlen(A) > 4) {
	      if (A[3] == '_') {
	       if (A[4]!= '{') {
		sprintf(STR2, "%c", A[4]);
	        if (A[5]=='_') sprintf(STR2, "%c%c", A[4],A[6]);
		code = (sscanf(STR2, "%ld", &mul) == 0);
		}else{
		mul=5;
		while(A[mul]!='}'){STR2[mul-5]=A[mul]; mul++ ; }
		STR2[mul-4]='\0'; 
		code = (sscanf(STR2, "%ld", &mul) == 0);
		}  
	      } else
		mul = 1;
	    }
	    mul *= gmul * ggmul;
	    if (!strcmp(subs, "Ade")) {  /*Adeninyl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul * 5;
	      Point->H += mul * 4;
	      Point->N += mul * 5;
	      strcpy(A, strsub(STR2, A, 4, (int)(strlen(A) - 3)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "BOC")) {  /*Butyloxycarbonyl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul * 5;
	      Point->H += mul * 9;
	      Point->O += mul * 2;
	      strcpy(A, strsub(STR2, A, 4, (int)(strlen(A) - 3)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Cyt")) {  /*Cytosinyl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul * 4;
	      Point->H += mul * 4;
	      Point->N += mul * 3;
	      Point->O += mul;
	      strcpy(A, strsub(STR2, A, 4, (int)(strlen(A) - 3)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Gua")) {  /*Guaninyl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul * 5;
	      Point->H += mul * 4;
	      Point->N += mul * 5;
	      Point->O += mul;
	      strcpy(A, strsub(STR2, A, 4, (int)(strlen(A) - 3)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "iBu")) {  /*iso-Butyl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul * 4;
	      Point->H += mul * 9;
	      strcpy(A, strsub(STR2, A, 4, (int)(strlen(A) - 3)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "iPr")) {  /*2-Propyl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul * 3;
	      Point->H += mul * 7;
	      strcpy(A, strsub(STR2, A, 4, (int)(strlen(A) - 3)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "MOC")) {  /*Methoxycarbonyl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul * 2;
	      Point->H += mul * 3;
	      Point->O += mul * 2;
	      strcpy(A, strsub(STR2, A, 4, (int)(strlen(A) - 3)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "MOM")) {  /*Methoxymethyl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul * 2;
	      Point->H += mul * 5;
	      Point->O += mul;
	      strcpy(A, strsub(STR2, A, 4, (int)(strlen(A) - 3)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "tBu")) {  /*t-Butyl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul * 4;
	      Point->H += mul * 9;
	      strcpy(A, strsub(STR2, A, 4, (int)(strlen(A) - 3)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Thy")) {  /*Thyminyl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul * 5;
	      Point->H += mul * 5;
	      Point->N += mul * 2;
	      Point->O += mul * 2;
	      strcpy(A, strsub(STR2, A, 4, (int)(strlen(A) - 3)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "TMS")) {  /*Trimethylsilyl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul * 3;
	      Point->H += mul * 9;
	      Point->Si += mul;
	      strcpy(A, strsub(STR2, A, 4, (int)(strlen(A) - 3)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Tol")) {  /*tolyl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul * 8;
	      Point->H += mul * 7;
	      Point->O += mul;
	      strcpy(A, strsub(STR2, A, 4, (int)(strlen(A) - 3)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Ura")) {  /*Uracilyl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul * 4;
	      Point->H += mul * 3;
	      Point->N += mul * 2;
	      Point->O += mul * 2;
	      strcpy(A, strsub(STR2, A, 4, (int)(strlen(A) - 3)));
	      stripped = true;
	    }
	  }
	  if (strlen(A) >= 2 && !stripped) {
	    sprintf(subs, "%.2s", A);
	    if (strlen(A) > 3) {
	      if (A[2] == '_') {
	       if (A[3]!= '{') {
		sprintf(STR2, "%c", A[3]);
	        if (A[4]=='_') sprintf(STR2, "%c%c", A[3],A[5]);
		code = (sscanf(STR2, "%ld", &mul) == 0);
		}else{
		mul=4;
		while(A[mul]!='}'){STR2[mul-4]=A[mul]; mul++ ; }
		STR2[mul-3]='\0'; 
		code = (sscanf(STR2, "%ld", &mul) == 0);
		}  
	      } else
		mul = 1;
	    }
	    mul *= gmul * ggmul;
	    if (!strcmp(subs, "Ac")) {  /*acetyl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul * 2;
	      Point->H += mul * 3;
	      Point->O += mul;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Bn")) {  /*benzyl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul * 7;
	      Point->H += mul * 7;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Br")) {  /*bromine*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->Br += mul;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Bu")) {  /*butyl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul * 4;
	      Point->H += mul * 9;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Bz")) {  /*benzoyl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul * 7;
	      Point->H += mul * 5;
	      Point->O += mul;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "CE")) {  /*cyanoethyl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul * 3;
	      Point->H += mul * 4;
	      Point->N += mul;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Cl")) {  /*chlorine*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->Cl += mul;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Et")) {  /*ethyl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul * 2;
	      Point->H += mul * 5;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Me")) {  /*methyl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul;
	      Point->H += mul * 3;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Ms")) {  /*methanesulfonyl, mesyl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul;
	      Point->H += mul * 3;
	      Point->O += mul * 2;
	      Point->S += mul;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Mg")) {  /*magnesium*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->Mg += mul;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Na")) {  /*sodium*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->Na += mul;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Ph")) {  /*phenyl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul * 6;
	      Point->H += mul * 5;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Pr")) {  /*propyl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul * 3;
	      Point->H += mul * 7;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Tf")) {  /*trifluoromethanesulfonyl, triflyl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul;
	      Point->F += mul * 3;
	      Point->O += mul * 2;
	      Point->S += mul;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Tr")) {  /*trityl, triphenylmethyl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul * 19;
	      Point->H += mul * 15;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Ts")) {  /*toluenesulfonyl, tosyl*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->C += mul * 7;
	      Point->H += mul * 7;
	      Point->O += mul * 2;
	      Point->S += mul;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	    if (!strcmp(subs, "Si")) {  /*silicon*/
	      if (debug)
		printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	      Point->Si += mul;
	      strcpy(A, strsub(STR2, A, 3, (int)(strlen(A) - 2)));
	      stripped = true;
	    }
	  }
	  if (strlen(A) < 1 || stripped)
	    continue;
	  sprintf(subs, "%.1s", A);
	  if (strlen(A) > 2) {
	    if (A[1] == '_') {
	       if (A[2]!= '{') {
		sprintf(STR2, "%c", A[2]);
	        if (A[3]=='_') sprintf(STR2, "%c%c", A[2],A[4]);
		code = (sscanf(STR2, "%ld", &mul) == 0);
		}else{
		mul=3;
		while(A[mul]!='}'){STR2[mul-3]=A[mul]; mul++ ; }
		STR2[mul-2]='\0'; 
		code = (sscanf(STR2, "%ld", &mul) == 0);
		}  
	    } else
	      mul = 1;
	  }
	  mul *= gmul * ggmul;
	  if (!strcmp(subs, "B")) {  /*boron*/
	    if (debug)
	      printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	    Point->B += mul;
	  }
	  if (!strcmp(subs, "C")) {  /*carbon*/
	    if (debug)
	      printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	    Point->C += mul;
	  }
	  if (!strcmp(subs, "F")) {  /*fluorine*/
	    if (debug)
	      printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	    Point->F += mul;
	  }
	  if (!strcmp(subs, "H")) {  /*hydrogen*/
	    if (debug)
	      printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	    Point->H += mul;
	  }
	  if (!strcmp(subs, "I")) {  /*iodine*/
	    if (debug)
	      printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	    Point->I += mul;
	  }
	  if (!strcmp(subs, "K")) {  /*potassium*/
	    if (debug)
	      printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	    Point->K += mul;
	  }
	  if (!strcmp(subs, "N")) {  /*nitrogen*/
	    if (debug)
	      printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	    Point->N += mul;
	  }
	  if (!strcmp(subs, "O")) {  /*oxygen*/
	    if (debug)
	      printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	    Point->O += mul;
	  }
	  if (!strcmp(subs, "P")) {  /*phosphorus*/
	    if (debug)
	      printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	    Point->P += mul;
	  }
	  if (!strcmp(subs, "S")) {  /*sulfur*/
	    if (debug)
	      printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	    Point->S += mul;
	  }
	  if (!strcmp(subs, "Z")) {  /*"Z", Benzyloxycarbonyl*/
	    if (debug)
	      printf("  %s*%ld (%ld,%ld)\n", subs, mul, gmul, ggmul);
	    Point->C += mul * 8;
	    Point->H += mul * 7;
	    Point->O += mul * 2;
	  }
	  if (!strcmp(subs, ")"))  /*reset gmul*/
	    gmul = 1;
	  if (!strcmp(subs, "]")) {  /*reset gmul,ggmul*/
	    gmul = 1;
	    ggmul = 1;
	  }
	  if (true)
	    strcpy(A, strsub(STR2, A, 2, (int)(strlen(A) - 1)));
	}
      }
      Point = Point->Last;
    }
    Point = Current;
  }
}


main(argc, argv)
int argc;
Char *argv[];
{
  Char STR1[256], STR2[256];
  Char *TEMP;
  boolean interactive=false;

  PASCAL_MAIN(argc, argv);
  IFile = NULL;
  if (P_argc == 1) {
    printf("enter \"cht -h\" for help\n");
    _Escape(0);
  }
  C = 0;
  H = 0;
  N = 0;
  O = 0;
  P = 0;
  S = 0;
  Si = 0;
  B = 0;
  Br = 0;
  I = 0;
  Cl = 0;
  F = 0;
  Mg = 0;
  Na = 0;
  K = 0;
  verbose = false;
  debug = false;
  fa = false;   /*no file assigned*/
  Count = 0;
  *Alert = '\0';
  for (rep = 1; rep < P_argc; rep++) {
    if (!strcmp(strcpy(STR2, P_argv[rep]), "-v") ||
	!strcmp(strcpy(STR1, P_argv[rep]), "--verbose"))
      verbose = true;
    if (!strcmp(strcpy(STR2, P_argv[rep]), "-d") ||
	!strcmp(strcpy(STR1, P_argv[rep]), "--debug"))
      debug = true;
    if (!strcmp(strcpy(STR2, P_argv[rep]), "-i") ||
	!strcmp(strcpy(STR1, P_argv[rep]), "--interpret"))
      interactive = true;
    if (!strcmp(strcpy(STR2, P_argv[rep]), "-h") ||
	!strcmp(strcpy(STR1, P_argv[rep]), "--help")) {
      printf("The Chemtool drawings analyzer 1.7\n");
      printf("***   Gizmo Head Software   ***\n");
      printf("    Radek Liboska (c) 2001\n\n");
      printf("syntax: cht [-options] <filename.cht>\n\n");
      printf("Recognizes C,H,O,N,P,S,Si,B,Br,I,Cl,F,Mg,Na,K,\n");
      printf(
	"        Ac,Ade,Bn,Bu,Bz,BOC,Cyt,CE,DBAM,DMAM,DMTr,Et,Gua,iBu,iPr,Me,Ms,MOC,\n");
      printf(
	"        MOM,MMTr,Ph,Pr,tBu,Tf,Thy,Tol,Tr,Ts,TBDMS,TBDPS,TMS,TMTr,Ura,Z\n");
      printf("Can handle two levels of parentheses; e.g. P[OCH(CH_3)_2]_3\n\n");
      printf("options:\n");
      printf("        -h or --help : this help\n");
      printf("        -v or --verbose : be verbose\n");
      printf("        -d or --debug : be more verbose\n\n");
      _Escape(0);
    }
    if (strcpy(STR2, P_argv[rep])[0] != '-') {
      strcpy(STR1, P_argv[rep]);
      strcpy(IFile_NAME, STR1);
      fa = true;
    }
  }
  if (!fa && !interactive) {
    printf("No file defined, enter \"cht -h\" for help\n");
    _Escape(1);
  }
  if (!interactive){
  if (IFile != NULL)
    IFile = freopen(IFile_NAME, "r", IFile);
  else
    IFile = fopen(IFile_NAME, "r");
  if (IFile == NULL)
    _EscIO2(FileNotFound, IFile_NAME);
  }else {
  if (IFile)fclose(IFile);
  IFile=tmpfile();
  fprintf(IFile,"Chemtool Version 1.0\ngeometry 100 100\n\bonds 0\natoms 1\n0	 0	%s 	0\n",IFile_NAME);
  rewind(IFile);
  }
  Point = (TPoint *)Malloc(sizeof(TPoint));
  Point->X = 0;
  Point->Y = 0;
  Point->C = 0;
  Point->H = 0;
  Point->N = 0;
  Point->O = 0;
  Point->P = 0;
  Point->S = 0;
  Point->Si = 0;
  Point->B = 0;
  Point->Br = 0;
  Point->Cl = 0;
  Point->F = 0;
  Point->I = 0;
  Point->Mg = 0;
  Point->Na = 0;
  Point->K = 0;
  Point->RecCount = Count;
  Point->Last = NULL;
  Bond = (TBond *)Malloc(sizeof(TBond));
  Bond->X1 = 0;
  Bond->Y1 = 0;
  Bond->X2 = 0;
  Bond->Y2 = 0;
  Bond->RecCount = Count;
  Bond->Last = NULL;
  fgets(sss, 256, IFile);
  TEMP = strchr(sss, '\n');
  if (TEMP != NULL)
    *TEMP = 0;
  sprintf(sss, "%.18s", strcpy(STR1, sss));
  if (strcmp(sss, "Chemtool Version 1")) {
    printf("Not a chemtool 1.x file, enter \"cht -h\" for help\n");
    printf("file starts: %s\n",sss);
    _Escape(2);
  }
  fscanf(IFile, "%*[^\n]");
  getc(IFile);
  fgets(sssb, 7, IFile);
  TEMP = strchr(sssb, '\n');
  if (TEMP != NULL) {
    *TEMP = 0;
    ungetc('\n', IFile);
  }
  fscanf(IFile, "%ld%*[^\n]", &bonds);
  getc(IFile);
  if (bonds == 0)
    nobonds = true;
  if (!strcmp(sssb, "bonds ")) {
    if (bonds > 0)
      doBonds();
  }
  fgets(sssb, 7, IFile);
  TEMP = strchr(sssb, '\n');
  if (TEMP != NULL) {
    *TEMP = 0;
    ungetc('\n', IFile);
  }
  fscanf(IFile, "%ld%*[^\n]", &atoms);
  getc(IFile);
  if (!strcmp(sssb, "atoms ")) {
    if (atoms > 0)
      doLabels();
  }
  if (IFile != NULL)
    fclose(IFile);
  IFile = NULL;
  if (verbose)
    printf("---------------------- Summary -------------------------\n");
  while (Point->Last != NULL) {
    if (verbose)
      printf(
	"RecCount: %ld X=%ld Y=%ld C%ld H%ld N%ld O%ld P%ld S%ld Si%ld B%ld Br%ld Cl%ld F%ld I%ld Mg%ld Na%ld K%ld\n",
	Point->RecCount, Point->X, Point->Y, Point->C, Point->H, Point->N,
	Point->O, Point->P, Point->S, Point->Si, Point->B, Point->Br,
	Point->Cl, Point->F, Point->I, Point->Mg, Point->Na, Point->K);
    C += Point->C;
    H += Point->H;
    N += Point->N;
    O += Point->O;
    P += Point->P;
    S += Point->S;
    Si += Point->Si;
    B += Point->B;
    Br += Point->Br;
    Cl += Point->Cl;
    F += Point->F;
    I += Point->I;
    Mg += Point->Mg;
    Na += Point->Na;
    K += Point->K;

    Point = Point->Last;
  }

  if (H < 0)   /*overlapped bonds*/
    H = 0;

  M = C * 12.011 + H * 1.0079 + N * 14.0067 + O * 15.9994 + P * 30.97376 +
      S * 32.064 + Si * 28.086 + B * 10.81 + Br * 79.904 + Cl * 35.453 +
      F * 18.9984 + I * 126.9045 + Mg * 24.305 + Na * 22.98977 + K * 39.098;
  Me = C * 12 + H * 1.007825037 + N * 14.003074008 + O * 15.99491464 +
       P * 30.9737634 + S * 31.9720718 + Si * 27.9769284 + B * 11.0093053 +
       Br * 78.9183361 + Cl * 34.968852729 + F * 18.99840325 +
       I * 126.904477 + Mg * 23.9850450 + Na * 22.9897697 + K * 38.9637079;

  if (Me > 0 && *Alert == '\0') {
    if (C > 1)
      printf("C%ld", C);
    if (C == 1)
      putchar('C');
    if (H > 1)
      printf("H%ld", H);
    if (H == 1)
      putchar('H');
    if (N > 1)
      printf("N%ld", N);
    if (N == 1)
      putchar('N');
    if (O > 1)
      printf("O%ld", O);
    if (O == 1)
      putchar('O');
    if (P > 1)
      printf("P%ld", P);
    if (P == 1)
      putchar('P');
    if (S > 1)
      printf("S%ld", S);
    if (S == 1)
      putchar('S');
    if (Si > 1)
      printf("Si%ld", Si);
    if (Si == 1)
      printf("Si");
    if (B > 1)
      printf("B%ld", B);
    if (B == 1)
      putchar('B');
    if (Br > 1)
      printf("Br%ld", Br);
    if (Br == 1)
      printf("Br");
    if (Cl > 1)
      printf("Cl%ld", Cl);
    if (Cl == 1)
      printf("Cl");
    if (F > 1)
      printf("F%ld", F);
    if (F == 1)
      putchar('F');
    if (I > 1)
      printf("I%ld", I);
    if (I == 1)
      putchar('I');
    if (Mg > 1)
      printf("Mg%ld", Mg);
    if (Mg == 1)
      printf("Mg");
    if (Na > 1)
      printf("Na%ld", Na);
    if (Na == 1)
      printf("Na");
    if (K > 1)
      printf("K%ld", K);
    if (K == 1)
      putchar('K');

    printf(" [%2.3f]", M);
    printf(" Me=%2.10f ", Me);

    if (C > 0)
      printf("%4.2f%%C;", C * 12.011 * 100 / M);
    if (H > 0)
      printf("%4.2f%%H;", H * 1.0079 * 100 / M);
    if (B > 0)
      printf("%4.2f%%B;", B * 10.81 * 100 / M);
    if (N > 0)
      printf("%4.2f%%N;", N * 14.0067 * 100 / M);
    if (O > 0)
      printf("%4.2f%%O;", O * 15.9994 * 100 / M);
    if (P > 0)
      printf("%4.2f%%P;", P * 30.97376 * 100 / M);
    if (S > 0)
      printf("%4.2f%%S;", S * 32.0640 * 100 / M);
    if (K > 0)
      printf("%4.2f%%K;", K * 39.098 * 100 / M);
    if (Mg > 0)
      printf("%4.2f%%Mg;", Mg * 24.305 * 100 / M);
    if (Na > 0)
      printf("%4.2f%%Na;", Na * 22.98977 * 100 / M);
    if (Si > 0)
      printf("%4.2f%%Si;", Si * 28.086 * 100 / M);
    if (Br > 0)
      printf("%4.2f%%Br;", Br * 79.904 * 100 / M);
    if (Cl > 0)
      printf("%4.2f%%Cl;", Cl * 35.453 * 100 / M);
    if (F > 0)
      printf("%4.2f%%F;", F * 18.9984 * 100 / M);
    if (I > 0)
      printf("%4.2f%%I;", I * 126.9045 * 100 / M);
  } else {
    if (*Alert != '\0')
      printf("%s overlapped bonds !", Alert);
    else
      printf("C0H0 [0.00] Me=0.0000000000 0.00%%C;0.00%%H");
  }
  putchar('\n');
  exit(EXIT_SUCCESS);
}



/* End. */
