/***************************************************************************
                          player_data_events.cpp  -  description
                             -------------------
    begin                : Fri Feb 2 2001
    copyright            : (C) 2001 by Juan Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "player_data.h"
#include <stdio.h>

/*
	  setup_voices():

This will go throught all the REAL channels, if it finds a channel
that needs to be restarted or assigned a new VIRTUAL channel, then it
will just find one and do it.

*/


void Player_Data::setup_voices() {

	int i,voice_index;


	for (i=0;i<PATTERN_WIDTH;i++) {

		voice_index=-1;

		if (control.channel[i].note_delay) continue;


		// check if we need a new empty voice
		if (control.channel[i].kick==KICK_NOTE) {

			/* if no channel was cut above, find an empty or quiet channel
			   here */
			if ( song->variables.use_instruments && !control.force_no_nna) {

				if (control.channel[i].slave_voice==NULL) { // no slave??

					int newchn;
					if ((newchn=find_empty_voice())!=-1) {

						control.channel[i].slave_voice_index=newchn;
						control.channel[i].slave_voice=voice[newchn];
					}
				}

			} else  {
				if (i<control.max_voices) {

					control.channel[i].slave_voice_index=i;
					control.channel[i].slave_voice=voice[i];
                                } else {
					//This is a _DIRTY_ hack, but i cant think a better way.
					control.channel[i].slave_voice_index=control.max_voices-1;
					control.channel[i].slave_voice=voice[control.max_voices-1];
				}
				
			}


			/* assign parts of MP_VOICE only done for a KICK_NOTE */
			if ( ( control.channel[i].slave_voice!=NULL ) ) {

				voice_index=control.channel[i].slave_voice_index;
				
				
				if (voice[voice_index]->has_master_channel && (voice[voice_index]->master_channel!=NULL) ) {
                                        // If this voice already has a master channel, make sure to remove the reference to it.
					voice[voice_index]->master_channel->slave_voice=NULL;

				}
				//notify the voice that the current channel is the master
				voice[voice_index]->master_channel=&control.channel[i];
				//set the voice as slave of the current channel
				control.channel[i].slave_voice=voice[voice_index];
				//master channel index of the voice
				voice[voice_index]->master_channel_index=i;
				voice[voice_index]->has_master_channel=true;
			}

		} else {
                // nope..
                        // so if we DO have a slave voice then use it.
			if ( control.channel[i].slave_voice!=NULL ) {
			
				voice_index=control.channel[i].slave_voice_index;
			}
		}
                //assuming this channel has a slave voice..
		if (voice_index>=0) {

			// IMPROVE: Code a method for this:
			voice[voice_index]->update_info_from_master_channel();
		}

		control.channel[i].kick=KICK_NOTHING;
	}
}
void Player_Data::Voice_Control::reset() {

	memset(this,0,sizeof(*this));

	instrument_ptr=NULL;
	sample_ptr=NULL;
	has_master_channel=false;
	instrument_index=-1;
	reverb_send=0;
	filter.it_cutoff=255;
	filter.it_reso=0;
	
}

void Player_Data::Channel_Control::reset() {

	memset(this,0,sizeof(*this));

	slave_voice=NULL;
	slave_voice_index=255;
	mute=false;
	old_note=255;
	real_note=255;
	instrument_index=255;
	filter.it_cutoff=255;
	filter.it_reso=0;
	reverb_send=0;
	
}

void Player_Data::Voice_Control::update_info_from_master_channel() {

	instrument_ptr=master_channel->instrument_ptr;
	sample_ptr=master_channel->sample_ptr;

	instrument_index=master_channel->instrument_index;

	note=master_channel->note;
	output_volume=master_channel->output_volume;

	channel_volume=master_channel->channel_volume;

	panning=master_channel->panning;

	kick=master_channel->kick;
	note_end_flags=master_channel->note_end_flags;
	period=master_channel->period;

	volume_envelope_ctrl.active=master_channel->volume_envelope_on;
	panning_envelope_ctrl.active=master_channel->panning_envelope_on;
	pitch_envelope_ctrl.active=master_channel->pitch_envelope_on;

	base_speed=master_channel->base_speed;

	NNA_type=master_channel->NNA_type;
	reverb_send=master_channel->reverb_send;

//	last_note_type=master_channel->last_note_type;

	sample_start_index=master_channel->sample_start_index;
	filter=master_channel->filter;

}


void Player_Data::update_mixer() {

	int tmp_mixer_period;
	Sint32 tmp_vibrato_value,tmp_vibrato_depth,tmp_volenv_value;
	Uint64 tmpvol; // 64bits should be the only way to avoid getting notes raped out
	int i;


	control.voices_used=0;

	for (i=0;i<control.song_voices;i++) {

	         int filter_env=-1;
		
		//if voice doesnt have a sample set or size is 0.. forget it
		if ( (voice[i]->sample_ptr==NULL) || (voice[i]->sample_ptr->data.size==0)) continue;


		//TODO set limits somewhere else

		if (voice[i]->period<40) {
		
			voice[i]->period=40;

		} else if (voice[i]->period>50000) {

			voice[i]->period=50000;
		}


		if ((voice[i]->kick==KICK_NOTE)||(voice[i]->kick==KICK_NOTEOFF)) {

			int real_start_index;

			if (voice[i]->sample_start_index==-1) {

				real_start_index=0;

			} else {

				real_start_index=voice[i]->sample_start_index;
			}

			mixer->setup_voice(i,&voice[i]->sample_ptr->data,real_start_index);
			voice[i]->fadeout_volume=512;
			voice[i]->auto_vibrato_sweep_pos=0;
	
		

		}


		/* Start Envelopes */	
               	if ( song->variables.use_instruments && ((voice[i]->kick==KICK_NOTE)||(voice[i]->kick==KICK_ENVELOPE))) {
	
			voice[i]->start_envelope(&voice[i]->instrument_ptr->volume.envelope,&voice[i]->volume_envelope_ctrl);
			voice[i]->start_envelope(&voice[i]->instrument_ptr->panning.envelope,&voice[i]->panning_envelope_ctrl);
			voice[i]->start_envelope(&voice[i]->instrument_ptr->pitch.envelope,&voice[i]->pitch_envelope_ctrl);
		}

		voice[i]->kick=KICK_NOTHING;

               	if (song->variables.use_instruments) {

			voice[i]->process_envelope(&voice[i]->instrument_ptr->volume.envelope,&voice[i]->volume_envelope_ctrl);
			voice[i]->process_envelope(&voice[i]->instrument_ptr->panning.envelope,&voice[i]->panning_envelope_ctrl);
			voice[i]->process_envelope(&voice[i]->instrument_ptr->pitch.envelope,&voice[i]->pitch_envelope_ctrl);

			if (voice[i]->volume_envelope_ctrl.terminated) {

				if (voice[i]->volume_envelope_ctrl.kill) {
	
					voice[i]->fadeout_volume=0;
				} else {

					voice[i]->note_end_flags|=END_NOTE_FADE;
                                }
			}
				
		}

		if (song->variables.use_instruments) {

			tmp_volenv_value=voice[i]->volume_envelope_ctrl.value;
		} else {

			tmp_volenv_value=64;

		}

		tmpvol=(Uint64)voice[i]->fadeout_volume;    /* max 512 */
		tmpvol*=(Uint64)voice[i]->channel_volume;    /* * max 64 */
		tmpvol*=(Uint64)voice[i]->output_volume;     /* * max 256 */
		voice[i]->total_volume=(tmpvol/0x4000)<<4; /* totalvolume used to determine samplevolume */
		tmpvol*=(Uint64)song->variables.mixing_volume; /* max 128 */
		tmpvol*=(Uint64)control.global_volume;   /* max 128 */
		tmpvol*=(Uint64)tmp_volenv_value; /* max 64 */
		tmpvol>>=34;//0x200000;


		if ((voice[i]->master_channel!=NULL) && song->initial_variables.channel[voice[i]->master_channel_index].mute) {

			mixer->set_voice_volume(i,0);
		} else {
			mixer->set_voice_volume(i,tmpvol);
			if (voice[i]->fadeout_volume>0) control.voices_used++;
		}

        	
	        if (!song->variables.use_stereo) {

			mixer->set_voice_panning(i,PAN_CENTER);

		} else if (voice[i]->panning==PAN_SURROUND) {

			mixer->set_voice_panning(i,PAN_SURROUND);
		} else if (song->variables.use_instruments) {

			int newpan,real_modifier;

			real_modifier=(voice[i]->panning_envelope_ctrl.value*(PAN_CENTER-abs(voice[i]->panning-PAN_CENTER)))/32;

			newpan=voice[i]->panning+real_modifier;

			newpan=(newpan<PAN_LEFT)?PAN_LEFT:(newpan>PAN_RIGHT)?PAN_RIGHT:newpan;
			
			mixer->set_voice_panning(i,newpan);
		} else {
			mixer->set_voice_panning(i,voice[i]->panning);
		}



		/* VIBRATO */

		if ( (voice[i]->period>0) && (voice[i]->sample_ptr->vibrato_depth>0) ) {

			switch (voice[i]->sample_ptr->vibrato_type) {
				case 0:
					tmp_vibrato_value=auto_vibrato_table[voice[i]->auto_vibrato_pos&127];
					if (voice[i]->auto_vibrato_pos & 0x80) tmp_vibrato_value=-tmp_vibrato_value;
					break;
				case 1:
					tmp_vibrato_value=64;
					if (voice[i]->auto_vibrato_pos & 0x80) tmp_vibrato_value=-tmp_vibrato_value;
					break;
				case 2:
					tmp_vibrato_value=63-(((voice[i]->auto_vibrato_pos+128)&255)>>1);
					break;
				default:
					tmp_vibrato_value=(((voice[i]->auto_vibrato_pos+128)&255)>>1)-64;
					break;
			}
		} else {

			tmp_vibrato_value=0;
		}


		if ((voice[i]->auto_vibrato_sweep_pos>>8)<voice[i]->sample_ptr->vibrato_depth) {

			voice[i]->auto_vibrato_sweep_pos+=voice[i]->sample_ptr->vibrato_speed; //FIXME - speed? i think so
			tmp_vibrato_depth=voice[i]->auto_vibrato_sweep_pos;

		} else {

			tmp_vibrato_depth=voice[i]->sample_ptr->vibrato_depth<<8;
		}

		tmp_vibrato_value=(tmp_vibrato_value*tmp_vibrato_depth)>>16;

		
		

		// Linear WHAT?

		voice[i]->period-=tmp_vibrato_value;

		/* update vibrato position */
		voice[i]->auto_vibrato_pos=(voice[i]->auto_vibrato_pos+voice[i]->sample_ptr->vibrato_rate)&0xff;

		/* external vibrato */
		
		if (control.external_vibrato) {
		
			if ( (voice[i]->master_channel!=NULL) && (voice[i]->master_channel->doing_vibrato) )
				mixer->set_voice_vibrato(i,voice[i]->master_channel->vibrato_speed,voice[i]->master_channel->vibrato_depth);
			else
				mixer->set_voice_vibrato(i,0,0);					
		}
			
		

		
		
		
		/* process pitch envelope */
		tmp_mixer_period=voice[i]->period;

		if (voice[i]->pitch_envelope_ctrl.active) {

			long aux_pitch_diff;
			int pe_value=voice[i]->pitch_envelope_ctrl.value;
			
			if (!voice[i]->instrument_ptr->pitch.use_as_filter) {
			
				if (((Uint16)voice[i]->note<<1)+pe_value<=0) pe_value=-(voice[i]->note<<1);
	
				aux_pitch_diff=get_period(((Uint16)voice[i]->note<<1)+pe_value,voice[i]->base_speed)-get_period(((Uint16)voice[i]->note<<1),voice[i]->base_speed);
	
				if ( ((int)tmp_mixer_period-aux_pitch_diff)<0 ) aux_pitch_diff=0;
	
				tmp_mixer_period+=aux_pitch_diff;
			} else {

				filter_env=pe_value+32; //max 64
//			        printf("pitch envelope at %i",filter_env);
			
			}
		}

		if (voice[i]->fadeout_volume==0) { /* check for a dead note (fadevol=0) */

			mixer->stop_voice(i);

		} else {

			mixer->set_voice_frequency(i,get_frequency(tmp_mixer_period));

			/* if keyfade, start substracting fadeoutspeed from fadevol: */
			if ((song->variables.use_instruments)&&(voice[i]->note_end_flags & END_NOTE_FADE)) {

				if (voice[i]->fadeout_volume>=(voice[i]->instrument_ptr->volume.fadeout)) {

					voice[i]->fadeout_volume-=(voice[i]->instrument_ptr->volume.fadeout);
				} else {

					voice[i]->fadeout_volume=0;
				}
			}
			
			/*FILTARSSSSSSSS*/


					
			voice[i]->filter.envelope_cutoff=filter_env;
			
	                voice[i]->filter.recalculate_coheficients(mixer->get_mix_frequency());
	
	                if ((voice[i]->filter.final_cutoff<0xFF) && (control.filters)) {
	
				mixer->set_voice_filter(i,voice[i]->filter.coef1,voice[i]->filter.coef2, voice[i]->filter.coef3,true);
	                } else {
	
				mixer->set_voice_filter(i,0,0,0,false);
	                }
	
	                /* RAIVERV */
	
       			mixer->set_voice_reverb_send(i,voice[i]->reverb_send);


                }
	}
}








void Player_Data::handle_tick() {

	int i;


	if ( mixer==NULL ) return;
	if ( song==NULL ) return;


	/* update time counter (sngtime is in milliseconds (in fact 2^-10)) */

	if (control.ticks_counter>=control.speed) { // time to process... ***THE ROW***!

		/* process pattern-delay. pf->patdly2 is the counter and pf->patdly is
		   the command memory. */

//		if (control.pattern_delay_1) {

//			control.pattern_delay_2=control.pattern_delay_1;
//			control.pattern_delay_1=0;
//		}
//		if (control.pattern_delay_2) {
//			 patterndelay active
//			if (--control.pattern_delay_2)
//				 so turn back pf->patpos by 1
//				if (pf->patpos) pf->patpos--;
//		}

		if (control.play_mode!=PLAY_NOTHING) {

			control.ticks_counter=0;
	

			if (control.position.force_next_order>=0) {

				control.position.current_order=control.position.force_next_order;				
			}

			control.position.force_next_order=-1;			

			control.previous_position=control.position; // for those special cases...
                        control.position.forbid_jump=false;

			for (i=0;i<PATTERN_WIDTH;i++) {

				process_note(i,song->get_pattern(control.position.current_pattern)->get_note(i,control.position.current_row));
			}

			control.position.current_row++;
		
			if ( control.position.current_row>=song->get_pattern(control.position.current_pattern)->get_length() ) {

				if (control.play_mode==PLAY_SONG) {

					int next_order;

					next_order=song->get_next_order(control.position.current_order);

					if (next_order!=-1) {
						// Do we have a "next order?"
						control.position.current_pattern=song->get_order(next_order);
						if (next_order<=control.position.current_order) control.reached_end=true;
						control.position.current_order=next_order;
					
					} else {
						// no, probably the user deleted the orderlist.
						control.play_mode=PLAY_NOTHING;
						reset();
						control.reached_end=true;
					}
				}
				control.position.current_row=0;
			}

		}


	}



	pre_process_effects();
	process_NNAs();
	setup_voices();

	/* now set up the actual hardware channel playback information */
	update_mixer();

	control.ticks_counter++;
}