/***************************************************************************
                          envelope.h  -  description
                             -------------------
    begin                : Sun Mar 25 2001
    copyright            : (C) 2001 by Juan Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef ENVELOPE_H
#define ENVELOPE_H

#include "typedefs.h"
/**envelope?
  *@author Juan Linietsky
  */

/******************************
 envelope.h
 ----------

Proovides an envelope, and basic functions
for it that can be used for both player
and interface
********************************/

#define NO_ENVELOPE_POINT -5000
#define MAX_ENVELOPE_POINTS 25

struct Envelope {

	struct Point {
	
		Uint16 tick_offset;
		Sint16 value;
	};

	Point node[MAX_ENVELOPE_POINTS];
	
	Sint8 node_count;

	bool on;
	bool carry;

	bool loop_on;

	Uint8 loop_begin_node;
	Uint8 loop_end_node;

	bool sustain_loop_on;
	Uint8 sustain_loop_begin_node;
	Uint8 sustain_loop_end_node;

	Sint8 max_value;
	bool envelope_signed;

	void set_max(Sint8 p_max) { max_value=p_max; }
	Sint8 get_max() { return max_value; }

	void set_signed(bool p_signed) { envelope_signed=p_signed; }
	bool is_signed() { return envelope_signed; }

	void set_position(int p_node,int p_x,int p_y);
	int add_position(int p_x,int p_y);
	void del_position(int p_node);

	void set_loop_begin(int pos);
	void set_loop_end(int pos);

	void set_sustain_loop_begin(int pos);
	void set_sustain_loop_end(int pos);

	void reset();
	int get_height_at_pos(int pos);

	Envelope();
		
};
#endif
