#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "chinese.h"
#include "input.h"
static char *macrostr[26];
void Init_macrokey()
{
    FILE *fp;
    char *macrofile = getenv("CHDRV_MACRO");
    char buf[256];
    int lineno,i;

    if (macrofile == NULL)
      macrofile = CHSYS"chdrv.mac";
    for(i=0;i<26;i++)
      macrostr[i] = NULL;

    fp = fopen(macrofile,"r");
    if (fp == NULL)
      {
	  printf("Can't open macro file\n");
	  return;
      }
    lineno = 1;
    while(fgets(buf,256,fp))
      {
	  char *ss,*str;
	  int no;

	  ss = buf;
	  while(*ss&&isspace(*ss)) ss++;
	  if (*ss == '#')
	    continue;
	  while(*ss&&(*ss!= ' ')&&(*ss!='\t')&&(*ss!='\n')) ss++;
	  *ss = 0;
	  ss++;
	  while(*ss&&((*ss==' ')||(*ss=='\t')||(*ss=='\n'))) ss++;
	  str = ss;
	  while(*ss&&(*ss!= ' ')&&(*ss!='\t')&&(*ss!='\n')) ss++;
	  *ss = 0;

	  if (buf[1] != 0)
	    {
		printf("line %d:index error,only allow one char\n",lineno);
	    }
	  else
	    if ((*buf <= 'z') && (*buf >= 'a'))
	      {
		  if (macrostr[*buf-'a'])
		    free(macrostr[*buf-'a']);
		  macrostr[*buf-'a'] = strdup(str);
	      }
	    else
	      printf("line %d:index %c is not valid\n",lineno,*buf);
	  lineno++;
      }
    fclose(fp);
}

char * add_macrokey(char *key,char *buf)
{
    int no;

    no = atoi(key);

    if ((no < 0 ) || (no > 26))
      SYSERR1("index %d too large",no);
    else
      {
	  SYSERR1("index %d",no);
	  if (macrostr[no])
	    {
		if (method!=0)
		  *buf++ = -1;
		strcpy(buf,macrostr[no]);
		buf += strlen(macrostr[no]);
		if (method!=0)
		  *buf++ = -1;
	    }
      }
    return buf;
}
    

