/************************************************************************
    filename:   CEGUIFalNamedArea.cpp
    created:    Sun Jun 26 2005
    author:     Paul D Turner <paul@cegui.org.uk>
*************************************************************************/
/*************************************************************************
    Crazy Eddie's GUI System (http://www.cegui.org.uk)
    Copyright (C)2004 - 2005 Paul D Turner (paul@cegui.org.uk)
 
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.
 
    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.
 
    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*************************************************************************/
#include "falagard/CEGUIFalNamedArea.h"
#include <iostream>

// Start of CEGUI namespace section
namespace CEGUI
{
    NamedArea::NamedArea(const String& name) :
        d_name(name)
    {
    }

    const String& NamedArea::getName() const
    {
        return d_name;
    }

    const ComponentArea& NamedArea::getArea() const
    {
        return d_area;
    }

    void NamedArea::setArea(const ComponentArea& area)
    {
        d_area = area;
    }

    void NamedArea::writeXMLToStream(OutStream& out_stream) const
    {
        out_stream << "<NamedArea name=\"" << d_name << "\">" << std::endl;
        d_area.writeXMLToStream(out_stream);
        out_stream << "</NamedArea>" << std::endl;
    }

} // End of  CEGUI namespace section
