#
# 	Construction et gestion de la fenetre principale
# 	(c) 1995-7 Alexandre Burton & Jean Piche
# 	v. 1.80a (10/08/97)
#
#       EDITED BY Hans-Christoph Steiner <hans@eds.org>
#       $Id $

proc bindHelp {window message} {
    global globalAssist helpLine
    bind $window <Enter> "set globalAssist \"$helpLine($message)\""
    bind $window <Leave> "set globalAssist {}"
    return $window
}

proc showHelp {args} {
    global path helpLine
    bug showHelp $args
    if [llength $args] {set s $helpLine($args)} {set s {}}
    $path(winHelp) config -text $s	
    $path(editHelp) config -text $s
    $path(graphHelp) config -text $s
    if [winfo exists $path(prefHelp)] {$path(prefHelp) config -text $s}
}

proc showRef {args} {
    global path refLine
    $path(editHelp) config -text $refLine($args)
}

proc toggleAssist {} {
    global prefs path
    if $prefs(assist) { 
	grid $path(win).help -row 4 -column 0 -sticky news -padx 5 -pady 5
	pack $path(edit).help -side bottom -anchor sw  -fill x
	pack .pre.help -side bottom -anchor sw  -fill x
    } {
	grid forget $path(win).help
	pack forget $path(edit).help
	pack forget .pre.help
    }
}

proc switchGlobalMode {} {
    global prefs path
    if !$prefs(globalMode) {
	$path(winOut).rates.edit config -state disabled
	$path(winOut).rates.play config -state disabled
	$path(winOut).rates.send config -state disabled
	$path(winOutDUR) config -fg gray50
	$path(winOutNom) config -fg gray50
	$path(winOutNom) config -state disabled
#	$path(winOut).output.spk config -fg black
    } {
	$path(winOut).rates.edit config -state normal
	$path(winOut).rates.play config -state normal
	$path(winOut).rates.send config -state normal
	$path(winOutDUR) config -fg black
	$path(winOutNom) config -fg black
	$path(winOutNom) config -state normal
#	$path(winOut).output.spk config -fg gray50
    }
}

proc makeInfoWindow {} {

    modebug building: soundwindow

    global path tcl_platform  globalMode globalAssist cfont color
    global prefs lan soundName dpi ceclib CSversion utik nchnls soundOutInfo
	
    pack [frame $path(win)  -bd 0] -fill both 
    wm title . "$CSversion"

    switch -- $tcl_platform(platform) {
	irix 		{wm iconname . "Cecilia"; }
	macintosh 	{wm geometry . +3+23}
    }
    wm geometry . $prefs(geom,.)

    createInfoWindowMenu

    ######################################
    ###    Header
    
    grid [label $path(winModule) -bd 0 -text "(no module loaded)"] \
	    -column 0 -row 0 -sticky news -pady 0 -padx 5
    bindHelp $path(winModule)  LWinNoModule
    
    
    ######################################
    ###    Transports
    
    grid [frame $path(trans) -relief sunken -bd 2] -column 0 -row 1 -sticky news -pady 5 -padx 5
    buildTransports

    ######################################
    ###    SoundOUT frame 	
    
    grid [frame $path(winOut) -relief groove -bd 2] -column 0 -row 2 -sticky news  -pady 5 -padx 5
    
    ### Header ###
    grid [label $path(winOut).l   -text "Output Information"] \
	    -row 0 -column 0 -sticky news		
    
    ### Output info ###
    grid [frame $path(winOut).output ] \
	    -column 0 -row 1 -sticky news -padx 2
        
    grid [label $path(winOut).output.spk  -text "|<" -justify left] \
	    -row 0 -column 0 -sticky news
    
    switch -- $tcl_platform(os) {
		"MacOS"   {set pad 4}
		"Windows" {set pad 0}
		"IRIX"    {set pad 6}
		"Linux"   {set pad 2}
# This number is a total guess -HCS
		"Darwin"  {set pad 2}
    }
    
    grid [radiobutton $path(winOut).output.rmode -indicatoron 0 \
	    -padx $pad -pady $pad -text "DAC" -justify left\
	    -variable prefs(globalMode) -value 0 -command switchGlobalMode] \
	    -row 0 -column 1 -sticky e 
    
    grid [radiobutton $path(winOut).output.dmode -indicatoron 0 \
	    -padx $pad -pady $pad -text "Disk ->" -justify left\
	    -variable prefs(globalMode) -value 1 -command switchGlobalMode] \
	    -row 0 -column 2 -sticky w
        
    grid [entry $path(winOutNom) -justify left ]  -row 0 -column 3 -sticky we -padx 5
    
    grid [label $path(winOutDUR)  -width 5 -justify right \
	    -textvariable soundOutInfo(duree) ]   -row 0 -column 4 -sticky news
    
    grid [label $path(winOut).output.s -justify left  \
	    -text s.] -row 0 -column 5 -sticky news
    
    
    switch -- $tcl_platform(os) {
	"MacOS"   {set pad 2}
	"IRIX"    {set pad 10}
	"Linux"   {set pad 2}
# This number is a total guess -HCS
	"Darwin"   {set pad 2}
    }
    
   
    $path(winOutDUR) config -fg gray50
    
    bindHelp $path(winOut).l LWinOut
    #	bindHelp $path(winOut).output.spk LWinOutSpk
    #    bindHelp $path(winOut).output.edit bWinEdit
    bindHelp $path(winOut).output.rmode tWinOutRMode
    bindHelp $path(winOut).output.dmode tWinOutDMode
    #    bindHelp $path(winOut).output.play bWinPlay
    bindHelp $path(winOutNom) LWinOutName
    bindHelp $path(winOutDUR) LWinOutDur
    
    ### Output rates & sizes ###
    grid [frame $path(winOut).rates] -column 0 -row 2 -sticky news
    
    bug "	making the damn little popups..."
    foreach item {SR KSM KR GEN} {
	eval optMenu $path(winOut$item) soundOutInfo(user$item) {"adjustRates $item"} \
		{"$cfont(small)"} ${color} 7 1 $soundOutInfo(possible$item)
	bindHelp $path(winOut$item) oWinOut$item
    }
    bug "	...done with them!"
    
    grid columnconfigure $path(winOut).rates 2 -weight 10
    grid columnconfigure $path(winOut).rates 5 -weight 10
    grid columnconfigure $path(winOut).rates 7 -pad 2
    grid configure $path(winOut).rates -ipady 2 -ipadx 2
    
    grid [label $path(winOut).rates.labSR  -text "sr: " -justify left] \
	    -column 0 -row 0 -sticky e
    grid $path(winOutSR) -column 1 -row 0 -sticky ew
    
    grid [label $path(winOut).rates.labkr  -text "kr: " -justify left] -column 0 -row 1 -sticky e
    grid $path(winOutKR) -column 1 -row 1 -sticky ew
    
    grid [label $path(winOut).rates.labksm  -text "ksmps: " -justify left ] -column 0 -row 2 -sticky e
    grid $path(winOutKSM) -column 1 -row 2 -sticky ew
    
    grid [label $path(winOut).rates.labgen -text "gen size: " ] -column 0 -row 3 -sticky e
    grid $path(winOutGEN)  -column 1 -row 3 -sticky ew -pady 1

    grid [frame $path(winOut).rates.nchnls] -row 2 -column 5 -columnspan 3 -rowspan 2 -sticky e
    pack [label $path(winOut).rates.nchnls.labchn -text "channels: "] -side left
    
    foreach chn $soundOutInfo(possibleCHN) {
	pack [radiobutton $path(winOut).rates.nchnls.$chn  -disabledforeground ${color}4  \
		 -pady 0 -padx 0 -text $chn  -indicatoron 0 -width 6 -justify center \
		-variable soundOutInfo(userCHN) -value $chn] -side left
	$path(winOut).rates.nchnls.$chn config -state disabled
	bindHelp $path(winOut).rates.nchnls.$chn rWinOutChn
    }
    
    button $path(winOut).rates.play -image play  -state disabled \
	    -command {playSound $soundName $path(winOut).output.play}
    
    button $path(winOut).rates.edit -image edi  \
	    -state disabled -command {editSoundFile $soundName} 

    button $path(winOut).rates.send  -image cycle \
	    -state disabled -command {sendfile $soundName}

    if {$tcl_platform(platform) != "Windows"} {			
	grid $path(winOut).rates.edit -row 0 -column 6 -rowspan 2 -sticky ew -pady $pad
	grid $path(winOut).rates.play -row 0 -column 7 -rowspan 2 -sticky ew -pady $pad
	grid $path(winOut).rates.send -row 0 -column 8 -rowspan 2 -sticky ew -pady $pad
    }
 
     bindHelp $path(winOut).rates.edit bWinEdit
    bindHelp $path(winOut).rates.play bWinPlay
    bindHelp $path(winOut).rates.send bWinSend

    ### Amplitudes Information ###
    frame $path(winOut).amps -bd 2 -relief groove  
    pack [label $path(winOutAmp) -text "" ] \
	    -side left -fill x -expand y
    if {$tcl_platform(platform) == "unix"} {
	grid $path(winOut).amps   -column 0 -row 3 -sticky news
    }
    bindHelp $path(winOutAmp) LWinOutAmp
    
    ######################################
    ###    Input Info
    
    frame $path(winIn) -relief groove -bd 3  
    frame $path(winIn).f   
    label $path(winIn).l  -text "Input(s) Information" -bg gray50
    bindHelp $path(winIn).l LWinIn
    
    ######################################
    ###    Assistance
    
    frame $path(win).help -relief groove -bd 2
    pack [label $path(winHelp) -justify left -anchor w -textvariable globalAssist] -fill x -anchor w
    bindHelp $path(winHelp) LWinHelp
    
    if $prefs(assist) { grid $path(win).help -row 4 -column 0 -sticky news -padx 5 -pady 5 }
    
    ###
    ######################################
    
    set soundOutInfo(userSR)  $prefs(sr)
    set soundOutInfo(userKSM) $prefs(ksm)
    set soundOutInfo(userGEN) $prefs(gen)
    set soundOutInfo(userKR)  $prefs(kr)
    set soundOutInfo(oldrateSR)  $prefs(sr)
    set soundOutInfo(oldrateKSM) $prefs(ksm)
    set soundOutInfo(oldrateGEN) $prefs(gen)
    set soundOutInfo(oldrateKR)  $prefs(kr)
    
    bindsoundwin $path(win)
    bind $path(win) <Leave> windowsMenu

    bug SoundWindow Complete

}

proc sendfile {p} {
    global value soundInInfo path prefs
    set f [file join $prefs(SFDIR) [$path(winOutNom) get]]
    bug p: $p f: $f s: [array exists soundInInfo] tail: [file tail $f]
    if {[file exists $f]&&[array exists soundInInfo]} {
	set value([lindex [array names soundInInfo] 0]) $f 
	getSoundInfo [lindex [array names soundInInfo] 0]
    }
}

proc getRate {rate} {
	global  soundOutInfo path
	catch {destroy .rate}
	toplevel .rate
	set xx [expr 130 +[winfo x .]]
	set yy [expr 170 +[winfo y .]]
        wm geometry .rate 350x25+$xx+$yy
	pack [label .rate.l -text "New $rate value:"] -side left
	pack [entry .rate.e] -side left
	pack [button .rate.b -text OK -command "setRate $rate 0"] -side left
	pack [button .rate.c -text Cancel -command "setRate $rate 1"] -side left
	bind .rate <Return> {.rate.b invoke}
	focus .rate.e
	grab set .rate
}
		
proc setRate {rate w} {
	global  soundOutInfo
	if $w {
	    set soundOutInfo(user$rate) $soundOutInfo(oldrate$rate)
	    grab release .rate ;  destroy .rate ;
	    return
	}	
	set tt [.rate.e get]
	set re [catch {set gg [expr $tt]}]
	if $re {bell;return}
	grab release .rate ;  destroy .rate ;
	set soundOutInfo(user$rate) $gg
	adjustRates $rate
}

proc cleanFormat {s} { return [string trimright [string trimright $s 0] .] }

proc adjustRates {rate} {
	global soundOutInfo
	set rate [string trim $rate]
	if [regexp other $soundOutInfo(user$rate)] {
		getRate $rate
	} {
		switch -- $rate {
			SR 	{ set soundOutInfo(userKR) 	[cleanFormat [expr 1.0 * $soundOutInfo(userSR) / $soundOutInfo(userKSM)] ]}
			KR 	{ set soundOutInfo(userKSM) 	[cleanFormat [expr 1.0 * $soundOutInfo(userSR) / $soundOutInfo(userKR)] ]}	
			KSM 	{ set soundOutInfo(userKR) 	[cleanFormat [expr 1.0 * $soundOutInfo(userSR) / $soundOutInfo(userKSM)] ]}
		}
	set soundOutInfo(oldrate$rate) $soundOutInfo(user$rate)
	}
}

proc toggleWin {target master} {
    global path
     if {[lsearch [pack slaves $master] $target] > 0} {
	pack forget $target
    } {
	pack $target -side top -fill x  -padx 1 -pady 1
    }
}



proc createSampleLabel { chan } {
    global path 
    foreach target [winfo child $path(winOutAmp)] {
	if {$target != "$path(winOutAmp).pad"} {destroy $target}
    }
    for {set c 0} {$c<$chan} {incr c} {
	pack [label $path(winOutAmp).ok$c ] -side left -fill x -expand y 
	pack [label $path(winOutAmp).ov$c ] -side right -fill x -expand y 
    }
}
    
proc updateNewMenu {  } {
    global rootMenu rootFolder prefs modir
    foreach f $modir {
	if [winfo exists $rootMenu.[file tail $f]] {destroy $rootMenu.[file tail $f]}
	set rootFolder [file dirname $f]
	scanFolder [file tail $f]
    }
    . config -menu .menubar
}

proc createInfoWindowMenu {} {
    global path  lan prefs frbut3 convButt tcl_platform soundOutInfo
    global utik rootMenu rootFolder tempobut _db
    
    bug creating main window menubar

	modebug "building soundwindow:" "menu (bar)"
    set frbut3  [menu .menubar]
    .menubar add cascade -menu .menubar.file -label File

	modebug "building soundwindow:" "menu (file)"
    menu .menubar.file -tearoff 0
    .menubar.file add cascade -label "New ..." -menu .menubar.file.c 

    initscan

    .menubar.file add separator 
    .menubar.file add command -label "Open..." -accelerator $_db(mod,a)-O -command openModule
    .menubar.file add command -label "Save Snapshot" -accelerator $_db(mod,a)-S -command saveGraph
    .menubar.file add command -label "Save Snapshot as..." -command saveAsGraph
    .menubar.file add separator 
    .menubar.file add command  -accelerator $_db(mod,a)-I -label "Reinit Module"  -command "catch {reInit}"
    .menubar.file add separator 
    .menubar.file add command  -label "Preferences..."  -command preferences
    .menubar.file add separator 
    .menubar.file add command  -label $lan(nom15)  -accelerator $_db(mod,a)-Q -command quitte 
    
	modebug "building soundwindow:" "menu (csound)"
    .menubar add cascade -menu .menubar.option -label Csound
    set utix [menu   $frbut3.option -tearoff 0]

    $utix add check -label "Preview Command  " -variable prefs(prev_line) 
    
    if {$tcl_platform(platform) == "unix"} {
	$utix add check -label "$lan(nom42)" -variable prefs(wind) -command setGraphs
    }
    $utix add separator
    $utix add check -label "$lan(nom44)" -variable prefs(midi)  
    $utix add check -label "$lan(nom45)" -variable prefs(sigin) 
	$utix add check -label "Table graphics" -variable prefs(graph) 
	
    # SHARC & Shells Stuff
    switch -- $tcl_platform(platform) {
	"windows" {
	    $utix add check -label "Internal Memory Allocations" 	-variable prefs(intmem) 
	    $utix add check -label "Relink DSP objects" 	-variable prefs(relink) 
	}
	"unix" {
	    $utix add check -label "$lan(nom106)" -variable prefs(heart) 
	    $utix add check -label "$lan(nom107)" -variable prefs(time)  
	    $utix add check -label "$lan(nom41a)" -variable prefs(ascii) 	
	}
    }
    $utix add separator

    $utix add check  -label "Tempo" -command makeTempo -variable tempobut

    $utix add cascade -label "$lan(nom46)" -menu $utix.samp 
	menu $utix.samp -tearoff 0
	
    foreach but {aiff raw wav} {
    	$utix.samp add radio -variable prefs(type) -value $but -label $but 
    }
    
    $utix add cascade -label "$lan(nom48)" -menu $utix.mess 
	menu $utix.mess -tearoff 0
    $utix.mess add check -variable prefs(amp)   -label $lan(nom65a) 
    $utix.mess add check -variable prefs(range) -label $lan(nom65b)
    $utix.mess add check -variable prefs(warn)  -label $lan(nom65c) 
	     
    $utix  add separator

    # no buffer on windows because they are fussy
    if {$tcl_platform(platform) != "windows"} {
	    $utix add cascade -label "DAC Buffers"  -menu $utix.realb
	 	menu $utix.realb  -tearoff 0
	 
		$utix.realb add cascade -label Soft  -menu $utix.realb.soft
		menu $utix.realb.soft  -tearoff 0
	   	foreach abut {1 2 4 8 16 32 64 128 256 512 1024 2048 4096 8192 16384 32768 65536} {
	   		$utix.realb.soft add radio -variable prefs(realb) -value $abut -label $abut 
	   	}
	
	   	$utix.realb add cascade -label Hard  -menu $utix.realb.hard
		menu $utix.realb.hard  -tearoff 0
	   	foreach bbut {1 2 4 8 16 32 64 128 256 512 1024 2048 4096 8192 16384 32768 65536} {
	   		$utix.realb.hard add radio -variable prefs(realB) -value $bbut -label $bbut 
	   	}	
	if {$tcl_platform(platform) == "macintosh"} {
	    $utix.realb add separator
	    $utix.realb add cascade  -label Console -menu $utix.realb.text
	    menu $utix.realb.text  -tearoff 0
	    foreach bbut {1 5 10 50 100 500 1000} {
		$utix.realb.text add radio -variable prefs(realText) -value $bbut -label $bbut 
	    }
	}
	   	$utix add cascade -label "Disk Buffers"  -menu $utix.diskb
		menu $utix.diskb  -tearoff 0
	
	   	$utix.diskb add cascade -label Soft  -menu $utix.diskb.soft
		menu $utix.diskb.soft  -tearoff 0
	   		foreach abut {512 1024 2048 4096 8192 16384 32768 65536 131072 262144 524288 1048576} {
	   	$utix.diskb.soft add radio -variable prefs(diskb) -value $abut -label $abut 
	   	}
	
	   	$utix.diskb add cascade -label Hard  -menu $utix.diskb.hard
		menu $utix.diskb.hard  -tearoff 0
	   	foreach bbut {512 1024 2048 4096 8192 16384 32768 65536 131072 262144 524288 1048576} {
	   		$utix.diskb.hard add radio -variable prefs(diskB) -value $bbut -label $bbut 
	   	}
	   
	if {$tcl_platform(platform) == "macintosh"} {
	    $utix.diskb add separator
	    $utix.diskb add cascade  -label Console -menu $utix.diskb.text
	    menu $utix.diskb.text  -tearoff 0
	    foreach bbut {1 5 10 50 100 500 1000} {
		$utix.diskb.text add radio -variable prefs(diskText) -value $bbut -label $bbut 
	    }
	}


	if {$tcl_platform(platform) == "unix"} {
	   $utix add cascade  -label "Set MIDI port"  -menu $utix.port
		menu $utix.port -tearoff 0 -relief raised
	    foreach bbut {ttyd1 ttyd2} {
		$utix.port add radio -variable prefs(midiport)   -value $bbut  -label $bbut 
	    }
    }
    
 	$utix add separator
  }
  
  
    $utix add cascade  -label "Default Headers" -menu $utix.defaults
   
	menu $utix.defaults  -tearoff 0
    $utix.defaults add cascade -label "Sampling Rate" -menu $utix.defaults.sr 
	menu $utix.defaults.sr  -tearoff 0
    foreach cbut $soundOutInfo(possibleSR) {
    	$utix.defaults.sr add radio -variable prefs(sr) -value $cbut -label $cbut 
    }
    $utix.defaults add cascade -label "Control Rate" -menu $utix.defaults.kr 
	menu $utix.defaults.kr  -tearoff 0
    foreach cbut $soundOutInfo(possibleKR) {
    	$utix.defaults.kr add radio -variable prefs(kr) -value $cbut -label $cbut 
    }
    $utix.defaults add cascade -label "KSMPS" -menu $utix.defaults.ksm 
	menu $utix.defaults.ksm  -tearoff 0
    foreach dbut $soundOutInfo(possibleKSM) {
    	$utix.defaults.ksm add radio -variable prefs(ksm) -value $dbut -label $dbut 
    }
    $utix.defaults add cascade -label "Channels" -menu $utix.defaults.chn 
	menu $utix.defaults.chn  -tearoff 0
    foreach ebut $soundOutInfo(possibleCHN) {
    	$utix.defaults.chn add radio -variable prefs(chn) -value $ebut -label $ebut 
    }
    $utix.defaults add separator
    $utix.defaults add cascade -label "GEN Resolution" -menu $utix.defaults.gen 
	menu $utix.defaults.gen  -tearoff 0
    foreach bbut $soundOutInfo(possibleGEN) {
    	$utix.defaults.gen add radio -variable prefs(gen) -value $bbut -label $bbut 
    }
    $utix add separator
    $utix add check  -label "$lan(nom49a)" -variable prefs(play) 
    $utix add check  -label "$lan(nom49b)" -variable prefs(incr) 
    $utix add check -label "Remember Input File" -variable prefs(keep)
    $utix add check -label "Use Speedo on Write" -variable prefs(spee)


	modebug "building soundwindow:" "menu (analysis)"
	   .menubar add cascade -menu .menubar.util -label Analysis  
		set utiz [menu .menubar.util -tearoff 0]
		$utiz add command  -label LPCanal  -command "analFrames lpc"
		$utiz add command  -label PVanal -command "analFrames vocoder"
		$utiz add command  -label Hetro  -command "analFrames hetrodyne"
		$utiz add command  -label Convolution -command "analFrames convolution"
		
		set utik [menu .menubar.wind   -tearoff 0 ]
    .menubar add cascade -menu $utik -label Windows 

	  
	$utik add command -label "Show editor" -accelerator $_db(mod,a)-E -command "showEditWindow 1"

	if {$tcl_platform(platform) == "unix"} {$utik add command -label "Hide all" -command "closeAll 0"}
	$utik add separator
	$utik add command -label "Main" 

	switch -- $tcl_platform(platform) {
		macintosh {
   			.menubar add cascade -menu [set utip [menu .menubar.apple -tearoff 0]] -label Apple
			$utip add command  -label "About Cecilia..."  -command getAbout
		}
	}
	
	modebug "building soundwindow:" "menu (help)"
    	.menubar add cascade -menu [set utip [menu .menubar.help -tearoff 0]] -label $lan(nom14a)
	$utip add command  -label "Cecilia Basics"  -state disabled	
	$utip add command  -label "   Help Index"  -command "Helpme [file join html index.$_db(html)]" 	
	$utip add command  -label "   Jumpstart"  -command "Helpme [file join html jump.$_db(html)]" 	
	$utip add command  -label "   Concepts"  -command "Helpme [file join html main.$_db(html)]" 
	$utip add separator		
	$utip add check	       -label "Assistance" -variable prefs(assist) -command toggleAssist
	$utip add command  -label "About Cecilia..."  -command getAbout
    
#    set convButt [button .menubar.conv -command doConv]
    .menubar.file entryconfigure 3 -state disabled
    .menubar.file entryconfigure 4 -state disabled
    .menubar.wind entryconfigure 0 -state disabled
   
   . config -menu .menubar
    bind .menubar <Enter> windowsMenu
    bug ...menu complete
}

proc setGraphs {} {
    global prefs frbut3
   	if {$prefs(wind) == 0} {
	    .menubar.wind entryconfigure 6 -state disabled
	    .menubar.wind entryconfigure 7 -state disabled
	    .menubar.wind entryconfigure 8 -state disabled
	    set prefs(heart) 0
	    set prefs(time) 0
	    set prefs(ascii) 0
	} else {
	     .menubar.wind entryconfigure 6 -state normal
	     .menubar.wind entryconfigure 7 -state normal
	}
	if {$prefs(graph) == 1 & $prefs(wind) == 1} {
	     .menubar.wind entryconfigure 8 -state normal
	} else {
	     .menubar.wind entryconfigure 8 -state disabled
	}
	if {$prefs(graph) == 0} {set prefs(ascii) 0}
}

proc initscan {} {
    global _db prefs ceclib

	if ![winfo ismapped .temp] {
		set redo 1
		wm deiconify .temp
		raise .temp
		update
	} { set redo 0 }
		
    destroy .menubar.file.c
    menu .menubar.file.c -tearoff 0
    .menubar.file.c add command  -label "Module...  " -accelerator $_db(mod,a)-N -command  "checkIt 1"
    .menubar.file.c add separator 
    scanMods [file join $ceclib builtin] .menubar.file.c 1
    .menubar.file.c add separator     
    foreach mf $prefs(MODIR) { scanMods $mf .menubar.file.c 1}
    .menubar.file.c add separator 
    .menubar.file.c add command  -label "Update menu" -command initscan

	if $redo {
		wm withdraw .temp
	}	
}

proc scanMods {folder m root} {
    global _db
	modebug "building soundwindow:" "menu (modules; scanning [file tail $folder])"
    if $root { $m insert last command -label [file tail $folder] -state disabled }
    set usefull 0
    set content [glob -nocomplain [file join $folder *]]
    foreach item $content {
	switch [file type $item] {
	    link { bug $item ignored: not following links }
	    file {
		set f [open $item r]
		regsub -all \{|\" [gets $f] {} l
		if {[lindex $l 0]== "<snap>"} {
		    set tag "\(s\)" ; set true 1 ; set tt 2
		   
		} elseif {[lindex $l 0]=="<info>"} {
		    set tag "\(m\)" ; set true 1 ; set tt 3
		} else {set true 0}
		if $true {
		    set usefull 1
		    regsub -all \  $item \\\  item
		    $m add command -label "$tag [file tail $item]" -command "checkIt $tt $item"
		}
		close $f
	    }
	    directory {
		$m add cascade -label "  [file tail $item]" -menu $m.[set x [incr _db(menu,id)]]
		menu $m.$x -tearoff 0
		if ![scanMods [file join $folder $item] $m.$x 0] {
		    $m delete last
		    destroy $m.$x
		} {
		    set usefull 1 
		}
	    }
	}
    }
    return $usefull
}

proc checkIt {args} {
	bug checking
	if {[doCloseCheck] == 0} {return}
    if {[closureCheck] == 0} {return}
    
	if {[lindex $args 0] == 1} { 
    	makeNewTemplate
	} elseif {[lindex $args 0] == 2} {openGraph [file join [lindex $args 1] [lindex $args 2] [lindex $args 3]]
	} else {
    	showEditWindow 0
    	parseModule [file join [lindex $args 1] [lindex $args 2] [lindex $args 3]]
	setBitbind on
    } 	
}

proc closeInterface {what} {
    global path frbut3 lan prefs panelist
    if {$what == 1} {
	wm deiconify .pre
	if [winfo exists .win] {wm deiconify .win}
	}
    if {$what == 0} {
	wm withdraw .pre
	if [winfo exists .win] {wm withdraw .win}
	}
}


proc windowsMenu {} {
global windowNames data nomModuleCourrant tcl_platform
#bug updating windows menu
set nopath {.preferences .top .cs .bgerrorDialog .menubar .menubar3 .#menubar \
		.search/replace .goto .speedo .temp .clip .message .analysis .bgerrorTrace}
 if {$tcl_platform(platform) != "macintosh"} {.menubar.wind delete 3 end} {.menubar.wind delete 2 end}
 .menubar.wind add command -label Main -command "catch {wm deiconify ,};raise ."
    foreach wind [winfo children .] {
	if {[lsearch $nopath $wind] == "-1"} {
	    switch $wind {
	    .pre  {
		    if ![info exists data] {
			.menubar.wind add command -label $windowNames($wind) \
			    -command "catch {wm deiconify $wind};raise $wind" -state disabled
		    } else {
			.menubar.wind add command -label $windowNames($wind) \
			    -command "catch {wm deiconify $wind};raise $wind" -state normal
		    }
		}
	    .edit  {
		    if {$nomModuleCourrant == ""} {
			.menubar.wind add command -label $windowNames($wind) \
			    -command "catch {wm deiconify $wind};raise $wind" -state disabled
		    } else {
			.menubar.wind add command -label $windowNames($wind) \
			    -command "catch {wm deiconify $wind};raise $wind" -state normal
		    }
	    }
	   default {.menubar.wind add command -label $windowNames($wind) \
	       -command "catch {wm deiconify $wind};raise $wind" -state normal}
	}
    }
    
    }
}

proc closeAll {what} {
    global path frbut3   data nomModuleCourrant
	set nopath [list .top .menubar .\#menubar .temp .clip .message .insertTk-opcode .insertOrc-opcode .insertSco-opcode]
	showEditWindow $what
	if {$what == 1} {
		foreach wind [winfo children .] {
		    if {[lsearch $nopath $wind] == "-1"} {
		        switch -glob -- $wind {
			  .pre { if [info exists data] { catch {wm deiconify $wind}} }
			 .edit { if { $nomModuleCourrant != "" } { catch {wm deiconify $wind}} } 
		       default { catch {wm deiconify $wind} }
		       }
		    }
		}
		.menubar.wind entryconfigure 1 -label "Hide All  " -command "closeAll 0"
	} else {
		foreach wind [winfo children .] {
			catch {wm withdraw $wind}
		}
		wm iconify .
		.menubar.wind entryconfigure 1 -label "Show All  " -command "closeAll 1"
	}
}


proc makeTempo {} {
 
	global prefs tempobut cfont
	global  click lan 
	if {$tempobut == 0} {set prefs(tempo) off; return}
	if [winfo exists .tempo] { wm deiconify .comp;raise .comp;return}
    	set t [toplevel .tempo -bd 5  -relief ridge]
     	wm minsize .tempo 300 120
    	wm maxsize .tempo 300 120
     	frame $t.sli 
    	foreach sli {bpm } {
		frame $t.sli.$sli -bd 2 -relief groove
		label $t.sli.$sli.nam$sli -text $sli  -font $cfont(small) -width 8 
		scale $t.sli.$sli.$sli -showvalue 0 -from 5 -to 1000 -resolution 1 -variable prefs(tempo) -highlightthickness 0  -orient horizontal -length 150 -width 8 
		label $t.sli.$sli.lab$sli -highlightthickness 0 -textvariable prefs(tempo) -font $cfont(small) -width 8 
		pack  $t.sli.$sli.nam$sli $t.sli.$sli.$sli $t.sli.$sli.lab$sli -side left
		pack $t.sli.$sli -side top -padx 5
	}
     	pack  $t.sli -side top -pady 3 
     	frame $t.ex  -bd 2 -relief groove
	button $t.ex.ok -highlightthickness 0 -text OK \
	    -command "destroy .tempo "
	pack $t.ex.ok -side left -expand 1 -anchor w -padx 5 -pady 5
	pack $t.ex -side bottom -padx 5 -pady 5 -expand 1 -fill x
}


