#
# 	Parser de fichiers Cecilia (extraction et generation d'orchestres)
# 	(c) 1995-7 Alexandre Burton et Jean Piche
# 	v. 1.80a (10/08/97)
#

#bind . <KP_Enter> updateTkInterface

proc typewarning {n t}  {
    bug Warning: object $n uses the obsolete type $t
}

proc updateTkInterface {} {
    global path module data a value type kill soundInInfo gensize frbut3 prefs
    set newGraph 0
    set newIrate 0
    activateChannels 
#    clearWinSize .
    append liste " [array names data] [array names value]"
    foreach l [split [$path(panel).tk_interface.t get 0.0 end] \n] {
	set n [lindex $l 1]
	set t [lindex $l 0]
	
	if {[llength $l] > 1} {
	    if {[lsearch [array names data] $n] == -1 && [lsearch [array names value] $n] == -1} {
		if {$t == "cec_graph" && ![info exists data]} {set newGraph 1}
		if {$t != "cec_graph" && ![info exists value]} {set newIrate 1}
		eval $l
		bug new object $t $n
		    
	    } else {
		if {"$type($n)" != $t} {
		    eval "$kill($n)"
		    eval $l
		    bug type change for  $n
		} else {
		    regsub $n $liste "" liste
		    eval refresh-$t $l
		    
		}
	    }
	}
    }
    
    if [info exists liste] { 
    	foreach v $liste { eval "$kill($v)" ; bug destroying  $v}
    }
    
    if [info exists data] { 
	if {[llength [array names data]] == 0} {unset data; set a 0} 
    }

    if $newGraph {showGraph}
    if $newIrate {showIrate}
    
    if [array exists soundInInfo]   {
	grid $path(winIn) -column 0 -row 3 
	pack $path(winIn).l  -side top -fill both -expand y -fill x
	pack $path(winIn).f  -side top -fill both -expand y -fill x    
    }
    
    if {[array exists value] || [info exists data]} {
	showInterface
    } else {
	clearInterface
    }
    update
#    setWinSize .
    return
}

proc extractTag2 {source cible} {
    set len [string length $cible]
    set start [expr [string first  <$cible> $source] + $len + 2]
    set end [expr [string first  </$cible> $source] - 1]
    return [string range $source $start $end]
}


proc loadPanes {stuff} {
    global path module
    foreach pane $module(tags) {
    	bug ...loading $pane
		$path(panel).$pane.t delete 0.0 end
		set contenu [extractTag2 $stuff $pane]
		set contenu [string trim $contenu]
		$path(panel).$pane.t insert end $contenu
		if {[regexp instr $contenu] > 0} { lappend module(nchnls) $pane }	
    }
    regsub -all info|score|tk_interface $module(nchnls) "" module(nchnls)
}

proc activateChannels {} {
    global module path soundOutInfo
    bug verifying orchestra channels
    foreach chn  $soundOutInfo(possibleCHN) {
    	bug ...$chn
	if {[regexp instr [$path(panel).$chn.t get 0.0 end] > 0] } {
	    $path(winOut).rates.nchnls.$chn config -state normal
		setstate idle
	} else {
	    $path(winOut).rates.nchnls.$chn config -state disabled
	}
    }
    
}

proc showGraph {} {

    global path frbut3 plot graphOrig type data idx initGraph prefs
    if ![array exists data] {
    	bug ...no data
    	return 0
    }
    pack $path(canvas) -side top -fill both -expand y  -padx 3 -pady 3
    pack $path(gauche) -side left -anchor w -fill y
    set q 0
    
    bug resetting graphwin to $prefs(geom,pre)
    wm geometry .pre $prefs(geom,pre)
    update

    $path(param).select$initGraph invoke
    $frbut3.file entryconfigure 3 -state disabled
    $frbut3.file entryconfigure 4 -state normal
    set plot(lastX) [floatToScreenX 0.5]
    set plot(lastY) [floatToScreenY 0.5]
#    drawXGrid
    return 1
}

proc showIrate {} {

	bug showing_irate

    global path slideOrig value
    if ![array exists value] {return 0}
    set slideOrig  [array get value]
    return 1
}

proc setDefaultHeader {} {

	bug setting default header

    global soundOutInfo prefs module path
    set soundOutInfo(userSR) $prefs(sr)
    set soundOutInfo(userKR) $prefs(kr)
    set soundOutInfo(userKSM) $prefs(ksm)
    set soundOutInfo(userGEN) $prefs(gen)
	
	# nchnls stuff...
    if {[lsearch $module(nchnls) $prefs(chn)] < 0} {
		if {[llength $module(nchnls)] < 1} {
		    if [info exists $soundOutInfo(userCHN)] { unset soundOutInfo(userCHN) }
		    foreach chn $soundOutInfo(possibleCHN) {
				$path(winOut).rates.nchnls.$chn  deselect
			}		    
		    bug "warning: no legal orchestra!!"
		} else {
		    set soundOutInfo(userCHN) [lindex $module(nchnls) 0]
		    $path(winOut).rates.nchnls.[lindex $module(nchnls) 0] select 
		}
    } else {
		set soundOutInfo(userCHN) $prefs(chn)
		$path(winOut).rates.nchnls.$prefs(chn) select 
    }
}

proc showInterface {} {
	bug "...showing interface"
    global path prefs
     pack $path(top) -side top	-expand y -fill both
    if {$prefs(tools) == 1} {catch {makeTools2}} else {
		pack .pre.too -side top -before .pre.grap -expand n -fill x
    }
    wm deiconify .pre 
    raise .pre  
    bind .pre <ButtonRelease-1> testChange
}

proc defaultDuree {} {
    global value
    if {[info exists value(duree_totale)]} {
	return [format %f6 $value(duree_totale)]
	} else {
	    if {[info exists value(total_time)]} {
		return [format %f6 $value(total_time)]
	    } else {
		return 0 
	    }
    }
}

proc reinitModule {fichier} {

    bug reinitializing module space for $fichier

    global nomModuleCourrant module cs midifile gensize realtim prefs
    global realArr frbut3 midiArr midiIn prefs genBank type
    clearOutPanes 
    
    set prefs(geom,pre) [wm geometry .pre]
#    bug preserving $prefs(geom,pre)
    set genBank 180
    wm withdraw .pre
    destroyData
	setstate idle
    set nomModuleCourrant ""
    set module(path) $fichier
    set module(nom) [file tail $module(path)]
    set module(tempfile) ""
    set module(tags) {tk_interface info mono stereo quad score}
    set module(outtags) {orcOut scoreOut}
    set module(nchnls) ""
    catch {unset realArr}
    catch {unset midiArr}
    catch {unset gensize}
    foreach it [array names type] {unset type($it)}
    set midifile 0
    set midiIn 0
    set realtim 0
    set cs(presco) 0
    set cs(preorc) 0
}

proc clearInterface {} { catch {destroy .win} }

proc setInterface {} {
    global tcl_platform
    bug setting interface...
    switch -- $tcl_platform(platform) {
	"macintosh" {
		bug ...on macintosh...
	if {[showGraph] || [showIrate]} {showInterface } else {clearInterface}
	}
	default {
		bug ...on unix...
	if {[showGraph] > 0} {showInterface } else {clearInterface}
	}
    }
    if {![showIrate]} {showEditWindow 1}
}

proc parseModule {fichier} {

    global soundOutInfo prefs module _db path grFlag
    bug "parsing $module(path)..."

    if [catch {CsoundStop}] { bug hmm... something odd with stopping csound (killed by user?) }
    reinitModule $fichier
    
    bug reading $module(path) from disk
    set f [open $module(path)]
    set stuff [read $f]
    close $f
    
    loadPanes $stuff
    activateChannels 
    if {$prefs(colorize) == 1} {colorit}
    
    bug evaluating tk_interface
    
    if {[lsearch [$path(panel).tk_interface.t get 0.0 end] "cgraph"] == -1} {
	set grFlag 1} {set grFlag 0}
    resetPath
    eval [$path(panel).tk_interface.t get 0.0 end]
    bug done with the tk_interface
    
    set soundOutInfo(duree) [defaultDuree]
    setDefaultHeader
    updateModuleInfo 

    setInterface

    if $_db(time,reset) {setSoundOutDuree}
    bug ...done parsing
    
}

proc updateModuleInfo {} {
    global module value data  frbut3  prefs path  realArr
    global CSversion nomModuleCourrant graphOrig slideOrig realOrig
	if !$prefs(globalMode) {$path(winOutNom) config -state normal}
	$path(winOutNom) delete 0 end
	$path(winOutNom) insert 0 $module(nom).$prefs(type)
	if !$prefs(globalMode) {$path(winOutNom) config -state disabled}
	if {$nomModuleCourrant == ""} { set nomModuleCourrant "untitled"}
	set the ": [lindex [split [file tail $nomModuleCourrant ] . ] 0]"
	wm title .pre		    "Grapher: $module(nom)$the"
	wm iconname .pre		    "Grapher"
	wm title $path(edit)    "Cecilia: Editor: $module(nom)"
	$path(winModule) config -text "$module(nom)$the"
	bindHelp $path(winModule) LWinModule
	$path(area) delete titre
	set graphOrig [array get data]
	set slideOrig  [array get value]
	set realOrig  [array get realArr]
	bind .pre <ButtonRelease-1> testChange
	$frbut3.wind entryconfigure 0 -state normal
}

proc determineHeaderValues {} {
    global soundInInfo soundOutInfo nchnls path lan
    set soundOutInfo(ksmps) $soundOutInfo(userKSM) 
    set soundOutInfo(sr) $soundOutInfo(userSR)
    set soundOutInfo(nchnls) $soundOutInfo(userCHN)
    return 1
}

proc determineHeaderValues2 {} {
    global soundInInfo soundOutInfo nchnls path lan
    set soundOutInfo(ksmps) $soundOutInfo(userKSM) 
    if {$soundOutInfo(userSR) !="auto"} {set rate($soundOutInfo(userSR)) user }
    if {$soundOutInfo(userCHN) !="auto"} {set chan($soundOutInfo(userCHN)) user }
    foreach s [array names soundInInfo] { 
		if {[lindex $soundInInfo($s) 0] != "" } {
			lappend rate([lindex $soundInInfo($s) 0]) $s
			lappend chan($nchnls([lindex $soundInInfo($s) 1])) $s
		}
    } 
    switch [array size rate] {
		0   {		    
		    errFile2 "$lan(nom200)"
		    raise $path(win)
		    return 0	
		}	    
		1   {
		    set soundOutInfo(userSR) [array names rate]
		    set soundOutInfo(sr)     [array names rate]
		}
		default {
	   	 	foreach cas [array names rate] {lappend stuff [list $cas ( $rate($cas) ) ] }
	    	set choix [ errFile4 $lan(nom201) $stuff ]
	    	unset stuff
	   		if {$choix == "false"} {
	       		raise $path(win)
				return 0
    		} else {
    			set soundOutInfo(userSR) $choix
				set soundOutInfo(sr) $choix
	    	}
		}	
   	}	
    switch [array size chan] {
		0 {		    
		    errFile2 "$lan(nom202)"
		    raise $path(win)
		    return 0		
		} 1 {
		    set soundOutInfo(userCHN) [array names chan]
		    set soundOutInfo(nchnls) [array names chan]
		} default {
		    foreach cas [array names chan] {lappend stuff [list $cas ( $chan($cas) ) ] }
			errFile4 "$lan(nom203)"
		        raise $path(win)
			return 0
		}
    }
    return 1
}

proc chooseSR { args } {
    global lan
    errFile4 $lan(nom204) $args
}

proc verifieSoundIns { } {
    global value soundInInfo path lan tcl_platform soundNamer
    foreach soundin [array names soundInInfo] {
		if { $value($soundin) == "toLoad"} {
		    raise $path(win)
		    update
			catch {destroy .message}
		    	set mess "You must choose a soundfile:\n $soundNamer($soundin)"
			if {$tcl_platform(platform) == "unix"} {
			    errFile2 $mess
			} else {
			    tk_messageBox -type ok -icon warning   -message $mess 	
			}
		    chooseSoundPath $soundin
#		    $path(winIn).f.$soundin.b flash
		    return 0
		}
    }   
    return 1
}




proc preCompile {} {
    global value module son genID env path data cs midifile selectedMIDIfile homedir useScore
    global soundInInfo soundOutInfo prefs nchnls gensize tcl_platform user tclswitch

    set tclswitch 0
    set useScore 1
    if {$cs(preorc) == 0} {
	update
	$path(panel).orcOut.t config -state normal
	$path(panel).orcOut.t delete 0.0 end
	$path(panel).orcOut.t config -state disabled
	
	bug "checking for in and out compatibilty"
	if {![verifieSoundIns] || ![determineHeaderValues]} {return false} 
	
	bug "setting up the time..."
	if {[info exists value(duree_totale)]} {
	    set time $value(duree_totale)
	} else {
	    if {[info exists value(total_time)]} {
		set time $value(total_time)
	    } else {
		set time $soundOutInfo(duree)
	    }
	}
	
	bug ...time has been set to $time
	
	####

	bug "building name"
	set sounds .
	foreach s [array names soundInInfo] {
	    append sounds [file tail $value($s)] 
	}
	if {$sounds == "."} {set sounds ""}

	## a verifier avec la nouvelle methode
	set soundOutInfo(kr) [expr 1.0 * $soundOutInfo(sr) / $soundOutInfo(ksmps)]

	set    orcOut "sr = $soundOutInfo(sr)\n"
	append orcOut "kr = $soundOutInfo(kr)\n"
	append orcOut "ksmps = $soundOutInfo(ksmps)\n"
	append orcOut "nchnls = $nchnls($soundOutInfo(nchnls))\n"
	
	if [regexp ^\#include [$path(panel).$soundOutInfo(nchnls).t get 0.0 e]] {
	    puts "including file as orchestra"
	    set f [open [lindex [$path(panel).$soundOutInfo(nchnls).t get 0.0 e] 1] r]
	    append orcOut [read $f]
	    close $f
	} {
	    set theOrc [subValue3 [$path(panel).$soundOutInfo(nchnls).t get 0.0 end]]
	    set orch [checkHead $theOrc]
	    append orcOut [lindex $orch 0]
	    append orcOut [checkRealHead]
	    append orcOut [checkIrateInits]
	    append orcOut [checkMidiHead]
	    append orcOut [checkGraph]
	    append orcOut [checkMidi]
	    append orcOut [checkRealTime]
	    append orcOut [string range $theOrc [lindex $orch 1] end]
	}
	if {$tcl_platform(platform) == "unix"} {
	    set module(tempfile) [file join $prefs(TMPDIR) $user.$module(nom)]
	} else { set module(tempfile) [file join $prefs(TMPDIR) $module(nom)] }
	bug "...writing orchestra"
	set tempOrc [open $module(tempfile).orc w+]
	puts $tempOrc $orcOut
	close $tempOrc    
	bug "... orchestra written into $module(tempfile).orc"
	
	$path(panel).orcOut.t config -state normal
	$path(panel).orcOut.t insert end $orcOut
	$path(panel).orcOut.t config -state disabled

	bug "cleaning stuff"
	#if [winfo exists .message] {destroy .message}
    }
    if {$cs(presco) == 0} {
	$path(panel).scoreOut.t config -state normal
	$path(panel).scoreOut.t delete 0.0 end
	$path(panel).scoreOut.t config -state disabled
	
	
	# parsing score
	set  theScore [realTimSco]
	append theScore [checkMidiSco]
	append theScore [checkGraphSco]
	
	set module(score) [$path(panel).score.t get 0.0 end]
	
	if {$tcl_platform(platform) != "windows"} {
	    if [array exists data] {
		append theScore [scoredump all]\n
	    }
	}
	
	if {[regexp MidiFile $module(score)]} then {
	    set midifile 1
	    set useScore 0
	    set selectedMIDIfile [lindex $module(score) [expr [lsearch $module(score) MidiFile] + 2]]
	} else {set midifile 0 ; set selectedMIDIfile ""}
	
	if {[regexp \#min|nil $module(score)]} then {
	    foreach l [split [subValue3 [$path(panel).$soundOutInfo(nchnls).t get 0.0 end] ] \n] {
		if [regexp instr $l] { 
		    append theScore "f100 0 8192 10 1\ni[lindex $l 1] 0 [format %f4 $time]\n"
		}
	    }
	} elseif {[string range $module(score) 0 1] == "\#!"} {
	    puts "spawning external process for score generation"
	    append theScore [eval exec "[string range [lindex [split $module(score) \n] 0] 2 e]"]
	} elseif [regexp ^\#include $module(score)] {
	    puts "including score from file"
	    set f [open [lindex $module(score) 1] r]
	    append theScore [read $f]
	    close $f
	} elseif {[regexp \#tcl $module(score)]}  {
	    append theScore [eval $module(score)]\n
	} elseif {[regexp \#cyb $module(score)]}  { 
	    set ret [debin [subValue3 $module(score)]]
	    if {$ret == "false"} {return false} else {
		append theScore $ret\n
	    }
	} { append theScore [subValue3 $module(score)]\n }
    } {
	bug "writing score..."
	append theScore [$path(panel).scoreOut.t get 0.0 end]\n 
    }
    $path(panel).scoreOut.t config -state normal
    $path(panel).scoreOut.t insert 0.0 $theScore
    $path(panel).scoreOut.t config -state disabled
    set theScore [string trim $theScore]
    if {[lindex $theScore end] != "e"} {append theScore "\ne"}
    set tempSco [open $module(tempfile).sco w+]
    puts $tempSco $theScore
    close $tempSco
    bug "...score now in $module(tempfile).sco"
    
    createSampleLabel $nchnls($soundOutInfo(nchnls))
    if $tclswitch {return false} { return true}
}

proc subValue3 {data} {
    global value type path soundInInfo soundOutInfo
    set load 0
    set rem  $data
    regsub -all \[\[\] $rem @ rem
    regsub -all (\]) $rem ! rem
    while   {[string first @ $rem  ] != -1} {
	set it [string first "@" $rem  ]
	set at [string first "!" $rem  ]
	set da [string range $rem 0 $at]
	set rem [string range $rem [expr $at +1] end]
	set v [string range $da [expr $it+1] [expr $at-1]] 
	if {[info exists value($v)]} {
	    switch -- $type($v) {
		cec_option  { set result [$path(optionval).$v.menu index $realArr(${v}op)] }
		cec_filein  { set result $value($v) }
		default	    { set result [cleanFormat [format %.6f $value($v)]] }
	    }
	    regsub -all @$v! $da $result da
	} else {
	    if {[info exists $v]} {
		append outer ${$v}
	    } else {
		if {[string first \@ $v  ] != -1} {
		    append v "]"
		    regsub -all \@ $v \[ v
		}
		catch {eval $v} vv
		regsub -all \[\[\] $v @ v
		regsub -all (\]) $v ! v
		regsub -all ($v) $da $vv da
	    }			
	}
	regsub -all @ $da {} da
	regsub -all ! $da {} da
	append outer $da
    }
    append outer $rem 
    return $outer
} 


proc testChange {} {
    global data value graphOrig slideOrig path frbut3 realOrig realArr
    set boo [string compare [array get data] $graphOrig]
    set baa [string compare [array get value] $slideOrig]
    set buu [string compare [array get realArr] $realOrig]
    if {$boo != 0 | $baa != 0 | $buu != 0} {
	bind .pre <ButtonRelease-1> ""
       $path(winModule)  config  -text [$path(winModule) cget -text]***
       wm title .pre "Grapher: [$path(winModule) cget -text]"
       $frbut3.file entryconfigure 3 -state normal
       $frbut3.file entryconfigure 4 -state normal
    }
}


proc findgenSize {count} {

    if {$count < 512 } {set asr 512}
    if {$count > 512 & $count < 1024} {set asr 1024}
    if {$count >= 1024 & $count < 2048} {set asr 2048}
    if {$count >= 2048 & $count < 4096} {set asr 4096}
    if {$count >= 4096 & $count < 8192} {set  asr 8192}
    if {$count >= 8192 & $count < 16384} {set  asr 16384}
    if {$count >= 16384 & $count < 32768} {set  asr 32768}
    if {$count >= 32768 & $count < 65536} {set  asr 65536}
    if {$count >= 65536 & $count < 131072} {set  asr 131072}
    if {$count >= 131072 & $count < 262144} {set  asr 262144}
    if {$count >= 262144 & $count < 524288} {set  asr 524288}
    if {$count >= 524288 & $count < 1048576} {set  asr 1048576}
    if {$count >= 1048576 & $count < 2097152} {set  asr 2097152}
    if {$count >= 2097152 & $count < 4194304} {set  asr 4194304}
    if {$count >= 4194304 } {set  asr 8388608}

     return $asr

}


proc sinfo {args} {
    global soundInInfo tcl_precision nchnls
    switch [lindex $args 1] {
	frames  {return [format %.0f [expr [lindex $soundInInfo([lindex $args 0]) 0] * \
					  [lindex $soundInInfo([lindex $args 0]) 2]]]}
	dur     {return [lindex $soundInInfo([lindex $args 0]) 2]}
	sr      {return [lindex $soundInInfo([lindex $args 0]) 0]}
	chn     {
	    set rr [lindex $soundInInfo([lindex $args 0]) 1]
	    if [catch {expr $rr *1} res ] { return $nchnls($rr)} else {return $rr}
	}
    }
}


proc checkHead {dat} {
    set here [string first "instr " $dat]
    set head [string range $dat 0   [expr $here - 1]]
    return "{$head} $here"
}


proc checkGraph {} {
    global data genID isRealTime myidx tcl_platform value typeList _db
	
    ### note: MAc and Unix are now identical
    switch --  $tcl_platform(platform) {
	macintosh 	{ 
	    if {[llength [array names data]] > 0} {
		set magic "\n                       instr $_db(csound,main)        ; Cecilia's Magical\n" 
		append magic "                                        ; Csound Instrument\n\n"
		set i 1
		foreach gr [array names data] {
		    append magic "  [format %20s gk$gr] oscil1i 0,1,p3,$genID($gr) ;"
		    append magic "[format %5s [expr [llength $data($gr)]/2]] points\n"
		    incr i
		}
		append magic "\n                       endin\n"
		return $magic
	    } 
	}
	windows 	{ 
	    if [llength [array names data]] {
		set genDefs ""
		set ins55 "\n  instr 55 ; Cecilia communication instrument\n\n"
		for {set i 0} {$i < 127} {incr i} {append ins55 ", 1"}
		append ins55 \n\n
		
		# parsing each control parameter -- either realtime or graphbased
		foreach param [array names data] {
		    
		    append genDefs 	"  gisource_$myidx($param)\t\t ftgen [dump $param]\n"
		    append ins55 \
"  
;	### $param parameter piping ###
	kgraph_$myidx($param) 	oscil1i	0, 1, p3, gisource_$myidx($param)
	krealsl_$myidx($param)	= v$myidx($param)
	krealsl_$myidx($param) 	port krealsl_$myidx($param),.01
	gk$param	= (v[expr $myidx($param) + 100] > 1 ? kgraph_$myidx($param) : krealsl_$myidx($param))
	gk$param = krealsl_$myidx($param)
"

			}
			append ins55 "$subins55\n  endin\n\n\n"
	
			return \
"
$genDefs

$ins55
"
		    } 
		}
		unix	{
		    
		    set magic "\n                       instr $_db(csound,main)        ; Cecilia's Magical\n" 
		    append magic "                                                      ; Csound Instrument\n\n"
		    set i 1
		    foreach gr [array names data] {
			append magic "  [format %20s gk$gr] oscil1i 0,1,p3,$genID($gr) ;"
			append magic "[format %5s [expr [llength $data($gr)]/2]] points\n"
			incr i
		    }
		    append magic "\n                       endin\n"
		    return $magic
		}
	    }
	    
	}


proc checkGraphSco {} {
    global data value soundOutInfo _db
    if {[llength [array names data]] > 0} {
	if {[info exists value(duree_totale)]} {
	    set time $value(duree_totale)
	} else {
	    if {[info exists value(total_time)]} {
		set time $value(total_time)
	    } else {
		set time $soundOutInfo(duree)
	    }
	}
    set ins "i$_db(csound,main) 0 $time \n "  
    return $ins
    }
}


proc checkRealTime {} {

    global realArr realtim env user
    if {$realtim == 0} {
	return
    } else {
	set rt ""
    	foreach el $realArr(list) {
	    if {$realArr(${el}rec) == "k-rate"} { 
		append rt "\n$realArr(${el}or) "
	    }
	    if {$realArr(${el}rec) == "record"} { 
		set rot "\n$realArr(${el}or) "
		set ins  [lindex $realArr(chan) [lsearch $realArr(list) $el]]
		set realArr(file${el}) "/tmp/$user.tmpReal.$el"
		regsub -all filezzz $rot "$realArr(file${el})" rot
		regsub -all ";" $rot "" rot
		append rt "$rot\n"
	    }
	    if {$realArr(${el}rec) == "playback"} {
		append rt $realArr(${el}pb)
	    }
    	}	
    	return $rt
    }
}


proc realTimSco {} {
    
    global realtim realArr time soundOutInfo env
    if {$realtim == 0} {return} 
    set ret "\n"
    set in 0
    foreach el $realArr(list) {    
	if {$realArr(${el}rec) == "record"} {
	    append ret "$realArr(${el}sc) $soundOutInfo(duree)\n"
	}
	if {$realArr(${el}rec) == "playback"} {
	    set ins  [lindex $realArr(chan) [lsearch $realArr(list) $el]]
	    set size [findgenSize [file size "$realArr(file${el})"]]
	    append ret "f$ins 0 [expr $size/4] -1 \"$realArr(file${el})\" 0 6 0\n"
	    append ret "$realArr(${el}sc) $soundOutInfo(duree)\n"
	}
	if {$realArr(${el}rec) == "k-rate"} {
	    append ret "$realArr(${el}sc) $soundOutInfo(duree)\n"
	}
	incr in
    }
    return $ret\n     
}

proc checkIrateInits {} {
    global typeList value
    if [llength $typeList(cec_irateSlider)] {
	set irate ";;; Initialization of I-rate sliders\n"
	foreach islider $typeList(cec_irateSlider) {
	    if ![regexp _ $islider] { append irate "gk$islider init $value($islider)\ngi$islider init $value($islider)\n"}
	}
	return $irate\n
    } else { return }
}    

proc checkRealHead {} {
	
	# no way on Mac yet
#	return

	global realtim realArr env user ceclib tcl_platform
	
    if {$realtim == 0} {
		return
    } else {
    set ret "\n"
    set chh 151
    foreach el $realArr(list) {
	if {$realArr(${el}rec) == "k-rate"} { 
	    append rt "\ngkpp${el} init $realArr($el) "
	    append rt "\ngk${el} init $realArr($el) "
            append rt "\ngi${el} init $realArr($el) "
	    }
	if {$realArr(${el}rec) == "record"} { 
	    append rt "\ngk${el} init $realArr($el) "
	    append rt "\ngkpp${el} init $realArr($el) "
	    }
  	if {$realArr(${el}rec) == "playback"} {

		if {$tcl_platform(platform) == "windows"} {
			set size [file size [file join $ceclib tmp tmpReal.$el]]
		}
		if {$tcl_platform(platform) == "unix"} {
			set size [file size [file join / tmp $user.tmpReal.$el]]
		}
	    append rt "\ngi${chh}sz = [expr $size / 4]"
	}
	incr chh
    }
	return $rt\n
    }
}



proc checkMidi {} {
global midiIn midiArr value env prefs user ceclib tcl_platform
    if {$midiIn == 0} {return} 
#    set prefs(midi) 1
    set ret "\n"
    set in 0
    foreach el $midiArr(list) {
        set chan [lindex $midiArr(chan) $in]
	if {$midiArr(${chan}rec) == "midi_record"} {

		if {$tcl_platform(platform) == "windows"} {
			set midiArr(file${chan}) [file join $ceclib tmp tmpMidi.$chan]
		}
		if {$tcl_platform(platform) == "unix"} {
			set midiArr(file${chan}) [file join tmp $user.tmpMidi.$chan]
		}

	    set rot \n$midiArr($el) 
	    regsub -all portezzz $rot "$value(${el}_playlag)" rot
	    regsub -all filezzz $rot "$midiArr(file${chan})" rot
	    regsub -all ; $rot "" rot
	    append ret $rot     
	}
	if {$midiArr(${chan}rec) == "k-rate"} {
	    set rot \n$midiArr($el) 
	    regsub -all portezzz $rot "$value(${el}_playlag)" rot
	    append ret $rot
	}		
	if {$midiArr(${chan}rec) == "playback"} {
	    set rot \n$midiArr(${el}pb)
	    regsub -all portezzz $rot "$value(${el}_playlag)" rot
	    append ret $rot
	}
	incr in
    }
    return $ret
}

proc checkMidiSco {} {
global midiIn midiArr time soundOutInfo env
    if {$midiIn == 0} {return} 
    set ret "\n"
    set in 0
     foreach el $midiArr(list) {
        set chan [lindex $midiArr(chan) $in]
	if {$midiArr(${chan}rec) == "midi_record"} {
	    append ret "\n$midiArr(${el}sc) $soundOutInfo(duree)"
	    }
	if {$midiArr(${chan}rec) == "playback"} {
	    set ins  [lindex $midiArr(chan) [lsearch $midiArr(list) $el]]
	    set size [findgenSize [file size "$midiArr(file${ins})"]]
	    append ret "\nf$ins 0 [expr $size/4] -1 \"$midiArr(file${ins})\" 0 6 0"
	    append ret "\n$midiArr(${el}sc) $soundOutInfo(duree)"
	    }
	if {$midiArr(${chan}rec) == "k-rate"} {
	    append ret "\n$midiArr(${el}sc) $soundOutInfo(duree)"
	}
	incr in
    }
   return $ret  
}

proc checkMidiHead {} {
global midiIn midiArr env user ceclib tcl_platform
    if {$midiIn == 0} {
	return
    } else {
#        set chh 151
	set ret "\n"
	set in 0
     foreach el $midiArr(list) {
	append ret \n$midiArr(${el}hd)
        set chan [lindex $midiArr(chan) $in]
	if {$midiArr(${chan}rec) == "playback"} {
	    set ins  [lindex $midiArr(chan) [lsearch $midiArr(list) $el]]

		if {$tcl_platform(platform) == "windows"} {
			set size [file size [file join $ceclib tmp tmpMidi.$el]]
		}
		if {$tcl_platform(platform) == "unix"} {
			set size [file size [file join tmp $user.tmpMidi.$el]]
		}

	    set flou [string trimright $chan 0]
	    append ret "\ngi${flou}sz = [expr $size/4]"
	}
	incr in
    }
	return $ret
    }
}

