#ifndef H_CDW_FILE_MANAGER
#define H_CDW_FILE_MANAGER





#include <stddef.h>  /* size_t */
#include <stdbool.h> /* bool */

#include "main.h"
#include "cdw_dll.h"
#include "cdw_ncurses.h"





cdw_rv_t cdw_file_manager_init(void);
void     cdw_file_manager_clean(void);

cdw_rv_t cdw_file_manager_handle_adding_to_selected_files(void);
cdw_rv_t cdw_file_manager_handle_deleting_from_selected_files(void);

cdw_rv_t cdw_file_manager_create_graftpoints_file(void);
void     cdw_file_manager_delete_graftpoints_file(void);





cdw_rv_t  cdw_selected_files_create_view(WINDOW *window);
void      cdw_selected_files_delete_view(void);
cdw_rv_t  cdw_selected_files_regenerate_view(void);

bool            cdw_selected_files_file_over_4gb_present(void);
long long       cdw_selected_files_get_size(void);
cdw_rv_t        cdw_selected_files_search(char const * path, int can_mode);
void            cdw_selected_files_set_follow_symlinks(bool follow);
size_t          cdw_selected_files_get_number(void);
cdw_dll_item_t *cdw_selected_files_get_list(void);
double          cdw_selected_files_calculate_size_mb(void);





#endif /* #ifndef H_CDW_FILE_MANAGER */
