/*  $Revision: 7691 $ $Author: egonw $ $Date: 2007-01-11 12:47:48 +0100 (Thu, 11 Jan 2007) $    
 *
 *  Copyright (C) 1997-2007  The Chemistry Development Kit (CDK) project
 *
 *  Contact: cdk-devel@lists.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public License
 *  as published by the Free Software Foundation; either version 2.1
 *  of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 */
package org.openscience.cdk.structgen.deterministic;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

import org.openscience.cdk.interfaces.IAtomContainer;

/**
 * An implementation of Faulons equivalent classes deterministic generator. 
 *
 * @author      steinbeck
 * @cdk.created 2000-10-02
 * 
 * @cdk.module  structgen
 */
public class Graph extends ArrayList
{
    private static final long serialVersionUID = 1087357022768386719L;
    
    private Hashtable classes = null;
	
	public Graph()
	{
		super();
		classes = new Hashtable();
	}
	
	public void partition()
	{
		IAtomContainer ac = null;
		Integer eClass = null;
		classes.clear();
		for (int f = 0; f < size(); f++)
		{
			ac = (IAtomContainer)get(f);
			eClass = (Integer)ac.getProperty("class");
			if (!classes.containsKey(eClass))
			{
				/* Create a new Vector for this non-existing class */
				classes.put(eClass, new ArrayList());	
			}
			else
			{
				((List)classes.get(eClass)).add(ac);	
			}
		}
		
	}
	
	public int getNumberOfClasses()
	{
		return classes.size();
		
	}
	
}

