/****************************************************************************
                             Hyper's CD Catalog
		A multiplatform qt and xml based catalog program

 Author    : Peter Deak (hyperr@freemail.hu)
 License   : GPL
 Copyright : (C) 2003 Peter Deak
****************************************************************************/

#ifndef ADDDIALOG_H
#define ADDDIALOG_H

#include <qvariant.h>
#include <qpixmap.h>
#include <qdialog.h>
#include <qdatetime.h>

class QVBoxLayout;
class QHBoxLayout;
class QGridLayout;
class QComboBox;
class QLabel;
class QLineEdit;
class QListView;
class QListViewItem;
class QPushButton;
class QSpinBox;
class QMultiLineEdit;
class DirectoryView;
class GuiSlave;
class QApplication;
class DataBase;

class addDialog : public QDialog
{
    Q_OBJECT

public:
    
    addDialog(GuiSlave *c,QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
    ~addDialog();

    int volumename;
    GuiSlave *caller;

    QLabel* textLabel6;
    QLabel* textLabel1;
    QLabel* textLabel2;
    QLabel* textLabel5;
    QLabel* textLabel4;
    QLabel* textLabel3;
    QPushButton* buttonCancel;
    QPushButton* buttonOK;
    QPushButton* buttonPli;
    QMultiLineEdit *teComm;
    QLineEdit* leOwner;
    QComboBox* cbType;
    QSpinBox* sbNumber;
    QLineEdit* leName;
    DirectoryView* dirView;

protected:
    QGridLayout* addDialogLayout;
    QVBoxLayout* layout10;
    QHBoxLayout* layout9;
    QVBoxLayout* layout8;
    QVBoxLayout* layout7;
    QHBoxLayout* layout2;
    QHBoxLayout* layout3;
    QHBoxLayout* layout4;
    QGridLayout* layout5;
    QHBoxLayout* layout1;

protected slots:
    virtual void languageChange();
    int bOk();
    int bCan();
    int sread();
    int setMediaName(const QString & ds);

private:
    QPixmap image0;
    QPixmap image1;
    QPixmap image2;
    QPixmap image3;
    QPixmap image4;
    QPixmap image5;
    QPixmap image6;

public:
    int OK;
    int type;
    int serial;
    QString dComm,dName,dOwner,dDir;

};


class PWw : public QWidget
 {
  Q_OBJECT
  public:
   int lastx,lasty;
   int s;
   int refreshTime;
   QApplication *appl;
   PWw(QWidget *parent,QApplication *qapp = NULL);
   int begintext;

   void step(void);
   void end (void);

  protected:

   QTime t;
   void paintEvent(QPaintEvent *pe);
   void mouseMoveEvent(QMouseEvent *me);
   void mousePressEvent(QMouseEvent *me);
 };

void progress(PWw *p); 
 

class AddLnk : public QDialog
 {
  Q_OBJECT
  
  public:
   AddLnk(QWidget *parent);
  
   bool ok;
   QLineEdit *fname;
   QPushButton *bselect;
   QPushButton *buttonOk;
   QPushButton *buttonCancel;
   QLabel *label;
   
   QVBoxLayout *vbox;
   
   QHBoxLayout *hbox1;
   QHBoxLayout *hbox2;
   
  public slots:
  
   int sselect(void);
   int sok(void);
   int scancel(void);

protected slots:
    virtual void languageChange();
   
 };

#endif // ADDDIALOG_H
