/***************************************************************************
                          FileItem.cpp  -  description
                             -------------------
    begin                : Fri Jul 27 2001
    copyright            : (C) 2001 by Alex Podolsky
    email                : alexpod@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlistview.h>

#include <kurl.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kmimetype.h>

#include "FileItem.h"
#include "CdboFileItem.h"

FileItem::FileItem(QListView * parent, QString path) : CdboFileItem(parent, path){
	nameField = 0;
	init();
}

//==============================================
FileItem::FileItem(CdboFileItem * parent, QString path):CdboFileItem(parent, path){
	nameField = 0;
	init();
}	
//=================================================================
void FileItem::init(){
	setPixmap(nameField,BarIcon(KMimeType::iconForURL(path), KIcon::SizeSmall ));
	CdboFileItem::init();
}

//=======================================
FileItem::~FileItem(){
}