/***************************************************************************
                          FakePropertiesDialog.cpp  -  description
                             -------------------
    begin                : Sat Dec 1 2001
    copyright            : (C) 2001 by Alex Podolsky
    email                : alexpod@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//#include <iostream.h>

#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qframe.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qimage.h>
#include <qpixmap.h>

#include <kmimetype.h>
#include <kiconloader.h>
#include <kmimemagic.h>
#include <kmessagebox.h>

#include "FakePropertiesDialog.h"
#include "FakeFolderItem.h"

//==========================================================================
FakePropertiesDialog::FakePropertiesDialog(FakeFolderItem *item, FileEntry *entry, QWidget* parent,  const char* name)
    : QDialog( parent, name, FALSE, 0 )
{

    if ( !name )
	setName( "FakePropertiesDialog" );
	multiItems = false;
	thisEntry = entry;
	if(!thisEntry)
		return;
	folderItem = item;
	this->foldersList = 0;
	this->entriesList = 0;
	
	KMimeType::Ptr mimetype = KMimeType::findByURL(KURL(thisEntry->path));
	QString type = mimetype->comment().latin1();

	QString path = thisEntry->path;
	if(thisEntry->immutable)
		path = "Imported from previous session";

	init();
	initLabels(thisEntry->name,
		BarIcon(KMimeType::iconForURL(thisEntry->path), KIcon::SizeMedium ),
		folderItem->getPathToTop(),
		//(unsigned long)
		thisEntry->size,
		type,
		path,
		true,
		true);
	initControls(thisEntry->visibility, false);
	//resize( 10, 10 );
}
//==========================================================================
FakePropertiesDialog::FakePropertiesDialog(FakeFolderItem *item, QWidget* parent,  const char* name)
    : QDialog( parent, name, FALSE, 0 )
{
	if ( !name )
		setName( "FakePropertiesDialog" );
	if(!item || item->isTop())
		return;
	folderItem = item;
	thisEntry = 0;
	this->foldersList = 0;
	this->entriesList = 0;
	multiItems = false;
	int k = folderItem->getName().length() + 1;
	QString location = folderItem->getPathToTop();
	location = location.remove(location.length() - k, k);

	QString type = "Virtual CD Folder";
	if(item->isImmutable())
		type = "Folder imported from previous session";

	init();
	initLabels(folderItem->getName(),
		folderItem->getIcon(),
		location,
		folderItem->getSize(),
		type,
		"",
		true,
		true);
	
	//int ii = folderItem->totalEntries();
	double visibility = getTypeFromFolder(folderItem);
	initControls(visibility, true, true);
}
//==========================================================================
FakePropertiesDialog::FakePropertiesDialog(FakeFolderItem *item, FakeFoldersList *foldersList,
								FakeFileEntriesList *entriesList, QWidget* parent,  const char* name)
    : QDialog( parent, name, FALSE, 0 )
{
	if ( !name )
		setName( "FakePropertiesDialog" );
	multiItems = true;
	folderItem = item;
	thisEntry = 0;
	this->foldersList = foldersList;
	
		
	this->entriesList = entriesList;
	
	//int k = folderItem->getName().length() + 1;
	QString location = folderItem->getPathToTop();
	//location = location.remove(location.length() - k, k);

	QString type = "Unknown";
	
	int totalI = entriesList->count() + foldersList->count();
	QString name = " ";
	name = name + QString::number(totalI) + " items ";
	
	if(entriesList->count() > 0)	
		name = name + " - " + QString::number(entriesList->count()) + " files ";
	if(foldersList->count() > 0)
		name = name + " - " + QString::number(foldersList->count()) + " folders ";

	int size = 0;
	double visibility = getTypeFromEntriesList(entriesList, &size);
	double t = getTypeFromFolderList(foldersList, &size);
	
	if(t > visibility)
		visibility = t;
		
	init(false);
	initLabels(name,
		DesktopIcon("kmultiple"),
		location,
		size,
		type,
		"",
		false,
		true);
	if(visibility == FakeFolderItem::HFS_Visible + FakeFolderItem::RR_Visible + FakeFolderItem::Joi_Visible &&
				foldersList->count() > 0)
		visibility = visibility - 0.1;
	if(foldersList->count() > 0)
		initControls(visibility, true, true);
	else
		initControls(visibility, false, true);
}
//======================================================
double FakePropertiesDialog::getTypeFromEntriesList(FakeFileEntriesList *entriesList, int *size){
	int visibility = 0, rrC = 0, joiC = 0, hfsC = 0;
	int ii = entriesList->count();
	double v = 0.0;
	if(ii > 0){
		FileEntry *entry;
		for (entry=entriesList->first(); entry; entry=entriesList->next()){
			visibility = entry->visibility;
			*size += entry->size;
			if(visibility > FakeFolderItem::RR_Visible + FakeFolderItem::Joi_Visible){
       			hfsC++;
       			visibility -= FakeFolderItem::HFS_Visible;
       		}
       		if(visibility > FakeFolderItem::RR_Visible){
       			joiC++;
       			visibility -= FakeFolderItem::Joi_Visible;
       		}
       		if(visibility > FakeFolderItem::None_Visible){
       			rrC++;
       		}
		}
		
		if(hfsC > 0){
			if(hfsC == ii)
				v = 4.0;
			else
				v = 3.9;
		
		}
		if(joiC > 0){
			if(hfsC == ii)
				v += 2.0;
			else
				v += 1.9;
		
		}
		if(rrC > 0){
			if(rrC == ii)
				v += 1.0;
			else
				v += 0.9;
		
		}
	}
	return v;
}
//======================================================
double FakePropertiesDialog::getTypeFromFolder(FakeFolderItem *item){
	int visibility = 0, rrC = 0, joiC = 0, hfsC = 0;
	int ii = item->totalEntries();
	double v = 0.0;
	if(ii > 0){
		FileEntry *entry;
		for (entry=item->getFirstFileEntry(); entry; entry=item->getNextFileEntry()){
			visibility = entry->visibility;
			if(visibility > FakeFolderItem::RR_Visible + FakeFolderItem::Joi_Visible){
       			hfsC++;
       			visibility -= FakeFolderItem::HFS_Visible;
       		}
       		if(visibility > FakeFolderItem::RR_Visible){
       			joiC++;
       			visibility -= FakeFolderItem::Joi_Visible;
       		}
       		if(visibility > FakeFolderItem::None_Visible){
       			rrC++;
       		}
		}
		
		if(hfsC > 0){
			if(hfsC == ii)
				v = 4.0;
			else
				v = 3.9;
		
		}
		if(joiC > 0){
			if(hfsC == ii)
				v += 2.0;
			else
				v += 1.9;
		
		}
		if(rrC > 0){
			if(rrC == ii)
				v += 1.0;
			else
				v += 0.9;
		
		}
	}
	return v;
}
//======================================================
double FakePropertiesDialog::getTypeFromFolderList(FakeFoldersList *foldersList, int *size){
	int ii = foldersList->count();
	double v = 0.0;
	if(ii > 0){
		FakeFolderItem *item;
		double t = 0.0;
		for (item=foldersList->first(); item; item=foldersList->next()){
			*size += item->getSize();
			t = getTypeFromFolder(item);
			if(t > v)
				v = t;
		}
	}
	return v;
}
//==========================================================================
void FakePropertiesDialog::initControls(double visibility, bool isDir, bool tristate ){

	if(isDir){
		visibFrm->setTitle( tr( "Contents visible on filesystems" ) );
		applToSubdirChk->setEnabled( true );
		applToSubdirChk->setChecked( false );
	}
	else{
		visibFrm->setTitle( tr( "Visible on filesystems" ) );
		applToSubdirChk->hide();
		resize( 383, 372 );
	}
	if(!tristate){
       	if(visibility > FakeFolderItem::RR_Visible + FakeFolderItem::Joi_Visible){
       		hfsChk->setChecked( true );
       		visibility -= FakeFolderItem::HFS_Visible;
       	}
       	if(visibility > FakeFolderItem::RR_Visible){
       		joiletChk->setChecked( true );
       		visibility -= FakeFolderItem::Joi_Visible;
       	}
       	if(visibility > FakeFolderItem::None_Visible){
       		rrChk->setChecked( true );
       	}
       }
       else{
		if(visibility > FakeFolderItem::RR_Visible + FakeFolderItem::Joi_Visible){
			if(visibility == FakeFolderItem::RR_Visible + FakeFolderItem::Joi_Visible + FakeFolderItem::HFS_Visible)
       			hfsChk->setChecked( true );
       		else{
       			hfsChk->setTristate(true);
       			hfsChk->setNoChange();
       		}
       		visibility -= FakeFolderItem::HFS_Visible;
       	}
       	if(visibility > FakeFolderItem::RR_Visible){
       		if(visibility == FakeFolderItem::RR_Visible + FakeFolderItem::Joi_Visible)
       			joiletChk->setChecked( true );
       		else{
       			joiletChk->setTristate(true);
       			joiletChk->setNoChange();
       		}
       		visibility -= FakeFolderItem::Joi_Visible;
       	}
       	if(visibility > FakeFolderItem::None_Visible){
       		if(visibility == FakeFolderItem::RR_Visible)
       			rrChk->setChecked( true );
       		else{
       			rrChk->setTristate(true);
       			rrChk->setNoChange();
       		}
       	}
       }
}
//==========================================================================
void FakePropertiesDialog::initLabels(QString name, QPixmap icon, QString location,
				unsigned long size, QString type, QString path,  bool editable, bool highlite ){
				
	setCaption( tr( "Properties for " + name ) );
	
	iconImg->setPixmap( icon );
		
	origLocationLbl->setText(path );
	locationLbl->setText( location );
	if(editable){
		nameTxt->setText(name);
		nameTxt->setFocus();
		if(highlite)
			nameTxt->selectAll();
		nameTxt->setCursorPosition(name.length());
	}
	else
		nameLbl->setText(name);
		
	sizeLbl->setText(  formateSize(size) + " (" + QString::number(size) + ")" );
	typeLbl->setText( type );
}
//==========================================================================
void FakePropertiesDialog::init(bool editable){


	resize( 383, 422 );


    FakePropertiesDialogLayout = new QGridLayout( this );
    FakePropertiesDialogLayout->setSpacing( 5 );
    FakePropertiesDialogLayout->setMargin( 7 );
    QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    FakePropertiesDialogLayout->addItem( spacer, 1, 0 );

    okBtn = new QPushButton( this, "okBtn" );
    okBtn->setMinimumSize( QSize( 80, 0 ) );
    okBtn->setText( tr( "&OK" ) );
    okBtn->setDefault( true );


    FakePropertiesDialogLayout->addWidget( okBtn, 1, 1 );

    cancelBtn = new QPushButton( this, "cancelBtn" );
    cancelBtn->setMinimumSize( QSize( 80, 0 ) );
    cancelBtn->setText( tr( "&Cancel" ) );

    FakePropertiesDialogLayout->addWidget( cancelBtn, 1, 2 );

    baseFrm = new QFrame( this, "baseFrm" );
   // baseFrm->setMinimumSize( QSize( 310, 340 ) );
    baseFrm->setFrameShape( QFrame::StyledPanel );
    baseFrm->setFrameShadow( QFrame::Raised );
    baseFrmLayout = new QGridLayout( baseFrm );
    baseFrmLayout->setSpacing( 6 );
    baseFrmLayout->setMargin( 11 );
///////////////////////////////////////////////////////////
    typeRepLbl = new QLabel( baseFrm, "typeRepLbl" );
    typeRepLbl->setText( tr( "Type:" ) );

    baseFrmLayout->addWidget( typeRepLbl, 2, 0 );

/////////////////////////////////////////////////////////////////
    typeLbl = new QLabel( baseFrm, "typeLbl" );


    baseFrmLayout->addWidget( typeLbl, 2, 1 );

       locationLbl = new QLabel( baseFrm, "locationLbl" );

///////////
    baseFrmLayout->addWidget( locationLbl, 3, 1 );

    locationRepLbl = new QLabel( baseFrm, "locationRepLbl" );
    locationRepLbl->setText( tr( "Location:" ) );

    baseFrmLayout->addWidget( locationRepLbl, 3, 0 );

    sizeRepLbl = new QLabel( baseFrm, "sizeRepLbl" );
    sizeRepLbl->setText( tr( "Size:" ) );

    baseFrmLayout->addWidget( sizeRepLbl, 4, 0 );

    sizeLbl = new QLabel( baseFrm, "sizeLbl" );

//////
    baseFrmLayout->addWidget( sizeLbl, 4, 1 );

    origLocationLbl = new QLabel( baseFrm, "origLocationLbl" );

    baseFrmLayout->addWidget( origLocationLbl, 5, 1 );

    origLocationRepLbl = new QLabel( baseFrm, "origLocationRepLbl" );
    origLocationRepLbl->setText( tr( "Source:" ) );
/////////////
    baseFrmLayout->addWidget( origLocationRepLbl, 5, 0 );
    QSpacerItem* spacer_2 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
    baseFrmLayout->addItem( spacer_2, 9, 1 );

    applToSubdirChk = new QCheckBox( baseFrm, "applToSubdirChk" );//////////////////////////////////////////
    applToSubdirChk->setText( tr( "Apply changes to all subdirectories contents" ) );

    baseFrmLayout->addMultiCellWidget( applToSubdirChk, 8, 8, 0, 1 );

    visibFrm = new QButtonGroup( baseFrm, "visibFrm" );


    visibFrm->setColumnLayout(0, Qt::Vertical );
    visibFrm->layout()->setSpacing( 0 );
    visibFrm->layout()->setMargin( 0 );
    visibFrmLayout = new QVBoxLayout( visibFrm->layout() );
    visibFrmLayout->setAlignment( Qt::AlignTop );
    visibFrmLayout->setSpacing( 6 );
    visibFrmLayout->setMargin( 11 );

    rrChk = new QCheckBox( visibFrm, "rrChk" );//////////////////////////////////////////////////////
    rrChk->setMinimumSize( QSize( 0, 25 ) );
    rrChk->setText( tr( "ISO9660/RockRidge" ) );

    QToolTip::add(  rrChk, tr( "Uncheck if you want this file to be hidden<b></b> on ISO9660 filesystem. It will not be seen on Linux." ) );
    visibFrmLayout->addWidget( rrChk );

    joiletChk = new QCheckBox( visibFrm, "joiletChk" );////////////////////////////
    joiletChk->setMinimumSize( QSize( 0, 25 ) );
    joiletChk->setText( tr( "Joliet" ) );

    QToolTip::add(  joiletChk, tr( "Uncheck if you want this file to be hidden<b></b> on Joilet filesystem (used on Windows)." ) );
    visibFrmLayout->addWidget( joiletChk );

    hfsChk = new QCheckBox( visibFrm, "hfsChk" );////////////////////////////////////////
    hfsChk->setMinimumSize( QSize( 0, 25 ) );
    hfsChk->setText( tr( "HFS" ) );

    QToolTip::add(  hfsChk, tr( "Uncheck if you want this file to be hidden<b></b> on HFS filesystem (used on Macs)." ) );
    visibFrmLayout->addWidget( hfsChk );

    baseFrmLayout->addMultiCellWidget( visibFrm, 7, 7, 0, 1 );

    Line2 = new QFrame( baseFrm, "Line2" );
    Line2->setFrameStyle( QFrame::HLine | QFrame::Sunken );

    baseFrmLayout->addMultiCellWidget( Line2, 6, 6, 0, 1 );

    iconFrm = new QFrame( baseFrm, "iconFrm" );
    iconFrm->setMinimumSize( QSize( 90, 70 ) );
    iconFrm->setMaximumSize( QSize( 85, 32767 ) );
    iconFrm->setFrameShape( QFrame::NoFrame );
    iconFrm->setFrameShadow( QFrame::Plain );
    iconFrmLayout = new QHBoxLayout( iconFrm );
    iconFrmLayout->setSpacing( 6 );
    iconFrmLayout->setMargin( 11 );

    iconImg = new QLabel( iconFrm, "iconImg" );

    iconImg->setScaledContents( false );
    iconFrmLayout->addWidget( iconImg );
    QSpacerItem* spacer_3 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    iconFrmLayout->addItem( spacer_3 );

    baseFrmLayout->addWidget( iconFrm, 0, 0 );
////////

 	if(editable){
 		nameTxt = new QLineEdit( baseFrm, "nameTxt" );
		baseFrmLayout->addWidget( nameTxt, 0, 1 );
	}
	else{
		nameLbl = new QLabel( baseFrm, "nameLbl" );
		nameLbl->setMinimumWidth(240);
		baseFrmLayout->addWidget( nameLbl, 0, 1 );
	}
    Line1 = new QFrame( baseFrm, "Line1" );
    Line1->setFrameStyle( QFrame::HLine | QFrame::Sunken );

    baseFrmLayout->addMultiCellWidget( Line1, 1, 1, 0, 1 );

    FakePropertiesDialogLayout->addMultiCellWidget( baseFrm, 0, 0, 0, 2 );

   // signals and slots connections
    connect( cancelBtn, SIGNAL( clicked() ), this, SLOT( cancelSlot() ) );
    connect( okBtn, SIGNAL( clicked() ), this, SLOT( okSlot() ) );

    exec();
}

//========================================
FakePropertiesDialog::~FakePropertiesDialog(){
}
//========================================
void FakePropertiesDialog::okSlot(){
	QString n;
	if(!multiItems){
		n =  nameTxt->text().simplifyWhiteSpace();
		if(n.isEmpty()){
			KMessageBox::error(this,
              		"The new file name is empty!");
			return;
		}
	}
	
	bool addHFS = false, addJoi = false, addRR = false;
	int v = FakeFolderItem::None_Visible, ts = 0;
	
	ts = hfsChk->state();
	if(ts == QButton::NoChange){
		addHFS = true;
	}
	else{
		 if(ts == QButton::On)
			v += FakeFolderItem::HFS_Visible;
	}
	//////
	ts = joiletChk->state();
	if(ts == QButton::NoChange){
		addJoi = true;
	}
	else{
		 if(ts == QButton::On)
			v += FakeFolderItem::Joi_Visible;
	}
	/////////////////
	ts = rrChk->state();
	if(ts == QButton::NoChange){
		addRR = true;
	}
	else{
		 if(ts == QButton::On)
			v += FakeFolderItem::RR_Visible;
	}
	if(multiItems){
		if(entriesList->count() > 0){
			FileEntry *entry;
			for (entry=entriesList->first(); entry; entry=entriesList->next()){
				applyVisibilityToFile(entry, v, addHFS, addJoi, addRR);
			}
		}
		if(foldersList->count() > 0){
			FakeFolderItem *item;
			for (item=foldersList->first(); item; item=foldersList->next()){
				applyVisibilityToFolder(item, v, addHFS, addJoi, addRR);
			}
		}
	}
	else if(thisEntry != 0){
		if(!applyNameToFile(thisEntry, n))
			return;
		applyVisibilityToFile(thisEntry, v, addHFS, addJoi, addRR);
	}
	else{
		if(!renameFolder(n))
			return;
		
		applyVisibilityToFolder(folderItem, v, addHFS, addJoi, addRR);
	}
	emit applied();
	accept();
}
//========================================
void FakePropertiesDialog::cancelSlot(){
	emit canceled();
	reject();
}
//========================================
bool FakePropertiesDialog::applyNameToFile(FileEntry *entry, QString n){
	if(entry->name != n){
		if(entry->immutable){
			KMessageBox::sorry(this,
             		"You can't modify properties for this file.\n"\
				"It was imported from previous session.");
			return false;
		}
		else{
			if(entry->name != n && folderItem->containsEntry(n)){
				KMessageBox::sorry(this,
             			"Item with the same name already exists in this folder.\n"\
					"Please choose another name.");
				return false;
			}
			entry->name = n;
		}
	}
	return true;
}
//========================================
bool FakePropertiesDialog::applyVisibilityToFile(FileEntry *entry, int v, bool addHFS, bool addJoi, bool addRR){
	if(entry->immutable)
		return false;
	int visibility = entry->visibility;
	int newVisibility = v;
	if(addHFS && visibility > FakeFolderItem::RR_Visible + FakeFolderItem::Joi_Visible)
       	newVisibility += FakeFolderItem::HFS_Visible;
       if(visibility > FakeFolderItem::RR_Visible + FakeFolderItem::Joi_Visible)
       	visibility -= FakeFolderItem::HFS_Visible;
       		
       if(addJoi && visibility > FakeFolderItem::RR_Visible)
       	newVisibility += FakeFolderItem::Joi_Visible;
       if(visibility > FakeFolderItem::RR_Visible)
       	visibility -= FakeFolderItem::Joi_Visible;
       		
       if(addRR && visibility > FakeFolderItem::None_Visible)
       	newVisibility += FakeFolderItem::RR_Visible;
       		
	entry->visibility = newVisibility;
	return true;
}
//========================================
bool FakePropertiesDialog::applyVisibilityToFolder(FakeFolderItem *thisFolder, int v, bool addHFS, bool addJoi, bool addRR){
	//if ( progress->wasCancelled() )
	//		return false;
	if(thisFolder->childCount() > 0){
		FakeFolderItem *i;
		for(i=(FakeFolderItem *)thisFolder->firstChild(); ; i=(FakeFolderItem *)i->nextSibling()){
			if(!i){
				break;
			}
			/*if ( progress->wasCancelled() )
				return false;
*/
			if(i->childCount() > 0){
				if(!applyVisibilityToFolder(i, v, addHFS, addJoi, addRR))
					return false;
			}
		}
	}
		
	int visibility = 0,
		newVisibility= 0,
		ii = folderItem->totalEntries();

	if(ii > 0){
		FileEntry *thisEntry;
		for (thisEntry=thisFolder->getFirstFileEntry(); thisEntry; thisEntry=thisFolder->getNextFileEntry()){
			if(thisEntry->immutable)
				continue;
			visibility = thisEntry->visibility;
			newVisibility = v;
			
			if(addHFS && visibility > FakeFolderItem::RR_Visible + FakeFolderItem::Joi_Visible)
       			newVisibility += FakeFolderItem::HFS_Visible;
       		if(visibility > FakeFolderItem::RR_Visible + FakeFolderItem::Joi_Visible)
       			visibility -= FakeFolderItem::HFS_Visible;
       		
       		if(addJoi && visibility > FakeFolderItem::RR_Visible)
       			newVisibility += FakeFolderItem::Joi_Visible;
       		if(visibility > FakeFolderItem::RR_Visible)
       			visibility -= FakeFolderItem::Joi_Visible;
       		
       		if(addRR && visibility > FakeFolderItem::None_Visible)
       			newVisibility += FakeFolderItem::RR_Visible;
       		
			thisEntry->visibility = newVisibility;
	
		}
	}
	return true;
}
//========================================
bool FakePropertiesDialog::renameFolder(QString n){
	if(folderItem->getName() == n){
		return true;
	}
	if(folderItem->isImmutable()){
		KMessageBox::sorry(this,
            		"You can't rename this folder.\n"\
			"It was imported from previous session.");
		return false;
	}
	if(((FakeFolderItem *)folderItem->parent())->containsEntry(n)){
		KMessageBox::sorry(this,
			"Item with the same name already exists in this folder.\n"\
			"Please choose another name.");
		return false;
	}
	folderItem->setName(n);
	return true;
}
//===========================================================
QString FakePropertiesDialog::formateSize(unsigned long size) {
	QString buff;
	if(size < 1024)
		return QString::number(size) + "B";
	else if(size / 1024 < 1024){
		//return QString::number(size / 1024) + "KB";
		buff = buff.setNum( ((double)size) / 1024, 'f', 1) + "KB";
		return buff;
	}
	else if(size / 1024  / 1024 < 1024){
		buff = buff.setNum( ((double)size) / 1024 / 1024, 'f', 1) + "MB";
		return buff;
	}
	else{
		buff = buff.setNum( ((double)size) / 1024 / 1024  / 1024, 'f', 1) + "GB";
		return buff;
	}
	return "";
}
