/***************************************************************************
                          CompilationTreeView.h  -  description
                             -------------------
    begin                : Tue Jul 24 2001
    copyright            : (C) 2001 by Alex Podolsky
    email                : alexpod@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef COMPILATIONLISTVIEW_H
#define COMPILATIONLISTVIEW_H

#include <qwidget.h>
#include <qlistview.h>
#include <qevent.h>

#include <kio/job.h>
#include <klistview.h>

#include "../../cdbakeoven.h"

class QListViewItem;
class CdboFileItem;
class QDropEvent;

class CompilationTreeView : public KListView  {
   Q_OBJECT
public:
	CompilationTreeView( QWidget *parent=0L, const char *name=0L);
	~CompilationTreeView();
	
	void setCDBOApp(CDBakeOvenApp * parent) { cdboApp = parent; }
signals:
	void gotCaption(const QString &, bool);

public slots:	
	virtual bool addItem(QString);
	virtual void updateSettings();
	virtual void slotReload();
	virtual void compilSettingsSlot();	

	
	bool addMultipleItems(QString);
	bool addMultipleItems(QStringList);
	void remove();
	void removeAll();
	bool saveAndRemove();
	void saveRemoveAndLoad(QString);
	bool save();
	bool saveAs();
	void slotProperties();

protected slots:

	void dropOcurred(QDropEvent * e, QListViewItem *after);
	void openWithSlot();
    	virtual void keyPressEvent(QKeyEvent *e);
    	void reloadTop();
	
protected:
	virtual bool acceptDrag (QDropEvent* event) const;
	
	virtual inline QString getType() { return "Unknown Type"; }
	virtual void resetTotal();
	virtual void subtractFromTotal(int);
	
	void setParentForDrop(QListViewItem *item);
	
	void emitGotCaption();
	int currentItemSize();
	void doSave(QString);
	void popUpSettings(int type);
	bool isEmpty();
	
	QString currentItemPath();
	QString currentItemName();
	QListViewItem* getItemForDeletion();
	
	
	
	bool saved;
	QString listFileName;
	
	CDBakeOvenApp * cdboApp;
	
	CdboFileItem *top;
	QStringList fList;
	QStringList nameList;
	
	//QDict <QString> namePositionMap;
	CdboFileItem *parentForDrop;
	
};
#endif