/***************************************************************************
                          AudioOptPnl.cpp  -  description
                             -------------------
    begin                : Sat May 5 2001
    copyright            : (C) 2001 by Alexy Podolsky
    email                : alexpod@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 **************************************************************************/
//#include <iostream.h>

#include <qspinbox.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <qbuttongroup.h>
#include <qradiobutton.h>
#include <qcombobox.h>
#include <qlineedit.h>

#include <kapp.h>
#include <kmessagebox.h>
#include <ksimpleconfig.h>

#include "AudioOptPnl.h"

AudioOptPnl::AudioOptPnl( QWidget* parent,  const char* name, WFlags fl )
    		: AudioOptPnlBase( parent, name, fl ){
    	
	config = kapp->config();
	readOptions();
	//readOnlyChk->setEnabled(false);//////////////////////////////////////////////////////////////////////////////////////////////////////////
}
AudioOptPnl::AudioOptPnl(int activeTab, QWidget* parent,  const char* name, WFlags fl )
    		: AudioOptPnlBase( parent, name, fl ){
    	
	config = kapp->config();
	readOptions();
	//readOnlyChk->setEnabled(false);/////////////////////////////////////////////////////////////////////////////////////////////////////////
	audioOptTbs->setCurrentPage(activeTab);
}
/*
 *  Destroys the object and frees any allocated resources
 */
AudioOptPnl::~AudioOptPnl(){

}
//---------------------------------------------------------------------------------------------
void AudioOptPnl::readOptions(){
	config->setGroup("Audio Read Options");
	bool  bBuff= config->readBoolEntry("Use cdda2wav", true);
	if(bBuff){
		cdda2wavRBtn->setChecked(true);
		cdda2wavSlot();
	}
	else{
		cdparanoiaRBtn->setChecked(true);
		cdparanoiaSlot();
	}
	abortOnSkpChk->setChecked(config->readBoolEntry("Abort On Skip", false));
	extractAllChk->setChecked(config->readBoolEntry("Extract All", true));
	extractAllSlot();
	splitOutChk->setChecked(config->readBoolEntry("Split Output", false));
	readOnlyChk->setChecked(config->readBoolEntry("Read Only", false));
	waitChk->setChecked(config->readBoolEntry("Wait For Signal", false));
	echoChk->setChecked(config->readBoolEntry("Echo", false));
	
	fromTrackSpn->setValue(config->readNumEntry("From Track", 1));
	toTrackSpn->setValue(config->readNumEntry("To Track", 1));
	cdromSpeedSpn->setValue(config->readNumEntry("CD-Rom Speed", 0));
	outputTypeSpn->setCurrentItem(config->readNumEntry("Output Type", 0));
	cdromIndSpn->setCurrentItem(config->readNumEntry("CD-Rom Indianess", 0));
	outputIndSpn->setCurrentItem(config->readNumEntry("Output Indianess", 0));
	
	switch(config->readNumEntry("CD Type", 0)){
		case 0: maxQRBtn->setChecked(true); break;
		case 1: stereoRBtn->setChecked(true); break;
		case 2: monoRBtn->setChecked(true); break;
		default: stereoCSRBtn->setChecked(true); break;
	}
	extensionsTxt->setText(config->readEntry("Supported Audio Extensions", ".mp3 .aiff .au .wav .ogg .raw .cdr .sun"));
	bool cdboDtct = config->readBoolEntry("CDBO Audio Files Detection", true);
	if(cdboDtct){
		cdboDetectRBtn->setChecked(true);
		cdboDetectSlot();
	}
	else{
		kdeDetectRBtn->setChecked(true);
		kdeDetectSlot();
	}
	 connect( toTrackSpn, SIGNAL( valueChanged(int) ), this, SLOT( toTrackAddSlot(int) ) );
}
//-----------------------------------------------------------------------------------------------
void AudioOptPnl::saveOptions(){
	config->setGroup("Audio Read Options");
	config->writeEntry("Use cdda2wav", cdda2wavRBtn->isChecked());
	config->writeEntry("Abort On Skip", abortOnSkpChk->isChecked());
	config->writeEntry("Extract All", extractAllChk->isChecked());
	config->writeEntry("Split Output", splitOutChk->isChecked());
	config->writeEntry("Read Only", readOnlyChk->isChecked());
	config->writeEntry("Wait For Signal", waitChk->isChecked());
	config->writeEntry("Echo", echoChk->isChecked());
	
	config->writeEntry("From Track", fromTrackSpn->value());
	config->writeEntry("To Track", toTrackSpn->value());
	config->writeEntry("CD-Rom Speed", cdromSpeedSpn->value());
	
	config->writeEntry("Output Type", outputTypeSpn->currentItem());
	config->writeEntry("CD-Rom Indianess", cdromIndSpn->currentItem());
	config->writeEntry("Output Indianess", outputIndSpn->currentItem());
	
	config->writeEntry("Supported Audio Extensions", extensionsTxt->text());
	
	config->writeEntry("CDBO Audio Files Detection", cdboDetectRBtn->isChecked());
	
	if(maxQRBtn->isChecked())
		config->writeEntry("CD Type", 0);
	else if(stereoRBtn->isChecked())
		config->writeEntry("CD Type", 1);
	else if(monoRBtn->isChecked())
		config->writeEntry("CD Type", 2);
	else
		config->writeEntry("CD Type", 3);
	
	config->sync();
}
//-----------------------------------------------------------------------------------------------
void AudioOptPnl::applyDefaults(){
	KSimpleConfig *config = (KSimpleConfig *)(kapp->config());
	config->deleteGroup("Audio Read Options");
	readOptions();
}
//-----------------------------------------------------------------------------------------------
void AudioOptPnl::cdda2wavSlot(){
	cdda2wavPnl->setEnabled(true);
	cdparanoiaPnl->setEnabled(false);
   	outputTypeSpn->insertItem( "au/sun - Sun PCM files", 4);
}
//-----------------------------------------------------------------------------------------------
void AudioOptPnl::extractAllSlot(){	
	bool yes = !extractAllChk->isChecked();
	fromTrackLbl->setEnabled(yes);
	toTrackLbl->setEnabled(yes);
	fromTrackSpn->setEnabled(yes);
	toTrackSpn->setEnabled(yes);
}
//-----------------------------------------------------------------------------------------------
void AudioOptPnl::cdparanoiaSlot(){
	cdda2wavPnl->setEnabled(false);
	cdparanoiaPnl->setEnabled(true);
	outputTypeSpn->removeItem(4);
}
void AudioOptPnl::fromTrackAddSlot(int value){
	if(toTrackSpn->value() < value)
		toTrackSpn->setValue(value);
}
void AudioOptPnl::toTrackAddSlot(int value){
	if(fromTrackSpn->value() > value)
		fromTrackSpn->setValue(value);
}

void AudioOptPnl::kdeDetectSlot(){
	extensionsTxt->setEnabled(false);
	extensionsLbl->setEnabled(false);
}
void AudioOptPnl::cdboDetectSlot(){
	extensionsTxt->setEnabled(true);
	extensionsLbl->setEnabled(true);
}