/***************************************************************************
                          SpeedPnl.cpp  -  description
                             -------------------
    begin                : Tue May 22 2001
    copyright            : (C) 2001 by Alex Podolsky
    email                : alexpod@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "SpeedPnl.h"

#include <qframe.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlcdnumber.h>
#include <qpushbutton.h>
#include <qslider.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>

#include <kconfig.h>
#include <kapp.h>

SpeedPnl::SpeedPnl( QWidget* parent,  const char* name, WFlags fl )
    : QWidget( parent, name, fl ){
    	
    	if ( !name )
		setName( "SpeedPnl" );
	
	config = kapp->config();
    	
    	
    	resize( 359, 81 );
    	SpeedPnlLayout = new QHBoxLayout( this );
    	SpeedPnlLayout->setSpacing( 0 );
    	SpeedPnlLayout->setMargin( 0 );

    	SpeedPnlFrm = new QGroupBox( this, "SpeedPnlFrm" );
    	SpeedPnlFrm->setLineWidth( 1 );
    	SpeedPnlFrm->setTitle( tr( "Speed" ) );
    	QWhatsThis::add(  SpeedPnlFrm, tr( "You can encreace or decreace 'Maximum Speed' through the preferences menu." ) );
    	SpeedPnlFrm->setColumnLayout(0, Qt::Vertical );
    	SpeedPnlFrm->layout()->setSpacing( 0 );
    	SpeedPnlFrm->layout()->setMargin( 0 );
    	SpeedPnlFrmLayout = new QHBoxLayout( SpeedPnlFrm->layout() );
    	SpeedPnlFrmLayout->setAlignment( Qt::AlignTop );
    	SpeedPnlFrmLayout->setSpacing( 6 );
    	SpeedPnlFrmLayout->setMargin( 11 );

    	speedLcd = new QLCDNumber( SpeedPnlFrm, "speedLcd" );
    	speedLcd->setMinimumSize( QSize( 40, 37 ) );
    	QFont speedLcd_font(  speedLcd->font() );
    	speedLcd_font.setBold( TRUE );
    	speedLcd->setFont( speedLcd_font );
     speedLcd->setFrameShape( QLCDNumber::PopupPanel );
     speedLcd->setFrameShadow( QLCDNumber::Plain );
     speedLcd->setNumDigits( 2 );
     speedLcd->setSegmentStyle( QLCDNumber::Filled );
     speedLcd->setProperty( "intValue", 4 );
     QToolTip::add(  speedLcd, tr( "Recording speed." ) );
     SpeedPnlFrmLayout->addWidget( speedLcd );

    	spaser = new QFrame( SpeedPnlFrm, "spaser" );
    	spaser->setMinimumSize( QSize( 1, 0 ) );
    	spaser->setMaximumSize( QSize( 20, 32767 ) );
    	spaser->setBackgroundOrigin( QFrame::ParentOrigin );
    	spaser->setFrameShape( QFrame::NoFrame );
    	SpeedPnlFrmLayout->addWidget( spaser );

    	minLbl = new QLabel( SpeedPnlFrm, "minLbl" );
    	minLbl->setMinimumSize( QSize( 0, 30 ) );
    	minLbl->setMaximumSize( QSize( 32767, 30 ) );
    	minLbl->setText( tr( "Min" ) );
    	minLbl->setAlignment( int( QLabel::AlignBottom | QLabel::AlignRight ) );
    	SpeedPnlFrmLayout->addWidget( minLbl );

    	speedSld = new QSlider( SpeedPnlFrm, "speedSld" );
    	speedSld->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)7, (QSizePolicy::SizeType)0, speedSld->sizePolicy().hasHeightForWidth() ) );
    	speedSld->setMinimumSize( QSize( 170, 23 ) );
    	speedSld->setLineStep( 1 );
    	speedSld->setPageStep( 1 );
    	speedSld->setOrientation( QSlider::Horizontal );
    	speedSld->setTickmarks( QSlider::Right );
    	speedSld->setTickInterval( 1 );
    	SpeedPnlFrmLayout->addWidget( speedSld );

    	maxLbl = new QLabel( SpeedPnlFrm, "maxLbl" );
    	maxLbl->setMinimumSize( QSize( 0, 30 ) );
    	maxLbl->setMaximumSize( QSize( 32767, 30 ) );
    	maxLbl->setText( tr( "Max" ) );
    	maxLbl->setAlignment( int( QLabel::AlignBottom | QLabel::AlignLeft ) );
    	SpeedPnlFrmLayout->addWidget( maxLbl );
    	SpeedPnlLayout->addWidget( SpeedPnlFrm );
	
    	//readOptions();
    // signals and slots connections
    	connect( speedSld, SIGNAL( valueChanged(int) ), this, SLOT( speedChangeSlot() ) );
}

SpeedPnl::~SpeedPnl(){
}
//---------------------------------------------------------------------------------------------------------
void SpeedPnl::saveOptions(){	
     config->setGroup("Target Devices");
     config->writeEntry("Target Speed", speedSld->value());
}
//---------------------------------------------------------------------------------------------
void SpeedPnl::readOptions(){
	
	/////////////////////////////////////////////////////////////////////
     config->setGroup("Default Settings");	
	int maxSpeed = config->readNumEntry("Max Write Speed", 14);
	if(maxSpeed <  8) maxSpeed = 8;
	speedSld->setMaxValue(maxSpeed);
	
	///////////////////////////////////////////////////////////
	config->setGroup("Target Devices");
	int speed = config->readNumEntry("Target Speed", 0);
	speedSld->setValue(speed);
	speedChangeSlot();
}
/*  
 *  Main event handler. Reimplemented to handle application
 *  font changes
 */
bool SpeedPnl::event( QEvent* ev ){
    bool ret = QWidget::event( ev ); 
    if ( ev->type() == QEvent::ApplicationFontChange ) {
	QFont speedLcd_font(  speedLcd->font() );
	speedLcd_font.setBold( TRUE );
	speedLcd->setFont( speedLcd_font ); 
    }
    return ret;
}
//-----------------------------------------------------------------------------------
void SpeedPnl::speedChangeSlot(){
    	int speed = speedSld->value();
	speedLcd->display(speed);
	QString speedComment = "Speed = " + QString::number(speed) +
								"x (" + QString::number(speed * 172) + "KB/sec).<b></b> Actual recording speed may depend on capabilities of your drive and media.";
	QToolTip::add(speedSld, tr(speedComment));
}

