/***************************************************************************
                          SettingsDialog.h  -  description
                             -------------------
    begin                : Tue May 22 2001
    copyright            : (C) 2001 by Alex Podolsky
    email                : alexpod@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef SETTINGSDIALOG_H
#define SETTINGSDIALOG_H

#include <qvariant.h>
#include <kdialogbase.h>

class DetectTbsPnl;
class RecordOptPnl;
class CdboOpt;
class AudioOptPnl;
class IsoOptPnl;
class InfoPnl;

class SettingsDialog : public KDialogBase
{
    Q_OBJECT

public:
    SettingsDialog(QWidget* parent = 0,
    					const char* name = 0,
    					bool modal = true,
    					int index = SettingsDialog::Specifications);
    ~SettingsDialog();
	
    static const int Specifications = 0;
    static const int Devices  = 1;
    static const int Recording = 2;
    static const int Image = 3;
    static const int Audio = 4;
    static const int Defaults = 5;
    static const int AudioMP3 = 6;

signals:
	void applied();
	
protected slots:
	void applyClickedSlot();
	void defaultClickedSlot();
	void okClickedSlot();
	void cancelClickedSlot();

protected:
	void initSlots();

private:
	DetectTbsPnl *detectPnl;
	RecordOptPnl *recordOptPnl;
	IsoOptPnl *isoOptPnl;
	AudioOptPnl *audioOptPnl;
	CdboOpt *cdboOpt;
	InfoPnl *info;
};
#endif