/***************************************************************************
                          SessionTypeDialog.cpp  -  description
                             -------------------
    begin                : Sat May 5 2001
    copyright            : (C) 2001 by Alexy Podolsky
    email                : alexpod@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "SessionTypeDialog.h"

#include <qbuttongroup.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>

//#include <iostream.h>

SessionTypeDialog::SessionTypeDialog(int * chosenType, QWidget* parent,  const char* name, bool modal, WFlags fl )
    : QDialog( parent, name, modal, fl )
{
    if ( !name )
	setName( "SessionTypeDialog" );
    resize( 232, 194 );
    this->chosenType = chosenType;
     init();
}
//==============================================
void SessionTypeDialog::init(){

    *chosenType = invalidSession;
    setCaption( tr( "Choose Session Type" ) );
    SessionTypeDialogLayout = new QGridLayout( this ); 
    SessionTypeDialogLayout->setSpacing( 6 );
    SessionTypeDialogLayout->setMargin( 11 );

    TextLabel1 = new QLabel( this, "TextLabel1" );
    TextLabel1->setText( tr( "Please choose type for this session" ) );

    SessionTypeDialogLayout->addMultiCellWidget( TextLabel1, 0, 0, 0, 1 );

    ButtonGroup1 = new QButtonGroup( this, "ButtonGroup1" );
    ButtonGroup1->setTitle( tr( "Available Types" ) );
    ButtonGroup1->setColumnLayout(0, Qt::Vertical );
    ButtonGroup1->layout()->setSpacing( 0 );
    ButtonGroup1->layout()->setMargin( 0 );
    ButtonGroup1Layout = new QVBoxLayout( ButtonGroup1->layout() );
    ButtonGroup1Layout->setAlignment( Qt::AlignTop );
    ButtonGroup1Layout->setSpacing( 6 );
    ButtonGroup1Layout->setMargin( 11 );

    firstRBtn = new QRadioButton( ButtonGroup1, "firstRBtn" );
    firstRBtn->setText( tr( "&First" ) );
    QToolTip::add(  firstRBtn, tr( "This should be the first session on <b></b>multi-session CD. CDBO will NOT try to fetch previous session info." ) );
    ButtonGroup1Layout->addWidget( firstRBtn );

    middleRBtn = new QRadioButton( ButtonGroup1, "middleRBtn" );
    middleRBtn->setText( tr( "&Intermidiate" ) );
    QToolTip::add(  middleRBtn, tr( "This session should stay in the middle of <b></b>multi-session CD. CDBO will try to fetch previous session info, and than append this session to it." ) );
    ButtonGroup1Layout->addWidget( middleRBtn );

    finalRBtn = new QRadioButton( ButtonGroup1, "finalRBtn" );
    finalRBtn->setText( tr( "Fina&l" ) );
    QToolTip::add(  finalRBtn, tr( "This session should the last session of <b></b>multi-session CD. CDBO will try to fetch previous session info, and than append this session to it. After this session, no subsequent sessions can be appended to this CD." ) );
    ButtonGroup1Layout->addWidget( finalRBtn );

    SessionTypeDialogLayout->addMultiCellWidget( ButtonGroup1, 1, 1, 0, 1 );

    okBtn = new QPushButton( this, "okBtn" );
    okBtn->setEnabled( FALSE );
    okBtn->setMinimumSize( QSize( 100, 0 ) );
    okBtn->setMaximumSize( QSize( 100, 32767 ) );
    okBtn->setText( tr( "&OK" ) );

    SessionTypeDialogLayout->addWidget( okBtn, 2, 0 );

    cancelBtn = new QPushButton( this, "cancelBtn" );
    cancelBtn->setMinimumSize( QSize( 100, 0 ) );
    cancelBtn->setMaximumSize( QSize( 100, 32767 ) );
    cancelBtn->setText( tr( "&Cancel" ) );
    QToolTip::add(  cancelBtn, tr( "Cancel this process." ) );

    SessionTypeDialogLayout->addWidget( cancelBtn, 2, 1 );

    // signals and slots connections
    connect( firstRBtn, SIGNAL( clicked() ), this, SLOT( firstSlot() ) );
    connect( middleRBtn, SIGNAL( clicked() ), this, SLOT( middleSlot() ) );
    connect( finalRBtn, SIGNAL( clicked() ), this, SLOT( finalSlot() ) );
    connect( okBtn, SIGNAL( clicked() ), this, SLOT( okSlot() ) );
    connect( cancelBtn, SIGNAL( clicked() ), this, SLOT( cancelSlot() ) );
}
//=========================================
SessionTypeDialog::~SessionTypeDialog(){
}
//========================================
void SessionTypeDialog::cancelSlot(){
    *chosenType = invalidSession;
    accept();
}
//========================================
void SessionTypeDialog::firstSlot(){
    *chosenType = firstSession;
    okBtn->setEnabled(true);
}
//========================================
void SessionTypeDialog::middleSlot(){
    *chosenType = middleSession;
    okBtn->setEnabled(true);
}
//========================================
void SessionTypeDialog::finalSlot(){
    *chosenType = finalSession;
    okBtn->setEnabled(true);
}
//========================================
void SessionTypeDialog::okSlot(){
    accept();
}

