/***************************************************************************
                          EraseDialogBase.cpp  -  description
                             -------------------
    begin                : Sat May 5 2001
    copyright            : (C) 2001 by Alexy Podolsky
    email                : alexpod@users.sourceforge.net
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "EraseDialogBase.h"

#include <qcheckbox.h>
#include <qcombobox.h>
#include <qframe.h>
#include <qgroupbox.h>
#include <qpushbutton.h>
#include "dialogParts/DialogCntPnl.h"
#include "dialogParts/DriveInfoPnl.h"
#include "dialogParts/SpeedPnl.h"
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>

#include <klocale.h>

EraseDialogBase::EraseDialogBase( QWidget* parent,  const char* name, bool modal, WFlags fl)
    : QDialog( parent, name, modal, fl )
{
    	if ( !name )
		setName( "EraseDialogBase" );
	eraseMode = true;
	init();
}
//===========================================================
EraseDialogBase::EraseDialogBase(bool eraseMode, QWidget* parent,  const char* name, bool modal, WFlags fl)
    : QDialog( parent, name, modal, fl )
{
    	if ( !name )
		setName( "EraseDialogBase" );
	this->eraseMode = eraseMode;
	init();
}
//===========================================================	
void EraseDialogBase::init(){
    resize( 720, 433 ); 
    setMinimumSize( QSize( 720, 433 ) );
    setMaximumSize( QSize( 720, 433 ) );
     if(eraseMode)
     	setCaption( i18n( "Erase Dialog" ) );
     else
     	setCaption( i18n( "Fixate CD Dialog" ) );
    EraseDialogBaseLayout = new QGridLayout( this ); 
    EraseDialogBaseLayout->setSpacing( 0 );
    EraseDialogBaseLayout->setMargin( 0 );

    dialogCntPnl = new DialogCntPnl( this, "dialogCntPnl" );

    EraseDialogBaseLayout->addMultiCellWidget( dialogCntPnl, 1, 1, 0, 1 );

    Frame5 = new QFrame( this, "Frame5" );
    Frame5->setMinimumSize( QSize( 300, 0 ) );
    Frame5->setMaximumSize( QSize( 300, 150 ) );
    Frame5->setFrameShape( QFrame::StyledPanel );
    Frame5->setFrameShadow( QFrame::Raised );
    Frame5->setLineWidth( 1 );
    Frame5->setMargin( 0 );
    Frame5->setMidLineWidth( 0 );

    targetDevicePnl = new DriveInfoPnl( Frame5, "targetDevicePnl" );
    targetDevicePnl->setGeometry( QRect( 11, 10, 280, 131 ) ); 

    EraseDialogBaseLayout->addWidget( Frame5, 0, 0 );

    detailsFrm = new QFrame( this, "detailsFrm" );
    detailsFrm->setMinimumSize( QSize( 0, 150 ) );
    detailsFrm->setMaximumSize( QSize( 32767, 150 ) );
    detailsFrm->setFrameShape( QFrame::StyledPanel );
    detailsFrm->setFrameShadow( QFrame::Raised );

    GroupBox6 = new QGroupBox( detailsFrm, "GroupBox6" );
    GroupBox6->setEnabled( TRUE );
    GroupBox6->setGeometry( QRect( 10, 80, 400, 62 ) ); 
    GroupBox6->setFrameShape( QGroupBox::Box );
    GroupBox6->setFrameShadow( QGroupBox::Sunken );
    if(eraseMode){
    	GroupBox6->setTitle( i18n( "Blank-Type" ) );
    	QWhatsThis::add(  GroupBox6, i18n( "Type of erase." ) );
    }
    else{
    	GroupBox6->setTitle( i18n( "Fixate-Type" ) );
    	QWhatsThis::add(  GroupBox6, i18n( "Type of fixate." ) );
    }
    GroupBox6->setColumnLayout(0, Qt::Vertical );
    GroupBox6->layout()->setSpacing( 0 );
    GroupBox6->layout()->setMargin( 0 );
    GroupBox6Layout = new QHBoxLayout( GroupBox6->layout() );
    GroupBox6Layout->setAlignment( Qt::AlignTop );
    GroupBox6Layout->setSpacing( 6 );
    GroupBox6Layout->setMargin( 11 );

    	blankTypeCmb = new QComboBox( FALSE, GroupBox6, "blankTypeCmb" );
	if(eraseMode){
    		blankTypeCmb->insertItem( i18n( "Minimal blank" ) );
    		blankTypeCmb->insertItem( i18n( "Blank the entire CD-RW" ) );
    		blankTypeCmb->insertItem( i18n( "Blank a track" ) );
   		blankTypeCmb->insertItem( i18n( "Unreserve a reserved track" ) );
   		blankTypeCmb->insertItem( i18n( "Blank the tail of a track" ) );
    		blankTypeCmb->insertItem( i18n( "Unclose last session" ) );
    		blankTypeCmb->insertItem( i18n( "Blank last session" ) );
    		blankTypeCmb->setMinimumSize( QSize( 200, 30 ) );
    		blankTypeCmb->setMaximumSize( QSize( 200, 30 ) );
    		QToolTip::add(  blankTypeCmb, i18n( "Please note:<b></b> Full blank takes about 74 min at single speed. Minimal blank is done in a few minutes." ) );
    		QWhatsThis::add(  blankTypeCmb, i18n( "Please note:<b></b> Full blank takes about 74 min at single speed. Minimal blank is done in a few minutes." ) );
	}
	else{
    		blankTypeCmb->insertItem( i18n( "Fixate" ) );
    		blankTypeCmb->insertItem( i18n( "'Dummy' fixate" ) );
    		blankTypeCmb->setMinimumSize( QSize( 200, 30 ) );
    		blankTypeCmb->setMaximumSize( QSize( 200, 30 ) );
    		QToolTip::add(  blankTypeCmb, i18n( "Please choose the action to take." ) );
    		//QWhatsThis::add(  blankTypeCmb, i18n( "Please note:<b></b> Full blank takes about 74 min at single speed. Minimal blank is done in a few minutes." ) );
	}


    GroupBox6Layout->addWidget( blankTypeCmb );
    QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    GroupBox6Layout->addItem( spacer );

    	if(eraseMode){
    		forceChk = new QCheckBox( GroupBox6, "forceChk" );
    		forceChk->setMinimumSize( QSize( 130, 30 ) );
    		forceChk->setMaximumSize( QSize( 140, 30 ) );
    		forceChk->setText( i18n( "&Force Blanking" ) );
    		forceChk->setAutoResize( FALSE );
    		forceChk->setChecked( FALSE );
    		QToolTip::add(  forceChk, i18n( "Force to continue on errors. This action currently implements some <b></b>tricks that will allow you to blank bad CD-RW disks." ) );
    		QWhatsThis::add(  forceChk, i18n( "This action currently implements some tricks that will allow you to blank bad CD-RW disks." ) );
    		GroupBox6Layout->addWidget( forceChk );
    		customBurnBtn = new QPushButton( 0, "customBurnBtn" );
	}
	else{
		customBurnBtn = new QPushButton( GroupBox6, "customBurnBtn" );
    		customBurnBtn->setMinimumSize( QSize( 90, 30 ) );
    		customBurnBtn->setMaximumSize( QSize( 90, 30 ) );
    		customBurnBtn->setText( i18n( "Custom" ) );
    		QToolTip::add(  customBurnBtn, i18n( "Configure recording options" ) );
    		GroupBox6Layout->addWidget( customBurnBtn );
		forceChk = new QCheckBox( 0, "forceChk" );
	}
    speedPnl = new SpeedPnl( detailsFrm, "speedPnl" );
    speedPnl->setGeometry( QRect( 10, 10, 401, 71 ) ); 

    EraseDialogBaseLayout->addWidget( detailsFrm, 0, 1 );

    // tab order
    setTabOrder( forceChk, blankTypeCmb );
}

/*  
 *  Destroys the object and frees any allocated resources
 */
EraseDialogBase::~EraseDialogBase()
{
    // no need to delete child widgets, Qt does it all for us
}

#include "EraseDialogBase.moc"
