/***************************************************************************
                          CdCopyDialog.cpp  -  description
                             -------------------
    begin                : Sat May 5 2001
    copyright            : (C) 2001 by Alexy Podolsky
    email                :  alexpod@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <iostream.h>

#include <qstring.h>
#include <qcombobox.h>
#include <qtooltip.h>
#include <qslider.h>
#include <qspinbox.h>
#include <qdir.h>
#include <qfile.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <qstringlist.h>
#include <qradiobutton.h>
#include <qlistview.h>
#include <qevent.h>
#include <qdatetime.h>
#include <qlcdnumber.h>

#include <kiconloader.h>
#include <kprocess.h>
#include <kmessagebox.h>
#include <kapp.h>
#include <kfiledialog.h>
#include <klocale.h>
#include <kconfig.h>
#include <kurl.h>
#include <kdirsize.h>

#include "SettingsDialog.h"
#include "CdCopyDialogBase.h"
#include "CdCopyDialog.h"
#include "EraseDialog.h"
#include "PreviewDialog.h"
#include "../cdbakeoven.h"

#define TEST_AND_COPY 1
#define COPY 0
#define DUMMY_COPY 2
#define ON_THE_FLY_COPY 3

//---------------------------------------------------------------------------------------------
CdCopyDialog::CdCopyDialog(QWidget *parent, const char *name ) :
	CdCopyDialogBase(parent,name,true),
	CdboDialogBase(CdboDialogBase::CdCopyDialogType){
	//////////////
	
	factory = new CdboDialogActionFactory(this, "CdCopyDialogFactory");	
	
	stillCopying = false;
	stillChecking = false;
	stillReading = false;
	
	
	config = kapp->config();
	
	///////////////////////////////////////////////////
	targetDevicePnl->setType(DriveInfoPnl::Target);
	targetDevicePnl->setUsrBtnTitle("&Erase");
	/////////////////////////////////////////////////
	srcDevicePnl->setType(DriveInfoPnl::Source);
	srcDevicePnl->setUsrBtnTitle("&Preview");
	////////////////////////////////////////////////
	dialogCntPnl->setStartBtnTitle("&Copy!");
	QToolTip::add(dialogCntPnl->getStartBtn(), tr( "Start copy!" ) );
	dialogCntPnl->resizeOutputViewColomns(80,568);
	/////////////////////////////////////////////////
	
	readOptions();
	initBtns();
	targetDevicePnl->closeTray();
	// connecting to the Drive Info Panel
	connect( targetDevicePnl->getDetectBtn(), SIGNAL( clicked() ), this, SLOT( detectDestSlot() ) );
	connect( targetDevicePnl->getUsrBtn(), SIGNAL( clicked() ), this, SLOT( eraseSlot() ) );
	
	// connecting to the Src Drive Info Panel
	connect( srcDevicePnl->getDetectBtn(), SIGNAL( clicked() ), this, SLOT( detectDestSlot() ) );
	connect( srcDevicePnl->getUsrBtn(), SIGNAL( clicked() ), this, SLOT( previewSlot() ) );
	
	// connecting to the Dialog Control Panel
	connect( dialogCntPnl->getStartBtn(), SIGNAL( clicked() ), this, SLOT( startBtnSlot() ) );
	connect( dialogCntPnl->getCancelBtn(), SIGNAL( clicked() ), this, SLOT( cancelSlot() ) );
	connect( dialogCntPnl->getSettingsBtn(), SIGNAL( clicked() ), this, SLOT( settingsSlot() ) );
	connect( dialogCntPnl->getQuitBtn(), SIGNAL( clicked() ), this, SLOT( quitSlot() ) );
	
	// connecting to the factory
	connect( factory, SIGNAL( processDone(bool) ), this, SLOT( taskDone(bool) ) );
	connect( factory, SIGNAL( failedToLunchProcess() ), this, SLOT( taskFailedToStart() ) );
	
	
	
	connect( factory, SIGNAL( tmpCheckProcessDone(bool) ), this, SLOT( tmpChecked(bool) ) );
	
}
//---------------------------------------------------------------------------------------------
CdCopyDialog::~CdCopyDialog(){
	delete factory;
}
//---------------------------------------------------------------------------------------------
void CdCopyDialog::readOptions(){
	
	////////////////////////////////////////////////	
     config->setGroup("Default Settings");		
	tempDir = config->readEntry("Tmp Dir", "");
	
	bool bBuff = config->readBoolEntry("Remove Tmp File", true);
	removeTempBtn->setChecked(bBuff);
	
	checkTmpSize = config->readBoolEntry("Check Tmp Size", true);
	minTmpSize = config->readNumEntry("Minimum Tmp Size", 650);
	
	
	///////////////////////////////////////////////////////////////////
	config->setGroup("Copy Options");
     int iBuff = config->readNumEntry("Type of Copy", 0);
     actionCmb->setCurrentItem(iBuff);
     iBuff = config->readNumEntry("Number of Copies", 0);
     	numberSpn->setValue( iBuff );
	bBuff = config->readBoolEntry("Data CD", true);
	if(bBuff)
		dataRBtn->setChecked(true);
	else
		musicRBtn->setChecked(true);
	
	speedPnl->readOptions();
	targetDevicePnl->readOptions();
     srcDevicePnl->readOptions();
}
//---------------------------------------------------------------------------------------------
void CdCopyDialog::saveOptions(){

	
	//////////////////////////////////////////////////////////
     config->setGroup("Copy Options");
     config->writeEntry("Type of Copy", actionCmb->currentItem());
     config->writeEntry("Number of Copies", numberSpn->value());
     config->writeEntry("Data CD", dataRBtn->isChecked());

     ////////////////////////////////////////////////////////////////////
     config->setGroup("Default Settings");

	config->writeEntry("Remove Tmp File", removeTempBtn->isChecked());
	
	speedPnl->saveOptions();
 	targetDevicePnl->saveOptions();
 	srcDevicePnl->saveOptions();
 	
 	config->sync();
}
//---------------------------------------------------------------------------------------------
void CdCopyDialog::initBtns(){
	if(targetDevicePnl->isReady()){
		
		srcDevicePnl->closeTray();
		blockBtns(false);
		dialogCntPnl->status("Ready");
	}
	else{
		blockBtns(true);
		dialogCntPnl->getCancelBtn()->setEnabled(false);
		if(srcDevicePnl->isReady()){
			srcDevicePnl->blockBtns(false);
			srcDevicePnl->closeTray();
		}
		dialogCntPnl->status("No recording device configured.");
	}
}
//---------------------------------------------------------------------------------------------
void CdCopyDialog::blockBtns(bool yes) const{
	dialogCntPnl->getStartBtn()->setEnabled(!yes);
	dialogCntPnl->getCancelBtn()->setEnabled(yes);
	detailsFrm->setEnabled(!yes);
	targetDevicePnl->blockBtns(yes);
	srcDevicePnl->blockBtns(yes);
	if(stillReading || stillChecking || stillCopying){
		targetDevicePnl->getDetectBtn()->setEnabled(false);
		srcDevicePnl->getDetectBtn()->setEnabled(false);
		dialogCntPnl->getSettingsBtn()->setEnabled(false);
		dialogCntPnl->getDumpBtn()->setEnabled(false);
	}
	else{
		targetDevicePnl->getDetectBtn()->setEnabled(true);
		srcDevicePnl->getDetectBtn()->setEnabled(true);
		dialogCntPnl->getSettingsBtn()->setEnabled(true);
		dialogCntPnl->getDumpBtn()->setEnabled(true);
	}
}
//----------------------------------------------------------------------------------------------
void CdCopyDialog::readOptionsBtnSlot(){
	if(dataRBtn->isChecked())
		popUpSettings(SettingsDialog::Recording);
	else
		popUpSettings(SettingsDialog::Audio);
}
//------------------------------------------------------------------------------------------
void CdCopyDialog::previewSlot(){
	if(dataRBtn->isChecked()){
       	PreviewDialog *pd = new PreviewDialog((QWidget *)parent(), "pd");
       	if(!pd->open(srcDevicePnl->getDriveName())){
       		KMessageBox::error(this,
                     "Failed to mount " + targetDevicePnl->getDriveName() + "\n"\
                     "Make sure you have enough privileges to perform this action.");
       		return;
       	}
		pd->exec();
	}
	else{
		kapp->kdeinitExec("kscd");//, QStringList(srcDevicePnl->getDriveName()));
	
	}
	
}
//---------------------------------------------------------------------------------------------
QString CdCopyDialog::getActionType() const{
	if(actionCmb->currentItem()  == DUMMY_COPY){	
		return "dummy";
	}
	else if(actionCmb->currentItem() == TEST_AND_COPY && copiesDone == 1)
		return "dummy";
	else
		return "burn";
}
//---------------------------------------------------------------------------------------------
void CdCopyDialog::startBtnSlot(){
	saveOptions();
	dialogCntPnl->clearOutput();
	dialogCntPnl->startForwardTimer();
	
	imageAddr = "";
	
	copiesDone = 1;
	
	if(getCopyType() == DUMMY_COPY)
		copiesDone = copiesWanted;
	else if(getCopyType() == TEST_AND_COPY)
		copiesWanted = numberSpn->value() + 1;
	else
		copiesWanted = numberSpn->value();

	if(getCopyType() == ON_THE_FLY_COPY){
		//if audio or same device - no good!
		if(srcDevicePnl->getDriveName() == targetDevicePnl->getDriveName()){
			KMessageBox::error(this,
				"You can not 'copy on the fly' using same device!\n"\
				"Please choose another action.");
			return;
		}
		if(!dataRBtn->isChecked()){
			KMessageBox::error(this,
				"You can not 'copy on the fly' audio CD!\n"\
				"Please choose another action.");
			return;
		}
		///start check or reading		
		config->setGroup("Recording Options");
		stillChecking = config->readBoolEntry("Check Drive First", false);
		if(stillChecking)
			factory->checkDrive();		
		else
			startCopyProcess();
	}
	else{
		stillChecking = true;
		//get size of image when ever possible
		KURL url(KIO::findDeviceMountPoint(srcDevicePnl->getDriveName()));
		int iBuff = (int)(KDirSize::dirSize(url) / 1024 / 1024);
		//if image is bigger then minimum size, make it minimum
		if(iBuff > minTmpSize)
			minTmpSize = iBuff;
		if(!factory->checkTmp(tempDir, minTmpSize)) {
			KMessageBox::error(this,
				"You must choose a valid temporary directory!");
		}
	}
}
//---------------------------------------------------------------------------------------------
void CdCopyDialog::tmpChecked(bool success){
	if(!stillChecking) return;

	if(checkTmpSize && !success){
		KMessageBox::error(this,
			"Chosen directory does not have enough space available\n" \
			"for storing disk image. Please choose another location!");
		stillChecking = false;
		return;
	}
	else{	
		config->setGroup("Recording Options");
		stillChecking = config->readBoolEntry("Check Drive First", false);
		if(stillChecking){
			factory->checkDrive();
		}
		else{
			startCopyProcess();
		}
	}
}
//---------------------------------------------------------------------------------------------
void CdCopyDialog::taskDone(bool success){
	if(!success){
		output(CdboDialogBase::StatusNotOkMessage, "Copy process failed!");
		dialogCntPnl->stopForwardTimer();
		config->setGroup("Recording Options");
		bool ejectAtEnd = config->readBoolEntry("Eject Media At End", true);
		
		if(stillReading){
			factory->removeTmpImage(imageAddr, tempDir);
			if(ejectAtEnd)
				srcDevicePnl->eject();
		}
		if(stillCopying){
			if(ejectAtEnd)
				targetDevicePnl->eject();
			if(getCopyType() != ON_THE_FLY_COPY && removeTempBtn->isChecked()){
				int result = KMessageBox::warningContinueCancel(this,
	   				"Do you still want to remove temporary image(s)?",
        				"Confirm your action",
        				QString("Yes"));
       			if(result == KMessageBox::Continue)
					factory->removeTmpImage(imageAddr, tempDir);
			}
		}
		stillCopying = false;
		stillReading = false;
		stillChecking = false;
		blockBtns(false);
		return;
	}
	/// if success /////////////////////////////////////////////////////
	if(stillChecking){
     		stillChecking = false;
     		//dialogCntPnl->startForwardTimer();
     		startCopyProcess();
     		return;
	}
	else if(stillReading){
		stillReading = false;
		config->setGroup("Recording Options");
    		if(config->readBoolEntry("Eject Media At End", true))
			srcDevicePnl->eject();
		if(readOnly){
			if(removeTempBtn->isChecked())
				factory->removeTmpImage(imageAddr,tempDir);
			dialogCntPnl->stopForwardTimer();
			blockBtns(false);
			status("Ready.");
			return;
		}
		if(srcDevicePnl->getDriveName() == targetDevicePnl->getDriveName()){
			KMessageBox::information(this,"Please insert CD-R(W) into " +
				srcDevicePnl->getDriveName() + " and click 'OK'.",
	   			"Please insert CD-R(W)");
		}
     	doCopy();
     	return;
 	}	
	else if(copiesDone < copiesWanted){
		copiesDone++;
		int fix = 0;
      	if(getCopyType() == TEST_AND_COPY){
 			if(copiesDone == 2){
 				output(CdboDialogBase::StatusOkMessage, "Dummy run completed successfully!");
 				/////////////////////////////////////
				int result = KMessageBox::questionYesNo(this,
						"Dummy run completed successfully! Continue with burn?",
        					"Continue with burn?",
        					QString("&Yes"),
        					QString("&No"));
				switch(result) {
    					case KMessageBox::No:{//
    						config->setGroup("Recording Options");
     					if(config->readBoolEntry("Eject Media At End", true))
     						targetDevicePnl->setEjected();
						if(removeTempBtn->isChecked()){
							int result = KMessageBox::warningContinueCancel(this,
	   							"Do you still want to remove temporary image(s)?",
        							"Confirm your action",
        							QString("Yes"));
       						if(result == KMessageBox::Continue)
								factory->removeTmpImage(imageAddr, tempDir);
						}
						dialogCntPnl->stopForwardTimer();
						stillCopying = false;
						stillReading = false;
						stillChecking = false;
						blockBtns(false);
						status("Ready.");
						return;
    					}///////////////////////=====================
					case KMessageBox::Yes:{
 						factory->burn(imageAddr, !dataRBtn->isChecked());
 						return;	
 					}
 				}
 			}
 			else
 				fix = 1;
 		}
      	output(CdboDialogBase::StatusOkMessage, "" + QString::number(copiesDone - fix) +
 			" of " + QString::number(copiesWanted - fix) +
 			" copied successfully!");
 		
 		KMessageBox::information(this,
 			"" + QString::number(copiesDone - fix) + " of " +
 			QString::number(copiesWanted - fix) + "  wanted copies are done!\n" \
 	   		"Please insert next CD-R(W) and click 'OK'.",
 	   		"Please insert next CD-R(W)");
      	qApp->processEvents();
      	//targetDevicePnl->closeTray();
      		targetDevicePnl->closeTrayAndWait();	
	   	factory->burn(imageAddr, !dataRBtn->isChecked());
	}
	else{
		/////////////////////////////////////////			
		config->setGroup("Recording Options");
     	if(config->readBoolEntry("Eject Media At End", true))
     		targetDevicePnl->setEjected();
		
		if(getCopyType() == DUMMY_COPY)
			output(CdboDialogBase::StatusOkMessage, "Dummy run completed successfully!");
		else
			output(CdboDialogBase::StatusOkMessage, "Copy process completed successfully!");
		
		if(removeTempBtn->isChecked())
			factory->removeTmpImage(imageAddr, tempDir);
		dialogCntPnl->stopForwardTimer();
		stillCopying = false;
		stillReading = false;
		stillChecking = false;
		blockBtns(false);
		
	}
}
//---------------------------------------------------------------------------------------------
void CdCopyDialog::taskFailedToStart(){
	output(CdboDialogBase::StatusNotOkMessage, "Copy process failed!");
	dialogCntPnl->stopForwardTimer();
	stillCopying = false;
	stillReading = false;
	stillChecking = false;
	blockBtns(false);
}

//------------------------------------------------------------------------------------
void CdCopyDialog::startCopyProcess(){
	//srcDevicePnl->closeTray();
	//if(srcDevicePnl->isEjected()) srcDevicePnl->closeTrayAndWait();	
	//cerr << "CLOSED\n";
	if(getCopyType() == ON_THE_FLY_COPY){
		//targetDevicePnl->closeTray();
		targetDevicePnl->closeTrayAndWait();	
		imageAddr = srcDevicePnl->getDriveName();
		stillCopying = true;
     		factory->burn(imageAddr);
		return;
	}
	//////////
	QDate today = QDate::currentDate();
	QTime now = QTime::currentTime();
	imageAddr = tempDir + "cdboImage_" + QString::number(today.month()) +
		 "_" + QString::number(today.day()) +
		 "_" + QString::number(now.hour()) +
		 "_" + QString::number(now.minute()) +
		 "_" + QString::number(now.second());
	
	stillReading = true;
	if(dataRBtn->isChecked()){
		factory->readData(srcDevicePnl->getDriveName(), &imageAddr);
		readOnly = false;
	}
	else{
		///////////////////////////////////////////////////////
		config->setGroup("Audio Read Options");
		readOnly = config->readBoolEntry("Read Only", false);
		stillReading = true;
		//output(CdboDialogBase::InfoMessage, "This CD was not fxated.");
		//=============================================================================
		
		factory->readAudio(srcDevicePnl->getDriveName(), &imageAddr);
	}
}		
//---------------------------------------------------------------------------------------------
void CdCopyDialog::doCopy(){
	//targetDevicePnl->closeTray();
	targetDevicePnl->closeTrayAndWait();	
	stillCopying = true;
     factory->burn(imageAddr, !dataRBtn->isChecked());
}
//---------------------------------------------------------------------------------------------
void CdCopyDialog::customBtnSlot(){
	//if(dataRBtn->isChecked())
		popUpSettings(SettingsDialog::Recording);
	//else
		//popUpSettings(SettingsDialog::Audio);
}
//---------------------------------------------------------------------------------------------
void CdCopyDialog::detectDestSlot(){
	popUpSettings(SettingsDialog::Devices);
}
//---------------------------------------------------------------------------------------------
void CdCopyDialog::settingsSlot(){
	popUpSettings(SettingsDialog::Defaults);
}
//---------------------------------------------------------------------------------------------
void CdCopyDialog::popUpSettings(int type){
	saveOptions();
	hide();
	((CDBakeOvenApp *)parent())->popUpSettings(type);
	readOptions();
	if(!stillCopying)
		initBtns();
	show();
}
//---------------------------------------------------------------------------------------------
void CdCopyDialog::eraseSlot(){
	saveOptions();
	EraseDialog *ed = new EraseDialog((QWidget *)parent(),"eraseD");
	hide();
	ed->exec();
	delete ed;
	readOptions();
	initBtns();
	show();
}
//---------------------------------------------------------------------------------------------
void CdCopyDialog::cancelSlot(){
	if(confermExit()){
		factory->killCurrentTask();
		if(stillCopying){
			output(CdboDialogBase::StatusNotOkMessage, "Copy process canceled!");
			if(getCopyType() != ON_THE_FLY_COPY && removeTempBtn->isChecked()){
				int result = KMessageBox::warningContinueCancel(this,
	   				"Do you still want to remove temporary image(s)?",
        				"Confirm your action",
        				QString("Yes"));
       			if(result == KMessageBox::Continue)
					factory->removeTmpImage(imageAddr, tempDir);
			}
		}
		else if(stillReading){
			output(CdboDialogBase::StatusNotOkMessage, "Read process canceled!");
			factory->removeTmpImage(imageAddr, tempDir);
		}
		dialogCntPnl->stopForwardTimer();
		status("Ready.");
		stillCopying = false;
		stillReading = false;
		stillChecking = false;
		blockBtns(false);	
	}
}
//---------------------------------------------------------------------------------------------
void CdCopyDialog::quitSlot(){
	if(stillCopying || stillReading){
		if(!confermExit()) return;
		else{
			factory->killCurrentTask();
			if(stillReading)
				factory->removeTmpImage(imageAddr, tempDir);
			
			if(stillCopying && getCopyType() != ON_THE_FLY_COPY && removeTempBtn->isChecked()){
				int result = KMessageBox::warningContinueCancel(this,
	   				"Do you still want to remove temporary image(s)?",
        				"Confirm your action",
        				QString("Yes"));
       			if(result == KMessageBox::Continue)
					factory->removeTmpImage(imageAddr, tempDir);
			}
			saveOptions();
			accept();
		}
	}
	else{	
		saveOptions();
		accept();
	}
}
//---------------------------------------------------------------------------------------------
void CdCopyDialog::closeEvent(QCloseEvent *e){
	if(stillCopying || stillReading){
		if(!confermExit()) e->ignore();
		else{
			factory->killCurrentTask();
			if(stillReading)
				factory->removeTmpImage(imageAddr,tempDir);
			
			if(stillCopying && getCopyType() != ON_THE_FLY_COPY && removeTempBtn->isChecked()){
				int result = KMessageBox::warningContinueCancel(this,
	   				"Do you still want to remove temporary image(s)?",
        				"Confirm your action",
        				QString("Yes"));
       			if(result == KMessageBox::Continue)
					factory->removeTmpImage(imageAddr,tempDir);
			}
			e->accept();
		}
	}
	else
		e->accept();
}
//---------------------------------------------------------------------------------------------
void CdCopyDialog::keyPressEvent(QKeyEvent *e){
	if(e->key() == Key_Escape){
        	if(stillCopying || stillReading){
        		if(!confermExit()) return;
        		else{
        			factory->killCurrentTask();
        			if(stillReading)
        				factory->removeTmpImage(imageAddr,tempDir);
        			
        			if(stillCopying && getCopyType() != ON_THE_FLY_COPY && removeTempBtn->isChecked()){
        				int result = KMessageBox::warningContinueCancel(this,
        	   				"Do you still want to remove temporary image(s)?",
                			"Confirm your action",
                			QString("Yes"));
               			if(result == KMessageBox::Continue)
        					factory->removeTmpImage(imageAddr,tempDir);
        			}
        		}
        	}
        	accept();
	}
	if(e->key() == Key_F2){
		settingsSlot();
	}
}
//---------------------------------------------------------------------------------------------
bool CdCopyDialog::confermExit(){
	if(stillChecking) return true;
	QString message;
	if(stillCopying)
		message = "Aborting now may damage your media,\nand/or even hang your system!";
	else
		message = "This will abort the read process.\nAborting now may hang your system!";
	int result = KMessageBox::warningContinueCancel(this,
	   message,
        "This may hang your system!",
        QString("Quit"));
    	switch(result) {
    		case KMessageBox::Continue:{
    			/*KMessageBox::error(this,
				"You've been WARNED!");*/
			return true;
		}
		case KMessageBox::Cancel:
        		return false;
    	}
    	return false;
}
