/***************************************************************************
                          NewAdvancedCdCompilationView.h  -  description
                             -------------------
    begin                : Sat Dec 1 2001
    copyright            : (C) 2001 by Alex Podolsky
    email                : alexpod@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef NEWADVANCEDCDCOMPILATIONVIEW_H
#define NEWADVANCEDCDCOMPILATIONVIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for Qt
#include <qwidget.h>

#include "widgets/fileViews/FakeFoldersListView.h"
#include "widgets/fileViews/AdvancedCompilationTreeView.h"
#include "CdboCompilationView.h"

// forward declaration of the NewCdCompilationView classes
class TargetTreeCntPanel;
class EstimatePnl;
class CDBakeOvenApp;
class ExpandPnl;

class NewAdvancedCdCompilationView : public CdboCompilationView{
  Q_OBJECT
public:
    /** Constructor for the main view */
    NewAdvancedCdCompilationView(CDBakeOvenApp * cdboApp, QWidget *parent = 0, const char *name=0);
    /** Destructor for the main view */
    ~NewAdvancedCdCompilationView();

	void saveOptions();
	inline CDBakeOvenApp* getCdboApp() {return cdboApp;}
	inline FakeFoldersListView* getView() { return compilView->getView();}
	inline AdvancedCompilationTreeView* getCompilView() { return compilView;}
	
public slots:
	void showTargetControl(bool);
	void showEstimate(bool);
	

private:
  	void initView();
  	
  	//members
  	CDBakeOvenApp *cdboApp;
  	
  	TargetTreeCntPanel *targetCnt;
  	EstimatePnl *estimate;	
  	ExpandPnl *estimateHldr;	
  	AdvancedCompilationTreeView *compilView;
  	
  	int eTimeId;
  	int lastPercent;
	
};

#endif // NEWADVANCEDCDCOMPILATIONVIEW_H